/*******************************************************************
*                                                                   
*  PHY_RX_AGC_page_1.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_AGC_page_1_regs_H_FILE
#define PHY_RX_AGC_page_1_regs_H_FILE

/* PHY_RXAGC_IF00_ANT1_RSSI_ADD */
/* Rx AGC ant1 rssi */
#define REG_PHY_RXAGC_IF00_ANT1_RSSI_ADD          0x14000
#define REG_PHY_RXAGC_IF00_ANT1_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF00_ANT1_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF00_ANT1_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF01_ANT1_SRSSI_ADD */
/* Rx AGC ant1 srssi */
#define REG_PHY_RXAGC_IF01_ANT1_SRSSI_ADD          0x14004
#define REG_PHY_RXAGC_IF01_ANT1_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF01_ANT1_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF01_ANT1_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF02_ANT1_BB_RSSI_ADD */
/* Rx AGC ant1 bb_rssi */
#define REG_PHY_RXAGC_IF02_ANT1_BB_RSSI_ADD          0x14008
#define REG_PHY_RXAGC_IF02_ANT1_BB_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF02_ANT1_BB_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF02_ANT1_BB_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF03_ANT1_BB_SRSSI_ADD */
/* Rx AGC ant1 bb_srssi */
#define REG_PHY_RXAGC_IF03_ANT1_BB_SRSSI_ADD          0x1400C
#define REG_PHY_RXAGC_IF03_ANT1_BB_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF03_ANT1_BB_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF03_ANT1_BB_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF04_ANT1_RSSI_IIR_POLE_SHIFT_ADD */
/* Rx AGC ant1 bb_srssi */
#define REG_PHY_RXAGC_IF04_ANT1_RSSI_IIR_POLE_SHIFT_ADD          0x14010
#define REG_PHY_RXAGC_IF04_ANT1_RSSI_IIR_POLE_SHIFT_ADD_MASK     0x00000007
#define REG_PHY_RXAGC_IF04_ANT1_RSSI_IIR_POLE_SHIFT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF04_ANT1_RSSI_IIR_POLE_SHIFT_ADD_WIDTH    3

/* PHY_RXAGC_IF05_ANT1_BB_RSSI_IIR_POLE_SHIFT_ADD */
/* Rx AGC ant1 rssi iir pole shift */
#define REG_PHY_RXAGC_IF05_ANT1_BB_RSSI_IIR_POLE_SHIFT_ADD          0x14014
#define REG_PHY_RXAGC_IF05_ANT1_BB_RSSI_IIR_POLE_SHIFT_ADD_MASK     0x00000007
#define REG_PHY_RXAGC_IF05_ANT1_BB_RSSI_IIR_POLE_SHIFT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF05_ANT1_BB_RSSI_IIR_POLE_SHIFT_ADD_WIDTH    3

/* PHY_RXAGC_IF06_ANT1_RF_POWER_ADD */
/* Rx AGC ant1 bb_rssi iir pole shift */
#define REG_PHY_RXAGC_IF06_ANT1_RF_POWER_ADD          0x14018
#define REG_PHY_RXAGC_IF06_ANT1_RF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF06_ANT1_RF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF06_ANT1_RF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF07_ANT1_SRF_POWER_ADD */
/* Rx AGC ant1 srf_power */
#define REG_PHY_RXAGC_IF07_ANT1_SRF_POWER_ADD          0x1401C
#define REG_PHY_RXAGC_IF07_ANT1_SRF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF07_ANT1_SRF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF07_ANT1_SRF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF08_ANT1_BB_POWER_ADD */
/* Rx AGC ant1 bb_power */
#define REG_PHY_RXAGC_IF08_ANT1_BB_POWER_ADD          0x14020
#define REG_PHY_RXAGC_IF08_ANT1_BB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF08_ANT1_BB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF08_ANT1_BB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF09_ANT1_SBB_POWER_ADD */
/* Rx AGC ant1 sbb_power */
#define REG_PHY_RXAGC_IF09_ANT1_SBB_POWER_ADD          0x14024
#define REG_PHY_RXAGC_IF09_ANT1_SBB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF09_ANT1_SBB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF09_ANT1_SBB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF0A_ANT1_RSSSI_TABLE1_ADD */
/* Rx AGC ant1 rssi db table1 */
#define REG_PHY_RXAGC_IF0A_ANT1_RSSSI_TABLE1_ADD          0x14028
#define REG_PHY_RXAGC_IF0A_ANT1_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF0A_ANT1_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF0A_ANT1_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF0B_ANT1_RSSSI_TABLE2_ADD */
/* Rx AGC ant1 rssi db table2 */
#define REG_PHY_RXAGC_IF0B_ANT1_RSSSI_TABLE2_ADD          0x1402C
#define REG_PHY_RXAGC_IF0B_ANT1_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF0B_ANT1_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF0B_ANT1_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF0C_ANT1_RSSSI_TABLE3_ADD */
/* Rx AGC ant1 rssi db table3 */
#define REG_PHY_RXAGC_IF0C_ANT1_RSSSI_TABLE3_ADD          0x14030
#define REG_PHY_RXAGC_IF0C_ANT1_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF0C_ANT1_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF0C_ANT1_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF0E_ANT1_D1_ADD */
/* Rx AGC ant1 rssi d1 value (rssi(2)-rssi(1)) */
#define REG_PHY_RXAGC_IF0E_ANT1_D1_ADD          0x14038
#define REG_PHY_RXAGC_IF0E_ANT1_D1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF0E_ANT1_D1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF0E_ANT1_D1_ADD_WIDTH    32

/* PHY_RXAGC_IF0F_ANT1_D2_ADD */
/* Rx AGC ant1 rssi d2 value (rssi(3)-rssi(2)) */
#define REG_PHY_RXAGC_IF0F_ANT1_D2_ADD          0x1403C
#define REG_PHY_RXAGC_IF0F_ANT1_D2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF0F_ANT1_D2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF0F_ANT1_D2_ADD_WIDTH    32

/* PHY_RXAGC_IF10_ANT1_BB_RSSSI_TABLE1_ADD */
/* Rx AGC ant1 bb_rssi table1 */
#define REG_PHY_RXAGC_IF10_ANT1_BB_RSSSI_TABLE1_ADD          0x14040
#define REG_PHY_RXAGC_IF10_ANT1_BB_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF10_ANT1_BB_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF10_ANT1_BB_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF11_ANT1_BB_RSSSI_TABLE2_ADD */
/* Rx AGC ant1 bb_rssi table2 */
#define REG_PHY_RXAGC_IF11_ANT1_BB_RSSSI_TABLE2_ADD          0x14044
#define REG_PHY_RXAGC_IF11_ANT1_BB_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF11_ANT1_BB_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF11_ANT1_BB_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF12_ANT1_BB_RSSSI_TABLE3_ADD */
/* Rx AGC ant1 bb_rssi table3 */
#define REG_PHY_RXAGC_IF12_ANT1_BB_RSSSI_TABLE3_ADD          0x14048
#define REG_PHY_RXAGC_IF12_ANT1_BB_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF12_ANT1_BB_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF12_ANT1_BB_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF13_ANT1_SYSTEM_GAIN_ACC_ADD */
/* Rx AGC ant1 system gain dc acc */
#define REG_PHY_RXAGC_IF13_ANT1_SYSTEM_GAIN_ACC_ADD          0x1404C
#define REG_PHY_RXAGC_IF13_ANT1_SYSTEM_GAIN_ACC_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF13_ANT1_SYSTEM_GAIN_ACC_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF13_ANT1_SYSTEM_GAIN_ACC_ADD_WIDTH    8

/* PHY_RXAGC_IF14_ANT1_B1_ADD */
/* Rx AGC ant1 bb_rssi b1 value (bb_rssi(2)-bb_rssi(1)) */
#define REG_PHY_RXAGC_IF14_ANT1_B1_ADD          0x14050
#define REG_PHY_RXAGC_IF14_ANT1_B1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF14_ANT1_B1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF14_ANT1_B1_ADD_WIDTH    32

/* PHY_RXAGC_IF15_ANT1_B2_ADD */
/* Rx AGC ant1 bb_rssi b2 value (bb_rssi(3)-bb_rssi(2)) */
#define REG_PHY_RXAGC_IF15_ANT1_B2_ADD          0x14054
#define REG_PHY_RXAGC_IF15_ANT1_B2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF15_ANT1_B2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF15_ANT1_B2_ADD_WIDTH    32

/* PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD */
/* Rx AGC ant1 rssi threshold */
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD          0x14058
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_WIDTH    7

/* PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SIGN */
/* Rx AGC ant1 rssi threshold signed for read */
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SIGN          0x14058
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF16_ANT1_RSSI_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD */
/* Rx AGC ant1 rf up threshold */
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD          0x1405C
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SIGN */
/* Rx AGC ant1 rf up threshold  signed for read */
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SIGN          0x1405C
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF17_ANT1_RF_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD */
/* Rx AGC ant1 rf low threshold */
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD          0x14060
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SIGN */
/* Rx AGC ant1 rf low threshold  signed for read */
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SIGN          0x14060
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF18_ANT1_RF_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF1A_ANT1_RF_TIMER_THR_ADD */
/* Rx AGC ant1 rf timer threshold  */
#define REG_PHY_RXAGC_IF1A_ANT1_RF_TIMER_THR_ADD          0x14068
#define REG_PHY_RXAGC_IF1A_ANT1_RF_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF1A_ANT1_RF_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF1A_ANT1_RF_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF1C_ANT1_BB_TIMER_THR_ADD */
/* Rx AGC ant1 bb timer threshold  */
#define REG_PHY_RXAGC_IF1C_ANT1_BB_TIMER_THR_ADD          0x14070
#define REG_PHY_RXAGC_IF1C_ANT1_BB_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF1C_ANT1_BB_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF1C_ANT1_BB_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD */
/* Rx AGC ant1 delta rf threshold  */
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD          0x14074
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SIGN */
/* Rx AGC ant1 delta rf threshold sign */
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SIGN          0x14074
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF1D_ANT1_DELTA_RF_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD */
/* Rx AGC ant1 delta bb threshold  */
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD          0x14078
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_WIDTH    10

/* PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SIGN */
/* Rx AGC ant1 delta bb threshold sign */
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SIGN          0x14078
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF1E_ANT1_DELTA_BB_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF22_ANT1_RF_RELEASE_THR_ADD */
/* Rx AGC ant1 rf release threshold */
#define REG_PHY_RXAGC_IF22_ANT1_RF_RELEASE_THR_ADD          0x14088
#define REG_PHY_RXAGC_IF22_ANT1_RF_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF22_ANT1_RF_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF22_ANT1_RF_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF24_ANT1_BB_RELEASE_THR_ADD */
/* Rx AGC ant1 bb release threshold  */
#define REG_PHY_RXAGC_IF24_ANT1_BB_RELEASE_THR_ADD          0x14090
#define REG_PHY_RXAGC_IF24_ANT1_BB_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF24_ANT1_BB_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF24_ANT1_BB_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF26_ANT1_LONGTHERM_RELEASE_THR_ADD */
/* Rx AGC ant1 longterm release threshold  */
#define REG_PHY_RXAGC_IF26_ANT1_LONGTHERM_RELEASE_THR_ADD          0x14098
#define REG_PHY_RXAGC_IF26_ANT1_LONGTHERM_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF26_ANT1_LONGTHERM_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF26_ANT1_LONGTHERM_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD */
/* Rx AGC ant1 longterm threshold  */
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD          0x1409C
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SIGN */
/* Rx AGC ant1 longterm threshold sign */
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SIGN          0x1409C
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF27_ANT1_LONGTHERM_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD */
/* Rx AGC ant1 bb power up threshold */
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD          0x140A0
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SIGN */
/* Rx AGC ant1 bb power up threshold sign */
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SIGN          0x140A0
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF28_ANT1_BB_POWER_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF29_ANT1_ACC_ALGO_CNTR_ADD */
/* Rx AGC ant1 accelerator algorithm control */
#define REG_PHY_RXAGC_IF29_ANT1_ACC_ALGO_CNTR_ADD          0x140A4
#define REG_PHY_RXAGC_IF29_ANT1_ACC_ALGO_CNTR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF29_ANT1_ACC_ALGO_CNTR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF29_ANT1_ACC_ALGO_CNTR_ADD_WIDTH    16

/* PHY_RXAGC_IF2A_ANT1_ACC_OUT_ADD */
/* Rx AGC ant1 accelerator output */
#define REG_PHY_RXAGC_IF2A_ANT1_ACC_OUT_ADD          0x140A8
#define REG_PHY_RXAGC_IF2A_ANT1_ACC_OUT_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF2A_ANT1_ACC_OUT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2A_ANT1_ACC_OUT_ADD_WIDTH    9

/* PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD */
/* Rx AGC ant1 rssi offset1 */
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD          0x140AC
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_WIDTH    8

/* PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SIGN */
/* Rx AGC ant1 rssi offset1 */
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SIGN          0x140AC
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF2B_ANT1_RSSI_OFFSET1_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD */
/* Rx AGC ant1 rssi offset2 */
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD          0x140B0
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_WIDTH    7

/* PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant1 rssi offset2 */
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SIGN          0x140B0
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF2C_ANT1_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD */
/* Rx AGC ant1 rssi iir pole */
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD          0x140B4
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_MASK     0x0000000f
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_WIDTH    4

/* PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SIGN */
/* Rx AGC ant1 rssi iir pole */
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SIGN          0x140B4
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF2D_ANT1_RSSI_IIR_POLE_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD */
/* Rx AGC ant1 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD          0x140B8
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_WIDTH    10

/* PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SIGN */
/* Rx AGC ant1 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SIGN          0x140B8
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF2E_ANT1_BB_RSSI_DC_OFFSET_I_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD */
/* Rx AGC ant1 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD          0x140BC
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_WIDTH    10

/* PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SIGN */
/* Rx AGC ant1 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SIGN          0x140BC
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF2F_ANT1_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF30_ANT1_BB_RSSI_IIR_COUNTER_ADD */
/* Rx AGC ant1 bb rssi iir counter */
#define REG_PHY_RXAGC_IF30_ANT1_BB_RSSI_IIR_COUNTER_ADD          0x140C0
#define REG_PHY_RXAGC_IF30_ANT1_BB_RSSI_IIR_COUNTER_ADD_MASK     0x00000fff
#define REG_PHY_RXAGC_IF30_ANT1_BB_RSSI_IIR_COUNTER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF30_ANT1_BB_RSSI_IIR_COUNTER_ADD_WIDTH    12

/* PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD */
/* Rx AGC ant1 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD          0x140C4
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SIGN */
/* Rx AGC ant1 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SIGN          0x140C4
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF31_ANT1_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD */
/* Rx AGC ant1 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD          0x140C8
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SIGN */
/* Rx AGC ant1 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SIGN          0x140C8
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF32_ANT1_BB_RSSI_FAST_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF33_ANT1_RSSI_IIR_COUNTER_ADD */
/* Rx AGC ant1 rssi iir counter */
#define REG_PHY_RXAGC_IF33_ANT1_RSSI_IIR_COUNTER_ADD          0x140CC
#define REG_PHY_RXAGC_IF33_ANT1_RSSI_IIR_COUNTER_ADD_MASK     0x00000fff
#define REG_PHY_RXAGC_IF33_ANT1_RSSI_IIR_COUNTER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF33_ANT1_RSSI_IIR_COUNTER_ADD_WIDTH    12

/* PHY_RXAGC_IF34_ANT1_BB_SATURATION_COUNTER_ADD */
/* Rx AGC ant1 bb saturation counter */
#define REG_PHY_RXAGC_IF34_ANT1_BB_SATURATION_COUNTER_ADD          0x140D0
#define REG_PHY_RXAGC_IF34_ANT1_BB_SATURATION_COUNTER_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF34_ANT1_BB_SATURATION_COUNTER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF34_ANT1_BB_SATURATION_COUNTER_ADD_WIDTH    7

/* PHY_RXAGC_IF35_ANT1_BB_RSSI_OFFSET1_ADD */
/* Rx AGC ant1 bb rssi offset 1 */
#define REG_PHY_RXAGC_IF35_ANT1_BB_RSSI_OFFSET1_ADD          0x140D4
#define REG_PHY_RXAGC_IF35_ANT1_BB_RSSI_OFFSET1_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF35_ANT1_BB_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF35_ANT1_BB_RSSI_OFFSET1_ADD_WIDTH    16

/* PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD */
/* Rx AGC ant1 bb rssi offset 2 */
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD          0x140D8
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_WIDTH    8

/* PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant1 bb rssi offset 2 */
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SIGN          0x140D8
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF36_ANT1_BB_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD */
/* Rx AGC ant1 bb rssi iir pole */
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD          0x140DC
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_MASK     0x0000000f
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_WIDTH    4

/* PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SIGN */
/* Rx AGC ant1 bb rssi iir pole */
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SIGN          0x140DC
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF37_ANT1_BB_RSSI_IIR_POLE_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF38_ANT1_LNA_ADD */
/* Rx AGC ant1 lna */
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD          0x140E0
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_WIDTH    7

/* PHY_RXAGC_IF38_ANT1_LNA_ADD_SIGN */
/* Rx AGC ant1 lna */
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_SIGN          0x140E0
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF38_ANT1_LNA_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD */
/* Rx AGC ant1 system gain */
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD          0x140E4
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_WIDTH    9

/* PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SIGN */
/* Rx AGC ant1 system gain */
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SIGN          0x140E4
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF39_ANT1_SYSTEM_GAIN_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF3A_ANT1_BB_RSSI_IIR_COUNTER_RDBACK_ADD */
/* Rx AGC ant1 bb rssi iir counter readback */
#define REG_PHY_RXAGC_IF3A_ANT1_BB_RSSI_IIR_COUNTER_RDBACK_ADD          0x140E8
#define REG_PHY_RXAGC_IF3A_ANT1_BB_RSSI_IIR_COUNTER_RDBACK_ADD_MASK     0x00000fff
#define REG_PHY_RXAGC_IF3A_ANT1_BB_RSSI_IIR_COUNTER_RDBACK_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF3A_ANT1_BB_RSSI_IIR_COUNTER_RDBACK_ADD_WIDTH    12

/* PHY_RXAGC_IF3B_ANT1_ACC_MASK_OP_ADD */
/* Rx AGC ant1 accelerator mask cmd */
#define REG_PHY_RXAGC_IF3B_ANT1_ACC_MASK_OP_ADD          0x140EC
#define REG_PHY_RXAGC_IF3B_ANT1_ACC_MASK_OP_ADD_MASK     0x00000001
#define REG_PHY_RXAGC_IF3B_ANT1_ACC_MASK_OP_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF3B_ANT1_ACC_MASK_OP_ADD_WIDTH    1

/* PHY_RXAGC_IF3B_ANT2_ACC_MASK_OP_ADD */
/* Rx AGC an2 accelerator mask cmd */
#define REG_PHY_RXAGC_IF3B_ANT2_ACC_MASK_OP_ADD          0x140EC
#define REG_PHY_RXAGC_IF3B_ANT2_ACC_MASK_OP_ADD_MASK     0x00000002
#define REG_PHY_RXAGC_IF3B_ANT2_ACC_MASK_OP_ADD_SHIFT    1
#define REG_PHY_RXAGC_IF3B_ANT2_ACC_MASK_OP_ADD_WIDTH    1

/* PHY_RXAGC_IF3B_ANT3_ACC_MASK_OP_ADD */
/* Rx AGC ant3 accelerator mask cmd */
#define REG_PHY_RXAGC_IF3B_ANT3_ACC_MASK_OP_ADD          0x140EC
#define REG_PHY_RXAGC_IF3B_ANT3_ACC_MASK_OP_ADD_MASK     0x00000004
#define REG_PHY_RXAGC_IF3B_ANT3_ACC_MASK_OP_ADD_SHIFT    2
#define REG_PHY_RXAGC_IF3B_ANT3_ACC_MASK_OP_ADD_WIDTH    1

/* PHY_RXAGC_IF3B_ACC_AUTO_CLOSE_MODE_ADD */
/* Rx AGC accelerator auto close mode */
#define REG_PHY_RXAGC_IF3B_ACC_AUTO_CLOSE_MODE_ADD          0x140EC
#define REG_PHY_RXAGC_IF3B_ACC_AUTO_CLOSE_MODE_ADD_MASK     0x00000010
#define REG_PHY_RXAGC_IF3B_ACC_AUTO_CLOSE_MODE_ADD_SHIFT    4
#define REG_PHY_RXAGC_IF3B_ACC_AUTO_CLOSE_MODE_ADD_WIDTH    1

/* PHY_RXAGC_IF3B_ALGOUT_DIFF_ONE_ADD */
/* Rx AGC accelerator output differ one status */
#define REG_PHY_RXAGC_IF3B_ALGOUT_DIFF_ONE_ADD          0x140EC
#define REG_PHY_RXAGC_IF3B_ALGOUT_DIFF_ONE_ADD_MASK     0x00000100
#define REG_PHY_RXAGC_IF3B_ALGOUT_DIFF_ONE_ADD_SHIFT    8
#define REG_PHY_RXAGC_IF3B_ALGOUT_DIFF_ONE_ADD_WIDTH    1

/* PHY_RXAGC_IF3C_ANT1_RSSI_IIR_COUNTER_RDBACK_ADD */
/* Rx AGC ant1 rssi iir counter readback */
#define REG_PHY_RXAGC_IF3C_ANT1_RSSI_IIR_COUNTER_RDBACK_ADD          0x140F0
#define REG_PHY_RXAGC_IF3C_ANT1_RSSI_IIR_COUNTER_RDBACK_ADD_MASK     0x00000fff
#define REG_PHY_RXAGC_IF3C_ANT1_RSSI_IIR_COUNTER_RDBACK_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF3C_ANT1_RSSI_IIR_COUNTER_RDBACK_ADD_WIDTH    12

/* PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_GO */
/* Rx AGC ant1 bb rssi iir go command */
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_GO          0x140F8
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_GO_MASK     0x00000001
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_GO_SHIFT    0
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_GO_WIDTH    1

/* PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_RESET */
/* Rx AGC ant1 bb rssi iir reset */
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_RESET          0x140F8
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_RESET_MASK     0x00000002
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_RESET_SHIFT    1
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_CNT_RESET_WIDTH    1

/* PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_COUNTER_DONE */
/* Rx AGC ant1 bb rssi iir counter done */
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_COUNTER_DONE          0x140F8
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_COUNTER_DONE_MASK     0x00000004
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_COUNTER_DONE_SHIFT    2
#define REG_PHY_RXAGC_IF3E_ANT1_BB_RSSI_IIR_COUNTER_DONE_WIDTH    1

/* PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_GO */
/* Rx AGC ant1 rssi iir go command */
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_GO          0x140FC
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_GO_MASK     0x00000001
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_GO_SHIFT    0
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_GO_WIDTH    1

/* PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_RESET */
/* Rx AGC ant1 rssi iir reset */
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_RESET          0x140FC
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_RESET_MASK     0x00000002
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_RESET_SHIFT    1
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_CNT_RESET_WIDTH    1

/* PHY_RXAGC_IF3F_ANT1_RSSI_IIR_COUNTER_DONE */
/* Rx AGC ant1 rssi iir counter done */
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_COUNTER_DONE          0x140FC
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_COUNTER_DONE_MASK     0x00000004
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_COUNTER_DONE_SHIFT    2
#define REG_PHY_RXAGC_IF3F_ANT1_RSSI_IIR_COUNTER_DONE_WIDTH    1

/* PHY_RXAGC_IF40_ANT2_RSSI_ADD */
/* Rx AGC ant2 rssi */
#define REG_PHY_RXAGC_IF40_ANT2_RSSI_ADD          0x14100
#define REG_PHY_RXAGC_IF40_ANT2_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF40_ANT2_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF40_ANT2_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF41_ANT2_SRSSI_ADD */
/* Rx AGC ant2 srssi */
#define REG_PHY_RXAGC_IF41_ANT2_SRSSI_ADD          0x14104
#define REG_PHY_RXAGC_IF41_ANT2_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF41_ANT2_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF41_ANT2_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF42_ANT2_BB_RSSI_ADD */
/* Rx AGC ant2 bb_rssi */
#define REG_PHY_RXAGC_IF42_ANT2_BB_RSSI_ADD          0x14108
#define REG_PHY_RXAGC_IF42_ANT2_BB_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF42_ANT2_BB_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF42_ANT2_BB_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF43_ANT2_BB_SRSSI_ADD */
/* Rx AGC ant2 bb_srssi */
#define REG_PHY_RXAGC_IF43_ANT2_BB_SRSSI_ADD          0x1410C
#define REG_PHY_RXAGC_IF43_ANT2_BB_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF43_ANT2_BB_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF43_ANT2_BB_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF46_ANT2_RF_POWER_ADD */
/* Rx AGC ant2 rf_power */
#define REG_PHY_RXAGC_IF46_ANT2_RF_POWER_ADD          0x14118
#define REG_PHY_RXAGC_IF46_ANT2_RF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF46_ANT2_RF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF46_ANT2_RF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF47_ANT2_SRF_POWER_ADD */
/* Rx AGC ant2 srf_power */
#define REG_PHY_RXAGC_IF47_ANT2_SRF_POWER_ADD          0x1411C
#define REG_PHY_RXAGC_IF47_ANT2_SRF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF47_ANT2_SRF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF47_ANT2_SRF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF48_ANT2_BB_POWER_ADD */
/* Rx AGC ant2 bb_power */
#define REG_PHY_RXAGC_IF48_ANT2_BB_POWER_ADD          0x14120
#define REG_PHY_RXAGC_IF48_ANT2_BB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF48_ANT2_BB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF48_ANT2_BB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF49_ANT2_SBB_POWER_ADD */
/* Rx AGC ant2 sbb_power */
#define REG_PHY_RXAGC_IF49_ANT2_SBB_POWER_ADD          0x14124
#define REG_PHY_RXAGC_IF49_ANT2_SBB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF49_ANT2_SBB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF49_ANT2_SBB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF4A_ANT2_RSSSI_TABLE1_ADD */
/* Rx AGC ant2 rssi db table1 */
#define REG_PHY_RXAGC_IF4A_ANT2_RSSSI_TABLE1_ADD          0x14128
#define REG_PHY_RXAGC_IF4A_ANT2_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF4A_ANT2_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF4A_ANT2_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF4B_ANT2_RSSSI_TABLE2_ADD */
/* Rx AGC ant2 rssi db table2 */
#define REG_PHY_RXAGC_IF4B_ANT2_RSSSI_TABLE2_ADD          0x1412C
#define REG_PHY_RXAGC_IF4B_ANT2_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF4B_ANT2_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF4B_ANT2_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF4C_ANT2_RSSSI_TABLE3_ADD */
/* Rx AGC ant2 rssi db table3 */
#define REG_PHY_RXAGC_IF4C_ANT2_RSSSI_TABLE3_ADD          0x14130
#define REG_PHY_RXAGC_IF4C_ANT2_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF4C_ANT2_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF4C_ANT2_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF4E_ANT2_D1_ADD */
/* Rx AGC ant2 rssi d1 value (rssi(2)-rssi(1)) */
#define REG_PHY_RXAGC_IF4E_ANT2_D1_ADD          0x14138
#define REG_PHY_RXAGC_IF4E_ANT2_D1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF4E_ANT2_D1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF4E_ANT2_D1_ADD_WIDTH    32

/* PHY_RXAGC_IF4F_ANT2_D2_ADD */
/* Rx AGC ant2 rssi d2 value (rssi(3)-rssi(2)) */
#define REG_PHY_RXAGC_IF4F_ANT2_D2_ADD          0x1413C
#define REG_PHY_RXAGC_IF4F_ANT2_D2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF4F_ANT2_D2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF4F_ANT2_D2_ADD_WIDTH    32

/* PHY_RXAGC_IF50_ANT2_BB_RSSSI_TABLE1_ADD */
/* Rx AGC ant2 bb_rssi table1 */
#define REG_PHY_RXAGC_IF50_ANT2_BB_RSSSI_TABLE1_ADD          0x14140
#define REG_PHY_RXAGC_IF50_ANT2_BB_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF50_ANT2_BB_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF50_ANT2_BB_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF51_ANT2_BB_RSSSI_TABLE2_ADD */
/* Rx AGC ant2 bb_rssi table2 */
#define REG_PHY_RXAGC_IF51_ANT2_BB_RSSSI_TABLE2_ADD          0x14144
#define REG_PHY_RXAGC_IF51_ANT2_BB_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF51_ANT2_BB_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF51_ANT2_BB_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF52_ANT2_BB_RSSSI_TABLE3_ADD */
/* Rx AGC ant2 bb_rssi table3 */
#define REG_PHY_RXAGC_IF52_ANT2_BB_RSSSI_TABLE3_ADD          0x14148
#define REG_PHY_RXAGC_IF52_ANT2_BB_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF52_ANT2_BB_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF52_ANT2_BB_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF53_ANT2_SYSTEM_GAIN_ACC_ADD */
/* Rx AGC ant2 system gain dc acc */
#define REG_PHY_RXAGC_IF53_ANT2_SYSTEM_GAIN_ACC_ADD          0x1414C
#define REG_PHY_RXAGC_IF53_ANT2_SYSTEM_GAIN_ACC_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF53_ANT2_SYSTEM_GAIN_ACC_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF53_ANT2_SYSTEM_GAIN_ACC_ADD_WIDTH    8

/* PHY_RXAGC_IF54_ANT2_B1_ADD */
/* Rx AGC ant2 bb_rssi b1 value (bb_rssi(2)-bb_rssi(1)) */
#define REG_PHY_RXAGC_IF54_ANT2_B1_ADD          0x14150
#define REG_PHY_RXAGC_IF54_ANT2_B1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF54_ANT2_B1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF54_ANT2_B1_ADD_WIDTH    32

/* PHY_RXAGC_IF55_ANT2_B2_ADD */
/* Rx AGC ant2 bb_rssi b2 value (bb_rssi(3)-bb_rssi(2)) */
#define REG_PHY_RXAGC_IF55_ANT2_B2_ADD          0x14154
#define REG_PHY_RXAGC_IF55_ANT2_B2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF55_ANT2_B2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF55_ANT2_B2_ADD_WIDTH    32

/* PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD */
/* Rx AGC ant2 rssi threshold */
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD          0x14158
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_WIDTH    7

/* PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SIGN */
/* Rx AGC ant2 rssi threshold */
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SIGN          0x14158
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF56_ANT2_RSSI_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD */
/* Rx AGC ant2 rf up threshold */
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD          0x1415C
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SIGN */
/* Rx AGC ant2 rf up threshold */
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SIGN          0x1415C
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF57_ANT2_RF_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD */
/* Rx AGC ant2 rf low threshold */
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD          0x14160
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SIGN */
/* Rx AGC ant2 rf low threshold */
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SIGN          0x14160
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF58_ANT2_RF_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF5A_ANT2_RF_TIMER_THR_ADD */
/* Rx AGC ant2 rf timer threshold  */
#define REG_PHY_RXAGC_IF5A_ANT2_RF_TIMER_THR_ADD          0x14168
#define REG_PHY_RXAGC_IF5A_ANT2_RF_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF5A_ANT2_RF_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF5A_ANT2_RF_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF5C_ANT2_BB_TIMER_THR_ADD */
/* Rx AGC ant2 bb timer threshold  */
#define REG_PHY_RXAGC_IF5C_ANT2_BB_TIMER_THR_ADD          0x14170
#define REG_PHY_RXAGC_IF5C_ANT2_BB_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF5C_ANT2_BB_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF5C_ANT2_BB_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD */
/* Rx AGC ant2 delta rf threshold  */
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD          0x14174
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SIGN */
/* Rx AGC ant2 delta rf threshold  */
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SIGN          0x14174
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF5D_ANT2_DELTA_RF_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD */
/* Rx AGC ant2 delta bb threshold  */
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD          0x14178
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_WIDTH    10

/* PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SIGN */
/* Rx AGC ant2 delta bb threshold  */
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SIGN          0x14178
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF5E_ANT2_DELTA_BB_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF62_ANT2_RF_RELEASE_THR_ADD */
/* Rx AGC ant2 rf release threshold */
#define REG_PHY_RXAGC_IF62_ANT2_RF_RELEASE_THR_ADD          0x14188
#define REG_PHY_RXAGC_IF62_ANT2_RF_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF62_ANT2_RF_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF62_ANT2_RF_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF64_ANT2_BB_RELEASE_THR_ADD */
/* Rx AGC ant2 bb release threshold  */
#define REG_PHY_RXAGC_IF64_ANT2_BB_RELEASE_THR_ADD          0x14190
#define REG_PHY_RXAGC_IF64_ANT2_BB_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF64_ANT2_BB_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF64_ANT2_BB_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF66_ANT2_LONGTHERM_RELEASE_THR_ADD */
/* Rx AGC ant2 longterm release threshold  */
#define REG_PHY_RXAGC_IF66_ANT2_LONGTHERM_RELEASE_THR_ADD          0x14198
#define REG_PHY_RXAGC_IF66_ANT2_LONGTHERM_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF66_ANT2_LONGTHERM_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF66_ANT2_LONGTHERM_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD */
/* Rx AGC ant2 longterm threshold  */
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD          0x1419C
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SIGN */
/* Rx AGC ant2 longterm threshold  */
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SIGN          0x1419C
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF67_ANT2_LONGTHERM_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD */
/* Rx AGC ant2 bb power up threshold */
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD          0x141A0
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SIGN */
/* Rx AGC ant2 bb power up threshold */
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SIGN          0x141A0
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF68_ANT2_BB_POWER_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF69_ANT2_ACC_ALGO_CNTR_ADD */
/* Rx AGC ant2 accelerator algorithm control */
#define REG_PHY_RXAGC_IF69_ANT2_ACC_ALGO_CNTR_ADD          0x141A4
#define REG_PHY_RXAGC_IF69_ANT2_ACC_ALGO_CNTR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF69_ANT2_ACC_ALGO_CNTR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF69_ANT2_ACC_ALGO_CNTR_ADD_WIDTH    16

/* PHY_RXAGC_IF6A_ANT2_ACC_OUT_ADD */
/* Rx AGC ant2 accelerator output */
#define REG_PHY_RXAGC_IF6A_ANT2_ACC_OUT_ADD          0x141A8
#define REG_PHY_RXAGC_IF6A_ANT2_ACC_OUT_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF6A_ANT2_ACC_OUT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF6A_ANT2_ACC_OUT_ADD_WIDTH    9

/* PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD */
/* Rx AGC ant2 rssi offset1 */
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD          0x141AC
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_WIDTH    8

/* PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SIGN */
/* Rx AGC ant2 rssi offset1 */
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SIGN          0x141AC
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF6B_ANT2_RSSI_OFFSET1_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD */
/* Rx AGC ant2 rssi offset2 */
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD          0x141B0
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_WIDTH    7

/* PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant2 rssi offset2 */
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SIGN          0x141B0
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF6C_ANT2_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD */
/* Rx AGC ant2 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD          0x141B8
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_WIDTH    10

/* PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SIGN */
/* Rx AGC ant2 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SIGN          0x141B8
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF6E_ANT2_BB_RSSI_DC_OFFSET_I_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD */
/* Rx AGC ant2 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD          0x141BC
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_WIDTH    10

/* PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SIGN */
/* Rx AGC ant2 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SIGN          0x141BC
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF6F_ANT2_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD */
/* Rx AGC ant2 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD          0x141C4
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SIGN */
/* Rx AGC ant2 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SIGN          0x141C4
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF71_ANT2_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD */
/* Rx AGC ant2 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD          0x141C8
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SIGN */
/* Rx AGC ant2 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SIGN          0x141C8
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF72_ANT2_BB_RSSI_FAST_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF74_ANT2_BB_SATURATION_COUNTER_ADD */
/* Rx AGC ant2 bb saturation counter */
#define REG_PHY_RXAGC_IF74_ANT2_BB_SATURATION_COUNTER_ADD          0x141D0
#define REG_PHY_RXAGC_IF74_ANT2_BB_SATURATION_COUNTER_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF74_ANT2_BB_SATURATION_COUNTER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF74_ANT2_BB_SATURATION_COUNTER_ADD_WIDTH    7

/* PHY_RXAGC_IF75_ANT2_BB_RSSI_OFFSET1_ADD */
/* Rx AGC ant2 bb rssi offset 1 */
#define REG_PHY_RXAGC_IF75_ANT2_BB_RSSI_OFFSET1_ADD          0x141D4
#define REG_PHY_RXAGC_IF75_ANT2_BB_RSSI_OFFSET1_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF75_ANT2_BB_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF75_ANT2_BB_RSSI_OFFSET1_ADD_WIDTH    16

/* PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD */
/* Rx AGC ant2 bb rssi offset 2 */
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD          0x141D8
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_WIDTH    8

/* PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant2 bb rssi offset 2 */
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SIGN          0x141D8
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF76_ANT2_BB_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF78_ANT2_LNA_ADD */
/* Rx AGC ant2 lna */
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD          0x141E0
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_WIDTH    7

/* PHY_RXAGC_IF78_ANT2_LNA_ADD_SIGN */
/* Rx AGC ant2 lna */
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_SIGN          0x141E0
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF78_ANT2_LNA_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD */
/* Rx AGC ant2 system gain */
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD          0x141E4
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_WIDTH    9

/* PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SIGN */
/* Rx AGC ant2 system gain */
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SIGN          0x141E4
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF79_ANT2_SYSTEM_GAIN_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF80_ANT3_RSSI_ADD */
/* Rx AGC ant3 rssi */
#define REG_PHY_RXAGC_IF80_ANT3_RSSI_ADD          0x14200
#define REG_PHY_RXAGC_IF80_ANT3_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF80_ANT3_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF80_ANT3_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF81_ANT3_SRSSI_ADD */
/* Rx AGC ant3 srssi */
#define REG_PHY_RXAGC_IF81_ANT3_SRSSI_ADD          0x14204
#define REG_PHY_RXAGC_IF81_ANT3_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF81_ANT3_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF81_ANT3_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF82_ANT3_BB_RSSI_ADD */
/* Rx AGC ant3 bb_rssi */
#define REG_PHY_RXAGC_IF82_ANT3_BB_RSSI_ADD          0x14208
#define REG_PHY_RXAGC_IF82_ANT3_BB_RSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF82_ANT3_BB_RSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF82_ANT3_BB_RSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF83_ANT3_BB_SRSSI_ADD */
/* Rx AGC ant3 bb_srssi */
#define REG_PHY_RXAGC_IF83_ANT3_BB_SRSSI_ADD          0x1420C
#define REG_PHY_RXAGC_IF83_ANT3_BB_SRSSI_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF83_ANT3_BB_SRSSI_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF83_ANT3_BB_SRSSI_ADD_WIDTH    32

/* PHY_RXAGC_IF86_ANT3_RF_POWER_ADD */
/* Rx AGC ant3 rf_power */
#define REG_PHY_RXAGC_IF86_ANT3_RF_POWER_ADD          0x14218
#define REG_PHY_RXAGC_IF86_ANT3_RF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF86_ANT3_RF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF86_ANT3_RF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF87_ANT3_SRF_POWER_ADD */
/* Rx AGC ant3 srf_power */
#define REG_PHY_RXAGC_IF87_ANT3_SRF_POWER_ADD          0x1421C
#define REG_PHY_RXAGC_IF87_ANT3_SRF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF87_ANT3_SRF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF87_ANT3_SRF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF88_ANT3_BB_POWER_ADD */
/* Rx AGC ant3 bb_power */
#define REG_PHY_RXAGC_IF88_ANT3_BB_POWER_ADD          0x14220
#define REG_PHY_RXAGC_IF88_ANT3_BB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF88_ANT3_BB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF88_ANT3_BB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF89_ANT3_SBB_POWER_ADD */
/* Rx AGC ant3 sbb_power */
#define REG_PHY_RXAGC_IF89_ANT3_SBB_POWER_ADD          0x14224
#define REG_PHY_RXAGC_IF89_ANT3_SBB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF89_ANT3_SBB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF89_ANT3_SBB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IF8A_ANT3_RSSSI_TABLE1_ADD */
/* Rx AGC ant3 rssi db table1 */
#define REG_PHY_RXAGC_IF8A_ANT3_RSSSI_TABLE1_ADD          0x14228
#define REG_PHY_RXAGC_IF8A_ANT3_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF8A_ANT3_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF8A_ANT3_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF8B_ANT3_RSSSI_TABLE2_ADD */
/* Rx AGC ant3 rssi db table2 */
#define REG_PHY_RXAGC_IF8B_ANT3_RSSSI_TABLE2_ADD          0x1422C
#define REG_PHY_RXAGC_IF8B_ANT3_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF8B_ANT3_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF8B_ANT3_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF8C_ANT3_RSSSI_TABLE3_ADD */
/* Rx AGC ant3 rssi db table3 */
#define REG_PHY_RXAGC_IF8C_ANT3_RSSSI_TABLE3_ADD          0x14230
#define REG_PHY_RXAGC_IF8C_ANT3_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF8C_ANT3_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF8C_ANT3_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF8E_ANT3_D1_ADD */
/* Rx AGC ant3 rssi d1 value (rssi(2)-rssi(1)) */
#define REG_PHY_RXAGC_IF8E_ANT3_D1_ADD          0x14238
#define REG_PHY_RXAGC_IF8E_ANT3_D1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF8E_ANT3_D1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF8E_ANT3_D1_ADD_WIDTH    32

/* PHY_RXAGC_IF8F_ANT3_D2_ADD */
/* Rx AGC ant3 rssi d2 value (rssi(3)-rssi(2)) */
#define REG_PHY_RXAGC_IF8F_ANT3_D2_ADD          0x1423C
#define REG_PHY_RXAGC_IF8F_ANT3_D2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF8F_ANT3_D2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF8F_ANT3_D2_ADD_WIDTH    32

/* PHY_RXAGC_IF90_ANT3_BB_RSSSI_TABLE1_ADD */
/* Rx AGC ant3 bb_rssi table1 */
#define REG_PHY_RXAGC_IF90_ANT3_BB_RSSSI_TABLE1_ADD          0x14240
#define REG_PHY_RXAGC_IF90_ANT3_BB_RSSSI_TABLE1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF90_ANT3_BB_RSSSI_TABLE1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF90_ANT3_BB_RSSSI_TABLE1_ADD_WIDTH    32

/* PHY_RXAGC_IF91_ANT3_BB_RSSSI_TABLE2_ADD */
/* Rx AGC ant3 bb_rssi table2 */
#define REG_PHY_RXAGC_IF91_ANT3_BB_RSSSI_TABLE2_ADD          0x14244
#define REG_PHY_RXAGC_IF91_ANT3_BB_RSSSI_TABLE2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF91_ANT3_BB_RSSSI_TABLE2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF91_ANT3_BB_RSSSI_TABLE2_ADD_WIDTH    32

/* PHY_RXAGC_IF92_ANT3_BB_RSSSI_TABLE3_ADD */
/* Rx AGC ant3 bb_rssi table3 */
#define REG_PHY_RXAGC_IF92_ANT3_BB_RSSSI_TABLE3_ADD          0x14248
#define REG_PHY_RXAGC_IF92_ANT3_BB_RSSSI_TABLE3_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF92_ANT3_BB_RSSSI_TABLE3_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF92_ANT3_BB_RSSSI_TABLE3_ADD_WIDTH    32

/* PHY_RXAGC_IF93_ANT3_SYSTEM_GAIN_ACC_ADD */
/* Rx AGC ant3 system gain dc acc */
#define REG_PHY_RXAGC_IF93_ANT3_SYSTEM_GAIN_ACC_ADD          0x1424C
#define REG_PHY_RXAGC_IF93_ANT3_SYSTEM_GAIN_ACC_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF93_ANT3_SYSTEM_GAIN_ACC_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF93_ANT3_SYSTEM_GAIN_ACC_ADD_WIDTH    8

/* PHY_RXAGC_IF94_ANT3_B1_ADD */
/* Rx AGC ant3 bb_rssi b1 value (bb_rssi(2)-bb_rssi(1)) */
#define REG_PHY_RXAGC_IF94_ANT3_B1_ADD          0x14250
#define REG_PHY_RXAGC_IF94_ANT3_B1_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF94_ANT3_B1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF94_ANT3_B1_ADD_WIDTH    32

/* PHY_RXAGC_IF95_ANT3_B2_ADD */
/* Rx AGC ant3 bb_rssi b2 value (bb_rssi(3)-bb_rssi(2)) */
#define REG_PHY_RXAGC_IF95_ANT3_B2_ADD          0x14254
#define REG_PHY_RXAGC_IF95_ANT3_B2_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF95_ANT3_B2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF95_ANT3_B2_ADD_WIDTH    32

/* PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD */
/* Rx AGC ant3 rssi threshold */
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD          0x14258
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_WIDTH    7

/* PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SIGN */
/* Rx AGC ant3 rssi threshold */
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SIGN          0x14258
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF96_ANT3_RSSI_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD */
/* Rx AGC ant3 rf up threshold */
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD          0x1425C
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SIGN */
/* Rx AGC ant3 rf up threshold */
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SIGN          0x1425C
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF97_ANT3_RF_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD */
/* Rx AGC ant3 rf low threshold */
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD          0x14260
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SIGN */
/* Rx AGC ant3 rf low threshold */
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SIGN          0x14260
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF98_ANT3_RF_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF9A_ANT3_RF_TIMER_THR_ADD */
/* Rx AGC ant3 rf timer threshold  */
#define REG_PHY_RXAGC_IF9A_ANT3_RF_TIMER_THR_ADD          0x14268
#define REG_PHY_RXAGC_IF9A_ANT3_RF_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF9A_ANT3_RF_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF9A_ANT3_RF_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF9C_ANT3_BB_TIMER_THR_ADD */
/* Rx AGC ant3 bb timer threshold  */
#define REG_PHY_RXAGC_IF9C_ANT3_BB_TIMER_THR_ADD          0x14270
#define REG_PHY_RXAGC_IF9C_ANT3_BB_TIMER_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IF9C_ANT3_BB_TIMER_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF9C_ANT3_BB_TIMER_THR_ADD_WIDTH    16

/* PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD */
/* Rx AGC ant3 delta rf threshold  */
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD          0x14274
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_WIDTH    8

/* PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SIGN */
/* Rx AGC ant3 delta rf threshold  */
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SIGN          0x14274
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF9D_ANT3_DELTA_RF_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD */
/* Rx AGC ant3 delta bb threshold  */
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD          0x14278
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_WIDTH    10

/* PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SIGN */
/* Rx AGC ant3 delta bb threshold  */
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SIGN          0x14278
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IF9E_ANT3_DELTA_BB_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFA2_ANT3_RF_RELEASE_THR_ADD */
/* Rx AGC ant3 rf release threshold */
#define REG_PHY_RXAGC_IFA2_ANT3_RF_RELEASE_THR_ADD          0x14288
#define REG_PHY_RXAGC_IFA2_ANT3_RF_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IFA2_ANT3_RF_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA2_ANT3_RF_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IFA4_ANT3_BB_RELEASE_THR_ADD */
/* Rx AGC ant3 bb release threshold  */
#define REG_PHY_RXAGC_IFA4_ANT3_BB_RELEASE_THR_ADD          0x14290
#define REG_PHY_RXAGC_IFA4_ANT3_BB_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IFA4_ANT3_BB_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA4_ANT3_BB_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IFA6_ANT3_LONGTHERM_RELEASE_THR_ADD */
/* Rx AGC ant3 longterm release threshold  */
#define REG_PHY_RXAGC_IFA6_ANT3_LONGTHERM_RELEASE_THR_ADD          0x14298
#define REG_PHY_RXAGC_IFA6_ANT3_LONGTHERM_RELEASE_THR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IFA6_ANT3_LONGTHERM_RELEASE_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA6_ANT3_LONGTHERM_RELEASE_THR_ADD_WIDTH    16

/* PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD */
/* Rx AGC ant3 longterm threshold  */
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD          0x1429C
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_WIDTH    8

/* PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SIGN */
/* Rx AGC ant3 longterm threshold  */
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SIGN          0x1429C
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFA7_ANT3_LONGTHERM_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD */
/* Rx AGC ant3 bb power up threshold */
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD          0x142A0
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_WIDTH    9

/* PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SIGN */
/* Rx AGC ant3 bb power up threshold */
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SIGN          0x142A0
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFA8_ANT3_BB_POWER_UP_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFA9_ANT3_ACC_ALGO_CNTR_ADD */
/* Rx AGC ant3 accelerator algorithm control */
#define REG_PHY_RXAGC_IFA9_ANT3_ACC_ALGO_CNTR_ADD          0x142A4
#define REG_PHY_RXAGC_IFA9_ANT3_ACC_ALGO_CNTR_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IFA9_ANT3_ACC_ALGO_CNTR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFA9_ANT3_ACC_ALGO_CNTR_ADD_WIDTH    16

/* PHY_RXAGC_IFAA_ANT3_ACC_OUT_ADD */
/* Rx AGC ant3 accelerator output */
#define REG_PHY_RXAGC_IFAA_ANT3_ACC_OUT_ADD          0x142A8
#define REG_PHY_RXAGC_IFAA_ANT3_ACC_OUT_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IFAA_ANT3_ACC_OUT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFAA_ANT3_ACC_OUT_ADD_WIDTH    9

/* PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD */
/* Rx AGC ant3 rssi offset1 */
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD          0x142AC
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_WIDTH    8

/* PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SIGN */
/* Rx AGC ant3 rssi offset1 */
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SIGN          0x142AC
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFAB_ANT3_RSSI_OFFSET1_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD */
/* Rx AGC ant3 rssi offset2 */
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD          0x142B0
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_WIDTH    7

/* PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant3 rssi offset2 */
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SIGN          0x142B0
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFAC_ANT3_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD */
/* Rx AGC ant3 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD          0x142B8
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_WIDTH    10

/* PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SIGN */
/* Rx AGC ant3 bb rssi dc offset 1 */
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SIGN          0x142B8
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFAE_ANT3_BB_RSSI_DC_OFFSET_I_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD */
/* Rx AGC ant3 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD          0x142BC
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_MASK     0x000003ff
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_WIDTH    10

/* PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SIGN */
/* Rx AGC ant3 bb rssi dc offset 2 */
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SIGN          0x142BC
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFAF_ANT3_BB_RSSI_DC_OFFSET_Q_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD */
/* Rx AGC ant3 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD          0x142C4
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SIGN */
/* Rx AGC ant3 bb rssi slow low threshold */
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SIGN          0x142C4
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFB1_ANT3_BB_RSSI_SLOW_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD */
/* Rx AGC ant3 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD          0x142C8
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_WIDTH    9

/* PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SIGN */
/* Rx AGC ant3 bb rssi fast low threshold */
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SIGN          0x142C8
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFB2_ANT3_BB_RSSI_FAST_LOW_THR_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFB4_ANT3_BB_SATURATION_COUNTER_ADD */
/* Rx AGC ant3 bb saturation counter */
#define REG_PHY_RXAGC_IFB4_ANT3_BB_SATURATION_COUNTER_ADD          0x142D0
#define REG_PHY_RXAGC_IFB4_ANT3_BB_SATURATION_COUNTER_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IFB4_ANT3_BB_SATURATION_COUNTER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB4_ANT3_BB_SATURATION_COUNTER_ADD_WIDTH    7

/* PHY_RXAGC_IFB5_ANT3_BB_RSSI_OFFSET1_ADD */
/* Rx AGC ant3 bb rssi offset 1 */
#define REG_PHY_RXAGC_IFB5_ANT3_BB_RSSI_OFFSET1_ADD          0x142D4
#define REG_PHY_RXAGC_IFB5_ANT3_BB_RSSI_OFFSET1_ADD_MASK     0x0000ffff
#define REG_PHY_RXAGC_IFB5_ANT3_BB_RSSI_OFFSET1_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB5_ANT3_BB_RSSI_OFFSET1_ADD_WIDTH    16

/* PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD */
/* Rx AGC ant3 bb rssi offset 2 */
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD          0x142D8
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_WIDTH    8

/* PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SIGN */
/* Rx AGC ant3 bb rssi offset 2 */
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SIGN          0x142D8
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFB6_ANT3_BB_RSSI_OFFSET2_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFB8_ANT3_LNA_ADD */
/* Rx AGC ant3 lna */
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD          0x142E0
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_MASK     0x0000007f
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_WIDTH    7

/* PHY_RXAGC_IFB8_ANT3_LNA_ADD_SIGN */
/* Rx AGC ant3 lna */
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_SIGN          0x142E0
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFB8_ANT3_LNA_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD */
/* Rx AGC ant3 system gain */
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD          0x142E4
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_MASK     0x000001ff
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_WIDTH    9

/* PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SIGN */
/* Rx AGC ant3 system gain */
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SIGN          0x142E4
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFB9_ANT3_SYSTEM_GAIN_ADD_SIGN_WIDTH    32

/* PHY_RXAGC_IFC0_ANT1_AGC_STM_RDBACK_ADD */
/* Rx AGC Acc0 state readback */
#define REG_PHY_RXAGC_IFC0_ANT1_AGC_STM_RDBACK_ADD          0x14300
#define REG_PHY_RXAGC_IFC0_ANT1_AGC_STM_RDBACK_ADD_MASK     0x0000003f
#define REG_PHY_RXAGC_IFC0_ANT1_AGC_STM_RDBACK_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFC0_ANT1_AGC_STM_RDBACK_ADD_WIDTH    6

/* PHY_RXAGC_IFC0_ANT2_AGC_STM_RDBACK_ADD */
/* Rx AGC Acc1 state readback */
#define REG_PHY_RXAGC_IFC0_ANT2_AGC_STM_RDBACK_ADD          0x14300
#define REG_PHY_RXAGC_IFC0_ANT2_AGC_STM_RDBACK_ADD_MASK     0x00003f00
#define REG_PHY_RXAGC_IFC0_ANT2_AGC_STM_RDBACK_ADD_SHIFT    8
#define REG_PHY_RXAGC_IFC0_ANT2_AGC_STM_RDBACK_ADD_WIDTH    6

/* PHY_RXAGC_IFC1_ANT3_AGC_STM_RDBACK_ADD */
/* Rx AGC Acc2 state readback */
#define REG_PHY_RXAGC_IFC1_ANT3_AGC_STM_RDBACK_ADD          0x14304
#define REG_PHY_RXAGC_IFC1_ANT3_AGC_STM_RDBACK_ADD_MASK     0x0000003f
#define REG_PHY_RXAGC_IFC1_ANT3_AGC_STM_RDBACK_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFC1_ANT3_AGC_STM_RDBACK_ADD_WIDTH    6

/* PHY_RXAGC_IFC2_MAX_RF_POWER_ADD */
/* max_rf_power_add */
#define REG_PHY_RXAGC_IFC2_MAX_RF_POWER_ADD          0x14308
#define REG_PHY_RXAGC_IFC2_MAX_RF_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFC2_MAX_RF_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFC2_MAX_RF_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IFC3_MAX_BB_POWER_ADD */
/* max_bb_power_add */
#define REG_PHY_RXAGC_IFC3_MAX_BB_POWER_ADD          0x1430C
#define REG_PHY_RXAGC_IFC3_MAX_BB_POWER_ADD_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFC3_MAX_BB_POWER_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFC3_MAX_BB_POWER_ADD_WIDTH    32

/* PHY_RXAGC_IFC5_RSSI_SAT_ADD */
/* rssi_sat_add: 
7: rf_power_sat
6: ant3_rf_power_sat,
5: ant2_rf_power_sat,
4: ant1_rf_power_sat,
3: bb_power_sat,
2: ant3_bb_rssi_sat,
1: ant2_bb_rssi_sat,
0: ant1_bb_rssi_sat */
#define REG_PHY_RXAGC_IFC5_RSSI_SAT_ADD          0x14314
#define REG_PHY_RXAGC_IFC5_RSSI_SAT_ADD_MASK     0x000000ff
#define REG_PHY_RXAGC_IFC5_RSSI_SAT_ADD_SHIFT    0
#define REG_PHY_RXAGC_IFC5_RSSI_SAT_ADD_WIDTH    8

/* PHY_RXAGC_IFC6_BB_RSSI_SAT_THR */
/* bb_rssi_sat_thr */
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR          0x14318
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_MASK     0x000001ff
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SHIFT    0
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_WIDTH    9

/* PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SIGN */
/* bb_rssi_sat_thr */
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SIGN          0x14318
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFC6_BB_RSSI_SAT_THR_SIGN_WIDTH    32

/* PHY_RXAGC_IFC7_RF_POWER_SAT_THR */
/* rf_power_sat_thr */
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR          0x1431C
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_MASK     0x000000ff
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SHIFT    0
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_WIDTH    8

/* PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SIGN */
/* rf_power_sat_thr */
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SIGN          0x1431C
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SIGN_MASK     0xFFFFFFFF
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SIGN_SHIFT    0
#define REG_PHY_RXAGC_IFC7_RF_POWER_SAT_THR_SIGN_WIDTH    32

/* PHY_RXAGC_IFC8_CLEAR_AGC_TIMERS */
/* clear_agc_timers */
#define REG_PHY_RXAGC_IFC8_CLEAR_AGC_TIMERS          0x14320
#define REG_PHY_RXAGC_IFC8_CLEAR_AGC_TIMERS_MASK     0x00000001
#define REG_PHY_RXAGC_IFC8_CLEAR_AGC_TIMERS_SHIFT    0
#define REG_PHY_RXAGC_IFC8_CLEAR_AGC_TIMERS_WIDTH    1

/* PHY_RXAGC_IFC9_CLEAR_AGC_ACC_OUT */
/* clear_agc_acc_out */
#define REG_PHY_RXAGC_IFC9_CLEAR_AGC_ACC_OUT          0x14324
#define REG_PHY_RXAGC_IFC9_CLEAR_AGC_ACC_OUT_MASK     0x00000001
#define REG_PHY_RXAGC_IFC9_CLEAR_AGC_ACC_OUT_SHIFT    0
#define REG_PHY_RXAGC_IFC9_CLEAR_AGC_ACC_OUT_WIDTH    1

/* PHY_RXAGC_IFCA_CLEAR_AGC_MASK_OP */
/* clear_agc_mask_op */
#define REG_PHY_RXAGC_IFCA_CLEAR_AGC_MASK_OP          0x14328
#define REG_PHY_RXAGC_IFCA_CLEAR_AGC_MASK_OP_MASK     0x00000001
#define REG_PHY_RXAGC_IFCA_CLEAR_AGC_MASK_OP_SHIFT    0
#define REG_PHY_RXAGC_IFCA_CLEAR_AGC_MASK_OP_WIDTH    1

/* PHY_RXTD_AGC_ACC101_ACCELERATOR_REG01 */
/* Agc Acc Reg01
Table Min Value x (so first entry will be zero)
 */
#define REG_PHY_RXTD_AGC_ACC101_ACCELERATOR_REG01          0x14404
#define REG_PHY_RXTD_AGC_ACC101_ACCELERATOR_REG01_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC101_ACCELERATOR_REG01_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC101_ACCELERATOR_REG01_WIDTH    8

/* PHY_RXTD_AGC_ACC102_ACCELERATOR_REG02 */
/* Agc Acc Reg02
Table min value y (so first entry will be zero) */
#define REG_PHY_RXTD_AGC_ACC102_ACCELERATOR_REG02          0x14408
#define REG_PHY_RXTD_AGC_ACC102_ACCELERATOR_REG02_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC102_ACCELERATOR_REG02_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC102_ACCELERATOR_REG02_WIDTH    8

/* PHY_RXTD_AGC_ACC109_ACCELERATOR_REG09 */
/* Agc Acc Reg09
min column & row table entry */
#define REG_PHY_RXTD_AGC_ACC109_ACCELERATOR_REG09          0x14424
#define REG_PHY_RXTD_AGC_ACC109_ACCELERATOR_REG09_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC109_ACCELERATOR_REG09_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC109_ACCELERATOR_REG09_WIDTH    8

/* PHY_RXTD_AGC_ACC10A_ACCELERATOR_REG10 */
/* Agc Acc Reg10
max column table entry */
#define REG_PHY_RXTD_AGC_ACC10A_ACCELERATOR_REG10          0x14428
#define REG_PHY_RXTD_AGC_ACC10A_ACCELERATOR_REG10_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC10A_ACCELERATOR_REG10_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC10A_ACCELERATOR_REG10_WIDTH    8

/* PHY_RXTD_AGC_ACC10B_ACCELERATOR_REG11 */
/* Agc Acc Reg11
max row table entry */
#define REG_PHY_RXTD_AGC_ACC10B_ACCELERATOR_REG11          0x1442C
#define REG_PHY_RXTD_AGC_ACC10B_ACCELERATOR_REG11_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC10B_ACCELERATOR_REG11_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC10B_ACCELERATOR_REG11_WIDTH    8

/* PHY_RXTD_AGC_ACC118_TABLE_ACCESS_ANT_SEL */
/* table_access_ant_sel */
#define REG_PHY_RXTD_AGC_ACC118_TABLE_ACCESS_ANT_SEL          0x14460
#define REG_PHY_RXTD_AGC_ACC118_TABLE_ACCESS_ANT_SEL_MASK     0x00000007
#define REG_PHY_RXTD_AGC_ACC118_TABLE_ACCESS_ANT_SEL_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC118_TABLE_ACCESS_ANT_SEL_WIDTH    3

/* PHY_RXTD_AGC_ACC118_GAIN_CALC_ANT_SEL */
/* gain_calc_ant_sel */
#define REG_PHY_RXTD_AGC_ACC118_GAIN_CALC_ANT_SEL          0x14460
#define REG_PHY_RXTD_AGC_ACC118_GAIN_CALC_ANT_SEL_MASK     0x00000070
#define REG_PHY_RXTD_AGC_ACC118_GAIN_CALC_ANT_SEL_SHIFT    4
#define REG_PHY_RXTD_AGC_ACC118_GAIN_CALC_ANT_SEL_WIDTH    3

/* PHY_RXTD_AGC_ACC118_CALCULATE_PGC3_ONLY */
/* calculate_pgc3_only */
#define REG_PHY_RXTD_AGC_ACC118_CALCULATE_PGC3_ONLY          0x14460
#define REG_PHY_RXTD_AGC_ACC118_CALCULATE_PGC3_ONLY_MASK     0x00000080
#define REG_PHY_RXTD_AGC_ACC118_CALCULATE_PGC3_ONLY_SHIFT    7
#define REG_PHY_RXTD_AGC_ACC118_CALCULATE_PGC3_ONLY_WIDTH    1

/* PHY_RXTD_AGC_ACC118_RF_POWER_DIRECT */
/* rf_power_direct */
#define REG_PHY_RXTD_AGC_ACC118_RF_POWER_DIRECT          0x14460
#define REG_PHY_RXTD_AGC_ACC118_RF_POWER_DIRECT_MASK     0x00000700
#define REG_PHY_RXTD_AGC_ACC118_RF_POWER_DIRECT_SHIFT    8
#define REG_PHY_RXTD_AGC_ACC118_RF_POWER_DIRECT_WIDTH    3

/* PHY_RXTD_AGC_ACC118_BB_POWER_DIRECT */
/* bb_power_direct */
#define REG_PHY_RXTD_AGC_ACC118_BB_POWER_DIRECT          0x14460
#define REG_PHY_RXTD_AGC_ACC118_BB_POWER_DIRECT_MASK     0x00007000
#define REG_PHY_RXTD_AGC_ACC118_BB_POWER_DIRECT_SHIFT    12
#define REG_PHY_RXTD_AGC_ACC118_BB_POWER_DIRECT_WIDTH    3

/* PHY_RXTD_AGC_ACC118_TABLE_GO */
/* Activate the table ACC. */
#define REG_PHY_RXTD_AGC_ACC118_TABLE_GO          0x14460
#define REG_PHY_RXTD_AGC_ACC118_TABLE_GO_MASK     0x00008000
#define REG_PHY_RXTD_AGC_ACC118_TABLE_GO_SHIFT    15
#define REG_PHY_RXTD_AGC_ACC118_TABLE_GO_WIDTH    1

/* PHY_RXTD_AGC_ACC119_MIN_INF_RF_POWER */
/* min_inf_rf_power */
#define REG_PHY_RXTD_AGC_ACC119_MIN_INF_RF_POWER          0x14464
#define REG_PHY_RXTD_AGC_ACC119_MIN_INF_RF_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC119_MIN_INF_RF_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC119_MIN_INF_RF_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC119_MAX_INF_RF_POWER */
/* max_inf_rf_power */
#define REG_PHY_RXTD_AGC_ACC119_MAX_INF_RF_POWER          0x14464
#define REG_PHY_RXTD_AGC_ACC119_MAX_INF_RF_POWER_MASK     0x0000ff00
#define REG_PHY_RXTD_AGC_ACC119_MAX_INF_RF_POWER_SHIFT    8
#define REG_PHY_RXTD_AGC_ACC119_MAX_INF_RF_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC11A_MIN_INF_BB_POWER */
/* min_inf_bb_power */
#define REG_PHY_RXTD_AGC_ACC11A_MIN_INF_BB_POWER          0x14468
#define REG_PHY_RXTD_AGC_ACC11A_MIN_INF_BB_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC11A_MIN_INF_BB_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC11A_MIN_INF_BB_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC11A_MAX_INF_BB_POWER */
/* max_inf_bb_power */
#define REG_PHY_RXTD_AGC_ACC11A_MAX_INF_BB_POWER          0x14468
#define REG_PHY_RXTD_AGC_ACC11A_MAX_INF_BB_POWER_MASK     0x0000ff00
#define REG_PHY_RXTD_AGC_ACC11A_MAX_INF_BB_POWER_SHIFT    8
#define REG_PHY_RXTD_AGC_ACC11A_MAX_INF_BB_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC1 */
/* ifx_max_pgc1 */
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC1          0x1446C
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC1_MASK     0x00000007
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC1_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC1_WIDTH    3

/* PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC2 */
/* ifx_max_pgc2 */
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC2          0x1446C
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC2_MASK     0x00000070
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC2_SHIFT    4
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC2_WIDTH    3

/* PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC3 */
/* ifx_max_pgc3 */
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC3          0x1446C
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC3_MASK     0x00000f00
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC3_SHIFT    8
#define REG_PHY_RXTD_AGC_ACC11B_IFX_MAX_PGC3_WIDTH    4

/* PHY_RXTD_AGC_ACC11C_ANT0_GAIN1_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC11C_ANT0_GAIN1_WORD          0x14470
#define REG_PHY_RXTD_AGC_ACC11C_ANT0_GAIN1_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC11C_ANT0_GAIN1_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC11C_ANT0_GAIN1_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC11D_ANT0_GAIN2_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC11D_ANT0_GAIN2_WORD          0x14474
#define REG_PHY_RXTD_AGC_ACC11D_ANT0_GAIN2_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC11D_ANT0_GAIN2_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC11D_ANT0_GAIN2_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC11F_ANT1_GAIN1_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC11F_ANT1_GAIN1_WORD          0x1447C
#define REG_PHY_RXTD_AGC_ACC11F_ANT1_GAIN1_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC11F_ANT1_GAIN1_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC11F_ANT1_GAIN1_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC120_ANT1_GAIN2_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC120_ANT1_GAIN2_WORD          0x14480
#define REG_PHY_RXTD_AGC_ACC120_ANT1_GAIN2_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC120_ANT1_GAIN2_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC120_ANT1_GAIN2_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC122_ANT2_GAIN1_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC122_ANT2_GAIN1_WORD          0x14488
#define REG_PHY_RXTD_AGC_ACC122_ANT2_GAIN1_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC122_ANT2_GAIN1_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC122_ANT2_GAIN1_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC123_ANT2_GAIN2_WORD */
/* ant0_agc_word */
#define REG_PHY_RXTD_AGC_ACC123_ANT2_GAIN2_WORD          0x1448C
#define REG_PHY_RXTD_AGC_ACC123_ANT2_GAIN2_WORD_MASK     0x0000ffff
#define REG_PHY_RXTD_AGC_ACC123_ANT2_GAIN2_WORD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC123_ANT2_GAIN2_WORD_WIDTH    16

/* PHY_RXTD_AGC_ACC124_IFX_GAIN1_ADD */
/* ifx_gain1_add */
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN1_ADD          0x14490
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN1_ADD_MASK     0x0000007f
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN1_ADD_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN1_ADD_WIDTH    7

/* PHY_RXTD_AGC_ACC124_IFX_GAIN2_ADD */
/* ifx_gain2_add */
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN2_ADD          0x14490
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN2_ADD_MASK     0x00007f00
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN2_ADD_SHIFT    8
#define REG_PHY_RXTD_AGC_ACC124_IFX_GAIN2_ADD_WIDTH    7

/* PHY_RXTD_AGC_ACC126_TARGET_BACKOFF */
/* target_backoff */
#define REG_PHY_RXTD_AGC_ACC126_TARGET_BACKOFF          0x14498
#define REG_PHY_RXTD_AGC_ACC126_TARGET_BACKOFF_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC126_TARGET_BACKOFF_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC126_TARGET_BACKOFF_WIDTH    8

/* PHY_RXTD_AGC_ACC127_IFX_DONE */
/* infineon_done */
#define REG_PHY_RXTD_AGC_ACC127_IFX_DONE          0x1449C
#define REG_PHY_RXTD_AGC_ACC127_IFX_DONE_MASK     0x00000001
#define REG_PHY_RXTD_AGC_ACC127_IFX_DONE_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC127_IFX_DONE_WIDTH    1

/* PHY_RXTD_AGC_ACC128_ANT0_GEN_RISC_RF_POWER */
/* ant0_gen_risc_rf_power */
#define REG_PHY_RXTD_AGC_ACC128_ANT0_GEN_RISC_RF_POWER          0x144A0
#define REG_PHY_RXTD_AGC_ACC128_ANT0_GEN_RISC_RF_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC128_ANT0_GEN_RISC_RF_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC128_ANT0_GEN_RISC_RF_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC129_ANT0_GEN_RISC_BB_POWER */
/* ant0_gen_risc_bb_power */
#define REG_PHY_RXTD_AGC_ACC129_ANT0_GEN_RISC_BB_POWER          0x144A4
#define REG_PHY_RXTD_AGC_ACC129_ANT0_GEN_RISC_BB_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC129_ANT0_GEN_RISC_BB_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC129_ANT0_GEN_RISC_BB_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC12A_ANT1_GEN_RISC_RF_POWER */
/* ant1_gen_risc_rf_power */
#define REG_PHY_RXTD_AGC_ACC12A_ANT1_GEN_RISC_RF_POWER          0x144A8
#define REG_PHY_RXTD_AGC_ACC12A_ANT1_GEN_RISC_RF_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC12A_ANT1_GEN_RISC_RF_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC12A_ANT1_GEN_RISC_RF_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC12B_ANT1_GEN_RISC_BB_POWER */
/* ant1_gen_risc_bb_power */
#define REG_PHY_RXTD_AGC_ACC12B_ANT1_GEN_RISC_BB_POWER          0x144AC
#define REG_PHY_RXTD_AGC_ACC12B_ANT1_GEN_RISC_BB_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC12B_ANT1_GEN_RISC_BB_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC12B_ANT1_GEN_RISC_BB_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC12C_ANT2_GEN_RISC_RF_POWER */
/* ant2_gen_risc_rf_power */
#define REG_PHY_RXTD_AGC_ACC12C_ANT2_GEN_RISC_RF_POWER          0x144B0
#define REG_PHY_RXTD_AGC_ACC12C_ANT2_GEN_RISC_RF_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC12C_ANT2_GEN_RISC_RF_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC12C_ANT2_GEN_RISC_RF_POWER_WIDTH    8

/* PHY_RXTD_AGC_ACC12D_ANT2_GEN_RISC_BB_POWER */
/* ant2_gen_risc_bb_power */
#define REG_PHY_RXTD_AGC_ACC12D_ANT2_GEN_RISC_BB_POWER          0x144B4
#define REG_PHY_RXTD_AGC_ACC12D_ANT2_GEN_RISC_BB_POWER_MASK     0x000000ff
#define REG_PHY_RXTD_AGC_ACC12D_ANT2_GEN_RISC_BB_POWER_SHIFT    0
#define REG_PHY_RXTD_AGC_ACC12D_ANT2_GEN_RISC_BB_POWER_WIDTH    8
#endif 
