/*******************************************************************
*                                                                   
*  PHY_RX_FD.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_FD_regs_H_FILE
#define PHY_RX_FD_regs_H_FILE

/* PHY_RXFD_REG02_BIST_DONE_LOW */
/* bist done low part */
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW          0x00008
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_SHIFT    0
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_WIDTH    32

/* PHY_RXFD_REG03_BIST_DONE_HIGH */
/* bist done high part */
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH          0x0000C
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_SHIFT    0
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_WIDTH    32

/* PHY_RXFD_REG04_BIST_RESULT_LOW */
/* bist result low part */
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW          0x00010
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_SHIFT    0
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_WIDTH    32

/* PHY_RXFD_REG05_BIST_RESULT_HIGH */
/* bist result high part */
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH          0x00014
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_SHIFT    0
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_WIDTH    32

/* PHY_RXFD_REG06_PT_BYPASS */
/* phase tracking bypass - zero outputs */
#define REG_PHY_RXFD_REG06_PT_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_PT_BYPASS_MASK     0x00000001
#define REG_PHY_RXFD_REG06_PT_BYPASS_SHIFT    0
#define REG_PHY_RXFD_REG06_PT_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_NCO_FUNC_BYPASS */
/* nco functional bypass (force phase addr to zero) */
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_MASK     0x00000002
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_SHIFT    1
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN */
/* enable update ch in read write mode */
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN          0x00018
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_MASK     0x00000010
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_SHIFT    4
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_WIDTH    1

/* PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN */
/* enable update ch in update mode */
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN          0x00018
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_MASK     0x00000020
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_SHIFT    5
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_WIDTH    1

/* PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS */
/* independent noise estimation sw bypass */
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_MASK     0x00000040
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_SHIFT    6
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS */
/* dependent noise estimation sw bypass */
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_MASK     0x00000080
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_SHIFT    7
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_RX_ENABLE_OVERRIDE */
/* GSM - test mode */
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE          0x00018
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_MASK     0x00000200
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_SHIFT    9
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_WIDTH    1

/* PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE */
/* dpndt_ne_symmetric_mode */
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE          0x00018
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_MASK     0x00000400
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_SHIFT    10
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_WIDTH    1

/* PHY_RXFD_REG06_BC_OUT_2TB */
/* connect bin chooser output to MID  test plug 0 (len0_tp0). 001-fft_0, 010-fft_1 100-fft_2 */
#define REG_PHY_RXFD_REG06_BC_OUT_2TB          0x00018
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_MASK     0x70000000
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_SHIFT    28
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_WIDTH    3

/* PHY_RXFD_REG07_FFT_OLA_SELECT */
/* fft_ola_select[2],fft_ola_select[1],fft_ola_select[0] */
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT          0x0001C
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_MASK     0x00000007
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_SHIFT    0
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_WIDTH    3

/* PHY_RXFD_REG07_FFT_0_GCLK_BYPASS */
/* fft 0 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_MASK     0x00000010
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_SHIFT    4
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_1_GCLK_BYPASS */
/* fft 1 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_MASK     0x00000020
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_SHIFT    5
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_2_GCLK_BYPASS */
/* fft 2 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_MASK     0x00000040
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_SHIFT    6
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_RND */
/* fft output round */
#define REG_PHY_RXFD_REG07_FFT_RND          0x0001C
#define REG_PHY_RXFD_REG07_FFT_RND_MASK     0x00000300
#define REG_PHY_RXFD_REG07_FFT_RND_SHIFT    8
#define REG_PHY_RXFD_REG07_FFT_RND_WIDTH    2

/* PHY_RXFD_REG07_FFT_START_WADDR */
/* fft_start_waddr */
#define REG_PHY_RXFD_REG07_FFT_START_WADDR          0x0001C
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_MASK     0x0007F000
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_SHIFT    12
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_WIDTH    7

/* PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT */
/* short cyclic prefix timing shift - full channel bonding */
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT          0x0001C
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_MASK     0x00F00000
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_SHIFT    20
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_WIDTH    4

/* PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT */
/* short cyclic prefix timing shift - non channel bonding */
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT          0x0001C
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_MASK     0x0F000000
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_SHIFT    24
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_WIDTH    4

/* PHY_RXFD_REG09_FCB_NPILOT */
/* full channel bonding - number of pilots bins */
#define REG_PHY_RXFD_REG09_FCB_NPILOT          0x00024
#define REG_PHY_RXFD_REG09_FCB_NPILOT_MASK     0x00000007
#define REG_PHY_RXFD_REG09_FCB_NPILOT_SHIFT    0
#define REG_PHY_RXFD_REG09_FCB_NPILOT_WIDTH    3

/* PHY_RXFD_REG09_NCB_NPILOT */
/* non channel bonding - number of pilots bins */
#define REG_PHY_RXFD_REG09_NCB_NPILOT          0x00024
#define REG_PHY_RXFD_REG09_NCB_NPILOT_MASK     0x00000070
#define REG_PHY_RXFD_REG09_NCB_NPILOT_SHIFT    4
#define REG_PHY_RXFD_REG09_NCB_NPILOT_WIDTH    3

/* PHY_RXFD_REG09_FCB_NDATA */
/* full channel bonding - number of data bins */
#define REG_PHY_RXFD_REG09_FCB_NDATA          0x00024
#define REG_PHY_RXFD_REG09_FCB_NDATA_MASK     0x00007F00
#define REG_PHY_RXFD_REG09_FCB_NDATA_SHIFT    8
#define REG_PHY_RXFD_REG09_FCB_NDATA_WIDTH    7

/* PHY_RXFD_REG09_NCB_NDATA */
/* non channel bonding - number of data bins */
#define REG_PHY_RXFD_REG09_NCB_NDATA          0x00024
#define REG_PHY_RXFD_REG09_NCB_NDATA_MASK     0x007F0000
#define REG_PHY_RXFD_REG09_NCB_NDATA_SHIFT    16
#define REG_PHY_RXFD_REG09_NCB_NDATA_WIDTH    7

/* PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE */
/* phase init mode */
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE          0x00028
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_MASK     0x00000030
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_SHIFT    4
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_WIDTH    2

/* PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE */
/* timing init mode */
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE          0x00028
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_MASK     0x00000300
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_SHIFT    8
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_WIDTH    2

/* PHY_RXFD_REG0A_FT_ENABLE */
/* frequency tracking enable */
#define REG_PHY_RXFD_REG0A_FT_ENABLE          0x00028
#define REG_PHY_RXFD_REG0A_FT_ENABLE_MASK     0x00001000
#define REG_PHY_RXFD_REG0A_FT_ENABLE_SHIFT    12
#define REG_PHY_RXFD_REG0A_FT_ENABLE_WIDTH    1

/* PHY_RXFD_REG0A_NUM_OF_SYM_MASK */
/* frequency tracking symbol mask */
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK          0x00028
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_MASK     0x7FF00000
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_SHIFT    20
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_WIDTH    11

/* PHY_RXFD_REG0A_RF_DATA_TYPE */
/* frequency tracking data type */
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE          0x00028
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_MASK     0x80000000
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_SHIFT    31
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_WIDTH    1

/* PHY_RXFD_REG0B_CT_GCLK_DIS */
/* channel tracking gated clock disable */
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS          0x0002C
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_MASK     0x00000001
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_SHIFT    0
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_WIDTH    1

/* PHY_RXFD_REG0B_CT_2_TB_EN */
/* channel (pilot & data) to test bus en (at end of packet) */
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN          0x0002C
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_MASK     0x00000020
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_SHIFT    5
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_WIDTH    1

/* PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_CH_TRK */
/* ct_force_llr_valid_ch_trk */
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_CH_TRK          0x0002C
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_CH_TRK_MASK     0x00000040
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_CH_TRK_SHIFT    6
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_CH_TRK_WIDTH    1

/* PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_NOISE_TRK */
/* ct_force_llr_valid_noise_trk */
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_NOISE_TRK          0x0002C
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_NOISE_TRK_MASK     0x00000080
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_NOISE_TRK_SHIFT    7
#define REG_PHY_RXFD_REG0B_CT_FORCE_LLR_VALID_NOISE_TRK_WIDTH    1

/* PHY_RXFD_REG0B_CT_TX_EQUAL_NORM_MODE */
/* ct_tx_equal_norm_mode */
#define REG_PHY_RXFD_REG0B_CT_TX_EQUAL_NORM_MODE          0x0002C
#define REG_PHY_RXFD_REG0B_CT_TX_EQUAL_NORM_MODE_MASK     0x00000100
#define REG_PHY_RXFD_REG0B_CT_TX_EQUAL_NORM_MODE_SHIFT    8
#define REG_PHY_RXFD_REG0B_CT_TX_EQUAL_NORM_MODE_WIDTH    1

/* PHY_RXFD_REG0B_TONE_ROTATION_EN */
/* tone_rotation_en */
#define REG_PHY_RXFD_REG0B_TONE_ROTATION_EN          0x0002C
#define REG_PHY_RXFD_REG0B_TONE_ROTATION_EN_MASK     0x00000200
#define REG_PHY_RXFD_REG0B_TONE_ROTATION_EN_SHIFT    9
#define REG_PHY_RXFD_REG0B_TONE_ROTATION_EN_WIDTH    1

/* PHY_RXFD_REG0C_TABLE_1_START */
/* channel estimation full channel bonding table start address */
#define REG_PHY_RXFD_REG0C_TABLE_1_START          0x00030
#define REG_PHY_RXFD_REG0C_TABLE_1_START_MASK     0x000001FF
#define REG_PHY_RXFD_REG0C_TABLE_1_START_SHIFT    0
#define REG_PHY_RXFD_REG0C_TABLE_1_START_WIDTH    9

/* PHY_RXFD_REG0D_CE_H0_SET */
/* channel estimation ho coefficients */
#define REG_PHY_RXFD_REG0D_CE_H0_SET          0x00034
#define REG_PHY_RXFD_REG0D_CE_H0_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0D_CE_H0_SET_SHIFT    0
#define REG_PHY_RXFD_REG0D_CE_H0_SET_WIDTH    10

/* PHY_RXFD_REG0D_CE_H1_SET */
/* channel estimation h1 coefficients */
#define REG_PHY_RXFD_REG0D_CE_H1_SET          0x00034
#define REG_PHY_RXFD_REG0D_CE_H1_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0D_CE_H1_SET_SHIFT    16
#define REG_PHY_RXFD_REG0D_CE_H1_SET_WIDTH    10

/* PHY_RXFD_REG0E_CE_H2_SET */
/* channel estimation h2 coefficients */
#define REG_PHY_RXFD_REG0E_CE_H2_SET          0x00038
#define REG_PHY_RXFD_REG0E_CE_H2_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0E_CE_H2_SET_SHIFT    0
#define REG_PHY_RXFD_REG0E_CE_H2_SET_WIDTH    10

/* PHY_RXFD_REG0E_CE_H3_SET */
/* channel estimation h3 coefficients */
#define REG_PHY_RXFD_REG0E_CE_H3_SET          0x00038
#define REG_PHY_RXFD_REG0E_CE_H3_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0E_CE_H3_SET_SHIFT    16
#define REG_PHY_RXFD_REG0E_CE_H3_SET_WIDTH    10

/* PHY_RXFD_REG0F_CE_H4_SET */
/* channel estimation h4 coefficients */
#define REG_PHY_RXFD_REG0F_CE_H4_SET          0x0003C
#define REG_PHY_RXFD_REG0F_CE_H4_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0F_CE_H4_SET_SHIFT    0
#define REG_PHY_RXFD_REG0F_CE_H4_SET_WIDTH    10

/* PHY_RXFD_REG0F_CE_H5_SET */
/* channel estimation h5 coefficients */
#define REG_PHY_RXFD_REG0F_CE_H5_SET          0x0003C
#define REG_PHY_RXFD_REG0F_CE_H5_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0F_CE_H5_SET_SHIFT    16
#define REG_PHY_RXFD_REG0F_CE_H5_SET_WIDTH    10

/* PHY_RXFD_REG10_SLICER_USE_GCLK */
/* if active slicer work with gclk, else bypass slicer gated clock  */
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK          0x00040
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_MASK     0x00000001
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_SHIFT    0
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_WIDTH    1

/* PHY_RXFD_REG10_QR_USE_GCLK */
/* if active QR work with gclk, else bypass QR gated clock  */
#define REG_PHY_RXFD_REG10_QR_USE_GCLK          0x00040
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_MASK     0x00000002
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_SHIFT    1
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_WIDTH    1

/* PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL */
/* long1_scrm_init_val */
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL          0x00044
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_MASK     0x0000007F
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_SHIFT    0
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_WIDTH    7

/* PHY_RXFD_REG11_FCB_PRANK3_MASK_AN0 */
/* fcb_prank3_mask_an0 */
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN0          0x00044
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN0_MASK     0x0000FF00
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN0_SHIFT    8
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG11_FCB_PRANK3_MASK_AN1 */
/* fcb_prank3_mask_an1 */
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN1          0x00044
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN1_SHIFT    16
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG11_FCB_PRANK3_MASK_AN2 */
/* fcb_prank3_mask_an2 */
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN2          0x00044
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN2_SHIFT    16
#define REG_PHY_RXFD_REG11_FCB_PRANK3_MASK_AN2_WIDTH    8

/* PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK */
/* two_band_prank1_mask */
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_MASK     0x000000FF
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_SHIFT    0
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK */
/* long3_fcb_prank1_mask */
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_MASK     0x0000FF00
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_SHIFT    8
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK */
/* long3_ncb_prank1_mask */
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_MASK     0x00FF0000
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_SHIFT    16
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG12_NCB_PRANK3_MASK_AN0 */
/* ncb_prank3_mask_an0 */
#define REG_PHY_RXFD_REG12_NCB_PRANK3_MASK_AN0          0x00048
#define REG_PHY_RXFD_REG12_NCB_PRANK3_MASK_AN0_MASK     0xff000000
#define REG_PHY_RXFD_REG12_NCB_PRANK3_MASK_AN0_SHIFT    24
#define REG_PHY_RXFD_REG12_NCB_PRANK3_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG13_FCB_PRANK1_MASK */
/* fcb_prank1_mask */
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK          0x0004C
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_MASK     0x000000FF
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_SHIFT    0
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG13_NCB_PRANK1_MASK */
/* ncb_prank1_mask */
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK          0x0004C
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_MASK     0x0000FF00
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_SHIFT    8
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG13_NCB_PRANK3_MASK_AN1 */
/* ncb_prank3_mask_an1 */
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN1          0x0004C
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN1_MASK     0x00ff0000
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN1_SHIFT    16
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG13_NCB_PRANK3_MASK_AN2 */
/* ncb_prank3_mask_an2 */
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN2          0x0004C
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN2_MASK     0xff000000
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN2_SHIFT    24
#define REG_PHY_RXFD_REG13_NCB_PRANK3_MASK_AN2_WIDTH    8

/* PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0 */
/* fcb_prank2_mask_an0 */
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0          0x00050
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_MASK     0x000000FF
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_SHIFT    0
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1 */
/* fcb_prank2_mask_an1 */
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1          0x00050
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_SHIFT    8
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0 */
/* ncb_prank2_mask_an0 */
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0          0x00050
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_MASK     0x00FF0000
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_SHIFT    16
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1 */
/* ncb_prank2_mask_an1 */
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1          0x00050
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_MASK     0xFF000000
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_SHIFT    24
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD */
/* td_ht_mode_add */
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_MASK     0x0000000F
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_SHIFT    0
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD */
/* td_legacy_mode_add */
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_MASK     0x000000F0
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_SHIFT    4
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD */
/* td_rank_cp_00_add */
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD */
/* td_rank_cp_01_add */
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_MASK     0x0000F000
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_SHIFT    12
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_LTF3_JUMP_ADD */
/* td_ht_ltf3_jump_add */
#define REG_PHY_RXFD_REG15_TD_HT_LTF3_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_LTF3_JUMP_ADD_MASK     0x000f0000
#define REG_PHY_RXFD_REG15_TD_HT_LTF3_JUMP_ADD_SHIFT    16
#define REG_PHY_RXFD_REG15_TD_HT_LTF3_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_ELTF_SKIP_ADD */
/* td_ht_eltf_skip_addr  */
#define REG_PHY_RXFD_REG15_TD_HT_ELTF_SKIP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_ELTF_SKIP_ADD_MASK     0x00F00000
#define REG_PHY_RXFD_REG15_TD_HT_ELTF_SKIP_ADD_SHIFT    20
#define REG_PHY_RXFD_REG15_TD_HT_ELTF_SKIP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD */
/* td_ht_mode_add */
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_MASK     0x0000000F
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_SHIFT    0
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD */
/* td_legacy_mode_add */
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_MASK     0x000000F0
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_SHIFT    4
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD */
/* extra ltf mode */
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_LTF3_JUMP_ADD */
/* fd_ht_ltf3_jump_add */
#define REG_PHY_RXFD_REG16_FD_HT_LTF3_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_LTF3_JUMP_ADD_MASK     0x0000f000
#define REG_PHY_RXFD_REG16_FD_HT_LTF3_JUMP_ADD_SHIFT    12
#define REG_PHY_RXFD_REG16_FD_HT_LTF3_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LCP */
/* gsm_td_ram_data_sym_type_lcp */
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LCP          0x00058
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LCP_MASK     0x000F0000
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LCP_SHIFT    16
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LCP_WIDTH    4

/* PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_SCP */
/* gsm_td_ram_data_sym_type_scp */
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_SCP          0x00058
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_SCP_MASK     0x00F00000
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_SCP_SHIFT    20
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_SCP_WIDTH    4

/* PHY_RXFD_REG16_CB_HALF_ENABLE */
/* channel bonding half band enable */
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE          0x00058
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_MASK     0x01000000
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_SHIFT    24
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_WIDTH    1

/* PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LEG */
/* gsm_td_ram_data_sym_type_leg */
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LEG          0x00058
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LEG_MASK     0xF0000000
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LEG_SHIFT    28
#define REG_PHY_RXFD_REG16_GSM_TD_RAM_DATA_SYM_TYPE_LEG_WIDTH    4

/* PHY_RXFD_REG1B_GSM_ABORT_THR */
/* gsm_abort_thr */
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR          0x0006C
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_MASK     0x0000FFFF
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_SHIFT    0
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_WIDTH    16

/* PHY_RXFD_REG1C_LEN_TP0 */
/* enable nco output to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP0          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP0_MASK     0x00000007
#define REG_PHY_RXFD_REG1C_LEN_TP0_SHIFT    0
#define REG_PHY_RXFD_REG1C_LEN_TP0_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP1 */
/* enable phase tracking input to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP1          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP1_MASK     0x00000070
#define REG_PHY_RXFD_REG1C_LEN_TP1_SHIFT    4
#define REG_PHY_RXFD_REG1C_LEN_TP1_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP2 */
/* enable phase tracking output to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP2          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP2_MASK     0x00000700
#define REG_PHY_RXFD_REG1C_LEN_TP2_SHIFT    8
#define REG_PHY_RXFD_REG1C_LEN_TP2_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP3 */
/* enable channel to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP3          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP3_MASK     0x00007000
#define REG_PHY_RXFD_REG1C_LEN_TP3_SHIFT    12
#define REG_PHY_RXFD_REG1C_LEN_TP3_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP4 */
/* enable slicer output or fifo_4_2bnad  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP4          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP4_MASK     0x00070000
#define REG_PHY_RXFD_REG1C_LEN_TP4_SHIFT    16
#define REG_PHY_RXFD_REG1C_LEN_TP4_WIDTH    3

/* PHY_RXFD_REG1C_SLICER_2TB */
/* select slicer or fifo to test bus (1- slicer) */
#define REG_PHY_RXFD_REG1C_SLICER_2TB          0x00070
#define REG_PHY_RXFD_REG1C_SLICER_2TB_MASK     0x00080000
#define REG_PHY_RXFD_REG1C_SLICER_2TB_SHIFT    19
#define REG_PHY_RXFD_REG1C_SLICER_2TB_WIDTH    1

/* PHY_RXFD_REG1C_LEN_TP5 */
/* enable timing estimation and csm information  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP5          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP5_MASK     0x00700000
#define REG_PHY_RXFD_REG1C_LEN_TP5_SHIFT    20
#define REG_PHY_RXFD_REG1C_LEN_TP5_WIDTH    3

/* PHY_RXFD_REG1C_TE_ACCUM_2TB */
/* select source to tb unit 5 high: 0 - data from fd_csm 1-timing estimation accumulaotr output */
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB          0x00070
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_MASK     0x00800000
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_SHIFT    23
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_WIDTH    1

/* PHY_RXFD_REG1C_LEN_TP6 */
/* enable gsm information  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP6          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP6_MASK     0x07000000
#define REG_PHY_RXFD_REG1C_LEN_TP6_SHIFT    24
#define REG_PHY_RXFD_REG1C_LEN_TP6_WIDTH    3

/* PHY_RXFD_REG1C_GSM_2_TB_RATE */
/* gsm information strobe rate(+1)  to the test bus */
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE          0x00070
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_MASK     0xF0000000
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_SHIFT    28
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_WIDTH    4

/* PHY_RXFD_REG1D_SPARE_REG */
/* spare register */
#define REG_PHY_RXFD_REG1D_SPARE_REG          0x00074
#define REG_PHY_RXFD_REG1D_SPARE_REG_MASK     0x0000FFFF
#define REG_PHY_RXFD_REG1D_SPARE_REG_SHIFT    0
#define REG_PHY_RXFD_REG1D_SPARE_REG_WIDTH    16

/* PHY_RXFD_REG1E_QR_TB_EN_CSM */
/* qr_tb_en_csm */
#define REG_PHY_RXFD_REG1E_QR_TB_EN_CSM          0x00078
#define REG_PHY_RXFD_REG1E_QR_TB_EN_CSM_MASK     0x00000001
#define REG_PHY_RXFD_REG1E_QR_TB_EN_CSM_SHIFT    0
#define REG_PHY_RXFD_REG1E_QR_TB_EN_CSM_WIDTH    1

/* PHY_RXFD_REG1E_SVD_TB_EN */
/* svd_tb_en */
#define REG_PHY_RXFD_REG1E_SVD_TB_EN          0x00078
#define REG_PHY_RXFD_REG1E_SVD_TB_EN_MASK     0x00000002
#define REG_PHY_RXFD_REG1E_SVD_TB_EN_SHIFT    1
#define REG_PHY_RXFD_REG1E_SVD_TB_EN_WIDTH    1

/* PHY_RXFD_REG1E_COMPRESS_TB_EN */
/* compress_tb_en */
#define REG_PHY_RXFD_REG1E_COMPRESS_TB_EN          0x00078
#define REG_PHY_RXFD_REG1E_COMPRESS_TB_EN_MASK     0x00000004
#define REG_PHY_RXFD_REG1E_COMPRESS_TB_EN_SHIFT    2
#define REG_PHY_RXFD_REG1E_COMPRESS_TB_EN_WIDTH    1

/* PHY_RXFD_REG1E_TB_R_NON_DIAGONAL */
/* tb_r_non_diagonal */
#define REG_PHY_RXFD_REG1E_TB_R_NON_DIAGONAL          0x00078
#define REG_PHY_RXFD_REG1E_TB_R_NON_DIAGONAL_MASK     0x00000008
#define REG_PHY_RXFD_REG1E_TB_R_NON_DIAGONAL_SHIFT    3
#define REG_PHY_RXFD_REG1E_TB_R_NON_DIAGONAL_WIDTH    1

/* PHY_RXFD_REG34_SW_HT_DETECTOR_EN */
/* 1 - force detector output to be as sw_ht_detector_11n */
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN          0x000D0
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_MASK     0x00010000
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_SHIFT    16
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_WIDTH    1

/* PHY_RXFD_REG34_SW_HT_DETECTOR_11N */
/* force ht_detector output :
0 - 11a,
1- 11n */
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N          0x000D0
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_MASK     0x00020000
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_SHIFT    17
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_WIDTH    1

/* PHY_RXFD_REG34_CDD_POLARITY */
/* 00 - bypass
01 - positive
10- negative */
#define REG_PHY_RXFD_REG34_CDD_POLARITY          0x000D0
#define REG_PHY_RXFD_REG34_CDD_POLARITY_MASK     0x000C0000
#define REG_PHY_RXFD_REG34_CDD_POLARITY_SHIFT    18
#define REG_PHY_RXFD_REG34_CDD_POLARITY_WIDTH    2

/* PHY_RXFD_REG34_CE_UPDATE_CH */
/* channel estimation - write back to channel */
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH          0x000D0
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_MASK     0x00200000
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_SHIFT    21
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_WIDTH    1

/* PHY_RXFD_REG34_OLA_MODE */
/* ola mode */
#define REG_PHY_RXFD_REG34_OLA_MODE          0x000D0
#define REG_PHY_RXFD_REG34_OLA_MODE_MASK     0x00400000
#define REG_PHY_RXFD_REG34_OLA_MODE_SHIFT    22
#define REG_PHY_RXFD_REG34_OLA_MODE_WIDTH    1

/* PHY_RXFD_REG34_OLA_FFT_DONE */
/* fft done in ola mode */
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE          0x000D0
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_MASK     0x00800000
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_SHIFT    23
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_WIDTH    1

/* PHY_RXFD_REG34_OLA_SW_FFT_P */
/* ola  mode - switch between the fft */
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P          0x000D0
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_MASK     0x01000000
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_SHIFT    24
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_WIDTH    1

/* PHY_RXFD_REG34_GREENFIELD_DTCTR_EN */
/* enable green field detector */
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN          0x000D0
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_MASK     0x02000000
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_SHIFT    25
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_WIDTH    1

/* PHY_RXFD_REG34_MAC_CONTROL_CHANNEL */
/* mac mips control channel 
0-usb    1-lsb */
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL          0x000D0
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_MASK     0x04000000
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_SHIFT    26
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_WIDTH    1

/* PHY_RXFD_REG34_ENABLE_ERROR_EVENT */
/* enable error event */
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT          0x000D0
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_MASK     0x08000000
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_SHIFT    27
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_WIDTH    1

/* PHY_RXFD_REG35_TABLE_2_START */
/* channel_estimation high throughput non channel bonding mode start address */
#define REG_PHY_RXFD_REG35_TABLE_2_START          0x000D4
#define REG_PHY_RXFD_REG35_TABLE_2_START_MASK     0x000001FF
#define REG_PHY_RXFD_REG35_TABLE_2_START_SHIFT    0
#define REG_PHY_RXFD_REG35_TABLE_2_START_WIDTH    9

/* PHY_RXFD_REG35_TABLE_2_END */
/* channel_estimation high throughput non channel bonding mode end address */
#define REG_PHY_RXFD_REG35_TABLE_2_END          0x000D4
#define REG_PHY_RXFD_REG35_TABLE_2_END_MASK     0x001FF000
#define REG_PHY_RXFD_REG35_TABLE_2_END_SHIFT    12
#define REG_PHY_RXFD_REG35_TABLE_2_END_WIDTH    9

/* PHY_RXFD_REG35_DCMTR_TB_OP_MODE */
/* decimated test bus operation mode:
0 - normal mode (nco output)
1- decimated nco output */
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_SHIFT    21
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE */
/* decimated test bus zipper mode:
all the data directed to one of the test bus */
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_MASK     0x00400000
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_SHIFT    22
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE */
/* decimated test bus data bins rate:
0 - 1/4
1- 1/8 */
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_MASK     0x00800000
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_SHIFT    23
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_SYM_RATE */
/* decimated test bus symbol rate:
0 - 1/1
1- 1/2
2- 1/4 */
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_MASK     0x03000000
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_SHIFT    24
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_WIDTH    2

/* PHY_RXFD_REG36_QR_SW_BIST_START */
/* qr_sw_bist_start */
#define REG_PHY_RXFD_REG36_QR_SW_BIST_START          0x000D8
#define REG_PHY_RXFD_REG36_QR_SW_BIST_START_MASK     0x00080000
#define REG_PHY_RXFD_REG36_QR_SW_BIST_START_SHIFT    19
#define REG_PHY_RXFD_REG36_QR_SW_BIST_START_WIDTH    1

/* PHY_RXFD_REG36_SW_BIST_START */
/* sw_bist_start */
#define REG_PHY_RXFD_REG36_SW_BIST_START          0x000D8
#define REG_PHY_RXFD_REG36_SW_BIST_START_MASK     0x00100000
#define REG_PHY_RXFD_REG36_SW_BIST_START_SHIFT    20
#define REG_PHY_RXFD_REG36_SW_BIST_START_WIDTH    1

/* PHY_RXFD_REG36_CLEAR_RAM_MODE */
/* clear_ram_mode */
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE          0x000D8
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_SHIFT    21
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_WIDTH    1

/* PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL */
/* test_bus_low_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_MASK     0x00c00000
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_SHIFT    22
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL */
/* test_bus_mid_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_MASK     0x03000000
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_SHIFT    24
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL */
/* test_bus_high_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_MASK     0x0c000000
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_SHIFT    26
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG37_SLICER_GCLK_BYPASS */
/* slicer_gclk_bypass */
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS          0x000DC
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_MASK     0xf0000000
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_SHIFT    28
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_WIDTH    4

/* PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD */
/* fd (lsig) next address in case of greenfield (default htsig1) */
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD          0x000E0
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD */
/* fd (htsig2) next address in case of greenfield (default data) */
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD          0x000E0
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_MASK     0x0000F000
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_SHIFT    12
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM */
/* hyp_rxfd_ne_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM */
/* hyp_rxfd_phase_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_MASK     0x00700000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_SHIFT    20
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM */
/* hyp_rxfd_phase_smoothing_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_SHIFT    24
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM */
/* hyp_rxfd_timing_smoothing_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM */
/* hyp_rxfd_data_0_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_SHIFT    0
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM */
/* hyp_rxfd_data_1_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_MASK     0x00000070
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_SHIFT    4
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM */
/* hyp_rxfd_pilot_0_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_SHIFT    8
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM */
/* hyp_rxfd_pilot_1_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_SHIFT    12
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM */
/* hyp_rxfd_fft_0_image_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM */
/* hyp_rxfd_pilot_2_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM */
/* hyp_rxfd_gsm_ram_style_rm */
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM          0x000F0
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_SHIFT    0
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM */
/* hyp_rxfd_data_2_ch_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM */
/* hyp_rxfd_impl_chann_pre_phase_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_SHIFT    24
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM */
/* hyp_rxfd_impl_chann_pre_tx_rx_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_MASK     0x000001ff
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_SHIFT    0
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_WIDTH    9

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_MASK     0x0003fe00
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_SHIFT    9
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_WIDTH    9

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_MASK     0x07fc0000
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_SHIFT    18
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_WIDTH    9

/* PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8 */
/* effective_snr */
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8          0x00100
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_MASK     0x000001ff
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_SHIFT    0
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_WIDTH    9

/* PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_FOR_AVR_REPORT */
/* effective_snr */
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_FOR_AVR_REPORT          0x00100
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_FOR_AVR_REPORT_MASK     0x00000600
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_FOR_AVR_REPORT_SHIFT    9
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_FOR_AVR_REPORT_WIDTH    2

/* PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2N_SUBCARRIER */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2N_SUBCARRIER          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2N_SUBCARRIER_MASK     0x000000FF
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2N_SUBCARRIER_SHIFT    0
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2N_SUBCARRIER_WIDTH    8

/* PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK0          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK0_MASK     0x0000FF00
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK0_SHIFT    8
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK0_WIDTH    8

/* PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK1          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK1_WIDTH    8

/* PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK2          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_LOG2_RANK2_WIDTH    8

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_MASK     0x000000FF
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_WIDTH    8

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_MASK     0x0000FF00
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_SHIFT    8
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_WIDTH    8

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH2_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH2_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH2_RANK0_MASK     0x00FF0000
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH2_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH2_RANK0_WIDTH    8

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH3_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH3_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH3_RANK0_MASK     0xFF000000
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH3_RANK0_SHIFT    24
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH3_RANK0_WIDTH    8

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH4_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH4_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH4_RANK0_MASK     0x000000FF
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH4_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH4_RANK0_WIDTH    8

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH5_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH5_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH5_RANK0_MASK     0x0000FF00
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH5_RANK0_SHIFT    8
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH5_RANK0_WIDTH    8

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH6_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH6_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH6_RANK0_MASK     0x00FF0000
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH6_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH6_RANK0_WIDTH    8

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH7_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH7_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH7_RANK0_MASK     0xFF000000
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH7_RANK0_SHIFT    24
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH7_RANK0_WIDTH    8

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH0_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH0_RANK1          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH0_RANK1_MASK     0x000000FF
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH0_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH0_RANK1_WIDTH    8

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH1_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH1_RANK1          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH1_RANK1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH1_RANK1_SHIFT    8
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH1_RANK1_WIDTH    8

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH2_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH2_RANK1          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH2_RANK1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH2_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH2_RANK1_WIDTH    8

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH3_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH3_RANK1          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH3_RANK1_MASK     0xFF000000
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH3_RANK1_SHIFT    24
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH3_RANK1_WIDTH    8

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH4_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH4_RANK1          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH4_RANK1_MASK     0x000000FF
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH4_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH4_RANK1_WIDTH    8

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH5_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH5_RANK1          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH5_RANK1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH5_RANK1_SHIFT    8
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH5_RANK1_WIDTH    8

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK1          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK1_WIDTH    8

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK1          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK1_MASK     0xFF000000
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK1_SHIFT    24
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK1_WIDTH    8

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH8_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH8_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH8_RANK1_MASK     0x000000FF
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH8_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH8_RANK1_WIDTH    8

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH9_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH9_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH9_RANK1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH9_RANK1_SHIFT    8
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH9_RANK1_WIDTH    8

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH10_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH10_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH10_RANK1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH10_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH10_RANK1_WIDTH    8

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH11_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH11_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH11_RANK1_MASK     0xFF000000
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH11_RANK1_SHIFT    24
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH11_RANK1_WIDTH    8

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH12_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH12_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH12_RANK1_MASK     0x000000FF
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH12_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH12_RANK1_WIDTH    8

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH13_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH13_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH13_RANK1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH13_RANK1_SHIFT    8
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH13_RANK1_WIDTH    8

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH14_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH14_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH14_RANK1_MASK     0x00FF0000
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH14_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH14_RANK1_WIDTH    8

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH15_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH15_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH15_RANK1_MASK     0xFF000000
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH15_RANK1_SHIFT    24
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH15_RANK1_WIDTH    8

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH0_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH0_RANK2          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH0_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH0_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH0_RANK2_WIDTH    8

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH1_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH1_RANK2          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH1_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH1_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH1_RANK2_WIDTH    8

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH2_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH2_RANK2          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH2_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH2_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH2_RANK2_WIDTH    8

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH3_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH3_RANK2          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH3_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH3_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH3_RANK2_WIDTH    8

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH4_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH4_RANK2          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH4_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH4_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH4_RANK2_WIDTH    8

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH5_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH5_RANK2          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH5_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH5_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH5_RANK2_WIDTH    8

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK2          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK2_WIDTH    8

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK2          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK2_WIDTH    8

/* PHY_RXFD_REG4A_EFFECTIVE_SNR_TH8_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH8_RANK2          0x00128
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH8_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH8_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH8_RANK2_WIDTH    8

/* PHY_RXFD_REG4A_EFFECTIVE_SNR_TH9_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH9_RANK2          0x00128
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH9_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH9_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH9_RANK2_WIDTH    8

/* PHY_RXFD_REG4A_EFFECTIVE_SNR_TH10_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH10_RANK2          0x00128
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH10_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH10_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH10_RANK2_WIDTH    8

/* PHY_RXFD_REG4A_EFFECTIVE_SNR_TH11_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH11_RANK2          0x00128
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH11_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH11_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG4A_EFFECTIVE_SNR_TH11_RANK2_WIDTH    8

/* PHY_RXFD_REG4B_EFFECTIVE_SNR_TH12_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH12_RANK2          0x0012C
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH12_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH12_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH12_RANK2_WIDTH    8

/* PHY_RXFD_REG4B_EFFECTIVE_SNR_TH13_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH13_RANK2          0x0012C
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH13_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH13_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH13_RANK2_WIDTH    8

/* PHY_RXFD_REG4B_EFFECTIVE_SNR_TH14_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH14_RANK2          0x0012C
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH14_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH14_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH14_RANK2_WIDTH    8

/* PHY_RXFD_REG4B_EFFECTIVE_SNR_TH15_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH15_RANK2          0x0012C
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH15_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH15_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG4B_EFFECTIVE_SNR_TH15_RANK2_WIDTH    8

/* PHY_RXFD_REG4C_EFFECTIVE_SNR_TH16_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH16_RANK2          0x00130
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH16_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH16_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH16_RANK2_WIDTH    8

/* PHY_RXFD_REG4C_EFFECTIVE_SNR_TH17_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH17_RANK2          0x00130
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH17_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH17_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH17_RANK2_WIDTH    8

/* PHY_RXFD_REG4C_EFFECTIVE_SNR_TH18_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH18_RANK2          0x00130
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH18_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH18_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH18_RANK2_WIDTH    8

/* PHY_RXFD_REG4C_EFFECTIVE_SNR_TH19_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH19_RANK2          0x00130
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH19_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH19_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG4C_EFFECTIVE_SNR_TH19_RANK2_WIDTH    8

/* PHY_RXFD_REG4D_EFFECTIVE_SNR_TH20_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH20_RANK2          0x00134
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH20_RANK2_MASK     0x000000FF
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH20_RANK2_SHIFT    0
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH20_RANK2_WIDTH    8

/* PHY_RXFD_REG4D_EFFECTIVE_SNR_TH21_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH21_RANK2          0x00134
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH21_RANK2_MASK     0x0000FF00
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH21_RANK2_SHIFT    8
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH21_RANK2_WIDTH    8

/* PHY_RXFD_REG4D_EFFECTIVE_SNR_TH22_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH22_RANK2          0x00134
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH22_RANK2_MASK     0x00FF0000
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH22_RANK2_SHIFT    16
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH22_RANK2_WIDTH    8

/* PHY_RXFD_REG4D_EFFECTIVE_SNR_TH23_RANK2 */
/* effective_snr */
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH23_RANK2          0x00134
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH23_RANK2_MASK     0xFF000000
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH23_RANK2_SHIFT    24
#define REG_PHY_RXFD_REG4D_EFFECTIVE_SNR_TH23_RANK2_WIDTH    8

/* PHY_RXFD_REG4E_EFFECTIVE_SNR_GCLK_BYPASS */
/* effective_snr_gclk_bypass */
#define REG_PHY_RXFD_REG4E_EFFECTIVE_SNR_GCLK_BYPASS          0x00138
#define REG_PHY_RXFD_REG4E_EFFECTIVE_SNR_GCLK_BYPASS_MASK     0x00000001
#define REG_PHY_RXFD_REG4E_EFFECTIVE_SNR_GCLK_BYPASS_SHIFT    0
#define REG_PHY_RXFD_REG4E_EFFECTIVE_SNR_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG4E_BF_RX_PARSER_GCLK_BYPASS */
/* bf_rx_parser_gclk_bypass */
#define REG_PHY_RXFD_REG4E_BF_RX_PARSER_GCLK_BYPASS          0x00138
#define REG_PHY_RXFD_REG4E_BF_RX_PARSER_GCLK_BYPASS_MASK     0x00000002
#define REG_PHY_RXFD_REG4E_BF_RX_PARSER_GCLK_BYPASS_SHIFT    1
#define REG_PHY_RXFD_REG4E_BF_RX_PARSER_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG4E_IMPL_CHANN_PRE_GCLK_BYPASS */
/* impl_chann_pre_gclk_bypass */
#define REG_PHY_RXFD_REG4E_IMPL_CHANN_PRE_GCLK_BYPASS          0x00138
#define REG_PHY_RXFD_REG4E_IMPL_CHANN_PRE_GCLK_BYPASS_MASK     0x80000000
#define REG_PHY_RXFD_REG4E_IMPL_CHANN_PRE_GCLK_BYPASS_SHIFT    31
#define REG_PHY_RXFD_REG4E_IMPL_CHANN_PRE_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG4F_AVG_SNR_ADD_FACTOR */
/* avg_snr_add_factor */
#define REG_PHY_RXFD_REG4F_AVG_SNR_ADD_FACTOR          0x0013C
#define REG_PHY_RXFD_REG4F_AVG_SNR_ADD_FACTOR_MASK     0x000003ff
#define REG_PHY_RXFD_REG4F_AVG_SNR_ADD_FACTOR_SHIFT    0
#define REG_PHY_RXFD_REG4F_AVG_SNR_ADD_FACTOR_WIDTH    10

/* PHY_RXFD_REG4F_AVG_SNR_MULT_FACTOR */
/* avg_snr_mult_factor */
#define REG_PHY_RXFD_REG4F_AVG_SNR_MULT_FACTOR          0x0013C
#define REG_PHY_RXFD_REG4F_AVG_SNR_MULT_FACTOR_MASK     0x03fff000
#define REG_PHY_RXFD_REG4F_AVG_SNR_MULT_FACTOR_SHIFT    12
#define REG_PHY_RXFD_REG4F_AVG_SNR_MULT_FACTOR_WIDTH    14

/* PHY_RXFD_REG4F_EFFECTIVE_SNR_S_SCALE */
/* effective_snr_s_scale */
#define REG_PHY_RXFD_REG4F_EFFECTIVE_SNR_S_SCALE          0x0013C
#define REG_PHY_RXFD_REG4F_EFFECTIVE_SNR_S_SCALE_MASK     0x10000000
#define REG_PHY_RXFD_REG4F_EFFECTIVE_SNR_S_SCALE_SHIFT    28
#define REG_PHY_RXFD_REG4F_EFFECTIVE_SNR_S_SCALE_WIDTH    1

/* PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_2 */
/* compressed_fourier_phase_2 */
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_2          0x00140
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_2_MASK     0x00003FFF
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_2_SHIFT    0
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_2_WIDTH    14

/* PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_3 */
/* compressed_fourier_phase_3 */
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_3          0x00140
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_3_MASK     0x3FFF0000
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_3_SHIFT    16
#define REG_PHY_RXFD_REG50_COMPRESSED_FOURIER_PHASE_3_WIDTH    14

/* PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_4 */
/* compressed_fourier_phase_4 */
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_4          0x00144
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_4_MASK     0x00003FFF
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_4_SHIFT    0
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_4_WIDTH    14

/* PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_5 */
/* compressed_fourier_phase_5 */
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_5          0x00144
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_5_MASK     0x3FFF0000
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_5_SHIFT    16
#define REG_PHY_RXFD_REG51_COMPRESSED_FOURIER_PHASE_5_WIDTH    14

/* PHY_RXFD_REG52_QR_START_COUNTER */
/* qr_start_counter */
#define REG_PHY_RXFD_REG52_QR_START_COUNTER          0x00148
#define REG_PHY_RXFD_REG52_QR_START_COUNTER_MASK     0x000001ff
#define REG_PHY_RXFD_REG52_QR_START_COUNTER_SHIFT    0
#define REG_PHY_RXFD_REG52_QR_START_COUNTER_WIDTH    9

/* PHY_RXFD_REG52_CSM_ACTIVATE_QR_SIG_SYM_THR */
/* csm_activate_qr_sig_sym_thr */
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_SIG_SYM_THR          0x00148
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_SIG_SYM_THR_MASK     0x000ff800
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_SIG_SYM_THR_SHIFT    11
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_SIG_SYM_THR_WIDTH    9

/* PHY_RXFD_REG52_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_NCB  */
/* csm_activate_qr_data_sym_thr_lcp_ncb  */
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_NCB           0x00148
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_NCB _MASK     0x1ff00000
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_NCB _SHIFT    20
#define REG_PHY_RXFD_REG52_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_NCB _WIDTH    9

/* PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_FCB  */
/* csm_activate_qr_data_sym_thr_lcp_fcb  */
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_FCB           0x0014C
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_FCB _MASK     0x000001ff
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_FCB _SHIFT    0
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_LCP_FCB _WIDTH    9

/* PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_FCB  */
/* csm_activate_qr_data_sym_thr_scp_fcb  */
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_FCB           0x0014C
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_FCB _MASK     0x000ff800
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_FCB _SHIFT    11
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_FCB _WIDTH    9

/* PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_NCB  */
/* csm_activate_qr_data_sym_thr_scp_ncb  */
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_NCB           0x0014C
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_NCB _MASK     0x1ff00000
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_NCB _SHIFT    20
#define REG_PHY_RXFD_REG53_CSM_ACTIVATE_QR_DATA_SYM_THR_SCP_NCB _WIDTH    9

/* PHY_RXFD_REG54_QR_START_ADDR_STBC */
/* qr_start_addr_stbc */
#define REG_PHY_RXFD_REG54_QR_START_ADDR_STBC          0x00150
#define REG_PHY_RXFD_REG54_QR_START_ADDR_STBC_MASK     0x000001ff
#define REG_PHY_RXFD_REG54_QR_START_ADDR_STBC_SHIFT    0
#define REG_PHY_RXFD_REG54_QR_START_ADDR_STBC_WIDTH    9

/* PHY_RXFD_REG54_QR_END_ADDR_STBC */
/* qr_end_addr_stbc */
#define REG_PHY_RXFD_REG54_QR_END_ADDR_STBC          0x00150
#define REG_PHY_RXFD_REG54_QR_END_ADDR_STBC_MASK     0x000ff800
#define REG_PHY_RXFD_REG54_QR_END_ADDR_STBC_SHIFT    11
#define REG_PHY_RXFD_REG54_QR_END_ADDR_STBC_WIDTH    9

/* PHY_RXFD_REG54_QAPPLY_START_ADDR_STBC */
/* qapply_start_addr_stbc */
#define REG_PHY_RXFD_REG54_QAPPLY_START_ADDR_STBC          0x00150
#define REG_PHY_RXFD_REG54_QAPPLY_START_ADDR_STBC_MASK     0x1ff00000
#define REG_PHY_RXFD_REG54_QAPPLY_START_ADDR_STBC_SHIFT    20
#define REG_PHY_RXFD_REG54_QAPPLY_START_ADDR_STBC_WIDTH    9

/* PHY_RXFD_REG55_QAPPLY_END_ADDR_STBC */
/* qapply_end_addr_stbc */
#define REG_PHY_RXFD_REG55_QAPPLY_END_ADDR_STBC          0x00154
#define REG_PHY_RXFD_REG55_QAPPLY_END_ADDR_STBC_MASK     0x000001ff
#define REG_PHY_RXFD_REG55_QAPPLY_END_ADDR_STBC_SHIFT    0
#define REG_PHY_RXFD_REG55_QAPPLY_END_ADDR_STBC_WIDTH    9

/* PHY_RXFD_REG55_QR_START_ADDR_LAST_STBC */
/* qr_start_addr_last_stbc */
#define REG_PHY_RXFD_REG55_QR_START_ADDR_LAST_STBC          0x00154
#define REG_PHY_RXFD_REG55_QR_START_ADDR_LAST_STBC_MASK     0x000ff800
#define REG_PHY_RXFD_REG55_QR_START_ADDR_LAST_STBC_SHIFT    11
#define REG_PHY_RXFD_REG55_QR_START_ADDR_LAST_STBC_WIDTH    9

/* PHY_RXFD_REG55_QR_END_ADDR_LAST_STBC */
/* qr_end_addr_last_stbc */
#define REG_PHY_RXFD_REG55_QR_END_ADDR_LAST_STBC          0x00154
#define REG_PHY_RXFD_REG55_QR_END_ADDR_LAST_STBC_MASK     0x1ff00000
#define REG_PHY_RXFD_REG55_QR_END_ADDR_LAST_STBC_SHIFT    20
#define REG_PHY_RXFD_REG55_QR_END_ADDR_LAST_STBC_WIDTH    9

/* PHY_RXFD_REG56_QAPPLY_START_ADDR_LAST_STBC */
/* qapply_start_addr_last_stbc */
#define REG_PHY_RXFD_REG56_QAPPLY_START_ADDR_LAST_STBC          0x00158
#define REG_PHY_RXFD_REG56_QAPPLY_START_ADDR_LAST_STBC_MASK     0x000001ff
#define REG_PHY_RXFD_REG56_QAPPLY_START_ADDR_LAST_STBC_SHIFT    0
#define REG_PHY_RXFD_REG56_QAPPLY_START_ADDR_LAST_STBC_WIDTH    9

/* PHY_RXFD_REG56_QAPPLY_END_ADDR_LAST_STBC */
/* qapply_end_addr_last_stbc */
#define REG_PHY_RXFD_REG56_QAPPLY_END_ADDR_LAST_STBC          0x00158
#define REG_PHY_RXFD_REG56_QAPPLY_END_ADDR_LAST_STBC_MASK     0x000ff800
#define REG_PHY_RXFD_REG56_QAPPLY_END_ADDR_LAST_STBC_SHIFT    11
#define REG_PHY_RXFD_REG56_QAPPLY_END_ADDR_LAST_STBC_WIDTH    9

/* PHY_RXFD_REG56_FIRST_QR_STBC_TIM_OFSET */
/* delay_value_of_first_stbc_qr  */
#define REG_PHY_RXFD_REG56_FIRST_QR_STBC_TIM_OFSET          0x00158
#define REG_PHY_RXFD_REG56_FIRST_QR_STBC_TIM_OFSET_MASK     0x03f00000
#define REG_PHY_RXFD_REG56_FIRST_QR_STBC_TIM_OFSET_SHIFT    20
#define REG_PHY_RXFD_REG56_FIRST_QR_STBC_TIM_OFSET_WIDTH    6

/* PHY_RXFD_REG57_BF_RX_PARSER_FB */
/* bf_rx_parser_fb */
#define REG_PHY_RXFD_REG57_BF_RX_PARSER_FB          0x0015C
#define REG_PHY_RXFD_REG57_BF_RX_PARSER_FB_MASK     0x00000003
#define REG_PHY_RXFD_REG57_BF_RX_PARSER_FB_SHIFT    0
#define REG_PHY_RXFD_REG57_BF_RX_PARSER_FB_WIDTH    2

/* PHY_RXFD_REG57_CHANNEL_ESTIMATION_USE_3LTFS */
/* channel_estimation_use_3ltfs */
#define REG_PHY_RXFD_REG57_CHANNEL_ESTIMATION_USE_3LTFS          0x0015C
#define REG_PHY_RXFD_REG57_CHANNEL_ESTIMATION_USE_3LTFS_MASK     0x00000004
#define REG_PHY_RXFD_REG57_CHANNEL_ESTIMATION_USE_3LTFS_SHIFT    2
#define REG_PHY_RXFD_REG57_CHANNEL_ESTIMATION_USE_3LTFS_WIDTH    1

/* PHY_RXFD_REG68_NUM_OF_LNA_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_MASK     0x00000003
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_SHIFT    0
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_WIDTH    2

/* PHY_RXFD_REG68_NUM_OF_PGC1_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_MASK     0x000000fc
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_SHIFT    2
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_WIDTH    6

/* PHY_RXFD_REG68_NUM_OF_PGC2_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_MASK     0x00003f00
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_SHIFT    8
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_WIDTH    6

/* PHY_RXFD_REG68_NUM_OF_PGC3_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_MASK     0x000fc000
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_SHIFT    14
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_WIDTH    6

/* PHY_RXFD_REG73_QR_GCLK_DISABLE */
/* qr_gclk_disable */
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE          0x001CC
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_MASK     0x0000007f
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_SHIFT    0
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_WIDTH    7

/* PHY_RXFD_REG73_SLICER_GCLK_DISABLE */
/* slicer_gclk_disable */
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE          0x001CC
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_MASK     0x00ffff80
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_SHIFT    7
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_WIDTH    17

/* PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE */
/* hyp_rxfd_gclk_disable */
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE          0x001D0
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_MASK     0x0003fffe
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_SHIFT    1
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_WIDTH    17

/* PHY_RXFD_REG74_MEM_GLOBAL_RM */
/* mem_global_rm */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_MASK     0x000c0000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_SHIFT    18
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_WIDTH    2

/* PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS */
/* mem_global_bist_scr_bypass */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_MASK     0x00100000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_SHIFT    20
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_WIDTH    1

/* PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE */
/* mem_global_ram_test_mode */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_SHIFT    21
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_WIDTH    1

/* PHY_RXFD_REG75_NOISE_TRK_ALPHA_FIRST */
/* noise_trk_alpha_first */
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_FIRST          0x001D4
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_FIRST_MASK     0x00000007
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_FIRST_SHIFT    0
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_FIRST_WIDTH    3

/* PHY_RXFD_REG75_NOISE_TRK_ALPHA_SECOND */
/* noise_trk_alpha_second */
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_SECOND          0x001D4
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_SECOND_MASK     0x00000070
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_SECOND_SHIFT    4
#define REG_PHY_RXFD_REG75_NOISE_TRK_ALPHA_SECOND_WIDTH    3

/* PHY_RXFD_REG75_NOISE_TRK_BYPASS_DATA */
/* noise_trk_bypass_data */
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_DATA          0x001D4
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_DATA_MASK     0x00040000
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_DATA_SHIFT    18
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_DATA_WIDTH    1

/* PHY_RXFD_REG75_NOISE_TRK_BYPASS_SIG */
/* noise_trk_bypass_sig */
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_SIG          0x001D4
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_SIG_MASK     0x00080000
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_SIG_SHIFT    19
#define REG_PHY_RXFD_REG75_NOISE_TRK_BYPASS_SIG_WIDTH    1

/* PHY_RXFD_REG76_QR_GC0_PM_RM_VALUE */
/* qr_gc0_pm_rm_value */
#define REG_PHY_RXFD_REG76_QR_GC0_PM_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_GC0_PM_RM_VALUE_MASK     0x00000007
#define REG_PHY_RXFD_REG76_QR_GC0_PM_RM_VALUE_SHIFT    0
#define REG_PHY_RXFD_REG76_QR_GC0_PM_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_GC1_PM_RM_VALUE */
/* qr_gc1_pm_rm_value */
#define REG_PHY_RXFD_REG76_QR_GC1_PM_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_GC1_PM_RM_VALUE_MASK     0x00000070
#define REG_PHY_RXFD_REG76_QR_GC1_PM_RM_VALUE_SHIFT    4
#define REG_PHY_RXFD_REG76_QR_GC1_PM_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_0_MEM_0_RM_VALUE */
/* qr_h_mems_0_mem_0_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_0_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_0_RM_VALUE_MASK     0x00000700
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_0_RM_VALUE_SHIFT    8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_0_MEM_1_RM_VALUE */
/* qr_h_mems_0_mem_0_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_1_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_1_RM_VALUE_MASK     0x00007000
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_1_RM_VALUE_SHIFT    12
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_0_MEM_2_RM_VALUE */
/* qr_h_mems_0_mem_2_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_2_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_2_RM_VALUE_MASK     0x00070000
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_2_RM_VALUE_SHIFT    16
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_2_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_0_MEM_3_RM_VALUE */
/* qr_h_mems_0_mem_3_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_3_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_3_RM_VALUE_MASK     0x00700000
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_3_RM_VALUE_SHIFT    20
#define REG_PHY_RXFD_REG76_QR_H_MEMS_0_MEM_3_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_1_MEM_0_RM_VALUE */
/* qr_h_mems_1_mem_0_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_0_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_0_RM_VALUE_MASK     0x07000000
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_0_RM_VALUE_SHIFT    24
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG76_QR_H_MEMS_1_MEM_1_RM_VALUE */
/* qr_h_mems_1_mem_1_rm_value */
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_1_RM_VALUE          0x001D8
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_1_RM_VALUE_MASK     0x70000000
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_1_RM_VALUE_SHIFT    28
#define REG_PHY_RXFD_REG76_QR_H_MEMS_1_MEM_1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_1_MEM_2_RM_VALUE */
/* qr_h_mems_1_mem_2_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_2_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_2_RM_VALUE_MASK     0x00000007
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_2_RM_VALUE_SHIFT    0
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_2_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_1_MEM_3_RM_VALUE */
/* qr_h_mems_1_mem_3_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_3_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_3_RM_VALUE_MASK     0x00000070
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_3_RM_VALUE_SHIFT    4
#define REG_PHY_RXFD_REG77_QR_H_MEMS_1_MEM_3_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_2_MEM_0_RM_VALUE */
/* qr_h_mems_2_mem_0_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_0_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_0_RM_VALUE_MASK     0x00000700
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_0_RM_VALUE_SHIFT    8
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_2_MEM_1_RM_VALUE */
/* qr_h_mems_2_mem_1_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_1_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_1_RM_VALUE_MASK     0x00007000
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_1_RM_VALUE_SHIFT    12
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_2_MEM_2_RM_VALUE */
/* qr_h_mems_2_mem_2_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_2_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_2_RM_VALUE_MASK     0x00070000
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_2_RM_VALUE_SHIFT    16
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_2_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_H_MEMS_2_MEM_3_RM_VALUE */
/* qr_h_mems_2_mem_3_rm_value */
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_3_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_3_RM_VALUE_MASK     0x00700000
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_3_RM_VALUE_SHIFT    20
#define REG_PHY_RXFD_REG77_QR_H_MEMS_2_MEM_3_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_Q_MEMS_0_MEM0_RM_VALUE */
/* qr_q_mems_0_mem0_rm_value */
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM0_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM0_RM_VALUE_MASK     0x07000000
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM0_RM_VALUE_SHIFT    24
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG77_QR_Q_MEMS_0_MEM1_RM_VALUE */
/* qr_q_mems_0_mem1_rm_value */
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM1_RM_VALUE          0x001DC
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM1_RM_VALUE_MASK     0x70000000
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM1_RM_VALUE_SHIFT    28
#define REG_PHY_RXFD_REG77_QR_Q_MEMS_0_MEM1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_Q_MEMS_1_MEM0_RM_VALUE */
/* qr_q_mems_1_mem0_rm_value */
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM0_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM0_RM_VALUE_MASK     0x00000007
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM0_RM_VALUE_SHIFT    0
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_Q_MEMS_1_MEM1_RM_VALUE */
/* qr_q_mems_1_mem1_rm_value */
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM1_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM1_RM_VALUE_MASK     0x00000070
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM1_RM_VALUE_SHIFT    4
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_1_MEM1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_Q_MEMS_2_MEM0_RM_VALUE */
/* qr_q_mems_2_mem0_rm_value */
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM0_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM0_RM_VALUE_MASK     0x00000700
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM0_RM_VALUE_SHIFT    8
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM0_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_Q_MEMS_2_MEM1_RM_VALUE */
/* qr_q_mems_2_mem1_rm_value */
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM1_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM1_RM_VALUE_MASK     0x00007000
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM1_RM_VALUE_SHIFT    12
#define REG_PHY_RXFD_REG78_QR_Q_MEMS_2_MEM1_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_SPHERE_IF_MEM_RM_VALUE */
/* qr_sphere_if_mem_rm_value */
#define REG_PHY_RXFD_REG78_QR_SPHERE_IF_MEM_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_SPHERE_IF_MEM_RM_VALUE_MASK     0x00070000
#define REG_PHY_RXFD_REG78_QR_SPHERE_IF_MEM_RM_VALUE_SHIFT    16
#define REG_PHY_RXFD_REG78_QR_SPHERE_IF_MEM_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG78_QR_SORT_MEM_RM_VALUE */
/* qr_sort_mem_rm_value */
#define REG_PHY_RXFD_REG78_QR_SORT_MEM_RM_VALUE          0x001E0
#define REG_PHY_RXFD_REG78_QR_SORT_MEM_RM_VALUE_MASK     0x00700000
#define REG_PHY_RXFD_REG78_QR_SORT_MEM_RM_VALUE_SHIFT    20
#define REG_PHY_RXFD_REG78_QR_SORT_MEM_RM_VALUE_WIDTH    3

/* PHY_RXFD_REG79_QR_START_ADDR */
/* qr_start_addr */
#define REG_PHY_RXFD_REG79_QR_START_ADDR          0x001E4
#define REG_PHY_RXFD_REG79_QR_START_ADDR_MASK     0x000001ff
#define REG_PHY_RXFD_REG79_QR_START_ADDR_SHIFT    0
#define REG_PHY_RXFD_REG79_QR_START_ADDR_WIDTH    9

/* PHY_RXFD_REG79_QR_END_ADDR */
/* qr_end_addr */
#define REG_PHY_RXFD_REG79_QR_END_ADDR          0x001E4
#define REG_PHY_RXFD_REG79_QR_END_ADDR_MASK     0x000ff800
#define REG_PHY_RXFD_REG79_QR_END_ADDR_SHIFT    11
#define REG_PHY_RXFD_REG79_QR_END_ADDR_WIDTH    9

/* PHY_RXFD_REG79_QAPPLY_START_ADDR */
/* qapply_start_addr */
#define REG_PHY_RXFD_REG79_QAPPLY_START_ADDR          0x001E4
#define REG_PHY_RXFD_REG79_QAPPLY_START_ADDR_MASK     0x1ff00000
#define REG_PHY_RXFD_REG79_QAPPLY_START_ADDR_SHIFT    20
#define REG_PHY_RXFD_REG79_QAPPLY_START_ADDR_WIDTH    9

/* PHY_RXFD_REG7A_QAPPLY_END_ADDR */
/* qapply_end_addr */
#define REG_PHY_RXFD_REG7A_QAPPLY_END_ADDR          0x001E8
#define REG_PHY_RXFD_REG7A_QAPPLY_END_ADDR_MASK     0x000001ff
#define REG_PHY_RXFD_REG7A_QAPPLY_END_ADDR_SHIFT    0
#define REG_PHY_RXFD_REG7A_QAPPLY_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7A_SVD_START_ADDR_IMPLICIT */
/* svd_start_addr_implicit */
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_IMPLICIT          0x001E8
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_IMPLICIT_MASK     0x000ff800
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_IMPLICIT_SHIFT    11
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_IMPLICIT_WIDTH    9

/* PHY_RXFD_REG7A_SVD_START_ADDR_EXPLICIT */
/* svd_start_addr_explicit */
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_EXPLICIT          0x001E8
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_EXPLICIT_MASK     0x1ff00000
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_EXPLICIT_SHIFT    20
#define REG_PHY_RXFD_REG7A_SVD_START_ADDR_EXPLICIT_WIDTH    9

/* PHY_RXFD_REG7B_SVD_END_ADDR */
/* svd_end_addr  */
#define REG_PHY_RXFD_REG7B_SVD_END_ADDR          0x001EC
#define REG_PHY_RXFD_REG7B_SVD_END_ADDR_MASK     0x000001ff
#define REG_PHY_RXFD_REG7B_SVD_END_ADDR_SHIFT    0
#define REG_PHY_RXFD_REG7B_SVD_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7B_COMPRESS_3ANT_START_ADDR */
/* compress_3ant_start_addr */
#define REG_PHY_RXFD_REG7B_COMPRESS_3ANT_START_ADDR          0x001EC
#define REG_PHY_RXFD_REG7B_COMPRESS_3ANT_START_ADDR_MASK     0x000ff800
#define REG_PHY_RXFD_REG7B_COMPRESS_3ANT_START_ADDR_SHIFT    11
#define REG_PHY_RXFD_REG7B_COMPRESS_3ANT_START_ADDR_WIDTH    9

/* PHY_RXFD_REG7B_COMPRESS_2ANT_START_ADDR */
/* compress_2ant_start_addr */
#define REG_PHY_RXFD_REG7B_COMPRESS_2ANT_START_ADDR          0x001EC
#define REG_PHY_RXFD_REG7B_COMPRESS_2ANT_START_ADDR_MASK     0x1ff00000
#define REG_PHY_RXFD_REG7B_COMPRESS_2ANT_START_ADDR_SHIFT    20
#define REG_PHY_RXFD_REG7B_COMPRESS_2ANT_START_ADDR_WIDTH    9

/* PHY_RXFD_REG7C_COMPRESS_3ANT_END_ADDR */
/* compress_3ant_end_addr */
#define REG_PHY_RXFD_REG7C_COMPRESS_3ANT_END_ADDR          0x001F0
#define REG_PHY_RXFD_REG7C_COMPRESS_3ANT_END_ADDR_MASK     0x000001ff
#define REG_PHY_RXFD_REG7C_COMPRESS_3ANT_END_ADDR_SHIFT    0
#define REG_PHY_RXFD_REG7C_COMPRESS_3ANT_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7C_COMPRESS_2ANT_END_ADDR */
/* compress_2ant_end_addr */
#define REG_PHY_RXFD_REG7C_COMPRESS_2ANT_END_ADDR          0x001F0
#define REG_PHY_RXFD_REG7C_COMPRESS_2ANT_END_ADDR_MASK     0x000ff800
#define REG_PHY_RXFD_REG7C_COMPRESS_2ANT_END_ADDR_SHIFT    11
#define REG_PHY_RXFD_REG7C_COMPRESS_2ANT_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7C_DECOMPRESS_3ANT_START_ADDR */
/* decompress_3ant_start_addr */
#define REG_PHY_RXFD_REG7C_DECOMPRESS_3ANT_START_ADDR          0x001F0
#define REG_PHY_RXFD_REG7C_DECOMPRESS_3ANT_START_ADDR_MASK     0x1ff00000
#define REG_PHY_RXFD_REG7C_DECOMPRESS_3ANT_START_ADDR_SHIFT    20
#define REG_PHY_RXFD_REG7C_DECOMPRESS_3ANT_START_ADDR_WIDTH    9

/* PHY_RXFD_REG7D_DECOMPRESS_2ANT_START_ADDR */
/* decompress_2ant_start_addr */
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_START_ADDR          0x001F4
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_START_ADDR_MASK     0x000001ff
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_START_ADDR_SHIFT    0
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_START_ADDR_WIDTH    9

/* PHY_RXFD_REG7D_DECOMPRESS_3ANT_END_ADDR */
/* decompress_3ant_end_addr */
#define REG_PHY_RXFD_REG7D_DECOMPRESS_3ANT_END_ADDR          0x001F4
#define REG_PHY_RXFD_REG7D_DECOMPRESS_3ANT_END_ADDR_MASK     0x000ff800
#define REG_PHY_RXFD_REG7D_DECOMPRESS_3ANT_END_ADDR_SHIFT    11
#define REG_PHY_RXFD_REG7D_DECOMPRESS_3ANT_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7D_DECOMPRESS_2ANT_END_ADDR */
/* decompress_2ant_end_addr */
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_END_ADDR          0x001F4
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_END_ADDR_MASK     0x1ff00000
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_END_ADDR_SHIFT    20
#define REG_PHY_RXFD_REG7D_DECOMPRESS_2ANT_END_ADDR_WIDTH    9

/* PHY_RXFD_REG7E_QAPPLY_SCP_COUNTER */
/* decompress_2ant_start_addr */
#define REG_PHY_RXFD_REG7E_QAPPLY_SCP_COUNTER          0x001F8
#define REG_PHY_RXFD_REG7E_QAPPLY_SCP_COUNTER_MASK     0x000001ff
#define REG_PHY_RXFD_REG7E_QAPPLY_SCP_COUNTER_SHIFT    0
#define REG_PHY_RXFD_REG7E_QAPPLY_SCP_COUNTER_WIDTH    9

/* PHY_RXFD_REG7E_QAPPLY_LCP_COUNTER */
/* decompress_3ant_end_addr */
#define REG_PHY_RXFD_REG7E_QAPPLY_LCP_COUNTER          0x001F8
#define REG_PHY_RXFD_REG7E_QAPPLY_LCP_COUNTER_MASK     0x000ff800
#define REG_PHY_RXFD_REG7E_QAPPLY_LCP_COUNTER_SHIFT    11
#define REG_PHY_RXFD_REG7E_QAPPLY_LCP_COUNTER_WIDTH    9

/* PHY_RXFD_REG7E_QAPPLY_LEGACY_COUNTER */
/* decompress_2ant_end_addr */
#define REG_PHY_RXFD_REG7E_QAPPLY_LEGACY_COUNTER          0x001F8
#define REG_PHY_RXFD_REG7E_QAPPLY_LEGACY_COUNTER_MASK     0x1ff00000
#define REG_PHY_RXFD_REG7E_QAPPLY_LEGACY_COUNTER_SHIFT    20
#define REG_PHY_RXFD_REG7E_QAPPLY_LEGACY_COUNTER_WIDTH    9

/* PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_0 */
/* compressed_fourier_phase_0 */
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_0          0x001FC
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_0_MASK     0x00003FFF
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_0_SHIFT    0
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_0_WIDTH    14

/* PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_1 */
/* compressed_fourier_phase_1 */
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_1          0x001FC
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_1_MASK     0x3FFF0000
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_1_SHIFT    16
#define REG_PHY_RXFD_REG7F_COMPRESSED_FOURIER_PHASE_1_WIDTH    14
#endif 
