/*******************************************************************
*                                                                   
*  PHY_RX_TD_IF_Risc_Page_0_be.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_TD_IF_Risc_Page_0_be_regs_H_FILE
#define PHY_RX_TD_IF_Risc_Page_0_be_regs_H_FILE

/* PHY_RXBE_IF180_SW_RESET_N_REG */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly. */
#define REG_PHY_RXBE_IF180_SW_RESET_N_REG          0x10600
#define REG_PHY_RXBE_IF180_SW_RESET_N_REG_MASK     0x00000FFF
#define REG_PHY_RXBE_IF180_SW_RESET_N_REG_SHIFT    0
#define REG_PHY_RXBE_IF180_SW_RESET_N_REG_WIDTH    12

/* PHY_RXBE_IF181_BLOCKS_EN */
/* Sub blocks enable. One bit per sub block. Enables or disables the sub block clock.unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly. */
#define REG_PHY_RXBE_IF181_BLOCKS_EN          0x10604
#define REG_PHY_RXBE_IF181_BLOCKS_EN_MASK     0x00000FFF
#define REG_PHY_RXBE_IF181_BLOCKS_EN_SHIFT    0
#define REG_PHY_RXBE_IF181_BLOCKS_EN_WIDTH    12

/* PHY_RXBE_IF182_SW_RESET_GENERATE */
/* A SW reset procedure will be initiated by writing to this register to the bits that equal 1l */
#define REG_PHY_RXBE_IF182_SW_RESET_GENERATE          0x10608
#define REG_PHY_RXBE_IF182_SW_RESET_GENERATE_MASK     0x00000FFF
#define REG_PHY_RXBE_IF182_SW_RESET_GENERATE_SHIFT    0
#define REG_PHY_RXBE_IF182_SW_RESET_GENERATE_WIDTH    12

/* PHY_RXBE_IF183_GSM_SW_RESET_MASK */
/* Which block to software reset after rxbe_enable fall */
#define REG_PHY_RXBE_IF183_GSM_SW_RESET_MASK          0x1060C
#define REG_PHY_RXBE_IF183_GSM_SW_RESET_MASK_MASK     0x00000FFF
#define REG_PHY_RXBE_IF183_GSM_SW_RESET_MASK_SHIFT    0
#define REG_PHY_RXBE_IF183_GSM_SW_RESET_MASK_WIDTH    12

/* PHY_RXBE_IF184_EVM_11B */
/* 11b evm metric */
#define REG_PHY_RXBE_IF184_EVM_11B          0x10610
#define REG_PHY_RXBE_IF184_EVM_11B_MASK     0x000000ff
#define REG_PHY_RXBE_IF184_EVM_11B_SHIFT    0
#define REG_PHY_RXBE_IF184_EVM_11B_WIDTH    8

/* PHY_RXBE_IF184_TX_ANTENNA */
/* preferred Tx antenna for 802.11b frames */
#define REG_PHY_RXBE_IF184_TX_ANTENNA          0x10610
#define REG_PHY_RXBE_IF184_TX_ANTENNA_MASK     0x00000100
#define REG_PHY_RXBE_IF184_TX_ANTENNA_SHIFT    8
#define REG_PHY_RXBE_IF184_TX_ANTENNA_WIDTH    1

/* PHY_RXBE_IF185_ANT1_AD_RSSI */
/* antenna1 ad rssi */
#define REG_PHY_RXBE_IF185_ANT1_AD_RSSI          0x10614
#define REG_PHY_RXBE_IF185_ANT1_AD_RSSI_MASK     0x000000ff
#define REG_PHY_RXBE_IF185_ANT1_AD_RSSI_SHIFT    0
#define REG_PHY_RXBE_IF185_ANT1_AD_RSSI_WIDTH    8

/* PHY_RXBE_IF186_ANT2_AD_RSSI */
/* antenna2 ad rssi */
#define REG_PHY_RXBE_IF186_ANT2_AD_RSSI          0x10618
#define REG_PHY_RXBE_IF186_ANT2_AD_RSSI_MASK     0x000000ff
#define REG_PHY_RXBE_IF186_ANT2_AD_RSSI_SHIFT    0
#define REG_PHY_RXBE_IF186_ANT2_AD_RSSI_WIDTH    8

/* PHY_RXBE_IF187_ANT3_AD_RSSI */
/* antenna3 ad rssi */
#define REG_PHY_RXBE_IF187_ANT3_AD_RSSI          0x1061C
#define REG_PHY_RXBE_IF187_ANT3_AD_RSSI_MASK     0x000000ff
#define REG_PHY_RXBE_IF187_ANT3_AD_RSSI_SHIFT    0
#define REG_PHY_RXBE_IF187_ANT3_AD_RSSI_WIDTH    8

/* PHY_RXBE_IF188_GEN_RISC_SPARE_0 */
/* Gen Risc spare register 0 */
#define REG_PHY_RXBE_IF188_GEN_RISC_SPARE_0          0x10620
#define REG_PHY_RXBE_IF188_GEN_RISC_SPARE_0_MASK     0x0000ffff
#define REG_PHY_RXBE_IF188_GEN_RISC_SPARE_0_SHIFT    0
#define REG_PHY_RXBE_IF188_GEN_RISC_SPARE_0_WIDTH    16

/* PHY_RXBE_IF189_GEN_RISC_SPARE_1 */
/* Gen Risc spare register 1 */
#define REG_PHY_RXBE_IF189_GEN_RISC_SPARE_1          0x10624
#define REG_PHY_RXBE_IF189_GEN_RISC_SPARE_1_MASK     0x0000ffff
#define REG_PHY_RXBE_IF189_GEN_RISC_SPARE_1_SHIFT    0
#define REG_PHY_RXBE_IF189_GEN_RISC_SPARE_1_WIDTH    16

/* PHY_RXBE_IF18A_GEN_RISC_SPARE_2 */
/* Gen Risc spare register 2 */
#define REG_PHY_RXBE_IF18A_GEN_RISC_SPARE_2          0x10628
#define REG_PHY_RXBE_IF18A_GEN_RISC_SPARE_2_MASK     0x0000ffff
#define REG_PHY_RXBE_IF18A_GEN_RISC_SPARE_2_SHIFT    0
#define REG_PHY_RXBE_IF18A_GEN_RISC_SPARE_2_WIDTH    16

/* PHY_RXBE_IF18B_GEN_RISC_SPARE_3 */
/* Gen Risc spare register 3 */
#define REG_PHY_RXBE_IF18B_GEN_RISC_SPARE_3          0x1062C
#define REG_PHY_RXBE_IF18B_GEN_RISC_SPARE_3_MASK     0x0000ffff
#define REG_PHY_RXBE_IF18B_GEN_RISC_SPARE_3_SHIFT    0
#define REG_PHY_RXBE_IF18B_GEN_RISC_SPARE_3_WIDTH    16

/* PHY_RXBE_IF18D_GEN_RISC_SPARE_5_15_0 */
/* Gen Risc spare register 5 bits 15:0 */
#define REG_PHY_RXBE_IF18D_GEN_RISC_SPARE_5_15_0          0x10634
#define REG_PHY_RXBE_IF18D_GEN_RISC_SPARE_5_15_0_MASK     0x0000ffff
#define REG_PHY_RXBE_IF18D_GEN_RISC_SPARE_5_15_0_SHIFT    0
#define REG_PHY_RXBE_IF18D_GEN_RISC_SPARE_5_15_0_WIDTH    16

/* PHY_RXBE_IF18E_GEN_RISC_SPARE_5_31_16 */
/* Gen Risc spare register 5 bits 31:16 */
#define REG_PHY_RXBE_IF18E_GEN_RISC_SPARE_5_31_16          0x10638
#define REG_PHY_RXBE_IF18E_GEN_RISC_SPARE_5_31_16_MASK     0x0000ffff
#define REG_PHY_RXBE_IF18E_GEN_RISC_SPARE_5_31_16_SHIFT    0
#define REG_PHY_RXBE_IF18E_GEN_RISC_SPARE_5_31_16_WIDTH    16

/* PHY_RXBE_IF190_RISC_MODULATION */
/* risc_modulation */
#define REG_PHY_RXBE_IF190_RISC_MODULATION          0x10640
#define REG_PHY_RXBE_IF190_RISC_MODULATION_MASK     0x00000007
#define REG_PHY_RXBE_IF190_RISC_MODULATION_SHIFT    0
#define REG_PHY_RXBE_IF190_RISC_MODULATION_WIDTH    3

/* PHY_RXBE_IF190_RISC_CODE_RATE */
/* risc_code_rate */
#define REG_PHY_RXBE_IF190_RISC_CODE_RATE          0x10640
#define REG_PHY_RXBE_IF190_RISC_CODE_RATE_MASK     0x00000030
#define REG_PHY_RXBE_IF190_RISC_CODE_RATE_SHIFT    4
#define REG_PHY_RXBE_IF190_RISC_CODE_RATE_WIDTH    2

/* PHY_RXBE_IF190_RISC_VITERBI_NES */
/* risc_viterbi_nes */
#define REG_PHY_RXBE_IF190_RISC_VITERBI_NES          0x10640
#define REG_PHY_RXBE_IF190_RISC_VITERBI_NES_MASK     0x00000300
#define REG_PHY_RXBE_IF190_RISC_VITERBI_NES_SHIFT    8
#define REG_PHY_RXBE_IF190_RISC_VITERBI_NES_WIDTH    2

/* PHY_RXBE_IF190_RISC_OVERRIDE */
/* risc_override */
#define REG_PHY_RXBE_IF190_RISC_OVERRIDE          0x10640
#define REG_PHY_RXBE_IF190_RISC_OVERRIDE_MASK     0x00001000
#define REG_PHY_RXBE_IF190_RISC_OVERRIDE_SHIFT    12
#define REG_PHY_RXBE_IF190_RISC_OVERRIDE_WIDTH    1

/* PHY_RXBE_IF190_RISC_MCS_VALID */
/* risc_mcs_valid */
#define REG_PHY_RXBE_IF190_RISC_MCS_VALID          0x10640
#define REG_PHY_RXBE_IF190_RISC_MCS_VALID_MASK     0x00002000
#define REG_PHY_RXBE_IF190_RISC_MCS_VALID_SHIFT    13
#define REG_PHY_RXBE_IF190_RISC_MCS_VALID_WIDTH    1

/* PHY_RXBE_IF192_ANT0_NOISE_EST */
/* antenna0 noise estimation */
#define REG_PHY_RXBE_IF192_ANT0_NOISE_EST          0x10648
#define REG_PHY_RXBE_IF192_ANT0_NOISE_EST_MASK     0x000000ff
#define REG_PHY_RXBE_IF192_ANT0_NOISE_EST_SHIFT    0
#define REG_PHY_RXBE_IF192_ANT0_NOISE_EST_WIDTH    8

/* PHY_RXBE_IF193_ANT1_NOISE_EST */
/* antenna1 noise estimation */
#define REG_PHY_RXBE_IF193_ANT1_NOISE_EST          0x1064C
#define REG_PHY_RXBE_IF193_ANT1_NOISE_EST_MASK     0x000000ff
#define REG_PHY_RXBE_IF193_ANT1_NOISE_EST_SHIFT    0
#define REG_PHY_RXBE_IF193_ANT1_NOISE_EST_WIDTH    8

/* PHY_RXBE_IF194_ANT2_NOISE_EST */
/* antenna2 noise estimation */
#define REG_PHY_RXBE_IF194_ANT2_NOISE_EST          0x10650
#define REG_PHY_RXBE_IF194_ANT2_NOISE_EST_MASK     0x000000ff
#define REG_PHY_RXBE_IF194_ANT2_NOISE_EST_SHIFT    0
#define REG_PHY_RXBE_IF194_ANT2_NOISE_EST_WIDTH    8

/* PHY_RXBE_IF195_RF_FREQ_SFT_LONG */
/* rf frequency shift at long */
#define REG_PHY_RXBE_IF195_RF_FREQ_SFT_LONG          0x10654
#define REG_PHY_RXBE_IF195_RF_FREQ_SFT_LONG_MASK     0x00000fff
#define REG_PHY_RXBE_IF195_RF_FREQ_SFT_LONG_SHIFT    0
#define REG_PHY_RXBE_IF195_RF_FREQ_SFT_LONG_WIDTH    12

/* PHY_RXBE_IF196_RF_FREQ_SFT_PEND */
/* rf frequency shift at packet end */
#define REG_PHY_RXBE_IF196_RF_FREQ_SFT_PEND          0x10658
#define REG_PHY_RXBE_IF196_RF_FREQ_SFT_PEND_MASK     0x00000fff
#define REG_PHY_RXBE_IF196_RF_FREQ_SFT_PEND_SHIFT    0
#define REG_PHY_RXBE_IF196_RF_FREQ_SFT_PEND_WIDTH    12

/* PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER */
/* ldpc_iterations_number */
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER          0x1065C
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_MASK     0x000007ff
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_SHIFT    0
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_WIDTH    11

/* PHY_RXBE_IF197_LDPC_ITERATIONS_STOP_SIGNAL */
/* ldpc_iterations_number */
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_STOP_SIGNAL          0x1065C
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_STOP_SIGNAL_MASK     0x00000800
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_STOP_SIGNAL_SHIFT    11
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_STOP_SIGNAL_WIDTH    1

/* PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_VALID */
/* ldpc iterations number valid (will reset when read) */
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_VALID          0x1065C
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_VALID_MASK     0x00008000
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_VALID_SHIFT    15
#define REG_PHY_RXBE_IF197_LDPC_ITERATIONS_NUMBER_VALID_WIDTH    1

/* PHY_RXBE_IF198_RF_PHASE_NSE */
/* rf phase noise */
#define REG_PHY_RXBE_IF198_RF_PHASE_NSE          0x10660
#define REG_PHY_RXBE_IF198_RF_PHASE_NSE_MASK     0x00000fff
#define REG_PHY_RXBE_IF198_RF_PHASE_NSE_SHIFT    0
#define REG_PHY_RXBE_IF198_RF_PHASE_NSE_WIDTH    12

/* PHY_RXBE_IF199_TIMING_SFT */
/* Timing shift */
#define REG_PHY_RXBE_IF199_TIMING_SFT          0x10664
#define REG_PHY_RXBE_IF199_TIMING_SFT_MASK     0x0000003f
#define REG_PHY_RXBE_IF199_TIMING_SFT_SHIFT    0
#define REG_PHY_RXBE_IF199_TIMING_SFT_WIDTH    6

/* PHY_RXBE_IF19A_ANT1_ACTIVE */
/* antenna1 active */
#define REG_PHY_RXBE_IF19A_ANT1_ACTIVE          0x10668
#define REG_PHY_RXBE_IF19A_ANT1_ACTIVE_MASK     0x00000001
#define REG_PHY_RXBE_IF19A_ANT1_ACTIVE_SHIFT    0
#define REG_PHY_RXBE_IF19A_ANT1_ACTIVE_WIDTH    1

/* PHY_RXBE_IF19A_ANT2_ACTIVE */
/* antenna2 active */
#define REG_PHY_RXBE_IF19A_ANT2_ACTIVE          0x10668
#define REG_PHY_RXBE_IF19A_ANT2_ACTIVE_MASK     0x00000002
#define REG_PHY_RXBE_IF19A_ANT2_ACTIVE_SHIFT    1
#define REG_PHY_RXBE_IF19A_ANT2_ACTIVE_WIDTH    1

/* PHY_RXBE_IF19A_ANT3_ACTIVE */
/* antenna3 active */
#define REG_PHY_RXBE_IF19A_ANT3_ACTIVE          0x10668
#define REG_PHY_RXBE_IF19A_ANT3_ACTIVE_MASK     0x00000004
#define REG_PHY_RXBE_IF19A_ANT3_ACTIVE_SHIFT    2
#define REG_PHY_RXBE_IF19A_ANT3_ACTIVE_WIDTH    1

/* PHY_RXBE_IF19B_A_LENGTH */
/* a length */
#define REG_PHY_RXBE_IF19B_A_LENGTH          0x1066C
#define REG_PHY_RXBE_IF19B_A_LENGTH_MASK     0x00000fff
#define REG_PHY_RXBE_IF19B_A_LENGTH_SHIFT    0
#define REG_PHY_RXBE_IF19B_A_LENGTH_WIDTH    12

/* PHY_RXBE_IF19B_A_RATE */
/* a rate */
#define REG_PHY_RXBE_IF19B_A_RATE          0x1066C
#define REG_PHY_RXBE_IF19B_A_RATE_MASK     0x0000f000
#define REG_PHY_RXBE_IF19B_A_RATE_SHIFT    12
#define REG_PHY_RXBE_IF19B_A_RATE_WIDTH    4

/* PHY_RXBE_IF19C_L_SIG_RESERVED */
/* L-SIG reserved bit */
#define REG_PHY_RXBE_IF19C_L_SIG_RESERVED          0x10670
#define REG_PHY_RXBE_IF19C_L_SIG_RESERVED_MASK     0x00000001
#define REG_PHY_RXBE_IF19C_L_SIG_RESERVED_SHIFT    0
#define REG_PHY_RXBE_IF19C_L_SIG_RESERVED_WIDTH    1

/* PHY_RXBE_IF19C_SIG1_PARITY */
/* signal1 parity */
#define REG_PHY_RXBE_IF19C_SIG1_PARITY          0x10670
#define REG_PHY_RXBE_IF19C_SIG1_PARITY_MASK     0x00000002
#define REG_PHY_RXBE_IF19C_SIG1_PARITY_SHIFT    1
#define REG_PHY_RXBE_IF19C_SIG1_PARITY_WIDTH    1

/* PHY_RXBE_IF19C_SIG1_INFO_VALID */
/* signal1 info valid */
#define REG_PHY_RXBE_IF19C_SIG1_INFO_VALID          0x10670
#define REG_PHY_RXBE_IF19C_SIG1_INFO_VALID_MASK     0x00008000
#define REG_PHY_RXBE_IF19C_SIG1_INFO_VALID_SHIFT    15
#define REG_PHY_RXBE_IF19C_SIG1_INFO_VALID_WIDTH    1

/* PHY_RXBE_IF19D_N_LENGTH */
/* n packet length */
#define REG_PHY_RXBE_IF19D_N_LENGTH          0x10674
#define REG_PHY_RXBE_IF19D_N_LENGTH_MASK     0x0000ffff
#define REG_PHY_RXBE_IF19D_N_LENGTH_SHIFT    0
#define REG_PHY_RXBE_IF19D_N_LENGTH_WIDTH    16

/* PHY_RXBE_IF19E_NSS */
/* Number of spatial streams */
#define REG_PHY_RXBE_IF19E_NSS          0x10678
#define REG_PHY_RXBE_IF19E_NSS_MASK     0x00000030
#define REG_PHY_RXBE_IF19E_NSS_SHIFT    4
#define REG_PHY_RXBE_IF19E_NSS_WIDTH    2

/* PHY_RXBE_IF19E_AGGREGATION */
/* Aggregation */
#define REG_PHY_RXBE_IF19E_AGGREGATION          0x10678
#define REG_PHY_RXBE_IF19E_AGGREGATION_MASK     0x00000200
#define REG_PHY_RXBE_IF19E_AGGREGATION_SHIFT    9
#define REG_PHY_RXBE_IF19E_AGGREGATION_WIDTH    1

/* PHY_RXBE_IF19E_SHORT_GI */
/* short cyclic prefix */
#define REG_PHY_RXBE_IF19E_SHORT_GI          0x10678
#define REG_PHY_RXBE_IF19E_SHORT_GI_MASK     0x00000400
#define REG_PHY_RXBE_IF19E_SHORT_GI_SHIFT    10
#define REG_PHY_RXBE_IF19E_SHORT_GI_WIDTH    1

/* PHY_RXBE_IF19E_FEC_TYPE */
/* fec type */
#define REG_PHY_RXBE_IF19E_FEC_TYPE          0x10678
#define REG_PHY_RXBE_IF19E_FEC_TYPE_MASK     0x00000800
#define REG_PHY_RXBE_IF19E_FEC_TYPE_SHIFT    11
#define REG_PHY_RXBE_IF19E_FEC_TYPE_WIDTH    1

/* PHY_RXBE_IF19E_BW_20_40 */
/* bandwidht of packet:
'0' = nCB (20MHz)
'1' = CB (40MHz) */
#define REG_PHY_RXBE_IF19E_BW_20_40          0x10678
#define REG_PHY_RXBE_IF19E_BW_20_40_MASK     0x00001000
#define REG_PHY_RXBE_IF19E_BW_20_40_SHIFT    12
#define REG_PHY_RXBE_IF19E_BW_20_40_WIDTH    1

/* PHY_RXBE_IF19E_SMOOTHING */
/* Smoothing */
#define REG_PHY_RXBE_IF19E_SMOOTHING          0x10678
#define REG_PHY_RXBE_IF19E_SMOOTHING_MASK     0x00002000
#define REG_PHY_RXBE_IF19E_SMOOTHING_SHIFT    13
#define REG_PHY_RXBE_IF19E_SMOOTHING_WIDTH    1

/* PHY_RXBE_IF19E_SOUNDING */
/* Sounding */
#define REG_PHY_RXBE_IF19E_SOUNDING          0x10678
#define REG_PHY_RXBE_IF19E_SOUNDING_MASK     0x00004000
#define REG_PHY_RXBE_IF19E_SOUNDING_SHIFT    14
#define REG_PHY_RXBE_IF19E_SOUNDING_WIDTH    1

/* PHY_RXBE_IF19E_HT_SIG2_RESERVED */
/* HT-SIG2 reserved bit */
#define REG_PHY_RXBE_IF19E_HT_SIG2_RESERVED          0x10678
#define REG_PHY_RXBE_IF19E_HT_SIG2_RESERVED_MASK     0x00008000
#define REG_PHY_RXBE_IF19E_HT_SIG2_RESERVED_SHIFT    15
#define REG_PHY_RXBE_IF19E_HT_SIG2_RESERVED_WIDTH    1

/* PHY_RXBE_IF19F_CRC_TX */
/* Tx crc */
#define REG_PHY_RXBE_IF19F_CRC_TX          0x1067C
#define REG_PHY_RXBE_IF19F_CRC_TX_MASK     0x000000ff
#define REG_PHY_RXBE_IF19F_CRC_TX_SHIFT    0
#define REG_PHY_RXBE_IF19F_CRC_TX_WIDTH    8

/* PHY_RXBE_IF19F_STBC */
/* STBC - indicates the difference between num of spatial streams and num of spatial mapper input */
#define REG_PHY_RXBE_IF19F_STBC          0x1067C
#define REG_PHY_RXBE_IF19F_STBC_MASK     0x00000300
#define REG_PHY_RXBE_IF19F_STBC_SHIFT    8
#define REG_PHY_RXBE_IF19F_STBC_WIDTH    2

/* PHY_RXBE_IF19F_NUM_HT_LTF */
/* Number of additional HT-LTFs for sounding packets.
'0' = no additional ht-ltfs
'1', '2' = 1 or 2 respectively
'3' = 4 */
#define REG_PHY_RXBE_IF19F_NUM_HT_LTF          0x1067C
#define REG_PHY_RXBE_IF19F_NUM_HT_LTF_MASK     0x00001c00
#define REG_PHY_RXBE_IF19F_NUM_HT_LTF_SHIFT    10
#define REG_PHY_RXBE_IF19F_NUM_HT_LTF_WIDTH    3

/* PHY_RXBE_IF19F_SIG3_INFO_VALID */
/* signal3 info valid */
#define REG_PHY_RXBE_IF19F_SIG3_INFO_VALID          0x1067C
#define REG_PHY_RXBE_IF19F_SIG3_INFO_VALID_MASK     0x00008000
#define REG_PHY_RXBE_IF19F_SIG3_INFO_VALID_SHIFT    15
#define REG_PHY_RXBE_IF19F_SIG3_INFO_VALID_WIDTH    1

/* PHY_RXBE_IF1A0_SIG1_PARITY_ERR */
/* Signal 1 parity Error */
#define REG_PHY_RXBE_IF1A0_SIG1_PARITY_ERR          0x10680
#define REG_PHY_RXBE_IF1A0_SIG1_PARITY_ERR_MASK     0x00000001
#define REG_PHY_RXBE_IF1A0_SIG1_PARITY_ERR_SHIFT    0
#define REG_PHY_RXBE_IF1A0_SIG1_PARITY_ERR_WIDTH    1

/* PHY_RXBE_IF1A0_SIG1_INVALID_RATE */
/* Signal 1 Invalid Rate */
#define REG_PHY_RXBE_IF1A0_SIG1_INVALID_RATE          0x10680
#define REG_PHY_RXBE_IF1A0_SIG1_INVALID_RATE_MASK     0x00000002
#define REG_PHY_RXBE_IF1A0_SIG1_INVALID_RATE_SHIFT    1
#define REG_PHY_RXBE_IF1A0_SIG1_INVALID_RATE_WIDTH    1

/* PHY_RXBE_IF1A0_SIG1_MIN_LENGTH_ERR */
/* Signal 1 minimum length Error */
#define REG_PHY_RXBE_IF1A0_SIG1_MIN_LENGTH_ERR          0x10680
#define REG_PHY_RXBE_IF1A0_SIG1_MIN_LENGTH_ERR_MASK     0x00000004
#define REG_PHY_RXBE_IF1A0_SIG1_MIN_LENGTH_ERR_SHIFT    2
#define REG_PHY_RXBE_IF1A0_SIG1_MIN_LENGTH_ERR_WIDTH    1

/* PHY_RXBE_IF1A0_SIG1_RESERVED_ERR */
/* Signal 1 reserved bit Error */
#define REG_PHY_RXBE_IF1A0_SIG1_RESERVED_ERR          0x10680
#define REG_PHY_RXBE_IF1A0_SIG1_RESERVED_ERR_MASK     0x00000008
#define REG_PHY_RXBE_IF1A0_SIG1_RESERVED_ERR_SHIFT    3
#define REG_PHY_RXBE_IF1A0_SIG1_RESERVED_ERR_WIDTH    1

/* PHY_RXBE_IF1A0_SIG23_CRC_ERR */
/* signal23 Crc Error */
#define REG_PHY_RXBE_IF1A0_SIG23_CRC_ERR          0x10680
#define REG_PHY_RXBE_IF1A0_SIG23_CRC_ERR_MASK     0x00000010
#define REG_PHY_RXBE_IF1A0_SIG23_CRC_ERR_SHIFT    4
#define REG_PHY_RXBE_IF1A0_SIG23_CRC_ERR_WIDTH    1

/* PHY_RXBE_IF1A0_MTLK_CRC_STATUS */
/* Metalink CRC status
'1' = good CRC */
#define REG_PHY_RXBE_IF1A0_MTLK_CRC_STATUS          0x10680
#define REG_PHY_RXBE_IF1A0_MTLK_CRC_STATUS_MASK     0x00000040
#define REG_PHY_RXBE_IF1A0_MTLK_CRC_STATUS_SHIFT    6
#define REG_PHY_RXBE_IF1A0_MTLK_CRC_STATUS_WIDTH    1

/* PHY_RXBE_IF1A0_MCS */
/* MCS field from HT-SIG1 */
#define REG_PHY_RXBE_IF1A0_MCS          0x10680
#define REG_PHY_RXBE_IF1A0_MCS_MASK     0x00007f00
#define REG_PHY_RXBE_IF1A0_MCS_SHIFT    8
#define REG_PHY_RXBE_IF1A0_MCS_WIDTH    7

/* PHY_RXBE_IF1A1_LDPC_MAX_ITERATIONS */
/* LDPC max iterations number */
#define REG_PHY_RXBE_IF1A1_LDPC_MAX_ITERATIONS          0x10684
#define REG_PHY_RXBE_IF1A1_LDPC_MAX_ITERATIONS_MASK     0x000007ff
#define REG_PHY_RXBE_IF1A1_LDPC_MAX_ITERATIONS_SHIFT    0
#define REG_PHY_RXBE_IF1A1_LDPC_MAX_ITERATIONS_WIDTH    11

/* PHY_RXBE_IF1A2_RXBE_RISC_CAUSE_INT */
/* Rx BE Risc Cause int
Writing to the Cause register will clear the interrupts.
Bit per Int
[6]: ldpc_buffers_full
[5]: slicer_quality_valid_interrupt
[4]: sig3_err_interrupt
[3]: sig1_err_interrupt
[2]: m11b_rdy_fall_interrupt_pulse
[1]: ofdm_rdy_fall_interrupt_pulse
[0]: phy_pac_rx_phy_ready_pulse */
#define REG_PHY_RXBE_IF1A2_RXBE_RISC_CAUSE_INT          0x10688
#define REG_PHY_RXBE_IF1A2_RXBE_RISC_CAUSE_INT_MASK     0x0000007f
#define REG_PHY_RXBE_IF1A2_RXBE_RISC_CAUSE_INT_SHIFT    0
#define REG_PHY_RXBE_IF1A2_RXBE_RISC_CAUSE_INT_WIDTH    7

/* PHY_RXBE_IF1A3_RXBE_RISC_INT_ENABLE */
/* Rx BE Risc Int Enable
[6]: ldpc_buffers_full
[5]: slicer_quality_valid_interrupt
[4]: sig3_err_interrupt
[3]: sig1_err_interrupt
[2]: m11b_rdy_fall_interrupt_pulse
[1]: ofdm_rdy_fall_interrupt_pulse
[0]: phy_pac_rx_phy_ready_pulse */
#define REG_PHY_RXBE_IF1A3_RXBE_RISC_INT_ENABLE          0x1068C
#define REG_PHY_RXBE_IF1A3_RXBE_RISC_INT_ENABLE_MASK     0x0000007f
#define REG_PHY_RXBE_IF1A3_RXBE_RISC_INT_ENABLE_SHIFT    0
#define REG_PHY_RXBE_IF1A3_RXBE_RISC_INT_ENABLE_WIDTH    7

/* PHY_RXBE_IF1A4_SW_GCLK_BYPASS */
/* 1' - activate gclk. */
#define REG_PHY_RXBE_IF1A4_SW_GCLK_BYPASS          0x10690
#define REG_PHY_RXBE_IF1A4_SW_GCLK_BYPASS_MASK     0x00003FFF
#define REG_PHY_RXBE_IF1A4_SW_GCLK_BYPASS_SHIFT    0
#define REG_PHY_RXBE_IF1A4_SW_GCLK_BYPASS_WIDTH    14

/* PHY_RXBE_IF1A5_LDPC_N_DATA */
/* number of payload data bits in first codeword */
#define REG_PHY_RXBE_IF1A5_LDPC_N_DATA          0x10694
#define REG_PHY_RXBE_IF1A5_LDPC_N_DATA_MASK     0x000007ff
#define REG_PHY_RXBE_IF1A5_LDPC_N_DATA_SHIFT    0
#define REG_PHY_RXBE_IF1A5_LDPC_N_DATA_WIDTH    11

/* PHY_RXBE_IF1A5_LDPC_CW_TYPE */
/* LDPC type: 0-2=draft modes,
3=Proprietary mode */
#define REG_PHY_RXBE_IF1A5_LDPC_CW_TYPE          0x10694
#define REG_PHY_RXBE_IF1A5_LDPC_CW_TYPE_MASK     0x00003000
#define REG_PHY_RXBE_IF1A5_LDPC_CW_TYPE_SHIFT    12
#define REG_PHY_RXBE_IF1A5_LDPC_CW_TYPE_WIDTH    2

/* PHY_RXBE_IF1A5_LDPC_RX_RISC_OVERRIDE */
/* ldpc_rx_risc_override */
#define REG_PHY_RXBE_IF1A5_LDPC_RX_RISC_OVERRIDE          0x10694
#define REG_PHY_RXBE_IF1A5_LDPC_RX_RISC_OVERRIDE_MASK     0x00004000
#define REG_PHY_RXBE_IF1A5_LDPC_RX_RISC_OVERRIDE_SHIFT    14
#define REG_PHY_RXBE_IF1A5_LDPC_RX_RISC_OVERRIDE_WIDTH    1

/* PHY_RXBE_IF1A6_CLEAR_COUNTERS */
/* Clear all PRBS and CRC counters */
#define REG_PHY_RXBE_IF1A6_CLEAR_COUNTERS          0x10698
#define REG_PHY_RXBE_IF1A6_CLEAR_COUNTERS_MASK     0x00000001
#define REG_PHY_RXBE_IF1A6_CLEAR_COUNTERS_SHIFT    0
#define REG_PHY_RXBE_IF1A6_CLEAR_COUNTERS_WIDTH    1

/* PHY_RXBE_IF1A7_PRBS_ERR_PACKET_CNT */
/* number of packets with PRBS error (16 LSB only) */
#define REG_PHY_RXBE_IF1A7_PRBS_ERR_PACKET_CNT          0x1069C
#define REG_PHY_RXBE_IF1A7_PRBS_ERR_PACKET_CNT_MASK     0x0000ffff
#define REG_PHY_RXBE_IF1A7_PRBS_ERR_PACKET_CNT_SHIFT    0
#define REG_PHY_RXBE_IF1A7_PRBS_ERR_PACKET_CNT_WIDTH    16

/* PHY_RXBE_IF1A8_CRC_ERR_PACKET_CNT */
/* number of packets with CRC error (16 LSB only) */
#define REG_PHY_RXBE_IF1A8_CRC_ERR_PACKET_CNT          0x106A0
#define REG_PHY_RXBE_IF1A8_CRC_ERR_PACKET_CNT_MASK     0x0000ffff
#define REG_PHY_RXBE_IF1A8_CRC_ERR_PACKET_CNT_SHIFT    0
#define REG_PHY_RXBE_IF1A8_CRC_ERR_PACKET_CNT_WIDTH    16

/* PHY_RXBE_IF1A9_HYP_RXBE_CTRL_STM */
/* RxBE state machine */
#define REG_PHY_RXBE_IF1A9_HYP_RXBE_CTRL_STM          0x106A4
#define REG_PHY_RXBE_IF1A9_HYP_RXBE_CTRL_STM_MASK     0x00000007
#define REG_PHY_RXBE_IF1A9_HYP_RXBE_CTRL_STM_SHIFT    0
#define REG_PHY_RXBE_IF1A9_HYP_RXBE_CTRL_STM_WIDTH    3

/* PHY_RXBE_IF1A9_PHY_MAC_IF_MAIN_STM */
/* Phy MAC IF state machine */
#define REG_PHY_RXBE_IF1A9_PHY_MAC_IF_MAIN_STM          0x106A4
#define REG_PHY_RXBE_IF1A9_PHY_MAC_IF_MAIN_STM_MASK     0x000000f8
#define REG_PHY_RXBE_IF1A9_PHY_MAC_IF_MAIN_STM_SHIFT    3
#define REG_PHY_RXBE_IF1A9_PHY_MAC_IF_MAIN_STM_WIDTH    5

/* PHY_RXBE_IF1A9_PHY_PAC_RX_AGGREGATE */
/* aggregate bit connected to the mac */
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_AGGREGATE          0x106A4
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_AGGREGATE_MASK     0x00000200
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_AGGREGATE_SHIFT    9
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_AGGREGATE_WIDTH    1

/* PHY_RXBE_IF1A9_PHY_PAC_RX_PHY_READY */
/* ready bit connected to the mac */
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_PHY_READY          0x106A4
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_PHY_READY_MASK     0x00000400
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_PHY_READY_SHIFT    10
#define REG_PHY_RXBE_IF1A9_PHY_PAC_RX_PHY_READY_WIDTH    1

/* PHY_RXBE_IF1AA_IGNORE_SIG1_ERROR_N */
/* ignore signal 1 eror:
0- ignore sig1 error when Ht detected.
1- Rev-0 mode packet will be droped on sig-1 error. */
#define REG_PHY_RXBE_IF1AA_IGNORE_SIG1_ERROR_N          0x106A8
#define REG_PHY_RXBE_IF1AA_IGNORE_SIG1_ERROR_N_MASK     0x00000010
#define REG_PHY_RXBE_IF1AA_IGNORE_SIG1_ERROR_N_SHIFT    4
#define REG_PHY_RXBE_IF1AA_IGNORE_SIG1_ERROR_N_WIDTH    1

/* PHY_RXBE_IF1AB_PHY_PAC_RX_PHY_ERROR */
/* Rx phy error
asserted when aborting the packet interrupt to the Mac is not needed. */
#define REG_PHY_RXBE_IF1AB_PHY_PAC_RX_PHY_ERROR          0x106AC
#define REG_PHY_RXBE_IF1AB_PHY_PAC_RX_PHY_ERROR_MASK     0x00000001
#define REG_PHY_RXBE_IF1AB_PHY_PAC_RX_PHY_ERROR_SHIFT    0
#define REG_PHY_RXBE_IF1AB_PHY_PAC_RX_PHY_ERROR_WIDTH    1

/* PHY_RXBE_IF1AC_NDP_MAX_SUPPORTED_NSS */
/* mac control for ndp max allowed Nss */
#define REG_PHY_RXBE_IF1AC_NDP_MAX_SUPPORTED_NSS          0x106B0
#define REG_PHY_RXBE_IF1AC_NDP_MAX_SUPPORTED_NSS_MASK     0x00000030
#define REG_PHY_RXBE_IF1AC_NDP_MAX_SUPPORTED_NSS_SHIFT    4
#define REG_PHY_RXBE_IF1AC_NDP_MAX_SUPPORTED_NSS_WIDTH    2

/* PHY_RXBE_IF1AD_LDPC_N_CW */
/* number of codewords */
#define REG_PHY_RXBE_IF1AD_LDPC_N_CW          0x106B4
#define REG_PHY_RXBE_IF1AD_LDPC_N_CW_MASK     0x00007fff
#define REG_PHY_RXBE_IF1AD_LDPC_N_CW_SHIFT    0
#define REG_PHY_RXBE_IF1AD_LDPC_N_CW_WIDTH    15

/* PHY_RXBE_IF1AE_LDPC_REM_NSHRT_NCW */
/* number of CW with ldpc_n_data payload bits */
#define REG_PHY_RXBE_IF1AE_LDPC_REM_NSHRT_NCW          0x106B8
#define REG_PHY_RXBE_IF1AE_LDPC_REM_NSHRT_NCW_MASK     0x00007fff
#define REG_PHY_RXBE_IF1AE_LDPC_REM_NSHRT_NCW_SHIFT    0
#define REG_PHY_RXBE_IF1AE_LDPC_REM_NSHRT_NCW_WIDTH    15

/* PHY_RXBE_IF1B0_LDPC_N_PARITY */
/* numbre of parity bits in first CW of packet */
#define REG_PHY_RXBE_IF1B0_LDPC_N_PARITY          0x106C0
#define REG_PHY_RXBE_IF1B0_LDPC_N_PARITY_MASK     0x00007ff0
#define REG_PHY_RXBE_IF1B0_LDPC_N_PARITY_SHIFT    4
#define REG_PHY_RXBE_IF1B0_LDPC_N_PARITY_WIDTH    11

/* PHY_RXBE_IF1B2_LDPC_N_REPEAT */
/* number of parity bits in first CW of packet */
#define REG_PHY_RXBE_IF1B2_LDPC_N_REPEAT          0x106C8
#define REG_PHY_RXBE_IF1B2_LDPC_N_REPEAT_MASK     0x00001FFF
#define REG_PHY_RXBE_IF1B2_LDPC_N_REPEAT_SHIFT    0
#define REG_PHY_RXBE_IF1B2_LDPC_N_REPEAT_WIDTH    13

/* PHY_RXBE_IF1B3_LDPC_REM_NREP_NCW */
/* how many codewords to do repeat of Nrep+1 bits */
#define REG_PHY_RXBE_IF1B3_LDPC_REM_NREP_NCW          0x106CC
#define REG_PHY_RXBE_IF1B3_LDPC_REM_NREP_NCW_MASK     0x00007fFF
#define REG_PHY_RXBE_IF1B3_LDPC_REM_NREP_NCW_SHIFT    0
#define REG_PHY_RXBE_IF1B3_LDPC_REM_NREP_NCW_WIDTH    15

/* PHY_RXBE_IF1B4_L_SIG_DURATION */
/* L-SIG Duration */
#define REG_PHY_RXBE_IF1B4_L_SIG_DURATION          0x106D0
#define REG_PHY_RXBE_IF1B4_L_SIG_DURATION_MASK     0x0000ffff
#define REG_PHY_RXBE_IF1B4_L_SIG_DURATION_SHIFT    0
#define REG_PHY_RXBE_IF1B4_L_SIG_DURATION_WIDTH    16

/* PHY_RXBE_IF1B5_MCS_UNSUPPORTED */
/* MCS unsupported */
#define REG_PHY_RXBE_IF1B5_MCS_UNSUPPORTED          0x106D4
#define REG_PHY_RXBE_IF1B5_MCS_UNSUPPORTED_MASK     0x00000001
#define REG_PHY_RXBE_IF1B5_MCS_UNSUPPORTED_SHIFT    0
#define REG_PHY_RXBE_IF1B5_MCS_UNSUPPORTED_WIDTH    1

/* PHY_RXBE_IF1B6_LENGTH_TO_MAC */
/* length to MAC */
#define REG_PHY_RXBE_IF1B6_LENGTH_TO_MAC          0x106D8
#define REG_PHY_RXBE_IF1B6_LENGTH_TO_MAC_MASK     0x0000ffff
#define REG_PHY_RXBE_IF1B6_LENGTH_TO_MAC_SHIFT    0
#define REG_PHY_RXBE_IF1B6_LENGTH_TO_MAC_WIDTH    16

/* PHY_RXBE_IF1B7_RATE_TO_MAC */
/* rate to MAC */
#define REG_PHY_RXBE_IF1B7_RATE_TO_MAC          0x106DC
#define REG_PHY_RXBE_IF1B7_RATE_TO_MAC_MASK     0x000000ff
#define REG_PHY_RXBE_IF1B7_RATE_TO_MAC_SHIFT    0
#define REG_PHY_RXBE_IF1B7_RATE_TO_MAC_WIDTH    8

/* PHY_RXBE_IF1B8_LDPC_REM_NPUNC_NCW */
/* how many codewords to puncture Nppcs+1 bits */
#define REG_PHY_RXBE_IF1B8_LDPC_REM_NPUNC_NCW          0x106E0
#define REG_PHY_RXBE_IF1B8_LDPC_REM_NPUNC_NCW_MASK     0x00007FFF
#define REG_PHY_RXBE_IF1B8_LDPC_REM_NPUNC_NCW_SHIFT    0
#define REG_PHY_RXBE_IF1B8_LDPC_REM_NPUNC_NCW_WIDTH    15
#endif 
