/*******************************************************************
*                                                                   
*  PHY_RX_TD_IF_Risc_Page_0_fd.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_TD_IF_Risc_Page_0_fd_regs_H_FILE
#define PHY_RX_TD_IF_Risc_Page_0_fd_regs_H_FILE

/* PHY_RXFD_IF100_SW_RESET_N_REG */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly.
[0]- fd control state machine
[1]- fft_0
[2]- fft_1
[3]- fft_2
[4]- bin chooser
[5]- nco
[6]- pilot scrambler
[7]- phase tracking
[8]- organizer
[9]- channel tracking
[10]- channel smoothing
[11]- timing estimation
[12]- gsm
[13]- slicer
[14]- decimator test bus
 */
#define REG_PHY_RXFD_IF100_SW_RESET_N_REG          0x10400
#define REG_PHY_RXFD_IF100_SW_RESET_N_REG_MASK     0x00007FFF
#define REG_PHY_RXFD_IF100_SW_RESET_N_REG_SHIFT    0
#define REG_PHY_RXFD_IF100_SW_RESET_N_REG_WIDTH    15

/* PHY_RXFD_IF101_BLOCKS_EN */
/* Sub blocks enable. One bit per sub block. Enables or disables the sub block 
[0]- fd control state machine
[1]- fft_0
[2]- fft_1
[3]- fft_2
[4]- bin chooser
[5]- nco
[6]- pilot scrambler
[7]- phase tracking
[8]- organizer
[9]- channel tracking
[10]- channel smoothing
[11]- timing estimation
[12]- gsm
[13]- slicer
[14]- decimator test busclock.unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly. */
#define REG_PHY_RXFD_IF101_BLOCKS_EN          0x10404
#define REG_PHY_RXFD_IF101_BLOCKS_EN_MASK     0x00007FFF
#define REG_PHY_RXFD_IF101_BLOCKS_EN_SHIFT    0
#define REG_PHY_RXFD_IF101_BLOCKS_EN_WIDTH    15

/* PHY_RXFD_IF102_SW_RESET_GENERATE */
/* A SW reset procedure will be initiated by writing to this register to the bits that equal 1l */
#define REG_PHY_RXFD_IF102_SW_RESET_GENERATE          0x10408
#define REG_PHY_RXFD_IF102_SW_RESET_GENERATE_MASK     0x00007FFF
#define REG_PHY_RXFD_IF102_SW_RESET_GENERATE_SHIFT    0
#define REG_PHY_RXFD_IF102_SW_RESET_GENERATE_WIDTH    15

/* PHY_RXFD_IF103_GSM_SW_RESET_MASK */
/* Which block to software reset after rxbe_enable fall */
#define REG_PHY_RXFD_IF103_GSM_SW_RESET_MASK          0x1040C
#define REG_PHY_RXFD_IF103_GSM_SW_RESET_MASK_MASK     0x00007FFF
#define REG_PHY_RXFD_IF103_GSM_SW_RESET_MASK_SHIFT    0
#define REG_PHY_RXFD_IF103_GSM_SW_RESET_MASK_WIDTH    15

/* PHY_RXFD_IF104_RISC_RESET_MODEM_P */
/* Rx TD Risc Reset Modem pulse */
#define REG_PHY_RXFD_IF104_RISC_RESET_MODEM_P          0x10410
#define REG_PHY_RXFD_IF104_RISC_RESET_MODEM_P_MASK     0x00000001
#define REG_PHY_RXFD_IF104_RISC_RESET_MODEM_P_SHIFT    0
#define REG_PHY_RXFD_IF104_RISC_RESET_MODEM_P_WIDTH    1

/* PHY_RXFD_IF105_RXFD_RISC_CAUSE_INT */
/* Rx FD Risc Cause int -
bit[7] - effective snr
bit[6] - last symbol
bit[5] - fd_stm_aborted
bit[4] - td_stm_aborted
bit[3] - fd symbol ready
bit[2] - sym_strobe to td
bit[1] - green field packet
bit[0] - high throughput packet */
#define REG_PHY_RXFD_IF105_RXFD_RISC_CAUSE_INT          0x10414
#define REG_PHY_RXFD_IF105_RXFD_RISC_CAUSE_INT_MASK     0x000000ff
#define REG_PHY_RXFD_IF105_RXFD_RISC_CAUSE_INT_SHIFT    0
#define REG_PHY_RXFD_IF105_RXFD_RISC_CAUSE_INT_WIDTH    8

/* PHY_RXFD_IF106_RXFD_RISC_INT_ENABLE */
/* Rx FD Risc Int Enable */
#define REG_PHY_RXFD_IF106_RXFD_RISC_INT_ENABLE          0x10418
#define REG_PHY_RXFD_IF106_RXFD_RISC_INT_ENABLE_MASK     0x000000ff
#define REG_PHY_RXFD_IF106_RXFD_RISC_INT_ENABLE_SHIFT    0
#define REG_PHY_RXFD_IF106_RXFD_RISC_INT_ENABLE_WIDTH    8

/* PHY_RXFD_IF107_GSM_TD_NEXT_STATE */
/* GSM Td Next State */
#define REG_PHY_RXFD_IF107_GSM_TD_NEXT_STATE          0x1041C
#define REG_PHY_RXFD_IF107_GSM_TD_NEXT_STATE_MASK     0x0000000f
#define REG_PHY_RXFD_IF107_GSM_TD_NEXT_STATE_SHIFT    0
#define REG_PHY_RXFD_IF107_GSM_TD_NEXT_STATE_WIDTH    4

/* PHY_RXFD_IF107_GSM_FD_NEXT_STATE */
/* GSM Fd Next State */
#define REG_PHY_RXFD_IF107_GSM_FD_NEXT_STATE          0x1041C
#define REG_PHY_RXFD_IF107_GSM_FD_NEXT_STATE_MASK     0x000000f0
#define REG_PHY_RXFD_IF107_GSM_FD_NEXT_STATE_SHIFT    4
#define REG_PHY_RXFD_IF107_GSM_FD_NEXT_STATE_WIDTH    4

/* PHY_RXFD_IF107_RXFD_CSM */
/* GSM Fd Next State */
#define REG_PHY_RXFD_IF107_RXFD_CSM          0x1041C
#define REG_PHY_RXFD_IF107_RXFD_CSM_MASK     0x00001f00
#define REG_PHY_RXFD_IF107_RXFD_CSM_SHIFT    8
#define REG_PHY_RXFD_IF107_RXFD_CSM_WIDTH    5

/* PHY_RXFD_IF108_ANTENNA_EN */
/* Sanity Risc Antenna Enable
Risc Decision  */
#define REG_PHY_RXFD_IF108_ANTENNA_EN          0x10420
#define REG_PHY_RXFD_IF108_ANTENNA_EN_MASK     0x00000007
#define REG_PHY_RXFD_IF108_ANTENNA_EN_SHIFT    0
#define REG_PHY_RXFD_IF108_ANTENNA_EN_WIDTH    3

/* PHY_RXFD_IF108_ANTENNA_EN_VALID */
/* Sanity Risc Antenna Enable Valid
1- select the Risc antenna enable
0- select the host antenna enable */
#define REG_PHY_RXFD_IF108_ANTENNA_EN_VALID          0x10420
#define REG_PHY_RXFD_IF108_ANTENNA_EN_VALID_MASK     0x00000008
#define REG_PHY_RXFD_IF108_ANTENNA_EN_VALID_SHIFT    3
#define REG_PHY_RXFD_IF108_ANTENNA_EN_VALID_WIDTH    1

/* PHY_RXFD_IF109_CT_DATA_MU */
/* Channel Tracking Coefficient Mu */
#define REG_PHY_RXFD_IF109_CT_DATA_MU          0x10424
#define REG_PHY_RXFD_IF109_CT_DATA_MU_MASK     0x0000000f
#define REG_PHY_RXFD_IF109_CT_DATA_MU_SHIFT    0
#define REG_PHY_RXFD_IF109_CT_DATA_MU_WIDTH    4

/* PHY_RXFD_IF109_CT_PILOT_MU */
/* Channel Tracking Loop Coefficient Mu */
#define REG_PHY_RXFD_IF109_CT_PILOT_MU          0x10424
#define REG_PHY_RXFD_IF109_CT_PILOT_MU_MASK     0x000000f0
#define REG_PHY_RXFD_IF109_CT_PILOT_MU_SHIFT    4
#define REG_PHY_RXFD_IF109_CT_PILOT_MU_WIDTH    4

/* PHY_RXFD_IF109_FT_SHIFTER */
/* Frequency Tracking Loop Coefficient  */
#define REG_PHY_RXFD_IF109_FT_SHIFTER          0x10424
#define REG_PHY_RXFD_IF109_FT_SHIFTER_MASK     0x00000f00
#define REG_PHY_RXFD_IF109_FT_SHIFTER_SHIFT    8
#define REG_PHY_RXFD_IF109_FT_SHIFTER_WIDTH    4

/* PHY_RXFD_IF109_LLTF_CH_SMOOTH_BYPASS */
/* Risc Channel Estimation Bypass */
#define REG_PHY_RXFD_IF109_LLTF_CH_SMOOTH_BYPASS          0x10424
#define REG_PHY_RXFD_IF109_LLTF_CH_SMOOTH_BYPASS_MASK     0x00001000
#define REG_PHY_RXFD_IF109_LLTF_CH_SMOOTH_BYPASS_SHIFT    12
#define REG_PHY_RXFD_IF109_LLTF_CH_SMOOTH_BYPASS_WIDTH    1

/* PHY_RXFD_IF109_LLTF_TE_BYPASS */
/* L-Ltf ch smoothing bypass */
#define REG_PHY_RXFD_IF109_LLTF_TE_BYPASS          0x10424
#define REG_PHY_RXFD_IF109_LLTF_TE_BYPASS_MASK     0x00002000
#define REG_PHY_RXFD_IF109_LLTF_TE_BYPASS_SHIFT    13
#define REG_PHY_RXFD_IF109_LLTF_TE_BYPASS_WIDTH    1

/* PHY_RXFD_IF109_HTLTF_TE_BYPASS */
/* Ht-LTF Timing estimation Bypass */
#define REG_PHY_RXFD_IF109_HTLTF_TE_BYPASS          0x10424
#define REG_PHY_RXFD_IF109_HTLTF_TE_BYPASS_MASK     0x00004000
#define REG_PHY_RXFD_IF109_HTLTF_TE_BYPASS_SHIFT    14
#define REG_PHY_RXFD_IF109_HTLTF_TE_BYPASS_WIDTH    1

/* PHY_RXFD_IF109_HTLTF_CH_SMOOTH_BYPASS */
/* Ht-LTF channel smoothing bypass */
#define REG_PHY_RXFD_IF109_HTLTF_CH_SMOOTH_BYPASS          0x10424
#define REG_PHY_RXFD_IF109_HTLTF_CH_SMOOTH_BYPASS_MASK     0x00008000
#define REG_PHY_RXFD_IF109_HTLTF_CH_SMOOTH_BYPASS_SHIFT    15
#define REG_PHY_RXFD_IF109_HTLTF_CH_SMOOTH_BYPASS_WIDTH    1

/* PHY_RXFD_IF10A_SIG1_STALL */
/* Channel Tracking Signal 1 Stall */
#define REG_PHY_RXFD_IF10A_SIG1_STALL          0x10428
#define REG_PHY_RXFD_IF10A_SIG1_STALL_MASK     0x00000001
#define REG_PHY_RXFD_IF10A_SIG1_STALL_SHIFT    0
#define REG_PHY_RXFD_IF10A_SIG1_STALL_WIDTH    1

/* PHY_RXFD_IF10A_FIRST_DATA_STALL */
/* 1st Data Stall */
#define REG_PHY_RXFD_IF10A_FIRST_DATA_STALL          0x10428
#define REG_PHY_RXFD_IF10A_FIRST_DATA_STALL_MASK     0x00000002
#define REG_PHY_RXFD_IF10A_FIRST_DATA_STALL_SHIFT    1
#define REG_PHY_RXFD_IF10A_FIRST_DATA_STALL_WIDTH    1

/* PHY_RXFD_IF10A_TD_HT_SIG_STALL_RISC */
/* risc stall the gsm -td ht signal according to the gsm stm */
#define REG_PHY_RXFD_IF10A_TD_HT_SIG_STALL_RISC          0x10428
#define REG_PHY_RXFD_IF10A_TD_HT_SIG_STALL_RISC_MASK     0x00000004
#define REG_PHY_RXFD_IF10A_TD_HT_SIG_STALL_RISC_SHIFT    2
#define REG_PHY_RXFD_IF10A_TD_HT_SIG_STALL_RISC_WIDTH    1

/* PHY_RXFD_IF10A_TD_HT_LTF1_STALL_RISC */
/* risc stall the gsm -td ht signal according to the gsm stm */
#define REG_PHY_RXFD_IF10A_TD_HT_LTF1_STALL_RISC          0x10428
#define REG_PHY_RXFD_IF10A_TD_HT_LTF1_STALL_RISC_MASK     0x00000008
#define REG_PHY_RXFD_IF10A_TD_HT_LTF1_STALL_RISC_SHIFT    3
#define REG_PHY_RXFD_IF10A_TD_HT_LTF1_STALL_RISC_WIDTH    1

/* PHY_RXFD_IF10B_PHASE_SMOOTHING_SIZE */
/* Phase Smoothing Size */
#define REG_PHY_RXFD_IF10B_PHASE_SMOOTHING_SIZE          0x1042C
#define REG_PHY_RXFD_IF10B_PHASE_SMOOTHING_SIZE_MASK     0x0000001f
#define REG_PHY_RXFD_IF10B_PHASE_SMOOTHING_SIZE_SHIFT    0
#define REG_PHY_RXFD_IF10B_PHASE_SMOOTHING_SIZE_WIDTH    5

/* PHY_RXFD_IF10B_TIMING_SMOOTHING_SIZE */
/* Timing Smoothing Size */
#define REG_PHY_RXFD_IF10B_TIMING_SMOOTHING_SIZE          0x1042C
#define REG_PHY_RXFD_IF10B_TIMING_SMOOTHING_SIZE_MASK     0x00001f00
#define REG_PHY_RXFD_IF10B_TIMING_SMOOTHING_SIZE_SHIFT    8
#define REG_PHY_RXFD_IF10B_TIMING_SMOOTHING_SIZE_WIDTH    5

/* PHY_RXFD_IF10C_H_MODE_CNT_RISC */
/* h_mode counter
0-qr rate = 1:1
1-qr rate = 1:2
4-qr rate = 1:5
 */
#define REG_PHY_RXFD_IF10C_H_MODE_CNT_RISC          0x10430
#define REG_PHY_RXFD_IF10C_H_MODE_CNT_RISC_MASK     0x00000070
#define REG_PHY_RXFD_IF10C_H_MODE_CNT_RISC_SHIFT    4
#define REG_PHY_RXFD_IF10C_H_MODE_CNT_RISC_WIDTH    3

/* PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL */
/* risc control channel:
0-Usb 
1-Lsb */
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL          0x10430
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_MASK     0x00000100
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SHIFT    8
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_WIDTH    1

/* PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SEL */
/* control channel select decision:
0-Mac default
1-sw risc */
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SEL          0x10430
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SEL_MASK     0x00000200
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SEL_SHIFT    9
#define REG_PHY_RXFD_IF10C_RISC_CONTROL_CHANNEL_SEL_WIDTH    1

/* PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN */
/* risc override the td global enable */
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN          0x10434
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_MASK     0x00000001
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SHIFT    0
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_WIDTH    1

/* PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN */
/* risc override the fd global enable */
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN          0x10434
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_MASK     0x00000002
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SHIFT    1
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_WIDTH    1

/* PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN */
/* risc override the be global enable */
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN          0x10434
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_MASK     0x00000004
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SHIFT    2
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_WIDTH    1

/* PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL */
/* global enable selection:
0- hw
1-sw risc */
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL          0x10434
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL_MASK     0x00000010
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL_SHIFT    4
#define REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL_WIDTH    1

/* PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL */
/* global enable selection:
0- hw
1-sw risc */
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL          0x10434
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL_MASK     0x00000020
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL_SHIFT    5
#define REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL_WIDTH    1

/* PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL */
/* global enable selection:
0- hw
1-sw risc */
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL          0x10434
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL_MASK     0x00000040
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL_SHIFT    6
#define REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL_WIDTH    1

/* PHY_RXFD_IF10E_HT_MODE */
/* ht mode:
0-legacy
1-mixed mode */
#define REG_PHY_RXFD_IF10E_HT_MODE          0x10438
#define REG_PHY_RXFD_IF10E_HT_MODE_MASK     0x00000001
#define REG_PHY_RXFD_IF10E_HT_MODE_SHIFT    0
#define REG_PHY_RXFD_IF10E_HT_MODE_WIDTH    1

/* PHY_RXFD_IF10E_GF_DETECTED */
/* green fiels detection result:
1- green field detected */
#define REG_PHY_RXFD_IF10E_GF_DETECTED          0x10438
#define REG_PHY_RXFD_IF10E_GF_DETECTED_MASK     0x00000002
#define REG_PHY_RXFD_IF10E_GF_DETECTED_SHIFT    1
#define REG_PHY_RXFD_IF10E_GF_DETECTED_WIDTH    1

/* PHY_RXFD_IF10E_HT_METRICS */
/* green fiels detection result:
1- green field detected */
#define REG_PHY_RXFD_IF10E_HT_METRICS          0x10438
#define REG_PHY_RXFD_IF10E_HT_METRICS_MASK     0x00007ff0
#define REG_PHY_RXFD_IF10E_HT_METRICS_SHIFT    4
#define REG_PHY_RXFD_IF10E_HT_METRICS_WIDTH    11

/* PHY_RXFD_IF10F_MCS32_REV_0 */
/* mcs32 backward compatible for rev_0 */
#define REG_PHY_RXFD_IF10F_MCS32_REV_0          0x1043C
#define REG_PHY_RXFD_IF10F_MCS32_REV_0_MASK     0x00000001
#define REG_PHY_RXFD_IF10F_MCS32_REV_0_SHIFT    0
#define REG_PHY_RXFD_IF10F_MCS32_REV_0_WIDTH    1

/* PHY_RXFD_IF10F_GF_NCO_BP_EN */
/* enable nco_bypass for ht_detector input data in L_sig (do not rotate the data_bins for the ht detector)  */
#define REG_PHY_RXFD_IF10F_GF_NCO_BP_EN          0x1043C
#define REG_PHY_RXFD_IF10F_GF_NCO_BP_EN_MASK     0x00000002
#define REG_PHY_RXFD_IF10F_GF_NCO_BP_EN_SHIFT    1
#define REG_PHY_RXFD_IF10F_GF_NCO_BP_EN_WIDTH    1

/* PHY_RXFD_IF10F_HT_NCO_BP_EN */
/* enable nco_bypass for ht_detector input data in ht_sig1 (do not rotate the data_bins for the ht detector)  */
#define REG_PHY_RXFD_IF10F_HT_NCO_BP_EN          0x1043C
#define REG_PHY_RXFD_IF10F_HT_NCO_BP_EN_MASK     0x00000004
#define REG_PHY_RXFD_IF10F_HT_NCO_BP_EN_SHIFT    2
#define REG_PHY_RXFD_IF10F_HT_NCO_BP_EN_WIDTH    1

/* PHY_RXFD_IF110_HYP_RXFD_GPO */
/* gpo
for general use at the top level */
#define REG_PHY_RXFD_IF110_HYP_RXFD_GPO          0x10440
#define REG_PHY_RXFD_IF110_HYP_RXFD_GPO_MASK     0x0000ffff
#define REG_PHY_RXFD_IF110_HYP_RXFD_GPO_SHIFT    0
#define REG_PHY_RXFD_IF110_HYP_RXFD_GPO_WIDTH    16

/* PHY_RXFD_IF111_RISC_NUM_SYMBOLS */
/* number of bits I packet low 16 bits */
#define REG_PHY_RXFD_IF111_RISC_NUM_SYMBOLS          0x10444
#define REG_PHY_RXFD_IF111_RISC_NUM_SYMBOLS_MASK     0x00007fff
#define REG_PHY_RXFD_IF111_RISC_NUM_SYMBOLS_SHIFT    0
#define REG_PHY_RXFD_IF111_RISC_NUM_SYMBOLS_WIDTH    15

/* PHY_RXFD_IF112_RISC_NUM_SYMBOLS_VALID */
/* Number of dat bits valid signal */
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_VALID          0x10448
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_VALID_MASK     0x00001000
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_VALID_SHIFT    12
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_VALID_WIDTH    1

/* PHY_RXFD_IF112_RISC_NUM_SYMBOLS_SEL */
/* Select signal
0-Hw
1-Risc */
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_SEL          0x10448
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_SEL_MASK     0x00002000
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_SEL_SHIFT    13
#define REG_PHY_RXFD_IF112_RISC_NUM_SYMBOLS_SEL_WIDTH    1

/* PHY_RXFD_IF112_FD_TIM_REVERT_EN */
/* fd_tim_revert_en */
#define REG_PHY_RXFD_IF112_FD_TIM_REVERT_EN          0x10448
#define REG_PHY_RXFD_IF112_FD_TIM_REVERT_EN_MASK     0x00004000
#define REG_PHY_RXFD_IF112_FD_TIM_REVERT_EN_SHIFT    14
#define REG_PHY_RXFD_IF112_FD_TIM_REVERT_EN_WIDTH    1

/* PHY_RXFD_IF113_TE_OFFSET */
/* timing estimation offset */
#define REG_PHY_RXFD_IF113_TE_OFFSET          0x1044C
#define REG_PHY_RXFD_IF113_TE_OFFSET_MASK     0x000000f0
#define REG_PHY_RXFD_IF113_TE_OFFSET_SHIFT    4
#define REG_PHY_RXFD_IF113_TE_OFFSET_WIDTH    4

/* PHY_RXFD_IF113_DCMTR_TB_TIMER_EN */
/* dcmdt timer en
Decimator Timer is enabled. */
#define REG_PHY_RXFD_IF113_DCMTR_TB_TIMER_EN          0x1044C
#define REG_PHY_RXFD_IF113_DCMTR_TB_TIMER_EN_MASK     0x00000100
#define REG_PHY_RXFD_IF113_DCMTR_TB_TIMER_EN_SHIFT    8
#define REG_PHY_RXFD_IF113_DCMTR_TB_TIMER_EN_WIDTH    1

/* PHY_RXFD_IF114_PACKET_COUNTER */
/* packet counter in order to synchronize between the gen_risc and the unit
 */
#define REG_PHY_RXFD_IF114_PACKET_COUNTER          0x10450
#define REG_PHY_RXFD_IF114_PACKET_COUNTER_MASK     0x000000ff
#define REG_PHY_RXFD_IF114_PACKET_COUNTER_SHIFT    0
#define REG_PHY_RXFD_IF114_PACKET_COUNTER_WIDTH    8

/* PHY_RXFD_IF115_HYP_RXFD_GPI */
/* gpi for read only  */
#define REG_PHY_RXFD_IF115_HYP_RXFD_GPI          0x10454
#define REG_PHY_RXFD_IF115_HYP_RXFD_GPI_MASK     0x0000ffff
#define REG_PHY_RXFD_IF115_HYP_RXFD_GPI_SHIFT    0
#define REG_PHY_RXFD_IF115_HYP_RXFD_GPI_WIDTH    16

/* PHY_RXFD_IF116_HYP_RXFD_GPI2 */
/* gpi2 for read only  */
#define REG_PHY_RXFD_IF116_HYP_RXFD_GPI2          0x10458
#define REG_PHY_RXFD_IF116_HYP_RXFD_GPI2_MASK     0x0000ffff
#define REG_PHY_RXFD_IF116_HYP_RXFD_GPI2_SHIFT    0
#define REG_PHY_RXFD_IF116_HYP_RXFD_GPI2_WIDTH    16

/* PHY_RXFD_IF117_HYP_RXFD_LOW_GPR */
/* hyp_rxfd_low_gpr */
#define REG_PHY_RXFD_IF117_HYP_RXFD_LOW_GPR          0x1045C
#define REG_PHY_RXFD_IF117_HYP_RXFD_LOW_GPR_MASK     0x0000ffff
#define REG_PHY_RXFD_IF117_HYP_RXFD_LOW_GPR_SHIFT    0
#define REG_PHY_RXFD_IF117_HYP_RXFD_LOW_GPR_WIDTH    16

/* PHY_RXFD_IF118_HYP_RXFD_HIGH_GPR */
/* hyp_rxfd_high_gpr */
#define REG_PHY_RXFD_IF118_HYP_RXFD_HIGH_GPR          0x10460
#define REG_PHY_RXFD_IF118_HYP_RXFD_HIGH_GPR_MASK     0x0000ffff
#define REG_PHY_RXFD_IF118_HYP_RXFD_HIGH_GPR_SHIFT    0
#define REG_PHY_RXFD_IF118_HYP_RXFD_HIGH_GPR_WIDTH    16

/* PHY_RXFD_IF119_TIM_FIX_AN0 */
/* fd_timing result antenna_0 */
#define REG_PHY_RXFD_IF119_TIM_FIX_AN0          0x10464
#define REG_PHY_RXFD_IF119_TIM_FIX_AN0_MASK     0x0000007F
#define REG_PHY_RXFD_IF119_TIM_FIX_AN0_SHIFT    0
#define REG_PHY_RXFD_IF119_TIM_FIX_AN0_WIDTH    7

/* PHY_RXFD_IF119_TIM_FIX_AN1 */
/* fd_timing result antenna_1 */
#define REG_PHY_RXFD_IF119_TIM_FIX_AN1          0x10464
#define REG_PHY_RXFD_IF119_TIM_FIX_AN1_MASK     0x00007F00
#define REG_PHY_RXFD_IF119_TIM_FIX_AN1_SHIFT    8
#define REG_PHY_RXFD_IF119_TIM_FIX_AN1_WIDTH    7

/* PHY_RXFD_IF11A_TIM_FIX_AN2 */
/* fd_timing result antenna_2 */
#define REG_PHY_RXFD_IF11A_TIM_FIX_AN2          0x10468
#define REG_PHY_RXFD_IF11A_TIM_FIX_AN2_MASK     0x0000007F
#define REG_PHY_RXFD_IF11A_TIM_FIX_AN2_SHIFT    0
#define REG_PHY_RXFD_IF11A_TIM_FIX_AN2_WIDTH    7

/* PHY_RXFD_IF11A_TIM_FIX_LLTF_VALID */
/* fd_timing l_ltf result valid  */
#define REG_PHY_RXFD_IF11A_TIM_FIX_LLTF_VALID          0x10468
#define REG_PHY_RXFD_IF11A_TIM_FIX_LLTF_VALID_MASK     0x00000100
#define REG_PHY_RXFD_IF11A_TIM_FIX_LLTF_VALID_SHIFT    8
#define REG_PHY_RXFD_IF11A_TIM_FIX_LLTF_VALID_WIDTH    1

/* PHY_RXFD_IF11A_TIM_FIX_HTLTF_VALID */
/* fd_timing ht_ltf result valid  */
#define REG_PHY_RXFD_IF11A_TIM_FIX_HTLTF_VALID          0x10468
#define REG_PHY_RXFD_IF11A_TIM_FIX_HTLTF_VALID_MASK     0x00000200
#define REG_PHY_RXFD_IF11A_TIM_FIX_HTLTF_VALID_SHIFT    9
#define REG_PHY_RXFD_IF11A_TIM_FIX_HTLTF_VALID_WIDTH    1

/* PHY_RXFD_IF11B_FD_BINS_CNT */
/* fd output bins counter */
#define REG_PHY_RXFD_IF11B_FD_BINS_CNT          0x1046C
#define REG_PHY_RXFD_IF11B_FD_BINS_CNT_MASK     0x0000007F
#define REG_PHY_RXFD_IF11B_FD_BINS_CNT_SHIFT    0
#define REG_PHY_RXFD_IF11B_FD_BINS_CNT_WIDTH    7

/* PHY_RXFD_IF11B_FREQ_TRCK_GCLK_DEBUG_BYPASS */
/* freq_trck_gclk_debug_bypass */
#define REG_PHY_RXFD_IF11B_FREQ_TRCK_GCLK_DEBUG_BYPASS          0x1046C
#define REG_PHY_RXFD_IF11B_FREQ_TRCK_GCLK_DEBUG_BYPASS_MASK     0x00004000
#define REG_PHY_RXFD_IF11B_FREQ_TRCK_GCLK_DEBUG_BYPASS_SHIFT    14
#define REG_PHY_RXFD_IF11B_FREQ_TRCK_GCLK_DEBUG_BYPASS_WIDTH    1

/* PHY_RXFD_IF11B_RISC_IF2BIU_GCLK_BYPASS */
/* risc_if2biu gclk bypass */
#define REG_PHY_RXFD_IF11B_RISC_IF2BIU_GCLK_BYPASS          0x1046C
#define REG_PHY_RXFD_IF11B_RISC_IF2BIU_GCLK_BYPASS_MASK     0x00008000
#define REG_PHY_RXFD_IF11B_RISC_IF2BIU_GCLK_BYPASS_SHIFT    15
#define REG_PHY_RXFD_IF11B_RISC_IF2BIU_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_IF11C_FD_SYMBOLS_CNT */
/* fd output symbols counter */
#define REG_PHY_RXFD_IF11C_FD_SYMBOLS_CNT          0x10470
#define REG_PHY_RXFD_IF11C_FD_SYMBOLS_CNT_MASK     0x00000FFF
#define REG_PHY_RXFD_IF11C_FD_SYMBOLS_CNT_SHIFT    0
#define REG_PHY_RXFD_IF11C_FD_SYMBOLS_CNT_WIDTH    12

/* PHY_RXFD_IF11D_GCLK_DEBUG_BYPASS */
/* One bit per gator.
[0]- register file gator.
[1]- csm gator
[2]- fft_0 gator
[3]- fft_1 gator
[4]- fft_2 gator
[5]- bin chooser gator
[6]- nco gator
[7]- pilot scrambler gator
[8]- phase tracking  gator
[9]- organizer gator
[10]-channel tracking gator
[11] - channel estimation gator
[12] - timing estimation gator
[13] - gsm gator
[14] - avg_4_2band
[15] - slicer  */
#define REG_PHY_RXFD_IF11D_GCLK_DEBUG_BYPASS          0x10474
#define REG_PHY_RXFD_IF11D_GCLK_DEBUG_BYPASS_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF11D_GCLK_DEBUG_BYPASS_SHIFT    0
#define REG_PHY_RXFD_IF11D_GCLK_DEBUG_BYPASS_WIDTH    16

/* PHY_RXFD_IF11E_TIMING_SHIFT_ACCUM */
/* timing shift accumulator - for metrics */
#define REG_PHY_RXFD_IF11E_TIMING_SHIFT_ACCUM          0x10478
#define REG_PHY_RXFD_IF11E_TIMING_SHIFT_ACCUM_MASK     0x0000007F
#define REG_PHY_RXFD_IF11E_TIMING_SHIFT_ACCUM_SHIFT    0
#define REG_PHY_RXFD_IF11E_TIMING_SHIFT_ACCUM_WIDTH    7

/* PHY_RXFD_IF11F_AN0_MAGNITUDE */
/* fd_timing - an0 magnitude value */
#define REG_PHY_RXFD_IF11F_AN0_MAGNITUDE          0x1047C
#define REG_PHY_RXFD_IF11F_AN0_MAGNITUDE_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF11F_AN0_MAGNITUDE_SHIFT    0
#define REG_PHY_RXFD_IF11F_AN0_MAGNITUDE_WIDTH    16

/* PHY_RXFD_IF120_AN1_MAGNITUDE */
/* fd_timing - an1 magnitude value */
#define REG_PHY_RXFD_IF120_AN1_MAGNITUDE          0x10480
#define REG_PHY_RXFD_IF120_AN1_MAGNITUDE_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF120_AN1_MAGNITUDE_SHIFT    0
#define REG_PHY_RXFD_IF120_AN1_MAGNITUDE_WIDTH    16

/* PHY_RXFD_IF121_AN2_MAGNITUDE */
/* fd_timing - an2 magnitude value */
#define REG_PHY_RXFD_IF121_AN2_MAGNITUDE          0x10484
#define REG_PHY_RXFD_IF121_AN2_MAGNITUDE_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF121_AN2_MAGNITUDE_SHIFT    0
#define REG_PHY_RXFD_IF121_AN2_MAGNITUDE_WIDTH    16

/* PHY_RXFD_IF122_IS_HT_GF_MAGNITUDE */
/* ht/gf detection magnitude value */
#define REG_PHY_RXFD_IF122_IS_HT_GF_MAGNITUDE          0x10488
#define REG_PHY_RXFD_IF122_IS_HT_GF_MAGNITUDE_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF122_IS_HT_GF_MAGNITUDE_SHIFT    0
#define REG_PHY_RXFD_IF122_IS_HT_GF_MAGNITUDE_WIDTH    16

/* PHY_RXFD_IF123_NOISE_INV */
/* value of 1/noise to the effective_snr module */
#define REG_PHY_RXFD_IF123_NOISE_INV          0x1048C
#define REG_PHY_RXFD_IF123_NOISE_INV_MASK     0x00007FFF
#define REG_PHY_RXFD_IF123_NOISE_INV_SHIFT    0
#define REG_PHY_RXFD_IF123_NOISE_INV_WIDTH    15

/* PHY_RXFD_IF124_MEAN_EXP_RESULT */
/* effective snr module result - mean_exp_result */
#define REG_PHY_RXFD_IF124_MEAN_EXP_RESULT          0x10490
#define REG_PHY_RXFD_IF124_MEAN_EXP_RESULT_MASK     0x000000FF
#define REG_PHY_RXFD_IF124_MEAN_EXP_RESULT_SHIFT    0
#define REG_PHY_RXFD_IF124_MEAN_EXP_RESULT_WIDTH    8

/* PHY_RXFD_IF124_EFFECTIVE_SNR_MCS */
/* effective snr module result - effective_snr_mcs withput the msb (rank bit) */
#define REG_PHY_RXFD_IF124_EFFECTIVE_SNR_MCS          0x10490
#define REG_PHY_RXFD_IF124_EFFECTIVE_SNR_MCS_MASK     0x00007f00
#define REG_PHY_RXFD_IF124_EFFECTIVE_SNR_MCS_SHIFT    8
#define REG_PHY_RXFD_IF124_EFFECTIVE_SNR_MCS_WIDTH    7

/* PHY_RXFD_IF125_LNA_ANT0 */
/* agc calculation gain ant0  */
#define REG_PHY_RXFD_IF125_LNA_ANT0          0x10494
#define REG_PHY_RXFD_IF125_LNA_ANT0_MASK     0x00000003
#define REG_PHY_RXFD_IF125_LNA_ANT0_SHIFT    0
#define REG_PHY_RXFD_IF125_LNA_ANT0_WIDTH    2

/* PHY_RXFD_IF125_PGC1_ANT0 */
/* agc calculation gain ant0  */
#define REG_PHY_RXFD_IF125_PGC1_ANT0          0x10494
#define REG_PHY_RXFD_IF125_PGC1_ANT0_MASK     0x000000fc
#define REG_PHY_RXFD_IF125_PGC1_ANT0_SHIFT    2
#define REG_PHY_RXFD_IF125_PGC1_ANT0_WIDTH    6

/* PHY_RXFD_IF125_PGC2_ANT0 */
/* agc calculation gain ant0  */
#define REG_PHY_RXFD_IF125_PGC2_ANT0          0x10494
#define REG_PHY_RXFD_IF125_PGC2_ANT0_MASK     0x00003f00
#define REG_PHY_RXFD_IF125_PGC2_ANT0_SHIFT    8
#define REG_PHY_RXFD_IF125_PGC2_ANT0_WIDTH    6

/* PHY_RXFD_IF126_PGC3_ANT0 */
/* agc calculation gain ant0  */
#define REG_PHY_RXFD_IF126_PGC3_ANT0          0x10498
#define REG_PHY_RXFD_IF126_PGC3_ANT0_MASK     0x0000003f
#define REG_PHY_RXFD_IF126_PGC3_ANT0_SHIFT    0
#define REG_PHY_RXFD_IF126_PGC3_ANT0_WIDTH    6

/* PHY_RXFD_IF127_LNA_ANT1 */
/* agc calculation gain ant1 */
#define REG_PHY_RXFD_IF127_LNA_ANT1          0x1049C
#define REG_PHY_RXFD_IF127_LNA_ANT1_MASK     0x00000003
#define REG_PHY_RXFD_IF127_LNA_ANT1_SHIFT    0
#define REG_PHY_RXFD_IF127_LNA_ANT1_WIDTH    2

/* PHY_RXFD_IF127_PGC1_ANT1 */
/* agc calculation gain ant1 */
#define REG_PHY_RXFD_IF127_PGC1_ANT1          0x1049C
#define REG_PHY_RXFD_IF127_PGC1_ANT1_MASK     0x000000fc
#define REG_PHY_RXFD_IF127_PGC1_ANT1_SHIFT    2
#define REG_PHY_RXFD_IF127_PGC1_ANT1_WIDTH    6

/* PHY_RXFD_IF127_PGC2_ANT1 */
/* agc calculation gain ant1 */
#define REG_PHY_RXFD_IF127_PGC2_ANT1          0x1049C
#define REG_PHY_RXFD_IF127_PGC2_ANT1_MASK     0x00003f00
#define REG_PHY_RXFD_IF127_PGC2_ANT1_SHIFT    8
#define REG_PHY_RXFD_IF127_PGC2_ANT1_WIDTH    6

/* PHY_RXFD_IF128_PGC3_ANT1 */
/* agc calculation gain ant1 */
#define REG_PHY_RXFD_IF128_PGC3_ANT1          0x104A0
#define REG_PHY_RXFD_IF128_PGC3_ANT1_MASK     0x0000003f
#define REG_PHY_RXFD_IF128_PGC3_ANT1_SHIFT    0
#define REG_PHY_RXFD_IF128_PGC3_ANT1_WIDTH    6

/* PHY_RXFD_IF129_LNA_ANT2 */
/* agc calculation gain ant2 */
#define REG_PHY_RXFD_IF129_LNA_ANT2          0x104A4
#define REG_PHY_RXFD_IF129_LNA_ANT2_MASK     0x00000003
#define REG_PHY_RXFD_IF129_LNA_ANT2_SHIFT    0
#define REG_PHY_RXFD_IF129_LNA_ANT2_WIDTH    2

/* PHY_RXFD_IF129_PGC1_ANT2 */
/* agc calculation gain ant2 */
#define REG_PHY_RXFD_IF129_PGC1_ANT2          0x104A4
#define REG_PHY_RXFD_IF129_PGC1_ANT2_MASK     0x000000fc
#define REG_PHY_RXFD_IF129_PGC1_ANT2_SHIFT    2
#define REG_PHY_RXFD_IF129_PGC1_ANT2_WIDTH    6

/* PHY_RXFD_IF129_PGC2_ANT2 */
/* agc calculation gain ant2 */
#define REG_PHY_RXFD_IF129_PGC2_ANT2          0x104A4
#define REG_PHY_RXFD_IF129_PGC2_ANT2_MASK     0x00003f00
#define REG_PHY_RXFD_IF129_PGC2_ANT2_SHIFT    8
#define REG_PHY_RXFD_IF129_PGC2_ANT2_WIDTH    6

/* PHY_RXFD_IF12A_PGC3_ANT2 */
/* agc calculation gain ant2 */
#define REG_PHY_RXFD_IF12A_PGC3_ANT2          0x104A8
#define REG_PHY_RXFD_IF12A_PGC3_ANT2_MASK     0x0000003f
#define REG_PHY_RXFD_IF12A_PGC3_ANT2_SHIFT    0
#define REG_PHY_RXFD_IF12A_PGC3_ANT2_WIDTH    6

/* PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT0 */
/* flat correction calculation for channel preparation */
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT0          0x104AC
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT0_MASK     0x000000ff
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT0_SHIFT    0
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT0_WIDTH    8

/* PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT1 */
/* flat correction calculation for channel preparation */
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT1          0x104AC
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT1_MASK     0x0000ff00
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT1_SHIFT    8
#define REG_PHY_RXFD_IF12B_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT1_WIDTH    8

/* PHY_RXFD_IF12C_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT2 */
/* flat correction calculation for channel preparation */
#define REG_PHY_RXFD_IF12C_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT2          0x104B0
#define REG_PHY_RXFD_IF12C_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT2_MASK     0x000000ff
#define REG_PHY_RXFD_IF12C_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT2_SHIFT    0
#define REG_PHY_RXFD_IF12C_IMPL_CHANN_PRE_FLAT_CORRECTION_ANT2_WIDTH    8

/* PHY_RXFD_IF12D_FLAT_CORRECTION_CALC_CH_PRE_UNIT_DONE */
/* this signal rise when genrisc finnish correction calculation  */
#define REG_PHY_RXFD_IF12D_FLAT_CORRECTION_CALC_CH_PRE_UNIT_DONE          0x104B4
#define REG_PHY_RXFD_IF12D_FLAT_CORRECTION_CALC_CH_PRE_UNIT_DONE_MASK     0x00000004
#define REG_PHY_RXFD_IF12D_FLAT_CORRECTION_CALC_CH_PRE_UNIT_DONE_SHIFT    2
#define REG_PHY_RXFD_IF12D_FLAT_CORRECTION_CALC_CH_PRE_UNIT_DONE_WIDTH    1

/* PHY_RXFD_IF12D_EXPL_IMPL_N_MODE */
/* expl_impl_n_mode */
#define REG_PHY_RXFD_IF12D_EXPL_IMPL_N_MODE          0x104B4
#define REG_PHY_RXFD_IF12D_EXPL_IMPL_N_MODE_MASK     0x00000008
#define REG_PHY_RXFD_IF12D_EXPL_IMPL_N_MODE_SHIFT    3
#define REG_PHY_RXFD_IF12D_EXPL_IMPL_N_MODE_WIDTH    1

/* PHY_RXFD_IF12D_GENRISC_BF_EN */
/* genrisc_bf_en */
#define REG_PHY_RXFD_IF12D_GENRISC_BF_EN          0x104B4
#define REG_PHY_RXFD_IF12D_GENRISC_BF_EN_MASK     0x00000010
#define REG_PHY_RXFD_IF12D_GENRISC_BF_EN_SHIFT    4
#define REG_PHY_RXFD_IF12D_GENRISC_BF_EN_WIDTH    1

/* PHY_RXFD_IF12D_GENRISC_UPLOAD_CH_EN */
/* genrisc_upload_ch_en */
#define REG_PHY_RXFD_IF12D_GENRISC_UPLOAD_CH_EN          0x104B4
#define REG_PHY_RXFD_IF12D_GENRISC_UPLOAD_CH_EN_MASK     0x00000020
#define REG_PHY_RXFD_IF12D_GENRISC_UPLOAD_CH_EN_SHIFT    5
#define REG_PHY_RXFD_IF12D_GENRISC_UPLOAD_CH_EN_WIDTH    1

/* PHY_RXFD_IF12D_MCS_FEEDBACK_DISABLE */
/* mcs_feedback_disable */
#define REG_PHY_RXFD_IF12D_MCS_FEEDBACK_DISABLE          0x104B4
#define REG_PHY_RXFD_IF12D_MCS_FEEDBACK_DISABLE_MASK     0x00000040
#define REG_PHY_RXFD_IF12D_MCS_FEEDBACK_DISABLE_SHIFT    6
#define REG_PHY_RXFD_IF12D_MCS_FEEDBACK_DISABLE_WIDTH    1

/* PHY_RXFD_IF12E_SPHERE_MAX_LLR */
/* sphere_max_llr */
#define REG_PHY_RXFD_IF12E_SPHERE_MAX_LLR          0x104B8
#define REG_PHY_RXFD_IF12E_SPHERE_MAX_LLR_MASK     0x000003FF
#define REG_PHY_RXFD_IF12E_SPHERE_MAX_LLR_SHIFT    0
#define REG_PHY_RXFD_IF12E_SPHERE_MAX_LLR_WIDTH    10

/* PHY_RXFD_IF12E_SPHERE_NOISE_POWER_PROG_MODEL */
/* sphere_noise_power_prog_model */
#define REG_PHY_RXFD_IF12E_SPHERE_NOISE_POWER_PROG_MODEL          0x104B8
#define REG_PHY_RXFD_IF12E_SPHERE_NOISE_POWER_PROG_MODEL_MASK     0x00007000
#define REG_PHY_RXFD_IF12E_SPHERE_NOISE_POWER_PROG_MODEL_SHIFT    12
#define REG_PHY_RXFD_IF12E_SPHERE_NOISE_POWER_PROG_MODEL_WIDTH    3

/* PHY_RXFD_IF12F_SPHERE_TREE_PART_THR */
/* sphere_tree_part_thr */
#define REG_PHY_RXFD_IF12F_SPHERE_TREE_PART_THR          0x104BC
#define REG_PHY_RXFD_IF12F_SPHERE_TREE_PART_THR_MASK     0x00000007
#define REG_PHY_RXFD_IF12F_SPHERE_TREE_PART_THR_SHIFT    0
#define REG_PHY_RXFD_IF12F_SPHERE_TREE_PART_THR_WIDTH    3

/* PHY_RXFD_IF12F_SPHERE_LLR_THRESHOLD */
/* sphere_llr_threshold */
#define REG_PHY_RXFD_IF12F_SPHERE_LLR_THRESHOLD          0x104BC
#define REG_PHY_RXFD_IF12F_SPHERE_LLR_THRESHOLD_MASK     0x000001F0
#define REG_PHY_RXFD_IF12F_SPHERE_LLR_THRESHOLD_SHIFT    4
#define REG_PHY_RXFD_IF12F_SPHERE_LLR_THRESHOLD_WIDTH    5

/* PHY_RXFD_IF12F_SPHERE_NOISE_POWER_TREE_PART_THR */
/* sphere_noise_power_tree_part_thr */
#define REG_PHY_RXFD_IF12F_SPHERE_NOISE_POWER_TREE_PART_THR          0x104BC
#define REG_PHY_RXFD_IF12F_SPHERE_NOISE_POWER_TREE_PART_THR_MASK     0x00000200
#define REG_PHY_RXFD_IF12F_SPHERE_NOISE_POWER_TREE_PART_THR_SHIFT    9
#define REG_PHY_RXFD_IF12F_SPHERE_NOISE_POWER_TREE_PART_THR_WIDTH    1

/* PHY_RXFD_IF12F_NOISE_TRK_GAIN_IN_MIN */
/* noise_trk_gain_in_min */
#define REG_PHY_RXFD_IF12F_NOISE_TRK_GAIN_IN_MIN          0x104BC
#define REG_PHY_RXFD_IF12F_NOISE_TRK_GAIN_IN_MIN_MASK     0x0000F800
#define REG_PHY_RXFD_IF12F_NOISE_TRK_GAIN_IN_MIN_SHIFT    11
#define REG_PHY_RXFD_IF12F_NOISE_TRK_GAIN_IN_MIN_WIDTH    5

/* PHY_RXFD_IF130_CT_DATA_E4_IN_FOR_IIR0 */
/* ct_data_e4_in_for_iir0 */
#define REG_PHY_RXFD_IF130_CT_DATA_E4_IN_FOR_IIR0          0x104C0
#define REG_PHY_RXFD_IF130_CT_DATA_E4_IN_FOR_IIR0_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF130_CT_DATA_E4_IN_FOR_IIR0_SHIFT    0
#define REG_PHY_RXFD_IF130_CT_DATA_E4_IN_FOR_IIR0_WIDTH    16

/* PHY_RXFD_IF131_CT_DATA_E4_IN_FOR_IIR1 */
/* ct_data_e4_in_for_iir1 */
#define REG_PHY_RXFD_IF131_CT_DATA_E4_IN_FOR_IIR1          0x104C4
#define REG_PHY_RXFD_IF131_CT_DATA_E4_IN_FOR_IIR1_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF131_CT_DATA_E4_IN_FOR_IIR1_SHIFT    0
#define REG_PHY_RXFD_IF131_CT_DATA_E4_IN_FOR_IIR1_WIDTH    16

/* PHY_RXFD_IF132_CT_DATA_E4_IN_FOR_IIR2 */
/* ct_data_e4_in_for_iir2 */
#define REG_PHY_RXFD_IF132_CT_DATA_E4_IN_FOR_IIR2          0x104C8
#define REG_PHY_RXFD_IF132_CT_DATA_E4_IN_FOR_IIR2_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF132_CT_DATA_E4_IN_FOR_IIR2_SHIFT    0
#define REG_PHY_RXFD_IF132_CT_DATA_E4_IN_FOR_IIR2_WIDTH    16

/* PHY_RXFD_IF133_CT_DATA_E4_IN_FOR_IIR3 */
/* ct_data_e4_in_for_iir3 */
#define REG_PHY_RXFD_IF133_CT_DATA_E4_IN_FOR_IIR3          0x104CC
#define REG_PHY_RXFD_IF133_CT_DATA_E4_IN_FOR_IIR3_MASK     0x0000FFFF
#define REG_PHY_RXFD_IF133_CT_DATA_E4_IN_FOR_IIR3_SHIFT    0
#define REG_PHY_RXFD_IF133_CT_DATA_E4_IN_FOR_IIR3_WIDTH    16

/* PHY_RXFD_IF134_NOISE_TRK_NOISE_IDENTITY_REG */
/* noise_trk_noise_identity_reg */
#define REG_PHY_RXFD_IF134_NOISE_TRK_NOISE_IDENTITY_REG          0x104D0
#define REG_PHY_RXFD_IF134_NOISE_TRK_NOISE_IDENTITY_REG_MASK     0x0000003f
#define REG_PHY_RXFD_IF134_NOISE_TRK_NOISE_IDENTITY_REG_SHIFT    0
#define REG_PHY_RXFD_IF134_NOISE_TRK_NOISE_IDENTITY_REG_WIDTH    6
#endif 
