/*******************************************************************
*                                                                   
*  PHY_RX_TD_IF_Risc_Page_0_td.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_TD_IF_Risc_Page_0_td_regs_H_FILE
#define PHY_RX_TD_IF_Risc_Page_0_td_regs_H_FILE

/* PHY_RXTD_IF00_RISC_GPI_LOW */
/*  IF Semaphore reg00.\n GPI[15:0] Register connected to RFIC.\nReads the incoming Data from the Pads */
#define REG_PHY_RXTD_IF00_RISC_GPI_LOW          0x10000
#define REG_PHY_RXTD_IF00_RISC_GPI_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF00_RISC_GPI_LOW_SHIFT    0
#define REG_PHY_RXTD_IF00_RISC_GPI_LOW_WIDTH    16

/* PHY_RXTD_IF01_RISC_GPI_HIGH */
/*  IF Semaphore reg01.\n GPI[31:16] Register connected to RFIC.\nReads the incoming Data from the Pads */
#define REG_PHY_RXTD_IF01_RISC_GPI_HIGH          0x10004
#define REG_PHY_RXTD_IF01_RISC_GPI_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF01_RISC_GPI_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF01_RISC_GPI_HIGH_WIDTH    16

/* PHY_RXTD_IF00_RISC_GPO_LOW */
/*  IF Semaphore reg00.\n GPO[15:0] Register connected to RFIC.\nReads the incoming Data from the Pads */
#define REG_PHY_RXTD_IF00_RISC_GPO_LOW          0x10000
#define REG_PHY_RXTD_IF00_RISC_GPO_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF00_RISC_GPO_LOW_SHIFT    0
#define REG_PHY_RXTD_IF00_RISC_GPO_LOW_WIDTH    16

/* PHY_RXTD_IF01_RISC_GPO_HIGH */
/*  IF Semaphore reg01.\n GPO[31:16] Register connected to RFIC.\nReads the incoming Data from the Pads */
#define REG_PHY_RXTD_IF01_RISC_GPO_HIGH          0x10004
#define REG_PHY_RXTD_IF01_RISC_GPO_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF01_RISC_GPO_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF01_RISC_GPO_HIGH_WIDTH    16

/* PHY_RXTD_IF02_RISC_GPIO_OEN_LOW */
/*  IF Semaphore reg02.\nthe oen for semaphore reg00 0- output 1- Input. */
#define REG_PHY_RXTD_IF02_RISC_GPIO_OEN_LOW          0x10008
#define REG_PHY_RXTD_IF02_RISC_GPIO_OEN_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF02_RISC_GPIO_OEN_LOW_SHIFT    0
#define REG_PHY_RXTD_IF02_RISC_GPIO_OEN_LOW_WIDTH    16

/* PHY_RXTD_IF03_RISC_GPIO_OEN_HIGH */
/*  IF Semaphore reg03.\nthe oen for semaphore reg01 0- output 1- Input. */
#define REG_PHY_RXTD_IF03_RISC_GPIO_OEN_HIGH          0x1000C
#define REG_PHY_RXTD_IF03_RISC_GPIO_OEN_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF03_RISC_GPIO_OEN_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF03_RISC_GPIO_OEN_HIGH_WIDTH    16

/* PHY_RXTD_IF04_SEMAPHORE_REG_04 */
/* GenRisc operational mode: 0=normal, 1=loopback */
#define REG_PHY_RXTD_IF04_SEMAPHORE_REG_04          0x10010
#define REG_PHY_RXTD_IF04_SEMAPHORE_REG_04_MASK     0x0000ffff
#define REG_PHY_RXTD_IF04_SEMAPHORE_REG_04_SHIFT    0
#define REG_PHY_RXTD_IF04_SEMAPHORE_REG_04_WIDTH    16

/* PHY_RXTD_IF05_SEMAPHORE_REG_05 */
/*  IF Semaphore reg05. */
#define REG_PHY_RXTD_IF05_SEMAPHORE_REG_05          0x10014
#define REG_PHY_RXTD_IF05_SEMAPHORE_REG_05_MASK     0x0000ffff
#define REG_PHY_RXTD_IF05_SEMAPHORE_REG_05_SHIFT    0
#define REG_PHY_RXTD_IF05_SEMAPHORE_REG_05_WIDTH    16

/* PHY_RXTD_IF06_SEMAPHORE_REG_06 */
/*  IF Semaphore reg06. */
#define REG_PHY_RXTD_IF06_SEMAPHORE_REG_06          0x10018
#define REG_PHY_RXTD_IF06_SEMAPHORE_REG_06_MASK     0x0000ffff
#define REG_PHY_RXTD_IF06_SEMAPHORE_REG_06_SHIFT    0
#define REG_PHY_RXTD_IF06_SEMAPHORE_REG_06_WIDTH    16

/* PHY_RXTD_IF07_SEMAPHORE_REG_07 */
/*  IF Semaphore reg07. */
#define REG_PHY_RXTD_IF07_SEMAPHORE_REG_07          0x1001C
#define REG_PHY_RXTD_IF07_SEMAPHORE_REG_07_MASK     0x0000ffff
#define REG_PHY_RXTD_IF07_SEMAPHORE_REG_07_SHIFT    0
#define REG_PHY_RXTD_IF07_SEMAPHORE_REG_07_WIDTH    16

/* PHY_RXTD_IF08_SEMAPHORE_REG_08 */
/*  IF Semaphore reg08. */
#define REG_PHY_RXTD_IF08_SEMAPHORE_REG_08          0x10020
#define REG_PHY_RXTD_IF08_SEMAPHORE_REG_08_MASK     0x0000ffff
#define REG_PHY_RXTD_IF08_SEMAPHORE_REG_08_SHIFT    0
#define REG_PHY_RXTD_IF08_SEMAPHORE_REG_08_WIDTH    16

/* PHY_RXTD_IF09_SEMAPHORE_REG_09 */
/*  IF Semaphore reg09. */
#define REG_PHY_RXTD_IF09_SEMAPHORE_REG_09          0x10024
#define REG_PHY_RXTD_IF09_SEMAPHORE_REG_09_MASK     0x0000ffff
#define REG_PHY_RXTD_IF09_SEMAPHORE_REG_09_SHIFT    0
#define REG_PHY_RXTD_IF09_SEMAPHORE_REG_09_WIDTH    16

/* PHY_RXTD_IF0A_IQ_MISMATCH_GAIN_W1_REG_AN0 */
/* iq_mismatch_gain_w1_reg_an0 */
#define REG_PHY_RXTD_IF0A_IQ_MISMATCH_GAIN_W1_REG_AN0          0x10028
#define REG_PHY_RXTD_IF0A_IQ_MISMATCH_GAIN_W1_REG_AN0_MASK     0x00003fff
#define REG_PHY_RXTD_IF0A_IQ_MISMATCH_GAIN_W1_REG_AN0_SHIFT    0
#define REG_PHY_RXTD_IF0A_IQ_MISMATCH_GAIN_W1_REG_AN0_WIDTH    14

/* PHY_RXTD_IF0B_IQ_MISMATCH_GAIN_W2_REG_AN0 */
/* iq_mismatch_gain_w2_reg_an0 */
#define REG_PHY_RXTD_IF0B_IQ_MISMATCH_GAIN_W2_REG_AN0          0x1002C
#define REG_PHY_RXTD_IF0B_IQ_MISMATCH_GAIN_W2_REG_AN0_MASK     0x00007fff
#define REG_PHY_RXTD_IF0B_IQ_MISMATCH_GAIN_W2_REG_AN0_SHIFT    0
#define REG_PHY_RXTD_IF0B_IQ_MISMATCH_GAIN_W2_REG_AN0_WIDTH    15

/* PHY_RXTD_IF0C_IQ_MISMATCH_GAIN_W1_REG_AN1 */
/* iq_mismatch_gain_w1_reg_an1 */
#define REG_PHY_RXTD_IF0C_IQ_MISMATCH_GAIN_W1_REG_AN1          0x10030
#define REG_PHY_RXTD_IF0C_IQ_MISMATCH_GAIN_W1_REG_AN1_MASK     0x00003fff
#define REG_PHY_RXTD_IF0C_IQ_MISMATCH_GAIN_W1_REG_AN1_SHIFT    0
#define REG_PHY_RXTD_IF0C_IQ_MISMATCH_GAIN_W1_REG_AN1_WIDTH    14

/* PHY_RXTD_IF0D_IQ_MISMATCH_GAIN_W2_REG_AN1 */
/* iq_mismatch_gain_w2_reg_an1 */
#define REG_PHY_RXTD_IF0D_IQ_MISMATCH_GAIN_W2_REG_AN1          0x10034
#define REG_PHY_RXTD_IF0D_IQ_MISMATCH_GAIN_W2_REG_AN1_MASK     0x00007fff
#define REG_PHY_RXTD_IF0D_IQ_MISMATCH_GAIN_W2_REG_AN1_SHIFT    0
#define REG_PHY_RXTD_IF0D_IQ_MISMATCH_GAIN_W2_REG_AN1_WIDTH    15

/* PHY_RXTD_IF0E_IQ_MISMATCH_GAIN_W1_REG_AN2 */
/* iq_mismatch_gain_w1_reg_an2 */
#define REG_PHY_RXTD_IF0E_IQ_MISMATCH_GAIN_W1_REG_AN2          0x10038
#define REG_PHY_RXTD_IF0E_IQ_MISMATCH_GAIN_W1_REG_AN2_MASK     0x00003fff
#define REG_PHY_RXTD_IF0E_IQ_MISMATCH_GAIN_W1_REG_AN2_SHIFT    0
#define REG_PHY_RXTD_IF0E_IQ_MISMATCH_GAIN_W1_REG_AN2_WIDTH    14

/* PHY_RXTD_IF0F_IQ_MISMATCH_GAIN_W2_REG_AN2 */
/* iq_mismatch_gain_w2_reg_an2 */
#define REG_PHY_RXTD_IF0F_IQ_MISMATCH_GAIN_W2_REG_AN2          0x1003C
#define REG_PHY_RXTD_IF0F_IQ_MISMATCH_GAIN_W2_REG_AN2_MASK     0x00007fff
#define REG_PHY_RXTD_IF0F_IQ_MISMATCH_GAIN_W2_REG_AN2_SHIFT    0
#define REG_PHY_RXTD_IF0F_IQ_MISMATCH_GAIN_W2_REG_AN2_WIDTH    15

/* PHY_RXTD_IF10_DIFI_DPD0_GAIN */
/* difi_dpd0_gain */
#define REG_PHY_RXTD_IF10_DIFI_DPD0_GAIN          0x10040
#define REG_PHY_RXTD_IF10_DIFI_DPD0_GAIN_MASK     0x0000007f
#define REG_PHY_RXTD_IF10_DIFI_DPD0_GAIN_SHIFT    0
#define REG_PHY_RXTD_IF10_DIFI_DPD0_GAIN_WIDTH    7

/* PHY_RXTD_IF10_DIFI_DPD0_LUT */
/* difi_dpd0_lut */
#define REG_PHY_RXTD_IF10_DIFI_DPD0_LUT          0x10040
#define REG_PHY_RXTD_IF10_DIFI_DPD0_LUT_MASK     0x0000ff00
#define REG_PHY_RXTD_IF10_DIFI_DPD0_LUT_SHIFT    8
#define REG_PHY_RXTD_IF10_DIFI_DPD0_LUT_WIDTH    8

/* PHY_RXTD_IF11_DIFI_DPD1_GAIN */
/* difi_dpd1_gain */
#define REG_PHY_RXTD_IF11_DIFI_DPD1_GAIN          0x10044
#define REG_PHY_RXTD_IF11_DIFI_DPD1_GAIN_MASK     0x0000007f
#define REG_PHY_RXTD_IF11_DIFI_DPD1_GAIN_SHIFT    0
#define REG_PHY_RXTD_IF11_DIFI_DPD1_GAIN_WIDTH    7

/* PHY_RXTD_IF11_DIFI_DPD1_LUT */
/* difi_dpd1_lut */
#define REG_PHY_RXTD_IF11_DIFI_DPD1_LUT          0x10044
#define REG_PHY_RXTD_IF11_DIFI_DPD1_LUT_MASK     0x0000ff00
#define REG_PHY_RXTD_IF11_DIFI_DPD1_LUT_SHIFT    8
#define REG_PHY_RXTD_IF11_DIFI_DPD1_LUT_WIDTH    8

/* PHY_RXTD_IF12_DIFI_DPD2_GAIN */
/* difi_dpd2_gain */
#define REG_PHY_RXTD_IF12_DIFI_DPD2_GAIN          0x10048
#define REG_PHY_RXTD_IF12_DIFI_DPD2_GAIN_MASK     0x0000007f
#define REG_PHY_RXTD_IF12_DIFI_DPD2_GAIN_SHIFT    0
#define REG_PHY_RXTD_IF12_DIFI_DPD2_GAIN_WIDTH    7

/* PHY_RXTD_IF12_DIFI_DPD2_LUT */
/* difi_dpd2_lut */
#define REG_PHY_RXTD_IF12_DIFI_DPD2_LUT          0x10048
#define REG_PHY_RXTD_IF12_DIFI_DPD2_LUT_MASK     0x0000ff00
#define REG_PHY_RXTD_IF12_DIFI_DPD2_LUT_SHIFT    8
#define REG_PHY_RXTD_IF12_DIFI_DPD2_LUT_WIDTH    8

/* PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS */
/* difi_f3to1_tx_bypass
if tx_active and tx_bypass=> tx bypass the filter3to1
if rx_active and tx_active and tx_bypass => rx_mode and tx is bypassed
if rx_active and tx_active and ~tx_bypass => tx_mode and rx is ignored */
#define REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS          0x1004C
#define REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS_MASK     0x00000007
#define REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS_SHIFT    0
#define REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS_WIDTH    3

/* PHY_RXTD_IF13_DIFI_RX0_ANT_MUX */
/* difi_rx0_ant_mux
0: afe 0
1: afe 1
2: afe 2 */
#define REG_PHY_RXTD_IF13_DIFI_RX0_ANT_MUX          0x1004C
#define REG_PHY_RXTD_IF13_DIFI_RX0_ANT_MUX_MASK     0x00000030
#define REG_PHY_RXTD_IF13_DIFI_RX0_ANT_MUX_SHIFT    4
#define REG_PHY_RXTD_IF13_DIFI_RX0_ANT_MUX_WIDTH    2

/* PHY_RXTD_IF13_DIFI_RX1_ANT_MUX */
/* difi_rx1_ant_mux
0: afe 1
1: afe 0 */
#define REG_PHY_RXTD_IF13_DIFI_RX1_ANT_MUX          0x1004C
#define REG_PHY_RXTD_IF13_DIFI_RX1_ANT_MUX_MASK     0x00000040
#define REG_PHY_RXTD_IF13_DIFI_RX1_ANT_MUX_SHIFT    6
#define REG_PHY_RXTD_IF13_DIFI_RX1_ANT_MUX_WIDTH    1

/* PHY_RXTD_IF13_DIFI_RX2_ANT_MUX */
/* difi_rx2_ant_mux
0: afe 2
1: afe 0 */
#define REG_PHY_RXTD_IF13_DIFI_RX2_ANT_MUX          0x1004C
#define REG_PHY_RXTD_IF13_DIFI_RX2_ANT_MUX_MASK     0x00000080
#define REG_PHY_RXTD_IF13_DIFI_RX2_ANT_MUX_SHIFT    7
#define REG_PHY_RXTD_IF13_DIFI_RX2_ANT_MUX_WIDTH    1

/* PHY_RXTD_IF13_DIFI_TX0_ANT_MUX */
/* difi_tx0_ant_mux
0:tx0
1:tx1
2:tx2 */
#define REG_PHY_RXTD_IF13_DIFI_TX0_ANT_MUX          0x1004C
#define REG_PHY_RXTD_IF13_DIFI_TX0_ANT_MUX_MASK     0x00000300
#define REG_PHY_RXTD_IF13_DIFI_TX0_ANT_MUX_SHIFT    8
#define REG_PHY_RXTD_IF13_DIFI_TX0_ANT_MUX_WIDTH    2

/* PHY_RXTD_IF14_DIFI_SW_CLEAR */
/* difi_sw_clear */
#define REG_PHY_RXTD_IF14_DIFI_SW_CLEAR          0x10050
#define REG_PHY_RXTD_IF14_DIFI_SW_CLEAR_MASK     0x00000007
#define REG_PHY_RXTD_IF14_DIFI_SW_CLEAR_SHIFT    0
#define REG_PHY_RXTD_IF14_DIFI_SW_CLEAR_WIDTH    3

/* PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE */
/* td enable override
used for tx-rx mode:
digiatl loop back, Geortzel etc */
#define REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE          0x1006C
#define REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE_MASK     0x00000001
#define REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE_SHIFT    0
#define REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE_WIDTH    1

/* PHY_RXTD_IF1C_GEN_RISC_MASK_INT */
/* Gen risc Mask Interrupt */
#define REG_PHY_RXTD_IF1C_GEN_RISC_MASK_INT          0x10070
#define REG_PHY_RXTD_IF1C_GEN_RISC_MASK_INT_MASK     0x000007ff
#define REG_PHY_RXTD_IF1C_GEN_RISC_MASK_INT_SHIFT    0
#define REG_PHY_RXTD_IF1C_GEN_RISC_MASK_INT_WIDTH    11

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT0 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT0          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT0_MASK     0x00000001
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT0_SHIFT    0
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT0_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT1 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT1          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT1_MASK     0x00000002
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT1_SHIFT    1
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT1_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT2 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT2          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT2_MASK     0x00000004
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT2_SHIFT    2
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT2_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT3 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT3          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT3_MASK     0x00000008
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT3_SHIFT    3
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT3_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT4 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT4          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT4_MASK     0x00000010
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT4_SHIFT    4
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT4_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT5 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT5          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT5_MASK     0x00000020
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT5_SHIFT    5
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT5_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT6 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT6          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT6_MASK     0x00000040
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT6_SHIFT    6
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT6_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT7 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT7          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT7_MASK     0x00000080
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT7_SHIFT    7
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT7_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT8 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT8          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT8_MASK     0x00000100
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT8_SHIFT    8
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT8_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT9 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT9          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT9_MASK     0x00000200
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT9_SHIFT    9
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT9_WIDTH    1

/* PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT10 */
/* Gen risc Clear Int\nClear_in[0] - clear Int Num0\nClear_in[1] - clear Int Num1\nClear_in[2] - clear Int Num2 */
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT10          0x10074
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT10_MASK     0x00000400
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT10_SHIFT    10
#define REG_PHY_RXTD_IF1D_GEN_RISC_CLEAR_INT10_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_NOISE_CAUSE_INT0 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_NOISE_CAUSE_INT0          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_NOISE_CAUSE_INT0_MASK     0x00000001
#define REG_PHY_RXTD_IF1E_GEN_RISC_NOISE_CAUSE_INT0_SHIFT    0
#define REG_PHY_RXTD_IF1E_GEN_RISC_NOISE_CAUSE_INT0_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_TX_EN_START_CAUSE_INT1 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_START_CAUSE_INT1          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_START_CAUSE_INT1_MASK     0x00000002
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_START_CAUSE_INT1_SHIFT    1
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_START_CAUSE_INT1_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_TX_EN_END_CAUSE_INT2 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_END_CAUSE_INT2          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_END_CAUSE_INT2_MASK     0x00000004
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_END_CAUSE_INT2_SHIFT    2
#define REG_PHY_RXTD_IF1E_GEN_RISC_TX_EN_END_CAUSE_INT2_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_RX_LATCH_FALLING_RX_RDY_CAUSE_INT3 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_RX_LATCH_FALLING_RX_RDY_CAUSE_INT3          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_RX_LATCH_FALLING_RX_RDY_CAUSE_INT3_MASK     0x00000008
#define REG_PHY_RXTD_IF1E_GEN_RISC_RX_LATCH_FALLING_RX_RDY_CAUSE_INT3_SHIFT    3
#define REG_PHY_RXTD_IF1E_GEN_RISC_RX_LATCH_FALLING_RX_RDY_CAUSE_INT3_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_ERROR_CAUSE_INT4 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_ERROR_CAUSE_INT4          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_ERROR_CAUSE_INT4_MASK     0x00000010
#define REG_PHY_RXTD_IF1E_GEN_RISC_ERROR_CAUSE_INT4_SHIFT    4
#define REG_PHY_RXTD_IF1E_GEN_RISC_ERROR_CAUSE_INT4_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_FD_LAST_SYMBOL_CAUSE_INT5 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_FD_LAST_SYMBOL_CAUSE_INT5          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_FD_LAST_SYMBOL_CAUSE_INT5_MASK     0x00000020
#define REG_PHY_RXTD_IF1E_GEN_RISC_FD_LAST_SYMBOL_CAUSE_INT5_SHIFT    5
#define REG_PHY_RXTD_IF1E_GEN_RISC_FD_LAST_SYMBOL_CAUSE_INT5_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT6 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT6          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT6_MASK     0x00000040
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT6_SHIFT    6
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT6_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT7 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT7          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT7_MASK     0x00000080
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT7_SHIFT    7
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT7_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT8 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT8          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT8_MASK     0x00000100
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT8_SHIFT    8
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT8_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT9 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT9          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT9_MASK     0x00000200
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT9_SHIFT    9
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT9_WIDTH    1

/* PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT10 */
/* Gen risc Cause Int\n[0] noise est Int\n[1] pac_phy_tx_en_start\n[2] pac_phy_tx_en_end\n[3] free_running_cnt_int\n[4] rx_error_int hide 16 bits of rx error cause register\n[5] 0\n[6] rx sw int\n[7] rx cca int\n[8] rx be int\n[9] rx fd int\n[10] rx txb int */
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT10          0x10078
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT10_MASK     0x00000400
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT10_SHIFT    10
#define REG_PHY_RXTD_IF1E_GEN_RISC_HOST_CAUSE_INT10_WIDTH    1

/* PHY_RXTD_IF1F_ENABLE_ERROR_INT */
/* Gen Risc Enable Error Int
[0]-coarse error an0.
[1]-coarse error an1.
[2]-coarse error an2.
[3]-fine error an 0.
[4]-fine error an 1.
[5]-fine error an 2.
[6]-fifo overflow an0.
[7]-fifo overflow an1.
[8]-fifo overflow an2.
Csm Errors
[9] lock Timing aborted
[10] update pointer aborted
[11] sym_ready aborted
[12] pop state aborted
[13] update second nco aborted
[14] be error int
[15] 1'b0 */
#define REG_PHY_RXTD_IF1F_ENABLE_ERROR_INT          0x1007C
#define REG_PHY_RXTD_IF1F_ENABLE_ERROR_INT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF1F_ENABLE_ERROR_INT_SHIFT    0
#define REG_PHY_RXTD_IF1F_ENABLE_ERROR_INT_WIDTH    16

/* PHY_RXTD_IF20_CLEAR_ERROR_INT */
/* Gen Risc Clear Enable Error Int
[0]-coarse error an0.
[1]-coarse error an1.
[2]-coarse error an2.
[3]-fine error an 0.
[4]-fine error an 1.
[5]-fine error an 2.
[6]-fifo overflow an0.
[7]-fifo overflow an1.
[8]-fifo overflow an2.
Csm Errors
[9] lock Timing aborted
[10] update pointer aborted
[11] sym_ready aborted
[12] pop state aborted
[13] update second nco aborted
[14] be error int
[15] 1'b0 */
#define REG_PHY_RXTD_IF20_CLEAR_ERROR_INT          0x10080
#define REG_PHY_RXTD_IF20_CLEAR_ERROR_INT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF20_CLEAR_ERROR_INT_SHIFT    0
#define REG_PHY_RXTD_IF20_CLEAR_ERROR_INT_WIDTH    16

/* PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF */
/* rx_rdy_fall_delay_if */
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF          0x10084
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_MASK     0x00000fff
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_SHIFT    0
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_WIDTH    12

/* PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_EN */
/* rx_rdy_fall_delay_if_en */
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_EN          0x10084
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_EN_MASK     0x00001000
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_EN_SHIFT    12
#define REG_PHY_RXTD_IF21_RX_RDY_FALL_DELAY_IF_EN_WIDTH    1

/* PHY_RXTD_IF22_FREE_RUNNING_CNT_LOW_RT */
/* Free Running Counter
read the 16 low bits real time counter. */
#define REG_PHY_RXTD_IF22_FREE_RUNNING_CNT_LOW_RT          0x10088
#define REG_PHY_RXTD_IF22_FREE_RUNNING_CNT_LOW_RT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF22_FREE_RUNNING_CNT_LOW_RT_SHIFT    0
#define REG_PHY_RXTD_IF22_FREE_RUNNING_CNT_LOW_RT_WIDTH    16

/* PHY_RXTD_IF23_OFDM_ENABLE_BIT */
/* ofdm enable bit for csm */
#define REG_PHY_RXTD_IF23_OFDM_ENABLE_BIT          0x1008C
#define REG_PHY_RXTD_IF23_OFDM_ENABLE_BIT_MASK     0x00000001
#define REG_PHY_RXTD_IF23_OFDM_ENABLE_BIT_SHIFT    0
#define REG_PHY_RXTD_IF23_OFDM_ENABLE_BIT_WIDTH    1

/* PHY_RXTD_IF24_CSM_ANTENNA_ENABLE */
/* csm_antenna_enable */
#define REG_PHY_RXTD_IF24_CSM_ANTENNA_ENABLE          0x10090
#define REG_PHY_RXTD_IF24_CSM_ANTENNA_ENABLE_MASK     0x00000007
#define REG_PHY_RXTD_IF24_CSM_ANTENNA_ENABLE_SHIFT    0
#define REG_PHY_RXTD_IF24_CSM_ANTENNA_ENABLE_WIDTH    3

/* PHY_RXTD_IF25_ANTENNA_DELETION */
/* antenna_deletion */
#define REG_PHY_RXTD_IF25_ANTENNA_DELETION          0x10094
#define REG_PHY_RXTD_IF25_ANTENNA_DELETION_MASK     0x00000007
#define REG_PHY_RXTD_IF25_ANTENNA_DELETION_SHIFT    0
#define REG_PHY_RXTD_IF25_ANTENNA_DELETION_WIDTH    3

/* PHY_RXTD_IF26_SYMBOL_PRAM_READY_STM */
/* symbol_pram_ready_stm */
#define REG_PHY_RXTD_IF26_SYMBOL_PRAM_READY_STM          0x10098
#define REG_PHY_RXTD_IF26_SYMBOL_PRAM_READY_STM_MASK     0x00000003
#define REG_PHY_RXTD_IF26_SYMBOL_PRAM_READY_STM_SHIFT    0
#define REG_PHY_RXTD_IF26_SYMBOL_PRAM_READY_STM_WIDTH    2

/* PHY_RXTD_IF26_DELTA_F_STM */
/* delta_f_stm */
#define REG_PHY_RXTD_IF26_DELTA_F_STM          0x10098
#define REG_PHY_RXTD_IF26_DELTA_F_STM_MASK     0x00000030
#define REG_PHY_RXTD_IF26_DELTA_F_STM_SHIFT    4
#define REG_PHY_RXTD_IF26_DELTA_F_STM_WIDTH    2

/* PHY_RXTD_IF27_ANTENNA0_RESET_ENABLE */
/* antenna0_reset_enable */
#define REG_PHY_RXTD_IF27_ANTENNA0_RESET_ENABLE          0x1009C
#define REG_PHY_RXTD_IF27_ANTENNA0_RESET_ENABLE_MASK     0x00000001
#define REG_PHY_RXTD_IF27_ANTENNA0_RESET_ENABLE_SHIFT    0
#define REG_PHY_RXTD_IF27_ANTENNA0_RESET_ENABLE_WIDTH    1

/* PHY_RXTD_IF27_ANTENNA1_RESET_ENABLE */
/* antenna0_reset_enable */
#define REG_PHY_RXTD_IF27_ANTENNA1_RESET_ENABLE          0x1009C
#define REG_PHY_RXTD_IF27_ANTENNA1_RESET_ENABLE_MASK     0x00000002
#define REG_PHY_RXTD_IF27_ANTENNA1_RESET_ENABLE_SHIFT    1
#define REG_PHY_RXTD_IF27_ANTENNA1_RESET_ENABLE_WIDTH    1

/* PHY_RXTD_IF27_ANTENNA2_RESET_ENABLE */
/* antenna0_reset_enable */
#define REG_PHY_RXTD_IF27_ANTENNA2_RESET_ENABLE          0x1009C
#define REG_PHY_RXTD_IF27_ANTENNA2_RESET_ENABLE_MASK     0x00000004
#define REG_PHY_RXTD_IF27_ANTENNA2_RESET_ENABLE_SHIFT    2
#define REG_PHY_RXTD_IF27_ANTENNA2_RESET_ENABLE_WIDTH    1

/* PHY_RXTD_IF28_STOP_SIGNAL_TH_IF */
/* stop_signal_th_if */
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF          0x100A0
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_MASK     0x00000fff
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_SHIFT    0
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_WIDTH    12

/* PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_EN */
/* stop_signal_th_if_en */
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_EN          0x100A0
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_EN_MASK     0x00001000
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_EN_SHIFT    12
#define REG_PHY_RXTD_IF28_STOP_SIGNAL_TH_IF_EN_WIDTH    1

/* PHY_RXTD_IF29_RISC_INT6 */
/* Rx TD Risc int 6 */
#define REG_PHY_RXTD_IF29_RISC_INT6          0x100A4
#define REG_PHY_RXTD_IF29_RISC_INT6_MASK     0x00000001
#define REG_PHY_RXTD_IF29_RISC_INT6_SHIFT    0
#define REG_PHY_RXTD_IF29_RISC_INT6_WIDTH    1

/* PHY_RXTD_IF2A_OLA_STATE_AN0 */
/* ola_state_an0 */
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN0          0x100A8
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN0_MASK     0x00000007
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN0_SHIFT    0
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN0_WIDTH    3

/* PHY_RXTD_IF2A_OLA_STATE_AN1 */
/* ola_state_an1 */
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN1          0x100A8
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN1_MASK     0x00000070
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN1_SHIFT    4
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN1_WIDTH    3

/* PHY_RXTD_IF2A_OLA_STATE_AN2 */
/* ola_state_an2 */
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN2          0x100A8
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN2_MASK     0x00000700
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN2_SHIFT    8
#define REG_PHY_RXTD_IF2A_OLA_STATE_AN2_WIDTH    3

/* PHY_RXTD_IF2A_TD_CSM_STATE */
/* td_csm_state */
#define REG_PHY_RXTD_IF2A_TD_CSM_STATE          0x100A8
#define REG_PHY_RXTD_IF2A_TD_CSM_STATE_MASK     0x00007000
#define REG_PHY_RXTD_IF2A_TD_CSM_STATE_SHIFT    12
#define REG_PHY_RXTD_IF2A_TD_CSM_STATE_WIDTH    3

/* PHY_RXTD_IF2B_GEN_RISC_AIRTIME_US */
/* gen_risc_airtime_us */
#define REG_PHY_RXTD_IF2B_GEN_RISC_AIRTIME_US          0x100AC
#define REG_PHY_RXTD_IF2B_GEN_RISC_AIRTIME_US_MASK     0x0000ffff
#define REG_PHY_RXTD_IF2B_GEN_RISC_AIRTIME_US_SHIFT    0
#define REG_PHY_RXTD_IF2B_GEN_RISC_AIRTIME_US_WIDTH    16

/* PHY_RXTD_IF2C_GEN_RISC_4US_BOUNDARY_OFFSET */
/* gen_risc_4us_boundary_offset */
#define REG_PHY_RXTD_IF2C_GEN_RISC_4US_BOUNDARY_OFFSET          0x100B0
#define REG_PHY_RXTD_IF2C_GEN_RISC_4US_BOUNDARY_OFFSET_MASK     0x00000fff
#define REG_PHY_RXTD_IF2C_GEN_RISC_4US_BOUNDARY_OFFSET_SHIFT    0
#define REG_PHY_RXTD_IF2C_GEN_RISC_4US_BOUNDARY_OFFSET_WIDTH    12

/* PHY_RXTD_IF2C_CCA_CNT_SRC_CTRL */
/* cca_cnt_src_ctrl (0 - gen risc, 1- hw) */
#define REG_PHY_RXTD_IF2C_CCA_CNT_SRC_CTRL          0x100B0
#define REG_PHY_RXTD_IF2C_CCA_CNT_SRC_CTRL_MASK     0x00007000
#define REG_PHY_RXTD_IF2C_CCA_CNT_SRC_CTRL_SHIFT    12
#define REG_PHY_RXTD_IF2C_CCA_CNT_SRC_CTRL_WIDTH    3

/* PHY_RXTD_IF2D_HT_SHORT_IND */
/* ht_short_ind */
#define REG_PHY_RXTD_IF2D_HT_SHORT_IND          0x100B4
#define REG_PHY_RXTD_IF2D_HT_SHORT_IND_MASK     0x00000001
#define REG_PHY_RXTD_IF2D_HT_SHORT_IND_SHIFT    0
#define REG_PHY_RXTD_IF2D_HT_SHORT_IND_WIDTH    1

/* PHY_RXTD_IF2D_CCA_CS */
/* cca_cs */
#define REG_PHY_RXTD_IF2D_CCA_CS          0x100B4
#define REG_PHY_RXTD_IF2D_CCA_CS_MASK     0x00000002
#define REG_PHY_RXTD_IF2D_CCA_CS_SHIFT    1
#define REG_PHY_RXTD_IF2D_CCA_CS_WIDTH    1

/* PHY_RXTD_IF2D_PHY_MAC_CCA */
/* phy_mac_cca */
#define REG_PHY_RXTD_IF2D_PHY_MAC_CCA          0x100B4
#define REG_PHY_RXTD_IF2D_PHY_MAC_CCA_MASK     0x00000004
#define REG_PHY_RXTD_IF2D_PHY_MAC_CCA_SHIFT    2
#define REG_PHY_RXTD_IF2D_PHY_MAC_CCA_WIDTH    1

/* PHY_RXTD_IF2E_PACKET_TYPE */
/* packet_type */
#define REG_PHY_RXTD_IF2E_PACKET_TYPE          0x100B8
#define REG_PHY_RXTD_IF2E_PACKET_TYPE_MASK     0x00000001
#define REG_PHY_RXTD_IF2E_PACKET_TYPE_SHIFT    0
#define REG_PHY_RXTD_IF2E_PACKET_TYPE_WIDTH    1

/* PHY_RXTD_IF2E_IS_HT_SW */
/* is_ht */
#define REG_PHY_RXTD_IF2E_IS_HT_SW          0x100B8
#define REG_PHY_RXTD_IF2E_IS_HT_SW_MASK     0x00000008
#define REG_PHY_RXTD_IF2E_IS_HT_SW_SHIFT    3
#define REG_PHY_RXTD_IF2E_IS_HT_SW_WIDTH    1

/* PHY_RXTD_IF2E_CCA_BUSY_GEN_RISC */
/* cca_busy_gen_risc */
#define REG_PHY_RXTD_IF2E_CCA_BUSY_GEN_RISC          0x100B8
#define REG_PHY_RXTD_IF2E_CCA_BUSY_GEN_RISC_MASK     0x00000020
#define REG_PHY_RXTD_IF2E_CCA_BUSY_GEN_RISC_SHIFT    5
#define REG_PHY_RXTD_IF2E_CCA_BUSY_GEN_RISC_WIDTH    1

/* PHY_RXTD_IF2E_CCA_MODE_CTRL */
/* cca_mode_ctrl */
#define REG_PHY_RXTD_IF2E_CCA_MODE_CTRL          0x100B8
#define REG_PHY_RXTD_IF2E_CCA_MODE_CTRL_MASK     0x00000040
#define REG_PHY_RXTD_IF2E_CCA_MODE_CTRL_SHIFT    6
#define REG_PHY_RXTD_IF2E_CCA_MODE_CTRL_WIDTH    1

/* PHY_RXTD_IF2E_IS_HT_SEL */
/* select HW ht of sw ht */
#define REG_PHY_RXTD_IF2E_IS_HT_SEL          0x100B8
#define REG_PHY_RXTD_IF2E_IS_HT_SEL_MASK     0x00000080
#define REG_PHY_RXTD_IF2E_IS_HT_SEL_SHIFT    7
#define REG_PHY_RXTD_IF2E_IS_HT_SEL_WIDTH    1

/* PHY_RXTD_IF2E_GENRISC_RDY_ENABLE */
/* select HW ht of sw ht */
#define REG_PHY_RXTD_IF2E_GENRISC_RDY_ENABLE          0x100B8
#define REG_PHY_RXTD_IF2E_GENRISC_RDY_ENABLE_MASK     0x00000100
#define REG_PHY_RXTD_IF2E_GENRISC_RDY_ENABLE_SHIFT    8
#define REG_PHY_RXTD_IF2E_GENRISC_RDY_ENABLE_WIDTH    1

/* PHY_RXTD_IF2F_DC_REMOVAL_SHIFTER */
/* DC removal shifter */
#define REG_PHY_RXTD_IF2F_DC_REMOVAL_SHIFTER          0x100BC
#define REG_PHY_RXTD_IF2F_DC_REMOVAL_SHIFTER_MASK     0x0000000f
#define REG_PHY_RXTD_IF2F_DC_REMOVAL_SHIFTER_SHIFT    0
#define REG_PHY_RXTD_IF2F_DC_REMOVAL_SHIFTER_WIDTH    4

/* PHY_RXTD_IF30_GEN_RISC_AIRTIME_US_MAX */
/* gen_risc_airtime_us_max
for max airtime */
#define REG_PHY_RXTD_IF30_GEN_RISC_AIRTIME_US_MAX          0x100C0
#define REG_PHY_RXTD_IF30_GEN_RISC_AIRTIME_US_MAX_MASK     0x00000001
#define REG_PHY_RXTD_IF30_GEN_RISC_AIRTIME_US_MAX_SHIFT    0
#define REG_PHY_RXTD_IF30_GEN_RISC_AIRTIME_US_MAX_WIDTH    1

/* PHY_RXTD_IF31_GEN_RISC_AIRTIME_US_OVERRIDE */
/* gen_risc_airtime_us_max
for max airtime */
#define REG_PHY_RXTD_IF31_GEN_RISC_AIRTIME_US_OVERRIDE          0x100C4
#define REG_PHY_RXTD_IF31_GEN_RISC_AIRTIME_US_OVERRIDE_MASK     0x00000001
#define REG_PHY_RXTD_IF31_GEN_RISC_AIRTIME_US_OVERRIDE_SHIFT    0
#define REG_PHY_RXTD_IF31_GEN_RISC_AIRTIME_US_OVERRIDE_WIDTH    1

/* PHY_RXTD_IF34_ERROR_CAUSE_REG */
/* Rx TD Risc Error Cause Reg
[0]-coarse error an0.
[1]-coarse error an1.
[2]-coarse error an2.
[3]-fine error an 0.
[4]-fine error an 1.
[5]-fine error an 2.
[6]-fifo overflow an0.
[7]-fifo overflow an1.
[8]-fifo overflow an2.
Csm Errors
[9] lock Timing aborted
[10] update pointer aborted
[11] sym_ready aborted
[12] pop state aborted
[13] update second nco aborted
[14] be error int
[15] 1'b0 */
#define REG_PHY_RXTD_IF34_ERROR_CAUSE_REG          0x100D0
#define REG_PHY_RXTD_IF34_ERROR_CAUSE_REG_MASK     0x0000ffff
#define REG_PHY_RXTD_IF34_ERROR_CAUSE_REG_SHIFT    0
#define REG_PHY_RXTD_IF34_ERROR_CAUSE_REG_WIDTH    16

/* PHY_RXTD_IF35_TEST_PLUG_16_LOW */
/* Rx TD Risc Test Bus 16 Low */
#define REG_PHY_RXTD_IF35_TEST_PLUG_16_LOW          0x100D4
#define REG_PHY_RXTD_IF35_TEST_PLUG_16_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF35_TEST_PLUG_16_LOW_SHIFT    0
#define REG_PHY_RXTD_IF35_TEST_PLUG_16_LOW_WIDTH    16

/* PHY_RXTD_IF36_TEST_PLUG_LOW */
/* Rx TD Risc Test Bus low \n8 MSB activate the Test Bus Strobe */
#define REG_PHY_RXTD_IF36_TEST_PLUG_LOW          0x100D8
#define REG_PHY_RXTD_IF36_TEST_PLUG_LOW_MASK     0x000000ff
#define REG_PHY_RXTD_IF36_TEST_PLUG_LOW_SHIFT    0
#define REG_PHY_RXTD_IF36_TEST_PLUG_LOW_WIDTH    8

/* PHY_RXTD_IF37_TEST_PLUG_16_MID */
/* Rx TD Risc Test Bus 16 Mid */
#define REG_PHY_RXTD_IF37_TEST_PLUG_16_MID          0x100DC
#define REG_PHY_RXTD_IF37_TEST_PLUG_16_MID_MASK     0x0000ffff
#define REG_PHY_RXTD_IF37_TEST_PLUG_16_MID_SHIFT    0
#define REG_PHY_RXTD_IF37_TEST_PLUG_16_MID_WIDTH    16

/* PHY_RXTD_IF38_TEST_PLUG_MID */
/* Rx TD Risc Test Bus Mid\n8 MSB activate the Test Bus Strobe */
#define REG_PHY_RXTD_IF38_TEST_PLUG_MID          0x100E0
#define REG_PHY_RXTD_IF38_TEST_PLUG_MID_MASK     0x000000ff
#define REG_PHY_RXTD_IF38_TEST_PLUG_MID_SHIFT    0
#define REG_PHY_RXTD_IF38_TEST_PLUG_MID_WIDTH    8

/* PHY_RXTD_IF39_TEST_PLUG_16_HIGH */
/* Rx TD Risc Test Bus 16 High */
#define REG_PHY_RXTD_IF39_TEST_PLUG_16_HIGH          0x100E4
#define REG_PHY_RXTD_IF39_TEST_PLUG_16_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF39_TEST_PLUG_16_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF39_TEST_PLUG_16_HIGH_WIDTH    16

/* PHY_RXTD_IF3A_TEST_PLUG_HIGH */
/* Rx TD Risc Test Bus High\n8 MSB activate the Test Bus Strobe */
#define REG_PHY_RXTD_IF3A_TEST_PLUG_HIGH          0x100E8
#define REG_PHY_RXTD_IF3A_TEST_PLUG_HIGH_MASK     0x000000ff
#define REG_PHY_RXTD_IF3A_TEST_PLUG_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF3A_TEST_PLUG_HIGH_WIDTH    8

/* PHY_RXTD_IF3C_DECIMATOR0_ROUND */
/* Rx TD Risc Decimator antenna 0 Round\n0- round bit 4\n1- round bit 5\n..\n7-round bit 11 */
#define REG_PHY_RXTD_IF3C_DECIMATOR0_ROUND          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR0_ROUND_MASK     0x00000007
#define REG_PHY_RXTD_IF3C_DECIMATOR0_ROUND_SHIFT    0
#define REG_PHY_RXTD_IF3C_DECIMATOR0_ROUND_WIDTH    3

/* PHY_RXTD_IF3C_DECIMATOR1_ROUND */
/* Rx TD Risc Decimator antenna 1 Round\n0- round bit 4\n1- round bit 5\n..\n7-round bit 11 */
#define REG_PHY_RXTD_IF3C_DECIMATOR1_ROUND          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR1_ROUND_MASK     0x00000070
#define REG_PHY_RXTD_IF3C_DECIMATOR1_ROUND_SHIFT    4
#define REG_PHY_RXTD_IF3C_DECIMATOR1_ROUND_WIDTH    3

/* PHY_RXTD_IF3C_DECIMATOR2_ROUND */
/* Rx TD Risc Decimator antenna 2 Round\n0- round bit 4\n1- round bit 5\n..\n7-round bit 11 */
#define REG_PHY_RXTD_IF3C_DECIMATOR2_ROUND          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR2_ROUND_MASK     0x00000700
#define REG_PHY_RXTD_IF3C_DECIMATOR2_ROUND_SHIFT    8
#define REG_PHY_RXTD_IF3C_DECIMATOR2_ROUND_WIDTH    3

/* PHY_RXTD_IF3C_DECIMATOR0_MUL_BY_3 */
/* Rx TD Risc Decimator antenna 0 mul by3  */
#define REG_PHY_RXTD_IF3C_DECIMATOR0_MUL_BY_3          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR0_MUL_BY_3_MASK     0x00000800
#define REG_PHY_RXTD_IF3C_DECIMATOR0_MUL_BY_3_SHIFT    11
#define REG_PHY_RXTD_IF3C_DECIMATOR0_MUL_BY_3_WIDTH    1

/* PHY_RXTD_IF3C_DECIMATOR1_MUL_BY_3 */
/* Rx TD Risc Decimator antenna 1 mul by3  */
#define REG_PHY_RXTD_IF3C_DECIMATOR1_MUL_BY_3          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR1_MUL_BY_3_MASK     0x00001000
#define REG_PHY_RXTD_IF3C_DECIMATOR1_MUL_BY_3_SHIFT    12
#define REG_PHY_RXTD_IF3C_DECIMATOR1_MUL_BY_3_WIDTH    1

/* PHY_RXTD_IF3C_DECIMATOR2_MUL_BY_3 */
/* Rx TD Risc Decimator antenna 2 mul by3  */
#define REG_PHY_RXTD_IF3C_DECIMATOR2_MUL_BY_3          0x100F0
#define REG_PHY_RXTD_IF3C_DECIMATOR2_MUL_BY_3_MASK     0x00002000
#define REG_PHY_RXTD_IF3C_DECIMATOR2_MUL_BY_3_SHIFT    13
#define REG_PHY_RXTD_IF3C_DECIMATOR2_MUL_BY_3_WIDTH    1

/* PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN */
/* gen_risc_test_bus_en */
#define REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN          0x100F4
#define REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_MASK     0x00000007
#define REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_SHIFT    0
#define REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_WIDTH    3

/* PHY_RXTD_IF3E_BS0_ROUND_INIT */
/* bs0_round_init\n0- round bit 8\n1- round bit 9\n..\n7-round bit 15 */
#define REG_PHY_RXTD_IF3E_BS0_ROUND_INIT          0x100F8
#define REG_PHY_RXTD_IF3E_BS0_ROUND_INIT_MASK     0x00000007
#define REG_PHY_RXTD_IF3E_BS0_ROUND_INIT_SHIFT    0
#define REG_PHY_RXTD_IF3E_BS0_ROUND_INIT_WIDTH    3

/* PHY_RXTD_IF3E_BS1_ROUND_INIT */
/* bs1_round_init\n0- round bit 8\n1- round bit 9\n..\n7-round bit 15 */
#define REG_PHY_RXTD_IF3E_BS1_ROUND_INIT          0x100F8
#define REG_PHY_RXTD_IF3E_BS1_ROUND_INIT_MASK     0x00000070
#define REG_PHY_RXTD_IF3E_BS1_ROUND_INIT_SHIFT    4
#define REG_PHY_RXTD_IF3E_BS1_ROUND_INIT_WIDTH    3

/* PHY_RXTD_IF3E_BS2_ROUND_INIT */
/* bs2_round_init\n0- round bit 8\n1- round bit 9\n..\n7-round bit 15 */
#define REG_PHY_RXTD_IF3E_BS2_ROUND_INIT          0x100F8
#define REG_PHY_RXTD_IF3E_BS2_ROUND_INIT_MASK     0x00000700
#define REG_PHY_RXTD_IF3E_BS2_ROUND_INIT_SHIFT    8
#define REG_PHY_RXTD_IF3E_BS2_ROUND_INIT_WIDTH    3

/* PHY_RXTD_IF3E_BS0_MUL_BY_3 */
/* bs0_mul_by_3 */
#define REG_PHY_RXTD_IF3E_BS0_MUL_BY_3          0x100F8
#define REG_PHY_RXTD_IF3E_BS0_MUL_BY_3_MASK     0x00000800
#define REG_PHY_RXTD_IF3E_BS0_MUL_BY_3_SHIFT    11
#define REG_PHY_RXTD_IF3E_BS0_MUL_BY_3_WIDTH    1

/* PHY_RXTD_IF3E_BS1_MUL_BY_3 */
/* bs1_mul_by_3 */
#define REG_PHY_RXTD_IF3E_BS1_MUL_BY_3          0x100F8
#define REG_PHY_RXTD_IF3E_BS1_MUL_BY_3_MASK     0x00001000
#define REG_PHY_RXTD_IF3E_BS1_MUL_BY_3_SHIFT    12
#define REG_PHY_RXTD_IF3E_BS1_MUL_BY_3_WIDTH    1

/* PHY_RXTD_IF3E_BS2_MUL_BY_3 */
/* bs2_mul_by_3 */
#define REG_PHY_RXTD_IF3E_BS2_MUL_BY_3          0x100F8
#define REG_PHY_RXTD_IF3E_BS2_MUL_BY_3_MASK     0x00002000
#define REG_PHY_RXTD_IF3E_BS2_MUL_BY_3_SHIFT    13
#define REG_PHY_RXTD_IF3E_BS2_MUL_BY_3_WIDTH    1

/* AFE_RF_CTRL_RF_RESET_N */
/* RFIC Reset active low */
#define REG_AFE_RF_CTRL_RF_RESET_N          0x100FC
#define REG_AFE_RF_CTRL_RF_RESET_N_MASK     0x00000001
#define REG_AFE_RF_CTRL_RF_RESET_N_SHIFT    0
#define REG_AFE_RF_CTRL_RF_RESET_N_WIDTH    1

/* AFE_DYN_CTRL_RX0_STBY */
/* Rx0 ADC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_RX0_STBY          0x10104
#define REG_AFE_DYN_CTRL_RX0_STBY_MASK     0x00000001
#define REG_AFE_DYN_CTRL_RX0_STBY_SHIFT    0
#define REG_AFE_DYN_CTRL_RX0_STBY_WIDTH    1

/* AFE_DYN_CTRL_RX1_STBY */
/* Rx1 ADC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_RX1_STBY          0x10104
#define REG_AFE_DYN_CTRL_RX1_STBY_MASK     0x00000002
#define REG_AFE_DYN_CTRL_RX1_STBY_SHIFT    1
#define REG_AFE_DYN_CTRL_RX1_STBY_WIDTH    1

/* AFE_DYN_CTRL_RX2_STBY */
/* Rx2 ADC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_RX2_STBY          0x10104
#define REG_AFE_DYN_CTRL_RX2_STBY_MASK     0x00000004
#define REG_AFE_DYN_CTRL_RX2_STBY_SHIFT    2
#define REG_AFE_DYN_CTRL_RX2_STBY_WIDTH    1

/* AFE_DYN_CTRL_TX2_STBY */
/* Tx0 DAC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_TX2_STBY          0x10104
#define REG_AFE_DYN_CTRL_TX2_STBY_MASK     0x00000008
#define REG_AFE_DYN_CTRL_TX2_STBY_SHIFT    3
#define REG_AFE_DYN_CTRL_TX2_STBY_WIDTH    1

/* AFE_DYN_CTRL_TX0_STBY */
/* Tx0 DAC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_TX0_STBY          0x10104
#define REG_AFE_DYN_CTRL_TX0_STBY_MASK     0x00000010
#define REG_AFE_DYN_CTRL_TX0_STBY_SHIFT    4
#define REG_AFE_DYN_CTRL_TX0_STBY_WIDTH    1

/* AFE_DYN_CTRL_TX1_STBY */
/* Tx1 DAC Standby Mode (for I/Q pair) 1-standby 0-on */
#define REG_AFE_DYN_CTRL_TX1_STBY          0x10104
#define REG_AFE_DYN_CTRL_TX1_STBY_MASK     0x00000020
#define REG_AFE_DYN_CTRL_TX1_STBY_SHIFT    5
#define REG_AFE_DYN_CTRL_TX1_STBY_WIDTH    1

/* AFE_DYN_CTRL_AUX0_ADC_STBY */
/* Aux ADC Standby Mode active high 1-standby 0-on */
#define REG_AFE_DYN_CTRL_AUX0_ADC_STBY          0x10104
#define REG_AFE_DYN_CTRL_AUX0_ADC_STBY_MASK     0x00001000
#define REG_AFE_DYN_CTRL_AUX0_ADC_STBY_SHIFT    12
#define REG_AFE_DYN_CTRL_AUX0_ADC_STBY_WIDTH    1

/* AFE_DYN_CTRL_AUX1_ADC_STBY */
/* Aux ADC Standby Mode active high 1-standby 0-on */
#define REG_AFE_DYN_CTRL_AUX1_ADC_STBY          0x10104
#define REG_AFE_DYN_CTRL_AUX1_ADC_STBY_MASK     0x00002000
#define REG_AFE_DYN_CTRL_AUX1_ADC_STBY_SHIFT    13
#define REG_AFE_DYN_CTRL_AUX1_ADC_STBY_WIDTH    1

/* AFE_DYN_CTRL_AUX2_ADC_STBY */
/* Aux ADC Standby Mode active high 1-standby 0-on */
#define REG_AFE_DYN_CTRL_AUX2_ADC_STBY          0x10104
#define REG_AFE_DYN_CTRL_AUX2_ADC_STBY_MASK     0x00004000
#define REG_AFE_DYN_CTRL_AUX2_ADC_STBY_SHIFT    14
#define REG_AFE_DYN_CTRL_AUX2_ADC_STBY_WIDTH    1

/* AFE_PD_CTRL_RX0_PD */
/* Rx0 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_RX0_PD          0x10114
#define REG_AFE_PD_CTRL_RX0_PD_MASK     0x00000001
#define REG_AFE_PD_CTRL_RX0_PD_SHIFT    0
#define REG_AFE_PD_CTRL_RX0_PD_WIDTH    1

/* AFE_PD_CTRL_RX1_PD */
/* Rx1 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_RX1_PD          0x10114
#define REG_AFE_PD_CTRL_RX1_PD_MASK     0x00000002
#define REG_AFE_PD_CTRL_RX1_PD_SHIFT    1
#define REG_AFE_PD_CTRL_RX1_PD_WIDTH    1

/* AFE_PD_CTRL_RX2_PD */
/* Rx2 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_RX2_PD          0x10114
#define REG_AFE_PD_CTRL_RX2_PD_MASK     0x00000004
#define REG_AFE_PD_CTRL_RX2_PD_SHIFT    2
#define REG_AFE_PD_CTRL_RX2_PD_WIDTH    1

/* AFE_PD_CTRL_TX0_PD */
/* Tx0 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_TX0_PD          0x10114
#define REG_AFE_PD_CTRL_TX0_PD_MASK     0x00000008
#define REG_AFE_PD_CTRL_TX0_PD_SHIFT    3
#define REG_AFE_PD_CTRL_TX0_PD_WIDTH    1

/* AFE_PD_CTRL_TX1_PD */
/* Tx1 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_TX1_PD          0x10114
#define REG_AFE_PD_CTRL_TX1_PD_MASK     0x00000010
#define REG_AFE_PD_CTRL_TX1_PD_SHIFT    4
#define REG_AFE_PD_CTRL_TX1_PD_WIDTH    1

/* AFE_PD_CTRL_TX2_PD */
/* Tx1 Channel I ADC Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_TX2_PD          0x10114
#define REG_AFE_PD_CTRL_TX2_PD_MASK     0x00000020
#define REG_AFE_PD_CTRL_TX2_PD_SHIFT    5
#define REG_AFE_PD_CTRL_TX2_PD_WIDTH    1

/* AFE_PD_CTRL_AUX_ADC0_PD */
/* Auxiliary ADC 0 Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_AUX_ADC0_PD          0x10114
#define REG_AFE_PD_CTRL_AUX_ADC0_PD_MASK     0x00000400
#define REG_AFE_PD_CTRL_AUX_ADC0_PD_SHIFT    10
#define REG_AFE_PD_CTRL_AUX_ADC0_PD_WIDTH    1

/* AFE_PD_CTRL_AUX_ADC1_PD */
/* Auxiliary ADC 1 Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_AUX_ADC1_PD          0x10114
#define REG_AFE_PD_CTRL_AUX_ADC1_PD_MASK     0x00000800
#define REG_AFE_PD_CTRL_AUX_ADC1_PD_SHIFT    11
#define REG_AFE_PD_CTRL_AUX_ADC1_PD_WIDTH    1

/* AFE_PD_CTRL_AUX_ADC2_PD */
/* Auxiliary ADC 2 Power Down Mode.\n1 - Power Down\n0 - Enable */
#define REG_AFE_PD_CTRL_AUX_ADC2_PD          0x10114
#define REG_AFE_PD_CTRL_AUX_ADC2_PD_MASK     0x00001000
#define REG_AFE_PD_CTRL_AUX_ADC2_PD_SHIFT    12
#define REG_AFE_PD_CTRL_AUX_ADC2_PD_WIDTH    1

/* AFE_AUX_CTRL_AUX0_CH_EN */
/* Aux0 ADC channel enable */
#define REG_AFE_AUX_CTRL_AUX0_CH_EN          0x1011C
#define REG_AFE_AUX_CTRL_AUX0_CH_EN_MASK     0x00000001
#define REG_AFE_AUX_CTRL_AUX0_CH_EN_SHIFT    0
#define REG_AFE_AUX_CTRL_AUX0_CH_EN_WIDTH    1

/* AFE_AUX_CTRL_AUX1_CH_EN */
/* Aux1 ADC channel enable */
#define REG_AFE_AUX_CTRL_AUX1_CH_EN          0x1011C
#define REG_AFE_AUX_CTRL_AUX1_CH_EN_MASK     0x00000002
#define REG_AFE_AUX_CTRL_AUX1_CH_EN_SHIFT    1
#define REG_AFE_AUX_CTRL_AUX1_CH_EN_WIDTH    1

/* AFE_AUX_CTRL_AUX2_CH_EN */
/* Aux2 ADC channel enable */
#define REG_AFE_AUX_CTRL_AUX2_CH_EN          0x1011C
#define REG_AFE_AUX_CTRL_AUX2_CH_EN_MASK     0x00000004
#define REG_AFE_AUX_CTRL_AUX2_CH_EN_SHIFT    2
#define REG_AFE_AUX_CTRL_AUX2_CH_EN_WIDTH    1

/* RSSI_DATA_REG0_RSSI_0_DATA */
/* rssi_0_data */
#define REG_RSSI_DATA_REG0_RSSI_0_DATA          0x10120
#define REG_RSSI_DATA_REG0_RSSI_0_DATA_MASK     0x000000ff
#define REG_RSSI_DATA_REG0_RSSI_0_DATA_SHIFT    0
#define REG_RSSI_DATA_REG0_RSSI_0_DATA_WIDTH    8

/* RSSI_DATA_REG0_RSSI_1_DATA */
/* rssi_1_data */
#define REG_RSSI_DATA_REG0_RSSI_1_DATA          0x10120
#define REG_RSSI_DATA_REG0_RSSI_1_DATA_MASK     0x0000ff00
#define REG_RSSI_DATA_REG0_RSSI_1_DATA_SHIFT    8
#define REG_RSSI_DATA_REG0_RSSI_1_DATA_WIDTH    8

/* RSSI_DATA_REG1_RSSI_2_DATA */
/* rssi_2_data */
#define REG_RSSI_DATA_REG1_RSSI_2_DATA          0x10124
#define REG_RSSI_DATA_REG1_RSSI_2_DATA_MASK     0x000000ff
#define REG_RSSI_DATA_REG1_RSSI_2_DATA_SHIFT    0
#define REG_RSSI_DATA_REG1_RSSI_2_DATA_WIDTH    8

/* PHY_RXTD_IF4A_TEST_FIFO_FULL */
/* test_fifo_full */
#define REG_PHY_RXTD_IF4A_TEST_FIFO_FULL          0x10128
#define REG_PHY_RXTD_IF4A_TEST_FIFO_FULL_MASK     0x00000007
#define REG_PHY_RXTD_IF4A_TEST_FIFO_FULL_SHIFT    0
#define REG_PHY_RXTD_IF4A_TEST_FIFO_FULL_WIDTH    3

/* PHY_RXTD_IF4A_TB_FIFO_ERROR */
/* tb fifo error
push while full or pop while empty */
#define REG_PHY_RXTD_IF4A_TB_FIFO_ERROR          0x10128
#define REG_PHY_RXTD_IF4A_TB_FIFO_ERROR_MASK     0x00000038
#define REG_PHY_RXTD_IF4A_TB_FIFO_ERROR_SHIFT    3
#define REG_PHY_RXTD_IF4A_TB_FIFO_ERROR_WIDTH    3

/* PHY_RXTD_IF4A_LVDS_FIFO_LOW_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_ERR_IND_MASK     0x00000040
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_ERR_IND_SHIFT    6
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4A_LVDS_FIFO_MID_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_ERR_IND_MASK     0x00000080
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_ERR_IND_SHIFT    7
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4A_LVDS_FIFO_HIGH_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_ERR_IND_MASK     0x00000100
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_ERR_IND_SHIFT    8
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4A_LVDS_FIFO_LOW_CLR_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_CLR_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_CLR_ERR_IND_MASK     0x00000040
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_CLR_ERR_IND_SHIFT    6
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_LOW_CLR_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4A_LVDS_FIFO_MID_CLR_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_CLR_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_CLR_ERR_IND_MASK     0x00000080
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_CLR_ERR_IND_SHIFT    7
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_MID_CLR_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4A_LVDS_FIFO_HIGH_CLR_ERR_IND */
/* lvds_fifo low erro rindication
Push while full indication. */
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_CLR_ERR_IND          0x10128
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_CLR_ERR_IND_MASK     0x00000100
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_CLR_ERR_IND_SHIFT    8
#define REG_PHY_RXTD_IF4A_LVDS_FIFO_HIGH_CLR_ERR_IND_WIDTH    1

/* PHY_RXTD_IF4C_DETECTOR_BYPASS_EN */
/* detector_bypass_en */
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_EN          0x10130
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_EN_MASK     0x00000001
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_EN_SHIFT    0
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_EN_WIDTH    1

/* PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN */
/* detector_bypass_reset_rxtd_en */
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN          0x10130
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN_MASK     0x00000002
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN_SHIFT    1
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN_WIDTH    1

/* PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN */
/* detector_bypass_clear_difi_en */
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN          0x10130
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN_MASK     0x00000004
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN_SHIFT    2
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN_WIDTH    1

/* PHY_RXTD_IF4C_DETECTOR_BYPASS_CNT_VALUE */
/* detector_bypass_cnt_value */
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CNT_VALUE          0x10130
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CNT_VALUE_MASK     0x0000fff0
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CNT_VALUE_SHIFT    4
#define REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CNT_VALUE_WIDTH    12

/* PHY_RXTD_IF4D_ENABLE_CCA_INT */
/* enable_cca_int\n[0]-last sample indication\n[1]-ht_short_ind */
#define REG_PHY_RXTD_IF4D_ENABLE_CCA_INT          0x10134
#define REG_PHY_RXTD_IF4D_ENABLE_CCA_INT_MASK     0x00000003
#define REG_PHY_RXTD_IF4D_ENABLE_CCA_INT_SHIFT    0
#define REG_PHY_RXTD_IF4D_ENABLE_CCA_INT_WIDTH    2

/* PHY_RXTD_IF4E_CLEAR_CCA_INT */
/* clear_cca_int\n[0]-last sample indication\n[1]-ht_short_ind */
#define REG_PHY_RXTD_IF4E_CLEAR_CCA_INT          0x10138
#define REG_PHY_RXTD_IF4E_CLEAR_CCA_INT_MASK     0x00000003
#define REG_PHY_RXTD_IF4E_CLEAR_CCA_INT_SHIFT    0
#define REG_PHY_RXTD_IF4E_CLEAR_CCA_INT_WIDTH    2

/* PHY_RXTD_IF4F_CCA_CAUSE_REG */
/* CCACause Reg\n[0]-last sample indication\n[1]-ht_short_ind */
#define REG_PHY_RXTD_IF4F_CCA_CAUSE_REG          0x1013C
#define REG_PHY_RXTD_IF4F_CCA_CAUSE_REG_MASK     0x00000003
#define REG_PHY_RXTD_IF4F_CCA_CAUSE_REG_SHIFT    0
#define REG_PHY_RXTD_IF4F_CCA_CAUSE_REG_WIDTH    2

/* PHY_RXTD_IF50_NOISE_EST_RISC_AN0 */
/* Noise_est_risc_an0 */
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN0          0x10140
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN0_MASK     0x0000007f
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN0_SHIFT    0
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN0_WIDTH    7

/* PHY_RXTD_IF50_NOISE_EST_RISC_AN1 */
/* Noise_est_risc_an1 */
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN1          0x10140
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN1_MASK     0x00007f00
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN1_SHIFT    8
#define REG_PHY_RXTD_IF50_NOISE_EST_RISC_AN1_WIDTH    7

/* PHY_RXTD_IF51_NOISE_EST_RISC_AN2 */
/* Noise_est_risc_an2 */
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_AN2          0x10144
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_AN2_MASK     0x0000007f
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_AN2_SHIFT    0
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_AN2_WIDTH    7

/* PHY_RXTD_IF51_NOISE_EST_RISC_ALL_VALID */
/* Noise_est_risc_all_valid */
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_ALL_VALID          0x10144
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_ALL_VALID_MASK     0x00000100
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_ALL_VALID_SHIFT    8
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_ALL_VALID_WIDTH    1

/* PHY_RXTD_IF51_NOISE_EST_RISC_SELECT */
/* Noise_est_risc_select */
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_SELECT          0x10144
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_SELECT_MASK     0x00000200
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_SELECT_SHIFT    9
#define REG_PHY_RXTD_IF51_NOISE_EST_RISC_SELECT_WIDTH    1

/* PHY_RXTD_IF52_NOISE_EST_GI0_DATA */
/* Noise Estimation gi0 Data Antenna 0 */
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA          0x10148
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_MASK     0x0000007f
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_SHIFT    0
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_WIDTH    7

/* PHY_RXTD_IF52_NOISE_EST_GI0_DATA_VALID */
/* Noise Estimation gi0 Data Valid Antenna 0 */
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_VALID          0x10148
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_VALID_MASK     0x00000080
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_VALID_SHIFT    7
#define REG_PHY_RXTD_IF52_NOISE_EST_GI0_DATA_VALID_WIDTH    1

/* PHY_RXTD_IF53_NOISE_EST_GI1_DATA */
/* Noise Estimation gi1 Data Antenna 1 */
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA          0x1014C
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_MASK     0x0000007f
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_SHIFT    0
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_WIDTH    7

/* PHY_RXTD_IF53_NOISE_EST_GI1_DATA_VALID */
/* Noise Estimation gi2 Data Valid Antenna 2 */
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_VALID          0x1014C
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_VALID_MASK     0x00000080
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_VALID_SHIFT    7
#define REG_PHY_RXTD_IF53_NOISE_EST_GI1_DATA_VALID_WIDTH    1

/* PHY_RXTD_IF54_NOISE_EST_GI2_DATA */
/* Noise Estimation gi3 Data Antenna 3 */
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA          0x10150
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_MASK     0x0000007f
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_SHIFT    0
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_WIDTH    7

/* PHY_RXTD_IF54_NOISE_EST_GI2_DATA_VALID */
/* Noise Estimation gi4 Data Valid Antenna 4 */
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_VALID          0x10150
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_VALID_MASK     0x00000080
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_VALID_SHIFT    7
#define REG_PHY_RXTD_IF54_NOISE_EST_GI2_DATA_VALID_WIDTH    1

/* PHY_RXTD_IF55_NOISE_EST_ACC_OUT_LOW_AN0 */
/* Noise Estimation Accumulator Data Low An0 */
#define REG_PHY_RXTD_IF55_NOISE_EST_ACC_OUT_LOW_AN0          0x10154
#define REG_PHY_RXTD_IF55_NOISE_EST_ACC_OUT_LOW_AN0_MASK     0x000000FF
#define REG_PHY_RXTD_IF55_NOISE_EST_ACC_OUT_LOW_AN0_SHIFT    0
#define REG_PHY_RXTD_IF55_NOISE_EST_ACC_OUT_LOW_AN0_WIDTH    8

/* PHY_RXTD_IF56_NOISE_EST_ACC_OUT_HIGH_AN0 */
/* Noise Estimation Accumulator Data High An0 */
#define REG_PHY_RXTD_IF56_NOISE_EST_ACC_OUT_HIGH_AN0          0x10158
#define REG_PHY_RXTD_IF56_NOISE_EST_ACC_OUT_HIGH_AN0_MASK     0x0000FFFF
#define REG_PHY_RXTD_IF56_NOISE_EST_ACC_OUT_HIGH_AN0_SHIFT    0
#define REG_PHY_RXTD_IF56_NOISE_EST_ACC_OUT_HIGH_AN0_WIDTH    16

/* PHY_RXTD_IF57_NOISE_EST_ACC_OUT_LOW_AN1 */
/* Noise Estimation Accumulator Data Low An1 */
#define REG_PHY_RXTD_IF57_NOISE_EST_ACC_OUT_LOW_AN1          0x1015C
#define REG_PHY_RXTD_IF57_NOISE_EST_ACC_OUT_LOW_AN1_MASK     0x000000FF
#define REG_PHY_RXTD_IF57_NOISE_EST_ACC_OUT_LOW_AN1_SHIFT    0
#define REG_PHY_RXTD_IF57_NOISE_EST_ACC_OUT_LOW_AN1_WIDTH    8

/* PHY_RXTD_IF58_NOISE_EST_ACC_OUT_HIGH_AN1 */
/* Noise Estimation Accumulator Data High An1 */
#define REG_PHY_RXTD_IF58_NOISE_EST_ACC_OUT_HIGH_AN1          0x10160
#define REG_PHY_RXTD_IF58_NOISE_EST_ACC_OUT_HIGH_AN1_MASK     0x0000FFFF
#define REG_PHY_RXTD_IF58_NOISE_EST_ACC_OUT_HIGH_AN1_SHIFT    0
#define REG_PHY_RXTD_IF58_NOISE_EST_ACC_OUT_HIGH_AN1_WIDTH    16

/* PHY_RXTD_IF59_NOISE_EST_ACC_OUT_LOW_AN2 */
/* Noise Estimation Accumulator Data Low An2 */
#define REG_PHY_RXTD_IF59_NOISE_EST_ACC_OUT_LOW_AN2          0x10164
#define REG_PHY_RXTD_IF59_NOISE_EST_ACC_OUT_LOW_AN2_MASK     0x000000FF
#define REG_PHY_RXTD_IF59_NOISE_EST_ACC_OUT_LOW_AN2_SHIFT    0
#define REG_PHY_RXTD_IF59_NOISE_EST_ACC_OUT_LOW_AN2_WIDTH    8

/* PHY_RXTD_IF5A_NOISE_EST_ACC_OUT_HIGH_AN2 */
/* Noise Estimation Accumulator Data High An2 */
#define REG_PHY_RXTD_IF5A_NOISE_EST_ACC_OUT_HIGH_AN2          0x10168
#define REG_PHY_RXTD_IF5A_NOISE_EST_ACC_OUT_HIGH_AN2_MASK     0x0000FFFF
#define REG_PHY_RXTD_IF5A_NOISE_EST_ACC_OUT_HIGH_AN2_SHIFT    0
#define REG_PHY_RXTD_IF5A_NOISE_EST_ACC_OUT_HIGH_AN2_WIDTH    16

/* PHY_RXTD_IF5B_DET_SC_16_I_AT_COARSE_TIMING_AN0 */
/* Detector Coarse Corr I Data An0 */
#define REG_PHY_RXTD_IF5B_DET_SC_16_I_AT_COARSE_TIMING_AN0          0x1016C
#define REG_PHY_RXTD_IF5B_DET_SC_16_I_AT_COARSE_TIMING_AN0_MASK     0x00003fff
#define REG_PHY_RXTD_IF5B_DET_SC_16_I_AT_COARSE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF5B_DET_SC_16_I_AT_COARSE_TIMING_AN0_WIDTH    14

/* PHY_RXTD_IF5C_DET_SC_16_Q_AT_COARSE_TIMING_AN0 */
/* Detector Coarse Corr I Data An0 */
#define REG_PHY_RXTD_IF5C_DET_SC_16_Q_AT_COARSE_TIMING_AN0          0x10170
#define REG_PHY_RXTD_IF5C_DET_SC_16_Q_AT_COARSE_TIMING_AN0_MASK     0x00003fff
#define REG_PHY_RXTD_IF5C_DET_SC_16_Q_AT_COARSE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF5C_DET_SC_16_Q_AT_COARSE_TIMING_AN0_WIDTH    14

/* PHY_RXTD_IF5D_DET_R_16_USB_AT_COARSE_TIMING_AN0 */
/* Detector Coarse Corr I Data An0 */
#define REG_PHY_RXTD_IF5D_DET_R_16_USB_AT_COARSE_TIMING_AN0          0x10174
#define REG_PHY_RXTD_IF5D_DET_R_16_USB_AT_COARSE_TIMING_AN0_MASK     0x00000fff
#define REG_PHY_RXTD_IF5D_DET_R_16_USB_AT_COARSE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF5D_DET_R_16_USB_AT_COARSE_TIMING_AN0_WIDTH    12

/* PHY_RXTD_IF5E_DET_R_16_LSB_AT_COARSE_TIMING_AN0 */
/* Detector Coarse Corr I Data An0 */
#define REG_PHY_RXTD_IF5E_DET_R_16_LSB_AT_COARSE_TIMING_AN0          0x10178
#define REG_PHY_RXTD_IF5E_DET_R_16_LSB_AT_COARSE_TIMING_AN0_MASK     0x00000fff
#define REG_PHY_RXTD_IF5E_DET_R_16_LSB_AT_COARSE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF5E_DET_R_16_LSB_AT_COARSE_TIMING_AN0_WIDTH    12

/* PHY_RXTD_IF5F_DET_SHORTENED_MA */
/* Shortened moving average decrease parameter. */
#define REG_PHY_RXTD_IF5F_DET_SHORTENED_MA          0x1017C
#define REG_PHY_RXTD_IF5F_DET_SHORTENED_MA_MASK     0x0000007f
#define REG_PHY_RXTD_IF5F_DET_SHORTENED_MA_SHIFT    0
#define REG_PHY_RXTD_IF5F_DET_SHORTENED_MA_WIDTH    7

/* PHY_RXTD_IF5F_DET_BYPASS_DC */
/* det_bypass_dc */
#define REG_PHY_RXTD_IF5F_DET_BYPASS_DC          0x1017C
#define REG_PHY_RXTD_IF5F_DET_BYPASS_DC_MASK     0x00000100
#define REG_PHY_RXTD_IF5F_DET_BYPASS_DC_SHIFT    8
#define REG_PHY_RXTD_IF5F_DET_BYPASS_DC_WIDTH    1

/* PHY_RXTD_IF5F_DET_USE_DIFF */
/* det_use_diff */
#define REG_PHY_RXTD_IF5F_DET_USE_DIFF          0x1017C
#define REG_PHY_RXTD_IF5F_DET_USE_DIFF_MASK     0x00000200
#define REG_PHY_RXTD_IF5F_DET_USE_DIFF_SHIFT    9
#define REG_PHY_RXTD_IF5F_DET_USE_DIFF_WIDTH    1

/* PHY_RXTD_IF60_DET_SC_64_I_AT_FINE_TIMING_AN0 */
/* Detector Coarse Corr I Data An0 */
#define REG_PHY_RXTD_IF60_DET_SC_64_I_AT_FINE_TIMING_AN0          0x10180
#define REG_PHY_RXTD_IF60_DET_SC_64_I_AT_FINE_TIMING_AN0_MASK     0x0000ffff
#define REG_PHY_RXTD_IF60_DET_SC_64_I_AT_FINE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF60_DET_SC_64_I_AT_FINE_TIMING_AN0_WIDTH    16

/* PHY_RXTD_IF61_DET_SC_64_Q_AT_FINE_TIMING_AN0 */
/* Detector Coarse Corr Q Data An0 */
#define REG_PHY_RXTD_IF61_DET_SC_64_Q_AT_FINE_TIMING_AN0          0x10184
#define REG_PHY_RXTD_IF61_DET_SC_64_Q_AT_FINE_TIMING_AN0_MASK     0x0000ffff
#define REG_PHY_RXTD_IF61_DET_SC_64_Q_AT_FINE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF61_DET_SC_64_Q_AT_FINE_TIMING_AN0_WIDTH    16

/* PHY_RXTD_IF62_DET_ABS_SC_AT_COARSE_TIMING_AN0 */
/* Detector Coarse Corr Q Data An0 */
#define REG_PHY_RXTD_IF62_DET_ABS_SC_AT_COARSE_TIMING_AN0          0x10188
#define REG_PHY_RXTD_IF62_DET_ABS_SC_AT_COARSE_TIMING_AN0_MASK     0x00003fff
#define REG_PHY_RXTD_IF62_DET_ABS_SC_AT_COARSE_TIMING_AN0_SHIFT    0
#define REG_PHY_RXTD_IF62_DET_ABS_SC_AT_COARSE_TIMING_AN0_WIDTH    14

/* PHY_RXTD_IF63_DET_ABS_SC_AT_COARSE_TIMING_AN1 */
/* Detector Coarse Corr Q Data An0 */
#define REG_PHY_RXTD_IF63_DET_ABS_SC_AT_COARSE_TIMING_AN1          0x1018C
#define REG_PHY_RXTD_IF63_DET_ABS_SC_AT_COARSE_TIMING_AN1_MASK     0x00003fff
#define REG_PHY_RXTD_IF63_DET_ABS_SC_AT_COARSE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IF63_DET_ABS_SC_AT_COARSE_TIMING_AN1_WIDTH    14

/* PHY_RXTD_IF64_DET_SC_64_I_AT_FINE_TIMING_AN1 */
/* Detector Coarse Corr I Data An1 */
#define REG_PHY_RXTD_IF64_DET_SC_64_I_AT_FINE_TIMING_AN1          0x10190
#define REG_PHY_RXTD_IF64_DET_SC_64_I_AT_FINE_TIMING_AN1_MASK     0x0000ffff
#define REG_PHY_RXTD_IF64_DET_SC_64_I_AT_FINE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IF64_DET_SC_64_I_AT_FINE_TIMING_AN1_WIDTH    16

/* PHY_RXTD_IF65_DET_SC_64_Q_AT_FINE_TIMING_AN1 */
/* Detector Coarse Corr Q Data An1 */
#define REG_PHY_RXTD_IF65_DET_SC_64_Q_AT_FINE_TIMING_AN1          0x10194
#define REG_PHY_RXTD_IF65_DET_SC_64_Q_AT_FINE_TIMING_AN1_MASK     0x0000ffff
#define REG_PHY_RXTD_IF65_DET_SC_64_Q_AT_FINE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IF65_DET_SC_64_Q_AT_FINE_TIMING_AN1_WIDTH    16

/* PHY_RXTD_IF66_DET_ABS_SC_AT_COARSE_TIMING_AN2 */
/* Detector Coarse Corr Q Data An0 */
#define REG_PHY_RXTD_IF66_DET_ABS_SC_AT_COARSE_TIMING_AN2          0x10198
#define REG_PHY_RXTD_IF66_DET_ABS_SC_AT_COARSE_TIMING_AN2_MASK     0x00003fff
#define REG_PHY_RXTD_IF66_DET_ABS_SC_AT_COARSE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IF66_DET_ABS_SC_AT_COARSE_TIMING_AN2_WIDTH    14

/* PHY_RXTD_IF67_WD_COUNTER_EN */
/* Watch dog counter enble */
#define REG_PHY_RXTD_IF67_WD_COUNTER_EN          0x1019C
#define REG_PHY_RXTD_IF67_WD_COUNTER_EN_MASK     0x00000001
#define REG_PHY_RXTD_IF67_WD_COUNTER_EN_SHIFT    0
#define REG_PHY_RXTD_IF67_WD_COUNTER_EN_WIDTH    1

/* PHY_RXTD_IF67_CLEAR_WD_COUNTER */
/* Clear Watch dog counter enble */
#define REG_PHY_RXTD_IF67_CLEAR_WD_COUNTER          0x1019C
#define REG_PHY_RXTD_IF67_CLEAR_WD_COUNTER_MASK     0x00000010
#define REG_PHY_RXTD_IF67_CLEAR_WD_COUNTER_SHIFT    4
#define REG_PHY_RXTD_IF67_CLEAR_WD_COUNTER_WIDTH    1

/* PHY_RXTD_IF68_DET_SC_64_I_AT_FINE_TIMING_AN2 */
/* Detector Coarse Corr I Data An2 */
#define REG_PHY_RXTD_IF68_DET_SC_64_I_AT_FINE_TIMING_AN2          0x101A0
#define REG_PHY_RXTD_IF68_DET_SC_64_I_AT_FINE_TIMING_AN2_MASK     0x0000ffff
#define REG_PHY_RXTD_IF68_DET_SC_64_I_AT_FINE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IF68_DET_SC_64_I_AT_FINE_TIMING_AN2_WIDTH    16

/* PHY_RXTD_IF69_DET_SC_64_Q_AT_FINE_TIMING_AN2 */
/* Detector Coarse Corr Q Data An2 */
#define REG_PHY_RXTD_IF69_DET_SC_64_Q_AT_FINE_TIMING_AN2          0x101A4
#define REG_PHY_RXTD_IF69_DET_SC_64_Q_AT_FINE_TIMING_AN2_MASK     0x0000ffff
#define REG_PHY_RXTD_IF69_DET_SC_64_Q_AT_FINE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IF69_DET_SC_64_Q_AT_FINE_TIMING_AN2_WIDTH    16

/* PHY_RXTD_IF6A_DET_USE_COMMON_FINE_TIMING */
/* det_use_common_fine_timing */
#define REG_PHY_RXTD_IF6A_DET_USE_COMMON_FINE_TIMING          0x101A8
#define REG_PHY_RXTD_IF6A_DET_USE_COMMON_FINE_TIMING_MASK     0x00000001
#define REG_PHY_RXTD_IF6A_DET_USE_COMMON_FINE_TIMING_SHIFT    0
#define REG_PHY_RXTD_IF6A_DET_USE_COMMON_FINE_TIMING_WIDTH    1

/* PHY_RXTD_IF6A_DET_NOISE_EST_VALID_EN */
/* det_noise_est_valid_en */
#define REG_PHY_RXTD_IF6A_DET_NOISE_EST_VALID_EN          0x101A8
#define REG_PHY_RXTD_IF6A_DET_NOISE_EST_VALID_EN_MASK     0x00000010
#define REG_PHY_RXTD_IF6A_DET_NOISE_EST_VALID_EN_SHIFT    4
#define REG_PHY_RXTD_IF6A_DET_NOISE_EST_VALID_EN_WIDTH    1

/* PHY_RXTD_IF6B_SANITY_RISC_ANTENNA_EN_VALID_NEW */
/* Sanity Risc Antenna Enable Valid\n1- select the Risc antenna enable\n0- select the host antenna enable */
#define REG_PHY_RXTD_IF6B_SANITY_RISC_ANTENNA_EN_VALID_NEW          0x101AC
#define REG_PHY_RXTD_IF6B_SANITY_RISC_ANTENNA_EN_VALID_NEW_MASK     0x00000001
#define REG_PHY_RXTD_IF6B_SANITY_RISC_ANTENNA_EN_VALID_NEW_SHIFT    0
#define REG_PHY_RXTD_IF6B_SANITY_RISC_ANTENNA_EN_VALID_NEW_WIDTH    1

/* PHY_RXTD_IF6C_DELTA_F_DATA_REG */
/* Delta F Data */
#define REG_PHY_RXTD_IF6C_DELTA_F_DATA_REG          0x101B0
#define REG_PHY_RXTD_IF6C_DELTA_F_DATA_REG_MASK     0x00007fff
#define REG_PHY_RXTD_IF6C_DELTA_F_DATA_REG_SHIFT    0
#define REG_PHY_RXTD_IF6C_DELTA_F_DATA_REG_WIDTH    15

/* PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN0 */
/* Sanity Detector Coarse Ready An0 */
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN0          0x101B4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN0_MASK     0x00000001
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN0_SHIFT    0
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN0_WIDTH    1

/* PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN1 */
/* Sanity Detector Coarse Ready An1 */
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN1          0x101B4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN1_MASK     0x00000002
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN1_SHIFT    1
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN1_WIDTH    1

/* PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN2 */
/* Sanity Detector Coarse Ready An2 */
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN2          0x101B4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN2_MASK     0x00000004
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN2_SHIFT    2
#define REG_PHY_RXTD_IF6D_SANITY_DET_COARSE_RDY_AN2_WIDTH    1

/* PHY_RXTD_IF6D_SANITY_DET_COMMON_COARSE_ERR */
/* Sanity_det_common_coarse_err */
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_COARSE_ERR          0x101B4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_COARSE_ERR_MASK     0x00000010
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_COARSE_ERR_SHIFT    4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_COARSE_ERR_WIDTH    1

/* PHY_RXTD_IF6D_SANITY_DET_COMMON_FINE_ERR */
/* Sanity_det_common_fine_err */
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_FINE_ERR          0x101B4
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_FINE_ERR_MASK     0x00000020
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_FINE_ERR_SHIFT    5
#define REG_PHY_RXTD_IF6D_SANITY_DET_COMMON_FINE_ERR_WIDTH    1

/* PHY_RXTD_IF6E_SANITY_HOST_ANTENNA_EN */
/* sanity Host Antenna Enable */
#define REG_PHY_RXTD_IF6E_SANITY_HOST_ANTENNA_EN          0x101B8
#define REG_PHY_RXTD_IF6E_SANITY_HOST_ANTENNA_EN_MASK     0x00000007
#define REG_PHY_RXTD_IF6E_SANITY_HOST_ANTENNA_EN_SHIFT    0
#define REG_PHY_RXTD_IF6E_SANITY_HOST_ANTENNA_EN_WIDTH    3

/* PHY_RXTD_IF6F_SANITY_AN0_COARSE_CNT */
/* Sanity An 0 Coarse Counter\nCounter is Latched on Coarse Ready. */
#define REG_PHY_RXTD_IF6F_SANITY_AN0_COARSE_CNT          0x101BC
#define REG_PHY_RXTD_IF6F_SANITY_AN0_COARSE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF6F_SANITY_AN0_COARSE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF6F_SANITY_AN0_COARSE_CNT_WIDTH    16

/* PHY_RXTD_IF70_SANITY_AN1_COARSE_CNT */
/* Sanity An 0 Coarse Counter\nCounter is Latched on Fine Ready. */
#define REG_PHY_RXTD_IF70_SANITY_AN1_COARSE_CNT          0x101C0
#define REG_PHY_RXTD_IF70_SANITY_AN1_COARSE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF70_SANITY_AN1_COARSE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF70_SANITY_AN1_COARSE_CNT_WIDTH    16

/* PHY_RXTD_IF71_SANITY_AN2_COARSE_CNT */
/* Sanity An 1 Coarse Counter\nCounter is Latched on Coarse Ready. */
#define REG_PHY_RXTD_IF71_SANITY_AN2_COARSE_CNT          0x101C4
#define REG_PHY_RXTD_IF71_SANITY_AN2_COARSE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF71_SANITY_AN2_COARSE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF71_SANITY_AN2_COARSE_CNT_WIDTH    16

/* PHY_RXTD_IF72_SANITY_AN0_FINE_CNT */
/* Sanity An 1 Coarse Counter\nCounter is Latched on Fine Ready. */
#define REG_PHY_RXTD_IF72_SANITY_AN0_FINE_CNT          0x101C8
#define REG_PHY_RXTD_IF72_SANITY_AN0_FINE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF72_SANITY_AN0_FINE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF72_SANITY_AN0_FINE_CNT_WIDTH    16

/* PHY_RXTD_IF73_SANITY_AN1_FINE_CNT */
/* Sanity An 2 Coarse Counter\nCounter is Latched on Coarse Ready. */
#define REG_PHY_RXTD_IF73_SANITY_AN1_FINE_CNT          0x101CC
#define REG_PHY_RXTD_IF73_SANITY_AN1_FINE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF73_SANITY_AN1_FINE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF73_SANITY_AN1_FINE_CNT_WIDTH    16

/* PHY_RXTD_IF74_SANITY_AN2_FINE_CNT */
/* Sanity An 2 Coarse Counter\nCounter is Latched on Fine Ready. */
#define REG_PHY_RXTD_IF74_SANITY_AN2_FINE_CNT          0x101D0
#define REG_PHY_RXTD_IF74_SANITY_AN2_FINE_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF74_SANITY_AN2_FINE_CNT_SHIFT    0
#define REG_PHY_RXTD_IF74_SANITY_AN2_FINE_CNT_WIDTH    16

/* PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN */
/* Sanity Risc Antenna Enable\nRisc Decision  */
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN          0x101D8
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_MASK     0x00000007
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_SHIFT    0
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_WIDTH    3

/* PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID */
/* Sanity Risc Antenna Enable Valid\n1- select the Risc antenna enable\n0- select the host antenna enable */
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID          0x101D8
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID_MASK     0x00000010
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID_SHIFT    4
#define REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID_WIDTH    1

/* PHY_RXTD_IF77_SANITY_CLK_PER_STROBE */
/* Sanity Clock Per Strobe\nSanity Counter strobe\n(Counters rate) */
#define REG_PHY_RXTD_IF77_SANITY_CLK_PER_STROBE          0x101DC
#define REG_PHY_RXTD_IF77_SANITY_CLK_PER_STROBE_MASK     0x0000001f
#define REG_PHY_RXTD_IF77_SANITY_CLK_PER_STROBE_SHIFT    0
#define REG_PHY_RXTD_IF77_SANITY_CLK_PER_STROBE_WIDTH    5

/* PHY_RXTD_IF78_CNT_RESET */
/* Sanity reset the Sanity Counters */
#define REG_PHY_RXTD_IF78_CNT_RESET          0x101E0
#define REG_PHY_RXTD_IF78_CNT_RESET_MASK     0x00000001
#define REG_PHY_RXTD_IF78_CNT_RESET_SHIFT    0
#define REG_PHY_RXTD_IF78_CNT_RESET_WIDTH    1

/* PHY_RXTD_IF79_COMMON_COARSE_RDY_CNT */
/* Sanity Detector Coarse Max Abs Sc An0\n8 low bits [7:0] */
#define REG_PHY_RXTD_IF79_COMMON_COARSE_RDY_CNT          0x101E4
#define REG_PHY_RXTD_IF79_COMMON_COARSE_RDY_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF79_COMMON_COARSE_RDY_CNT_SHIFT    0
#define REG_PHY_RXTD_IF79_COMMON_COARSE_RDY_CNT_WIDTH    16

/* PHY_RXTD_IF7A_ENABLE_TIMERS_INT */
/* enable_timers_int
[0]-timer 0 interrupt enable
[1]-timer 1 interrupt enable */
#define REG_PHY_RXTD_IF7A_ENABLE_TIMERS_INT          0x101E8
#define REG_PHY_RXTD_IF7A_ENABLE_TIMERS_INT_MASK     0x00000003
#define REG_PHY_RXTD_IF7A_ENABLE_TIMERS_INT_SHIFT    0
#define REG_PHY_RXTD_IF7A_ENABLE_TIMERS_INT_WIDTH    2

/* PHY_RXTD_IF7B_CLEAR_TIMERS_INT */
/* clear_timers_int
[0]-timer 0 interrupt clear
[1]-timer 1 interrupt clear */
#define REG_PHY_RXTD_IF7B_CLEAR_TIMERS_INT          0x101EC
#define REG_PHY_RXTD_IF7B_CLEAR_TIMERS_INT_MASK     0x00000003
#define REG_PHY_RXTD_IF7B_CLEAR_TIMERS_INT_SHIFT    0
#define REG_PHY_RXTD_IF7B_CLEAR_TIMERS_INT_WIDTH    2

/* PHY_RXTD_IF7C_CCA_TIMERS_REG */
/* cause_timers_reg
[0]-timer 0 interrupt 
[1]-timer 1 interrupt */
#define REG_PHY_RXTD_IF7C_CCA_TIMERS_REG          0x101F0
#define REG_PHY_RXTD_IF7C_CCA_TIMERS_REG_MASK     0x00000003
#define REG_PHY_RXTD_IF7C_CCA_TIMERS_REG_SHIFT    0
#define REG_PHY_RXTD_IF7C_CCA_TIMERS_REG_WIDTH    2

/* PHY_RXTD_IF7D_COMMON_FINE_RDY_CNT */
/* common_fine_rdy_cnt */
#define REG_PHY_RXTD_IF7D_COMMON_FINE_RDY_CNT          0x101F4
#define REG_PHY_RXTD_IF7D_COMMON_FINE_RDY_CNT_MASK     0x0000ffff
#define REG_PHY_RXTD_IF7D_COMMON_FINE_RDY_CNT_SHIFT    0
#define REG_PHY_RXTD_IF7D_COMMON_FINE_RDY_CNT_WIDTH    16

/* PHY_RXTD_IF7E_RXTD_CSM_NCO_FREQ_DATA */
/* Sanity Delta f value at the end of the packet */
#define REG_PHY_RXTD_IF7E_RXTD_CSM_NCO_FREQ_DATA          0x101F8
#define REG_PHY_RXTD_IF7E_RXTD_CSM_NCO_FREQ_DATA_MASK     0x00007fff
#define REG_PHY_RXTD_IF7E_RXTD_CSM_NCO_FREQ_DATA_SHIFT    0
#define REG_PHY_RXTD_IF7E_RXTD_CSM_NCO_FREQ_DATA_WIDTH    15

/* PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN0 */
/* Sanity Detector Fine Ready An0 */
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN0          0x101FC
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN0_MASK     0x00000001
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN0_SHIFT    0
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN0_WIDTH    1

/* PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN1 */
/* Sanity Detector Fine Ready An1 */
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN1          0x101FC
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN1_MASK     0x00000002
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN1_SHIFT    1
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN1_WIDTH    1

/* PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN2 */
/* Sanity Detector Fine Ready An2 */
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN2          0x101FC
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN2_MASK     0x00000004
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN2_SHIFT    2
#define REG_PHY_RXTD_IF7F_SANITY_DET_FINE_RDY_AN2_WIDTH    1

/* PHY_RXTD_IF7F_SANITY_DET_COMMON_COARSE_RDY */
/* sanity_det_common_coarse_rdy */
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_COARSE_RDY          0x101FC
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_COARSE_RDY_MASK     0x00000008
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_COARSE_RDY_SHIFT    3
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_COARSE_RDY_WIDTH    1

/* PHY_RXTD_IF7F_SANITY_DET_COMMON_FINE_RDY */
/* sanity_det_common_fine_rdy */
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_FINE_RDY          0x101FC
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_FINE_RDY_MASK     0x00000010
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_FINE_RDY_SHIFT    4
#define REG_PHY_RXTD_IF7F_SANITY_DET_COMMON_FINE_RDY_WIDTH    1

/* PHY_RXTD_IF80_SANITY_DET_IS_FULL_CB */
/* Sanity Detector Top Is Full CB\n1- Full CB / 2B\n0- Usb Lsb HB */
#define REG_PHY_RXTD_IF80_SANITY_DET_IS_FULL_CB          0x10200
#define REG_PHY_RXTD_IF80_SANITY_DET_IS_FULL_CB_MASK     0x00000001
#define REG_PHY_RXTD_IF80_SANITY_DET_IS_FULL_CB_SHIFT    0
#define REG_PHY_RXTD_IF80_SANITY_DET_IS_FULL_CB_WIDTH    1

/* PHY_RXTD_IF80_SANITY_DET_INPUT_SELECT */
/* Sanity Detector Top Input Select\n0-0 None\n1- CB\n2-USB.\n3-Lsb. */
#define REG_PHY_RXTD_IF80_SANITY_DET_INPUT_SELECT          0x10200
#define REG_PHY_RXTD_IF80_SANITY_DET_INPUT_SELECT_MASK     0x00000006
#define REG_PHY_RXTD_IF80_SANITY_DET_INPUT_SELECT_SHIFT    1
#define REG_PHY_RXTD_IF80_SANITY_DET_INPUT_SELECT_WIDTH    2

/* PHY_RXTD_IF80_SANITY_DET_SIGNAL_DETECT */
/* Sanity Detector Top Signal Detect */
#define REG_PHY_RXTD_IF80_SANITY_DET_SIGNAL_DETECT          0x10200
#define REG_PHY_RXTD_IF80_SANITY_DET_SIGNAL_DETECT_MASK     0x00000008
#define REG_PHY_RXTD_IF80_SANITY_DET_SIGNAL_DETECT_SHIFT    3
#define REG_PHY_RXTD_IF80_SANITY_DET_SIGNAL_DETECT_WIDTH    1

/* PHY_RXTD_IF80_SANITY_CB_ENABLE */
/* CB Enable */
#define REG_PHY_RXTD_IF80_SANITY_CB_ENABLE          0x10200
#define REG_PHY_RXTD_IF80_SANITY_CB_ENABLE_MASK     0x00000010
#define REG_PHY_RXTD_IF80_SANITY_CB_ENABLE_SHIFT    4
#define REG_PHY_RXTD_IF80_SANITY_CB_ENABLE_WIDTH    1

/* PHY_RXTD_IF80_SANITY_DELTA_F_VALID */
/* sanity Delta F Data Valid */
#define REG_PHY_RXTD_IF80_SANITY_DELTA_F_VALID          0x10200
#define REG_PHY_RXTD_IF80_SANITY_DELTA_F_VALID_MASK     0x00000020
#define REG_PHY_RXTD_IF80_SANITY_DELTA_F_VALID_SHIFT    5
#define REG_PHY_RXTD_IF80_SANITY_DELTA_F_VALID_WIDTH    1

/* PHY_RXTD_IF81_BYTES_IN_FIFO0 */
/* bytes in test fifo0 */
#define REG_PHY_RXTD_IF81_BYTES_IN_FIFO0          0x10204
#define REG_PHY_RXTD_IF81_BYTES_IN_FIFO0_MASK     0x00001fff
#define REG_PHY_RXTD_IF81_BYTES_IN_FIFO0_SHIFT    0
#define REG_PHY_RXTD_IF81_BYTES_IN_FIFO0_WIDTH    13

/* PHY_RXTD_IF82_BYTES_IN_FIFO1 */
/* bytes_in_fifo1 */
#define REG_PHY_RXTD_IF82_BYTES_IN_FIFO1          0x10208
#define REG_PHY_RXTD_IF82_BYTES_IN_FIFO1_MASK     0x000003ff
#define REG_PHY_RXTD_IF82_BYTES_IN_FIFO1_SHIFT    0
#define REG_PHY_RXTD_IF82_BYTES_IN_FIFO1_WIDTH    10

/* PHY_RXTD_IF83_BYTES_IN_FIFO2 */
/* bytes_in_fifo2 */
#define REG_PHY_RXTD_IF83_BYTES_IN_FIFO2          0x1020C
#define REG_PHY_RXTD_IF83_BYTES_IN_FIFO2_MASK     0x000003ff
#define REG_PHY_RXTD_IF83_BYTES_IN_FIFO2_SHIFT    0
#define REG_PHY_RXTD_IF83_BYTES_IN_FIFO2_WIDTH    10

/* PHY_RXTD_IF84_ENABLE_INT6 */
/* enable_int6\n[0]-sw int\n[1]-rfld\n[2] risc watch dog int */
#define REG_PHY_RXTD_IF84_ENABLE_INT6          0x10210
#define REG_PHY_RXTD_IF84_ENABLE_INT6_MASK     0x00000007
#define REG_PHY_RXTD_IF84_ENABLE_INT6_SHIFT    0
#define REG_PHY_RXTD_IF84_ENABLE_INT6_WIDTH    3

/* PHY_RXTD_IF85_CLEAR_INT6 */
/* clear_int6\n[0]-sw int\n[1]-rfld\n[2] risc watch dog int */
#define REG_PHY_RXTD_IF85_CLEAR_INT6          0x10214
#define REG_PHY_RXTD_IF85_CLEAR_INT6_MASK     0x00000007
#define REG_PHY_RXTD_IF85_CLEAR_INT6_SHIFT    0
#define REG_PHY_RXTD_IF85_CLEAR_INT6_WIDTH    3

/* PHY_RXTD_IF86_INT6_CAUSE_REG */
/* int6_cause_reg\n[0]-sw int\n[1]-rfld\n[2] risc watch dog int */
#define REG_PHY_RXTD_IF86_INT6_CAUSE_REG          0x10218
#define REG_PHY_RXTD_IF86_INT6_CAUSE_REG_MASK     0x00000007
#define REG_PHY_RXTD_IF86_INT6_CAUSE_REG_SHIFT    0
#define REG_PHY_RXTD_IF86_INT6_CAUSE_REG_WIDTH    3

/* PHY_RXTD_IF88_FREE_RUNNING_CNT_LOW */
/* free_running_cnt_low
the 16 low bits are latcghed when reading the high bits */
#define REG_PHY_RXTD_IF88_FREE_RUNNING_CNT_LOW          0x10220
#define REG_PHY_RXTD_IF88_FREE_RUNNING_CNT_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF88_FREE_RUNNING_CNT_LOW_SHIFT    0
#define REG_PHY_RXTD_IF88_FREE_RUNNING_CNT_LOW_WIDTH    16

/* PHY_RXTD_IF89_FREE_RUNNING_CNT_HIGH */
/* free_running_cnt_high 
the 16 low bits are latcghed when reading the high bits */
#define REG_PHY_RXTD_IF89_FREE_RUNNING_CNT_HIGH          0x10224
#define REG_PHY_RXTD_IF89_FREE_RUNNING_CNT_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF89_FREE_RUNNING_CNT_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF89_FREE_RUNNING_CNT_HIGH_WIDTH    16

/* PHY_RXTD_IF8A_FREE_RUNNING_CNT_TH_LOW */
/* free_running_cnt_th_low */
#define REG_PHY_RXTD_IF8A_FREE_RUNNING_CNT_TH_LOW          0x10228
#define REG_PHY_RXTD_IF8A_FREE_RUNNING_CNT_TH_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IF8A_FREE_RUNNING_CNT_TH_LOW_SHIFT    0
#define REG_PHY_RXTD_IF8A_FREE_RUNNING_CNT_TH_LOW_WIDTH    16

/* PHY_RXTD_IF8B_FREE_RUNNING_CNT_TH_HIGH */
/* free_running_cnt_th_high */
#define REG_PHY_RXTD_IF8B_FREE_RUNNING_CNT_TH_HIGH          0x1022C
#define REG_PHY_RXTD_IF8B_FREE_RUNNING_CNT_TH_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IF8B_FREE_RUNNING_CNT_TH_HIGH_SHIFT    0
#define REG_PHY_RXTD_IF8B_FREE_RUNNING_CNT_TH_HIGH_WIDTH    16

/* PHY_RXTD_IF8C_RAM_WR_PNT0 */
/* last write address to test bus FIFO low */
#define REG_PHY_RXTD_IF8C_RAM_WR_PNT0          0x10230
#define REG_PHY_RXTD_IF8C_RAM_WR_PNT0_MASK     0x00000fff
#define REG_PHY_RXTD_IF8C_RAM_WR_PNT0_SHIFT    0
#define REG_PHY_RXTD_IF8C_RAM_WR_PNT0_WIDTH    12

/* PHY_RXTD_IF8D_RAM_WR_PNT1 */
/* last write address to test bus FIFO mid */
#define REG_PHY_RXTD_IF8D_RAM_WR_PNT1          0x10234
#define REG_PHY_RXTD_IF8D_RAM_WR_PNT1_MASK     0x000001ff
#define REG_PHY_RXTD_IF8D_RAM_WR_PNT1_SHIFT    0
#define REG_PHY_RXTD_IF8D_RAM_WR_PNT1_WIDTH    9

/* PHY_RXTD_IF8E_RAM_WR_PNT2 */
/* last write address to test bus FIFO high */
#define REG_PHY_RXTD_IF8E_RAM_WR_PNT2          0x10238
#define REG_PHY_RXTD_IF8E_RAM_WR_PNT2_MASK     0x000001ff
#define REG_PHY_RXTD_IF8E_RAM_WR_PNT2_SHIFT    0
#define REG_PHY_RXTD_IF8E_RAM_WR_PNT2_WIDTH    9

/* PHY_RXTD_IF8F_SW_RESET_N_REG */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly.
[0]- An0,1,2 ADC.
[1]- An0,1,2 IQ Mismatch.
[2]- An0,1,2 Decimator & Integrator.
[3]- An0,1,2 Band Select (USB & LSB).
[5]- An0,1,2 Detector.
[6]- An0,1,2 Fifo.
[7]- An0,1,2 Top Nco.
[8] - OLA
[9]-  TD CSM.
[10]- RX Agc.
[11]- CCA.
[12]- Detector Top 
[13] Agc BB rssi reset.
[14] Agc Rssi reset.
[15] ADC IF top reset */
#define REG_PHY_RXTD_IF8F_SW_RESET_N_REG          0x1023C
#define REG_PHY_RXTD_IF8F_SW_RESET_N_REG_MASK     0x0000ffff
#define REG_PHY_RXTD_IF8F_SW_RESET_N_REG_SHIFT    0
#define REG_PHY_RXTD_IF8F_SW_RESET_N_REG_WIDTH    16

/* PHY_RXTD_IF90_BLOCK_EN */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly
[0]- An0,1,2 ADC.
[1]- An0,1,2 IQ Mismatch.
[2]- An0,1,2 Decimator & Integrator.
[3]- An0,1,2 Band Select (USB & LSB).
[5]- An0,1,2 Detector.
[6]- An0,1,2 Fifo.
[7]- An0,1,2 Top Nco.
[8] - OLA
[9]-  TD CSM.
[10]- RX Agc.
[11]- CCA.
[12]- Detector Top 
[13] Agc BB rssi reset.
[14] Agc Rssi reset.
 [15] ADC IF top reset */
#define REG_PHY_RXTD_IF90_BLOCK_EN          0x10240
#define REG_PHY_RXTD_IF90_BLOCK_EN_MASK     0x0000ffff
#define REG_PHY_RXTD_IF90_BLOCK_EN_SHIFT    0
#define REG_PHY_RXTD_IF90_BLOCK_EN_WIDTH    16

/* PHY_RXTD_IF91_GSM_SW_RESET_MASK */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "1" resets the sub block. the reg is used automatically between packets
[0]- An0,1,2 ADC.
[1]- An0,1,2 IQ Mismatch.
[2]- An0,1,2 Decimator & Integrator.
[3]- An0,1,2 Band Select (USB & LSB).
[5]- An0,1,2 Detector.
[6]- An0,1,2 Fifo.
[7]- An0,1,2 Top Nco.
[8] - OLA
[9]-  TD CSM.
[10]- RX Agc.
[11]- CCA.
[12]- Detector Top 
[13] Agc BB rssi reset.
[14] Agc Rssi reset.
 [15] ADC IF top reset. */
#define REG_PHY_RXTD_IF91_GSM_SW_RESET_MASK          0x10244
#define REG_PHY_RXTD_IF91_GSM_SW_RESET_MASK_MASK     0x0000ffff
#define REG_PHY_RXTD_IF91_GSM_SW_RESET_MASK_SHIFT    0
#define REG_PHY_RXTD_IF91_GSM_SW_RESET_MASK_WIDTH    16

/* PHY_RXTD_IF92_SW_RESET_GENERATE */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "1" resets the sub block. the reg is used when writing to addr 0 for debug mode
[0]- An0,1,2 ADC.
[1]- An0,1,2 IQ Mismatch.
[2]- An0,1,2 Decimator & Integrator.
[3]- An0,1,2 Band Select (USB & LSB).
[5]- An0,1,2 Detector.
[6]- An0,1,2 Fifo.
[7]- An0,1,2 Top Nco.
[8] - OLA
[9]-  TD CSM.
[10]- RX Agc.
[11]- CCA.
[12]- Detector Top 
[13] Agc BB rssi reset.
[14] Agc Rssi reset.
 [15] ADC IF top reset. */
#define REG_PHY_RXTD_IF92_SW_RESET_GENERATE          0x10248
#define REG_PHY_RXTD_IF92_SW_RESET_GENERATE_MASK     0x0000ffff
#define REG_PHY_RXTD_IF92_SW_RESET_GENERATE_SHIFT    0
#define REG_PHY_RXTD_IF92_SW_RESET_GENERATE_WIDTH    16

/* PHY_RXTD_IF93_GRISC_DC_REMOVAL_DATA_I_AN0 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_DATA_I_AN0          0x1024C
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_DATA_I_AN0_MASK     0x00007fff
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_DATA_I_AN0_SHIFT    0
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_DATA_I_AN0_WIDTH    15

/* PHY_RXTD_IF93_GRISC_DC_REMOVAL_VALID_I_AN0 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_VALID_I_AN0          0x1024C
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_VALID_I_AN0_MASK     0x00008000
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_VALID_I_AN0_SHIFT    15
#define REG_PHY_RXTD_IF93_GRISC_DC_REMOVAL_VALID_I_AN0_WIDTH    1

/* PHY_RXTD_IF94_GRISC_DC_REMOVAL_DATA_Q_AN0 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_DATA_Q_AN0          0x10250
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_DATA_Q_AN0_MASK     0x00007fff
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_DATA_Q_AN0_SHIFT    0
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_DATA_Q_AN0_WIDTH    15

/* PHY_RXTD_IF94_GRISC_DC_REMOVAL_VALID_Q_AN0 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_VALID_Q_AN0          0x10250
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_VALID_Q_AN0_MASK     0x00008000
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_VALID_Q_AN0_SHIFT    15
#define REG_PHY_RXTD_IF94_GRISC_DC_REMOVAL_VALID_Q_AN0_WIDTH    1

/* PHY_RXTD_IF95_GRISC_DC_REMOVAL_DATA_I_AN1 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_DATA_I_AN1          0x10254
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_DATA_I_AN1_MASK     0x00007fff
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_DATA_I_AN1_SHIFT    0
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_DATA_I_AN1_WIDTH    15

/* PHY_RXTD_IF95_GRISC_DC_REMOVAL_VALID_I_AN1 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_VALID_I_AN1          0x10254
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_VALID_I_AN1_MASK     0x00008000
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_VALID_I_AN1_SHIFT    15
#define REG_PHY_RXTD_IF95_GRISC_DC_REMOVAL_VALID_I_AN1_WIDTH    1

/* PHY_RXTD_IF96_GRISC_DC_REMOVAL_DATA_Q_AN1 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_DATA_Q_AN1          0x10258
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_DATA_Q_AN1_MASK     0x00007fff
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_DATA_Q_AN1_SHIFT    0
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_DATA_Q_AN1_WIDTH    15

/* PHY_RXTD_IF96_GRISC_DC_REMOVAL_VALID_Q_AN1 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_VALID_Q_AN1          0x10258
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_VALID_Q_AN1_MASK     0x00008000
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_VALID_Q_AN1_SHIFT    15
#define REG_PHY_RXTD_IF96_GRISC_DC_REMOVAL_VALID_Q_AN1_WIDTH    1

/* PHY_RXTD_IF97_GRISC_DC_REMOVAL_DATA_I_AN2 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_DATA_I_AN2          0x1025C
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_DATA_I_AN2_MASK     0x00007fff
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_DATA_I_AN2_SHIFT    0
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_DATA_I_AN2_WIDTH    15

/* PHY_RXTD_IF97_GRISC_DC_REMOVAL_VALID_I_AN2 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_VALID_I_AN2          0x1025C
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_VALID_I_AN2_MASK     0x00008000
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_VALID_I_AN2_SHIFT    15
#define REG_PHY_RXTD_IF97_GRISC_DC_REMOVAL_VALID_I_AN2_WIDTH    1

/* PHY_RXTD_IF98_GRISC_DC_REMOVAL_DATA_Q_AN2 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_DATA_Q_AN2          0x10260
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_DATA_Q_AN2_MASK     0x00007fff
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_DATA_Q_AN2_SHIFT    0
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_DATA_Q_AN2_WIDTH    15

/* PHY_RXTD_IF98_GRISC_DC_REMOVAL_VALID_Q_AN2 */
/* Dc removal override by risc I part an-0 */
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_VALID_Q_AN2          0x10260
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_VALID_Q_AN2_MASK     0x00008000
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_VALID_Q_AN2_SHIFT    15
#define REG_PHY_RXTD_IF98_GRISC_DC_REMOVAL_VALID_Q_AN2_WIDTH    1

/* PHY_RXTD_IF99_DC_REG_I_AN0 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF99_DC_REG_I_AN0          0x10264
#define REG_PHY_RXTD_IF99_DC_REG_I_AN0_MASK     0x00007fff
#define REG_PHY_RXTD_IF99_DC_REG_I_AN0_SHIFT    0
#define REG_PHY_RXTD_IF99_DC_REG_I_AN0_WIDTH    15

/* PHY_RXTD_IF9A_DC_REG_Q_AN0 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9A_DC_REG_Q_AN0          0x10268
#define REG_PHY_RXTD_IF9A_DC_REG_Q_AN0_MASK     0x00007fff
#define REG_PHY_RXTD_IF9A_DC_REG_Q_AN0_SHIFT    0
#define REG_PHY_RXTD_IF9A_DC_REG_Q_AN0_WIDTH    15

/* PHY_RXTD_IF9B_DC_REG_I_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9B_DC_REG_I_AN1          0x1026C
#define REG_PHY_RXTD_IF9B_DC_REG_I_AN1_MASK     0x00007fff
#define REG_PHY_RXTD_IF9B_DC_REG_I_AN1_SHIFT    0
#define REG_PHY_RXTD_IF9B_DC_REG_I_AN1_WIDTH    15

/* PHY_RXTD_IF9C_DC_REG_Q_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9C_DC_REG_Q_AN1          0x10270
#define REG_PHY_RXTD_IF9C_DC_REG_Q_AN1_MASK     0x00007fff
#define REG_PHY_RXTD_IF9C_DC_REG_Q_AN1_SHIFT    0
#define REG_PHY_RXTD_IF9C_DC_REG_Q_AN1_WIDTH    15

/* PHY_RXTD_IF9D_DC_REG_I_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9D_DC_REG_I_AN2          0x10274
#define REG_PHY_RXTD_IF9D_DC_REG_I_AN2_MASK     0x00007fff
#define REG_PHY_RXTD_IF9D_DC_REG_I_AN2_SHIFT    0
#define REG_PHY_RXTD_IF9D_DC_REG_I_AN2_WIDTH    15

/* PHY_RXTD_IF9E_DC_REG_Q_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9E_DC_REG_Q_AN2          0x10278
#define REG_PHY_RXTD_IF9E_DC_REG_Q_AN2_MASK     0x00007fff
#define REG_PHY_RXTD_IF9E_DC_REG_Q_AN2_SHIFT    0
#define REG_PHY_RXTD_IF9E_DC_REG_Q_AN2_WIDTH    15

/* PHY_RXTD_IF9F_DET_SC_16_I_AT_COARSE_TIMING_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IF9F_DET_SC_16_I_AT_COARSE_TIMING_AN1          0x1027C
#define REG_PHY_RXTD_IF9F_DET_SC_16_I_AT_COARSE_TIMING_AN1_MASK     0x00003fff
#define REG_PHY_RXTD_IF9F_DET_SC_16_I_AT_COARSE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IF9F_DET_SC_16_I_AT_COARSE_TIMING_AN1_WIDTH    14

/* PHY_RXTD_IFA0_DET_SC_16_Q_AT_COARSE_TIMING_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA0_DET_SC_16_Q_AT_COARSE_TIMING_AN1          0x10280
#define REG_PHY_RXTD_IFA0_DET_SC_16_Q_AT_COARSE_TIMING_AN1_MASK     0x00003fff
#define REG_PHY_RXTD_IFA0_DET_SC_16_Q_AT_COARSE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IFA0_DET_SC_16_Q_AT_COARSE_TIMING_AN1_WIDTH    14

/* PHY_RXTD_IFA1_DET_R_16_USB_AT_COARSE_TIMING_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA1_DET_R_16_USB_AT_COARSE_TIMING_AN1          0x10284
#define REG_PHY_RXTD_IFA1_DET_R_16_USB_AT_COARSE_TIMING_AN1_MASK     0x00000fff
#define REG_PHY_RXTD_IFA1_DET_R_16_USB_AT_COARSE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IFA1_DET_R_16_USB_AT_COARSE_TIMING_AN1_WIDTH    12

/* PHY_RXTD_IFA2_DET_R_16_LSB_AT_COARSE_TIMING_AN1 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA2_DET_R_16_LSB_AT_COARSE_TIMING_AN1          0x10288
#define REG_PHY_RXTD_IFA2_DET_R_16_LSB_AT_COARSE_TIMING_AN1_MASK     0x00000fff
#define REG_PHY_RXTD_IFA2_DET_R_16_LSB_AT_COARSE_TIMING_AN1_SHIFT    0
#define REG_PHY_RXTD_IFA2_DET_R_16_LSB_AT_COARSE_TIMING_AN1_WIDTH    12

/* PHY_RXTD_IFA3_DET_SC_16_I_AT_COARSE_TIMING_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA3_DET_SC_16_I_AT_COARSE_TIMING_AN2          0x1028C
#define REG_PHY_RXTD_IFA3_DET_SC_16_I_AT_COARSE_TIMING_AN2_MASK     0x00003fff
#define REG_PHY_RXTD_IFA3_DET_SC_16_I_AT_COARSE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IFA3_DET_SC_16_I_AT_COARSE_TIMING_AN2_WIDTH    14

/* PHY_RXTD_IFA4_DET_SC_16_Q_AT_COARSE_TIMING_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA4_DET_SC_16_Q_AT_COARSE_TIMING_AN2          0x10290
#define REG_PHY_RXTD_IFA4_DET_SC_16_Q_AT_COARSE_TIMING_AN2_MASK     0x00003fff
#define REG_PHY_RXTD_IFA4_DET_SC_16_Q_AT_COARSE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IFA4_DET_SC_16_Q_AT_COARSE_TIMING_AN2_WIDTH    14

/* PHY_RXTD_IFA5_DET_R_16_USB_AT_COARSE_TIMING_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA5_DET_R_16_USB_AT_COARSE_TIMING_AN2          0x10294
#define REG_PHY_RXTD_IFA5_DET_R_16_USB_AT_COARSE_TIMING_AN2_MASK     0x00000fff
#define REG_PHY_RXTD_IFA5_DET_R_16_USB_AT_COARSE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IFA5_DET_R_16_USB_AT_COARSE_TIMING_AN2_WIDTH    12

/* PHY_RXTD_IFA6_DET_R_16_LSB_AT_COARSE_TIMING_AN2 */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA6_DET_R_16_LSB_AT_COARSE_TIMING_AN2          0x10298
#define REG_PHY_RXTD_IFA6_DET_R_16_LSB_AT_COARSE_TIMING_AN2_MASK     0x00000fff
#define REG_PHY_RXTD_IFA6_DET_R_16_LSB_AT_COARSE_TIMING_AN2_SHIFT    0
#define REG_PHY_RXTD_IFA6_DET_R_16_LSB_AT_COARSE_TIMING_AN2_WIDTH    12

/* PHY_RXTD_IFA7_RTH_AT_COARSE_TIMING_USB */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA7_RTH_AT_COARSE_TIMING_USB          0x1029C
#define REG_PHY_RXTD_IFA7_RTH_AT_COARSE_TIMING_USB_MASK     0x00000fff
#define REG_PHY_RXTD_IFA7_RTH_AT_COARSE_TIMING_USB_SHIFT    0
#define REG_PHY_RXTD_IFA7_RTH_AT_COARSE_TIMING_USB_WIDTH    12

/* PHY_RXTD_IFA8_ABS_SC_AT_COARSE_TIMING_USB */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA8_ABS_SC_AT_COARSE_TIMING_USB          0x102A0
#define REG_PHY_RXTD_IFA8_ABS_SC_AT_COARSE_TIMING_USB_MASK     0x00000fff
#define REG_PHY_RXTD_IFA8_ABS_SC_AT_COARSE_TIMING_USB_SHIFT    0
#define REG_PHY_RXTD_IFA8_ABS_SC_AT_COARSE_TIMING_USB_WIDTH    12

/* PHY_RXTD_IFA9_RTH_AT_COARSE_TIMING_LSB */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFA9_RTH_AT_COARSE_TIMING_LSB          0x102A4
#define REG_PHY_RXTD_IFA9_RTH_AT_COARSE_TIMING_LSB_MASK     0x00000fff
#define REG_PHY_RXTD_IFA9_RTH_AT_COARSE_TIMING_LSB_SHIFT    0
#define REG_PHY_RXTD_IFA9_RTH_AT_COARSE_TIMING_LSB_WIDTH    12

/* PHY_RXTD_IFAA_ABS_SC_AT_COARSE_TIMING_LSB */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFAA_ABS_SC_AT_COARSE_TIMING_LSB          0x102A8
#define REG_PHY_RXTD_IFAA_ABS_SC_AT_COARSE_TIMING_LSB_MASK     0x00000fff
#define REG_PHY_RXTD_IFAA_ABS_SC_AT_COARSE_TIMING_LSB_SHIFT    0
#define REG_PHY_RXTD_IFAA_ABS_SC_AT_COARSE_TIMING_LSB_WIDTH    12

/* PHY_RXTD_IFAB_DET_COARSE_C_I */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFAB_DET_COARSE_C_I          0x102AC
#define REG_PHY_RXTD_IFAB_DET_COARSE_C_I_MASK     0x0000ffff
#define REG_PHY_RXTD_IFAB_DET_COARSE_C_I_SHIFT    0
#define REG_PHY_RXTD_IFAB_DET_COARSE_C_I_WIDTH    16

/* PHY_RXTD_IFAC_DET_COARSE_C_Q */
/* Dc removal Hw read only */
#define REG_PHY_RXTD_IFAC_DET_COARSE_C_Q          0x102B0
#define REG_PHY_RXTD_IFAC_DET_COARSE_C_Q_MASK     0x0000ffff
#define REG_PHY_RXTD_IFAC_DET_COARSE_C_Q_SHIFT    0
#define REG_PHY_RXTD_IFAC_DET_COARSE_C_Q_WIDTH    16

/* PHY_RXTD_IFAD_ACC_DC2_AN0_REG0 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFAD_ACC_DC2_AN0_REG0          0x102B4
#define REG_PHY_RXTD_IFAD_ACC_DC2_AN0_REG0_MASK     0x000003ff
#define REG_PHY_RXTD_IFAD_ACC_DC2_AN0_REG0_SHIFT    0
#define REG_PHY_RXTD_IFAD_ACC_DC2_AN0_REG0_WIDTH    10

/* PHY_RXTD_IFAE_ACC_DC2_AN0_REG1 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFAE_ACC_DC2_AN0_REG1          0x102B8
#define REG_PHY_RXTD_IFAE_ACC_DC2_AN0_REG1_MASK     0x000003ff
#define REG_PHY_RXTD_IFAE_ACC_DC2_AN0_REG1_SHIFT    0
#define REG_PHY_RXTD_IFAE_ACC_DC2_AN0_REG1_WIDTH    10

/* PHY_RXTD_IFAF_ACC_DC2_AN0_REG2 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFAF_ACC_DC2_AN0_REG2          0x102BC
#define REG_PHY_RXTD_IFAF_ACC_DC2_AN0_REG2_MASK     0x000003ff
#define REG_PHY_RXTD_IFAF_ACC_DC2_AN0_REG2_SHIFT    0
#define REG_PHY_RXTD_IFAF_ACC_DC2_AN0_REG2_WIDTH    10

/* PHY_RXTD_IFB0_ACC_DC2_AN0_REG3 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB0_ACC_DC2_AN0_REG3          0x102C0
#define REG_PHY_RXTD_IFB0_ACC_DC2_AN0_REG3_MASK     0x000003ff
#define REG_PHY_RXTD_IFB0_ACC_DC2_AN0_REG3_SHIFT    0
#define REG_PHY_RXTD_IFB0_ACC_DC2_AN0_REG3_WIDTH    10

/* PHY_RXTD_IFB1_ACC_DC2_AN0_REG4 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB1_ACC_DC2_AN0_REG4          0x102C4
#define REG_PHY_RXTD_IFB1_ACC_DC2_AN0_REG4_MASK     0x000003ff
#define REG_PHY_RXTD_IFB1_ACC_DC2_AN0_REG4_SHIFT    0
#define REG_PHY_RXTD_IFB1_ACC_DC2_AN0_REG4_WIDTH    10

/* PHY_RXTD_IFB2_ACC_DC2_AN0_REG5 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB2_ACC_DC2_AN0_REG5          0x102C8
#define REG_PHY_RXTD_IFB2_ACC_DC2_AN0_REG5_MASK     0x000003ff
#define REG_PHY_RXTD_IFB2_ACC_DC2_AN0_REG5_SHIFT    0
#define REG_PHY_RXTD_IFB2_ACC_DC2_AN0_REG5_WIDTH    10

/* PHY_RXTD_IFB3_ACC_DC2_AN0_REG6 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB3_ACC_DC2_AN0_REG6          0x102CC
#define REG_PHY_RXTD_IFB3_ACC_DC2_AN0_REG6_MASK     0x000003ff
#define REG_PHY_RXTD_IFB3_ACC_DC2_AN0_REG6_SHIFT    0
#define REG_PHY_RXTD_IFB3_ACC_DC2_AN0_REG6_WIDTH    10

/* PHY_RXTD_IFB4_ACC_DC2_AN0_REG7 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB4_ACC_DC2_AN0_REG7          0x102D0
#define REG_PHY_RXTD_IFB4_ACC_DC2_AN0_REG7_MASK     0x000003ff
#define REG_PHY_RXTD_IFB4_ACC_DC2_AN0_REG7_SHIFT    0
#define REG_PHY_RXTD_IFB4_ACC_DC2_AN0_REG7_WIDTH    10

/* PHY_RXTD_IFB5_CCA_PI_BAND0_LSB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_LSB          0x102D4
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_LSB_MASK     0x0000ff00
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_LSB_SHIFT    8
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_LSB_WIDTH    8

/* PHY_RXTD_IFB5_CCA_PI_BAND0_USB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_USB          0x102D4
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_USB_MASK     0x000000ff
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_USB_SHIFT    0
#define REG_PHY_RXTD_IFB5_CCA_PI_BAND0_USB_WIDTH    8

/* PHY_RXTD_IFB6_CCA_PI_BAND1_LSB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_LSB          0x102D8
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_LSB_MASK     0x0000ff00
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_LSB_SHIFT    8
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_LSB_WIDTH    8

/* PHY_RXTD_IFB6_CCA_PI_BAND1_USB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_USB          0x102D8
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_USB_MASK     0x000000ff
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_USB_SHIFT    0
#define REG_PHY_RXTD_IFB6_CCA_PI_BAND1_USB_WIDTH    8

/* PHY_RXTD_IFB7_CCA_PI_BAND2_LSB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_LSB          0x102DC
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_LSB_MASK     0x0000ff00
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_LSB_SHIFT    8
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_LSB_WIDTH    8

/* PHY_RXTD_IFB7_CCA_PI_BAND2_USB */
/* CCA Lsb an-o energu */
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_USB          0x102DC
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_USB_MASK     0x000000ff
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_USB_SHIFT    0
#define REG_PHY_RXTD_IFB7_CCA_PI_BAND2_USB_WIDTH    8

/* PHY_RXTD_IFB8_ACC_DC2_AN1_REG0 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB8_ACC_DC2_AN1_REG0          0x102E0
#define REG_PHY_RXTD_IFB8_ACC_DC2_AN1_REG0_MASK     0x000003ff
#define REG_PHY_RXTD_IFB8_ACC_DC2_AN1_REG0_SHIFT    0
#define REG_PHY_RXTD_IFB8_ACC_DC2_AN1_REG0_WIDTH    10

/* PHY_RXTD_IFB9_ACC_DC2_AN1_REG1 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFB9_ACC_DC2_AN1_REG1          0x102E4
#define REG_PHY_RXTD_IFB9_ACC_DC2_AN1_REG1_MASK     0x000003ff
#define REG_PHY_RXTD_IFB9_ACC_DC2_AN1_REG1_SHIFT    0
#define REG_PHY_RXTD_IFB9_ACC_DC2_AN1_REG1_WIDTH    10

/* PHY_RXTD_IFBA_ACC_DC2_AN1_REG2 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBA_ACC_DC2_AN1_REG2          0x102E8
#define REG_PHY_RXTD_IFBA_ACC_DC2_AN1_REG2_MASK     0x000003ff
#define REG_PHY_RXTD_IFBA_ACC_DC2_AN1_REG2_SHIFT    0
#define REG_PHY_RXTD_IFBA_ACC_DC2_AN1_REG2_WIDTH    10

/* PHY_RXTD_IFBB_ACC_DC2_AN1_REG3 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBB_ACC_DC2_AN1_REG3          0x102EC
#define REG_PHY_RXTD_IFBB_ACC_DC2_AN1_REG3_MASK     0x000003ff
#define REG_PHY_RXTD_IFBB_ACC_DC2_AN1_REG3_SHIFT    0
#define REG_PHY_RXTD_IFBB_ACC_DC2_AN1_REG3_WIDTH    10

/* PHY_RXTD_IFBC_ACC_DC2_AN1_REG4 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBC_ACC_DC2_AN1_REG4          0x102F0
#define REG_PHY_RXTD_IFBC_ACC_DC2_AN1_REG4_MASK     0x000003ff
#define REG_PHY_RXTD_IFBC_ACC_DC2_AN1_REG4_SHIFT    0
#define REG_PHY_RXTD_IFBC_ACC_DC2_AN1_REG4_WIDTH    10

/* PHY_RXTD_IFBD_ACC_DC2_AN1_REG5 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBD_ACC_DC2_AN1_REG5          0x102F4
#define REG_PHY_RXTD_IFBD_ACC_DC2_AN1_REG5_MASK     0x000003ff
#define REG_PHY_RXTD_IFBD_ACC_DC2_AN1_REG5_SHIFT    0
#define REG_PHY_RXTD_IFBD_ACC_DC2_AN1_REG5_WIDTH    10

/* PHY_RXTD_IFBE_ACC_DC2_AN1_REG6 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBE_ACC_DC2_AN1_REG6          0x102F8
#define REG_PHY_RXTD_IFBE_ACC_DC2_AN1_REG6_MASK     0x000003ff
#define REG_PHY_RXTD_IFBE_ACC_DC2_AN1_REG6_SHIFT    0
#define REG_PHY_RXTD_IFBE_ACC_DC2_AN1_REG6_WIDTH    10

/* PHY_RXTD_IFBF_ACC_DC2_AN1_REG7 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFBF_ACC_DC2_AN1_REG7          0x102FC
#define REG_PHY_RXTD_IFBF_ACC_DC2_AN1_REG7_MASK     0x000003ff
#define REG_PHY_RXTD_IFBF_ACC_DC2_AN1_REG7_SHIFT    0
#define REG_PHY_RXTD_IFBF_ACC_DC2_AN1_REG7_WIDTH    10

/* PHY_RXTD_IFC0_ACC_DC2_AN2_REG0 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC0_ACC_DC2_AN2_REG0          0x10300
#define REG_PHY_RXTD_IFC0_ACC_DC2_AN2_REG0_MASK     0x000003ff
#define REG_PHY_RXTD_IFC0_ACC_DC2_AN2_REG0_SHIFT    0
#define REG_PHY_RXTD_IFC0_ACC_DC2_AN2_REG0_WIDTH    10

/* PHY_RXTD_IFC1_ACC_DC2_AN2_REG1 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC1_ACC_DC2_AN2_REG1          0x10304
#define REG_PHY_RXTD_IFC1_ACC_DC2_AN2_REG1_MASK     0x000003ff
#define REG_PHY_RXTD_IFC1_ACC_DC2_AN2_REG1_SHIFT    0
#define REG_PHY_RXTD_IFC1_ACC_DC2_AN2_REG1_WIDTH    10

/* PHY_RXTD_IFC2_ACC_DC2_AN2_REG2 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC2_ACC_DC2_AN2_REG2          0x10308
#define REG_PHY_RXTD_IFC2_ACC_DC2_AN2_REG2_MASK     0x000003ff
#define REG_PHY_RXTD_IFC2_ACC_DC2_AN2_REG2_SHIFT    0
#define REG_PHY_RXTD_IFC2_ACC_DC2_AN2_REG2_WIDTH    10

/* PHY_RXTD_IFC3_ACC_DC2_AN2_REG3 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC3_ACC_DC2_AN2_REG3          0x1030C
#define REG_PHY_RXTD_IFC3_ACC_DC2_AN2_REG3_MASK     0x000003ff
#define REG_PHY_RXTD_IFC3_ACC_DC2_AN2_REG3_SHIFT    0
#define REG_PHY_RXTD_IFC3_ACC_DC2_AN2_REG3_WIDTH    10

/* PHY_RXTD_IFC4_ACC_DC2_AN2_REG4 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC4_ACC_DC2_AN2_REG4          0x10310
#define REG_PHY_RXTD_IFC4_ACC_DC2_AN2_REG4_MASK     0x000003ff
#define REG_PHY_RXTD_IFC4_ACC_DC2_AN2_REG4_SHIFT    0
#define REG_PHY_RXTD_IFC4_ACC_DC2_AN2_REG4_WIDTH    10

/* PHY_RXTD_IFC5_ACC_DC2_AN2_REG5 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC5_ACC_DC2_AN2_REG5          0x10314
#define REG_PHY_RXTD_IFC5_ACC_DC2_AN2_REG5_MASK     0x000003ff
#define REG_PHY_RXTD_IFC5_ACC_DC2_AN2_REG5_SHIFT    0
#define REG_PHY_RXTD_IFC5_ACC_DC2_AN2_REG5_WIDTH    10

/* PHY_RXTD_IFC6_ACC_DC2_AN2_REG6 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC6_ACC_DC2_AN2_REG6          0x10318
#define REG_PHY_RXTD_IFC6_ACC_DC2_AN2_REG6_MASK     0x000003ff
#define REG_PHY_RXTD_IFC6_ACC_DC2_AN2_REG6_SHIFT    0
#define REG_PHY_RXTD_IFC6_ACC_DC2_AN2_REG6_WIDTH    10

/* PHY_RXTD_IFC7_ACC_DC2_AN2_REG7 */
/* Dc0accelerator reg0 */
#define REG_PHY_RXTD_IFC7_ACC_DC2_AN2_REG7          0x1031C
#define REG_PHY_RXTD_IFC7_ACC_DC2_AN2_REG7_MASK     0x000003ff
#define REG_PHY_RXTD_IFC7_ACC_DC2_AN2_REG7_SHIFT    0
#define REG_PHY_RXTD_IFC7_ACC_DC2_AN2_REG7_WIDTH    10

/* PHY_RXTD_IFC8_TIMER0_TH */
/* timer0_th */
#define REG_PHY_RXTD_IFC8_TIMER0_TH          0x10320
#define REG_PHY_RXTD_IFC8_TIMER0_TH_MASK     0x0000ffff
#define REG_PHY_RXTD_IFC8_TIMER0_TH_SHIFT    0
#define REG_PHY_RXTD_IFC8_TIMER0_TH_WIDTH    16

/* PHY_RXTD_IFC8_TIMER0 */
/* timer0 */
#define REG_PHY_RXTD_IFC8_TIMER0          0x10320
#define REG_PHY_RXTD_IFC8_TIMER0_MASK     0x0000ffff
#define REG_PHY_RXTD_IFC8_TIMER0_SHIFT    0
#define REG_PHY_RXTD_IFC8_TIMER0_WIDTH    16

/* PHY_RXTD_IFC9_TIMER0_STB_TH */
/* timer0_stb_th */
#define REG_PHY_RXTD_IFC9_TIMER0_STB_TH          0x10324
#define REG_PHY_RXTD_IFC9_TIMER0_STB_TH_MASK     0x0000000f
#define REG_PHY_RXTD_IFC9_TIMER0_STB_TH_SHIFT    0
#define REG_PHY_RXTD_IFC9_TIMER0_STB_TH_WIDTH    4

/* PHY_RXTD_IFCA_TIMER1_TH */
/* timer1_th */
#define REG_PHY_RXTD_IFCA_TIMER1_TH          0x10328
#define REG_PHY_RXTD_IFCA_TIMER1_TH_MASK     0x0000ffff
#define REG_PHY_RXTD_IFCA_TIMER1_TH_SHIFT    0
#define REG_PHY_RXTD_IFCA_TIMER1_TH_WIDTH    16

/* PHY_RXTD_IFCA_TIMER1 */
/* timer1 */
#define REG_PHY_RXTD_IFCA_TIMER1          0x10328
#define REG_PHY_RXTD_IFCA_TIMER1_MASK     0x0000ffff
#define REG_PHY_RXTD_IFCA_TIMER1_SHIFT    0
#define REG_PHY_RXTD_IFCA_TIMER1_WIDTH    16

/* PHY_RXTD_IFCB_TIMER1_STB_TH */
/* timer1_stb_th */
#define REG_PHY_RXTD_IFCB_TIMER1_STB_TH          0x1032C
#define REG_PHY_RXTD_IFCB_TIMER1_STB_TH_MASK     0x0000000f
#define REG_PHY_RXTD_IFCB_TIMER1_STB_TH_SHIFT    0
#define REG_PHY_RXTD_IFCB_TIMER1_STB_TH_WIDTH    4

/* PHY_RXTD_IFCC_TEST_PLUG_LOW_ONLY16 */
/* Rx TD Risc Test Bus 16 Low */
#define REG_PHY_RXTD_IFCC_TEST_PLUG_LOW_ONLY16          0x10330
#define REG_PHY_RXTD_IFCC_TEST_PLUG_LOW_ONLY16_MASK     0x0000ffff
#define REG_PHY_RXTD_IFCC_TEST_PLUG_LOW_ONLY16_SHIFT    0
#define REG_PHY_RXTD_IFCC_TEST_PLUG_LOW_ONLY16_WIDTH    16

/* PHY_RXTD_IFCD_TEST_PLUG_MID_ONLY16 */
/* Rx TD Risc Test Bus 16 Low */
#define REG_PHY_RXTD_IFCD_TEST_PLUG_MID_ONLY16          0x10334
#define REG_PHY_RXTD_IFCD_TEST_PLUG_MID_ONLY16_MASK     0x0000ffff
#define REG_PHY_RXTD_IFCD_TEST_PLUG_MID_ONLY16_SHIFT    0
#define REG_PHY_RXTD_IFCD_TEST_PLUG_MID_ONLY16_WIDTH    16

/* PHY_RXTD_IFCE_TEST_PLUG_HIGH_ONLY16 */
/* Rx TD Risc Test Bus 16 Low */
#define REG_PHY_RXTD_IFCE_TEST_PLUG_HIGH_ONLY16          0x10338
#define REG_PHY_RXTD_IFCE_TEST_PLUG_HIGH_ONLY16_MASK     0x0000ffff
#define REG_PHY_RXTD_IFCE_TEST_PLUG_HIGH_ONLY16_SHIFT    0
#define REG_PHY_RXTD_IFCE_TEST_PLUG_HIGH_ONLY16_WIDTH    16

/* PHY_RXTD_IFD2_RSSI_RATE_OVERIDE */
/* rssi rate overide
Determines whether to work the rssi with 20Mhz:0- Divide by 4 ( Default ).1  Divide by 2. */
#define REG_PHY_RXTD_IFD2_RSSI_RATE_OVERIDE          0x10348
#define REG_PHY_RXTD_IFD2_RSSI_RATE_OVERIDE_MASK     0x00000010
#define REG_PHY_RXTD_IFD2_RSSI_RATE_OVERIDE_SHIFT    4
#define REG_PHY_RXTD_IFD2_RSSI_RATE_OVERIDE_WIDTH    1

/* PHY_RXTD_IFD3_AGC_ACCUMULATOR_SAMPLES */
/* agc_accumulator_samples */
#define REG_PHY_RXTD_IFD3_AGC_ACCUMULATOR_SAMPLES          0x1034C
#define REG_PHY_RXTD_IFD3_AGC_ACCUMULATOR_SAMPLES_MASK     0x000000ff
#define REG_PHY_RXTD_IFD3_AGC_ACCUMULATOR_SAMPLES_SHIFT    0
#define REG_PHY_RXTD_IFD3_AGC_ACCUMULATOR_SAMPLES_WIDTH    8

/* PHY_RXTD_IFD4_AGC_ACCUMULATOR_START */
/* agc_accumulator_start */
#define REG_PHY_RXTD_IFD4_AGC_ACCUMULATOR_START          0x10350
#define REG_PHY_RXTD_IFD4_AGC_ACCUMULATOR_START_MASK     0x00000001
#define REG_PHY_RXTD_IFD4_AGC_ACCUMULATOR_START_SHIFT    0
#define REG_PHY_RXTD_IFD4_AGC_ACCUMULATOR_START_WIDTH    1

/* PHY_RXTD_IFD5_AGC_ACCUMULATOR_SUM0 */
/* agc_accumulator_sum0 */
#define REG_PHY_RXTD_IFD5_AGC_ACCUMULATOR_SUM0          0x10354
#define REG_PHY_RXTD_IFD5_AGC_ACCUMULATOR_SUM0_MASK     0x0000ffff
#define REG_PHY_RXTD_IFD5_AGC_ACCUMULATOR_SUM0_SHIFT    0
#define REG_PHY_RXTD_IFD5_AGC_ACCUMULATOR_SUM0_WIDTH    16

/* PHY_RXTD_IFD6_AGC_ACCUMULATOR_SUM1 */
/* agc_accumulator_sum1 */
#define REG_PHY_RXTD_IFD6_AGC_ACCUMULATOR_SUM1          0x10358
#define REG_PHY_RXTD_IFD6_AGC_ACCUMULATOR_SUM1_MASK     0x0000ffff
#define REG_PHY_RXTD_IFD6_AGC_ACCUMULATOR_SUM1_SHIFT    0
#define REG_PHY_RXTD_IFD6_AGC_ACCUMULATOR_SUM1_WIDTH    16

/* PHY_RXTD_IFD7_AGC_ACCUMULATOR_SUM2 */
/* agc_accumulator_sum2 */
#define REG_PHY_RXTD_IFD7_AGC_ACCUMULATOR_SUM2          0x1035C
#define REG_PHY_RXTD_IFD7_AGC_ACCUMULATOR_SUM2_MASK     0x0000ffff
#define REG_PHY_RXTD_IFD7_AGC_ACCUMULATOR_SUM2_SHIFT    0
#define REG_PHY_RXTD_IFD7_AGC_ACCUMULATOR_SUM2_WIDTH    16

/* PHY_RXTD_IFD8_AGC_ACCUMULATOR_DONE */
/* agc_accumulator_done */
#define REG_PHY_RXTD_IFD8_AGC_ACCUMULATOR_DONE          0x10360
#define REG_PHY_RXTD_IFD8_AGC_ACCUMULATOR_DONE_MASK     0x00000001
#define REG_PHY_RXTD_IFD8_AGC_ACCUMULATOR_DONE_SHIFT    0
#define REG_PHY_RXTD_IFD8_AGC_ACCUMULATOR_DONE_WIDTH    1

/* PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_EN */
/* b_override_rx_ant_en */
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_EN          0x10364
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_EN_MASK     0x00000001
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_EN_SHIFT    0
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_EN_WIDTH    1

/* PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_SEL */
/* b_override_rx_ant_sel */
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_SEL          0x10364
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_SEL_MASK     0x00000030
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_SEL_SHIFT    4
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_RX_ANT_SEL_WIDTH    2

/* PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_EN */
/* b_override_tx_ant_en */
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_EN          0x10364
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_EN_MASK     0x00000100
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_EN_SHIFT    8
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_EN_WIDTH    1

/* PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_SEL */
/* b_override_tx_ant_sel */
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_SEL          0x10364
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_SEL_MASK     0x00003000
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_SEL_SHIFT    12
#define REG_PHY_RXTD_IFD9_B_OVERRIDE_TX_ANT_SEL_WIDTH    2

/* PHY_RXTD_IFDA_B_INTERFACE_RX_ANT */
/* b_interface_rx_ant */
#define REG_PHY_RXTD_IFDA_B_INTERFACE_RX_ANT          0x10368
#define REG_PHY_RXTD_IFDA_B_INTERFACE_RX_ANT_MASK     0x00000003
#define REG_PHY_RXTD_IFDA_B_INTERFACE_RX_ANT_SHIFT    0
#define REG_PHY_RXTD_IFDA_B_INTERFACE_RX_ANT_WIDTH    2

/* PHY_RXTD_IFDA_B_INTERFACE_TX_ANT */
/* b_interface_tx_ant */
#define REG_PHY_RXTD_IFDA_B_INTERFACE_TX_ANT          0x10368
#define REG_PHY_RXTD_IFDA_B_INTERFACE_TX_ANT_MASK     0x00000030
#define REG_PHY_RXTD_IFDA_B_INTERFACE_TX_ANT_SHIFT    4
#define REG_PHY_RXTD_IFDA_B_INTERFACE_TX_ANT_WIDTH    2

/* PHY_RXTD_IFDB_DET_COMMON_SC_64_I_AT_FINE_TIMING */
/* det_common_sc_64_i_at_fine_timing */
#define REG_PHY_RXTD_IFDB_DET_COMMON_SC_64_I_AT_FINE_TIMING          0x1036C
#define REG_PHY_RXTD_IFDB_DET_COMMON_SC_64_I_AT_FINE_TIMING_MASK     0x0000ffff
#define REG_PHY_RXTD_IFDB_DET_COMMON_SC_64_I_AT_FINE_TIMING_SHIFT    0
#define REG_PHY_RXTD_IFDB_DET_COMMON_SC_64_I_AT_FINE_TIMING_WIDTH    16

/* PHY_RXTD_IFDC_DET_COMMON_SC_64_Q_AT_FINE_TIMING */
/* det_common_sc_64_q_at_fine_timing */
#define REG_PHY_RXTD_IFDC_DET_COMMON_SC_64_Q_AT_FINE_TIMING          0x10370
#define REG_PHY_RXTD_IFDC_DET_COMMON_SC_64_Q_AT_FINE_TIMING_MASK     0x0000ffff
#define REG_PHY_RXTD_IFDC_DET_COMMON_SC_64_Q_AT_FINE_TIMING_SHIFT    0
#define REG_PHY_RXTD_IFDC_DET_COMMON_SC_64_Q_AT_FINE_TIMING_WIDTH    16

/* PHY_RXTD_IFDD_SPARE_CONFIG_RISC_IN */
/* spare_config_risc_in */
#define REG_PHY_RXTD_IFDD_SPARE_CONFIG_RISC_IN          0x10374
#define REG_PHY_RXTD_IFDD_SPARE_CONFIG_RISC_IN_MASK     0x0000ffff
#define REG_PHY_RXTD_IFDD_SPARE_CONFIG_RISC_IN_SHIFT    0
#define REG_PHY_RXTD_IFDD_SPARE_CONFIG_RISC_IN_WIDTH    16

/* PHY_RXTD_IFDE_SPARE_CONFIG_RISC_OUT */
/* spare_config_risc_out */
#define REG_PHY_RXTD_IFDE_SPARE_CONFIG_RISC_OUT          0x10378
#define REG_PHY_RXTD_IFDE_SPARE_CONFIG_RISC_OUT_MASK     0x0000ffff
#define REG_PHY_RXTD_IFDE_SPARE_CONFIG_RISC_OUT_SHIFT    0
#define REG_PHY_RXTD_IFDE_SPARE_CONFIG_RISC_OUT_WIDTH    16

/* PHY_RXTD_IFE0_FCSI_CLK_WR_DIVR */
/* fcsi_clk_wr_divr */
#define REG_PHY_RXTD_IFE0_FCSI_CLK_WR_DIVR          0x10380
#define REG_PHY_RXTD_IFE0_FCSI_CLK_WR_DIVR_MASK     0x0000001f
#define REG_PHY_RXTD_IFE0_FCSI_CLK_WR_DIVR_SHIFT    0
#define REG_PHY_RXTD_IFE0_FCSI_CLK_WR_DIVR_WIDTH    5

/* PHY_RXTD_IFE0_FCSI_CLK_RD_DIVR */
/* fcsi_clk_rd_divr */
#define REG_PHY_RXTD_IFE0_FCSI_CLK_RD_DIVR          0x10380
#define REG_PHY_RXTD_IFE0_FCSI_CLK_RD_DIVR_MASK     0x00001f00
#define REG_PHY_RXTD_IFE0_FCSI_CLK_RD_DIVR_SHIFT    8
#define REG_PHY_RXTD_IFE0_FCSI_CLK_RD_DIVR_WIDTH    5

/* PHY_RXTD_IFE1_INTERNAL_RF_MODE */
/* internal_rf_mode */
#define REG_PHY_RXTD_IFE1_INTERNAL_RF_MODE          0x10384
#define REG_PHY_RXTD_IFE1_INTERNAL_RF_MODE_MASK     0x00000001
#define REG_PHY_RXTD_IFE1_INTERNAL_RF_MODE_SHIFT    0
#define REG_PHY_RXTD_IFE1_INTERNAL_RF_MODE_WIDTH    1

/* PHY_RXTD_IFE1_EXTERNAL_RF_MODE */
/* internal_rf_mode */
#define REG_PHY_RXTD_IFE1_EXTERNAL_RF_MODE          0x10384
#define REG_PHY_RXTD_IFE1_EXTERNAL_RF_MODE_MASK     0x00000002
#define REG_PHY_RXTD_IFE1_EXTERNAL_RF_MODE_SHIFT    1
#define REG_PHY_RXTD_IFE1_EXTERNAL_RF_MODE_WIDTH    1

/* PHY_RXTD_IFE1_FCSI_ADDITIONAL_CYCLES */
/* fcsi_additional_cycles */
#define REG_PHY_RXTD_IFE1_FCSI_ADDITIONAL_CYCLES          0x10384
#define REG_PHY_RXTD_IFE1_FCSI_ADDITIONAL_CYCLES_MASK     0x00000f00
#define REG_PHY_RXTD_IFE1_FCSI_ADDITIONAL_CYCLES_SHIFT    8
#define REG_PHY_RXTD_IFE1_FCSI_ADDITIONAL_CYCLES_WIDTH    4

/* PHY_RXTD_IFE2_FCSI_GR_ADDR_A */
/* fcsi_gr_addr_a */
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A          0x10388
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_MASK     0x0000007f
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_SHIFT    0
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_WIDTH    7

/* PHY_RXTD_IFE2_FCSI_GR_ADDR_A_TO_ALL_ADDRESS */
/* fcsi_gr_addr_a_to_all_address */
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_TO_ALL_ADDRESS          0x10388
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_TO_ALL_ADDRESS_MASK     0x00001000
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_TO_ALL_ADDRESS_SHIFT    12
#define REG_PHY_RXTD_IFE2_FCSI_GR_ADDR_A_TO_ALL_ADDRESS_WIDTH    1

/* PHY_RXTD_IFE2_FCSI_GR_MS_ACCESS */
/* fcsi_gr_ms_access */
#define REG_PHY_RXTD_IFE2_FCSI_GR_MS_ACCESS          0x10388
#define REG_PHY_RXTD_IFE2_FCSI_GR_MS_ACCESS_MASK     0x00002000
#define REG_PHY_RXTD_IFE2_FCSI_GR_MS_ACCESS_SHIFT    13
#define REG_PHY_RXTD_IFE2_FCSI_GR_MS_ACCESS_WIDTH    1

/* PHY_RXTD_IFE2_FCSI_GR_RF_ACCESS */
/* fcsi_gr_rf_access */
#define REG_PHY_RXTD_IFE2_FCSI_GR_RF_ACCESS          0x10388
#define REG_PHY_RXTD_IFE2_FCSI_GR_RF_ACCESS_MASK     0x00004000
#define REG_PHY_RXTD_IFE2_FCSI_GR_RF_ACCESS_SHIFT    14
#define REG_PHY_RXTD_IFE2_FCSI_GR_RF_ACCESS_WIDTH    1

/* PHY_RXTD_IFE2_FCSI_GR_RD_WR */
/* fcsi_gr_rd_wr */
#define REG_PHY_RXTD_IFE2_FCSI_GR_RD_WR          0x10388
#define REG_PHY_RXTD_IFE2_FCSI_GR_RD_WR_MASK     0x00008000
#define REG_PHY_RXTD_IFE2_FCSI_GR_RD_WR_SHIFT    15
#define REG_PHY_RXTD_IFE2_FCSI_GR_RD_WR_WIDTH    1

/* PHY_RXTD_IFE3_FCSI_GR_ADDR_B */
/* fcsi_gr_addr_b */
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_B          0x1038C
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_B_MASK     0x0000007f
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_B_SHIFT    0
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_B_WIDTH    7

/* PHY_RXTD_IFE3_FCSI_GR_ADDR_C */
/* fcsi_gr_addr_c */
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_C          0x1038C
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_C_MASK     0x00007f00
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_C_SHIFT    8
#define REG_PHY_RXTD_IFE3_FCSI_GR_ADDR_C_WIDTH    7

/* PHY_RXTD_IFE4_FCSI_GR_WR_DATA_A */
/* fcsi_gr_wr_data_a */
#define REG_PHY_RXTD_IFE4_FCSI_GR_WR_DATA_A          0x10390
#define REG_PHY_RXTD_IFE4_FCSI_GR_WR_DATA_A_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE4_FCSI_GR_WR_DATA_A_SHIFT    0
#define REG_PHY_RXTD_IFE4_FCSI_GR_WR_DATA_A_WIDTH    16

/* PHY_RXTD_IFE5_FCSI_GR_WR_DATA_B */
/* fcsi_gr_wr_data_b */
#define REG_PHY_RXTD_IFE5_FCSI_GR_WR_DATA_B          0x10394
#define REG_PHY_RXTD_IFE5_FCSI_GR_WR_DATA_B_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE5_FCSI_GR_WR_DATA_B_SHIFT    0
#define REG_PHY_RXTD_IFE5_FCSI_GR_WR_DATA_B_WIDTH    16

/* PHY_RXTD_IFE6_FCSI_GR_WR_DATA_C */
/* fcsi_gr_wr_data_c */
#define REG_PHY_RXTD_IFE6_FCSI_GR_WR_DATA_C          0x10398
#define REG_PHY_RXTD_IFE6_FCSI_GR_WR_DATA_C_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE6_FCSI_GR_WR_DATA_C_SHIFT    0
#define REG_PHY_RXTD_IFE6_FCSI_GR_WR_DATA_C_WIDTH    16

/* PHY_RXTD_IFE7_FCSI_RD_DATA_A */
/* fcsi_rd_data_a */
#define REG_PHY_RXTD_IFE7_FCSI_RD_DATA_A          0x1039C
#define REG_PHY_RXTD_IFE7_FCSI_RD_DATA_A_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE7_FCSI_RD_DATA_A_SHIFT    0
#define REG_PHY_RXTD_IFE7_FCSI_RD_DATA_A_WIDTH    16

/* PHY_RXTD_IFE8_FCSI_RD_DATA_B */
/* fcsi_rd_data_b */
#define REG_PHY_RXTD_IFE8_FCSI_RD_DATA_B          0x103A0
#define REG_PHY_RXTD_IFE8_FCSI_RD_DATA_B_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE8_FCSI_RD_DATA_B_SHIFT    0
#define REG_PHY_RXTD_IFE8_FCSI_RD_DATA_B_WIDTH    16

/* PHY_RXTD_IFE9_FCSI_RD_DATA_C */
/* fcsi_rd_data_c */
#define REG_PHY_RXTD_IFE9_FCSI_RD_DATA_C          0x103A4
#define REG_PHY_RXTD_IFE9_FCSI_RD_DATA_C_MASK     0x0000ffff
#define REG_PHY_RXTD_IFE9_FCSI_RD_DATA_C_SHIFT    0
#define REG_PHY_RXTD_IFE9_FCSI_RD_DATA_C_WIDTH    16

/* PHY_RXTD_IFEA_FCSI_BUSY */
/* fcsi_busy */
#define REG_PHY_RXTD_IFEA_FCSI_BUSY          0x103A8
#define REG_PHY_RXTD_IFEA_FCSI_BUSY_MASK     0x00000001
#define REG_PHY_RXTD_IFEA_FCSI_BUSY_SHIFT    0
#define REG_PHY_RXTD_IFEA_FCSI_BUSY_WIDTH    1

/* PHY_RXTD_IFEB_FCSI_MS_RESET_N */
/* fcsi_ms_reset_n */
#define REG_PHY_RXTD_IFEB_FCSI_MS_RESET_N          0x103AC
#define REG_PHY_RXTD_IFEB_FCSI_MS_RESET_N_MASK     0x00000001
#define REG_PHY_RXTD_IFEB_FCSI_MS_RESET_N_SHIFT    0
#define REG_PHY_RXTD_IFEB_FCSI_MS_RESET_N_WIDTH    1

/* PHY_RXTD_IFEB_FCSI_RF_RESET_N */
/* fcsi_rf_reset_n */
#define REG_PHY_RXTD_IFEB_FCSI_RF_RESET_N          0x103AC
#define REG_PHY_RXTD_IFEB_FCSI_RF_RESET_N_MASK     0x00000002
#define REG_PHY_RXTD_IFEB_FCSI_RF_RESET_N_SHIFT    1
#define REG_PHY_RXTD_IFEB_FCSI_RF_RESET_N_WIDTH    1

/* PHY_RXTD_IFEC_HYP_FCSI_STATE_MACHINE */
/* hyp_fcsi_state_machine */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_STATE_MACHINE          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_STATE_MACHINE_MASK     0x00000007
#define REG_PHY_RXTD_IFEC_HYP_FCSI_STATE_MACHINE_SHIFT    0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_STATE_MACHINE_WIDTH    3

/* PHY_RXTD_IFEC_HYP_FCSI_COUNTER */
/* hyp_fcsi_counter */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_MASK     0x000000f8
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_SHIFT    3
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_WIDTH    5

/* PHY_RXTD_IFEC_HYP_FCSI_COUNTER_LIMIT */
/* hyp_fcsi_counter_limit */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_LIMIT          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_LIMIT_MASK     0x00001f00
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_LIMIT_SHIFT    8
#define REG_PHY_RXTD_IFEC_HYP_FCSI_COUNTER_LIMIT_WIDTH    5

/* PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ACTIVE */
/* hyp_fcsi_clock_active */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ACTIVE          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ACTIVE_MASK     0x00002000
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ACTIVE_SHIFT    13
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ACTIVE_WIDTH    1

/* PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ENABLE */
/* hyp_fcsi_clock_enable */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ENABLE          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ENABLE_MASK     0x00004000
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ENABLE_SHIFT    14
#define REG_PHY_RXTD_IFEC_HYP_FCSI_CLOCK_ENABLE_WIDTH    1

/* PHY_RXTD_IFEC_HYP_FCSI_ACTIVE */
/* hyp_fcsi_active */
#define REG_PHY_RXTD_IFEC_HYP_FCSI_ACTIVE          0x103B0
#define REG_PHY_RXTD_IFEC_HYP_FCSI_ACTIVE_MASK     0x00008000
#define REG_PHY_RXTD_IFEC_HYP_FCSI_ACTIVE_SHIFT    15
#define REG_PHY_RXTD_IFEC_HYP_FCSI_ACTIVE_WIDTH    1

/* PHY_RXTD_IFF0_ACCUMULATOR_RESET_VALUE_I */
/* accumulator_reset_value_I */
#define REG_PHY_RXTD_IFF0_ACCUMULATOR_RESET_VALUE_I          0x103C0
#define REG_PHY_RXTD_IFF0_ACCUMULATOR_RESET_VALUE_I_MASK     0x00000fff
#define REG_PHY_RXTD_IFF0_ACCUMULATOR_RESET_VALUE_I_SHIFT    0
#define REG_PHY_RXTD_IFF0_ACCUMULATOR_RESET_VALUE_I_WIDTH    12

/* PHY_RXTD_IFF1_ACCUMULATOR_RESET_VALUE_Q */
/* accumulator_reset_value_Q */
#define REG_PHY_RXTD_IFF1_ACCUMULATOR_RESET_VALUE_Q          0x103C4
#define REG_PHY_RXTD_IFF1_ACCUMULATOR_RESET_VALUE_Q_MASK     0x00000fff
#define REG_PHY_RXTD_IFF1_ACCUMULATOR_RESET_VALUE_Q_SHIFT    0
#define REG_PHY_RXTD_IFF1_ACCUMULATOR_RESET_VALUE_Q_WIDTH    12

/* PHY_RXTD_IFF2_RESET_VALUES_IQ */
/* reset_values_IQ */
#define REG_PHY_RXTD_IFF2_RESET_VALUES_IQ          0x103C8
#define REG_PHY_RXTD_IFF2_RESET_VALUES_IQ_MASK     0x00000001
#define REG_PHY_RXTD_IFF2_RESET_VALUES_IQ_SHIFT    0
#define REG_PHY_RXTD_IFF2_RESET_VALUES_IQ_WIDTH    1

/* PHY_RXTD_IFF3_SHORT_SUM_IN0_LOW */
/* short_sum_in0_low */
#define REG_PHY_RXTD_IFF3_SHORT_SUM_IN0_LOW          0x103CC
#define REG_PHY_RXTD_IFF3_SHORT_SUM_IN0_LOW_MASK     0x000000ff
#define REG_PHY_RXTD_IFF3_SHORT_SUM_IN0_LOW_SHIFT    0
#define REG_PHY_RXTD_IFF3_SHORT_SUM_IN0_LOW_WIDTH    8

/* PHY_RXTD_IFF4_SHORT_SUM_IN0_HI */
/* short_sum_in0_hi */
#define REG_PHY_RXTD_IFF4_SHORT_SUM_IN0_HI          0x103D0
#define REG_PHY_RXTD_IFF4_SHORT_SUM_IN0_HI_MASK     0x0000ffff
#define REG_PHY_RXTD_IFF4_SHORT_SUM_IN0_HI_SHIFT    0
#define REG_PHY_RXTD_IFF4_SHORT_SUM_IN0_HI_WIDTH    16

/* PHY_RXTD_IFF5_SHORT_SUM_IN1_LOW */
/* short_sum_in1_low */
#define REG_PHY_RXTD_IFF5_SHORT_SUM_IN1_LOW          0x103D4
#define REG_PHY_RXTD_IFF5_SHORT_SUM_IN1_LOW_MASK     0x000000ff
#define REG_PHY_RXTD_IFF5_SHORT_SUM_IN1_LOW_SHIFT    0
#define REG_PHY_RXTD_IFF5_SHORT_SUM_IN1_LOW_WIDTH    8

/* PHY_RXTD_IFF6_SHORT_SUM_IN1_HI */
/* short_sum_in1_hi */
#define REG_PHY_RXTD_IFF6_SHORT_SUM_IN1_HI          0x103D8
#define REG_PHY_RXTD_IFF6_SHORT_SUM_IN1_HI_MASK     0x0000ffff
#define REG_PHY_RXTD_IFF6_SHORT_SUM_IN1_HI_SHIFT    0
#define REG_PHY_RXTD_IFF6_SHORT_SUM_IN1_HI_WIDTH    16

/* PHY_RXTD_IFF7_SHORT_SUM_IN2_LOW */
/* short_sum_in2_low */
#define REG_PHY_RXTD_IFF7_SHORT_SUM_IN2_LOW          0x103DC
#define REG_PHY_RXTD_IFF7_SHORT_SUM_IN2_LOW_MASK     0x000000ff
#define REG_PHY_RXTD_IFF7_SHORT_SUM_IN2_LOW_SHIFT    0
#define REG_PHY_RXTD_IFF7_SHORT_SUM_IN2_LOW_WIDTH    8

/* PHY_RXTD_IFF8_SHORT_SUM_IN2_HI */
/* short_sum_in2_hi */
#define REG_PHY_RXTD_IFF8_SHORT_SUM_IN2_HI          0x103E0
#define REG_PHY_RXTD_IFF8_SHORT_SUM_IN2_HI_MASK     0x0000ffff
#define REG_PHY_RXTD_IFF8_SHORT_SUM_IN2_HI_SHIFT    0
#define REG_PHY_RXTD_IFF8_SHORT_SUM_IN2_HI_WIDTH    16

/* PHY_RXTD_IFF9_SHORT_CALC_GO */
/* short_calc_go */
#define REG_PHY_RXTD_IFF9_SHORT_CALC_GO          0x103E4
#define REG_PHY_RXTD_IFF9_SHORT_CALC_GO_MASK     0x00000001
#define REG_PHY_RXTD_IFF9_SHORT_CALC_GO_SHIFT    0
#define REG_PHY_RXTD_IFF9_SHORT_CALC_GO_WIDTH    1

/* PHY_RXTD_IFFB_HYP_RXTD_GPR_LOW */
/* gpr low */
#define REG_PHY_RXTD_IFFB_HYP_RXTD_GPR_LOW          0x103EC
#define REG_PHY_RXTD_IFFB_HYP_RXTD_GPR_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IFFB_HYP_RXTD_GPR_LOW_SHIFT    0
#define REG_PHY_RXTD_IFFB_HYP_RXTD_GPR_LOW_WIDTH    16

/* PHY_RXTD_IFFC_HYP_RXTD_GPR_HIGH */
/* gpr high */
#define REG_PHY_RXTD_IFFC_HYP_RXTD_GPR_HIGH          0x103F0
#define REG_PHY_RXTD_IFFC_HYP_RXTD_GPR_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IFFC_HYP_RXTD_GPR_HIGH_SHIFT    0
#define REG_PHY_RXTD_IFFC_HYP_RXTD_GPR_HIGH_WIDTH    16

/* PHY_RXTD_IFFD_HYP_RXTD_GPO */
/* gpo high */
#define REG_PHY_RXTD_IFFD_HYP_RXTD_GPO          0x103F4
#define REG_PHY_RXTD_IFFD_HYP_RXTD_GPO_MASK     0x0000ffff
#define REG_PHY_RXTD_IFFD_HYP_RXTD_GPO_SHIFT    0
#define REG_PHY_RXTD_IFFD_HYP_RXTD_GPO_WIDTH    16

/* PHY_RXTD_IFFE_HYP_RXTD_GPI_SYNC_LOW */
/* hyp_rxtd_gpi_sync_low */
#define REG_PHY_RXTD_IFFE_HYP_RXTD_GPI_SYNC_LOW          0x103F8
#define REG_PHY_RXTD_IFFE_HYP_RXTD_GPI_SYNC_LOW_MASK     0x0000ffff
#define REG_PHY_RXTD_IFFE_HYP_RXTD_GPI_SYNC_LOW_SHIFT    0
#define REG_PHY_RXTD_IFFE_HYP_RXTD_GPI_SYNC_LOW_WIDTH    16

/* PHY_RXTD_IFFF_HYP_RXTD_GPI_SYNC_HIGH */
/* hyp_rxtd_gpi_sync_high */
#define REG_PHY_RXTD_IFFF_HYP_RXTD_GPI_SYNC_HIGH          0x103FC
#define REG_PHY_RXTD_IFFF_HYP_RXTD_GPI_SYNC_HIGH_MASK     0x0000ffff
#define REG_PHY_RXTD_IFFF_HYP_RXTD_GPI_SYNC_HIGH_SHIFT    0
#define REG_PHY_RXTD_IFFF_HYP_RXTD_GPI_SYNC_HIGH_WIDTH    16
#endif 
