/*******************************************************************
*                                                                   
*  PHY_RX_TD.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RX_TD_regs_H_FILE
#define PHY_RX_TD_regs_H_FILE

/* PHY_RXTD_REG00_SW_RESET_N_REG */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly.
[0]- RSSI.
[2]- HYP_FCSI.
[3]- Geortzel. 
[4]- Delta F
[5]- Noise Est.
[6]- Gen Risc.
[7]- Risc Logic.
[8]- Test bus fifo.
[10] - OLA select (should be active also in regular mode)
[11] - B interface
[13] - difi
 */
#define REG_PHY_RXTD_REG00_SW_RESET_N_REG          0x00000
#define REG_PHY_RXTD_REG00_SW_RESET_N_REG_MASK     0x0000ffff
#define REG_PHY_RXTD_REG00_SW_RESET_N_REG_SHIFT    0
#define REG_PHY_RXTD_REG00_SW_RESET_N_REG_WIDTH    16

/* PHY_RXTD_REG01_BLOCK_EN */
/* One bit per sub block. Block Enable.
[0]- RSSI.
[2]- HYP_FCSI.
[3]- Geortzel. 
[4]- Delta F
[5]- Noise Est.
[6]- Gen Risc.
[7]- Risc Logic.
[8]- Test bus fifo.
[10] - OLA select (should be active also in regular mode)
[11] - B interface */
#define REG_PHY_RXTD_REG01_BLOCK_EN          0x00004
#define REG_PHY_RXTD_REG01_BLOCK_EN_MASK     0x0000ffff
#define REG_PHY_RXTD_REG01_BLOCK_EN_SHIFT    0
#define REG_PHY_RXTD_REG01_BLOCK_EN_WIDTH    16

/* PHY_RXTD_REG02_REG_02 */
/* Hyperion General Register Unused. */
#define REG_PHY_RXTD_REG02_REG_02          0x00008
#define REG_PHY_RXTD_REG02_REG_02_MASK     0xffffffff
#define REG_PHY_RXTD_REG02_REG_02_SHIFT    0
#define REG_PHY_RXTD_REG02_REG_02_WIDTH    32

/* PHY_RXTD_REG03_REG_03 */
/* Hyperion General Register:
0       Use Afe Div Ratio From Register reg_03[3:1].
3:1    Afe Div Ratio.(Source Clock Is PLL).
13:8  Afe IO Control state @ miscellaneous mode (The Data is inverted).
23:16 RX Afe clock Delay Mux Select (0- no clock deley 1- 1 cell delay 2- 2 cells delay).
31:24 TX Afe clock Delay Mux Selecr (0- no clock deley 1- 1 cell delay 2- 2 cells delay). */
#define REG_PHY_RXTD_REG03_REG_03          0x0000C
#define REG_PHY_RXTD_REG03_REG_03_MASK     0xffffffff
#define REG_PHY_RXTD_REG03_REG_03_SHIFT    0
#define REG_PHY_RXTD_REG03_REG_03_WIDTH    32

/* PHY_RXTD_REG04_ADC_SAMPLING_POLARITY */
/*  Negedge Clk = "0".
 Posedge Clk = "1". */
#define REG_PHY_RXTD_REG04_ADC_SAMPLING_POLARITY          0x00010
#define REG_PHY_RXTD_REG04_ADC_SAMPLING_POLARITY_MASK     0x00000001
#define REG_PHY_RXTD_REG04_ADC_SAMPLING_POLARITY_SHIFT    0
#define REG_PHY_RXTD_REG04_ADC_SAMPLING_POLARITY_WIDTH    1

/* PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0 */
/* Bypass IIR.  */
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0          0x00014
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0_MASK     0x00000001
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0_SHIFT    0
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0_WIDTH    1

/* PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0 */
/* Equalizer bypass. */
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0          0x00014
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0_MASK     0x00000002
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0_SHIFT    1
#define REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0_WIDTH    1

/* PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_I_AN0 */
/* Dc reject IIR Mu (I) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_I_AN0          0x00018
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_I_AN0_MASK     0x00000003
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_I_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_I_AN0_WIDTH    2

/* PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_Q_AN0 */
/* Dc reject IIR Mu (Q) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_Q_AN0          0x00018
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_Q_AN0_MASK     0x00000030
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_Q_AN0_SHIFT    4
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_IIR_MU_Q_AN0_WIDTH    2

/* PHY_RXTD_REG06_IQ_MISMATCH_EST_MU_AN0 */
/* Shift round size: 2-10bit;
1-9bit; 0-8bit; */
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_MU_AN0          0x00018
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_MU_AN0_MASK     0x00300000
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_MU_AN0_SHIFT    20
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_MU_AN0_WIDTH    2

/* PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_I_SUM_AN0 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_I_SUM_AN0          0x00018
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_I_SUM_AN0_MASK     0x01000000
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_I_SUM_AN0_SHIFT    24
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_I_SUM_AN0_WIDTH    1

/* PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN0 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN0          0x00018
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN0_MASK     0x10000000
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN0_SHIFT    28
#define REG_PHY_RXTD_REG06_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN0_WIDTH    1

/* PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_I_AN0 */
/* Equalizer I pipe length;
0- 5FF delay;1- 7FF delay;
2-9 FF delay.3- 11FF delay;4- 13FF delay;5-15 FF delay; */
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_I_AN0          0x0001C
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_I_AN0_MASK     0x00000007
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_I_AN0_SHIFT    0
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_I_AN0_WIDTH    3

/* PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_Q_AN0 */
/* Equalizer Q pipe length;
0- 2FF delay;1- 3FF delay;
2-4 FF delay.3- 5FF delay;4- 6FF delay;5- 7FF delay; */
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_Q_AN0          0x0001C
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_Q_AN0_MASK     0x00000070
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_Q_AN0_SHIFT    4
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_LENGTH_Q_AN0_WIDTH    3

/* PHY_RXTD_REG07_IQ_MISMATCH_EQ_RATE_MODE_AN0 */
/* Equalizer Q rate mode;
0- 80Mhz;1- 40Mhz; */
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_RATE_MODE_AN0          0x0001C
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_RATE_MODE_AN0_MASK     0x00000100
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_RATE_MODE_AN0_SHIFT    8
#define REG_PHY_RXTD_REG07_IQ_MISMATCH_EQ_RATE_MODE_AN0_WIDTH    1

/* PHY_RXTD_REG08_DET_TH_1_1ANT */
/* det_th_1_1ant
detection threshold register 1 for 1 antenna */
#define REG_PHY_RXTD_REG08_DET_TH_1_1ANT          0x00020
#define REG_PHY_RXTD_REG08_DET_TH_1_1ANT_MASK     0x000000ff
#define REG_PHY_RXTD_REG08_DET_TH_1_1ANT_SHIFT    0
#define REG_PHY_RXTD_REG08_DET_TH_1_1ANT_WIDTH    8

/* PHY_RXTD_REG08_DET_TH_1_2ANT */
/* det_th_1_2ant
detection threshold register 1 for 2 antennas */
#define REG_PHY_RXTD_REG08_DET_TH_1_2ANT          0x00020
#define REG_PHY_RXTD_REG08_DET_TH_1_2ANT_MASK     0x0000ff00
#define REG_PHY_RXTD_REG08_DET_TH_1_2ANT_SHIFT    8
#define REG_PHY_RXTD_REG08_DET_TH_1_2ANT_WIDTH    8

/* PHY_RXTD_REG08_DET_TH_1_3ANT */
/* det_th_1_1ant
detection threshold register 1 for 3 antennas */
#define REG_PHY_RXTD_REG08_DET_TH_1_3ANT          0x00020
#define REG_PHY_RXTD_REG08_DET_TH_1_3ANT_MASK     0x00ff0000
#define REG_PHY_RXTD_REG08_DET_TH_1_3ANT_SHIFT    16
#define REG_PHY_RXTD_REG08_DET_TH_1_3ANT_WIDTH    8

/* PHY_RXTD_REG09_DETECTION_MASK_0 */
/* detection mask table - line 0  */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_0          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_0_MASK     0x00000007
#define REG_PHY_RXTD_REG09_DETECTION_MASK_0_SHIFT    0
#define REG_PHY_RXTD_REG09_DETECTION_MASK_0_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_1 */
/* detection mask table - line 1 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_1          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_1_MASK     0x00000038
#define REG_PHY_RXTD_REG09_DETECTION_MASK_1_SHIFT    3
#define REG_PHY_RXTD_REG09_DETECTION_MASK_1_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_2 */
/* detection mask table - line 2 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_2          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_2_MASK     0x000001C0
#define REG_PHY_RXTD_REG09_DETECTION_MASK_2_SHIFT    6
#define REG_PHY_RXTD_REG09_DETECTION_MASK_2_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_3 */
/* detection mask table - line 3 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_3          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_3_MASK     0x00000e00
#define REG_PHY_RXTD_REG09_DETECTION_MASK_3_SHIFT    9
#define REG_PHY_RXTD_REG09_DETECTION_MASK_3_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_4 */
/* detection mask table - line 4 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_4          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_4_MASK     0x00007000
#define REG_PHY_RXTD_REG09_DETECTION_MASK_4_SHIFT    12
#define REG_PHY_RXTD_REG09_DETECTION_MASK_4_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_5 */
/* detection mask table - line 5 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_5          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_5_MASK     0x00038000
#define REG_PHY_RXTD_REG09_DETECTION_MASK_5_SHIFT    15
#define REG_PHY_RXTD_REG09_DETECTION_MASK_5_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_6 */
/* detection mask table - line 6 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_6          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_6_MASK     0x001c0000
#define REG_PHY_RXTD_REG09_DETECTION_MASK_6_SHIFT    18
#define REG_PHY_RXTD_REG09_DETECTION_MASK_6_WIDTH    3

/* PHY_RXTD_REG09_DETECTION_MASK_7 */
/* detection mask table - line 7 */
#define REG_PHY_RXTD_REG09_DETECTION_MASK_7          0x00024
#define REG_PHY_RXTD_REG09_DETECTION_MASK_7_MASK     0x00e00000
#define REG_PHY_RXTD_REG09_DETECTION_MASK_7_SHIFT    21
#define REG_PHY_RXTD_REG09_DETECTION_MASK_7_WIDTH    3

/* PHY_RXTD_REG09_SC_CYCLIC_PERIOD */
/* sc cyclic period selector combiner cyclic period (last entry of the detection mask table).    */
#define REG_PHY_RXTD_REG09_SC_CYCLIC_PERIOD          0x00024
#define REG_PHY_RXTD_REG09_SC_CYCLIC_PERIOD_MASK     0x07000000
#define REG_PHY_RXTD_REG09_SC_CYCLIC_PERIOD_SHIFT    24
#define REG_PHY_RXTD_REG09_SC_CYCLIC_PERIOD_WIDTH    3

/* PHY_RXTD_REG0A_FIX_ARBITER_ENABLE */
/* fix abiter 2 to 1.
The arbiter will abort acces when the mips/rosc aborted. */
#define REG_PHY_RXTD_REG0A_FIX_ARBITER_ENABLE          0x00028
#define REG_PHY_RXTD_REG0A_FIX_ARBITER_ENABLE_MASK     0x00000001
#define REG_PHY_RXTD_REG0A_FIX_ARBITER_ENABLE_SHIFT    0
#define REG_PHY_RXTD_REG0A_FIX_ARBITER_ENABLE_WIDTH    1

/* PHY_RXTD_REG0C_IQ_MISMATCH_EST_ACC_COUNTER_AN0 */
/* Time of accumulate of the estimators. */
#define REG_PHY_RXTD_REG0C_IQ_MISMATCH_EST_ACC_COUNTER_AN0          0x00030
#define REG_PHY_RXTD_REG0C_IQ_MISMATCH_EST_ACC_COUNTER_AN0_MASK     0x00ffffff
#define REG_PHY_RXTD_REG0C_IQ_MISMATCH_EST_ACC_COUNTER_AN0_SHIFT    0
#define REG_PHY_RXTD_REG0C_IQ_MISMATCH_EST_ACC_COUNTER_AN0_WIDTH    24

/* PHY_RXTD_REG0D_IQ_MISMATCH_EST_START_WORK_AN0 */
/* Start estimators. */
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_START_WORK_AN0          0x00034
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_START_WORK_AN0_MASK     0x00000010
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_START_WORK_AN0_SHIFT    4
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_START_WORK_AN0_WIDTH    1

/* PHY_RXTD_REG0D_IQ_MISMATCH_EST_RESET_REGS_AN0 */
/* Reset accumulators values. */
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_RESET_REGS_AN0          0x00034
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_RESET_REGS_AN0_MASK     0x00000100
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_RESET_REGS_AN0_SHIFT    8
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_RESET_REGS_AN0_WIDTH    1

/* PHY_RXTD_REG0D_IQ_MISMATCH_EST_VALID_IQ_AN0 */
/* Rx TD IQ Mismatch Est valid */
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_VALID_IQ_AN0          0x00034
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_VALID_IQ_AN0_MASK     0x00001000
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_VALID_IQ_AN0_SHIFT    12
#define REG_PHY_RXTD_REG0D_IQ_MISMATCH_EST_VALID_IQ_AN0_WIDTH    1

/* PHY_RXTD_REG0F_IQ_MISMATCH_EST_REG_II_AN0 */
/* Estimation Accumulator II Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG0F_IQ_MISMATCH_EST_REG_II_AN0          0x0003C
#define REG_PHY_RXTD_REG0F_IQ_MISMATCH_EST_REG_II_AN0_MASK     0xffffffff
#define REG_PHY_RXTD_REG0F_IQ_MISMATCH_EST_REG_II_AN0_SHIFT    0
#define REG_PHY_RXTD_REG0F_IQ_MISMATCH_EST_REG_II_AN0_WIDTH    32

/* PHY_RXTD_REG11_IQ_MISMATCH_EST_REG_QQ_AN0 */
/* Estimation Accumulator QQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG11_IQ_MISMATCH_EST_REG_QQ_AN0          0x00044
#define REG_PHY_RXTD_REG11_IQ_MISMATCH_EST_REG_QQ_AN0_MASK     0xffffffff
#define REG_PHY_RXTD_REG11_IQ_MISMATCH_EST_REG_QQ_AN0_SHIFT    0
#define REG_PHY_RXTD_REG11_IQ_MISMATCH_EST_REG_QQ_AN0_WIDTH    32

/* PHY_RXTD_REG13_IQ_MISMATCH_EST_REG_IQ_AN0 */
/* Estimation Accumulator IQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG13_IQ_MISMATCH_EST_REG_IQ_AN0          0x0004C
#define REG_PHY_RXTD_REG13_IQ_MISMATCH_EST_REG_IQ_AN0_MASK     0xffffffff
#define REG_PHY_RXTD_REG13_IQ_MISMATCH_EST_REG_IQ_AN0_SHIFT    0
#define REG_PHY_RXTD_REG13_IQ_MISMATCH_EST_REG_IQ_AN0_WIDTH    32

/* PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW */
/* mips test plug low data */
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW          0x00050
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_MASK     0x00ffffff
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_SHIFT    0
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_WIDTH    24

/* PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_STRB */
/* mips test plug low data strobe */
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_STRB          0x00050
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_STRB_MASK     0x01000000
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_STRB_SHIFT    24
#define REG_PHY_RXTD_REG14_MIPS_TEST_PLUG_LOW_STRB_WIDTH    1

/* PHY_RXTD_REG15_MIPS_TEST_PLUG_MID */
/* mips test plug mid data */
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID          0x00054
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_MASK     0x00ffffff
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_SHIFT    0
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_WIDTH    24

/* PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_STRB */
/* mips test plug mid data strobe */
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_STRB          0x00054
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_STRB_MASK     0x01000000
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_STRB_SHIFT    24
#define REG_PHY_RXTD_REG15_MIPS_TEST_PLUG_MID_STRB_WIDTH    1

/* PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH */
/* mips test plug high data */
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH          0x00058
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_MASK     0x00ffffff
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_SHIFT    0
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_WIDTH    24

/* PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_STRB */
/* mips test plug high data strobe */
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_STRB          0x00058
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_STRB_MASK     0x01000000
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_STRB_SHIFT    24
#define REG_PHY_RXTD_REG16_MIPS_TEST_PLUG_HIGH_STRB_WIDTH    1

/* PHY_RXTD_REG17_DECIMATOR_H_0 */
/* I&Q Decimator Symmetric Filter Coefficient H[0],H[34]. */
#define REG_PHY_RXTD_REG17_DECIMATOR_H_0          0x0005C
#define REG_PHY_RXTD_REG17_DECIMATOR_H_0_MASK     0x0000007f
#define REG_PHY_RXTD_REG17_DECIMATOR_H_0_SHIFT    0
#define REG_PHY_RXTD_REG17_DECIMATOR_H_0_WIDTH    7

/* PHY_RXTD_REG17_DECIMATOR_H_1 */
/* I&Q Decimator Symmetric Filter Coefficient H[1],H[33]. */
#define REG_PHY_RXTD_REG17_DECIMATOR_H_1          0x0005C
#define REG_PHY_RXTD_REG17_DECIMATOR_H_1_MASK     0x0007f000
#define REG_PHY_RXTD_REG17_DECIMATOR_H_1_SHIFT    12
#define REG_PHY_RXTD_REG17_DECIMATOR_H_1_WIDTH    7

/* PHY_RXTD_REG18_DECIMATOR_H_2 */
/* I&Q Decimator Symmetric Filter Coefficient H[2],H[32]. */
#define REG_PHY_RXTD_REG18_DECIMATOR_H_2          0x00060
#define REG_PHY_RXTD_REG18_DECIMATOR_H_2_MASK     0x0000007f
#define REG_PHY_RXTD_REG18_DECIMATOR_H_2_SHIFT    0
#define REG_PHY_RXTD_REG18_DECIMATOR_H_2_WIDTH    7

/* PHY_RXTD_REG18_DECIMATOR_H_3 */
/* I&Q Decimator Symmetric Filter Coefficient H[3],H[31]. */
#define REG_PHY_RXTD_REG18_DECIMATOR_H_3          0x00060
#define REG_PHY_RXTD_REG18_DECIMATOR_H_3_MASK     0x0007f000
#define REG_PHY_RXTD_REG18_DECIMATOR_H_3_SHIFT    12
#define REG_PHY_RXTD_REG18_DECIMATOR_H_3_WIDTH    7

/* PHY_RXTD_REG19_DECIMATOR_H_4 */
/* I&Q Decimator Symmetric Filter Coefficient H[4],H[30]. */
#define REG_PHY_RXTD_REG19_DECIMATOR_H_4          0x00064
#define REG_PHY_RXTD_REG19_DECIMATOR_H_4_MASK     0x0000007f
#define REG_PHY_RXTD_REG19_DECIMATOR_H_4_SHIFT    0
#define REG_PHY_RXTD_REG19_DECIMATOR_H_4_WIDTH    7

/* PHY_RXTD_REG19_DECIMATOR_H_5 */
/* I&Q Decimator Symmetric Filter Coefficient H[5],H[29]. */
#define REG_PHY_RXTD_REG19_DECIMATOR_H_5          0x00064
#define REG_PHY_RXTD_REG19_DECIMATOR_H_5_MASK     0x0007f000
#define REG_PHY_RXTD_REG19_DECIMATOR_H_5_SHIFT    12
#define REG_PHY_RXTD_REG19_DECIMATOR_H_5_WIDTH    7

/* PHY_RXTD_REG1A_DECIMATOR_H_6 */
/* I&Q Decimator Symmetric Filter Coefficient H[6],H[28]. */
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_6          0x00068
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_6_MASK     0x000001ff
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_6_SHIFT    0
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_6_WIDTH    9

/* PHY_RXTD_REG1A_DECIMATOR_H_7 */
/* I&Q Decimator Symmetric Filter Coefficient H[7],H[27]. */
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_7          0x00068
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_7_MASK     0x001ff000
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_7_SHIFT    12
#define REG_PHY_RXTD_REG1A_DECIMATOR_H_7_WIDTH    9

/* PHY_RXTD_REG1B_DECIMATOR_H_8 */
/* I&Q Decimator Symmetric Filter Coefficient H[8],H[26]. */
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_8          0x0006C
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_8_MASK     0x000001ff
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_8_SHIFT    0
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_8_WIDTH    9

/* PHY_RXTD_REG1B_DECIMATOR_H_9 */
/* I&Q Decimator Symmetric Filter Coefficient H[9],H[25]. */
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_9          0x0006C
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_9_MASK     0x001ff000
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_9_SHIFT    12
#define REG_PHY_RXTD_REG1B_DECIMATOR_H_9_WIDTH    9

/* PHY_RXTD_REG1C_DECIMATOR_H_10 */
/* I&Q Decimator Symmetric Filter Coefficient H[10],H[24]. */
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_10          0x00070
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_10_MASK     0x000001ff
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_10_SHIFT    0
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_10_WIDTH    9

/* PHY_RXTD_REG1C_DECIMATOR_H_11 */
/* I&Q Decimator Symmetric Filter Coefficient H[11],H[23]. */
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_11          0x00070
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_11_MASK     0x001ff000
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_11_SHIFT    12
#define REG_PHY_RXTD_REG1C_DECIMATOR_H_11_WIDTH    9

/* PHY_RXTD_REG1D_DECIMATOR_H_12 */
/* I&Q Decimator Symmetric Filter Coefficient H[12],H[22]. */
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_12          0x00074
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_12_MASK     0x000003ff
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_12_SHIFT    0
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_12_WIDTH    10

/* PHY_RXTD_REG1D_DECIMATOR_H_13 */
/* I&Q Decimator Symmetric Filter Coefficient H[13],H[21]. */
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_13          0x00074
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_13_MASK     0x003ff000
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_13_SHIFT    12
#define REG_PHY_RXTD_REG1D_DECIMATOR_H_13_WIDTH    10

/* PHY_RXTD_REG1E_DECIMATOR_H_14 */
/* I&Q Decimator Symmetric Filter Coefficient H[14],H[20]. */
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_14          0x00078
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_14_MASK     0x000003ff
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_14_SHIFT    0
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_14_WIDTH    10

/* PHY_RXTD_REG1E_DECIMATOR_H_15 */
/* I&Q Decimator Symmetric Filter Coefficient H[15],H[19]. */
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_15          0x00078
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_15_MASK     0x003ff000
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_15_SHIFT    12
#define REG_PHY_RXTD_REG1E_DECIMATOR_H_15_WIDTH    10

/* PHY_RXTD_REG1F_DECIMATOR_H_16 */
/* I&Q Decimator Symmetric Filter Coefficient H[16],H[18]. */
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_16          0x0007C
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_16_MASK     0x000003ff
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_16_SHIFT    0
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_16_WIDTH    10

/* PHY_RXTD_REG1F_DECIMATOR_H_17 */
/* I&Q Decimator Symmetric Filter Coefficient H[17]. */
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_17          0x0007C
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_17_MASK     0x003ff000
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_17_SHIFT    12
#define REG_PHY_RXTD_REG1F_DECIMATOR_H_17_WIDTH    10

/* PHY_RXTD_REG22_NOISE_EST_EN_RESET_ACC */
/* Noise Est Enable Reset Acc:
Enable reset noise accumulator before long2 */
#define REG_PHY_RXTD_REG22_NOISE_EST_EN_RESET_ACC          0x00088
#define REG_PHY_RXTD_REG22_NOISE_EST_EN_RESET_ACC_MASK     0x00000001
#define REG_PHY_RXTD_REG22_NOISE_EST_EN_RESET_ACC_SHIFT    0
#define REG_PHY_RXTD_REG22_NOISE_EST_EN_RESET_ACC_WIDTH    1

/* PHY_RXTD_REG24_RX_IQ_SWAP */
/* Frequency Inversion IQ Swap:
Swaps the I&Q parts
"0" I=I; Q=Q.
"1" I=Q; Q=I. */
#define REG_PHY_RXTD_REG24_RX_IQ_SWAP          0x00090
#define REG_PHY_RXTD_REG24_RX_IQ_SWAP_MASK     0x00000007
#define REG_PHY_RXTD_REG24_RX_IQ_SWAP_SHIFT    0
#define REG_PHY_RXTD_REG24_RX_IQ_SWAP_WIDTH    3

/* PHY_RXTD_REG24_RX_SPECTROM_FLIP */
/* Frequency Inversion Spectrum Flip:
Conjugate The Image Value.
"0" Q=Q.
"1" Q=-Q. */
#define REG_PHY_RXTD_REG24_RX_SPECTROM_FLIP          0x00090
#define REG_PHY_RXTD_REG24_RX_SPECTROM_FLIP_MASK     0x00000070
#define REG_PHY_RXTD_REG24_RX_SPECTROM_FLIP_SHIFT    4
#define REG_PHY_RXTD_REG24_RX_SPECTROM_FLIP_WIDTH    3

/* PHY_RXTD_REG27_BAND_SELECT_H_1 */
/* Band Select USB & LSB Coefficient H[1],H[9]. */
#define REG_PHY_RXTD_REG27_BAND_SELECT_H_1          0x0009C
#define REG_PHY_RXTD_REG27_BAND_SELECT_H_1_MASK     0x001ff000
#define REG_PHY_RXTD_REG27_BAND_SELECT_H_1_SHIFT    12
#define REG_PHY_RXTD_REG27_BAND_SELECT_H_1_WIDTH    9

/* PHY_RXTD_REG28_BAND_SELECT_H_3 */
/* Band Select USB & LSB Coefficient H[3],H[7]. */
#define REG_PHY_RXTD_REG28_BAND_SELECT_H_3          0x000A0
#define REG_PHY_RXTD_REG28_BAND_SELECT_H_3_MASK     0x001ff000
#define REG_PHY_RXTD_REG28_BAND_SELECT_H_3_SHIFT    12
#define REG_PHY_RXTD_REG28_BAND_SELECT_H_3_WIDTH    9

/* PHY_RXTD_REG29_BAND_SELECT_H_5 */
/* Band Select USB & LSB Coefficient H[5]. */
#define REG_PHY_RXTD_REG29_BAND_SELECT_H_5          0x000A4
#define REG_PHY_RXTD_REG29_BAND_SELECT_H_5_MASK     0x001ff000
#define REG_PHY_RXTD_REG29_BAND_SELECT_H_5_SHIFT    12
#define REG_PHY_RXTD_REG29_BAND_SELECT_H_5_WIDTH    9

/* PHY_RXTD_REG2A_BS_GCLK_DIS */
/* Band Selecr Num Gated Clock Disable/Enable 
"0" Gated clock is Enabled.
"1" Gated clock is Disabled. */
#define REG_PHY_RXTD_REG2A_BS_GCLK_DIS          0x000A8
#define REG_PHY_RXTD_REG2A_BS_GCLK_DIS_MASK     0x00000010
#define REG_PHY_RXTD_REG2A_BS_GCLK_DIS_SHIFT    4
#define REG_PHY_RXTD_REG2A_BS_GCLK_DIS_WIDTH    1

/* PHY_RXTD_REG2A_BS_FREQ_CONV1_BYPASS */
/* Rx TD Band Select Frequency Convert 1 Bypass. */
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV1_BYPASS          0x000A8
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV1_BYPASS_MASK     0x00000100
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV1_BYPASS_SHIFT    8
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV1_BYPASS_WIDTH    1

/* PHY_RXTD_REG2A_BS_FREQ_CONV2_BYPASS */
/* Rx TD Band Select Frequency Convert 2 Bypass. */
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV2_BYPASS          0x000A8
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV2_BYPASS_MASK     0x00000200
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV2_BYPASS_SHIFT    9
#define REG_PHY_RXTD_REG2A_BS_FREQ_CONV2_BYPASS_WIDTH    1

/* PHY_RXTD_REG2A_BS_DET_DEC_BYPASS */
/* Rx TD Band Select DecimatorBypass. */
#define REG_PHY_RXTD_REG2A_BS_DET_DEC_BYPASS          0x000A8
#define REG_PHY_RXTD_REG2A_BS_DET_DEC_BYPASS_MASK     0x00000400
#define REG_PHY_RXTD_REG2A_BS_DET_DEC_BYPASS_SHIFT    10
#define REG_PHY_RXTD_REG2A_BS_DET_DEC_BYPASS_WIDTH    1

/* PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_OFDM */
/* delay in clocks for an OFDM packet */
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_OFDM          0x000B0
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_OFDM_MASK     0x00000fff
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_OFDM_SHIFT    0
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_OFDM_WIDTH    12

/* PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_11B */
/* delay in clocks for a 11b packet */
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_11B          0x000B0
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_11B_MASK     0x00fff000
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_11B_SHIFT    12
#define REG_PHY_RXTD_REG2C_CCA_TIMING_MODE_DELAY_11B_WIDTH    12

/* PHY_RXTD_REG2E_DET_BYPASS_MEAN_REMOVAL */
/* Bypass the Mean Removal.
'1' = bypass, '0' = don't bypass */
#define REG_PHY_RXTD_REG2E_DET_BYPASS_MEAN_REMOVAL          0x000B8
#define REG_PHY_RXTD_REG2E_DET_BYPASS_MEAN_REMOVAL_MASK     0x00000001
#define REG_PHY_RXTD_REG2E_DET_BYPASS_MEAN_REMOVAL_SHIFT    0
#define REG_PHY_RXTD_REG2E_DET_BYPASS_MEAN_REMOVAL_WIDTH    1

/* PHY_RXTD_REG2E_DET_MRB_DELAY_LINE_LENGTH */
/* Mean removal moving average delay line length (N).
'0' = 16, '1' = 8 */
#define REG_PHY_RXTD_REG2E_DET_MRB_DELAY_LINE_LENGTH          0x000B8
#define REG_PHY_RXTD_REG2E_DET_MRB_DELAY_LINE_LENGTH_MASK     0x00000002
#define REG_PHY_RXTD_REG2E_DET_MRB_DELAY_LINE_LENGTH_SHIFT    1
#define REG_PHY_RXTD_REG2E_DET_MRB_DELAY_LINE_LENGTH_WIDTH    1

/* PHY_RXTD_REG2E_DET_MRB_MIDDLE_TAP */
/* Mean removal middle tap position (r)
r= 0-7 */
#define REG_PHY_RXTD_REG2E_DET_MRB_MIDDLE_TAP          0x000B8
#define REG_PHY_RXTD_REG2E_DET_MRB_MIDDLE_TAP_MASK     0x0000001c
#define REG_PHY_RXTD_REG2E_DET_MRB_MIDDLE_TAP_SHIFT    2
#define REG_PHY_RXTD_REG2E_DET_MRB_MIDDLE_TAP_WIDTH    3

/* PHY_RXTD_REG2E_DET_MRB_BPF_MODE */
/* Mean Removal filter mode - BPF or HPF.
'0' = HPF mode, '1' = BPF mode. */
#define REG_PHY_RXTD_REG2E_DET_MRB_BPF_MODE          0x000B8
#define REG_PHY_RXTD_REG2E_DET_MRB_BPF_MODE_MASK     0x00000020
#define REG_PHY_RXTD_REG2E_DET_MRB_BPF_MODE_SHIFT    5
#define REG_PHY_RXTD_REG2E_DET_MRB_BPF_MODE_WIDTH    1

/* PHY_RXTD_REG2E_DET_BYPASS_DC */
/* Bypass the DC Removal.
'1' = bypass, '0' = don't bypass */
#define REG_PHY_RXTD_REG2E_DET_BYPASS_DC          0x000B8
#define REG_PHY_RXTD_REG2E_DET_BYPASS_DC_MASK     0x00000040
#define REG_PHY_RXTD_REG2E_DET_BYPASS_DC_SHIFT    6
#define REG_PHY_RXTD_REG2E_DET_BYPASS_DC_WIDTH    1

/* PHY_RXTD_REG2E_DET_DOUBLE_DELAY */
/* Use double delay in DC estimation.
'1' = use double delay. */
#define REG_PHY_RXTD_REG2E_DET_DOUBLE_DELAY          0x000B8
#define REG_PHY_RXTD_REG2E_DET_DOUBLE_DELAY_MASK     0x00000080
#define REG_PHY_RXTD_REG2E_DET_DOUBLE_DELAY_SHIFT    7
#define REG_PHY_RXTD_REG2E_DET_DOUBLE_DELAY_WIDTH    1

/* PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_1SYM */
/* Delay between coarse ready and DC calculation.
This register is used when the coarse timing determines 1 symbol delay. */
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_1SYM          0x000B8
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_1SYM_MASK     0x00007F00
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_1SYM_SHIFT    8
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_1SYM_WIDTH    7

/* PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_2SYM */
/* Delay between coarse ready and DC calculation.
This register is used when the coarse timing determines 2 symbols delay. */
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_2SYM          0x000B8
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_2SYM_MASK     0x003F8000
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_2SYM_SHIFT    15
#define REG_PHY_RXTD_REG2E_DET_DC_DELAY_AFTER_RDY_2SYM_WIDTH    7

/* PHY_RXTD_REG2E_DET_CORR_D_L */
/* Low tap (Dl) for correlation of length D (D= Dh-Dl).
The low tap can't be 0 (values - 1-14). */
#define REG_PHY_RXTD_REG2E_DET_CORR_D_L          0x000B8
#define REG_PHY_RXTD_REG2E_DET_CORR_D_L_MASK     0x03c00000
#define REG_PHY_RXTD_REG2E_DET_CORR_D_L_SHIFT    22
#define REG_PHY_RXTD_REG2E_DET_CORR_D_L_WIDTH    4

/* PHY_RXTD_REG2E_DET_CORR_D_H */
/* High tap (Dh) for correlation of length D (D= Dh-Dl).
The high tap can't be lower than the low tap (values - 2-15). */
#define REG_PHY_RXTD_REG2E_DET_CORR_D_H          0x000B8
#define REG_PHY_RXTD_REG2E_DET_CORR_D_H_MASK     0x3c000000
#define REG_PHY_RXTD_REG2E_DET_CORR_D_H_SHIFT    26
#define REG_PHY_RXTD_REG2E_DET_CORR_D_H_WIDTH    4

/* PHY_RXTD_REG2F_DET_USE_DIFF */
/* use differentiators in correlation-64 calculation.
'1' = enable, '0' = disable. */
#define REG_PHY_RXTD_REG2F_DET_USE_DIFF          0x000BC
#define REG_PHY_RXTD_REG2F_DET_USE_DIFF_MASK     0x00000001
#define REG_PHY_RXTD_REG2F_DET_USE_DIFF_SHIFT    0
#define REG_PHY_RXTD_REG2F_DET_USE_DIFF_WIDTH    1

/* PHY_RXTD_REG2F_DET_DIFF_MODE */
/* differentiators mode correlation-64 calculation (when they are enabled).
'1' = limit, '0' = round. */
#define REG_PHY_RXTD_REG2F_DET_DIFF_MODE          0x000BC
#define REG_PHY_RXTD_REG2F_DET_DIFF_MODE_MASK     0x00000002
#define REG_PHY_RXTD_REG2F_DET_DIFF_MODE_SHIFT    1
#define REG_PHY_RXTD_REG2F_DET_DIFF_MODE_WIDTH    1

/* PHY_RXTD_REG2F_DET_CNT_TH_FOR_CORR16_SIZE */
/* Number of strobes between reset and detection to change correlation-16 size (if the counter exceeds this value the size changes). */
#define REG_PHY_RXTD_REG2F_DET_CNT_TH_FOR_CORR16_SIZE          0x000BC
#define REG_PHY_RXTD_REG2F_DET_CNT_TH_FOR_CORR16_SIZE_MASK     0x000003fc
#define REG_PHY_RXTD_REG2F_DET_CNT_TH_FOR_CORR16_SIZE_SHIFT    2
#define REG_PHY_RXTD_REG2F_DET_CNT_TH_FOR_CORR16_SIZE_WIDTH    8

/* PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_TIMING */
/* Use common coarse timing signal to start DC estimation.
'1' = use common coarse timing, '0' = use local coarse timing */
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_TIMING          0x000BC
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_TIMING_MASK     0x00020000
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_TIMING_SHIFT    17
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_TIMING_WIDTH    1

/* PHY_RXTD_REG2F_DET_USE_STATE_MACHINE */
/* Use state machine decision for length of DC calculation. */
#define REG_PHY_RXTD_REG2F_DET_USE_STATE_MACHINE          0x000BC
#define REG_PHY_RXTD_REG2F_DET_USE_STATE_MACHINE_MASK     0x00040000
#define REG_PHY_RXTD_REG2F_DET_USE_STATE_MACHINE_SHIFT    18
#define REG_PHY_RXTD_REG2F_DET_USE_STATE_MACHINE_WIDTH    1

/* PHY_RXTD_REG2F_DET_FINE_ERR_CNT_INIT */
/* Error Counter Initial value for fine timing. When the counter overflows error is asserted, so "0" is the largest delay before error. */
#define REG_PHY_RXTD_REG2F_DET_FINE_ERR_CNT_INIT          0x000BC
#define REG_PHY_RXTD_REG2F_DET_FINE_ERR_CNT_INIT_MASK     0x3ff80000
#define REG_PHY_RXTD_REG2F_DET_FINE_ERR_CNT_INIT_SHIFT    19
#define REG_PHY_RXTD_REG2F_DET_FINE_ERR_CNT_INIT_WIDTH    11

/* PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_RDY */
/* Rx TD detect control immediate
'1' = report detect immidiate, '0' = report detect after cb_wait/detection */
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_RDY          0x000BC
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_RDY_MASK     0x40000000
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_RDY_SHIFT    30
#define REG_PHY_RXTD_REG2F_DET_USE_COMMON_COARSE_RDY_WIDTH    1

/* PHY_RXTD_REG2F_DET_CONTROL_IMD */
/* Use common coarse rdy signal to start fine timing.
'1' = use common coarse rdy, '0' = use local coarse rdy */
#define REG_PHY_RXTD_REG2F_DET_CONTROL_IMD          0x000BC
#define REG_PHY_RXTD_REG2F_DET_CONTROL_IMD_MASK     0x80000000
#define REG_PHY_RXTD_REG2F_DET_CONTROL_IMD_SHIFT    31
#define REG_PHY_RXTD_REG2F_DET_CONTROL_IMD_WIDTH    1

/* PHY_RXTD_REG30_DET_FINE_PEAK_CNT_INIT */
/* Peak counter Initial value for Fine timing.
Number of samples after the Peak Point 
(Ram pointer - Peak Cnt = Peak Time)  */
#define REG_PHY_RXTD_REG30_DET_FINE_PEAK_CNT_INIT          0x000C0
#define REG_PHY_RXTD_REG30_DET_FINE_PEAK_CNT_INIT_MASK     0x000000ff
#define REG_PHY_RXTD_REG30_DET_FINE_PEAK_CNT_INIT_SHIFT    0
#define REG_PHY_RXTD_REG30_DET_FINE_PEAK_CNT_INIT_WIDTH    8

/* PHY_RXTD_REG30_DET_FINE_ENABLE_DELAY */
/* Delay between enable (coarse ready) and start of module operation for fine timing. */
#define REG_PHY_RXTD_REG30_DET_FINE_ENABLE_DELAY          0x000C0
#define REG_PHY_RXTD_REG30_DET_FINE_ENABLE_DELAY_MASK     0x0000ff00
#define REG_PHY_RXTD_REG30_DET_FINE_ENABLE_DELAY_SHIFT    8
#define REG_PHY_RXTD_REG30_DET_FINE_ENABLE_DELAY_WIDTH    8

/* PHY_RXTD_REG30_DET_FINE_DELAY_SIZE */
/* Delay Ram initial write address for fine frequency. */
#define REG_PHY_RXTD_REG30_DET_FINE_DELAY_SIZE          0x000C0
#define REG_PHY_RXTD_REG30_DET_FINE_DELAY_SIZE_MASK     0x000f0000
#define REG_PHY_RXTD_REG30_DET_FINE_DELAY_SIZE_SHIFT    16
#define REG_PHY_RXTD_REG30_DET_FINE_DELAY_SIZE_WIDTH    4

/* PHY_RXTD_REG30_DET_COARSE_RDY_2SYM */
/* Number of strobes after coarse ready to determine good/bad coarse timing. */
#define REG_PHY_RXTD_REG30_DET_COARSE_RDY_2SYM          0x000C0
#define REG_PHY_RXTD_REG30_DET_COARSE_RDY_2SYM_MASK     0x0ff00000
#define REG_PHY_RXTD_REG30_DET_COARSE_RDY_2SYM_SHIFT    20
#define REG_PHY_RXTD_REG30_DET_COARSE_RDY_2SYM_WIDTH    8

/* PHY_RXTD_REG31_DET_COARSE_PEAK_CNT_INIT */
/* Peak counterInitial value for Coarse timing.
Number of samples after the Peak Point 
(Ram pointer - Peak Cnt = Peak Time)  */
#define REG_PHY_RXTD_REG31_DET_COARSE_PEAK_CNT_INIT          0x000C4
#define REG_PHY_RXTD_REG31_DET_COARSE_PEAK_CNT_INIT_MASK     0x000000ff
#define REG_PHY_RXTD_REG31_DET_COARSE_PEAK_CNT_INIT_SHIFT    0
#define REG_PHY_RXTD_REG31_DET_COARSE_PEAK_CNT_INIT_WIDTH    8

/* PHY_RXTD_REG31_DET_COARSE_ENABLE_DELAY */
/* Delay between enable (signal detect) and start of module operation for coarse timing. */
#define REG_PHY_RXTD_REG31_DET_COARSE_ENABLE_DELAY          0x000C4
#define REG_PHY_RXTD_REG31_DET_COARSE_ENABLE_DELAY_MASK     0x0000ff00
#define REG_PHY_RXTD_REG31_DET_COARSE_ENABLE_DELAY_SHIFT    8
#define REG_PHY_RXTD_REG31_DET_COARSE_ENABLE_DELAY_WIDTH    8

/* PHY_RXTD_REG31_DET_COARSE_DELAY_SIZE */
/* Delay before smoothing for coarse frequency. */
#define REG_PHY_RXTD_REG31_DET_COARSE_DELAY_SIZE          0x000C4
#define REG_PHY_RXTD_REG31_DET_COARSE_DELAY_SIZE_MASK     0x001f0000
#define REG_PHY_RXTD_REG31_DET_COARSE_DELAY_SIZE_SHIFT    16
#define REG_PHY_RXTD_REG31_DET_COARSE_DELAY_SIZE_WIDTH    5

/* PHY_RXTD_REG31_DET_COARSE_ERR_CNT_INIT */
/* Error Counter Initial value for coarse timing. When the counter overflows error is asserted, so "0" is the largest delay before error. */
#define REG_PHY_RXTD_REG31_DET_COARSE_ERR_CNT_INIT          0x000C4
#define REG_PHY_RXTD_REG31_DET_COARSE_ERR_CNT_INIT_MASK     0xffe00000
#define REG_PHY_RXTD_REG31_DET_COARSE_ERR_CNT_INIT_SHIFT    21
#define REG_PHY_RXTD_REG31_DET_COARSE_ERR_CNT_INIT_WIDTH    11

/* PHY_RXTD_REG32_DET_TOP_TH_2 */
/* Detection thershold register 2, used in boolean mode. */
#define REG_PHY_RXTD_REG32_DET_TOP_TH_2          0x000C8
#define REG_PHY_RXTD_REG32_DET_TOP_TH_2_MASK     0x0000ff00
#define REG_PHY_RXTD_REG32_DET_TOP_TH_2_SHIFT    8
#define REG_PHY_RXTD_REG32_DET_TOP_TH_2_WIDTH    8

/* PHY_RXTD_REG32_DET_TOP_TH_3 */
/* Detection thershold register 3, used in power branch. */
#define REG_PHY_RXTD_REG32_DET_TOP_TH_3          0x000C8
#define REG_PHY_RXTD_REG32_DET_TOP_TH_3_MASK     0x01ff0000
#define REG_PHY_RXTD_REG32_DET_TOP_TH_3_SHIFT    16
#define REG_PHY_RXTD_REG32_DET_TOP_TH_3_WIDTH    9

/* PHY_RXTD_REG32_DET_TOP_CNT */
/* Number of times the condition for detection exists, before asserting signal detect. */
#define REG_PHY_RXTD_REG32_DET_TOP_CNT          0x000C8
#define REG_PHY_RXTD_REG32_DET_TOP_CNT_MASK     0x0E000000
#define REG_PHY_RXTD_REG32_DET_TOP_CNT_SHIFT    25
#define REG_PHY_RXTD_REG32_DET_TOP_CNT_WIDTH    3

/* PHY_RXTD_REG32_DET_TOP_MODE */
/* Detection mode:
'0'= A (gen1), '1' = B1 (abs), '2' = B2 (boolean), '3' = B3 (abs^2) */
#define REG_PHY_RXTD_REG32_DET_TOP_MODE          0x000C8
#define REG_PHY_RXTD_REG32_DET_TOP_MODE_MASK     0x30000000
#define REG_PHY_RXTD_REG32_DET_TOP_MODE_SHIFT    28
#define REG_PHY_RXTD_REG32_DET_TOP_MODE_WIDTH    2

/* PHY_RXTD_REG33_DET_TOP_BLOCK_CNT */
/* For how many strobes the detection is blocked. */
#define REG_PHY_RXTD_REG33_DET_TOP_BLOCK_CNT          0x000CC
#define REG_PHY_RXTD_REG33_DET_TOP_BLOCK_CNT_MASK     0x00000fff
#define REG_PHY_RXTD_REG33_DET_TOP_BLOCK_CNT_SHIFT    0
#define REG_PHY_RXTD_REG33_DET_TOP_BLOCK_CNT_WIDTH    12

/* PHY_RXTD_REG33_WAIT_CYCLES */
/* Number of cycles to wait after first detect before determining the input select (Usb/lsb etc detect). */
#define REG_PHY_RXTD_REG33_WAIT_CYCLES          0x000CC
#define REG_PHY_RXTD_REG33_WAIT_CYCLES_MASK     0x000ff000
#define REG_PHY_RXTD_REG33_WAIT_CYCLES_SHIFT    12
#define REG_PHY_RXTD_REG33_WAIT_CYCLES_WIDTH    8

/* PHY_RXTD_REG33_DET_MA_DEC */
/* Rx TD ma_dec.
fine timing moving average decrease from 96 length.
 */
#define REG_PHY_RXTD_REG33_DET_MA_DEC          0x000CC
#define REG_PHY_RXTD_REG33_DET_MA_DEC_MASK     0x00f00000
#define REG_PHY_RXTD_REG33_DET_MA_DEC_SHIFT    20
#define REG_PHY_RXTD_REG33_DET_MA_DEC_WIDTH    4

/* PHY_RXTD_REG34_HT_SHORT_OFFSET */
/* CCA ht short offset */
#define REG_PHY_RXTD_REG34_HT_SHORT_OFFSET          0x000D0
#define REG_PHY_RXTD_REG34_HT_SHORT_OFFSET_MASK     0x00003fff
#define REG_PHY_RXTD_REG34_HT_SHORT_OFFSET_SHIFT    0
#define REG_PHY_RXTD_REG34_HT_SHORT_OFFSET_WIDTH    14

/* PHY_RXTD_REG34_LAST_SAMPLE_OFFSET */
/* CCA last sample offset */
#define REG_PHY_RXTD_REG34_LAST_SAMPLE_OFFSET          0x000D0
#define REG_PHY_RXTD_REG34_LAST_SAMPLE_OFFSET_MASK     0x03ffC000
#define REG_PHY_RXTD_REG34_LAST_SAMPLE_OFFSET_SHIFT    14
#define REG_PHY_RXTD_REG34_LAST_SAMPLE_OFFSET_WIDTH    12

/* PHY_RXTD_REG35_CCA_ENERGY_0_1_DELAY */
/* delay in clocks of CCA rise event */
#define REG_PHY_RXTD_REG35_CCA_ENERGY_0_1_DELAY          0x000D4
#define REG_PHY_RXTD_REG35_CCA_ENERGY_0_1_DELAY_MASK     0x000003ff
#define REG_PHY_RXTD_REG35_CCA_ENERGY_0_1_DELAY_SHIFT    0
#define REG_PHY_RXTD_REG35_CCA_ENERGY_0_1_DELAY_WIDTH    10

/* PHY_RXTD_REG35_CCA_ENERGY_1_0_DELAY */
/* delay in clocks of CCA fall event */
#define REG_PHY_RXTD_REG35_CCA_ENERGY_1_0_DELAY          0x000D4
#define REG_PHY_RXTD_REG35_CCA_ENERGY_1_0_DELAY_MASK     0x003ff000
#define REG_PHY_RXTD_REG35_CCA_ENERGY_1_0_DELAY_SHIFT    12
#define REG_PHY_RXTD_REG35_CCA_ENERGY_1_0_DELAY_WIDTH    10

/* PHY_RXTD_REG35_LSB_IS_CTRL_CHANNEL */
/* indicates wether LSB is the control channel (1 - LSB,0 - USB) */
#define REG_PHY_RXTD_REG35_LSB_IS_CTRL_CHANNEL          0x000D4
#define REG_PHY_RXTD_REG35_LSB_IS_CTRL_CHANNEL_MASK     0x01000000
#define REG_PHY_RXTD_REG35_LSB_IS_CTRL_CHANNEL_SHIFT    24
#define REG_PHY_RXTD_REG35_LSB_IS_CTRL_CHANNEL_WIDTH    1

/* PHY_RXTD_REG35_DISABLE_CCA_ED_EXT */
/* 0 - both channels affect CCA_ED ,1 - Only ctrl channel afferct CCA_ED */
#define REG_PHY_RXTD_REG35_DISABLE_CCA_ED_EXT          0x000D4
#define REG_PHY_RXTD_REG35_DISABLE_CCA_ED_EXT_MASK     0x02000000
#define REG_PHY_RXTD_REG35_DISABLE_CCA_ED_EXT_SHIFT    25
#define REG_PHY_RXTD_REG35_DISABLE_CCA_ED_EXT_WIDTH    1

/* PHY_RXTD_REG35_BLOCK_AUX_CHANNEL */
/* block_aux_channel */
#define REG_PHY_RXTD_REG35_BLOCK_AUX_CHANNEL          0x000D4
#define REG_PHY_RXTD_REG35_BLOCK_AUX_CHANNEL_MASK     0x04000000
#define REG_PHY_RXTD_REG35_BLOCK_AUX_CHANNEL_SHIFT    26
#define REG_PHY_RXTD_REG35_BLOCK_AUX_CHANNEL_WIDTH    1

/* PHY_RXTD_REG35_RESET_CCA_COUNTERS */
/* reset cca counters */
#define REG_PHY_RXTD_REG35_RESET_CCA_COUNTERS          0x000D4
#define REG_PHY_RXTD_REG35_RESET_CCA_COUNTERS_MASK     0x08000000
#define REG_PHY_RXTD_REG35_RESET_CCA_COUNTERS_SHIFT    27
#define REG_PHY_RXTD_REG35_RESET_CCA_COUNTERS_WIDTH    1

/* PHY_RXTD_REG35_CCA_ACC_SAMPLES */
/* number of samples to use for energy estimation (number + 1) */
#define REG_PHY_RXTD_REG35_CCA_ACC_SAMPLES          0x000D4
#define REG_PHY_RXTD_REG35_CCA_ACC_SAMPLES_MASK     0xf0000000
#define REG_PHY_RXTD_REG35_CCA_ACC_SAMPLES_SHIFT    28
#define REG_PHY_RXTD_REG35_CCA_ACC_SAMPLES_WIDTH    4

/* PHY_RXTD_REG36_CCA_ED_THRESHOLD */
/* threshold value */
#define REG_PHY_RXTD_REG36_CCA_ED_THRESHOLD          0x000D8
#define REG_PHY_RXTD_REG36_CCA_ED_THRESHOLD_MASK     0x000000ff
#define REG_PHY_RXTD_REG36_CCA_ED_THRESHOLD_SHIFT    0
#define REG_PHY_RXTD_REG36_CCA_ED_THRESHOLD_WIDTH    8

/* PHY_RXTD_REG37_CTRL_CHANNEL_CNT */
/* counter for the control channel */
#define REG_PHY_RXTD_REG37_CTRL_CHANNEL_CNT          0x000DC
#define REG_PHY_RXTD_REG37_CTRL_CHANNEL_CNT_MASK     0xffffffff
#define REG_PHY_RXTD_REG37_CTRL_CHANNEL_CNT_SHIFT    0
#define REG_PHY_RXTD_REG37_CTRL_CHANNEL_CNT_WIDTH    32

/* PHY_RXTD_REG38_EXT_CHANNEL_CNT */
/* counter for the extension channel */
#define REG_PHY_RXTD_REG38_EXT_CHANNEL_CNT          0x000E0
#define REG_PHY_RXTD_REG38_EXT_CHANNEL_CNT_MASK     0xffffffff
#define REG_PHY_RXTD_REG38_EXT_CHANNEL_CNT_SHIFT    0
#define REG_PHY_RXTD_REG38_EXT_CHANNEL_CNT_WIDTH    32

/* PHY_RXTD_REG3A_ADC_ACTIVE_REG */
/* Rx TD Adc Active.
0- Adc Is Not active.
1- Adc Is Active Sample the Incoming data from the Athena. */
#define REG_PHY_RXTD_REG3A_ADC_ACTIVE_REG          0x000E8
#define REG_PHY_RXTD_REG3A_ADC_ACTIVE_REG_MASK     0x00000001
#define REG_PHY_RXTD_REG3A_ADC_ACTIVE_REG_SHIFT    0
#define REG_PHY_RXTD_REG3A_ADC_ACTIVE_REG_WIDTH    1

/* PHY_RXTD_REG3B_SYM_DATA_LEN_REG */
/* Symbol Data byte length.
option num 3 of the "sym_data_len_select" */
#define REG_PHY_RXTD_REG3B_SYM_DATA_LEN_REG          0x000EC
#define REG_PHY_RXTD_REG3B_SYM_DATA_LEN_REG_MASK     0x000000ff
#define REG_PHY_RXTD_REG3B_SYM_DATA_LEN_REG_SHIFT    0
#define REG_PHY_RXTD_REG3B_SYM_DATA_LEN_REG_WIDTH    8

/* PHY_RXTD_REG3C_CB_ENABLE */
/* Operation mode.
"1" 40 Mhz (Afe @ 80Mhz).
"0" 20 Mhz (Afe @ 40Mhz). */
#define REG_PHY_RXTD_REG3C_CB_ENABLE          0x000F0
#define REG_PHY_RXTD_REG3C_CB_ENABLE_MASK     0x00000001
#define REG_PHY_RXTD_REG3C_CB_ENABLE_SHIFT    0
#define REG_PHY_RXTD_REG3C_CB_ENABLE_WIDTH    1

/* PHY_RXTD_REG3C_HOST_ANTENNA_EN */
/* Antenna Enable.
Bit 0 An 0 is Enable.
Bit 1 An 1 is Enable.
Bit 2 An 2 is Enable. */
#define REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN          0x000F0
#define REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_MASK     0x00000070
#define REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_SHIFT    4
#define REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_WIDTH    3

/* PHY_RXTD_REG3C_BAND_SELECT_DELAY */
/* Band select Clock Cycles Delay
for the Time Doamin CSM (Signed value).
Used For:
1.UNCB 20Mhz
2.CB Usb.
3.CB Lsb.
4.Hb. */
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY          0x000F0
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_MASK     0x0000ff00
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_SHIFT    8
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_WIDTH    8

/* PHY_RXTD_REG3C_BAND_SELECT_DELAY_2B */
/* Band select Clock Cycles Delay
for the Time Doamin CSM (Signed value).
Used For:
1.CB 2 Band (Intel Mode).
2.Full CB. */
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_2B          0x000F0
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_2B_MASK     0x00ff0000
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_2B_SHIFT    16
#define REG_PHY_RXTD_REG3C_BAND_SELECT_DELAY_2B_WIDTH    8

/* PHY_RXTD_REG3D_STM_ABORT_THR */
/* RX Time Domain Abort counter threshold.
up to 17usec delay.  */
#define REG_PHY_RXTD_REG3D_STM_ABORT_THR          0x000F4
#define REG_PHY_RXTD_REG3D_STM_ABORT_THR_MASK     0x0000ffff
#define REG_PHY_RXTD_REG3D_STM_ABORT_THR_SHIFT    0
#define REG_PHY_RXTD_REG3D_STM_ABORT_THR_WIDTH    16

/* PHY_RXTD_REG3E_BYPASS_IQ_ALL */
/* Bypass IQ Mismatch */
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL          0x000F8
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_MASK     0x00000001
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_SHIFT    0
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_WIDTH    1

/* PHY_RXTD_REG3E_BYPASS_DEC_ALL */
/* Bypass Decimator Filter */
#define REG_PHY_RXTD_REG3E_BYPASS_DEC_ALL          0x000F8
#define REG_PHY_RXTD_REG3E_BYPASS_DEC_ALL_MASK     0x00000002
#define REG_PHY_RXTD_REG3E_BYPASS_DEC_ALL_SHIFT    1
#define REG_PHY_RXTD_REG3E_BYPASS_DEC_ALL_WIDTH    1

/* PHY_RXTD_REG3E_BYPASS_IQ_ALL_FOR_AGC */
/* Rx TD Bypass iq for agc:
0 agc bb = iq mismatcgh out
1 agc bb = adc data out */
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_FOR_AGC          0x000F8
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_FOR_AGC_MASK     0x00000004
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_FOR_AGC_SHIFT    2
#define REG_PHY_RXTD_REG3E_BYPASS_IQ_ALL_FOR_AGC_WIDTH    1

/* PHY_RXTD_REG3E_BYPASS_DC_ALL */
/* Bypass Dc Removal */
#define REG_PHY_RXTD_REG3E_BYPASS_DC_ALL          0x000F8
#define REG_PHY_RXTD_REG3E_BYPASS_DC_ALL_MASK     0x00000020
#define REG_PHY_RXTD_REG3E_BYPASS_DC_ALL_SHIFT    5
#define REG_PHY_RXTD_REG3E_BYPASS_DC_ALL_WIDTH    1

/* PHY_RXTD_REG040_RSSI_0_BIN_NUM */
/* Rssi 0 Bin locatioin.
0-rssi_data[7:0].
1-rssi_data[15:8].
2-rssi_data[23:16].
etc.
rssi_data is a shift left register suppurts up to 8xrssi[7:0]. */
#define REG_PHY_RXTD_REG040_RSSI_0_BIN_NUM          0x00100
#define REG_PHY_RXTD_REG040_RSSI_0_BIN_NUM_MASK     0x00000003
#define REG_PHY_RXTD_REG040_RSSI_0_BIN_NUM_SHIFT    0
#define REG_PHY_RXTD_REG040_RSSI_0_BIN_NUM_WIDTH    2

/* PHY_RXTD_REG040_RSSI_1_BIN_NUM */
/* Rssi 1 Bin locatioin.
0-rssi_data[7:0].
1-rssi_data[15:8].
2-rssi_data[23:16].
etc.
rssi_data is a shift left register suppurts up to 8xrssi[7:0]. */
#define REG_PHY_RXTD_REG040_RSSI_1_BIN_NUM          0x00100
#define REG_PHY_RXTD_REG040_RSSI_1_BIN_NUM_MASK     0x00000030
#define REG_PHY_RXTD_REG040_RSSI_1_BIN_NUM_SHIFT    4
#define REG_PHY_RXTD_REG040_RSSI_1_BIN_NUM_WIDTH    2

/* PHY_RXTD_REG040_RSSI_2_BIN_NUM */
/* Rssi 2 Bin locatioin.
0-rssi_data[7:0].
1-rssi_data[15:8].
2-rssi_data[23:16].
etc.
rssi_data is a shift left register suppurts up to 8xrssi[7:0]. */
#define REG_PHY_RXTD_REG040_RSSI_2_BIN_NUM          0x00100
#define REG_PHY_RXTD_REG040_RSSI_2_BIN_NUM_MASK     0x00000300
#define REG_PHY_RXTD_REG040_RSSI_2_BIN_NUM_SHIFT    8
#define REG_PHY_RXTD_REG040_RSSI_2_BIN_NUM_WIDTH    2

/* PHY_RXTD_REG041_RSSI_SAMPLE_POLARITY */
/* Rssi sample Polarity.
0-Negative edge.
1-Positive edge.
 */
#define REG_PHY_RXTD_REG041_RSSI_SAMPLE_POLARITY          0x00104
#define REG_PHY_RXTD_REG041_RSSI_SAMPLE_POLARITY_MASK     0x00000001
#define REG_PHY_RXTD_REG041_RSSI_SAMPLE_POLARITY_SHIFT    0
#define REG_PHY_RXTD_REG041_RSSI_SAMPLE_POLARITY_WIDTH    1

/* PHY_RXTD_REG041_RSSI_STRB_THR */
/* ESSI strobe threshold:
CB strobe rate 20Mhz 1:12  0xb
NCB strobe rate 10MHZ 1:24 0x17 */
#define REG_PHY_RXTD_REG041_RSSI_STRB_THR          0x00104
#define REG_PHY_RXTD_REG041_RSSI_STRB_THR_MASK     0x000001f0
#define REG_PHY_RXTD_REG041_RSSI_STRB_THR_SHIFT    4
#define REG_PHY_RXTD_REG041_RSSI_STRB_THR_WIDTH    5

/* PHY_RXTD_REG041_RSSI_POP_THR */
/* ESSI Read strobe threshold:
CB/Ncb Read pointer should be 0x5
 */
#define REG_PHY_RXTD_REG041_RSSI_POP_THR          0x00104
#define REG_PHY_RXTD_REG041_RSSI_POP_THR_MASK     0x0001f000
#define REG_PHY_RXTD_REG041_RSSI_POP_THR_SHIFT    12
#define REG_PHY_RXTD_REG041_RSSI_POP_THR_WIDTH    5

/* PHY_RXTD_REG04B_PARALLEL_MODE */
/* Rx TD Hyp Pif Parallel Mode.
1-Parallel Mode
0-Mspi. */
#define REG_PHY_RXTD_REG04B_PARALLEL_MODE          0x0012C
#define REG_PHY_RXTD_REG04B_PARALLEL_MODE_MASK     0x00000010
#define REG_PHY_RXTD_REG04B_PARALLEL_MODE_SHIFT    4
#define REG_PHY_RXTD_REG04B_PARALLEL_MODE_WIDTH    1

/* PHY_RXTD_REG04C_DELTA_F_CMP_EN */
/* Delta F compare enable:
1-Compare the Fine Angle to the 4*Coarse Angle.
0-delta F data equal to fine Angle.

 */
#define REG_PHY_RXTD_REG04C_DELTA_F_CMP_EN          0x00130
#define REG_PHY_RXTD_REG04C_DELTA_F_CMP_EN_MASK     0x00000001
#define REG_PHY_RXTD_REG04C_DELTA_F_CMP_EN_SHIFT    0
#define REG_PHY_RXTD_REG04C_DELTA_F_CMP_EN_WIDTH    1

/* PHY_RXTD_REG04C_DELTA_F_FINE_ERR_ENABLE */
/* Delta F fine error enable.
1- disable delta f operation when fine error is asserted.
0- delta f is active when fine error was asserted.


 */
#define REG_PHY_RXTD_REG04C_DELTA_F_FINE_ERR_ENABLE          0x00130
#define REG_PHY_RXTD_REG04C_DELTA_F_FINE_ERR_ENABLE_MASK     0x00000010
#define REG_PHY_RXTD_REG04C_DELTA_F_FINE_ERR_ENABLE_SHIFT    4
#define REG_PHY_RXTD_REG04C_DELTA_F_FINE_ERR_ENABLE_WIDTH    1

/* PHY_RXTD_REG04F_RISC_ARBITER_GCLK_BYPASS */
/* Gclk Bypass. */
#define REG_PHY_RXTD_REG04F_RISC_ARBITER_GCLK_BYPASS          0x0013C
#define REG_PHY_RXTD_REG04F_RISC_ARBITER_GCLK_BYPASS_MASK     0x00000001
#define REG_PHY_RXTD_REG04F_RISC_ARBITER_GCLK_BYPASS_SHIFT    0
#define REG_PHY_RXTD_REG04F_RISC_ARBITER_GCLK_BYPASS_WIDTH    1

/* PHY_RXTD_REG050_RISC_PAGE */
/* Risc Page Address. Allows access to internal registers
 */
#define REG_PHY_RXTD_REG050_RISC_PAGE          0x00140
#define REG_PHY_RXTD_REG050_RISC_PAGE_MASK     0x00000010
#define REG_PHY_RXTD_REG050_RISC_PAGE_SHIFT    4
#define REG_PHY_RXTD_REG050_RISC_PAGE_WIDTH    1

/* PHY_RXTD_REG051_RISC_START_OP */
/* Rx TD RIsc Start Opcode.
The Risc will Jump to Boot address (0x000)
and Start the Risc Prog. */
#define REG_PHY_RXTD_REG051_RISC_START_OP          0x00144
#define REG_PHY_RXTD_REG051_RISC_START_OP_MASK     0x00000001
#define REG_PHY_RXTD_REG051_RISC_START_OP_SHIFT    0
#define REG_PHY_RXTD_REG051_RISC_START_OP_WIDTH    1

/* PHY_RXTD_REG053_GEORTZEL_IQ_SELECT */
/* Geortzel IQ Select.
1= Select I Data.
0= Select Q Data. */
#define REG_PHY_RXTD_REG053_GEORTZEL_IQ_SELECT          0x0014C
#define REG_PHY_RXTD_REG053_GEORTZEL_IQ_SELECT_MASK     0x00000001
#define REG_PHY_RXTD_REG053_GEORTZEL_IQ_SELECT_SHIFT    0
#define REG_PHY_RXTD_REG053_GEORTZEL_IQ_SELECT_WIDTH    1

/* PHY_RXTD_REG053_GEORTZEL_RESET_ACUM */
/* Reset the acum result
should be reseted before start operation. */
#define REG_PHY_RXTD_REG053_GEORTZEL_RESET_ACUM          0x0014C
#define REG_PHY_RXTD_REG053_GEORTZEL_RESET_ACUM_MASK     0x00000010
#define REG_PHY_RXTD_REG053_GEORTZEL_RESET_ACUM_SHIFT    4
#define REG_PHY_RXTD_REG053_GEORTZEL_RESET_ACUM_WIDTH    1

/* PHY_RXTD_REG053_GEORTZEL_ADC_SELECT */
/* Geortzel ADC Select.
1-select antenna-0.
2-select antenna-1.
3-select antenna-2.
default value antenna-0. */
#define REG_PHY_RXTD_REG053_GEORTZEL_ADC_SELECT          0x0014C
#define REG_PHY_RXTD_REG053_GEORTZEL_ADC_SELECT_MASK     0x00000700
#define REG_PHY_RXTD_REG053_GEORTZEL_ADC_SELECT_SHIFT    8
#define REG_PHY_RXTD_REG053_GEORTZEL_ADC_SELECT_WIDTH    3

/* PHY_RXTD_REG054_GEORTZEL_MUL_I */
/* I Mult Value. */
#define REG_PHY_RXTD_REG054_GEORTZEL_MUL_I          0x00150
#define REG_PHY_RXTD_REG054_GEORTZEL_MUL_I_MASK     0x00000fff
#define REG_PHY_RXTD_REG054_GEORTZEL_MUL_I_SHIFT    0
#define REG_PHY_RXTD_REG054_GEORTZEL_MUL_I_WIDTH    12

/* PHY_RXTD_REG055_GEORTZEL_MUL_Q */
/* Q Mult Value. */
#define REG_PHY_RXTD_REG055_GEORTZEL_MUL_Q          0x00154
#define REG_PHY_RXTD_REG055_GEORTZEL_MUL_Q_MASK     0x00000fff
#define REG_PHY_RXTD_REG055_GEORTZEL_MUL_Q_SHIFT    0
#define REG_PHY_RXTD_REG055_GEORTZEL_MUL_Q_WIDTH    12

/* PHY_RXTD_REG056_GEORTZEL_I_RESULT */
/* Geortzel I Result. */
#define REG_PHY_RXTD_REG056_GEORTZEL_I_RESULT          0x00158
#define REG_PHY_RXTD_REG056_GEORTZEL_I_RESULT_MASK     0x0fffffff
#define REG_PHY_RXTD_REG056_GEORTZEL_I_RESULT_SHIFT    0
#define REG_PHY_RXTD_REG056_GEORTZEL_I_RESULT_WIDTH    28

/* PHY_RXTD_REG057_GEORTZEL_Q_RESULT */
/* Geortzel Q Result. */
#define REG_PHY_RXTD_REG057_GEORTZEL_Q_RESULT          0x0015C
#define REG_PHY_RXTD_REG057_GEORTZEL_Q_RESULT_MASK     0x0fffffff
#define REG_PHY_RXTD_REG057_GEORTZEL_Q_RESULT_SHIFT    0
#define REG_PHY_RXTD_REG057_GEORTZEL_Q_RESULT_WIDTH    28

/* PHY_RXTD_REG057_GEORTZEL_DATA_VALID */
/* Geortzel Data Valid. */
#define REG_PHY_RXTD_REG057_GEORTZEL_DATA_VALID          0x0015C
#define REG_PHY_RXTD_REG057_GEORTZEL_DATA_VALID_MASK     0x80000000
#define REG_PHY_RXTD_REG057_GEORTZEL_DATA_VALID_SHIFT    31
#define REG_PHY_RXTD_REG057_GEORTZEL_DATA_VALID_WIDTH    1

/* PHY_RXTD_REG058_GEORTZEL_VALID_THR */
/* Geortzel Valid Threshold.
Number Of incoming data bins (64,128,256). */
#define REG_PHY_RXTD_REG058_GEORTZEL_VALID_THR          0x00160
#define REG_PHY_RXTD_REG058_GEORTZEL_VALID_THR_MASK     0x0000007f
#define REG_PHY_RXTD_REG058_GEORTZEL_VALID_THR_SHIFT    0
#define REG_PHY_RXTD_REG058_GEORTZEL_VALID_THR_WIDTH    7

/* PHY_RXTD_REG05A_RAM_BIST_RESULT */
/* Bist Result Low Result. */
#define REG_PHY_RXTD_REG05A_RAM_BIST_RESULT          0x00168
#define REG_PHY_RXTD_REG05A_RAM_BIST_RESULT_MASK     0xffffffff
#define REG_PHY_RXTD_REG05A_RAM_BIST_RESULT_SHIFT    0
#define REG_PHY_RXTD_REG05A_RAM_BIST_RESULT_WIDTH    32

/* PHY_RXTD_REG05C_RAM_BIST_DONE */
/* Bist Done Low Result. */
#define REG_PHY_RXTD_REG05C_RAM_BIST_DONE          0x00170
#define REG_PHY_RXTD_REG05C_RAM_BIST_DONE_MASK     0xffffffff
#define REG_PHY_RXTD_REG05C_RAM_BIST_DONE_SHIFT    0
#define REG_PHY_RXTD_REG05C_RAM_BIST_DONE_WIDTH    32

/* PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0 */
/* Test Plug Local Enable.
bit[0]-an0 Low ADC Fifo Data In {I,Q}
bit[1]-an0 Low ADC Data Out {I,Q}.
bit[2]-an0 Low IQ Mismatch Data Out {I,Q}.
bit[3]-an0 Low IQ Mismatch 0
bit[4]-an0 Low IQ Mismatch 1
bit[5]-an0 Low IQ Mismatch 2
bit[6]-an0 Low Decimator Data Out {I,Q}.
bit[7]-an0 Low Band Select Data Out BS_1{I,Q},BS_2{I,Q}.
bit[8]-an0 Low Dc Removal In (Fifo Data Out) {I,Q}.
bit[9]-an0 Low Dc Removal Out {I,Q}.
bit[10]-an0 Low Nco Data out {I,Q}.
bit[11]-an0 Low Nco Data Out FFt Data In {I,Q}.
bit[16]-an0 Low Noise In {I,Q}
bit[17]-an0 Mid Noise Delayed data In {I,Q}
bit[18]-an0 High Noise Data Out 24b
bit[19]-Risc Low Data
bit[20]-RSSI
bit[21]-OLA
bit[22]-risc last executed
bit[23]-mips low
bit[24]-difi */
#define REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0          0x00178
#define REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0_MASK     0x01ffffff
#define REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0_SHIFT    0
#define REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0_WIDTH    25

/* PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1 */
/* Test Plug Local Enable.
bit[0]-an0 Mid ADC Fifo Data In {I,Q}
bit[1]-an0 Mid ADC Data Out {I,Q}.
bit[2]-an0 Mid IQ Mismatch Data Out {I,Q}.
bit[3]-an0 Mid IQ Mismatch 0
bit[4]-an0 Mid IQ Mismatch 1
bit[5]-an0 Mid IQ Mismatch 2
bit[6]-an0 Mid Decimator Data Out {I,Q}.
bit[7]-an0 Mid Band Select Data Out BS_1{I,Q},BS_2{I,Q}.
bit[8]-an0 Mid Dc Removal In (Fifo Data Out) {I,Q}.
bit[9]-an0 Mid Dc Removal Out {I,Q}.
bit[10]-an0 Mid Nco Data out {I,Q}.
bit[11]-an0 Mid Nco Data Out FFt Data In {I,Q}.
bit[16]-an0 Low Noise In {I,Q}
bit[17]-an0 Mid Noise Delayed data In {I,Q}
bit[18]-an0 High Noise Data Out 24b
bit[19]-Risc Mid Data
bit[20]-RSSI
bit[21]-TD state machines
bit[23]-mips mid
bit[24]-difi */
#define REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1          0x0017C
#define REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1_MASK     0x01ffffff
#define REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1_SHIFT    0
#define REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1_WIDTH    25

/* PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2 */
/* Test Plug Local Enable.
bit[0]-an0 High ADC Fifo Data In {I,Q}
bit[1]-an0 High ADC Data Out {I,Q}.
bit[2]-an0 High IQ Mismatch Data Out {I,Q}.
bit[3]-an0 High IQ Mismatch 0
bit[4]-an0 High IQ Mismatch 1
bit[5]-an0 High IQ Mismatch 2
bit[6]-an0 High Decimator Data Out {I,Q}.
bit[7]-an0 High Band Select Data Out BS_1{I,Q},BS_2{I,Q}.
bit[8]-an0 High Dc Removal In (Fifo Data Out) {I,Q}.
bit[9]-an0 High Dc Removal Out {I,Q}.
bit[10]-an0 High Nco Data out {I,Q}.
bit[11]-an0 High Nco Data Out FFt Data In {I,Q}.
bit[16]-an0 Low Noise In {I,Q}
bit[17]-an0 Mid Noise Delayed data In {I,Q}
bit[18]-an0 High Noise Data Out 24b
bit[19]-Risc High Data
bit[20]-RSSI
bit[23]-mips high
bit[24]-difi */
#define REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2          0x00180
#define REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2_MASK     0x01ffffff
#define REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2_SHIFT    0
#define REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2_WIDTH    25

/* PHY_RXTD_REG061_GSM_SW_RESET_MASK */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "1" resets the sub block. the reg is used automatically between packets.
[0]- RSSI.
[2]- Prometh i/f.
[3]- Geortzel. 
[4]- Delta F
[5]- Noise Est.
[6]- Gen Risc.
[7]- Risc Logic.
[8]- Test bus fifo.
[10] - OLA select (should be active also in regular mode)
[11] - B interface */
#define REG_PHY_RXTD_REG061_GSM_SW_RESET_MASK          0x00184
#define REG_PHY_RXTD_REG061_GSM_SW_RESET_MASK_MASK     0x0000ffff
#define REG_PHY_RXTD_REG061_GSM_SW_RESET_MASK_SHIFT    0
#define REG_PHY_RXTD_REG061_GSM_SW_RESET_MASK_WIDTH    16

/* PHY_RXTD_REG062_SW_RESET_GENERATE */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "1" resets the sub block. the reg is used when writing to addr 0 for debug mode.
[0]- RSSI.
[2]- Prometh i/f.
[3]- Geortzel. 
[4]- Delta F
[5]- Noise Est.
[6]- Gen Risc.
[7]- Risc Logic.
[8]- Test bus fifo.
[10] - OLA select (should be active also in regular mode)
[11] - B interface */
#define REG_PHY_RXTD_REG062_SW_RESET_GENERATE          0x00188
#define REG_PHY_RXTD_REG062_SW_RESET_GENERATE_MASK     0x0000ffff
#define REG_PHY_RXTD_REG062_SW_RESET_GENERATE_SHIFT    0
#define REG_PHY_RXTD_REG062_SW_RESET_GENERATE_WIDTH    16

/* PHY_RXTD_REG064_IQ_MISMATCH_EQ_CALIB_COEF_0_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 0. */
#define REG_PHY_RXTD_REG064_IQ_MISMATCH_EQ_CALIB_COEF_0_AN0          0x00190
#define REG_PHY_RXTD_REG064_IQ_MISMATCH_EQ_CALIB_COEF_0_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG064_IQ_MISMATCH_EQ_CALIB_COEF_0_AN0_SHIFT    0
#define REG_PHY_RXTD_REG064_IQ_MISMATCH_EQ_CALIB_COEF_0_AN0_WIDTH    10

/* PHY_RXTD_REG065_IQ_MISMATCH_EQ_CALIB_COEF_1_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 1. */
#define REG_PHY_RXTD_REG065_IQ_MISMATCH_EQ_CALIB_COEF_1_AN0          0x00194
#define REG_PHY_RXTD_REG065_IQ_MISMATCH_EQ_CALIB_COEF_1_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG065_IQ_MISMATCH_EQ_CALIB_COEF_1_AN0_SHIFT    0
#define REG_PHY_RXTD_REG065_IQ_MISMATCH_EQ_CALIB_COEF_1_AN0_WIDTH    10

/* PHY_RXTD_REG066_IQ_MISMATCH_EQ_CALIB_COEF_2_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 2. */
#define REG_PHY_RXTD_REG066_IQ_MISMATCH_EQ_CALIB_COEF_2_AN0          0x00198
#define REG_PHY_RXTD_REG066_IQ_MISMATCH_EQ_CALIB_COEF_2_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG066_IQ_MISMATCH_EQ_CALIB_COEF_2_AN0_SHIFT    0
#define REG_PHY_RXTD_REG066_IQ_MISMATCH_EQ_CALIB_COEF_2_AN0_WIDTH    10

/* PHY_RXTD_REG067_IQ_MISMATCH_EQ_CALIB_COEF_3_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 3. */
#define REG_PHY_RXTD_REG067_IQ_MISMATCH_EQ_CALIB_COEF_3_AN0          0x0019C
#define REG_PHY_RXTD_REG067_IQ_MISMATCH_EQ_CALIB_COEF_3_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG067_IQ_MISMATCH_EQ_CALIB_COEF_3_AN0_SHIFT    0
#define REG_PHY_RXTD_REG067_IQ_MISMATCH_EQ_CALIB_COEF_3_AN0_WIDTH    10

/* PHY_RXTD_REG068_IQ_MISMATCH_EQ_CALIB_COEF_4_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 4. */
#define REG_PHY_RXTD_REG068_IQ_MISMATCH_EQ_CALIB_COEF_4_AN0          0x001A0
#define REG_PHY_RXTD_REG068_IQ_MISMATCH_EQ_CALIB_COEF_4_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG068_IQ_MISMATCH_EQ_CALIB_COEF_4_AN0_SHIFT    0
#define REG_PHY_RXTD_REG068_IQ_MISMATCH_EQ_CALIB_COEF_4_AN0_WIDTH    10

/* PHY_RXTD_REG069_IQ_MISMATCH_EQ_CALIB_COEF_5_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 5. */
#define REG_PHY_RXTD_REG069_IQ_MISMATCH_EQ_CALIB_COEF_5_AN0          0x001A4
#define REG_PHY_RXTD_REG069_IQ_MISMATCH_EQ_CALIB_COEF_5_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG069_IQ_MISMATCH_EQ_CALIB_COEF_5_AN0_SHIFT    0
#define REG_PHY_RXTD_REG069_IQ_MISMATCH_EQ_CALIB_COEF_5_AN0_WIDTH    10

/* PHY_RXTD_REG06A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 6. */
#define REG_PHY_RXTD_REG06A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN0          0x001A8
#define REG_PHY_RXTD_REG06A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN0_WIDTH    10

/* PHY_RXTD_REG06B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 7. */
#define REG_PHY_RXTD_REG06B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN0          0x001AC
#define REG_PHY_RXTD_REG06B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN0_WIDTH    10

/* PHY_RXTD_REG06C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 8. */
#define REG_PHY_RXTD_REG06C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN0          0x001B0
#define REG_PHY_RXTD_REG06C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN0_WIDTH    10

/* PHY_RXTD_REG06D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 9. */
#define REG_PHY_RXTD_REG06D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN0          0x001B4
#define REG_PHY_RXTD_REG06D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN0_WIDTH    10

/* PHY_RXTD_REG06E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 10. */
#define REG_PHY_RXTD_REG06E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN0          0x001B8
#define REG_PHY_RXTD_REG06E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN0_WIDTH    10

/* PHY_RXTD_REG06F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 11. */
#define REG_PHY_RXTD_REG06F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN0          0x001BC
#define REG_PHY_RXTD_REG06F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG06F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN0_SHIFT    0
#define REG_PHY_RXTD_REG06F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN0_WIDTH    10

/* PHY_RXTD_REG070_IQ_MISMATCH_EQ_CALIB_COEF_12_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 12. */
#define REG_PHY_RXTD_REG070_IQ_MISMATCH_EQ_CALIB_COEF_12_AN0          0x001C0
#define REG_PHY_RXTD_REG070_IQ_MISMATCH_EQ_CALIB_COEF_12_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG070_IQ_MISMATCH_EQ_CALIB_COEF_12_AN0_SHIFT    0
#define REG_PHY_RXTD_REG070_IQ_MISMATCH_EQ_CALIB_COEF_12_AN0_WIDTH    10

/* PHY_RXTD_REG071_IQ_MISMATCH_EQ_CALIB_COEF_13_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 13. */
#define REG_PHY_RXTD_REG071_IQ_MISMATCH_EQ_CALIB_COEF_13_AN0          0x001C4
#define REG_PHY_RXTD_REG071_IQ_MISMATCH_EQ_CALIB_COEF_13_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG071_IQ_MISMATCH_EQ_CALIB_COEF_13_AN0_SHIFT    0
#define REG_PHY_RXTD_REG071_IQ_MISMATCH_EQ_CALIB_COEF_13_AN0_WIDTH    10

/* PHY_RXTD_REG072_IQ_MISMATCH_EQ_CALIB_COEF_14_AN0 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 14. */
#define REG_PHY_RXTD_REG072_IQ_MISMATCH_EQ_CALIB_COEF_14_AN0          0x001C8
#define REG_PHY_RXTD_REG072_IQ_MISMATCH_EQ_CALIB_COEF_14_AN0_MASK     0x000003ff
#define REG_PHY_RXTD_REG072_IQ_MISMATCH_EQ_CALIB_COEF_14_AN0_SHIFT    0
#define REG_PHY_RXTD_REG072_IQ_MISMATCH_EQ_CALIB_COEF_14_AN0_WIDTH    10

/* PHY_RXTD_REG073_OLA_SAMPLE_PER_WINDOW */
/* ola sample per window */
#define REG_PHY_RXTD_REG073_OLA_SAMPLE_PER_WINDOW          0x001CC
#define REG_PHY_RXTD_REG073_OLA_SAMPLE_PER_WINDOW_MASK     0x000000ff
#define REG_PHY_RXTD_REG073_OLA_SAMPLE_PER_WINDOW_SHIFT    0
#define REG_PHY_RXTD_REG073_OLA_SAMPLE_PER_WINDOW_WIDTH    8

/* PHY_RXTD_REG074_OLA_NUM_OF_WINDOWS */
/* ola number of windows */
#define REG_PHY_RXTD_REG074_OLA_NUM_OF_WINDOWS          0x001D0
#define REG_PHY_RXTD_REG074_OLA_NUM_OF_WINDOWS_MASK     0x0000001f
#define REG_PHY_RXTD_REG074_OLA_NUM_OF_WINDOWS_SHIFT    0
#define REG_PHY_RXTD_REG074_OLA_NUM_OF_WINDOWS_WIDTH    5

/* PHY_RXTD_REG074_OLA_ZERO_INPUT */
/* ola zero input:
00- regular mode
01- Q-part zero
10- I part zero */
#define REG_PHY_RXTD_REG074_OLA_ZERO_INPUT          0x001D0
#define REG_PHY_RXTD_REG074_OLA_ZERO_INPUT_MASK     0x00000300
#define REG_PHY_RXTD_REG074_OLA_ZERO_INPUT_SHIFT    8
#define REG_PHY_RXTD_REG074_OLA_ZERO_INPUT_WIDTH    2

/* PHY_RXTD_REG075_OLA_ROUND */
/* ola round parameter */
#define REG_PHY_RXTD_REG075_OLA_ROUND          0x001D4
#define REG_PHY_RXTD_REG075_OLA_ROUND_MASK     0x00000007
#define REG_PHY_RXTD_REG075_OLA_ROUND_SHIFT    0
#define REG_PHY_RXTD_REG075_OLA_ROUND_WIDTH    3

/* PHY_RXTD_REG076_RF_CAL_MODE */
/* rf calibration mode */
#define REG_PHY_RXTD_REG076_RF_CAL_MODE          0x001D8
#define REG_PHY_RXTD_REG076_RF_CAL_MODE_MASK     0x00000001
#define REG_PHY_RXTD_REG076_RF_CAL_MODE_SHIFT    0
#define REG_PHY_RXTD_REG076_RF_CAL_MODE_WIDTH    1

/* PHY_RXTD_REG076_OLA_START_AN0 */
/* ola_start_an0 pulse */
#define REG_PHY_RXTD_REG076_OLA_START_AN0          0x001D8
#define REG_PHY_RXTD_REG076_OLA_START_AN0_MASK     0x00000010
#define REG_PHY_RXTD_REG076_OLA_START_AN0_SHIFT    4
#define REG_PHY_RXTD_REG076_OLA_START_AN0_WIDTH    1

/* PHY_RXTD_REG076_OLA_START_AN1 */
/* ola_start_an1 pulse  */
#define REG_PHY_RXTD_REG076_OLA_START_AN1          0x001D8
#define REG_PHY_RXTD_REG076_OLA_START_AN1_MASK     0x00000100
#define REG_PHY_RXTD_REG076_OLA_START_AN1_SHIFT    8
#define REG_PHY_RXTD_REG076_OLA_START_AN1_WIDTH    1

/* PHY_RXTD_REG076_OLA_START_AN2 */
/* ola_start_an2 pulse  */
#define REG_PHY_RXTD_REG076_OLA_START_AN2          0x001D8
#define REG_PHY_RXTD_REG076_OLA_START_AN2_MASK     0x00001000
#define REG_PHY_RXTD_REG076_OLA_START_AN2_SHIFT    12
#define REG_PHY_RXTD_REG076_OLA_START_AN2_WIDTH    1

/* PHY_RXTD_REG076_OLA_DONE_AN0 */
/* ola_done_an0 pulse  */
#define REG_PHY_RXTD_REG076_OLA_DONE_AN0          0x001D8
#define REG_PHY_RXTD_REG076_OLA_DONE_AN0_MASK     0x00010000
#define REG_PHY_RXTD_REG076_OLA_DONE_AN0_SHIFT    16
#define REG_PHY_RXTD_REG076_OLA_DONE_AN0_WIDTH    1

/* PHY_RXTD_REG076_OLA_DONE_AN1 */
/* ola_done_an1 pulse  */
#define REG_PHY_RXTD_REG076_OLA_DONE_AN1          0x001D8
#define REG_PHY_RXTD_REG076_OLA_DONE_AN1_MASK     0x00100000
#define REG_PHY_RXTD_REG076_OLA_DONE_AN1_SHIFT    20
#define REG_PHY_RXTD_REG076_OLA_DONE_AN1_WIDTH    1

/* PHY_RXTD_REG076_OLA_DONE_AN2 */
/* ola_done_an2 pulse  */
#define REG_PHY_RXTD_REG076_OLA_DONE_AN2          0x001D8
#define REG_PHY_RXTD_REG076_OLA_DONE_AN2_MASK     0x01000000
#define REG_PHY_RXTD_REG076_OLA_DONE_AN2_SHIFT    24
#define REG_PHY_RXTD_REG076_OLA_DONE_AN2_WIDTH    1

/* PHY_RXTD_REG077_HOST_FIFO_MODE_AN0 */
/* host_fifo_mode */
#define REG_PHY_RXTD_REG077_HOST_FIFO_MODE_AN0          0x001DC
#define REG_PHY_RXTD_REG077_HOST_FIFO_MODE_AN0_MASK     0x00000001
#define REG_PHY_RXTD_REG077_HOST_FIFO_MODE_AN0_SHIFT    0
#define REG_PHY_RXTD_REG077_HOST_FIFO_MODE_AN0_WIDTH    1

/* PHY_RXTD_REG077_FIFO_FILL_START_AN0 */
/* fifo_fill_start */
#define REG_PHY_RXTD_REG077_FIFO_FILL_START_AN0          0x001DC
#define REG_PHY_RXTD_REG077_FIFO_FILL_START_AN0_MASK     0x00000010
#define REG_PHY_RXTD_REG077_FIFO_FILL_START_AN0_SHIFT    4
#define REG_PHY_RXTD_REG077_FIFO_FILL_START_AN0_WIDTH    1

/* PHY_RXTD_REG077_FIFO_FILL_STOP_AN0 */
/* fifo_fill_stop */
#define REG_PHY_RXTD_REG077_FIFO_FILL_STOP_AN0          0x001DC
#define REG_PHY_RXTD_REG077_FIFO_FILL_STOP_AN0_MASK     0x00000100
#define REG_PHY_RXTD_REG077_FIFO_FILL_STOP_AN0_SHIFT    8
#define REG_PHY_RXTD_REG077_FIFO_FILL_STOP_AN0_WIDTH    1

/* PHY_RXTD_REG077_FIFO_FILL_DONE_AN0 */
/* fifo_fill_done */
#define REG_PHY_RXTD_REG077_FIFO_FILL_DONE_AN0          0x001DC
#define REG_PHY_RXTD_REG077_FIFO_FILL_DONE_AN0_MASK     0x00001000
#define REG_PHY_RXTD_REG077_FIFO_FILL_DONE_AN0_SHIFT    12
#define REG_PHY_RXTD_REG077_FIFO_FILL_DONE_AN0_WIDTH    1

/* PHY_RXTD_REG077_FIFO_WR_ADDR_AN0 */
/* fifo 0 write address */
#define REG_PHY_RXTD_REG077_FIFO_WR_ADDR_AN0          0x001DC
#define REG_PHY_RXTD_REG077_FIFO_WR_ADDR_AN0_MASK     0x01ff0000
#define REG_PHY_RXTD_REG077_FIFO_WR_ADDR_AN0_SHIFT    16
#define REG_PHY_RXTD_REG077_FIFO_WR_ADDR_AN0_WIDTH    9

/* PHY_RXTD_REG078_RX_RDY_RISE_DELAY_11A */
/* rx_rdy_rise_delay_11a */
#define REG_PHY_RXTD_REG078_RX_RDY_RISE_DELAY_11A          0x001E0
#define REG_PHY_RXTD_REG078_RX_RDY_RISE_DELAY_11A_MASK     0x00000fff
#define REG_PHY_RXTD_REG078_RX_RDY_RISE_DELAY_11A_SHIFT    0
#define REG_PHY_RXTD_REG078_RX_RDY_RISE_DELAY_11A_WIDTH    12

/* PHY_RXTD_REG079_RX_RDY_RISE_DELAY_11N */
/* rx_rdy_rise_delay_11n */
#define REG_PHY_RXTD_REG079_RX_RDY_RISE_DELAY_11N          0x001E4
#define REG_PHY_RXTD_REG079_RX_RDY_RISE_DELAY_11N_MASK     0x00000fff
#define REG_PHY_RXTD_REG079_RX_RDY_RISE_DELAY_11N_SHIFT    0
#define REG_PHY_RXTD_REG079_RX_RDY_RISE_DELAY_11N_WIDTH    12

/* PHY_RXTD_REG07A_RX_RDY_FALL_DELAY */
/* rx_rdy_fall_delay */
#define REG_PHY_RXTD_REG07A_RX_RDY_FALL_DELAY          0x001E8
#define REG_PHY_RXTD_REG07A_RX_RDY_FALL_DELAY_MASK     0x00000fff
#define REG_PHY_RXTD_REG07A_RX_RDY_FALL_DELAY_SHIFT    0
#define REG_PHY_RXTD_REG07A_RX_RDY_FALL_DELAY_WIDTH    12

/* PHY_RXTD_REG07B_STOP_SIGNAL_TH */
/* stop_signal_th */
#define REG_PHY_RXTD_REG07B_STOP_SIGNAL_TH          0x001EC
#define REG_PHY_RXTD_REG07B_STOP_SIGNAL_TH_MASK     0x00000fff
#define REG_PHY_RXTD_REG07B_STOP_SIGNAL_TH_SHIFT    0
#define REG_PHY_RXTD_REG07B_STOP_SIGNAL_TH_WIDTH    12

/* PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN */
/* td_test_bus_gclk_en  */
#define REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN          0x001FC
#define REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN_MASK     0x00000001
#define REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN_SHIFT    0
#define REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN_WIDTH    1

/* PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN */
/* be_test_bus_gclk_en  */
#define REG_PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN          0x001FC
#define REG_PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN_MASK     0x00000002
#define REG_PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN_SHIFT    1
#define REG_PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN_WIDTH    1

/* PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN */
/* slicer_test_bus_gclk_en  */
#define REG_PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN          0x001FC
#define REG_PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN_MASK     0x00000004
#define REG_PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN_SHIFT    2
#define REG_PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN_WIDTH    1

/* PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN */
/* fd_test_bus_gclk_en  */
#define REG_PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN          0x001FC
#define REG_PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN_MASK     0x00000008
#define REG_PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN_SHIFT    3
#define REG_PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN_WIDTH    1

/* PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN */
/* tx_test_bus_gclk_en  */
#define REG_PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN          0x001FC
#define REG_PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN_MASK     0x00000010
#define REG_PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN_SHIFT    4
#define REG_PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN_WIDTH    1

/* PHY_RXTD_REG7F_SW_BIST_START */
/* sw_bist_start */
#define REG_PHY_RXTD_REG7F_SW_BIST_START          0x001FC
#define REG_PHY_RXTD_REG7F_SW_BIST_START_MASK     0x00000100
#define REG_PHY_RXTD_REG7F_SW_BIST_START_SHIFT    8
#define REG_PHY_RXTD_REG7F_SW_BIST_START_WIDTH    1

/* PHY_RXTD_REG7F_CLEAR_RAM_MODE */
/* clear_ram_mode */
#define REG_PHY_RXTD_REG7F_CLEAR_RAM_MODE          0x001FC
#define REG_PHY_RXTD_REG7F_CLEAR_RAM_MODE_MASK     0x00001000
#define REG_PHY_RXTD_REG7F_CLEAR_RAM_MODE_SHIFT    12
#define REG_PHY_RXTD_REG7F_CLEAR_RAM_MODE_WIDTH    1

/* PHY_RXTD_REG7F_PREPOS_MAC_PHY_SELECT */
/* prepos_mac_phy_select */
#define REG_PHY_RXTD_REG7F_PREPOS_MAC_PHY_SELECT          0x001FC
#define REG_PHY_RXTD_REG7F_PREPOS_MAC_PHY_SELECT_MASK     0x00010000
#define REG_PHY_RXTD_REG7F_PREPOS_MAC_PHY_SELECT_SHIFT    16
#define REG_PHY_RXTD_REG7F_PREPOS_MAC_PHY_SELECT_WIDTH    1

/* PHY_RXTD_REG80_GCLK_BYPASS_EN */
/* gclk bypass - when '1' clocks will be always active */
#define REG_PHY_RXTD_REG80_GCLK_BYPASS_EN          0x00200
#define REG_PHY_RXTD_REG80_GCLK_BYPASS_EN_MASK     0xffffffff
#define REG_PHY_RXTD_REG80_GCLK_BYPASS_EN_SHIFT    0
#define REG_PHY_RXTD_REG80_GCLK_BYPASS_EN_WIDTH    32

/* PHY_RXTD_REG81_TB_FIFO_DIVR */
/* Test Bus FIFO Divide Ratio */
#define REG_PHY_RXTD_REG81_TB_FIFO_DIVR          0x00204
#define REG_PHY_RXTD_REG81_TB_FIFO_DIVR_MASK     0x00000007
#define REG_PHY_RXTD_REG81_TB_FIFO_DIVR_SHIFT    0
#define REG_PHY_RXTD_REG81_TB_FIFO_DIVR_WIDTH    3

/* PHY_RXTD_REG81_TB_FIFO_CLEAR */
/* Test Bus FIFO Clear */
#define REG_PHY_RXTD_REG81_TB_FIFO_CLEAR          0x00204
#define REG_PHY_RXTD_REG81_TB_FIFO_CLEAR_MASK     0x00000010
#define REG_PHY_RXTD_REG81_TB_FIFO_CLEAR_SHIFT    4
#define REG_PHY_RXTD_REG81_TB_FIFO_CLEAR_WIDTH    1

/* PHY_RXTD_REG81_TB_FIFO_LOW_RD_RATE */
/* Test Bus FIFO Rate:
0- use the master rate 80/40
1- master rate is divided by 2
2- maste rate is divided by 3
3- master rate is divided by 4 */
#define REG_PHY_RXTD_REG81_TB_FIFO_LOW_RD_RATE          0x00204
#define REG_PHY_RXTD_REG81_TB_FIFO_LOW_RD_RATE_MASK     0x00000300
#define REG_PHY_RXTD_REG81_TB_FIFO_LOW_RD_RATE_SHIFT    8
#define REG_PHY_RXTD_REG81_TB_FIFO_LOW_RD_RATE_WIDTH    2

/* PHY_RXTD_REG81_TB_FIFO_MID_RD_RATE */
/* Test Bus FIFO Rate:
0- use the master rate 80/40
1- master rate is divided by 2
2- maste rate is divided by 3
3- master rate is divided by 5 */
#define REG_PHY_RXTD_REG81_TB_FIFO_MID_RD_RATE          0x00204
#define REG_PHY_RXTD_REG81_TB_FIFO_MID_RD_RATE_MASK     0x00003000
#define REG_PHY_RXTD_REG81_TB_FIFO_MID_RD_RATE_SHIFT    12
#define REG_PHY_RXTD_REG81_TB_FIFO_MID_RD_RATE_WIDTH    2

/* PHY_RXTD_REG81_TB_FIFO_HIGH_RD_RATE */
/* Test Bus FIFO Rate:
0- use the master rate 80/40
1- master rate is divided by 2
2- maste rate is divided by 3
3- master rate is divided by 6 */
#define REG_PHY_RXTD_REG81_TB_FIFO_HIGH_RD_RATE          0x00204
#define REG_PHY_RXTD_REG81_TB_FIFO_HIGH_RD_RATE_MASK     0x00030000
#define REG_PHY_RXTD_REG81_TB_FIFO_HIGH_RD_RATE_SHIFT    16
#define REG_PHY_RXTD_REG81_TB_FIFO_HIGH_RD_RATE_WIDTH    2

/* PHY_RXTD_REG82_RX_ADC_FIFO_RD_RATE */
/* RX ADC Fifo Read Strobe Rate Control */
#define REG_PHY_RXTD_REG82_RX_ADC_FIFO_RD_RATE          0x00208
#define REG_PHY_RXTD_REG82_RX_ADC_FIFO_RD_RATE_MASK     0x0000000f
#define REG_PHY_RXTD_REG82_RX_ADC_FIFO_RD_RATE_SHIFT    0
#define REG_PHY_RXTD_REG82_RX_ADC_FIFO_RD_RATE_WIDTH    4

/* PHY_RXTD_REG83_ANALOG_LPBK */
/* Analog LoopBack Mode */
#define REG_PHY_RXTD_REG83_ANALOG_LPBK          0x0020C
#define REG_PHY_RXTD_REG83_ANALOG_LPBK_MASK     0x00000001
#define REG_PHY_RXTD_REG83_ANALOG_LPBK_SHIFT    0
#define REG_PHY_RXTD_REG83_ANALOG_LPBK_WIDTH    1

/* PHY_RXTD_REG83_TX0_LPBK_SELECT */
/* Tx0 LoopBack Select */
#define REG_PHY_RXTD_REG83_TX0_LPBK_SELECT          0x0020C
#define REG_PHY_RXTD_REG83_TX0_LPBK_SELECT_MASK     0x00000030
#define REG_PHY_RXTD_REG83_TX0_LPBK_SELECT_SHIFT    4
#define REG_PHY_RXTD_REG83_TX0_LPBK_SELECT_WIDTH    2

/* PHY_RXTD_REG83_TX1_LPBK_SELECT */
/* Tx1 LoopBack Select */
#define REG_PHY_RXTD_REG83_TX1_LPBK_SELECT          0x0020C
#define REG_PHY_RXTD_REG83_TX1_LPBK_SELECT_MASK     0x00000300
#define REG_PHY_RXTD_REG83_TX1_LPBK_SELECT_SHIFT    8
#define REG_PHY_RXTD_REG83_TX1_LPBK_SELECT_WIDTH    2

/* PHY_RXTD_REG83_TX2_LPBK_SELECT */
/* Tx2 LoopBack Select */
#define REG_PHY_RXTD_REG83_TX2_LPBK_SELECT          0x0020C
#define REG_PHY_RXTD_REG83_TX2_LPBK_SELECT_MASK     0x00003000
#define REG_PHY_RXTD_REG83_TX2_LPBK_SELECT_SHIFT    12
#define REG_PHY_RXTD_REG83_TX2_LPBK_SELECT_WIDTH    2

/* PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE */
/* test_fifo_capture_mode */
#define REG_PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE          0x00210
#define REG_PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE_MASK     0x00000001
#define REG_PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE_SHIFT    0
#define REG_PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE_WIDTH    1

/* PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE */
/* test_fifo_cyclic_mode */
#define REG_PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE          0x00210
#define REG_PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE_MASK     0x00000002
#define REG_PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE_SHIFT    1
#define REG_PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE_WIDTH    1

/* PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN */
/* test_fifo_external_trig_en */
#define REG_PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN          0x00210
#define REG_PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN_MASK     0x00000004
#define REG_PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN_SHIFT    2
#define REG_PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN_WIDTH    1

/* PHY_RXTD_REG84_TEST_FIFO_LARGE_MEM_EN */
/* test fifo large mem en
4k ram is enabled all controls registers refers to the 4-k ram such as: bytes in fifo, wr_pointer etc */
#define REG_PHY_RXTD_REG84_TEST_FIFO_LARGE_MEM_EN          0x00210
#define REG_PHY_RXTD_REG84_TEST_FIFO_LARGE_MEM_EN_MASK     0x00000008
#define REG_PHY_RXTD_REG84_TEST_FIFO_LARGE_MEM_EN_SHIFT    3
#define REG_PHY_RXTD_REG84_TEST_FIFO_LARGE_MEM_EN_WIDTH    1

/* PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL */
/* test_bus_low_mux_ctrl
00 -Fifo low = test bus low.
01 -Fifo low = test bus mid.
10 -Fifo low = test bus high */
#define REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL          0x00210
#define REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL_MASK     0x00000030
#define REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL_SHIFT    4
#define REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL_WIDTH    2

/* PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL */
/* test_bus_mid_mux_ctrl
00 -Fifo mid = test bus low.
01 -Fifo mid = test bus mid.
10 -Fifo mid = test bus high */
#define REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL          0x00210
#define REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL_MASK     0x00000300
#define REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL_SHIFT    8
#define REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL_WIDTH    2

/* PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL */
/* test_bus_high_mux_ctrl
00 -Fifo high = test bus low.
01 -Fifo high = test bus mid.
10 -Fifo high = test bus high */
#define REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL          0x00210
#define REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL_MASK     0x00003000
#define REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL_SHIFT    12
#define REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL_WIDTH    2

/* PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_IIR_AN1 */
/* Bypass IIR.  */
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_IIR_AN1          0x00214
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_IIR_AN1_MASK     0x00000001
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_IIR_AN1_SHIFT    0
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_IIR_AN1_WIDTH    1

/* PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_EQ_AN1 */
/* Equalizer bypass. */
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_EQ_AN1          0x00214
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_EQ_AN1_MASK     0x00000002
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_EQ_AN1_SHIFT    1
#define REG_PHY_RXTD_REG085_IQ_MISMATCH_BYPASS_EQ_AN1_WIDTH    1

/* PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_I_AN1 */
/* Dc reject IIR Mu (I) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_I_AN1          0x00218
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_I_AN1_MASK     0x00000003
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_I_AN1_SHIFT    0
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_I_AN1_WIDTH    2

/* PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_Q_AN1 */
/* Dc reject IIR Mu (Q) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_Q_AN1          0x00218
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_Q_AN1_MASK     0x00000030
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_Q_AN1_SHIFT    4
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_IIR_MU_Q_AN1_WIDTH    2

/* PHY_RXTD_REG086_IQ_MISMATCH_EST_MU_AN1 */
/* Shift round size: 2-10bit;
1-9bit; 0-8bit; */
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_MU_AN1          0x00218
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_MU_AN1_MASK     0x00300000
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_MU_AN1_SHIFT    20
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_MU_AN1_WIDTH    2

/* PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_I_SUM_AN1 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_I_SUM_AN1          0x00218
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_I_SUM_AN1_MASK     0x01000000
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_I_SUM_AN1_SHIFT    24
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_I_SUM_AN1_WIDTH    1

/* PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN1 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN1          0x00218
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN1_MASK     0x10000000
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN1_SHIFT    28
#define REG_PHY_RXTD_REG086_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN1_WIDTH    1

/* PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_I_AN1 */
/* Equalizer I pipe length;
0- 5FF delay;1- 7FF delay;
2-9 FF delay.4- 11FF delay;5- 13FF delay;6-15 FF delay; */
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_I_AN1          0x0021C
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_I_AN1_MASK     0x00000007
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_I_AN1_SHIFT    0
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_I_AN1_WIDTH    3

/* PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_Q_AN1 */
/* Equalizer Q pipe length;
0- 3FF delay;1- 4FF delay;
2-5 FF delay.3- 6FF delay;4- 7FF delay;5- 8FF delay; */
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_Q_AN1          0x0021C
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_Q_AN1_MASK     0x00000070
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_Q_AN1_SHIFT    4
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_LENGTH_Q_AN1_WIDTH    3

/* PHY_RXTD_REG087_IQ_MISMATCH_EQ_RATE_MODE_AN1 */
/* Equalizer Q rate mode;
0- 80Mhz;1- 40Mhz; */
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_RATE_MODE_AN1          0x0021C
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_RATE_MODE_AN1_MASK     0x00000100
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_RATE_MODE_AN1_SHIFT    8
#define REG_PHY_RXTD_REG087_IQ_MISMATCH_EQ_RATE_MODE_AN1_WIDTH    1

/* PHY_RXTD_REG08C_IQ_MISMATCH_EST_ACC_COUNTER_AN1 */
/* Time of accumulate of the estimators. */
#define REG_PHY_RXTD_REG08C_IQ_MISMATCH_EST_ACC_COUNTER_AN1          0x00230
#define REG_PHY_RXTD_REG08C_IQ_MISMATCH_EST_ACC_COUNTER_AN1_MASK     0x00ffffff
#define REG_PHY_RXTD_REG08C_IQ_MISMATCH_EST_ACC_COUNTER_AN1_SHIFT    0
#define REG_PHY_RXTD_REG08C_IQ_MISMATCH_EST_ACC_COUNTER_AN1_WIDTH    24

/* PHY_RXTD_REG08D_IQ_MISMATCH_EST_START_WORK_AN1 */
/* Start estimators. */
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_START_WORK_AN1          0x00234
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_START_WORK_AN1_MASK     0x00000010
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_START_WORK_AN1_SHIFT    4
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_START_WORK_AN1_WIDTH    1

/* PHY_RXTD_REG08D_IQ_MISMATCH_EST_RESET_REGS_AN1 */
/* Reset accumulators values. */
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_RESET_REGS_AN1          0x00234
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_RESET_REGS_AN1_MASK     0x00000100
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_RESET_REGS_AN1_SHIFT    8
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_RESET_REGS_AN1_WIDTH    1

/* PHY_RXTD_REG08D_IQ_MISMATCH_EST_VALID_IQ_AN1 */
/* Rx TD IQ Mismatch Est valid */
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_VALID_IQ_AN1          0x00234
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_VALID_IQ_AN1_MASK     0x00001000
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_VALID_IQ_AN1_SHIFT    12
#define REG_PHY_RXTD_REG08D_IQ_MISMATCH_EST_VALID_IQ_AN1_WIDTH    1

/* PHY_RXTD_REG08F_IQ_MISMATCH_EST_REG_II_AN1 */
/* Estimation Accumulator II Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG08F_IQ_MISMATCH_EST_REG_II_AN1          0x0023C
#define REG_PHY_RXTD_REG08F_IQ_MISMATCH_EST_REG_II_AN1_MASK     0xffffffff
#define REG_PHY_RXTD_REG08F_IQ_MISMATCH_EST_REG_II_AN1_SHIFT    0
#define REG_PHY_RXTD_REG08F_IQ_MISMATCH_EST_REG_II_AN1_WIDTH    32

/* PHY_RXTD_REG091_IQ_MISMATCH_EST_REG_QQ_AN1 */
/* Estimation Accumulator QQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG091_IQ_MISMATCH_EST_REG_QQ_AN1          0x00244
#define REG_PHY_RXTD_REG091_IQ_MISMATCH_EST_REG_QQ_AN1_MASK     0xffffffff
#define REG_PHY_RXTD_REG091_IQ_MISMATCH_EST_REG_QQ_AN1_SHIFT    0
#define REG_PHY_RXTD_REG091_IQ_MISMATCH_EST_REG_QQ_AN1_WIDTH    32

/* PHY_RXTD_REG093_IQ_MISMATCH_EST_REG_IQ_AN1 */
/* Estimation Accumulator IQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG093_IQ_MISMATCH_EST_REG_IQ_AN1          0x0024C
#define REG_PHY_RXTD_REG093_IQ_MISMATCH_EST_REG_IQ_AN1_MASK     0xffffffff
#define REG_PHY_RXTD_REG093_IQ_MISMATCH_EST_REG_IQ_AN1_SHIFT    0
#define REG_PHY_RXTD_REG093_IQ_MISMATCH_EST_REG_IQ_AN1_WIDTH    32

/* PHY_RXTD_REG0E4_IQ_MISMATCH_EQ_CALIB_COEF_0_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 0. */
#define REG_PHY_RXTD_REG0E4_IQ_MISMATCH_EQ_CALIB_COEF_0_AN1          0x00390
#define REG_PHY_RXTD_REG0E4_IQ_MISMATCH_EQ_CALIB_COEF_0_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E4_IQ_MISMATCH_EQ_CALIB_COEF_0_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E4_IQ_MISMATCH_EQ_CALIB_COEF_0_AN1_WIDTH    10

/* PHY_RXTD_REG0E5_IQ_MISMATCH_EQ_CALIB_COEF_1_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 1. */
#define REG_PHY_RXTD_REG0E5_IQ_MISMATCH_EQ_CALIB_COEF_1_AN1          0x00394
#define REG_PHY_RXTD_REG0E5_IQ_MISMATCH_EQ_CALIB_COEF_1_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E5_IQ_MISMATCH_EQ_CALIB_COEF_1_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E5_IQ_MISMATCH_EQ_CALIB_COEF_1_AN1_WIDTH    10

/* PHY_RXTD_REG0E6_IQ_MISMATCH_EQ_CALIB_COEF_2_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 2. */
#define REG_PHY_RXTD_REG0E6_IQ_MISMATCH_EQ_CALIB_COEF_2_AN1          0x00398
#define REG_PHY_RXTD_REG0E6_IQ_MISMATCH_EQ_CALIB_COEF_2_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E6_IQ_MISMATCH_EQ_CALIB_COEF_2_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E6_IQ_MISMATCH_EQ_CALIB_COEF_2_AN1_WIDTH    10

/* PHY_RXTD_REG0E7_IQ_MISMATCH_EQ_CALIB_COEF_3_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 3. */
#define REG_PHY_RXTD_REG0E7_IQ_MISMATCH_EQ_CALIB_COEF_3_AN1          0x0039C
#define REG_PHY_RXTD_REG0E7_IQ_MISMATCH_EQ_CALIB_COEF_3_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E7_IQ_MISMATCH_EQ_CALIB_COEF_3_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E7_IQ_MISMATCH_EQ_CALIB_COEF_3_AN1_WIDTH    10

/* PHY_RXTD_REG0E8_IQ_MISMATCH_EQ_CALIB_COEF_4_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 4. */
#define REG_PHY_RXTD_REG0E8_IQ_MISMATCH_EQ_CALIB_COEF_4_AN1          0x003A0
#define REG_PHY_RXTD_REG0E8_IQ_MISMATCH_EQ_CALIB_COEF_4_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E8_IQ_MISMATCH_EQ_CALIB_COEF_4_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E8_IQ_MISMATCH_EQ_CALIB_COEF_4_AN1_WIDTH    10

/* PHY_RXTD_REG0E9_IQ_MISMATCH_EQ_CALIB_COEF_5_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 5. */
#define REG_PHY_RXTD_REG0E9_IQ_MISMATCH_EQ_CALIB_COEF_5_AN1          0x003A4
#define REG_PHY_RXTD_REG0E9_IQ_MISMATCH_EQ_CALIB_COEF_5_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0E9_IQ_MISMATCH_EQ_CALIB_COEF_5_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0E9_IQ_MISMATCH_EQ_CALIB_COEF_5_AN1_WIDTH    10

/* PHY_RXTD_REG0EA_IQ_MISMATCH_EQ_CALIB_COEF_6_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 6. */
#define REG_PHY_RXTD_REG0EA_IQ_MISMATCH_EQ_CALIB_COEF_6_AN1          0x003A8
#define REG_PHY_RXTD_REG0EA_IQ_MISMATCH_EQ_CALIB_COEF_6_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0EA_IQ_MISMATCH_EQ_CALIB_COEF_6_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0EA_IQ_MISMATCH_EQ_CALIB_COEF_6_AN1_WIDTH    10

/* PHY_RXTD_REG0EB_IQ_MISMATCH_EQ_CALIB_COEF_7_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 7. */
#define REG_PHY_RXTD_REG0EB_IQ_MISMATCH_EQ_CALIB_COEF_7_AN1          0x003AC
#define REG_PHY_RXTD_REG0EB_IQ_MISMATCH_EQ_CALIB_COEF_7_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0EB_IQ_MISMATCH_EQ_CALIB_COEF_7_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0EB_IQ_MISMATCH_EQ_CALIB_COEF_7_AN1_WIDTH    10

/* PHY_RXTD_REG0EC_IQ_MISMATCH_EQ_CALIB_COEF_8_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 8. */
#define REG_PHY_RXTD_REG0EC_IQ_MISMATCH_EQ_CALIB_COEF_8_AN1          0x003B0
#define REG_PHY_RXTD_REG0EC_IQ_MISMATCH_EQ_CALIB_COEF_8_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0EC_IQ_MISMATCH_EQ_CALIB_COEF_8_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0EC_IQ_MISMATCH_EQ_CALIB_COEF_8_AN1_WIDTH    10

/* PHY_RXTD_REG0ED_IQ_MISMATCH_EQ_CALIB_COEF_9_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 9. */
#define REG_PHY_RXTD_REG0ED_IQ_MISMATCH_EQ_CALIB_COEF_9_AN1          0x003B4
#define REG_PHY_RXTD_REG0ED_IQ_MISMATCH_EQ_CALIB_COEF_9_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0ED_IQ_MISMATCH_EQ_CALIB_COEF_9_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0ED_IQ_MISMATCH_EQ_CALIB_COEF_9_AN1_WIDTH    10

/* PHY_RXTD_REG0EE_IQ_MISMATCH_EQ_CALIB_COEF_10_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 10. */
#define REG_PHY_RXTD_REG0EE_IQ_MISMATCH_EQ_CALIB_COEF_10_AN1          0x003B8
#define REG_PHY_RXTD_REG0EE_IQ_MISMATCH_EQ_CALIB_COEF_10_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0EE_IQ_MISMATCH_EQ_CALIB_COEF_10_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0EE_IQ_MISMATCH_EQ_CALIB_COEF_10_AN1_WIDTH    10

/* PHY_RXTD_REG0EF_IQ_MISMATCH_EQ_CALIB_COEF_11_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 11. */
#define REG_PHY_RXTD_REG0EF_IQ_MISMATCH_EQ_CALIB_COEF_11_AN1          0x003BC
#define REG_PHY_RXTD_REG0EF_IQ_MISMATCH_EQ_CALIB_COEF_11_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0EF_IQ_MISMATCH_EQ_CALIB_COEF_11_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0EF_IQ_MISMATCH_EQ_CALIB_COEF_11_AN1_WIDTH    10

/* PHY_RXTD_REG0F0_IQ_MISMATCH_EQ_CALIB_COEF_12_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 12. */
#define REG_PHY_RXTD_REG0F0_IQ_MISMATCH_EQ_CALIB_COEF_12_AN1          0x003C0
#define REG_PHY_RXTD_REG0F0_IQ_MISMATCH_EQ_CALIB_COEF_12_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0F0_IQ_MISMATCH_EQ_CALIB_COEF_12_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0F0_IQ_MISMATCH_EQ_CALIB_COEF_12_AN1_WIDTH    10

/* PHY_RXTD_REG0F1_IQ_MISMATCH_EQ_CALIB_COEF_13_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 13. */
#define REG_PHY_RXTD_REG0F1_IQ_MISMATCH_EQ_CALIB_COEF_13_AN1          0x003C4
#define REG_PHY_RXTD_REG0F1_IQ_MISMATCH_EQ_CALIB_COEF_13_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0F1_IQ_MISMATCH_EQ_CALIB_COEF_13_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0F1_IQ_MISMATCH_EQ_CALIB_COEF_13_AN1_WIDTH    10

/* PHY_RXTD_REG0F2_IQ_MISMATCH_EQ_CALIB_COEF_14_AN1 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 14. */
#define REG_PHY_RXTD_REG0F2_IQ_MISMATCH_EQ_CALIB_COEF_14_AN1          0x003C8
#define REG_PHY_RXTD_REG0F2_IQ_MISMATCH_EQ_CALIB_COEF_14_AN1_MASK     0x000003ff
#define REG_PHY_RXTD_REG0F2_IQ_MISMATCH_EQ_CALIB_COEF_14_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0F2_IQ_MISMATCH_EQ_CALIB_COEF_14_AN1_WIDTH    10

/* PHY_RXTD_REG0F3_HOST_FIFO_MODE_AN1 */
/* host_fifo_mode */
#define REG_PHY_RXTD_REG0F3_HOST_FIFO_MODE_AN1          0x003CC
#define REG_PHY_RXTD_REG0F3_HOST_FIFO_MODE_AN1_MASK     0x00000001
#define REG_PHY_RXTD_REG0F3_HOST_FIFO_MODE_AN1_SHIFT    0
#define REG_PHY_RXTD_REG0F3_HOST_FIFO_MODE_AN1_WIDTH    1

/* PHY_RXTD_REG0F3_FIFO_FILL_START_AN1 */
/* fifo_fill_start */
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_START_AN1          0x003CC
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_START_AN1_MASK     0x00000010
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_START_AN1_SHIFT    4
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_START_AN1_WIDTH    1

/* PHY_RXTD_REG0F3_FIFO_FILL_STOP_AN1 */
/* fifo_fill_stop */
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_STOP_AN1          0x003CC
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_STOP_AN1_MASK     0x00000100
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_STOP_AN1_SHIFT    8
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_STOP_AN1_WIDTH    1

/* PHY_RXTD_REG0F3_FIFO_FILL_DONE_AN1 */
/* fifo_fill_done */
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_DONE_AN1          0x003CC
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_DONE_AN1_MASK     0x00001000
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_DONE_AN1_SHIFT    12
#define REG_PHY_RXTD_REG0F3_FIFO_FILL_DONE_AN1_WIDTH    1

/* PHY_RXTD_REG0F3_FIFO_WR_ADDR_AN1 */
/* fifo 1 write address */
#define REG_PHY_RXTD_REG0F3_FIFO_WR_ADDR_AN1          0x003CC
#define REG_PHY_RXTD_REG0F3_FIFO_WR_ADDR_AN1_MASK     0x01ff0000
#define REG_PHY_RXTD_REG0F3_FIFO_WR_ADDR_AN1_SHIFT    16
#define REG_PHY_RXTD_REG0F3_FIFO_WR_ADDR_AN1_WIDTH    9

/* PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_IIR_AN2 */
/* Bypass IIR.  */
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_IIR_AN2          0x00414
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_IIR_AN2_MASK     0x00000001
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_IIR_AN2_SHIFT    0
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_IIR_AN2_WIDTH    1

/* PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_EQ_AN2 */
/* Equalizer bypass. */
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_EQ_AN2          0x00414
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_EQ_AN2_MASK     0x00000002
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_EQ_AN2_SHIFT    1
#define REG_PHY_RXTD_REG105_IQ_MISMATCH_BYPASS_EQ_AN2_WIDTH    1

/* PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_I_AN2 */
/* Dc reject IIR Mu (I) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_I_AN2          0x00418
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_I_AN2_MASK     0x00000003
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_I_AN2_SHIFT    0
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_I_AN2_WIDTH    2

/* PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_Q_AN2 */
/* Dc reject IIR Mu (Q) Value.
Shift round size of I:
2-11 bit; 1-10 bit; 0 -9bit. */
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_Q_AN2          0x00418
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_Q_AN2_MASK     0x00000030
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_Q_AN2_SHIFT    4
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_IIR_MU_Q_AN2_WIDTH    2

/* PHY_RXTD_REG106_IQ_MISMATCH_EST_MU_AN2 */
/* Shift round size: 2-10bit;
1-9bit; 0-8bit; */
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_MU_AN2          0x00418
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_MU_AN2_MASK     0x00300000
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_MU_AN2_SHIFT    20
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_MU_AN2_WIDTH    2

/* PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_I_SUM_AN2 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_I_SUM_AN2          0x00418
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_I_SUM_AN2_MASK     0x01000000
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_I_SUM_AN2_SHIFT    24
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_I_SUM_AN2_WIDTH    1

/* PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN2 */
/* 0 - sqr ; 1 sqrt */
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN2          0x00418
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN2_MASK     0x10000000
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN2_SHIFT    28
#define REG_PHY_RXTD_REG106_IQ_MISMATCH_EST_REGULAR_Q_SUM_AN2_WIDTH    1

/* PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_I_AN2 */
/* Equalizer I pipe length;
0- 5FF delay;1- 7FF delay;
2-9 FF delay.4- 11FF delay;5- 13FF delay;6-15 FF delay; */
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_I_AN2          0x0041C
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_I_AN2_MASK     0x00000007
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_I_AN2_SHIFT    0
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_I_AN2_WIDTH    3

/* PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_Q_AN2 */
/* Equalizer Q pipe length;
0- 3FF delay;1- 4FF delay;
2-5 FF delay.3- 6FF delay;4- 7FF delay;5- 8FF delay; */
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_Q_AN2          0x0041C
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_Q_AN2_MASK     0x00000070
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_Q_AN2_SHIFT    4
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_LENGTH_Q_AN2_WIDTH    3

/* PHY_RXTD_REG107_IQ_MISMATCH_EQ_RATE_MODE_AN2 */
/* Equalizer Q rate mode;
0- 80Mhz;1- 40Mhz; */
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_RATE_MODE_AN2          0x0041C
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_RATE_MODE_AN2_MASK     0x00000100
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_RATE_MODE_AN2_SHIFT    8
#define REG_PHY_RXTD_REG107_IQ_MISMATCH_EQ_RATE_MODE_AN2_WIDTH    1

/* PHY_RXTD_REG10C_IQ_MISMATCH_EST_ACC_COUNTER_AN2 */
/* Time of accumulate of the estimators. */
#define REG_PHY_RXTD_REG10C_IQ_MISMATCH_EST_ACC_COUNTER_AN2          0x00430
#define REG_PHY_RXTD_REG10C_IQ_MISMATCH_EST_ACC_COUNTER_AN2_MASK     0x00ffffff
#define REG_PHY_RXTD_REG10C_IQ_MISMATCH_EST_ACC_COUNTER_AN2_SHIFT    0
#define REG_PHY_RXTD_REG10C_IQ_MISMATCH_EST_ACC_COUNTER_AN2_WIDTH    24

/* PHY_RXTD_REG10D_IQ_MISMATCH_EST_START_WORK_AN2 */
/* Start estimators. */
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_START_WORK_AN2          0x00434
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_START_WORK_AN2_MASK     0x00000010
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_START_WORK_AN2_SHIFT    4
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_START_WORK_AN2_WIDTH    1

/* PHY_RXTD_REG10D_IQ_MISMATCH_EST_RESET_REGS_AN2 */
/* Reset accumulators values. */
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_RESET_REGS_AN2          0x00434
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_RESET_REGS_AN2_MASK     0x00000100
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_RESET_REGS_AN2_SHIFT    8
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_RESET_REGS_AN2_WIDTH    1

/* PHY_RXTD_REG10D_IQ_MISMATCH_EST_VALID_IQ_AN2 */
/* Rx TD IQ Mismatch Est valid */
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_VALID_IQ_AN2          0x00434
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_VALID_IQ_AN2_MASK     0x00001000
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_VALID_IQ_AN2_SHIFT    12
#define REG_PHY_RXTD_REG10D_IQ_MISMATCH_EST_VALID_IQ_AN2_WIDTH    1

/* PHY_RXTD_REG10F_IQ_MISMATCH_EST_REG_II_AN2 */
/* Estimation Accumulator II Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG10F_IQ_MISMATCH_EST_REG_II_AN2          0x0043C
#define REG_PHY_RXTD_REG10F_IQ_MISMATCH_EST_REG_II_AN2_MASK     0xffffffff
#define REG_PHY_RXTD_REG10F_IQ_MISMATCH_EST_REG_II_AN2_SHIFT    0
#define REG_PHY_RXTD_REG10F_IQ_MISMATCH_EST_REG_II_AN2_WIDTH    32

/* PHY_RXTD_REG111_IQ_MISMATCH_EST_REG_QQ_AN2 */
/* Estimation Accumulator QQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG111_IQ_MISMATCH_EST_REG_QQ_AN2          0x00444
#define REG_PHY_RXTD_REG111_IQ_MISMATCH_EST_REG_QQ_AN2_MASK     0xffffffff
#define REG_PHY_RXTD_REG111_IQ_MISMATCH_EST_REG_QQ_AN2_SHIFT    0
#define REG_PHY_RXTD_REG111_IQ_MISMATCH_EST_REG_QQ_AN2_WIDTH    32

/* PHY_RXTD_REG113_IQ_MISMATCH_EST_REG_IQ_AN2 */
/* Estimation Accumulator IQ Low 20 bits value
[19:0]. */
#define REG_PHY_RXTD_REG113_IQ_MISMATCH_EST_REG_IQ_AN2          0x0044C
#define REG_PHY_RXTD_REG113_IQ_MISMATCH_EST_REG_IQ_AN2_MASK     0xffffffff
#define REG_PHY_RXTD_REG113_IQ_MISMATCH_EST_REG_IQ_AN2_SHIFT    0
#define REG_PHY_RXTD_REG113_IQ_MISMATCH_EST_REG_IQ_AN2_WIDTH    32

/* PHY_RXTD_REG164_IQ_MISMATCH_EQ_CALIB_COEF_0_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 0. */
#define REG_PHY_RXTD_REG164_IQ_MISMATCH_EQ_CALIB_COEF_0_AN2          0x00590
#define REG_PHY_RXTD_REG164_IQ_MISMATCH_EQ_CALIB_COEF_0_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG164_IQ_MISMATCH_EQ_CALIB_COEF_0_AN2_SHIFT    0
#define REG_PHY_RXTD_REG164_IQ_MISMATCH_EQ_CALIB_COEF_0_AN2_WIDTH    10

/* PHY_RXTD_REG165_IQ_MISMATCH_EQ_CALIB_COEF_1_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 1. */
#define REG_PHY_RXTD_REG165_IQ_MISMATCH_EQ_CALIB_COEF_1_AN2          0x00594
#define REG_PHY_RXTD_REG165_IQ_MISMATCH_EQ_CALIB_COEF_1_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG165_IQ_MISMATCH_EQ_CALIB_COEF_1_AN2_SHIFT    0
#define REG_PHY_RXTD_REG165_IQ_MISMATCH_EQ_CALIB_COEF_1_AN2_WIDTH    10

/* PHY_RXTD_REG166_IQ_MISMATCH_EQ_CALIB_COEF_2_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 2. */
#define REG_PHY_RXTD_REG166_IQ_MISMATCH_EQ_CALIB_COEF_2_AN2          0x00598
#define REG_PHY_RXTD_REG166_IQ_MISMATCH_EQ_CALIB_COEF_2_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG166_IQ_MISMATCH_EQ_CALIB_COEF_2_AN2_SHIFT    0
#define REG_PHY_RXTD_REG166_IQ_MISMATCH_EQ_CALIB_COEF_2_AN2_WIDTH    10

/* PHY_RXTD_REG167_IQ_MISMATCH_EQ_CALIB_COEF_3_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 3. */
#define REG_PHY_RXTD_REG167_IQ_MISMATCH_EQ_CALIB_COEF_3_AN2          0x0059C
#define REG_PHY_RXTD_REG167_IQ_MISMATCH_EQ_CALIB_COEF_3_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG167_IQ_MISMATCH_EQ_CALIB_COEF_3_AN2_SHIFT    0
#define REG_PHY_RXTD_REG167_IQ_MISMATCH_EQ_CALIB_COEF_3_AN2_WIDTH    10

/* PHY_RXTD_REG168_IQ_MISMATCH_EQ_CALIB_COEF_4_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 4. */
#define REG_PHY_RXTD_REG168_IQ_MISMATCH_EQ_CALIB_COEF_4_AN2          0x005A0
#define REG_PHY_RXTD_REG168_IQ_MISMATCH_EQ_CALIB_COEF_4_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG168_IQ_MISMATCH_EQ_CALIB_COEF_4_AN2_SHIFT    0
#define REG_PHY_RXTD_REG168_IQ_MISMATCH_EQ_CALIB_COEF_4_AN2_WIDTH    10

/* PHY_RXTD_REG169_IQ_MISMATCH_EQ_CALIB_COEF_5_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 5. */
#define REG_PHY_RXTD_REG169_IQ_MISMATCH_EQ_CALIB_COEF_5_AN2          0x005A4
#define REG_PHY_RXTD_REG169_IQ_MISMATCH_EQ_CALIB_COEF_5_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG169_IQ_MISMATCH_EQ_CALIB_COEF_5_AN2_SHIFT    0
#define REG_PHY_RXTD_REG169_IQ_MISMATCH_EQ_CALIB_COEF_5_AN2_WIDTH    10

/* PHY_RXTD_REG16A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 6. */
#define REG_PHY_RXTD_REG16A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN2          0x005A8
#define REG_PHY_RXTD_REG16A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16A_IQ_MISMATCH_EQ_CALIB_COEF_6_AN2_WIDTH    10

/* PHY_RXTD_REG16B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 7. */
#define REG_PHY_RXTD_REG16B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN2          0x005AC
#define REG_PHY_RXTD_REG16B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16B_IQ_MISMATCH_EQ_CALIB_COEF_7_AN2_WIDTH    10

/* PHY_RXTD_REG16C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 8. */
#define REG_PHY_RXTD_REG16C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN2          0x005B0
#define REG_PHY_RXTD_REG16C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16C_IQ_MISMATCH_EQ_CALIB_COEF_8_AN2_WIDTH    10

/* PHY_RXTD_REG16D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 9. */
#define REG_PHY_RXTD_REG16D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN2          0x005B4
#define REG_PHY_RXTD_REG16D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16D_IQ_MISMATCH_EQ_CALIB_COEF_9_AN2_WIDTH    10

/* PHY_RXTD_REG16E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 10. */
#define REG_PHY_RXTD_REG16E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN2          0x005B8
#define REG_PHY_RXTD_REG16E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16E_IQ_MISMATCH_EQ_CALIB_COEF_10_AN2_WIDTH    10

/* PHY_RXTD_REG16F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 11. */
#define REG_PHY_RXTD_REG16F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN2          0x005BC
#define REG_PHY_RXTD_REG16F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG16F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN2_SHIFT    0
#define REG_PHY_RXTD_REG16F_IQ_MISMATCH_EQ_CALIB_COEF_11_AN2_WIDTH    10

/* PHY_RXTD_REG170_IQ_MISMATCH_EQ_CALIB_COEF_12_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 12. */
#define REG_PHY_RXTD_REG170_IQ_MISMATCH_EQ_CALIB_COEF_12_AN2          0x005C0
#define REG_PHY_RXTD_REG170_IQ_MISMATCH_EQ_CALIB_COEF_12_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG170_IQ_MISMATCH_EQ_CALIB_COEF_12_AN2_SHIFT    0
#define REG_PHY_RXTD_REG170_IQ_MISMATCH_EQ_CALIB_COEF_12_AN2_WIDTH    10

/* PHY_RXTD_REG171_IQ_MISMATCH_EQ_CALIB_COEF_13_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 13. */
#define REG_PHY_RXTD_REG171_IQ_MISMATCH_EQ_CALIB_COEF_13_AN2          0x005C4
#define REG_PHY_RXTD_REG171_IQ_MISMATCH_EQ_CALIB_COEF_13_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG171_IQ_MISMATCH_EQ_CALIB_COEF_13_AN2_SHIFT    0
#define REG_PHY_RXTD_REG171_IQ_MISMATCH_EQ_CALIB_COEF_13_AN2_WIDTH    10

/* PHY_RXTD_REG172_IQ_MISMATCH_EQ_CALIB_COEF_14_AN2 */
/* IQ Mismatch Equalizer Calibration Coefficient Num 14. */
#define REG_PHY_RXTD_REG172_IQ_MISMATCH_EQ_CALIB_COEF_14_AN2          0x005C8
#define REG_PHY_RXTD_REG172_IQ_MISMATCH_EQ_CALIB_COEF_14_AN2_MASK     0x000003ff
#define REG_PHY_RXTD_REG172_IQ_MISMATCH_EQ_CALIB_COEF_14_AN2_SHIFT    0
#define REG_PHY_RXTD_REG172_IQ_MISMATCH_EQ_CALIB_COEF_14_AN2_WIDTH    10

/* PHY_RXTD_REG173_HOST_FIFO_MODE_AN2 */
/* host_fifo_mode */
#define REG_PHY_RXTD_REG173_HOST_FIFO_MODE_AN2          0x005CC
#define REG_PHY_RXTD_REG173_HOST_FIFO_MODE_AN2_MASK     0x00000001
#define REG_PHY_RXTD_REG173_HOST_FIFO_MODE_AN2_SHIFT    0
#define REG_PHY_RXTD_REG173_HOST_FIFO_MODE_AN2_WIDTH    1

/* PHY_RXTD_REG173_FIFO_FILL_START_AN2 */
/* fifo_fill_start */
#define REG_PHY_RXTD_REG173_FIFO_FILL_START_AN2          0x005CC
#define REG_PHY_RXTD_REG173_FIFO_FILL_START_AN2_MASK     0x00000010
#define REG_PHY_RXTD_REG173_FIFO_FILL_START_AN2_SHIFT    4
#define REG_PHY_RXTD_REG173_FIFO_FILL_START_AN2_WIDTH    1

/* PHY_RXTD_REG173_FIFO_FILL_STOP_AN2 */
/* fifo_fill_stop */
#define REG_PHY_RXTD_REG173_FIFO_FILL_STOP_AN2          0x005CC
#define REG_PHY_RXTD_REG173_FIFO_FILL_STOP_AN2_MASK     0x00000100
#define REG_PHY_RXTD_REG173_FIFO_FILL_STOP_AN2_SHIFT    8
#define REG_PHY_RXTD_REG173_FIFO_FILL_STOP_AN2_WIDTH    1

/* PHY_RXTD_REG173_FIFO_FILL_DONE_AN2 */
/* fifo_fill_done */
#define REG_PHY_RXTD_REG173_FIFO_FILL_DONE_AN2          0x005CC
#define REG_PHY_RXTD_REG173_FIFO_FILL_DONE_AN2_MASK     0x00001000
#define REG_PHY_RXTD_REG173_FIFO_FILL_DONE_AN2_SHIFT    12
#define REG_PHY_RXTD_REG173_FIFO_FILL_DONE_AN2_WIDTH    1

/* PHY_RXTD_REG173_FIFO_WR_ADDR_AN2 */
/* fifo 2 write address */
#define REG_PHY_RXTD_REG173_FIFO_WR_ADDR_AN2          0x005CC
#define REG_PHY_RXTD_REG173_FIFO_WR_ADDR_AN2_MASK     0x01ff0000
#define REG_PHY_RXTD_REG173_FIFO_WR_ADDR_AN2_SHIFT    16
#define REG_PHY_RXTD_REG173_FIFO_WR_ADDR_AN2_WIDTH    9

/* PHY_RXTD_REG174_SPARE_GATES_GCLK_BYPASS */
/* spare_gates_gclk_bypass */
#define REG_PHY_RXTD_REG174_SPARE_GATES_GCLK_BYPASS          0x005D0
#define REG_PHY_RXTD_REG174_SPARE_GATES_GCLK_BYPASS_MASK     0x0003ffff
#define REG_PHY_RXTD_REG174_SPARE_GATES_GCLK_BYPASS_SHIFT    0
#define REG_PHY_RXTD_REG174_SPARE_GATES_GCLK_BYPASS_WIDTH    18

/* PHY_RXTD_REG175_GEN_RISC_SRAM_RM */
/* gen_risc_sram_rm */
#define REG_PHY_RXTD_REG175_GEN_RISC_SRAM_RM          0x005D4
#define REG_PHY_RXTD_REG175_GEN_RISC_SRAM_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG175_GEN_RISC_SRAM_RM_SHIFT    0
#define REG_PHY_RXTD_REG175_GEN_RISC_SRAM_RM_WIDTH    3

/* PHY_RXTD_REG175_GEN_RISC_IRAM_RM */
/* gen_risc_iram_rm */
#define REG_PHY_RXTD_REG175_GEN_RISC_IRAM_RM          0x005D4
#define REG_PHY_RXTD_REG175_GEN_RISC_IRAM_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG175_GEN_RISC_IRAM_RM_SHIFT    4
#define REG_PHY_RXTD_REG175_GEN_RISC_IRAM_RM_WIDTH    3

/* PHY_RXTD_REG175_TEST_BUS_FIFO_LOW_RM */
/* test_bus_fifo_low_rm */
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_LOW_RM          0x005D4
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_LOW_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_LOW_RM_SHIFT    8
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_LOW_RM_WIDTH    3

/* PHY_RXTD_REG175_TEST_BUS_FIFO_MID_RM */
/* test_bus_fifo_mid_rm */
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_MID_RM          0x005D4
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_MID_RM_MASK     0x00007000
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_MID_RM_SHIFT    12
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_MID_RM_WIDTH    3

/* PHY_RXTD_REG175_TEST_BUS_FIFO_HIGH_RM */
/* test_bus_fifo_high_rm */
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_HIGH_RM          0x005D4
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_HIGH_RM_MASK     0x00070000
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_HIGH_RM_SHIFT    16
#define REG_PHY_RXTD_REG175_TEST_BUS_FIFO_HIGH_RM_WIDTH    3

/* PHY_RXTD_REG175_TEST_FIFO_LARGE_RAM_LOW_RM */
/* test_fifo_large_ram_low_rm */
#define REG_PHY_RXTD_REG175_TEST_FIFO_LARGE_RAM_LOW_RM          0x005D4
#define REG_PHY_RXTD_REG175_TEST_FIFO_LARGE_RAM_LOW_RM_MASK     0x00700000
#define REG_PHY_RXTD_REG175_TEST_FIFO_LARGE_RAM_LOW_RM_SHIFT    20
#define REG_PHY_RXTD_REG175_TEST_FIFO_LARGE_RAM_LOW_RM_WIDTH    3

/* PHY_RXTD_REG175_MEM_CONVERTER_RM */
/* mem_converter_rm */
#define REG_PHY_RXTD_REG175_MEM_CONVERTER_RM          0x005D4
#define REG_PHY_RXTD_REG175_MEM_CONVERTER_RM_MASK     0x07000000
#define REG_PHY_RXTD_REG175_MEM_CONVERTER_RM_SHIFT    24
#define REG_PHY_RXTD_REG175_MEM_CONVERTER_RM_WIDTH    3

/* PHY_RXTD_REG175_TOP_DELAY_RAM_RM */
/* top_delay_ram_rm */
#define REG_PHY_RXTD_REG175_TOP_DELAY_RAM_RM          0x005D4
#define REG_PHY_RXTD_REG175_TOP_DELAY_RAM_RM_MASK     0x70000000
#define REG_PHY_RXTD_REG175_TOP_DELAY_RAM_RM_SHIFT    28
#define REG_PHY_RXTD_REG175_TOP_DELAY_RAM_RM_WIDTH    3

/* PHY_RXTD_REG176_RX_FIFO_AN0_RM */
/* rx_fifo_an0_rm */
#define REG_PHY_RXTD_REG176_RX_FIFO_AN0_RM          0x005D8
#define REG_PHY_RXTD_REG176_RX_FIFO_AN0_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG176_RX_FIFO_AN0_RM_SHIFT    0
#define REG_PHY_RXTD_REG176_RX_FIFO_AN0_RM_WIDTH    3

/* PHY_RXTD_REG176_DELAY_RAM_FINE_TIME_FREQ_AN0_RM */
/* delay_ram_fine_time_freq_an0_rm */
#define REG_PHY_RXTD_REG176_DELAY_RAM_FINE_TIME_FREQ_AN0_RM          0x005D8
#define REG_PHY_RXTD_REG176_DELAY_RAM_FINE_TIME_FREQ_AN0_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG176_DELAY_RAM_FINE_TIME_FREQ_AN0_RM_SHIFT    4
#define REG_PHY_RXTD_REG176_DELAY_RAM_FINE_TIME_FREQ_AN0_RM_WIDTH    3

/* PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_USB_AN0_RM */
/* delay_ram_correlation16_usb_an0_rm */
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_USB_AN0_RM          0x005D8
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_USB_AN0_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_USB_AN0_RM_SHIFT    8
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_USB_AN0_RM_WIDTH    3

/* PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_LSB_AN0_RM */
/* delay_ram_correlation16_lsb_an0_rm */
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_LSB_AN0_RM          0x005D8
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_LSB_AN0_RM_MASK     0x00007000
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_LSB_AN0_RM_SHIFT    12
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION16_LSB_AN0_RM_WIDTH    3

/* PHY_RXTD_REG176_DELAY_RAM_CORRELATION64_TOP_AN0_RM */
/* delay_ram_correlation64_top_an0_rm */
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION64_TOP_AN0_RM          0x005D8
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION64_TOP_AN0_RM_MASK     0x00070000
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION64_TOP_AN0_RM_SHIFT    16
#define REG_PHY_RXTD_REG176_DELAY_RAM_CORRELATION64_TOP_AN0_RM_WIDTH    3

/* PHY_RXTD_REG177_RX_FIFO_AN1_RM */
/* rx_fifo_an1_rm */
#define REG_PHY_RXTD_REG177_RX_FIFO_AN1_RM          0x005DC
#define REG_PHY_RXTD_REG177_RX_FIFO_AN1_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG177_RX_FIFO_AN1_RM_SHIFT    0
#define REG_PHY_RXTD_REG177_RX_FIFO_AN1_RM_WIDTH    3

/* PHY_RXTD_REG177_DELAY_RAM_FINE_TIME_FREQ_AN1_RM */
/* delay_ram_fine_time_freq_an1_rm */
#define REG_PHY_RXTD_REG177_DELAY_RAM_FINE_TIME_FREQ_AN1_RM          0x005DC
#define REG_PHY_RXTD_REG177_DELAY_RAM_FINE_TIME_FREQ_AN1_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG177_DELAY_RAM_FINE_TIME_FREQ_AN1_RM_SHIFT    4
#define REG_PHY_RXTD_REG177_DELAY_RAM_FINE_TIME_FREQ_AN1_RM_WIDTH    3

/* PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_USB_AN1_RM */
/* delay_ram_correlation16_usb_an1_rm */
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_USB_AN1_RM          0x005DC
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_USB_AN1_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_USB_AN1_RM_SHIFT    8
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_USB_AN1_RM_WIDTH    3

/* PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_LSB_AN1_RM */
/* delay_ram_correlation16_lsb_an1_rm */
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_LSB_AN1_RM          0x005DC
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_LSB_AN1_RM_MASK     0x00007000
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_LSB_AN1_RM_SHIFT    12
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION16_LSB_AN1_RM_WIDTH    3

/* PHY_RXTD_REG177_DELAY_RAM_CORRELATION64_TOP_AN1_RM */
/* delay_ram_correlation64_top_an1_rm */
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION64_TOP_AN1_RM          0x005DC
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION64_TOP_AN1_RM_MASK     0x00070000
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION64_TOP_AN1_RM_SHIFT    16
#define REG_PHY_RXTD_REG177_DELAY_RAM_CORRELATION64_TOP_AN1_RM_WIDTH    3

/* PHY_RXTD_REG178_RX_FIFO_AN2_RM */
/* rx_fifo_an2_rm */
#define REG_PHY_RXTD_REG178_RX_FIFO_AN2_RM          0x005E0
#define REG_PHY_RXTD_REG178_RX_FIFO_AN2_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG178_RX_FIFO_AN2_RM_SHIFT    0
#define REG_PHY_RXTD_REG178_RX_FIFO_AN2_RM_WIDTH    3

/* PHY_RXTD_REG178_DELAY_RAM_FINE_TIME_FREQ_AN2_RM */
/* delay_ram_fine_time_freq_an2_rm */
#define REG_PHY_RXTD_REG178_DELAY_RAM_FINE_TIME_FREQ_AN2_RM          0x005E0
#define REG_PHY_RXTD_REG178_DELAY_RAM_FINE_TIME_FREQ_AN2_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG178_DELAY_RAM_FINE_TIME_FREQ_AN2_RM_SHIFT    4
#define REG_PHY_RXTD_REG178_DELAY_RAM_FINE_TIME_FREQ_AN2_RM_WIDTH    3

/* PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_USB_AN2_RM */
/* delay_ram_correlation16_usb_an2_rm */
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_USB_AN2_RM          0x005E0
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_USB_AN2_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_USB_AN2_RM_SHIFT    8
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_USB_AN2_RM_WIDTH    3

/* PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_LSB_AN2_RM */
/* delay_ram_correlation16_lsb_an2_rm */
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_LSB_AN2_RM          0x005E0
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_LSB_AN2_RM_MASK     0x00007000
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_LSB_AN2_RM_SHIFT    12
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION16_LSB_AN2_RM_WIDTH    3

/* PHY_RXTD_REG178_DELAY_RAM_CORRELATION64_TOP_AN2_RM */
/* delay_ram_correlation64_top_an2_rm */
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION64_TOP_AN2_RM          0x005E0
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION64_TOP_AN2_RM_MASK     0x00070000
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION64_TOP_AN2_RM_SHIFT    16
#define REG_PHY_RXTD_REG178_DELAY_RAM_CORRELATION64_TOP_AN2_RM_WIDTH    3

/* PHY_RXTD_REG179_DC_TABLE_RM */
/* dc_table_rm */
#define REG_PHY_RXTD_REG179_DC_TABLE_RM          0x005E4
#define REG_PHY_RXTD_REG179_DC_TABLE_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG179_DC_TABLE_RM_SHIFT    0
#define REG_PHY_RXTD_REG179_DC_TABLE_RM_WIDTH    3

/* PHY_RXTD_REG179_RISC_DRAM_RM */
/* risc_dram_rm */
#define REG_PHY_RXTD_REG179_RISC_DRAM_RM          0x005E4
#define REG_PHY_RXTD_REG179_RISC_DRAM_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG179_RISC_DRAM_RM_SHIFT    4
#define REG_PHY_RXTD_REG179_RISC_DRAM_RM_WIDTH    3

/* PHY_RXTD_REG179_AGC_TABLE_RM */
/* agc_table_rm */
#define REG_PHY_RXTD_REG179_AGC_TABLE_RM          0x005E4
#define REG_PHY_RXTD_REG179_AGC_TABLE_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG179_AGC_TABLE_RM_SHIFT    8
#define REG_PHY_RXTD_REG179_AGC_TABLE_RM_WIDTH    3

/* PHY_RXTD_REG17B_SWITCH_11B_COUNTER_LIMIT */
/* switch_11b_counter_limit */
#define REG_PHY_RXTD_REG17B_SWITCH_11B_COUNTER_LIMIT          0x005EC
#define REG_PHY_RXTD_REG17B_SWITCH_11B_COUNTER_LIMIT_MASK     0x001fffff
#define REG_PHY_RXTD_REG17B_SWITCH_11B_COUNTER_LIMIT_SHIFT    0
#define REG_PHY_RXTD_REG17B_SWITCH_11B_COUNTER_LIMIT_WIDTH    21

/* PHY_RXTD_REG17C_GCLK_SHUTDOWN_EN */
/* gclk shutdown - when '1' clocks will be always deactive */
#define REG_PHY_RXTD_REG17C_GCLK_SHUTDOWN_EN          0x005F0
#define REG_PHY_RXTD_REG17C_GCLK_SHUTDOWN_EN_MASK     0xffffffff
#define REG_PHY_RXTD_REG17C_GCLK_SHUTDOWN_EN_SHIFT    0
#define REG_PHY_RXTD_REG17C_GCLK_SHUTDOWN_EN_WIDTH    32

/* PHY_RXTD_REG17D_BIST_SCR_BYPASS */
/* bist_scr_bypass */
#define REG_PHY_RXTD_REG17D_BIST_SCR_BYPASS          0x005F4
#define REG_PHY_RXTD_REG17D_BIST_SCR_BYPASS_MASK     0x00000001
#define REG_PHY_RXTD_REG17D_BIST_SCR_BYPASS_SHIFT    0
#define REG_PHY_RXTD_REG17D_BIST_SCR_BYPASS_WIDTH    1

/* PHY_RXTD_REG17D_RAM_TEST_MODE */
/* ram_test_mode */
#define REG_PHY_RXTD_REG17D_RAM_TEST_MODE          0x005F4
#define REG_PHY_RXTD_REG17D_RAM_TEST_MODE_MASK     0x00000002
#define REG_PHY_RXTD_REG17D_RAM_TEST_MODE_SHIFT    1
#define REG_PHY_RXTD_REG17D_RAM_TEST_MODE_WIDTH    1

/* PHY_RXTD_REG17D_MEM_GLOBAL_RM */
/* mem_global_rm */
#define REG_PHY_RXTD_REG17D_MEM_GLOBAL_RM          0x005F4
#define REG_PHY_RXTD_REG17D_MEM_GLOBAL_RM_MASK     0x0000000c
#define REG_PHY_RXTD_REG17D_MEM_GLOBAL_RM_SHIFT    2
#define REG_PHY_RXTD_REG17D_MEM_GLOBAL_RM_WIDTH    2

/* PHY_RXTD_REG17E_DIFI_DEC_C0 */
/* difi_dec_c0 */
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C0          0x005F8
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C0_MASK     0x000000ff
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C0_SHIFT    0
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C0_WIDTH    8

/* PHY_RXTD_REG17E_DIFI_DEC_C1 */
/* difi_dec_c1 */
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C1          0x005F8
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C1_MASK     0x0000ff00
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C1_SHIFT    8
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C1_WIDTH    8

/* PHY_RXTD_REG17E_DIFI_DEC_C2 */
/* difi_dec_c2 */
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C2          0x005F8
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C2_MASK     0x00ff0000
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C2_SHIFT    16
#define REG_PHY_RXTD_REG17E_DIFI_DEC_C2_WIDTH    8

/* PHY_RXTD_REG17F_DIFI_DEC_OFFSET */
/* difi_dec_offset */
#define REG_PHY_RXTD_REG17F_DIFI_DEC_OFFSET          0x005FC
#define REG_PHY_RXTD_REG17F_DIFI_DEC_OFFSET_MASK     0x00007fff
#define REG_PHY_RXTD_REG17F_DIFI_DEC_OFFSET_SHIFT    0
#define REG_PHY_RXTD_REG17F_DIFI_DEC_OFFSET_WIDTH    15

/* PHY_RXTD_REG17F_DIFI_DEC_SHIFT */
/* difi_dec_shift */
#define REG_PHY_RXTD_REG17F_DIFI_DEC_SHIFT          0x005FC
#define REG_PHY_RXTD_REG17F_DIFI_DEC_SHIFT_MASK     0x00030000
#define REG_PHY_RXTD_REG17F_DIFI_DEC_SHIFT_SHIFT    16
#define REG_PHY_RXTD_REG17F_DIFI_DEC_SHIFT_WIDTH    2

/* PHY_RXTD_REG17F_DIFI_GPIO_IQ */
/* difi_gpio_iq */
#define REG_PHY_RXTD_REG17F_DIFI_GPIO_IQ          0x005FC
#define REG_PHY_RXTD_REG17F_DIFI_GPIO_IQ_MASK     0x00300000
#define REG_PHY_RXTD_REG17F_DIFI_GPIO_IQ_SHIFT    20
#define REG_PHY_RXTD_REG17F_DIFI_GPIO_IQ_WIDTH    2

/* PHY_RXTD_REG17F_DIFI_DEC_DEFAULT */
/* difi_dec_default */
#define REG_PHY_RXTD_REG17F_DIFI_DEC_DEFAULT          0x005FC
#define REG_PHY_RXTD_REG17F_DIFI_DEC_DEFAULT_MASK     0x0f000000
#define REG_PHY_RXTD_REG17F_DIFI_DEC_DEFAULT_SHIFT    24
#define REG_PHY_RXTD_REG17F_DIFI_DEC_DEFAULT_WIDTH    4

/* PHY_RXTD_REG180_DIFI_F3TO1_C0 */
/* difi_f3to1_c0 */
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C0          0x00600
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C0_MASK     0x000007ff
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C0_SHIFT    0
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C0_WIDTH    11

/* PHY_RXTD_REG180_DIFI_F3TO1_C1 */
/* difi_f3to1_c1 */
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C1          0x00600
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C1_MASK     0x007ff000
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C1_SHIFT    12
#define REG_PHY_RXTD_REG180_DIFI_F3TO1_C1_WIDTH    11

/* PHY_RXTD_REG181_DIFI_F3TO1_C2 */
/* difi_f3to1_c2 */
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C2          0x00604
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C2_MASK     0x000007ff
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C2_SHIFT    0
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C2_WIDTH    11

/* PHY_RXTD_REG181_DIFI_F3TO1_C3 */
/* difi_f3to1_c3 */
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C3          0x00604
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C3_MASK     0x007ff000
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C3_SHIFT    12
#define REG_PHY_RXTD_REG181_DIFI_F3TO1_C3_WIDTH    11

/* PHY_RXTD_REG182_DIFI_F3TO1_C4 */
/* difi_f3to1_c4 */
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C4          0x00608
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C4_MASK     0x000007ff
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C4_SHIFT    0
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C4_WIDTH    11

/* PHY_RXTD_REG182_DIFI_F3TO1_C5 */
/* difi_f3to1_c5 */
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C5          0x00608
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C5_MASK     0x007ff000
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C5_SHIFT    12
#define REG_PHY_RXTD_REG182_DIFI_F3TO1_C5_WIDTH    11

/* PHY_RXTD_REG183_DIFI_F3TO1_C6 */
/* difi_f3to1_c6 */
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C6          0x0060C
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C6_MASK     0x000007ff
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C6_SHIFT    0
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C6_WIDTH    11

/* PHY_RXTD_REG183_DIFI_F3TO1_C7 */
/* difi_f3to1_c7 */
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C7          0x0060C
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C7_MASK     0x007ff000
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C7_SHIFT    12
#define REG_PHY_RXTD_REG183_DIFI_F3TO1_C7_WIDTH    11

/* PHY_RXTD_REG184_DIFI_F3TO1_C8 */
/* difi_f3to1_c8 */
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_C8          0x00610
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_C8_MASK     0x000007ff
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_C8_SHIFT    0
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_C8_WIDTH    11

/* PHY_RXTD_REG184_DIFI_F3TO1_DEC_SHIFTER */
/* difi_f3to1_dec_shifter */
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_DEC_SHIFTER          0x00610
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_DEC_SHIFTER_MASK     0x00003000
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_DEC_SHIFTER_SHIFT    12
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_DEC_SHIFTER_WIDTH    2

/* PHY_RXTD_REG184_DIFI_F3TO1_INT_SHIFTER */
/* difi_f3to1_int_shifter */
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_INT_SHIFTER          0x00610
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_INT_SHIFTER_MASK     0x00030000
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_INT_SHIFTER_SHIFT    16
#define REG_PHY_RXTD_REG184_DIFI_F3TO1_INT_SHIFTER_WIDTH    2

/* PHY_RXTD_REG185_DIFI_DPD0_RM */
/* difi_dpd0_rm */
#define REG_PHY_RXTD_REG185_DIFI_DPD0_RM          0x00614
#define REG_PHY_RXTD_REG185_DIFI_DPD0_RM_MASK     0x00000007
#define REG_PHY_RXTD_REG185_DIFI_DPD0_RM_SHIFT    0
#define REG_PHY_RXTD_REG185_DIFI_DPD0_RM_WIDTH    3

/* PHY_RXTD_REG185_DIFI_DPD1_RM */
/* difi_dpd1_rm */
#define REG_PHY_RXTD_REG185_DIFI_DPD1_RM          0x00614
#define REG_PHY_RXTD_REG185_DIFI_DPD1_RM_MASK     0x00000070
#define REG_PHY_RXTD_REG185_DIFI_DPD1_RM_SHIFT    4
#define REG_PHY_RXTD_REG185_DIFI_DPD1_RM_WIDTH    3

/* PHY_RXTD_REG185_DIFI_DPD2_RM */
/* difi_dpd2_rm */
#define REG_PHY_RXTD_REG185_DIFI_DPD2_RM          0x00614
#define REG_PHY_RXTD_REG185_DIFI_DPD2_RM_MASK     0x00000700
#define REG_PHY_RXTD_REG185_DIFI_DPD2_RM_SHIFT    8
#define REG_PHY_RXTD_REG185_DIFI_DPD2_RM_WIDTH    3

/* PHY_RXTD_REG186_DIFI_DPD_SCALE */
/* difi_dpd_scale */
#define REG_PHY_RXTD_REG186_DIFI_DPD_SCALE          0x00618
#define REG_PHY_RXTD_REG186_DIFI_DPD_SCALE_MASK     0x00000003
#define REG_PHY_RXTD_REG186_DIFI_DPD_SCALE_SHIFT    0
#define REG_PHY_RXTD_REG186_DIFI_DPD_SCALE_WIDTH    2

/* PHY_RXTD_REG186_DIFI_DPD0_BYPASS */
/* difi_dpd0_bypass */
#define REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS          0x00618
#define REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS_MASK     0x00000010
#define REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS_SHIFT    4
#define REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS_WIDTH    1

/* PHY_RXTD_REG186_DIFI_DPD1_BYPASS */
/* difi_dpd1_bypass */
#define REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS          0x00618
#define REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS_MASK     0x00000100
#define REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS_SHIFT    8
#define REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS_WIDTH    1

/* PHY_RXTD_REG186_DIFI_DPD2_BYPASS */
/* difi_dpd2_bypass */
#define REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS          0x00618
#define REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS_MASK     0x00001000
#define REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS_SHIFT    12
#define REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS_WIDTH    1

/* PHY_RXTD_REG188_DISABLE_SEC_DETECTION */
/* disable_sec_detection */
#define REG_PHY_RXTD_REG188_DISABLE_SEC_DETECTION          0x00620
#define REG_PHY_RXTD_REG188_DISABLE_SEC_DETECTION_MASK     0x00000001
#define REG_PHY_RXTD_REG188_DISABLE_SEC_DETECTION_SHIFT    0
#define REG_PHY_RXTD_REG188_DISABLE_SEC_DETECTION_WIDTH    1

/* PHY_RXTD_REG189_WATCH_DOG_LIMIT */
/* allows up to 17sec watch dog limit
if limit is 0 then watch dog is disabled */
#define REG_PHY_RXTD_REG189_WATCH_DOG_LIMIT          0x00624
#define REG_PHY_RXTD_REG189_WATCH_DOG_LIMIT_MASK     0xffffffff
#define REG_PHY_RXTD_REG189_WATCH_DOG_LIMIT_SHIFT    0
#define REG_PHY_RXTD_REG189_WATCH_DOG_LIMIT_WIDTH    32

/* PHY_RXTD_REG18A_STBC_SIFS_DELAY */
/* stbc_sifs_delay: add delay (up to 900ns) to sifs if viterbi and:
bw=40 and ht
bw=80 and vht */
#define REG_PHY_RXTD_REG18A_STBC_SIFS_DELAY          0x00628
#define REG_PHY_RXTD_REG18A_STBC_SIFS_DELAY_MASK     0x000000ff
#define REG_PHY_RXTD_REG18A_STBC_SIFS_DELAY_SHIFT    0
#define REG_PHY_RXTD_REG18A_STBC_SIFS_DELAY_WIDTH    8
#endif 
