/*******************************************************************
*                                                                   
*  PHY_Tx1_Cyc_Ext.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_Tx1_Cyc_Ext_regs_H_FILE
#define PHY_Tx1_Cyc_Ext_regs_H_FILE

/* TX1_CYC_EXT_REG00_FFT_START_ADDR0_SET0 */
/* Option 0 start address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR0_SET0          0x2B000
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR0_SET0_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR0_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR0_SET0_WIDTH    7

/* TX1_CYC_EXT_REG00_FFT_END_ADDR0_SET0 */
/* Option 0 End address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR0_SET0          0x2B000
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR0_SET0_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR0_SET0_SHIFT    7
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR0_SET0_WIDTH    7

/* TX1_CYC_EXT_REG00_FFT_START_ADDR1_SET0 */
/* Option 1 start address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR1_SET0          0x2B000
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR1_SET0_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR1_SET0_SHIFT    14
#define REG_TX1_CYC_EXT_REG00_FFT_START_ADDR1_SET0_WIDTH    7

/* TX1_CYC_EXT_REG00_FFT_END_ADDR1_SET0 */
/* Option 1 End address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR1_SET0          0x2B000
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR1_SET0_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR1_SET0_SHIFT    21
#define REG_TX1_CYC_EXT_REG00_FFT_END_ADDR1_SET0_WIDTH    7

/* TX1_CYC_EXT_REG01_FFT_START_ADDR2_SET0 */
/* Option 2 start address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG01_FFT_START_ADDR2_SET0          0x2B004
#define REG_TX1_CYC_EXT_REG01_FFT_START_ADDR2_SET0_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG01_FFT_START_ADDR2_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG01_FFT_START_ADDR2_SET0_WIDTH    7

/* TX1_CYC_EXT_REG01_FFT_END_ADDR2_SET0 */
/* Option 2 End address for IFFT OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG01_FFT_END_ADDR2_SET0          0x2B004
#define REG_TX1_CYC_EXT_REG01_FFT_END_ADDR2_SET0_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG01_FFT_END_ADDR2_SET0_SHIFT    7
#define REG_TX1_CYC_EXT_REG01_FFT_END_ADDR2_SET0_WIDTH    7

/* TX1_CYC_EXT_REG02_FFT_OP_0_SET0 */
/* IFFT OpCode 0 in set 0 */
#define REG_TX1_CYC_EXT_REG02_FFT_OP_0_SET0          0x2B008
#define REG_TX1_CYC_EXT_REG02_FFT_OP_0_SET0_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG02_FFT_OP_0_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG02_FFT_OP_0_SET0_WIDTH    6

/* TX1_CYC_EXT_REG02_FFT_OP_1_SET0 */
/* IFFT OpCode 1 in set 0 */
#define REG_TX1_CYC_EXT_REG02_FFT_OP_1_SET0          0x2B008
#define REG_TX1_CYC_EXT_REG02_FFT_OP_1_SET0_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG02_FFT_OP_1_SET0_SHIFT    6
#define REG_TX1_CYC_EXT_REG02_FFT_OP_1_SET0_WIDTH    6

/* TX1_CYC_EXT_REG02_FFT_OP_2_SET0 */
/* IFFT OpCode 2 in set 0 */
#define REG_TX1_CYC_EXT_REG02_FFT_OP_2_SET0          0x2B008
#define REG_TX1_CYC_EXT_REG02_FFT_OP_2_SET0_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG02_FFT_OP_2_SET0_SHIFT    12
#define REG_TX1_CYC_EXT_REG02_FFT_OP_2_SET0_WIDTH    6

/* TX1_CYC_EXT_REG03_FFT_START_ADDR0_SET1 */
/* Option 0 start address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR0_SET1          0x2B00C
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR0_SET1_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR0_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR0_SET1_WIDTH    7

/* TX1_CYC_EXT_REG03_FFT_END_ADDR0_SET1 */
/* Option 0 End address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR0_SET1          0x2B00C
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR0_SET1_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR0_SET1_SHIFT    7
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR0_SET1_WIDTH    7

/* TX1_CYC_EXT_REG03_FFT_START_ADDR1_SET1 */
/* Option 1 start address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR1_SET1          0x2B00C
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR1_SET1_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR1_SET1_SHIFT    14
#define REG_TX1_CYC_EXT_REG03_FFT_START_ADDR1_SET1_WIDTH    7

/* TX1_CYC_EXT_REG03_FFT_END_ADDR1_SET1 */
/* Option 1 End address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR1_SET1          0x2B00C
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR1_SET1_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR1_SET1_SHIFT    21
#define REG_TX1_CYC_EXT_REG03_FFT_END_ADDR1_SET1_WIDTH    7

/* TX1_CYC_EXT_REG04_FFT_START_ADDR2_SET1 */
/* Option 2 start address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG04_FFT_START_ADDR2_SET1          0x2B010
#define REG_TX1_CYC_EXT_REG04_FFT_START_ADDR2_SET1_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG04_FFT_START_ADDR2_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG04_FFT_START_ADDR2_SET1_WIDTH    7

/* TX1_CYC_EXT_REG04_FFT_END_ADDR2_SET1 */
/* Option 2 End address for IFFT OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG04_FFT_END_ADDR2_SET1          0x2B010
#define REG_TX1_CYC_EXT_REG04_FFT_END_ADDR2_SET1_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG04_FFT_END_ADDR2_SET1_SHIFT    7
#define REG_TX1_CYC_EXT_REG04_FFT_END_ADDR2_SET1_WIDTH    7

/* TX1_CYC_EXT_REG05_FFT_OP_0_SET1 */
/* IFFT OpCode 0 in set 1 */
#define REG_TX1_CYC_EXT_REG05_FFT_OP_0_SET1          0x2B014
#define REG_TX1_CYC_EXT_REG05_FFT_OP_0_SET1_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG05_FFT_OP_0_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG05_FFT_OP_0_SET1_WIDTH    6

/* TX1_CYC_EXT_REG05_FFT_OP_1_SET1 */
/* IFFT OpCode 1 in set 1 */
#define REG_TX1_CYC_EXT_REG05_FFT_OP_1_SET1          0x2B014
#define REG_TX1_CYC_EXT_REG05_FFT_OP_1_SET1_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG05_FFT_OP_1_SET1_SHIFT    6
#define REG_TX1_CYC_EXT_REG05_FFT_OP_1_SET1_WIDTH    6

/* TX1_CYC_EXT_REG05_FFT_OP_2_SET1 */
/* IFFT OpCode 2 in set 1 */
#define REG_TX1_CYC_EXT_REG05_FFT_OP_2_SET1          0x2B014
#define REG_TX1_CYC_EXT_REG05_FFT_OP_2_SET1_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG05_FFT_OP_2_SET1_SHIFT    12
#define REG_TX1_CYC_EXT_REG05_FFT_OP_2_SET1_WIDTH    6

/* TX1_CYC_EXT_REG06_FFT_START_ADDR0_SET2 */
/* Option 0 start address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR0_SET2          0x2B018
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR0_SET2_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR0_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR0_SET2_WIDTH    7

/* TX1_CYC_EXT_REG06_FFT_END_ADDR0_SET2 */
/* Option 0 End address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR0_SET2          0x2B018
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR0_SET2_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR0_SET2_SHIFT    7
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR0_SET2_WIDTH    7

/* TX1_CYC_EXT_REG06_FFT_START_ADDR1_SET2 */
/* Option 1 start address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR1_SET2          0x2B018
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR1_SET2_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR1_SET2_SHIFT    14
#define REG_TX1_CYC_EXT_REG06_FFT_START_ADDR1_SET2_WIDTH    7

/* TX1_CYC_EXT_REG06_FFT_END_ADDR1_SET2 */
/* Option 1 End address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR1_SET2          0x2B018
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR1_SET2_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR1_SET2_SHIFT    21
#define REG_TX1_CYC_EXT_REG06_FFT_END_ADDR1_SET2_WIDTH    7

/* TX1_CYC_EXT_REG07_FFT_START_ADDR2_SET2 */
/* Option 2 start address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG07_FFT_START_ADDR2_SET2          0x2B01C
#define REG_TX1_CYC_EXT_REG07_FFT_START_ADDR2_SET2_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG07_FFT_START_ADDR2_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG07_FFT_START_ADDR2_SET2_WIDTH    7

/* TX1_CYC_EXT_REG07_FFT_END_ADDR2_SET2 */
/* Option 2 End address for IFFT OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG07_FFT_END_ADDR2_SET2          0x2B01C
#define REG_TX1_CYC_EXT_REG07_FFT_END_ADDR2_SET2_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG07_FFT_END_ADDR2_SET2_SHIFT    7
#define REG_TX1_CYC_EXT_REG07_FFT_END_ADDR2_SET2_WIDTH    7

/* TX1_CYC_EXT_REG08_FFT_OP_0_SET2 */
/* IFFT OpCode 0 in set 2 */
#define REG_TX1_CYC_EXT_REG08_FFT_OP_0_SET2          0x2B020
#define REG_TX1_CYC_EXT_REG08_FFT_OP_0_SET2_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG08_FFT_OP_0_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG08_FFT_OP_0_SET2_WIDTH    6

/* TX1_CYC_EXT_REG08_FFT_OP_1_SET2 */
/* IFFT OpCode 1 in set 2 */
#define REG_TX1_CYC_EXT_REG08_FFT_OP_1_SET2          0x2B020
#define REG_TX1_CYC_EXT_REG08_FFT_OP_1_SET2_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG08_FFT_OP_1_SET2_SHIFT    6
#define REG_TX1_CYC_EXT_REG08_FFT_OP_1_SET2_WIDTH    6

/* TX1_CYC_EXT_REG08_FFT_OP_2_SET2 */
/* IFFT OpCode 2 in set 2 */
#define REG_TX1_CYC_EXT_REG08_FFT_OP_2_SET2          0x2B020
#define REG_TX1_CYC_EXT_REG08_FFT_OP_2_SET2_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG08_FFT_OP_2_SET2_SHIFT    12
#define REG_TX1_CYC_EXT_REG08_FFT_OP_2_SET2_WIDTH    6

/* TX1_CYC_EXT_REG09_FFT_START_ADDR0_SET3 */
/* Option 0 start address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR0_SET3          0x2B024
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR0_SET3_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR0_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR0_SET3_WIDTH    7

/* TX1_CYC_EXT_REG09_FFT_END_ADDR0_SET3 */
/* Option 0 End address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR0_SET3          0x2B024
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR0_SET3_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR0_SET3_SHIFT    7
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR0_SET3_WIDTH    7

/* TX1_CYC_EXT_REG09_FFT_START_ADDR1_SET3 */
/* Option 1 start address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR1_SET3          0x2B024
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR1_SET3_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR1_SET3_SHIFT    14
#define REG_TX1_CYC_EXT_REG09_FFT_START_ADDR1_SET3_WIDTH    7

/* TX1_CYC_EXT_REG09_FFT_END_ADDR1_SET3 */
/* Option 1 End address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR1_SET3          0x2B024
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR1_SET3_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR1_SET3_SHIFT    21
#define REG_TX1_CYC_EXT_REG09_FFT_END_ADDR1_SET3_WIDTH    7

/* TX1_CYC_EXT_REG0A_FFT_START_ADDR2_SET3 */
/* Option 2 start address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG0A_FFT_START_ADDR2_SET3          0x2B028
#define REG_TX1_CYC_EXT_REG0A_FFT_START_ADDR2_SET3_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG0A_FFT_START_ADDR2_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG0A_FFT_START_ADDR2_SET3_WIDTH    7

/* TX1_CYC_EXT_REG0A_FFT_END_ADDR2_SET3 */
/* Option 2 End address for IFFT OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG0A_FFT_END_ADDR2_SET3          0x2B028
#define REG_TX1_CYC_EXT_REG0A_FFT_END_ADDR2_SET3_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG0A_FFT_END_ADDR2_SET3_SHIFT    7
#define REG_TX1_CYC_EXT_REG0A_FFT_END_ADDR2_SET3_WIDTH    7

/* TX1_CYC_EXT_REG0B_FFT_OP_0_SET3 */
/* IFFT OpCode 0 in set 3 */
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_0_SET3          0x2B02C
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_0_SET3_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_0_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_0_SET3_WIDTH    6

/* TX1_CYC_EXT_REG0B_FFT_OP_1_SET3 */
/* IFFT OpCode 1 in set 3 */
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_1_SET3          0x2B02C
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_1_SET3_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_1_SET3_SHIFT    6
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_1_SET3_WIDTH    6

/* TX1_CYC_EXT_REG0B_FFT_OP_2_SET3 */
/* IFFT OpCode 2 in set 3 */
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_2_SET3          0x2B02C
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_2_SET3_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_2_SET3_SHIFT    12
#define REG_TX1_CYC_EXT_REG0B_FFT_OP_2_SET3_WIDTH    6

/* TX1_CYC_EXT_REG0C_PRE_START_ADDR0_SET0 */
/* Option 0 start address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0C_PRE_START_ADDR0_SET0          0x2B030
#define REG_TX1_CYC_EXT_REG0C_PRE_START_ADDR0_SET0_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG0C_PRE_START_ADDR0_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG0C_PRE_START_ADDR0_SET0_WIDTH    9

/* TX1_CYC_EXT_REG0C_PRE_END_ADDR0_SET0 */
/* Option 0 End address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0C_PRE_END_ADDR0_SET0          0x2B030
#define REG_TX1_CYC_EXT_REG0C_PRE_END_ADDR0_SET0_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG0C_PRE_END_ADDR0_SET0_SHIFT    10
#define REG_TX1_CYC_EXT_REG0C_PRE_END_ADDR0_SET0_WIDTH    9

/* TX1_CYC_EXT_REG0D_PRE_START_ADDR1_SET0 */
/* Option 1 start address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0D_PRE_START_ADDR1_SET0          0x2B034
#define REG_TX1_CYC_EXT_REG0D_PRE_START_ADDR1_SET0_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG0D_PRE_START_ADDR1_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG0D_PRE_START_ADDR1_SET0_WIDTH    9

/* TX1_CYC_EXT_REG0D_PRE_END_ADDR1_SET0 */
/* Option 1 End address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0D_PRE_END_ADDR1_SET0          0x2B034
#define REG_TX1_CYC_EXT_REG0D_PRE_END_ADDR1_SET0_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG0D_PRE_END_ADDR1_SET0_SHIFT    10
#define REG_TX1_CYC_EXT_REG0D_PRE_END_ADDR1_SET0_WIDTH    9

/* TX1_CYC_EXT_REG0E_PRE_START_ADDR2_SET0 */
/* Option 2 start address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0E_PRE_START_ADDR2_SET0          0x2B038
#define REG_TX1_CYC_EXT_REG0E_PRE_START_ADDR2_SET0_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG0E_PRE_START_ADDR2_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG0E_PRE_START_ADDR2_SET0_WIDTH    9

/* TX1_CYC_EXT_REG0E_PRE_END_ADDR2_SET0 */
/* Option 2 End address for Preamble OpCodes set 0 */
#define REG_TX1_CYC_EXT_REG0E_PRE_END_ADDR2_SET0          0x2B038
#define REG_TX1_CYC_EXT_REG0E_PRE_END_ADDR2_SET0_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG0E_PRE_END_ADDR2_SET0_SHIFT    10
#define REG_TX1_CYC_EXT_REG0E_PRE_END_ADDR2_SET0_WIDTH    9

/* TX1_CYC_EXT_REG10_PRE_OP_0_SET0 */
/* Preamble OpCode 0 in set 0 */
#define REG_TX1_CYC_EXT_REG10_PRE_OP_0_SET0          0x2B040
#define REG_TX1_CYC_EXT_REG10_PRE_OP_0_SET0_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG10_PRE_OP_0_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG10_PRE_OP_0_SET0_WIDTH    6

/* TX1_CYC_EXT_REG10_PRE_OP_1_SET0 */
/* Preamble OpCode 1 in set 0 */
#define REG_TX1_CYC_EXT_REG10_PRE_OP_1_SET0          0x2B040
#define REG_TX1_CYC_EXT_REG10_PRE_OP_1_SET0_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG10_PRE_OP_1_SET0_SHIFT    6
#define REG_TX1_CYC_EXT_REG10_PRE_OP_1_SET0_WIDTH    6

/* TX1_CYC_EXT_REG10_PRE_OP_2_SET0 */
/* Preamble OpCode 2 in set 0 */
#define REG_TX1_CYC_EXT_REG10_PRE_OP_2_SET0          0x2B040
#define REG_TX1_CYC_EXT_REG10_PRE_OP_2_SET0_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG10_PRE_OP_2_SET0_SHIFT    12
#define REG_TX1_CYC_EXT_REG10_PRE_OP_2_SET0_WIDTH    6

/* TX1_CYC_EXT_REG11_PRE_START_ADDR0_SET1 */
/* Option 0 start address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG11_PRE_START_ADDR0_SET1          0x2B044
#define REG_TX1_CYC_EXT_REG11_PRE_START_ADDR0_SET1_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG11_PRE_START_ADDR0_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG11_PRE_START_ADDR0_SET1_WIDTH    9

/* TX1_CYC_EXT_REG11_PRE_END_ADDR0_SET1 */
/* Option 0 End address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG11_PRE_END_ADDR0_SET1          0x2B044
#define REG_TX1_CYC_EXT_REG11_PRE_END_ADDR0_SET1_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG11_PRE_END_ADDR0_SET1_SHIFT    10
#define REG_TX1_CYC_EXT_REG11_PRE_END_ADDR0_SET1_WIDTH    9

/* TX1_CYC_EXT_REG12_PRE_START_ADDR1_SET1 */
/* Option 1 start address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG12_PRE_START_ADDR1_SET1          0x2B048
#define REG_TX1_CYC_EXT_REG12_PRE_START_ADDR1_SET1_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG12_PRE_START_ADDR1_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG12_PRE_START_ADDR1_SET1_WIDTH    9

/* TX1_CYC_EXT_REG12_PRE_END_ADDR1_SET1 */
/* Option 1 End address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG12_PRE_END_ADDR1_SET1          0x2B048
#define REG_TX1_CYC_EXT_REG12_PRE_END_ADDR1_SET1_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG12_PRE_END_ADDR1_SET1_SHIFT    10
#define REG_TX1_CYC_EXT_REG12_PRE_END_ADDR1_SET1_WIDTH    9

/* TX1_CYC_EXT_REG13_PRE_START_ADDR2_SET1 */
/* Option 2 start address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG13_PRE_START_ADDR2_SET1          0x2B04C
#define REG_TX1_CYC_EXT_REG13_PRE_START_ADDR2_SET1_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG13_PRE_START_ADDR2_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG13_PRE_START_ADDR2_SET1_WIDTH    9

/* TX1_CYC_EXT_REG13_PRE_END_ADDR2_SET1 */
/* Option 2 End address for Preamble OpCodes set 1 */
#define REG_TX1_CYC_EXT_REG13_PRE_END_ADDR2_SET1          0x2B04C
#define REG_TX1_CYC_EXT_REG13_PRE_END_ADDR2_SET1_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG13_PRE_END_ADDR2_SET1_SHIFT    10
#define REG_TX1_CYC_EXT_REG13_PRE_END_ADDR2_SET1_WIDTH    9

/* TX1_CYC_EXT_REG15_PRE_OP_0_SET1 */
/* Preamble OpCode 0 in set 1 */
#define REG_TX1_CYC_EXT_REG15_PRE_OP_0_SET1          0x2B054
#define REG_TX1_CYC_EXT_REG15_PRE_OP_0_SET1_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG15_PRE_OP_0_SET1_SHIFT    0
#define REG_TX1_CYC_EXT_REG15_PRE_OP_0_SET1_WIDTH    6

/* TX1_CYC_EXT_REG15_PRE_OP_1_SET1 */
/* Preamble OpCode 1 in set 1 */
#define REG_TX1_CYC_EXT_REG15_PRE_OP_1_SET1          0x2B054
#define REG_TX1_CYC_EXT_REG15_PRE_OP_1_SET1_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG15_PRE_OP_1_SET1_SHIFT    6
#define REG_TX1_CYC_EXT_REG15_PRE_OP_1_SET1_WIDTH    6

/* TX1_CYC_EXT_REG15_PRE_OP_2_SET1 */
/* Preamble OpCode 2 in set 1 */
#define REG_TX1_CYC_EXT_REG15_PRE_OP_2_SET1          0x2B054
#define REG_TX1_CYC_EXT_REG15_PRE_OP_2_SET1_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG15_PRE_OP_2_SET1_SHIFT    12
#define REG_TX1_CYC_EXT_REG15_PRE_OP_2_SET1_WIDTH    6

/* TX1_CYC_EXT_REG16_PRE_START_ADDR0_SET2 */
/* Option 0 start address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG16_PRE_START_ADDR0_SET2          0x2B058
#define REG_TX1_CYC_EXT_REG16_PRE_START_ADDR0_SET2_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG16_PRE_START_ADDR0_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG16_PRE_START_ADDR0_SET2_WIDTH    9

/* TX1_CYC_EXT_REG16_PRE_END_ADDR0_SET2 */
/* Option 0 End address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG16_PRE_END_ADDR0_SET2          0x2B058
#define REG_TX1_CYC_EXT_REG16_PRE_END_ADDR0_SET2_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG16_PRE_END_ADDR0_SET2_SHIFT    10
#define REG_TX1_CYC_EXT_REG16_PRE_END_ADDR0_SET2_WIDTH    9

/* TX1_CYC_EXT_REG17_PRE_START_ADDR1_SET2 */
/* Option 1 start address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG17_PRE_START_ADDR1_SET2          0x2B05C
#define REG_TX1_CYC_EXT_REG17_PRE_START_ADDR1_SET2_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG17_PRE_START_ADDR1_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG17_PRE_START_ADDR1_SET2_WIDTH    9

/* TX1_CYC_EXT_REG17_PRE_END_ADDR1_SET2 */
/* Option 1 End address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG17_PRE_END_ADDR1_SET2          0x2B05C
#define REG_TX1_CYC_EXT_REG17_PRE_END_ADDR1_SET2_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG17_PRE_END_ADDR1_SET2_SHIFT    10
#define REG_TX1_CYC_EXT_REG17_PRE_END_ADDR1_SET2_WIDTH    9

/* TX1_CYC_EXT_REG18_PRE_START_ADDR2_SET2 */
/* Option 2 start address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG18_PRE_START_ADDR2_SET2          0x2B060
#define REG_TX1_CYC_EXT_REG18_PRE_START_ADDR2_SET2_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG18_PRE_START_ADDR2_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG18_PRE_START_ADDR2_SET2_WIDTH    9

/* TX1_CYC_EXT_REG18_PRE_END_ADDR2_SET2 */
/* Option 2 End address for Preamble OpCodes set 2 */
#define REG_TX1_CYC_EXT_REG18_PRE_END_ADDR2_SET2          0x2B060
#define REG_TX1_CYC_EXT_REG18_PRE_END_ADDR2_SET2_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG18_PRE_END_ADDR2_SET2_SHIFT    10
#define REG_TX1_CYC_EXT_REG18_PRE_END_ADDR2_SET2_WIDTH    9

/* TX1_CYC_EXT_REG1A_PRE_OP_0_SET2 */
/* Preamble OpCode 0 in set 2 */
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_0_SET2          0x2B068
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_0_SET2_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_0_SET2_SHIFT    0
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_0_SET2_WIDTH    6

/* TX1_CYC_EXT_REG1A_PRE_OP_1_SET2 */
/* Preamble OpCode 1 in set 2 */
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_1_SET2          0x2B068
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_1_SET2_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_1_SET2_SHIFT    6
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_1_SET2_WIDTH    6

/* TX1_CYC_EXT_REG1A_PRE_OP_2_SET2 */
/* Preamble OpCode 2 in set 2 */
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_2_SET2          0x2B068
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_2_SET2_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_2_SET2_SHIFT    12
#define REG_TX1_CYC_EXT_REG1A_PRE_OP_2_SET2_WIDTH    6

/* TX1_CYC_EXT_REG1B_PRE_START_ADDR0_SET3 */
/* Option 0 start address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1B_PRE_START_ADDR0_SET3          0x2B06C
#define REG_TX1_CYC_EXT_REG1B_PRE_START_ADDR0_SET3_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG1B_PRE_START_ADDR0_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG1B_PRE_START_ADDR0_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1B_PRE_END_ADDR0_SET3 */
/* Option 0 End address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1B_PRE_END_ADDR0_SET3          0x2B06C
#define REG_TX1_CYC_EXT_REG1B_PRE_END_ADDR0_SET3_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG1B_PRE_END_ADDR0_SET3_SHIFT    10
#define REG_TX1_CYC_EXT_REG1B_PRE_END_ADDR0_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1C_PRE_START_ADDR1_SET3 */
/* Option 1 start address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1C_PRE_START_ADDR1_SET3          0x2B070
#define REG_TX1_CYC_EXT_REG1C_PRE_START_ADDR1_SET3_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG1C_PRE_START_ADDR1_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG1C_PRE_START_ADDR1_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1C_PRE_END_ADDR1_SET3 */
/* Option 1 End address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1C_PRE_END_ADDR1_SET3          0x2B070
#define REG_TX1_CYC_EXT_REG1C_PRE_END_ADDR1_SET3_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG1C_PRE_END_ADDR1_SET3_SHIFT    10
#define REG_TX1_CYC_EXT_REG1C_PRE_END_ADDR1_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1D_PRE_START_ADDR2_SET3 */
/* Option 2 start address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1D_PRE_START_ADDR2_SET3          0x2B074
#define REG_TX1_CYC_EXT_REG1D_PRE_START_ADDR2_SET3_MASK     0x000001FF
#define REG_TX1_CYC_EXT_REG1D_PRE_START_ADDR2_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG1D_PRE_START_ADDR2_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1D_PRE_END_ADDR2_SET3 */
/* Option 2 End address for Preamble OpCodes set 3 */
#define REG_TX1_CYC_EXT_REG1D_PRE_END_ADDR2_SET3          0x2B074
#define REG_TX1_CYC_EXT_REG1D_PRE_END_ADDR2_SET3_MASK     0x0007FC00
#define REG_TX1_CYC_EXT_REG1D_PRE_END_ADDR2_SET3_SHIFT    10
#define REG_TX1_CYC_EXT_REG1D_PRE_END_ADDR2_SET3_WIDTH    9

/* TX1_CYC_EXT_REG1F_PRE_OP_0_SET3 */
/* Preamble OpCode 0 in set 3 */
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_0_SET3          0x2B07C
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_0_SET3_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_0_SET3_SHIFT    0
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_0_SET3_WIDTH    6

/* TX1_CYC_EXT_REG1F_PRE_OP_1_SET3 */
/* Preamble OpCode 1 in set 3 */
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_1_SET3          0x2B07C
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_1_SET3_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_1_SET3_SHIFT    6
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_1_SET3_WIDTH    6

/* TX1_CYC_EXT_REG1F_PRE_OP_2_SET3 */
/* Preamble OpCode 2 in set 3 */
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_2_SET3          0x2B07C
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_2_SET3_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_2_SET3_SHIFT    12
#define REG_TX1_CYC_EXT_REG1F_PRE_OP_2_SET3_WIDTH    6

/* TX1_CYC_EXT_REG20_CLK_PER_STRB_SET0 */
/* Cyclic Extention clock per strobe rate set 0 */
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET0          0x2B080
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET0_MASK     0x0000000F
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET0_SHIFT    0
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET0_WIDTH    4

/* TX1_CYC_EXT_REG20_CLK_PER_STRB_SET1 */
/* Cyclic Extention clock per strobe rate set 1 */
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET1          0x2B080
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET1_MASK     0x000000F0
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET1_SHIFT    4
#define REG_TX1_CYC_EXT_REG20_CLK_PER_STRB_SET1_WIDTH    4

/* TX1_CYC_EXT_REG21_RAMP_DOWN_END_ADDR */
/* Number of samples in ramp down mode (cyclic scheme select = 5) */
#define REG_TX1_CYC_EXT_REG21_RAMP_DOWN_END_ADDR          0x2B084
#define REG_TX1_CYC_EXT_REG21_RAMP_DOWN_END_ADDR_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG21_RAMP_DOWN_END_ADDR_SHIFT    0
#define REG_TX1_CYC_EXT_REG21_RAMP_DOWN_END_ADDR_WIDTH    7

/* TX1_CYC_EXT_REG21_RAMP_UP_END_ADDR */
/* Number of samples in ramp up mode (cyclic scheme select = 4) */
#define REG_TX1_CYC_EXT_REG21_RAMP_UP_END_ADDR          0x2B084
#define REG_TX1_CYC_EXT_REG21_RAMP_UP_END_ADDR_MASK     0x00007F00
#define REG_TX1_CYC_EXT_REG21_RAMP_UP_END_ADDR_SHIFT    8
#define REG_TX1_CYC_EXT_REG21_RAMP_UP_END_ADDR_WIDTH    7

/* TX1_CYC_EXT_REG22_FFT_START_ADDR0_SET4 */
/* Option 0 start address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR0_SET4          0x2B088
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR0_SET4_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR0_SET4_SHIFT    0
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR0_SET4_WIDTH    7

/* TX1_CYC_EXT_REG22_FFT_END_ADDR0_SET4 */
/* Option 0 End address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR0_SET4          0x2B088
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR0_SET4_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR0_SET4_SHIFT    7
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR0_SET4_WIDTH    7

/* TX1_CYC_EXT_REG22_FFT_START_ADDR1_SET4 */
/* Option 1 start address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR1_SET4          0x2B088
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR1_SET4_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR1_SET4_SHIFT    14
#define REG_TX1_CYC_EXT_REG22_FFT_START_ADDR1_SET4_WIDTH    7

/* TX1_CYC_EXT_REG22_FFT_END_ADDR1_SET4 */
/* Option 1 End address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR1_SET4          0x2B088
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR1_SET4_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR1_SET4_SHIFT    21
#define REG_TX1_CYC_EXT_REG22_FFT_END_ADDR1_SET4_WIDTH    7

/* TX1_CYC_EXT_REG23_FFT_START_ADDR2_SET4 */
/* Option 2 start address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG23_FFT_START_ADDR2_SET4          0x2B08C
#define REG_TX1_CYC_EXT_REG23_FFT_START_ADDR2_SET4_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG23_FFT_START_ADDR2_SET4_SHIFT    0
#define REG_TX1_CYC_EXT_REG23_FFT_START_ADDR2_SET4_WIDTH    7

/* TX1_CYC_EXT_REG23_FFT_END_ADDR2_SET4 */
/* Option 2 End address for IFFT OpCodes set 4 */
#define REG_TX1_CYC_EXT_REG23_FFT_END_ADDR2_SET4          0x2B08C
#define REG_TX1_CYC_EXT_REG23_FFT_END_ADDR2_SET4_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG23_FFT_END_ADDR2_SET4_SHIFT    7
#define REG_TX1_CYC_EXT_REG23_FFT_END_ADDR2_SET4_WIDTH    7

/* TX1_CYC_EXT_REG24_FFT_OP_0_SET4 */
/* IFFT OpCode 0 in set 4 */
#define REG_TX1_CYC_EXT_REG24_FFT_OP_0_SET4          0x2B090
#define REG_TX1_CYC_EXT_REG24_FFT_OP_0_SET4_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG24_FFT_OP_0_SET4_SHIFT    0
#define REG_TX1_CYC_EXT_REG24_FFT_OP_0_SET4_WIDTH    6

/* TX1_CYC_EXT_REG24_FFT_OP_1_SET4 */
/* IFFT OpCode 1 in set 4 */
#define REG_TX1_CYC_EXT_REG24_FFT_OP_1_SET4          0x2B090
#define REG_TX1_CYC_EXT_REG24_FFT_OP_1_SET4_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG24_FFT_OP_1_SET4_SHIFT    6
#define REG_TX1_CYC_EXT_REG24_FFT_OP_1_SET4_WIDTH    6

/* TX1_CYC_EXT_REG24_FFT_OP_2_SET4 */
/* IFFT OpCode 2 in set 4 */
#define REG_TX1_CYC_EXT_REG24_FFT_OP_2_SET4          0x2B090
#define REG_TX1_CYC_EXT_REG24_FFT_OP_2_SET4_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG24_FFT_OP_2_SET4_SHIFT    12
#define REG_TX1_CYC_EXT_REG24_FFT_OP_2_SET4_WIDTH    6

/* TX1_CYC_EXT_REG25_FFT_START_ADDR0_SET5 */
/* Option 0 start address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR0_SET5          0x2B094
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR0_SET5_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR0_SET5_SHIFT    0
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR0_SET5_WIDTH    7

/* TX1_CYC_EXT_REG25_FFT_END_ADDR0_SET5 */
/* Option 0 End address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR0_SET5          0x2B094
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR0_SET5_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR0_SET5_SHIFT    7
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR0_SET5_WIDTH    7

/* TX1_CYC_EXT_REG25_FFT_START_ADDR1_SET5 */
/* Option 1 start address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR1_SET5          0x2B094
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR1_SET5_MASK     0x001FC000
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR1_SET5_SHIFT    14
#define REG_TX1_CYC_EXT_REG25_FFT_START_ADDR1_SET5_WIDTH    7

/* TX1_CYC_EXT_REG25_FFT_END_ADDR1_SET5 */
/* Option 1 End address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR1_SET5          0x2B094
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR1_SET5_MASK     0x0FE00000
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR1_SET5_SHIFT    21
#define REG_TX1_CYC_EXT_REG25_FFT_END_ADDR1_SET5_WIDTH    7

/* TX1_CYC_EXT_REG26_FFT_START_ADDR2_SET5 */
/* Option 2 start address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG26_FFT_START_ADDR2_SET5          0x2B098
#define REG_TX1_CYC_EXT_REG26_FFT_START_ADDR2_SET5_MASK     0x0000007F
#define REG_TX1_CYC_EXT_REG26_FFT_START_ADDR2_SET5_SHIFT    0
#define REG_TX1_CYC_EXT_REG26_FFT_START_ADDR2_SET5_WIDTH    7

/* TX1_CYC_EXT_REG26_FFT_END_ADDR2_SET5 */
/* Option 2 End address for IFFT OpCodes set 5 */
#define REG_TX1_CYC_EXT_REG26_FFT_END_ADDR2_SET5          0x2B098
#define REG_TX1_CYC_EXT_REG26_FFT_END_ADDR2_SET5_MASK     0x00003F80
#define REG_TX1_CYC_EXT_REG26_FFT_END_ADDR2_SET5_SHIFT    7
#define REG_TX1_CYC_EXT_REG26_FFT_END_ADDR2_SET5_WIDTH    7

/* TX1_CYC_EXT_REG27_FFT_OP_0_SET5 */
/* IFFT OpCode 0 in set 5 */
#define REG_TX1_CYC_EXT_REG27_FFT_OP_0_SET5          0x2B09C
#define REG_TX1_CYC_EXT_REG27_FFT_OP_0_SET5_MASK     0x0000003F
#define REG_TX1_CYC_EXT_REG27_FFT_OP_0_SET5_SHIFT    0
#define REG_TX1_CYC_EXT_REG27_FFT_OP_0_SET5_WIDTH    6

/* TX1_CYC_EXT_REG27_FFT_OP_1_SET5 */
/* IFFT OpCode 1 in set 5 */
#define REG_TX1_CYC_EXT_REG27_FFT_OP_1_SET5          0x2B09C
#define REG_TX1_CYC_EXT_REG27_FFT_OP_1_SET5_MASK     0x00000FC0
#define REG_TX1_CYC_EXT_REG27_FFT_OP_1_SET5_SHIFT    6
#define REG_TX1_CYC_EXT_REG27_FFT_OP_1_SET5_WIDTH    6

/* TX1_CYC_EXT_REG27_FFT_OP_2_SET5 */
/* IFFT OpCode 2 in set 5 */
#define REG_TX1_CYC_EXT_REG27_FFT_OP_2_SET5          0x2B09C
#define REG_TX1_CYC_EXT_REG27_FFT_OP_2_SET5_MASK     0x0003F000
#define REG_TX1_CYC_EXT_REG27_FFT_OP_2_SET5_SHIFT    12
#define REG_TX1_CYC_EXT_REG27_FFT_OP_2_SET5_WIDTH    6

/* TX1_CYC_EXT_REG2E_TONE_GEN_MODE */
/* for Tone Generation Mode enable set 1 */
#define REG_TX1_CYC_EXT_REG2E_TONE_GEN_MODE          0x2B0B8
#define REG_TX1_CYC_EXT_REG2E_TONE_GEN_MODE_MASK     0x00000002
#define REG_TX1_CYC_EXT_REG2E_TONE_GEN_MODE_SHIFT    1
#define REG_TX1_CYC_EXT_REG2E_TONE_GEN_MODE_WIDTH    1

/* TX1_CYC_EXT_REG2E_GCLK_BYPASS */
/* Disable gating of clock. Clock is free running. */
#define REG_TX1_CYC_EXT_REG2E_GCLK_BYPASS          0x2B0B8
#define REG_TX1_CYC_EXT_REG2E_GCLK_BYPASS_MASK     0x0000000c
#define REG_TX1_CYC_EXT_REG2E_GCLK_BYPASS_SHIFT    2
#define REG_TX1_CYC_EXT_REG2E_GCLK_BYPASS_WIDTH    2

/* TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_0 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_0          0x2B0C0
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_0_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_0_SHIFT    0
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_0_WIDTH    10

/* TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_1 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_1          0x2B0C0
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_1_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_1_SHIFT    16
#define REG_TX1_CYC_EXT_REG30_CYC_OUT_AMP_GAIN_1_WIDTH    10

/* TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_2 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_2          0x2B0C4
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_2_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_2_SHIFT    0
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_2_WIDTH    10

/* TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_3 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_3          0x2B0C4
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_3_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_3_SHIFT    16
#define REG_TX1_CYC_EXT_REG31_CYC_OUT_AMP_GAIN_3_WIDTH    10

/* TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_4 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_4          0x2B0C8
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_4_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_4_SHIFT    0
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_4_WIDTH    10

/* TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_5 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_5          0x2B0C8
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_5_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_5_SHIFT    16
#define REG_TX1_CYC_EXT_REG32_CYC_OUT_AMP_GAIN_5_WIDTH    10

/* TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_6 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_6          0x2B0CC
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_6_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_6_SHIFT    0
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_6_WIDTH    10

/* TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_7 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_7          0x2B0CC
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_7_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_7_SHIFT    16
#define REG_TX1_CYC_EXT_REG33_CYC_OUT_AMP_GAIN_7_WIDTH    10

/* TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_8 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_8          0x2B0D0
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_8_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_8_SHIFT    0
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_8_WIDTH    10

/* TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_9 */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_9          0x2B0D0
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_9_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_9_SHIFT    16
#define REG_TX1_CYC_EXT_REG34_CYC_OUT_AMP_GAIN_9_WIDTH    10

/* TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_A */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_A          0x2B0D4
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_A_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_A_SHIFT    0
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_A_WIDTH    10

/* TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_B */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_B          0x2B0D4
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_B_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_B_SHIFT    16
#define REG_TX1_CYC_EXT_REG35_CYC_OUT_AMP_GAIN_B_WIDTH    10

/* TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_C */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_C          0x2B0D8
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_C_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_C_SHIFT    0
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_C_WIDTH    10

/* TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_D */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_D          0x2B0D8
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_D_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_D_SHIFT    16
#define REG_TX1_CYC_EXT_REG36_CYC_OUT_AMP_GAIN_D_WIDTH    10

/* TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_E */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_E          0x2B0DC
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_E_MASK     0x000003FF
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_E_SHIFT    0
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_E_WIDTH    10

/* TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_F */
/* Amplitude gain factor value */
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_F          0x2B0DC
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_F_MASK     0x03FF0000
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_F_SHIFT    16
#define REG_TX1_CYC_EXT_REG37_CYC_OUT_AMP_GAIN_F_WIDTH    10
#endif 
