/*******************************************************************
*                                                                   
*  PHY_Tx_MAC_Emu.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_Tx_MAC_Emu_regs_H_FILE
#define PHY_Tx_MAC_Emu_regs_H_FILE

/* TX_MAC_EMU_REG00_EMU_RUN */
/* Start MAC Emualtor transmit */
#define REG_TX_MAC_EMU_REG00_EMU_RUN          0x38000
#define REG_TX_MAC_EMU_REG00_EMU_RUN_MASK     0x00000001
#define REG_TX_MAC_EMU_REG00_EMU_RUN_SHIFT    0
#define REG_TX_MAC_EMU_REG00_EMU_RUN_WIDTH    1

/* TX_MAC_EMU_REG00_EMU_TX_DONE */
/* Start MAC Emualtor transmit Done */
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE          0x38000
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_MASK     0x00000002
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_SHIFT    1
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_WIDTH    1

/* TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS */
/* Number of packets to transmit in every session. */
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS          0x38004
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_SHIFT    0
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_WIDTH    24

/* TX_MAC_EMU_REG02_ENDLESS_MODE */
/* Transmit as if number of packets equal infinity */
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE          0x38008
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_MASK     0x00000001
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_SHIFT    0
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_IN_MODE */
/* Enable including of CRC word at end of data. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_MASK     0x00000002
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_SHIFT    1
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_INVERT */
/* Enable curruption of the CRC word. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_MASK     0x00000004
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_SHIFT    2
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_REVERSE */
/* Insert the CRC bits from MSB to LSB. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_MASK     0x00000008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_SHIFT    3
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE */
/* Enable that the first N bytes will be taken  from the Prefix RAM */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_MASK     0x00000010
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_SHIFT    4
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_SET */
/* There are 2 sets of prefix data in the RAM. This selects which set. */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_MASK     0x00000020
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_SHIFT    5
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_LEN */
/* The number of prefix words to use. 0-63. 0=1 word, 63=64 words. */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_MASK     0x00003F00
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_SHIFT    8
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_WIDTH    6

/* TX_MAC_EMU_REG03_EMU_LENGTH */
/* The length (in bytes) of the packet */
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH          0x3800C
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_MASK     0x000FFFFF
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_SHIFT    0
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_WIDTH    20

/* TX_MAC_EMU_REG03_EMU_GEN_RISC0 */
/* TX MAC Emulator - gen risc spare 0 */
#define REG_TX_MAC_EMU_REG03_EMU_GEN_RISC0          0x3800C
#define REG_TX_MAC_EMU_REG03_EMU_GEN_RISC0_MASK     0xFFF00000
#define REG_TX_MAC_EMU_REG03_EMU_GEN_RISC0_SHIFT    20
#define REG_TX_MAC_EMU_REG03_EMU_GEN_RISC0_WIDTH    12

/* TX_MAC_EMU_REG04_EMU_PACKET_TYPE */
/* Set the next packet type:
0 - legacy
1- 11b
2-ht
3-vht */
#define REG_TX_MAC_EMU_REG04_EMU_PACKET_TYPE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_PACKET_TYPE_MASK     0x00000003
#define REG_TX_MAC_EMU_REG04_EMU_PACKET_TYPE_SHIFT    0
#define REG_TX_MAC_EMU_REG04_EMU_PACKET_TYPE_WIDTH    2

/* TX_MAC_EMU_REG04_EMU_CBW */
/* Set the next packets bw:
0 - 20Mhz
1- 40Mhz
2- 80Mhz
3-80+80Mhz */
#define REG_TX_MAC_EMU_REG04_EMU_CBW          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_CBW_MASK     0x0000000c
#define REG_TX_MAC_EMU_REG04_EMU_CBW_SHIFT    2
#define REG_TX_MAC_EMU_REG04_EMU_CBW_WIDTH    2

/* TX_MAC_EMU_REG04_EMU_TX_POWER */
/* select the TX power value */
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_MASK     0x000003F0
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_SHIFT    4
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_WIDTH    6

/* TX_MAC_EMU_REG04_EMU_LDPC_MODE */
/* select the TX FEC Mode */
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_MASK     0x00000400
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_SHIFT    10
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_SHORT_CP */
/* Enable packet with short cyclic prefix */
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_MASK     0x00000800
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_SHIFT    11
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_STBC */
/* Enable TX in STBC */
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_MASK     0x00001000
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_SHIFT    12
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_MCS */
/* Packet MCS */
#define REG_TX_MAC_EMU_REG04_EMU_MCS          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_MCS_MASK     0x0007e000
#define REG_TX_MAC_EMU_REG04_EMU_MCS_SHIFT    13
#define REG_TX_MAC_EMU_REG04_EMU_MCS_WIDTH    6

/* TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE */
/* Enable TX MIMO Power save */
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_MASK     0x00080000
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_SHIFT    19
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_ANT_SELECT */
/* General Purpose IF bits */
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_MASK     0x0ff00000
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_SHIFT    20
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_WIDTH    8

/* TX_MAC_EMU_REG05_EMU_CDD_OFST_1 */
/* TX cdd offset Antenna 1 */
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_MASK     0x0000000F
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_SHIFT    0
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_WIDTH    4

/* TX_MAC_EMU_REG05_EMU_CDD_OFST_2 */
/* TX cdd offset Antenna 2 */
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_MASK     0x000000F0
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_SHIFT    4
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_WIDTH    4

/* TX_MAC_EMU_REG05_EMU_BF_TYPE */
/* TX MAC Emulator - BF type:
0-bypass
1-bf
2-calibration
3-flat */
#define REG_TX_MAC_EMU_REG05_EMU_BF_TYPE          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_BF_TYPE_MASK     0x00003000
#define REG_TX_MAC_EMU_REG05_EMU_BF_TYPE_SHIFT    12
#define REG_TX_MAC_EMU_REG05_EMU_BF_TYPE_WIDTH    2

/* TX_MAC_EMU_REG05_EMU_SOUNDING */
/* TX MAC Emulator - sounding packet indication */
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_MASK     0x00010000
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_SHIFT    16
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_WIDTH    1

/* TX_MAC_EMU_REG05_EMU_GEN_RISC1 */
/* TX MAC Emulator - gen risc spare 1 */
#define REG_TX_MAC_EMU_REG05_EMU_GEN_RISC1          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_GEN_RISC1_MASK     0x7FF00000
#define REG_TX_MAC_EMU_REG05_EMU_GEN_RISC1_SHIFT    20
#define REG_TX_MAC_EMU_REG05_EMU_GEN_RISC1_WIDTH    11

/* TX_MAC_EMU_REG07_EMU_SIGNAL1 */
/* Set the next packets Signal #1 */
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1          0x3801C
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_SHIFT    0
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_WIDTH    24

/* TX_MAC_EMU_REG08_EMU_SIGNAL2 */
/* Set the next packets Signal #2 */
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2          0x38020
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_SHIFT    0
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_WIDTH    24

/* TX_MAC_EMU_REG09_EMU_SIGNAL3 */
/* Set the next packets Signal #3 */
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3          0x38024
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_SHIFT    0
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_WIDTH    24

/* TX_MAC_EMU_REG0A_EMU_PATTERN_MODE */
/* Set the next packets data pattern mode */
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_MASK     0x00000003
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_SHIFT    0
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_WIDTH    2

/* TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR */
/* Enable insertion of PRBS Errors */
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_MASK     0x00000010
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_SHIFT    4
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_WIDTH    1

/* TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM */
/* Set the error insertino rate */
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_MASK     0x0001FF00
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_SHIFT    8
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_WIDTH    9

/* TX_MAC_EMU_REG0B_EMU_PRBS_TYPE */
/* PRBS Polynom */
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE          0x3802C
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_SHIFT    0
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_WIDTH    32

/* TX_MAC_EMU_REG0C_EMU_PRBS_INIT */
/* The PRBS init data word */
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT          0x38030
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_SHIFT    0
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_WIDTH    32

/* TX_MAC_EMU_REG0D_EMU_FIXED_DATA */
/* The TX Data for Fixed pattern mode */
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA          0x38034
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_SHIFT    0
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_WIDTH    32

/* TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY */
/* Delay (in clock cycles) between PHY Enable rize and Wait for PHY Ready state */
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY          0x38038
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_MASK     0x0000FFFF
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_SHIFT    0
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_WIDTH    16

/* TX_MAC_EMU_REG0E_EMU_IPG_DLY */
/* Delay (in clock cycles) between a packet TX end to the next packet start. */
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY          0x38038
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_MASK     0xFFFF0000
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_SHIFT    16
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_WIDTH    16

/* TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC */
/* the synchronized version of pac_phy_tx_phy_enable */
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC          0x38044
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_MASK     0x80000000
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_SHIFT    31
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_WIDTH    1

/* TX_MAC_EMU_REG13_EMU_BF_HEADER10 */
/* bf_header10:mimo_ctrl,vht_mode,4'h0,implicit,sounding,report_length[8:0] */
#define REG_TX_MAC_EMU_REG13_EMU_BF_HEADER10          0x3804c
#define REG_TX_MAC_EMU_REG13_EMU_BF_HEADER10_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG13_EMU_BF_HEADER10_SHIFT    0
#define REG_TX_MAC_EMU_REG13_EMU_BF_HEADER10_WIDTH    32

/* TX_MAC_EMU_REG14_EMU_BF_HEADER32 */
/* bf_header32:mean_snr */
#define REG_TX_MAC_EMU_REG14_EMU_BF_HEADER32          0x38050
#define REG_TX_MAC_EMU_REG14_EMU_BF_HEADER32_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG14_EMU_BF_HEADER32_SHIFT    0
#define REG_TX_MAC_EMU_REG14_EMU_BF_HEADER32_WIDTH    32
#endif 
