/*******************************************************************
*                                                                   
*  RFIC.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef RFIC_regs_H_FILE
#define RFIC_regs_H_FILE

/* RFIC_SOFTWARE_RESET */
/* Writing to this register resets the RFIC */
#define REG_RFIC_SOFTWARE_RESET          0x0
#define REG_RFIC_SOFTWARE_RESET_MASK     0x00000FFF
#define REG_RFIC_SOFTWARE_RESET_SHIFT    0
#define REG_RFIC_SOFTWARE_RESET_WIDTH    12

/* RFIC_GENERAL_CONTROL */
/* Override masks */
#define REG_RFIC_GENERAL_CONTROL          0x2
#define REG_RFIC_GENERAL_CONTROL_MASK     0x00000FFF
#define REG_RFIC_GENERAL_CONTROL_SHIFT    0
#define REG_RFIC_GENERAL_CONTROL_WIDTH    12

/* RFIC_RX0_ENABLE */
/* Set to '0' for quick shutdown */
#define REG_RFIC_RX0_ENABLE          0x2
#define REG_RFIC_RX0_ENABLE_MASK     0x00000800
#define REG_RFIC_RX0_ENABLE_SHIFT    11
#define REG_RFIC_RX0_ENABLE_WIDTH    1

/* RFIC_RX0_LISTEN */
/* Only LNA and RSSI operational */
#define REG_RFIC_RX0_LISTEN          0x2
#define REG_RFIC_RX0_LISTEN_MASK     0x00000400
#define REG_RFIC_RX0_LISTEN_SHIFT    10
#define REG_RFIC_RX0_LISTEN_WIDTH    1

/* RFIC_RX1_ENABLE */
/* Set to '0' for quick shutdown */
#define REG_RFIC_RX1_ENABLE          0x2
#define REG_RFIC_RX1_ENABLE_MASK     0x00000200
#define REG_RFIC_RX1_ENABLE_SHIFT    9
#define REG_RFIC_RX1_ENABLE_WIDTH    1

/* RFIC_RX1_LISTEN */
/* Only LNA and RSSI operational */
#define REG_RFIC_RX1_LISTEN          0x2
#define REG_RFIC_RX1_LISTEN_MASK     0x00000100
#define REG_RFIC_RX1_LISTEN_SHIFT    8
#define REG_RFIC_RX1_LISTEN_WIDTH    1

/* RFIC_TX0_ENABLE */
/* Set to '0' for quick shutdown */
#define REG_RFIC_TX0_ENABLE          0x2
#define REG_RFIC_TX0_ENABLE_MASK     0x00000080
#define REG_RFIC_TX0_ENABLE_SHIFT    7
#define REG_RFIC_TX0_ENABLE_WIDTH    1

/* RFIC_TX1_ENABLE */
/* Set to '0' for quick shutdown */
#define REG_RFIC_TX1_ENABLE          0x2
#define REG_RFIC_TX1_ENABLE_MASK     0x00000040
#define REG_RFIC_TX1_ENABLE_SHIFT    6
#define REG_RFIC_TX1_ENABLE_WIDTH    1

/* RFIC_MUTE */
/* LNA's and Drivers not operational */
#define REG_RFIC_MUTE          0x2
#define REG_RFIC_MUTE_MASK     0x00000020
#define REG_RFIC_MUTE_SHIFT    5
#define REG_RFIC_MUTE_WIDTH    1

/* RFIC_CAL */
/* Set to '0' for quick shutdown */
#define REG_RFIC_CAL          0x2
#define REG_RFIC_CAL_MASK     0x00000010
#define REG_RFIC_CAL_SHIFT    4
#define REG_RFIC_CAL_WIDTH    1

/* RFIC_SYNTH_ENABLE */
/* Set to '0' for quick shutdown. '1' overrides External Synth setting */
#define REG_RFIC_SYNTH_ENABLE          0x2
#define REG_RFIC_SYNTH_ENABLE_MASK     0x00000008
#define REG_RFIC_SYNTH_ENABLE_SHIFT    3
#define REG_RFIC_SYNTH_ENABLE_WIDTH    1

/* RFIC_EXTERNAL_SYNTH */
/* Sets input buffers and Mux */
#define REG_RFIC_EXTERNAL_SYNTH          0x2
#define REG_RFIC_EXTERNAL_SYNTH_MASK     0x00000004
#define REG_RFIC_EXTERNAL_SYNTH_SHIFT    2
#define REG_RFIC_EXTERNAL_SYNTH_WIDTH    1

/* RFIC_ENABLE_SET_SELECT */
/* Select from four sets of 'Enable' Registers */
#define REG_RFIC_ENABLE_SET_SELECT          0x2
#define REG_RFIC_ENABLE_SET_SELECT_MASK     0x00000003
#define REG_RFIC_ENABLE_SET_SELECT_SHIFT    0
#define REG_RFIC_ENABLE_SET_SELECT_WIDTH    2

/* RFIC_RESERVED_GENERAL_0 */
/* Reserved */
#define REG_RFIC_RESERVED_GENERAL_0          0x4
#define REG_RFIC_RESERVED_GENERAL_0_MASK     0x00000FFF
#define REG_RFIC_RESERVED_GENERAL_0_SHIFT    0
#define REG_RFIC_RESERVED_GENERAL_0_WIDTH    12

/* RFIC_RESERVED_GENERAL_1 */
/* Reserved */
#define REG_RFIC_RESERVED_GENERAL_1          0x8
#define REG_RFIC_RESERVED_GENERAL_1_MASK     0x00000FFF
#define REG_RFIC_RESERVED_GENERAL_1_SHIFT    0
#define REG_RFIC_RESERVED_GENERAL_1_WIDTH    12

/* RFIC_ID_VERSION */
/* Read Only */
#define REG_RFIC_ID_VERSION          0xF
#define REG_RFIC_ID_VERSION_MASK     0x00000FFF
#define REG_RFIC_ID_VERSION_SHIFT    0
#define REG_RFIC_ID_VERSION_WIDTH    12

/* RFIC_BIASING_ENABLE_1_REGISTER */
#define REG_RFIC_BIASING_ENABLE_1_REGISTER          0x10
#define REG_RFIC_BIASING_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_BIASING_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_BIASING_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_VCO_VREG_ENABLE_1 */
#define REG_RFIC_VCO_VREG_ENABLE_1          0x10
#define REG_RFIC_VCO_VREG_ENABLE_1_MASK     0x00000800
#define REG_RFIC_VCO_VREG_ENABLE_1_SHIFT    11
#define REG_RFIC_VCO_VREG_ENABLE_1_WIDTH    1

/* RFIC_SYNTH_BG_ENABLE_1 */
#define REG_RFIC_SYNTH_BG_ENABLE_1          0x10
#define REG_RFIC_SYNTH_BG_ENABLE_1_MASK     0x00000400
#define REG_RFIC_SYNTH_BG_ENABLE_1_SHIFT    10
#define REG_RFIC_SYNTH_BG_ENABLE_1_WIDTH    1

/* RFIC_SYNTH_ITAT_ENABLE_1 */
#define REG_RFIC_SYNTH_ITAT_ENABLE_1          0x10
#define REG_RFIC_SYNTH_ITAT_ENABLE_1_MASK     0x00000200
#define REG_RFIC_SYNTH_ITAT_ENABLE_1_SHIFT    9
#define REG_RFIC_SYNTH_ITAT_ENABLE_1_WIDTH    1

/* RFIC_VCO_T_SENSE_ENABLE_1 */
#define REG_RFIC_VCO_T_SENSE_ENABLE_1          0x10
#define REG_RFIC_VCO_T_SENSE_ENABLE_1_MASK     0x00000100
#define REG_RFIC_VCO_T_SENSE_ENABLE_1_SHIFT    8
#define REG_RFIC_VCO_T_SENSE_ENABLE_1_WIDTH    1

/* RFIC_RX0_BB_BIAS_ENABLE_1 */
#define REG_RFIC_RX0_BB_BIAS_ENABLE_1          0x10
#define REG_RFIC_RX0_BB_BIAS_ENABLE_1_MASK     0x00000080
#define REG_RFIC_RX0_BB_BIAS_ENABLE_1_SHIFT    7
#define REG_RFIC_RX0_BB_BIAS_ENABLE_1_WIDTH    1

/* RFIC_RX0_T_SENSE_ENABLE_1 */
#define REG_RFIC_RX0_T_SENSE_ENABLE_1          0x10
#define REG_RFIC_RX0_T_SENSE_ENABLE_1_MASK     0x00000040
#define REG_RFIC_RX0_T_SENSE_ENABLE_1_SHIFT    6
#define REG_RFIC_RX0_T_SENSE_ENABLE_1_WIDTH    1

/* RFIC_TX0_BIAS_ENABLE_1 */
#define REG_RFIC_TX0_BIAS_ENABLE_1          0x10
#define REG_RFIC_TX0_BIAS_ENABLE_1_MASK     0x00000020
#define REG_RFIC_TX0_BIAS_ENABLE_1_SHIFT    5
#define REG_RFIC_TX0_BIAS_ENABLE_1_WIDTH    1

/* RFIC_TX0_CALDAC_ENABLE_1 */
#define REG_RFIC_TX0_CALDAC_ENABLE_1          0x10
#define REG_RFIC_TX0_CALDAC_ENABLE_1_MASK     0x00000010
#define REG_RFIC_TX0_CALDAC_ENABLE_1_SHIFT    4
#define REG_RFIC_TX0_CALDAC_ENABLE_1_WIDTH    1

/* RFIC_RX1_BB_BIAS_ENABLE_1 */
#define REG_RFIC_RX1_BB_BIAS_ENABLE_1          0x10
#define REG_RFIC_RX1_BB_BIAS_ENABLE_1_MASK     0x00000008
#define REG_RFIC_RX1_BB_BIAS_ENABLE_1_SHIFT    3
#define REG_RFIC_RX1_BB_BIAS_ENABLE_1_WIDTH    1

/* RFIC_RX1_T_SENSE_ENABLE_1 */
#define REG_RFIC_RX1_T_SENSE_ENABLE_1          0x10
#define REG_RFIC_RX1_T_SENSE_ENABLE_1_MASK     0x00000004
#define REG_RFIC_RX1_T_SENSE_ENABLE_1_SHIFT    2
#define REG_RFIC_RX1_T_SENSE_ENABLE_1_WIDTH    1

/* RFIC_TX1_BIAS_ENABLE_1 */
#define REG_RFIC_TX1_BIAS_ENABLE_1          0x10
#define REG_RFIC_TX1_BIAS_ENABLE_1_MASK     0x00000002
#define REG_RFIC_TX1_BIAS_ENABLE_1_SHIFT    1
#define REG_RFIC_TX1_BIAS_ENABLE_1_WIDTH    1

/* RFIC_TX1_CALDAC_ENABLE_1 */
#define REG_RFIC_TX1_CALDAC_ENABLE_1          0x10
#define REG_RFIC_TX1_CALDAC_ENABLE_1_MASK     0x00000001
#define REG_RFIC_TX1_CALDAC_ENABLE_1_SHIFT    0
#define REG_RFIC_TX1_CALDAC_ENABLE_1_WIDTH    1

/* RFIC_RX_CHANNEL_ENABLE_1_REGISTER */
#define REG_RFIC_RX_CHANNEL_ENABLE_1_REGISTER          0x11
#define REG_RFIC_RX_CHANNEL_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_CHANNEL_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_RX_CHANNEL_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_I_1 */
#define REG_RFIC_RX0_LPF_I_1          0x11
#define REG_RFIC_RX0_LPF_I_1_MASK     0x00000800
#define REG_RFIC_RX0_LPF_I_1_SHIFT    11
#define REG_RFIC_RX0_LPF_I_1_WIDTH    1

/* RFIC_RX0_LPF_Q_1 */
#define REG_RFIC_RX0_LPF_Q_1          0x11
#define REG_RFIC_RX0_LPF_Q_1_MASK     0x00000400
#define REG_RFIC_RX0_LPF_Q_1_SHIFT    10
#define REG_RFIC_RX0_LPF_Q_1_WIDTH    1

/* RFIC_RX0_VGA1_DC_ENABLE_1 */
#define REG_RFIC_RX0_VGA1_DC_ENABLE_1          0x11
#define REG_RFIC_RX0_VGA1_DC_ENABLE_1_MASK     0x00000200
#define REG_RFIC_RX0_VGA1_DC_ENABLE_1_SHIFT    9
#define REG_RFIC_RX0_VGA1_DC_ENABLE_1_WIDTH    1

/* RFIC_RX0_VGA2_DC_ENABLE_1 */
#define REG_RFIC_RX0_VGA2_DC_ENABLE_1          0x11
#define REG_RFIC_RX0_VGA2_DC_ENABLE_1_MASK     0x00000100
#define REG_RFIC_RX0_VGA2_DC_ENABLE_1_SHIFT    8
#define REG_RFIC_RX0_VGA2_DC_ENABLE_1_WIDTH    1

/* RFIC_RX0_VGA2_I_1 */
#define REG_RFIC_RX0_VGA2_I_1          0x11
#define REG_RFIC_RX0_VGA2_I_1_MASK     0x00000080
#define REG_RFIC_RX0_VGA2_I_1_SHIFT    7
#define REG_RFIC_RX0_VGA2_I_1_WIDTH    1

/* RFIC_RX0_VGA2_Q_1 */
#define REG_RFIC_RX0_VGA2_Q_1          0x11
#define REG_RFIC_RX0_VGA2_Q_1_MASK     0x00000040
#define REG_RFIC_RX0_VGA2_Q_1_SHIFT    6
#define REG_RFIC_RX0_VGA2_Q_1_WIDTH    1

/* RFIC_RX1_LPF_I_1 */
#define REG_RFIC_RX1_LPF_I_1          0x11
#define REG_RFIC_RX1_LPF_I_1_MASK     0x00000020
#define REG_RFIC_RX1_LPF_I_1_SHIFT    5
#define REG_RFIC_RX1_LPF_I_1_WIDTH    1

/* RFIC_RX1_LPF_Q_1 */
#define REG_RFIC_RX1_LPF_Q_1          0x11
#define REG_RFIC_RX1_LPF_Q_1_MASK     0x00000010
#define REG_RFIC_RX1_LPF_Q_1_SHIFT    4
#define REG_RFIC_RX1_LPF_Q_1_WIDTH    1

/* RFIC_RX1_VGA1_DC_ENABLE_1 */
#define REG_RFIC_RX1_VGA1_DC_ENABLE_1          0x11
#define REG_RFIC_RX1_VGA1_DC_ENABLE_1_MASK     0x00000008
#define REG_RFIC_RX1_VGA1_DC_ENABLE_1_SHIFT    3
#define REG_RFIC_RX1_VGA1_DC_ENABLE_1_WIDTH    1

/* RFIC_RX1_VGA2_DC_ENABLE_1 */
#define REG_RFIC_RX1_VGA2_DC_ENABLE_1          0x11
#define REG_RFIC_RX1_VGA2_DC_ENABLE_1_MASK     0x00000004
#define REG_RFIC_RX1_VGA2_DC_ENABLE_1_SHIFT    2
#define REG_RFIC_RX1_VGA2_DC_ENABLE_1_WIDTH    1

/* RFIC_RX1_VGA2_I_1 */
#define REG_RFIC_RX1_VGA2_I_1          0x11
#define REG_RFIC_RX1_VGA2_I_1_MASK     0x00000002
#define REG_RFIC_RX1_VGA2_I_1_SHIFT    1
#define REG_RFIC_RX1_VGA2_I_1_WIDTH    1

/* RFIC_RX1_VGA2_Q_1 */
#define REG_RFIC_RX1_VGA2_Q_1          0x11
#define REG_RFIC_RX1_VGA2_Q_1_MASK     0x00000001
#define REG_RFIC_RX1_VGA2_Q_1_SHIFT    0
#define REG_RFIC_RX1_VGA2_Q_1_WIDTH    1

/* RFIC_RX_BAND_ENABLE_1_REGISTER */
#define REG_RFIC_RX_BAND_ENABLE_1_REGISTER          0x12
#define REG_RFIC_RX_BAND_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_BAND_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_RX_BAND_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_RX0_VGA1_I_ENABLE_1 */
#define REG_RFIC_RX0_VGA1_I_ENABLE_1          0x12
#define REG_RFIC_RX0_VGA1_I_ENABLE_1_MASK     0x00000800
#define REG_RFIC_RX0_VGA1_I_ENABLE_1_SHIFT    11
#define REG_RFIC_RX0_VGA1_I_ENABLE_1_WIDTH    1

/* RFIC_RX0_VGA1_Q_ENABLE_1 */
#define REG_RFIC_RX0_VGA1_Q_ENABLE_1          0x12
#define REG_RFIC_RX0_VGA1_Q_ENABLE_1_MASK     0x00000400
#define REG_RFIC_RX0_VGA1_Q_ENABLE_1_SHIFT    10
#define REG_RFIC_RX0_VGA1_Q_ENABLE_1_WIDTH    1

/* RFIC_RX0_RSSI_ENABLE_1 */
#define REG_RFIC_RX0_RSSI_ENABLE_1          0x12
#define REG_RFIC_RX0_RSSI_ENABLE_1_MASK     0x00000200
#define REG_RFIC_RX0_RSSI_ENABLE_1_SHIFT    9
#define REG_RFIC_RX0_RSSI_ENABLE_1_WIDTH    1

/* RFIC_LO_RX0_ENABLE_1 */
#define REG_RFIC_LO_RX0_ENABLE_1          0x12
#define REG_RFIC_LO_RX0_ENABLE_1_MASK     0x00000100
#define REG_RFIC_LO_RX0_ENABLE_1_SHIFT    8
#define REG_RFIC_LO_RX0_ENABLE_1_WIDTH    1

/* RFIC_RX0_MIXER_ENABLE_1 */
#define REG_RFIC_RX0_MIXER_ENABLE_1          0x12
#define REG_RFIC_RX0_MIXER_ENABLE_1_MASK     0x00000080
#define REG_RFIC_RX0_MIXER_ENABLE_1_SHIFT    7
#define REG_RFIC_RX0_MIXER_ENABLE_1_WIDTH    1

/* RFIC_RX0_LNA_ENABLE_1 */
#define REG_RFIC_RX0_LNA_ENABLE_1          0x12
#define REG_RFIC_RX0_LNA_ENABLE_1_MASK     0x00000040
#define REG_RFIC_RX0_LNA_ENABLE_1_SHIFT    6
#define REG_RFIC_RX0_LNA_ENABLE_1_WIDTH    1

/* RFIC_RX1_VGA1_I_ENABLE_1 */
#define REG_RFIC_RX1_VGA1_I_ENABLE_1          0x12
#define REG_RFIC_RX1_VGA1_I_ENABLE_1_MASK     0x00000020
#define REG_RFIC_RX1_VGA1_I_ENABLE_1_SHIFT    5
#define REG_RFIC_RX1_VGA1_I_ENABLE_1_WIDTH    1

/* RFIC_RX1_VGA1_Q_ENABLE_1 */
#define REG_RFIC_RX1_VGA1_Q_ENABLE_1          0x12
#define REG_RFIC_RX1_VGA1_Q_ENABLE_1_MASK     0x00000010
#define REG_RFIC_RX1_VGA1_Q_ENABLE_1_SHIFT    4
#define REG_RFIC_RX1_VGA1_Q_ENABLE_1_WIDTH    1

/* RFIC_RX1_RSSI_ENABLE_1 */
#define REG_RFIC_RX1_RSSI_ENABLE_1          0x12
#define REG_RFIC_RX1_RSSI_ENABLE_1_MASK     0x00000008
#define REG_RFIC_RX1_RSSI_ENABLE_1_SHIFT    3
#define REG_RFIC_RX1_RSSI_ENABLE_1_WIDTH    1

/* RFIC_LO_RX1_ENABLE_1 */
#define REG_RFIC_LO_RX1_ENABLE_1          0x12
#define REG_RFIC_LO_RX1_ENABLE_1_MASK     0x00000004
#define REG_RFIC_LO_RX1_ENABLE_1_SHIFT    2
#define REG_RFIC_LO_RX1_ENABLE_1_WIDTH    1

/* RFIC_RX1_MIXER_ENABLE_1 */
#define REG_RFIC_RX1_MIXER_ENABLE_1          0x12
#define REG_RFIC_RX1_MIXER_ENABLE_1_MASK     0x00000002
#define REG_RFIC_RX1_MIXER_ENABLE_1_SHIFT    1
#define REG_RFIC_RX1_MIXER_ENABLE_1_WIDTH    1

/* RFIC_RX1_LNA_ENABLE_1 */
#define REG_RFIC_RX1_LNA_ENABLE_1          0x12
#define REG_RFIC_RX1_LNA_ENABLE_1_MASK     0x00000001
#define REG_RFIC_RX1_LNA_ENABLE_1_SHIFT    0
#define REG_RFIC_RX1_LNA_ENABLE_1_WIDTH    1

/* RFIC_TX_ENABLE_1_REGISTER */
#define REG_RFIC_TX_ENABLE_1_REGISTER          0x13
#define REG_RFIC_TX_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_TX_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_LPF_TX0_I_1 */
#define REG_RFIC_LPF_TX0_I_1          0x13
#define REG_RFIC_LPF_TX0_I_1_MASK     0x00000800
#define REG_RFIC_LPF_TX0_I_1_SHIFT    11
#define REG_RFIC_LPF_TX0_I_1_WIDTH    1

/* RFIC_LPF_TX0_Q_1 */
#define REG_RFIC_LPF_TX0_Q_1          0x13
#define REG_RFIC_LPF_TX0_Q_1_MASK     0x00000400
#define REG_RFIC_LPF_TX0_Q_1_SHIFT    10
#define REG_RFIC_LPF_TX0_Q_1_WIDTH    1

/* RFIC_UPCONV_TX0_1 */
#define REG_RFIC_UPCONV_TX0_1          0x13
#define REG_RFIC_UPCONV_TX0_1_MASK     0x00000200
#define REG_RFIC_UPCONV_TX0_1_SHIFT    9
#define REG_RFIC_UPCONV_TX0_1_WIDTH    1

/* RFIC_TPC_TX0_1 */
#define REG_RFIC_TPC_TX0_1          0x13
#define REG_RFIC_TPC_TX0_1_MASK     0x00000100
#define REG_RFIC_TPC_TX0_1_SHIFT    8
#define REG_RFIC_TPC_TX0_1_WIDTH    1

/* RFIC_LO_TX0_ENABLE_1 */
#define REG_RFIC_LO_TX0_ENABLE_1          0x13
#define REG_RFIC_LO_TX0_ENABLE_1_MASK     0x00000080
#define REG_RFIC_LO_TX0_ENABLE_1_SHIFT    7
#define REG_RFIC_LO_TX0_ENABLE_1_WIDTH    1

/* RFIC_DRIVER_TX0_1 */
#define REG_RFIC_DRIVER_TX0_1          0x13
#define REG_RFIC_DRIVER_TX0_1_MASK     0x00000040
#define REG_RFIC_DRIVER_TX0_1_SHIFT    6
#define REG_RFIC_DRIVER_TX0_1_WIDTH    1

/* RFIC_LPF_TX1_I_1 */
#define REG_RFIC_LPF_TX1_I_1          0x13
#define REG_RFIC_LPF_TX1_I_1_MASK     0x00000020
#define REG_RFIC_LPF_TX1_I_1_SHIFT    5
#define REG_RFIC_LPF_TX1_I_1_WIDTH    1

/* RFIC_LPF_TX1_Q_1 */
#define REG_RFIC_LPF_TX1_Q_1          0x13
#define REG_RFIC_LPF_TX1_Q_1_MASK     0x00000010
#define REG_RFIC_LPF_TX1_Q_1_SHIFT    4
#define REG_RFIC_LPF_TX1_Q_1_WIDTH    1

/* RFIC_UPCONV_TX1_1 */
#define REG_RFIC_UPCONV_TX1_1          0x13
#define REG_RFIC_UPCONV_TX1_1_MASK     0x00000008
#define REG_RFIC_UPCONV_TX1_1_SHIFT    3
#define REG_RFIC_UPCONV_TX1_1_WIDTH    1

/* RFIC_TPC_TX1_1 */
#define REG_RFIC_TPC_TX1_1          0x13
#define REG_RFIC_TPC_TX1_1_MASK     0x00000004
#define REG_RFIC_TPC_TX1_1_SHIFT    2
#define REG_RFIC_TPC_TX1_1_WIDTH    1

/* RFIC_LO_TX1_ENABLE_1 */
#define REG_RFIC_LO_TX1_ENABLE_1          0x13
#define REG_RFIC_LO_TX1_ENABLE_1_MASK     0x00000002
#define REG_RFIC_LO_TX1_ENABLE_1_SHIFT    1
#define REG_RFIC_LO_TX1_ENABLE_1_WIDTH    1

/* RFIC_DRIVER_TX1_1 */
#define REG_RFIC_DRIVER_TX1_1          0x13
#define REG_RFIC_DRIVER_TX1_1_MASK     0x00000001
#define REG_RFIC_DRIVER_TX1_1_SHIFT    0
#define REG_RFIC_DRIVER_TX1_1_WIDTH    1

/* RFIC_SYNTH_ENABLE_1_REGISTER */
#define REG_RFIC_SYNTH_ENABLE_1_REGISTER          0x14
#define REG_RFIC_SYNTH_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_SYNTH_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_VCO_ENABLE_1 */
#define REG_RFIC_VCO_ENABLE_1          0x14
#define REG_RFIC_VCO_ENABLE_1_MASK     0x00000800
#define REG_RFIC_VCO_ENABLE_1_SHIFT    11
#define REG_RFIC_VCO_ENABLE_1_WIDTH    1

/* RFIC_VCO_MUX_ENABLE_1 */
#define REG_RFIC_VCO_MUX_ENABLE_1          0x14
#define REG_RFIC_VCO_MUX_ENABLE_1_MASK     0x00000400
#define REG_RFIC_VCO_MUX_ENABLE_1_SHIFT    10
#define REG_RFIC_VCO_MUX_ENABLE_1_WIDTH    1

/* RFIC_DIV_2_ENABLE_1 */
#define REG_RFIC_DIV_2_ENABLE_1          0x14
#define REG_RFIC_DIV_2_ENABLE_1_MASK     0x00000200
#define REG_RFIC_DIV_2_ENABLE_1_SHIFT    9
#define REG_RFIC_DIV_2_ENABLE_1_WIDTH    1

/* RFIC_LO_CHAIN_ENABLE_1 */
#define REG_RFIC_LO_CHAIN_ENABLE_1          0x14
#define REG_RFIC_LO_CHAIN_ENABLE_1_MASK     0x00000100
#define REG_RFIC_LO_CHAIN_ENABLE_1_SHIFT    8
#define REG_RFIC_LO_CHAIN_ENABLE_1_WIDTH    1

/* RFIC_VCO_O_BUF_ENABLE_1 */
#define REG_RFIC_VCO_O_BUF_ENABLE_1          0x14
#define REG_RFIC_VCO_O_BUF_ENABLE_1_MASK     0x00000080
#define REG_RFIC_VCO_O_BUF_ENABLE_1_SHIFT    7
#define REG_RFIC_VCO_O_BUF_ENABLE_1_WIDTH    1

/* RFIC_VCO_I_BUF_ENABLE_1 */
#define REG_RFIC_VCO_I_BUF_ENABLE_1          0x14
#define REG_RFIC_VCO_I_BUF_ENABLE_1_MASK     0x00000040
#define REG_RFIC_VCO_I_BUF_ENABLE_1_SHIFT    6
#define REG_RFIC_VCO_I_BUF_ENABLE_1_WIDTH    1

/* RFIC_SPARE_ENABLE_1 */
#define REG_RFIC_SPARE_ENABLE_1          0x14
#define REG_RFIC_SPARE_ENABLE_1_MASK     0x00000030
#define REG_RFIC_SPARE_ENABLE_1_SHIFT    4
#define REG_RFIC_SPARE_ENABLE_1_WIDTH    2

/* RFIC_MAIN_DIV_ENABLE_1 */
#define REG_RFIC_MAIN_DIV_ENABLE_1          0x14
#define REG_RFIC_MAIN_DIV_ENABLE_1_MASK     0x00000008
#define REG_RFIC_MAIN_DIV_ENABLE_1_SHIFT    3
#define REG_RFIC_MAIN_DIV_ENABLE_1_WIDTH    1

/* RFIC_REF_DIV_ENABLE_1 */
#define REG_RFIC_REF_DIV_ENABLE_1          0x14
#define REG_RFIC_REF_DIV_ENABLE_1_MASK     0x00000004
#define REG_RFIC_REF_DIV_ENABLE_1_SHIFT    2
#define REG_RFIC_REF_DIV_ENABLE_1_WIDTH    1

/* RFIC_MOR_ENABLE_1 */
#define REG_RFIC_MOR_ENABLE_1          0x14
#define REG_RFIC_MOR_ENABLE_1_MASK     0x00000002
#define REG_RFIC_MOR_ENABLE_1_SHIFT    1
#define REG_RFIC_MOR_ENABLE_1_WIDTH    1

/* RFIC_CP_ENABLE_1 */
#define REG_RFIC_CP_ENABLE_1          0x14
#define REG_RFIC_CP_ENABLE_1_MASK     0x00000001
#define REG_RFIC_CP_ENABLE_1_SHIFT    0
#define REG_RFIC_CP_ENABLE_1_WIDTH    1

/* RFIC_BIASING_ENABLE_2_REGISTER */
#define REG_RFIC_BIASING_ENABLE_2_REGISTER          0x15
#define REG_RFIC_BIASING_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_BIASING_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_BIASING_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_VCO_VREG_ENABLE_2 */
#define REG_RFIC_VCO_VREG_ENABLE_2          0x15
#define REG_RFIC_VCO_VREG_ENABLE_2_MASK     0x00000800
#define REG_RFIC_VCO_VREG_ENABLE_2_SHIFT    11
#define REG_RFIC_VCO_VREG_ENABLE_2_WIDTH    1

/* RFIC_SYNTH_BG_ENABLE_2 */
#define REG_RFIC_SYNTH_BG_ENABLE_2          0x15
#define REG_RFIC_SYNTH_BG_ENABLE_2_MASK     0x00000400
#define REG_RFIC_SYNTH_BG_ENABLE_2_SHIFT    10
#define REG_RFIC_SYNTH_BG_ENABLE_2_WIDTH    1

/* RFIC_SYNTH_ITAT_ENABLE_2 */
#define REG_RFIC_SYNTH_ITAT_ENABLE_2          0x15
#define REG_RFIC_SYNTH_ITAT_ENABLE_2_MASK     0x00000200
#define REG_RFIC_SYNTH_ITAT_ENABLE_2_SHIFT    9
#define REG_RFIC_SYNTH_ITAT_ENABLE_2_WIDTH    1

/* RFIC_VCO_T_SENSE_ENABLE_2 */
#define REG_RFIC_VCO_T_SENSE_ENABLE_2          0x15
#define REG_RFIC_VCO_T_SENSE_ENABLE_2_MASK     0x00000100
#define REG_RFIC_VCO_T_SENSE_ENABLE_2_SHIFT    8
#define REG_RFIC_VCO_T_SENSE_ENABLE_2_WIDTH    1

/* RFIC_RX0_BB_BIAS_ENABLE_2 */
#define REG_RFIC_RX0_BB_BIAS_ENABLE_2          0x15
#define REG_RFIC_RX0_BB_BIAS_ENABLE_2_MASK     0x00000080
#define REG_RFIC_RX0_BB_BIAS_ENABLE_2_SHIFT    7
#define REG_RFIC_RX0_BB_BIAS_ENABLE_2_WIDTH    1

/* RFIC_RX0_T_SENSE_ENABLE_2 */
#define REG_RFIC_RX0_T_SENSE_ENABLE_2          0x15
#define REG_RFIC_RX0_T_SENSE_ENABLE_2_MASK     0x00000040
#define REG_RFIC_RX0_T_SENSE_ENABLE_2_SHIFT    6
#define REG_RFIC_RX0_T_SENSE_ENABLE_2_WIDTH    1

/* RFIC_TX0_BIAS_ENABLE_2 */
#define REG_RFIC_TX0_BIAS_ENABLE_2          0x15
#define REG_RFIC_TX0_BIAS_ENABLE_2_MASK     0x00000020
#define REG_RFIC_TX0_BIAS_ENABLE_2_SHIFT    5
#define REG_RFIC_TX0_BIAS_ENABLE_2_WIDTH    1

/* RFIC_TX0_CALDAC_ENABLE_2 */
#define REG_RFIC_TX0_CALDAC_ENABLE_2          0x15
#define REG_RFIC_TX0_CALDAC_ENABLE_2_MASK     0x00000010
#define REG_RFIC_TX0_CALDAC_ENABLE_2_SHIFT    4
#define REG_RFIC_TX0_CALDAC_ENABLE_2_WIDTH    1

/* RFIC_RX1_BB_BIAS_ENABLE_2 */
#define REG_RFIC_RX1_BB_BIAS_ENABLE_2          0x15
#define REG_RFIC_RX1_BB_BIAS_ENABLE_2_MASK     0x00000008
#define REG_RFIC_RX1_BB_BIAS_ENABLE_2_SHIFT    3
#define REG_RFIC_RX1_BB_BIAS_ENABLE_2_WIDTH    1

/* RFIC_RX1_T_SENSE_ENABLE_2 */
#define REG_RFIC_RX1_T_SENSE_ENABLE_2          0x15
#define REG_RFIC_RX1_T_SENSE_ENABLE_2_MASK     0x00000004
#define REG_RFIC_RX1_T_SENSE_ENABLE_2_SHIFT    2
#define REG_RFIC_RX1_T_SENSE_ENABLE_2_WIDTH    1

/* RFIC_TX1_BIAS_ENABLE_2 */
#define REG_RFIC_TX1_BIAS_ENABLE_2          0x15
#define REG_RFIC_TX1_BIAS_ENABLE_2_MASK     0x00000002
#define REG_RFIC_TX1_BIAS_ENABLE_2_SHIFT    1
#define REG_RFIC_TX1_BIAS_ENABLE_2_WIDTH    1

/* RFIC_TX1_CALDAC_ENABLE_2 */
#define REG_RFIC_TX1_CALDAC_ENABLE_2          0x15
#define REG_RFIC_TX1_CALDAC_ENABLE_2_MASK     0x00000001
#define REG_RFIC_TX1_CALDAC_ENABLE_2_SHIFT    0
#define REG_RFIC_TX1_CALDAC_ENABLE_2_WIDTH    1

/* RFIC_RX_CHANNEL_ENABLE_2_REGISTER */
#define REG_RFIC_RX_CHANNEL_ENABLE_2_REGISTER          0x16
#define REG_RFIC_RX_CHANNEL_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_CHANNEL_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_RX_CHANNEL_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_I_2 */
#define REG_RFIC_RX0_LPF_I_2          0x16
#define REG_RFIC_RX0_LPF_I_2_MASK     0x00000800
#define REG_RFIC_RX0_LPF_I_2_SHIFT    11
#define REG_RFIC_RX0_LPF_I_2_WIDTH    1

/* RFIC_RX0_LPF_Q_2 */
#define REG_RFIC_RX0_LPF_Q_2          0x16
#define REG_RFIC_RX0_LPF_Q_2_MASK     0x00000400
#define REG_RFIC_RX0_LPF_Q_2_SHIFT    10
#define REG_RFIC_RX0_LPF_Q_2_WIDTH    1

/* RFIC_RX0_VGA1_DC_ENABLE_2 */
#define REG_RFIC_RX0_VGA1_DC_ENABLE_2          0x16
#define REG_RFIC_RX0_VGA1_DC_ENABLE_2_MASK     0x00000200
#define REG_RFIC_RX0_VGA1_DC_ENABLE_2_SHIFT    9
#define REG_RFIC_RX0_VGA1_DC_ENABLE_2_WIDTH    1

/* RFIC_RX0_VGA2_DC_ENABLE_2 */
#define REG_RFIC_RX0_VGA2_DC_ENABLE_2          0x16
#define REG_RFIC_RX0_VGA2_DC_ENABLE_2_MASK     0x00000100
#define REG_RFIC_RX0_VGA2_DC_ENABLE_2_SHIFT    8
#define REG_RFIC_RX0_VGA2_DC_ENABLE_2_WIDTH    1

/* RFIC_RX0_VGA2_I_2 */
#define REG_RFIC_RX0_VGA2_I_2          0x16
#define REG_RFIC_RX0_VGA2_I_2_MASK     0x00000080
#define REG_RFIC_RX0_VGA2_I_2_SHIFT    7
#define REG_RFIC_RX0_VGA2_I_2_WIDTH    1

/* RFIC_RX0_VGA2_Q_2 */
#define REG_RFIC_RX0_VGA2_Q_2          0x16
#define REG_RFIC_RX0_VGA2_Q_2_MASK     0x00000040
#define REG_RFIC_RX0_VGA2_Q_2_SHIFT    6
#define REG_RFIC_RX0_VGA2_Q_2_WIDTH    1

/* RFIC_RX1_LPF_I_2 */
#define REG_RFIC_RX1_LPF_I_2          0x16
#define REG_RFIC_RX1_LPF_I_2_MASK     0x00000020
#define REG_RFIC_RX1_LPF_I_2_SHIFT    5
#define REG_RFIC_RX1_LPF_I_2_WIDTH    1

/* RFIC_RX1_LPF_Q_2 */
#define REG_RFIC_RX1_LPF_Q_2          0x16
#define REG_RFIC_RX1_LPF_Q_2_MASK     0x00000010
#define REG_RFIC_RX1_LPF_Q_2_SHIFT    4
#define REG_RFIC_RX1_LPF_Q_2_WIDTH    1

/* RFIC_RX1_VGA1_DC_ENABLE_2 */
#define REG_RFIC_RX1_VGA1_DC_ENABLE_2          0x16
#define REG_RFIC_RX1_VGA1_DC_ENABLE_2_MASK     0x00000008
#define REG_RFIC_RX1_VGA1_DC_ENABLE_2_SHIFT    3
#define REG_RFIC_RX1_VGA1_DC_ENABLE_2_WIDTH    1

/* RFIC_RX1_VGA2_DC_ENABLE_2 */
#define REG_RFIC_RX1_VGA2_DC_ENABLE_2          0x16
#define REG_RFIC_RX1_VGA2_DC_ENABLE_2_MASK     0x00000004
#define REG_RFIC_RX1_VGA2_DC_ENABLE_2_SHIFT    2
#define REG_RFIC_RX1_VGA2_DC_ENABLE_2_WIDTH    1

/* RFIC_RX1_VGA2_I_2 */
#define REG_RFIC_RX1_VGA2_I_2          0x16
#define REG_RFIC_RX1_VGA2_I_2_MASK     0x00000002
#define REG_RFIC_RX1_VGA2_I_2_SHIFT    1
#define REG_RFIC_RX1_VGA2_I_2_WIDTH    1

/* RFIC_RX1_VGA2_Q_2 */
#define REG_RFIC_RX1_VGA2_Q_2          0x16
#define REG_RFIC_RX1_VGA2_Q_2_MASK     0x00000001
#define REG_RFIC_RX1_VGA2_Q_2_SHIFT    0
#define REG_RFIC_RX1_VGA2_Q_2_WIDTH    1

/* RFIC_RX_BAND_ENABLE_2_REGISTER */
#define REG_RFIC_RX_BAND_ENABLE_2_REGISTER          0x17
#define REG_RFIC_RX_BAND_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_BAND_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_RX_BAND_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_RX0_VGA1_I_ENABLE_2 */
#define REG_RFIC_RX0_VGA1_I_ENABLE_2          0x17
#define REG_RFIC_RX0_VGA1_I_ENABLE_2_MASK     0x00000800
#define REG_RFIC_RX0_VGA1_I_ENABLE_2_SHIFT    11
#define REG_RFIC_RX0_VGA1_I_ENABLE_2_WIDTH    1

/* RFIC_RX0_VGA1_Q_ENABLE_2 */
#define REG_RFIC_RX0_VGA1_Q_ENABLE_2          0x17
#define REG_RFIC_RX0_VGA1_Q_ENABLE_2_MASK     0x00000400
#define REG_RFIC_RX0_VGA1_Q_ENABLE_2_SHIFT    10
#define REG_RFIC_RX0_VGA1_Q_ENABLE_2_WIDTH    1

/* RFIC_RX0_RSSI_ENABLE_2 */
#define REG_RFIC_RX0_RSSI_ENABLE_2          0x17
#define REG_RFIC_RX0_RSSI_ENABLE_2_MASK     0x00000200
#define REG_RFIC_RX0_RSSI_ENABLE_2_SHIFT    9
#define REG_RFIC_RX0_RSSI_ENABLE_2_WIDTH    1

/* RFIC_LO_RX0_ENABLE_2 */
#define REG_RFIC_LO_RX0_ENABLE_2          0x17
#define REG_RFIC_LO_RX0_ENABLE_2_MASK     0x00000100
#define REG_RFIC_LO_RX0_ENABLE_2_SHIFT    8
#define REG_RFIC_LO_RX0_ENABLE_2_WIDTH    1

/* RFIC_RX0_MIXER_ENABLE_2 */
#define REG_RFIC_RX0_MIXER_ENABLE_2          0x17
#define REG_RFIC_RX0_MIXER_ENABLE_2_MASK     0x00000080
#define REG_RFIC_RX0_MIXER_ENABLE_2_SHIFT    7
#define REG_RFIC_RX0_MIXER_ENABLE_2_WIDTH    1

/* RFIC_RX0_LNA_ENABLE_2 */
#define REG_RFIC_RX0_LNA_ENABLE_2          0x17
#define REG_RFIC_RX0_LNA_ENABLE_2_MASK     0x00000040
#define REG_RFIC_RX0_LNA_ENABLE_2_SHIFT    6
#define REG_RFIC_RX0_LNA_ENABLE_2_WIDTH    1

/* RFIC_RX1_VGA1_I_ENABLE_2 */
#define REG_RFIC_RX1_VGA1_I_ENABLE_2          0x17
#define REG_RFIC_RX1_VGA1_I_ENABLE_2_MASK     0x00000020
#define REG_RFIC_RX1_VGA1_I_ENABLE_2_SHIFT    5
#define REG_RFIC_RX1_VGA1_I_ENABLE_2_WIDTH    1

/* RFIC_RX1_VGA1_Q_ENABLE_2 */
#define REG_RFIC_RX1_VGA1_Q_ENABLE_2          0x17
#define REG_RFIC_RX1_VGA1_Q_ENABLE_2_MASK     0x00000010
#define REG_RFIC_RX1_VGA1_Q_ENABLE_2_SHIFT    4
#define REG_RFIC_RX1_VGA1_Q_ENABLE_2_WIDTH    1

/* RFIC_RX1_RSSI_ENABLE_2 */
#define REG_RFIC_RX1_RSSI_ENABLE_2          0x17
#define REG_RFIC_RX1_RSSI_ENABLE_2_MASK     0x00000008
#define REG_RFIC_RX1_RSSI_ENABLE_2_SHIFT    3
#define REG_RFIC_RX1_RSSI_ENABLE_2_WIDTH    1

/* RFIC_LO_RX1_ENABLE_2 */
#define REG_RFIC_LO_RX1_ENABLE_2          0x17
#define REG_RFIC_LO_RX1_ENABLE_2_MASK     0x00000004
#define REG_RFIC_LO_RX1_ENABLE_2_SHIFT    2
#define REG_RFIC_LO_RX1_ENABLE_2_WIDTH    1

/* RFIC_RX1_MIXER_ENABLE_2 */
#define REG_RFIC_RX1_MIXER_ENABLE_2          0x17
#define REG_RFIC_RX1_MIXER_ENABLE_2_MASK     0x00000002
#define REG_RFIC_RX1_MIXER_ENABLE_2_SHIFT    1
#define REG_RFIC_RX1_MIXER_ENABLE_2_WIDTH    1

/* RFIC_RX1_LNA_ENABLE_2 */
#define REG_RFIC_RX1_LNA_ENABLE_2          0x17
#define REG_RFIC_RX1_LNA_ENABLE_2_MASK     0x00000001
#define REG_RFIC_RX1_LNA_ENABLE_2_SHIFT    0
#define REG_RFIC_RX1_LNA_ENABLE_2_WIDTH    1

/* RFIC_TX_ENABLE_2_REGISTER */
#define REG_RFIC_TX_ENABLE_2_REGISTER          0x18
#define REG_RFIC_TX_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_TX_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_LPF_TX0_I_2 */
#define REG_RFIC_LPF_TX0_I_2          0x18
#define REG_RFIC_LPF_TX0_I_2_MASK     0x00000800
#define REG_RFIC_LPF_TX0_I_2_SHIFT    11
#define REG_RFIC_LPF_TX0_I_2_WIDTH    1

/* RFIC_LPF_TX0_Q_2 */
#define REG_RFIC_LPF_TX0_Q_2          0x18
#define REG_RFIC_LPF_TX0_Q_2_MASK     0x00000400
#define REG_RFIC_LPF_TX0_Q_2_SHIFT    10
#define REG_RFIC_LPF_TX0_Q_2_WIDTH    1

/* RFIC_UPCONV_TX0_2 */
#define REG_RFIC_UPCONV_TX0_2          0x18
#define REG_RFIC_UPCONV_TX0_2_MASK     0x00000200
#define REG_RFIC_UPCONV_TX0_2_SHIFT    9
#define REG_RFIC_UPCONV_TX0_2_WIDTH    1

/* RFIC_TPC_TX0_2 */
#define REG_RFIC_TPC_TX0_2          0x18
#define REG_RFIC_TPC_TX0_2_MASK     0x00000100
#define REG_RFIC_TPC_TX0_2_SHIFT    8
#define REG_RFIC_TPC_TX0_2_WIDTH    1

/* RFIC_LO_TX0_ENABLE_2 */
#define REG_RFIC_LO_TX0_ENABLE_2          0x18
#define REG_RFIC_LO_TX0_ENABLE_2_MASK     0x00000080
#define REG_RFIC_LO_TX0_ENABLE_2_SHIFT    7
#define REG_RFIC_LO_TX0_ENABLE_2_WIDTH    1

/* RFIC_DRIVER_TX0_2 */
#define REG_RFIC_DRIVER_TX0_2          0x18
#define REG_RFIC_DRIVER_TX0_2_MASK     0x00000040
#define REG_RFIC_DRIVER_TX0_2_SHIFT    6
#define REG_RFIC_DRIVER_TX0_2_WIDTH    1

/* RFIC_LPF_TX1_I_2 */
#define REG_RFIC_LPF_TX1_I_2          0x18
#define REG_RFIC_LPF_TX1_I_2_MASK     0x00000020
#define REG_RFIC_LPF_TX1_I_2_SHIFT    5
#define REG_RFIC_LPF_TX1_I_2_WIDTH    1

/* RFIC_LPF_TX1_Q_2 */
#define REG_RFIC_LPF_TX1_Q_2          0x18
#define REG_RFIC_LPF_TX1_Q_2_MASK     0x00000010
#define REG_RFIC_LPF_TX1_Q_2_SHIFT    4
#define REG_RFIC_LPF_TX1_Q_2_WIDTH    1

/* RFIC_UPCONV_TX1_2 */
#define REG_RFIC_UPCONV_TX1_2          0x18
#define REG_RFIC_UPCONV_TX1_2_MASK     0x00000008
#define REG_RFIC_UPCONV_TX1_2_SHIFT    3
#define REG_RFIC_UPCONV_TX1_2_WIDTH    1

/* RFIC_TPC_TX1_2 */
#define REG_RFIC_TPC_TX1_2          0x18
#define REG_RFIC_TPC_TX1_2_MASK     0x00000004
#define REG_RFIC_TPC_TX1_2_SHIFT    2
#define REG_RFIC_TPC_TX1_2_WIDTH    1

/* RFIC_LO_TX1_ENABLE_2 */
#define REG_RFIC_LO_TX1_ENABLE_2          0x18
#define REG_RFIC_LO_TX1_ENABLE_2_MASK     0x00000002
#define REG_RFIC_LO_TX1_ENABLE_2_SHIFT    1
#define REG_RFIC_LO_TX1_ENABLE_2_WIDTH    1

/* RFIC_DRIVER_TX1_2 */
#define REG_RFIC_DRIVER_TX1_2          0x18
#define REG_RFIC_DRIVER_TX1_2_MASK     0x00000001
#define REG_RFIC_DRIVER_TX1_2_SHIFT    0
#define REG_RFIC_DRIVER_TX1_2_WIDTH    1

/* RFIC_SYNTH_ENABLE_2_REGISTER */
#define REG_RFIC_SYNTH_ENABLE_2_REGISTER          0x19
#define REG_RFIC_SYNTH_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_SYNTH_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_VCO_ENABLE_2 */
#define REG_RFIC_VCO_ENABLE_2          0x19
#define REG_RFIC_VCO_ENABLE_2_MASK     0x00000800
#define REG_RFIC_VCO_ENABLE_2_SHIFT    11
#define REG_RFIC_VCO_ENABLE_2_WIDTH    1

/* RFIC_VCO_MUX_ENABLE_2 */
#define REG_RFIC_VCO_MUX_ENABLE_2          0x19
#define REG_RFIC_VCO_MUX_ENABLE_2_MASK     0x00000400
#define REG_RFIC_VCO_MUX_ENABLE_2_SHIFT    10
#define REG_RFIC_VCO_MUX_ENABLE_2_WIDTH    1

/* RFIC_DIV_2_ENABLE_2 */
#define REG_RFIC_DIV_2_ENABLE_2          0x19
#define REG_RFIC_DIV_2_ENABLE_2_MASK     0x00000200
#define REG_RFIC_DIV_2_ENABLE_2_SHIFT    9
#define REG_RFIC_DIV_2_ENABLE_2_WIDTH    1

/* RFIC_LO_CHAIN_ENABLE_2 */
#define REG_RFIC_LO_CHAIN_ENABLE_2          0x19
#define REG_RFIC_LO_CHAIN_ENABLE_2_MASK     0x00000100
#define REG_RFIC_LO_CHAIN_ENABLE_2_SHIFT    8
#define REG_RFIC_LO_CHAIN_ENABLE_2_WIDTH    1

/* RFIC_VCO_O_BUF_ENABLE_2 */
#define REG_RFIC_VCO_O_BUF_ENABLE_2          0x19
#define REG_RFIC_VCO_O_BUF_ENABLE_2_MASK     0x00000080
#define REG_RFIC_VCO_O_BUF_ENABLE_2_SHIFT    7
#define REG_RFIC_VCO_O_BUF_ENABLE_2_WIDTH    1

/* RFIC_VCO_I_BUF_ENABLE_2 */
#define REG_RFIC_VCO_I_BUF_ENABLE_2          0x19
#define REG_RFIC_VCO_I_BUF_ENABLE_2_MASK     0x00000040
#define REG_RFIC_VCO_I_BUF_ENABLE_2_SHIFT    6
#define REG_RFIC_VCO_I_BUF_ENABLE_2_WIDTH    1

/* RFIC_SPARE_ENABLE_2 */
#define REG_RFIC_SPARE_ENABLE_2          0x19
#define REG_RFIC_SPARE_ENABLE_2_MASK     0x00000030
#define REG_RFIC_SPARE_ENABLE_2_SHIFT    4
#define REG_RFIC_SPARE_ENABLE_2_WIDTH    2

/* RFIC_MAIN_DIV_ENABLE_2 */
#define REG_RFIC_MAIN_DIV_ENABLE_2          0x19
#define REG_RFIC_MAIN_DIV_ENABLE_2_MASK     0x00000008
#define REG_RFIC_MAIN_DIV_ENABLE_2_SHIFT    3
#define REG_RFIC_MAIN_DIV_ENABLE_2_WIDTH    1

/* RFIC_REF_DIV_ENABLE_2 */
#define REG_RFIC_REF_DIV_ENABLE_2          0x19
#define REG_RFIC_REF_DIV_ENABLE_2_MASK     0x00000004
#define REG_RFIC_REF_DIV_ENABLE_2_SHIFT    2
#define REG_RFIC_REF_DIV_ENABLE_2_WIDTH    1

/* RFIC_MOR_ENABLE_2 */
#define REG_RFIC_MOR_ENABLE_2          0x19
#define REG_RFIC_MOR_ENABLE_2_MASK     0x00000002
#define REG_RFIC_MOR_ENABLE_2_SHIFT    1
#define REG_RFIC_MOR_ENABLE_2_WIDTH    1

/* RFIC_CP_ENABLE_2 */
#define REG_RFIC_CP_ENABLE_2          0x19
#define REG_RFIC_CP_ENABLE_2_MASK     0x00000001
#define REG_RFIC_CP_ENABLE_2_SHIFT    0
#define REG_RFIC_CP_ENABLE_2_WIDTH    1

/* RFIC_BIASING_ENABLE_3_REGISTER */
#define REG_RFIC_BIASING_ENABLE_3_REGISTER          0x1A
#define REG_RFIC_BIASING_ENABLE_3_REGISTER_MASK     0x00000FFF
#define REG_RFIC_BIASING_ENABLE_3_REGISTER_SHIFT    0
#define REG_RFIC_BIASING_ENABLE_3_REGISTER_WIDTH    12

/* RFIC_VCO_VREG_ENABLE_3 */
#define REG_RFIC_VCO_VREG_ENABLE_3          0x1A
#define REG_RFIC_VCO_VREG_ENABLE_3_MASK     0x00000800
#define REG_RFIC_VCO_VREG_ENABLE_3_SHIFT    11
#define REG_RFIC_VCO_VREG_ENABLE_3_WIDTH    1

/* RFIC_SYNTH_BG_ENABLE_3 */
#define REG_RFIC_SYNTH_BG_ENABLE_3          0x1A
#define REG_RFIC_SYNTH_BG_ENABLE_3_MASK     0x00000400
#define REG_RFIC_SYNTH_BG_ENABLE_3_SHIFT    10
#define REG_RFIC_SYNTH_BG_ENABLE_3_WIDTH    1

/* RFIC_SYNTH_ITAT_ENABLE_3 */
#define REG_RFIC_SYNTH_ITAT_ENABLE_3          0x1A
#define REG_RFIC_SYNTH_ITAT_ENABLE_3_MASK     0x00000200
#define REG_RFIC_SYNTH_ITAT_ENABLE_3_SHIFT    9
#define REG_RFIC_SYNTH_ITAT_ENABLE_3_WIDTH    1

/* RFIC_VCO_T_SENSE_ENABLE_3 */
#define REG_RFIC_VCO_T_SENSE_ENABLE_3          0x1A
#define REG_RFIC_VCO_T_SENSE_ENABLE_3_MASK     0x00000100
#define REG_RFIC_VCO_T_SENSE_ENABLE_3_SHIFT    8
#define REG_RFIC_VCO_T_SENSE_ENABLE_3_WIDTH    1

/* RFIC_RX0_BB_BIAS_ENABLE_3 */
#define REG_RFIC_RX0_BB_BIAS_ENABLE_3          0x1A
#define REG_RFIC_RX0_BB_BIAS_ENABLE_3_MASK     0x00000080
#define REG_RFIC_RX0_BB_BIAS_ENABLE_3_SHIFT    7
#define REG_RFIC_RX0_BB_BIAS_ENABLE_3_WIDTH    1

/* RFIC_RX0_T_SENSE_ENABLE_3 */
#define REG_RFIC_RX0_T_SENSE_ENABLE_3          0x1A
#define REG_RFIC_RX0_T_SENSE_ENABLE_3_MASK     0x00000040
#define REG_RFIC_RX0_T_SENSE_ENABLE_3_SHIFT    6
#define REG_RFIC_RX0_T_SENSE_ENABLE_3_WIDTH    1

/* RFIC_TX0_BIAS_ENABLE_3 */
#define REG_RFIC_TX0_BIAS_ENABLE_3          0x1A
#define REG_RFIC_TX0_BIAS_ENABLE_3_MASK     0x00000020
#define REG_RFIC_TX0_BIAS_ENABLE_3_SHIFT    5
#define REG_RFIC_TX0_BIAS_ENABLE_3_WIDTH    1

/* RFIC_TX0_CALDAC_ENABLE_3 */
#define REG_RFIC_TX0_CALDAC_ENABLE_3          0x1A
#define REG_RFIC_TX0_CALDAC_ENABLE_3_MASK     0x00000010
#define REG_RFIC_TX0_CALDAC_ENABLE_3_SHIFT    4
#define REG_RFIC_TX0_CALDAC_ENABLE_3_WIDTH    1

/* RFIC_RX1_BB_BIAS_ENABLE_3 */
#define REG_RFIC_RX1_BB_BIAS_ENABLE_3          0x1A
#define REG_RFIC_RX1_BB_BIAS_ENABLE_3_MASK     0x00000008
#define REG_RFIC_RX1_BB_BIAS_ENABLE_3_SHIFT    3
#define REG_RFIC_RX1_BB_BIAS_ENABLE_3_WIDTH    1

/* RFIC_RX1_T_SENSE_ENABLE_3 */
#define REG_RFIC_RX1_T_SENSE_ENABLE_3          0x1A
#define REG_RFIC_RX1_T_SENSE_ENABLE_3_MASK     0x00000004
#define REG_RFIC_RX1_T_SENSE_ENABLE_3_SHIFT    2
#define REG_RFIC_RX1_T_SENSE_ENABLE_3_WIDTH    1

/* RFIC_TX1_BIAS_ENABLE_3 */
#define REG_RFIC_TX1_BIAS_ENABLE_3          0x1A
#define REG_RFIC_TX1_BIAS_ENABLE_3_MASK     0x00000002
#define REG_RFIC_TX1_BIAS_ENABLE_3_SHIFT    1
#define REG_RFIC_TX1_BIAS_ENABLE_3_WIDTH    1

/* RFIC_TX1_CALDAC_ENABLE_3 */
#define REG_RFIC_TX1_CALDAC_ENABLE_3          0x1A
#define REG_RFIC_TX1_CALDAC_ENABLE_3_MASK     0x00000001
#define REG_RFIC_TX1_CALDAC_ENABLE_3_SHIFT    0
#define REG_RFIC_TX1_CALDAC_ENABLE_3_WIDTH    1

/* RFIC_RX_CHANNEL_ENABLE_3_REGISTER */
#define REG_RFIC_RX_CHANNEL_ENABLE_3_REGISTER          0x1B
#define REG_RFIC_RX_CHANNEL_ENABLE_3_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_CHANNEL_ENABLE_3_REGISTER_SHIFT    0
#define REG_RFIC_RX_CHANNEL_ENABLE_3_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_I_3 */
#define REG_RFIC_RX0_LPF_I_3          0x1B
#define REG_RFIC_RX0_LPF_I_3_MASK     0x00000800
#define REG_RFIC_RX0_LPF_I_3_SHIFT    11
#define REG_RFIC_RX0_LPF_I_3_WIDTH    1

/* RFIC_RX0_LPF_Q_3 */
#define REG_RFIC_RX0_LPF_Q_3          0x1B
#define REG_RFIC_RX0_LPF_Q_3_MASK     0x00000400
#define REG_RFIC_RX0_LPF_Q_3_SHIFT    10
#define REG_RFIC_RX0_LPF_Q_3_WIDTH    1

/* RFIC_RX0_VGA1_DC_ENABLE_3 */
#define REG_RFIC_RX0_VGA1_DC_ENABLE_3          0x1B
#define REG_RFIC_RX0_VGA1_DC_ENABLE_3_MASK     0x00000200
#define REG_RFIC_RX0_VGA1_DC_ENABLE_3_SHIFT    9
#define REG_RFIC_RX0_VGA1_DC_ENABLE_3_WIDTH    1

/* RFIC_RX0_VGA2_DC_ENABLE_3 */
#define REG_RFIC_RX0_VGA2_DC_ENABLE_3          0x1B
#define REG_RFIC_RX0_VGA2_DC_ENABLE_3_MASK     0x00000100
#define REG_RFIC_RX0_VGA2_DC_ENABLE_3_SHIFT    8
#define REG_RFIC_RX0_VGA2_DC_ENABLE_3_WIDTH    1

/* RFIC_RX0_VGA2_I_3 */
#define REG_RFIC_RX0_VGA2_I_3          0x1B
#define REG_RFIC_RX0_VGA2_I_3_MASK     0x00000080
#define REG_RFIC_RX0_VGA2_I_3_SHIFT    7
#define REG_RFIC_RX0_VGA2_I_3_WIDTH    1

/* RFIC_RX0_VGA2_Q_3 */
#define REG_RFIC_RX0_VGA2_Q_3          0x1B
#define REG_RFIC_RX0_VGA2_Q_3_MASK     0x00000040
#define REG_RFIC_RX0_VGA2_Q_3_SHIFT    6
#define REG_RFIC_RX0_VGA2_Q_3_WIDTH    1

/* RFIC_RX1_LPF_I_3 */
#define REG_RFIC_RX1_LPF_I_3          0x1B
#define REG_RFIC_RX1_LPF_I_3_MASK     0x00000020
#define REG_RFIC_RX1_LPF_I_3_SHIFT    5
#define REG_RFIC_RX1_LPF_I_3_WIDTH    1

/* RFIC_RX1_LPF_Q_3 */
#define REG_RFIC_RX1_LPF_Q_3          0x1B
#define REG_RFIC_RX1_LPF_Q_3_MASK     0x00000010
#define REG_RFIC_RX1_LPF_Q_3_SHIFT    4
#define REG_RFIC_RX1_LPF_Q_3_WIDTH    1

/* RFIC_RX1_VGA1_DC_ENABLE_3 */
#define REG_RFIC_RX1_VGA1_DC_ENABLE_3          0x1B
#define REG_RFIC_RX1_VGA1_DC_ENABLE_3_MASK     0x00000008
#define REG_RFIC_RX1_VGA1_DC_ENABLE_3_SHIFT    3
#define REG_RFIC_RX1_VGA1_DC_ENABLE_3_WIDTH    1

/* RFIC_RX1_VGA2_DC_ENABLE_3 */
#define REG_RFIC_RX1_VGA2_DC_ENABLE_3          0x1B
#define REG_RFIC_RX1_VGA2_DC_ENABLE_3_MASK     0x00000004
#define REG_RFIC_RX1_VGA2_DC_ENABLE_3_SHIFT    2
#define REG_RFIC_RX1_VGA2_DC_ENABLE_3_WIDTH    1

/* RFIC_RX1_VGA2_I_3 */
#define REG_RFIC_RX1_VGA2_I_3          0x1B
#define REG_RFIC_RX1_VGA2_I_3_MASK     0x00000002
#define REG_RFIC_RX1_VGA2_I_3_SHIFT    1
#define REG_RFIC_RX1_VGA2_I_3_WIDTH    1

/* RFIC_RX1_VGA2_Q_3 */
#define REG_RFIC_RX1_VGA2_Q_3          0x1B
#define REG_RFIC_RX1_VGA2_Q_3_MASK     0x00000001
#define REG_RFIC_RX1_VGA2_Q_3_SHIFT    0
#define REG_RFIC_RX1_VGA2_Q_3_WIDTH    1

/* RFIC_RX_BAND_ENABLE_3_REGISTER */
#define REG_RFIC_RX_BAND_ENABLE_3_REGISTER          0x1C
#define REG_RFIC_RX_BAND_ENABLE_3_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_BAND_ENABLE_3_REGISTER_SHIFT    0
#define REG_RFIC_RX_BAND_ENABLE_3_REGISTER_WIDTH    12

/* RFIC_RX0_VGA1_I_ENABLE_3 */
#define REG_RFIC_RX0_VGA1_I_ENABLE_3          0x1C
#define REG_RFIC_RX0_VGA1_I_ENABLE_3_MASK     0x00000800
#define REG_RFIC_RX0_VGA1_I_ENABLE_3_SHIFT    11
#define REG_RFIC_RX0_VGA1_I_ENABLE_3_WIDTH    1

/* RFIC_RX0_VGA1_Q_ENABLE_3 */
#define REG_RFIC_RX0_VGA1_Q_ENABLE_3          0x1C
#define REG_RFIC_RX0_VGA1_Q_ENABLE_3_MASK     0x00000400
#define REG_RFIC_RX0_VGA1_Q_ENABLE_3_SHIFT    10
#define REG_RFIC_RX0_VGA1_Q_ENABLE_3_WIDTH    1

/* RFIC_RX0_RSSI_ENABLE_3 */
#define REG_RFIC_RX0_RSSI_ENABLE_3          0x1C
#define REG_RFIC_RX0_RSSI_ENABLE_3_MASK     0x00000200
#define REG_RFIC_RX0_RSSI_ENABLE_3_SHIFT    9
#define REG_RFIC_RX0_RSSI_ENABLE_3_WIDTH    1

/* RFIC_LO_RX0_ENABLE_3 */
#define REG_RFIC_LO_RX0_ENABLE_3          0x1C
#define REG_RFIC_LO_RX0_ENABLE_3_MASK     0x00000100
#define REG_RFIC_LO_RX0_ENABLE_3_SHIFT    8
#define REG_RFIC_LO_RX0_ENABLE_3_WIDTH    1

/* RFIC_RX0_MIXER_ENABLE_3 */
#define REG_RFIC_RX0_MIXER_ENABLE_3          0x1C
#define REG_RFIC_RX0_MIXER_ENABLE_3_MASK     0x00000080
#define REG_RFIC_RX0_MIXER_ENABLE_3_SHIFT    7
#define REG_RFIC_RX0_MIXER_ENABLE_3_WIDTH    1

/* RFIC_RX0_LNA_ENABLE_3 */
#define REG_RFIC_RX0_LNA_ENABLE_3          0x1C
#define REG_RFIC_RX0_LNA_ENABLE_3_MASK     0x00000040
#define REG_RFIC_RX0_LNA_ENABLE_3_SHIFT    6
#define REG_RFIC_RX0_LNA_ENABLE_3_WIDTH    1

/* RFIC_RX1_VGA1_I_ENABLE_3 */
#define REG_RFIC_RX1_VGA1_I_ENABLE_3          0x1C
#define REG_RFIC_RX1_VGA1_I_ENABLE_3_MASK     0x00000020
#define REG_RFIC_RX1_VGA1_I_ENABLE_3_SHIFT    5
#define REG_RFIC_RX1_VGA1_I_ENABLE_3_WIDTH    1

/* RFIC_RX1_VGA1_Q_ENABLE_3 */
#define REG_RFIC_RX1_VGA1_Q_ENABLE_3          0x1C
#define REG_RFIC_RX1_VGA1_Q_ENABLE_3_MASK     0x00000010
#define REG_RFIC_RX1_VGA1_Q_ENABLE_3_SHIFT    4
#define REG_RFIC_RX1_VGA1_Q_ENABLE_3_WIDTH    1

/* RFIC_RX1_RSSI_ENABLE_3 */
#define REG_RFIC_RX1_RSSI_ENABLE_3          0x1C
#define REG_RFIC_RX1_RSSI_ENABLE_3_MASK     0x00000008
#define REG_RFIC_RX1_RSSI_ENABLE_3_SHIFT    3
#define REG_RFIC_RX1_RSSI_ENABLE_3_WIDTH    1

/* RFIC_LO_RX1_ENABLE_3 */
#define REG_RFIC_LO_RX1_ENABLE_3          0x1C
#define REG_RFIC_LO_RX1_ENABLE_3_MASK     0x00000004
#define REG_RFIC_LO_RX1_ENABLE_3_SHIFT    2
#define REG_RFIC_LO_RX1_ENABLE_3_WIDTH    1

/* RFIC_RX1_MIXER_ENABLE_3 */
#define REG_RFIC_RX1_MIXER_ENABLE_3          0x1C
#define REG_RFIC_RX1_MIXER_ENABLE_3_MASK     0x00000002
#define REG_RFIC_RX1_MIXER_ENABLE_3_SHIFT    1
#define REG_RFIC_RX1_MIXER_ENABLE_3_WIDTH    1

/* RFIC_RX1_LNA_ENABLE_3 */
#define REG_RFIC_RX1_LNA_ENABLE_3          0x1C
#define REG_RFIC_RX1_LNA_ENABLE_3_MASK     0x00000001
#define REG_RFIC_RX1_LNA_ENABLE_3_SHIFT    0
#define REG_RFIC_RX1_LNA_ENABLE_3_WIDTH    1

/* RFIC_TX_ENABLE_3_REGISTER */
#define REG_RFIC_TX_ENABLE_3_REGISTER          0x1D
#define REG_RFIC_TX_ENABLE_3_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX_ENABLE_3_REGISTER_SHIFT    0
#define REG_RFIC_TX_ENABLE_3_REGISTER_WIDTH    12

/* RFIC_LPF_TX0_I_3 */
#define REG_RFIC_LPF_TX0_I_3          0x1D
#define REG_RFIC_LPF_TX0_I_3_MASK     0x00000800
#define REG_RFIC_LPF_TX0_I_3_SHIFT    11
#define REG_RFIC_LPF_TX0_I_3_WIDTH    1

/* RFIC_LPF_TX0_Q_3 */
#define REG_RFIC_LPF_TX0_Q_3          0x1D
#define REG_RFIC_LPF_TX0_Q_3_MASK     0x00000400
#define REG_RFIC_LPF_TX0_Q_3_SHIFT    10
#define REG_RFIC_LPF_TX0_Q_3_WIDTH    1

/* RFIC_UPCONV_TX0_3 */
#define REG_RFIC_UPCONV_TX0_3          0x1D
#define REG_RFIC_UPCONV_TX0_3_MASK     0x00000200
#define REG_RFIC_UPCONV_TX0_3_SHIFT    9
#define REG_RFIC_UPCONV_TX0_3_WIDTH    1

/* RFIC_TPC_TX0_3 */
#define REG_RFIC_TPC_TX0_3          0x1D
#define REG_RFIC_TPC_TX0_3_MASK     0x00000100
#define REG_RFIC_TPC_TX0_3_SHIFT    8
#define REG_RFIC_TPC_TX0_3_WIDTH    1

/* RFIC_LO_TX0_ENABLE_3 */
#define REG_RFIC_LO_TX0_ENABLE_3          0x1D
#define REG_RFIC_LO_TX0_ENABLE_3_MASK     0x00000080
#define REG_RFIC_LO_TX0_ENABLE_3_SHIFT    7
#define REG_RFIC_LO_TX0_ENABLE_3_WIDTH    1

/* RFIC_DRIVER_TX0_3 */
#define REG_RFIC_DRIVER_TX0_3          0x1D
#define REG_RFIC_DRIVER_TX0_3_MASK     0x00000040
#define REG_RFIC_DRIVER_TX0_3_SHIFT    6
#define REG_RFIC_DRIVER_TX0_3_WIDTH    1

/* RFIC_LPF_TX1_I_3 */
#define REG_RFIC_LPF_TX1_I_3          0x1D
#define REG_RFIC_LPF_TX1_I_3_MASK     0x00000020
#define REG_RFIC_LPF_TX1_I_3_SHIFT    5
#define REG_RFIC_LPF_TX1_I_3_WIDTH    1

/* RFIC_LPF_TX1_Q_3 */
#define REG_RFIC_LPF_TX1_Q_3          0x1D
#define REG_RFIC_LPF_TX1_Q_3_MASK     0x00000010
#define REG_RFIC_LPF_TX1_Q_3_SHIFT    4
#define REG_RFIC_LPF_TX1_Q_3_WIDTH    1

/* RFIC_UPCONV_TX1_3 */
#define REG_RFIC_UPCONV_TX1_3          0x1D
#define REG_RFIC_UPCONV_TX1_3_MASK     0x00000008
#define REG_RFIC_UPCONV_TX1_3_SHIFT    3
#define REG_RFIC_UPCONV_TX1_3_WIDTH    1

/* RFIC_TPC_TX1_3 */
#define REG_RFIC_TPC_TX1_3          0x1D
#define REG_RFIC_TPC_TX1_3_MASK     0x00000004
#define REG_RFIC_TPC_TX1_3_SHIFT    2
#define REG_RFIC_TPC_TX1_3_WIDTH    1

/* RFIC_LO_TX1_ENABLE_3 */
#define REG_RFIC_LO_TX1_ENABLE_3          0x1D
#define REG_RFIC_LO_TX1_ENABLE_3_MASK     0x00000002
#define REG_RFIC_LO_TX1_ENABLE_3_SHIFT    1
#define REG_RFIC_LO_TX1_ENABLE_3_WIDTH    1

/* RFIC_DRIVER_TX1_3 */
#define REG_RFIC_DRIVER_TX1_3          0x1D
#define REG_RFIC_DRIVER_TX1_3_MASK     0x00000001
#define REG_RFIC_DRIVER_TX1_3_SHIFT    0
#define REG_RFIC_DRIVER_TX1_3_WIDTH    1

/* RFIC_SYNTH_ENABLE_3_REGISTER */
#define REG_RFIC_SYNTH_ENABLE_3_REGISTER          0x1E
#define REG_RFIC_SYNTH_ENABLE_3_REGISTER_MASK     0x00000FFF
#define REG_RFIC_SYNTH_ENABLE_3_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_ENABLE_3_REGISTER_WIDTH    12

/* RFIC_VCO_ENABLE_3 */
#define REG_RFIC_VCO_ENABLE_3          0x1E
#define REG_RFIC_VCO_ENABLE_3_MASK     0x00000800
#define REG_RFIC_VCO_ENABLE_3_SHIFT    11
#define REG_RFIC_VCO_ENABLE_3_WIDTH    1

/* RFIC_VCO_MUX_ENABLE_3 */
#define REG_RFIC_VCO_MUX_ENABLE_3          0x1E
#define REG_RFIC_VCO_MUX_ENABLE_3_MASK     0x00000400
#define REG_RFIC_VCO_MUX_ENABLE_3_SHIFT    10
#define REG_RFIC_VCO_MUX_ENABLE_3_WIDTH    1

/* RFIC_DIV_2_ENABLE_3 */
#define REG_RFIC_DIV_2_ENABLE_3          0x1E
#define REG_RFIC_DIV_2_ENABLE_3_MASK     0x00000200
#define REG_RFIC_DIV_2_ENABLE_3_SHIFT    9
#define REG_RFIC_DIV_2_ENABLE_3_WIDTH    1

/* RFIC_LO_CHAIN_ENABLE_3 */
#define REG_RFIC_LO_CHAIN_ENABLE_3          0x1E
#define REG_RFIC_LO_CHAIN_ENABLE_3_MASK     0x00000100
#define REG_RFIC_LO_CHAIN_ENABLE_3_SHIFT    8
#define REG_RFIC_LO_CHAIN_ENABLE_3_WIDTH    1

/* RFIC_VCO_O_BUF_ENABLE_3 */
#define REG_RFIC_VCO_O_BUF_ENABLE_3          0x1E
#define REG_RFIC_VCO_O_BUF_ENABLE_3_MASK     0x00000080
#define REG_RFIC_VCO_O_BUF_ENABLE_3_SHIFT    7
#define REG_RFIC_VCO_O_BUF_ENABLE_3_WIDTH    1

/* RFIC_VCO_I_BUF_ENABLE_3 */
#define REG_RFIC_VCO_I_BUF_ENABLE_3          0x1E
#define REG_RFIC_VCO_I_BUF_ENABLE_3_MASK     0x00000040
#define REG_RFIC_VCO_I_BUF_ENABLE_3_SHIFT    6
#define REG_RFIC_VCO_I_BUF_ENABLE_3_WIDTH    1

/* RFIC_SPARE_ENABLE_3 */
#define REG_RFIC_SPARE_ENABLE_3          0x1E
#define REG_RFIC_SPARE_ENABLE_3_MASK     0x00000030
#define REG_RFIC_SPARE_ENABLE_3_SHIFT    4
#define REG_RFIC_SPARE_ENABLE_3_WIDTH    2

/* RFIC_MAIN_DIV_ENABLE_3 */
#define REG_RFIC_MAIN_DIV_ENABLE_3          0x1E
#define REG_RFIC_MAIN_DIV_ENABLE_3_MASK     0x00000008
#define REG_RFIC_MAIN_DIV_ENABLE_3_SHIFT    3
#define REG_RFIC_MAIN_DIV_ENABLE_3_WIDTH    1

/* RFIC_REF_DIV_ENABLE_3 */
#define REG_RFIC_REF_DIV_ENABLE_3          0x1E
#define REG_RFIC_REF_DIV_ENABLE_3_MASK     0x00000004
#define REG_RFIC_REF_DIV_ENABLE_3_SHIFT    2
#define REG_RFIC_REF_DIV_ENABLE_3_WIDTH    1

/* RFIC_MOR_ENABLE_3 */
#define REG_RFIC_MOR_ENABLE_3          0x1E
#define REG_RFIC_MOR_ENABLE_3_MASK     0x00000002
#define REG_RFIC_MOR_ENABLE_3_SHIFT    1
#define REG_RFIC_MOR_ENABLE_3_WIDTH    1

/* RFIC_CP_ENABLE_3 */
#define REG_RFIC_CP_ENABLE_3          0x1E
#define REG_RFIC_CP_ENABLE_3_MASK     0x00000001
#define REG_RFIC_CP_ENABLE_3_SHIFT    0
#define REG_RFIC_CP_ENABLE_3_WIDTH    1

/* RFIC_BIASING_ENABLE_0_REGISTER */
#define REG_RFIC_BIASING_ENABLE_0_REGISTER          0x20
#define REG_RFIC_BIASING_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_BIASING_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_BIASING_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_VCO_VREG_ENABLE_0 */
#define REG_RFIC_VCO_VREG_ENABLE_0          0x20
#define REG_RFIC_VCO_VREG_ENABLE_0_MASK     0x00000800
#define REG_RFIC_VCO_VREG_ENABLE_0_SHIFT    11
#define REG_RFIC_VCO_VREG_ENABLE_0_WIDTH    1

/* RFIC_SYNTH_BG_ENABLE_0 */
#define REG_RFIC_SYNTH_BG_ENABLE_0          0x20
#define REG_RFIC_SYNTH_BG_ENABLE_0_MASK     0x00000400
#define REG_RFIC_SYNTH_BG_ENABLE_0_SHIFT    10
#define REG_RFIC_SYNTH_BG_ENABLE_0_WIDTH    1

/* RFIC_SYNTH_ITAT_ENABLE_0 */
#define REG_RFIC_SYNTH_ITAT_ENABLE_0          0x20
#define REG_RFIC_SYNTH_ITAT_ENABLE_0_MASK     0x00000200
#define REG_RFIC_SYNTH_ITAT_ENABLE_0_SHIFT    9
#define REG_RFIC_SYNTH_ITAT_ENABLE_0_WIDTH    1

/* RFIC_VCO_T_SENSE_ENABLE_0 */
#define REG_RFIC_VCO_T_SENSE_ENABLE_0          0x20
#define REG_RFIC_VCO_T_SENSE_ENABLE_0_MASK     0x00000100
#define REG_RFIC_VCO_T_SENSE_ENABLE_0_SHIFT    8
#define REG_RFIC_VCO_T_SENSE_ENABLE_0_WIDTH    1

/* RFIC_RX0_BB_BIAS_ENABLE_0 */
#define REG_RFIC_RX0_BB_BIAS_ENABLE_0          0x20
#define REG_RFIC_RX0_BB_BIAS_ENABLE_0_MASK     0x00000080
#define REG_RFIC_RX0_BB_BIAS_ENABLE_0_SHIFT    7
#define REG_RFIC_RX0_BB_BIAS_ENABLE_0_WIDTH    1

/* RFIC_RX0_T_SENSE_ENABLE_0 */
#define REG_RFIC_RX0_T_SENSE_ENABLE_0          0x20
#define REG_RFIC_RX0_T_SENSE_ENABLE_0_MASK     0x00000040
#define REG_RFIC_RX0_T_SENSE_ENABLE_0_SHIFT    6
#define REG_RFIC_RX0_T_SENSE_ENABLE_0_WIDTH    1

/* RFIC_TX0_BIAS_ENABLE_0 */
#define REG_RFIC_TX0_BIAS_ENABLE_0          0x20
#define REG_RFIC_TX0_BIAS_ENABLE_0_MASK     0x00000020
#define REG_RFIC_TX0_BIAS_ENABLE_0_SHIFT    5
#define REG_RFIC_TX0_BIAS_ENABLE_0_WIDTH    1

/* RFIC_TX0_CALDAC_ENABLE_0 */
#define REG_RFIC_TX0_CALDAC_ENABLE_0          0x20
#define REG_RFIC_TX0_CALDAC_ENABLE_0_MASK     0x00000010
#define REG_RFIC_TX0_CALDAC_ENABLE_0_SHIFT    4
#define REG_RFIC_TX0_CALDAC_ENABLE_0_WIDTH    1

/* RFIC_RX1_BB_BIAS_ENABLE_0 */
#define REG_RFIC_RX1_BB_BIAS_ENABLE_0          0x20
#define REG_RFIC_RX1_BB_BIAS_ENABLE_0_MASK     0x00000008
#define REG_RFIC_RX1_BB_BIAS_ENABLE_0_SHIFT    3
#define REG_RFIC_RX1_BB_BIAS_ENABLE_0_WIDTH    1

/* RFIC_RX1_T_SENSE_ENABLE_0 */
#define REG_RFIC_RX1_T_SENSE_ENABLE_0          0x20
#define REG_RFIC_RX1_T_SENSE_ENABLE_0_MASK     0x00000004
#define REG_RFIC_RX1_T_SENSE_ENABLE_0_SHIFT    2
#define REG_RFIC_RX1_T_SENSE_ENABLE_0_WIDTH    1

/* RFIC_TX1_BIAS_ENABLE_0 */
#define REG_RFIC_TX1_BIAS_ENABLE_0          0x20
#define REG_RFIC_TX1_BIAS_ENABLE_0_MASK     0x00000002
#define REG_RFIC_TX1_BIAS_ENABLE_0_SHIFT    1
#define REG_RFIC_TX1_BIAS_ENABLE_0_WIDTH    1

/* RFIC_TX1_CALDAC_ENABLE_0 */
#define REG_RFIC_TX1_CALDAC_ENABLE_0          0x20
#define REG_RFIC_TX1_CALDAC_ENABLE_0_MASK     0x00000001
#define REG_RFIC_TX1_CALDAC_ENABLE_0_SHIFT    0
#define REG_RFIC_TX1_CALDAC_ENABLE_0_WIDTH    1

/* RFIC_RX_CHANNEL_ENABLE_0_REGISTER */
#define REG_RFIC_RX_CHANNEL_ENABLE_0_REGISTER          0x21
#define REG_RFIC_RX_CHANNEL_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_CHANNEL_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_RX_CHANNEL_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_I_0 */
#define REG_RFIC_RX0_LPF_I_0          0x21
#define REG_RFIC_RX0_LPF_I_0_MASK     0x00000800
#define REG_RFIC_RX0_LPF_I_0_SHIFT    11
#define REG_RFIC_RX0_LPF_I_0_WIDTH    1

/* RFIC_RX0_LPF_Q_0 */
#define REG_RFIC_RX0_LPF_Q_0          0x21
#define REG_RFIC_RX0_LPF_Q_0_MASK     0x00000400
#define REG_RFIC_RX0_LPF_Q_0_SHIFT    10
#define REG_RFIC_RX0_LPF_Q_0_WIDTH    1

/* RFIC_RX0_VGA1_DC_ENABLE_0 */
#define REG_RFIC_RX0_VGA1_DC_ENABLE_0          0x21
#define REG_RFIC_RX0_VGA1_DC_ENABLE_0_MASK     0x00000200
#define REG_RFIC_RX0_VGA1_DC_ENABLE_0_SHIFT    9
#define REG_RFIC_RX0_VGA1_DC_ENABLE_0_WIDTH    1

/* RFIC_RX0_VGA2_DC_ENABLE_0 */
#define REG_RFIC_RX0_VGA2_DC_ENABLE_0          0x21
#define REG_RFIC_RX0_VGA2_DC_ENABLE_0_MASK     0x00000100
#define REG_RFIC_RX0_VGA2_DC_ENABLE_0_SHIFT    8
#define REG_RFIC_RX0_VGA2_DC_ENABLE_0_WIDTH    1

/* RFIC_RX0_VGA2_I_0 */
#define REG_RFIC_RX0_VGA2_I_0          0x21
#define REG_RFIC_RX0_VGA2_I_0_MASK     0x00000080
#define REG_RFIC_RX0_VGA2_I_0_SHIFT    7
#define REG_RFIC_RX0_VGA2_I_0_WIDTH    1

/* RFIC_RX0_VGA2_Q_0 */
#define REG_RFIC_RX0_VGA2_Q_0          0x21
#define REG_RFIC_RX0_VGA2_Q_0_MASK     0x00000040
#define REG_RFIC_RX0_VGA2_Q_0_SHIFT    6
#define REG_RFIC_RX0_VGA2_Q_0_WIDTH    1

/* RFIC_RX1_LPF_I_0 */
#define REG_RFIC_RX1_LPF_I_0          0x21
#define REG_RFIC_RX1_LPF_I_0_MASK     0x00000020
#define REG_RFIC_RX1_LPF_I_0_SHIFT    5
#define REG_RFIC_RX1_LPF_I_0_WIDTH    1

/* RFIC_RX1_LPF_Q_0 */
#define REG_RFIC_RX1_LPF_Q_0          0x21
#define REG_RFIC_RX1_LPF_Q_0_MASK     0x00000010
#define REG_RFIC_RX1_LPF_Q_0_SHIFT    4
#define REG_RFIC_RX1_LPF_Q_0_WIDTH    1

/* RFIC_RX1_VGA1_DC_ENABLE_0 */
#define REG_RFIC_RX1_VGA1_DC_ENABLE_0          0x21
#define REG_RFIC_RX1_VGA1_DC_ENABLE_0_MASK     0x00000008
#define REG_RFIC_RX1_VGA1_DC_ENABLE_0_SHIFT    3
#define REG_RFIC_RX1_VGA1_DC_ENABLE_0_WIDTH    1

/* RFIC_RX1_VGA2_DC_ENABLE_0 */
#define REG_RFIC_RX1_VGA2_DC_ENABLE_0          0x21
#define REG_RFIC_RX1_VGA2_DC_ENABLE_0_MASK     0x00000004
#define REG_RFIC_RX1_VGA2_DC_ENABLE_0_SHIFT    2
#define REG_RFIC_RX1_VGA2_DC_ENABLE_0_WIDTH    1

/* RFIC_RX1_VGA2_I_0 */
#define REG_RFIC_RX1_VGA2_I_0          0x21
#define REG_RFIC_RX1_VGA2_I_0_MASK     0x00000002
#define REG_RFIC_RX1_VGA2_I_0_SHIFT    1
#define REG_RFIC_RX1_VGA2_I_0_WIDTH    1

/* RFIC_RX1_VGA2_Q_0 */
#define REG_RFIC_RX1_VGA2_Q_0          0x21
#define REG_RFIC_RX1_VGA2_Q_0_MASK     0x00000001
#define REG_RFIC_RX1_VGA2_Q_0_SHIFT    0
#define REG_RFIC_RX1_VGA2_Q_0_WIDTH    1

/* RFIC_RX_BAND_ENABLE_0_REGISTER */
#define REG_RFIC_RX_BAND_ENABLE_0_REGISTER          0x22
#define REG_RFIC_RX_BAND_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_BAND_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_RX_BAND_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_RX0_VGA1_I_ENABLE_0 */
#define REG_RFIC_RX0_VGA1_I_ENABLE_0          0x22
#define REG_RFIC_RX0_VGA1_I_ENABLE_0_MASK     0x00000800
#define REG_RFIC_RX0_VGA1_I_ENABLE_0_SHIFT    11
#define REG_RFIC_RX0_VGA1_I_ENABLE_0_WIDTH    1

/* RFIC_RX0_VGA1_Q_ENABLE_0 */
#define REG_RFIC_RX0_VGA1_Q_ENABLE_0          0x22
#define REG_RFIC_RX0_VGA1_Q_ENABLE_0_MASK     0x00000400
#define REG_RFIC_RX0_VGA1_Q_ENABLE_0_SHIFT    10
#define REG_RFIC_RX0_VGA1_Q_ENABLE_0_WIDTH    1

/* RFIC_RX0_RSSI_ENABLE_0 */
#define REG_RFIC_RX0_RSSI_ENABLE_0          0x22
#define REG_RFIC_RX0_RSSI_ENABLE_0_MASK     0x00000200
#define REG_RFIC_RX0_RSSI_ENABLE_0_SHIFT    9
#define REG_RFIC_RX0_RSSI_ENABLE_0_WIDTH    1

/* RFIC_LO_RX0_ENABLE_0 */
#define REG_RFIC_LO_RX0_ENABLE_0          0x22
#define REG_RFIC_LO_RX0_ENABLE_0_MASK     0x00000100
#define REG_RFIC_LO_RX0_ENABLE_0_SHIFT    8
#define REG_RFIC_LO_RX0_ENABLE_0_WIDTH    1

/* RFIC_RX0_MIXER_ENABLE_0 */
#define REG_RFIC_RX0_MIXER_ENABLE_0          0x22
#define REG_RFIC_RX0_MIXER_ENABLE_0_MASK     0x00000080
#define REG_RFIC_RX0_MIXER_ENABLE_0_SHIFT    7
#define REG_RFIC_RX0_MIXER_ENABLE_0_WIDTH    1

/* RFIC_RX0_LNA_ENABLE_0 */
#define REG_RFIC_RX0_LNA_ENABLE_0          0x22
#define REG_RFIC_RX0_LNA_ENABLE_0_MASK     0x00000040
#define REG_RFIC_RX0_LNA_ENABLE_0_SHIFT    6
#define REG_RFIC_RX0_LNA_ENABLE_0_WIDTH    1

/* RFIC_RX1_VGA1_I_ENABLE_0 */
#define REG_RFIC_RX1_VGA1_I_ENABLE_0          0x22
#define REG_RFIC_RX1_VGA1_I_ENABLE_0_MASK     0x00000020
#define REG_RFIC_RX1_VGA1_I_ENABLE_0_SHIFT    5
#define REG_RFIC_RX1_VGA1_I_ENABLE_0_WIDTH    1

/* RFIC_RX1_VGA1_Q_ENABLE_0 */
#define REG_RFIC_RX1_VGA1_Q_ENABLE_0          0x22
#define REG_RFIC_RX1_VGA1_Q_ENABLE_0_MASK     0x00000010
#define REG_RFIC_RX1_VGA1_Q_ENABLE_0_SHIFT    4
#define REG_RFIC_RX1_VGA1_Q_ENABLE_0_WIDTH    1

/* RFIC_RX1_RSSI_ENABLE_0 */
#define REG_RFIC_RX1_RSSI_ENABLE_0          0x22
#define REG_RFIC_RX1_RSSI_ENABLE_0_MASK     0x00000008
#define REG_RFIC_RX1_RSSI_ENABLE_0_SHIFT    3
#define REG_RFIC_RX1_RSSI_ENABLE_0_WIDTH    1

/* RFIC_LO_RX1_ENABLE_0 */
#define REG_RFIC_LO_RX1_ENABLE_0          0x22
#define REG_RFIC_LO_RX1_ENABLE_0_MASK     0x00000004
#define REG_RFIC_LO_RX1_ENABLE_0_SHIFT    2
#define REG_RFIC_LO_RX1_ENABLE_0_WIDTH    1

/* RFIC_RX1_MIXER_ENABLE_0 */
#define REG_RFIC_RX1_MIXER_ENABLE_0          0x22
#define REG_RFIC_RX1_MIXER_ENABLE_0_MASK     0x00000002
#define REG_RFIC_RX1_MIXER_ENABLE_0_SHIFT    1
#define REG_RFIC_RX1_MIXER_ENABLE_0_WIDTH    1

/* RFIC_RX1_LNA_ENABLE_0 */
#define REG_RFIC_RX1_LNA_ENABLE_0          0x22
#define REG_RFIC_RX1_LNA_ENABLE_0_MASK     0x00000001
#define REG_RFIC_RX1_LNA_ENABLE_0_SHIFT    0
#define REG_RFIC_RX1_LNA_ENABLE_0_WIDTH    1

/* RFIC_TX_ENABLE_0_REGISTER */
#define REG_RFIC_TX_ENABLE_0_REGISTER          0x23
#define REG_RFIC_TX_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_TX_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_TX0_LPF_I_0 */
#define REG_RFIC_TX0_LPF_I_0          0x23
#define REG_RFIC_TX0_LPF_I_0_MASK     0x00000800
#define REG_RFIC_TX0_LPF_I_0_SHIFT    11
#define REG_RFIC_TX0_LPF_I_0_WIDTH    1

/* RFIC_TX0_LPF_Q_0 */
#define REG_RFIC_TX0_LPF_Q_0          0x23
#define REG_RFIC_TX0_LPF_Q_0_MASK     0x00000400
#define REG_RFIC_TX0_LPF_Q_0_SHIFT    10
#define REG_RFIC_TX0_LPF_Q_0_WIDTH    1

/* RFIC_TX0_UPCONV_0 */
#define REG_RFIC_TX0_UPCONV_0          0x23
#define REG_RFIC_TX0_UPCONV_0_MASK     0x00000200
#define REG_RFIC_TX0_UPCONV_0_SHIFT    9
#define REG_RFIC_TX0_UPCONV_0_WIDTH    1

/* RFIC_TX0_TPC_0 */
#define REG_RFIC_TX0_TPC_0          0x23
#define REG_RFIC_TX0_TPC_0_MASK     0x00000100
#define REG_RFIC_TX0_TPC_0_SHIFT    8
#define REG_RFIC_TX0_TPC_0_WIDTH    1

/* RFIC_LO_TX0_ENABLE_0 */
#define REG_RFIC_LO_TX0_ENABLE_0          0x23
#define REG_RFIC_LO_TX0_ENABLE_0_MASK     0x00000080
#define REG_RFIC_LO_TX0_ENABLE_0_SHIFT    7
#define REG_RFIC_LO_TX0_ENABLE_0_WIDTH    1

/* RFIC_TX0_DRIVER_0 */
#define REG_RFIC_TX0_DRIVER_0          0x23
#define REG_RFIC_TX0_DRIVER_0_MASK     0x00000040
#define REG_RFIC_TX0_DRIVER_0_SHIFT    6
#define REG_RFIC_TX0_DRIVER_0_WIDTH    1

/* RFIC_TX1_LPF_I_0 */
#define REG_RFIC_TX1_LPF_I_0          0x23
#define REG_RFIC_TX1_LPF_I_0_MASK     0x00000020
#define REG_RFIC_TX1_LPF_I_0_SHIFT    5
#define REG_RFIC_TX1_LPF_I_0_WIDTH    1

/* RFIC_TX1_LPF_Q_0 */
#define REG_RFIC_TX1_LPF_Q_0          0x23
#define REG_RFIC_TX1_LPF_Q_0_MASK     0x00000010
#define REG_RFIC_TX1_LPF_Q_0_SHIFT    4
#define REG_RFIC_TX1_LPF_Q_0_WIDTH    1

/* RFIC_TX1_UPCONV_0 */
#define REG_RFIC_TX1_UPCONV_0          0x23
#define REG_RFIC_TX1_UPCONV_0_MASK     0x00000008
#define REG_RFIC_TX1_UPCONV_0_SHIFT    3
#define REG_RFIC_TX1_UPCONV_0_WIDTH    1

/* RFIC_TX1_TPC_0 */
#define REG_RFIC_TX1_TPC_0          0x23
#define REG_RFIC_TX1_TPC_0_MASK     0x00000004
#define REG_RFIC_TX1_TPC_0_SHIFT    2
#define REG_RFIC_TX1_TPC_0_WIDTH    1

/* RFIC_LO_TX1_ENABLE_0 */
#define REG_RFIC_LO_TX1_ENABLE_0          0x23
#define REG_RFIC_LO_TX1_ENABLE_0_MASK     0x00000002
#define REG_RFIC_LO_TX1_ENABLE_0_SHIFT    1
#define REG_RFIC_LO_TX1_ENABLE_0_WIDTH    1

/* RFIC_TX1_DRIVER_0 */
#define REG_RFIC_TX1_DRIVER_0          0x23
#define REG_RFIC_TX1_DRIVER_0_MASK     0x00000001
#define REG_RFIC_TX1_DRIVER_0_SHIFT    0
#define REG_RFIC_TX1_DRIVER_0_WIDTH    1

/* RFIC_SYNTH_ENABLE_0_REGISTER */
#define REG_RFIC_SYNTH_ENABLE_0_REGISTER          0x24
#define REG_RFIC_SYNTH_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_SYNTH_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_VCO_ENABLE_0 */
#define REG_RFIC_VCO_ENABLE_0          0x24
#define REG_RFIC_VCO_ENABLE_0_MASK     0x00000800
#define REG_RFIC_VCO_ENABLE_0_SHIFT    11
#define REG_RFIC_VCO_ENABLE_0_WIDTH    1

/* RFIC_VCO_MUX_ENABLE_0 */
#define REG_RFIC_VCO_MUX_ENABLE_0          0x24
#define REG_RFIC_VCO_MUX_ENABLE_0_MASK     0x00000400
#define REG_RFIC_VCO_MUX_ENABLE_0_SHIFT    10
#define REG_RFIC_VCO_MUX_ENABLE_0_WIDTH    1

/* RFIC_DIV_2_ENABLE_0 */
#define REG_RFIC_DIV_2_ENABLE_0          0x24
#define REG_RFIC_DIV_2_ENABLE_0_MASK     0x00000200
#define REG_RFIC_DIV_2_ENABLE_0_SHIFT    9
#define REG_RFIC_DIV_2_ENABLE_0_WIDTH    1

/* RFIC_LO_CHAIN_ENABLE_0 */
#define REG_RFIC_LO_CHAIN_ENABLE_0          0x24
#define REG_RFIC_LO_CHAIN_ENABLE_0_MASK     0x00000100
#define REG_RFIC_LO_CHAIN_ENABLE_0_SHIFT    8
#define REG_RFIC_LO_CHAIN_ENABLE_0_WIDTH    1

/* RFIC_VCO_O_BUF_ENABLE_0 */
#define REG_RFIC_VCO_O_BUF_ENABLE_0          0x24
#define REG_RFIC_VCO_O_BUF_ENABLE_0_MASK     0x00000080
#define REG_RFIC_VCO_O_BUF_ENABLE_0_SHIFT    7
#define REG_RFIC_VCO_O_BUF_ENABLE_0_WIDTH    1

/* RFIC_VCO_I_BUF_ENABLE_0 */
#define REG_RFIC_VCO_I_BUF_ENABLE_0          0x24
#define REG_RFIC_VCO_I_BUF_ENABLE_0_MASK     0x00000040
#define REG_RFIC_VCO_I_BUF_ENABLE_0_SHIFT    6
#define REG_RFIC_VCO_I_BUF_ENABLE_0_WIDTH    1

/* RFIC_SPARE_ENABLE_0 */
#define REG_RFIC_SPARE_ENABLE_0          0x24
#define REG_RFIC_SPARE_ENABLE_0_MASK     0x00000030
#define REG_RFIC_SPARE_ENABLE_0_SHIFT    4
#define REG_RFIC_SPARE_ENABLE_0_WIDTH    2

/* RFIC_MAIN_DIV_ENABLE_0 */
#define REG_RFIC_MAIN_DIV_ENABLE_0          0x24
#define REG_RFIC_MAIN_DIV_ENABLE_0_MASK     0x00000008
#define REG_RFIC_MAIN_DIV_ENABLE_0_SHIFT    3
#define REG_RFIC_MAIN_DIV_ENABLE_0_WIDTH    1

/* RFIC_REF_DIV_ENABLE_0 */
#define REG_RFIC_REF_DIV_ENABLE_0          0x24
#define REG_RFIC_REF_DIV_ENABLE_0_MASK     0x00000004
#define REG_RFIC_REF_DIV_ENABLE_0_SHIFT    2
#define REG_RFIC_REF_DIV_ENABLE_0_WIDTH    1

/* RFIC_MOR_ENABLE_0 */
#define REG_RFIC_MOR_ENABLE_0          0x24
#define REG_RFIC_MOR_ENABLE_0_MASK     0x00000002
#define REG_RFIC_MOR_ENABLE_0_SHIFT    1
#define REG_RFIC_MOR_ENABLE_0_WIDTH    1

/* RFIC_CP_ENABLE_0 */
#define REG_RFIC_CP_ENABLE_0          0x24
#define REG_RFIC_CP_ENABLE_0_MASK     0x00000001
#define REG_RFIC_CP_ENABLE_0_SHIFT    0
#define REG_RFIC_CP_ENABLE_0_WIDTH    1

/* RFIC_RESERVED_ENABLE_0_REGISTER */
#define REG_RFIC_RESERVED_ENABLE_0_REGISTER          0x25
#define REG_RFIC_RESERVED_ENABLE_0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RESERVED_ENABLE_0_REGISTER_SHIFT    0
#define REG_RFIC_RESERVED_ENABLE_0_REGISTER_WIDTH    12

/* RFIC_RESERVED_ENABLE_1_REGISTER */
#define REG_RFIC_RESERVED_ENABLE_1_REGISTER          0x26
#define REG_RFIC_RESERVED_ENABLE_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RESERVED_ENABLE_1_REGISTER_SHIFT    0
#define REG_RFIC_RESERVED_ENABLE_1_REGISTER_WIDTH    12

/* RFIC_RESERVED_ENABLE_2_REGISTER */
#define REG_RFIC_RESERVED_ENABLE_2_REGISTER          0x27
#define REG_RFIC_RESERVED_ENABLE_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RESERVED_ENABLE_2_REGISTER_SHIFT    0
#define REG_RFIC_RESERVED_ENABLE_2_REGISTER_WIDTH    12

/* RFIC_RX0_MISC_CONTROL_1_REGISTER */
/* Mixer and LNA biasing tweak */
#define REG_RFIC_RX0_MISC_CONTROL_1_REGISTER          0x28
#define REG_RFIC_RX0_MISC_CONTROL_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX0_MISC_CONTROL_1_REGISTER_SHIFT    0
#define REG_RFIC_RX0_MISC_CONTROL_1_REGISTER_WIDTH    12

/* RFIC_RX0_MIXER_BOOST */
#define REG_RFIC_RX0_MIXER_BOOST          0x28
#define REG_RFIC_RX0_MIXER_BOOST_MASK     0x00000E00
#define REG_RFIC_RX0_MIXER_BOOST_SHIFT    9
#define REG_RFIC_RX0_MIXER_BOOST_WIDTH    3

/* RFIC_RX0_LNA_STAGE1_BIAS */
#define REG_RFIC_RX0_LNA_STAGE1_BIAS          0x28
#define REG_RFIC_RX0_LNA_STAGE1_BIAS_MASK     0x000001C0
#define REG_RFIC_RX0_LNA_STAGE1_BIAS_SHIFT    6
#define REG_RFIC_RX0_LNA_STAGE1_BIAS_WIDTH    3

/* RFIC_RX0_LNA_STAGE2_BIAS */
#define REG_RFIC_RX0_LNA_STAGE2_BIAS          0x28
#define REG_RFIC_RX0_LNA_STAGE2_BIAS_MASK     0x00000038
#define REG_RFIC_RX0_LNA_STAGE2_BIAS_SHIFT    3
#define REG_RFIC_RX0_LNA_STAGE2_BIAS_WIDTH    3

/* RFIC_RX0_LNB_BANDGAP */
#define REG_RFIC_RX0_LNB_BANDGAP          0x28
#define REG_RFIC_RX0_LNB_BANDGAP_MASK     0x00000007
#define REG_RFIC_RX0_LNB_BANDGAP_SHIFT    0
#define REG_RFIC_RX0_LNB_BANDGAP_WIDTH    3

/* RFIC_RX0_MISC_CONTROL_2_REGISTER */
/* Athena BG and Baseband tweak */
#define REG_RFIC_RX0_MISC_CONTROL_2_REGISTER          0x29
#define REG_RFIC_RX0_MISC_CONTROL_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX0_MISC_CONTROL_2_REGISTER_SHIFT    0
#define REG_RFIC_RX0_MISC_CONTROL_2_REGISTER_WIDTH    12

/* RFIC_RX0_LNB_MISC_BIASING */
#define REG_RFIC_RX0_LNB_MISC_BIASING          0x29
#define REG_RFIC_RX0_LNB_MISC_BIASING_MASK     0x00000E00
#define REG_RFIC_RX0_LNB_MISC_BIASING_SHIFT    9
#define REG_RFIC_RX0_LNB_MISC_BIASING_WIDTH    3

/* RFIC_RX0_BB_MISC_BIASING */
#define REG_RFIC_RX0_BB_MISC_BIASING          0x29
#define REG_RFIC_RX0_BB_MISC_BIASING_MASK     0x000001F8
#define REG_RFIC_RX0_BB_MISC_BIASING_SHIFT    3
#define REG_RFIC_RX0_BB_MISC_BIASING_WIDTH    6

/* RFIC_RX0_EXTERNAL_BANDGAP_TRIM */
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_TRIM          0x29
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_TRIM_MASK     0x00000038
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_TRIM_SHIFT    3
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_TRIM_WIDTH    3

/* RFIC_RX0_EXTERNAL_BANDGAP_ENABLE */
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_ENABLE          0x29
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_ENABLE_MASK     0x00000040
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_ENABLE_SHIFT    6
#define REG_RFIC_RX0_EXTERNAL_BANDGAP_ENABLE_WIDTH    1

/* RFIC_RX0_BB_BANDGAP_TRIM */
#define REG_RFIC_RX0_BB_BANDGAP_TRIM          0x29
#define REG_RFIC_RX0_BB_BANDGAP_TRIM_MASK     0x00000007
#define REG_RFIC_RX0_BB_BANDGAP_TRIM_SHIFT    0
#define REG_RFIC_RX0_BB_BANDGAP_TRIM_WIDTH    3

/* RFIC_RX1_MISC_CONTROL_1_REGISTER */
/* Mixer and LNA biasing tweak */
#define REG_RFIC_RX1_MISC_CONTROL_1_REGISTER          0x2A
#define REG_RFIC_RX1_MISC_CONTROL_1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX1_MISC_CONTROL_1_REGISTER_SHIFT    0
#define REG_RFIC_RX1_MISC_CONTROL_1_REGISTER_WIDTH    12

/* RFIC_RX1_MIXER_BOOST */
#define REG_RFIC_RX1_MIXER_BOOST          0x2A
#define REG_RFIC_RX1_MIXER_BOOST_MASK     0x00000E00
#define REG_RFIC_RX1_MIXER_BOOST_SHIFT    9
#define REG_RFIC_RX1_MIXER_BOOST_WIDTH    3

/* RFIC_RX1_LNA_STAGE1_BIAS */
#define REG_RFIC_RX1_LNA_STAGE1_BIAS          0x2A
#define REG_RFIC_RX1_LNA_STAGE1_BIAS_MASK     0x000001C0
#define REG_RFIC_RX1_LNA_STAGE1_BIAS_SHIFT    6
#define REG_RFIC_RX1_LNA_STAGE1_BIAS_WIDTH    3

/* RFIC_RX1_LNA_STAGE2_BIAS */
#define REG_RFIC_RX1_LNA_STAGE2_BIAS          0x2A
#define REG_RFIC_RX1_LNA_STAGE2_BIAS_MASK     0x00000038
#define REG_RFIC_RX1_LNA_STAGE2_BIAS_SHIFT    3
#define REG_RFIC_RX1_LNA_STAGE2_BIAS_WIDTH    3

/* RFIC_RX1_LNB_BANDGAP */
#define REG_RFIC_RX1_LNB_BANDGAP          0x2A
#define REG_RFIC_RX1_LNB_BANDGAP_MASK     0x00000007
#define REG_RFIC_RX1_LNB_BANDGAP_SHIFT    0
#define REG_RFIC_RX1_LNB_BANDGAP_WIDTH    3

/* RFIC_RX1_MISC_CONTROL_2_REGISTER */
/* Athena BG and Baseband tweak */
#define REG_RFIC_RX1_MISC_CONTROL_2_REGISTER          0x2B
#define REG_RFIC_RX1_MISC_CONTROL_2_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX1_MISC_CONTROL_2_REGISTER_SHIFT    0
#define REG_RFIC_RX1_MISC_CONTROL_2_REGISTER_WIDTH    12

/* RFIC_RX1_LNB_MISC_BIASING */
#define REG_RFIC_RX1_LNB_MISC_BIASING          0x2B
#define REG_RFIC_RX1_LNB_MISC_BIASING_MASK     0x00000E00
#define REG_RFIC_RX1_LNB_MISC_BIASING_SHIFT    9
#define REG_RFIC_RX1_LNB_MISC_BIASING_WIDTH    3

/* RFIC_RX1_BB_MISC_BIASING */
#define REG_RFIC_RX1_BB_MISC_BIASING          0x2B
#define REG_RFIC_RX1_BB_MISC_BIASING_MASK     0x000001F8
#define REG_RFIC_RX1_BB_MISC_BIASING_SHIFT    3
#define REG_RFIC_RX1_BB_MISC_BIASING_WIDTH    6

/* RFIC_RX1_EXTERNAL_BANDGAP_TRIM */
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_TRIM          0x2B
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_TRIM_MASK     0x00000038
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_TRIM_SHIFT    3
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_TRIM_WIDTH    3

/* RFIC_RX1_EXTERNAL_BANDGAP_ENABLE */
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_ENABLE          0x2B
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_ENABLE_MASK     0x00000040
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_ENABLE_SHIFT    6
#define REG_RFIC_RX1_EXTERNAL_BANDGAP_ENABLE_WIDTH    1

/* RFIC_RX1_BB_BANDGAP_TRIM */
#define REG_RFIC_RX1_BB_BANDGAP_TRIM          0x2B
#define REG_RFIC_RX1_BB_BANDGAP_TRIM_MASK     0x00000007
#define REG_RFIC_RX1_BB_BANDGAP_TRIM_SHIFT    0
#define REG_RFIC_RX1_BB_BANDGAP_TRIM_WIDTH    3

/* RFIC_RX_BB_TEST_MUX_REGISTER */
/* Input and Output Select */
#define REG_RFIC_RX_BB_TEST_MUX_REGISTER          0x2C
#define REG_RFIC_RX_BB_TEST_MUX_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_BB_TEST_MUX_REGISTER_SHIFT    0
#define REG_RFIC_RX_BB_TEST_MUX_REGISTER_WIDTH    12

/* RFIC_RX0_TEST_IN_SELECT */
/* Bit [2] unused */
#define REG_RFIC_RX0_TEST_IN_SELECT          0x2C
#define REG_RFIC_RX0_TEST_IN_SELECT_MASK     0x00000E00
#define REG_RFIC_RX0_TEST_IN_SELECT_SHIFT    9
#define REG_RFIC_RX0_TEST_IN_SELECT_WIDTH    3

/* RFIC_RX0_TEST_OUT_SELECT */
/* Bit [2] unused */
#define REG_RFIC_RX0_TEST_OUT_SELECT          0x2C
#define REG_RFIC_RX0_TEST_OUT_SELECT_MASK     0x000001C0
#define REG_RFIC_RX0_TEST_OUT_SELECT_SHIFT    6
#define REG_RFIC_RX0_TEST_OUT_SELECT_WIDTH    3

/* RFIC_RX1_TEST_IN_SELECT */
/* Bit [2] unused */
#define REG_RFIC_RX1_TEST_IN_SELECT          0x2C
#define REG_RFIC_RX1_TEST_IN_SELECT_MASK     0x00000038
#define REG_RFIC_RX1_TEST_IN_SELECT_SHIFT    3
#define REG_RFIC_RX1_TEST_IN_SELECT_WIDTH    3

/* RFIC_RX1_TEST_OUT_SELECT */
/* Bit [2] unused */
#define REG_RFIC_RX1_TEST_OUT_SELECT          0x2C
#define REG_RFIC_RX1_TEST_OUT_SELECT_MASK     0x00000007
#define REG_RFIC_RX1_TEST_OUT_SELECT_SHIFT    0
#define REG_RFIC_RX1_TEST_OUT_SELECT_WIDTH    3

/* RFIC_SYNTH_MISC_CONTROL_REGISTER */
/* Synthesizer tweaks and tests */
#define REG_RFIC_SYNTH_MISC_CONTROL_REGISTER          0x2D
#define REG_RFIC_SYNTH_MISC_CONTROL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_SYNTH_MISC_CONTROL_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_MISC_CONTROL_REGISTER_WIDTH    12

/* RFIC_SYNTH_TEST_RESERVED */
/* Bits [1::0] unused */
#define REG_RFIC_SYNTH_TEST_RESERVED          0x2D
#define REG_RFIC_SYNTH_TEST_RESERVED_MASK     0x00000E00
#define REG_RFIC_SYNTH_TEST_RESERVED_SHIFT    9
#define REG_RFIC_SYNTH_TEST_RESERVED_WIDTH    3

/* RFIC_LOW_POWER_VCO_OUT */
#define REG_RFIC_LOW_POWER_VCO_OUT          0x2D
#define REG_RFIC_LOW_POWER_VCO_OUT_MASK     0x00000100
#define REG_RFIC_LOW_POWER_VCO_OUT_SHIFT    8
#define REG_RFIC_LOW_POWER_VCO_OUT_WIDTH    1

/* RFIC_TEST_OUT_SEL */
#define REG_RFIC_TEST_OUT_SEL          0x2D
#define REG_RFIC_TEST_OUT_SEL_MASK     0x000000E0
#define REG_RFIC_TEST_OUT_SEL_SHIFT    5
#define REG_RFIC_TEST_OUT_SEL_WIDTH    3

/* RFIC_CP_SEL_STAY_ON */
#define REG_RFIC_CP_SEL_STAY_ON          0x2D
#define REG_RFIC_CP_SEL_STAY_ON_MASK     0x00000010
#define REG_RFIC_CP_SEL_STAY_ON_SHIFT    4
#define REG_RFIC_CP_SEL_STAY_ON_WIDTH    1

/* RFIC_CP_MAN_I_SEL */
#define REG_RFIC_CP_MAN_I_SEL          0x2D
#define REG_RFIC_CP_MAN_I_SEL_MASK     0x0000000C
#define REG_RFIC_CP_MAN_I_SEL_SHIFT    2
#define REG_RFIC_CP_MAN_I_SEL_WIDTH    2

/* RFIC_VCO_I_BOOST1 */
#define REG_RFIC_VCO_I_BOOST1          0x2D
#define REG_RFIC_VCO_I_BOOST1_MASK     0x00000002
#define REG_RFIC_VCO_I_BOOST1_SHIFT    1
#define REG_RFIC_VCO_I_BOOST1_WIDTH    1

/* RFIC_VCO_I_BOOST2 */
#define REG_RFIC_VCO_I_BOOST2          0x2D
#define REG_RFIC_VCO_I_BOOST2_MASK     0x00000001
#define REG_RFIC_VCO_I_BOOST2_SHIFT    0
#define REG_RFIC_VCO_I_BOOST2_WIDTH    1

/* RFIC_TPC_REGISTER */
/* Transmitter Power Control */
#define REG_RFIC_TPC_REGISTER          0x2E
#define REG_RFIC_TPC_REGISTER_MASK     0x000003CF
#define REG_RFIC_TPC_REGISTER_SHIFT    0
#define REG_RFIC_TPC_REGISTER_WIDTH    8

/* RFIC_TX0_TPC_WORD */
/* Legal values are 0-11; '0' = max gain */
#define REG_RFIC_TX0_TPC_WORD          0x2E
#define REG_RFIC_TX0_TPC_WORD_MASK     0x000003C0
#define REG_RFIC_TX0_TPC_WORD_SHIFT    6
#define REG_RFIC_TX0_TPC_WORD_WIDTH    4

/* RFIC_TX1_TPC_WORD */
/* Legal values are 0-11; '0' = max gain */
#define REG_RFIC_TX1_TPC_WORD          0x2E
#define REG_RFIC_TX1_TPC_WORD_MASK     0x0000000F
#define REG_RFIC_TX1_TPC_WORD_SHIFT    0
#define REG_RFIC_TX1_TPC_WORD_WIDTH    4

/* RFIC_LPF_TUNER_TIME_SET_REGISTER */
/* Selects offset from nominal tuning frequency */
#define REG_RFIC_LPF_TUNER_TIME_SET_REGISTER          0x2F
#define REG_RFIC_LPF_TUNER_TIME_SET_REGISTER_MASK     0x00000FFF
#define REG_RFIC_LPF_TUNER_TIME_SET_REGISTER_SHIFT    0
#define REG_RFIC_LPF_TUNER_TIME_SET_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_TUNER_TIME_SET */
/*  0x24 = 100% \n 0x3F = 127% \n 0x0 = 64% */
#define REG_RFIC_RX0_LPF_TUNER_TIME_SET          0x2F
#define REG_RFIC_RX0_LPF_TUNER_TIME_SET_MASK     0x00000FC0
#define REG_RFIC_RX0_LPF_TUNER_TIME_SET_SHIFT    6
#define REG_RFIC_RX0_LPF_TUNER_TIME_SET_WIDTH    6

/* RFIC_RX1_LPF_TUNER_TIME_SET */
/*  0x24 = 100% \n 0x3F = 127% \n 0x0 = 64% */
#define REG_RFIC_RX1_LPF_TUNER_TIME_SET          0x2F
#define REG_RFIC_RX1_LPF_TUNER_TIME_SET_MASK     0x0000003F
#define REG_RFIC_RX1_LPF_TUNER_TIME_SET_SHIFT    0
#define REG_RFIC_RX1_LPF_TUNER_TIME_SET_WIDTH    6

/* RFIC_SYNTH_MAIN_DIV_REGISTER */
#define REG_RFIC_SYNTH_MAIN_DIV_REGISTER          0x30
#define REG_RFIC_SYNTH_MAIN_DIV_REGISTER_MASK     0x00000F7F
#define REG_RFIC_SYNTH_MAIN_DIV_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_MAIN_DIV_REGISTER_WIDTH    11

/* RFIC_MAIN_DIV_PC */
#define REG_RFIC_MAIN_DIV_PC          0x30
#define REG_RFIC_MAIN_DIV_PC_MASK     0x0000007F
#define REG_RFIC_MAIN_DIV_PC_SHIFT    0
#define REG_RFIC_MAIN_DIV_PC_WIDTH    7

/* RFIC_MAIN_DIV_SW */
#define REG_RFIC_MAIN_DIV_SW          0x30
#define REG_RFIC_MAIN_DIV_SW_MASK     0x00000F00
#define REG_RFIC_MAIN_DIV_SW_SHIFT    8
#define REG_RFIC_MAIN_DIV_SW_WIDTH    4

/* RFIC_REF_DIV */
#define REG_RFIC_REF_DIV          0x31
#define REG_RFIC_REF_DIV_MASK     0x0000001F
#define REG_RFIC_REF_DIV_SHIFT    0
#define REG_RFIC_REF_DIV_WIDTH    5

/* RFIC_SYNTH_CONTROL_REGISTER */
/* VCO Tank and Sub-Band Select */
#define REG_RFIC_SYNTH_CONTROL_REGISTER          0x32
#define REG_RFIC_SYNTH_CONTROL_REGISTER_MASK     0x00000FFD
#define REG_RFIC_SYNTH_CONTROL_REGISTER_SHIFT    0
#define REG_RFIC_SYNTH_CONTROL_REGISTER_WIDTH    11

/* RFIC_VCO_TANK_SELECT */
/* Only one VCO can be on at any time */
#define REG_RFIC_VCO_TANK_SELECT          0x32
#define REG_RFIC_VCO_TANK_SELECT_MASK     0x00000C00
#define REG_RFIC_VCO_TANK_SELECT_SHIFT    10
#define REG_RFIC_VCO_TANK_SELECT_WIDTH    2

/* RFIC_VCO_HB_SEL */
#define REG_RFIC_VCO_HB_SEL          0x32
#define REG_RFIC_VCO_HB_SEL_MASK     0x00000800
#define REG_RFIC_VCO_HB_SEL_SHIFT    11
#define REG_RFIC_VCO_HB_SEL_WIDTH    1

/* RFIC_VCO_LB_SEL */
#define REG_RFIC_VCO_LB_SEL          0x32
#define REG_RFIC_VCO_LB_SEL_MASK     0x00000400
#define REG_RFIC_VCO_LB_SEL_SHIFT    10
#define REG_RFIC_VCO_LB_SEL_WIDTH    1

/* RFIC_VCO_SUB_BAND */
/* Only the number of '1' bits selects the sub-band */
#define REG_RFIC_VCO_SUB_BAND          0x32
#define REG_RFIC_VCO_SUB_BAND_MASK     0x000003FC
#define REG_RFIC_VCO_SUB_BAND_SHIFT    2
#define REG_RFIC_VCO_SUB_BAND_WIDTH    8

/* RFIC_EXTERNAL_VCO_SEL */
#define REG_RFIC_EXTERNAL_VCO_SEL          0x32
#define REG_RFIC_EXTERNAL_VCO_SEL_MASK     0x00000001
#define REG_RFIC_EXTERNAL_VCO_SEL_SHIFT    0
#define REG_RFIC_EXTERNAL_VCO_SEL_WIDTH    1

/* RFIC_AGC_RX0_REGISTER */
/* Gain Controls and DC Loop */
#define REG_RFIC_AGC_RX0_REGISTER          0x33
#define REG_RFIC_AGC_RX0_REGISTER_MASK     0x00000FFF
#define REG_RFIC_AGC_RX0_REGISTER_SHIFT    0
#define REG_RFIC_AGC_RX0_REGISTER_WIDTH    12

/* RFIC_RX0_LNA_GAIN */
/* 00' shuts down the LNA */
#define REG_RFIC_RX0_LNA_GAIN          0x33
#define REG_RFIC_RX0_LNA_GAIN_MASK     0x00000300
#define REG_RFIC_RX0_LNA_GAIN_SHIFT    8
#define REG_RFIC_RX0_LNA_GAIN_WIDTH    2

/* RFIC_RX0_VGA1_GAIN */
/* Legal Values are 1-6; 1=0dB Gain */
#define REG_RFIC_RX0_VGA1_GAIN          0x33
#define REG_RFIC_RX0_VGA1_GAIN_MASK     0x000000E0
#define REG_RFIC_RX0_VGA1_GAIN_SHIFT    5
#define REG_RFIC_RX0_VGA1_GAIN_WIDTH    3

/* RFIC_RX0_VGA2_GAIN */
#define REG_RFIC_RX0_VGA2_GAIN          0x33
#define REG_RFIC_RX0_VGA2_GAIN_MASK     0x0000001F
#define REG_RFIC_RX0_VGA2_GAIN_SHIFT    0
#define REG_RFIC_RX0_VGA2_GAIN_WIDTH    5

/* RFIC_RX0_V1_DC_LOOP */
#define REG_RFIC_RX0_V1_DC_LOOP          0x33
#define REG_RFIC_RX0_V1_DC_LOOP_MASK     0x00000400
#define REG_RFIC_RX0_V1_DC_LOOP_SHIFT    10
#define REG_RFIC_RX0_V1_DC_LOOP_WIDTH    1

/* RFIC_RX0_V2_DC_LOOP */
#define REG_RFIC_RX0_V2_DC_LOOP          0x33
#define REG_RFIC_RX0_V2_DC_LOOP_MASK     0x00000800
#define REG_RFIC_RX0_V2_DC_LOOP_SHIFT    11
#define REG_RFIC_RX0_V2_DC_LOOP_WIDTH    1

/* RFIC_AGC_RX1_REGISTER */
/* Gain Controls and DC Loop */
#define REG_RFIC_AGC_RX1_REGISTER          0x34
#define REG_RFIC_AGC_RX1_REGISTER_MASK     0x00000FFF
#define REG_RFIC_AGC_RX1_REGISTER_SHIFT    0
#define REG_RFIC_AGC_RX1_REGISTER_WIDTH    12

/* RFIC_RX1_LNA_GAIN */
/* 00' shuts down the LNA */
#define REG_RFIC_RX1_LNA_GAIN          0x34
#define REG_RFIC_RX1_LNA_GAIN_MASK     0x00000300
#define REG_RFIC_RX1_LNA_GAIN_SHIFT    8
#define REG_RFIC_RX1_LNA_GAIN_WIDTH    2

/* RFIC_RX1_VGA1_GAIN */
/* Legal Values are 1-6; 1=0dB Gain */
#define REG_RFIC_RX1_VGA1_GAIN          0x34
#define REG_RFIC_RX1_VGA1_GAIN_MASK     0x000000E0
#define REG_RFIC_RX1_VGA1_GAIN_SHIFT    5
#define REG_RFIC_RX1_VGA1_GAIN_WIDTH    3

/* RFIC_RX1_VGA2_GAIN */
#define REG_RFIC_RX1_VGA2_GAIN          0x34
#define REG_RFIC_RX1_VGA2_GAIN_MASK     0x0000001F
#define REG_RFIC_RX1_VGA2_GAIN_SHIFT    0
#define REG_RFIC_RX1_VGA2_GAIN_WIDTH    5

/* RFIC_RX1_V1_DC_LOOP */
#define REG_RFIC_RX1_V1_DC_LOOP          0x34
#define REG_RFIC_RX1_V1_DC_LOOP_MASK     0x00000400
#define REG_RFIC_RX1_V1_DC_LOOP_SHIFT    10
#define REG_RFIC_RX1_V1_DC_LOOP_WIDTH    1

/* RFIC_RX1_V2_DC_LOOP */
#define REG_RFIC_RX1_V2_DC_LOOP          0x34
#define REG_RFIC_RX1_V2_DC_LOOP_MASK     0x00000800
#define REG_RFIC_RX1_V2_DC_LOOP_SHIFT    11
#define REG_RFIC_RX1_V2_DC_LOOP_WIDTH    1

/* RFIC_LPF_TUNER_OUTPUT_REGISTER */
/* Read Only */
#define REG_RFIC_LPF_TUNER_OUTPUT_REGISTER          0x35
#define REG_RFIC_LPF_TUNER_OUTPUT_REGISTER_MASK     0x00000FFF
#define REG_RFIC_LPF_TUNER_OUTPUT_REGISTER_SHIFT    0
#define REG_RFIC_LPF_TUNER_OUTPUT_REGISTER_WIDTH    12

/* RFIC_RX0_TUNING_OUTPUT */
/* Read Only */
#define REG_RFIC_RX0_TUNING_OUTPUT          0x35
#define REG_RFIC_RX0_TUNING_OUTPUT_MASK     0x00000FC0
#define REG_RFIC_RX0_TUNING_OUTPUT_SHIFT    6
#define REG_RFIC_RX0_TUNING_OUTPUT_WIDTH    6

/* RFIC_RX1_TUNING_OUTPUT */
/* Read Only */
#define REG_RFIC_RX1_TUNING_OUTPUT          0x35
#define REG_RFIC_RX1_TUNING_OUTPUT_MASK     0x0000003F
#define REG_RFIC_RX1_TUNING_OUTPUT_SHIFT    0
#define REG_RFIC_RX1_TUNING_OUTPUT_WIDTH    6

/* RFIC_RX_LPF_WORD_REGISTER */
#define REG_RFIC_RX_LPF_WORD_REGISTER          0x36
#define REG_RFIC_RX_LPF_WORD_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_LPF_WORD_REGISTER_SHIFT    0
#define REG_RFIC_RX_LPF_WORD_REGISTER_WIDTH    12

/* RFIC_RX0_LPF_WORD */
#define REG_RFIC_RX0_LPF_WORD          0x36
#define REG_RFIC_RX0_LPF_WORD_MASK     0x00000FC0
#define REG_RFIC_RX0_LPF_WORD_SHIFT    6
#define REG_RFIC_RX0_LPF_WORD_WIDTH    6

/* RFIC_RX1_LPF_WORD */
#define REG_RFIC_RX1_LPF_WORD          0x36
#define REG_RFIC_RX1_LPF_WORD_MASK     0x0000003F
#define REG_RFIC_RX1_LPF_WORD_SHIFT    0
#define REG_RFIC_RX1_LPF_WORD_WIDTH    6

/* RFIC_MUX_CONTROL_REGISTER */
/* Enable T-Mux, Enable and Control Analog Mux */
#define REG_RFIC_MUX_CONTROL_REGISTER          0x37
#define REG_RFIC_MUX_CONTROL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_MUX_CONTROL_REGISTER_SHIFT    0
#define REG_RFIC_MUX_CONTROL_REGISTER_WIDTH    12

/* RFIC_RX0_TMUX_IN_ENABLE */
#define REG_RFIC_RX0_TMUX_IN_ENABLE          0x37
#define REG_RFIC_RX0_TMUX_IN_ENABLE_MASK     0x00000800
#define REG_RFIC_RX0_TMUX_IN_ENABLE_SHIFT    11
#define REG_RFIC_RX0_TMUX_IN_ENABLE_WIDTH    1

/* RFIC_RX0_TMUX_OUT_ENABLE */
#define REG_RFIC_RX0_TMUX_OUT_ENABLE          0x37
#define REG_RFIC_RX0_TMUX_OUT_ENABLE_MASK     0x00000400
#define REG_RFIC_RX0_TMUX_OUT_ENABLE_SHIFT    10
#define REG_RFIC_RX0_TMUX_OUT_ENABLE_WIDTH    1

/* RFIC_TRX0_MUX_ENABLE */
#define REG_RFIC_TRX0_MUX_ENABLE          0x37
#define REG_RFIC_TRX0_MUX_ENABLE_MASK     0x00000200
#define REG_RFIC_TRX0_MUX_ENABLE_SHIFT    9
#define REG_RFIC_TRX0_MUX_ENABLE_WIDTH    1

/* RFIC_TRX0_MUX_SELECT */
#define REG_RFIC_TRX0_MUX_SELECT          0x37
#define REG_RFIC_TRX0_MUX_SELECT_MASK     0x000001C0
#define REG_RFIC_TRX0_MUX_SELECT_SHIFT    6
#define REG_RFIC_TRX0_MUX_SELECT_WIDTH    3

/* RFIC_RX1_TMUX_IN_ENABLE */
#define REG_RFIC_RX1_TMUX_IN_ENABLE          0x37
#define REG_RFIC_RX1_TMUX_IN_ENABLE_MASK     0x00000020
#define REG_RFIC_RX1_TMUX_IN_ENABLE_SHIFT    5
#define REG_RFIC_RX1_TMUX_IN_ENABLE_WIDTH    1

/* RFIC_RX1_TMUX_OUT_ENABLE */
#define REG_RFIC_RX1_TMUX_OUT_ENABLE          0x37
#define REG_RFIC_RX1_TMUX_OUT_ENABLE_MASK     0x00000010
#define REG_RFIC_RX1_TMUX_OUT_ENABLE_SHIFT    4
#define REG_RFIC_RX1_TMUX_OUT_ENABLE_WIDTH    1

/* RFIC_TRX1_MUX_ENABLE */
#define REG_RFIC_TRX1_MUX_ENABLE          0x37
#define REG_RFIC_TRX1_MUX_ENABLE_MASK     0x00000008
#define REG_RFIC_TRX1_MUX_ENABLE_SHIFT    3
#define REG_RFIC_TRX1_MUX_ENABLE_WIDTH    1

/* RFIC_TRX1_MUX_SELECT */
#define REG_RFIC_TRX1_MUX_SELECT          0x37
#define REG_RFIC_TRX1_MUX_SELECT_MASK     0x00000007
#define REG_RFIC_TRX1_MUX_SELECT_SHIFT    0
#define REG_RFIC_TRX1_MUX_SELECT_WIDTH    3

/* RFIC_TRX0_CAL_REGISTER */
#define REG_RFIC_TRX0_CAL_REGISTER          0x38
#define REG_RFIC_TRX0_CAL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TRX0_CAL_REGISTER_SHIFT    0
#define REG_RFIC_TRX0_CAL_REGISTER_WIDTH    12

/* RFIC_TRX0_CAL_VCO_ENABLE */
#define REG_RFIC_TRX0_CAL_VCO_ENABLE          0x38
#define REG_RFIC_TRX0_CAL_VCO_ENABLE_MASK     0x00000800
#define REG_RFIC_TRX0_CAL_VCO_ENABLE_SHIFT    11
#define REG_RFIC_TRX0_CAL_VCO_ENABLE_WIDTH    1

/* RFIC_TRX0_LOOPBACK */
#define REG_RFIC_TRX0_LOOPBACK          0x38
#define REG_RFIC_TRX0_LOOPBACK_MASK     0x00000600
#define REG_RFIC_TRX0_LOOPBACK_SHIFT    9
#define REG_RFIC_TRX0_LOOPBACK_WIDTH    2

/* RFIC_TRX0_TX_IQ_CAL */
/* Bit [1] unused */
#define REG_RFIC_TRX0_TX_IQ_CAL          0x38
#define REG_RFIC_TRX0_TX_IQ_CAL_MASK     0x00000180
#define REG_RFIC_TRX0_TX_IQ_CAL_SHIFT    7
#define REG_RFIC_TRX0_TX_IQ_CAL_WIDTH    2

/* RFIC_TRX0_IQ_DET_ENABLE */
#define REG_RFIC_TRX0_IQ_DET_ENABLE          0x38
#define REG_RFIC_TRX0_IQ_DET_ENABLE_MASK     0x00000040
#define REG_RFIC_TRX0_IQ_DET_ENABLE_SHIFT    6
#define REG_RFIC_TRX0_IQ_DET_ENABLE_WIDTH    1

/* RFIC_TRX0_LO_DET_ENABLE */
#define REG_RFIC_TRX0_LO_DET_ENABLE          0x38
#define REG_RFIC_TRX0_LO_DET_ENABLE_MASK     0x00000020
#define REG_RFIC_TRX0_LO_DET_ENABLE_SHIFT    5
#define REG_RFIC_TRX0_LO_DET_ENABLE_WIDTH    1

/* RFIC_TRX0_TX_LOOP_ENABLE */
#define REG_RFIC_TRX0_TX_LOOP_ENABLE          0x38
#define REG_RFIC_TRX0_TX_LOOP_ENABLE_MASK     0x00000010
#define REG_RFIC_TRX0_TX_LOOP_ENABLE_SHIFT    4
#define REG_RFIC_TRX0_TX_LOOP_ENABLE_WIDTH    1

/* RFIC_TRX0_RX_RF_IQ_CAL */
#define REG_RFIC_TRX0_RX_RF_IQ_CAL          0x38
#define REG_RFIC_TRX0_RX_RF_IQ_CAL_MASK     0x0000000C
#define REG_RFIC_TRX0_RX_RF_IQ_CAL_SHIFT    2
#define REG_RFIC_TRX0_RX_RF_IQ_CAL_WIDTH    2

/* RFIC_TRX0_RX_BB_IQ_CAL */
/* Bit [1] unused */
#define REG_RFIC_TRX0_RX_BB_IQ_CAL          0x38
#define REG_RFIC_TRX0_RX_BB_IQ_CAL_MASK     0x00000003
#define REG_RFIC_TRX0_RX_BB_IQ_CAL_SHIFT    0
#define REG_RFIC_TRX0_RX_BB_IQ_CAL_WIDTH    2

/* RFIC_TRX1_CAL_REGISTER */
#define REG_RFIC_TRX1_CAL_REGISTER          0x39
#define REG_RFIC_TRX1_CAL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TRX1_CAL_REGISTER_SHIFT    0
#define REG_RFIC_TRX1_CAL_REGISTER_WIDTH    12

/* RFIC_TRX1_CAL_VCO_ENABLE */
#define REG_RFIC_TRX1_CAL_VCO_ENABLE          0x39
#define REG_RFIC_TRX1_CAL_VCO_ENABLE_MASK     0x00000800
#define REG_RFIC_TRX1_CAL_VCO_ENABLE_SHIFT    11
#define REG_RFIC_TRX1_CAL_VCO_ENABLE_WIDTH    1

/* RFIC_TRX1_LOOPBACK */
#define REG_RFIC_TRX1_LOOPBACK          0x39
#define REG_RFIC_TRX1_LOOPBACK_MASK     0x00000600
#define REG_RFIC_TRX1_LOOPBACK_SHIFT    9
#define REG_RFIC_TRX1_LOOPBACK_WIDTH    2

/* RFIC_TRX1_TX_IQ_CAL */
/* Bit [1] unused */
#define REG_RFIC_TRX1_TX_IQ_CAL          0x39
#define REG_RFIC_TRX1_TX_IQ_CAL_MASK     0x00000180
#define REG_RFIC_TRX1_TX_IQ_CAL_SHIFT    7
#define REG_RFIC_TRX1_TX_IQ_CAL_WIDTH    2

/* RFIC_TRX1_IQ_DET_ENABLE */
#define REG_RFIC_TRX1_IQ_DET_ENABLE          0x39
#define REG_RFIC_TRX1_IQ_DET_ENABLE_MASK     0x00000040
#define REG_RFIC_TRX1_IQ_DET_ENABLE_SHIFT    6
#define REG_RFIC_TRX1_IQ_DET_ENABLE_WIDTH    1

/* RFIC_TRX1_LO_DET_ENABLE */
#define REG_RFIC_TRX1_LO_DET_ENABLE          0x39
#define REG_RFIC_TRX1_LO_DET_ENABLE_MASK     0x00000020
#define REG_RFIC_TRX1_LO_DET_ENABLE_SHIFT    5
#define REG_RFIC_TRX1_LO_DET_ENABLE_WIDTH    1

/* RFIC_TRX1_TX_LOOP_ENABLE */
#define REG_RFIC_TRX1_TX_LOOP_ENABLE          0x39
#define REG_RFIC_TRX1_TX_LOOP_ENABLE_MASK     0x00000010
#define REG_RFIC_TRX1_TX_LOOP_ENABLE_SHIFT    4
#define REG_RFIC_TRX1_TX_LOOP_ENABLE_WIDTH    1

/* RFIC_TRX1_RX_RF_IQ_CAL */
#define REG_RFIC_TRX1_RX_RF_IQ_CAL          0x39
#define REG_RFIC_TRX1_RX_RF_IQ_CAL_MASK     0x0000000C
#define REG_RFIC_TRX1_RX_RF_IQ_CAL_SHIFT    2
#define REG_RFIC_TRX1_RX_RF_IQ_CAL_WIDTH    2

/* RFIC_TRX1_RX_BB_IQ_CAL */
/* Bit [1] unused */
#define REG_RFIC_TRX1_RX_BB_IQ_CAL          0x39
#define REG_RFIC_TRX1_RX_BB_IQ_CAL_MASK     0x00000003
#define REG_RFIC_TRX1_RX_BB_IQ_CAL_SHIFT    0
#define REG_RFIC_TRX1_RX_BB_IQ_CAL_WIDTH    2

/* RFIC_LPF_CTRL_REGISTER */
/* Tuner Control and Enable, TX CB select */
#define REG_RFIC_LPF_CTRL_REGISTER          0x3A
#define REG_RFIC_LPF_CTRL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_LPF_CTRL_REGISTER_SHIFT    0
#define REG_RFIC_LPF_CTRL_REGISTER_WIDTH    12

/* RFIC_RX0_CB_SEL */
#define REG_RFIC_RX0_CB_SEL          0x3A
#define REG_RFIC_RX0_CB_SEL_MASK     0x00000800
#define REG_RFIC_RX0_CB_SEL_SHIFT    11
#define REG_RFIC_RX0_CB_SEL_WIDTH    1

/* RFIC_RX0_TUNE_RESERVED */
#define REG_RFIC_RX0_TUNE_RESERVED          0x3A
#define REG_RFIC_RX0_TUNE_RESERVED_MASK     0x00000400
#define REG_RFIC_RX0_TUNE_RESERVED_SHIFT    10
#define REG_RFIC_RX0_TUNE_RESERVED_WIDTH    1

/* RFIC_RX0_REF_SELECT */
#define REG_RFIC_RX0_REF_SELECT          0x3A
#define REG_RFIC_RX0_REF_SELECT_MASK     0x00000200
#define REG_RFIC_RX0_REF_SELECT_SHIFT    9
#define REG_RFIC_RX0_REF_SELECT_WIDTH    1

/* RFIC_RX0_TUNE_ENABLE */
#define REG_RFIC_RX0_TUNE_ENABLE          0x3A
#define REG_RFIC_RX0_TUNE_ENABLE_MASK     0x00000100
#define REG_RFIC_RX0_TUNE_ENABLE_SHIFT    8
#define REG_RFIC_RX0_TUNE_ENABLE_WIDTH    1

/* RFIC_RX0_LPF_TUNE_RESET_N */
#define REG_RFIC_RX0_LPF_TUNE_RESET_N          0x3A
#define REG_RFIC_RX0_LPF_TUNE_RESET_N_MASK     0x00000080
#define REG_RFIC_RX0_LPF_TUNE_RESET_N_SHIFT    7
#define REG_RFIC_RX0_LPF_TUNE_RESET_N_WIDTH    1

/* RFIC_RX1_CB_SEL */
#define REG_RFIC_RX1_CB_SEL          0x3A
#define REG_RFIC_RX1_CB_SEL_MASK     0x00000040
#define REG_RFIC_RX1_CB_SEL_SHIFT    6
#define REG_RFIC_RX1_CB_SEL_WIDTH    1

/* RFIC_RX1_TUNE_RESERVED */
#define REG_RFIC_RX1_TUNE_RESERVED          0x3A
#define REG_RFIC_RX1_TUNE_RESERVED_MASK     0x00000020
#define REG_RFIC_RX1_TUNE_RESERVED_SHIFT    5
#define REG_RFIC_RX1_TUNE_RESERVED_WIDTH    1

/* RFIC_RX1_REF_SELECT */
#define REG_RFIC_RX1_REF_SELECT          0x3A
#define REG_RFIC_RX1_REF_SELECT_MASK     0x00000010
#define REG_RFIC_RX1_REF_SELECT_SHIFT    4
#define REG_RFIC_RX1_REF_SELECT_WIDTH    1

/* RFIC_RX1_TUNE_ENABLE */
#define REG_RFIC_RX1_TUNE_ENABLE          0x3A
#define REG_RFIC_RX1_TUNE_ENABLE_MASK     0x00000008
#define REG_RFIC_RX1_TUNE_ENABLE_SHIFT    3
#define REG_RFIC_RX1_TUNE_ENABLE_WIDTH    1

/* RFIC_RX1_LPF_TUNE_RESET_N */
#define REG_RFIC_RX1_LPF_TUNE_RESET_N          0x3A
#define REG_RFIC_RX1_LPF_TUNE_RESET_N_MASK     0x00000004
#define REG_RFIC_RX1_LPF_TUNE_RESET_N_SHIFT    2
#define REG_RFIC_RX1_LPF_TUNE_RESET_N_WIDTH    1

/* RFIC_TX0_CB_SEL */
#define REG_RFIC_TX0_CB_SEL          0x3A
#define REG_RFIC_TX0_CB_SEL_MASK     0x00000002
#define REG_RFIC_TX0_CB_SEL_SHIFT    1
#define REG_RFIC_TX0_CB_SEL_WIDTH    1

/* RFIC_TX1_CB_SEL */
#define REG_RFIC_TX1_CB_SEL          0x3A
#define REG_RFIC_TX1_CB_SEL_MASK     0x00000001
#define REG_RFIC_TX1_CB_SEL_SHIFT    0
#define REG_RFIC_TX1_CB_SEL_WIDTH    1

/* RFIC_RX_DC_LOOP_CONTROL_REGISTER */
/* Gain Tweaknig, VGA2 DC Loop Mask */
#define REG_RFIC_RX_DC_LOOP_CONTROL_REGISTER          0x3B
#define REG_RFIC_RX_DC_LOOP_CONTROL_REGISTER_MASK     0x00000FFF
#define REG_RFIC_RX_DC_LOOP_CONTROL_REGISTER_SHIFT    0
#define REG_RFIC_RX_DC_LOOP_CONTROL_REGISTER_WIDTH    12

/* RFIC_RX0_VGA2_LOOP_MASK */
/* Controls which of the two feedback loops are controlled by the AGC */
#define REG_RFIC_RX0_VGA2_LOOP_MASK          0x3B
#define REG_RFIC_RX0_VGA2_LOOP_MASK_MASK     0x00000003
#define REG_RFIC_RX0_VGA2_LOOP_MASK_SHIFT    0
#define REG_RFIC_RX0_VGA2_LOOP_MASK_WIDTH    2

/* RFIC_RX0_VGA1_LOOP_GAIN */
#define REG_RFIC_RX0_VGA1_LOOP_GAIN          0x3B
#define REG_RFIC_RX0_VGA1_LOOP_GAIN_MASK     0x0000000C
#define REG_RFIC_RX0_VGA1_LOOP_GAIN_SHIFT    2
#define REG_RFIC_RX0_VGA1_LOOP_GAIN_WIDTH    2

/* RFIC_RX0_VGA2_LOOP_GAIN */
#define REG_RFIC_RX0_VGA2_LOOP_GAIN          0x3B
#define REG_RFIC_RX0_VGA2_LOOP_GAIN_MASK     0x00000030
#define REG_RFIC_RX0_VGA2_LOOP_GAIN_SHIFT    4
#define REG_RFIC_RX0_VGA2_LOOP_GAIN_WIDTH    2

/* RFIC_RX1_VGA1_LOOP_GAIN */
#define REG_RFIC_RX1_VGA1_LOOP_GAIN          0x3B
#define REG_RFIC_RX1_VGA1_LOOP_GAIN_MASK     0x000000C0
#define REG_RFIC_RX1_VGA1_LOOP_GAIN_SHIFT    6
#define REG_RFIC_RX1_VGA1_LOOP_GAIN_WIDTH    2

/* RFIC_RX1_VGA2_LOOP_GAIN */
#define REG_RFIC_RX1_VGA2_LOOP_GAIN          0x3B
#define REG_RFIC_RX1_VGA2_LOOP_GAIN_MASK     0x00000300
#define REG_RFIC_RX1_VGA2_LOOP_GAIN_SHIFT    8
#define REG_RFIC_RX1_VGA2_LOOP_GAIN_WIDTH    2

/* RFIC_RX1_VGA2_LOOP_MASK */
/* Controls which of the two feedback loops are controlled by the AGC */
#define REG_RFIC_RX1_VGA2_LOOP_MASK          0x3B
#define REG_RFIC_RX1_VGA2_LOOP_MASK_MASK     0x00000C00
#define REG_RFIC_RX1_VGA2_LOOP_MASK_SHIFT    10
#define REG_RFIC_RX1_VGA2_LOOP_MASK_WIDTH    2

/* RFIC_TX0_LO_LEAK_REGISTER */
#define REG_RFIC_TX0_LO_LEAK_REGISTER          0x3C
#define REG_RFIC_TX0_LO_LEAK_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX0_LO_LEAK_REGISTER_SHIFT    0
#define REG_RFIC_TX0_LO_LEAK_REGISTER_WIDTH    12

/* RFIC_TX0_I_DAC */
#define REG_RFIC_TX0_I_DAC          0x3C
#define REG_RFIC_TX0_I_DAC_MASK     0x00000FC0
#define REG_RFIC_TX0_I_DAC_SHIFT    6
#define REG_RFIC_TX0_I_DAC_WIDTH    6

/* RFIC_TX0_Q_DAC */
#define REG_RFIC_TX0_Q_DAC          0x3C
#define REG_RFIC_TX0_Q_DAC_MASK     0x0000003F
#define REG_RFIC_TX0_Q_DAC_SHIFT    0
#define REG_RFIC_TX0_Q_DAC_WIDTH    6

/* RFIC_TX1_LO_LEAK_REGISTER */
#define REG_RFIC_TX1_LO_LEAK_REGISTER          0x3D
#define REG_RFIC_TX1_LO_LEAK_REGISTER_MASK     0x00000FFF
#define REG_RFIC_TX1_LO_LEAK_REGISTER_SHIFT    0
#define REG_RFIC_TX1_LO_LEAK_REGISTER_WIDTH    12

/* RFIC_TX1_I_DAC */
#define REG_RFIC_TX1_I_DAC          0x3D
#define REG_RFIC_TX1_I_DAC_MASK     0x00000FC0
#define REG_RFIC_TX1_I_DAC_SHIFT    6
#define REG_RFIC_TX1_I_DAC_WIDTH    6

/* RFIC_TX1_Q_DAC */
#define REG_RFIC_TX1_Q_DAC          0x3D
#define REG_RFIC_TX1_Q_DAC_MASK     0x0000003F
#define REG_RFIC_TX1_Q_DAC_SHIFT    0
#define REG_RFIC_TX1_Q_DAC_WIDTH    6

/* RFIC_TX_LO_LEAK_MSB_REGISTER */
#define REG_RFIC_TX_LO_LEAK_MSB_REGISTER          0x3E
#define REG_RFIC_TX_LO_LEAK_MSB_REGISTER_MASK     0x000006DB
#define REG_RFIC_TX_LO_LEAK_MSB_REGISTER_SHIFT    0
#define REG_RFIC_TX_LO_LEAK_MSB_REGISTER_WIDTH    8

/* RFIC_TX0_I_DAC_MSB */
#define REG_RFIC_TX0_I_DAC_MSB          0x3E
#define REG_RFIC_TX0_I_DAC_MSB_MASK     0x00000600
#define REG_RFIC_TX0_I_DAC_MSB_SHIFT    9
#define REG_RFIC_TX0_I_DAC_MSB_WIDTH    2

/* RFIC_TX0_Q_DAC_MSB */
#define REG_RFIC_TX0_Q_DAC_MSB          0x3E
#define REG_RFIC_TX0_Q_DAC_MSB_MASK     0x000000C0
#define REG_RFIC_TX0_Q_DAC_MSB_SHIFT    6
#define REG_RFIC_TX0_Q_DAC_MSB_WIDTH    2

/* RFIC_TX1_I_DAC_MSB */
#define REG_RFIC_TX1_I_DAC_MSB          0x3E
#define REG_RFIC_TX1_I_DAC_MSB_MASK     0x00000018
#define REG_RFIC_TX1_I_DAC_MSB_SHIFT    3
#define REG_RFIC_TX1_I_DAC_MSB_WIDTH    2

/* RFIC_TX1_Q_DAC_MSB */
#define REG_RFIC_TX1_Q_DAC_MSB          0x3E
#define REG_RFIC_TX1_Q_DAC_MSB_MASK     0x00000003
#define REG_RFIC_TX1_Q_DAC_MSB_SHIFT    0
#define REG_RFIC_TX1_Q_DAC_MSB_WIDTH    2

/* RFIC_OUTPUT_TEST_SENSE_REGISTER */
/* Read Only */
#define REG_RFIC_OUTPUT_TEST_SENSE_REGISTER          0x3F
#define REG_RFIC_OUTPUT_TEST_SENSE_REGISTER_MASK     0x00000FFF
#define REG_RFIC_OUTPUT_TEST_SENSE_REGISTER_SHIFT    0
#define REG_RFIC_OUTPUT_TEST_SENSE_REGISTER_WIDTH    12

/* RFIC_VTUNE_TOO_LOW */
/* Read Only */
#define REG_RFIC_VTUNE_TOO_LOW          0x3F
#define REG_RFIC_VTUNE_TOO_LOW_MASK     0x00000001
#define REG_RFIC_VTUNE_TOO_LOW_SHIFT    0
#define REG_RFIC_VTUNE_TOO_LOW_WIDTH    1

/* RFIC_VTUNE_ADC */
/* Read Only */
#define REG_RFIC_VTUNE_ADC          0x3F
#define REG_RFIC_VTUNE_ADC_MASK     0x00000006
#define REG_RFIC_VTUNE_ADC_SHIFT    1
#define REG_RFIC_VTUNE_ADC_WIDTH    2

/* RFIC_VTUNE_TOO_HIGH */
/* Read Only */
#define REG_RFIC_VTUNE_TOO_HIGH          0x3F
#define REG_RFIC_VTUNE_TOO_HIGH_MASK     0x00000008
#define REG_RFIC_VTUNE_TOO_HIGH_SHIFT    3
#define REG_RFIC_VTUNE_TOO_HIGH_WIDTH    1

/* RFIC_RX0_LPF_TUNE_DONE */
/* Read Only */
#define REG_RFIC_RX0_LPF_TUNE_DONE          0x3F
#define REG_RFIC_RX0_LPF_TUNE_DONE_MASK     0x00000080
#define REG_RFIC_RX0_LPF_TUNE_DONE_SHIFT    7
#define REG_RFIC_RX0_LPF_TUNE_DONE_WIDTH    1

/* RFIC_RX0_LPF_TUNE_ERROR */
/* Read Only */
#define REG_RFIC_RX0_LPF_TUNE_ERROR          0x3F
#define REG_RFIC_RX0_LPF_TUNE_ERROR_MASK     0x00000040
#define REG_RFIC_RX0_LPF_TUNE_ERROR_SHIFT    6
#define REG_RFIC_RX0_LPF_TUNE_ERROR_WIDTH    1

/* RFIC_RX1_LPF_TUNE_DONE */
/* Read Only */
#define REG_RFIC_RX1_LPF_TUNE_DONE          0x3F
#define REG_RFIC_RX1_LPF_TUNE_DONE_MASK     0x00000020
#define REG_RFIC_RX1_LPF_TUNE_DONE_SHIFT    5
#define REG_RFIC_RX1_LPF_TUNE_DONE_WIDTH    1

/* RFIC_RX1_LPF_TUNE_ERROR */
/* Read Only */
#define REG_RFIC_RX1_LPF_TUNE_ERROR          0x3F
#define REG_RFIC_RX1_LPF_TUNE_ERROR_MASK     0x00000010
#define REG_RFIC_RX1_LPF_TUNE_ERROR_SHIFT    4
#define REG_RFIC_RX1_LPF_TUNE_ERROR_WIDTH    1

/* RFIC_PLL_LD_TEST_OUT */
/* Read Only */
#define REG_RFIC_PLL_LD_TEST_OUT          0x3F
#define REG_RFIC_PLL_LD_TEST_OUT_MASK     0x00000100
#define REG_RFIC_PLL_LD_TEST_OUT_SHIFT    8
#define REG_RFIC_PLL_LD_TEST_OUT_WIDTH    1

/* RFIC_SENSE_RESERVED */
#define REG_RFIC_SENSE_RESERVED          0x3F
#define REG_RFIC_SENSE_RESERVED_MASK     0x00000E00
#define REG_RFIC_SENSE_RESERVED_SHIFT    9
#define REG_RFIC_SENSE_RESERVED_WIDTH    3
#endif 
