/*******************************************************************
*                                                                  
*  Shared Reg.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef Shared Reg_regs_H_FILE
#define Shared Reg_regs_H_FILE

/* DRAM_SREFRESH_MODE */
#define REG_DRAM_SREFRESH_MODE          0x000
#define REG_DRAM_SREFRESH_MODE_MASK     0x00000004
#define REG_DRAM_SREFRESH_MODE_SHIFT    2
#define REG_DRAM_SREFRESH_MODE_WIDTH    1

/* NPU_BOOT_MODE */
#define REG_NPU_BOOT_MODE          0x000
#define REG_NPU_BOOT_MODE_MASK     0x00300000
#define REG_NPU_BOOT_MODE_SHIFT    20
#define REG_NPU_BOOT_MODE_WIDTH    2

/* CLK_SEL_DDR2 */
#define REG_CLK_SEL_DDR2          0x004
#define REG_CLK_SEL_DDR2_MASK     0x00000100
#define REG_CLK_SEL_DDR2_SHIFT    8
#define REG_CLK_SEL_DDR2_WIDTH    1

/* SOFT_RESET_RESERVED1 */
#define REG_SOFT_RESET_RESERVED1          0x008
#define REG_SOFT_RESET_RESERVED1_MASK     0x00000002
#define REG_SOFT_RESET_RESERVED1_SHIFT    1
#define REG_SOFT_RESET_RESERVED1_WIDTH    1

/* UPP_MIPS_SW_RST_N */
#define REG_UPP_MIPS_SW_RST_N          0x008
#define REG_UPP_MIPS_SW_RST_N_MASK     0x00000001
#define REG_UPP_MIPS_SW_RST_N_SHIFT    0
#define REG_UPP_MIPS_SW_RST_N_WIDTH    1

/* NPU_MIPS_SW_RST_N */
#define REG_NPU_MIPS_SW_RST_N          0x008
#define REG_NPU_MIPS_SW_RST_N_MASK     0x00000004
#define REG_NPU_MIPS_SW_RST_N_SHIFT    2
#define REG_NPU_MIPS_SW_RST_N_WIDTH    1

/* SOFT_RESET_RESERVED2 */
#define REG_SOFT_RESET_RESERVED2          0x008
#define REG_SOFT_RESET_RESERVED2_MASK     0x00000008
#define REG_SOFT_RESET_RESERVED2_SHIFT    3
#define REG_SOFT_RESET_RESERVED2_WIDTH    1

/* GMAC0_SW_RST_N */
#define REG_GMAC0_SW_RST_N          0x008
#define REG_GMAC0_SW_RST_N_MASK     0x00000010
#define REG_GMAC0_SW_RST_N_SHIFT    4
#define REG_GMAC0_SW_RST_N_WIDTH    1

/* USB_CORE_AHB_SW_RST_N */
#define REG_USB_CORE_AHB_SW_RST_N          0x008
#define REG_USB_CORE_AHB_SW_RST_N_MASK     0x00000020
#define REG_USB_CORE_AHB_SW_RST_N_SHIFT    5
#define REG_USB_CORE_AHB_SW_RST_N_WIDTH    1

/* USB_CORE_PHY_SW_RST_N */
#define REG_USB_CORE_PHY_SW_RST_N          0x008
#define REG_USB_CORE_PHY_SW_RST_N_MASK     0x00000040
#define REG_USB_CORE_PHY_SW_RST_N_SHIFT    6
#define REG_USB_CORE_PHY_SW_RST_N_WIDTH    1

/* SOFT_RESET_RESERVED3 */
#define REG_SOFT_RESET_RESERVED3          0x008
#define REG_SOFT_RESET_RESERVED3_MASK     0x00000180
#define REG_SOFT_RESET_RESERVED3_SHIFT    7
#define REG_SOFT_RESET_RESERVED3_WIDTH    2

/* DDR_AHB_PRT0_SW_RST_N */
#define REG_DDR_AHB_PRT0_SW_RST_N          0x008
#define REG_DDR_AHB_PRT0_SW_RST_N_MASK     0x00000200
#define REG_DDR_AHB_PRT0_SW_RST_N_SHIFT    9
#define REG_DDR_AHB_PRT0_SW_RST_N_WIDTH    1

/* DDR_AHB_PRT1_SW_RST_N */
#define REG_DDR_AHB_PRT1_SW_RST_N          0x008
#define REG_DDR_AHB_PRT1_SW_RST_N_MASK     0x00000400
#define REG_DDR_AHB_PRT1_SW_RST_N_SHIFT    10
#define REG_DDR_AHB_PRT1_SW_RST_N_WIDTH    1

/* DDR_AHB_PRT2_SW_RST_N */
#define REG_DDR_AHB_PRT2_SW_RST_N          0x008
#define REG_DDR_AHB_PRT2_SW_RST_N_MASK     0x00000800
#define REG_DDR_AHB_PRT2_SW_RST_N_SHIFT    11
#define REG_DDR_AHB_PRT2_SW_RST_N_WIDTH    1

/* DDR_AHB_PRT3_SW_RST_N */
#define REG_DDR_AHB_PRT3_SW_RST_N          0x008
#define REG_DDR_AHB_PRT3_SW_RST_N_MASK     0x00001000
#define REG_DDR_AHB_PRT3_SW_RST_N_SHIFT    12
#define REG_DDR_AHB_PRT3_SW_RST_N_WIDTH    1

/* DDR_AHB_PRT4_SW_RST_N */
#define REG_DDR_AHB_PRT4_SW_RST_N          0x008
#define REG_DDR_AHB_PRT4_SW_RST_N_MASK     0x00002000
#define REG_DDR_AHB_PRT4_SW_RST_N_SHIFT    13
#define REG_DDR_AHB_PRT4_SW_RST_N_WIDTH    1

/* GMAC1_SW_RST_N */
#define REG_GMAC1_SW_RST_N          0x008
#define REG_GMAC1_SW_RST_N_MASK     0x00004000
#define REG_GMAC1_SW_RST_N_SHIFT    14
#define REG_GMAC1_SW_RST_N_WIDTH    1

/* DDRDMA_SW_RST_N */
#define REG_DDRDMA_SW_RST_N          0x008
#define REG_DDRDMA_SW_RST_N_MASK     0x00008000
#define REG_DDRDMA_SW_RST_N_SHIFT    15
#define REG_DDRDMA_SW_RST_N_WIDTH    1

/* SW_HW_RESET_N_REQ */
#define REG_SW_HW_RESET_N_REQ          0x008
#define REG_SW_HW_RESET_N_REQ_MASK     0x00010000
#define REG_SW_HW_RESET_N_REQ_SHIFT    16
#define REG_SW_HW_RESET_N_REQ_WIDTH    1

/* CLK_ENABLE_RESERVED1 */
#define REG_CLK_ENABLE_RESERVED1          0x00c
#define REG_CLK_ENABLE_RESERVED1_MASK     0x00000003
#define REG_CLK_ENABLE_RESERVED1_SHIFT    0
#define REG_CLK_ENABLE_RESERVED1_WIDTH    2

/* GMAC0_CLK_ENABLE */
#define REG_GMAC0_CLK_ENABLE          0x00c
#define REG_GMAC0_CLK_ENABLE_MASK     0x00000004
#define REG_GMAC0_CLK_ENABLE_SHIFT    2
#define REG_GMAC0_CLK_ENABLE_WIDTH    1

/* CLK_ENABLE_RESERVED2 */
#define REG_CLK_ENABLE_RESERVED2          0x00c
#define REG_CLK_ENABLE_RESERVED2_MASK     0x00000008
#define REG_CLK_ENABLE_RESERVED2_SHIFT    3
#define REG_CLK_ENABLE_RESERVED2_WIDTH    1

/* USB_SYS_CLK_ENABLE */
#define REG_USB_SYS_CLK_ENABLE          0x00c
#define REG_USB_SYS_CLK_ENABLE_MASK     0x00000010
#define REG_USB_SYS_CLK_ENABLE_SHIFT    4
#define REG_USB_SYS_CLK_ENABLE_WIDTH    1

/* GMAC1_CLK_ENABLE */
#define REG_GMAC1_CLK_ENABLE          0x00c
#define REG_GMAC1_CLK_ENABLE_MASK     0x00000020
#define REG_GMAC1_CLK_ENABLE_SHIFT    5
#define REG_GMAC1_CLK_ENABLE_WIDTH    1

/* NPU_TO_UPP_MIPS_DIRECT_INT_SET */
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_SET          0x010
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_SET_MASK     0x00000003
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_SET_SHIFT    0
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_SET_WIDTH    2

/* NPU_TO_UPP_MIPS_INT_SET */
#define REG_NPU_TO_UPP_MIPS_INT_SET          0x010
#define REG_NPU_TO_UPP_MIPS_INT_SET_MASK     0xfffffffc
#define REG_NPU_TO_UPP_MIPS_INT_SET_SHIFT    2
#define REG_NPU_TO_UPP_MIPS_INT_SET_WIDTH    30

/* NPU_TO_UPP_MIPS_DIRECT_INT_ENABLE */
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_ENABLE          0x014
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_ENABLE_MASK     0x00000003
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_ENABLE_SHIFT    0
#define REG_NPU_TO_UPP_MIPS_DIRECT_INT_ENABLE_WIDTH    2

/* NPU_TO_UPP_MIPS_INT_ENABLE */
#define REG_NPU_TO_UPP_MIPS_INT_ENABLE          0x014
#define REG_NPU_TO_UPP_MIPS_INT_ENABLE_MASK     0xfffffffc
#define REG_NPU_TO_UPP_MIPS_INT_ENABLE_SHIFT    2
#define REG_NPU_TO_UPP_MIPS_INT_ENABLE_WIDTH    30

/* NPU_INT_CLEAR */
#define REG_NPU_INT_CLEAR          0x018
#define REG_NPU_INT_CLEAR_MASK     0xffffffff
#define REG_NPU_INT_CLEAR_SHIFT    0
#define REG_NPU_INT_CLEAR_WIDTH    32

/* UPP_MIPS_TO_NPU_INT_ENABLE */
#define REG_UPP_MIPS_TO_NPU_INT_ENABLE          0x01c
#define REG_UPP_MIPS_TO_NPU_INT_ENABLE_MASK     0xffffffff
#define REG_UPP_MIPS_TO_NPU_INT_ENABLE_SHIFT    0
#define REG_UPP_MIPS_TO_NPU_INT_ENABLE_WIDTH    32

/* UPP_MIPS_SW_RST_STB_ENA */
#define REG_UPP_MIPS_SW_RST_STB_ENA          0x024
#define REG_UPP_MIPS_SW_RST_STB_ENA_MASK     0x00000001
#define REG_UPP_MIPS_SW_RST_STB_ENA_SHIFT    0
#define REG_UPP_MIPS_SW_RST_STB_ENA_WIDTH    1

/* SOFT_RESET_STB_ENA_RESERVED1 */
#define REG_SOFT_RESET_STB_ENA_RESERVED1          0x024
#define REG_SOFT_RESET_STB_ENA_RESERVED1_MASK     0x00000002
#define REG_SOFT_RESET_STB_ENA_RESERVED1_SHIFT    1
#define REG_SOFT_RESET_STB_ENA_RESERVED1_WIDTH    1

/* NPU_MIPS_SW_RST_STB_ENA */
#define REG_NPU_MIPS_SW_RST_STB_ENA          0x024
#define REG_NPU_MIPS_SW_RST_STB_ENA_MASK     0x00000004
#define REG_NPU_MIPS_SW_RST_STB_ENA_SHIFT    2
#define REG_NPU_MIPS_SW_RST_STB_ENA_WIDTH    1

/* SOFT_RESET_STB_ENA_RESERVED2 */
#define REG_SOFT_RESET_STB_ENA_RESERVED2          0x024
#define REG_SOFT_RESET_STB_ENA_RESERVED2_MASK     0x00000008
#define REG_SOFT_RESET_STB_ENA_RESERVED2_SHIFT    3
#define REG_SOFT_RESET_STB_ENA_RESERVED2_WIDTH    1

/* GMAC0_SW_RST_STB_ENA */
#define REG_GMAC0_SW_RST_STB_ENA          0x024
#define REG_GMAC0_SW_RST_STB_ENA_MASK     0x00000010
#define REG_GMAC0_SW_RST_STB_ENA_SHIFT    4
#define REG_GMAC0_SW_RST_STB_ENA_WIDTH    1

/* USB_CORE_AHB_SW_RST_STB_ENA */
#define REG_USB_CORE_AHB_SW_RST_STB_ENA          0x024
#define REG_USB_CORE_AHB_SW_RST_STB_ENA_MASK     0x00000020
#define REG_USB_CORE_AHB_SW_RST_STB_ENA_SHIFT    5
#define REG_USB_CORE_AHB_SW_RST_STB_ENA_WIDTH    1

/* USB_CORE_PHY_SW_RST_STB_ENA */
#define REG_USB_CORE_PHY_SW_RST_STB_ENA          0x024
#define REG_USB_CORE_PHY_SW_RST_STB_ENA_MASK     0x00000040
#define REG_USB_CORE_PHY_SW_RST_STB_ENA_SHIFT    6
#define REG_USB_CORE_PHY_SW_RST_STB_ENA_WIDTH    1

/* SOFT_RESET_STB_ENA_RESERVED3 */
#define REG_SOFT_RESET_STB_ENA_RESERVED3          0x024
#define REG_SOFT_RESET_STB_ENA_RESERVED3_MASK     0x00000180
#define REG_SOFT_RESET_STB_ENA_RESERVED3_SHIFT    7
#define REG_SOFT_RESET_STB_ENA_RESERVED3_WIDTH    2

/* DDR_AHB_PRT0_SW_RST_STB_ENA */
#define REG_DDR_AHB_PRT0_SW_RST_STB_ENA          0x024
#define REG_DDR_AHB_PRT0_SW_RST_STB_ENA_MASK     0x00000200
#define REG_DDR_AHB_PRT0_SW_RST_STB_ENA_SHIFT    9
#define REG_DDR_AHB_PRT0_SW_RST_STB_ENA_WIDTH    1

/* DDR_AHB_PRT1_SW_RST_STB_ENA */
#define REG_DDR_AHB_PRT1_SW_RST_STB_ENA          0x024
#define REG_DDR_AHB_PRT1_SW_RST_STB_ENA_MASK     0x00000400
#define REG_DDR_AHB_PRT1_SW_RST_STB_ENA_SHIFT    10
#define REG_DDR_AHB_PRT1_SW_RST_STB_ENA_WIDTH    1

/* DDR_AHB_PRT2_SW_RST_STB_ENA */
#define REG_DDR_AHB_PRT2_SW_RST_STB_ENA          0x024
#define REG_DDR_AHB_PRT2_SW_RST_STB_ENA_MASK     0x00000800
#define REG_DDR_AHB_PRT2_SW_RST_STB_ENA_SHIFT    11
#define REG_DDR_AHB_PRT2_SW_RST_STB_ENA_WIDTH    1

/* DDR_AHB_PRT3_SW_RST_STB_ENA */
#define REG_DDR_AHB_PRT3_SW_RST_STB_ENA          0x024
#define REG_DDR_AHB_PRT3_SW_RST_STB_ENA_MASK     0x00001000
#define REG_DDR_AHB_PRT3_SW_RST_STB_ENA_SHIFT    12
#define REG_DDR_AHB_PRT3_SW_RST_STB_ENA_WIDTH    1

/* DDR_AHB_PRT4_SW_RST_STB_ENA */
#define REG_DDR_AHB_PRT4_SW_RST_STB_ENA          0x024
#define REG_DDR_AHB_PRT4_SW_RST_STB_ENA_MASK     0x00002000
#define REG_DDR_AHB_PRT4_SW_RST_STB_ENA_SHIFT    13
#define REG_DDR_AHB_PRT4_SW_RST_STB_ENA_WIDTH    1

/* GMAC1_SW_RST_STB_ENA */
#define REG_GMAC1_SW_RST_STB_ENA          0x024
#define REG_GMAC1_SW_RST_STB_ENA_MASK     0x00004000
#define REG_GMAC1_SW_RST_STB_ENA_SHIFT    14
#define REG_GMAC1_SW_RST_STB_ENA_WIDTH    1

/* DDRDMA_SW_RST_STB_ENA */
#define REG_DDRDMA_SW_RST_STB_ENA          0x024
#define REG_DDRDMA_SW_RST_STB_ENA_MASK     0x00008000
#define REG_DDRDMA_SW_RST_STB_ENA_SHIFT    15
#define REG_DDRDMA_SW_RST_STB_ENA_WIDTH    1

/* SW_HW_RESET_REQ_STB_ENA */
#define REG_SW_HW_RESET_REQ_STB_ENA          0x024
#define REG_SW_HW_RESET_REQ_STB_ENA_MASK     0x00010000
#define REG_SW_HW_RESET_REQ_STB_ENA_SHIFT    16
#define REG_SW_HW_RESET_REQ_STB_ENA_WIDTH    1

/* GMAC0_RX_FIFO_RM */
#define REG_GMAC0_RX_FIFO_RM          0x060
#define REG_GMAC0_RX_FIFO_RM_MASK     0x00000007
#define REG_GMAC0_RX_FIFO_RM_SHIFT    0
#define REG_GMAC0_RX_FIFO_RM_WIDTH    3

/* GMAC0_TX_FIFO_RM */
#define REG_GMAC0_TX_FIFO_RM          0x060
#define REG_GMAC0_TX_FIFO_RM_MASK     0x00000070
#define REG_GMAC0_TX_FIFO_RM_SHIFT    4
#define REG_GMAC0_TX_FIFO_RM_WIDTH    3

/* GMAC1_RX_FIFO_RM */
#define REG_GMAC1_RX_FIFO_RM          0x060
#define REG_GMAC1_RX_FIFO_RM_MASK     0x00000700
#define REG_GMAC1_RX_FIFO_RM_SHIFT    8
#define REG_GMAC1_RX_FIFO_RM_WIDTH    3

/* GMAC1_TX_FIFO_RM */
#define REG_GMAC1_TX_FIFO_RM          0x060
#define REG_GMAC1_TX_FIFO_RM_MASK     0x00007000
#define REG_GMAC1_TX_FIFO_RM_SHIFT    12
#define REG_GMAC1_TX_FIFO_RM_WIDTH    3

/* GMAC0_DLY_PHY_CLK_RX */
#define REG_GMAC0_DLY_PHY_CLK_RX          0x064
#define REG_GMAC0_DLY_PHY_CLK_RX_MASK     0x0000003f
#define REG_GMAC0_DLY_PHY_CLK_RX_SHIFT    0
#define REG_GMAC0_DLY_PHY_CLK_RX_WIDTH    6

/* GMAC0_DLY_PHY_CLK_TX */
#define REG_GMAC0_DLY_PHY_CLK_TX          0x064
#define REG_GMAC0_DLY_PHY_CLK_TX_MASK     0x00003f00
#define REG_GMAC0_DLY_PHY_CLK_TX_SHIFT    8
#define REG_GMAC0_DLY_PHY_CLK_TX_WIDTH    6

/* GMAC1_DLY_PHY_CLK_RX */
#define REG_GMAC1_DLY_PHY_CLK_RX          0x064
#define REG_GMAC1_DLY_PHY_CLK_RX_MASK     0x003f0000
#define REG_GMAC1_DLY_PHY_CLK_RX_SHIFT    16
#define REG_GMAC1_DLY_PHY_CLK_RX_WIDTH    6

/* GMAC1_DLY_PHY_CLK_TX */
#define REG_GMAC1_DLY_PHY_CLK_TX          0x064
#define REG_GMAC1_DLY_PHY_CLK_TX_MASK     0x3f000000
#define REG_GMAC1_DLY_PHY_CLK_TX_SHIFT    24
#define REG_GMAC1_DLY_PHY_CLK_TX_WIDTH    6

/* GMAC0_SEL_CLK_SWITCH */
#define REG_GMAC0_SEL_CLK_SWITCH          0x068
#define REG_GMAC0_SEL_CLK_SWITCH_MASK     0x00000003
#define REG_GMAC0_SEL_CLK_SWITCH_SHIFT    0
#define REG_GMAC0_SEL_CLK_SWITCH_WIDTH    2

/* GMAC0_DIV_CLK_SRC_SEL */
#define REG_GMAC0_DIV_CLK_SRC_SEL          0x068
#define REG_GMAC0_DIV_CLK_SRC_SEL_MASK     0x0000000c
#define REG_GMAC0_DIV_CLK_SRC_SEL_SHIFT    2
#define REG_GMAC0_DIV_CLK_SRC_SEL_WIDTH    2

/* GMAC_PHY_CLK_REF_OE_N */
#define REG_GMAC_PHY_CLK_REF_OE_N          0x068
#define REG_GMAC_PHY_CLK_REF_OE_N_MASK     0x00000010
#define REG_GMAC_PHY_CLK_REF_OE_N_SHIFT    4
#define REG_GMAC_PHY_CLK_REF_OE_N_WIDTH    1

/* GMAC0_INV_PHY_CLK_TX_OUT */
#define REG_GMAC0_INV_PHY_CLK_TX_OUT          0x068
#define REG_GMAC0_INV_PHY_CLK_TX_OUT_MASK     0x00000040
#define REG_GMAC0_INV_PHY_CLK_TX_OUT_SHIFT    6
#define REG_GMAC0_INV_PHY_CLK_TX_OUT_WIDTH    1

/* GMAC0_PHY_INTF_SEL */
#define REG_GMAC0_PHY_INTF_SEL          0x068
#define REG_GMAC0_PHY_INTF_SEL_MASK     0x00000380
#define REG_GMAC0_PHY_INTF_SEL_SHIFT    7
#define REG_GMAC0_PHY_INTF_SEL_WIDTH    3

/* GMAC0_PHY_CLK_RX_OE_N */
#define REG_GMAC0_PHY_CLK_RX_OE_N          0x068
#define REG_GMAC0_PHY_CLK_RX_OE_N_MASK     0x00000400
#define REG_GMAC0_PHY_CLK_RX_OE_N_SHIFT    10
#define REG_GMAC0_PHY_CLK_RX_OE_N_WIDTH    1

/* GMAC0_PHY_CLK_TX_OE_N */
#define REG_GMAC0_PHY_CLK_TX_OE_N          0x068
#define REG_GMAC0_PHY_CLK_TX_OE_N_MASK     0x00000800
#define REG_GMAC0_PHY_CLK_TX_OE_N_SHIFT    11
#define REG_GMAC0_PHY_CLK_TX_OE_N_WIDTH    1

/* GMAC0_USE_EXT_PHY_CLK_TX */
#define REG_GMAC0_USE_EXT_PHY_CLK_TX          0x068
#define REG_GMAC0_USE_EXT_PHY_CLK_TX_MASK     0x00001000
#define REG_GMAC0_USE_EXT_PHY_CLK_TX_SHIFT    12
#define REG_GMAC0_USE_EXT_PHY_CLK_TX_WIDTH    1

/* GMII_MODE */
#define REG_GMII_MODE          0x068
#define REG_GMII_MODE_MASK     0x00002000
#define REG_GMII_MODE_SHIFT    13
#define REG_GMII_MODE_WIDTH    1

/* PHY_CLK_REF_OE_N */
#define REG_PHY_CLK_REF_OE_N          0x068
#define REG_PHY_CLK_REF_OE_N_MASK     0x00004000
#define REG_PHY_CLK_REF_OE_N_SHIFT    14
#define REG_PHY_CLK_REF_OE_N_WIDTH    1

/* GMAC1_SEL_CLK_SWITCH */
#define REG_GMAC1_SEL_CLK_SWITCH          0x068
#define REG_GMAC1_SEL_CLK_SWITCH_MASK     0x00030000
#define REG_GMAC1_SEL_CLK_SWITCH_SHIFT    16
#define REG_GMAC1_SEL_CLK_SWITCH_WIDTH    2

/* GMAC1_DIV_CLK_SRC_SEL */
#define REG_GMAC1_DIV_CLK_SRC_SEL          0x068
#define REG_GMAC1_DIV_CLK_SRC_SEL_MASK     0x000c0000
#define REG_GMAC1_DIV_CLK_SRC_SEL_SHIFT    18
#define REG_GMAC1_DIV_CLK_SRC_SEL_WIDTH    2

/* GMAC1_INV_PHY_CLK_TX_OUT */
#define REG_GMAC1_INV_PHY_CLK_TX_OUT          0x068
#define REG_GMAC1_INV_PHY_CLK_TX_OUT_MASK     0x00400000
#define REG_GMAC1_INV_PHY_CLK_TX_OUT_SHIFT    22
#define REG_GMAC1_INV_PHY_CLK_TX_OUT_WIDTH    1

/* GMAC1_PHY_INTF_SEL */
#define REG_GMAC1_PHY_INTF_SEL          0x068
#define REG_GMAC1_PHY_INTF_SEL_MASK     0x01800000
#define REG_GMAC1_PHY_INTF_SEL_SHIFT    23
#define REG_GMAC1_PHY_INTF_SEL_WIDTH    2

/* GMAC1_PHY_CLK_RX_OE_N */
#define REG_GMAC1_PHY_CLK_RX_OE_N          0x068
#define REG_GMAC1_PHY_CLK_RX_OE_N_MASK     0x02000000
#define REG_GMAC1_PHY_CLK_RX_OE_N_SHIFT    25
#define REG_GMAC1_PHY_CLK_RX_OE_N_WIDTH    1

/* GMAC1_PHY_CLK_TX_OE_N */
#define REG_GMAC1_PHY_CLK_TX_OE_N          0x068
#define REG_GMAC1_PHY_CLK_TX_OE_N_MASK     0x04000000
#define REG_GMAC1_PHY_CLK_TX_OE_N_SHIFT    26
#define REG_GMAC1_PHY_CLK_TX_OE_N_WIDTH    1

/* GMAC_SMA_LP */
#define REG_GMAC_SMA_LP          0x068
#define REG_GMAC_SMA_LP_MASK     0x08000000
#define REG_GMAC_SMA_LP_SHIFT    27
#define REG_GMAC_SMA_LP_WIDTH    1

/* GMAC1_MSTR_SMA */
#define REG_GMAC1_MSTR_SMA          0x068
#define REG_GMAC1_MSTR_SMA_MASK     0x10000000
#define REG_GMAC1_MSTR_SMA_SHIFT    28
#define REG_GMAC1_MSTR_SMA_WIDTH    1

/* GMAC_REVMII_SYNPS */
#define REG_GMAC_REVMII_SYNPS          0x068
#define REG_GMAC_REVMII_SYNPS_MASK     0x20000000
#define REG_GMAC_REVMII_SYNPS_SHIFT    29
#define REG_GMAC_REVMII_SYNPS_WIDTH    1

/* GMAC0_REF_CLK_SEL */
#define REG_GMAC0_REF_CLK_SEL          0x068
#define REG_GMAC0_REF_CLK_SEL_MASK     0x40000000
#define REG_GMAC0_REF_CLK_SEL_SHIFT    30
#define REG_GMAC0_REF_CLK_SEL_WIDTH    1

/* GMAC1_REF_CLK_SEL */
#define REG_GMAC1_REF_CLK_SEL          0x068
#define REG_GMAC1_REF_CLK_SEL_MASK     0x80000000
#define REG_GMAC1_REF_CLK_SEL_SHIFT    31
#define REG_GMAC1_REF_CLK_SEL_WIDTH    1

/* OCP_BRIDGE_READ_STATE */
#define REG_OCP_BRIDGE_READ_STATE          0x06c
#define REG_OCP_BRIDGE_READ_STATE_MASK     0x00000003
#define REG_OCP_BRIDGE_READ_STATE_SHIFT    0
#define REG_OCP_BRIDGE_READ_STATE_WIDTH    2

/* OCP_BRIDGE_WRITE_STATE */
#define REG_OCP_BRIDGE_WRITE_STATE          0x06c
#define REG_OCP_BRIDGE_WRITE_STATE_MASK     0x0000000c
#define REG_OCP_BRIDGE_WRITE_STATE_SHIFT    2
#define REG_OCP_BRIDGE_WRITE_STATE_WIDTH    2

/* REQ_INFO_BUFFERABLE */
#define REG_REQ_INFO_BUFFERABLE          0x070
#define REG_REQ_INFO_BUFFERABLE_MASK     0x00000001
#define REG_REQ_INFO_BUFFERABLE_SHIFT    0
#define REG_REQ_INFO_BUFFERABLE_WIDTH    1

/* BB_DDR_BASE_ADDR */
#define REG_BB_DDR_BASE_ADDR          0x074
#define REG_BB_DDR_BASE_ADDR_MASK     0x0000003f
#define REG_BB_DDR_BASE_ADDR_SHIFT    0
#define REG_BB_DDR_BASE_ADDR_WIDTH    6

/* REG_ACC_ARB_MODE */
#define REG_REG_ACC_ARB_MODE          0x07c
#define REG_REG_ACC_ARB_MODE_MASK     0x00000003
#define REG_REG_ACC_ARB_MODE_SHIFT    0
#define REG_REG_ACC_ARB_MODE_WIDTH    2

/* REG_ACC_ARB_PRIORITY_ORDER */
#define REG_REG_ACC_ARB_PRIORITY_ORDER          0x07c
#define REG_REG_ACC_ARB_PRIORITY_ORDER_MASK     0x000003fc
#define REG_REG_ACC_ARB_PRIORITY_ORDER_SHIFT    2
#define REG_REG_ACC_ARB_PRIORITY_ORDER_WIDTH    8

/* REG_ACC_ARB_WEIGHTED_RR_LIST */
#define REG_REG_ACC_ARB_WEIGHTED_RR_LIST          0x07c
#define REG_REG_ACC_ARB_WEIGHTED_RR_LIST_MASK     0x03fffc00
#define REG_REG_ACC_ARB_WEIGHTED_RR_LIST_SHIFT    10
#define REG_REG_ACC_ARB_WEIGHTED_RR_LIST_WIDTH    16

/* GMAC0_DIV_RATIO */
#define REG_GMAC0_DIV_RATIO          0x080
#define REG_GMAC0_DIV_RATIO_MASK     0x0000007f
#define REG_GMAC0_DIV_RATIO_SHIFT    0
#define REG_GMAC0_DIV_RATIO_WIDTH    7

/* GMAC0_INV_PHY_CLK_RX */
#define REG_GMAC0_INV_PHY_CLK_RX          0x080
#define REG_GMAC0_INV_PHY_CLK_RX_MASK     0x00000080
#define REG_GMAC0_INV_PHY_CLK_RX_SHIFT    7
#define REG_GMAC0_INV_PHY_CLK_RX_WIDTH    1

/* GMAC1_DIV_RATIO */
#define REG_GMAC1_DIV_RATIO          0x080
#define REG_GMAC1_DIV_RATIO_MASK     0x00007f00
#define REG_GMAC1_DIV_RATIO_SHIFT    8
#define REG_GMAC1_DIV_RATIO_WIDTH    7

/* GMAC1_INV_PHY_CLK_RX */
#define REG_GMAC1_INV_PHY_CLK_RX          0x080
#define REG_GMAC1_INV_PHY_CLK_RX_MASK     0x00008000
#define REG_GMAC1_INV_PHY_CLK_RX_SHIFT    15
#define REG_GMAC1_INV_PHY_CLK_RX_WIDTH    1

/* GMAC_IDDQ */
#define REG_GMAC_IDDQ          0x084
#define REG_GMAC_IDDQ_MASK     0x00000001
#define REG_GMAC_IDDQ_SHIFT    0
#define REG_GMAC_IDDQ_WIDTH    1

/* GMAC0_CORE_PHY_ADDR */
#define REG_GMAC0_CORE_PHY_ADDR          0x084
#define REG_GMAC0_CORE_PHY_ADDR_MASK     0x0000003e
#define REG_GMAC0_CORE_PHY_ADDR_SHIFT    1
#define REG_GMAC0_CORE_PHY_ADDR_WIDTH    5

/* GMAC0_REVMII_PHY_ADDR */
#define REG_GMAC0_REVMII_PHY_ADDR          0x084
#define REG_GMAC0_REVMII_PHY_ADDR_MASK     0x000007c0
#define REG_GMAC0_REVMII_PHY_ADDR_SHIFT    6
#define REG_GMAC0_REVMII_PHY_ADDR_WIDTH    5

/* DDR_D_LOW_S1 */
#define REG_DDR_D_LOW_S1          0x088
#define REG_DDR_D_LOW_S1_MASK     0x00000001
#define REG_DDR_D_LOW_S1_SHIFT    0
#define REG_DDR_D_LOW_S1_WIDTH    1

/* DDR_D_HIGH_S1 */
#define REG_DDR_D_HIGH_S1          0x088
#define REG_DDR_D_HIGH_S1_MASK     0x00000002
#define REG_DDR_D_HIGH_S1_SHIFT    1
#define REG_DDR_D_HIGH_S1_WIDTH    1

/* DDR_CTL_S1 */
#define REG_DDR_CTL_S1          0x088
#define REG_DDR_CTL_S1_MASK     0x00000004
#define REG_DDR_CTL_S1_SHIFT    2
#define REG_DDR_CTL_S1_WIDTH    1

/* GMAC0_MST_SHRAM_ACCESS */
#define REG_GMAC0_MST_SHRAM_ACCESS          0x08c
#define REG_GMAC0_MST_SHRAM_ACCESS_MASK     0x00000001
#define REG_GMAC0_MST_SHRAM_ACCESS_SHIFT    0
#define REG_GMAC0_MST_SHRAM_ACCESS_WIDTH    1

/* GMAC1_MST_SHRAM_ACCESS */
#define REG_GMAC1_MST_SHRAM_ACCESS          0x08c
#define REG_GMAC1_MST_SHRAM_ACCESS_MASK     0x00000002
#define REG_GMAC1_MST_SHRAM_ACCESS_SHIFT    1
#define REG_GMAC1_MST_SHRAM_ACCESS_WIDTH    1

/* GMAC0_GMAC1_MST_SHRAM_SELECT */
#define REG_GMAC0_GMAC1_MST_SHRAM_SELECT          0x08c
#define REG_GMAC0_GMAC1_MST_SHRAM_SELECT_MASK     0x00000004
#define REG_GMAC0_GMAC1_MST_SHRAM_SELECT_SHIFT    2
#define REG_GMAC0_GMAC1_MST_SHRAM_SELECT_WIDTH    1

/* GMAC0_SBD_FLOWCTRL */
#define REG_GMAC0_SBD_FLOWCTRL          0x094
#define REG_GMAC0_SBD_FLOWCTRL_MASK     0x00000001
#define REG_GMAC0_SBD_FLOWCTRL_SHIFT    0
#define REG_GMAC0_SBD_FLOWCTRL_WIDTH    1

/* GMAC1_SBD_FLOWCTRL */
#define REG_GMAC1_SBD_FLOWCTRL          0x094
#define REG_GMAC1_SBD_FLOWCTRL_MASK     0x00000002
#define REG_GMAC1_SBD_FLOWCTRL_SHIFT    1
#define REG_GMAC1_SBD_FLOWCTRL_WIDTH    1

/* WATCH_DOG_ENABLE */
#define REG_WATCH_DOG_ENABLE          0x0ac
#define REG_WATCH_DOG_ENABLE_MASK     0x00000001
#define REG_WATCH_DOG_ENABLE_SHIFT    0
#define REG_WATCH_DOG_ENABLE_WIDTH    1

/* UPP_MIPS_DIRECT_INT_CLEAR */
#define REG_UPP_MIPS_DIRECT_INT_CLEAR          0x110
#define REG_UPP_MIPS_DIRECT_INT_CLEAR_MASK     0x00000003
#define REG_UPP_MIPS_DIRECT_INT_CLEAR_SHIFT    0
#define REG_UPP_MIPS_DIRECT_INT_CLEAR_WIDTH    2

/* UPP_MIPS_INT_CLEAR */
#define REG_UPP_MIPS_INT_CLEAR          0x110
#define REG_UPP_MIPS_INT_CLEAR_MASK     0xfffffffc
#define REG_UPP_MIPS_INT_CLEAR_SHIFT    2
#define REG_UPP_MIPS_INT_CLEAR_WIDTH    30

/* UPP_MIPS_TO_NPU_INT_SET */
#define REG_UPP_MIPS_TO_NPU_INT_SET          0x118
#define REG_UPP_MIPS_TO_NPU_INT_SET_MASK     0xffffffff
#define REG_UPP_MIPS_TO_NPU_INT_SET_SHIFT    0
#define REG_UPP_MIPS_TO_NPU_INT_SET_WIDTH    32

/* EFUSE_DATA_Q_SAMP */
#define REG_EFUSE_DATA_Q_SAMP          0x120
#define REG_EFUSE_DATA_Q_SAMP_MASK     0x000000ff
#define REG_EFUSE_DATA_Q_SAMP_SHIFT    0
#define REG_EFUSE_DATA_Q_SAMP_WIDTH    8

/* NPU_EFUSE_ADDR */
#define REG_NPU_EFUSE_ADDR          0x124
#define REG_NPU_EFUSE_ADDR_MASK     0x00000fff
#define REG_NPU_EFUSE_ADDR_SHIFT    0
#define REG_NPU_EFUSE_ADDR_WIDTH    12

/* NPU_EFUSE_WR_RD */
#define REG_NPU_EFUSE_WR_RD          0x128
#define REG_NPU_EFUSE_WR_RD_MASK     0x00000001
#define REG_NPU_EFUSE_WR_RD_SHIFT    0
#define REG_NPU_EFUSE_WR_RD_WIDTH    1

/* EFUSE_CONTROL_BUSY */
#define REG_EFUSE_CONTROL_BUSY          0x12c
#define REG_EFUSE_CONTROL_BUSY_MASK     0x00000001
#define REG_EFUSE_CONTROL_BUSY_SHIFT    0
#define REG_EFUSE_CONTROL_BUSY_WIDTH    1

/* EFUSE_INIT_DONE */
#define REG_EFUSE_INIT_DONE          0x12c
#define REG_EFUSE_INIT_DONE_MASK     0x00000002
#define REG_EFUSE_INIT_DONE_SHIFT    1
#define REG_EFUSE_INIT_DONE_WIDTH    1

/* EFUSE_CONTROL_SM */
#define REG_EFUSE_CONTROL_SM          0x12c
#define REG_EFUSE_CONTROL_SM_MASK     0x0000000c
#define REG_EFUSE_CONTROL_SM_SHIFT    2
#define REG_EFUSE_CONTROL_SM_WIDTH    2

/* EFUSE_INIT_VECTOR0 */
#define REG_EFUSE_INIT_VECTOR0          0x12c
#define REG_EFUSE_INIT_VECTOR0_MASK     0x0000ff00
#define REG_EFUSE_INIT_VECTOR0_SHIFT    8
#define REG_EFUSE_INIT_VECTOR0_WIDTH    8

/* EFUSE_INIT_VECTOR1 */
#define REG_EFUSE_INIT_VECTOR1          0x12c
#define REG_EFUSE_INIT_VECTOR1_MASK     0x00ff0000
#define REG_EFUSE_INIT_VECTOR1_SHIFT    16
#define REG_EFUSE_INIT_VECTOR1_WIDTH    8

/* NPU_EFUSE_TIMER_CONFIG1 */
#define REG_NPU_EFUSE_TIMER_CONFIG1          0x130
#define REG_NPU_EFUSE_TIMER_CONFIG1_MASK     0xffffffff
#define REG_NPU_EFUSE_TIMER_CONFIG1_SHIFT    0
#define REG_NPU_EFUSE_TIMER_CONFIG1_WIDTH    32

/* NPU_EFUSE_TIMER_CONFIG2 */
#define REG_NPU_EFUSE_TIMER_CONFIG2          0x134
#define REG_NPU_EFUSE_TIMER_CONFIG2_MASK     0xffffffff
#define REG_NPU_EFUSE_TIMER_CONFIG2_SHIFT    0
#define REG_NPU_EFUSE_TIMER_CONFIG2_WIDTH    32

/* IDPULLUP */
#define REG_IDPULLUP          0x200
#define REG_IDPULLUP_MASK     0x00000001
#define REG_IDPULLUP_SHIFT    0
#define REG_IDPULLUP_WIDTH    1

/* CHRGVBUS */
#define REG_CHRGVBUS          0x200
#define REG_CHRGVBUS_MASK     0x00000002
#define REG_CHRGVBUS_SHIFT    1
#define REG_CHRGVBUS_WIDTH    1

/* DISCHRGVBUS */
#define REG_DISCHRGVBUS          0x200
#define REG_DISCHRGVBUS_MASK     0x00000004
#define REG_DISCHRGVBUS_SHIFT    2
#define REG_DISCHRGVBUS_WIDTH    1

/* DRVVBUS */
#define REG_DRVVBUS          0x200
#define REG_DRVVBUS_MASK     0x00000008
#define REG_DRVVBUS_SHIFT    3
#define REG_DRVVBUS_WIDTH    1

/* OTGDISABLE */
#define REG_OTGDISABLE          0x200
#define REG_OTGDISABLE_MASK     0x00000010
#define REG_OTGDISABLE_SHIFT    4
#define REG_OTGDISABLE_WIDTH    1

/* DPPULLDOWN_DEVICE */
#define REG_DPPULLDOWN_DEVICE          0x200
#define REG_DPPULLDOWN_DEVICE_MASK     0x00000020
#define REG_DPPULLDOWN_DEVICE_SHIFT    5
#define REG_DPPULLDOWN_DEVICE_WIDTH    1

/* DMPULLDOWN_DEVICE */
#define REG_DMPULLDOWN_DEVICE          0x200
#define REG_DMPULLDOWN_DEVICE_MASK     0x00000040
#define REG_DMPULLDOWN_DEVICE_SHIFT    6
#define REG_DMPULLDOWN_DEVICE_WIDTH    1

/* DPPULLDOWN_HOST */
#define REG_DPPULLDOWN_HOST          0x200
#define REG_DPPULLDOWN_HOST_MASK     0x00000080
#define REG_DPPULLDOWN_HOST_SHIFT    7
#define REG_DPPULLDOWN_HOST_WIDTH    1

/* DMPULLDOWN_HOST */
#define REG_DMPULLDOWN_HOST          0x200
#define REG_DMPULLDOWN_HOST_MASK     0x00000100
#define REG_DMPULLDOWN_HOST_SHIFT    8
#define REG_DMPULLDOWN_HOST_WIDTH    1

/* VBUSVLDEXTSEL_DEVICE */
#define REG_VBUSVLDEXTSEL_DEVICE          0x200
#define REG_VBUSVLDEXTSEL_DEVICE_MASK     0x00000200
#define REG_VBUSVLDEXTSEL_DEVICE_SHIFT    9
#define REG_VBUSVLDEXTSEL_DEVICE_WIDTH    1

/* VBUSVLDEXTSEL_HOST */
#define REG_VBUSVLDEXTSEL_HOST          0x200
#define REG_VBUSVLDEXTSEL_HOST_MASK     0x00000400
#define REG_VBUSVLDEXTSEL_HOST_SHIFT    10
#define REG_VBUSVLDEXTSEL_HOST_WIDTH    1

/* VBUSVLDEXT */
#define REG_VBUSVLDEXT          0x200
#define REG_VBUSVLDEXT_MASK     0x00000800
#define REG_VBUSVLDEXT_SHIFT    11
#define REG_VBUSVLDEXT_WIDTH    1

/* COMPDISTUNE */
#define REG_COMPDISTUNE          0x204
#define REG_COMPDISTUNE_MASK     0x00000007
#define REG_COMPDISTUNE_SHIFT    0
#define REG_COMPDISTUNE_WIDTH    3

/* OTGTUNE */
#define REG_OTGTUNE          0x204
#define REG_OTGTUNE_MASK     0x00000038
#define REG_OTGTUNE_SHIFT    3
#define REG_OTGTUNE_WIDTH    3

/* SQRXTUNE */
#define REG_SQRXTUNE          0x204
#define REG_SQRXTUNE_MASK     0x000001c0
#define REG_SQRXTUNE_SHIFT    6
#define REG_SQRXTUNE_WIDTH    3

/* TXFSLSTUNE */
#define REG_TXFSLSTUNE          0x204
#define REG_TXFSLSTUNE_MASK     0x00001e00
#define REG_TXFSLSTUNE_SHIFT    9
#define REG_TXFSLSTUNE_WIDTH    4

/* TXPREEMPHASISTUNE */
#define REG_TXPREEMPHASISTUNE          0x204
#define REG_TXPREEMPHASISTUNE_MASK     0x00002000
#define REG_TXPREEMPHASISTUNE_SHIFT    13
#define REG_TXPREEMPHASISTUNE_WIDTH    1

/* TXRISETUNE */
#define REG_TXRISETUNE          0x204
#define REG_TXRISETUNE_MASK     0x00004000
#define REG_TXRISETUNE_SHIFT    14
#define REG_TXRISETUNE_WIDTH    1

/* TXVREFTUNE */
#define REG_TXVREFTUNE          0x204
#define REG_TXVREFTUNE_MASK     0x00078000
#define REG_TXVREFTUNE_SHIFT    15
#define REG_TXVREFTUNE_WIDTH    4

/* TXHSXVTUNE */
#define REG_TXHSXVTUNE          0x204
#define REG_TXHSXVTUNE_MASK     0x00180000
#define REG_TXHSXVTUNE_SHIFT    19
#define REG_TXHSXVTUNE_WIDTH    2

/* REFCLKDIV */
#define REG_REFCLKDIV          0x208
#define REG_REFCLKDIV_MASK     0x00000003
#define REG_REFCLKDIV_SHIFT    0
#define REG_REFCLKDIV_WIDTH    2

/* REFCLKSEL */
#define REG_REFCLKSEL          0x208
#define REG_REFCLKSEL_MASK     0x0000000c
#define REG_REFCLKSEL_SHIFT    2
#define REG_REFCLKSEL_WIDTH    2

/* COMMONONN */
#define REG_COMMONONN          0x208
#define REG_COMMONONN_MASK     0x00000010
#define REG_COMMONONN_SHIFT    4
#define REG_COMMONONN_WIDTH    1

/* OVERRIDE_OPMODE */
#define REG_OVERRIDE_OPMODE          0x20c
#define REG_OVERRIDE_OPMODE_MASK     0x00000001
#define REG_OVERRIDE_OPMODE_SHIFT    0
#define REG_OVERRIDE_OPMODE_WIDTH    1

/* TXBITSTUFFEN */
#define REG_TXBITSTUFFEN          0x20c
#define REG_TXBITSTUFFEN_MASK     0x00000002
#define REG_TXBITSTUFFEN_SHIFT    1
#define REG_TXBITSTUFFEN_WIDTH    1

/* TXBITSTUFFENH */
#define REG_TXBITSTUFFENH          0x20c
#define REG_TXBITSTUFFENH_MASK     0x00000004
#define REG_TXBITSTUFFENH_SHIFT    2
#define REG_TXBITSTUFFENH_WIDTH    1

/* PHY_TEST_OVERRIDE_SIGNALS */
#define REG_PHY_TEST_OVERRIDE_SIGNALS          0x210
#define REG_PHY_TEST_OVERRIDE_SIGNALS_MASK     0x00000001
#define REG_PHY_TEST_OVERRIDE_SIGNALS_SHIFT    0
#define REG_PHY_TEST_OVERRIDE_SIGNALS_WIDTH    1

/* BISTEN */
#define REG_BISTEN          0x210
#define REG_BISTEN_MASK     0x00000002
#define REG_BISTEN_SHIFT    1
#define REG_BISTEN_WIDTH    1

/* LSBIST */
#define REG_LSBIST          0x210
#define REG_LSBIST_MASK     0x00000004
#define REG_LSBIST_SHIFT    2
#define REG_LSBIST_WIDTH    1

/* FSBIST */
#define REG_FSBIST          0x210
#define REG_FSBIST_MASK     0x00000008
#define REG_FSBIST_SHIFT    3
#define REG_FSBIST_WIDTH    1

/* HSBIST */
#define REG_HSBIST          0x210
#define REG_HSBIST_MASK     0x00000010
#define REG_HSBIST_SHIFT    4
#define REG_HSBIST_WIDTH    1

/* BISTERROR */
#define REG_BISTERROR          0x214
#define REG_BISTERROR_MASK     0x00000001
#define REG_BISTERROR_SHIFT    0
#define REG_BISTERROR_WIDTH    1

/* BISTDONE */
#define REG_BISTDONE          0x214
#define REG_BISTDONE_MASK     0x00000002
#define REG_BISTDONE_SHIFT    1
#define REG_BISTDONE_WIDTH    1

/* TESTDATAIN */
#define REG_TESTDATAIN          0x218
#define REG_TESTDATAIN_MASK     0x000000ff
#define REG_TESTDATAIN_SHIFT    0
#define REG_TESTDATAIN_WIDTH    8

/* TESTADDR */
#define REG_TESTADDR          0x218
#define REG_TESTADDR_MASK     0x00000f00
#define REG_TESTADDR_SHIFT    8
#define REG_TESTADDR_WIDTH    4

/* TESTDATAOUTSEL */
#define REG_TESTDATAOUTSEL          0x218
#define REG_TESTDATAOUTSEL_MASK     0x00001000
#define REG_TESTDATAOUTSEL_SHIFT    12
#define REG_TESTDATAOUTSEL_WIDTH    1

/* USB_PHY_TEST_NUMCLK */
#define REG_USB_PHY_TEST_NUMCLK          0x218
#define REG_USB_PHY_TEST_NUMCLK_MASK     0x0001e000
#define REG_USB_PHY_TEST_NUMCLK_SHIFT    13
#define REG_USB_PHY_TEST_NUMCLK_WIDTH    4

/* TESTDATAOUT */
#define REG_TESTDATAOUT          0x21c
#define REG_TESTDATAOUT_MASK     0x0000000f
#define REG_TESTDATAOUT_SHIFT    0
#define REG_TESTDATAOUT_WIDTH    4

/* DATAIN_OVERRIDE */
#define REG_DATAIN_OVERRIDE          0x220
#define REG_DATAIN_OVERRIDE_MASK     0x000000ff
#define REG_DATAIN_OVERRIDE_SHIFT    0
#define REG_DATAIN_OVERRIDE_WIDTH    8

/* DATAINH_OVERRIDE */
#define REG_DATAINH_OVERRIDE          0x220
#define REG_DATAINH_OVERRIDE_MASK     0x0000ff00
#define REG_DATAINH_OVERRIDE_SHIFT    8
#define REG_DATAINH_OVERRIDE_WIDTH    8

/* TXVALID_OVERRIDE */
#define REG_TXVALID_OVERRIDE          0x220
#define REG_TXVALID_OVERRIDE_MASK     0x00010000
#define REG_TXVALID_OVERRIDE_SHIFT    16
#define REG_TXVALID_OVERRIDE_WIDTH    1

/* TXVALIDH_OVERRIDE */
#define REG_TXVALIDH_OVERRIDE          0x220
#define REG_TXVALIDH_OVERRIDE_MASK     0x00020000
#define REG_TXVALIDH_OVERRIDE_SHIFT    17
#define REG_TXVALIDH_OVERRIDE_WIDTH    1

/* OPMODE_OVERRIDE */
#define REG_OPMODE_OVERRIDE          0x220
#define REG_OPMODE_OVERRIDE_MASK     0x000c0000
#define REG_OPMODE_OVERRIDE_SHIFT    18
#define REG_OPMODE_OVERRIDE_WIDTH    2

/* TERMSEL_OVERRIDE */
#define REG_TERMSEL_OVERRIDE          0x220
#define REG_TERMSEL_OVERRIDE_MASK     0x00100000
#define REG_TERMSEL_OVERRIDE_SHIFT    20
#define REG_TERMSEL_OVERRIDE_WIDTH    1

/* XCVRSEL_OVERRIDE */
#define REG_XCVRSEL_OVERRIDE          0x220
#define REG_XCVRSEL_OVERRIDE_MASK     0x00600000
#define REG_XCVRSEL_OVERRIDE_SHIFT    21
#define REG_XCVRSEL_OVERRIDE_WIDTH    2

/* SUSPENDM_OVERRIDE */
#define REG_SUSPENDM_OVERRIDE          0x220
#define REG_SUSPENDM_OVERRIDE_MASK     0x00800000
#define REG_SUSPENDM_OVERRIDE_SHIFT    23
#define REG_SUSPENDM_OVERRIDE_WIDTH    1

/* VATESTENB */
#define REG_VATESTENB          0x224
#define REG_VATESTENB_MASK     0x00000001
#define REG_VATESTENB_SHIFT    0
#define REG_VATESTENB_WIDTH    1

/* SIDDQ */
#define REG_SIDDQ          0x224
#define REG_SIDDQ_MASK     0x00000002
#define REG_SIDDQ_SHIFT    1
#define REG_SIDDQ_WIDTH    1

/* LOOPBACKENB */
#define REG_LOOPBACKENB          0x224
#define REG_LOOPBACKENB_MASK     0x00000004
#define REG_LOOPBACKENB_SHIFT    2
#define REG_LOOPBACKENB_WIDTH    1

/* POR */
#define REG_POR          0x228
#define REG_POR_MASK     0x00000001
#define REG_POR_SHIFT    0
#define REG_POR_WIDTH    1

/* PORTRESET */
#define REG_PORTRESET          0x228
#define REG_PORTRESET_MASK     0x00000002
#define REG_PORTRESET_SHIFT    1
#define REG_PORTRESET_WIDTH    1

/* ATERESET */
#define REG_ATERESET          0x228
#define REG_ATERESET_MASK     0x00000004
#define REG_ATERESET_SHIFT    2
#define REG_ATERESET_WIDTH    1

/* SLEEPM */
#define REG_SLEEPM          0x228
#define REG_SLEEPM_MASK     0x00000008
#define REG_SLEEPM_SHIFT    3
#define REG_SLEEPM_WIDTH    1

/* DEVICE_SESSION_VALID_INDICATOR_SEL */
#define REG_DEVICE_SESSION_VALID_INDICATOR_SEL          0x22c
#define REG_DEVICE_SESSION_VALID_INDICATOR_SEL_MASK     0x00000001
#define REG_DEVICE_SESSION_VALID_INDICATOR_SEL_SHIFT    0
#define REG_DEVICE_SESSION_VALID_INDICATOR_SEL_WIDTH    1

/* VBUS_VALID_FILTER_SEL */
#define REG_VBUS_VALID_FILTER_SEL          0x22c
#define REG_VBUS_VALID_FILTER_SEL_MASK     0x00000002
#define REG_VBUS_VALID_FILTER_SEL_SHIFT    1
#define REG_VBUS_VALID_FILTER_SEL_WIDTH    1

/* LINESTATE */
#define REG_LINESTATE          0x230
#define REG_LINESTATE_MASK     0x00000003
#define REG_LINESTATE_SHIFT    0
#define REG_LINESTATE_WIDTH    2

/* UTMI_SUSPEND_N */
#define REG_UTMI_SUSPEND_N          0x230
#define REG_UTMI_SUSPEND_N_MASK     0x00000004
#define REG_UTMI_SUSPEND_N_SHIFT    2
#define REG_UTMI_SUSPEND_N_WIDTH    1

/* AVALID */
#define REG_AVALID          0x230
#define REG_AVALID_MASK     0x00000008
#define REG_AVALID_SHIFT    3
#define REG_AVALID_WIDTH    1

/* BVALID */
#define REG_BVALID          0x230
#define REG_BVALID_MASK     0x00000010
#define REG_BVALID_SHIFT    4
#define REG_BVALID_WIDTH    1

/* SUSPEND_LOCAL_FLOP_ENABLE */
#define REG_SUSPEND_LOCAL_FLOP_ENABLE          0x234
#define REG_SUSPEND_LOCAL_FLOP_ENABLE_MASK     0x00000001
#define REG_SUSPEND_LOCAL_FLOP_ENABLE_SHIFT    0
#define REG_SUSPEND_LOCAL_FLOP_ENABLE_WIDTH    1

/* SUSPEND_LINE_STATE */
#define REG_SUSPEND_LINE_STATE          0x234
#define REG_SUSPEND_LINE_STATE_MASK     0x00000006
#define REG_SUSPEND_LINE_STATE_SHIFT    1
#define REG_SUSPEND_LINE_STATE_WIDTH    2

/* SUSPEND_SIGNAL_SOURCE_SELECT */
#define REG_SUSPEND_SIGNAL_SOURCE_SELECT          0x234
#define REG_SUSPEND_SIGNAL_SOURCE_SELECT_MASK     0x00000008
#define REG_SUSPEND_SIGNAL_SOURCE_SELECT_SHIFT    3
#define REG_SUSPEND_SIGNAL_SOURCE_SELECT_WIDTH    1

/* USB_PHY_MAX_NUM_CLK */
#define REG_USB_PHY_MAX_NUM_CLK          0x238
#define REG_USB_PHY_MAX_NUM_CLK_MASK     0x0000ffff
#define REG_USB_PHY_MAX_NUM_CLK_SHIFT    0
#define REG_USB_PHY_MAX_NUM_CLK_WIDTH    16

/* USB_PHY_CLK_COUNTER */
#define REG_USB_PHY_CLK_COUNTER          0x23c
#define REG_USB_PHY_CLK_COUNTER_MASK     0x0000ffff
#define REG_USB_PHY_CLK_COUNTER_SHIFT    0
#define REG_USB_PHY_CLK_COUNTER_WIDTH    16

/* USB_ROM_NUM_WAIT_STATE */
#define REG_USB_ROM_NUM_WAIT_STATE          0x240
#define REG_USB_ROM_NUM_WAIT_STATE_MASK     0x00000001
#define REG_USB_ROM_NUM_WAIT_STATE_SHIFT    0
#define REG_USB_ROM_NUM_WAIT_STATE_WIDTH    1

/* CONTROLLER_INTERRUPT */
#define REG_CONTROLLER_INTERRUPT          0x244
#define REG_CONTROLLER_INTERRUPT_MASK     0x00000001
#define REG_CONTROLLER_INTERRUPT_SHIFT    0
#define REG_CONTROLLER_INTERRUPT_WIDTH    1

/* RESUME_INTERRUPT */
#define REG_RESUME_INTERRUPT          0x244
#define REG_RESUME_INTERRUPT_MASK     0x00000002
#define REG_RESUME_INTERRUPT_SHIFT    1
#define REG_RESUME_INTERRUPT_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_ASSERTED_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_INTERRUPT          0x244
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_INTERRUPT_MASK     0x00000004
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_INTERRUPT_SHIFT    2
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_INTERRUPT_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_DEASSERTED_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_INTERRUPT          0x244
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_INTERRUPT_MASK     0x00000008
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_INTERRUPT_SHIFT    3
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_INTERRUPT_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_ASSERTED_CLEAR_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_CLEAR_INTERRUPT          0x248
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_CLEAR_INTERRUPT_MASK     0x00000004
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_CLEAR_INTERRUPT_SHIFT    2
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_CLEAR_INTERRUPT_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_DEASSERTED_CLEAR_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_CLEAR_INTERRUPT          0x248
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_CLEAR_INTERRUPT_MASK     0x00000008
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_CLEAR_INTERRUPT_SHIFT    3
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_CLEAR_INTERRUPT_WIDTH    1

/* OSCILLATOR_DISABLE_MODE */
#define REG_OSCILLATOR_DISABLE_MODE          0x24c
#define REG_OSCILLATOR_DISABLE_MODE_MASK     0x00000001
#define REG_OSCILLATOR_DISABLE_MODE_SHIFT    0
#define REG_OSCILLATOR_DISABLE_MODE_WIDTH    1

/* OSCILLATOR_SHUT_DOWN_MODE */
#define REG_OSCILLATOR_SHUT_DOWN_MODE          0x24c
#define REG_OSCILLATOR_SHUT_DOWN_MODE_MASK     0x00000002
#define REG_OSCILLATOR_SHUT_DOWN_MODE_SHIFT    1
#define REG_OSCILLATOR_SHUT_DOWN_MODE_WIDTH    1

/* OSCILLATOR_LDO4_POWER_DOWN_MODE */
#define REG_OSCILLATOR_LDO4_POWER_DOWN_MODE          0x24c
#define REG_OSCILLATOR_LDO4_POWER_DOWN_MODE_MASK     0x00000004
#define REG_OSCILLATOR_LDO4_POWER_DOWN_MODE_SHIFT    2
#define REG_OSCILLATOR_LDO4_POWER_DOWN_MODE_WIDTH    1

/* RF_CENTRAL_BIAS_POWER_DOWN_MODE */
#define REG_RF_CENTRAL_BIAS_POWER_DOWN_MODE          0x24c
#define REG_RF_CENTRAL_BIAS_POWER_DOWN_MODE_MASK     0x00000008
#define REG_RF_CENTRAL_BIAS_POWER_DOWN_MODE_SHIFT    3
#define REG_RF_CENTRAL_BIAS_POWER_DOWN_MODE_WIDTH    1

/* USB_HOST_DEVICE_N_MODE */
/* 0: Device mode, 1: Host mode */
#define REG_USB_HOST_DEVICE_N_MODE          0x250
#define REG_USB_HOST_DEVICE_N_MODE_MASK     0x00000001
#define REG_USB_HOST_DEVICE_N_MODE_SHIFT    0
#define REG_USB_HOST_DEVICE_N_MODE_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_ASSERTED_MASK_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_MASK_INTERRUPT          0x254
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_MASK_INTERRUPT_MASK     0x00000004
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_MASK_INTERRUPT_SHIFT    2
#define REG_DEVICE_VBUS_SESSION_VALID_ASSERTED_MASK_INTERRUPT_WIDTH    1

/* DEVICE_VBUS_SESSION_VALID_DEASSERTED_MASK_INTERRUPT */
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_MASK_INTERRUPT          0x254
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_MASK_INTERRUPT_MASK     0x00000008
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_MASK_INTERRUPT_SHIFT    3
#define REG_DEVICE_VBUS_SESSION_VALID_DEASSERTED_MASK_INTERRUPT_WIDTH    1

/* USB_ROM_BIST_START */
#define REG_USB_ROM_BIST_START          0x258
#define REG_USB_ROM_BIST_START_MASK     0x00000001
#define REG_USB_ROM_BIST_START_SHIFT    0
#define REG_USB_ROM_BIST_START_WIDTH    1

/* USB_ROM_BIST_DONE */
#define REG_USB_ROM_BIST_DONE          0x25c
#define REG_USB_ROM_BIST_DONE_MASK     0x00000001
#define REG_USB_ROM_BIST_DONE_SHIFT    0
#define REG_USB_ROM_BIST_DONE_WIDTH    1

/* USB_ROM_BIST_RESULT */
#define REG_USB_ROM_BIST_RESULT          0x25c
#define REG_USB_ROM_BIST_RESULT_MASK     0x00000002
#define REG_USB_ROM_BIST_RESULT_SHIFT    1
#define REG_USB_ROM_BIST_RESULT_WIDTH    1
#endif 
