/*******************************************************************
*                                                                  
*  USB Device REGS.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef USB Device REGS_regs_H_FILE
#define USB Device REGS_regs_H_FILE

/* OTGVER */
#define REG_OTGVER          0x00000
#define REG_OTGVER_MASK     0x00100000
#define REG_OTGVER_SHIFT    20
#define REG_OTGVER_WIDTH    1

/* BSESVLD */
#define REG_BSESVLD          0x00000
#define REG_BSESVLD_MASK     0x00080000
#define REG_BSESVLD_SHIFT    19
#define REG_BSESVLD_WIDTH    1

/* ASESVLD */
#define REG_ASESVLD          0x00000
#define REG_ASESVLD_MASK     0x00040000
#define REG_ASESVLD_SHIFT    18
#define REG_ASESVLD_WIDTH    1

/* DBNCTIME */
#define REG_DBNCTIME          0x00000
#define REG_DBNCTIME_MASK     0x00020000
#define REG_DBNCTIME_SHIFT    17
#define REG_DBNCTIME_WIDTH    1

/* CONIDSTS */
#define REG_CONIDSTS          0x00000
#define REG_CONIDSTS_MASK     0x00010000
#define REG_CONIDSTS_SHIFT    16
#define REG_CONIDSTS_WIDTH    1

/* HSTNEGSCS */
#define REG_HSTNEGSCS          0x00000
#define REG_HSTNEGSCS_MASK     0x00000100
#define REG_HSTNEGSCS_SHIFT    8
#define REG_HSTNEGSCS_WIDTH    1

/* AVALIDOVVAL */
#define REG_AVALIDOVVAL          0x00000
#define REG_AVALIDOVVAL_MASK     0x00000080
#define REG_AVALIDOVVAL_SHIFT    7
#define REG_AVALIDOVVAL_WIDTH    1

/* AVALIDOVEN */
#define REG_AVALIDOVEN          0x00000
#define REG_AVALIDOVEN_MASK     0x00000040
#define REG_AVALIDOVEN_SHIFT    6
#define REG_AVALIDOVEN_WIDTH    1

/* BVALIDOVVAL */
#define REG_BVALIDOVVAL          0x00000
#define REG_BVALIDOVVAL_MASK     0x00000020
#define REG_BVALIDOVVAL_SHIFT    5
#define REG_BVALIDOVVAL_WIDTH    1

/* BVALIDOVEN */
#define REG_BVALIDOVEN          0x00000
#define REG_BVALIDOVEN_MASK     0x00000010
#define REG_BVALIDOVEN_SHIFT    4
#define REG_BVALIDOVEN_WIDTH    1

/* VBVALIDOVVAL */
#define REG_VBVALIDOVVAL          0x00000
#define REG_VBVALIDOVVAL_MASK     0x00000008
#define REG_VBVALIDOVVAL_SHIFT    3
#define REG_VBVALIDOVVAL_WIDTH    1

/* VBVALIDOVEN */
#define REG_VBVALIDOVEN          0x00000
#define REG_VBVALIDOVEN_MASK     0x00000004
#define REG_VBVALIDOVEN_SHIFT    2
#define REG_VBVALIDOVEN_WIDTH    1

/* SESREQ */
#define REG_SESREQ          0x00000
#define REG_SESREQ_MASK     0x00000002
#define REG_SESREQ_SHIFT    1
#define REG_SESREQ_WIDTH    1

/* SESREQSCS */
#define REG_SESREQSCS          0x00000
#define REG_SESREQSCS_MASK     0x00000001
#define REG_SESREQSCS_SHIFT    0
#define REG_SESREQSCS_WIDTH    1

/* DBNCEDONE */
#define REG_DBNCEDONE          0x00004
#define REG_DBNCEDONE_MASK     0x00080000
#define REG_DBNCEDONE_SHIFT    19
#define REG_DBNCEDONE_WIDTH    1

/* ADEVTOUTCHG */
#define REG_ADEVTOUTCHG          0x00004
#define REG_ADEVTOUTCHG_MASK     0x00040000
#define REG_ADEVTOUTCHG_SHIFT    18
#define REG_ADEVTOUTCHG_WIDTH    1

/* HSTNEGDET */
#define REG_HSTNEGDET          0x00004
#define REG_HSTNEGDET_MASK     0x00020000
#define REG_HSTNEGDET_SHIFT    17
#define REG_HSTNEGDET_WIDTH    1

/* HSTNEGSUCSTSCHNG */
#define REG_HSTNEGSUCSTSCHNG          0x00004
#define REG_HSTNEGSUCSTSCHNG_MASK     0x00000200
#define REG_HSTNEGSUCSTSCHNG_SHIFT    9
#define REG_HSTNEGSUCSTSCHNG_WIDTH    1

/* SESREQSUCSTSCHNG */
#define REG_SESREQSUCSTSCHNG          0x00004
#define REG_SESREQSUCSTSCHNG_MASK     0x00000100
#define REG_SESREQSUCSTSCHNG_SHIFT    8
#define REG_SESREQSUCSTSCHNG_WIDTH    1

/* SESENDDET */
#define REG_SESENDDET          0x00004
#define REG_SESENDDET_MASK     0x00000004
#define REG_SESENDDET_SHIFT    2
#define REG_SESENDDET_WIDTH    1

/* NOTIALLDMAWRIT */
#define REG_NOTIALLDMAWRIT          0x00008
#define REG_NOTIALLDMAWRIT_MASK     0x00400000
#define REG_NOTIALLDMAWRIT_SHIFT    22
#define REG_NOTIALLDMAWRIT_WIDTH    1

/* REMMEMSUPP */
#define REG_REMMEMSUPP          0x00008
#define REG_REMMEMSUPP_MASK     0x00200000
#define REG_REMMEMSUPP_SHIFT    21
#define REG_REMMEMSUPP_WIDTH    1

/* PTXFEMPLVL */
#define REG_PTXFEMPLVL          0x00008
#define REG_PTXFEMPLVL_MASK     0x00000100
#define REG_PTXFEMPLVL_SHIFT    8
#define REG_PTXFEMPLVL_WIDTH    1

/* NPTXFEMPLVL */
#define REG_NPTXFEMPLVL          0x00008
#define REG_NPTXFEMPLVL_MASK     0x00000080
#define REG_NPTXFEMPLVL_SHIFT    7
#define REG_NPTXFEMPLVL_WIDTH    1

/* DMAEN */
#define REG_DMAEN          0x00008
#define REG_DMAEN_MASK     0x00000020
#define REG_DMAEN_SHIFT    5
#define REG_DMAEN_WIDTH    1

/* HBSTLEN */
#define REG_HBSTLEN          0x00008
#define REG_HBSTLEN_MASK     0x0000001e
#define REG_HBSTLEN_SHIFT    1
#define REG_HBSTLEN_WIDTH    4

/* GLBLINTRMSK */
#define REG_GLBLINTRMSK          0x00008
#define REG_GLBLINTRMSK_MASK     0x00000001
#define REG_GLBLINTRMSK_SHIFT    0
#define REG_GLBLINTRMSK_WIDTH    1

/* FORCEDEVMODE */
#define REG_FORCEDEVMODE          0x0000c
#define REG_FORCEDEVMODE_MASK     0x40000000
#define REG_FORCEDEVMODE_SHIFT    30
#define REG_FORCEDEVMODE_WIDTH    1

/* FORCEHSTMODE */
#define REG_FORCEHSTMODE          0x0000c
#define REG_FORCEHSTMODE_MASK     0x20000000
#define REG_FORCEHSTMODE_SHIFT    29
#define REG_FORCEHSTMODE_WIDTH    1

/* TXENDDELAY */
#define REG_TXENDDELAY          0x0000c
#define REG_TXENDDELAY_MASK     0x10000000
#define REG_TXENDDELAY_SHIFT    28
#define REG_TXENDDELAY_WIDTH    1

/* IC_USBCAP */
#define REG_IC_USBCAP          0x0000c
#define REG_IC_USBCAP_MASK     0x04000000
#define REG_IC_USBCAP_SHIFT    26
#define REG_IC_USBCAP_WIDTH    1

/* TERMSELDLPULSE */
#define REG_TERMSELDLPULSE          0x0000c
#define REG_TERMSELDLPULSE_MASK     0x00400000
#define REG_TERMSELDLPULSE_SHIFT    22
#define REG_TERMSELDLPULSE_WIDTH    1

/* PHYLPWRCLKSEL */
#define REG_PHYLPWRCLKSEL          0x0000c
#define REG_PHYLPWRCLKSEL_MASK     0x00008000
#define REG_PHYLPWRCLKSEL_SHIFT    15
#define REG_PHYLPWRCLKSEL_WIDTH    1

/* USBTRDTIM */
#define REG_USBTRDTIM          0x0000c
#define REG_USBTRDTIM_MASK     0x00003c00
#define REG_USBTRDTIM_SHIFT    10
#define REG_USBTRDTIM_WIDTH    4

/* PHYSEL */
#define REG_PHYSEL          0x0000c
#define REG_PHYSEL_MASK     0x00000040
#define REG_PHYSEL_SHIFT    6
#define REG_PHYSEL_WIDTH    1

/* FSINTF */
#define REG_FSINTF          0x0000c
#define REG_FSINTF_MASK     0x00000020
#define REG_FSINTF_SHIFT    5
#define REG_FSINTF_WIDTH    1

/* ULPI_UTMI_SEL */
#define REG_ULPI_UTMI_SEL          0x0000c
#define REG_ULPI_UTMI_SEL_MASK     0x00000010
#define REG_ULPI_UTMI_SEL_SHIFT    4
#define REG_ULPI_UTMI_SEL_WIDTH    1

/* PHYIF */
#define REG_PHYIF          0x0000c
#define REG_PHYIF_MASK     0x00000008
#define REG_PHYIF_SHIFT    3
#define REG_PHYIF_WIDTH    1

/* TOUTCAL */
#define REG_TOUTCAL          0x0000c
#define REG_TOUTCAL_MASK     0x00000007
#define REG_TOUTCAL_SHIFT    0
#define REG_TOUTCAL_WIDTH    3

/* CORRUPTTXPKT */
#define REG_CORRUPTTXPKT          0x0000c
#define REG_CORRUPTTXPKT_MASK     0x80000000
#define REG_CORRUPTTXPKT_SHIFT    31
#define REG_CORRUPTTXPKT_WIDTH    1

/* AHBIDLE */
#define REG_AHBIDLE          0x00010
#define REG_AHBIDLE_MASK     0x80000000
#define REG_AHBIDLE_SHIFT    31
#define REG_AHBIDLE_WIDTH    1

/* DMAREQ */
#define REG_DMAREQ          0x00010
#define REG_DMAREQ_MASK     0x40000000
#define REG_DMAREQ_SHIFT    30
#define REG_DMAREQ_WIDTH    1

/* TXFNUM_GRSTCTL */
#define REG_TXFNUM_GRSTCTL          0x00010
#define REG_TXFNUM_GRSTCTL_MASK     0x000007c0
#define REG_TXFNUM_GRSTCTL_SHIFT    6
#define REG_TXFNUM_GRSTCTL_WIDTH    5

/* TXFFLSH */
#define REG_TXFFLSH          0x00010
#define REG_TXFFLSH_MASK     0x00000020
#define REG_TXFFLSH_SHIFT    5
#define REG_TXFFLSH_WIDTH    1

/* RXFFLSH */
#define REG_RXFFLSH          0x00010
#define REG_RXFFLSH_MASK     0x00000010
#define REG_RXFFLSH_SHIFT    4
#define REG_RXFFLSH_WIDTH    1

/* FRMCNTRRST */
#define REG_FRMCNTRRST          0x00010
#define REG_FRMCNTRRST_MASK     0x00000004
#define REG_FRMCNTRRST_SHIFT    2
#define REG_FRMCNTRRST_WIDTH    1

/* CSFTRST */
#define REG_CSFTRST          0x00010
#define REG_CSFTRST_MASK     0x00000001
#define REG_CSFTRST_SHIFT    0
#define REG_CSFTRST_WIDTH    1

/* WKUPINT */
#define REG_WKUPINT          0x00014
#define REG_WKUPINT_MASK     0x80000000
#define REG_WKUPINT_SHIFT    31
#define REG_WKUPINT_WIDTH    1

/* SESSREQINT */
#define REG_SESSREQINT          0x00014
#define REG_SESSREQINT_MASK     0x40000000
#define REG_SESSREQINT_SHIFT    30
#define REG_SESSREQINT_WIDTH    1

/* DISCONNINT */
#define REG_DISCONNINT          0x00014
#define REG_DISCONNINT_MASK     0x20000000
#define REG_DISCONNINT_SHIFT    29
#define REG_DISCONNINT_WIDTH    1

/* CONIDSTSCHNG */
#define REG_CONIDSTSCHNG          0x00014
#define REG_CONIDSTSCHNG_MASK     0x10000000
#define REG_CONIDSTSCHNG_SHIFT    28
#define REG_CONIDSTSCHNG_WIDTH    1

/* PTXFEMP */
#define REG_PTXFEMP          0x00014
#define REG_PTXFEMP_MASK     0x04000000
#define REG_PTXFEMP_SHIFT    26
#define REG_PTXFEMP_WIDTH    1

/* HCHINT */
#define REG_HCHINT          0x00014
#define REG_HCHINT_MASK     0x02000000
#define REG_HCHINT_SHIFT    25
#define REG_HCHINT_WIDTH    1

/* PRTINT */
#define REG_PRTINT          0x00014
#define REG_PRTINT_MASK     0x01000000
#define REG_PRTINT_SHIFT    24
#define REG_PRTINT_WIDTH    1

/* RESETDET */
#define REG_RESETDET          0x00014
#define REG_RESETDET_MASK     0x00800000
#define REG_RESETDET_SHIFT    23
#define REG_RESETDET_WIDTH    1

/* FETSUSP */
#define REG_FETSUSP          0x00014
#define REG_FETSUSP_MASK     0x00400000
#define REG_FETSUSP_SHIFT    22
#define REG_FETSUSP_WIDTH    1

/* INCOMPLP */
#define REG_INCOMPLP          0x00014
#define REG_INCOMPLP_MASK     0x00200000
#define REG_INCOMPLP_SHIFT    21
#define REG_INCOMPLP_WIDTH    1

/* INCOMPISOIN */
#define REG_INCOMPISOIN          0x00014
#define REG_INCOMPISOIN_MASK     0x00100000
#define REG_INCOMPISOIN_SHIFT    20
#define REG_INCOMPISOIN_WIDTH    1

/* OEPINT */
#define REG_OEPINT          0x00014
#define REG_OEPINT_MASK     0x00080000
#define REG_OEPINT_SHIFT    19
#define REG_OEPINT_WIDTH    1

/* IEPINT */
#define REG_IEPINT          0x00014
#define REG_IEPINT_MASK     0x00040000
#define REG_IEPINT_SHIFT    18
#define REG_IEPINT_WIDTH    1

/* EPMIS */
#define REG_EPMIS          0x00014
#define REG_EPMIS_MASK     0x00020000
#define REG_EPMIS_SHIFT    17
#define REG_EPMIS_WIDTH    1

/* ISOOUTDROP */
#define REG_ISOOUTDROP          0x00014
#define REG_ISOOUTDROP_MASK     0x00004000
#define REG_ISOOUTDROP_SHIFT    14
#define REG_ISOOUTDROP_WIDTH    1

/* ENUMDONE */
#define REG_ENUMDONE          0x00014
#define REG_ENUMDONE_MASK     0x00002000
#define REG_ENUMDONE_SHIFT    13
#define REG_ENUMDONE_WIDTH    1

/* USBRST */
#define REG_USBRST          0x00014
#define REG_USBRST_MASK     0x00001000
#define REG_USBRST_SHIFT    12
#define REG_USBRST_WIDTH    1

/* USBSUSP */
#define REG_USBSUSP          0x00014
#define REG_USBSUSP_MASK     0x00000800
#define REG_USBSUSP_SHIFT    11
#define REG_USBSUSP_WIDTH    1

/* ERLYSUSP */
#define REG_ERLYSUSP          0x00014
#define REG_ERLYSUSP_MASK     0x00000400
#define REG_ERLYSUSP_SHIFT    10
#define REG_ERLYSUSP_WIDTH    1

/* GOUTNAKEFF */
#define REG_GOUTNAKEFF          0x00014
#define REG_GOUTNAKEFF_MASK     0x00000080
#define REG_GOUTNAKEFF_SHIFT    7
#define REG_GOUTNAKEFF_WIDTH    1

/* GINNAKEFF */
#define REG_GINNAKEFF          0x00014
#define REG_GINNAKEFF_MASK     0x00000040
#define REG_GINNAKEFF_SHIFT    6
#define REG_GINNAKEFF_WIDTH    1

/* RXFLVL */
#define REG_RXFLVL          0x00014
#define REG_RXFLVL_MASK     0x00000010
#define REG_RXFLVL_SHIFT    4
#define REG_RXFLVL_WIDTH    1

/* SOF */
#define REG_SOF          0x00014
#define REG_SOF_MASK     0x00000008
#define REG_SOF_SHIFT    3
#define REG_SOF_WIDTH    1

/* OTGINT */
#define REG_OTGINT          0x00014
#define REG_OTGINT_MASK     0x00000004
#define REG_OTGINT_SHIFT    2
#define REG_OTGINT_WIDTH    1

/* MODEMIS */
#define REG_MODEMIS          0x00014
#define REG_MODEMIS_MASK     0x00000002
#define REG_MODEMIS_SHIFT    1
#define REG_MODEMIS_WIDTH    1

/* CURMOD */
#define REG_CURMOD          0x00014
#define REG_CURMOD_MASK     0x00000001
#define REG_CURMOD_SHIFT    0
#define REG_CURMOD_WIDTH    1

/* WKUPINTMSK */
#define REG_WKUPINTMSK          0x00018
#define REG_WKUPINTMSK_MASK     0x80000000
#define REG_WKUPINTMSK_SHIFT    31
#define REG_WKUPINTMSK_WIDTH    1

/* SESSREQINTMSK */
#define REG_SESSREQINTMSK          0x00018
#define REG_SESSREQINTMSK_MASK     0x40000000
#define REG_SESSREQINTMSK_SHIFT    30
#define REG_SESSREQINTMSK_WIDTH    1

/* DISCONNINTMSK */
#define REG_DISCONNINTMSK          0x00018
#define REG_DISCONNINTMSK_MASK     0x20000000
#define REG_DISCONNINTMSK_SHIFT    29
#define REG_DISCONNINTMSK_WIDTH    1

/* CONIDSTSCHNGMSK */
#define REG_CONIDSTSCHNGMSK          0x00018
#define REG_CONIDSTSCHNGMSK_MASK     0x10000000
#define REG_CONIDSTSCHNGMSK_SHIFT    28
#define REG_CONIDSTSCHNGMSK_WIDTH    1

/* PTXFEMPMSK */
#define REG_PTXFEMPMSK          0x00018
#define REG_PTXFEMPMSK_MASK     0x04000000
#define REG_PTXFEMPMSK_SHIFT    26
#define REG_PTXFEMPMSK_WIDTH    1

/* HCHINTMSK */
#define REG_HCHINTMSK          0x00018
#define REG_HCHINTMSK_MASK     0x02000000
#define REG_HCHINTMSK_SHIFT    25
#define REG_HCHINTMSK_WIDTH    1

/* PRTINTMSK */
#define REG_PRTINTMSK          0x00018
#define REG_PRTINTMSK_MASK     0x01000000
#define REG_PRTINTMSK_SHIFT    24
#define REG_PRTINTMSK_WIDTH    1

/* RESETDETMSK */
#define REG_RESETDETMSK          0x00018
#define REG_RESETDETMSK_MASK     0x00800000
#define REG_RESETDETMSK_SHIFT    23
#define REG_RESETDETMSK_WIDTH    1

/* FETSUSPMSK */
#define REG_FETSUSPMSK          0x00018
#define REG_FETSUSPMSK_MASK     0x00400000
#define REG_FETSUSPMSK_SHIFT    22
#define REG_FETSUSPMSK_WIDTH    1

/* INCOMPLPMSK */
#define REG_INCOMPLPMSK          0x00018
#define REG_INCOMPLPMSK_MASK     0x00200000
#define REG_INCOMPLPMSK_SHIFT    21
#define REG_INCOMPLPMSK_WIDTH    1

/* INCOMPISOINMSK */
#define REG_INCOMPISOINMSK          0x00018
#define REG_INCOMPISOINMSK_MASK     0x00100000
#define REG_INCOMPISOINMSK_SHIFT    20
#define REG_INCOMPISOINMSK_WIDTH    1

/* OEPINTMSK */
#define REG_OEPINTMSK          0x00018
#define REG_OEPINTMSK_MASK     0x00080000
#define REG_OEPINTMSK_SHIFT    19
#define REG_OEPINTMSK_WIDTH    1

/* IEPINTMSK */
#define REG_IEPINTMSK          0x00018
#define REG_IEPINTMSK_MASK     0x00040000
#define REG_IEPINTMSK_SHIFT    18
#define REG_IEPINTMSK_WIDTH    1

/* EPMISMSK */
#define REG_EPMISMSK          0x00018
#define REG_EPMISMSK_MASK     0x00020000
#define REG_EPMISMSK_SHIFT    17
#define REG_EPMISMSK_WIDTH    1

/* EOPFMSK */
#define REG_EOPFMSK          0x00018
#define REG_EOPFMSK_MASK     0x00008000
#define REG_EOPFMSK_SHIFT    15
#define REG_EOPFMSK_WIDTH    1

/* ISOOUTDROPMSK */
#define REG_ISOOUTDROPMSK          0x00018
#define REG_ISOOUTDROPMSK_MASK     0x00004000
#define REG_ISOOUTDROPMSK_SHIFT    14
#define REG_ISOOUTDROPMSK_WIDTH    1

/* ENUMDONEMSK */
#define REG_ENUMDONEMSK          0x00018
#define REG_ENUMDONEMSK_MASK     0x00002000
#define REG_ENUMDONEMSK_SHIFT    13
#define REG_ENUMDONEMSK_WIDTH    1

/* USBRSTMSK */
#define REG_USBRSTMSK          0x00018
#define REG_USBRSTMSK_MASK     0x00001000
#define REG_USBRSTMSK_SHIFT    12
#define REG_USBRSTMSK_WIDTH    1

/* USBSUSPMSK */
#define REG_USBSUSPMSK          0x00018
#define REG_USBSUSPMSK_MASK     0x00000800
#define REG_USBSUSPMSK_SHIFT    11
#define REG_USBSUSPMSK_WIDTH    1

/* ERLYSUSPMSK */
#define REG_ERLYSUSPMSK          0x00018
#define REG_ERLYSUSPMSK_MASK     0x00000400
#define REG_ERLYSUSPMSK_SHIFT    10
#define REG_ERLYSUSPMSK_WIDTH    1

/* GOUTNAKEFFMSK */
#define REG_GOUTNAKEFFMSK          0x00018
#define REG_GOUTNAKEFFMSK_MASK     0x00000080
#define REG_GOUTNAKEFFMSK_SHIFT    7
#define REG_GOUTNAKEFFMSK_WIDTH    1

/* GINNAKEFFMSK */
#define REG_GINNAKEFFMSK          0x00018
#define REG_GINNAKEFFMSK_MASK     0x00000040
#define REG_GINNAKEFFMSK_SHIFT    6
#define REG_GINNAKEFFMSK_WIDTH    1

/* RXFLVLMSK */
#define REG_RXFLVLMSK          0x00018
#define REG_RXFLVLMSK_MASK     0x00000010
#define REG_RXFLVLMSK_SHIFT    4
#define REG_RXFLVLMSK_WIDTH    1

/* SOFMSK */
#define REG_SOFMSK          0x00018
#define REG_SOFMSK_MASK     0x00000008
#define REG_SOFMSK_SHIFT    3
#define REG_SOFMSK_WIDTH    1

/* OTGINTMSK */
#define REG_OTGINTMSK          0x00018
#define REG_OTGINTMSK_MASK     0x00000004
#define REG_OTGINTMSK_SHIFT    2
#define REG_OTGINTMSK_WIDTH    1

/* MODEMISMSK */
#define REG_MODEMISMSK          0x00018
#define REG_MODEMISMSK_MASK     0x00000002
#define REG_MODEMISMSK_SHIFT    1
#define REG_MODEMISMSK_WIDTH    1

/* FN */
#define REG_FN          0x0001c
#define REG_FN_MASK     0x0f000000
#define REG_FN_SHIFT    24
#define REG_FN_WIDTH    4

/* PKTSTS */
#define REG_PKTSTS          0x0001c
#define REG_PKTSTS_MASK     0x001e0000
#define REG_PKTSTS_SHIFT    17
#define REG_PKTSTS_WIDTH    4

/* DPID */
#define REG_DPID          0x0001c
#define REG_DPID_MASK     0x00018000
#define REG_DPID_SHIFT    15
#define REG_DPID_WIDTH    2

/* BCNT */
#define REG_BCNT          0x0001c
#define REG_BCNT_MASK     0x00007ff0
#define REG_BCNT_SHIFT    4
#define REG_BCNT_WIDTH    11

/* CHNUM */
#define REG_CHNUM          0x0001c
#define REG_CHNUM_MASK     0x0000000f
#define REG_CHNUM_SHIFT    0
#define REG_CHNUM_WIDTH    4

/* FN */
#define REG_FN          0x00020
#define REG_FN_MASK     0x01e00000
#define REG_FN_SHIFT    21
#define REG_FN_WIDTH    4

/* PKTSTS */
#define REG_PKTSTS          0x00020
#define REG_PKTSTS_MASK     0x001e0000
#define REG_PKTSTS_SHIFT    17
#define REG_PKTSTS_WIDTH    4

/* DPID */
#define REG_DPID          0x00020
#define REG_DPID_MASK     0x00018000
#define REG_DPID_SHIFT    15
#define REG_DPID_WIDTH    2

/* BCNT */
#define REG_BCNT          0x00020
#define REG_BCNT_MASK     0x00007ff0
#define REG_BCNT_SHIFT    4
#define REG_BCNT_WIDTH    11

/* CHNUM */
#define REG_CHNUM          0x00020
#define REG_CHNUM_MASK     0x0000000f
#define REG_CHNUM_SHIFT    0
#define REG_CHNUM_WIDTH    4

/* RXFDEP */
#define REG_RXFDEP          0x00024
#define REG_RXFDEP_MASK     0x000007ff
#define REG_RXFDEP_SHIFT    0
#define REG_RXFDEP_WIDTH    11

/* NPTXFDEP */
#define REG_NPTXFDEP          0x00028
#define REG_NPTXFDEP_MASK     0x07ff0000
#define REG_NPTXFDEP_SHIFT    16
#define REG_NPTXFDEP_WIDTH    11

/* INEPTXF0DEP */
#define REG_INEPTXF0DEP          0x00028
#define REG_INEPTXF0DEP_MASK     0x07ff0000
#define REG_INEPTXF0DEP_SHIFT    16
#define REG_INEPTXF0DEP_WIDTH    11

/* NPTXFSTADDR */
#define REG_NPTXFSTADDR          0x00028
#define REG_NPTXFSTADDR_MASK     0x000007ff
#define REG_NPTXFSTADDR_SHIFT    0
#define REG_NPTXFSTADDR_WIDTH    11

/* NPTXQTOP */
#define REG_NPTXQTOP          0x0002c
#define REG_NPTXQTOP_MASK     0x7f000000
#define REG_NPTXQTOP_SHIFT    24
#define REG_NPTXQTOP_WIDTH    7

/* NPTXQSPCAVAIL */
#define REG_NPTXQSPCAVAIL          0x0002c
#define REG_NPTXQSPCAVAIL_MASK     0x00ff0000
#define REG_NPTXQSPCAVAIL_SHIFT    16
#define REG_NPTXQSPCAVAIL_WIDTH    8

/* NPTXFSPCAVAIL */
#define REG_NPTXFSPCAVAIL          0x0002c
#define REG_NPTXFSPCAVAIL_MASK     0x0000ffff
#define REG_NPTXFSPCAVAIL_SHIFT    0
#define REG_NPTXFSPCAVAIL_WIDTH    16

/* GSNPSID */
#define REG_GSNPSID          0x00040
#define REG_GSNPSID_MASK     0xffffffff
#define REG_GSNPSID_SHIFT    0
#define REG_GSNPSID_WIDTH    32

/* GHWCFG1 */
#define REG_GHWCFG1          0x00044
#define REG_GHWCFG1_MASK     0xffffffff
#define REG_GHWCFG1_SHIFT    0
#define REG_GHWCFG1_WIDTH    32

/* TKNQDEPTH */
#define REG_TKNQDEPTH          0x00048
#define REG_TKNQDEPTH_MASK     0x7c000000
#define REG_TKNQDEPTH_SHIFT    26
#define REG_TKNQDEPTH_WIDTH    5

/* PTXQDEPTH */
#define REG_PTXQDEPTH          0x00048
#define REG_PTXQDEPTH_MASK     0x03000000
#define REG_PTXQDEPTH_SHIFT    24
#define REG_PTXQDEPTH_WIDTH    2

/* NPTXQDEPTH */
#define REG_NPTXQDEPTH          0x00048
#define REG_NPTXQDEPTH_MASK     0x00c00000
#define REG_NPTXQDEPTH_SHIFT    22
#define REG_NPTXQDEPTH_WIDTH    2

/* MULTIPROCINTRPT */
#define REG_MULTIPROCINTRPT          0x00048
#define REG_MULTIPROCINTRPT_MASK     0x00100000
#define REG_MULTIPROCINTRPT_SHIFT    20
#define REG_MULTIPROCINTRPT_WIDTH    1

/* DYNFIFOSIZING */
#define REG_DYNFIFOSIZING          0x00048
#define REG_DYNFIFOSIZING_MASK     0x00080000
#define REG_DYNFIFOSIZING_SHIFT    19
#define REG_DYNFIFOSIZING_WIDTH    1

/* PERIOSUPPOR */
#define REG_PERIOSUPPOR          0x00048
#define REG_PERIOSUPPOR_MASK     0x00040000
#define REG_PERIOSUPPOR_SHIFT    18
#define REG_PERIOSUPPOR_WIDTH    1

/* NUMHSTCHNL */
#define REG_NUMHSTCHNL          0x00048
#define REG_NUMHSTCHNL_MASK     0x0003c000
#define REG_NUMHSTCHNL_SHIFT    14
#define REG_NUMHSTCHNL_WIDTH    4

/* NUMDEVEPS */
#define REG_NUMDEVEPS          0x00048
#define REG_NUMDEVEPS_MASK     0x00003c00
#define REG_NUMDEVEPS_SHIFT    10
#define REG_NUMDEVEPS_WIDTH    4

/* FSPHYTYPE */
#define REG_FSPHYTYPE          0x00048
#define REG_FSPHYTYPE_MASK     0x00000300
#define REG_FSPHYTYPE_SHIFT    8
#define REG_FSPHYTYPE_WIDTH    2

/* HSPHYTYPE */
#define REG_HSPHYTYPE          0x00048
#define REG_HSPHYTYPE_MASK     0x000000c0
#define REG_HSPHYTYPE_SHIFT    6
#define REG_HSPHYTYPE_WIDTH    2

/* SINGPNT */
#define REG_SINGPNT          0x00048
#define REG_SINGPNT_MASK     0x00000020
#define REG_SINGPNT_SHIFT    5
#define REG_SINGPNT_WIDTH    1

/* OTGARCH */
#define REG_OTGARCH          0x00048
#define REG_OTGARCH_MASK     0x00000018
#define REG_OTGARCH_SHIFT    3
#define REG_OTGARCH_WIDTH    2

/* OTGMODE */
#define REG_OTGMODE          0x00048
#define REG_OTGMODE_MASK     0x00000007
#define REG_OTGMODE_SHIFT    0
#define REG_OTGMODE_WIDTH    3

/* DFIFODEPTH */
#define REG_DFIFODEPTH          0x0004c
#define REG_DFIFODEPTH_MASK     0xffff0000
#define REG_DFIFODEPTH_SHIFT    16
#define REG_DFIFODEPTH_WIDTH    16

/* LPMMODE */
#define REG_LPMMODE          0x0004c
#define REG_LPMMODE_MASK     0x00008000
#define REG_LPMMODE_SHIFT    15
#define REG_LPMMODE_WIDTH    1

/* BCSUPPORT */
#define REG_BCSUPPORT          0x0004c
#define REG_BCSUPPORT_MASK     0x00004000
#define REG_BCSUPPORT_SHIFT    14
#define REG_BCSUPPORT_WIDTH    1

/* HSICMODE */
#define REG_HSICMODE          0x0004c
#define REG_HSICMODE_MASK     0x00002000
#define REG_HSICMODE_SHIFT    13
#define REG_HSICMODE_WIDTH    1

/* ADPSUPPORT */
#define REG_ADPSUPPORT          0x0004c
#define REG_ADPSUPPORT_MASK     0x00001000
#define REG_ADPSUPPORT_SHIFT    12
#define REG_ADPSUPPORT_WIDTH    1

/* RSTTYPE */
#define REG_RSTTYPE          0x0004c
#define REG_RSTTYPE_MASK     0x00000800
#define REG_RSTTYPE_SHIFT    11
#define REG_RSTTYPE_WIDTH    1

/* OPTFEATURE */
#define REG_OPTFEATURE          0x0004c
#define REG_OPTFEATURE_MASK     0x00000400
#define REG_OPTFEATURE_SHIFT    10
#define REG_OPTFEATURE_WIDTH    1

/* VNDCTLSUPT */
#define REG_VNDCTLSUPT          0x0004c
#define REG_VNDCTLSUPT_MASK     0x00000200
#define REG_VNDCTLSUPT_SHIFT    9
#define REG_VNDCTLSUPT_WIDTH    1

/* I2CINTSEL */
#define REG_I2CINTSEL          0x0004c
#define REG_I2CINTSEL_MASK     0x00000100
#define REG_I2CINTSEL_SHIFT    8
#define REG_I2CINTSEL_WIDTH    1

/* OTGEN */
#define REG_OTGEN          0x0004c
#define REG_OTGEN_MASK     0x00000080
#define REG_OTGEN_SHIFT    7
#define REG_OTGEN_WIDTH    1

/* PKTSIZEWIDTH */
#define REG_PKTSIZEWIDTH          0x0004c
#define REG_PKTSIZEWIDTH_MASK     0x00000070
#define REG_PKTSIZEWIDTH_SHIFT    4
#define REG_PKTSIZEWIDTH_WIDTH    3

/* XFERSIZEWIDTH */
#define REG_XFERSIZEWIDTH          0x0004c
#define REG_XFERSIZEWIDTH_MASK     0x0000000f
#define REG_XFERSIZEWIDTH_SHIFT    0
#define REG_XFERSIZEWIDTH_WIDTH    4

/* DMA */
#define REG_DMA          0x00050
#define REG_DMA_MASK     0x80000000
#define REG_DMA_SHIFT    31
#define REG_DMA_WIDTH    1

/* DMA_CONFIGURATION */
#define REG_DMA_CONFIGURATION          0x00050
#define REG_DMA_CONFIGURATION_MASK     0x40000000
#define REG_DMA_CONFIGURATION_SHIFT    30
#define REG_DMA_CONFIGURATION_WIDTH    1

/* INEPS */
#define REG_INEPS          0x00050
#define REG_INEPS_MASK     0x3c000000
#define REG_INEPS_SHIFT    26
#define REG_INEPS_WIDTH    4

/* DEDFIFOMODE */
#define REG_DEDFIFOMODE          0x00050
#define REG_DEDFIFOMODE_MASK     0x02000000
#define REG_DEDFIFOMODE_SHIFT    25
#define REG_DEDFIFOMODE_WIDTH    1

/* SESSENDFLTR */
#define REG_SESSENDFLTR          0x00050
#define REG_SESSENDFLTR_MASK     0x01000000
#define REG_SESSENDFLTR_SHIFT    24
#define REG_SESSENDFLTR_WIDTH    1

/* BVALIDFLTR */
#define REG_BVALIDFLTR          0x00050
#define REG_BVALIDFLTR_MASK     0x00800000
#define REG_BVALIDFLTR_SHIFT    23
#define REG_BVALIDFLTR_WIDTH    1

/* AVALIDFLTR */
#define REG_AVALIDFLTR          0x00050
#define REG_AVALIDFLTR_MASK     0x00400000
#define REG_AVALIDFLTR_SHIFT    22
#define REG_AVALIDFLTR_WIDTH    1

/* VBUSVALIDFLTR */
#define REG_VBUSVALIDFLTR          0x00050
#define REG_VBUSVALIDFLTR_MASK     0x00200000
#define REG_VBUSVALIDFLTR_SHIFT    21
#define REG_VBUSVALIDFLTR_WIDTH    1

/* IDDGFLTR */
#define REG_IDDGFLTR          0x00050
#define REG_IDDGFLTR_MASK     0x00100000
#define REG_IDDGFLTR_SHIFT    20
#define REG_IDDGFLTR_WIDTH    1

/* NUMCTLEPS */
#define REG_NUMCTLEPS          0x00050
#define REG_NUMCTLEPS_MASK     0x000f0000
#define REG_NUMCTLEPS_SHIFT    16
#define REG_NUMCTLEPS_WIDTH    4

/* PHYDATAWIDTH */
#define REG_PHYDATAWIDTH          0x00050
#define REG_PHYDATAWIDTH_MASK     0x0000c000
#define REG_PHYDATAWIDTH_SHIFT    14
#define REG_PHYDATAWIDTH_WIDTH    2

/* HIBERNATION */
#define REG_HIBERNATION          0x00050
#define REG_HIBERNATION_MASK     0x00000040
#define REG_HIBERNATION_SHIFT    6
#define REG_HIBERNATION_WIDTH    1

/* AHBFREQ */
#define REG_AHBFREQ          0x00050
#define REG_AHBFREQ_MASK     0x00000020
#define REG_AHBFREQ_SHIFT    5
#define REG_AHBFREQ_WIDTH    1

/* PARTIALPWRDN */
#define REG_PARTIALPWRDN          0x00050
#define REG_PARTIALPWRDN_MASK     0x00000010
#define REG_PARTIALPWRDN_SHIFT    4
#define REG_PARTIALPWRDN_WIDTH    1

/* NUMDEVPERIOEPS */
#define REG_NUMDEVPERIOEPS          0x00050
#define REG_NUMDEVPERIOEPS_MASK     0x0000000f
#define REG_NUMDEVPERIOEPS_SHIFT    0
#define REG_NUMDEVPERIOEPS_WIDTH    4

/* EPINFOBASEADDR */
#define REG_EPINFOBASEADDR          0x0005c
#define REG_EPINFOBASEADDR_MASK     0xffff0000
#define REG_EPINFOBASEADDR_SHIFT    16
#define REG_EPINFOBASEADDR_WIDTH    16

/* GDFIFOCFG */
#define REG_GDFIFOCFG          0x0005c
#define REG_GDFIFOCFG_MASK     0x0000ffff
#define REG_GDFIFOCFG_SHIFT    0
#define REG_GDFIFOCFG_WIDTH    16

/* INEPNTXFDEP1 */
#define REG_INEPNTXFDEP1          0x00104
#define REG_INEPNTXFDEP1_MASK     0x07ff0000
#define REG_INEPNTXFDEP1_SHIFT    16
#define REG_INEPNTXFDEP1_WIDTH    11

/* INEPNTXFSTADDR1 */
#define REG_INEPNTXFSTADDR1          0x00104
#define REG_INEPNTXFSTADDR1_MASK     0x00000fff
#define REG_INEPNTXFSTADDR1_SHIFT    0
#define REG_INEPNTXFSTADDR1_WIDTH    12

/* INEPNTXFDEP2 */
#define REG_INEPNTXFDEP2          0x00108
#define REG_INEPNTXFDEP2_MASK     0x07ff0000
#define REG_INEPNTXFDEP2_SHIFT    16
#define REG_INEPNTXFDEP2_WIDTH    11

/* INEPNTXFSTADDR2 */
#define REG_INEPNTXFSTADDR2          0x00108
#define REG_INEPNTXFSTADDR2_MASK     0x00000fff
#define REG_INEPNTXFSTADDR2_SHIFT    0
#define REG_INEPNTXFSTADDR2_WIDTH    12

/* INEPNTXFDEP3 */
#define REG_INEPNTXFDEP3          0x0010c
#define REG_INEPNTXFDEP3_MASK     0x07ff0000
#define REG_INEPNTXFDEP3_SHIFT    16
#define REG_INEPNTXFDEP3_WIDTH    11

/* INEPNTXFSTADDR3 */
#define REG_INEPNTXFSTADDR3          0x0010c
#define REG_INEPNTXFSTADDR3_MASK     0x00001fff
#define REG_INEPNTXFSTADDR3_SHIFT    0
#define REG_INEPNTXFSTADDR3_WIDTH    13

/* INEPNTXFDEP4 */
#define REG_INEPNTXFDEP4          0x00110
#define REG_INEPNTXFDEP4_MASK     0x07ff0000
#define REG_INEPNTXFDEP4_SHIFT    16
#define REG_INEPNTXFDEP4_WIDTH    11

/* INEPNTXFSTADDR4 */
#define REG_INEPNTXFSTADDR4          0x00110
#define REG_INEPNTXFSTADDR4_MASK     0x00001fff
#define REG_INEPNTXFSTADDR4_SHIFT    0
#define REG_INEPNTXFSTADDR4_WIDTH    13

/* RESVALID */
#define REG_RESVALID          0x00800
#define REG_RESVALID_MASK     0xfc000000
#define REG_RESVALID_SHIFT    26
#define REG_RESVALID_WIDTH    6

/* PERSCHINTVL */
#define REG_PERSCHINTVL          0x00800
#define REG_PERSCHINTVL_MASK     0x03000000
#define REG_PERSCHINTVL_SHIFT    24
#define REG_PERSCHINTVL_WIDTH    2

/* DESCDMA */
#define REG_DESCDMA          0x00800
#define REG_DESCDMA_MASK     0x00800000
#define REG_DESCDMA_SHIFT    23
#define REG_DESCDMA_WIDTH    1

/* ENDEVOUTNAK */
#define REG_ENDEVOUTNAK          0x00800
#define REG_ENDEVOUTNAK_MASK     0x00002000
#define REG_ENDEVOUTNAK_SHIFT    13
#define REG_ENDEVOUTNAK_WIDTH    1

/* PERFRINT */
#define REG_PERFRINT          0x00800
#define REG_PERFRINT_MASK     0x00001800
#define REG_PERFRINT_SHIFT    11
#define REG_PERFRINT_WIDTH    2

/* DEVADDR */
#define REG_DEVADDR          0x00800
#define REG_DEVADDR_MASK     0x000007f0
#define REG_DEVADDR_SHIFT    4
#define REG_DEVADDR_WIDTH    7

/* ENA32KHZSUSP */
#define REG_ENA32KHZSUSP          0x00800
#define REG_ENA32KHZSUSP_MASK     0x00000008
#define REG_ENA32KHZSUSP_SHIFT    3
#define REG_ENA32KHZSUSP_WIDTH    1

/* NZSTSOUTHSHK */
#define REG_NZSTSOUTHSHK          0x00800
#define REG_NZSTSOUTHSHK_MASK     0x00000004
#define REG_NZSTSOUTHSHK_SHIFT    2
#define REG_NZSTSOUTHSHK_WIDTH    1

/* DEVSPD */
#define REG_DEVSPD          0x00800
#define REG_DEVSPD_MASK     0x00000003
#define REG_DEVSPD_SHIFT    0
#define REG_DEVSPD_WIDTH    2

/* NAKONBBLE */
#define REG_NAKONBBLE          0x00804
#define REG_NAKONBBLE_MASK     0x00010000
#define REG_NAKONBBLE_SHIFT    16
#define REG_NAKONBBLE_WIDTH    1

/* IGNRFRMNUM */
#define REG_IGNRFRMNUM          0x00804
#define REG_IGNRFRMNUM_MASK     0x00008000
#define REG_IGNRFRMNUM_SHIFT    15
#define REG_IGNRFRMNUM_WIDTH    1

/* GMC */
#define REG_GMC          0x00804
#define REG_GMC_MASK     0x00006000
#define REG_GMC_SHIFT    13
#define REG_GMC_WIDTH    2

/* PWRONPRGDONE */
#define REG_PWRONPRGDONE          0x00804
#define REG_PWRONPRGDONE_MASK     0x00000800
#define REG_PWRONPRGDONE_SHIFT    11
#define REG_PWRONPRGDONE_WIDTH    1

/* TSTCTL */
#define REG_TSTCTL          0x00804
#define REG_TSTCTL_MASK     0x00000070
#define REG_TSTCTL_SHIFT    4
#define REG_TSTCTL_WIDTH    3

/* GOUTNAKSTS */
#define REG_GOUTNAKSTS          0x00804
#define REG_GOUTNAKSTS_MASK     0x00000008
#define REG_GOUTNAKSTS_SHIFT    3
#define REG_GOUTNAKSTS_WIDTH    1

/* GNPINNAKSTS */
#define REG_GNPINNAKSTS          0x00804
#define REG_GNPINNAKSTS_MASK     0x00000004
#define REG_GNPINNAKSTS_SHIFT    2
#define REG_GNPINNAKSTS_WIDTH    1

/* SFTDISCON */
#define REG_SFTDISCON          0x00804
#define REG_SFTDISCON_MASK     0x00000002
#define REG_SFTDISCON_SHIFT    1
#define REG_SFTDISCON_WIDTH    1

/* RMTWKUPSIG */
#define REG_RMTWKUPSIG          0x00804
#define REG_RMTWKUPSIG_MASK     0x00000001
#define REG_RMTWKUPSIG_SHIFT    0
#define REG_RMTWKUPSIG_WIDTH    1

/* CGOUTNAK */
#define REG_CGOUTNAK          0x00804
#define REG_CGOUTNAK_MASK     0x00000400
#define REG_CGOUTNAK_SHIFT    10
#define REG_CGOUTNAK_WIDTH    1

/* SGOUTNAK */
#define REG_SGOUTNAK          0x00804
#define REG_SGOUTNAK_MASK     0x00000200
#define REG_SGOUTNAK_SHIFT    9
#define REG_SGOUTNAK_WIDTH    1

/* CGNPINNAK */
#define REG_CGNPINNAK          0x00804
#define REG_CGNPINNAK_MASK     0x00000100
#define REG_CGNPINNAK_SHIFT    8
#define REG_CGNPINNAK_WIDTH    1

/* SGNPINNAK */
#define REG_SGNPINNAK          0x00804
#define REG_SGNPINNAK_MASK     0x00000080
#define REG_SGNPINNAK_SHIFT    7
#define REG_SGNPINNAK_WIDTH    1

/* SOFFN */
#define REG_SOFFN          0x00808
#define REG_SOFFN_MASK     0x003fff00
#define REG_SOFFN_SHIFT    8
#define REG_SOFFN_WIDTH    14

/* ERRTICERR */
#define REG_ERRTICERR          0x00808
#define REG_ERRTICERR_MASK     0x00000008
#define REG_ERRTICERR_SHIFT    3
#define REG_ERRTICERR_WIDTH    1

/* ENUMSPD */
#define REG_ENUMSPD          0x00808
#define REG_ENUMSPD_MASK     0x00000006
#define REG_ENUMSPD_SHIFT    1
#define REG_ENUMSPD_WIDTH    2

/* SUSPSTS */
#define REG_SUSPSTS          0x00808
#define REG_SUSPSTS_MASK     0x00000001
#define REG_SUSPSTS_SHIFT    0
#define REG_SUSPSTS_WIDTH    1

/* NAKMSK */
#define REG_NAKMSK          0x00810
#define REG_NAKMSK_MASK     0x00002000
#define REG_NAKMSK_SHIFT    13
#define REG_NAKMSK_WIDTH    1

/* BNAININTRMSK */
#define REG_BNAININTRMSK          0x00810
#define REG_BNAININTRMSK_MASK     0x00000200
#define REG_BNAININTRMSK_SHIFT    9
#define REG_BNAININTRMSK_WIDTH    1

/* TXFIFOUNDRNMSK */
#define REG_TXFIFOUNDRNMSK          0x00810
#define REG_TXFIFOUNDRNMSK_MASK     0x00000100
#define REG_TXFIFOUNDRNMSK_SHIFT    8
#define REG_TXFIFOUNDRNMSK_WIDTH    1

/* INEPNAKEFFMSK */
#define REG_INEPNAKEFFMSK          0x00810
#define REG_INEPNAKEFFMSK_MASK     0x00000040
#define REG_INEPNAKEFFMSK_SHIFT    6
#define REG_INEPNAKEFFMSK_WIDTH    1

/* INTKNEPMISMSK */
#define REG_INTKNEPMISMSK          0x00810
#define REG_INTKNEPMISMSK_MASK     0x00000020
#define REG_INTKNEPMISMSK_SHIFT    5
#define REG_INTKNEPMISMSK_WIDTH    1

/* INTKNTXFEMPMSK */
#define REG_INTKNTXFEMPMSK          0x00810
#define REG_INTKNTXFEMPMSK_MASK     0x00000010
#define REG_INTKNTXFEMPMSK_SHIFT    4
#define REG_INTKNTXFEMPMSK_WIDTH    1

/* TIMEOUTMSK */
#define REG_TIMEOUTMSK          0x00810
#define REG_TIMEOUTMSK_MASK     0x00000008
#define REG_TIMEOUTMSK_SHIFT    3
#define REG_TIMEOUTMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x00810
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* EPDISBLDMSK */
#define REG_EPDISBLDMSK          0x00810
#define REG_EPDISBLDMSK_MASK     0x00000002
#define REG_EPDISBLDMSK_SHIFT    1
#define REG_EPDISBLDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x00810
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* NYETMSK1 */
#define REG_NYETMSK1          0x00814
#define REG_NYETMSK1_MASK     0x00004000
#define REG_NYETMSK1_SHIFT    14
#define REG_NYETMSK1_WIDTH    1

/* NAKMSK1 */
#define REG_NAKMSK1          0x00814
#define REG_NAKMSK1_MASK     0x00002000
#define REG_NAKMSK1_SHIFT    13
#define REG_NAKMSK1_WIDTH    1

/* BBLEERRMSK1 */
#define REG_BBLEERRMSK1          0x00814
#define REG_BBLEERRMSK1_MASK     0x00001000
#define REG_BBLEERRMSK1_SHIFT    12
#define REG_BBLEERRMSK1_WIDTH    1

/* BNAOUTINTRMSK1 */
#define REG_BNAOUTINTRMSK1          0x00814
#define REG_BNAOUTINTRMSK1_MASK     0x00000200
#define REG_BNAOUTINTRMSK1_SHIFT    9
#define REG_BNAOUTINTRMSK1_WIDTH    1

/* OUTPKTERRMSK1 */
#define REG_OUTPKTERRMSK1          0x00814
#define REG_OUTPKTERRMSK1_MASK     0x00000100
#define REG_OUTPKTERRMSK1_SHIFT    8
#define REG_OUTPKTERRMSK1_WIDTH    1

/* BACK2BACKSETUP1 */
#define REG_BACK2BACKSETUP1          0x00814
#define REG_BACK2BACKSETUP1_MASK     0x00000040
#define REG_BACK2BACKSETUP1_SHIFT    6
#define REG_BACK2BACKSETUP1_WIDTH    1

/* OUTTKNEPDISMSK1 */
#define REG_OUTTKNEPDISMSK1          0x00814
#define REG_OUTTKNEPDISMSK1_MASK     0x00000010
#define REG_OUTTKNEPDISMSK1_SHIFT    4
#define REG_OUTTKNEPDISMSK1_WIDTH    1

/* SETUPMSK1 */
#define REG_SETUPMSK1          0x00814
#define REG_SETUPMSK1_MASK     0x00000008
#define REG_SETUPMSK1_SHIFT    3
#define REG_SETUPMSK1_WIDTH    1

/* AHBERRMSK1 */
#define REG_AHBERRMSK1          0x00814
#define REG_AHBERRMSK1_MASK     0x00000004
#define REG_AHBERRMSK1_SHIFT    2
#define REG_AHBERRMSK1_WIDTH    1

/* EPDISBLDMSK1 */
#define REG_EPDISBLDMSK1          0x00814
#define REG_EPDISBLDMSK1_MASK     0x00000002
#define REG_EPDISBLDMSK1_SHIFT    1
#define REG_EPDISBLDMSK1_WIDTH    1

/* XFERCOMPLMSK1 */
#define REG_XFERCOMPLMSK1          0x00814
#define REG_XFERCOMPLMSK1_MASK     0x00000001
#define REG_XFERCOMPLMSK1_SHIFT    0
#define REG_XFERCOMPLMSK1_WIDTH    1

/* OUTEPINT10 */
#define REG_OUTEPINT10          0x00818
#define REG_OUTEPINT10_MASK     0x04000000
#define REG_OUTEPINT10_SHIFT    26
#define REG_OUTEPINT10_WIDTH    1

/* OUTEPINT9 */
#define REG_OUTEPINT9          0x00818
#define REG_OUTEPINT9_MASK     0x02000000
#define REG_OUTEPINT9_SHIFT    25
#define REG_OUTEPINT9_WIDTH    1

/* OUTEPINT8 */
#define REG_OUTEPINT8          0x00818
#define REG_OUTEPINT8_MASK     0x01000000
#define REG_OUTEPINT8_SHIFT    24
#define REG_OUTEPINT8_WIDTH    1

/* OUTEPINT7 */
#define REG_OUTEPINT7          0x00818
#define REG_OUTEPINT7_MASK     0x00800000
#define REG_OUTEPINT7_SHIFT    23
#define REG_OUTEPINT7_WIDTH    1

/* OUTEPINT6 */
#define REG_OUTEPINT6          0x00818
#define REG_OUTEPINT6_MASK     0x00400000
#define REG_OUTEPINT6_SHIFT    22
#define REG_OUTEPINT6_WIDTH    1

/* OUTEPINT5 */
#define REG_OUTEPINT5          0x00818
#define REG_OUTEPINT5_MASK     0x00200000
#define REG_OUTEPINT5_SHIFT    21
#define REG_OUTEPINT5_WIDTH    1

/* OUTEPINT4 */
#define REG_OUTEPINT4          0x00818
#define REG_OUTEPINT4_MASK     0x00100000
#define REG_OUTEPINT4_SHIFT    20
#define REG_OUTEPINT4_WIDTH    1

/* OUTEPINT3 */
#define REG_OUTEPINT3          0x00818
#define REG_OUTEPINT3_MASK     0x00080000
#define REG_OUTEPINT3_SHIFT    19
#define REG_OUTEPINT3_WIDTH    1

/* OUTEPINT2 */
#define REG_OUTEPINT2          0x00818
#define REG_OUTEPINT2_MASK     0x00040000
#define REG_OUTEPINT2_SHIFT    18
#define REG_OUTEPINT2_WIDTH    1

/* OUTEPINT1 */
#define REG_OUTEPINT1          0x00818
#define REG_OUTEPINT1_MASK     0x00020000
#define REG_OUTEPINT1_SHIFT    17
#define REG_OUTEPINT1_WIDTH    1

/* OUTEPINT0 */
#define REG_OUTEPINT0          0x00818
#define REG_OUTEPINT0_MASK     0x00010000
#define REG_OUTEPINT0_SHIFT    16
#define REG_OUTEPINT0_WIDTH    1

/* INEPINT10 */
#define REG_INEPINT10          0x00818
#define REG_INEPINT10_MASK     0x00000400
#define REG_INEPINT10_SHIFT    10
#define REG_INEPINT10_WIDTH    1

/* INEPINT9 */
#define REG_INEPINT9          0x00818
#define REG_INEPINT9_MASK     0x00000200
#define REG_INEPINT9_SHIFT    9
#define REG_INEPINT9_WIDTH    1

/* INEPINT8 */
#define REG_INEPINT8          0x00818
#define REG_INEPINT8_MASK     0x00000100
#define REG_INEPINT8_SHIFT    8
#define REG_INEPINT8_WIDTH    1

/* INEPINT7 */
#define REG_INEPINT7          0x00818
#define REG_INEPINT7_MASK     0x00000080
#define REG_INEPINT7_SHIFT    7
#define REG_INEPINT7_WIDTH    1

/* INEPINT6 */
#define REG_INEPINT6          0x00818
#define REG_INEPINT6_MASK     0x00000040
#define REG_INEPINT6_SHIFT    6
#define REG_INEPINT6_WIDTH    1

/* INEPINT5 */
#define REG_INEPINT5          0x00818
#define REG_INEPINT5_MASK     0x00000020
#define REG_INEPINT5_SHIFT    5
#define REG_INEPINT5_WIDTH    1

/* INEPINT4 */
#define REG_INEPINT4          0x00818
#define REG_INEPINT4_MASK     0x00000010
#define REG_INEPINT4_SHIFT    4
#define REG_INEPINT4_WIDTH    1

/* INEPINT3 */
#define REG_INEPINT3          0x00818
#define REG_INEPINT3_MASK     0x00000008
#define REG_INEPINT3_SHIFT    3
#define REG_INEPINT3_WIDTH    1

/* INEPINT2 */
#define REG_INEPINT2          0x00818
#define REG_INEPINT2_MASK     0x00000004
#define REG_INEPINT2_SHIFT    2
#define REG_INEPINT2_WIDTH    1

/* INEPINT1 */
#define REG_INEPINT1          0x00818
#define REG_INEPINT1_MASK     0x00000002
#define REG_INEPINT1_SHIFT    1
#define REG_INEPINT1_WIDTH    1

/* INEPINT0 */
#define REG_INEPINT0          0x00818
#define REG_INEPINT0_MASK     0x00000001
#define REG_INEPINT0_SHIFT    0
#define REG_INEPINT0_WIDTH    1

/* OUTEPMSK10 */
#define REG_OUTEPMSK10          0x0081c
#define REG_OUTEPMSK10_MASK     0x04000000
#define REG_OUTEPMSK10_SHIFT    26
#define REG_OUTEPMSK10_WIDTH    1

/* OUTEPMSK9 */
#define REG_OUTEPMSK9          0x0081c
#define REG_OUTEPMSK9_MASK     0x02000000
#define REG_OUTEPMSK9_SHIFT    25
#define REG_OUTEPMSK9_WIDTH    1

/* OUTEPMSK8 */
#define REG_OUTEPMSK8          0x0081c
#define REG_OUTEPMSK8_MASK     0x01000000
#define REG_OUTEPMSK8_SHIFT    24
#define REG_OUTEPMSK8_WIDTH    1

/* OUTEPMSK7 */
#define REG_OUTEPMSK7          0x0081c
#define REG_OUTEPMSK7_MASK     0x00800000
#define REG_OUTEPMSK7_SHIFT    23
#define REG_OUTEPMSK7_WIDTH    1

/* OUTEPMSK6 */
#define REG_OUTEPMSK6          0x0081c
#define REG_OUTEPMSK6_MASK     0x00400000
#define REG_OUTEPMSK6_SHIFT    22
#define REG_OUTEPMSK6_WIDTH    1

/* OUTEPMSK5 */
#define REG_OUTEPMSK5          0x0081c
#define REG_OUTEPMSK5_MASK     0x00200000
#define REG_OUTEPMSK5_SHIFT    21
#define REG_OUTEPMSK5_WIDTH    1

/* OUTEPMSK4 */
#define REG_OUTEPMSK4          0x0081c
#define REG_OUTEPMSK4_MASK     0x00100000
#define REG_OUTEPMSK4_SHIFT    20
#define REG_OUTEPMSK4_WIDTH    1

/* OUTEPMSK3 */
#define REG_OUTEPMSK3          0x0081c
#define REG_OUTEPMSK3_MASK     0x00080000
#define REG_OUTEPMSK3_SHIFT    19
#define REG_OUTEPMSK3_WIDTH    1

/* OUTEPMSK2 */
#define REG_OUTEPMSK2          0x0081c
#define REG_OUTEPMSK2_MASK     0x00040000
#define REG_OUTEPMSK2_SHIFT    18
#define REG_OUTEPMSK2_WIDTH    1

/* OUTEPMSK1 */
#define REG_OUTEPMSK1          0x0081c
#define REG_OUTEPMSK1_MASK     0x00020000
#define REG_OUTEPMSK1_SHIFT    17
#define REG_OUTEPMSK1_WIDTH    1

/* OUTEPMSK0 */
#define REG_OUTEPMSK0          0x0081c
#define REG_OUTEPMSK0_MASK     0x00010000
#define REG_OUTEPMSK0_SHIFT    16
#define REG_OUTEPMSK0_WIDTH    1

/* INEPMSK10 */
#define REG_INEPMSK10          0x0081c
#define REG_INEPMSK10_MASK     0x00000400
#define REG_INEPMSK10_SHIFT    10
#define REG_INEPMSK10_WIDTH    1

/* INEPMSK9 */
#define REG_INEPMSK9          0x0081c
#define REG_INEPMSK9_MASK     0x00000200
#define REG_INEPMSK9_SHIFT    9
#define REG_INEPMSK9_WIDTH    1

/* INEPMSK8 */
#define REG_INEPMSK8          0x0081c
#define REG_INEPMSK8_MASK     0x00000100
#define REG_INEPMSK8_SHIFT    8
#define REG_INEPMSK8_WIDTH    1

/* INEPMSK7 */
#define REG_INEPMSK7          0x0081c
#define REG_INEPMSK7_MASK     0x00000080
#define REG_INEPMSK7_SHIFT    7
#define REG_INEPMSK7_WIDTH    1

/* INEPMSK6 */
#define REG_INEPMSK6          0x0081c
#define REG_INEPMSK6_MASK     0x00000040
#define REG_INEPMSK6_SHIFT    6
#define REG_INEPMSK6_WIDTH    1

/* INEPMSK5 */
#define REG_INEPMSK5          0x0081c
#define REG_INEPMSK5_MASK     0x00000020
#define REG_INEPMSK5_SHIFT    5
#define REG_INEPMSK5_WIDTH    1

/* INEPMSK4 */
#define REG_INEPMSK4          0x0081c
#define REG_INEPMSK4_MASK     0x00000010
#define REG_INEPMSK4_SHIFT    4
#define REG_INEPMSK4_WIDTH    1

/* INEPMSK3 */
#define REG_INEPMSK3          0x0081c
#define REG_INEPMSK3_MASK     0x00000008
#define REG_INEPMSK3_SHIFT    3
#define REG_INEPMSK3_WIDTH    1

/* INEPMSK2 */
#define REG_INEPMSK2          0x0081c
#define REG_INEPMSK2_MASK     0x00000004
#define REG_INEPMSK2_SHIFT    2
#define REG_INEPMSK2_WIDTH    1

/* INEPMSK1 */
#define REG_INEPMSK1          0x0081c
#define REG_INEPMSK1_MASK     0x00000002
#define REG_INEPMSK1_SHIFT    1
#define REG_INEPMSK1_WIDTH    1

/* INEPMSK0 */
#define REG_INEPMSK0          0x0081c
#define REG_INEPMSK0_MASK     0x00000001
#define REG_INEPMSK0_SHIFT    0
#define REG_INEPMSK0_WIDTH    1

/* DVBUSDIS */
#define REG_DVBUSDIS          0x00828
#define REG_DVBUSDIS_MASK     0x0000ffff
#define REG_DVBUSDIS_SHIFT    0
#define REG_DVBUSDIS_WIDTH    16

/* DVBUSPULSE */
#define REG_DVBUSPULSE          0x0082c
#define REG_DVBUSPULSE_MASK     0x00000fff
#define REG_DVBUSPULSE_SHIFT    0
#define REG_DVBUSPULSE_WIDTH    12

/* ARBPRKEN */
#define REG_ARBPRKEN          0x00830
#define REG_ARBPRKEN_MASK     0x08000000
#define REG_ARBPRKEN_SHIFT    27
#define REG_ARBPRKEN_WIDTH    1

/* RXTHRLEN */
#define REG_RXTHRLEN          0x00830
#define REG_RXTHRLEN_MASK     0x03fe0000
#define REG_RXTHRLEN_SHIFT    17
#define REG_RXTHRLEN_WIDTH    9

/* RXTHREN */
#define REG_RXTHREN          0x00830
#define REG_RXTHREN_MASK     0x00010000
#define REG_RXTHREN_SHIFT    16
#define REG_RXTHREN_WIDTH    1

/* AHBTHRRATIO */
#define REG_AHBTHRRATIO          0x00830
#define REG_AHBTHRRATIO_MASK     0x00001800
#define REG_AHBTHRRATIO_SHIFT    11
#define REG_AHBTHRRATIO_WIDTH    2

/* TXTHRLEN */
#define REG_TXTHRLEN          0x00830
#define REG_TXTHRLEN_MASK     0x000007fc
#define REG_TXTHRLEN_SHIFT    2
#define REG_TXTHRLEN_WIDTH    9

/* ISOTHREN */
#define REG_ISOTHREN          0x00830
#define REG_ISOTHREN_MASK     0x00000002
#define REG_ISOTHREN_SHIFT    1
#define REG_ISOTHREN_WIDTH    1

/* NONISOTHREN */
#define REG_NONISOTHREN          0x00830
#define REG_NONISOTHREN_MASK     0x00000001
#define REG_NONISOTHREN_SHIFT    0
#define REG_NONISOTHREN_WIDTH    1

/* INEPTXFEMPMSK */
#define REG_INEPTXFEMPMSK          0x00834
#define REG_INEPTXFEMPMSK_MASK     0x0000ffff
#define REG_INEPTXFEMPMSK_SHIFT    0
#define REG_INEPTXFEMPMSK_WIDTH    16

/* EPENA0 */
#define REG_EPENA0          0x00900
#define REG_EPENA0_MASK     0x80000000
#define REG_EPENA0_SHIFT    31
#define REG_EPENA0_WIDTH    1

/* EPDIS0 */
#define REG_EPDIS0          0x00900
#define REG_EPDIS0_MASK     0x40000000
#define REG_EPDIS0_SHIFT    30
#define REG_EPDIS0_WIDTH    1

/* TXFNUM0 */
#define REG_TXFNUM0          0x00900
#define REG_TXFNUM0_MASK     0x03c00000
#define REG_TXFNUM0_SHIFT    22
#define REG_TXFNUM0_WIDTH    4

/* STALL0 */
#define REG_STALL0          0x00900
#define REG_STALL0_MASK     0x00200000
#define REG_STALL0_SHIFT    21
#define REG_STALL0_WIDTH    1

/* EPTYPE0 */
#define REG_EPTYPE0          0x00900
#define REG_EPTYPE0_MASK     0x000c0000
#define REG_EPTYPE0_SHIFT    18
#define REG_EPTYPE0_WIDTH    2

/* NAKSTS0 */
#define REG_NAKSTS0          0x00900
#define REG_NAKSTS0_MASK     0x00020000
#define REG_NAKSTS0_SHIFT    17
#define REG_NAKSTS0_WIDTH    1

/* USBACTEP0 */
#define REG_USBACTEP0          0x00900
#define REG_USBACTEP0_MASK     0x00008000
#define REG_USBACTEP0_SHIFT    15
#define REG_USBACTEP0_WIDTH    1

/* MPS0 */
#define REG_MPS0          0x00900
#define REG_MPS0_MASK     0x00000003
#define REG_MPS0_SHIFT    0
#define REG_MPS0_WIDTH    2

/* SNAK0 */
#define REG_SNAK0          0x00900
#define REG_SNAK0_MASK     0x08000000
#define REG_SNAK0_SHIFT    27
#define REG_SNAK0_WIDTH    1

/* CNAK0 */
#define REG_CNAK0          0x00900
#define REG_CNAK0_MASK     0x04000000
#define REG_CNAK0_SHIFT    26
#define REG_CNAK0_WIDTH    1

/* NYETINTRPT0 */
#define REG_NYETINTRPT0          0x00908
#define REG_NYETINTRPT0_MASK     0x00004000
#define REG_NYETINTRPT0_SHIFT    14
#define REG_NYETINTRPT0_WIDTH    1

/* NAKINTRPT0 */
#define REG_NAKINTRPT0          0x00908
#define REG_NAKINTRPT0_MASK     0x00002000
#define REG_NAKINTRPT0_SHIFT    13
#define REG_NAKINTRPT0_WIDTH    1

/* BBLEERR0 */
#define REG_BBLEERR0          0x00908
#define REG_BBLEERR0_MASK     0x00001000
#define REG_BBLEERR0_SHIFT    12
#define REG_BBLEERR0_WIDTH    1

/* PKTDRPSTS0 */
#define REG_PKTDRPSTS0          0x00908
#define REG_PKTDRPSTS0_MASK     0x00000800
#define REG_PKTDRPSTS0_SHIFT    11
#define REG_PKTDRPSTS0_WIDTH    1

/* BNAINTR0 */
#define REG_BNAINTR0          0x00908
#define REG_BNAINTR0_MASK     0x00000200
#define REG_BNAINTR0_SHIFT    9
#define REG_BNAINTR0_WIDTH    1

/* TXFIFOUNDRN0 */
#define REG_TXFIFOUNDRN0          0x00908
#define REG_TXFIFOUNDRN0_MASK     0x00000100
#define REG_TXFIFOUNDRN0_SHIFT    8
#define REG_TXFIFOUNDRN0_WIDTH    1

/* TXFEMP0 */
#define REG_TXFEMP0          0x00908
#define REG_TXFEMP0_MASK     0x00000080
#define REG_TXFEMP0_SHIFT    7
#define REG_TXFEMP0_WIDTH    1

/* INEPNAKEFF0 */
#define REG_INEPNAKEFF0          0x00908
#define REG_INEPNAKEFF0_MASK     0x00000040
#define REG_INEPNAKEFF0_SHIFT    6
#define REG_INEPNAKEFF0_WIDTH    1

/* INTKNEPMIS0 */
#define REG_INTKNEPMIS0          0x00908
#define REG_INTKNEPMIS0_MASK     0x00000020
#define REG_INTKNEPMIS0_SHIFT    5
#define REG_INTKNEPMIS0_WIDTH    1

/* INTKNTXFEMP0 */
#define REG_INTKNTXFEMP0          0x00908
#define REG_INTKNTXFEMP0_MASK     0x00000010
#define REG_INTKNTXFEMP0_SHIFT    4
#define REG_INTKNTXFEMP0_WIDTH    1

/* TIMEOUT0 */
#define REG_TIMEOUT0          0x00908
#define REG_TIMEOUT0_MASK     0x00000008
#define REG_TIMEOUT0_SHIFT    3
#define REG_TIMEOUT0_WIDTH    1

/* AHBERR0 */
#define REG_AHBERR0          0x00908
#define REG_AHBERR0_MASK     0x00000004
#define REG_AHBERR0_SHIFT    2
#define REG_AHBERR0_WIDTH    1

/* EPDISBLD0 */
#define REG_EPDISBLD0          0x00908
#define REG_EPDISBLD0_MASK     0x00000002
#define REG_EPDISBLD0_SHIFT    1
#define REG_EPDISBLD0_WIDTH    1

/* XFERCOMPL0 */
#define REG_XFERCOMPL0          0x00908
#define REG_XFERCOMPL0_MASK     0x00000001
#define REG_XFERCOMPL0_SHIFT    0
#define REG_XFERCOMPL0_WIDTH    1

/* PKTCNT0 */
#define REG_PKTCNT0          0x00910
#define REG_PKTCNT0_MASK     0x00180000
#define REG_PKTCNT0_SHIFT    19
#define REG_PKTCNT0_WIDTH    2

/* XFERSIZE0 */
#define REG_XFERSIZE0          0x00910
#define REG_XFERSIZE0_MASK     0x0000007f
#define REG_XFERSIZE0_SHIFT    0
#define REG_XFERSIZE0_WIDTH    7

/* DIEPDMA0 */
#define REG_DIEPDMA0          0x00914
#define REG_DIEPDMA0_MASK     0xffffffff
#define REG_DIEPDMA0_SHIFT    0
#define REG_DIEPDMA0_WIDTH    32

/* INEPTXFSPCAVAIL0 */
#define REG_INEPTXFSPCAVAIL0          0x00918
#define REG_INEPTXFSPCAVAIL0_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL0_SHIFT    0
#define REG_INEPTXFSPCAVAIL0_WIDTH    16

/* DIEPDMAB0 */
#define REG_DIEPDMAB0          0x0091c
#define REG_DIEPDMAB0_MASK     0xffffffff
#define REG_DIEPDMAB0_SHIFT    0
#define REG_DIEPDMAB0_WIDTH    32

/* EPENA1 */
#define REG_EPENA1          0x00920
#define REG_EPENA1_MASK     0x80000000
#define REG_EPENA1_SHIFT    31
#define REG_EPENA1_WIDTH    1

/* EPDIS1 */
#define REG_EPDIS1          0x00920
#define REG_EPDIS1_MASK     0x40000000
#define REG_EPDIS1_SHIFT    30
#define REG_EPDIS1_WIDTH    1

/* TXFNUM1 */
#define REG_TXFNUM1          0x00920
#define REG_TXFNUM1_MASK     0x03c00000
#define REG_TXFNUM1_SHIFT    22
#define REG_TXFNUM1_WIDTH    4

/* STALL1 */
#define REG_STALL1          0x00920
#define REG_STALL1_MASK     0x00200000
#define REG_STALL1_SHIFT    21
#define REG_STALL1_WIDTH    1

/* EPTYPE1 */
#define REG_EPTYPE1          0x00920
#define REG_EPTYPE1_MASK     0x000c0000
#define REG_EPTYPE1_SHIFT    18
#define REG_EPTYPE1_WIDTH    2

/* NAKSTS1 */
#define REG_NAKSTS1          0x00920
#define REG_NAKSTS1_MASK     0x00020000
#define REG_NAKSTS1_SHIFT    17
#define REG_NAKSTS1_WIDTH    1

/* DPID1 */
#define REG_DPID1          0x00920
#define REG_DPID1_MASK     0x00010000
#define REG_DPID1_SHIFT    16
#define REG_DPID1_WIDTH    1

/* USBACTEP1 */
#define REG_USBACTEP1          0x00920
#define REG_USBACTEP1_MASK     0x00008000
#define REG_USBACTEP1_SHIFT    15
#define REG_USBACTEP1_WIDTH    1

/* MPS1 */
#define REG_MPS1          0x00920
#define REG_MPS1_MASK     0x000007ff
#define REG_MPS1_SHIFT    0
#define REG_MPS1_WIDTH    11

/* SETD1PID1 */
#define REG_SETD1PID1          0x00920
#define REG_SETD1PID1_MASK     0x20000000
#define REG_SETD1PID1_SHIFT    29
#define REG_SETD1PID1_WIDTH    1

/* SETD0PID1 */
#define REG_SETD0PID1          0x00920
#define REG_SETD0PID1_MASK     0x10000000
#define REG_SETD0PID1_SHIFT    28
#define REG_SETD0PID1_WIDTH    1

/* SNAK1 */
#define REG_SNAK1          0x00920
#define REG_SNAK1_MASK     0x08000000
#define REG_SNAK1_SHIFT    27
#define REG_SNAK1_WIDTH    1

/* CNAK1 */
#define REG_CNAK1          0x00920
#define REG_CNAK1_MASK     0x04000000
#define REG_CNAK1_SHIFT    26
#define REG_CNAK1_WIDTH    1

/* NYETINTRPT1 */
#define REG_NYETINTRPT1          0x00928
#define REG_NYETINTRPT1_MASK     0x00004000
#define REG_NYETINTRPT1_SHIFT    14
#define REG_NYETINTRPT1_WIDTH    1

/* NAKINTRPT1 */
#define REG_NAKINTRPT1          0x00928
#define REG_NAKINTRPT1_MASK     0x00002000
#define REG_NAKINTRPT1_SHIFT    13
#define REG_NAKINTRPT1_WIDTH    1

/* BBLEERR1 */
#define REG_BBLEERR1          0x00928
#define REG_BBLEERR1_MASK     0x00001000
#define REG_BBLEERR1_SHIFT    12
#define REG_BBLEERR1_WIDTH    1

/* PKTDRPSTS1 */
#define REG_PKTDRPSTS1          0x00928
#define REG_PKTDRPSTS1_MASK     0x00000800
#define REG_PKTDRPSTS1_SHIFT    11
#define REG_PKTDRPSTS1_WIDTH    1

/* BNAINTR1 */
#define REG_BNAINTR1          0x00928
#define REG_BNAINTR1_MASK     0x00000200
#define REG_BNAINTR1_SHIFT    9
#define REG_BNAINTR1_WIDTH    1

/* TXFIFOUNDRN1 */
#define REG_TXFIFOUNDRN1          0x00928
#define REG_TXFIFOUNDRN1_MASK     0x00000100
#define REG_TXFIFOUNDRN1_SHIFT    8
#define REG_TXFIFOUNDRN1_WIDTH    1

/* TXFEMP1 */
#define REG_TXFEMP1          0x00928
#define REG_TXFEMP1_MASK     0x00000080
#define REG_TXFEMP1_SHIFT    7
#define REG_TXFEMP1_WIDTH    1

/* INEPNAKEFF1 */
#define REG_INEPNAKEFF1          0x00928
#define REG_INEPNAKEFF1_MASK     0x00000040
#define REG_INEPNAKEFF1_SHIFT    6
#define REG_INEPNAKEFF1_WIDTH    1

/* INTKNEPMIS1 */
#define REG_INTKNEPMIS1          0x00928
#define REG_INTKNEPMIS1_MASK     0x00000020
#define REG_INTKNEPMIS1_SHIFT    5
#define REG_INTKNEPMIS1_WIDTH    1

/* INTKNTXFEMP1 */
#define REG_INTKNTXFEMP1          0x00928
#define REG_INTKNTXFEMP1_MASK     0x00000010
#define REG_INTKNTXFEMP1_SHIFT    4
#define REG_INTKNTXFEMP1_WIDTH    1

/* TIMEOUT1 */
#define REG_TIMEOUT1          0x00928
#define REG_TIMEOUT1_MASK     0x00000008
#define REG_TIMEOUT1_SHIFT    3
#define REG_TIMEOUT1_WIDTH    1

/* AHBERR1 */
#define REG_AHBERR1          0x00928
#define REG_AHBERR1_MASK     0x00000004
#define REG_AHBERR1_SHIFT    2
#define REG_AHBERR1_WIDTH    1

/* EPDISBLD1 */
#define REG_EPDISBLD1          0x00928
#define REG_EPDISBLD1_MASK     0x00000002
#define REG_EPDISBLD1_SHIFT    1
#define REG_EPDISBLD1_WIDTH    1

/* XFERCOMPL1 */
#define REG_XFERCOMPL1          0x00928
#define REG_XFERCOMPL1_MASK     0x00000001
#define REG_XFERCOMPL1_SHIFT    0
#define REG_XFERCOMPL1_WIDTH    1

/* MC1 */
#define REG_MC1          0x00930
#define REG_MC1_MASK     0x60000000
#define REG_MC1_SHIFT    29
#define REG_MC1_WIDTH    2

/* PKTCNT1 */
#define REG_PKTCNT1          0x00930
#define REG_PKTCNT1_MASK     0x1ff80000
#define REG_PKTCNT1_SHIFT    19
#define REG_PKTCNT1_WIDTH    10

/* XFERSIZE1 */
#define REG_XFERSIZE1          0x00930
#define REG_XFERSIZE1_MASK     0x0007ffff
#define REG_XFERSIZE1_SHIFT    0
#define REG_XFERSIZE1_WIDTH    19

/* DIEPDMA1 */
#define REG_DIEPDMA1          0x00934
#define REG_DIEPDMA1_MASK     0xffffffff
#define REG_DIEPDMA1_SHIFT    0
#define REG_DIEPDMA1_WIDTH    32

/* INEPTXFSPCAVAIL1 */
#define REG_INEPTXFSPCAVAIL1          0x00938
#define REG_INEPTXFSPCAVAIL1_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL1_SHIFT    0
#define REG_INEPTXFSPCAVAIL1_WIDTH    16

/* DIEPDMAB1 */
#define REG_DIEPDMAB1          0x0093c
#define REG_DIEPDMAB1_MASK     0xffffffff
#define REG_DIEPDMAB1_SHIFT    0
#define REG_DIEPDMAB1_WIDTH    32

/* EPENA2 */
#define REG_EPENA2          0x00940
#define REG_EPENA2_MASK     0x80000000
#define REG_EPENA2_SHIFT    31
#define REG_EPENA2_WIDTH    1

/* EPDIS2 */
#define REG_EPDIS2          0x00940
#define REG_EPDIS2_MASK     0x40000000
#define REG_EPDIS2_SHIFT    30
#define REG_EPDIS2_WIDTH    1

/* TXFNUM2 */
#define REG_TXFNUM2          0x00940
#define REG_TXFNUM2_MASK     0x03c00000
#define REG_TXFNUM2_SHIFT    22
#define REG_TXFNUM2_WIDTH    4

/* STALL2 */
#define REG_STALL2          0x00940
#define REG_STALL2_MASK     0x00200000
#define REG_STALL2_SHIFT    21
#define REG_STALL2_WIDTH    1

/* EPTYPE2 */
#define REG_EPTYPE2          0x00940
#define REG_EPTYPE2_MASK     0x000c0000
#define REG_EPTYPE2_SHIFT    18
#define REG_EPTYPE2_WIDTH    2

/* NAKSTS2 */
#define REG_NAKSTS2          0x00940
#define REG_NAKSTS2_MASK     0x00020000
#define REG_NAKSTS2_SHIFT    17
#define REG_NAKSTS2_WIDTH    1

/* DPID2 */
#define REG_DPID2          0x00940
#define REG_DPID2_MASK     0x00010000
#define REG_DPID2_SHIFT    16
#define REG_DPID2_WIDTH    1

/* USBACTEP2 */
#define REG_USBACTEP2          0x00940
#define REG_USBACTEP2_MASK     0x00008000
#define REG_USBACTEP2_SHIFT    15
#define REG_USBACTEP2_WIDTH    1

/* MPS2 */
#define REG_MPS2          0x00940
#define REG_MPS2_MASK     0x000007ff
#define REG_MPS2_SHIFT    0
#define REG_MPS2_WIDTH    11

/* SETD1PID2 */
#define REG_SETD1PID2          0x00940
#define REG_SETD1PID2_MASK     0x20000000
#define REG_SETD1PID2_SHIFT    29
#define REG_SETD1PID2_WIDTH    1

/* SETD0PID2 */
#define REG_SETD0PID2          0x00940
#define REG_SETD0PID2_MASK     0x10000000
#define REG_SETD0PID2_SHIFT    28
#define REG_SETD0PID2_WIDTH    1

/* SNAK2 */
#define REG_SNAK2          0x00940
#define REG_SNAK2_MASK     0x08000000
#define REG_SNAK2_SHIFT    27
#define REG_SNAK2_WIDTH    1

/* CNAK2 */
#define REG_CNAK2          0x00940
#define REG_CNAK2_MASK     0x04000000
#define REG_CNAK2_SHIFT    26
#define REG_CNAK2_WIDTH    1

/* NYETINTRPT2 */
#define REG_NYETINTRPT2          0x00948
#define REG_NYETINTRPT2_MASK     0x00004000
#define REG_NYETINTRPT2_SHIFT    14
#define REG_NYETINTRPT2_WIDTH    1

/* NAKINTRPT2 */
#define REG_NAKINTRPT2          0x00948
#define REG_NAKINTRPT2_MASK     0x00002000
#define REG_NAKINTRPT2_SHIFT    13
#define REG_NAKINTRPT2_WIDTH    1

/* BBLEERR2 */
#define REG_BBLEERR2          0x00948
#define REG_BBLEERR2_MASK     0x00001000
#define REG_BBLEERR2_SHIFT    12
#define REG_BBLEERR2_WIDTH    1

/* PKTDRPSTS2 */
#define REG_PKTDRPSTS2          0x00948
#define REG_PKTDRPSTS2_MASK     0x00000800
#define REG_PKTDRPSTS2_SHIFT    11
#define REG_PKTDRPSTS2_WIDTH    1

/* BNAINTR2 */
#define REG_BNAINTR2          0x00948
#define REG_BNAINTR2_MASK     0x00000200
#define REG_BNAINTR2_SHIFT    9
#define REG_BNAINTR2_WIDTH    1

/* TXFIFOUNDRN2 */
#define REG_TXFIFOUNDRN2          0x00948
#define REG_TXFIFOUNDRN2_MASK     0x00000100
#define REG_TXFIFOUNDRN2_SHIFT    8
#define REG_TXFIFOUNDRN2_WIDTH    1

/* TXFEMP2 */
#define REG_TXFEMP2          0x00948
#define REG_TXFEMP2_MASK     0x00000080
#define REG_TXFEMP2_SHIFT    7
#define REG_TXFEMP2_WIDTH    1

/* INEPNAKEFF2 */
#define REG_INEPNAKEFF2          0x00948
#define REG_INEPNAKEFF2_MASK     0x00000040
#define REG_INEPNAKEFF2_SHIFT    6
#define REG_INEPNAKEFF2_WIDTH    1

/* INTKNEPMIS2 */
#define REG_INTKNEPMIS2          0x00948
#define REG_INTKNEPMIS2_MASK     0x00000020
#define REG_INTKNEPMIS2_SHIFT    5
#define REG_INTKNEPMIS2_WIDTH    1

/* INTKNTXFEMP2 */
#define REG_INTKNTXFEMP2          0x00948
#define REG_INTKNTXFEMP2_MASK     0x00000010
#define REG_INTKNTXFEMP2_SHIFT    4
#define REG_INTKNTXFEMP2_WIDTH    1

/* TIMEOUT2 */
#define REG_TIMEOUT2          0x00948
#define REG_TIMEOUT2_MASK     0x00000008
#define REG_TIMEOUT2_SHIFT    3
#define REG_TIMEOUT2_WIDTH    1

/* AHBERR2 */
#define REG_AHBERR2          0x00948
#define REG_AHBERR2_MASK     0x00000004
#define REG_AHBERR2_SHIFT    2
#define REG_AHBERR2_WIDTH    1

/* EPDISBLD2 */
#define REG_EPDISBLD2          0x00948
#define REG_EPDISBLD2_MASK     0x00000002
#define REG_EPDISBLD2_SHIFT    1
#define REG_EPDISBLD2_WIDTH    1

/* XFERCOMPL2 */
#define REG_XFERCOMPL2          0x00948
#define REG_XFERCOMPL2_MASK     0x00000001
#define REG_XFERCOMPL2_SHIFT    0
#define REG_XFERCOMPL2_WIDTH    1

/* MC2 */
#define REG_MC2          0x00950
#define REG_MC2_MASK     0x60000000
#define REG_MC2_SHIFT    29
#define REG_MC2_WIDTH    2

/* PKTCNT2 */
#define REG_PKTCNT2          0x00950
#define REG_PKTCNT2_MASK     0x1ff80000
#define REG_PKTCNT2_SHIFT    19
#define REG_PKTCNT2_WIDTH    10

/* XFERSIZE2 */
#define REG_XFERSIZE2          0x00950
#define REG_XFERSIZE2_MASK     0x0007ffff
#define REG_XFERSIZE2_SHIFT    0
#define REG_XFERSIZE2_WIDTH    19

/* DIEPDMA2 */
#define REG_DIEPDMA2          0x00954
#define REG_DIEPDMA2_MASK     0xffffffff
#define REG_DIEPDMA2_SHIFT    0
#define REG_DIEPDMA2_WIDTH    32

/* INEPTXFSPCAVAIL2 */
#define REG_INEPTXFSPCAVAIL2          0x00958
#define REG_INEPTXFSPCAVAIL2_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL2_SHIFT    0
#define REG_INEPTXFSPCAVAIL2_WIDTH    16

/* DIEPDMAB2 */
#define REG_DIEPDMAB2          0x0095c
#define REG_DIEPDMAB2_MASK     0xffffffff
#define REG_DIEPDMAB2_SHIFT    0
#define REG_DIEPDMAB2_WIDTH    32

/* EPENA3 */
#define REG_EPENA3          0x00960
#define REG_EPENA3_MASK     0x80000000
#define REG_EPENA3_SHIFT    31
#define REG_EPENA3_WIDTH    1

/* EPDIS3 */
#define REG_EPDIS3          0x00960
#define REG_EPDIS3_MASK     0x40000000
#define REG_EPDIS3_SHIFT    30
#define REG_EPDIS3_WIDTH    1

/* TXFNUM3 */
#define REG_TXFNUM3          0x00960
#define REG_TXFNUM3_MASK     0x03c00000
#define REG_TXFNUM3_SHIFT    22
#define REG_TXFNUM3_WIDTH    4

/* STALL3 */
#define REG_STALL3          0x00960
#define REG_STALL3_MASK     0x00200000
#define REG_STALL3_SHIFT    21
#define REG_STALL3_WIDTH    1

/* EPTYPE3 */
#define REG_EPTYPE3          0x00960
#define REG_EPTYPE3_MASK     0x000c0000
#define REG_EPTYPE3_SHIFT    18
#define REG_EPTYPE3_WIDTH    2

/* NAKSTS3 */
#define REG_NAKSTS3          0x00960
#define REG_NAKSTS3_MASK     0x00020000
#define REG_NAKSTS3_SHIFT    17
#define REG_NAKSTS3_WIDTH    1

/* DPID3 */
#define REG_DPID3          0x00960
#define REG_DPID3_MASK     0x00010000
#define REG_DPID3_SHIFT    16
#define REG_DPID3_WIDTH    1

/* USBACTEP3 */
#define REG_USBACTEP3          0x00960
#define REG_USBACTEP3_MASK     0x00008000
#define REG_USBACTEP3_SHIFT    15
#define REG_USBACTEP3_WIDTH    1

/* MPS3 */
#define REG_MPS3          0x00960
#define REG_MPS3_MASK     0x000007ff
#define REG_MPS3_SHIFT    0
#define REG_MPS3_WIDTH    11

/* SETD1PID3 */
#define REG_SETD1PID3          0x00960
#define REG_SETD1PID3_MASK     0x20000000
#define REG_SETD1PID3_SHIFT    29
#define REG_SETD1PID3_WIDTH    1

/* SETD0PID3 */
#define REG_SETD0PID3          0x00960
#define REG_SETD0PID3_MASK     0x10000000
#define REG_SETD0PID3_SHIFT    28
#define REG_SETD0PID3_WIDTH    1

/* SNAK3 */
#define REG_SNAK3          0x00960
#define REG_SNAK3_MASK     0x08000000
#define REG_SNAK3_SHIFT    27
#define REG_SNAK3_WIDTH    1

/* CNAK3 */
#define REG_CNAK3          0x00960
#define REG_CNAK3_MASK     0x04000000
#define REG_CNAK3_SHIFT    26
#define REG_CNAK3_WIDTH    1

/* NYETINTRPT3 */
#define REG_NYETINTRPT3          0x00968
#define REG_NYETINTRPT3_MASK     0x00004000
#define REG_NYETINTRPT3_SHIFT    14
#define REG_NYETINTRPT3_WIDTH    1

/* NAKINTRPT3 */
#define REG_NAKINTRPT3          0x00968
#define REG_NAKINTRPT3_MASK     0x00002000
#define REG_NAKINTRPT3_SHIFT    13
#define REG_NAKINTRPT3_WIDTH    1

/* BBLEERR3 */
#define REG_BBLEERR3          0x00968
#define REG_BBLEERR3_MASK     0x00001000
#define REG_BBLEERR3_SHIFT    12
#define REG_BBLEERR3_WIDTH    1

/* PKTDRPSTS3 */
#define REG_PKTDRPSTS3          0x00968
#define REG_PKTDRPSTS3_MASK     0x00000800
#define REG_PKTDRPSTS3_SHIFT    11
#define REG_PKTDRPSTS3_WIDTH    1

/* BNAINTR3 */
#define REG_BNAINTR3          0x00968
#define REG_BNAINTR3_MASK     0x00000200
#define REG_BNAINTR3_SHIFT    9
#define REG_BNAINTR3_WIDTH    1

/* TXFIFOUNDRN3 */
#define REG_TXFIFOUNDRN3          0x00968
#define REG_TXFIFOUNDRN3_MASK     0x00000100
#define REG_TXFIFOUNDRN3_SHIFT    8
#define REG_TXFIFOUNDRN3_WIDTH    1

/* TXFEMP3 */
#define REG_TXFEMP3          0x00968
#define REG_TXFEMP3_MASK     0x00000080
#define REG_TXFEMP3_SHIFT    7
#define REG_TXFEMP3_WIDTH    1

/* INEPNAKEFF3 */
#define REG_INEPNAKEFF3          0x00968
#define REG_INEPNAKEFF3_MASK     0x00000040
#define REG_INEPNAKEFF3_SHIFT    6
#define REG_INEPNAKEFF3_WIDTH    1

/* INTKNEPMIS3 */
#define REG_INTKNEPMIS3          0x00968
#define REG_INTKNEPMIS3_MASK     0x00000020
#define REG_INTKNEPMIS3_SHIFT    5
#define REG_INTKNEPMIS3_WIDTH    1

/* INTKNTXFEMP3 */
#define REG_INTKNTXFEMP3          0x00968
#define REG_INTKNTXFEMP3_MASK     0x00000010
#define REG_INTKNTXFEMP3_SHIFT    4
#define REG_INTKNTXFEMP3_WIDTH    1

/* TIMEOUT3 */
#define REG_TIMEOUT3          0x00968
#define REG_TIMEOUT3_MASK     0x00000008
#define REG_TIMEOUT3_SHIFT    3
#define REG_TIMEOUT3_WIDTH    1

/* AHBERR3 */
#define REG_AHBERR3          0x00968
#define REG_AHBERR3_MASK     0x00000004
#define REG_AHBERR3_SHIFT    2
#define REG_AHBERR3_WIDTH    1

/* EPDISBLD3 */
#define REG_EPDISBLD3          0x00968
#define REG_EPDISBLD3_MASK     0x00000002
#define REG_EPDISBLD3_SHIFT    1
#define REG_EPDISBLD3_WIDTH    1

/* XFERCOMPL3 */
#define REG_XFERCOMPL3          0x00968
#define REG_XFERCOMPL3_MASK     0x00000001
#define REG_XFERCOMPL3_SHIFT    0
#define REG_XFERCOMPL3_WIDTH    1

/* MC3 */
#define REG_MC3          0x00970
#define REG_MC3_MASK     0x60000000
#define REG_MC3_SHIFT    29
#define REG_MC3_WIDTH    2

/* PKTCNT3 */
#define REG_PKTCNT3          0x00970
#define REG_PKTCNT3_MASK     0x1ff80000
#define REG_PKTCNT3_SHIFT    19
#define REG_PKTCNT3_WIDTH    10

/* XFERSIZE3 */
#define REG_XFERSIZE3          0x00970
#define REG_XFERSIZE3_MASK     0x0007ffff
#define REG_XFERSIZE3_SHIFT    0
#define REG_XFERSIZE3_WIDTH    19

/* DIEPDMA3 */
#define REG_DIEPDMA3          0x00974
#define REG_DIEPDMA3_MASK     0xffffffff
#define REG_DIEPDMA3_SHIFT    0
#define REG_DIEPDMA3_WIDTH    32

/* INEPTXFSPCAVAIL3 */
#define REG_INEPTXFSPCAVAIL3          0x00978
#define REG_INEPTXFSPCAVAIL3_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL3_SHIFT    0
#define REG_INEPTXFSPCAVAIL3_WIDTH    16

/* DIEPDMAB3 */
#define REG_DIEPDMAB3          0x0097c
#define REG_DIEPDMAB3_MASK     0xffffffff
#define REG_DIEPDMAB3_SHIFT    0
#define REG_DIEPDMAB3_WIDTH    32

/* EPENA4 */
#define REG_EPENA4          0x00980
#define REG_EPENA4_MASK     0x80000000
#define REG_EPENA4_SHIFT    31
#define REG_EPENA4_WIDTH    1

/* EPDIS4 */
#define REG_EPDIS4          0x00980
#define REG_EPDIS4_MASK     0x40000000
#define REG_EPDIS4_SHIFT    30
#define REG_EPDIS4_WIDTH    1

/* TXFNUM4 */
#define REG_TXFNUM4          0x00980
#define REG_TXFNUM4_MASK     0x03c00000
#define REG_TXFNUM4_SHIFT    22
#define REG_TXFNUM4_WIDTH    4

/* STALL4 */
#define REG_STALL4          0x00980
#define REG_STALL4_MASK     0x00200000
#define REG_STALL4_SHIFT    21
#define REG_STALL4_WIDTH    1

/* EPTYPE4 */
#define REG_EPTYPE4          0x00980
#define REG_EPTYPE4_MASK     0x000c0000
#define REG_EPTYPE4_SHIFT    18
#define REG_EPTYPE4_WIDTH    2

/* NAKSTS4 */
#define REG_NAKSTS4          0x00980
#define REG_NAKSTS4_MASK     0x00020000
#define REG_NAKSTS4_SHIFT    17
#define REG_NAKSTS4_WIDTH    1

/* DPID4 */
#define REG_DPID4          0x00980
#define REG_DPID4_MASK     0x00010000
#define REG_DPID4_SHIFT    16
#define REG_DPID4_WIDTH    1

/* USBACTEP4 */
#define REG_USBACTEP4          0x00980
#define REG_USBACTEP4_MASK     0x00008000
#define REG_USBACTEP4_SHIFT    15
#define REG_USBACTEP4_WIDTH    1

/* MPS4 */
#define REG_MPS4          0x00980
#define REG_MPS4_MASK     0x000007ff
#define REG_MPS4_SHIFT    0
#define REG_MPS4_WIDTH    11

/* SETD1PID4 */
#define REG_SETD1PID4          0x00980
#define REG_SETD1PID4_MASK     0x20000000
#define REG_SETD1PID4_SHIFT    29
#define REG_SETD1PID4_WIDTH    1

/* SETD0PID4 */
#define REG_SETD0PID4          0x00980
#define REG_SETD0PID4_MASK     0x10000000
#define REG_SETD0PID4_SHIFT    28
#define REG_SETD0PID4_WIDTH    1

/* SNAK4 */
#define REG_SNAK4          0x00980
#define REG_SNAK4_MASK     0x08000000
#define REG_SNAK4_SHIFT    27
#define REG_SNAK4_WIDTH    1

/* CNAK4 */
#define REG_CNAK4          0x00980
#define REG_CNAK4_MASK     0x04000000
#define REG_CNAK4_SHIFT    26
#define REG_CNAK4_WIDTH    1

/* NYETINTRPT4 */
#define REG_NYETINTRPT4          0x00988
#define REG_NYETINTRPT4_MASK     0x00004000
#define REG_NYETINTRPT4_SHIFT    14
#define REG_NYETINTRPT4_WIDTH    1

/* NAKINTRPT4 */
#define REG_NAKINTRPT4          0x00988
#define REG_NAKINTRPT4_MASK     0x00002000
#define REG_NAKINTRPT4_SHIFT    13
#define REG_NAKINTRPT4_WIDTH    1

/* BBLEERR4 */
#define REG_BBLEERR4          0x00988
#define REG_BBLEERR4_MASK     0x00001000
#define REG_BBLEERR4_SHIFT    12
#define REG_BBLEERR4_WIDTH    1

/* PKTDRPSTS4 */
#define REG_PKTDRPSTS4          0x00988
#define REG_PKTDRPSTS4_MASK     0x00000800
#define REG_PKTDRPSTS4_SHIFT    11
#define REG_PKTDRPSTS4_WIDTH    1

/* BNAINTR4 */
#define REG_BNAINTR4          0x00988
#define REG_BNAINTR4_MASK     0x00000200
#define REG_BNAINTR4_SHIFT    9
#define REG_BNAINTR4_WIDTH    1

/* TXFIFOUNDRN4 */
#define REG_TXFIFOUNDRN4          0x00988
#define REG_TXFIFOUNDRN4_MASK     0x00000100
#define REG_TXFIFOUNDRN4_SHIFT    8
#define REG_TXFIFOUNDRN4_WIDTH    1

/* TXFEMP4 */
#define REG_TXFEMP4          0x00988
#define REG_TXFEMP4_MASK     0x00000080
#define REG_TXFEMP4_SHIFT    7
#define REG_TXFEMP4_WIDTH    1

/* INEPNAKEFF4 */
#define REG_INEPNAKEFF4          0x00988
#define REG_INEPNAKEFF4_MASK     0x00000040
#define REG_INEPNAKEFF4_SHIFT    6
#define REG_INEPNAKEFF4_WIDTH    1

/* INTKNEPMIS4 */
#define REG_INTKNEPMIS4          0x00988
#define REG_INTKNEPMIS4_MASK     0x00000020
#define REG_INTKNEPMIS4_SHIFT    5
#define REG_INTKNEPMIS4_WIDTH    1

/* INTKNTXFEMP4 */
#define REG_INTKNTXFEMP4          0x00988
#define REG_INTKNTXFEMP4_MASK     0x00000010
#define REG_INTKNTXFEMP4_SHIFT    4
#define REG_INTKNTXFEMP4_WIDTH    1

/* TIMEOUT4 */
#define REG_TIMEOUT4          0x00988
#define REG_TIMEOUT4_MASK     0x00000008
#define REG_TIMEOUT4_SHIFT    3
#define REG_TIMEOUT4_WIDTH    1

/* AHBERR4 */
#define REG_AHBERR4          0x00988
#define REG_AHBERR4_MASK     0x00000004
#define REG_AHBERR4_SHIFT    2
#define REG_AHBERR4_WIDTH    1

/* EPDISBLD4 */
#define REG_EPDISBLD4          0x00988
#define REG_EPDISBLD4_MASK     0x00000002
#define REG_EPDISBLD4_SHIFT    1
#define REG_EPDISBLD4_WIDTH    1

/* XFERCOMPL4 */
#define REG_XFERCOMPL4          0x00988
#define REG_XFERCOMPL4_MASK     0x00000001
#define REG_XFERCOMPL4_SHIFT    0
#define REG_XFERCOMPL4_WIDTH    1

/* MC4 */
#define REG_MC4          0x00990
#define REG_MC4_MASK     0x60000000
#define REG_MC4_SHIFT    29
#define REG_MC4_WIDTH    2

/* PKTCNT4 */
#define REG_PKTCNT4          0x00990
#define REG_PKTCNT4_MASK     0x1ff80000
#define REG_PKTCNT4_SHIFT    19
#define REG_PKTCNT4_WIDTH    10

/* XFERSIZE4 */
#define REG_XFERSIZE4          0x00990
#define REG_XFERSIZE4_MASK     0x0007ffff
#define REG_XFERSIZE4_SHIFT    0
#define REG_XFERSIZE4_WIDTH    19

/* DIEPDMA4 */
#define REG_DIEPDMA4          0x00994
#define REG_DIEPDMA4_MASK     0xffffffff
#define REG_DIEPDMA4_SHIFT    0
#define REG_DIEPDMA4_WIDTH    32

/* INEPTXFSPCAVAIL4 */
#define REG_INEPTXFSPCAVAIL4          0x00998
#define REG_INEPTXFSPCAVAIL4_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL4_SHIFT    0
#define REG_INEPTXFSPCAVAIL4_WIDTH    16

/* DIEPDMAB4 */
#define REG_DIEPDMAB4          0x0099c
#define REG_DIEPDMAB4_MASK     0xffffffff
#define REG_DIEPDMAB4_SHIFT    0
#define REG_DIEPDMAB4_WIDTH    32

/* EPENA5 */
#define REG_EPENA5          0x009a0
#define REG_EPENA5_MASK     0x80000000
#define REG_EPENA5_SHIFT    31
#define REG_EPENA5_WIDTH    1

/* EPDIS5 */
#define REG_EPDIS5          0x009a0
#define REG_EPDIS5_MASK     0x40000000
#define REG_EPDIS5_SHIFT    30
#define REG_EPDIS5_WIDTH    1

/* TXFNUM5 */
#define REG_TXFNUM5          0x009a0
#define REG_TXFNUM5_MASK     0x03c00000
#define REG_TXFNUM5_SHIFT    22
#define REG_TXFNUM5_WIDTH    4

/* STALL5 */
#define REG_STALL5          0x009a0
#define REG_STALL5_MASK     0x00200000
#define REG_STALL5_SHIFT    21
#define REG_STALL5_WIDTH    1

/* EPTYPE5 */
#define REG_EPTYPE5          0x009a0
#define REG_EPTYPE5_MASK     0x000c0000
#define REG_EPTYPE5_SHIFT    18
#define REG_EPTYPE5_WIDTH    2

/* NAKSTS5 */
#define REG_NAKSTS5          0x009a0
#define REG_NAKSTS5_MASK     0x00020000
#define REG_NAKSTS5_SHIFT    17
#define REG_NAKSTS5_WIDTH    1

/* DPID5 */
#define REG_DPID5          0x009a0
#define REG_DPID5_MASK     0x00010000
#define REG_DPID5_SHIFT    16
#define REG_DPID5_WIDTH    1

/* USBACTEP5 */
#define REG_USBACTEP5          0x009a0
#define REG_USBACTEP5_MASK     0x00008000
#define REG_USBACTEP5_SHIFT    15
#define REG_USBACTEP5_WIDTH    1

/* MPS5 */
#define REG_MPS5          0x009a0
#define REG_MPS5_MASK     0x000007ff
#define REG_MPS5_SHIFT    0
#define REG_MPS5_WIDTH    11

/* SETD1PID5 */
#define REG_SETD1PID5          0x009a0
#define REG_SETD1PID5_MASK     0x20000000
#define REG_SETD1PID5_SHIFT    29
#define REG_SETD1PID5_WIDTH    1

/* SETD0PID5 */
#define REG_SETD0PID5          0x009a0
#define REG_SETD0PID5_MASK     0x10000000
#define REG_SETD0PID5_SHIFT    28
#define REG_SETD0PID5_WIDTH    1

/* SNAK5 */
#define REG_SNAK5          0x009a0
#define REG_SNAK5_MASK     0x08000000
#define REG_SNAK5_SHIFT    27
#define REG_SNAK5_WIDTH    1

/* CNAK5 */
#define REG_CNAK5          0x009a0
#define REG_CNAK5_MASK     0x04000000
#define REG_CNAK5_SHIFT    26
#define REG_CNAK5_WIDTH    1

/* NYETINTRPT5 */
#define REG_NYETINTRPT5          0x009a8
#define REG_NYETINTRPT5_MASK     0x00004000
#define REG_NYETINTRPT5_SHIFT    14
#define REG_NYETINTRPT5_WIDTH    1

/* NAKINTRPT5 */
#define REG_NAKINTRPT5          0x009a8
#define REG_NAKINTRPT5_MASK     0x00002000
#define REG_NAKINTRPT5_SHIFT    13
#define REG_NAKINTRPT5_WIDTH    1

/* BBLEERR5 */
#define REG_BBLEERR5          0x009a8
#define REG_BBLEERR5_MASK     0x00001000
#define REG_BBLEERR5_SHIFT    12
#define REG_BBLEERR5_WIDTH    1

/* PKTDRPSTS5 */
#define REG_PKTDRPSTS5          0x009a8
#define REG_PKTDRPSTS5_MASK     0x00000800
#define REG_PKTDRPSTS5_SHIFT    11
#define REG_PKTDRPSTS5_WIDTH    1

/* BNAINTR5 */
#define REG_BNAINTR5          0x009a8
#define REG_BNAINTR5_MASK     0x00000200
#define REG_BNAINTR5_SHIFT    9
#define REG_BNAINTR5_WIDTH    1

/* TXFIFOUNDRN5 */
#define REG_TXFIFOUNDRN5          0x009a8
#define REG_TXFIFOUNDRN5_MASK     0x00000100
#define REG_TXFIFOUNDRN5_SHIFT    8
#define REG_TXFIFOUNDRN5_WIDTH    1

/* TXFEMP5 */
#define REG_TXFEMP5          0x009a8
#define REG_TXFEMP5_MASK     0x00000080
#define REG_TXFEMP5_SHIFT    7
#define REG_TXFEMP5_WIDTH    1

/* INEPNAKEFF5 */
#define REG_INEPNAKEFF5          0x009a8
#define REG_INEPNAKEFF5_MASK     0x00000040
#define REG_INEPNAKEFF5_SHIFT    6
#define REG_INEPNAKEFF5_WIDTH    1

/* INTKNEPMIS5 */
#define REG_INTKNEPMIS5          0x009a8
#define REG_INTKNEPMIS5_MASK     0x00000020
#define REG_INTKNEPMIS5_SHIFT    5
#define REG_INTKNEPMIS5_WIDTH    1

/* INTKNTXFEMP5 */
#define REG_INTKNTXFEMP5          0x009a8
#define REG_INTKNTXFEMP5_MASK     0x00000010
#define REG_INTKNTXFEMP5_SHIFT    4
#define REG_INTKNTXFEMP5_WIDTH    1

/* TIMEOUT5 */
#define REG_TIMEOUT5          0x009a8
#define REG_TIMEOUT5_MASK     0x00000008
#define REG_TIMEOUT5_SHIFT    3
#define REG_TIMEOUT5_WIDTH    1

/* AHBERR5 */
#define REG_AHBERR5          0x009a8
#define REG_AHBERR5_MASK     0x00000004
#define REG_AHBERR5_SHIFT    2
#define REG_AHBERR5_WIDTH    1

/* EPDISBLD5 */
#define REG_EPDISBLD5          0x009a8
#define REG_EPDISBLD5_MASK     0x00000002
#define REG_EPDISBLD5_SHIFT    1
#define REG_EPDISBLD5_WIDTH    1

/* XFERCOMPL5 */
#define REG_XFERCOMPL5          0x009a8
#define REG_XFERCOMPL5_MASK     0x00000001
#define REG_XFERCOMPL5_SHIFT    0
#define REG_XFERCOMPL5_WIDTH    1

/* MC5 */
#define REG_MC5          0x009b0
#define REG_MC5_MASK     0x60000000
#define REG_MC5_SHIFT    29
#define REG_MC5_WIDTH    2

/* PKTCNT5 */
#define REG_PKTCNT5          0x009b0
#define REG_PKTCNT5_MASK     0x1ff80000
#define REG_PKTCNT5_SHIFT    19
#define REG_PKTCNT5_WIDTH    10

/* XFERSIZE5 */
#define REG_XFERSIZE5          0x009b0
#define REG_XFERSIZE5_MASK     0x0007ffff
#define REG_XFERSIZE5_SHIFT    0
#define REG_XFERSIZE5_WIDTH    19

/* DIEPDMA5 */
#define REG_DIEPDMA5          0x009b4
#define REG_DIEPDMA5_MASK     0xffffffff
#define REG_DIEPDMA5_SHIFT    0
#define REG_DIEPDMA5_WIDTH    32

/* INEPTXFSPCAVAIL5 */
#define REG_INEPTXFSPCAVAIL5          0x009b8
#define REG_INEPTXFSPCAVAIL5_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL5_SHIFT    0
#define REG_INEPTXFSPCAVAIL5_WIDTH    16

/* DIEPDMAB5 */
#define REG_DIEPDMAB5          0x009bc
#define REG_DIEPDMAB5_MASK     0xffffffff
#define REG_DIEPDMAB5_SHIFT    0
#define REG_DIEPDMAB5_WIDTH    32

/* EPENA6 */
#define REG_EPENA6          0x009c0
#define REG_EPENA6_MASK     0x80000000
#define REG_EPENA6_SHIFT    31
#define REG_EPENA6_WIDTH    1

/* EPDIS6 */
#define REG_EPDIS6          0x009c0
#define REG_EPDIS6_MASK     0x40000000
#define REG_EPDIS6_SHIFT    30
#define REG_EPDIS6_WIDTH    1

/* TXFNUM6 */
#define REG_TXFNUM6          0x009c0
#define REG_TXFNUM6_MASK     0x03c00000
#define REG_TXFNUM6_SHIFT    22
#define REG_TXFNUM6_WIDTH    4

/* STALL6 */
#define REG_STALL6          0x009c0
#define REG_STALL6_MASK     0x00200000
#define REG_STALL6_SHIFT    21
#define REG_STALL6_WIDTH    1

/* EPTYPE6 */
#define REG_EPTYPE6          0x009c0
#define REG_EPTYPE6_MASK     0x000c0000
#define REG_EPTYPE6_SHIFT    18
#define REG_EPTYPE6_WIDTH    2

/* NAKSTS6 */
#define REG_NAKSTS6          0x009c0
#define REG_NAKSTS6_MASK     0x00020000
#define REG_NAKSTS6_SHIFT    17
#define REG_NAKSTS6_WIDTH    1

/* DPID6 */
#define REG_DPID6          0x009c0
#define REG_DPID6_MASK     0x00010000
#define REG_DPID6_SHIFT    16
#define REG_DPID6_WIDTH    1

/* USBACTEP6 */
#define REG_USBACTEP6          0x009c0
#define REG_USBACTEP6_MASK     0x00008000
#define REG_USBACTEP6_SHIFT    15
#define REG_USBACTEP6_WIDTH    1

/* MPS6 */
#define REG_MPS6          0x009c0
#define REG_MPS6_MASK     0x000007ff
#define REG_MPS6_SHIFT    0
#define REG_MPS6_WIDTH    11

/* SETD1PID6 */
#define REG_SETD1PID6          0x009c0
#define REG_SETD1PID6_MASK     0x20000000
#define REG_SETD1PID6_SHIFT    29
#define REG_SETD1PID6_WIDTH    1

/* SETD0PID6 */
#define REG_SETD0PID6          0x009c0
#define REG_SETD0PID6_MASK     0x10000000
#define REG_SETD0PID6_SHIFT    28
#define REG_SETD0PID6_WIDTH    1

/* SNAK6 */
#define REG_SNAK6          0x009c0
#define REG_SNAK6_MASK     0x08000000
#define REG_SNAK6_SHIFT    27
#define REG_SNAK6_WIDTH    1

/* CNAK6 */
#define REG_CNAK6          0x009c0
#define REG_CNAK6_MASK     0x04000000
#define REG_CNAK6_SHIFT    26
#define REG_CNAK6_WIDTH    1

/* NYETINTRPT6 */
#define REG_NYETINTRPT6          0x009c8
#define REG_NYETINTRPT6_MASK     0x00004000
#define REG_NYETINTRPT6_SHIFT    14
#define REG_NYETINTRPT6_WIDTH    1

/* NAKINTRPT6 */
#define REG_NAKINTRPT6          0x009c8
#define REG_NAKINTRPT6_MASK     0x00002000
#define REG_NAKINTRPT6_SHIFT    13
#define REG_NAKINTRPT6_WIDTH    1

/* BBLEERR6 */
#define REG_BBLEERR6          0x009c8
#define REG_BBLEERR6_MASK     0x00001000
#define REG_BBLEERR6_SHIFT    12
#define REG_BBLEERR6_WIDTH    1

/* PKTDRPSTS6 */
#define REG_PKTDRPSTS6          0x009c8
#define REG_PKTDRPSTS6_MASK     0x00000800
#define REG_PKTDRPSTS6_SHIFT    11
#define REG_PKTDRPSTS6_WIDTH    1

/* BNAINTR6 */
#define REG_BNAINTR6          0x009c8
#define REG_BNAINTR6_MASK     0x00000200
#define REG_BNAINTR6_SHIFT    9
#define REG_BNAINTR6_WIDTH    1

/* TXFIFOUNDRN6 */
#define REG_TXFIFOUNDRN6          0x009c8
#define REG_TXFIFOUNDRN6_MASK     0x00000100
#define REG_TXFIFOUNDRN6_SHIFT    8
#define REG_TXFIFOUNDRN6_WIDTH    1

/* TXFEMP6 */
#define REG_TXFEMP6          0x009c8
#define REG_TXFEMP6_MASK     0x00000080
#define REG_TXFEMP6_SHIFT    7
#define REG_TXFEMP6_WIDTH    1

/* INEPNAKEFF6 */
#define REG_INEPNAKEFF6          0x009c8
#define REG_INEPNAKEFF6_MASK     0x00000040
#define REG_INEPNAKEFF6_SHIFT    6
#define REG_INEPNAKEFF6_WIDTH    1

/* INTKNEPMIS6 */
#define REG_INTKNEPMIS6          0x009c8
#define REG_INTKNEPMIS6_MASK     0x00000020
#define REG_INTKNEPMIS6_SHIFT    5
#define REG_INTKNEPMIS6_WIDTH    1

/* INTKNTXFEMP6 */
#define REG_INTKNTXFEMP6          0x009c8
#define REG_INTKNTXFEMP6_MASK     0x00000010
#define REG_INTKNTXFEMP6_SHIFT    4
#define REG_INTKNTXFEMP6_WIDTH    1

/* TIMEOUT6 */
#define REG_TIMEOUT6          0x009c8
#define REG_TIMEOUT6_MASK     0x00000008
#define REG_TIMEOUT6_SHIFT    3
#define REG_TIMEOUT6_WIDTH    1

/* AHBERR6 */
#define REG_AHBERR6          0x009c8
#define REG_AHBERR6_MASK     0x00000004
#define REG_AHBERR6_SHIFT    2
#define REG_AHBERR6_WIDTH    1

/* EPDISBLD6 */
#define REG_EPDISBLD6          0x009c8
#define REG_EPDISBLD6_MASK     0x00000002
#define REG_EPDISBLD6_SHIFT    1
#define REG_EPDISBLD6_WIDTH    1

/* XFERCOMPL6 */
#define REG_XFERCOMPL6          0x009c8
#define REG_XFERCOMPL6_MASK     0x00000001
#define REG_XFERCOMPL6_SHIFT    0
#define REG_XFERCOMPL6_WIDTH    1

/* MC6 */
#define REG_MC6          0x009d0
#define REG_MC6_MASK     0x60000000
#define REG_MC6_SHIFT    29
#define REG_MC6_WIDTH    2

/* PKTCNT6 */
#define REG_PKTCNT6          0x009d0
#define REG_PKTCNT6_MASK     0x1ff80000
#define REG_PKTCNT6_SHIFT    19
#define REG_PKTCNT6_WIDTH    10

/* XFERSIZE6 */
#define REG_XFERSIZE6          0x009d0
#define REG_XFERSIZE6_MASK     0x0007ffff
#define REG_XFERSIZE6_SHIFT    0
#define REG_XFERSIZE6_WIDTH    19

/* DIEPDMA66 */
#define REG_DIEPDMA66          0x009d4
#define REG_DIEPDMA66_MASK     0xffffffff
#define REG_DIEPDMA66_SHIFT    0
#define REG_DIEPDMA66_WIDTH    32

/* INEPTXFSPCAVAIL6 */
#define REG_INEPTXFSPCAVAIL6          0x009d8
#define REG_INEPTXFSPCAVAIL6_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL6_SHIFT    0
#define REG_INEPTXFSPCAVAIL6_WIDTH    16

/* DIEPDMAB6 */
#define REG_DIEPDMAB6          0x009dc
#define REG_DIEPDMAB6_MASK     0xffffffff
#define REG_DIEPDMAB6_SHIFT    0
#define REG_DIEPDMAB6_WIDTH    32

/* EPENA7 */
#define REG_EPENA7          0x009e0
#define REG_EPENA7_MASK     0x80000000
#define REG_EPENA7_SHIFT    31
#define REG_EPENA7_WIDTH    1

/* EPDIS7 */
#define REG_EPDIS7          0x009e0
#define REG_EPDIS7_MASK     0x40000000
#define REG_EPDIS7_SHIFT    30
#define REG_EPDIS7_WIDTH    1

/* TXFNUM7 */
#define REG_TXFNUM7          0x009e0
#define REG_TXFNUM7_MASK     0x03c00000
#define REG_TXFNUM7_SHIFT    22
#define REG_TXFNUM7_WIDTH    4

/* STALL7 */
#define REG_STALL7          0x009e0
#define REG_STALL7_MASK     0x00200000
#define REG_STALL7_SHIFT    21
#define REG_STALL7_WIDTH    1

/* EPTYPE7 */
#define REG_EPTYPE7          0x009e0
#define REG_EPTYPE7_MASK     0x000c0000
#define REG_EPTYPE7_SHIFT    18
#define REG_EPTYPE7_WIDTH    2

/* NAKSTS7 */
#define REG_NAKSTS7          0x009e0
#define REG_NAKSTS7_MASK     0x00020000
#define REG_NAKSTS7_SHIFT    17
#define REG_NAKSTS7_WIDTH    1

/* DPID7 */
#define REG_DPID7          0x009e0
#define REG_DPID7_MASK     0x00010000
#define REG_DPID7_SHIFT    16
#define REG_DPID7_WIDTH    1

/* USBACTEP7 */
#define REG_USBACTEP7          0x009e0
#define REG_USBACTEP7_MASK     0x00008000
#define REG_USBACTEP7_SHIFT    15
#define REG_USBACTEP7_WIDTH    1

/* MPS7 */
#define REG_MPS7          0x009e0
#define REG_MPS7_MASK     0x000007ff
#define REG_MPS7_SHIFT    0
#define REG_MPS7_WIDTH    11

/* SETD1PID7 */
#define REG_SETD1PID7          0x009e0
#define REG_SETD1PID7_MASK     0x20000000
#define REG_SETD1PID7_SHIFT    29
#define REG_SETD1PID7_WIDTH    1

/* SETD0PID7 */
#define REG_SETD0PID7          0x009e0
#define REG_SETD0PID7_MASK     0x10000000
#define REG_SETD0PID7_SHIFT    28
#define REG_SETD0PID7_WIDTH    1

/* SNAK7 */
#define REG_SNAK7          0x009e0
#define REG_SNAK7_MASK     0x08000000
#define REG_SNAK7_SHIFT    27
#define REG_SNAK7_WIDTH    1

/* CNAK7 */
#define REG_CNAK7          0x009e0
#define REG_CNAK7_MASK     0x04000000
#define REG_CNAK7_SHIFT    26
#define REG_CNAK7_WIDTH    1

/* NYETINTRPT7 */
#define REG_NYETINTRPT7          0x009e8
#define REG_NYETINTRPT7_MASK     0x00004000
#define REG_NYETINTRPT7_SHIFT    14
#define REG_NYETINTRPT7_WIDTH    1

/* NAKINTRPT7 */
#define REG_NAKINTRPT7          0x009e8
#define REG_NAKINTRPT7_MASK     0x00002000
#define REG_NAKINTRPT7_SHIFT    13
#define REG_NAKINTRPT7_WIDTH    1

/* BBLEERR7 */
#define REG_BBLEERR7          0x009e8
#define REG_BBLEERR7_MASK     0x00001000
#define REG_BBLEERR7_SHIFT    12
#define REG_BBLEERR7_WIDTH    1

/* PKTDRPSTS7 */
#define REG_PKTDRPSTS7          0x009e8
#define REG_PKTDRPSTS7_MASK     0x00000800
#define REG_PKTDRPSTS7_SHIFT    11
#define REG_PKTDRPSTS7_WIDTH    1

/* BNAINTR7 */
#define REG_BNAINTR7          0x009e8
#define REG_BNAINTR7_MASK     0x00000200
#define REG_BNAINTR7_SHIFT    9
#define REG_BNAINTR7_WIDTH    1

/* TXFIFOUNDRN7 */
#define REG_TXFIFOUNDRN7          0x009e8
#define REG_TXFIFOUNDRN7_MASK     0x00000100
#define REG_TXFIFOUNDRN7_SHIFT    8
#define REG_TXFIFOUNDRN7_WIDTH    1

/* TXFEMP7 */
#define REG_TXFEMP7          0x009e8
#define REG_TXFEMP7_MASK     0x00000080
#define REG_TXFEMP7_SHIFT    7
#define REG_TXFEMP7_WIDTH    1

/* INEPNAKEFF7 */
#define REG_INEPNAKEFF7          0x009e8
#define REG_INEPNAKEFF7_MASK     0x00000040
#define REG_INEPNAKEFF7_SHIFT    6
#define REG_INEPNAKEFF7_WIDTH    1

/* INTKNEPMIS7 */
#define REG_INTKNEPMIS7          0x009e8
#define REG_INTKNEPMIS7_MASK     0x00000020
#define REG_INTKNEPMIS7_SHIFT    5
#define REG_INTKNEPMIS7_WIDTH    1

/* INTKNTXFEMP7 */
#define REG_INTKNTXFEMP7          0x009e8
#define REG_INTKNTXFEMP7_MASK     0x00000010
#define REG_INTKNTXFEMP7_SHIFT    4
#define REG_INTKNTXFEMP7_WIDTH    1

/* TIMEOUT7 */
#define REG_TIMEOUT7          0x009e8
#define REG_TIMEOUT7_MASK     0x00000008
#define REG_TIMEOUT7_SHIFT    3
#define REG_TIMEOUT7_WIDTH    1

/* AHBERR7 */
#define REG_AHBERR7          0x009e8
#define REG_AHBERR7_MASK     0x00000004
#define REG_AHBERR7_SHIFT    2
#define REG_AHBERR7_WIDTH    1

/* EPDISBLD7 */
#define REG_EPDISBLD7          0x009e8
#define REG_EPDISBLD7_MASK     0x00000002
#define REG_EPDISBLD7_SHIFT    1
#define REG_EPDISBLD7_WIDTH    1

/* XFERCOMPL7 */
#define REG_XFERCOMPL7          0x009e8
#define REG_XFERCOMPL7_MASK     0x00000001
#define REG_XFERCOMPL7_SHIFT    0
#define REG_XFERCOMPL7_WIDTH    1

/* MC7 */
#define REG_MC7          0x009f0
#define REG_MC7_MASK     0x60000000
#define REG_MC7_SHIFT    29
#define REG_MC7_WIDTH    2

/* PKTCNT7 */
#define REG_PKTCNT7          0x009f0
#define REG_PKTCNT7_MASK     0x1ff80000
#define REG_PKTCNT7_SHIFT    19
#define REG_PKTCNT7_WIDTH    10

/* XFERSIZE7 */
#define REG_XFERSIZE7          0x009f0
#define REG_XFERSIZE7_MASK     0x0007ffff
#define REG_XFERSIZE7_SHIFT    0
#define REG_XFERSIZE7_WIDTH    19

/* DIEPDMA7 */
#define REG_DIEPDMA7          0x009f4
#define REG_DIEPDMA7_MASK     0xffffffff
#define REG_DIEPDMA7_SHIFT    0
#define REG_DIEPDMA7_WIDTH    32

/* INEPTXFSPCAVAIL7 */
#define REG_INEPTXFSPCAVAIL7          0x009f8
#define REG_INEPTXFSPCAVAIL7_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL7_SHIFT    0
#define REG_INEPTXFSPCAVAIL7_WIDTH    16

/* DIEPDMAB7 */
#define REG_DIEPDMAB7          0x009fc
#define REG_DIEPDMAB7_MASK     0xffffffff
#define REG_DIEPDMAB7_SHIFT    0
#define REG_DIEPDMAB7_WIDTH    32

/* EPENA8 */
#define REG_EPENA8          0x00a00
#define REG_EPENA8_MASK     0x80000000
#define REG_EPENA8_SHIFT    31
#define REG_EPENA8_WIDTH    1

/* EPDIS8 */
#define REG_EPDIS8          0x00a00
#define REG_EPDIS8_MASK     0x40000000
#define REG_EPDIS8_SHIFT    30
#define REG_EPDIS8_WIDTH    1

/* TXFNUM8 */
#define REG_TXFNUM8          0x00a00
#define REG_TXFNUM8_MASK     0x03c00000
#define REG_TXFNUM8_SHIFT    22
#define REG_TXFNUM8_WIDTH    4

/* STALL8 */
#define REG_STALL8          0x00a00
#define REG_STALL8_MASK     0x00200000
#define REG_STALL8_SHIFT    21
#define REG_STALL8_WIDTH    1

/* EPTYPE8 */
#define REG_EPTYPE8          0x00a00
#define REG_EPTYPE8_MASK     0x000c0000
#define REG_EPTYPE8_SHIFT    18
#define REG_EPTYPE8_WIDTH    2

/* NAKSTS8 */
#define REG_NAKSTS8          0x00a00
#define REG_NAKSTS8_MASK     0x00020000
#define REG_NAKSTS8_SHIFT    17
#define REG_NAKSTS8_WIDTH    1

/* DPID8 */
#define REG_DPID8          0x00a00
#define REG_DPID8_MASK     0x00010000
#define REG_DPID8_SHIFT    16
#define REG_DPID8_WIDTH    1

/* USBACTEP8 */
#define REG_USBACTEP8          0x00a00
#define REG_USBACTEP8_MASK     0x00008000
#define REG_USBACTEP8_SHIFT    15
#define REG_USBACTEP8_WIDTH    1

/* MPS8 */
#define REG_MPS8          0x00a00
#define REG_MPS8_MASK     0x000007ff
#define REG_MPS8_SHIFT    0
#define REG_MPS8_WIDTH    11

/* SETD1PID8 */
#define REG_SETD1PID8          0x00a00
#define REG_SETD1PID8_MASK     0x20000000
#define REG_SETD1PID8_SHIFT    29
#define REG_SETD1PID8_WIDTH    1

/* SETD0PID8 */
#define REG_SETD0PID8          0x00a00
#define REG_SETD0PID8_MASK     0x10000000
#define REG_SETD0PID8_SHIFT    28
#define REG_SETD0PID8_WIDTH    1

/* SNAK8 */
#define REG_SNAK8          0x00a00
#define REG_SNAK8_MASK     0x08000000
#define REG_SNAK8_SHIFT    27
#define REG_SNAK8_WIDTH    1

/* CNAK8 */
#define REG_CNAK8          0x00a00
#define REG_CNAK8_MASK     0x04000000
#define REG_CNAK8_SHIFT    26
#define REG_CNAK8_WIDTH    1

/* NYETINTRPT8 */
#define REG_NYETINTRPT8          0x00a08
#define REG_NYETINTRPT8_MASK     0x00004000
#define REG_NYETINTRPT8_SHIFT    14
#define REG_NYETINTRPT8_WIDTH    1

/* NAKINTRPT8 */
#define REG_NAKINTRPT8          0x00a08
#define REG_NAKINTRPT8_MASK     0x00002000
#define REG_NAKINTRPT8_SHIFT    13
#define REG_NAKINTRPT8_WIDTH    1

/* BBLEERR8 */
#define REG_BBLEERR8          0x00a08
#define REG_BBLEERR8_MASK     0x00001000
#define REG_BBLEERR8_SHIFT    12
#define REG_BBLEERR8_WIDTH    1

/* PKTDRPSTS8 */
#define REG_PKTDRPSTS8          0x00a08
#define REG_PKTDRPSTS8_MASK     0x00000800
#define REG_PKTDRPSTS8_SHIFT    11
#define REG_PKTDRPSTS8_WIDTH    1

/* BNAINTR8 */
#define REG_BNAINTR8          0x00a08
#define REG_BNAINTR8_MASK     0x00000200
#define REG_BNAINTR8_SHIFT    9
#define REG_BNAINTR8_WIDTH    1

/* TXFIFOUNDRN8 */
#define REG_TXFIFOUNDRN8          0x00a08
#define REG_TXFIFOUNDRN8_MASK     0x00000100
#define REG_TXFIFOUNDRN8_SHIFT    8
#define REG_TXFIFOUNDRN8_WIDTH    1

/* TXFEMP8 */
#define REG_TXFEMP8          0x00a08
#define REG_TXFEMP8_MASK     0x00000080
#define REG_TXFEMP8_SHIFT    7
#define REG_TXFEMP8_WIDTH    1

/* INEPNAKEFF8 */
#define REG_INEPNAKEFF8          0x00a08
#define REG_INEPNAKEFF8_MASK     0x00000040
#define REG_INEPNAKEFF8_SHIFT    6
#define REG_INEPNAKEFF8_WIDTH    1

/* INTKNEPMIS8 */
#define REG_INTKNEPMIS8          0x00a08
#define REG_INTKNEPMIS8_MASK     0x00000020
#define REG_INTKNEPMIS8_SHIFT    5
#define REG_INTKNEPMIS8_WIDTH    1

/* INTKNTXFEMP8 */
#define REG_INTKNTXFEMP8          0x00a08
#define REG_INTKNTXFEMP8_MASK     0x00000010
#define REG_INTKNTXFEMP8_SHIFT    4
#define REG_INTKNTXFEMP8_WIDTH    1

/* TIMEOUT8 */
#define REG_TIMEOUT8          0x00a08
#define REG_TIMEOUT8_MASK     0x00000008
#define REG_TIMEOUT8_SHIFT    3
#define REG_TIMEOUT8_WIDTH    1

/* AHBERR8 */
#define REG_AHBERR8          0x00a08
#define REG_AHBERR8_MASK     0x00000004
#define REG_AHBERR8_SHIFT    2
#define REG_AHBERR8_WIDTH    1

/* EPDISBLD8 */
#define REG_EPDISBLD8          0x00a08
#define REG_EPDISBLD8_MASK     0x00000002
#define REG_EPDISBLD8_SHIFT    1
#define REG_EPDISBLD8_WIDTH    1

/* XFERCOMPL8 */
#define REG_XFERCOMPL8          0x00a08
#define REG_XFERCOMPL8_MASK     0x00000001
#define REG_XFERCOMPL8_SHIFT    0
#define REG_XFERCOMPL8_WIDTH    1

/* MC8 */
#define REG_MC8          0x00a10
#define REG_MC8_MASK     0x60000000
#define REG_MC8_SHIFT    29
#define REG_MC8_WIDTH    2

/* PKTCNT8 */
#define REG_PKTCNT8          0x00a10
#define REG_PKTCNT8_MASK     0x1ff80000
#define REG_PKTCNT8_SHIFT    19
#define REG_PKTCNT8_WIDTH    10

/* XFERSIZE8 */
#define REG_XFERSIZE8          0x00a10
#define REG_XFERSIZE8_MASK     0x0007ffff
#define REG_XFERSIZE8_SHIFT    0
#define REG_XFERSIZE8_WIDTH    19

/* DIEPDMA8 */
#define REG_DIEPDMA8          0x00a14
#define REG_DIEPDMA8_MASK     0xffffffff
#define REG_DIEPDMA8_SHIFT    0
#define REG_DIEPDMA8_WIDTH    32

/* INEPTXFSPCAVAIL8 */
#define REG_INEPTXFSPCAVAIL8          0x00a18
#define REG_INEPTXFSPCAVAIL8_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL8_SHIFT    0
#define REG_INEPTXFSPCAVAIL8_WIDTH    16

/* DIEPDMAB8 */
#define REG_DIEPDMAB8          0x00a1c
#define REG_DIEPDMAB8_MASK     0xffffffff
#define REG_DIEPDMAB8_SHIFT    0
#define REG_DIEPDMAB8_WIDTH    32

/* EPENA9 */
#define REG_EPENA9          0x00a20
#define REG_EPENA9_MASK     0x80000000
#define REG_EPENA9_SHIFT    31
#define REG_EPENA9_WIDTH    1

/* EPDIS9 */
#define REG_EPDIS9          0x00a20
#define REG_EPDIS9_MASK     0x40000000
#define REG_EPDIS9_SHIFT    30
#define REG_EPDIS9_WIDTH    1

/* TXFNUM9 */
#define REG_TXFNUM9          0x00a20
#define REG_TXFNUM9_MASK     0x03c00000
#define REG_TXFNUM9_SHIFT    22
#define REG_TXFNUM9_WIDTH    4

/* STALL9 */
#define REG_STALL9          0x00a20
#define REG_STALL9_MASK     0x00200000
#define REG_STALL9_SHIFT    21
#define REG_STALL9_WIDTH    1

/* EPTYPE9 */
#define REG_EPTYPE9          0x00a20
#define REG_EPTYPE9_MASK     0x000c0000
#define REG_EPTYPE9_SHIFT    18
#define REG_EPTYPE9_WIDTH    2

/* NAKSTS9 */
#define REG_NAKSTS9          0x00a20
#define REG_NAKSTS9_MASK     0x00020000
#define REG_NAKSTS9_SHIFT    17
#define REG_NAKSTS9_WIDTH    1

/* DPID9 */
#define REG_DPID9          0x00a20
#define REG_DPID9_MASK     0x00010000
#define REG_DPID9_SHIFT    16
#define REG_DPID9_WIDTH    1

/* USBACTEP9 */
#define REG_USBACTEP9          0x00a20
#define REG_USBACTEP9_MASK     0x00008000
#define REG_USBACTEP9_SHIFT    15
#define REG_USBACTEP9_WIDTH    1

/* MPS9 */
#define REG_MPS9          0x00a20
#define REG_MPS9_MASK     0x000007ff
#define REG_MPS9_SHIFT    0
#define REG_MPS9_WIDTH    11

/* SETD1PID9 */
#define REG_SETD1PID9          0x00a20
#define REG_SETD1PID9_MASK     0x20000000
#define REG_SETD1PID9_SHIFT    29
#define REG_SETD1PID9_WIDTH    1

/* SETD0PID9 */
#define REG_SETD0PID9          0x00a20
#define REG_SETD0PID9_MASK     0x10000000
#define REG_SETD0PID9_SHIFT    28
#define REG_SETD0PID9_WIDTH    1

/* SNAK9 */
#define REG_SNAK9          0x00a20
#define REG_SNAK9_MASK     0x08000000
#define REG_SNAK9_SHIFT    27
#define REG_SNAK9_WIDTH    1

/* CNAK9 */
#define REG_CNAK9          0x00a20
#define REG_CNAK9_MASK     0x04000000
#define REG_CNAK9_SHIFT    26
#define REG_CNAK9_WIDTH    1

/* NYETINTRPT9 */
#define REG_NYETINTRPT9          0x00a28
#define REG_NYETINTRPT9_MASK     0x00004000
#define REG_NYETINTRPT9_SHIFT    14
#define REG_NYETINTRPT9_WIDTH    1

/* NAKINTRPT9 */
#define REG_NAKINTRPT9          0x00a28
#define REG_NAKINTRPT9_MASK     0x00002000
#define REG_NAKINTRPT9_SHIFT    13
#define REG_NAKINTRPT9_WIDTH    1

/* BBLEERR9 */
#define REG_BBLEERR9          0x00a28
#define REG_BBLEERR9_MASK     0x00001000
#define REG_BBLEERR9_SHIFT    12
#define REG_BBLEERR9_WIDTH    1

/* PKTDRPSTS9 */
#define REG_PKTDRPSTS9          0x00a28
#define REG_PKTDRPSTS9_MASK     0x00000800
#define REG_PKTDRPSTS9_SHIFT    11
#define REG_PKTDRPSTS9_WIDTH    1

/* BNAINTR9 */
#define REG_BNAINTR9          0x00a28
#define REG_BNAINTR9_MASK     0x00000200
#define REG_BNAINTR9_SHIFT    9
#define REG_BNAINTR9_WIDTH    1

/* TXFIFOUNDRN9 */
#define REG_TXFIFOUNDRN9          0x00a28
#define REG_TXFIFOUNDRN9_MASK     0x00000100
#define REG_TXFIFOUNDRN9_SHIFT    8
#define REG_TXFIFOUNDRN9_WIDTH    1

/* TXFEMP9 */
#define REG_TXFEMP9          0x00a28
#define REG_TXFEMP9_MASK     0x00000080
#define REG_TXFEMP9_SHIFT    7
#define REG_TXFEMP9_WIDTH    1

/* INEPNAKEFF9 */
#define REG_INEPNAKEFF9          0x00a28
#define REG_INEPNAKEFF9_MASK     0x00000040
#define REG_INEPNAKEFF9_SHIFT    6
#define REG_INEPNAKEFF9_WIDTH    1

/* INTKNEPMIS9 */
#define REG_INTKNEPMIS9          0x00a28
#define REG_INTKNEPMIS9_MASK     0x00000020
#define REG_INTKNEPMIS9_SHIFT    5
#define REG_INTKNEPMIS9_WIDTH    1

/* INTKNTXFEMP9 */
#define REG_INTKNTXFEMP9          0x00a28
#define REG_INTKNTXFEMP9_MASK     0x00000010
#define REG_INTKNTXFEMP9_SHIFT    4
#define REG_INTKNTXFEMP9_WIDTH    1

/* TIMEOUT9 */
#define REG_TIMEOUT9          0x00a28
#define REG_TIMEOUT9_MASK     0x00000008
#define REG_TIMEOUT9_SHIFT    3
#define REG_TIMEOUT9_WIDTH    1

/* AHBERR9 */
#define REG_AHBERR9          0x00a28
#define REG_AHBERR9_MASK     0x00000004
#define REG_AHBERR9_SHIFT    2
#define REG_AHBERR9_WIDTH    1

/* EPDISBLD9 */
#define REG_EPDISBLD9          0x00a28
#define REG_EPDISBLD9_MASK     0x00000002
#define REG_EPDISBLD9_SHIFT    1
#define REG_EPDISBLD9_WIDTH    1

/* XFERCOMPL9 */
#define REG_XFERCOMPL9          0x00a28
#define REG_XFERCOMPL9_MASK     0x00000001
#define REG_XFERCOMPL9_SHIFT    0
#define REG_XFERCOMPL9_WIDTH    1

/* MC9 */
#define REG_MC9          0x00a30
#define REG_MC9_MASK     0x60000000
#define REG_MC9_SHIFT    29
#define REG_MC9_WIDTH    2

/* PKTCNT9 */
#define REG_PKTCNT9          0x00a30
#define REG_PKTCNT9_MASK     0x1ff80000
#define REG_PKTCNT9_SHIFT    19
#define REG_PKTCNT9_WIDTH    10

/* XFERSIZE9 */
#define REG_XFERSIZE9          0x00a30
#define REG_XFERSIZE9_MASK     0x0007ffff
#define REG_XFERSIZE9_SHIFT    0
#define REG_XFERSIZE9_WIDTH    19

/* DIEPDMA9 */
#define REG_DIEPDMA9          0x00a34
#define REG_DIEPDMA9_MASK     0xffffffff
#define REG_DIEPDMA9_SHIFT    0
#define REG_DIEPDMA9_WIDTH    32

/* INEPTXFSPCAVAIL9 */
#define REG_INEPTXFSPCAVAIL9          0x00a38
#define REG_INEPTXFSPCAVAIL9_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL9_SHIFT    0
#define REG_INEPTXFSPCAVAIL9_WIDTH    16

/* DIEPDMAB9 */
#define REG_DIEPDMAB9          0x00a3c
#define REG_DIEPDMAB9_MASK     0xffffffff
#define REG_DIEPDMAB9_SHIFT    0
#define REG_DIEPDMAB9_WIDTH    32

/* EPENA10 */
#define REG_EPENA10          0x00a40
#define REG_EPENA10_MASK     0x80000000
#define REG_EPENA10_SHIFT    31
#define REG_EPENA10_WIDTH    1

/* EPDIS10 */
#define REG_EPDIS10          0x00a40
#define REG_EPDIS10_MASK     0x40000000
#define REG_EPDIS10_SHIFT    30
#define REG_EPDIS10_WIDTH    1

/* TXFNUM10 */
#define REG_TXFNUM10          0x00a40
#define REG_TXFNUM10_MASK     0x03c00000
#define REG_TXFNUM10_SHIFT    22
#define REG_TXFNUM10_WIDTH    4

/* STALL10 */
#define REG_STALL10          0x00a40
#define REG_STALL10_MASK     0x00200000
#define REG_STALL10_SHIFT    21
#define REG_STALL10_WIDTH    1

/* EPTYPE10 */
#define REG_EPTYPE10          0x00a40
#define REG_EPTYPE10_MASK     0x000c0000
#define REG_EPTYPE10_SHIFT    18
#define REG_EPTYPE10_WIDTH    2

/* NAKSTS10 */
#define REG_NAKSTS10          0x00a40
#define REG_NAKSTS10_MASK     0x00020000
#define REG_NAKSTS10_SHIFT    17
#define REG_NAKSTS10_WIDTH    1

/* DPID10 */
#define REG_DPID10          0x00a40
#define REG_DPID10_MASK     0x00010000
#define REG_DPID10_SHIFT    16
#define REG_DPID10_WIDTH    1

/* USBACTEP10 */
#define REG_USBACTEP10          0x00a40
#define REG_USBACTEP10_MASK     0x00008000
#define REG_USBACTEP10_SHIFT    15
#define REG_USBACTEP10_WIDTH    1

/* MPS10 */
#define REG_MPS10          0x00a40
#define REG_MPS10_MASK     0x000007ff
#define REG_MPS10_SHIFT    0
#define REG_MPS10_WIDTH    11

/* SETD1PID10 */
#define REG_SETD1PID10          0x00a40
#define REG_SETD1PID10_MASK     0x20000000
#define REG_SETD1PID10_SHIFT    29
#define REG_SETD1PID10_WIDTH    1

/* SETD0PID10 */
#define REG_SETD0PID10          0x00a40
#define REG_SETD0PID10_MASK     0x10000000
#define REG_SETD0PID10_SHIFT    28
#define REG_SETD0PID10_WIDTH    1

/* SNAK10 */
#define REG_SNAK10          0x00a40
#define REG_SNAK10_MASK     0x08000000
#define REG_SNAK10_SHIFT    27
#define REG_SNAK10_WIDTH    1

/* CNAK10 */
#define REG_CNAK10          0x00a40
#define REG_CNAK10_MASK     0x04000000
#define REG_CNAK10_SHIFT    26
#define REG_CNAK10_WIDTH    1

/* NYETINTRPT10 */
#define REG_NYETINTRPT10          0x00a48
#define REG_NYETINTRPT10_MASK     0x00004000
#define REG_NYETINTRPT10_SHIFT    14
#define REG_NYETINTRPT10_WIDTH    1

/* NAKINTRPT10 */
#define REG_NAKINTRPT10          0x00a48
#define REG_NAKINTRPT10_MASK     0x00002000
#define REG_NAKINTRPT10_SHIFT    13
#define REG_NAKINTRPT10_WIDTH    1

/* BBLEERR10 */
#define REG_BBLEERR10          0x00a48
#define REG_BBLEERR10_MASK     0x00001000
#define REG_BBLEERR10_SHIFT    12
#define REG_BBLEERR10_WIDTH    1

/* PKTDRPSTS10 */
#define REG_PKTDRPSTS10          0x00a48
#define REG_PKTDRPSTS10_MASK     0x00000800
#define REG_PKTDRPSTS10_SHIFT    11
#define REG_PKTDRPSTS10_WIDTH    1

/* BNAINTR10 */
#define REG_BNAINTR10          0x00a48
#define REG_BNAINTR10_MASK     0x00000200
#define REG_BNAINTR10_SHIFT    9
#define REG_BNAINTR10_WIDTH    1

/* TXFIFOUNDRN10 */
#define REG_TXFIFOUNDRN10          0x00a48
#define REG_TXFIFOUNDRN10_MASK     0x00000100
#define REG_TXFIFOUNDRN10_SHIFT    8
#define REG_TXFIFOUNDRN10_WIDTH    1

/* TXFEMP10 */
#define REG_TXFEMP10          0x00a48
#define REG_TXFEMP10_MASK     0x00000080
#define REG_TXFEMP10_SHIFT    7
#define REG_TXFEMP10_WIDTH    1

/* INEPNAKEFF10 */
#define REG_INEPNAKEFF10          0x00a48
#define REG_INEPNAKEFF10_MASK     0x00000040
#define REG_INEPNAKEFF10_SHIFT    6
#define REG_INEPNAKEFF10_WIDTH    1

/* INTKNEPMIS10 */
#define REG_INTKNEPMIS10          0x00a48
#define REG_INTKNEPMIS10_MASK     0x00000020
#define REG_INTKNEPMIS10_SHIFT    5
#define REG_INTKNEPMIS10_WIDTH    1

/* INTKNTXFEMP10 */
#define REG_INTKNTXFEMP10          0x00a48
#define REG_INTKNTXFEMP10_MASK     0x00000010
#define REG_INTKNTXFEMP10_SHIFT    4
#define REG_INTKNTXFEMP10_WIDTH    1

/* TIMEOUT10 */
#define REG_TIMEOUT10          0x00a48
#define REG_TIMEOUT10_MASK     0x00000008
#define REG_TIMEOUT10_SHIFT    3
#define REG_TIMEOUT10_WIDTH    1

/* AHBERR10 */
#define REG_AHBERR10          0x00a48
#define REG_AHBERR10_MASK     0x00000004
#define REG_AHBERR10_SHIFT    2
#define REG_AHBERR10_WIDTH    1

/* EPDISBLD10 */
#define REG_EPDISBLD10          0x00a48
#define REG_EPDISBLD10_MASK     0x00000002
#define REG_EPDISBLD10_SHIFT    1
#define REG_EPDISBLD10_WIDTH    1

/* XFERCOMPL10 */
#define REG_XFERCOMPL10          0x00a48
#define REG_XFERCOMPL10_MASK     0x00000001
#define REG_XFERCOMPL10_SHIFT    0
#define REG_XFERCOMPL10_WIDTH    1

/* MC10 */
#define REG_MC10          0x00a50
#define REG_MC10_MASK     0x60000000
#define REG_MC10_SHIFT    29
#define REG_MC10_WIDTH    2

/* PKTCNT10 */
#define REG_PKTCNT10          0x00a50
#define REG_PKTCNT10_MASK     0x1ff80000
#define REG_PKTCNT10_SHIFT    19
#define REG_PKTCNT10_WIDTH    10

/* XFERSIZE10 */
#define REG_XFERSIZE10          0x00a50
#define REG_XFERSIZE10_MASK     0x0007ffff
#define REG_XFERSIZE10_SHIFT    0
#define REG_XFERSIZE10_WIDTH    19

/* DIEPDMA10 */
#define REG_DIEPDMA10          0x00a54
#define REG_DIEPDMA10_MASK     0xffffffff
#define REG_DIEPDMA10_SHIFT    0
#define REG_DIEPDMA10_WIDTH    32

/* INEPTXFSPCAVAIL10 */
#define REG_INEPTXFSPCAVAIL10          0x00a58
#define REG_INEPTXFSPCAVAIL10_MASK     0x0000ffff
#define REG_INEPTXFSPCAVAIL10_SHIFT    0
#define REG_INEPTXFSPCAVAIL10_WIDTH    16

/* DIEPDMAB10 */
#define REG_DIEPDMAB10          0x00a5c
#define REG_DIEPDMAB10_MASK     0xffffffff
#define REG_DIEPDMAB10_SHIFT    0
#define REG_DIEPDMAB10_WIDTH    32

/* EPENA0OUT */
#define REG_EPENA0OUT          0x00b00
#define REG_EPENA0OUT_MASK     0x80000000
#define REG_EPENA0OUT_SHIFT    31
#define REG_EPENA0OUT_WIDTH    1

/* EPDIS0OUT */
#define REG_EPDIS0OUT          0x00b00
#define REG_EPDIS0OUT_MASK     0x40000000
#define REG_EPDIS0OUT_SHIFT    30
#define REG_EPDIS0OUT_WIDTH    1

/* STALL0OUT */
#define REG_STALL0OUT          0x00b00
#define REG_STALL0OUT_MASK     0x00200000
#define REG_STALL0OUT_SHIFT    21
#define REG_STALL0OUT_WIDTH    1

/* SNP0OUT */
#define REG_SNP0OUT          0x00b00
#define REG_SNP0OUT_MASK     0x00100000
#define REG_SNP0OUT_SHIFT    20
#define REG_SNP0OUT_WIDTH    1

/* EPTYPE0OUT */
#define REG_EPTYPE0OUT          0x00b00
#define REG_EPTYPE0OUT_MASK     0x000c0000
#define REG_EPTYPE0OUT_SHIFT    18
#define REG_EPTYPE0OUT_WIDTH    2

/* NAKSTS0OUT */
#define REG_NAKSTS0OUT          0x00b00
#define REG_NAKSTS0OUT_MASK     0x00020000
#define REG_NAKSTS0OUT_SHIFT    17
#define REG_NAKSTS0OUT_WIDTH    1

/* USBACTEPCTL0OUT */
#define REG_USBACTEPCTL0OUT          0x00b00
#define REG_USBACTEPCTL0OUT_MASK     0x00008000
#define REG_USBACTEPCTL0OUT_SHIFT    15
#define REG_USBACTEPCTL0OUT_WIDTH    1

/* MPS0OUT */
#define REG_MPS0OUT          0x00b00
#define REG_MPS0OUT_MASK     0x00000003
#define REG_MPS0OUT_SHIFT    0
#define REG_MPS0OUT_WIDTH    2

/* SNAK0OUT */
#define REG_SNAK0OUT          0x00b00
#define REG_SNAK0OUT_MASK     0x08000000
#define REG_SNAK0OUT_SHIFT    27
#define REG_SNAK0OUT_WIDTH    1

/* CNAK0OUT */
#define REG_CNAK0OUT          0x00b00
#define REG_CNAK0OUT_MASK     0x04000000
#define REG_CNAK0OUT_SHIFT    26
#define REG_CNAK0OUT_WIDTH    1

/* NYETINTRPT0OUT */
#define REG_NYETINTRPT0OUT          0x00b08
#define REG_NYETINTRPT0OUT_MASK     0x00004000
#define REG_NYETINTRPT0OUT_SHIFT    14
#define REG_NYETINTRPT0OUT_WIDTH    1

/* NAKINTRPT0OUT */
#define REG_NAKINTRPT0OUT          0x00b08
#define REG_NAKINTRPT0OUT_MASK     0x00002000
#define REG_NAKINTRPT0OUT_SHIFT    13
#define REG_NAKINTRPT0OUT_WIDTH    1

/* BBLEERR0OUT */
#define REG_BBLEERR0OUT          0x00b08
#define REG_BBLEERR0OUT_MASK     0x00001000
#define REG_BBLEERR0OUT_SHIFT    12
#define REG_BBLEERR0OUT_WIDTH    1

/* PKTDRPSTS0OUT */
#define REG_PKTDRPSTS0OUT          0x00b08
#define REG_PKTDRPSTS0OUT_MASK     0x00000800
#define REG_PKTDRPSTS0OUT_SHIFT    11
#define REG_PKTDRPSTS0OUT_WIDTH    1

/* BNAINTR0OUT */
#define REG_BNAINTR0OUT          0x00b08
#define REG_BNAINTR0OUT_MASK     0x00000200
#define REG_BNAINTR0OUT_SHIFT    9
#define REG_BNAINTR0OUT_WIDTH    1

/* OUTPKTERR0OUT */
#define REG_OUTPKTERR0OUT          0x00b08
#define REG_OUTPKTERR0OUT_MASK     0x00000100
#define REG_OUTPKTERR0OUT_SHIFT    8
#define REG_OUTPKTERR0OUT_WIDTH    1

/* BACK2BACKSETUP0OUT */
#define REG_BACK2BACKSETUP0OUT          0x00b08
#define REG_BACK2BACKSETUP0OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP0OUT_SHIFT    6
#define REG_BACK2BACKSETUP0OUT_WIDTH    1

/* STSPHSERCVD0OUT */
#define REG_STSPHSERCVD0OUT          0x00b08
#define REG_STSPHSERCVD0OUT_MASK     0x00000020
#define REG_STSPHSERCVD0OUT_SHIFT    5
#define REG_STSPHSERCVD0OUT_WIDTH    1

/* OUTTKNEPDIS0OUT */
#define REG_OUTTKNEPDIS0OUT          0x00b08
#define REG_OUTTKNEPDIS0OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS0OUT_SHIFT    4
#define REG_OUTTKNEPDIS0OUT_WIDTH    1

/* SETUP0OUT */
#define REG_SETUP0OUT          0x00b08
#define REG_SETUP0OUT_MASK     0x00000008
#define REG_SETUP0OUT_SHIFT    3
#define REG_SETUP0OUT_WIDTH    1

/* AHBERR0OUT */
#define REG_AHBERR0OUT          0x00b08
#define REG_AHBERR0OUT_MASK     0x00000004
#define REG_AHBERR0OUT_SHIFT    2
#define REG_AHBERR0OUT_WIDTH    1

/* EPDISBLD0OUT */
#define REG_EPDISBLD0OUT          0x00b08
#define REG_EPDISBLD0OUT_MASK     0x00000002
#define REG_EPDISBLD0OUT_SHIFT    1
#define REG_EPDISBLD0OUT_WIDTH    1

/* XFERCOMPL0OUT */
#define REG_XFERCOMPL0OUT          0x00b08
#define REG_XFERCOMPL0OUT_MASK     0x00000001
#define REG_XFERCOMPL0OUT_SHIFT    0
#define REG_XFERCOMPL0OUT_WIDTH    1

/* SUPCNT0OUT */
#define REG_SUPCNT0OUT          0x00b10
#define REG_SUPCNT0OUT_MASK     0x60000000
#define REG_SUPCNT0OUT_SHIFT    29
#define REG_SUPCNT0OUT_WIDTH    2

/* PKTCNT0OUT */
#define REG_PKTCNT0OUT          0x00b10
#define REG_PKTCNT0OUT_MASK     0x00080000
#define REG_PKTCNT0OUT_SHIFT    19
#define REG_PKTCNT0OUT_WIDTH    1

/* XFERSIZE0OUT */
#define REG_XFERSIZE0OUT          0x00b10
#define REG_XFERSIZE0OUT_MASK     0x0000007f
#define REG_XFERSIZE0OUT_SHIFT    0
#define REG_XFERSIZE0OUT_WIDTH    7

/* DOEPDMA0OUT */
#define REG_DOEPDMA0OUT          0x00b14
#define REG_DOEPDMA0OUT_MASK     0xffffffff
#define REG_DOEPDMA0OUT_SHIFT    0
#define REG_DOEPDMA0OUT_WIDTH    32

/* DOEPDMAB0OUT */
#define REG_DOEPDMAB0OUT          0x00b1c
#define REG_DOEPDMAB0OUT_MASK     0xffffffff
#define REG_DOEPDMAB0OUT_SHIFT    0
#define REG_DOEPDMAB0OUT_WIDTH    32

/* EPENA1OUT */
#define REG_EPENA1OUT          0x00b20
#define REG_EPENA1OUT_MASK     0x80000000
#define REG_EPENA1OUT_SHIFT    31
#define REG_EPENA1OUT_WIDTH    1

/* EPDIS1OUT */
#define REG_EPDIS1OUT          0x00b20
#define REG_EPDIS1OUT_MASK     0x40000000
#define REG_EPDIS1OUT_SHIFT    30
#define REG_EPDIS1OUT_WIDTH    1

/* STALL1OUT */
#define REG_STALL1OUT          0x00b20
#define REG_STALL1OUT_MASK     0x00200000
#define REG_STALL1OUT_SHIFT    21
#define REG_STALL1OUT_WIDTH    1

/* SNP1OUT */
#define REG_SNP1OUT          0x00b20
#define REG_SNP1OUT_MASK     0x00100000
#define REG_SNP1OUT_SHIFT    20
#define REG_SNP1OUT_WIDTH    1

/* EPTYPE1OUT */
#define REG_EPTYPE1OUT          0x00b20
#define REG_EPTYPE1OUT_MASK     0x000c0000
#define REG_EPTYPE1OUT_SHIFT    18
#define REG_EPTYPE1OUT_WIDTH    2

/* NAKSTS1OUT */
#define REG_NAKSTS1OUT          0x00b20
#define REG_NAKSTS1OUT_MASK     0x00020000
#define REG_NAKSTS1OUT_SHIFT    17
#define REG_NAKSTS1OUT_WIDTH    1

/* DPID1OUT */
#define REG_DPID1OUT          0x00b20
#define REG_DPID1OUT_MASK     0x00010000
#define REG_DPID1OUT_SHIFT    16
#define REG_DPID1OUT_WIDTH    1

/* USBACTEPCTL1OUT */
#define REG_USBACTEPCTL1OUT          0x00b20
#define REG_USBACTEPCTL1OUT_MASK     0x00008000
#define REG_USBACTEPCTL1OUT_SHIFT    15
#define REG_USBACTEPCTL1OUT_WIDTH    1

/* MPS1OUT */
#define REG_MPS1OUT          0x00b20
#define REG_MPS1OUT_MASK     0x000007ff
#define REG_MPS1OUT_SHIFT    0
#define REG_MPS1OUT_WIDTH    11

/* SETD1PID1OUT */
#define REG_SETD1PID1OUT          0x00b20
#define REG_SETD1PID1OUT_MASK     0x20000000
#define REG_SETD1PID1OUT_SHIFT    29
#define REG_SETD1PID1OUT_WIDTH    1

/* SETD0PID1OUT */
#define REG_SETD0PID1OUT          0x00b20
#define REG_SETD0PID1OUT_MASK     0x10000000
#define REG_SETD0PID1OUT_SHIFT    28
#define REG_SETD0PID1OUT_WIDTH    1

/* SNAK1OUT */
#define REG_SNAK1OUT          0x00b20
#define REG_SNAK1OUT_MASK     0x08000000
#define REG_SNAK1OUT_SHIFT    27
#define REG_SNAK1OUT_WIDTH    1

/* CNAK1OUT */
#define REG_CNAK1OUT          0x00b20
#define REG_CNAK1OUT_MASK     0x04000000
#define REG_CNAK1OUT_SHIFT    26
#define REG_CNAK1OUT_WIDTH    1

/* NYETINTRPT1OUT */
#define REG_NYETINTRPT1OUT          0x00b28
#define REG_NYETINTRPT1OUT_MASK     0x00004000
#define REG_NYETINTRPT1OUT_SHIFT    14
#define REG_NYETINTRPT1OUT_WIDTH    1

/* NAKINTRPT1OUT */
#define REG_NAKINTRPT1OUT          0x00b28
#define REG_NAKINTRPT1OUT_MASK     0x00002000
#define REG_NAKINTRPT1OUT_SHIFT    13
#define REG_NAKINTRPT1OUT_WIDTH    1

/* BBLEERR1OUT */
#define REG_BBLEERR1OUT          0x00b28
#define REG_BBLEERR1OUT_MASK     0x00001000
#define REG_BBLEERR1OUT_SHIFT    12
#define REG_BBLEERR1OUT_WIDTH    1

/* PKTDRPSTS1OUT */
#define REG_PKTDRPSTS1OUT          0x00b28
#define REG_PKTDRPSTS1OUT_MASK     0x00000800
#define REG_PKTDRPSTS1OUT_SHIFT    11
#define REG_PKTDRPSTS1OUT_WIDTH    1

/* BNAINTR1OUT */
#define REG_BNAINTR1OUT          0x00b28
#define REG_BNAINTR1OUT_MASK     0x00000200
#define REG_BNAINTR1OUT_SHIFT    9
#define REG_BNAINTR1OUT_WIDTH    1

/* OUTPKTERR1OUT */
#define REG_OUTPKTERR1OUT          0x00b28
#define REG_OUTPKTERR1OUT_MASK     0x00000100
#define REG_OUTPKTERR1OUT_SHIFT    8
#define REG_OUTPKTERR1OUT_WIDTH    1

/* BACK2BACKSETUP1OUT */
#define REG_BACK2BACKSETUP1OUT          0x00b28
#define REG_BACK2BACKSETUP1OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP1OUT_SHIFT    6
#define REG_BACK2BACKSETUP1OUT_WIDTH    1

/* STSPHSERCVD1OUT */
#define REG_STSPHSERCVD1OUT          0x00b28
#define REG_STSPHSERCVD1OUT_MASK     0x00000020
#define REG_STSPHSERCVD1OUT_SHIFT    5
#define REG_STSPHSERCVD1OUT_WIDTH    1

/* OUTTKNEPDIS1OUT */
#define REG_OUTTKNEPDIS1OUT          0x00b28
#define REG_OUTTKNEPDIS1OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS1OUT_SHIFT    4
#define REG_OUTTKNEPDIS1OUT_WIDTH    1

/* SETUP1OUT */
#define REG_SETUP1OUT          0x00b28
#define REG_SETUP1OUT_MASK     0x00000008
#define REG_SETUP1OUT_SHIFT    3
#define REG_SETUP1OUT_WIDTH    1

/* AHBERR1OUT */
#define REG_AHBERR1OUT          0x00b28
#define REG_AHBERR1OUT_MASK     0x00000004
#define REG_AHBERR1OUT_SHIFT    2
#define REG_AHBERR1OUT_WIDTH    1

/* EPDISBLD1OUT */
#define REG_EPDISBLD1OUT          0x00b28
#define REG_EPDISBLD1OUT_MASK     0x00000002
#define REG_EPDISBLD1OUT_SHIFT    1
#define REG_EPDISBLD1OUT_WIDTH    1

/* XFERCOMPL1OUT */
#define REG_XFERCOMPL1OUT          0x00b28
#define REG_XFERCOMPL1OUT_MASK     0x00000001
#define REG_XFERCOMPL1OUT_SHIFT    0
#define REG_XFERCOMPL1OUT_WIDTH    1

/* RXDPID1OUT */
#define REG_RXDPID1OUT          0x00b30
#define REG_RXDPID1OUT_MASK     0x60000000
#define REG_RXDPID1OUT_SHIFT    29
#define REG_RXDPID1OUT_WIDTH    2

/* PKTCNT1OUT */
#define REG_PKTCNT1OUT          0x00b30
#define REG_PKTCNT1OUT_MASK     0x1ff80000
#define REG_PKTCNT1OUT_SHIFT    19
#define REG_PKTCNT1OUT_WIDTH    10

/* XFERSIZE1OUT */
#define REG_XFERSIZE1OUT          0x00b30
#define REG_XFERSIZE1OUT_MASK     0x0007ffff
#define REG_XFERSIZE1OUT_SHIFT    0
#define REG_XFERSIZE1OUT_WIDTH    19

/* DOEPDMA1OUT */
#define REG_DOEPDMA1OUT          0x00b34
#define REG_DOEPDMA1OUT_MASK     0xffffffff
#define REG_DOEPDMA1OUT_SHIFT    0
#define REG_DOEPDMA1OUT_WIDTH    32

/* DOEPDMAB1OUT */
#define REG_DOEPDMAB1OUT          0x00b3c
#define REG_DOEPDMAB1OUT_MASK     0xffffffff
#define REG_DOEPDMAB1OUT_SHIFT    0
#define REG_DOEPDMAB1OUT_WIDTH    32

/* EPENA2OUT */
#define REG_EPENA2OUT          0x00b40
#define REG_EPENA2OUT_MASK     0x80000000
#define REG_EPENA2OUT_SHIFT    31
#define REG_EPENA2OUT_WIDTH    1

/* EPDIS2OUT */
#define REG_EPDIS2OUT          0x00b40
#define REG_EPDIS2OUT_MASK     0x40000000
#define REG_EPDIS2OUT_SHIFT    30
#define REG_EPDIS2OUT_WIDTH    1

/* STALL2OUT */
#define REG_STALL2OUT          0x00b40
#define REG_STALL2OUT_MASK     0x00200000
#define REG_STALL2OUT_SHIFT    21
#define REG_STALL2OUT_WIDTH    1

/* SNP2OUT */
#define REG_SNP2OUT          0x00b40
#define REG_SNP2OUT_MASK     0x00100000
#define REG_SNP2OUT_SHIFT    20
#define REG_SNP2OUT_WIDTH    1

/* EPTYPE2OUT */
#define REG_EPTYPE2OUT          0x00b40
#define REG_EPTYPE2OUT_MASK     0x000c0000
#define REG_EPTYPE2OUT_SHIFT    18
#define REG_EPTYPE2OUT_WIDTH    2

/* NAKSTS2OUT */
#define REG_NAKSTS2OUT          0x00b40
#define REG_NAKSTS2OUT_MASK     0x00020000
#define REG_NAKSTS2OUT_SHIFT    17
#define REG_NAKSTS2OUT_WIDTH    1

/* DPID2OUT */
#define REG_DPID2OUT          0x00b40
#define REG_DPID2OUT_MASK     0x00010000
#define REG_DPID2OUT_SHIFT    16
#define REG_DPID2OUT_WIDTH    1

/* USBACTEPCTL2OUT */
#define REG_USBACTEPCTL2OUT          0x00b40
#define REG_USBACTEPCTL2OUT_MASK     0x00008000
#define REG_USBACTEPCTL2OUT_SHIFT    15
#define REG_USBACTEPCTL2OUT_WIDTH    1

/* MPS2OUT */
#define REG_MPS2OUT          0x00b40
#define REG_MPS2OUT_MASK     0x000007ff
#define REG_MPS2OUT_SHIFT    0
#define REG_MPS2OUT_WIDTH    11

/* SETD1PID2OUT */
#define REG_SETD1PID2OUT          0x00b40
#define REG_SETD1PID2OUT_MASK     0x20000000
#define REG_SETD1PID2OUT_SHIFT    29
#define REG_SETD1PID2OUT_WIDTH    1

/* SETD0PID2OUT */
#define REG_SETD0PID2OUT          0x00b40
#define REG_SETD0PID2OUT_MASK     0x10000000
#define REG_SETD0PID2OUT_SHIFT    28
#define REG_SETD0PID2OUT_WIDTH    1

/* SNAK2OUT */
#define REG_SNAK2OUT          0x00b40
#define REG_SNAK2OUT_MASK     0x08000000
#define REG_SNAK2OUT_SHIFT    27
#define REG_SNAK2OUT_WIDTH    1

/* CNAK2OUT */
#define REG_CNAK2OUT          0x00b40
#define REG_CNAK2OUT_MASK     0x04000000
#define REG_CNAK2OUT_SHIFT    26
#define REG_CNAK2OUT_WIDTH    1

/* NYETINTRPT2OUT */
#define REG_NYETINTRPT2OUT          0x00b48
#define REG_NYETINTRPT2OUT_MASK     0x00004000
#define REG_NYETINTRPT2OUT_SHIFT    14
#define REG_NYETINTRPT2OUT_WIDTH    1

/* NAKINTRPT2OUT */
#define REG_NAKINTRPT2OUT          0x00b48
#define REG_NAKINTRPT2OUT_MASK     0x00002000
#define REG_NAKINTRPT2OUT_SHIFT    13
#define REG_NAKINTRPT2OUT_WIDTH    1

/* BBLEERR2OUT */
#define REG_BBLEERR2OUT          0x00b48
#define REG_BBLEERR2OUT_MASK     0x00001000
#define REG_BBLEERR2OUT_SHIFT    12
#define REG_BBLEERR2OUT_WIDTH    1

/* PKTDRPSTS2OUT */
#define REG_PKTDRPSTS2OUT          0x00b48
#define REG_PKTDRPSTS2OUT_MASK     0x00000800
#define REG_PKTDRPSTS2OUT_SHIFT    11
#define REG_PKTDRPSTS2OUT_WIDTH    1

/* BNAINTR2OUT */
#define REG_BNAINTR2OUT          0x00b48
#define REG_BNAINTR2OUT_MASK     0x00000200
#define REG_BNAINTR2OUT_SHIFT    9
#define REG_BNAINTR2OUT_WIDTH    1

/* OUTPKTERR2OUT */
#define REG_OUTPKTERR2OUT          0x00b48
#define REG_OUTPKTERR2OUT_MASK     0x00000100
#define REG_OUTPKTERR2OUT_SHIFT    8
#define REG_OUTPKTERR2OUT_WIDTH    1

/* BACK2BACKSETUP2OUT */
#define REG_BACK2BACKSETUP2OUT          0x00b48
#define REG_BACK2BACKSETUP2OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP2OUT_SHIFT    6
#define REG_BACK2BACKSETUP2OUT_WIDTH    1

/* STSPHSERCVD2OUT */
#define REG_STSPHSERCVD2OUT          0x00b48
#define REG_STSPHSERCVD2OUT_MASK     0x00000020
#define REG_STSPHSERCVD2OUT_SHIFT    5
#define REG_STSPHSERCVD2OUT_WIDTH    1

/* OUTTKNEPDIS2OUT */
#define REG_OUTTKNEPDIS2OUT          0x00b48
#define REG_OUTTKNEPDIS2OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS2OUT_SHIFT    4
#define REG_OUTTKNEPDIS2OUT_WIDTH    1

/* SETUP2OUT */
#define REG_SETUP2OUT          0x00b48
#define REG_SETUP2OUT_MASK     0x00000008
#define REG_SETUP2OUT_SHIFT    3
#define REG_SETUP2OUT_WIDTH    1

/* AHBERR2OUT */
#define REG_AHBERR2OUT          0x00b48
#define REG_AHBERR2OUT_MASK     0x00000004
#define REG_AHBERR2OUT_SHIFT    2
#define REG_AHBERR2OUT_WIDTH    1

/* EPDISBLD2OUT */
#define REG_EPDISBLD2OUT          0x00b48
#define REG_EPDISBLD2OUT_MASK     0x00000002
#define REG_EPDISBLD2OUT_SHIFT    1
#define REG_EPDISBLD2OUT_WIDTH    1

/* XFERCOMPL2OUT */
#define REG_XFERCOMPL2OUT          0x00b48
#define REG_XFERCOMPL2OUT_MASK     0x00000001
#define REG_XFERCOMPL2OUT_SHIFT    0
#define REG_XFERCOMPL2OUT_WIDTH    1

/* RXDPID2OUT */
#define REG_RXDPID2OUT          0x00b50
#define REG_RXDPID2OUT_MASK     0x60000000
#define REG_RXDPID2OUT_SHIFT    29
#define REG_RXDPID2OUT_WIDTH    2

/* PKTCNT2OUT */
#define REG_PKTCNT2OUT          0x00b50
#define REG_PKTCNT2OUT_MASK     0x1ff80000
#define REG_PKTCNT2OUT_SHIFT    19
#define REG_PKTCNT2OUT_WIDTH    10

/* XFERSIZE2OUT */
#define REG_XFERSIZE2OUT          0x00b50
#define REG_XFERSIZE2OUT_MASK     0x0007ffff
#define REG_XFERSIZE2OUT_SHIFT    0
#define REG_XFERSIZE2OUT_WIDTH    19

/* DOEPDMA2OUT */
#define REG_DOEPDMA2OUT          0x00b54
#define REG_DOEPDMA2OUT_MASK     0xffffffff
#define REG_DOEPDMA2OUT_SHIFT    0
#define REG_DOEPDMA2OUT_WIDTH    32

/* DOEPDMAB2OUT */
#define REG_DOEPDMAB2OUT          0x00b5c
#define REG_DOEPDMAB2OUT_MASK     0xffffffff
#define REG_DOEPDMAB2OUT_SHIFT    0
#define REG_DOEPDMAB2OUT_WIDTH    32

/* EPENA3OUT */
#define REG_EPENA3OUT          0x00b60
#define REG_EPENA3OUT_MASK     0x80000000
#define REG_EPENA3OUT_SHIFT    31
#define REG_EPENA3OUT_WIDTH    1

/* EPDIS3OUT */
#define REG_EPDIS3OUT          0x00b60
#define REG_EPDIS3OUT_MASK     0x40000000
#define REG_EPDIS3OUT_SHIFT    30
#define REG_EPDIS3OUT_WIDTH    1

/* STALL3OUT */
#define REG_STALL3OUT          0x00b60
#define REG_STALL3OUT_MASK     0x00200000
#define REG_STALL3OUT_SHIFT    21
#define REG_STALL3OUT_WIDTH    1

/* SNP3OUT */
#define REG_SNP3OUT          0x00b60
#define REG_SNP3OUT_MASK     0x00100000
#define REG_SNP3OUT_SHIFT    20
#define REG_SNP3OUT_WIDTH    1

/* EPTYPE3OUT */
#define REG_EPTYPE3OUT          0x00b60
#define REG_EPTYPE3OUT_MASK     0x000c0000
#define REG_EPTYPE3OUT_SHIFT    18
#define REG_EPTYPE3OUT_WIDTH    2

/* NAKSTS3OUT */
#define REG_NAKSTS3OUT          0x00b60
#define REG_NAKSTS3OUT_MASK     0x00020000
#define REG_NAKSTS3OUT_SHIFT    17
#define REG_NAKSTS3OUT_WIDTH    1

/* DPID3OUT */
#define REG_DPID3OUT          0x00b60
#define REG_DPID3OUT_MASK     0x00010000
#define REG_DPID3OUT_SHIFT    16
#define REG_DPID3OUT_WIDTH    1

/* USBACTEPCTL3OUT */
#define REG_USBACTEPCTL3OUT          0x00b60
#define REG_USBACTEPCTL3OUT_MASK     0x00008000
#define REG_USBACTEPCTL3OUT_SHIFT    15
#define REG_USBACTEPCTL3OUT_WIDTH    1

/* MPS3OUT */
#define REG_MPS3OUT          0x00b60
#define REG_MPS3OUT_MASK     0x000007ff
#define REG_MPS3OUT_SHIFT    0
#define REG_MPS3OUT_WIDTH    11

/* SETD1PID3OUT */
#define REG_SETD1PID3OUT          0x00b60
#define REG_SETD1PID3OUT_MASK     0x20000000
#define REG_SETD1PID3OUT_SHIFT    29
#define REG_SETD1PID3OUT_WIDTH    1

/* SETD0PID3OUT */
#define REG_SETD0PID3OUT          0x00b60
#define REG_SETD0PID3OUT_MASK     0x10000000
#define REG_SETD0PID3OUT_SHIFT    28
#define REG_SETD0PID3OUT_WIDTH    1

/* SNAK3OUT */
#define REG_SNAK3OUT          0x00b60
#define REG_SNAK3OUT_MASK     0x08000000
#define REG_SNAK3OUT_SHIFT    27
#define REG_SNAK3OUT_WIDTH    1

/* CNAK3OUT */
#define REG_CNAK3OUT          0x00b60
#define REG_CNAK3OUT_MASK     0x04000000
#define REG_CNAK3OUT_SHIFT    26
#define REG_CNAK3OUT_WIDTH    1

/* NYETINTRPT3OUT */
#define REG_NYETINTRPT3OUT          0x00b68
#define REG_NYETINTRPT3OUT_MASK     0x00004000
#define REG_NYETINTRPT3OUT_SHIFT    14
#define REG_NYETINTRPT3OUT_WIDTH    1

/* NAKINTRPT3OUT */
#define REG_NAKINTRPT3OUT          0x00b68
#define REG_NAKINTRPT3OUT_MASK     0x00002000
#define REG_NAKINTRPT3OUT_SHIFT    13
#define REG_NAKINTRPT3OUT_WIDTH    1

/* BBLEERR3OUT */
#define REG_BBLEERR3OUT          0x00b68
#define REG_BBLEERR3OUT_MASK     0x00001000
#define REG_BBLEERR3OUT_SHIFT    12
#define REG_BBLEERR3OUT_WIDTH    1

/* PKTDRPSTS3OUT */
#define REG_PKTDRPSTS3OUT          0x00b68
#define REG_PKTDRPSTS3OUT_MASK     0x00000800
#define REG_PKTDRPSTS3OUT_SHIFT    11
#define REG_PKTDRPSTS3OUT_WIDTH    1

/* BNAINTR3OUT */
#define REG_BNAINTR3OUT          0x00b68
#define REG_BNAINTR3OUT_MASK     0x00000200
#define REG_BNAINTR3OUT_SHIFT    9
#define REG_BNAINTR3OUT_WIDTH    1

/* OUTPKTERR3OUT */
#define REG_OUTPKTERR3OUT          0x00b68
#define REG_OUTPKTERR3OUT_MASK     0x00000100
#define REG_OUTPKTERR3OUT_SHIFT    8
#define REG_OUTPKTERR3OUT_WIDTH    1

/* BACK2BACKSETUP3OUT */
#define REG_BACK2BACKSETUP3OUT          0x00b68
#define REG_BACK2BACKSETUP3OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP3OUT_SHIFT    6
#define REG_BACK2BACKSETUP3OUT_WIDTH    1

/* STSPHSERCVD3OUT */
#define REG_STSPHSERCVD3OUT          0x00b68
#define REG_STSPHSERCVD3OUT_MASK     0x00000020
#define REG_STSPHSERCVD3OUT_SHIFT    5
#define REG_STSPHSERCVD3OUT_WIDTH    1

/* OUTTKNEPDIS3OUT */
#define REG_OUTTKNEPDIS3OUT          0x00b68
#define REG_OUTTKNEPDIS3OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS3OUT_SHIFT    4
#define REG_OUTTKNEPDIS3OUT_WIDTH    1

/* SETUP3OUT */
#define REG_SETUP3OUT          0x00b68
#define REG_SETUP3OUT_MASK     0x00000008
#define REG_SETUP3OUT_SHIFT    3
#define REG_SETUP3OUT_WIDTH    1

/* AHBERR3OUT */
#define REG_AHBERR3OUT          0x00b68
#define REG_AHBERR3OUT_MASK     0x00000004
#define REG_AHBERR3OUT_SHIFT    2
#define REG_AHBERR3OUT_WIDTH    1

/* EPDISBLD3OUT */
#define REG_EPDISBLD3OUT          0x00b68
#define REG_EPDISBLD3OUT_MASK     0x00000002
#define REG_EPDISBLD3OUT_SHIFT    1
#define REG_EPDISBLD3OUT_WIDTH    1

/* XFERCOMPL3OUT */
#define REG_XFERCOMPL3OUT          0x00b68
#define REG_XFERCOMPL3OUT_MASK     0x00000001
#define REG_XFERCOMPL3OUT_SHIFT    0
#define REG_XFERCOMPL3OUT_WIDTH    1

/* RXDPID3OUT */
#define REG_RXDPID3OUT          0x00b70
#define REG_RXDPID3OUT_MASK     0x60000000
#define REG_RXDPID3OUT_SHIFT    29
#define REG_RXDPID3OUT_WIDTH    2

/* PKTCNT3OUT */
#define REG_PKTCNT3OUT          0x00b70
#define REG_PKTCNT3OUT_MASK     0x1ff80000
#define REG_PKTCNT3OUT_SHIFT    19
#define REG_PKTCNT3OUT_WIDTH    10

/* XFERSIZE3OUT */
#define REG_XFERSIZE3OUT          0x00b70
#define REG_XFERSIZE3OUT_MASK     0x0007ffff
#define REG_XFERSIZE3OUT_SHIFT    0
#define REG_XFERSIZE3OUT_WIDTH    19

/* DOEPDMA3OUT */
#define REG_DOEPDMA3OUT          0x00b74
#define REG_DOEPDMA3OUT_MASK     0xffffffff
#define REG_DOEPDMA3OUT_SHIFT    0
#define REG_DOEPDMA3OUT_WIDTH    32

/* DOEPDMAB3OUT */
#define REG_DOEPDMAB3OUT          0x00b7c
#define REG_DOEPDMAB3OUT_MASK     0xffffffff
#define REG_DOEPDMAB3OUT_SHIFT    0
#define REG_DOEPDMAB3OUT_WIDTH    32

/* EPENA4OUT */
#define REG_EPENA4OUT          0x00b80
#define REG_EPENA4OUT_MASK     0x80000000
#define REG_EPENA4OUT_SHIFT    31
#define REG_EPENA4OUT_WIDTH    1

/* EPDIS4OUT */
#define REG_EPDIS4OUT          0x00b80
#define REG_EPDIS4OUT_MASK     0x40000000
#define REG_EPDIS4OUT_SHIFT    30
#define REG_EPDIS4OUT_WIDTH    1

/* STALL4OUT */
#define REG_STALL4OUT          0x00b80
#define REG_STALL4OUT_MASK     0x00200000
#define REG_STALL4OUT_SHIFT    21
#define REG_STALL4OUT_WIDTH    1

/* SNP4OUT */
#define REG_SNP4OUT          0x00b80
#define REG_SNP4OUT_MASK     0x00100000
#define REG_SNP4OUT_SHIFT    20
#define REG_SNP4OUT_WIDTH    1

/* EPTYPE4OUT */
#define REG_EPTYPE4OUT          0x00b80
#define REG_EPTYPE4OUT_MASK     0x000c0000
#define REG_EPTYPE4OUT_SHIFT    18
#define REG_EPTYPE4OUT_WIDTH    2

/* NAKSTS4OUT */
#define REG_NAKSTS4OUT          0x00b80
#define REG_NAKSTS4OUT_MASK     0x00020000
#define REG_NAKSTS4OUT_SHIFT    17
#define REG_NAKSTS4OUT_WIDTH    1

/* DPID4OUT */
#define REG_DPID4OUT          0x00b80
#define REG_DPID4OUT_MASK     0x00010000
#define REG_DPID4OUT_SHIFT    16
#define REG_DPID4OUT_WIDTH    1

/* USBACTEPCTL4OUT */
#define REG_USBACTEPCTL4OUT          0x00b80
#define REG_USBACTEPCTL4OUT_MASK     0x00008000
#define REG_USBACTEPCTL4OUT_SHIFT    15
#define REG_USBACTEPCTL4OUT_WIDTH    1

/* MPS4OUT */
#define REG_MPS4OUT          0x00b80
#define REG_MPS4OUT_MASK     0x000007ff
#define REG_MPS4OUT_SHIFT    0
#define REG_MPS4OUT_WIDTH    11

/* SETD1PID4OUT */
#define REG_SETD1PID4OUT          0x00b80
#define REG_SETD1PID4OUT_MASK     0x20000000
#define REG_SETD1PID4OUT_SHIFT    29
#define REG_SETD1PID4OUT_WIDTH    1

/* SETD0PID4OUT */
#define REG_SETD0PID4OUT          0x00b80
#define REG_SETD0PID4OUT_MASK     0x10000000
#define REG_SETD0PID4OUT_SHIFT    28
#define REG_SETD0PID4OUT_WIDTH    1

/* SNAK4OUT */
#define REG_SNAK4OUT          0x00b80
#define REG_SNAK4OUT_MASK     0x08000000
#define REG_SNAK4OUT_SHIFT    27
#define REG_SNAK4OUT_WIDTH    1

/* CNAK4OUT */
#define REG_CNAK4OUT          0x00b80
#define REG_CNAK4OUT_MASK     0x04000000
#define REG_CNAK4OUT_SHIFT    26
#define REG_CNAK4OUT_WIDTH    1

/* NYETINTRPT4OUT */
#define REG_NYETINTRPT4OUT          0x00b88
#define REG_NYETINTRPT4OUT_MASK     0x00004000
#define REG_NYETINTRPT4OUT_SHIFT    14
#define REG_NYETINTRPT4OUT_WIDTH    1

/* NAKINTRPT4OUT */
#define REG_NAKINTRPT4OUT          0x00b88
#define REG_NAKINTRPT4OUT_MASK     0x00002000
#define REG_NAKINTRPT4OUT_SHIFT    13
#define REG_NAKINTRPT4OUT_WIDTH    1

/* BBLEERR4OUT */
#define REG_BBLEERR4OUT          0x00b88
#define REG_BBLEERR4OUT_MASK     0x00001000
#define REG_BBLEERR4OUT_SHIFT    12
#define REG_BBLEERR4OUT_WIDTH    1

/* PKTDRPSTS4OUT */
#define REG_PKTDRPSTS4OUT          0x00b88
#define REG_PKTDRPSTS4OUT_MASK     0x00000800
#define REG_PKTDRPSTS4OUT_SHIFT    11
#define REG_PKTDRPSTS4OUT_WIDTH    1

/* BNAINTR4OUT */
#define REG_BNAINTR4OUT          0x00b88
#define REG_BNAINTR4OUT_MASK     0x00000200
#define REG_BNAINTR4OUT_SHIFT    9
#define REG_BNAINTR4OUT_WIDTH    1

/* OUTPKTERR4OUT */
#define REG_OUTPKTERR4OUT          0x00b88
#define REG_OUTPKTERR4OUT_MASK     0x00000100
#define REG_OUTPKTERR4OUT_SHIFT    8
#define REG_OUTPKTERR4OUT_WIDTH    1

/* BACK2BACKSETUP4OUT */
#define REG_BACK2BACKSETUP4OUT          0x00b88
#define REG_BACK2BACKSETUP4OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP4OUT_SHIFT    6
#define REG_BACK2BACKSETUP4OUT_WIDTH    1

/* STSPHSERCVD4OUT */
#define REG_STSPHSERCVD4OUT          0x00b88
#define REG_STSPHSERCVD4OUT_MASK     0x00000020
#define REG_STSPHSERCVD4OUT_SHIFT    5
#define REG_STSPHSERCVD4OUT_WIDTH    1

/* OUTTKNEPDIS4OUT */
#define REG_OUTTKNEPDIS4OUT          0x00b88
#define REG_OUTTKNEPDIS4OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS4OUT_SHIFT    4
#define REG_OUTTKNEPDIS4OUT_WIDTH    1

/* SETUP4OUT */
#define REG_SETUP4OUT          0x00b88
#define REG_SETUP4OUT_MASK     0x00000008
#define REG_SETUP4OUT_SHIFT    3
#define REG_SETUP4OUT_WIDTH    1

/* AHBERR4OUT */
#define REG_AHBERR4OUT          0x00b88
#define REG_AHBERR4OUT_MASK     0x00000004
#define REG_AHBERR4OUT_SHIFT    2
#define REG_AHBERR4OUT_WIDTH    1

/* EPDISBLD4OUT */
#define REG_EPDISBLD4OUT          0x00b88
#define REG_EPDISBLD4OUT_MASK     0x00000002
#define REG_EPDISBLD4OUT_SHIFT    1
#define REG_EPDISBLD4OUT_WIDTH    1

/* XFERCOMPL4OUT */
#define REG_XFERCOMPL4OUT          0x00b88
#define REG_XFERCOMPL4OUT_MASK     0x00000001
#define REG_XFERCOMPL4OUT_SHIFT    0
#define REG_XFERCOMPL4OUT_WIDTH    1

/* RXDPID4OUT */
#define REG_RXDPID4OUT          0x00b90
#define REG_RXDPID4OUT_MASK     0x60000000
#define REG_RXDPID4OUT_SHIFT    29
#define REG_RXDPID4OUT_WIDTH    2

/* PKTCNT4OUT */
#define REG_PKTCNT4OUT          0x00b90
#define REG_PKTCNT4OUT_MASK     0x1ff80000
#define REG_PKTCNT4OUT_SHIFT    19
#define REG_PKTCNT4OUT_WIDTH    10

/* XFERSIZE4OUT */
#define REG_XFERSIZE4OUT          0x00b90
#define REG_XFERSIZE4OUT_MASK     0x0007ffff
#define REG_XFERSIZE4OUT_SHIFT    0
#define REG_XFERSIZE4OUT_WIDTH    19

/* DOEPDMA4OUT */
#define REG_DOEPDMA4OUT          0x00b94
#define REG_DOEPDMA4OUT_MASK     0xffffffff
#define REG_DOEPDMA4OUT_SHIFT    0
#define REG_DOEPDMA4OUT_WIDTH    32

/* DOEPDMAB4OUT */
#define REG_DOEPDMAB4OUT          0x00b9c
#define REG_DOEPDMAB4OUT_MASK     0xffffffff
#define REG_DOEPDMAB4OUT_SHIFT    0
#define REG_DOEPDMAB4OUT_WIDTH    32

/* EPENA5OUT */
#define REG_EPENA5OUT          0x00ba0
#define REG_EPENA5OUT_MASK     0x80000000
#define REG_EPENA5OUT_SHIFT    31
#define REG_EPENA5OUT_WIDTH    1

/* EPDIS5OUT */
#define REG_EPDIS5OUT          0x00ba0
#define REG_EPDIS5OUT_MASK     0x40000000
#define REG_EPDIS5OUT_SHIFT    30
#define REG_EPDIS5OUT_WIDTH    1

/* STALL5OUT */
#define REG_STALL5OUT          0x00ba0
#define REG_STALL5OUT_MASK     0x00200000
#define REG_STALL5OUT_SHIFT    21
#define REG_STALL5OUT_WIDTH    1

/* SNP5OUT */
#define REG_SNP5OUT          0x00ba0
#define REG_SNP5OUT_MASK     0x00100000
#define REG_SNP5OUT_SHIFT    20
#define REG_SNP5OUT_WIDTH    1

/* EPTYPE5OUT */
#define REG_EPTYPE5OUT          0x00ba0
#define REG_EPTYPE5OUT_MASK     0x000c0000
#define REG_EPTYPE5OUT_SHIFT    18
#define REG_EPTYPE5OUT_WIDTH    2

/* NAKSTS5OUT */
#define REG_NAKSTS5OUT          0x00ba0
#define REG_NAKSTS5OUT_MASK     0x00020000
#define REG_NAKSTS5OUT_SHIFT    17
#define REG_NAKSTS5OUT_WIDTH    1

/* DPID5OUT */
#define REG_DPID5OUT          0x00ba0
#define REG_DPID5OUT_MASK     0x00010000
#define REG_DPID5OUT_SHIFT    16
#define REG_DPID5OUT_WIDTH    1

/* USBACTEPCTL5OUT */
#define REG_USBACTEPCTL5OUT          0x00ba0
#define REG_USBACTEPCTL5OUT_MASK     0x00008000
#define REG_USBACTEPCTL5OUT_SHIFT    15
#define REG_USBACTEPCTL5OUT_WIDTH    1

/* MPS5OUT */
#define REG_MPS5OUT          0x00ba0
#define REG_MPS5OUT_MASK     0x000007ff
#define REG_MPS5OUT_SHIFT    0
#define REG_MPS5OUT_WIDTH    11

/* SETD1PID5OUT */
#define REG_SETD1PID5OUT          0x00ba0
#define REG_SETD1PID5OUT_MASK     0x20000000
#define REG_SETD1PID5OUT_SHIFT    29
#define REG_SETD1PID5OUT_WIDTH    1

/* SETD0PID5OUT */
#define REG_SETD0PID5OUT          0x00ba0
#define REG_SETD0PID5OUT_MASK     0x10000000
#define REG_SETD0PID5OUT_SHIFT    28
#define REG_SETD0PID5OUT_WIDTH    1

/* SNAK5OUT */
#define REG_SNAK5OUT          0x00ba0
#define REG_SNAK5OUT_MASK     0x08000000
#define REG_SNAK5OUT_SHIFT    27
#define REG_SNAK5OUT_WIDTH    1

/* CNAK5OUT */
#define REG_CNAK5OUT          0x00ba0
#define REG_CNAK5OUT_MASK     0x04000000
#define REG_CNAK5OUT_SHIFT    26
#define REG_CNAK5OUT_WIDTH    1

/* NYETINTRPT5OUT */
#define REG_NYETINTRPT5OUT          0x00ba8
#define REG_NYETINTRPT5OUT_MASK     0x00004000
#define REG_NYETINTRPT5OUT_SHIFT    14
#define REG_NYETINTRPT5OUT_WIDTH    1

/* NAKINTRPT5OUT */
#define REG_NAKINTRPT5OUT          0x00ba8
#define REG_NAKINTRPT5OUT_MASK     0x00002000
#define REG_NAKINTRPT5OUT_SHIFT    13
#define REG_NAKINTRPT5OUT_WIDTH    1

/* BBLEERR5OUT */
#define REG_BBLEERR5OUT          0x00ba8
#define REG_BBLEERR5OUT_MASK     0x00001000
#define REG_BBLEERR5OUT_SHIFT    12
#define REG_BBLEERR5OUT_WIDTH    1

/* PKTDRPSTS5OUT */
#define REG_PKTDRPSTS5OUT          0x00ba8
#define REG_PKTDRPSTS5OUT_MASK     0x00000800
#define REG_PKTDRPSTS5OUT_SHIFT    11
#define REG_PKTDRPSTS5OUT_WIDTH    1

/* BNAINTR5OUT */
#define REG_BNAINTR5OUT          0x00ba8
#define REG_BNAINTR5OUT_MASK     0x00000200
#define REG_BNAINTR5OUT_SHIFT    9
#define REG_BNAINTR5OUT_WIDTH    1

/* OUTPKTERR5OUT */
#define REG_OUTPKTERR5OUT          0x00ba8
#define REG_OUTPKTERR5OUT_MASK     0x00000100
#define REG_OUTPKTERR5OUT_SHIFT    8
#define REG_OUTPKTERR5OUT_WIDTH    1

/* BACK2BACKSETUP5OUT */
#define REG_BACK2BACKSETUP5OUT          0x00ba8
#define REG_BACK2BACKSETUP5OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP5OUT_SHIFT    6
#define REG_BACK2BACKSETUP5OUT_WIDTH    1

/* STSPHSERCVD5OUT */
#define REG_STSPHSERCVD5OUT          0x00ba8
#define REG_STSPHSERCVD5OUT_MASK     0x00000020
#define REG_STSPHSERCVD5OUT_SHIFT    5
#define REG_STSPHSERCVD5OUT_WIDTH    1

/* OUTTKNEPDIS5OUT */
#define REG_OUTTKNEPDIS5OUT          0x00ba8
#define REG_OUTTKNEPDIS5OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS5OUT_SHIFT    4
#define REG_OUTTKNEPDIS5OUT_WIDTH    1

/* SETUP5OUT */
#define REG_SETUP5OUT          0x00ba8
#define REG_SETUP5OUT_MASK     0x00000008
#define REG_SETUP5OUT_SHIFT    3
#define REG_SETUP5OUT_WIDTH    1

/* AHBERR5OUT */
#define REG_AHBERR5OUT          0x00ba8
#define REG_AHBERR5OUT_MASK     0x00000004
#define REG_AHBERR5OUT_SHIFT    2
#define REG_AHBERR5OUT_WIDTH    1

/* EPDISBLD5OUT */
#define REG_EPDISBLD5OUT          0x00ba8
#define REG_EPDISBLD5OUT_MASK     0x00000002
#define REG_EPDISBLD5OUT_SHIFT    1
#define REG_EPDISBLD5OUT_WIDTH    1

/* XFERCOMPL5OUT */
#define REG_XFERCOMPL5OUT          0x00ba8
#define REG_XFERCOMPL5OUT_MASK     0x00000001
#define REG_XFERCOMPL5OUT_SHIFT    0
#define REG_XFERCOMPL5OUT_WIDTH    1

/* RXDPID5OUT */
#define REG_RXDPID5OUT          0x00bb0
#define REG_RXDPID5OUT_MASK     0x60000000
#define REG_RXDPID5OUT_SHIFT    29
#define REG_RXDPID5OUT_WIDTH    2

/* PKTCNT5OUT */
#define REG_PKTCNT5OUT          0x00bb0
#define REG_PKTCNT5OUT_MASK     0x1ff80000
#define REG_PKTCNT5OUT_SHIFT    19
#define REG_PKTCNT5OUT_WIDTH    10

/* XFERSIZE5OUT */
#define REG_XFERSIZE5OUT          0x00bb0
#define REG_XFERSIZE5OUT_MASK     0x0007ffff
#define REG_XFERSIZE5OUT_SHIFT    0
#define REG_XFERSIZE5OUT_WIDTH    19

/* DOEPDMA5OUT */
#define REG_DOEPDMA5OUT          0x00bb4
#define REG_DOEPDMA5OUT_MASK     0xffffffff
#define REG_DOEPDMA5OUT_SHIFT    0
#define REG_DOEPDMA5OUT_WIDTH    32

/* DOEPDMAB5OUT */
#define REG_DOEPDMAB5OUT          0x00bbc
#define REG_DOEPDMAB5OUT_MASK     0xffffffff
#define REG_DOEPDMAB5OUT_SHIFT    0
#define REG_DOEPDMAB5OUT_WIDTH    32

/* EPENA6OUT */
#define REG_EPENA6OUT          0x00bc0
#define REG_EPENA6OUT_MASK     0x80000000
#define REG_EPENA6OUT_SHIFT    31
#define REG_EPENA6OUT_WIDTH    1

/* EPDIS6OUT */
#define REG_EPDIS6OUT          0x00bc0
#define REG_EPDIS6OUT_MASK     0x40000000
#define REG_EPDIS6OUT_SHIFT    30
#define REG_EPDIS6OUT_WIDTH    1

/* STALL6OUT */
#define REG_STALL6OUT          0x00bc0
#define REG_STALL6OUT_MASK     0x00200000
#define REG_STALL6OUT_SHIFT    21
#define REG_STALL6OUT_WIDTH    1

/* SNP6OUT */
#define REG_SNP6OUT          0x00bc0
#define REG_SNP6OUT_MASK     0x00100000
#define REG_SNP6OUT_SHIFT    20
#define REG_SNP6OUT_WIDTH    1

/* EPTYPE6OUT */
#define REG_EPTYPE6OUT          0x00bc0
#define REG_EPTYPE6OUT_MASK     0x000c0000
#define REG_EPTYPE6OUT_SHIFT    18
#define REG_EPTYPE6OUT_WIDTH    2

/* NAKSTS6OUT */
#define REG_NAKSTS6OUT          0x00bc0
#define REG_NAKSTS6OUT_MASK     0x00020000
#define REG_NAKSTS6OUT_SHIFT    17
#define REG_NAKSTS6OUT_WIDTH    1

/* DPID6OUT */
#define REG_DPID6OUT          0x00bc0
#define REG_DPID6OUT_MASK     0x00010000
#define REG_DPID6OUT_SHIFT    16
#define REG_DPID6OUT_WIDTH    1

/* USBACTEPCTL6OUT */
#define REG_USBACTEPCTL6OUT          0x00bc0
#define REG_USBACTEPCTL6OUT_MASK     0x00008000
#define REG_USBACTEPCTL6OUT_SHIFT    15
#define REG_USBACTEPCTL6OUT_WIDTH    1

/* MPS6OUT */
#define REG_MPS6OUT          0x00bc0
#define REG_MPS6OUT_MASK     0x000007ff
#define REG_MPS6OUT_SHIFT    0
#define REG_MPS6OUT_WIDTH    11

/* SETD1PID6OUT */
#define REG_SETD1PID6OUT          0x00bc0
#define REG_SETD1PID6OUT_MASK     0x20000000
#define REG_SETD1PID6OUT_SHIFT    29
#define REG_SETD1PID6OUT_WIDTH    1

/* SETD0PID6OUT */
#define REG_SETD0PID6OUT          0x00bc0
#define REG_SETD0PID6OUT_MASK     0x10000000
#define REG_SETD0PID6OUT_SHIFT    28
#define REG_SETD0PID6OUT_WIDTH    1

/* SNAK6OUT */
#define REG_SNAK6OUT          0x00bc0
#define REG_SNAK6OUT_MASK     0x08000000
#define REG_SNAK6OUT_SHIFT    27
#define REG_SNAK6OUT_WIDTH    1

/* CNAK6OUT */
#define REG_CNAK6OUT          0x00bc0
#define REG_CNAK6OUT_MASK     0x04000000
#define REG_CNAK6OUT_SHIFT    26
#define REG_CNAK6OUT_WIDTH    1

/* NYETINTRPT6OUT */
#define REG_NYETINTRPT6OUT          0x00bc8
#define REG_NYETINTRPT6OUT_MASK     0x00004000
#define REG_NYETINTRPT6OUT_SHIFT    14
#define REG_NYETINTRPT6OUT_WIDTH    1

/* NAKINTRPT6OUT */
#define REG_NAKINTRPT6OUT          0x00bc8
#define REG_NAKINTRPT6OUT_MASK     0x00002000
#define REG_NAKINTRPT6OUT_SHIFT    13
#define REG_NAKINTRPT6OUT_WIDTH    1

/* BBLEERR6OUT */
#define REG_BBLEERR6OUT          0x00bc8
#define REG_BBLEERR6OUT_MASK     0x00001000
#define REG_BBLEERR6OUT_SHIFT    12
#define REG_BBLEERR6OUT_WIDTH    1

/* PKTDRPSTS6OUT */
#define REG_PKTDRPSTS6OUT          0x00bc8
#define REG_PKTDRPSTS6OUT_MASK     0x00000800
#define REG_PKTDRPSTS6OUT_SHIFT    11
#define REG_PKTDRPSTS6OUT_WIDTH    1

/* BNAINTR6OUT */
#define REG_BNAINTR6OUT          0x00bc8
#define REG_BNAINTR6OUT_MASK     0x00000200
#define REG_BNAINTR6OUT_SHIFT    9
#define REG_BNAINTR6OUT_WIDTH    1

/* OUTPKTERR6OUT */
#define REG_OUTPKTERR6OUT          0x00bc8
#define REG_OUTPKTERR6OUT_MASK     0x00000100
#define REG_OUTPKTERR6OUT_SHIFT    8
#define REG_OUTPKTERR6OUT_WIDTH    1

/* BACK2BACKSETUP6OUT */
#define REG_BACK2BACKSETUP6OUT          0x00bc8
#define REG_BACK2BACKSETUP6OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP6OUT_SHIFT    6
#define REG_BACK2BACKSETUP6OUT_WIDTH    1

/* STSPHSERCVD6OUT */
#define REG_STSPHSERCVD6OUT          0x00bc8
#define REG_STSPHSERCVD6OUT_MASK     0x00000020
#define REG_STSPHSERCVD6OUT_SHIFT    5
#define REG_STSPHSERCVD6OUT_WIDTH    1

/* OUTTKNEPDIS6OUT */
#define REG_OUTTKNEPDIS6OUT          0x00bc8
#define REG_OUTTKNEPDIS6OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS6OUT_SHIFT    4
#define REG_OUTTKNEPDIS6OUT_WIDTH    1

/* SETUP6OUT */
#define REG_SETUP6OUT          0x00bc8
#define REG_SETUP6OUT_MASK     0x00000008
#define REG_SETUP6OUT_SHIFT    3
#define REG_SETUP6OUT_WIDTH    1

/* AHBERR6OUT */
#define REG_AHBERR6OUT          0x00bc8
#define REG_AHBERR6OUT_MASK     0x00000004
#define REG_AHBERR6OUT_SHIFT    2
#define REG_AHBERR6OUT_WIDTH    1

/* EPDISBLD6OUT */
#define REG_EPDISBLD6OUT          0x00bc8
#define REG_EPDISBLD6OUT_MASK     0x00000002
#define REG_EPDISBLD6OUT_SHIFT    1
#define REG_EPDISBLD6OUT_WIDTH    1

/* XFERCOMPL6OUT */
#define REG_XFERCOMPL6OUT          0x00bc8
#define REG_XFERCOMPL6OUT_MASK     0x00000001
#define REG_XFERCOMPL6OUT_SHIFT    0
#define REG_XFERCOMPL6OUT_WIDTH    1

/* RXDPID6OUT */
#define REG_RXDPID6OUT          0x00bd0
#define REG_RXDPID6OUT_MASK     0x60000000
#define REG_RXDPID6OUT_SHIFT    29
#define REG_RXDPID6OUT_WIDTH    2

/* PKTCNT6OUT */
#define REG_PKTCNT6OUT          0x00bd0
#define REG_PKTCNT6OUT_MASK     0x1ff80000
#define REG_PKTCNT6OUT_SHIFT    19
#define REG_PKTCNT6OUT_WIDTH    10

/* XFERSIZE6OUT */
#define REG_XFERSIZE6OUT          0x00bd0
#define REG_XFERSIZE6OUT_MASK     0x0007ffff
#define REG_XFERSIZE6OUT_SHIFT    0
#define REG_XFERSIZE6OUT_WIDTH    19

/* DOEPDMA6OUT */
#define REG_DOEPDMA6OUT          0x00bd4
#define REG_DOEPDMA6OUT_MASK     0xffffffff
#define REG_DOEPDMA6OUT_SHIFT    0
#define REG_DOEPDMA6OUT_WIDTH    32

/* DOEPDMAB6OUT */
#define REG_DOEPDMAB6OUT          0x00bdc
#define REG_DOEPDMAB6OUT_MASK     0xffffffff
#define REG_DOEPDMAB6OUT_SHIFT    0
#define REG_DOEPDMAB6OUT_WIDTH    32

/* EPENA7OUT */
#define REG_EPENA7OUT          0x00be0
#define REG_EPENA7OUT_MASK     0x80000000
#define REG_EPENA7OUT_SHIFT    31
#define REG_EPENA7OUT_WIDTH    1

/* EPDIS7OUT */
#define REG_EPDIS7OUT          0x00be0
#define REG_EPDIS7OUT_MASK     0x40000000
#define REG_EPDIS7OUT_SHIFT    30
#define REG_EPDIS7OUT_WIDTH    1

/* STALL7OUT */
#define REG_STALL7OUT          0x00be0
#define REG_STALL7OUT_MASK     0x00200000
#define REG_STALL7OUT_SHIFT    21
#define REG_STALL7OUT_WIDTH    1

/* SNP7OUT */
#define REG_SNP7OUT          0x00be0
#define REG_SNP7OUT_MASK     0x00100000
#define REG_SNP7OUT_SHIFT    20
#define REG_SNP7OUT_WIDTH    1

/* EPTYPE7OUT */
#define REG_EPTYPE7OUT          0x00be0
#define REG_EPTYPE7OUT_MASK     0x000c0000
#define REG_EPTYPE7OUT_SHIFT    18
#define REG_EPTYPE7OUT_WIDTH    2

/* NAKSTS7OUT */
#define REG_NAKSTS7OUT          0x00be0
#define REG_NAKSTS7OUT_MASK     0x00020000
#define REG_NAKSTS7OUT_SHIFT    17
#define REG_NAKSTS7OUT_WIDTH    1

/* DPID7OUT */
#define REG_DPID7OUT          0x00be0
#define REG_DPID7OUT_MASK     0x00010000
#define REG_DPID7OUT_SHIFT    16
#define REG_DPID7OUT_WIDTH    1

/* USBACTEPCTL7OUT */
#define REG_USBACTEPCTL7OUT          0x00be0
#define REG_USBACTEPCTL7OUT_MASK     0x00008000
#define REG_USBACTEPCTL7OUT_SHIFT    15
#define REG_USBACTEPCTL7OUT_WIDTH    1

/* MPS7OUT */
#define REG_MPS7OUT          0x00be0
#define REG_MPS7OUT_MASK     0x000007ff
#define REG_MPS7OUT_SHIFT    0
#define REG_MPS7OUT_WIDTH    11

/* SETD1PID7OUT */
#define REG_SETD1PID7OUT          0x00be0
#define REG_SETD1PID7OUT_MASK     0x20000000
#define REG_SETD1PID7OUT_SHIFT    29
#define REG_SETD1PID7OUT_WIDTH    1

/* SETD0PID7OUT */
#define REG_SETD0PID7OUT          0x00be0
#define REG_SETD0PID7OUT_MASK     0x10000000
#define REG_SETD0PID7OUT_SHIFT    28
#define REG_SETD0PID7OUT_WIDTH    1

/* SNAK7OUT */
#define REG_SNAK7OUT          0x00be0
#define REG_SNAK7OUT_MASK     0x08000000
#define REG_SNAK7OUT_SHIFT    27
#define REG_SNAK7OUT_WIDTH    1

/* CNAK7OUT */
#define REG_CNAK7OUT          0x00be0
#define REG_CNAK7OUT_MASK     0x04000000
#define REG_CNAK7OUT_SHIFT    26
#define REG_CNAK7OUT_WIDTH    1

/* NYETINTRPT7OUT */
#define REG_NYETINTRPT7OUT          0x00be8
#define REG_NYETINTRPT7OUT_MASK     0x00004000
#define REG_NYETINTRPT7OUT_SHIFT    14
#define REG_NYETINTRPT7OUT_WIDTH    1

/* NAKINTRPT7OUT */
#define REG_NAKINTRPT7OUT          0x00be8
#define REG_NAKINTRPT7OUT_MASK     0x00002000
#define REG_NAKINTRPT7OUT_SHIFT    13
#define REG_NAKINTRPT7OUT_WIDTH    1

/* BBLEERR7OUT */
#define REG_BBLEERR7OUT          0x00be8
#define REG_BBLEERR7OUT_MASK     0x00001000
#define REG_BBLEERR7OUT_SHIFT    12
#define REG_BBLEERR7OUT_WIDTH    1

/* PKTDRPSTS7OUT */
#define REG_PKTDRPSTS7OUT          0x00be8
#define REG_PKTDRPSTS7OUT_MASK     0x00000800
#define REG_PKTDRPSTS7OUT_SHIFT    11
#define REG_PKTDRPSTS7OUT_WIDTH    1

/* BNAINTR7OUT */
#define REG_BNAINTR7OUT          0x00be8
#define REG_BNAINTR7OUT_MASK     0x00000200
#define REG_BNAINTR7OUT_SHIFT    9
#define REG_BNAINTR7OUT_WIDTH    1

/* OUTPKTERR7OUT */
#define REG_OUTPKTERR7OUT          0x00be8
#define REG_OUTPKTERR7OUT_MASK     0x00000100
#define REG_OUTPKTERR7OUT_SHIFT    8
#define REG_OUTPKTERR7OUT_WIDTH    1

/* BACK2BACKSETUP7OUT */
#define REG_BACK2BACKSETUP7OUT          0x00be8
#define REG_BACK2BACKSETUP7OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP7OUT_SHIFT    6
#define REG_BACK2BACKSETUP7OUT_WIDTH    1

/* STSPHSERCVD7OUT */
#define REG_STSPHSERCVD7OUT          0x00be8
#define REG_STSPHSERCVD7OUT_MASK     0x00000020
#define REG_STSPHSERCVD7OUT_SHIFT    5
#define REG_STSPHSERCVD7OUT_WIDTH    1

/* OUTTKNEPDIS7OUT */
#define REG_OUTTKNEPDIS7OUT          0x00be8
#define REG_OUTTKNEPDIS7OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS7OUT_SHIFT    4
#define REG_OUTTKNEPDIS7OUT_WIDTH    1

/* SETUP7OUT */
#define REG_SETUP7OUT          0x00be8
#define REG_SETUP7OUT_MASK     0x00000008
#define REG_SETUP7OUT_SHIFT    3
#define REG_SETUP7OUT_WIDTH    1

/* AHBERR7OUT */
#define REG_AHBERR7OUT          0x00be8
#define REG_AHBERR7OUT_MASK     0x00000004
#define REG_AHBERR7OUT_SHIFT    2
#define REG_AHBERR7OUT_WIDTH    1

/* EPDISBLD7OUT */
#define REG_EPDISBLD7OUT          0x00be8
#define REG_EPDISBLD7OUT_MASK     0x00000002
#define REG_EPDISBLD7OUT_SHIFT    1
#define REG_EPDISBLD7OUT_WIDTH    1

/* XFERCOMPL7OUT */
#define REG_XFERCOMPL7OUT          0x00be8
#define REG_XFERCOMPL7OUT_MASK     0x00000001
#define REG_XFERCOMPL7OUT_SHIFT    0
#define REG_XFERCOMPL7OUT_WIDTH    1

/* RXDPID7OUT */
#define REG_RXDPID7OUT          0x00bf0
#define REG_RXDPID7OUT_MASK     0x60000000
#define REG_RXDPID7OUT_SHIFT    29
#define REG_RXDPID7OUT_WIDTH    2

/* PKTCNT7OUT */
#define REG_PKTCNT7OUT          0x00bf0
#define REG_PKTCNT7OUT_MASK     0x1ff80000
#define REG_PKTCNT7OUT_SHIFT    19
#define REG_PKTCNT7OUT_WIDTH    10

/* XFERSIZE7OUT */
#define REG_XFERSIZE7OUT          0x00bf0
#define REG_XFERSIZE7OUT_MASK     0x0007ffff
#define REG_XFERSIZE7OUT_SHIFT    0
#define REG_XFERSIZE7OUT_WIDTH    19

/* DOEPDMA7OUT */
#define REG_DOEPDMA7OUT          0x00bf4
#define REG_DOEPDMA7OUT_MASK     0xffffffff
#define REG_DOEPDMA7OUT_SHIFT    0
#define REG_DOEPDMA7OUT_WIDTH    32

/* DOEPDMAB7OUT */
#define REG_DOEPDMAB7OUT          0x00bfc
#define REG_DOEPDMAB7OUT_MASK     0xffffffff
#define REG_DOEPDMAB7OUT_SHIFT    0
#define REG_DOEPDMAB7OUT_WIDTH    32

/* EPENA8OUT */
#define REG_EPENA8OUT          0x00c00
#define REG_EPENA8OUT_MASK     0x80000000
#define REG_EPENA8OUT_SHIFT    31
#define REG_EPENA8OUT_WIDTH    1

/* EPDIS8OUT */
#define REG_EPDIS8OUT          0x00c00
#define REG_EPDIS8OUT_MASK     0x40000000
#define REG_EPDIS8OUT_SHIFT    30
#define REG_EPDIS8OUT_WIDTH    1

/* STALL8OUT */
#define REG_STALL8OUT          0x00c00
#define REG_STALL8OUT_MASK     0x00200000
#define REG_STALL8OUT_SHIFT    21
#define REG_STALL8OUT_WIDTH    1

/* SNP8OUT */
#define REG_SNP8OUT          0x00c00
#define REG_SNP8OUT_MASK     0x00100000
#define REG_SNP8OUT_SHIFT    20
#define REG_SNP8OUT_WIDTH    1

/* EPTYPE8OUT */
#define REG_EPTYPE8OUT          0x00c00
#define REG_EPTYPE8OUT_MASK     0x000c0000
#define REG_EPTYPE8OUT_SHIFT    18
#define REG_EPTYPE8OUT_WIDTH    2

/* NAKSTS8OUT */
#define REG_NAKSTS8OUT          0x00c00
#define REG_NAKSTS8OUT_MASK     0x00020000
#define REG_NAKSTS8OUT_SHIFT    17
#define REG_NAKSTS8OUT_WIDTH    1

/* DPID8OUT */
#define REG_DPID8OUT          0x00c00
#define REG_DPID8OUT_MASK     0x00010000
#define REG_DPID8OUT_SHIFT    16
#define REG_DPID8OUT_WIDTH    1

/* USBACTEPCTL8OUT */
#define REG_USBACTEPCTL8OUT          0x00c00
#define REG_USBACTEPCTL8OUT_MASK     0x00008000
#define REG_USBACTEPCTL8OUT_SHIFT    15
#define REG_USBACTEPCTL8OUT_WIDTH    1

/* MPS8OUT */
#define REG_MPS8OUT          0x00c00
#define REG_MPS8OUT_MASK     0x000007ff
#define REG_MPS8OUT_SHIFT    0
#define REG_MPS8OUT_WIDTH    11

/* SETD1PID8OUT */
#define REG_SETD1PID8OUT          0x00c00
#define REG_SETD1PID8OUT_MASK     0x20000000
#define REG_SETD1PID8OUT_SHIFT    29
#define REG_SETD1PID8OUT_WIDTH    1

/* SETD0PID8OUT */
#define REG_SETD0PID8OUT          0x00c00
#define REG_SETD0PID8OUT_MASK     0x10000000
#define REG_SETD0PID8OUT_SHIFT    28
#define REG_SETD0PID8OUT_WIDTH    1

/* SNAK8OUT */
#define REG_SNAK8OUT          0x00c00
#define REG_SNAK8OUT_MASK     0x08000000
#define REG_SNAK8OUT_SHIFT    27
#define REG_SNAK8OUT_WIDTH    1

/* CNAK8OUT */
#define REG_CNAK8OUT          0x00c00
#define REG_CNAK8OUT_MASK     0x04000000
#define REG_CNAK8OUT_SHIFT    26
#define REG_CNAK8OUT_WIDTH    1

/* NYETINTRPT8OUT */
#define REG_NYETINTRPT8OUT          0x00c08
#define REG_NYETINTRPT8OUT_MASK     0x00004000
#define REG_NYETINTRPT8OUT_SHIFT    14
#define REG_NYETINTRPT8OUT_WIDTH    1

/* NAKINTRPT8OUT */
#define REG_NAKINTRPT8OUT          0x00c08
#define REG_NAKINTRPT8OUT_MASK     0x00002000
#define REG_NAKINTRPT8OUT_SHIFT    13
#define REG_NAKINTRPT8OUT_WIDTH    1

/* BBLEERR8OUT */
#define REG_BBLEERR8OUT          0x00c08
#define REG_BBLEERR8OUT_MASK     0x00001000
#define REG_BBLEERR8OUT_SHIFT    12
#define REG_BBLEERR8OUT_WIDTH    1

/* PKTDRPSTS8OUT */
#define REG_PKTDRPSTS8OUT          0x00c08
#define REG_PKTDRPSTS8OUT_MASK     0x00000800
#define REG_PKTDRPSTS8OUT_SHIFT    11
#define REG_PKTDRPSTS8OUT_WIDTH    1

/* BNAINTR8OUT */
#define REG_BNAINTR8OUT          0x00c08
#define REG_BNAINTR8OUT_MASK     0x00000200
#define REG_BNAINTR8OUT_SHIFT    9
#define REG_BNAINTR8OUT_WIDTH    1

/* OUTPKTERR8OUT */
#define REG_OUTPKTERR8OUT          0x00c08
#define REG_OUTPKTERR8OUT_MASK     0x00000100
#define REG_OUTPKTERR8OUT_SHIFT    8
#define REG_OUTPKTERR8OUT_WIDTH    1

/* BACK2BACKSETUP8OUT */
#define REG_BACK2BACKSETUP8OUT          0x00c08
#define REG_BACK2BACKSETUP8OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP8OUT_SHIFT    6
#define REG_BACK2BACKSETUP8OUT_WIDTH    1

/* STSPHSERCVD8OUT */
#define REG_STSPHSERCVD8OUT          0x00c08
#define REG_STSPHSERCVD8OUT_MASK     0x00000020
#define REG_STSPHSERCVD8OUT_SHIFT    5
#define REG_STSPHSERCVD8OUT_WIDTH    1

/* OUTTKNEPDIS8OUT */
#define REG_OUTTKNEPDIS8OUT          0x00c08
#define REG_OUTTKNEPDIS8OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS8OUT_SHIFT    4
#define REG_OUTTKNEPDIS8OUT_WIDTH    1

/* SETUP8OUT */
#define REG_SETUP8OUT          0x00c08
#define REG_SETUP8OUT_MASK     0x00000008
#define REG_SETUP8OUT_SHIFT    3
#define REG_SETUP8OUT_WIDTH    1

/* AHBERR8OUT */
#define REG_AHBERR8OUT          0x00c08
#define REG_AHBERR8OUT_MASK     0x00000004
#define REG_AHBERR8OUT_SHIFT    2
#define REG_AHBERR8OUT_WIDTH    1

/* EPDISBLD8OUT */
#define REG_EPDISBLD8OUT          0x00c08
#define REG_EPDISBLD8OUT_MASK     0x00000002
#define REG_EPDISBLD8OUT_SHIFT    1
#define REG_EPDISBLD8OUT_WIDTH    1

/* XFERCOMPL8OUT */
#define REG_XFERCOMPL8OUT          0x00c08
#define REG_XFERCOMPL8OUT_MASK     0x00000001
#define REG_XFERCOMPL8OUT_SHIFT    0
#define REG_XFERCOMPL8OUT_WIDTH    1

/* RXDPID8OUT */
#define REG_RXDPID8OUT          0x00c10
#define REG_RXDPID8OUT_MASK     0x60000000
#define REG_RXDPID8OUT_SHIFT    29
#define REG_RXDPID8OUT_WIDTH    2

/* PKTCNT8OUT */
#define REG_PKTCNT8OUT          0x00c10
#define REG_PKTCNT8OUT_MASK     0x1ff80000
#define REG_PKTCNT8OUT_SHIFT    19
#define REG_PKTCNT8OUT_WIDTH    10

/* XFERSIZE8OUT */
#define REG_XFERSIZE8OUT          0x00c10
#define REG_XFERSIZE8OUT_MASK     0x0007ffff
#define REG_XFERSIZE8OUT_SHIFT    0
#define REG_XFERSIZE8OUT_WIDTH    19

/* DOEPDMA8OUT */
#define REG_DOEPDMA8OUT          0x00c14
#define REG_DOEPDMA8OUT_MASK     0xffffffff
#define REG_DOEPDMA8OUT_SHIFT    0
#define REG_DOEPDMA8OUT_WIDTH    32

/* DOEPDMAB8OUT */
#define REG_DOEPDMAB8OUT          0x00c1c
#define REG_DOEPDMAB8OUT_MASK     0xffffffff
#define REG_DOEPDMAB8OUT_SHIFT    0
#define REG_DOEPDMAB8OUT_WIDTH    32

/* EPENA9OUT */
#define REG_EPENA9OUT          0x00c20
#define REG_EPENA9OUT_MASK     0x80000000
#define REG_EPENA9OUT_SHIFT    31
#define REG_EPENA9OUT_WIDTH    1

/* EPDIS9OUT */
#define REG_EPDIS9OUT          0x00c20
#define REG_EPDIS9OUT_MASK     0x40000000
#define REG_EPDIS9OUT_SHIFT    30
#define REG_EPDIS9OUT_WIDTH    1

/* STALL9OUT */
#define REG_STALL9OUT          0x00c20
#define REG_STALL9OUT_MASK     0x00200000
#define REG_STALL9OUT_SHIFT    21
#define REG_STALL9OUT_WIDTH    1

/* SNP9OUT */
#define REG_SNP9OUT          0x00c20
#define REG_SNP9OUT_MASK     0x00100000
#define REG_SNP9OUT_SHIFT    20
#define REG_SNP9OUT_WIDTH    1

/* EPTYPE9OUT */
#define REG_EPTYPE9OUT          0x00c20
#define REG_EPTYPE9OUT_MASK     0x000c0000
#define REG_EPTYPE9OUT_SHIFT    18
#define REG_EPTYPE9OUT_WIDTH    2

/* NAKSTS9OUT */
#define REG_NAKSTS9OUT          0x00c20
#define REG_NAKSTS9OUT_MASK     0x00020000
#define REG_NAKSTS9OUT_SHIFT    17
#define REG_NAKSTS9OUT_WIDTH    1

/* DPID9OUT */
#define REG_DPID9OUT          0x00c20
#define REG_DPID9OUT_MASK     0x00010000
#define REG_DPID9OUT_SHIFT    16
#define REG_DPID9OUT_WIDTH    1

/* USBACTEPCTL9OUT */
#define REG_USBACTEPCTL9OUT          0x00c20
#define REG_USBACTEPCTL9OUT_MASK     0x00008000
#define REG_USBACTEPCTL9OUT_SHIFT    15
#define REG_USBACTEPCTL9OUT_WIDTH    1

/* MPS9OUT */
#define REG_MPS9OUT          0x00c20
#define REG_MPS9OUT_MASK     0x000007ff
#define REG_MPS9OUT_SHIFT    0
#define REG_MPS9OUT_WIDTH    11

/* SETD1PID9OUT */
#define REG_SETD1PID9OUT          0x00c20
#define REG_SETD1PID9OUT_MASK     0x20000000
#define REG_SETD1PID9OUT_SHIFT    29
#define REG_SETD1PID9OUT_WIDTH    1

/* SETD0PID9OUT */
#define REG_SETD0PID9OUT          0x00c20
#define REG_SETD0PID9OUT_MASK     0x10000000
#define REG_SETD0PID9OUT_SHIFT    28
#define REG_SETD0PID9OUT_WIDTH    1

/* SNAK9OUT */
#define REG_SNAK9OUT          0x00c20
#define REG_SNAK9OUT_MASK     0x08000000
#define REG_SNAK9OUT_SHIFT    27
#define REG_SNAK9OUT_WIDTH    1

/* CNAK9OUT */
#define REG_CNAK9OUT          0x00c20
#define REG_CNAK9OUT_MASK     0x04000000
#define REG_CNAK9OUT_SHIFT    26
#define REG_CNAK9OUT_WIDTH    1

/* NYETINTRPT9OUT */
#define REG_NYETINTRPT9OUT          0x00c28
#define REG_NYETINTRPT9OUT_MASK     0x00004000
#define REG_NYETINTRPT9OUT_SHIFT    14
#define REG_NYETINTRPT9OUT_WIDTH    1

/* NAKINTRPT9OUT */
#define REG_NAKINTRPT9OUT          0x00c28
#define REG_NAKINTRPT9OUT_MASK     0x00002000
#define REG_NAKINTRPT9OUT_SHIFT    13
#define REG_NAKINTRPT9OUT_WIDTH    1

/* BBLEERR9OUT */
#define REG_BBLEERR9OUT          0x00c28
#define REG_BBLEERR9OUT_MASK     0x00001000
#define REG_BBLEERR9OUT_SHIFT    12
#define REG_BBLEERR9OUT_WIDTH    1

/* PKTDRPSTS9OUT */
#define REG_PKTDRPSTS9OUT          0x00c28
#define REG_PKTDRPSTS9OUT_MASK     0x00000800
#define REG_PKTDRPSTS9OUT_SHIFT    11
#define REG_PKTDRPSTS9OUT_WIDTH    1

/* BNAINTR9OUT */
#define REG_BNAINTR9OUT          0x00c28
#define REG_BNAINTR9OUT_MASK     0x00000200
#define REG_BNAINTR9OUT_SHIFT    9
#define REG_BNAINTR9OUT_WIDTH    1

/* OUTPKTERR9OUT */
#define REG_OUTPKTERR9OUT          0x00c28
#define REG_OUTPKTERR9OUT_MASK     0x00000100
#define REG_OUTPKTERR9OUT_SHIFT    8
#define REG_OUTPKTERR9OUT_WIDTH    1

/* BACK2BACKSETUP9OUT */
#define REG_BACK2BACKSETUP9OUT          0x00c28
#define REG_BACK2BACKSETUP9OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP9OUT_SHIFT    6
#define REG_BACK2BACKSETUP9OUT_WIDTH    1

/* STSPHSERCVD9OUT */
#define REG_STSPHSERCVD9OUT          0x00c28
#define REG_STSPHSERCVD9OUT_MASK     0x00000020
#define REG_STSPHSERCVD9OUT_SHIFT    5
#define REG_STSPHSERCVD9OUT_WIDTH    1

/* OUTTKNEPDIS9OUT */
#define REG_OUTTKNEPDIS9OUT          0x00c28
#define REG_OUTTKNEPDIS9OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS9OUT_SHIFT    4
#define REG_OUTTKNEPDIS9OUT_WIDTH    1

/* SETUP9OUT */
#define REG_SETUP9OUT          0x00c28
#define REG_SETUP9OUT_MASK     0x00000008
#define REG_SETUP9OUT_SHIFT    3
#define REG_SETUP9OUT_WIDTH    1

/* AHBERR9OUT */
#define REG_AHBERR9OUT          0x00c28
#define REG_AHBERR9OUT_MASK     0x00000004
#define REG_AHBERR9OUT_SHIFT    2
#define REG_AHBERR9OUT_WIDTH    1

/* EPDISBLD9OUT */
#define REG_EPDISBLD9OUT          0x00c28
#define REG_EPDISBLD9OUT_MASK     0x00000002
#define REG_EPDISBLD9OUT_SHIFT    1
#define REG_EPDISBLD9OUT_WIDTH    1

/* XFERCOMPL9OUT */
#define REG_XFERCOMPL9OUT          0x00c28
#define REG_XFERCOMPL9OUT_MASK     0x00000001
#define REG_XFERCOMPL9OUT_SHIFT    0
#define REG_XFERCOMPL9OUT_WIDTH    1

/* RXDPID9OUT */
#define REG_RXDPID9OUT          0x00c30
#define REG_RXDPID9OUT_MASK     0x60000000
#define REG_RXDPID9OUT_SHIFT    29
#define REG_RXDPID9OUT_WIDTH    2

/* PKTCNT9OUT */
#define REG_PKTCNT9OUT          0x00c30
#define REG_PKTCNT9OUT_MASK     0x1ff80000
#define REG_PKTCNT9OUT_SHIFT    19
#define REG_PKTCNT9OUT_WIDTH    10

/* XFERSIZE9OUT */
#define REG_XFERSIZE9OUT          0x00c30
#define REG_XFERSIZE9OUT_MASK     0x0007ffff
#define REG_XFERSIZE9OUT_SHIFT    0
#define REG_XFERSIZE9OUT_WIDTH    19

/* DOEPDMA9OUT */
#define REG_DOEPDMA9OUT          0x00c34
#define REG_DOEPDMA9OUT_MASK     0xffffffff
#define REG_DOEPDMA9OUT_SHIFT    0
#define REG_DOEPDMA9OUT_WIDTH    32

/* DOEPDMAB9OUT */
#define REG_DOEPDMAB9OUT          0x00c3c
#define REG_DOEPDMAB9OUT_MASK     0xffffffff
#define REG_DOEPDMAB9OUT_SHIFT    0
#define REG_DOEPDMAB9OUT_WIDTH    32

/* EPENA10OUT */
#define REG_EPENA10OUT          0x00c40
#define REG_EPENA10OUT_MASK     0x80000000
#define REG_EPENA10OUT_SHIFT    31
#define REG_EPENA10OUT_WIDTH    1

/* EPDIS10OUT */
#define REG_EPDIS10OUT          0x00c40
#define REG_EPDIS10OUT_MASK     0x40000000
#define REG_EPDIS10OUT_SHIFT    30
#define REG_EPDIS10OUT_WIDTH    1

/* STALL10OUT */
#define REG_STALL10OUT          0x00c40
#define REG_STALL10OUT_MASK     0x00200000
#define REG_STALL10OUT_SHIFT    21
#define REG_STALL10OUT_WIDTH    1

/* SNP10OUT */
#define REG_SNP10OUT          0x00c40
#define REG_SNP10OUT_MASK     0x00100000
#define REG_SNP10OUT_SHIFT    20
#define REG_SNP10OUT_WIDTH    1

/* EPTYPE10OUT */
#define REG_EPTYPE10OUT          0x00c40
#define REG_EPTYPE10OUT_MASK     0x000c0000
#define REG_EPTYPE10OUT_SHIFT    18
#define REG_EPTYPE10OUT_WIDTH    2

/* NAKSTS10OUT */
#define REG_NAKSTS10OUT          0x00c40
#define REG_NAKSTS10OUT_MASK     0x00020000
#define REG_NAKSTS10OUT_SHIFT    17
#define REG_NAKSTS10OUT_WIDTH    1

/* DPID10OUT */
#define REG_DPID10OUT          0x00c40
#define REG_DPID10OUT_MASK     0x00010000
#define REG_DPID10OUT_SHIFT    16
#define REG_DPID10OUT_WIDTH    1

/* USBACTEPCTL10OUT */
#define REG_USBACTEPCTL10OUT          0x00c40
#define REG_USBACTEPCTL10OUT_MASK     0x00008000
#define REG_USBACTEPCTL10OUT_SHIFT    15
#define REG_USBACTEPCTL10OUT_WIDTH    1

/* MPS10OUT */
#define REG_MPS10OUT          0x00c40
#define REG_MPS10OUT_MASK     0x000007ff
#define REG_MPS10OUT_SHIFT    0
#define REG_MPS10OUT_WIDTH    11

/* SETD1PID10OUT */
#define REG_SETD1PID10OUT          0x00c40
#define REG_SETD1PID10OUT_MASK     0x20000000
#define REG_SETD1PID10OUT_SHIFT    29
#define REG_SETD1PID10OUT_WIDTH    1

/* SETD0PID10OUT */
#define REG_SETD0PID10OUT          0x00c40
#define REG_SETD0PID10OUT_MASK     0x10000000
#define REG_SETD0PID10OUT_SHIFT    28
#define REG_SETD0PID10OUT_WIDTH    1

/* SNAK10OUT */
#define REG_SNAK10OUT          0x00c40
#define REG_SNAK10OUT_MASK     0x08000000
#define REG_SNAK10OUT_SHIFT    27
#define REG_SNAK10OUT_WIDTH    1

/* CNAK10OUT */
#define REG_CNAK10OUT          0x00c40
#define REG_CNAK10OUT_MASK     0x04000000
#define REG_CNAK10OUT_SHIFT    26
#define REG_CNAK10OUT_WIDTH    1

/* NYETINTRPT10OUT */
#define REG_NYETINTRPT10OUT          0x00c48
#define REG_NYETINTRPT10OUT_MASK     0x00004000
#define REG_NYETINTRPT10OUT_SHIFT    14
#define REG_NYETINTRPT10OUT_WIDTH    1

/* NAKINTRPT10OUT */
#define REG_NAKINTRPT10OUT          0x00c48
#define REG_NAKINTRPT10OUT_MASK     0x00002000
#define REG_NAKINTRPT10OUT_SHIFT    13
#define REG_NAKINTRPT10OUT_WIDTH    1

/* BBLEERR10OUT */
#define REG_BBLEERR10OUT          0x00c48
#define REG_BBLEERR10OUT_MASK     0x00001000
#define REG_BBLEERR10OUT_SHIFT    12
#define REG_BBLEERR10OUT_WIDTH    1

/* PKTDRPSTS10OUT */
#define REG_PKTDRPSTS10OUT          0x00c48
#define REG_PKTDRPSTS10OUT_MASK     0x00000800
#define REG_PKTDRPSTS10OUT_SHIFT    11
#define REG_PKTDRPSTS10OUT_WIDTH    1

/* BNAINTR10OUT */
#define REG_BNAINTR10OUT          0x00c48
#define REG_BNAINTR10OUT_MASK     0x00000200
#define REG_BNAINTR10OUT_SHIFT    9
#define REG_BNAINTR10OUT_WIDTH    1

/* OUTPKTERR10OUT */
#define REG_OUTPKTERR10OUT          0x00c48
#define REG_OUTPKTERR10OUT_MASK     0x00000100
#define REG_OUTPKTERR10OUT_SHIFT    8
#define REG_OUTPKTERR10OUT_WIDTH    1

/* BACK2BACKSETUP10OUT */
#define REG_BACK2BACKSETUP10OUT          0x00c48
#define REG_BACK2BACKSETUP10OUT_MASK     0x00000040
#define REG_BACK2BACKSETUP10OUT_SHIFT    6
#define REG_BACK2BACKSETUP10OUT_WIDTH    1

/* STSPHSERCVD10OUT */
#define REG_STSPHSERCVD10OUT          0x00c48
#define REG_STSPHSERCVD10OUT_MASK     0x00000020
#define REG_STSPHSERCVD10OUT_SHIFT    5
#define REG_STSPHSERCVD10OUT_WIDTH    1

/* OUTTKNEPDIS10OUT */
#define REG_OUTTKNEPDIS10OUT          0x00c48
#define REG_OUTTKNEPDIS10OUT_MASK     0x00000010
#define REG_OUTTKNEPDIS10OUT_SHIFT    4
#define REG_OUTTKNEPDIS10OUT_WIDTH    1

/* SETUP10OUT */
#define REG_SETUP10OUT          0x00c48
#define REG_SETUP10OUT_MASK     0x00000008
#define REG_SETUP10OUT_SHIFT    3
#define REG_SETUP10OUT_WIDTH    1

/* AHBERR10OUT */
#define REG_AHBERR10OUT          0x00c48
#define REG_AHBERR10OUT_MASK     0x00000004
#define REG_AHBERR10OUT_SHIFT    2
#define REG_AHBERR10OUT_WIDTH    1

/* EPDISBLD10OUT */
#define REG_EPDISBLD10OUT          0x00c48
#define REG_EPDISBLD10OUT_MASK     0x00000002
#define REG_EPDISBLD10OUT_SHIFT    1
#define REG_EPDISBLD10OUT_WIDTH    1

/* XFERCOMPL10OUT */
#define REG_XFERCOMPL10OUT          0x00c48
#define REG_XFERCOMPL10OUT_MASK     0x00000001
#define REG_XFERCOMPL10OUT_SHIFT    0
#define REG_XFERCOMPL10OUT_WIDTH    1

/* RXDPID10OUT */
#define REG_RXDPID10OUT          0x00c50
#define REG_RXDPID10OUT_MASK     0x60000000
#define REG_RXDPID10OUT_SHIFT    29
#define REG_RXDPID10OUT_WIDTH    2

/* PKTCNT10OUT */
#define REG_PKTCNT10OUT          0x00c50
#define REG_PKTCNT10OUT_MASK     0x1ff80000
#define REG_PKTCNT10OUT_SHIFT    19
#define REG_PKTCNT10OUT_WIDTH    10

/* XFERSIZE10OUT */
#define REG_XFERSIZE10OUT          0x00c50
#define REG_XFERSIZE10OUT_MASK     0x0007ffff
#define REG_XFERSIZE10OUT_SHIFT    0
#define REG_XFERSIZE10OUT_WIDTH    19

/* DOEPDMA10OUT */
#define REG_DOEPDMA10OUT          0x00c54
#define REG_DOEPDMA10OUT_MASK     0xffffffff
#define REG_DOEPDMA10OUT_SHIFT    0
#define REG_DOEPDMA10OUT_WIDTH    32

/* DOEPDMAB10OUT */
#define REG_DOEPDMAB10OUT          0x00c5c
#define REG_DOEPDMAB10OUT_MASK     0xffffffff
#define REG_DOEPDMAB10OUT_SHIFT    0
#define REG_DOEPDMAB10OUT_WIDTH    32

/* DOEPDMAB11 */
#define REG_DOEPDMAB11          0x00c7c
#define REG_DOEPDMAB11_MASK     0xffffffff
#define REG_DOEPDMAB11_SHIFT    0
#define REG_DOEPDMAB11_WIDTH    32

/* DOEPDMAB12 */
#define REG_DOEPDMAB12          0x00c9c
#define REG_DOEPDMAB12_MASK     0xffffffff
#define REG_DOEPDMAB12_SHIFT    0
#define REG_DOEPDMAB12_WIDTH    32

/* DOEPDMAB13 */
#define REG_DOEPDMAB13          0x00cbc
#define REG_DOEPDMAB13_MASK     0xffffffff
#define REG_DOEPDMAB13_SHIFT    0
#define REG_DOEPDMAB13_WIDTH    32

/* DOEPDMAB14 */
#define REG_DOEPDMAB14          0x00cdc
#define REG_DOEPDMAB14_MASK     0xffffffff
#define REG_DOEPDMAB14_SHIFT    0
#define REG_DOEPDMAB14_WIDTH    32

/* DOEPDMAB15 */
#define REG_DOEPDMAB15          0x00cfc
#define REG_DOEPDMAB15_MASK     0xffffffff
#define REG_DOEPDMAB15_SHIFT    0
#define REG_DOEPDMAB15_WIDTH    32

/* RESETAFTERSUSP */
#define REG_RESETAFTERSUSP          0x00e00
#define REG_RESETAFTERSUSP_MASK     0x00000100
#define REG_RESETAFTERSUSP_SHIFT    8
#define REG_RESETAFTERSUSP_WIDTH    1

/* L1SUSPENDED */
#define REG_L1SUSPENDED          0x00e00
#define REG_L1SUSPENDED_MASK     0x00000080
#define REG_L1SUSPENDED_SHIFT    7
#define REG_L1SUSPENDED_WIDTH    1

/* PHYSLEEP */
#define REG_PHYSLEEP          0x00e00
#define REG_PHYSLEEP_MASK     0x00000040
#define REG_PHYSLEEP_SHIFT    6
#define REG_PHYSLEEP_WIDTH    1

/* RSTPDWNMODULE */
#define REG_RSTPDWNMODULE          0x00e00
#define REG_RSTPDWNMODULE_MASK     0x00000008
#define REG_RSTPDWNMODULE_SHIFT    3
#define REG_RSTPDWNMODULE_WIDTH    1

/* PWRCLMP */
#define REG_PWRCLMP          0x00e00
#define REG_PWRCLMP_MASK     0x00000004
#define REG_PWRCLMP_SHIFT    2
#define REG_PWRCLMP_WIDTH    1

/* GATEHCLK */
#define REG_GATEHCLK          0x00e00
#define REG_GATEHCLK_MASK     0x00000002
#define REG_GATEHCLK_SHIFT    1
#define REG_GATEHCLK_WIDTH    1

/* STOPPCLK */
#define REG_STOPPCLK          0x00e00
#define REG_STOPPCLK_MASK     0x00000001
#define REG_STOPPCLK_SHIFT    0
#define REG_STOPPCLK_WIDTH    1
#endif 
