/*******************************************************************
*                                                                  
*  USB Host REGS.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef USB Host REGS_regs_H_FILE
#define USB Host REGS_regs_H_FILE

/* OTGVER */
#define REG_OTGVER          0x00000
#define REG_OTGVER_MASK     0x00100000
#define REG_OTGVER_SHIFT    20
#define REG_OTGVER_WIDTH    1

/* BSESVLD */
#define REG_BSESVLD          0x00000
#define REG_BSESVLD_MASK     0x00080000
#define REG_BSESVLD_SHIFT    19
#define REG_BSESVLD_WIDTH    1

/* ASESVLD */
#define REG_ASESVLD          0x00000
#define REG_ASESVLD_MASK     0x00040000
#define REG_ASESVLD_SHIFT    18
#define REG_ASESVLD_WIDTH    1

/* DBNCTIME */
#define REG_DBNCTIME          0x00000
#define REG_DBNCTIME_MASK     0x00020000
#define REG_DBNCTIME_SHIFT    17
#define REG_DBNCTIME_WIDTH    1

/* CONIDSTS */
#define REG_CONIDSTS          0x00000
#define REG_CONIDSTS_MASK     0x00010000
#define REG_CONIDSTS_SHIFT    16
#define REG_CONIDSTS_WIDTH    1

/* HSTNEGSCS */
#define REG_HSTNEGSCS          0x00000
#define REG_HSTNEGSCS_MASK     0x00000100
#define REG_HSTNEGSCS_SHIFT    8
#define REG_HSTNEGSCS_WIDTH    1

/* AVALIDOVVAL */
#define REG_AVALIDOVVAL          0x00000
#define REG_AVALIDOVVAL_MASK     0x00000080
#define REG_AVALIDOVVAL_SHIFT    7
#define REG_AVALIDOVVAL_WIDTH    1

/* AVALIDOVEN */
#define REG_AVALIDOVEN          0x00000
#define REG_AVALIDOVEN_MASK     0x00000040
#define REG_AVALIDOVEN_SHIFT    6
#define REG_AVALIDOVEN_WIDTH    1

/* BVALIDOVVAL */
#define REG_BVALIDOVVAL          0x00000
#define REG_BVALIDOVVAL_MASK     0x00000020
#define REG_BVALIDOVVAL_SHIFT    5
#define REG_BVALIDOVVAL_WIDTH    1

/* BVALIDOVEN */
#define REG_BVALIDOVEN          0x00000
#define REG_BVALIDOVEN_MASK     0x00000010
#define REG_BVALIDOVEN_SHIFT    4
#define REG_BVALIDOVEN_WIDTH    1

/* VBVALIDOVVAL */
#define REG_VBVALIDOVVAL          0x00000
#define REG_VBVALIDOVVAL_MASK     0x00000008
#define REG_VBVALIDOVVAL_SHIFT    3
#define REG_VBVALIDOVVAL_WIDTH    1

/* VBVALIDOVEN */
#define REG_VBVALIDOVEN          0x00000
#define REG_VBVALIDOVEN_MASK     0x00000004
#define REG_VBVALIDOVEN_SHIFT    2
#define REG_VBVALIDOVEN_WIDTH    1

/* SESREQ */
#define REG_SESREQ          0x00000
#define REG_SESREQ_MASK     0x00000002
#define REG_SESREQ_SHIFT    1
#define REG_SESREQ_WIDTH    1

/* SESREQSCS */
#define REG_SESREQSCS          0x00000
#define REG_SESREQSCS_MASK     0x00000001
#define REG_SESREQSCS_SHIFT    0
#define REG_SESREQSCS_WIDTH    1

/* DBNCEDONE */
#define REG_DBNCEDONE          0x00004
#define REG_DBNCEDONE_MASK     0x00080000
#define REG_DBNCEDONE_SHIFT    19
#define REG_DBNCEDONE_WIDTH    1

/* ADEVTOUTCHG */
#define REG_ADEVTOUTCHG          0x00004
#define REG_ADEVTOUTCHG_MASK     0x00040000
#define REG_ADEVTOUTCHG_SHIFT    18
#define REG_ADEVTOUTCHG_WIDTH    1

/* HSTNEGDET */
#define REG_HSTNEGDET          0x00004
#define REG_HSTNEGDET_MASK     0x00020000
#define REG_HSTNEGDET_SHIFT    17
#define REG_HSTNEGDET_WIDTH    1

/* HSTNEGSUCSTSCHNG */
#define REG_HSTNEGSUCSTSCHNG          0x00004
#define REG_HSTNEGSUCSTSCHNG_MASK     0x00000200
#define REG_HSTNEGSUCSTSCHNG_SHIFT    9
#define REG_HSTNEGSUCSTSCHNG_WIDTH    1

/* SESREQSUCSTSCHNG */
#define REG_SESREQSUCSTSCHNG          0x00004
#define REG_SESREQSUCSTSCHNG_MASK     0x00000100
#define REG_SESREQSUCSTSCHNG_SHIFT    8
#define REG_SESREQSUCSTSCHNG_WIDTH    1

/* SESENDDET */
#define REG_SESENDDET          0x00004
#define REG_SESENDDET_MASK     0x00000004
#define REG_SESENDDET_SHIFT    2
#define REG_SESENDDET_WIDTH    1

/* NOTIALLDMAWRIT */
#define REG_NOTIALLDMAWRIT          0x00008
#define REG_NOTIALLDMAWRIT_MASK     0x00400000
#define REG_NOTIALLDMAWRIT_SHIFT    22
#define REG_NOTIALLDMAWRIT_WIDTH    1

/* REMMEMSUPP */
#define REG_REMMEMSUPP          0x00008
#define REG_REMMEMSUPP_MASK     0x00200000
#define REG_REMMEMSUPP_SHIFT    21
#define REG_REMMEMSUPP_WIDTH    1

/* PTXFEMPLVL */
#define REG_PTXFEMPLVL          0x00008
#define REG_PTXFEMPLVL_MASK     0x00000100
#define REG_PTXFEMPLVL_SHIFT    8
#define REG_PTXFEMPLVL_WIDTH    1

/* NPTXFEMPLVL */
#define REG_NPTXFEMPLVL          0x00008
#define REG_NPTXFEMPLVL_MASK     0x00000080
#define REG_NPTXFEMPLVL_SHIFT    7
#define REG_NPTXFEMPLVL_WIDTH    1

/* DMAEN */
#define REG_DMAEN          0x00008
#define REG_DMAEN_MASK     0x00000020
#define REG_DMAEN_SHIFT    5
#define REG_DMAEN_WIDTH    1

/* HBSTLEN */
#define REG_HBSTLEN          0x00008
#define REG_HBSTLEN_MASK     0x0000001e
#define REG_HBSTLEN_SHIFT    1
#define REG_HBSTLEN_WIDTH    4

/* GLBLINTRMSK */
#define REG_GLBLINTRMSK          0x00008
#define REG_GLBLINTRMSK_MASK     0x00000001
#define REG_GLBLINTRMSK_SHIFT    0
#define REG_GLBLINTRMSK_WIDTH    1

/* FORCEDEVMODE */
#define REG_FORCEDEVMODE          0x0000c
#define REG_FORCEDEVMODE_MASK     0x40000000
#define REG_FORCEDEVMODE_SHIFT    30
#define REG_FORCEDEVMODE_WIDTH    1

/* FORCEHSTMODE */
#define REG_FORCEHSTMODE          0x0000c
#define REG_FORCEHSTMODE_MASK     0x20000000
#define REG_FORCEHSTMODE_SHIFT    29
#define REG_FORCEHSTMODE_WIDTH    1

/* TXENDDELAY */
#define REG_TXENDDELAY          0x0000c
#define REG_TXENDDELAY_MASK     0x10000000
#define REG_TXENDDELAY_SHIFT    28
#define REG_TXENDDELAY_WIDTH    1

/* IC_USBCAP */
#define REG_IC_USBCAP          0x0000c
#define REG_IC_USBCAP_MASK     0x04000000
#define REG_IC_USBCAP_SHIFT    26
#define REG_IC_USBCAP_WIDTH    1

/* TERMSELDLPULSE */
#define REG_TERMSELDLPULSE          0x0000c
#define REG_TERMSELDLPULSE_MASK     0x00400000
#define REG_TERMSELDLPULSE_SHIFT    22
#define REG_TERMSELDLPULSE_WIDTH    1

/* PHYLPWRCLKSEL */
#define REG_PHYLPWRCLKSEL          0x0000c
#define REG_PHYLPWRCLKSEL_MASK     0x00008000
#define REG_PHYLPWRCLKSEL_SHIFT    15
#define REG_PHYLPWRCLKSEL_WIDTH    1

/* USBTRDTIM */
#define REG_USBTRDTIM          0x0000c
#define REG_USBTRDTIM_MASK     0x00003c00
#define REG_USBTRDTIM_SHIFT    10
#define REG_USBTRDTIM_WIDTH    4

/* PHYSEL */
#define REG_PHYSEL          0x0000c
#define REG_PHYSEL_MASK     0x00000040
#define REG_PHYSEL_SHIFT    6
#define REG_PHYSEL_WIDTH    1

/* FSINTF */
#define REG_FSINTF          0x0000c
#define REG_FSINTF_MASK     0x00000020
#define REG_FSINTF_SHIFT    5
#define REG_FSINTF_WIDTH    1

/* ULPI_UTMI_SEL */
#define REG_ULPI_UTMI_SEL          0x0000c
#define REG_ULPI_UTMI_SEL_MASK     0x00000010
#define REG_ULPI_UTMI_SEL_SHIFT    4
#define REG_ULPI_UTMI_SEL_WIDTH    1

/* PHYIF */
#define REG_PHYIF          0x0000c
#define REG_PHYIF_MASK     0x00000008
#define REG_PHYIF_SHIFT    3
#define REG_PHYIF_WIDTH    1

/* TOUTCAL */
#define REG_TOUTCAL          0x0000c
#define REG_TOUTCAL_MASK     0x00000007
#define REG_TOUTCAL_SHIFT    0
#define REG_TOUTCAL_WIDTH    3

/* CORRUPTTXPKT */
#define REG_CORRUPTTXPKT          0x0000c
#define REG_CORRUPTTXPKT_MASK     0x80000000
#define REG_CORRUPTTXPKT_SHIFT    31
#define REG_CORRUPTTXPKT_WIDTH    1

/* AHBIDLE */
#define REG_AHBIDLE          0x00010
#define REG_AHBIDLE_MASK     0x80000000
#define REG_AHBIDLE_SHIFT    31
#define REG_AHBIDLE_WIDTH    1

/* DMAREQ */
#define REG_DMAREQ          0x00010
#define REG_DMAREQ_MASK     0x40000000
#define REG_DMAREQ_SHIFT    30
#define REG_DMAREQ_WIDTH    1

/* TXFNUM_GRSTCTL */
#define REG_TXFNUM_GRSTCTL          0x00010
#define REG_TXFNUM_GRSTCTL_MASK     0x000007c0
#define REG_TXFNUM_GRSTCTL_SHIFT    6
#define REG_TXFNUM_GRSTCTL_WIDTH    5

/* TXFFLSH */
#define REG_TXFFLSH          0x00010
#define REG_TXFFLSH_MASK     0x00000020
#define REG_TXFFLSH_SHIFT    5
#define REG_TXFFLSH_WIDTH    1

/* RXFFLSH */
#define REG_RXFFLSH          0x00010
#define REG_RXFFLSH_MASK     0x00000010
#define REG_RXFFLSH_SHIFT    4
#define REG_RXFFLSH_WIDTH    1

/* FRMCNTRRST */
#define REG_FRMCNTRRST          0x00010
#define REG_FRMCNTRRST_MASK     0x00000004
#define REG_FRMCNTRRST_SHIFT    2
#define REG_FRMCNTRRST_WIDTH    1

/* CSFTRST */
#define REG_CSFTRST          0x00010
#define REG_CSFTRST_MASK     0x00000001
#define REG_CSFTRST_SHIFT    0
#define REG_CSFTRST_WIDTH    1

/* WKUPINT */
#define REG_WKUPINT          0x00014
#define REG_WKUPINT_MASK     0x80000000
#define REG_WKUPINT_SHIFT    31
#define REG_WKUPINT_WIDTH    1

/* SESSREQINT */
#define REG_SESSREQINT          0x00014
#define REG_SESSREQINT_MASK     0x40000000
#define REG_SESSREQINT_SHIFT    30
#define REG_SESSREQINT_WIDTH    1

/* DISCONNINT */
#define REG_DISCONNINT          0x00014
#define REG_DISCONNINT_MASK     0x20000000
#define REG_DISCONNINT_SHIFT    29
#define REG_DISCONNINT_WIDTH    1

/* CONIDSTSCHNG */
#define REG_CONIDSTSCHNG          0x00014
#define REG_CONIDSTSCHNG_MASK     0x10000000
#define REG_CONIDSTSCHNG_SHIFT    28
#define REG_CONIDSTSCHNG_WIDTH    1

/* PTXFEMP */
#define REG_PTXFEMP          0x00014
#define REG_PTXFEMP_MASK     0x04000000
#define REG_PTXFEMP_SHIFT    26
#define REG_PTXFEMP_WIDTH    1

/* HCHINT */
#define REG_HCHINT          0x00014
#define REG_HCHINT_MASK     0x02000000
#define REG_HCHINT_SHIFT    25
#define REG_HCHINT_WIDTH    1

/* PRTINT */
#define REG_PRTINT          0x00014
#define REG_PRTINT_MASK     0x01000000
#define REG_PRTINT_SHIFT    24
#define REG_PRTINT_WIDTH    1

/* RESETDET */
#define REG_RESETDET          0x00014
#define REG_RESETDET_MASK     0x00800000
#define REG_RESETDET_SHIFT    23
#define REG_RESETDET_WIDTH    1

/* FETSUSP */
#define REG_FETSUSP          0x00014
#define REG_FETSUSP_MASK     0x00400000
#define REG_FETSUSP_SHIFT    22
#define REG_FETSUSP_WIDTH    1

/* INCOMPLP */
#define REG_INCOMPLP          0x00014
#define REG_INCOMPLP_MASK     0x00200000
#define REG_INCOMPLP_SHIFT    21
#define REG_INCOMPLP_WIDTH    1

/* INCOMPISOIN */
#define REG_INCOMPISOIN          0x00014
#define REG_INCOMPISOIN_MASK     0x00100000
#define REG_INCOMPISOIN_SHIFT    20
#define REG_INCOMPISOIN_WIDTH    1

/* OEPINT */
#define REG_OEPINT          0x00014
#define REG_OEPINT_MASK     0x00080000
#define REG_OEPINT_SHIFT    19
#define REG_OEPINT_WIDTH    1

/* IEPINT */
#define REG_IEPINT          0x00014
#define REG_IEPINT_MASK     0x00040000
#define REG_IEPINT_SHIFT    18
#define REG_IEPINT_WIDTH    1

/* EPMIS */
#define REG_EPMIS          0x00014
#define REG_EPMIS_MASK     0x00020000
#define REG_EPMIS_SHIFT    17
#define REG_EPMIS_WIDTH    1

/* ISOOUTDROP */
#define REG_ISOOUTDROP          0x00014
#define REG_ISOOUTDROP_MASK     0x00004000
#define REG_ISOOUTDROP_SHIFT    14
#define REG_ISOOUTDROP_WIDTH    1

/* ENUMDONE */
#define REG_ENUMDONE          0x00014
#define REG_ENUMDONE_MASK     0x00002000
#define REG_ENUMDONE_SHIFT    13
#define REG_ENUMDONE_WIDTH    1

/* USBRST */
#define REG_USBRST          0x00014
#define REG_USBRST_MASK     0x00001000
#define REG_USBRST_SHIFT    12
#define REG_USBRST_WIDTH    1

/* USBSUSP */
#define REG_USBSUSP          0x00014
#define REG_USBSUSP_MASK     0x00000800
#define REG_USBSUSP_SHIFT    11
#define REG_USBSUSP_WIDTH    1

/* ERLYSUSP */
#define REG_ERLYSUSP          0x00014
#define REG_ERLYSUSP_MASK     0x00000400
#define REG_ERLYSUSP_SHIFT    10
#define REG_ERLYSUSP_WIDTH    1

/* GOUTNAKEFF */
#define REG_GOUTNAKEFF          0x00014
#define REG_GOUTNAKEFF_MASK     0x00000080
#define REG_GOUTNAKEFF_SHIFT    7
#define REG_GOUTNAKEFF_WIDTH    1

/* GINNAKEFF */
#define REG_GINNAKEFF          0x00014
#define REG_GINNAKEFF_MASK     0x00000040
#define REG_GINNAKEFF_SHIFT    6
#define REG_GINNAKEFF_WIDTH    1

/* RXFLVL */
#define REG_RXFLVL          0x00014
#define REG_RXFLVL_MASK     0x00000010
#define REG_RXFLVL_SHIFT    4
#define REG_RXFLVL_WIDTH    1

/* SOF */
#define REG_SOF          0x00014
#define REG_SOF_MASK     0x00000008
#define REG_SOF_SHIFT    3
#define REG_SOF_WIDTH    1

/* OTGINT */
#define REG_OTGINT          0x00014
#define REG_OTGINT_MASK     0x00000004
#define REG_OTGINT_SHIFT    2
#define REG_OTGINT_WIDTH    1

/* MODEMIS */
#define REG_MODEMIS          0x00014
#define REG_MODEMIS_MASK     0x00000002
#define REG_MODEMIS_SHIFT    1
#define REG_MODEMIS_WIDTH    1

/* CURMOD */
#define REG_CURMOD          0x00014
#define REG_CURMOD_MASK     0x00000001
#define REG_CURMOD_SHIFT    0
#define REG_CURMOD_WIDTH    1

/* WKUPINTMSK */
#define REG_WKUPINTMSK          0x00018
#define REG_WKUPINTMSK_MASK     0x80000000
#define REG_WKUPINTMSK_SHIFT    31
#define REG_WKUPINTMSK_WIDTH    1

/* SESSREQINTMSK */
#define REG_SESSREQINTMSK          0x00018
#define REG_SESSREQINTMSK_MASK     0x40000000
#define REG_SESSREQINTMSK_SHIFT    30
#define REG_SESSREQINTMSK_WIDTH    1

/* DISCONNINTMSK */
#define REG_DISCONNINTMSK          0x00018
#define REG_DISCONNINTMSK_MASK     0x20000000
#define REG_DISCONNINTMSK_SHIFT    29
#define REG_DISCONNINTMSK_WIDTH    1

/* CONIDSTSCHNGMSK */
#define REG_CONIDSTSCHNGMSK          0x00018
#define REG_CONIDSTSCHNGMSK_MASK     0x10000000
#define REG_CONIDSTSCHNGMSK_SHIFT    28
#define REG_CONIDSTSCHNGMSK_WIDTH    1

/* PTXFEMPMSK */
#define REG_PTXFEMPMSK          0x00018
#define REG_PTXFEMPMSK_MASK     0x04000000
#define REG_PTXFEMPMSK_SHIFT    26
#define REG_PTXFEMPMSK_WIDTH    1

/* HCHINTMSK */
#define REG_HCHINTMSK          0x00018
#define REG_HCHINTMSK_MASK     0x02000000
#define REG_HCHINTMSK_SHIFT    25
#define REG_HCHINTMSK_WIDTH    1

/* PRTINTMSK */
#define REG_PRTINTMSK          0x00018
#define REG_PRTINTMSK_MASK     0x01000000
#define REG_PRTINTMSK_SHIFT    24
#define REG_PRTINTMSK_WIDTH    1

/* RESETDETMSK */
#define REG_RESETDETMSK          0x00018
#define REG_RESETDETMSK_MASK     0x00800000
#define REG_RESETDETMSK_SHIFT    23
#define REG_RESETDETMSK_WIDTH    1

/* FETSUSPMSK */
#define REG_FETSUSPMSK          0x00018
#define REG_FETSUSPMSK_MASK     0x00400000
#define REG_FETSUSPMSK_SHIFT    22
#define REG_FETSUSPMSK_WIDTH    1

/* INCOMPLPMSK */
#define REG_INCOMPLPMSK          0x00018
#define REG_INCOMPLPMSK_MASK     0x00200000
#define REG_INCOMPLPMSK_SHIFT    21
#define REG_INCOMPLPMSK_WIDTH    1

/* INCOMPISOINMSK */
#define REG_INCOMPISOINMSK          0x00018
#define REG_INCOMPISOINMSK_MASK     0x00100000
#define REG_INCOMPISOINMSK_SHIFT    20
#define REG_INCOMPISOINMSK_WIDTH    1

/* OEPINTMSK */
#define REG_OEPINTMSK          0x00018
#define REG_OEPINTMSK_MASK     0x00080000
#define REG_OEPINTMSK_SHIFT    19
#define REG_OEPINTMSK_WIDTH    1

/* IEPINTMSK */
#define REG_IEPINTMSK          0x00018
#define REG_IEPINTMSK_MASK     0x00040000
#define REG_IEPINTMSK_SHIFT    18
#define REG_IEPINTMSK_WIDTH    1

/* EPMISMSK */
#define REG_EPMISMSK          0x00018
#define REG_EPMISMSK_MASK     0x00020000
#define REG_EPMISMSK_SHIFT    17
#define REG_EPMISMSK_WIDTH    1

/* EOPFMSK */
#define REG_EOPFMSK          0x00018
#define REG_EOPFMSK_MASK     0x00008000
#define REG_EOPFMSK_SHIFT    15
#define REG_EOPFMSK_WIDTH    1

/* ISOOUTDROPMSK */
#define REG_ISOOUTDROPMSK          0x00018
#define REG_ISOOUTDROPMSK_MASK     0x00004000
#define REG_ISOOUTDROPMSK_SHIFT    14
#define REG_ISOOUTDROPMSK_WIDTH    1

/* ENUMDONEMSK */
#define REG_ENUMDONEMSK          0x00018
#define REG_ENUMDONEMSK_MASK     0x00002000
#define REG_ENUMDONEMSK_SHIFT    13
#define REG_ENUMDONEMSK_WIDTH    1

/* USBRSTMSK */
#define REG_USBRSTMSK          0x00018
#define REG_USBRSTMSK_MASK     0x00001000
#define REG_USBRSTMSK_SHIFT    12
#define REG_USBRSTMSK_WIDTH    1

/* USBSUSPMSK */
#define REG_USBSUSPMSK          0x00018
#define REG_USBSUSPMSK_MASK     0x00000800
#define REG_USBSUSPMSK_SHIFT    11
#define REG_USBSUSPMSK_WIDTH    1

/* ERLYSUSPMSK */
#define REG_ERLYSUSPMSK          0x00018
#define REG_ERLYSUSPMSK_MASK     0x00000400
#define REG_ERLYSUSPMSK_SHIFT    10
#define REG_ERLYSUSPMSK_WIDTH    1

/* GOUTNAKEFFMSK */
#define REG_GOUTNAKEFFMSK          0x00018
#define REG_GOUTNAKEFFMSK_MASK     0x00000080
#define REG_GOUTNAKEFFMSK_SHIFT    7
#define REG_GOUTNAKEFFMSK_WIDTH    1

/* GINNAKEFFMSK */
#define REG_GINNAKEFFMSK          0x00018
#define REG_GINNAKEFFMSK_MASK     0x00000040
#define REG_GINNAKEFFMSK_SHIFT    6
#define REG_GINNAKEFFMSK_WIDTH    1

/* RXFLVLMSK */
#define REG_RXFLVLMSK          0x00018
#define REG_RXFLVLMSK_MASK     0x00000010
#define REG_RXFLVLMSK_SHIFT    4
#define REG_RXFLVLMSK_WIDTH    1

/* SOFMSK */
#define REG_SOFMSK          0x00018
#define REG_SOFMSK_MASK     0x00000008
#define REG_SOFMSK_SHIFT    3
#define REG_SOFMSK_WIDTH    1

/* OTGINTMSK */
#define REG_OTGINTMSK          0x00018
#define REG_OTGINTMSK_MASK     0x00000004
#define REG_OTGINTMSK_SHIFT    2
#define REG_OTGINTMSK_WIDTH    1

/* MODEMISMSK */
#define REG_MODEMISMSK          0x00018
#define REG_MODEMISMSK_MASK     0x00000002
#define REG_MODEMISMSK_SHIFT    1
#define REG_MODEMISMSK_WIDTH    1

/* FN */
#define REG_FN          0x0001c
#define REG_FN_MASK     0x0f000000
#define REG_FN_SHIFT    24
#define REG_FN_WIDTH    4

/* PKTSTS */
#define REG_PKTSTS          0x0001c
#define REG_PKTSTS_MASK     0x001e0000
#define REG_PKTSTS_SHIFT    17
#define REG_PKTSTS_WIDTH    4

/* DPID */
#define REG_DPID          0x0001c
#define REG_DPID_MASK     0x00018000
#define REG_DPID_SHIFT    15
#define REG_DPID_WIDTH    2

/* BCNT */
#define REG_BCNT          0x0001c
#define REG_BCNT_MASK     0x00007ff0
#define REG_BCNT_SHIFT    4
#define REG_BCNT_WIDTH    11

/* CHNUM */
#define REG_CHNUM          0x0001c
#define REG_CHNUM_MASK     0x0000000f
#define REG_CHNUM_SHIFT    0
#define REG_CHNUM_WIDTH    4

/* FN */
#define REG_FN          0x00020
#define REG_FN_MASK     0x01e00000
#define REG_FN_SHIFT    21
#define REG_FN_WIDTH    4

/* PKTSTS */
#define REG_PKTSTS          0x00020
#define REG_PKTSTS_MASK     0x001e0000
#define REG_PKTSTS_SHIFT    17
#define REG_PKTSTS_WIDTH    4

/* DPID */
#define REG_DPID          0x00020
#define REG_DPID_MASK     0x00018000
#define REG_DPID_SHIFT    15
#define REG_DPID_WIDTH    2

/* BCNT */
#define REG_BCNT          0x00020
#define REG_BCNT_MASK     0x00007ff0
#define REG_BCNT_SHIFT    4
#define REG_BCNT_WIDTH    11

/* CHNUM */
#define REG_CHNUM          0x00020
#define REG_CHNUM_MASK     0x0000000f
#define REG_CHNUM_SHIFT    0
#define REG_CHNUM_WIDTH    4

/* RXFDEP */
#define REG_RXFDEP          0x00024
#define REG_RXFDEP_MASK     0x000007ff
#define REG_RXFDEP_SHIFT    0
#define REG_RXFDEP_WIDTH    11

/* NPTXFDEP */
#define REG_NPTXFDEP          0x00028
#define REG_NPTXFDEP_MASK     0x07ff0000
#define REG_NPTXFDEP_SHIFT    16
#define REG_NPTXFDEP_WIDTH    11

/* INEPTXF0DEP */
#define REG_INEPTXF0DEP          0x00028
#define REG_INEPTXF0DEP_MASK     0x07ff0000
#define REG_INEPTXF0DEP_SHIFT    16
#define REG_INEPTXF0DEP_WIDTH    11

/* NPTXFSTADDR */
#define REG_NPTXFSTADDR          0x00028
#define REG_NPTXFSTADDR_MASK     0x000007ff
#define REG_NPTXFSTADDR_SHIFT    0
#define REG_NPTXFSTADDR_WIDTH    11

/* NPTXQTOP */
#define REG_NPTXQTOP          0x0002c
#define REG_NPTXQTOP_MASK     0x7f000000
#define REG_NPTXQTOP_SHIFT    24
#define REG_NPTXQTOP_WIDTH    7

/* NPTXQSPCAVAIL */
#define REG_NPTXQSPCAVAIL          0x0002c
#define REG_NPTXQSPCAVAIL_MASK     0x00ff0000
#define REG_NPTXQSPCAVAIL_SHIFT    16
#define REG_NPTXQSPCAVAIL_WIDTH    8

/* NPTXFSPCAVAIL */
#define REG_NPTXFSPCAVAIL          0x0002c
#define REG_NPTXFSPCAVAIL_MASK     0x0000ffff
#define REG_NPTXFSPCAVAIL_SHIFT    0
#define REG_NPTXFSPCAVAIL_WIDTH    16

/* GSNPSID */
#define REG_GSNPSID          0x00040
#define REG_GSNPSID_MASK     0xffffffff
#define REG_GSNPSID_SHIFT    0
#define REG_GSNPSID_WIDTH    32

/* GHWCFG1 */
#define REG_GHWCFG1          0x00044
#define REG_GHWCFG1_MASK     0xffffffff
#define REG_GHWCFG1_SHIFT    0
#define REG_GHWCFG1_WIDTH    32

/* TKNQDEPTH */
#define REG_TKNQDEPTH          0x00048
#define REG_TKNQDEPTH_MASK     0x7c000000
#define REG_TKNQDEPTH_SHIFT    26
#define REG_TKNQDEPTH_WIDTH    5

/* PTXQDEPTH */
#define REG_PTXQDEPTH          0x00048
#define REG_PTXQDEPTH_MASK     0x03000000
#define REG_PTXQDEPTH_SHIFT    24
#define REG_PTXQDEPTH_WIDTH    2

/* NPTXQDEPTH */
#define REG_NPTXQDEPTH          0x00048
#define REG_NPTXQDEPTH_MASK     0x00c00000
#define REG_NPTXQDEPTH_SHIFT    22
#define REG_NPTXQDEPTH_WIDTH    2

/* MULTIPROCINTRPT */
#define REG_MULTIPROCINTRPT          0x00048
#define REG_MULTIPROCINTRPT_MASK     0x00100000
#define REG_MULTIPROCINTRPT_SHIFT    20
#define REG_MULTIPROCINTRPT_WIDTH    1

/* DYNFIFOSIZING */
#define REG_DYNFIFOSIZING          0x00048
#define REG_DYNFIFOSIZING_MASK     0x00080000
#define REG_DYNFIFOSIZING_SHIFT    19
#define REG_DYNFIFOSIZING_WIDTH    1

/* PERIOSUPPOR */
#define REG_PERIOSUPPOR          0x00048
#define REG_PERIOSUPPOR_MASK     0x00040000
#define REG_PERIOSUPPOR_SHIFT    18
#define REG_PERIOSUPPOR_WIDTH    1

/* NUMHSTCHNL */
#define REG_NUMHSTCHNL          0x00048
#define REG_NUMHSTCHNL_MASK     0x0003c000
#define REG_NUMHSTCHNL_SHIFT    14
#define REG_NUMHSTCHNL_WIDTH    4

/* NUMDEVEPS */
#define REG_NUMDEVEPS          0x00048
#define REG_NUMDEVEPS_MASK     0x00003c00
#define REG_NUMDEVEPS_SHIFT    10
#define REG_NUMDEVEPS_WIDTH    4

/* FSPHYTYPE */
#define REG_FSPHYTYPE          0x00048
#define REG_FSPHYTYPE_MASK     0x00000300
#define REG_FSPHYTYPE_SHIFT    8
#define REG_FSPHYTYPE_WIDTH    2

/* HSPHYTYPE */
#define REG_HSPHYTYPE          0x00048
#define REG_HSPHYTYPE_MASK     0x000000c0
#define REG_HSPHYTYPE_SHIFT    6
#define REG_HSPHYTYPE_WIDTH    2

/* SINGPNT */
#define REG_SINGPNT          0x00048
#define REG_SINGPNT_MASK     0x00000020
#define REG_SINGPNT_SHIFT    5
#define REG_SINGPNT_WIDTH    1

/* OTGARCH */
#define REG_OTGARCH          0x00048
#define REG_OTGARCH_MASK     0x00000018
#define REG_OTGARCH_SHIFT    3
#define REG_OTGARCH_WIDTH    2

/* OTGMODE */
#define REG_OTGMODE          0x00048
#define REG_OTGMODE_MASK     0x00000007
#define REG_OTGMODE_SHIFT    0
#define REG_OTGMODE_WIDTH    3

/* DFIFODEPTH */
#define REG_DFIFODEPTH          0x0004c
#define REG_DFIFODEPTH_MASK     0xffff0000
#define REG_DFIFODEPTH_SHIFT    16
#define REG_DFIFODEPTH_WIDTH    16

/* LPMMODE */
#define REG_LPMMODE          0x0004c
#define REG_LPMMODE_MASK     0x00008000
#define REG_LPMMODE_SHIFT    15
#define REG_LPMMODE_WIDTH    1

/* BCSUPPORT */
#define REG_BCSUPPORT          0x0004c
#define REG_BCSUPPORT_MASK     0x00004000
#define REG_BCSUPPORT_SHIFT    14
#define REG_BCSUPPORT_WIDTH    1

/* HSICMODE */
#define REG_HSICMODE          0x0004c
#define REG_HSICMODE_MASK     0x00002000
#define REG_HSICMODE_SHIFT    13
#define REG_HSICMODE_WIDTH    1

/* ADPSUPPORT */
#define REG_ADPSUPPORT          0x0004c
#define REG_ADPSUPPORT_MASK     0x00001000
#define REG_ADPSUPPORT_SHIFT    12
#define REG_ADPSUPPORT_WIDTH    1

/* RSTTYPE */
#define REG_RSTTYPE          0x0004c
#define REG_RSTTYPE_MASK     0x00000800
#define REG_RSTTYPE_SHIFT    11
#define REG_RSTTYPE_WIDTH    1

/* OPTFEATURE */
#define REG_OPTFEATURE          0x0004c
#define REG_OPTFEATURE_MASK     0x00000400
#define REG_OPTFEATURE_SHIFT    10
#define REG_OPTFEATURE_WIDTH    1

/* VNDCTLSUPT */
#define REG_VNDCTLSUPT          0x0004c
#define REG_VNDCTLSUPT_MASK     0x00000200
#define REG_VNDCTLSUPT_SHIFT    9
#define REG_VNDCTLSUPT_WIDTH    1

/* I2CINTSEL */
#define REG_I2CINTSEL          0x0004c
#define REG_I2CINTSEL_MASK     0x00000100
#define REG_I2CINTSEL_SHIFT    8
#define REG_I2CINTSEL_WIDTH    1

/* OTGEN */
#define REG_OTGEN          0x0004c
#define REG_OTGEN_MASK     0x00000080
#define REG_OTGEN_SHIFT    7
#define REG_OTGEN_WIDTH    1

/* PKTSIZEWIDTH */
#define REG_PKTSIZEWIDTH          0x0004c
#define REG_PKTSIZEWIDTH_MASK     0x00000070
#define REG_PKTSIZEWIDTH_SHIFT    4
#define REG_PKTSIZEWIDTH_WIDTH    3

/* XFERSIZEWIDTH */
#define REG_XFERSIZEWIDTH          0x0004c
#define REG_XFERSIZEWIDTH_MASK     0x0000000f
#define REG_XFERSIZEWIDTH_SHIFT    0
#define REG_XFERSIZEWIDTH_WIDTH    4

/* DMA */
#define REG_DMA          0x00050
#define REG_DMA_MASK     0x80000000
#define REG_DMA_SHIFT    31
#define REG_DMA_WIDTH    1

/* DMA_CONFIGURATION */
#define REG_DMA_CONFIGURATION          0x00050
#define REG_DMA_CONFIGURATION_MASK     0x40000000
#define REG_DMA_CONFIGURATION_SHIFT    30
#define REG_DMA_CONFIGURATION_WIDTH    1

/* INEPS */
#define REG_INEPS          0x00050
#define REG_INEPS_MASK     0x3c000000
#define REG_INEPS_SHIFT    26
#define REG_INEPS_WIDTH    4

/* DEDFIFOMODE */
#define REG_DEDFIFOMODE          0x00050
#define REG_DEDFIFOMODE_MASK     0x02000000
#define REG_DEDFIFOMODE_SHIFT    25
#define REG_DEDFIFOMODE_WIDTH    1

/* SESSENDFLTR */
#define REG_SESSENDFLTR          0x00050
#define REG_SESSENDFLTR_MASK     0x01000000
#define REG_SESSENDFLTR_SHIFT    24
#define REG_SESSENDFLTR_WIDTH    1

/* BVALIDFLTR */
#define REG_BVALIDFLTR          0x00050
#define REG_BVALIDFLTR_MASK     0x00800000
#define REG_BVALIDFLTR_SHIFT    23
#define REG_BVALIDFLTR_WIDTH    1

/* AVALIDFLTR */
#define REG_AVALIDFLTR          0x00050
#define REG_AVALIDFLTR_MASK     0x00400000
#define REG_AVALIDFLTR_SHIFT    22
#define REG_AVALIDFLTR_WIDTH    1

/* VBUSVALIDFLTR */
#define REG_VBUSVALIDFLTR          0x00050
#define REG_VBUSVALIDFLTR_MASK     0x00200000
#define REG_VBUSVALIDFLTR_SHIFT    21
#define REG_VBUSVALIDFLTR_WIDTH    1

/* IDDGFLTR */
#define REG_IDDGFLTR          0x00050
#define REG_IDDGFLTR_MASK     0x00100000
#define REG_IDDGFLTR_SHIFT    20
#define REG_IDDGFLTR_WIDTH    1

/* NUMCTLEPS */
#define REG_NUMCTLEPS          0x00050
#define REG_NUMCTLEPS_MASK     0x000f0000
#define REG_NUMCTLEPS_SHIFT    16
#define REG_NUMCTLEPS_WIDTH    4

/* PHYDATAWIDTH */
#define REG_PHYDATAWIDTH          0x00050
#define REG_PHYDATAWIDTH_MASK     0x0000c000
#define REG_PHYDATAWIDTH_SHIFT    14
#define REG_PHYDATAWIDTH_WIDTH    2

/* HIBERNATION */
#define REG_HIBERNATION          0x00050
#define REG_HIBERNATION_MASK     0x00000040
#define REG_HIBERNATION_SHIFT    6
#define REG_HIBERNATION_WIDTH    1

/* AHBFREQ */
#define REG_AHBFREQ          0x00050
#define REG_AHBFREQ_MASK     0x00000020
#define REG_AHBFREQ_SHIFT    5
#define REG_AHBFREQ_WIDTH    1

/* PARTIALPWRDN */
#define REG_PARTIALPWRDN          0x00050
#define REG_PARTIALPWRDN_MASK     0x00000010
#define REG_PARTIALPWRDN_SHIFT    4
#define REG_PARTIALPWRDN_WIDTH    1

/* NUMDEVPERIOEPS */
#define REG_NUMDEVPERIOEPS          0x00050
#define REG_NUMDEVPERIOEPS_MASK     0x0000000f
#define REG_NUMDEVPERIOEPS_SHIFT    0
#define REG_NUMDEVPERIOEPS_WIDTH    4

/* EPINFOBASEADDR */
#define REG_EPINFOBASEADDR          0x0005c
#define REG_EPINFOBASEADDR_MASK     0xffff0000
#define REG_EPINFOBASEADDR_SHIFT    16
#define REG_EPINFOBASEADDR_WIDTH    16

/* GDFIFOCFG */
#define REG_GDFIFOCFG          0x0005c
#define REG_GDFIFOCFG_MASK     0x0000ffff
#define REG_GDFIFOCFG_SHIFT    0
#define REG_GDFIFOCFG_WIDTH    16

/* PTXFSIZE */
#define REG_PTXFSIZE          0x00100
#define REG_PTXFSIZE_MASK     0x07ff0000
#define REG_PTXFSIZE_SHIFT    16
#define REG_PTXFSIZE_WIDTH    11

/* PTXFSTADDR */
#define REG_PTXFSTADDR          0x00100
#define REG_PTXFSTADDR_MASK     0x00000fff
#define REG_PTXFSTADDR_SHIFT    0
#define REG_PTXFSTADDR_WIDTH    12

/* MODECHTIMEN */
#define REG_MODECHTIMEN          0x00400
#define REG_MODECHTIMEN_MASK     0x80000000
#define REG_MODECHTIMEN_SHIFT    31
#define REG_MODECHTIMEN_WIDTH    1

/* PERSCHEDENA */
#define REG_PERSCHEDENA          0x00400
#define REG_PERSCHEDENA_MASK     0x04000000
#define REG_PERSCHEDENA_SHIFT    26
#define REG_PERSCHEDENA_WIDTH    1

/* FRLISTEN */
#define REG_FRLISTEN          0x00400
#define REG_FRLISTEN_MASK     0x03000000
#define REG_FRLISTEN_SHIFT    24
#define REG_FRLISTEN_WIDTH    2

/* DESCDMA */
#define REG_DESCDMA          0x00400
#define REG_DESCDMA_MASK     0x00800000
#define REG_DESCDMA_SHIFT    23
#define REG_DESCDMA_WIDTH    1

/* RESVALID */
#define REG_RESVALID          0x00400
#define REG_RESVALID_MASK     0x0000ff00
#define REG_RESVALID_SHIFT    8
#define REG_RESVALID_WIDTH    8

/* ENA32KHZS */
#define REG_ENA32KHZS          0x00400
#define REG_ENA32KHZS_MASK     0x00000080
#define REG_ENA32KHZS_SHIFT    7
#define REG_ENA32KHZS_WIDTH    1

/* FSLSSUPP */
#define REG_FSLSSUPP          0x00400
#define REG_FSLSSUPP_MASK     0x00000004
#define REG_FSLSSUPP_SHIFT    2
#define REG_FSLSSUPP_WIDTH    1

/* FSLSPCLKSEL */
#define REG_FSLSPCLKSEL          0x00400
#define REG_FSLSPCLKSEL_MASK     0x00000003
#define REG_FSLSPCLKSEL_SHIFT    0
#define REG_FSLSPCLKSEL_WIDTH    2

/* HFIRRLDCTRL */
#define REG_HFIRRLDCTRL          0x00404
#define REG_HFIRRLDCTRL_MASK     0x00010000
#define REG_HFIRRLDCTRL_SHIFT    16
#define REG_HFIRRLDCTRL_WIDTH    1

/* FRINT */
#define REG_FRINT          0x00404
#define REG_FRINT_MASK     0x0000ffff
#define REG_FRINT_SHIFT    0
#define REG_FRINT_WIDTH    16

/* FRNUM */
#define REG_FRNUM          0x00408
#define REG_FRNUM_MASK     0x0000ffff
#define REG_FRNUM_SHIFT    0
#define REG_FRNUM_WIDTH    16

/* FRREM */
#define REG_FRREM          0x00408
#define REG_FRREM_MASK     0xffff0000
#define REG_FRREM_SHIFT    16
#define REG_FRREM_WIDTH    16

/* PTXQTOP */
#define REG_PTXQTOP          0x00410
#define REG_PTXQTOP_MASK     0xff000000
#define REG_PTXQTOP_SHIFT    24
#define REG_PTXQTOP_WIDTH    8

/* PTXQSPCAVAIL */
#define REG_PTXQSPCAVAIL          0x00410
#define REG_PTXQSPCAVAIL_MASK     0x00ff0000
#define REG_PTXQSPCAVAIL_SHIFT    16
#define REG_PTXQSPCAVAIL_WIDTH    8

/* PTXFSPCAVAIL */
#define REG_PTXFSPCAVAIL          0x00410
#define REG_PTXFSPCAVAIL_MASK     0x0000ffff
#define REG_PTXFSPCAVAIL_SHIFT    0
#define REG_PTXFSPCAVAIL_WIDTH    16

/* HAINT */
#define REG_HAINT          0x00414
#define REG_HAINT_MASK     0x0000ffff
#define REG_HAINT_SHIFT    0
#define REG_HAINT_WIDTH    16

/* HAINTMSK */
#define REG_HAINTMSK          0x00418
#define REG_HAINTMSK_MASK     0x0000ffff
#define REG_HAINTMSK_SHIFT    0
#define REG_HAINTMSK_WIDTH    16

/* HFLBADDR */
#define REG_HFLBADDR          0x0041c
#define REG_HFLBADDR_MASK     0xffffffff
#define REG_HFLBADDR_SHIFT    0
#define REG_HFLBADDR_WIDTH    32

/* PRTSPD */
#define REG_PRTSPD          0x00440
#define REG_PRTSPD_MASK     0x00060000
#define REG_PRTSPD_SHIFT    17
#define REG_PRTSPD_WIDTH    2

/* PRTTSTCTL */
#define REG_PRTTSTCTL          0x00440
#define REG_PRTTSTCTL_MASK     0x0001e000
#define REG_PRTTSTCTL_SHIFT    13
#define REG_PRTTSTCTL_WIDTH    4

/* PRTPWR */
#define REG_PRTPWR          0x00440
#define REG_PRTPWR_MASK     0x00001000
#define REG_PRTPWR_SHIFT    12
#define REG_PRTPWR_WIDTH    1

/* PRTLNSTS */
#define REG_PRTLNSTS          0x00440
#define REG_PRTLNSTS_MASK     0x00000c00
#define REG_PRTLNSTS_SHIFT    10
#define REG_PRTLNSTS_WIDTH    2

/* PRTRST */
#define REG_PRTRST          0x00440
#define REG_PRTRST_MASK     0x00000100
#define REG_PRTRST_SHIFT    8
#define REG_PRTRST_WIDTH    1

/* PRTSUSP */
#define REG_PRTSUSP          0x00440
#define REG_PRTSUSP_MASK     0x00000080
#define REG_PRTSUSP_SHIFT    7
#define REG_PRTSUSP_WIDTH    1

/* PRTRES */
#define REG_PRTRES          0x00440
#define REG_PRTRES_MASK     0x00000040
#define REG_PRTRES_SHIFT    6
#define REG_PRTRES_WIDTH    1

/* PRTOVRCURRCHNG */
#define REG_PRTOVRCURRCHNG          0x00440
#define REG_PRTOVRCURRCHNG_MASK     0x00000020
#define REG_PRTOVRCURRCHNG_SHIFT    5
#define REG_PRTOVRCURRCHNG_WIDTH    1

/* PRTOVRCURRACT */
#define REG_PRTOVRCURRACT          0x00440
#define REG_PRTOVRCURRACT_MASK     0x00000010
#define REG_PRTOVRCURRACT_SHIFT    4
#define REG_PRTOVRCURRACT_WIDTH    1

/* PRTENCHNG */
#define REG_PRTENCHNG          0x00440
#define REG_PRTENCHNG_MASK     0x00000008
#define REG_PRTENCHNG_SHIFT    3
#define REG_PRTENCHNG_WIDTH    1

/* PRTENA */
#define REG_PRTENA          0x00440
#define REG_PRTENA_MASK     0x00000004
#define REG_PRTENA_SHIFT    2
#define REG_PRTENA_WIDTH    1

/* PRTCONNDET */
#define REG_PRTCONNDET          0x00440
#define REG_PRTCONNDET_MASK     0x00000002
#define REG_PRTCONNDET_SHIFT    1
#define REG_PRTCONNDET_WIDTH    1

/* PRTCONNSTS */
#define REG_PRTCONNSTS          0x00440
#define REG_PRTCONNSTS_MASK     0x00000001
#define REG_PRTCONNSTS_SHIFT    0
#define REG_PRTCONNSTS_WIDTH    1

/* CHENA */
#define REG_CHENA          0x00500
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00500
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00500
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00500
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00500
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00500
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00500
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00500
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00500
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00504
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00504
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00504
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00504
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00504
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00508
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00508
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00508
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00508
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00508
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00508
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00508
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00508
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00508
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00508
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00508
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00508
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00508
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00508
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0050c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0050c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0050c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0050c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0050c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00510
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00510
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00510
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00510
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA0 */
#define REG_HCDMA0          0x00514
#define REG_HCDMA0_MASK     0xffffffff
#define REG_HCDMA0_SHIFT    0
#define REG_HCDMA0_WIDTH    32

/* HCDMAB0 */
#define REG_HCDMAB0          0x0051c
#define REG_HCDMAB0_MASK     0xffffffff
#define REG_HCDMAB0_SHIFT    0
#define REG_HCDMAB0_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00520
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00520
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00520
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00520
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00520
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00520
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00520
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00520
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00520
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00524
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00524
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00524
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00524
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00524
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00528
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00528
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00528
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00528
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00528
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00528
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00528
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00528
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00528
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00528
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00528
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00528
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00528
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00528
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0052c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0052c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0052c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0052c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0052c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00530
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00530
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00530
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00530
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA1 */
#define REG_HCDMA1          0x00534
#define REG_HCDMA1_MASK     0xffffffff
#define REG_HCDMA1_SHIFT    0
#define REG_HCDMA1_WIDTH    32

/* HCDMAB1 */
#define REG_HCDMAB1          0x0053c
#define REG_HCDMAB1_MASK     0xffffffff
#define REG_HCDMAB1_SHIFT    0
#define REG_HCDMAB1_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00540
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00540
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00540
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00540
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00540
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00540
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00540
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00540
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00540
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00544
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00544
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00544
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00544
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00544
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00548
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00548
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00548
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00548
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00548
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00548
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00548
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00548
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00548
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00548
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00548
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00548
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00548
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00548
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0054c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0054c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0054c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0054c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0054c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00550
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00550
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00550
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00550
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA2 */
#define REG_HCDMA2          0x00554
#define REG_HCDMA2_MASK     0xffffffff
#define REG_HCDMA2_SHIFT    0
#define REG_HCDMA2_WIDTH    32

/* HCDMAB2 */
#define REG_HCDMAB2          0x0055c
#define REG_HCDMAB2_MASK     0xffffffff
#define REG_HCDMAB2_SHIFT    0
#define REG_HCDMAB2_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00560
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00560
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00560
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00560
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00560
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00560
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00560
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00560
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00560
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00564
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00564
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00564
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00564
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00564
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00568
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00568
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00568
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00568
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00568
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00568
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00568
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00568
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00568
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00568
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00568
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00568
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00568
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00568
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0056c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0056c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0056c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0056c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0056c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00570
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00570
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00570
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00570
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA3 */
#define REG_HCDMA3          0x00574
#define REG_HCDMA3_MASK     0xffffffff
#define REG_HCDMA3_SHIFT    0
#define REG_HCDMA3_WIDTH    32

/* HCDMAB3 */
#define REG_HCDMAB3          0x0057c
#define REG_HCDMAB3_MASK     0xffffffff
#define REG_HCDMAB3_SHIFT    0
#define REG_HCDMAB3_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00580
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00580
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00580
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00580
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00580
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00580
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00580
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00580
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00580
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00584
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00584
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00584
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00584
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00584
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00588
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00588
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00588
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00588
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00588
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00588
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00588
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00588
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00588
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00588
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00588
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00588
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00588
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00588
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0058c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0058c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0058c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0058c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0058c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00590
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00590
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00590
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00590
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA4 */
#define REG_HCDMA4          0x00594
#define REG_HCDMA4_MASK     0xffffffff
#define REG_HCDMA4_SHIFT    0
#define REG_HCDMA4_WIDTH    32

/* HCDMAB4 */
#define REG_HCDMAB4          0x0059c
#define REG_HCDMAB4_MASK     0xffffffff
#define REG_HCDMAB4_SHIFT    0
#define REG_HCDMAB4_WIDTH    32

/* CHENA */
#define REG_CHENA          0x005a0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x005a0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x005a0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x005a0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x005a0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x005a0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x005a0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x005a0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x005a0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x005a4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x005a4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x005a4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x005a4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x005a4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x005a8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x005a8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x005a8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x005a8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x005a8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x005a8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x005a8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x005a8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x005a8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x005a8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x005a8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x005a8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x005a8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x005a8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x005ac
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x005ac
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x005ac
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x005ac
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x005ac
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x005b0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x005b0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x005b0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x005b0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA5 */
#define REG_HCDMA5          0x005b4
#define REG_HCDMA5_MASK     0xffffffff
#define REG_HCDMA5_SHIFT    0
#define REG_HCDMA5_WIDTH    32

/* HCDMAB5 */
#define REG_HCDMAB5          0x005bc
#define REG_HCDMAB5_MASK     0xffffffff
#define REG_HCDMAB5_SHIFT    0
#define REG_HCDMAB5_WIDTH    32

/* CHENA */
#define REG_CHENA          0x005c0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x005c0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x005c0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x005c0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x005c0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x005c0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x005c0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x005c0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x005c0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x005c4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x005c4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x005c4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x005c4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x005c4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x005c8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x005c8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x005c8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x005c8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x005c8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x005c8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x005c8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x005c8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x005c8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x005c8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x005c8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x005c8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x005c8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x005c8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x005cc
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x005cc
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x005cc
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x005cc
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x005cc
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x005d0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x005d0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x005d0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x005d0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA6 */
#define REG_HCDMA6          0x005d4
#define REG_HCDMA6_MASK     0xffffffff
#define REG_HCDMA6_SHIFT    0
#define REG_HCDMA6_WIDTH    32

/* HCDMAB6 */
#define REG_HCDMAB6          0x005dc
#define REG_HCDMAB6_MASK     0xffffffff
#define REG_HCDMAB6_SHIFT    0
#define REG_HCDMAB6_WIDTH    32

/* CHENA */
#define REG_CHENA          0x005e0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x005e0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x005e0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x005e0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x005e0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x005e0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x005e0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x005e0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x005e0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x005e4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x005e4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x005e4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x005e4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x005e4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x005e8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x005e8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x005e8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x005e8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x005e8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x005e8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x005e8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x005e8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x005e8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x005e8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x005e8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x005e8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x005e8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x005e8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x005ec
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x005ec
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x005ec
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x005ec
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x005ec
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x005f0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x005f0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x005f0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x005f0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA7 */
#define REG_HCDMA7          0x005f4
#define REG_HCDMA7_MASK     0xffffffff
#define REG_HCDMA7_SHIFT    0
#define REG_HCDMA7_WIDTH    32

/* HCDMAB7 */
#define REG_HCDMAB7          0x005fc
#define REG_HCDMAB7_MASK     0xffffffff
#define REG_HCDMAB7_SHIFT    0
#define REG_HCDMAB7_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00600
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00600
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00600
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00600
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00600
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00600
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00600
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00600
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00600
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00604
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00604
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00604
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00604
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00604
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00608
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00608
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00608
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00608
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00608
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00608
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00608
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00608
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00608
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00608
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00608
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00608
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00608
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00608
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0060c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0060c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0060c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0060c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0060c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00610
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00610
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00610
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00610
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA8 */
#define REG_HCDMA8          0x00614
#define REG_HCDMA8_MASK     0xffffffff
#define REG_HCDMA8_SHIFT    0
#define REG_HCDMA8_WIDTH    32

/* HCDMAB8 */
#define REG_HCDMAB8          0x0061c
#define REG_HCDMAB8_MASK     0xffffffff
#define REG_HCDMAB8_SHIFT    0
#define REG_HCDMAB8_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00620
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00620
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00620
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00620
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00620
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00620
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00620
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00620
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00620
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00624
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00624
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00624
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00624
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00624
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00628
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00628
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00628
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00628
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00628
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00628
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00628
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00628
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00628
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00628
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00628
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00628
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00628
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00628
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0062c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0062c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0062c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0062c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0062c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00630
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00630
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00630
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00630
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA9 */
#define REG_HCDMA9          0x00634
#define REG_HCDMA9_MASK     0xffffffff
#define REG_HCDMA9_SHIFT    0
#define REG_HCDMA9_WIDTH    32

/* HCDMAB9 */
#define REG_HCDMAB9          0x0063c
#define REG_HCDMAB9_MASK     0xffffffff
#define REG_HCDMAB9_SHIFT    0
#define REG_HCDMAB9_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00640
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00640
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00640
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00640
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00640
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00640
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00640
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00640
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00640
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00644
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00644
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00644
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00644
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00644
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00648
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00648
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00648
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00648
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00648
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00648
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00648
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00648
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00648
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00648
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00648
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00648
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00648
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00648
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0064c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0064c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0064c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0064c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0064c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00650
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00650
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00650
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00650
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA10 */
#define REG_HCDMA10          0x00654
#define REG_HCDMA10_MASK     0xffffffff
#define REG_HCDMA10_SHIFT    0
#define REG_HCDMA10_WIDTH    32

/* HCDMAB10 */
#define REG_HCDMAB10          0x0065c
#define REG_HCDMAB10_MASK     0xffffffff
#define REG_HCDMAB10_SHIFT    0
#define REG_HCDMAB10_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00660
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00660
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00660
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00660
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00660
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00660
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00660
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00660
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00660
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00664
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00664
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00664
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00664
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00664
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00668
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00668
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00668
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00668
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00668
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00668
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00668
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00668
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00668
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00668
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00668
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00668
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00668
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00668
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0066c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0066c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0066c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0066c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0066c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00670
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00670
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00670
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00670
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA11 */
#define REG_HCDMA11          0x00674
#define REG_HCDMA11_MASK     0xffffffff
#define REG_HCDMA11_SHIFT    0
#define REG_HCDMA11_WIDTH    32

/* HCDMAB11 */
#define REG_HCDMAB11          0x0067c
#define REG_HCDMAB11_MASK     0xffffffff
#define REG_HCDMAB11_SHIFT    0
#define REG_HCDMAB11_WIDTH    32

/* CHENA */
#define REG_CHENA          0x00680
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x00680
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x00680
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x00680
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x00680
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x00680
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x00680
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x00680
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x00680
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x00684
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x00684
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x00684
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x00684
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x00684
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x00688
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x00688
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x00688
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x00688
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x00688
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x00688
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x00688
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x00688
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x00688
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x00688
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x00688
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x00688
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x00688
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x00688
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x0068c
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x0068c
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x0068c
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x0068c
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x0068c
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x00690
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x00690
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x00690
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x00690
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA12 */
#define REG_HCDMA12          0x00694
#define REG_HCDMA12_MASK     0xffffffff
#define REG_HCDMA12_SHIFT    0
#define REG_HCDMA12_WIDTH    32

/* HCDMAB12 */
#define REG_HCDMAB12          0x0069c
#define REG_HCDMAB12_MASK     0xffffffff
#define REG_HCDMAB12_SHIFT    0
#define REG_HCDMAB12_WIDTH    32

/* CHENA */
#define REG_CHENA          0x006a0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x006a0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x006a0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x006a0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x006a0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x006a0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x006a0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x006a0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x006a0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x006a4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x006a4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x006a4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x006a4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x006a4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x006a8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x006a8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x006a8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x006a8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x006a8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x006a8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x006a8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x006a8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x006a8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x006a8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x006a8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x006a8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x006a8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x006a8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x006ac
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x006ac
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x006ac
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x006ac
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x006ac
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x006b0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x006b0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x006b0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x006b0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA13 */
#define REG_HCDMA13          0x006b4
#define REG_HCDMA13_MASK     0xffffffff
#define REG_HCDMA13_SHIFT    0
#define REG_HCDMA13_WIDTH    32

/* HCDMAB13 */
#define REG_HCDMAB13          0x006bc
#define REG_HCDMAB13_MASK     0xffffffff
#define REG_HCDMAB13_SHIFT    0
#define REG_HCDMAB13_WIDTH    32

/* CHENA */
#define REG_CHENA          0x006c0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x006c0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x006c0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x006c0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x006c0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x006c0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x006c0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x006c0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x006c0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x006c4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x006c4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x006c4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x006c4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x006c4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x006c8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x006c8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x006c8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x006c8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x006c8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x006c8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x006c8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x006c8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x006c8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x006c8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x006c8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x006c8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x006c8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x006c8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x006cc
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x006cc
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x006cc
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x006cc
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x006cc
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x006d0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x006d0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x006d0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x006d0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA14 */
#define REG_HCDMA14          0x006d4
#define REG_HCDMA14_MASK     0xffffffff
#define REG_HCDMA14_SHIFT    0
#define REG_HCDMA14_WIDTH    32

/* HCDMAB14 */
#define REG_HCDMAB14          0x006dc
#define REG_HCDMAB14_MASK     0xffffffff
#define REG_HCDMAB14_SHIFT    0
#define REG_HCDMAB14_WIDTH    32

/* CHENA */
#define REG_CHENA          0x006e0
#define REG_CHENA_MASK     0x80000000
#define REG_CHENA_SHIFT    31
#define REG_CHENA_WIDTH    1

/* CHDIS */
#define REG_CHDIS          0x006e0
#define REG_CHDIS_MASK     0x40000000
#define REG_CHDIS_SHIFT    30
#define REG_CHDIS_WIDTH    1

/* DEVADDR */
#define REG_DEVADDR          0x006e0
#define REG_DEVADDR_MASK     0x1fc00000
#define REG_DEVADDR_SHIFT    22
#define REG_DEVADDR_WIDTH    7

/* EC */
#define REG_EC          0x006e0
#define REG_EC_MASK     0x00300000
#define REG_EC_SHIFT    20
#define REG_EC_WIDTH    2

/* EPTYPE */
#define REG_EPTYPE          0x006e0
#define REG_EPTYPE_MASK     0x000c0000
#define REG_EPTYPE_SHIFT    18
#define REG_EPTYPE_WIDTH    2

/* LSPDDEV */
#define REG_LSPDDEV          0x006e0
#define REG_LSPDDEV_MASK     0x00020000
#define REG_LSPDDEV_SHIFT    17
#define REG_LSPDDEV_WIDTH    1

/* EPDIR */
#define REG_EPDIR          0x006e0
#define REG_EPDIR_MASK     0x00008000
#define REG_EPDIR_SHIFT    15
#define REG_EPDIR_WIDTH    1

/* EPNUM */
#define REG_EPNUM          0x006e0
#define REG_EPNUM_MASK     0x00007800
#define REG_EPNUM_SHIFT    11
#define REG_EPNUM_WIDTH    4

/* MPS */
#define REG_MPS          0x006e0
#define REG_MPS_MASK     0x000007ff
#define REG_MPS_SHIFT    0
#define REG_MPS_WIDTH    11

/* SPLTENA */
#define REG_SPLTENA          0x006e4
#define REG_SPLTENA_MASK     0x80000000
#define REG_SPLTENA_SHIFT    31
#define REG_SPLTENA_WIDTH    1

/* COMPSPLT */
#define REG_COMPSPLT          0x006e4
#define REG_COMPSPLT_MASK     0x00010000
#define REG_COMPSPLT_SHIFT    16
#define REG_COMPSPLT_WIDTH    1

/* XACTPOS */
#define REG_XACTPOS          0x006e4
#define REG_XACTPOS_MASK     0x0000c000
#define REG_XACTPOS_SHIFT    14
#define REG_XACTPOS_WIDTH    2

/* HUBADDR */
#define REG_HUBADDR          0x006e4
#define REG_HUBADDR_MASK     0x00003f80
#define REG_HUBADDR_SHIFT    7
#define REG_HUBADDR_WIDTH    7

/* PRTADDR */
#define REG_PRTADDR          0x006e4
#define REG_PRTADDR_MASK     0x0000007f
#define REG_PRTADDR_SHIFT    0
#define REG_PRTADDR_WIDTH    7

/* DESC_LST_ROLLINTR */
#define REG_DESC_LST_ROLLINTR          0x006e8
#define REG_DESC_LST_ROLLINTR_MASK     0x00002000
#define REG_DESC_LST_ROLLINTR_SHIFT    13
#define REG_DESC_LST_ROLLINTR_WIDTH    1

/* XCS_XACT_ERR */
#define REG_XCS_XACT_ERR          0x006e8
#define REG_XCS_XACT_ERR_MASK     0x00001000
#define REG_XCS_XACT_ERR_SHIFT    12
#define REG_XCS_XACT_ERR_WIDTH    1

/* BNAINTR */
#define REG_BNAINTR          0x006e8
#define REG_BNAINTR_MASK     0x00000800
#define REG_BNAINTR_SHIFT    11
#define REG_BNAINTR_WIDTH    1

/* DATATGLERR */
#define REG_DATATGLERR          0x006e8
#define REG_DATATGLERR_MASK     0x00000400
#define REG_DATATGLERR_SHIFT    10
#define REG_DATATGLERR_WIDTH    1

/* FRMOVRUN */
#define REG_FRMOVRUN          0x006e8
#define REG_FRMOVRUN_MASK     0x00000200
#define REG_FRMOVRUN_SHIFT    9
#define REG_FRMOVRUN_WIDTH    1

/* BBLERR */
#define REG_BBLERR          0x006e8
#define REG_BBLERR_MASK     0x00000100
#define REG_BBLERR_SHIFT    8
#define REG_BBLERR_WIDTH    1

/* XACTERR */
#define REG_XACTERR          0x006e8
#define REG_XACTERR_MASK     0x00000080
#define REG_XACTERR_SHIFT    7
#define REG_XACTERR_WIDTH    1

/* NYET */
#define REG_NYET          0x006e8
#define REG_NYET_MASK     0x00000040
#define REG_NYET_SHIFT    6
#define REG_NYET_WIDTH    1

/* ACK */
#define REG_ACK          0x006e8
#define REG_ACK_MASK     0x00000020
#define REG_ACK_SHIFT    5
#define REG_ACK_WIDTH    1

/* NAK */
#define REG_NAK          0x006e8
#define REG_NAK_MASK     0x00000010
#define REG_NAK_SHIFT    4
#define REG_NAK_WIDTH    1

/* STALL */
#define REG_STALL          0x006e8
#define REG_STALL_MASK     0x00000008
#define REG_STALL_SHIFT    3
#define REG_STALL_WIDTH    1

/* AHBERR */
#define REG_AHBERR          0x006e8
#define REG_AHBERR_MASK     0x00000004
#define REG_AHBERR_SHIFT    2
#define REG_AHBERR_WIDTH    1

/* CHHLTD */
#define REG_CHHLTD          0x006e8
#define REG_CHHLTD_MASK     0x00000002
#define REG_CHHLTD_SHIFT    1
#define REG_CHHLTD_WIDTH    1

/* XFERCOMPL */
#define REG_XFERCOMPL          0x006e8
#define REG_XFERCOMPL_MASK     0x00000001
#define REG_XFERCOMPL_SHIFT    0
#define REG_XFERCOMPL_WIDTH    1

/* FRM_LST_ROLLINTRMSK */
#define REG_FRM_LST_ROLLINTRMSK          0x006ec
#define REG_FRM_LST_ROLLINTRMSK_MASK     0x00002000
#define REG_FRM_LST_ROLLINTRMSK_SHIFT    13
#define REG_FRM_LST_ROLLINTRMSK_WIDTH    1

/* BNAINTRMSK */
#define REG_BNAINTRMSK          0x006ec
#define REG_BNAINTRMSK_MASK     0x00000800
#define REG_BNAINTRMSK_SHIFT    11
#define REG_BNAINTRMSK_WIDTH    1

/* AHBERRMSK */
#define REG_AHBERRMSK          0x006ec
#define REG_AHBERRMSK_MASK     0x00000004
#define REG_AHBERRMSK_SHIFT    2
#define REG_AHBERRMSK_WIDTH    1

/* CHHLTDMSK */
#define REG_CHHLTDMSK          0x006ec
#define REG_CHHLTDMSK_MASK     0x00000002
#define REG_CHHLTDMSK_SHIFT    1
#define REG_CHHLTDMSK_WIDTH    1

/* XFERCOMPLMSK */
#define REG_XFERCOMPLMSK          0x006ec
#define REG_XFERCOMPLMSK_MASK     0x00000001
#define REG_XFERCOMPLMSK_SHIFT    0
#define REG_XFERCOMPLMSK_WIDTH    1

/* DOPNG */
#define REG_DOPNG          0x006f0
#define REG_DOPNG_MASK     0x80000000
#define REG_DOPNG_SHIFT    31
#define REG_DOPNG_WIDTH    1

/* PID */
#define REG_PID          0x006f0
#define REG_PID_MASK     0x60000000
#define REG_PID_SHIFT    29
#define REG_PID_WIDTH    2

/* PKTCNT */
#define REG_PKTCNT          0x006f0
#define REG_PKTCNT_MASK     0x1ff80000
#define REG_PKTCNT_SHIFT    19
#define REG_PKTCNT_WIDTH    10

/* XFERSIZE */
#define REG_XFERSIZE          0x006f0
#define REG_XFERSIZE_MASK     0x0007ffff
#define REG_XFERSIZE_SHIFT    0
#define REG_XFERSIZE_WIDTH    19

/* HCDMA15 */
#define REG_HCDMA15          0x006f4
#define REG_HCDMA15_MASK     0xffffffff
#define REG_HCDMA15_SHIFT    0
#define REG_HCDMA15_WIDTH    32

/* HCDMAB15 */
#define REG_HCDMAB15          0x006fc
#define REG_HCDMAB15_MASK     0xffffffff
#define REG_HCDMAB15_SHIFT    0
#define REG_HCDMAB15_WIDTH    32

/* RESETAFTERSUSP */
#define REG_RESETAFTERSUSP          0x00e00
#define REG_RESETAFTERSUSP_MASK     0x00000100
#define REG_RESETAFTERSUSP_SHIFT    8
#define REG_RESETAFTERSUSP_WIDTH    1

/* L1SUSPENDED */
#define REG_L1SUSPENDED          0x00e00
#define REG_L1SUSPENDED_MASK     0x00000080
#define REG_L1SUSPENDED_SHIFT    7
#define REG_L1SUSPENDED_WIDTH    1

/* PHYSLEEP */
#define REG_PHYSLEEP          0x00e00
#define REG_PHYSLEEP_MASK     0x00000040
#define REG_PHYSLEEP_SHIFT    6
#define REG_PHYSLEEP_WIDTH    1

/* RSTPDWNMODULE */
#define REG_RSTPDWNMODULE          0x00e00
#define REG_RSTPDWNMODULE_MASK     0x00000008
#define REG_RSTPDWNMODULE_SHIFT    3
#define REG_RSTPDWNMODULE_WIDTH    1

/* PWRCLMP */
#define REG_PWRCLMP          0x00e00
#define REG_PWRCLMP_MASK     0x00000004
#define REG_PWRCLMP_SHIFT    2
#define REG_PWRCLMP_WIDTH    1

/* GATEHCLK */
#define REG_GATEHCLK          0x00e00
#define REG_GATEHCLK_MASK     0x00000002
#define REG_GATEHCLK_SHIFT    1
#define REG_GATEHCLK_WIDTH    1

/* STOPPCLK */
#define REG_STOPPCLK          0x00e00
#define REG_STOPPCLK_MASK     0x00000001
#define REG_STOPPCLK_SHIFT    0
#define REG_STOPPCLK_WIDTH    1
#endif 
