/*  Defines for WAVE500 with WRX500 */

#ifndef __CalibrationsDefines_h__
#define __CalibrationsDefines_h__


/**********************************************************************/
/***					Global Definitions                                                                   ***/
/**********************************************************************/


#define MAX_NUM_OF_BW						   3


#define ANTENNA_CONNECTED_DEFAULT_BITMAP 0xFF
#define ANTENNA_SELECTION_DEFAULT_BITMAP 0x55

// General enum for antenna numbering
typedef enum
{
    ANTENNA_0,
    ANTENNA_1,
    ANTENNA_2,
    ANTENNA_3,
    MAX_ANTENNA = ANTENNA_3,
    TOTAL_ANTENNAS,
}Antenna_e;

#define MAX_NUM_OF_ANTENNAS	                   TOTAL_ANTENNAS
#define MAX_NUM_OF_DIGITAL_ANTENNAS    (4)


typedef enum
{
    ANTENNA_BITMAP_NONE            = 0x0, /* binary(0000) */
    /* Single Antennas */
    ANTENNA_BITMAP_ANTENNA_0       = 0x1, /* binary(0001) */
    ANTENNA_BITMAP_ANTENNA_1       = 0x2, /* binary(0010) */
    ANTENNA_BITMAP_ANTENNA_2       = 0x4, /* binary(0100) */
    ANTENNA_BITMAP_ANTENNA_3       = 0x8, /* binary(1000) */
    /* Two Antennas */
    ANTENNA_BITMAP_ANTENNA_0_AND_1 = ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_1, /* binary(0011) */
    ANTENNA_BITMAP_ANTENNA_0_AND_2 = ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_2, /* binary(0101) */
    ANTENNA_BITMAP_ANTENNA_0_AND_3 = ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_3, /* binary(1001) */
    ANTENNA_BITMAP_ANTENNA_1_AND_2 = ANTENNA_BITMAP_ANTENNA_1 | ANTENNA_BITMAP_ANTENNA_2, /* binary(0110) */
    ANTENNA_BITMAP_ANTENNA_1_AND_3 = ANTENNA_BITMAP_ANTENNA_1 | ANTENNA_BITMAP_ANTENNA_3, /* binary(1010) */
    
    /* All Antennas */
    ANTENNA_BITMAP_ALL_ANTENNAS    = 0xf, /* binary(1111) */
	ANTENNA_BITMAP_ALL_ANTENNAS_GEN5 = 0xF, /* binary(1111) */
	ANTENNA_BITMAP_ALL_AFE_CHANNELS_GEN5 = 0x1F,
    
    ANTENNA_BITMAP_MAX_ANTENNAS    = 0xf,
}AntennaBitmaps_e;


typedef enum
{
	FCSI_CHANNEL_A,
	FCSI_CHANNEL_B,
	FCSI_CHANNEL_C,
	FCSI_CHANNEL_D,
	FCSI_CHANNEL_E,
	FCSI_TOTAL_CHANNELS
} FcsiChannels_e;

/* LNA index Enum */
/* The LNA active values are stored in the PHY registers in this order:   */
/*             ______________________________________                     */
/*             |  Low (MSB)  |  Mid  |  High (LSB)  |                     */
/*             |___[11:8]____|_[8:4]_|____[3:0]_____|                     */
/* We use this enum to address and ask for the actual value corresponding */
/* to the desired index. In W300 0 is usually the high index, and in AR10 */ 
/* it is usually 3. This enum helps iterate over all LNA's with no        */
/* platform dependency */
typedef enum HdkLnaIndex
{
    HDK_LNA_INDEX_MIN_INDEX = 0,
    HDK_LNA_INDEX_HIGH_GAIN = HDK_LNA_INDEX_MIN_INDEX,
    HDK_LNA_INDEX_MID_GAIN,
    HDK_LNA_INDEX_LOW_GAIN,
    HDK_LNA_INDEX_MAX_INDEX = 6,
    HDK_LNA_INDEX_NUM_OF_INDEXES = HDK_LNA_INDEX_MAX_INDEX,
} HdkLnaIndex_e;

#define MAX_NUMBER_OF_LNA_CROSSING_POINT 	7

/**********************************************************************/
/***					TxIQ                                                                              ***/
/**********************************************************************/

#define TX_IQ_ONLINE_NUM_BINS_CALIBRATED		(1) // The number of bins calibrated during one iteration of online calibration 

#define TX_IQ_MAX_VERIFY_ENERGY					(40)

#define TX_IQ_PGC3								(6)

#define TX_IQ_ENERGY_RESOLUTION					(9)
#define TX_IQ_ENERGY_LOG_RESOLUTION				(5)	

#define TX_IQ_VERIFY_REFERENCE_BIN				(16)

#define TX_IQ_PFIT_MAX_PNTS						(9)
#define TX_IQ_MAX_CALIBRATED_BINS           	(6)     //positive + negative bins, moved here from TxIQMismatchClbrHndlr.h
#define TX_IQ_TONE_AMPLITUDE		    		(10)
#define TX_IQ_TONE_AMPLITUDE_BW_OFFSET			(1)
#define TX_IQ_TONE_AMPLITUDE_DBV_CB         	(-14)	// changed from nCB Amplitude = -20  CB Amplitude = -14 
#define TX_IQ_TONE_AMPLITUDE_DBV_NCB        	(-17) 
#define TX_IQ_GRTZL_NUM_OF_CYCLES				(16)
#define TX_IQ_NUM_VERIFICATION_MEASUREMENTS		(1)		//Use powers of 2 only !!! Before changing this, pay attention to wrap-around caused by the sum of measurements

//max bins of single polarity - positive or negative
#define TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY	(TX_IQ_MAX_CALIBRATED_BINS>>1)	

#define TXIQ_NCB_FIRST_CALIBRATED_BIN   		(1)
#define TXIQ_NCB_SECOND_CALIBRATED_BIN  		(11)
#define TXIQ_NCB_LAST_CALIBRATED_BIN    		(28) 

#define TXIQ_CB_FIRST_CALIBRATED_BIN    		(2)
#define TXIQ_CB_SECOND_CALIBRATED_BIN   		(26)
#define TXIQ_CB_LAST_CALIBRATED_BIN     		(58)

#define TXIQ_CB80_FIRST_CALIBRATED_BIN    		(3)
#define TXIQ_CB80_SECOND_CALIBRATED_BIN   		(58)
#define TXIQ_CB80_LAST_CALIBRATED_BIN     		(122)

// TxIQ RF loop

#define TX_IQ_NUM_SAMPLES					(8192)
#define TX_IQ_ROUND							(8)
#define TX_IQ_IIR_MU						(9)
#define TX_IQ_PGC1							(18)
#define TX_IQ_PGC2							(12)
#define TX_IQ_LNA							(3)
#define IMR_RESOLUTION_BITS					(26)
#define IMR_RESOLUTION_dB	  				(3 * IMR_RESOLUTION_BITS)
#define I_Q_TRUNCATION_BITS					(12)
#define TX_IQ_ADAPTIVE_GAIN_ACCUM_HIGH		(350000)
#define TX_IQ_ADAPTIVE_GAIN_ACCUM_LOW		(35000)	
#define TX_IQ_ADAPTIVE_GAIN_AMP_HIGH		(15)
#define TX_IQ_ADAPTIVE_GAIN_AMP_LOW			(6)
#define TX_IQ_ADAPTIVE_GAIN_DIG_GAIN_HIGH	(450)
#define TX_IQ_ADAPTIVE_GAIN_DIG_GAIN_LOW	(128)

// TxIQ Single Side Band Calibration 

// Bandwith 80
#define TXIQ_LSB40_LSB20_20M					(-100)
#define TXIQ_LSB40_USB20_20M  					(-64)
#define TXIQ_USB40_LSB20_20M					(64)
#define TXIQ_USB40_USB20_20M   					(100)

#define TXIQ_LSB40_LSB20_40M  					(-100)
#define TXIQ_LSB40_USB20_40M  					(-100)
#define TXIQ_USB40_LSB20_40M					(100)
#define TXIQ_USB40_USB20_40M   					(100)

// Bandwith 40
#define TXIQ_LSB_20								(-28)
#define TXIQ_USB_20   							(28)

#define TXIQ_COEF_FIXED_POINT_SHIFT             (10)
#define TXIQ_ARCTAN_FIXED_POINT_SHIFT           (10)


typedef enum
{
	POSITIVE_RANGE = 1,
	NEGATIVE_RANGE,
	ALL_BIN_RANGES
} TxIqCalibratedBinsRange_e;

typedef enum
{
	BIN_CALIB_SUCCESS,	//calibration and verification succeeded
	BIN_VERIFY_FAIL,	//verify failed (and fix failed)
	BIN_FIX_SUCCESS,	//calibration or verify failed but fix succeeded (found adjacent successful bins)
	BIN_CALIB_NONE		//before calibration
} TxIqBinStatus_e;

/**********************************************************************/
/***					PhyRFIC                                                  				 ***/
/**********************************************************************/

#define DELAY_AFTER_PHY_RFIC_CHANGE 30
#define DELAY_CHANGE_PER_BW		 	10
#define MINIMUM_DELAY			 	1


#define TONE_AMPLITUDE_REFERENCE_SIGN   	(1)

/**********************************************************************/
/***					TxLO                                                   			          ***/
/**********************************************************************/

// Not in use
#define LO_PGC1								(0)	
#define LO_PGC2								(0)	
#define LO_PGC3								(6)
//

#define LO_TONE_AMPLITUDE					(10)

#define LO_GRTZL_NUM_OF_CYCLES				(16)

#define LO_NUM_VERIFICATION_MEASUREMENTS	(1) // Before changing this, pay attention to wrap-around caused by the sum of measurements

//I,Q DAC value ranges
#define LO_DAC_MIN							(-16)	
#define LO_DAC_MAX							(15)

// Maximum iterations during binary search
#define LO_MAX_BINARY_SEARCH_STEPS			(8) 

// Maximum iterations during linear search
#define LO_MAX_LINEAR_SEARCH_STEPS			(0)	


// cancel LO leakage also from the base-band
#define LO_CLIP_MIN							(-14)	
#define LO_CLIP_MAX							(13)	

#define LO_CALIB_BIN						(3)

#define LO_MAX_VERIFY_ENERGY_DIFF			(35)
#define LO_VERIFY_REFERENCE_BIN				(16)
#define LO_VERIFY_REFERENCE_TPC_IDX			(0)	//Note: the verify reference TPC index currently must equal 0 since it 
#define LO_BINARY_PIVOT						(0)	//must be calibrated first and is used as reference for 
												//calibration verification of all other TPC's

#define LO_INFINITE_ENERGY 					(1 << 30)	

/* Maximum iterations during binary search */

#define LO_DAC_NUM_ITER_OFFLINE				(2)
#define LO_DIGITAL_DAC_NUM_ITER				(5)


// cancel LO leakage also from the base-band
#define LO_DIGITAL_DAC_ADDITION				(1<<(LO_DIGITAL_DAC_NUM_ITER-1)) //16

#define LO_DIGITAL_DAC_MAX					(32)
#define LO_DIGITAL_DAC_MIN					(-32)
#define LO_DIGITAL_DAC_INIT					(0)

#define LO_ENERGY_RESOLUTION				(9)
#define LO_ENERGY_LOG_RESOLUTION			(5)

#define LO_ONLINE_NUM_TPCS_CALIBRATED		(2)	// The number of TPCs calibrated during one iteration of online calibration 
												//must be <= tpcInfo.numCalibTpcs		

#define	LO_DIGITAL_DAC_TPC_IDX 				(0)	//index inside tpcArray of the TPC used for digital DAC calibration
												//must be one of the calibrated TPC's
												//Note: the digital DAC TPC index currently must equal 0 since it 
												//is also used as the calibration verification reference TPC
#define LO_DIGITAL_GAIN						(256)


/**********************************************************************/
/***					TPC		                                                  			          ***/
/**********************************************************************/
#define MAX_TSSI_SECTIONS	4
#define GAIN_RESOLUTION		3

#define DIG_LOWER_LIMIT_DEFAULT			((int16)(-(1 << GAIN_RESOLUTION)))				// -1 db
#define PRE_DRV_MIN_GAIN_DEFAULT		((int16)(-(29 << (GAIN_RESOLUTION - 1))))		// -14.5 db
#define PGC_MIN_GAIN_DEFAULT			((int16)(-(6 << GAIN_RESOLUTION)))				// -6 db
#define PGC_STEP_DEFAULT				((int16)(4 << GAIN_RESOLUTION))					// 4 db
#define PGC_LOWER_LIMIT_DEFAULT			((int16)(-(6 << GAIN_RESOLUTION)))				// -6 db
#define PGC_UPPER_LIMIT_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define PRE_DRV_STEP_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define PRE_DRV_LOWER_LIMIT_DEFAULT		((int16)(-(45 << (GAIN_RESOLUTION - 1))))		// -22.5 db
#define PRE_DRV_UPPER_LIMIT_DEFAULT		((int16)(15 << (GAIN_RESOLUTION - 1)))			// 7.5 db
#define DIG_STEP_DEFAULT				((int16)(1 << (GAIN_RESOLUTION - 2)))			// 0.25 db
#define DIG_MAX_GAIN_DEFAULT			((int16)(1 << GAIN_RESOLUTION))					// 1 db
#define DIG_UPPER_LIMIT_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define DIG_MIN_GAIN_DEFAULT			((int16)(-(1 << GAIN_RESOLUTION)))				// -1 db
#define POWER_VECTOR_LEN_DEFAULT		(64)
#define MIN_POWER_DEFAULT				(0)												// 0 db
#define MIN_POWER_INDEX_DEFAULT			(0)
#define POWER_VEC_STEP_DEFAULT			((int16)(1 << (GAIN_RESOLUTION - 1)))			// 0.5 db
#define NUM_TSSI_CUT_POINTS_DEFAULT		(3)
#define PGC_WORD_OFFSET_DEFAULT			((int16)(6 << GAIN_RESOLUTION))					// 6 db
#define PGC_WORD_SHIFT_DEFAULT			(GAIN_RESOLUTION + 2)
#define PRE_DRV_WORD_OFFSET_DEFAULT		((int16)(45 << (GAIN_RESOLUTION - 1)))			// 22.5 db
#define PRE_DRV_WORD_SHIFT_DEFAULT		(GAIN_RESOLUTION + 1)
#define DIG_WORD_OFFSET_DEFAULT			((int16)(1 << GAIN_RESOLUTION))					// 1 db
#define DIG_WORD_SHIFT_DEFAULT			(GAIN_RESOLUTION - 2)

#define TPC_CHARACTERIZATION_LINEAR		(0)
#define TPC_CHARACTERIZATION_LOG		(1)
#define TPC_CHARACTERIZATION_SQUARE		(2)
#define TPC_CHARACTERIZATION_DEFAULT	TPC_CHARACTERIZATION_LOG

#define DIGITAL_WORD_WIDTH				(9)
#define DIGITAL_WORD_SHIFT				(0)
#define PGC_WORD_WIDTH					(2)
#define PGC_WORD_SHIFT					(DIGITAL_WORD_WIDTH)
#define PRE_DRV_WORD_WIDTH				(4)
#define PRE_DRV_WORD_SHIFT				(PGC_WORD_SHIFT + PGC_WORD_WIDTH)

#define TPC_MAX_S2D_REGIONS				3

#define TPC_GAIN_TABLE_START_ADDR		(0x9000)
#define TPC_POWER_OUT_START_ADDR		(0x8000)
#define TPC_TSSI_TABLE_START_ADDR		(0x8800)
#define TPC_TSSI_NUM_WORDS_IN_REGION	2
#define TPC_TSSI_NUM_WORDS_PER_ANT		(MAX_NUM_OF_BW * TPC_MAX_S2D_REGIONS * TPC_TSSI_NUM_WORDS_IN_REGION)
#define TPC_S2D_RAM_B_SHIFT				16
#define TPC_S2D_RAM_A_SHIFT				0
#define TPC_S2D_RAM_OFFSET_SHIFT		16
#define TPC_S2D_RAM_GAIN_SHIFT			5
#define TPC_S2D_RAM_PTHRESHOLD_SHIFT	25
#define TPC_S2D_RAM_PTHRESHOLD_MASK		(0x7E000000)
#define TPC_S2D_RAM_PTHRESHOLD_INVALID	(0xFF)

#define TPC_S2D_RAM_MASK				(0x7FFF0000)
#define TPC_TSSI_TABLE_BW_SECTION_SIZE 	(TPC_MAX_S2D_REGIONS * TPC_TSSI_NUM_WORDS_IN_REGION)

#define GAIN_TABLE_BYTES_WIDTH			(4)
#define GAIN_TABLE_ENTRIES				(128)

#define POWER_VECTOR_WORD_WIDTH			(7)
#define POWER_VEC_ANT_SECTION_SIZE		(96)
#define POWER_VEC_BW_SECTION_SIZE		(32)
#define POWER_VEC_BYTES_WIDTH			(4)

#define TPC_ACC_ENABLE_MASK				1
#define TPC_OPEN_LOOP_INDEX				0

#define TPC_POWER_OUT_MAX_ROWS	64

/**********************************************************************/
/***				RxIQ	                                                                                    ***/
/**********************************************************************/

/* these are defaults for the params */
#define RX_IQ_MAX_NUM_OF_BW			(3)	
#define	RX_IQ_VALID_BW				(0xFF)
#define RX_IQ_NUM_SAMPLES_OFFLINE			(600000)
#define RX_IQ_NUM_SAMPLES_ONLINE_FIRST_STAGE			(300000)
#define RX_IQ_NUM_SAMPLES_ONLINE_SECOND_STAGE			(300000)
#define RX_IQ_NUM_SAMPLES_ONLINE_VERIFY_STAGE			(50000)



#define RX_IQ_ROUND					(4)
#define RX_IQ_IIR_MU				(9)
#define RX_IQ_PGC1					(18)
#define RX_IQ_PGC2					(12)
#define RX_IQ_PGC3					(0)
#define RX_IQ_PGC3_STEP				(0)
#define W2_NUM_RES_BITS				(13)	// number of bits used after the decimal point for W2
#define W1_ERROR_VAL				(58)	// which is -43dBc IMR (for fixed point with W1_NUM_OF_FRAC_BITS(12))
#define W2_ERROR_VAL				(116)	// which is -43dBc IMR (for fixed point with W2_NUM_RES_BITS(13))
#define RX_IQ_LNA					(HDK_LNA_INDEX_MAX_INDEX-1)




/**********************************************************************/
/***					RxDC	                                                  			          ***/
/**********************************************************************/

#define RXDC_TABLE1_SECTION_LEN				(55)
#define RXDC_TABLE1_CORRECTION_LEN			(22)
#define RXDC_TABLE1_LNA_NUM					(5)
#define RXDC_TABLE1_PGC1_NUM				(8)
#define RXDC_TABLE1_BYTE_WIDTH				(4)
#define RXDC_TABLE1_START_ADDRESS			(PHY_RX_TD_BASE_ADDRESS + 0x2A000)
#define RXDC_TABLE1_FIELD_BIT_WIDTH			(6)///
#define RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH	(6)
#define RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH	(5)
#define RXDC_TABLE1_FIELD_MASK				((1 << RXDC_TABLE1_FIELD_BIT_WIDTH) - 1)
#define RXDC_TABLE1_DAC1_FIELD_MASK			((1 << RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH) - 1)
#define RXDC_TABLE1_DAC2_FIELD_MASK			((1 << RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH) - 1)
#define RXDC_TABLE2_FIELD_BIT_WIDTH			(5)
#define RXDC_TABLE2_FIELD_MASK				((1 << RXDC_TABLE2_FIELD_BIT_WIDTH) - 1)
#define RXDC_TABLE2_SECTION_LEN				(12)
#define RXDC_TABLE2_BYTE_WIDTH				(4)
#define RXDC_TABLE2_START_ADDRESS			(PHY_RX_TD_BASE_ADDRESS + 0x2C000)
#define RXDC_PGC_TO_INDEX_SHIFT				(0)
#define RXDC_PGC_TO_INDEX_STEP				(2)

#define RXDC_TABLE2_LNA_LUT_SECTION_LEN		(16)

#define RXDC_CONFIG_MAX_DC_LEVEL_MASK			(0xFFFF)
#define RXDC_CONFIG_MAX_DC_LEVEL_SHIFT			(0)
#define RXDC_CONFIG_CALIBRATION_MODE_MASK		(0x30000)
#define RXDC_CONFIG_CALIBRATION_MODE_SHIFT		(16)
#define RXDC_CONFIG_WRITE_TO_RFIC_MASK			(0x40000)
#define RXDC_CONFIG_WRITE_TO_RFIC_SHIFT			(18)
#define RXDC_CONFIG_RESIDUAL_BYPASS_MASK		(0x80000)
#define RXDC_CONFIG_RESIDUAL_BYPASS_SHIFT		(19)
#define RXDC_CONFIG_POWER_NUM_SAMPLES_MASK		(0x1F00000)
#define RXDC_CONFIG_POWER_NUM_SAMPLES_SHIFT		(20)

#define RXDC_CONFIG_CALIBRATION_MODE_CHIP		(0)
#define RXDC_CONFIG_CALIBRATION_MODE_SW			(1)
#define RXDC_CONFIG_CALIBRATION_MODE_NONE		(2)

#define RXDC_BW_FOR_DAC2_CAL					(0)
#define RXDC_PGC1_GAIN_FOR_DAC2_CAL				(0)
#define RXDC_PGC3_GAIN_FOR_DAC2_CAL				(0)
#define RXDC_LNA_GAIN_FOR_DAC2_CAL				(0)
#define RXDC_PGC2_GAIN_FOR_DAC0_CAL				(0)

#define RXDC_NUM_PGC2_GAINS						(12)
#define RXDC_GAIN_WORD_LNA_MASK					(0xFF000000)
#define RXDC_GAIN_WORD_LNA_SHIFT				(24)
#define RXDC_GAIN_WORD_PGC1_MASK				(0x00FF0000)
#define RXDC_GAIN_WORD_PGC1_SHIFT				(16)
#define RXDC_GAIN_WORD_PGC2_MASK				(0x0000FF00)
#define RXDC_GAIN_WORD_PGC2_SHIFT				(8)
#define RXDC_GAIN_WORD_PGC3_MASK				(0x000000FF)
#define RXDC_GAIN_WORD_PGC3_SHIFT				(0)

#define PGC2_HIGH_GAIN_DB						(18)
#define PGC2_INDEX_TO_GAIN_FACTOR				(2)
#define PGC2_INDEX_TO_GAIN_BIAS					(8)
#define PGC1_INDEX_TO_GAIN_FACTOR				(2)
#define PGC1_INDEX_TO_GAIN_BIAS					(0)

#define RXDC_CORRELATOR_SHIFT_FACTOR			(2)

#define RXDC_NUM_PGC3_GAINS						(1)
#define RXDC_NUM_PGC1_GAINS						(11)
#define RXDC_NUM_LNA_GAINS						(6)
#define RXDC_MAX_NUM_OF_GAIN_PERMUTATIONS		(RXDC_NUM_LNA_GAINS * RXDC_NUM_PGC1_GAINS * RXDC_NUM_PGC3_GAINS)
#define RXDC_NON_EXIST_GAIN						(0xFF)
#define RXDC_MAX_GAIN_PERMUTATIONS				(15)

#define RXDC_DIGITAL_GAIN						(0)
#define RXDC_MAX_NUM_OF_RETRIES			5

#define RXDC_DAC2_OFFLINE_MAX_STEPS		5
#define RXDC_DAC1_OFFLINE_MAX_STEPS		6
#define RXDC_DAC2_OFFLINE_INITIAL_STEP	8
#define RXDC_DAC1_OFFLINE_INITIAL_STEP	16

#define RXDC_REF_PGC2_GAIN			12
#define RXDC_REF_PGC2_INDEX			10

#define LNA_CONVERSIONS_START_ADDRESS			(RXDC_TABLE2_START_ADDRESS + 0x90)
#define LNA_GAIN_START_ADDRESS			(RXDC_TABLE2_START_ADDRESS + 0xb0)

#define LNA_CONVERSIONS_ANT_OFFSET				(0xD0)
#define LNA_GAIN_ANT_OFFSET				(0xD0)

#define RXDC_DAC1_MAX_VALUE			31
#define RXDC_DAC1_MIN_VALUE			(-32)

#define RXDC_DAC2_MAX_VALUE			15
#define RXDC_DAC2_MIN_VALUE			(-16)

// Algorithm state groups
#define FIRST_STATE									(0)

// DAC limits
#define PGC2_MAX_VALUE								(24)
#define PGC2_MIN_VALUE								(-6) //if you change here need also change in factor in CalcResidualCorrection
#define PGC2_STEP									(6)
#define PGC1_MAX_VALUE								(24)
#define PGC1_MIN_VALUE								(-6)
#define PGC1_STEP									(6)

#endif
