/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mt_sysrst.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "shram_man_msgs.h"
#include "queue_utility.h"
#include "lmi.h"
#include "ProgModelLoader.h"
#include "CalibrationManager.h"
#include "CalibrationHandler.h"
#include "RssiPathClbrHndlr.h"
#include "CtsManager_Api.h"
#include "ChannelSwitchManager_Api.h"
#include "ServicesHandler_Api.h"
#include "init_ifmsg.h"
#include "mib_ms.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"
#include "LmHdk_API.h"
#include "Afe_API.h"
#include "RficDriver_API.h"
#include "RficCommon.h"
#include "Indirect_API.h"
#include "Utils_Api.h"
#include "EventsManager_api.h"
#include "Pac_Api.h"

/*---------------------------------------------------------------------------------
/						Defines							
/----------------------------------------------------------------------------------*/

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 	15 
#define PROCESS_DUTYCYCLE_PRE_SERVICES_BITMAP			(TRUE << SERVICE_ID_PAUSE_ALL) | (TRUE << SERVICE_ID_SEND_CTS_SELF_FRAME)
#define PROCESS_DUTYCYCLE_POST_SERVICES_BITMAP			(TRUE << SERVICE_ID_RESUME_ALL)
#define PROCESS_DUTYCYCLE_SERVICE_DATA_BITMAP			((CTS2SELF_DURATION_MSEC_RSSI_MODE) << CTS2SELF_DURATION_MASK_SHIFT)

/*---------------------------------------------------------------------------------
/						Macro's						
/----------------------------------------------------------------------------------*/
#define VERIFY_BOOL(x)  (!((x) & 0xFE))

/*---------------------------------------------------------------------------------
/						Static functions									
/----------------------------------------------------------------------------------*/
static void dutycycleChangeState(DutyCycleState_e state);
static void dutycycleRunStateMachine(DutyCycleEvent_e event,K_MSG *pMsg);
static void dutycycleSetReqSendConfirm(void);
static void dutycycleScheduleProcessStart(void);
static bool dutycycleCheckProcessRejected(K_MSG *pMsg);
static void dutycycleInvalidEvent(K_MSG* pMsg);
/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/
dutycycleDB_t dutycycleDB;



static const DutyCycleStateMachineFunctionEntry_t DutyCycleSM[DC_NUMBER_OF_STATES][DC_NUMBER_OF_EVENTS] = 
{
	/*STATE - DC_STATE_DISABLE  */
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/
	dutycycleInvalidEvent,							 	/*DC_EVENT_PROCESS_START*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_END*/
	dutycycleInvalidEvent								/*DC_EVENT_TIMER_EXPIRED*/
	},

	/*STATE - DC_STATE_WAIT_PROCESS_START  */
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/													
	dutycycleProcessStart,								/*DC_EVENT_PROCESS_START*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_END*/
	dutycycleInvalidEvent								/*DC_EVENT_TIMER_EXPIRED*/
	},

	/*STATE - DC_STATE_WAIT_PROCESS_START_DISABLE*/
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/													
	dutycycleProcessStart,								/*DC_EVENT_PROCESS_START*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_END*/
	dutycycleInvalidEvent								/*DC_EVENT_TIMER_EXPIRED*/
	},
	/*STATE - DC_STATE_RF_OFF  */
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/														
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_START*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_END*/
	dutycycleRfOffTimerExpired							/*DC_EVENT_TIMER_EXPIRED*/
	},

	/*STATE - DC_STATE_WAIT_PROCESS_END  */
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/														
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_START*/
	dutycycleProcessEnd,								/*DC_EVENT_PROCESS_END*/
	dutycycleInvalidEvent								/*DC_EVENT_TIMER_EXPIRED*/
	},
	
	/*STATE - DC_STATE_WAIT_PROCESS_END_DISABLE*/
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/														
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_START*/
	dutycycleProcessEnd,								/*DC_EVENT_PROCESS_END*/
	dutycycleInvalidEvent								/*DC_EVENT_TIMER_EXPIRED*/
	},

	/*STATE - DC_STATE_RF_ON */
	{
	dutycycleDisableExecution,							/*DC_EVENT_DISABLE*/
	dutycycleEnableExecution,							/*DC_EVENT_ENABLE*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_START*/
	dutycycleInvalidEvent,								/*DC_EVENT_PROCESS_END*/
	dutycycleRfOnTimerExpired							/*DC_EVENT_TIMER_EXPIRED*/
	},
};

/********************************************************************************************************************************/
/*********************************************** Utility static functions **************************************************************/
/********************************************************************************************************************************/
static void dutycycleChangeState(DutyCycleState_e state)
{

#ifdef HDK_LOGS
	ILOG0_DD("Change DutyCycle State,from %d, to %d ", dutycycleDB.dutycycleSmState, state);
#endif
	dutycycleDB.dutycycleSmState = state;
}

static void dutycycleRunStateMachine(DutyCycleEvent_e event,K_MSG *pMsg)
{

#ifdef HDK_LOGS
	ILOG0_DD("Run DutyCycle SM, event %d, state %d", event, dutycycleDB.dutycycleSmState);
#endif

	DutyCycleSM[dutycycleDB.dutycycleSmState][event](pMsg);

}


static void dutycycleSetReqSendConfirm()
{
	if(dutycycleDB.pMsg != NULL)
	{
	OSAL_SEND_MESSAGE(UMI_MC_MAN_DUTY_CYCLE_SET_CFM, TASK_UM_IF_TASK, dutycycleDB.pMsg, dutycycleDB.pMsg->header.vapId);
	}
	dutycycleDB.pMsg = NULL;
}

static void dutycycleScheduleProcessStart()
{
	
	K_MSG *pMsg_m = NULL;
	ProcessRequestParams_t *processRequestParams = NULL;
	
	//schedule process
	pMsg_m = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(pMsg_m);
	processRequestParams->processId 				= PROCESS_ID_DUTY_CYCLE;
	processRequestParams->startProcessMsg 			= HDK_DUTY_CYCLE_PROCESS_START;
	processRequestParams->requesterParams			= NULL;
	processRequestParams->preProcessServiceBitmap  	= PROCESS_DUTYCYCLE_PRE_SERVICES_BITMAP	;									
	processRequestParams->endProcessMsg				= HDK_DUTY_CYCLE_END_PROCESS; 
	processRequestParams->postProcessServiceBitmap 	= PROCESS_DUTYCYCLE_POST_SERVICES_BITMAP;
	processRequestParams->returnTask				= TASK_HDK; 
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
	processRequestParams->serviceData				= PROCESS_DUTYCYCLE_SERVICE_DATA_BITMAP;
	processRequestParams->dualBandProcess			= 		 TRUE;
	processRequestParams->processMsgHandledByCdbProcessMan = FALSE;
	processRequestParams->vapId 					= ConfigurationManager_GetFirstVapForMyBand(); 

#ifdef HDK_LOGS
	ILOG0_V("dutycycleScheduleProcessStart() - SCHEDULING DUTY CYCLE PROCESS ");
	ILOG0_D("dutycycleScheduleProcessStart() pMsg_m->header.vapId:%d",processRequestParams->vapId);
#endif

	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST, TASK_PROCESS_MANAGER, pMsg_m, processRequestParams->vapId);
}

static bool dutycycleCheckProcessRejected(K_MSG *pMsg)
{
    ProcessManagerReturnParams_t* processManagerReturnParams;

	/*In case last VAP process was pending or running when process was requested, Process manager will reject it*/
	processManagerReturnParams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(pMsg);		
    if (processManagerReturnParams->processStatus == PROCESS_STATUS_REQUEST_REJECTED)
    {
		return (TRUE);
    }
	else
	{
		return (FALSE);
	}
}
	
static void dutycycleInvalidEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	ASSERT(0);
}


/********************************************************************************************************************************/
/*********************************************** Event Handlers ***************************************************************/
/********************************************************************************************************************************/

void dutycycleRfOnTimerExpired(K_MSG* pMsg)
{

	UNUSED_PARAM(pMsg);
	
	if (dutycycleDB.dutycycleSmState == DC_STATE_RF_ON)
	{

#ifdef HDK_LOGS
		/*DEBUG- print RF On duration*/
		ILOG0_D("dutycycleRfOnTimerExpired() RFon Timer duration: %d" ,TIME_STAMP(END_TIME,dutycycleDB.StartTsRfOn));
#endif

	}
	

	/* wait for Process Start*/
	dutycycleChangeState(DC_STATE_WAIT_PROCESS_START);

	/*Request Process Manager to schedule  process*/
	dutycycleScheduleProcessStart();
	
	/*Debug - Capture tsf to cts2self start */
	dutycycleDB.StartTsCts2self = TIME_STAMP(START_TIME,0);

	
}

void dutycycleRfOffTimerExpired(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;
	dummyMsg = ProcessManager_GetDummyMessage();
	uint8 vapId = ConfigurationManager_GetFirstVapForMyBand();
		

#ifdef HDK_LOGS
	ILOG0_D("dutycycleRfOffTimerExpired() RFoff Timer duration: %d" ,TIME_STAMP(END_TIME,dutycycleDB.StartTsRfOff));
	ILOG0_D("dutycycleRfOffTimerExpired() vapId:%d",vapId);
#endif

	/*Turn RF On*/
	ILOG0_V("DUTYCYCLE --  ENABLE -- RADIO -- API");
	HDK_TurnRadioOffOn(ENABLE_RADIO);	

	/*DEBUG- print RF Off duration*/
	ILOG0_D("dutycycleRfOffTimerExpired() RFoff Timer duration + EnableRadio runtime: %d" ,TIME_STAMP(END_TIME,dutycycleDB.StartTsRfOff));

	/*wait for Process End confirmation*/ 
	dutycycleChangeState(DC_STATE_WAIT_PROCESS_END);

	/*Notify process manager execution is done*/ 	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);

}



void dutycycleProcessStart(K_MSG* pMsg)
{

	K_MSG* dummyMsg = NULL;
	uint8 vapId = ConfigurationManager_GetFirstVapForMyBand();
	
	if (dutycycleCheckProcessRejected(pMsg) == TRUE)
	{

#ifdef HDK_LOGS
		ILOG0_V("dutycycleProcessStart()------ASSERT----- dutycycleCheckProcessRejected() = TRUE ");
#endif
		ASSERT(0);
	}	

	switch (dutycycleDB.dutycycleSmState)
	{	
		case DC_STATE_WAIT_PROCESS_START:

		{
			/*DEBUG- print Cts2Self duration*/
#ifdef HDK_LOGS
			ILOG0_D("dutycycleProcessStart() Cts2self duration: %d" ,TIME_STAMP(END_TIME,dutycycleDB.StartTsCts2self));
			ILOG0_D("dutycycleProcessStart() vapId:%d", vapId);
#endif

			/*DEBUG- Capture tsf to RFoff timer start */
			dutycycleDB.StartTsRfOff= TIME_STAMP(START_TIME,0);

			/*Start RF off timeout*/
			OSAL_SET_TIMER_EXPLICIT(HDK_DUTY_CYCLE_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(dutycycleDB.dutycycleRfOffTimeout), TASK_HDK);

#ifdef HDK_LOGS
			/*Turn RF Off*/
			ILOG0_V("DUTYCYCLE --  DISABLE -- RADIO -- API");
#endif

			/*change state RF Off*/
			dutycycleChangeState(DC_STATE_RF_OFF);

			//HDK_TurnRadioOffOn(DISABLE_RADIO); 

			

			break;
		}

		case DC_STATE_WAIT_PROCESS_START_DISABLE:
		{
			/*We were requested to disable while we were waiting for the process to be scheduled. we changed state and waited for the process to be scheduled*/
			/*Just request Process Manager to end process*/	
			
			dummyMsg = ProcessManager_GetDummyMessage();
			
			/* wait for it*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_END_DISABLE);

			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);

			break;
		}

		default:
		{
			ASSERT(0)
		}
	}

}


void dutycycleProcessEnd(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	switch (dutycycleDB.dutycycleSmState)
	{	
		case DC_STATE_WAIT_PROCESS_END:
		{
			dutycycleChangeState(DC_STATE_RF_ON);
			
			/*Debug - Capture tsf to RFoff timer start */
			dutycycleDB.StartTsRfOn= TIME_STAMP(START_TIME,0);

			/*Start RF on timeout*/
			OSAL_SET_TIMER_EXPLICIT(HDK_DUTY_CYCLE_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(dutycycleDB.dutycycleRfOnTimeout), TASK_HDK);

			break;
		}
		case DC_STATE_WAIT_PROCESS_END_DISABLE:
		{
			/*Enable online calibration*/
			ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE); 

			/*change state - Disable*/
			dutycycleChangeState(DC_STATE_DISABLE);

			/*Send confitmation*/
			dutycycleSetReqSendConfirm();

			break;
		}
		default:
		{
			ASSERT(0)
		}

	}

}



void dutycycleDisableExecution(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);
	K_MSG *dummyMsg = NULL;
	uint8 vapId = ConfigurationManager_GetFirstVapForMyBand();

	switch (dutycycleDB.dutycycleSmState)
	{
		
		case DC_STATE_WAIT_PROCESS_START:
		{
			/*change state*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_START_DISABLE);
			break;
		}
		case DC_STATE_WAIT_PROCESS_END:
		{
			/*change state*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_END_DISABLE);
			break;
		}
		case DC_STATE_RF_OFF:
		{
			dummyMsg = ProcessManager_GetDummyMessage();

#ifdef HDK_LOGS
			/*Turn RF On*/
			ILOG0_V("DUTYCYCLE --  ENABLE -- RADIO -- API");
#endif
			HDK_TurnRadioOffOn(ENABLE_RADIO); 

			/*Reset Timer*/
			OSAL_RESET_TIMER_EXPLICIT(HDK_DUTY_CYCLE_TIMER_EXPIRED, TASK_HDK);

			/*change state*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_END_DISABLE);	
			
			/*request Process Manager to end process*/
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);

			break;
		}

		case DC_STATE_RF_ON:
		{
			/*Enable online calibration*/
			ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE); 

			/*Reset Timer*/
			OSAL_RESET_TIMER_EXPLICIT(HDK_DUTY_CYCLE_TIMER_EXPIRED, TASK_HDK);

			/*change state*/
			dutycycleChangeState(DC_STATE_DISABLE);

			/*Send confitmation*/
			dutycycleSetReqSendConfirm();
			break;
		}

		case DC_STATE_DISABLE:
		case DC_STATE_WAIT_PROCESS_START_DISABLE:	
		case DC_STATE_WAIT_PROCESS_END_DISABLE:
		{
			dutycycleSetReqSendConfirm();
			break;
		}	
		default:
		{
			ASSERT(0)
		}	
		
	}

}



void dutycycleEnableExecution (K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	switch (dutycycleDB.dutycycleSmState)
	{
		case DC_EVENT_DISABLE:
		{
			/*Disable online calibration*/
			ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE); 
			/*Wanted sequence*/
			dutycycleRfOnTimerExpired(pMsg);
			break;
		}
		case DC_STATE_WAIT_PROCESS_START_DISABLE:	
		{
			/*We were waiting for process to start so we could notify processmanager task is done - user changed its mind and enabled us again*/
			/*change state to wait for process start*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_START);
			break;
		}
		case DC_STATE_WAIT_PROCESS_END_DISABLE:
		{
			/*We were waiting for process to end so we could disable - user changed its mind and enabled us again*/
			/*change state to wait for process start*/
			dutycycleChangeState(DC_STATE_WAIT_PROCESS_END);
			break;
		}

		case DC_STATE_WAIT_PROCESS_START:
		case DC_STATE_RF_OFF:
		case DC_STATE_WAIT_PROCESS_END:
		case DC_STATE_RF_ON:
			break;
		
		default:
		{
			ASSERT(0)
		}	
	}

	/*Send confitmation*/
	dutycycleSetReqSendConfirm();	
}


/********************************************************************************************************************************/
/*********************************************** Global functiops ***************************************************************/
/********************************************************************************************************************************/
void HDK_DCRequest(K_MSG *pMsg)
{
	UMI_DCSet_t* param;

	ASSERT(dutycycleDB.pMsg == NULL);
	/*Store message*/
	dutycycleDB.pMsg = pMsg;
	
	param = (UMI_DCSet_t*)pK_MSG_DATA(pMsg);

	/*  Input Verification	*/
	ASSERT(VERIFY_BOOL(param->isDutyCycleEnable));
	//ASSERT(VERIFY_BOOL(param->isDutyCycleForce));
	/*		 * 		* 		*/

	dutycycleDB.isEnabled = param->isDutyCycleEnable;
	 
	
	if (param->isDutyCycleEnable == 1)
	{
		ASSERT(param->radioOffTimeInMsecs); //if enable cannot input - 0
		ASSERT(param->radioOnTimeInMsecs); // if enable cannot input - 0
		
		dutycycleDB.dutycycleRfOffTimeout = param->radioOffTimeInMsecs;
		dutycycleDB.dutycycleRfOnTimeout =  param->radioOnTimeInMsecs;
		

#ifdef HDK_LOGS
		ILOG0_D("HDK_DCRequest() dutycycleDB.pMsg->header.vapId:%d",dutycycleDB.pMsg->header.vapId);
		ILOG0_DDD("HDK_DCRequest() dutycycleRfOffTimeOut:%d dutycycleRfOnTimeout:%d isEnabled:%d",dutycycleDB.dutycycleRfOffTimeout, dutycycleDB.dutycycleRfOnTimeout, dutycycleDB.isEnabled);
#endif	
	
		dutycycleRunStateMachine(DC_EVENT_ENABLE, pMsg);
	}
	else
	{	
		dutycycleRunStateMachine(DC_EVENT_DISABLE, pMsg);
	}
}

void HDK_DCRemoveLastVap (K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	
	if (dutycycleDB.dutycycleSmState != DC_STATE_DISABLE)
 	{

#ifdef HDK_LOGS
 		ILOG0_D("HDK_DCRemoveLastVap()------ASSERT----- dutycycleSmState: %d", dutycycleDB.dutycycleSmState);
#endif

		dutycycleRunStateMachine(DC_EVENT_DISABLE, pMsg);
		//ASSERT(0);
 	} 	
}


void HDK_DCTimerExpired(K_MSG* pMsg)
{
	/*Run State machine*/
	dutycycleRunStateMachine(DC_EVENT_TIMER_EXPIRED,pMsg);
}

void HDK_DCProcessStart(K_MSG *psMsg)
{
	/*Run State machine*/
	dutycycleRunStateMachine(DC_EVENT_PROCESS_START,psMsg);
}

void HDK_DCEndProcess(K_MSG *psMsg)
{
	/*Run State machine*/
	dutycycleRunStateMachine(DC_EVENT_PROCESS_END,psMsg);
}

bool HDK_DCisEnable()
		
	
{
	if (dutycycleDB.dutycycleSmState != DC_STATE_DISABLE)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}


void HDK_DCRadioOnOffCommand(uint32 radioOnOff)
{
   K_MSG* pMsg = NULL;
   pMsg = OSAL_GET_MESSAGE((sizeof(UMI_DCSet_t)));
   UMI_DCSet_t* param = (UMI_DCSet_t*)pK_MSG_DATA(pMsg);

   param->radioOffTimeInMsecs  = dutycycleDB.dutycycleRfOffTimeout;
   param->radioOnTimeInMsecs  =  dutycycleDB.dutycycleRfOnTimeout;
   param->isDutyCycleEnable = 	 dutycycleDB.isEnabled;
   
#ifdef HDK_LOGS
   ILOG0_DDD("HDK_DCRadioOnOffCommand() dutycycleRfOffTimeOut:%d dutycycleRfOnTimeout:%d isEnabled:%d",dutycycleDB.dutycycleRfOffTimeout, dutycycleDB.dutycycleRfOnTimeout, dutycycleDB.isEnabled);
#endif
	if ((radioOnOff == ENABLE_RADIO) && (dutycycleDB.isEnabled))
	{
		
		dutycycleRunStateMachine(DC_EVENT_ENABLE, pMsg);
	}

	else
	{
		dutycycleRunStateMachine(DC_EVENT_DISABLE, pMsg);
	}
}
void HDK_DCinit()
{
	/*Clear dutycycle DB*/
	ILOG0_V("HDK_DCinit() - CLEAR DUTYCYCLE DATABASE" );
	memset(&dutycycleDB, 0, sizeof(dutycycleDB_t));
}

