/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mt_sysrst.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "shram_man_msgs.h"
#include "queue_utility.h"
#include "lmi.h"
#include "ProgModelLoader.h"
#include "CalibrationManager.h"
#include "CalibrationHandler.h"
#include "RssiPathClbrHndlr.h"
#include "CtsManager_Api.h"
#include "ChannelSwitchManager_Api.h"
#include "ServicesHandler_Api.h"
#include "init_ifmsg.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"
#include "TpcClbrHndlr.h"
#include "LmHdk_API.h"
#include "Afe_API.h"
#include "RficDriver_API.h"
#include "BSSmanager_API.h"
#include "RficCommon.h"
#include "Indirect_API.h"
#include "Dut_Api.h"
#include "HdkTask.h"
#include "PSD.h"
#include "Statistics_Api.h"
#include "PhyDriver_API.h"
#include "HdkRadarDetection.h"
#include "HdkContinuousInterfererDetection.h"
#include "CoC_Api.h"
#include "Pauser_Api.h"
#include "SenderInterface_Api.h"
#include "efuseAccess_Api.h"
#include "Utils_Api.h"
#include "RegAccess_Api.h"
#include "StaDatabase_Api.h"
#include "BeaconHandler_api.h"
#include "EventsManager_api.h"
#include "Pac_Api.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 31


/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/
#define ERP_DISABLE 0
#define ERP_ENABLE  1
#define ERP_LOGS    0

erpDB_t erpDB;

#ifdef DEBUG_MODE_PROB
#define STATIC
#else
#define STATIC static
#endif

static void erpWaitConnection(void);
static void erpStaManagerSendConfirm(uint8 sid);
static void erpScheduleProcessStart(void);
static bool erpCheckProcessRejected(K_MSG *pMsg);
static void erpInitiatePowerCycle(K_MSG *pMsg);
static void erpPhyStaConnectingInd(void);
static void erpVerifyFirstStaAdd(void);
static void erpUpdateStaStatus(void);





static const ERPStateMachineFunctionEntry_t erpStateMAchine[ERP_NUMBER_OF_STATES][ERP_NUMBER_OF_EVENTS] = 
{
	/*STATE - ERP_STATE_DISABLE  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVap,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableEvent,								/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInDisableEvent							/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_IDLE  */
	{
		erpAddVapInIdle,								/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpInvalidEvent, 								/*EVENT - ERP_EVENT_ADD_STA,       */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpInvalidEvent,								/*EVENT - ERP_EVENT_BSS, */
		erpDisableInIdleEvent,							/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableEvent									/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_CONNECTION  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVapWaitConnectionEvent,				/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddStainWaitConnectionEvent, 				/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveStainWaitConnectionEvent,				/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpWaitConnectionTimerEvent,					/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpBssTxInWaitConnectionEvent,					/*EVENT - ERP_EVENT_BSS, */
		erpDisableInWaitConnectionEvent,				/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInWaitConnectionEvent					/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_CONNECTED  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVap,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveStainConnectedEvent,					/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableInConnectedEvent,						/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInConnectedEvent						/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_RF_ON  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVapInRfOnEvent,						/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddStaInRfOnEvent, 							/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpRfOnTimerEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpBssTxInRfOnEvent,							/*EVENT - ERP_EVENT_BSS, */
		erpDisableInRfOnEvent,							/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInRfOnEvent							/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCESS_START  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP */
		erpRemoveVap,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddStaInWaitProcessStartEvent,				/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpProcessStartInWaitProcessStartEvent,			/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpBssTxInWaitProcessStartEvent,				/*EVENT - ERP_EVENT_BSS, */
		erpDisableInWaitProcessStartEvent,				/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableEvent									/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_RF_OFF  */
	{
		erpInvalidEvent,								/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddStaInRfOffEvent, 							/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpRfOffTimerEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpBssTxInRfOffEvent,							/*EVENT - ERP_EVENT_BSS, */
		erpDisableInRfOffEvent,							/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInRfOffEvent							/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCESS_END  */
	{
		erpInvalidEvent,								/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddStaInWaitProcessEndEvent,					/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpProcessEndInWaitProcessEndEvent,				/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpBssTxInWaitProcessEndEvent,					/*EVENT - ERP_EVENT_BSS, */
		erpDisableInWaitProcessEndEvent,				/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableEvent									/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCESS_START_ABORT  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVap,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveStaInWaitProcessStartAbortEvent,		/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpProcessStartInWaitProcessStartAbortEvent,	/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableInWaitProcessStartAbortEvent,			/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableEvent									/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCES_END_ABORT  */
	{
		erpInvalidEvent,								/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveStaInWaitProcessEndAbortEvent,			/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_TIMER,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpProcessEndInWaitProcessEndAbortEvent,		/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableInWaitProcessEndAbortEvent,			/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableEvent									/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCESS_START_DISABLE  */
	{
		erpAddVap,										/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpRemoveVap,									/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_TIMER,	  */
		erpProcessStartInWaitProcessStartDisableEvent,	/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableEvent,								/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInWaitProcessStartDisableEvent			/*EVENT - ERP_EVENT_ENABLE, */	
	},

	/*STATE - ERP_STATE_WAIT_PROCESS_END_DISABLE  */
	{
		erpInvalidEvent,								/*EVENT - ERP_EVENT_ADD_VAP,	        */
		erpInvalidEvent,								/*EVENT - ERP_EVENT_REMOVE_VAP,       */
		erpAddSta, 										/*EVENT - ERP_EVENT_ADD_STA,       */
		erpRemoveSta,									/*EVENT - ERP_EVENT_REMOVE_STA,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_TIMER,	  */
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_PROCESS_START,	  */
		erpProcessEndInWaitProcessEndDisableEvent,		/*EVENT - ERP_EVENT_PROCESS_END, */		
		erpIgnoreEvent,									/*EVENT - ERP_EVENT_BSS, */
		erpDisableEvent,								/*EVENT - ERP_EVENT_DISABLE, */
		erpEnableInWaitProcessEndDisableEvent			/*EVENT - ERP_EVENT_ENABLE, */	
	}
};

/********************************************************************************************************************************/
/*********************************************** Utility functions **************************************************************/
/********************************************************************************************************************************/
void HDK_ERPChangeState(ERPState_e state)
{
#ifdef ERP_LOGS
	ILOG0_DD("Change ERP State,from %d, to %d ", erpDB.erpSmState, state);
#endif
	erpDB.erpSmState = state;
}

void erpRunStateMachine(ERPEvent_e event,K_MSG* pMsg)
{
#ifdef ERP_LOGS
	ILOG0_DD("Run ERP SM, event %d, state %d", event, erpDB.erpSmState);
#endif
	erpStateMAchine[erpDB.erpSmState][event](pMsg);
}

static void erpWaitConnection()
{

	/*Move to Wait for connection*/
	HDK_ERPChangeState(ERP_STATE_WAIT_CONNECTION);
	/*The timer may have expired and we may have a timer event pending, store current TSF so we can use it to validate that the timer event is the one we want*/
	erpDB.conectionTimerTsf = GET_TSF_TIMER_LOW();
	/*Set timeout*/
	OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.connectionTimeOut), TASK_HDK);
}

static void erpStaManagerSendConfirm(uint8 sid)
{
	K_MSG *pMsg;
	BssManagerStaManagerCfm_t *confirmMessage;

	/*Allocate message*/
	pMsg = OSAL_GET_MESSAGE(sizeof(BssManagerStaManagerCfm_t));
	confirmMessage = (BssManagerStaManagerCfm_t*) pK_MSG_DATA(pMsg);
	/*Set Client ID to the registered ID*/
	confirmMessage->clientId = BSS_MANAGER_STA_MANAGER_HDK_CLIENT;
	/*Set STA ID*/
	confirmMessage->sid = sid;
	/*Send confirmation message*/
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_REG_CFM, TASK_BSS_MANAGER, pMsg, VAP_ID_DO_NOT_CARE);
}

static void erpSetReqSendConfirm()
{
	if(erpDB.pMsg != NULL)
	{
		OSAL_SEND_MESSAGE(UMI_MC_MAN_ERP_SET_CFM, TASK_UM_IF_TASK, erpDB.pMsg, erpDB.pMsg->header.vapId);
	}
	erpDB.pMsg = NULL;
}

static void erpScheduleProcessStart()
{
	K_MSG *pMsg = NULL;
	ProcessRequestParams_t *processRequestParams = NULL;
	
	//schedule process
	pMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(pMsg);
	processRequestParams->processId 				= PROCESS_ID_ERP;
	processRequestParams->startProcessMsg 			= HDK_ERP_PROCESS_START;
	processRequestParams->requesterParams			= NULL;
	processRequestParams->preProcessServiceBitmap  	= (TRUE << SERVICE_ID_PAUSE_ALL);//pause all eran
	processRequestParams->endProcessMsg				= HDK_ERP_END_PROCESS; //this should never happen
	processRequestParams->postProcessServiceBitmap 	= (TRUE << SERVICE_ID_RESUME_ALL);; //resume all eran
	processRequestParams->returnTask				= TASK_HDK; 
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
	processRequestParams->serviceData				= 0x0;
	processRequestParams->dualBandProcess = 		TRUE;
	processRequestParams->processMsgHandledByCdbProcessMan = FALSE;

	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST, TASK_PROCESS_MANAGER, pMsg, pMsg->header.vapId);
}

static bool erpCheckProcessRejected(K_MSG *pMsg)
{
    ProcessManagerReturnParams_t* processManagerReturnParams;

	/*In case last VAP process was pending or running when process was requested, Process manager will reject it*/
	processManagerReturnParams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(pMsg);		
    if (processManagerReturnParams->processStatus == PROCESS_STATUS_REQUEST_REJECTED)
    {
		/*Enable Online Calibraion*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		/*Enable Beacon Blocking*/
		OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
		/*Change State*/
		HDK_ERPChangeState(ERP_STATE_IDLE);
		return (TRUE);
    }
	return (FALSE);
}

static void erpInitiatePowerCycle(K_MSG *pMsg)
{
	uint8 vapId = pMsg->header.vapId;
	/*Disable Online Calibration*/
	ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE);
	/*Disable BeaconBlocking*/
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_STOP, TASK_PAC_MANAGER, vapId );
	/*Set ERP RF on timout*/
	OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.erpRfOnTimeout), TASK_HDK);
	/*Move to RF on State*/
	HDK_ERPChangeState(ERP_STATE_RF_ON);
}

static void erpPhyStaConnectingInd()
{

#ifdef ERP_LOGS
			ILOG0_D("erpPhyStaConnectingInd()  with erpDB.status %d ",erpDB.status );
#endif

	if (erpDB.status == ERP_STA_NOT_CONNECTED)	
	{
		/*each Bss event assume first STA is added*/
		//PhyDrv_SetConnectedSTAind(TRUE);
		
	}

}
static void erpVerifyFirstStaAdd()
{

	
#ifdef ERP_LOGS
		ILOG0_D("erpVerifyStaAdd() connection timer expired with erpDB.status %d ",erpDB.status );
#endif

	/*if first STA Athenticated but did not associated the timer expired will restart phy power save*/
	if (erpDB.status == ERP_STA_NOT_CONNECTED) 
	{
		//PhyDrv_SetConnectedSTAind(FALSE);
	}
		
}

static void erpUpdateStaStatus()
{
		/*Update sta th status*/
	if (erpDB.numberOfStations==0)
	{
		erpDB.status = ERP_STA_NOT_CONNECTED;
	}
	else if (erpDB.numberOfStations >= erpDB.numberOfStaTh)
	{
		erpDB.status = ERP_STA_CONNECTED_UNTRIGGERED ;  
	}
 	else
 	{
 		erpDB.status = ERP_STA_CONNECTED_TRIGGERED;
 	}	
}
/********************************************************************************************************************************/
/*********************************************** Common handlers  ***************************************************************/
/********************************************************************************************************************************/
void erpIgnoreEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
}

void erpInvalidEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	ASSERT(0);
}

/********************************************************************************************************************************/
/*********************************************** ADD VAP Handlers ***************************************************************/
/********************************************************************************************************************************/
void erpAddVap(K_MSG* pMsg)
{
	uint8 vapIndex = 0;
	UMI_SET_WMM_PARAMETERS *postVapActivationMessage = NULL;
	K_MSG *vapMessage = NULL;

	/*Extract VAP Index from message*/
	vapMessage = (K_MSG *) (*((uint32 *)pK_MSG_DATA(pMsg)));
	postVapActivationMessage = (UMI_SET_WMM_PARAMETERS *) pK_MSG_DATA(vapMessage);
	vapIndex = postVapActivationMessage->vapId;

	/*Validate band Vapid*/
	ASSERT (ConfigurationManager_GetBandForVap(vapIndex) == ConfigurationManager_GetMyBand());

	/*Add VAP to bitmap*/
	erpDB.vapBitMap	|= (1 << vapIndex);

	
}

void erpAddVapInIdle(K_MSG* pMsg)
{
	/*First VAP added in Idle state*/
	/*First ADD VAP to bitmap*/

	erpAddVap(pMsg);

	erpInitiatePowerCycle(pMsg);
}

/********************************************************************************************************************************/
/*********************************************** Remove VAP Handlers ************************************************************/
/********************************************************************************************************************************/
void erpRemoveVap(K_MSG* pMsg)
{
	uint8 vapIndex = 0;
	UMI_REMOVE_VAP *removeVapnMessage = NULL;
	K_MSG *vapMessage = NULL;

	/*Extract VAP Index from message*/
	vapMessage = (K_MSG *) (*((uint32 *)pK_MSG_DATA(pMsg)));
	removeVapnMessage = (UMI_REMOVE_VAP *) pK_MSG_DATA(vapMessage);
	vapIndex = removeVapnMessage->vapId;

	/*Validate band Vapid*/
	ASSERT (ConfigurationManager_GetBandForVap(vapIndex) == ConfigurationManager_GetMyBand());

	/*Add VAP to bitmap*/
	erpDB.vapBitMap	&= ~(1 << vapIndex);
}

void erpRemoveVapWaitConnectionEvent(K_MSG* pMsg)
{
	erpRemoveVap(pMsg);
	/*Did we remove the last VAP?*/	
	if (erpDB.vapBitMap == 0)
	{
		/*Last VAP removed*/
		/*Move to Idle*/
		HDK_ERPChangeState(ERP_STATE_IDLE);
		/*Reset timer*/
		OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	}
	
}

void erpRemoveVapInRfOnEvent(K_MSG* pMsg)
{
	erpRemoveVap(pMsg);
	/*Did we remove the last VAP?*/	
	if (erpDB.vapBitMap == 0)
	{
		/*Last VAP removed*/
		/*Enable Online Calibraion*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		/*Enabel Beacon Blocking*/
		OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
		/*Move to Idle*/
		HDK_ERPChangeState(ERP_STATE_IDLE);
		/*Reset timer*/
		OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	}
}

/********************************************************************************************************************************/
/*********************************************** ADD STA Handlers ***************************************************************/
/********************************************************************************************************************************/
void erpAddSta(K_MSG* pMsg)
{
	BssManagerStaManagerReq_t *staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(pMsg);
	K_MSG *psMsg = staManagerReq->psMsg;
	UMI_STA_ADD *pAddSta = (UMI_STA_ADD *)pK_MSG_DATA(psMsg);
	uint8 sid = pAddSta->u16SID;
#ifdef ERP_LOGS
	ILOG0_DD("erpAddSta() ERP Add STA index : %d  EVENT on State: %d ",sid, erpDB.erpSmState);
#endif
	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();
	
	/*Increment number of STAs*/
	erpDB.numberOfStations++;

	/*Update sta th status*/	
	if (erpDB.numberOfStations >= erpDB.numberOfStaTh)
	{
		erpDB.status = ERP_STA_CONNECTED_UNTRIGGERED ;  
	}
 	else
 	{
 		erpDB.status = ERP_STA_CONNECTED_TRIGGERED;
 	}	
	/*Send confirmation to BSS Manager STA manager*/
	erpStaManagerSendConfirm(sid);
}


void erpAddStainWaitConnectionEvent(K_MSG* pMsg)
{

	erpAddSta(pMsg);

	/*We want to reset the connection timer as STA was added succesfully*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Enable Online Calibraion*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		
		/*Enable Beacon Blocking*/
		OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
		
		/*Move to Connected*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
	}
	else
	{
		//erpInitiatePowerCycle(pMsg);
		erpDB.conectionTimerTsf = GET_TSF_TIMER_LOW();
		OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.connectionTimeOut), TASK_HDK);
	}	
}

void erpAddStaInRfOnEvent(K_MSG* pMsg)
{
	erpAddSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Enable Online Calibraion*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		
		/*Enable Beacon Blocking*/
		OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
		
		/*Move to Connected*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
		
		/*Reset timer*/
		OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	}
}

void erpAddStaInWaitProcessStartEvent(K_MSG *pMsg)
{
	erpAddSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Move to Wait Process Start Abort*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START_ABORT);
	}
}

void erpAddStaInRfOffEvent(K_MSG *pMsg)
{
	/*STA was added when RF is Off, if exceeds STA threshold turn the RF on and request process maanger to end the process */
	erpAddSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Turn RF On*/
		HDK_TurnRadioOffOn(ENABLE_RADIO);	

		/*Run calibration after radio on - CFM and change ERP state will be handled in calibration CB*/
		//ClbrMngr_RunErpCalibration(OFFLINE_CAL_ERP_ADD_STA_IN_RF_OFF_EVENT_REQUESTER);

		/*Request Process Manager to end the process*/
		K_MSG *dummyMsg = ProcessManager_GetDummyMessage();	
		OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);

		/*Move to Wait Process End Abort*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
	}

}
void erpAddStaInWaitProcessEndEvent(K_MSG *pMsg)
{
	erpAddSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Move to Wait Process Start Abort*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
	}
}

/********************************************************************************************************************************/
/*********************************************** Remove STA Handlers ************************************************************/
/********************************************************************************************************************************/
void erpRemoveSta(K_MSG* pMsg)
{
	BssManagerStaManagerReq_t *staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(pMsg);
	K_MSG *psMsg = staManagerReq->psMsg;
	UMI_STA_REMOVE *pRemoveSta = (UMI_STA_REMOVE *)pK_MSG_DATA(psMsg);
	uint8 sid = pRemoveSta->u16SID;
#ifdef ERP_LOGS
	ILOG0_DD("erpRemoveSta() ERP Remove STA index: %d EVENT on State: %d ",sid,erpDB.erpSmState);
#endif
	
	erpDB.numberOfStations--;

	/*Update sta th status*/
	if (erpDB.numberOfStations==0)
	{
		erpDB.status = ERP_STA_NOT_CONNECTED;
		/* if No STA connected ind Phy for power save*/
		//PhyDrv_SetConnectedSTAind(FALSE);
	}
	else if (erpDB.numberOfStations >= erpDB.numberOfStaTh)
	{
		erpDB.status = ERP_STA_CONNECTED_UNTRIGGERED ;  
	}
 	else
 	{
 		erpDB.status = ERP_STA_CONNECTED_TRIGGERED;
 	}	

	/*Send confirmation to BSS Manager STA manager*/
	erpStaManagerSendConfirm(sid);
}

void erpRemoveStainWaitConnectionEvent(K_MSG * pMsg)
{
	/*First remove STA	and send confirmation to BSS Manager STA manager*/
	erpRemoveSta(pMsg);

	if (erpDB.status == ERP_STA_NOT_CONNECTED)
	{
		/*Last connected STA was removed reset connection timer and retrigger dutycycle timers.*/
		OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);

		/*no connected Sta reinit power cycle  */
		erpInitiatePowerCycle(pMsg);

	}
}

void erpRemoveStainConnectedEvent(K_MSG * pMsg)
{
	/*First remove STA  and send confirmation to BSS Manager STA manager*/
	erpRemoveSta(pMsg);
	/*if the remaning connected STA are <= to Sta threshold reactivate waitconnection timer*/
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Stay in Connected state*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
	}
	else
	{
#ifdef ERP_LOGS
		ILOG0_D("erpRemoveStainConnectedEvent() ERP Remove STA EVENT <= STAthreshold on State: %d ",erpDB.erpSmState);
#endif
		/*Current connected Sta's = Sta Th -  reinit power cycle  */
		erpInitiatePowerCycle(pMsg);
	}
}


void erpRemoveStaInWaitProcessStartAbortEvent(K_MSG *pMsg)
{
	/*STA was Added while waiting for process start (>numberOfStaTh) and was removed immedietlly - 
	 revert to WAIT_PROCESS_START to seamleslly continue the flow upon process manager event*/

	erpRemoveSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*remain in the ABORT State*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START_ABORT);
	}
	else
	{
		/*Move to Wait Process Start*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START);

	}
}

void erpRemoveStaInWaitProcessEndAbortEvent(K_MSG *pMsg)
{
	/*STA was Added while waiting for process end (>numberOfStaTh) and was removed immedietlly - 
	 revert to WAIT_PROCESS_END to seamleslly continue the flow upon process manager event */

	erpRemoveSta(pMsg);
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*remain in the ABORT State*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
	}
	else
	{
		/*Move to Wait Process Start Abort*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END);

	}
}

/********************************************************************************************************************************/
/*********************************************** Timer Handlers *****************************************************************/
/********************************************************************************************************************************/
void erpWaitConnectionTimerEvent(K_MSG* pMsg)
{

	/*Since in wait for conenction state there are cases where we restart the timer, we need to make sure that this event is not
	a pending event for the previous timer*/
	if ((GET_TSF_TIMER_LOW() - erpDB.conectionTimerTsf) < ((erpDB.connectionTimeOut * 1000)/2))
	{
		return;
	}

	erpVerifyFirstStaAdd();
	
	erpInitiatePowerCycle(pMsg);
}

void erpRfOnTimerEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	/*Request Process Manager to schedule ERP process*/
	erpScheduleProcessStart();
	/*And wait for Process Start*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START);
}

void erpRfOffTimerEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
#ifdef ERP_LOGS
	ILOG0_D("erp RfOffTimerExpired() RFoff Timer duration: %d" ,TIME_STAMP(END_TIME,erpDB.StartRfOffTsf));
#endif
	/*Turn RF On*/
	HDK_TurnRadioOffOn(ENABLE_RADIO);	
	/*Run calibration after radio on - CFM and change ERP state will be handled in calibration CB*/
	//ClbrMngr_RunErpCalibration(OFFLINE_CAL_ERP_RF_OFF_TIMER_EVENT_REQUESTER);

	/*Change State*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END);

	/*wait for process end*/
	K_MSG *dummyMsg = ProcessManager_GetDummyMessage();	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);
}

/********************************************************************************************************************************/
/*********************************************** Process Start Handlers *********************************************************/
/********************************************************************************************************************************/
void erpProcessStartInWaitProcessStartEvent(K_MSG* pMsg)
{
	if (erpCheckProcessRejected(pMsg) == TRUE)
	{
		return;
	}
#ifdef ERP_LOGS
	ILOG0_D("erp RfOffTimerExpired() RFon Timer duration: %d" ,TIME_STAMP(END_TIME,erpDB.StartRfOnTsf));
#endif
	/*Turn Radio Off*/
	HDK_TurnRadioOffOn(DISABLE_RADIO);
	/*Change State*/
	HDK_ERPChangeState(ERP_STATE_RF_OFF);
	/*Start RF off timeout*/
	OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.erpRfOffTimeOut), TASK_HDK);
	/*Debug - Capture tsf to RFoff timer start */
	erpDB.StartRfOffTsf= TIME_STAMP(START_TIME,0);	
}

void erpProcessStartInWaitProcessStartAbortEvent(K_MSG* pMsg)
{
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;

	if (erpCheckProcessRejected(pMsg) == TRUE)
	{
		return;
	}
	/*Just request Process Manager to end process*/
	dummyMsg = ProcessManager_GetDummyMessage();	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);
	/*And wait for it*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
}

void erpProcessStartInWaitProcessStartDisableEvent(K_MSG* pMsg)
{
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;
	
	if (erpCheckProcessRejected(pMsg) == TRUE)
	{
		/*Send confirm*/
		erpSetReqSendConfirm();
		return;
    }
	/*We were requested to disable while we were waiting for the process to be scheduled. we changed state and waited for the process to be scheduled*/
	/*Just request Process Manager to end process*/
	dummyMsg = ProcessManager_GetDummyMessage();	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);
	/*And wait for it*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
}

/********************************************************************************************************************************/
/*********************************************** Process End Handlers *********************************************************/
/********************************************************************************************************************************/
void erpProcessEndInWaitProcessEndEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	/*Move to RF on state*/
	HDK_ERPChangeState(ERP_STATE_RF_ON);
	/*Debug capture timer trigger timestamp*/
	erpDB.StartRfOnTsf = TIME_STAMP(START_TIME,0);	
	/*Start RF On timeout*/
	OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.erpRfOnTimeout), TASK_HDK);
}

void erpProcessEndInWaitProcessEndAbortEvent(K_MSG* pMsg)
{
	/*Enable Online Calibration*/
	ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
	/*Enable Beacon Blocking*/
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);	
	/*Check if connected STAs exceed the disable Th*/
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Move to Connected state*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
	}
	else
	{
		/*Add STA/ Bss event during process - wait addtioncal connection timer*/
		erpWaitConnection();
	}
}

void erpProcessEndInWaitProcessEndDisableEvent(K_MSG* pMsg)
{
	/*Enable Online Calibration*/
	ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
	/*Enable Beacon Blocking*/
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);	
	/*Move to Disable State*/
	HDK_ERPChangeState(ERP_STATE_DISABLE);
	/*Send confimr*/
	erpSetReqSendConfirm();
}

/********************************************************************************************************************************/
/*********************************************** BSS TX Handlers ****************************************************************/
/********************************************************************************************************************************/

void erpBssTxInWaitConnectionEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
#ifdef ERP_LOGS
	ILOG0_D("erpBssTxInWaitConnectionEvent() BSS TX EVENT on State: %d ",erpDB.erpSmState);
	ILOG0_V("erpBssTxInWaitConnectionEvent() BSS TX EVENT restrating connection timer");
#endif
	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();
	/*We want to transmit AUTH or ASSOC while waiting for STA to connect, restart the timer*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	/*The timer may have expired and we may have a timer event pending, store current TSF so we can use it to validate that the timer event is the one we want*/
	erpDB.conectionTimerTsf = GET_TSF_TIMER_LOW();
	/*Set the timer*/
	OSAL_SET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(erpDB.connectionTimeOut), TASK_HDK);
}

void erpBssTxInRfOnEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

#ifdef ERP_LOGS
	ILOG0_D("erpBssTxInRfOnEvent() BSS TX EVENT on State: %d ",erpDB.erpSmState);
	ILOG0_V("erpBssTxInRfOnEvent() BSS TX EVENT Move to wait connection");
#endif

	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();

	/*We want to transmit AUTH or ASSOC while waiting for RF On timer, restart the timer*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);

	/*Move to wait connection*/
	erpWaitConnection();
}



void erpBssTxInWaitProcessStartEvent(K_MSG* pMsg)

{

	UNUSED_PARAM(pMsg);

	
		/*We want to transmit an AUTH or ASSOC to unconnected STA while waiting for ERP process to be scheduled*/
		/*Move to Abort state so when Process is scheduled we just finish it and wait for STA to connectiontimer to expire*/

#ifdef ERP_LOGS
	ILOG0_D("erpBssTxInWaitProcessStartEvent() BSS TX EVENT on State: %d ",erpDB.erpSmState);
	ILOG0_V("erpBssTxInWaitProcessStartEvent() BSS TX EVENT Move toERP_STATE_WAIT_PROCESS_START_ABORT");
#endif
	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();

	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START_ABORT);
	
}



void erpBssTxInRfOffEvent(K_MSG* pMsg)

{

	UNUSED_PARAM(pMsg);

	/*We want to transmit an AUTH or ASSOC when RF is Off, turn the RF on and request process maanger to end the process */
	/*Turn RF On*/

#ifdef ERP_LOGS
	ILOG0_D("erpBssTxInRfOffEvent() BSS TX EVENT on State: %d ",erpDB.erpSmState);
	ILOG0_V("erpBssTxInRfOffEvent() BSS TX EVENT Enable Radio and run calibration");
#endif

	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();

	HDK_TurnRadioOffOn(ENABLE_RADIO);	

	/*Run calibration after radio on - CFM and change ERP state will be handled in calibration CB*/
	//ClbrMngr_RunErpCalibration(OFFLINE_CAL_ERP_BSS_TX_IN_RF_OFF_EVENT_REQUESTER);
		
	/*Request Process Manager to end the process*/
	K_MSG *dummyMsg = ProcessManager_GetDummyMessage();	

	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);

	/*Move to Wait Process End Abort*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);

}



void erpBssTxInWaitProcessEndEvent(K_MSG* pMsg)

{

	UNUSED_PARAM(pMsg);


#ifdef ERP_LOGS
	ILOG0_D("erpBssTxInWaitProcessEndEvent() BSS TX EVENT on State: %d ",erpDB.erpSmState);
#endif
	/*PhypowerSave isStaConnected indicaiton*/
	erpPhyStaConnectingInd();

	/*Move to Wait Process End Abort*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);

}


/********************************************************************************************************************************/
/*********************************************** Disable Handlers ***************************************************************/
/********************************************************************************************************************************/

void erpDisableEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);
	/*Just send confirm*/
	erpSetReqSendConfirm();
}



void erpDisableInIdleEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);
	
	/*Move to disable state*/
	HDK_ERPChangeState(ERP_STATE_DISABLE);

	/*Send confimr*/
	erpSetReqSendConfirm();
}



void erpDisableInWaitConnectionEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	/*Move to disable*/
	HDK_ERPChangeState(ERP_STATE_DISABLE);

	/*Reset connection timer*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);	

	/*Send confimr*/
	erpSetReqSendConfirm();
}



void erpDisableInConnectedEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	/*Move to disable*/
	HDK_ERPChangeState(ERP_STATE_DISABLE);

	/*Send confimr*/
	erpSetReqSendConfirm();
}



void erpDisableInRfOnEvent(K_MSG* pMsg)

{
	/*Enable On line calibration*/
	ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);

	/*Enable Beacon Blocking*/
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);

	/*Move to disable*/
	HDK_ERPChangeState(ERP_STATE_DISABLE);

	/*Reset RF On timer*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);	

	/*Send confimr*/
	erpSetReqSendConfirm();
}



void erpDisableInWaitProcessStartEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	/*We are requested to disable while waiting for process manager. Just chnage state and wait for process scheduled*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START_DISABLE);
}



void erpDisableInRfOffEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	/*We are requested to disable while RF is off. Turn RF on, request process manager to end and stop RF off timer*/
	/*Turn RF On*/
	HDK_TurnRadioOffOn(ENABLE_RADIO);	

	/*Run calibration after radio on - CFM and change ERP state will be handled in calibration CB*/
	/*ClbrMngr_RunErpCalibration(OFFLINE_CAL_ERP_DISABLE_IN_RF_OFF_EVENT_REQUESTER);*/

	/*Request Process Manager to end the process*/
	K_MSG *dummyMsg = ProcessManager_GetDummyMessage();
	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg ,pMsg->header.vapId);

	/*Reset RF Off timer*/
	OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);

	/*Wait for process end*/
	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
}



void erpDisableInWaitProcessEndEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
}



void erpDisableInWaitProcessStartAbortEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
}



void erpDisableInWaitProcessEndAbortEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
}

/********************************************************************************************************************************/
/*********************************************** Enable Handlers ****************************************************************/
/********************************************************************************************************************************/
void erpEnableInDisableEvent(K_MSG* pMsg)
{
	
	if (erpDB.vapBitMap == 0)
	{
		/*If no VAPs connected, move to Idle*/
		HDK_ERPChangeState(ERP_STATE_IDLE);	
	}
	else
	{
		if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
		{
			/*If STAs connected, move to Connected state*/
			HDK_ERPChangeState(ERP_STATE_CONNECTED);
		}
		else 
		{
			/*VAP(s) connected and Sta's < Sta Th, initiate power cycle*/
			erpInitiatePowerCycle(pMsg);
		}
		
	}
	/*Send confirmation*/
	erpSetReqSendConfirm();
}



void erpEnableInWaitConnectionEvent(K_MSG* pMsg)

{
	UNUSED_PARAM(pMsg);

	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*Enable Online Calibraion*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		
		/*Enable Beacon Blocking*/
		OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
		
		/*Move to Connected*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
		
		/*Reset timer*/
		OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
	}
	/*Send confirmation*/
	erpSetReqSendConfirm();
}


	
void erpEnableInConnectedEvent(K_MSG* pMsg)
{

	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		/*stay in Connected state*/
		HDK_ERPChangeState(ERP_STATE_CONNECTED);
	}
	else
	{	/*new input numOfStaTh has changed which change the sta state*/ 
		erpInitiatePowerCycle(pMsg);
	}
	
	/*Send confirmation*/
	erpSetReqSendConfirm();
}

void erpEnableInRfOnEvent(K_MSG* pMsg)

{
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)

		{
			/*Enable Online Calibraion*/
			ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
			
			/*Enable Beacon Blocking*/
			OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, pMsg->header.vapId);
			
			/*Move to Connected*/
			HDK_ERPChangeState(ERP_STATE_CONNECTED);
			
			/*Reset timer*/
			OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
		}

	/*Send confirmation*/
	erpSetReqSendConfirm();

}

void erpEnableInRfOffEvent(K_MSG* pMsg)

{
	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	
		{
			/*Turn RF On*/
			HDK_TurnRadioOffOn(ENABLE_RADIO);	

			/*Request Process Manager to end the process*/
			K_MSG *dummyMsg = ProcessManager_GetDummyMessage();	
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, pMsg->header.vapId);

			/*Move to Wait Process End Abort*/
			HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
		}

	 /*Send confirmation*/
	 erpSetReqSendConfirm();
}




void erpEnableInWaitProcessStartDisableEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);

	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{	
	   HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START_ABORT);
	}
	else
	{
		/*We were waiting for process to start so we could disable - user changed its mind and enabled us again*/
		/*Just change state to wait for process start*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_START);
	
}
	/*Send confirmation*/
	erpSetReqSendConfirm();
}

void erpEnableInWaitProcessEndDisableEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);

	if (erpDB.status == ERP_STA_CONNECTED_UNTRIGGERED)
	{
		 HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
	}
	else
	{
		/*We were waiting for process to end so we could disable - user changed its mind and enabled us again*/
		/*Just change state to wait for process end*/
		HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END);
	}
	/*Send confirmation*/
	erpSetReqSendConfirm();
}

void erpEnableEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);
	/*API can be sent at any time*/
	/*Just Send confirmation*/
	erpSetReqSendConfirm();
}

/********************************************************************************************************************************/
/*********************************************** Global functiops ***************************************************************/
/********************************************************************************************************************************/
void HDK_ERPSet(K_MSG *pMsg)
{
	UMI_ERPSet_t* param;

	ASSERT(erpDB.pMsg == NULL);
	/*Store message*/
	erpDB.pMsg = pMsg;
	param = (UMI_ERPSet_t*)pK_MSG_DATA(pMsg);
	if (param->isErpEnable == 1)
	{
		erpDB.connectionTimeOut = (uint32) STA_CONNECTION_TIMEOUT_SEC * 1000;
		erpDB.erpRfOffTimeOut =   (uint16)param->radioOffTimeInMsecs;
		erpDB.erpRfOnTimeout = 	  (uint16)param->radioOnTimeInMsecs;
		erpDB.numberOfStaTh = 	  (uint8)param->numberOfStationThreshold;
#ifdef ERP_LOGS
		ILOG0_DDD("HDK_ERPSet() connectionTimeOut:%d, erpRfOffTimeOut:%d erpRfOnTimeout:%d", erpDB.connectionTimeOut, erpDB.erpRfOffTimeOut, erpDB.erpRfOnTimeout);
		ILOG0_DDDD("HDK_ERPSet() vapBitMap:%d, erpSmState:%d numberOfStations:%d numberOfStationsTH:%d", erpDB.vapBitMap, erpDB.erpSmState, erpDB.numberOfStations, erpDB.numberOfStaTh);
#endif
		erpUpdateStaStatus();
		//PhyDrv_SetPowerSave(ENABLED);
		erpRunStateMachine(ERP_EVENT_ENABLE, pMsg);
	}
	else
	{	
		//PhyDrv_SetPowerSave(DISABLED);
		erpDB.connectionTimeOut = 0x0;
		erpRunStateMachine(ERP_EVENT_DISABLE, pMsg);
	}
}

void HDK_ERPPostVapActivation(K_MSG* pMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_ADD_VAP, pMsg);
}

void HDK_ERPRemoveVap(K_MSG * pMsg)
{
	HdkCdbManagerAddVapSmMsg_t* pAddVapSmMsgExtract;
	pAddVapSmMsgExtract = (HdkCdbManagerAddVapSmMsg_t*)pK_MSG_DATA(pMsg);

	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_REMOVE_VAP, pMsg);
	
	/*Send confirmation to HdkCdbManager*/
	OSAL_SEND_MESSAGE(pAddVapSmMsgExtract->retMsg, pAddVapSmMsgExtract->retTask, pMsg, pMsg->header.vapId); 
}


void HDK_ERPStaAdd(K_MSG *psMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_ADD_STA,psMsg);
}


void HDK_ERPStaRemove(K_MSG *psMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_REMOVE_STA,psMsg);
}

void HDK_ERPTimerExpired(K_MSG* pMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_TIMER,pMsg);
}


void HDK_ERPProcessStart(K_MSG *psMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_PROCESS_START,psMsg);
}

void HDK_ERPEndProcess(K_MSG *psMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_PROCESS_END,psMsg);
}

void HDK_ERPBssTX(K_MSG *psMsg)
{
	/*Run State machine*/
	erpRunStateMachine(ERP_EVENT_BSS_TX,psMsg);
}

void HDK_ERPRadioOnOffCommand(uint32 radioOnOffIndication)
{
	/*This should not be called when we have a pending message from driver*/
	ASSERT(erpDB.pMsg == NULL);
	K_MSG *pMsg = NULL;
	pMsg = OSAL_GET_MESSAGE(sizeof(UMI_ERPSet_t));
	byte localPersistant = pMsg->header.bPersistentMsg;
	
	
	if (radioOnOffIndication == ENABLE_RADIO)
	{
		if (erpDB.connectionTimeOut != 0)
		{
			erpRunStateMachine(ERP_EVENT_ENABLE,pMsg);
		}
	}
	else
	{
		erpRunStateMachine(ERP_EVENT_DISABLE,pMsg);
	}

	OSAL_FREE_MESSAGE(pMsg,localPersistant);
}

bool HDK_ERPisEnable()
			
{
	if ((erpDB.erpSmState != ERP_STATE_DISABLE) &&   
	    (erpDB.erpSmState != ERP_STATE_IDLE) &&	     
	    (erpDB.erpSmState != ERP_STATE_CONNECTED) && 
	    (erpDB.erpSmState != ERP_STATE_WAIT_CONNECTION))
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}


void ERP_init()
{
	/*Clear ERP DB*/
	memset(&erpDB, 0, sizeof(erpDB_t));
	
}

