/***********************************************************************************
 File:			HdkContinuousInterfererDetection.c
 Module:		HDK 
 Purpose: 		Detect none wifi interferers
 Description:   This file is the implementation of the HDK continuous interferer 
 				detection module which is responsible to manage the continuous 
 				interferer detection PHY genrisc FIFO processing.
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"	
#include "HdkContinuousInterfererDetection.h"
#include "PhyDriver_API.h"
#include "OSAL_Api.h"
#include "mhi_umi_propr.h"
#include "loggerAPI.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 3




/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
static HdkContinuousInterfererDetectionParameters_t HdkContinuousInterfererDetectionParameters;

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

HdkContinuousInterfererDetection_TimerExpired 


Description:
------------
Handles the event that continuous interferer detection timer has expired


Input:
-----

		
Output:
-------
	

Returns:
--------

	
**********************************************************************************/
void HdkContinuousInterfererDetection_TimerExpired()
{
	uint8 isNotificationNeeded = FALSE;

	/* If continuous interferer detection is not needed (a new channle was set without continuous interferer detection) this event is ignored */
	//ILOG0_D("HdkContinuousInterfererDetection_TimerExpired isContinuousInterfererDetectionEnabled  = %d", HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled); 
	if(HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled)
	{
		HdkContinuousInterfererDetectionParameters.pollingTimeoutCounter ++;
		if(HdkContinuousInterfererDetectionParameters.pollingTimeoutCounter == HdkContinuousInterfererDetectionParameters.currentNotificationTimeout)
		{
			isNotificationNeeded = TRUE;
			HdkContinuousInterfererDetectionParameters.pollingTimeoutCounter = 0;
		}
		PhyDrvInterfererDetection_FlushContinuousInterfererDetectionFifo(isNotificationNeeded);
		OSAL_SET_TIMER_EXPLICIT(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER, HdkContinuousInterfererDetectionParameters.currentPollingTimeout, TASK_HDK);
	}
}

/**********************************************************************************

HdkContinuousInterfererDetection_SetChannelRequest 


Description:
------------
Handles set channel request message recieved in the HDK module regarding continuous
interferer detection processing

Input:
-----
setChannelRequestParameters -  the structure that contains the parameters

		
Output:
-------
	

Returns:
--------

	
**********************************************************************************/
void HdkContinuousInterfererDetection_SetChannelRequest(HdkSetChannelReqParams_t *setChannelRequestParameters)
{
	if(ST_SCAN ==  setChannelRequestParameters->switchType)
	{
		HdkContinuousInterfererDetectionParameters.currentPollingTimeout = HdkContinuousInterfererDetectionParameters.scanPollingTimeout;
	    HdkContinuousInterfererDetectionParameters.currentNotificationTimeout = HdkContinuousInterfererDetectionParameters.scanNotificationTimeout;
	}
	else
    {
	    HdkContinuousInterfererDetectionParameters.currentPollingTimeout = HdkContinuousInterfererDetectionParameters.normalPollingTimeout;
		HdkContinuousInterfererDetectionParameters.currentNotificationTimeout = HdkContinuousInterfererDetectionParameters.normalNotificationTimeout;
	}

		
	if(HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled && (!setChannelRequestParameters->isContinuousInterfererDetectionNeeded))
	{
		OSAL_RESET_TIMER_EXPLICIT(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER, TASK_HDK);
	}
	else if((!HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled) && setChannelRequestParameters->isContinuousInterfererDetectionNeeded)
	{
		OSAL_SET_TIMER_EXPLICIT(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER, HdkContinuousInterfererDetectionParameters.currentPollingTimeout, TASK_HDK);
	}
	else if((HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled) && setChannelRequestParameters->isContinuousInterfererDetectionNeeded)
	{
		OSAL_RESET_TIMER_EXPLICIT(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER, TASK_HDK);
		OSAL_SET_TIMER_EXPLICIT(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER, HdkContinuousInterfererDetectionParameters.currentPollingTimeout, TASK_HDK);
	}

	HdkContinuousInterfererDetectionParameters.isContinuousInterfererDetectionEnabled = setChannelRequestParameters->isContinuousInterfererDetectionNeeded;
	HdkContinuousInterfererDetectionParameters.pollingTimeoutCounter = 0;
}


/**********************************************************************************

HdkContinuousInterfererDetection_Initialize 


Description:
------------
Initialize the HDK Interferer detection module internal parameters and structures

Input:
-----


Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void HdkContinuousInterfererDetection_Initialize()
{
	memset(&HdkContinuousInterfererDetectionParameters, 0, sizeof(HdkContinuousInterfererDetectionParameters_t));
	
	//TBD when these values are passed in initialization this section should be removed
	HdkContinuousInterfererDetectionParameters.normalPollingTimeout = HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_POLLING_TIMEOUT_IN_TICKS; 
	HdkContinuousInterfererDetectionParameters.scanPollingTimeout = HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_POLLING_TIMEOUT_IN_TICKS; 
	HdkContinuousInterfererDetectionParameters.normalNotificationTimeout = HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_NOTIFICATION_TIMEOUT; 
	HdkContinuousInterfererDetectionParameters.scanNotificationTimeout = HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_NOTIFICATION_TIMEOUT;
	///
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif
