/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "shram_man_msgs.h"
#include "queue_utility.h"
#include "lmi.h"
#include "ProgModelLoader.h"
#include "CalibrationManager.h"
#include "CalibrationHandler.h"
#include "RssiPathClbrHndlr.h"
#include "CtsManager_Api.h"
#include "ChannelSwitchManager_Api.h"
#include "ServicesHandler_Api.h"
#include "init_ifmsg.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"
#include "TpcClbrHndlr.h"
#include "LmHdk_API.h"
#include "Afe_API.h"
#include "RficDriver_API.h"
#include "BSSmanager_API.h"
#include "RficCommon.h"
#include "Indirect_API.h"
#include "Dut_Api.h"
#include "HdkTask.h"
#include "PSD.h"
#include "Statistics_Api.h"
#include "PhyDriver_API.h"
#include "HdkRadarDetection.h"
#include "HdkContinuousInterfererDetection.h"
#include "ContinuousInterfererDetection.h"
#include "InterfererDetection_Api.h"
#include "CoC_Api.h"
#include "Pauser_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "SenderInterface_Api.h"
#include "StatisticsPhyHandler.h"
#else //ENET_INC_ARCH_WAVE600
#include "phy_lib.h"
#include "PhyTestBus_API.h"
#endif
#include "efuseAccess_Api.h"
#include "Utils_Api.h"
#include "RegAccess_Api.h"
#include "shram_rx_buffer.h"
#include "Pac_Api.h"
#include "StaDatabase_Api.h"
#include "BeaconHandler_api.h"
#include "RadarDetection.h"
#include "System_Timers.h"
#include "linkAdaptation_api.h"
#include "HdkCdbManagerTask_api.h"
#include "ConfigurationManager_api.h"
#include "PhyRegsIncluder.h"
#include "ShramStatistics.h"
#include "ShramPhyStatDb.h"
#include "lm_StaDatabase.h"
#include "RxDcOffsetClbrHndlr.h"
#include "RxIQMismatchClbrHndlr.h"
#include "TxIQMismatchClbrHndlr.h"
#include "TxLOLeakageClbrHndlr.h"
#include "BeamFormingClbrHndlr.h"
#if defined (WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) && defined (ENET_INC_LMAC1)
#include "TxSender_ScratchPadApi.h"
#endif //(WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) && (ENET_INC_LMAC1)
#include "HeGroupManager_API.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 20

#define PRIMARY_CH_IDX_0	0

#define HDK_RF_ANTENNA0_FCSI_SR0_MODE_2__VAL 2 //LP
#define HDK_RF_ANTENNA0_FCSI_SR0_MODE_0__VAL 0 //AC

uint8		powerMode;
/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

#ifdef DEBUG_MODE_PROB
#define STATIC
#else
#define STATIC static
#endif


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define ERP_DISABLE 0
#define ERP_ENABLE  1

#define JUMP_BETWN_CHANLS		4

#define CHANNEL_NOTIFICATION_MAP_ST_NORMAL		(1 << CHANNEL_NOTIFICATION_LA_TPC_DATA) | \
												(1 << CHANNEL_NOTIFICATION_START_TPC_TIMER) | \
												(1 << CHANNEL_NOTIFICATION_COC) | \
												(1 << CHANNEL_NOTIFICATION_HE_GROUP_MANAGHER)

#define CHANNEL_NOTIFICATION_MAP_ST_SCAN		(1 << CHANNEL_NOTIFICATION_LA_TPC_DATA) | \
												(1 << CHANNEL_NOTIFICATION_HE_GROUP_MANAGHER)
#define CHANNEL_NOTIFICATION_MAP_ST_CSA			CHANNEL_NOTIFICATION_MAP_ST_NORMAL
#define CHANNEL_NOTIFICATION_MAP_ST_RSSI		(1 << CHANNEL_NOTIFICATION_LA_TPC_DATA) | \
												(1 << CHANNEL_NOTIFICATION_START_TPC_TIMER) | \
												(1 << CHANNEL_NOTIFICATION_HE_GROUP_MANAGHER)

#define CHANNEL_NOTIFICATION_MAP_ST_NORMAL_AFTER_RSSI	CHANNEL_NOTIFICATION_MAP_ST_NORMAL
#define CHANNEL_NOTIFICATION_MAP_ST_CALIBRATE	0
#define PROGMODEL_TX_ANT_SECTION_OFFSET (ANT_REGS_OFFSET)
#define PROGMODEL_RX_ANT_SECTION_OFFSET (ANT_REGS_OFFSET)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define CHANNEL_NOTIFICATION_SET_BIT(bitmap,offset) ((bitmap) |= (1 << offset))
/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Global  Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
STATIC void	hdkSmInit(void);
#if defined RADAR_DETECTION_ENABLED
STATIC void hdkRadarDetectionTimer(K_MSG* pMsg);
#endif
STATIC void hdkContinuousInterfererDetectionTimer(K_MSG* pMsg);
STATIC void hdkDownloadProgmodelPermissionReq(K_MSG *psMsg);
STATIC void hdkDownloadProgmodelReq(K_MSG *psMsg);
STATIC void hdkDonloadProgmodelDiffsReq(K_MSG *psMsg);
STATIC void hdkDownloadProgmodelAntDependentTxReq(K_MSG *psMsg);
STATIC void hdkDownloadProgmodelAntDependentRxReq(K_MSG *psMsg);
STATIC void hdkPlatformDataFieldsReq(K_MSG *psMsg);
STATIC void hdkPlatformTableReq(K_MSG *psMsg);
STATIC void HDK_setHdkConfigReq(K_MSG* psMsg);
STATIC void HDK_tpcConfigReq(K_MSG* psMsg);
STATIC void HDK_tpcSetAntParamsReq(K_MSG* psMsg);
STATIC void HDK_SetLaChannelDataCfm(K_MSG* psMsg);
STATIC void hdk_CocSetAntennasReq(K_MSG *psMsg);

STATIC void HDK_startRadioStateChangeProcess(K_MSG *psMsg);
STATIC void HDK_finalizeRadioStateChangeProcess(K_MSG *psMsg);


STATIC void HDK_startUserDemandProcess(K_MSG *psMsg);
STATIC void HDK_finalizeUserDemandProcess(K_MSG *psMsg);
STATIC void HDK_setPowerSelection(K_MSG *psMsg);
STATIC void hdk_PostVapActivation(K_MSG* pMsg);

#if !defined (HDK_REL_2_0)
STATIC void HDK_setAfeCalData(K_MSG* psMsg);
STATIC void HDK_setRficCalData(K_MSG* psMsg);
STATIC void HDK_setRssiCalData(K_MSG* psMsg);
#endif

uint8 hdkGetSsbModifiedBw(uint8 bandwidth, HdkSSBParameters_t ssbParams);
STATIC void hdkSsbModeFixChannelParams(void);

STATIC void setBwAndFrequency(K_MSG *pMsg);
STATIC void hdkRadarAndInterfererConfiguration(void);

STATIC void sendChannelParams(void);
STATIC void channelNotificationInit(void);
STATIC void hdkChannelNotificationCb(K_MSG * psMsg);
STATIC void HDK_SetCcaTh(K_MSG* psMsg);
STATIC void bandStateChangedInHdkCdbManRes (K_MSG* pmsg);
STATIC void HDK_GetCcaTh(K_MSG* psMsg);
STATIC void HDK_set11bAntennaSelection(K_MSG *psMsg);
STATIC void HDK_ConfigSmHwDependentReq(K_MSG *psMsg);
#if defined HDK_CDB_SUPPORT
STATIC void HDK_PauseBandReq(K_MSG *psMsg);
STATIC void HDK_PauseDone(K_MSG *psMsg);
STATIC void HDK_ResumeBandReq(K_MSG *psMsg);
STATIC void HDK_ResumeDone(K_MSG *psMsg);
#endif
STATIC void HDK_ResumeCalibratingBandReq(K_MSG *psMsg);
STATIC uint8 getRegulationLimitPerBw(uint8 band, uint8 bw, uint8 channel);
#if !defined(ENET_INC_ARCH_WAVE600) && !defined(ENET_INC_HW_FPGA)
STATIC uint8 getLimitFromEfuse(uint8 channel, uint8 bw, uint8 band);
#endif
STATIC void hdkFreqJumpDisable(K_MSG* pMsg);
STATIC void hdkFreqJumpEnable(K_MSG* pMsg);
STATIC void hdkFreqJumpInit(K_MSG* pMsg);
STATIC void hdkFreqJumpHndlr(K_MSG* pMsg);
STATIC void hdkFreqJumpCalDone(K_MSG* pMsg);

STATIC void hdkFreqJumpStoreChanParms(HdkSetChannelReqParams_t* pSetChannelCurrentParams);
STATIC void hdkFreqJumpRestoreOriginParms(HdkSetChannelReqParams_t *pHdkSetChannelRequestParams);
STATIC void hdkFreqJumpFillChannelParams(HdkSetChannelReqParams_t* pSetChannelToFillParams, Bandwidth_e bw);
STATIC void hdkFreqJumpSetBwChannelParams(Bandwidth_e bw);
STATIC void hdkFreqJumpDBbwChannelParams(Bandwidth_e originBw);
static void hdkUpdateantennaMaskPerChannel(uint8 channel_index);
#ifndef ENET_INC_ARCH_WAVE600
static CalStatus_e RxDcOffset_GetAndStatus(CalStatus_e status1,CalStatus_e status2);
#endif
void HDK_EnableFrequencyJump(K_MSG *psMsg);
#if defined RADAR_DETECTION_ENABLED
void hdkRadarAdaptiveSensUpdateParamsReq(K_MSG *psMsg);
void hdkRadarAdaptiveSensSendSerialTrace(K_MSG *psMsg);
#endif
STATIC void hdkIndirectResetReq(K_MSG* pMsg);
STATIC void hdkResetPhyReq(K_MSG* pMsg);
STATIC void hdkResetRfReq(K_MSG* pMsg);
STATIC void hdkResetRfBandReq(K_MSG* pMsg);
STATIC void hdkAddFirstVapBandConfigEventHandler(K_MSG* pMsg);
STATIC void hdkAddFirstVapBandConfigStateHandler(K_MSG* pMsg);
STATIC void hdkOfflineCalSmInvalidEvent(K_MSG *psMsg);
STATIC void hdkOfflineCalSmRunCalReqFromCdbManEvent(K_MSG *psMsg);
STATIC void hdkOfflineCalSmFinishCalEvent(K_MSG *psMsg);
STATIC void offlineCalRunCalReqFromCdbManEventHandler(K_MSG* pMsg);
STATIC void offlineCalFinishCalReqFromCdbManEventHandler(K_MSG* pMsg);
STATIC void hdkOfflineCalSmRunCalEvent(K_MSG *psMsg);
STATIC void hdkOfflineCalFromCalProcSmRunCalEvent(K_MSG *psMsg);
STATIC void setHdkOfflineCalSmState(HdkOfflineCalState_e state);
STATIC void hdkOfflineCalFinishedSetChannelCb(void);
STATIC void hdkOfflineCalFinishedOnDemandCb(K_MSG *psMsg);
STATIC void hdkOfflineCalFinishedRadioStatedCb(void);
STATIC void sendBandStateChangedIndToHdkCdbMan(HdkState_e state, K_MSG* storedKMsgFromRequester,HdkChangeStateCbTask_e cbTask);
STATIC void antConfigSendParams(void);
STATIC void hdkAntConfigNotificationCb(K_MSG* psMsg);
STATIC void HDK_SetAntConfig(K_MSG* psMsg);
STATIC void handleModifyAntMaskOtf(PowerSaveStates_e PowerSaveState);
STATIC void setAntennaConfigurationEvent(HdkAntConfigEvent_e event, K_MSG* pMsg);
STATIC void HDK_DisableAllAnts(K_MSG* psMsg);
STATIC void hdkAntConfigSmDisableAllAntsEvent(K_MSG* psMsg);
STATIC void hdkSetProcessAndDisableAntEventHandler(K_MSG* pMsg);
STATIC void hdkAntConfigProcessSchedEventHandler(K_MSG* pMsg);
STATIC void hdkAntConfigSetAntsEventHandler(K_MSG* pMsg);
STATIC void setHdkAntConfigSmState(HdkAntConfigState_e state);
STATIC void antConfigNotificationBitmapInit(void);
STATIC void hdkAntConfigNotificationCfmEventHandler(K_MSG* pMsg);
STATIC void sendCdbManOnlineCalProcessFinishInd(bool processAbortBeforeRun);
STATIC void antConfgiNotificationToLa(void);
STATIC void antConfigNotificationToCoC(void);
STATIC void HDK_AntConfigSetProcess(K_MSG* psMsg);
STATIC void hdkAntConfigSmInvalidEvent(K_MSG* psMsg);
STATIC void hdkAntConfigSmProcessDoneEvent(K_MSG* psMsg);
STATIC void hdkSetAntConfigForMyBand(uint8 antMask);
STATIC void hdkAntConfigSmNotificationDoneEvent(K_MSG* psMsg);
STATIC void hdkAntConfigProcessEndEventHandler(K_MSG* psMsg);
STATIC void hdkSetMaxAntsReq(K_MSG* psMsg);
STATIC void hdkSetOperationalAntConfigReq(K_MSG* psMsg);
STATIC void hdkSetRxDutyCycleReq(K_MSG* psMsg);
STATIC void hdkSetRxThReq(K_MSG* psMsg);
#ifndef ENET_INC_ARCH_WAVE600
STATIC void hdkSetMinRssiReq(K_MSG* psMsg);
#endif
STATIC void setCalibrationStatistics(void);
#ifdef ENET_INC_ARCH_WAVE600
STATIC void hdkConfigCliAnalogRxDc(K_MSG* psMsg);
STATIC void hdkConfigCliDigitalRxDc(K_MSG* psMsg);
#endif
#ifdef DEBUG_UM_INTERFACE
STATIC void HDK_setIreSwitchB(K_MSG *psMsg);
#ifdef ENET_INC_ARCH_WAVE600
static void hdkTestBusEn(K_MSG* psMsg);
#endif
#endif
static void hdkGetPhyStatistics(K_MSG* psMsg);

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
uint32* p32PsdProgmodelShramAddressBand = NULL;
K_MSG* pCocSaveMsgBeforeDmaTrigger = NULL;



STATIC const FunctionEntry_t afpTaskTable[TASK_HDK_END-TASK_HDK_START]=
{	
	/* HDK config */
	{HDK_setHdkConfigReq,					  			DOUBLE_CHECK_MSG_TYPE(HDK_SET_HDK_CONFIG_REQ)},
	
	/* Progmodel msgs */
	{hdkDownloadProgmodelPermissionReq,		  			DOUBLE_CHECK_MSG_TYPE(HDK_DOWNLOAD_PROG_MODEL_PERMISSION_REQ)},	
	{hdkDownloadProgmodelReq,		 		 			DOUBLE_CHECK_MSG_TYPE(HDK_DOWNLOAD_PROG_MODEL_REQ)},	
	{hdkDonloadProgmodelDiffsReq,			  			DOUBLE_CHECK_MSG_TYPE(HDK_DOWNLOAD_PROG_MODEL_DIFFS_REQ)},	
	{hdkDownloadProgmodelAntDependentTxReq,			  	DOUBLE_CHECK_MSG_TYPE(HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ)},	
	{hdkDownloadProgmodelAntDependentRxReq,			  	DOUBLE_CHECK_MSG_TYPE(HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ)},	
	/* Platform(PSD) msgs */
	{hdkPlatformDataFieldsReq,				  			DOUBLE_CHECK_MSG_TYPE(HDK_PLATFORM_DATA_FIELDS_REQ)},
	{hdkPlatformTableReq,			  					DOUBLE_CHECK_MSG_TYPE(HDK_PLATFORM_TABLE_REQ)},	
	
	/* Set Channel msgs*/
	{hdkSetChannelEventHandler,				  			DOUBLE_CHECK_MSG_TYPE(HDK_SET_CHANNEL_REQ)},
	{HDK_SetLaChannelDataCfm,				  			DOUBLE_CHECK_MSG_TYPE(HDK_LA_SET_CHANNEL_DATA_CFM)},
	{hdkChannelNotificationCb,				  			DOUBLE_CHECK_MSG_TYPE(HDK_CHANNEL_NOTIFICATION_CFM)},
	/* Load and Store DMA complete msg */
	{ClbrMngr_HostDataChunkDmaCompleteCb,	 			DOUBLE_CHECK_MSG_TYPE(HDK_CHUNK_DMA_COMPLETE)},
	/* Online Calibration msg */
	{hdkSchedOnlineCalibrationReqEventHandler, 			DOUBLE_CHECK_MSG_TYPE(HDK_SCHED_ONLINE_CALIBRATION_REQ)},
	{hdkRunOnlineCalibrationReqEventHandler,			DOUBLE_CHECK_MSG_TYPE(HDK_ONLINE_CALIB_PROCESS_STARTED)},
	{hdkFinishOnlineCalibrationReqEventHandler, 		DOUBLE_CHECK_MSG_TYPE(HDK_FINISH_ONLINE_CALIBRATION_REQ)},
	{ClbrMngr_FinalizeOnlineCalibrationProcess,			DOUBLE_CHECK_MSG_TYPE(HDK_ONLINE_CALIB_PROCESS_ENDED)},
	
	/* Calibrate msgs */
	{hdkCalibrateEventHandler,				  			DOUBLE_CHECK_MSG_TYPE(HDK_CALIBRATE_REQ)},
	{ClbrMngr_HandleCalibrateProcessStart,	 			DOUBLE_CHECK_MSG_TYPE(HDK_CALIBRATE_PROCESS_STARTED)},
	{ClbrMngr_HandleCalibrateProcessEnd,				DOUBLE_CHECK_MSG_TYPE(HDK_CALIBRATE_PROCESS_ENDED)},
	/* Add / Remove Vap */
	{hdkAddFirstVapBandConfigEventHandler,				DOUBLE_CHECK_MSG_TYPE(HDK_ADD_VAP_BAND_CONFIG_REQ)},
	{hdkRemoveLastVapEventHandler,						DOUBLE_CHECK_MSG_TYPE(HDK_REMOVE_VAP_BAND_CONFIG_REQ)},

//#ifndef ENET_INC_ARCH_WAVE600	
	{HDK_ERPRemoveVap,									DOUBLE_CHECK_MSG_TYPE(HDK_REMOVE_NON_LAST_VAP_REQ)},
//#endif
	{hdk_PostVapActivation,								DOUBLE_CHECK_MSG_TYPE(HDK_POST_ACTIVATION_VAP)},
	
	/* TPC */
	{HDK_tpcSetAntParamsReq,				  			DOUBLE_CHECK_MSG_TYPE(HDK_SET_TPC_ANT_PARAMS_REQ)},
	{HDK_tpcConfigReq,						  			DOUBLE_CHECK_MSG_TYPE(HDK_SET_TPC_CONFIG_REQ)},

	/* Radar Detection msgs */
#if defined RADAR_DETECTION_ENABLED
	{hdkRadarDetectionTimer,				  			DOUBLE_CHECK_MSG_TYPE(HDK_RADAR_DETECTION_TIMER)},
#endif
	{hdkContinuousInterfererDetectionTimer,   			DOUBLE_CHECK_MSG_TYPE(HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER)},
#if !defined (HDK_REL_2_0)	
	/* Calibration Data */
	{HDK_setAfeCalData,						  			DOUBLE_CHECK_MSG_TYPE(HDK_AFE_SET_CALIBRATION_DATA)},
	{HDK_setRficCalData,					  			DOUBLE_CHECK_MSG_TYPE(HDK_RFIC_SET_CALIBRATION_DATA)},
	{HDK_setRssiCalData,					  			DOUBLE_CHECK_MSG_TYPE(HDK_RSSI_CALIBRATION_DATA)},
#endif	
	/* Set Antennas (CoC)*/
	{hdkSetAntennasEventHandler,			 		 	DOUBLE_CHECK_MSG_TYPE(HDK_COC_SET_ANTENNAS_REQ)},	
	
	/* Radio On /Off */
	{hdkEnableDisableRfEventHandler,		  			DOUBLE_CHECK_MSG_TYPE(HDK_CHANGE_RADIO_STATE_REQ)},
	{HDK_startRadioStateChangeProcess,					DOUBLE_CHECK_MSG_TYPE(HDK_CHANGE_RADIO_STATE_PROCESS_STARTED)},
	{HDK_finalizeRadioStateChangeProcess,				DOUBLE_CHECK_MSG_TYPE(HDK_CHANGE_RADIO_STATE_PROCESS_ENDED)},
	
	/* User Demand request */
	{hdkUserDemandEventHandler,		  					DOUBLE_CHECK_MSG_TYPE(HDK_USER_DEMAND_REQ)},
	{HDK_startUserDemandProcess,						DOUBLE_CHECK_MSG_TYPE(HDK_USER_DEMAND_PROCESS_STARTED)},
	{HDK_finalizeUserDemandProcess,						DOUBLE_CHECK_MSG_TYPE(HDK_USER_DEMAND_PROCESS_ENDED)},
	/* CCA TH request */
	{HDK_SetCcaTh,										DOUBLE_CHECK_MSG_TYPE(HDK_CCA_TH_REQ)},
	/* Power Selection request */
	{HDK_setPowerSelection,								DOUBLE_CHECK_MSG_TYPE(HDK_SET_POWER_SELECTION)},
	/* 11b Antenna Selection request */
	{HDK_set11bAntennaSelection,						DOUBLE_CHECK_MSG_TYPE(HDK_SET_11B_ANT_SEL_REQ)},
	{HDK_GetCcaTh,										DOUBLE_CHECK_MSG_TYPE(HDK_GET_CCA_TH_REQ)},
	/* Enable Frequency Jump */	
	{HDK_EnableFrequencyJump, 							DOUBLE_CHECK_MSG_TYPE(HDK_FREQ_JUMP_MODE_REQ)},		
	/*Configuration messages*/
	{hdkIndirectResetReq, 								DOUBLE_CHECK_MSG_TYPE(HDK_INDIRECT_RESET_REQ)},
	{hdkResetPhyReq, 									DOUBLE_CHECK_MSG_TYPE(HDK_RESET_PHY_REQ)},
	{hdkResetRfReq, 									DOUBLE_CHECK_MSG_TYPE(HDK_RESET_RF_REQ)},		
	{hdkResetRfBandReq, 								DOUBLE_CHECK_MSG_TYPE(HDK_RESET_RF_BAND_REQ)},
	{HDK_ConfigSmHwDependentReq, 						DOUBLE_CHECK_MSG_TYPE(HDK_CONFIG_SM_HW_DEPENDENT_REQ)},
	/*Offline calibration messages*/
	{offlineCalRunCalReqFromCdbManEventHandler,			DOUBLE_CHECK_MSG_TYPE(HDK_RUN_OFFLINE_CALIBRATION_REQ)},
	{ClbrMngr_RunCalibrationOnFirstChannel,				DOUBLE_CHECK_MSG_TYPE(HDK_RUN_OFFLINE_CALIBRATION_ON_FIRST_CHANNEL_REQ)},
	{ClbrMngr_RunCalibrationOnNextChannel,				DOUBLE_CHECK_MSG_TYPE(HDK_RUN_OFFLINE_CALIBRATION_ON_NEXT_CHANNEL_REQ)},
#if defined HDK_CDB_SUPPORT
	{HDK_PauseBandReq,									DOUBLE_CHECK_MSG_TYPE(HDK_PAUSE_NON_CALIBRATING_BAND_REQ)},
	{HDK_PauseDone,										DOUBLE_CHECK_MSG_TYPE(HDK_OTHER_CORE_CALIBRATE_PROCESS_STARTED)},
	{HDK_ResumeBandReq,									DOUBLE_CHECK_MSG_TYPE(HDK_RESUME_NON_CALIBRATING_BAND_REQ)},
	{HDK_ResumeDone,									DOUBLE_CHECK_MSG_TYPE(HDK_OTHER_CORE_CALIBRATE_PROCESS_ENDED)},
#endif
	{HDK_ResumeCalibratingBandReq,						DOUBLE_CHECK_MSG_TYPE(HDK_RESUME_CALIBRATING_BAND_REQ)},
	{offlineCalFinishCalReqFromCdbManEventHandler, 		DOUBLE_CHECK_MSG_TYPE(HDK_FINISH_OFFLINE_CALIBRATION_REQ)},
	/*Change state res from HdkCdbManager*/
	{bandStateChangedInHdkCdbManRes, 					DOUBLE_CHECK_MSG_TYPE(HDK_BAND_STATE_CHANGED_RES)},
	/*Get Hdk params to statistics manager*/
	{HDK_SetSsbModeReq, 								DOUBLE_CHECK_MSG_TYPE(HDK_SET_SSB_MODE_REQ)},
	{HDK_RadarDetectionRssiThConfigReq, 				DOUBLE_CHECK_MSG_TYPE(HDK_RADAR_DETECTION_RSSI_TH_CONFIG_REQ)},
	/*Set antenna configuration*/
	{hdkSetProcessAndDisableAntEventHandler, 			DOUBLE_CHECK_MSG_TYPE(HDK_SET_PROCESS_AND_DISABLE_ALL_ANTS_REQ)},
	{HDK_DisableAllAnts, 								DOUBLE_CHECK_MSG_TYPE(HDK_DISABLE_ALL_ANTS_REQ)},
	{hdkAntConfigProcessSchedEventHandler, 				DOUBLE_CHECK_MSG_TYPE(HDK_SET_ANT_CONFIG_PROCESS_SCHED)},
	{hdkAntConfigSetAntsEventHandler, 					DOUBLE_CHECK_MSG_TYPE(HDK_SET_ANT_CONFIG_REQ)},
	{hdkAntConfigNotificationCfmEventHandler,			DOUBLE_CHECK_MSG_TYPE(HDK_SET_ANT_CONFIG_NOTIFICATION_CFM)},
	{hdkAntConfigProcessEndEventHandler,				DOUBLE_CHECK_MSG_TYPE(HDK_SET_ANT_CONFIG_PROCESS_END)},
	{hdkSetMaxAntsReq,									DOUBLE_CHECK_MSG_TYPE(HDK_SET_MAX_ANTS_REQ)},
	{hdkSetOperationalAntConfigReq,						DOUBLE_CHECK_MSG_TYPE(HDK_SET_OPERATIONAL_ANT_CONFIG_REQ)},
	{hdkSetRxDutyCycleReq, 								DOUBLE_CHECK_MSG_TYPE(HDK_SET_RX_DUTY_CYCLE_REQ)},
	{hdkSetRxThReq, 									DOUBLE_CHECK_MSG_TYPE(HDK_SET_RX_TH_REQ)},
#ifndef ENET_INC_ARCH_WAVE600
	{hdkSetMinRssiReq, 									DOUBLE_CHECK_MSG_TYPE(HDK_SET_MIN_RSSI_REQ)},
#endif
#ifdef ENET_INC_ARCH_WAVE600
	{hdkConfigCliAnalogRxDc, 							DOUBLE_CHECK_MSG_TYPE(HDK_RXDC_ANALOG_CONFIG_CLI)},
	{hdkConfigCliDigitalRxDc, 							DOUBLE_CHECK_MSG_TYPE(HDK_RXDC_DIGITAL_CONFIG_CLI)},
#endif
	{hdkGetPhyStatistics,								DOUBLE_CHECK_MSG_TYPE(HDK_GET_PHY_STATISTICS)}, 	
	{HDK_ERPSet, 										DOUBLE_CHECK_MSG_TYPE(HDK_ERP_SET_REQ)},	
	{HDK_ERPTimerExpired,								DOUBLE_CHECK_MSG_TYPE(HDK_ERP_TIMER_EXPIRED)},
	{HDK_ERPProcessStart, 								DOUBLE_CHECK_MSG_TYPE(HDK_ERP_PROCESS_START)},
	{HDK_ERPEndProcess, 								DOUBLE_CHECK_MSG_TYPE(HDK_ERP_END_PROCESS)},
	{HDK_ERPStaAdd, 									DOUBLE_CHECK_MSG_TYPE(HDK_ERP_STATION_ADD)},
	{HDK_ERPStaRemove, 									DOUBLE_CHECK_MSG_TYPE(HDK_ERP_STATION_REMOVE)},
	{HDK_ERPBssTX, 										DOUBLE_CHECK_MSG_TYPE(HDK_ERP_BSS_TX)},	
	{HDK_DCRequest, 									DOUBLE_CHECK_MSG_TYPE(HDK_DUTY_CYCLE_SET_REQ)},
	{HDK_DCTimerExpired,								DOUBLE_CHECK_MSG_TYPE(HDK_DUTY_CYCLE_TIMER_EXPIRED)},
	{HDK_DCProcessStart,								DOUBLE_CHECK_MSG_TYPE(HDK_DUTY_CYCLE_PROCESS_START)},
	{HDK_DCEndProcess, 									DOUBLE_CHECK_MSG_TYPE(HDK_DUTY_CYCLE_END_PROCESS)},
#if defined RADAR_DETECTION_ENABLED
	{hdkRadarAdaptiveSensUpdateParamsReq,				DOUBLE_CHECK_MSG_TYPE(HDK_SET_RADAR_ADAPTIVE_SENS_PARAMS_REQ)},
	{hdkRadarAdaptiveSensSendSerialTrace,				DOUBLE_CHECK_MSG_TYPE(HDK_RADAR_ADAPTIVE_SENS_ENABLE_SERIAL_TRACE)},
#endif
	{Hdk_SetTxWindowLimit,								DOUBLE_CHECK_MSG_TYPE(HDK_SET_TX_WINDOW_SIZE)},
	{channelNotificationOnlineTimerHandler,				DOUBLE_CHECK_MSG_TYPE(HDK_SET_ONLINE_TIMER)},
#ifdef DEBUG_UM_INTERFACE
	{HDK_setIreSwitchB, 								DOUBLE_CHECK_MSG_TYPE(HDK_IRE_SWITCH_B_REQ)},
#ifdef ENET_INC_ARCH_WAVE600
	{hdkTestBusEn,										DOUBLE_CHECK_MSG_TYPE(HDK_TEST_BUS_EN_REQ)},
#endif
#endif
	
	

};

/**********************    HDK Main SM    *****************************/

STATIC const HdkStateMachineFunctionEntry_t hdkStateMachineFunc[HDK_NUMBER_OF_STATES][HDK_NUMBER_OF_EVENTS] = 
{
	/*STATE - HDK_STATE_IDLE  */
	{
		hdkInitDoneStateHandler,						/*EVENT - HDK_EVENT_INIT_DONE	     		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG     		 */
		hdkInvalidEvent, 								/*EVENT - HDK_EVENT_REMOVE_LAST_VAP		 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_ENABLE_RF 			 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_DISABLE_RF			 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_CALIBRATE		      		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_CHANNEL	      		 */
		hdkInvalidEvent, 								/*EVENT - HDK_EVENT_SCHED_ONLINE_PROCESS */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_ANTENNAS  		 */
		hdkInvalidEvent									/*EVENT - HDK_EVENT_USER_DEMAND			 */
	},

	/*STATE - HDK_STATE_INIT  */
	{
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_INIT_DONE	     		 */
		hdkAddFirstVapBandConfigStateHandler,			/*EVENT - HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG     		 */
		hdkInvalidEvent, 								/*EVENT - HDK_EVENT_REMOVE_LAST_VAP		 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_ENABLE_RF 			 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_DISABLE_RF			 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_CALIBRATE		      		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_CHANNEL	      		 */
		hdkIgnoreOnlineTimerEvent, 						/*EVENT - HDK_EVENT_SCHED_ONLINE_PROCESS */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_ANTENNAS  		 */		
		hdkInvalidEvent									/*EVENT - HDK_EVENT_USER_DEMAND			 */
	},
	/*STATE - HDK_STATE_READY  */
	{
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_INIT_DONE	     		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG     		 */
		hdkRemoveLastVapStateHandler, 					/*EVENT - HDK_EVENT_REMOVE_LAST_VAP		 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_ENABLE_RF 			 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_DISABLE_RF			 */
		hdkCalibrateStateHandler,						/*EVENT - HDK_EVENT_CALIBRATE		      		 */
		hdkSetChannelStateHandler,						/*EVENT - HDK_EVENT_SET_CHANNEL	      		 */
		hdkIgnoreOnlineTimerEvent, 						/*EVENT - HDK_EVENT_SCHED_ONLINE_PROCESS */
		hdkIgnoreCocEvent,								/*EVENT - HDK_EVENT_SET_ANTENNAS  		 */
		hdkInvalidEvent									/*EVENT - HDK_EVENT_USER_DEMAND 		 */
	},
	/*STATE -HDK_STATE_ACTIVE  */
	{
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_INIT_DONE	     		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG     		 */
		hdkRemoveLastVapStateHandler,					/*EVENT - HDK_EVENT_REMOVE_LAST_VAP		 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_ENABLE_RF 			 */
		hdkEnableDisableRfStateHandler,					/*EVENT - HDK_EVENT_DISABLE_RF			 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_CALIBRATE		      		 */
		hdkSetChannelStateHandler,						/*EVENT - HDK_EVENT_SET_CHANNEL	      		 */
		hdkOnlineTimerExpiredStateHandler,				/*EVENT - HDK_EVENT_SCHED_ONLINE_PROCESS */
		hdkSetAntennasStateHandler,						/*EVENT - HDK_EVENT_SET_ANTENNAS  		 */
		hdkUserDemandStateHandler						/*EVENT - HDK_EVENT_USER_DEMAND 		 */
	},
	/*STATE - HDK_STATE_DISABLED  */
	{
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_INIT_DONE	     		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG     		 */
		hdkRemoveLastVapStateHandler, 					/*EVENT - HDK_EVENT_REMOVE_LAST_VAP		 */
		hdkEnableDisableRfStateHandler,					/*EVENT - HDK_EVENT_ENABLE_RF 			 */
		hdkIgnoreRadioEvent,							/*EVENT - HDK_EVENT_DISABLE_RF			 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_CALIBRATE		      		 */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_CHANNEL	      		 */
		hdkIgnoreOnlineTimerEvent,						/*EVENT - HDK_EVENT_SCHED_ONLINE_PROCESS */
		hdkInvalidEvent,								/*EVENT - HDK_EVENT_SET_ANTENNAS  		 */
		hdkInvalidEvent									/*EVENT - HDK_EVENT_USER_DEMAND 		 */
	}
};

/**********************    Set Channel SM    *****************************/

STATIC const SetChannelStateMachineFunctionEntry_t setChannelStateMachineFunc[SET_CHANNEL_NUMBER_OF_STATES][SET_CHANNEL_NUMBER_OF_EVENTS] = 
{
	/*STATE - SET_CHANNEL_STATE_IDLE  */
	{
		setChannelSetFrequencyStateHandler,				/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelRemoveLastVapStateHandler				/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},

	/*STATE - SET_CHANNEL_STATE_FREQUENCY_LOCK  */
	{
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelFrequencySetStateHandler,				/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelInvalidEvent							/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},
	/*STATE - SET_CHANNEL_STATE_LOAD_CAL  */
	{
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelCalResultsLoadedStateHandler,			/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelInvalidEvent							/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},
	/*STATE -SET_CHANNEL_STATE_OFFLINE_CAL  */
	{
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelOfflineCalDoneStateHandler,			/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelInvalidEvent							/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},
	/*STATE - SET_CHANNEL_STATE_STORE_CAL  */
	{
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelCalResultsStoredStateHandler,			/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelInvalidEvent							/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},
	/*STATE -SET_CHANNEL_STATE_SEND_PARAMS  */
	{
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelChannelNotificationDoneStateHandler,	/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelInvalidEvent							/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	},
	/*STATE - SET_CHANNEL_STATE_ACTIVE  */
	{
		setChannelSetFrequencyStateHandler,				/*EVENT - SET_CHANNEL_EVENT_SET_FREQUENCY	     		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_FREQUENCY_SET     		        */
		setChannelInvalidEvent, 						/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_LOADED		        */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_OFFLINE_CAL_DONE 			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CAL_RESULTS_STORED			  */
		setChannelInvalidEvent,							/*EVENT - SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE	  */
		setChannelRemoveLastVapStateHandler				/*EVENT - SET_CHANNEL_EVENT_REMOVE_LAST_VAP			  */
	}
};

/**********************    HDK processes SM    *****************************/

STATIC const HdkProcessStateMachineFunctionEntry_t hdkProcessesStateMachineFunc[HDK_PROCESS_NUMBER_OF_STATES][HDK_PROCESS_NUMBER_OF_EVENTS] = 
{
	/*STATE - HDK_PROCESS_STATE_IDLE  */
	{
		hdkProcessScheduleProcessReqStateHandler,		/*EVENT - HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ	        */
		hdkProcessProcessScheduledStateHandler,			/*EVENT - HDK_PROCESS_EVENT_PROCESS_SCHEDULED,	        */
		hdkProcessInvalidEvent, 						/*EVENT - HDK_PROCESS_EVENT_PROCESS_FINISHED,		        */
		hdkProcessInvalidEvent							/*EVENT - HDK_PROCESS_EVENT_EXECUTION_COMPLETED,		  */
	},

	/*STATE - HDK_PROCESS_STATE_WAIT_FOR_PROCESS_START  */
	{
		hdkProcessScheduleProcessReqStateHandler,		/*EVENT - HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ	        */
		hdkProcessProcessScheduledStateHandler,			/*EVENT - HDK_PROCESS_EVENT_PROCESS_SCHEDULED,	        */
		hdkProcessInvalidEvent, 						/*EVENT - HDK_PROCESS_EVENT_PROCESS_FINISHED,		        */
		hdkProcessInvalidEvent							/*EVENT - HDK_PROCESS_EVENT_EXECUTION_COMPLETED,		  */
	},
	/*STATE - HDK_PROCESS_STATE_ACTIVE  */
	{
		hdkProcessScheduleProcessReqStateHandler,		/*EVENT - HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ	        */
		hdkProcessInvalidEvent,							/*EVENT - HDK_PROCESS_EVENT_PROCESS_SCHEDULED,	        */
		hdkProcessProcessFinishedStateHandler, 			/*EVENT - HDK_PROCESS_EVENT_PROCESS_FINISHED,		        */
		hdkProcessInvalidEvent							/*EVENT - HDK_PROCESS_EVENT_EXECUTION_COMPLETED,		  */
	},
	/*STATE -HDK_PROCESS_STATE_WAIT_FOR_PROCESS_END  */
	{
		hdkProcessScheduleProcessReqStateHandler,		/*EVENT - HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ	        */
		hdkProcessInvalidEvent,							/*EVENT - HDK_PROCESS_EVENT_PROCESS_SCHEDULED,	        */
		hdkProcessInvalidEvent, 						/*EVENT - HDK_PROCESS_EVENT_PROCESS_FINISHED,		        */
		hdkProcessExecutionCompletedStateHandler		/*EVENT - HDK_PROCESS_EVENT_EXECUTION_COMPLETED,		  */
	}
};
/**********************    HDK Offline calibration SM    *****************************/

STATIC const OfflineCalStateMachineFunctionEntry_t hdkOfflineCalSmFunc[HDK_OFFLINE_CAL_NUMBER_OF_STATES][HDK_OFFLINE_CAL_NUMBER_OF_EVENTS] = 
{
	/*STATE - HDK_OFFLINE_CAL_STATE_IDLE  */
	{
		hdkOfflineCalSmRunCalEvent,							/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION	        */
		hdkOfflineCalFromCalProcSmRunCalEvent, 				/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION_FROM_CAL_PROC 		*/
		hdkOfflineCalSmInvalidEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER,	        */
		hdkOfflineCalSmInvalidEvent, 						/*EVENT - HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER,			*/
	},
	
	/*STATE - HDK_OFFLINE_CAL_STATE_WAIT_FOR_SET_MAX_ANTS  */
	{
		hdkOfflineCalSmRunCalEvent, 						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION 		*/
		hdkOfflineCalSmInvalidEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION_FROM_CAL_PROC 		*/
		hdkOfflineCalSmInvalidEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER,			*/
		hdkOfflineCalSmInvalidEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER,			*/
	},
		

	/*STATE - HDK_OFFLINE_CAL_STATE_WAIT_FOR_OFFLINE_CAL_START  */
	{
		hdkOfflineCalSmInvalidEvent, 						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION 		*/
		hdkOfflineCalSmInvalidEvent, 						/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION_FROM_CAL_PROC 		*/
		hdkOfflineCalSmRunCalReqFromCdbManEvent,			/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER, 		*/
		hdkOfflineCalSmInvalidEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER,			*/
	},
	/*STATE - HDK_OFFLINE_CAL_STATE_CALIBRATION_RUNNING  */
	{
		hdkOfflineCalSmRunCalEvent,							/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION			*/
		hdkOfflineCalSmInvalidEvent, 						/*EVENT - HDK_OFFLINE_CAL_EVENT_START_CALIBRATION_PROC 		*/
		hdkOfflineCalSmRunCalReqFromCdbManEvent,			/*EVENT - HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER, 		*/
		hdkOfflineCalSmFinishCalEvent,						/*EVENT - HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER,			*/
	},
};

/**********************    HDK ANTENNA CONFIGURATION SM    *****************************/
STATIC const AntConfigStateMachineFunctionEntry_t AntConfigChangeSmFunc[ANT_CONFIG_NUMBER_OF_STATES][ANT_CONFIG_NUMBER_OF_EVENTS] = 
{
	/*STATE - ANT_CONFIG_IDLE  */
	{
		HDK_AntConfigSetProcess,								/*EVENT - ANT_CONFIG_EVENT_SET_PROCESS	       */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_DISABLE_ANTS 	   */
		HDK_SetAntConfig, 										/*EVENT - ANT_CONFIG_EVENT_SET_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_NOTIFICATION_DONE 	   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_PROCESS_END	   */

	},
	/*STATE - ANT_CONFIG_WAIT_FOR_PROCESS_SCHED  */
	{
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_SET_PROCESS		   */
		hdkAntConfigSmDisableAllAntsEvent,						/*EVENT - ANT_CONFIG_EVENT_DISABLE_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_SET_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_NOTIFICATION_DONE 	   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_PROCESS_END	   */
	},

	/*STATE - ANT_CONFIG_DISABLE_ANT  */
	{
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_SET_PROCESS		   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_DISABLE_ANTS 	   */
		HDK_SetAntConfig,										/*EVENT - ANT_CONFIG_EVENT_SET_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_NOTIFICATION_DONE 	   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_PROCESS_END	   */
	},
	/*STATE - ANT_CONFIG_SET_ANTENNA_WAIT_FOR_NOTIFICATION_CFM  */
	{
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_SET_PROCESS		   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_DISABLE_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_SET_ANTS 	   */
		hdkAntConfigSmNotificationDoneEvent,					/*EVENT - ANT_CONFIG_EVENT_NOTIFICATION_DONE	   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_PROCESS_END	   */
	},
	
	/*STATE - ANT_CONFIG_WAIT_FOR_PROCESS_END	*/
	{
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_SET_PROCESS		   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_DISABLE_ANTS 	   */
		hdkAntConfigSmInvalidEvent, 							/*EVENT - ANT_CONFIG_EVENT_SET_ANTS 	   */
		hdkAntConfigSmInvalidEvent,								/*EVENT - ANT_CONFIG_EVENT_NOTIFICATION_DONE	   */
		hdkAntConfigSmProcessDoneEvent,							/*EVENT - ANT_CONFIG_EVENT_PROCESS_END	   */
	
	},
};
/**********************    HDK FREQU JUMP SM    *****************************/
STATIC const HdkFreqJumpStateMachineFunctionEntry_t hdkFreqJumpStateMachineFunc[FREQ_JUMP_NUMBER_OF_STATES][FREQ_JUMP_NUMBER_OF_EVENTS] = 
{
	/*STATE - FREQ_JUMP_STATE_DISABLED  */
	{
		hdkFreqJumpEnable,								/*EVENT - FREQ_JUMP_EVENT_ENABLE_FREQ	     	*/
		hdkFreqJumpEventIgnor,							/*EVENT - FREQ_JUMP_EVENT_DISABLE_FREQ		*/
		hdkFreqJumpEventIgnor,							/*EVENT - FREQ_JUMP_EVENT_START     			*/
		hdkFreqJumpEventIgnor, 							/*EVENT - FREQ_JUMP_EVENT_NEXT_BW  	        */		
		hdkFreqJumpEventIgnor						    /*EVENT - FREQ_JUMP_EVENT_CAL_DONE     		*/
	},

	/*STATE - FREQ_JUMP_STATE_INIT  */
	{		
		hdkFreqJumpEventIgnor,							/*EVENT - FREQ_JUMP_EVENT_ENABLE_FREQ	       */
		hdkFreqJumpDisable,								/*EVENT - FREQ_JUMP_EVENT_DISABLE_FREQ		*/
		hdkFreqJumpInit,								/*EVENT - FREQ_JUMP_EVENT_START     			*/
		hdkFreqJumpInvalidEvent, 						/*EVENT - FREQ_JUMP_EVENT_NEXT_BW		       */		
		hdkFreqJumpEventIgnor						    /*EVENT - FREQ_JUMP_EVENT_CAL_DONE     		*/
	},
	/*STATE - FREQ_JUMP_STATE_FJ_CHANNEL  */
	{
		
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_ENABLE_FREQ	     	 */
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_DISABLE_FREQ		*/
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_START     			 */
		hdkFreqJumpHndlr, 								/*EVENT - FREQ_JUMP_EVENT_NEXT_BW		        */		
		hdkFreqJumpEventIgnor							/*EVENT - FREQ_JUMP_EVENT_CAL_DONE     		 */
	},
	/*STATE - FREQ_JUMP_STATE_REQ_CHANNEL  */
	{
		
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_ENABLE_FREQ	     	*/
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_DISABLE_FREQ		*/
		hdkFreqJumpInvalidEvent,						/*EVENT - FREQ_JUMP_EVENT_START     			*/
		hdkFreqJumpEventIgnor, 							/*EVENT - FREQ_JUMP_EVENT_NEXT_BW		        */		
		hdkFreqJumpCalDone								/*EVENT - FREQ_JUMP_EVENT_CAL_DONE     		*/
	}		
};


STATIC const ChannelNotificationFunctionEntry_t channelNotificationFunc[CHANNEL_NOTIFICATION_MAX_NUM_OF_REQESTERS] =
{
	channelNotificationLATpcData,
	channelNotificationTpcTimerHandler,
	channelNotificationCoC,
	ChannelNotificationHeGroupManager

};



const uint32 ChannelNotificationBitmaps[ST_LAST] = 
{
	CHANNEL_NOTIFICATION_MAP_ST_NORMAL,
	CHANNEL_NOTIFICATION_MAP_ST_SCAN,
	CHANNEL_NOTIFICATION_MAP_ST_CSA,
	CHANNEL_NOTIFICATION_MAP_ST_RSSI,
	CHANNEL_NOTIFICATION_MAP_ST_NORMAL_AFTER_RSSI,
	CHANNEL_NOTIFICATION_MAP_ST_CALIBRATE
};
STATIC const AntConfigNotificationFunctionEntry_t AntConfigNotificationFunc[ANT_CONFIG_MAX_NUM_OF_REQESTERS] =
{
	antConfgiNotificationToLa,
	antConfigNotificationToCoC,
	antConfigNotificationToHeGroupManager,
};

Clipping_t clippingDB;

hdkConfiguration_t 	hdkConfigParams;

RxThreshold_t		rxThresholdParams = {0};

SetChannelParams_t 	setChannelParams;

HdkSSBParameters_t 	ssbParameters;

uint8 activeAntMask;
uint8 maxActiveAnt;

HdkSmStates_t hdkSmStates;

HdkNotificationParams_t channelNotificationParams;
HdkAntConfigDb_t antConfigDb;


//uint8 hdkVapManagerAddVapId;
//uint8 hdkVapManagerRemoveVapId;

UMI_ANT_SELECTION_11B GlobalAntSelection= {0};
HdkFreqJumpParams_t G_HdkFreqJumpParams = {0};

uint16 LoFrequencies_G[RFIC_LO_FREQUENCIES] = {0};

uint32 hkdRadioOn;

#define MAX_UPPER_BONDING_CHANNEL	7

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
STATIC void hdkSmInit(void)
{
	/* initialize HDK state machines */
	
	setHdkMainSmState(HDK_STATE_IDLE);
	setSetChannelSmState(SET_CHANNEL_STATE_IDLE);
	setHdkProcessSmState(HDK_PROCESS_STATE_IDLE);
	setHdkProcessId(HDK_PROCESS_NONE);
	setFreqJumpSmState(FREQ_JUMP_STATE_DISABLED);
	G_HdkFreqJumpParams.fjEnabled = FALSE;
	hdkSmStates.hdkProcessParams.requestedProcessesBitmap = 0;
	
}

STATIC void channelNotificationInit(void)
{
	/* initialize Channel Notification database */
	memset(&channelNotificationParams, 0, sizeof(HdkNotificationParams_t));
}

#if !defined (HDK_REL_2_0)
STATIC void HDK_setAfeCalData(K_MSG * psMsg)
{
#if !defined (ENET_INC_HW_FPGA)
	AFE_SetEfuseData(psMsg);
#endif
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_AFE_CALIBRATION_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_setRficCalData(K_MSG * psMsg)
{
	RficDriver_SetCalibrationData(psMsg);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_setRssiCalData(K_MSG * psMsg)
{
//#if !defined HDK_INTERMEDIATE_UNTIL_API_MERGE//PHYTBD: open after merge with CDB and API lignment  
	ILOG0_D("HDK_setRssiCalData. msgType: 0x%x ", psMsg->header.tKMsgType);
	RssiPath_GetTableFromDriver(psMsg);
//#endif
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RSSI_CAL_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}
#endif

STATIC void setBwAndFrequency(K_MSG *pMsg)
{
	HdkSetChannelReqParams_t* pSetChannelReqParams = (HdkSetChannelReqParams_t*) pK_MSG_DATA(pMsg);
	uint8 prevBW = setChannelParams.setChannelReqParams.chan_width;
	
	setChannelParams.isBwChanged = FALSE;
	setChannelParams.setChannelReqParams.switchType = pSetChannelReqParams->switchType;
	ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE);
	/* Store Set Channel Params in database */
	MEMCPY(&setChannelParams.setChannelReqParams, pSetChannelReqParams, sizeof(HdkSetChannelReqParams_t));

	/* SSB parameters configuration */
	ssbParameters.hdkSSBTcrBw = pSetChannelReqParams->chan_width;
	if (ssbParameters.ssbConfigurationValid == TRUE)
	{
		setChannelParams.setChannelReqParams.chan_width = hdkGetSsbModifiedBw(setChannelParams.setChannelReqParams.chan_width, ssbParameters);
		hdkSsbModeFixChannelParams();
	}

	if (setChannelParams.setChannelReqParams.chan_width != prevBW)
	{
		setChannelParams.isBwChanged = TRUE;
	}
	/* Radar / interferer detection configuration */
	hdkRadarAndInterfererConfiguration();
	
	/* Stop TPC timer */
	TPC_stopTimer();
		
	/* Stop any PHY activity */
	HDK_preSetChannel(setChannelParams.setChannelReqParams.chan_width);
	PhyDrv_ResetBB();
	
	/* Set spectrum  */
	PhyDrv_SetSpectrum(setChannelParams.band, setChannelParams.setChannelReqParams.chan_width, setChannelParams.setChannelReqParams.primary_chan_idx, setChannelParams.isBwChanged);	
#ifdef ENET_INC_ARCH_WAVE600
	RssiPath_extractValuesFromCalBin();
#endif

#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	ClbrHndlr_setFrequency();
#endif

	PhyDrv_ReActivateBB();
	PhyDrv_BandEdgeFix(&setChannelParams);	
	
}

STATIC void hdkRadarAndInterfererConfiguration(void)
{
	uint8 channel = Utils_GetPrimaryChannel(setChannelParams.setChannelReqParams.low_chan_num, setChannelParams.setChannelReqParams.low_chan_num2, setChannelParams.setChannelReqParams.chan_width, setChannelParams.setChannelReqParams.primary_chan_idx);
#if defined RADAR_DETECTION_ENABLED

	HdkRadarDetection_SetChannelRequest(&setChannelParams.setChannelReqParams);

#endif
	HdkContinuousInterfererDetection_SetChannelRequest(&setChannelParams.setChannelReqParams);

	PhyDrvInterfererDetection_SetChannelRequest(channel, setChannelParams.setChannelReqParams.isRadarDetectionNeeded, setChannelParams.setChannelReqParams.isContinuousInterfererDetectionNeeded);
}
STATIC void sendChannelParams(void)
{
	uint8 requestersIndex;
	
	channelNotificationParams.notHandledReqCounter = 0;

	channelNotificationParams.requestersBitmap = ChannelNotificationBitmaps[setChannelParams.setChannelReqParams.switchType];
	
	if (channelNotificationParams.requestersBitmap == CHANNEL_NOTIFICATION_DISABLED_BITMAP)
	{
		/* No requesters - Send Channel Notification Done event to Set Channel SM */
		setChannelChannelNotificationDoneEventHandler(NULL);
	}
	else
	{
		for (requestersIndex = 0; requestersIndex < CHANNEL_NOTIFICATION_MAX_NUM_OF_REQESTERS; requestersIndex++)
		{
			if (channelNotificationParams.requestersBitmap & (1 << requestersIndex))
			{
				channelNotificationParams.notHandledReqCounter++;
#ifdef HDK_LOGS	
				ILOG0_D("sendChannelParams. Call Requester: %d ", requestersIndex);
				SLOG0(0, 0, HdkNotificationParams_t, &channelNotificationParams);
#endif
				/* Call requester handler */
				channelNotificationFunc[requestersIndex]();
			}
		}
	}
}

STATIC void hdkChannelNotificationCb(K_MSG * psMsg)
{
	UNUSED_PARAM(psMsg);	
	channelNotificationParams.notHandledReqCounter--;
	
#ifdef HDK_LOGS	
	ILOG0_V("hdkChannelNotificationCb");
	SLOG0(0, 0, HdkNotificationParams_t, &channelNotificationParams);
#endif

	if (channelNotificationParams.notHandledReqCounter == 0)
	{	
		/* Send Channel Notification Done event to Set Channel SM */
		setChannelChannelNotificationDoneEventHandler(NULL);
	}
}
STATIC void antConfigSendParams(void)
{
	uint8 requestersIndex;

	antConfigDb.antConfigParams.notHandledReqCounter = 0;
	
	if (antConfigDb.antConfigParams.requestersBitmap == 0)
	{
		/* No requesters - Send notificationd done event to SM */
		setAntennaConfigurationEvent(ANT_CONFIG_EVENT_NOTIFICATION_DONE, NULL);

	}
	else
	{
		for (requestersIndex = 0; requestersIndex < ANT_CONFIG_MAX_NUM_OF_REQESTERS; requestersIndex++)
		{
			if (antConfigDb.antConfigParams.requestersBitmap & (1 << requestersIndex))
			{
				antConfigDb.antConfigParams.notHandledReqCounter++;
#ifdef HDK_LOGS	
				ILOG0_D("sendChannelParams. Call Requester: %d ", requestersIndex);
				SLOG0(0, 0, HdkNotificationParams_t, &antConfigDb.antConfigParams);
#endif
				/* Call requester handler */
				AntConfigNotificationFunc[requestersIndex]();
			}
		}
	}
	
}
STATIC void hdkAntConfigNotificationCb(K_MSG* psMsg)
{
	antConfigDb.antConfigParams.notHandledReqCounter--;
#ifdef HDK_LOGS	
	ILOG0_V("hdkAntConfigNotificationCb");
	SLOG0(0, 0, HdkNotificationParams_t, &antConfigDb.antConfigParams);
#endif

	if (antConfigDb.antConfigParams.notHandledReqCounter == 0)
	{	
		/* Send Channel Notification Done event to Ant config SM */
		setAntennaConfigurationEvent(ANT_CONFIG_EVENT_NOTIFICATION_DONE,psMsg);
	}
}


STATIC void hdkDownloadProgmodelPermissionReq(K_MSG *psMsg)
{
	if(hdkSmStates.hdkMainSmState == HDK_STATE_INIT)
	{
		OSAL_SEND_MESSAGE( UMI_MC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
	}
	else
	{
		DEBUG_ASSERT(0);
	}
}

STATIC void hdkDownloadProgmodelReq(K_MSG *psMsg)
{
	vLoadProgModel(0);
	OSAL_SEND_MESSAGE(UMI_UM_DOWNLOAD_PROG_MODEL_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void hdkDonloadProgmodelDiffsReq(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	DEBUG_ASSERT(0);
}
STATIC void hdkDownloadProgmodelAntDependentTxReq(K_MSG *psMsg)
{	
#ifdef ENET_INC_ARCH_WAVE600
	uint8 macRegAntMask;
	uint8 ant;

	macRegAntMask = PhyDrv_ReadMacAntConfig();
	/* Load progmodel should be done to all antenna together, We already update all antenna in one band through IndirectReset functions, so progmodel will be downloaded through that band*/
	/* Antenna mask will be changed to real configuration using HDK_CDB_MAN_SET_ANT_CONFIG_REQ*/
	if (macRegAntMask == ANTENNA_BITMAP_ALL_ANTENNAS_GEN5)
	{
		for(ant=0;ant<TOTAL_ANTENNAS;ant++)
		{
			vLoadProgModel(ant*PROGMODEL_TX_ANT_SECTION_OFFSET);
		}
	}
	OSAL_SEND_MESSAGE(UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#endif
}
STATIC void hdkDownloadProgmodelAntDependentRxReq(K_MSG *psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600
	uint32 macRegAntMask;
	uint8 ant;
	macRegAntMask = PhyDrv_ReadMacAntConfig();
	/* Load progmodel should be done to all antenna together, We already update all antenna in one band through IndirectReset functions, so progmodel will be downloaded through that band*/
	/* Antenna mask will be changed to real configuration using HDK_CDB_MAN_SET_ANT_CONFIG_REQ*/

	if (macRegAntMask == ANTENNA_BITMAP_ALL_ANTENNAS_GEN5)
	{
		for(ant=0;ant<TOTAL_ANTENNAS;ant++)
		{
			vLoadProgModel(ant*PROGMODEL_RX_ANT_SECTION_OFFSET);
		}
	}
	OSAL_SEND_MESSAGE(UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#endif
}

/****************************************************************************
 **
 ** NAME:           vBSS_PLATFORM_DATA_FIELDS_REQ
 **
 ** PARAMETERS:		K_MSG *psMsg
 **
 ** RETURN VALUES:  none
 ** 		
 ****************************************************************************/
STATIC void hdkPlatformDataFieldsReq(K_MSG *psMsg)
{
	platformDataFields_t *psDataFields = (platformDataFields_t *) pK_MSG_DATA(psMsg);

	PSD_copyPlatformDataFields(psDataFields->dataFields);
		
	OSAL_SEND_MESSAGE(UMI_MC_MAN_PLATFORM_DATA_FIELDS_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
 **
 ** NAME:           vBSS_PLATFORM_TABLE_REQ
 **
 ** PARAMETERS:		K_MSG *psMsg
 **
 ** RETURN VALUES:  none
 ** 		
 ****************************************************************************/
STATIC void hdkPlatformTableReq(K_MSG *psMsg)
{
	PSD_handlePlatformTable(psMsg);
}

STATIC void HDK_tpcConfigReq(K_MSG * psMsg)
{
	tpcConfig_t* params = (tpcConfig_t*)pK_MSG_DATA(psMsg);

#ifdef HDK_LOGS	
	SLOG0(0, 0, tpcConfig_t, params);
#endif

	TPC_configReq(params);

	OSAL_SEND_MESSAGE(UMI_MC_MAN_TPC_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_tpcSetAntParamsReq(K_MSG * psMsg)
{
	tpcAntParams_t* params = (tpcAntParams_t*)pK_MSG_DATA(psMsg);

	TPC_initAntParams(params);
	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_TPC_ANT_PARAMS_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_setHdkConfigReq(K_MSG * psMsg)
{
	UMI_HDK_CONFIG* params = (UMI_HDK_CONFIG*)pK_MSG_DATA(psMsg);
	
#ifdef HDK_LOGS	
#ifdef ENET_INC_ARCH_WAVE600
	SLOG0(0, 0, UMI_HDK_CONFIG, params);
#endif
#endif
	if (params->getSetOperation == API_GET_OPERATION)
	{
		params->setChannelMode = setChannelParams.mode;
		MEMCPY(&params->hdkConf, &hdkConfigParams, sizeof(hdkConfiguration_t));
		OSAL_SEND_MESSAGE(UMI_MC_MAN_HDK_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
	}
	else
	{

		HDK_configure(params);
	
#ifdef ENET_INC_ARCH_WAVE600
		OSAL_SEND_MESSAGE(PAC_MANAGER_SET_BAND_REQ, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
#else
		TxSenderInterface_Send_Band(params->hdkConf.band);
		OSAL_SEND_MESSAGE(UMI_MC_MAN_HDK_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#endif
	}

}
STATIC void HDK_startRadioStateChangeProcess(K_MSG *psMsg)
{
	ProcessManagerReturnParams_t*	processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG *requesterParams = (K_MSG *)processMangerReturnPrams->requesterParams;
	UMI_ENABLE_RADIO* pEnableRadio = (UMI_ENABLE_RADIO*)pK_MSG_DATA(requesterParams);
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessScheduledEventHandler(NULL, HDK_PROCESS_RADIO_ON_OFF);
	
	HDK_TurnRadioOffOn(pEnableRadio->u32RadioOn);
	
	// Calibrate if needed
	/* Calibrate */
	ClbrMngr_RunRadioStateChangeCalibration(pEnableRadio->u32RadioOn);
}
STATIC void HDK_finalizeRadioStateChangeProcess(K_MSG *psMsg)
{
	/* Send Process Execution Completed event to HDK Process SM */
	hdkProcessExecutionCompletedEventHandler(psMsg, HDK_PROCESS_RADIO_ON_OFF);
}


 void HDK_TurnRadioOffOn(uint32 u32RadioOn)
{
	bool radioOn;
	bool radioOff;
	bool isErpDutyCycle;
	uint8 requestedTxAntsMask, requestedRxAntsMask, requestedNumOfAnts;
	PowerSaveStates_e PowerSaveState;

	/* Configure antennas params */
	if (u32RadioOn == DISABLE_RADIO)
	{
		requestedTxAntsMask = ANTENNA_BITMAP_NONE;
		requestedRxAntsMask = ANTENNA_BITMAP_NONE;
		requestedNumOfAnts  = 0;
		radioOn = FALSE;
		radioOff= TRUE;
#ifdef HDK_LOGS	
		ILOG0_D("radioOn1:%d (2)",radioOn);
#endif
#if defined RADAR_DETECTION_ENABLED
		/*Set radar timer*/
		MT_SetModeTimer(MT_TIMER_0, MT_TIMER_DISABLE, MT_TIMER_ONE_SHOT);	
#endif
	}
	else
	{
		requestedTxAntsMask = CoC_getMaskActiveTxAnts();
		requestedRxAntsMask = CoC_getMaskActiveRxAnts();
		requestedNumOfAnts  = CoC_getNumActiveTxAnts();
		radioOn = TRUE;
		radioOff= FALSE;
		/*Set radar timer*/
#if defined RADAR_DETECTION_ENABLED
		if(HdkRadarDetectionIsRadarDetectionEnabled())
		{
			MT_SetModeTimer(MT_TIMER_0, MT_TIMER_ENABLE, MT_TIMER_ONE_SHOT);
		}
#endif
	}
	// Turn on/off antennas
	isErpDutyCycle = HDK_DCisEnable() || HDK_ERPisEnable();
	ILOG0_D("isErpDutyCycle: %x",isErpDutyCycle);
	PowerSaveState = HDK_FindPowerSaveState(radioOn, radioOff, requestedNumOfAnts, FALSE, isErpDutyCycle);
	ILOG0_D("PowerSaveState: %x",PowerSaveState);
	HDK_SetAntennasReq((AntennaBitmaps_e)requestedTxAntsMask, (AntennaBitmaps_e)requestedRxAntsMask, requestedNumOfAnts, PowerSaveState);
}

STATIC void HDK_startUserDemandProcess(K_MSG *psMsg)
{
	ProcessManagerReturnParams_t*	processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG *requesterParams = (K_MSG *)processMangerReturnPrams->requesterParams;
	UMI_HDK_USER_DEMAND* userDemandParams = (UMI_HDK_USER_DEMAND*)pK_MSG_DATA(requesterParams);

	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessScheduledEventHandler(NULL, HDK_PROCESS_USER_DEMAND);
	
#if defined(ENET_INC_HW_FPGA)
	FATAL(" In case we're running on FPGA,  we should't get here ");
#endif

	/* Read temperature from RFIC */
	RficDriver_ReadTemperature(&(userDemandParams->temperature[0]));
	
#ifdef HDK_LOGS	
	ILOG0_D("HDK_startUserDemandProcess. temp %d ",userDemandParams->temperature[0]);
#endif

	/* Calibrate upon user request */
	ClbrMngr_RunCalibrationOnDemand(userDemandParams->calibrateMask, requesterParams);
}
STATIC void HDK_finalizeUserDemandProcess(K_MSG *psMsg)
{
	/* Send Process Execution Completed event to HDK Process SM */
	hdkProcessExecutionCompletedEventHandler(psMsg, HDK_PROCESS_USER_DEMAND);
}
STATIC void HDK_setPowerSelection(K_MSG *psMsg)
{
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_POWER_LIMIT_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
}

STATIC void HDK_set11bAntennaSelection(K_MSG *psMsg)
{		
	set11bAntennaSelection(psMsg,TRUE);
	OSAL_SEND_MESSAGE(UMI_MAN_SEND_11B_SET_ANT_CFM, TASK_UM_IF_TASK, psMsg, VAP_ID_DO_NOT_CARE);
}


void HDK_override11bAntSel(uint8 antMask)
 {
	 uint8 firstAnt;
	 uint8 global11bRx, global11bTx, global11Rate;
	 
	 HDK_Get11bAntSelParams(&global11bRx, &global11bTx, &global11Rate);
	 if ((global11bRx == 0) && (global11bTx == 0))
	 {
		 firstAnt = PSD_findFirstAntInMask(antMask);
		 
		 HDK_Set11bAntSelParams(firstAnt, firstAnt, 0);
		 PhyDrv_Set_11B_RxAntSelection((PhyDrv_11BAntSelection_e)firstAnt);
		 PhyDrv_Set_11B_TxAntSelection((PhyDrv_11BAntSelection_e)firstAnt);  
 
			 
	 }
 }
#ifdef DEBUG_UM_INTERFACE
STATIC void HDK_setIreSwitchB(K_MSG *psMsg)
{		
	int8 setAPHighLowFilterBank;
	UMI_CONTROL_t* params;
	params = (UMI_CONTROL_t*)pK_MSG_DATA(psMsg);
	setAPHighLowFilterBank = params->setAPHighLowFilterBank;
	RficDriver_SelectBandFilterB(setAPHighLowFilterBank,DRIVER,0);
	OSAL_SEND_MESSAGE(UMI_IRE_SWITCH_B_CFM, TASK_UM_IF_TASK, psMsg, VAP_ID_DO_NOT_CARE);
}
#endif

#if defined HDK_CDB_SUPPORT
STATIC void HDK_PauseDone(K_MSG *psMsg)
{	
	sendMsgToHdkCdbOfflineCalSm(HDK_CDB_MAN_NON_CALIBRATING_BAND_PAUSE_DONE);
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessScheduledEventHandler(psMsg, HDK_PROCESS_PAUSE_BAND);
}
STATIC void HDK_ResumeDone(K_MSG *psMsg)
{
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessExecutionCompletedEventHandler(psMsg, HDK_PROCESS_PAUSE_BAND);
}
STATIC void HDK_PauseBandReq(K_MSG *psMsg)
{
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessScheduleProcessReqEventHandler(psMsg, HDK_PROCESS_PAUSE_BAND);

}
STATIC void HDK_ResumeBandReq(K_MSG *psMsg)
{
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessFinishedEventHandler(psMsg, HDK_PROCESS_PAUSE_BAND);
}
#endif
STATIC void HDK_ResumeCalibratingBandReq(K_MSG *psMsg)
{
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessFinishedEventHandler(psMsg, HDK_PROCESS_CALIBRATE);
}



/**********************************************************************************

hdkRadarDetectionTimer 


Description:
------------
handles a radar detection timer

Input: 
-----
tsManagerMessage 	


	
		
Output:
-------
	

Returns:
--------
	 
	
**********************************************************************************/

#if defined RADAR_DETECTION_ENABLED
STATIC void hdkRadarDetectionTimer(K_MSG *pMsg)
{
	UNUSED_PARAM(pMsg);	
	HdkRadarDetection_TimerExpired();
}
#endif

/**********************************************************************************

hdkContinuousInterfererDetectionTimer 


Description:
------------
handles a continuous interferer detection timer

Input: 
-----
tsManagerMessage 	


	
		
Output:
-------
	

Returns:
--------
	 
	
**********************************************************************************/

STATIC void hdkContinuousInterfererDetectionTimer(K_MSG *pMsg)
{
	UNUSED_PARAM(pMsg);	
	HdkContinuousInterfererDetection_TimerExpired();
}


/**********************************************************************************

hdk_RemoveVap 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * pMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
STATIC void hdk_PostVapActivation(K_MSG* pMsg)
{
	uint8 vapId;
	UMI_SET_WMM_PARAMETERS *postVapActivationMessage = NULL;

	postVapActivationMessage = (UMI_SET_WMM_PARAMETERS *)EXTRACT_VAP_MANAGER_MSG(pMsg);
	//KW_IGNORE ABV.GENERAL .. since abdata is never assigned, but used for typecast.
	
 	vapId = postVapActivationMessage->vapId;

	HDK_ERPPostVapActivation(pMsg);
	/*HDK_DCRadioOnOffCommand(ENABLE_RADIO);*/


	/* Send indication for HDK_CDB_MANAGER that VAP activation is done (for online calibration) */
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_BAND_POST_VAP_ACTIVATION_IND, TASK_HDK_CDB_MANAGER, vapId);
	
	FILL_VAP_MANAGER_CONFIRM_MSG(pMsg, vapId, VAP_MANAGER_POST_VAP_ACTIVATION, BSS_MANAGER_VAP_MANAGER_HDK_CLIENT);
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, pMsg, pMsg->header.vapId);
}
STATIC uint8 getRegulationLimitPerBw(uint8 band, uint8 bw, uint8 channel)
{
	
	uint8 limitFromHost, limitFromEfuse;
	
	/* Get regulation limit from host - MIN(CRDA limit, PSD) */
	limitFromHost = TPC_getRegulationLimit(bw) >> (GAIN_RESOLUTION - 1);

	/* Get limit from eFuse memory */
#if defined(ENET_INC_ARCH_WAVE600) || defined(ENET_INC_HW_FPGA)
	UNUSED_PARAM(band);
	UNUSED_PARAM(channel);
	limitFromEfuse = 0xFF;
#else
	limitFromEfuse = getLimitFromEfuse(channel, bw, band);
#endif
	
#ifdef HDK_LOGS	
	ILOG0_DD("limitFromHost %d, limitFromEfuse %d",limitFromHost, limitFromEfuse);
#endif

	return MIN(limitFromHost, limitFromEfuse);
}
#if !defined(ENET_INC_ARCH_WAVE600)&& !defined(ENET_INC_HW_FPGA)
STATIC uint8 getLimitFromEfuse(uint8 channel, uint8 bw, uint8 band)
{
	uint32 address;
	uint8 powerLimitsVersion;
	uint8 cisHeaderOffset = EFUSE_POWER_LIMITS_CIS_HEADER_OFFSET + EFUSE_POWER_LIMITS_VERSION_LENGTH;
	uint8 powerLimit;
	
	/* validate eFuse power limits version */
	efuseAccess_Read(&powerLimitsVersion, EFUSE_POWER_LIMITS_START_ADDRESS + EFUSE_POWER_LIMITS_CIS_HEADER_OFFSET);
	
	if (powerLimitsVersion > 0)
	{
		/* eFuse is burned */
		ASSERT(powerLimitsVersion == EFUSE_POWER_LIMITS_VERSION);
		
		if (band == BAND_5_2_GHZ)
		{
			cisHeaderOffset <<= 1;
		}

		/* Calculate address in eFuse for each channel */
		address = EFUSE_POWER_LIMITS_START_ADDRESS + cisHeaderOffset + HDK_convertChannelNumToIndex(channel, bw, band);

		/* Read from eFuse */
		efuseAccess_Read(&powerLimit, address);

		/* Flip readed value - limits are stored in efuse in the form [constant - limit] to prevent hacks */
		powerLimit = EFUSE_POWER_LIMITS_FLIPPING_CONSTANT - powerLimit;
	}
	else
	{
		/* Do not consider limit which is taken from un-burned memory */
		powerLimit = MAX_UINT8;
	}

	return powerLimit;
}
#endif
/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

HDK_Task 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

/**********************    Event Handlers - HDK Main SM    *****************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void hdkInitDoneEventHandler(K_MSG* pMsg)
{
	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_INIT_DONE](pMsg);
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

STATIC void hdkAddFirstVapBandConfigEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG. current state: %d", hdkSmStates.hdkMainSmState);
#endif

	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG](pMsg);

}

void hdkRemoveLastVapEventHandler(K_MSG* pMsg)
{

#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_REMOVE_LAST_VAP. current state: %d", hdkSmStates.hdkMainSmState);
#endif

	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_REMOVE_LAST_VAP](pMsg);
}

void hdkEnableDisableRfEventHandler(K_MSG* pMsg)
{
	UMI_ENABLE_RADIO* pEnableRadio = (UMI_ENABLE_RADIO*)pK_MSG_DATA(pMsg);
	uint32 enableRadio = pEnableRadio->u32RadioOn;
	
	/*save enable state*/
	hkdRadioOn = enableRadio;
	if (enableRadio == ENABLE_RADIO)
	{
#ifdef HDK_LOGS	
		ILOG0_D("HDK event: HDK_EVENT_ENABLE_RF. current state: %d", hdkSmStates.hdkMainSmState);
#endif
		hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_ENABLE_RF](pMsg);
	}
	else
	{
#ifdef HDK_LOGS	
		ILOG0_D("HDK event: HDK_EVENT_DISABLE_RF. current state: %d", hdkSmStates.hdkMainSmState);
#endif
		hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_DISABLE_RF](pMsg);
	}	
}

void hdkCalibrateEventHandler(K_MSG* pMsg)
{

#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_CALIBRATE. current state: %d", hdkSmStates.hdkMainSmState);
#endif
	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_CALIBRATE](pMsg);
}

void hdkSetChannelEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_SET_CHANNEL. current state: %d", hdkSmStates.hdkMainSmState);
#endif
	
	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_SET_CHANNEL](pMsg);
}

void hdkSchedOnlineCalibrationReqEventHandler(K_MSG* pMsg)
{
	HdkCdbManagerOnlineCalSmMsg_t* onlineCalSmMsg = (HdkCdbManagerOnlineCalSmMsg_t*) pK_MSG_DATA(pMsg);	

#ifdef HDK_LOGS	
		ILOG0_D("HDK event: HDK_EVENT_SCHED_ONLINE_PROCESS. current state: %d", hdkSmStates.hdkMainSmState);
#endif

	ClbrMngr_SetForceOnlineCal(onlineCalSmMsg->runForceCal);
	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_SCHED_ONLINE_PROCESS](pMsg);
}

void hdkFinishOnlineCalibrationReqEventHandler(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	/* Send Process Finished event to HDK Process SM */
	hdkProcessProcessFinishedEventHandler(NULL, HDK_PROCESS_ONLINE_CAL);
}
void hdkSetAntennasEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_SET_ANTENNAS. current state: %d", hdkSmStates.hdkMainSmState);
#endif

	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_SET_ANTENNAS](pMsg);
}

void hdkUserDemandEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_USER_DEMAND. current state: %d", hdkSmStates.hdkMainSmState);
#endif

	hdkStateMachineFunc[hdkSmStates.hdkMainSmState][HDK_EVENT_USER_DEMAND](pMsg);
}

/**********************    Event Handlers - Set Channel SM    *****************************/
void setChannelSetFrequencyEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_SET_FREQUENCY. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_SET_FREQUENCY](pMsg);
}

void setChannelFrequencySetEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_FREQUENCY_SET. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_FREQUENCY_SET](pMsg);
}

void setChannelCalResultsLoadedEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_CAL_RESULTS_LOADED. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_CAL_RESULTS_LOADED](pMsg);
}

void setChannelOfflineCalDoneEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_OFFLINE_CAL_DONE. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_OFFLINE_CAL_DONE](pMsg);
}

void setChannelCalResultsStoredEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_CAL_RESULTS_STORED. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_CAL_RESULTS_STORED](pMsg);
}

void setChannelChannelNotificationDoneEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE](pMsg);
}

void setChannelRemoveLastVapEventHandler(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Set Channel event: SET_CHANNEL_EVENT_REMOVE_LAST_VAP. current state: %d", hdkSmStates.setChannelSmState);
#endif

	setChannelStateMachineFunc[hdkSmStates.setChannelSmState][SET_CHANNEL_EVENT_REMOVE_LAST_VAP](pMsg);
}

/**********************    Event Handlers - HDK processes SM    *****************************/

void hdkProcessScheduleProcessReqEventHandler(K_MSG *psMsg, HdkProcess_e processId)
{
#ifdef HDK_LOGS	
	ILOG0_DD("HDK Process event: HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ. current state: %d proc: %d", hdkSmStates.hdkProcessParams.state, processId);
#endif


	hdkProcessesStateMachineFunc[hdkSmStates.hdkProcessParams.state][HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ](psMsg, processId);
}

void hdkProcessProcessScheduledEventHandler(K_MSG *psMsg, HdkProcess_e processId)
{
#ifdef HDK_LOGS	
	ILOG0_DD("HDK Process event: HDK_PROCESS_EVENT_PROCESS_SCHEDULED. current state: %d proc: %d", hdkSmStates.hdkProcessParams.state, processId);
#endif

	hdkProcessesStateMachineFunc[hdkSmStates.hdkProcessParams.state][HDK_PROCESS_EVENT_PROCESS_SCHEDULED](psMsg, processId);
}

void hdkProcessProcessFinishedEventHandler(K_MSG *psMsg, HdkProcess_e processId)
{
#ifdef HDK_LOGS	
	ILOG0_DD("HDK Process event: HDK_PROCESS_EVENT_PROCESS_FINISHED. current state: %d proc: %d", hdkSmStates.hdkProcessParams.state, processId);
#endif

	hdkProcessesStateMachineFunc[hdkSmStates.hdkProcessParams.state][HDK_PROCESS_EVENT_PROCESS_FINISHED](psMsg, processId);
}

void hdkProcessExecutionCompletedEventHandler(K_MSG *psMsg, HdkProcess_e processId)
{
#ifdef HDK_LOGS	
	ILOG0_DD("HDK Process event: HDK_PROCESS_EVENT_EXECUTION_COMPLETED. current state: %d proc: %d", hdkSmStates.hdkProcessParams.state, processId);
#endif

	hdkProcessesStateMachineFunc[hdkSmStates.hdkProcessParams.state][HDK_PROCESS_EVENT_EXECUTION_COMPLETED](psMsg, processId);
}

/**********************    State Handlers - HDK Main SM    *****************************/
void hdkInitDoneStateHandler(K_MSG* pMsg)
{
	/* Switch HDK Main state */
	UNUSED_PARAM(pMsg);	
	setHdkMainSmState(HDK_STATE_INIT);
}

STATIC void hdkAddFirstVapBandConfigStateHandler(K_MSG* pMsg)
{
	UMI_ADD_VAP* addVapStructurePtr;
	uint8 txAntMask = Hdk_GetTxAntMask();
	uint8 rxAntMask = Hdk_GetRxAntMask();
	uint8 numOfAnts = Utils_GetNumAntsFromMask(txAntMask);

	HdkCdbManagerAddVapSmMsg_t* pAddVapSmMsgExtract;
	pAddVapSmMsgExtract = (HdkCdbManagerAddVapSmMsg_t*)pK_MSG_DATA(pMsg);
	addVapStructurePtr = (UMI_ADD_VAP*)pK_MSG_DATA(pAddVapSmMsgExtract->pAddRemoveVapMsg);


		if(addVapStructurePtr->operationMode == OPERATION_MODE_DUT)
		{
			PhyDrv_SetVhtNonAggregate(1);
			erpRunStateMachine(ERP_EVENT_DISABLE, pMsg);	
		}


	HDK_SetAntennasReq((AntennaBitmaps_e)txAntMask, (AntennaBitmaps_e)rxAntMask, numOfAnts, RADIO_ON_INIT);

	/*Change band main sm state*/
	sendBandStateChangedIndToHdkCdbMan(HDK_STATE_READY, pAddVapSmMsgExtract->pAddRemoveVapMsg, HDK_ADD_VAP);

}

void hdkRemoveLastVapStateHandler(K_MSG* pMsg)
{
	HdkCdbManagerAddVapSmMsg_t* pAddVapSmMsgExtract;
	pAddVapSmMsgExtract = (HdkCdbManagerAddVapSmMsg_t*)pK_MSG_DATA(pMsg);

	if (hdkSmStates.hdkMainSmState != HDK_STATE_DISABLED)
	{
		/* notify dutycycle*/
	//	HDK_DCRemoveLastVap(pMsg);
		
		/* Disable Radio */
		HDK_SetAntennasReq(ANTENNA_BITMAP_NONE, ANTENNA_BITMAP_NONE, 0, RADIO_OFF);

		PhyDrv_DisableBB();
#if !defined(ENET_INC_ARCH_WAVE600B) && defined(ENET_INC_ARCH_WAVE600)
		PhyDrv_ReleaseSWreset();
		PhyDrv_EnableRx();
#endif
	}	
	
#ifdef HDK_LOGS	
	ILOG0_D("HDK event: HDK_EVENT_REMOVE_LAST_VAP. current state: %d", hdkSmStates.hdkMainSmState);
#endif
	
	/*Disable online calibration*/
	ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE);
	/*Run State machine*/

	erpRunStateMachine(ERP_EVENT_REMOVE_VAP, pMsg);

	/* Switch HDK Main state */
	sendBandStateChangedIndToHdkCdbMan(HDK_STATE_INIT, pAddVapSmMsgExtract->pAddRemoveVapMsg, HDK_REMOVE_VAP);
}

void hdkEnableDisableRfStateHandler(K_MSG* pMsg)
{
	/* Send schedule process request event to HDK Processes state machine */
	hdkProcessScheduleProcessReqEventHandler(pMsg, HDK_PROCESS_RADIO_ON_OFF);

}

void hdkCalibrateStateHandler(K_MSG* pMsg)
{
	/* Send schedule process request event to HDK Processes state machine */
	hdkProcessScheduleProcessReqEventHandler(pMsg, HDK_PROCESS_CALIBRATE);
}

void hdkOnlineTimerExpiredStateHandler(K_MSG* pMsg)
{
	/* Send schedule process request event to HDK Processes state machine */
	hdkProcessScheduleProcessReqEventHandler(pMsg, HDK_PROCESS_ONLINE_CAL);
}

void hdkSetAntennasStateHandler(K_MSG* pMsg)
{
	/* Set antennas */
	hdk_CocSetAntennasReq(pMsg);
}

void hdkUserDemandStateHandler(K_MSG* pMsg)
{
	/* Send schedule process request event to HDK Processes state machine */
	hdkProcessScheduleProcessReqEventHandler(pMsg, HDK_PROCESS_USER_DEMAND);
}

void hdkIgnoreRadioEvent(K_MSG* pMsg)
{
	/* Send confirmation to driver  */
	OSAL_SEND_MESSAGE(UMI_MC_MAN_ENABLE_RADIO_CFM, TASK_UM_IF_TASK, pMsg, VAP_ID_DO_NOT_CARE);
}

void hdkIgnoreCocEvent(K_MSG* pMsg)
{
	cocReq_t* pCocReq = (cocReq_t*)pK_MSG_DATA(pMsg);

	// Set HDK is not ready for CoC status
	pCocReq->hdkStatus = COC_STATUS_HDK_IS_NOT_READY;
	
	// Send confirmation to CoC module
	OSAL_SEND_MESSAGE(COC_HDK_SET_ANTS_CFM, TASK_COC, pMsg, pMsg->header.vapId);	
}

void hdkInvalidEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	ASSERT(0);
}

void hdkIgnoreOnlineTimerEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	sendCdbManOnlineCalProcessFinishInd(TRUE);		
}

/**********************    State Handlers - Set Channel SM    *****************************/

void SelectBandFilterFW(K_MSG* pMsg)
{
	HdkSetChannelReqParams_t* pSetChannelReqParams = (HdkSetChannelReqParams_t*) pK_MSG_DATA(pMsg);
	uint8 low_chan_num = pSetChannelReqParams->low_chan_num;
	uint8 vapId = pMsg->header.vapId;
		
	RficDriver_SelectBandFilterB(0,FW,low_chan_num);//if tableB is empty will not do it
	if (ConfigurationManager_IsZwdfsVap(vapId))
	{
		RficDriver_SelectBandFilterZwdfs(0,FW,low_chan_num);
	}
}
#if !defined ENET_INC_ARCH_WAVE600 //we dont have clipping option in GEN6 
void hdk_clippingTrigger()
{
	uint32 freq;
	uint8 i;
	freq = RficDriver_CalcLoFrequency(HDK_getSetChannelParams());//doesnt work for WRX300
	if (clippingDB.addressAnt[0] != 0)//table is not empty
	{
		i=0;
		while (freq > clippingDB.frequency[i])
		{
			i++;
		}
		PhyCalDrv_Write_Register_Clipping(clippingDB.clipping_en[i]);
	}
}
#endif
void SelectClippingRam(K_MSG*pMsg)
{
	HdkSetChannelReqParams_t* pSetChannelReqParams = (HdkSetChannelReqParams_t*) pK_MSG_DATA(pMsg);
	uint8 chan_width = pSetChannelReqParams->chan_width;
	uint8 ant;
	uint8 antMask;
	uint8 curAntMask;
	uint32 *srcaddr;
	if (clippingDB.addressAnt[0] != 0)//table is not empty
	{	
		if (BANDWIDTH_TWENTY == chan_width)
		{
			srcaddr = &clippingDB.clipping20[0];
		}
		else if (BANDWIDTH_FOURTY == chan_width)
		{
			srcaddr = &clippingDB.clipping40[0];
		}
		else //80
		{
			srcaddr = &clippingDB.clipping80[0];
		}
		antMask = Hdk_GetRxAntMask();
		
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			curAntMask = 1 << ant;
			if ((curAntMask & antMask) != FALSE)
			{
				memcpy32((uint32*)clippingDB.addressAnt[ant],srcaddr,CLIPPING_RANGE);
			}
		}
	}

}

void hdk_handleClipping()
{
	//uint16 Rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];//133
	uint16 cols = pShramAddress[PSD_NUM_OF_COLS_INDEX];//.3
	int index;

	for (index = 0; index < CLIPPING_FREQUENCIES; index++)
	{
		if (index < CLIPPING_ANTS)
		{
			clippingDB.addressAnt[index] = pShramAddress[PSD_TABLE_START_INDEX + (cols * index)];
		}
		clippingDB.frequency[index]  = pShramAddress[PSD_TABLE_START_INDEX + (cols * index) + 1];
		clippingDB.clipping_en[index]= pShramAddress[PSD_TABLE_START_INDEX + (cols * index) + 2];
	}
	for (index = 0; index < CLIPPING_RANGE; index++)
	{
		clippingDB.clipping20[index] = pShramAddress[PSD_TABLE_START_INDEX + (cols * (CLIPPING_FREQUENCIES + index)) + 0];
		clippingDB.clipping40[index] = pShramAddress[PSD_TABLE_START_INDEX + (cols * (CLIPPING_FREQUENCIES + index)) + 1];
		clippingDB.clipping80[index] = pShramAddress[PSD_TABLE_START_INDEX + (cols * (CLIPPING_FREQUENCIES + index)) + 2];
	}
}

void hdk_handleRxIqDefault()
{
#if defined ENET_INC_ARCH_WAVE600
	int ant;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		rxIqDefaultFromPSD.rxIqDefaultCh36.w1[ant]  = pShramAddress[PSD_TABLE_START_INDEX + (MAX_NUM_OF_ANTENNAS * ant)  ];
		rxIqDefaultFromPSD.rxIqDefaultCh36.w2[ant]  = pShramAddress[PSD_TABLE_START_INDEX + (MAX_NUM_OF_ANTENNAS * ant) + 1];
		rxIqDefaultFromPSD.rxIqDefaultCh100.w1[ant] = pShramAddress[PSD_TABLE_START_INDEX + (MAX_NUM_OF_ANTENNAS * ant) + 2];
		rxIqDefaultFromPSD.rxIqDefaultCh100.w2[ant] = pShramAddress[PSD_TABLE_START_INDEX + (MAX_NUM_OF_ANTENNAS * ant) + 3];
	}
	rxIqDefaultFromPSD.threshold = pShramAddress[PSD_TABLE_START_INDEX + (MAX_NUM_OF_ANTENNAS * ant)];
	rxIqDefaultFromPSD.paramsAreInitialized = TRUE;
#endif
}

void setChannelSetFrequencyStateHandler(K_MSG* pMsg)
{
	byte localPersistant = pMsg->header.bPersistentMsg;
	HdkSetChannelReqParams_t* pSetChannelReqParams = (HdkSetChannelReqParams_t*) pK_MSG_DATA(pMsg);

	hdkUpdateantennaMaskPerChannel(pSetChannelReqParams->low_chan_num);

	SelectBandFilterFW(pMsg);
	SelectClippingRam(pMsg);
	/* Set BW and Frequency */
	setBwAndFrequency(pMsg);
		
	if (HDK_SetChannelFreeMsgNeeded()== TRUE)
	{
		/* set channel message is no longer in use for this channel calibration */			
#ifdef HDK_LOGS		
				ILOG0_V(" FREEEEEE MSG............");		
#endif		
		ASSERT(pMsg);  //Check with Yossi why it's needed
		OSAL_FREE_MESSAGE(pMsg,localPersistant);
			
	}

	/* Switch Set Channel state */
	setSetChannelSmState(SET_CHANNEL_STATE_FREQUENCY_LOCK);
	
	/* send Frequency was set event */
	setChannelFrequencySetEventHandler(NULL);
}
void setChannelFrequencySetStateHandler(K_MSG* pMsg)
{
	/* Switch Set Channel state */
	UNUSED_PARAM(pMsg);	
	setSetChannelSmState(SET_CHANNEL_STATE_LOAD_CAL);

	/* Load Calibrations */
	if (setChannelParams.calibrationBufferBaseAddress != 0)	
	{
		/* Send trigger load event to Load & Store SM */
		loadStoreTriggerLoadEventHandler();
		return;
	}
	else
	{
		/* Send Calibration Results Loaded event to Set Channel SM */
		setChannelCalResultsLoadedEventHandler(NULL);
	}
}

void setChannelCalResultsLoadedStateHandler(K_MSG* pMsg)
{
	/* Switch Set Channel state */
	UNUSED_PARAM(pMsg);	
	setSetChannelSmState(SET_CHANNEL_STATE_OFFLINE_CAL);
#ifdef ENET_INC_ARCH_WAVE600
	ILOG0_V("resetStatus");
#endif
	ClbrMngr_ResetStatus();

	/* Offline calibration */
	ClbrMngr_RunOfflineCalibration();
}

void setChannelOfflineCalDoneStateHandler(K_MSG* pMsg)
{
	/* Switch Set Channel state */
	UNUSED_PARAM(pMsg);	
	setSetChannelSmState(SET_CHANNEL_STATE_STORE_CAL);
	ClbrMngr_handleOfflineCalibDone();

}


void setChannelChannelNotificationDoneStateHandler(K_MSG* pMsg)
{
	/* Switch Set Channel state */
	UNUSED_PARAM(pMsg);	
	setSetChannelSmState(SET_CHANNEL_STATE_ACTIVE);
	
	if ((getHdkProcessId() == HDK_PROCESS_CALIBRATE) && (getHdkProcessSmState() == HDK_PROCESS_STATE_ACTIVE))
	{
		/* Calibrate process is active */
		
		ClbrMngr_CalibrateChannelDone();
	}
	else
	{
		/* Indicate HDK cdb manager on state change. upon response from HdkCdbManager change band state and send confirmation to CSM */
		sendBandStateChangedIndToHdkCdbMan(HDK_STATE_ACTIVE, NULL, HDK_CHANNEL_NOTIFICATION_DONE_SEND_CFM_TO_CSM);
	}
}

void setChannelRemoveLastVapStateHandler(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	if (hdkSmStates.setChannelSmState != SET_CHANNEL_STATE_IDLE)
	{
		/* Switch Set Channel state */
		setSetChannelSmState(SET_CHANNEL_STATE_IDLE);
	}
}
void setChannelInvalidEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	ASSERT(0);
}

/**********************    State Handlers - HDK processes SM    *****************************/

void hdkProcessScheduleProcessReqStateHandler(K_MSG *psMsg, HdkProcess_e processId)
{
	uint32 preServiceBitmap = 0;
	uint32 postServiceBitmap = 0;
	K_MSG_TYPE startMsg = HDK_CHANGE_RADIO_STATE_PROCESS_STARTED;
	K_MSG_TYPE endMsg = HDK_CHANGE_RADIO_STATE_PROCESS_ENDED;
	uint8 processManagerId = PROCESS_ID_CHANGE_RADIO_STATE;
	uint32 serviceData = 0;
	bool dualCoreProcess = FALSE;
	HdkCdbManagerOnlineCalSmMsg_t* onlineCalSmMsg = (HdkCdbManagerOnlineCalSmMsg_t*) pK_MSG_DATA(psMsg);	


	/* HDK process schedule request configuration */
	switch (processId)
	{
		case HDK_PROCESS_ONLINE_CAL:
			preServiceBitmap = 	(TRUE << SERVICE_ID_CDB_SYNC_PROCESS_SCHEDULED) | (TRUE << SERVICE_ID_PAUSE_AC_TX) | 
								(TRUE << SERVICE_ID_SEND_CTS_SELF_FRAME) | (TRUE << SERVICE_ID_PAUSE_ALL) | 
								(TRUE << SERVICE_ID_CDB_SYNC_CTS_SENT);
			serviceData = TX_PAUSE_ALL_ACS_EXCEPT_GPHP;

			serviceData |= ((onlineCalSmMsg->ctsDurMode) << CTS2SELF_DURATION_MASK_SHIFT);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_ONLINE_CALIB_PROCESS_STARTED;
			endMsg = HDK_ONLINE_CALIB_PROCESS_ENDED;
			processManagerId = PROCESS_ID_ONLINE_CALIBRATION;
			// Set online calibration bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_ONLINE_CAL);
			break;
			
		case HDK_PROCESS_CALIBRATE:
			preServiceBitmap = (TRUE << SERVICE_ID_PAUSE_ALL);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_CALIBRATE_PROCESS_STARTED;
			endMsg = HDK_CALIBRATE_PROCESS_ENDED;
			processManagerId = PROCESS_ID_CALIBRATE;

			// Set calibrate bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_CALIBRATE);
			break;

		case HDK_PROCESS_RADIO_ON_OFF:
			preServiceBitmap = (TRUE << SERVICE_ID_PAUSE_ALL);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_CHANGE_RADIO_STATE_PROCESS_STARTED;
			endMsg = HDK_CHANGE_RADIO_STATE_PROCESS_ENDED;
			processManagerId = PROCESS_ID_CHANGE_RADIO_STATE;

			if (hkdRadioOn == DISABLE_RADIO)
			{
		
				HDK_ERPRadioOnOffCommand(DISABLE_RADIO);
				/*HDK_DCRadioOnOffCommand(DISABLE_RADIO);*/
			}
			// Set radio on/off bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_RADIO_ON_OFF);
			break;
			
		case HDK_PROCESS_USER_DEMAND:
			preServiceBitmap = (TRUE << SERVICE_ID_PAUSE_ALL);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_USER_DEMAND_PROCESS_STARTED;
			endMsg = HDK_USER_DEMAND_PROCESS_ENDED;
			processManagerId = PROCESS_ID_HDK_USER_DEMAND;

			// Set user demand bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_USER_DEMAND);
			break;
			
		case HDK_PROCESS_SET_ANTENNA_CONFIGURATION:
			preServiceBitmap =	(TRUE << SERVICE_ID_SEND_CTS_SELF_FRAME) | (TRUE << SERVICE_ID_PAUSE_ALL);
			serviceData = (TX_PAUSE_ALL_ACS_EXCEPT_GPHP) | (CTS2SELF_DURATION_MSEC_NORMAL_MODE << CTS2SELF_DURATION_MASK_SHIFT);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_SET_ANT_CONFIG_PROCESS_SCHED;
			endMsg = HDK_SET_ANT_CONFIG_PROCESS_END;
			processManagerId = PROCESS_ID_HDK_SET_ANT_CONFIGURATION;
			// Set user demand bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
			break;
#if defined HDK_CDB_SUPPORT
		case HDK_PROCESS_PAUSE_BAND:
			preServiceBitmap =	(TRUE << SERVICE_ID_PAUSE_ALL);
			postServiceBitmap = (TRUE << SERVICE_ID_RESUME_ALL);
			startMsg = HDK_OTHER_CORE_CALIBRATE_PROCESS_STARTED;
			endMsg = HDK_OTHER_CORE_CALIBRATE_PROCESS_ENDED;
			processManagerId = PROCESS_ID_HDK_OTHER_CORE_CALIBRATING;
		
			// Set user demand bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap |= (TRUE << HDK_PROCESS_PAUSE_BAND);
			break;
#endif
			
		default:
			DEBUG_ASSERT(0);
	};
	
	if (hdkSmStates.hdkProcessParams.state == HDK_PROCESS_STATE_IDLE)
	{
		/* Switch HDK Process state */
		setHdkProcessSmState(HDK_PROCESS_STATE_WAIT_FOR_PROCESS_START);
	}
		
	/* Send schedule request to Process Manager */
	HDK_scheduleRequestToProcessManager(processManagerId, psMsg, startMsg, endMsg, preServiceBitmap, postServiceBitmap, serviceData,dualCoreProcess);
}

void hdkProcessProcessScheduledStateHandler(K_MSG *psMsg, HdkProcess_e processId)
{
	/* Switch HDK Process state */
	UNUSED_PARAM(psMsg);	
	setHdkProcessSmState(HDK_PROCESS_STATE_ACTIVE);

	/* Set processId as current active process */
	setHdkProcessId(processId);
}

void hdkProcessProcessFinishedStateHandler(K_MSG *psMsg, HdkProcess_e processId)
{
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;
	UNUSED_PARAM(psMsg);
	UNUSED_PARAM(processId);	
	/* Switch HDK Process state */
	setHdkProcessSmState(HDK_PROCESS_STATE_WAIT_FOR_PROCESS_END);

	/* Process has finished. Notify Process Manager */
	dummyMsg = ProcessManager_GetDummyMessage();	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, GET_DEFAULT_VAP_FOR_MY_BAND());//need to change to real vap index for dual band
}

void hdkProcessExecutionCompletedStateHandler(K_MSG *psMsg, HdkProcess_e processId)
{
	ProcessManagerReturnParams_t*	processManagerReturnParams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG*							pUmiMsg = (K_MSG*)processManagerReturnParams->requesterParams; // driver MSG was stored when process has started
	switch (processId)
	{
		case HDK_PROCESS_ONLINE_CAL:
			
			// Clear online calibration bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_ONLINE_CAL);
			ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE); //send message to HdkCdbManager to enable / disable timer
			sendCdbManOnlineCalProcessFinishInd(FALSE);		
			break;
#if defined ENET_INC_ARCH_WAVE600
		case HDK_PROCESS_PAUSE_BAND:
		{
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_PAUSE_BAND);
			sendMsgToHdkCdbOfflineCalSm(HDK_CDB_MAN_NON_CALIBRATING_BAND_RESUME_DONE);
			break;
		}
#endif			
		case HDK_PROCESS_RADIO_ON_OFF:

			// Clear radio on/off bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_RADIO_ON_OFF);
			
			if (hdkSmStates.hdkMainSmState == HDK_STATE_ACTIVE)
			{
				/* Radio off  - Indicate HDK cdb manager on band state change. upon response from HdkCdbManager change band state and send confirmation to host */
				sendBandStateChangedIndToHdkCdbMan(HDK_STATE_DISABLED, pUmiMsg,HDK_RADIO_OFF);
			}
			else
			{
				/* Radio on  - Indicate HDK cdb manager on band state change. upon response from HdkCdbManager change band state and send confirmation to host */
				sendBandStateChangedIndToHdkCdbMan(HDK_STATE_ACTIVE, pUmiMsg,HDK_RADIO_ON);
			}

			if (hkdRadioOn == ENABLE_RADIO)
			{
			
				HDK_ERPRadioOnOffCommand(ENABLE_RADIO);

				/*HDK_DCRadioOnOffCommand(ENABLE_RADIO);*/
			}
			
				
 			break;
			
		case HDK_PROCESS_USER_DEMAND:

			// Clear user demand bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_USER_DEMAND);

			/* Send confirmation to driver  */
			OSAL_SEND_MESSAGE(UMI_MC_MAN_HDK_USER_DEMAND_CFM, TASK_UM_IF_TASK, pUmiMsg, VAP_ID_DO_NOT_CARE);
			break;
		case HDK_PROCESS_CALIBRATE:
		{
			// Clear user demand bit in requested processes bitmap
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_CALIBRATE);
			ClbrMngr_CalibrateParamsInit();
			sendMsgToHdkCdbOfflineCalSm(HDK_CDB_MAN_RESUME_CALIBRATING_BAND_DONE);
			break;
		}
		
		case HDK_PROCESS_SET_ANTENNA_CONFIGURATION:
		{
			hdkSmStates.hdkProcessParams.requestedProcessesBitmap &= ~(TRUE << HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
			sendHdkCdbManConfigSmCfm();
			break;
		}	
		default:
			DEBUG_ASSERT(0);
	};
	
	/* Switch HDK Process state */
	setHdkProcessSmState(HDK_PROCESS_STATE_IDLE);
	setHdkProcessId(HDK_PROCESS_NONE);
}

void hdkProcessInvalidEvent(K_MSG *psMsg, HdkProcess_e processId)
{
	UNUSED_PARAM(psMsg);	
	UNUSED_PARAM(processId);	
	ASSERT(0);
}

/**********************    State Setters  *****************************/

void setHdkMainSmState(HdkState_e state)
{
#ifdef HDK_LOGS	
	if ((state !=HDK_STATE_IDLE) && (state != HDK_STATE_INIT))
	{
		ILOG0_D("setHdkMainSmState. state: %d", state);
	}
#endif

	hdkSmStates.hdkMainSmState = state;
}

void setSetChannelSmState(SetChannelState_e state)
{
#ifdef HDK_LOGS	
	if (state != SET_CHANNEL_STATE_IDLE)
	{
		ILOG0_D("setSetChannelSmState. state: %d", state);
	}
#endif

	hdkSmStates.setChannelSmState = state;
}



void setHdkProcessSmState(HdkProcessState_e state)
{
#ifdef HDK_LOGS
	if (state != HDK_PROCESS_STATE_IDLE)
	{
		ILOG0_D("setHdkProcessSmState. state: %d", state);
	}
#endif

	hdkSmStates.hdkProcessParams.state = state;
}

void setHdkProcessId(HdkProcess_e processId)
{
#ifdef HDK_LOGS	
	if (processId != HDK_PROCESS_NONE)
	{
		ILOG0_D("setHdkProcessId. processId: %d", processId);
	}
#endif

	hdkSmStates.hdkProcessParams.processId = processId;
}

void setFreqJumpSmState(HdkFreqJumpState_e state)
{
	
		if (state != FREQ_JUMP_STATE_DISABLED)
		{
#ifdef HDK_LOGS	
		ILOG0_D("setFreqJumpSmState. state: %d", state);
#endif
		}


	hdkSmStates.freqJumpSmState = state;
}



/**********************    State Getters  *****************************/

HdkState_e getHdkSmState(void)
{
	return hdkSmStates.hdkMainSmState;
}

SetChannelState_e getSetChannelSmState(void)
{
	return hdkSmStates.setChannelSmState;
}

HdkProcessState_e getHdkProcessSmState(void)
{
	return hdkSmStates.hdkProcessParams.state;
}

HdkProcess_e getHdkProcessId(void)
{
	return hdkSmStates.hdkProcessParams.processId;
}

HdkAntConfigState_e getHdkAntConfigSmState()
{
	return	hdkSmStates.hdkAntConfigurationState;
}

/**********************    State Handlers - Configuration SM    *****************************/
STATIC void hdkIndirectResetReq(K_MSG* pMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract;
	pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(pMsg);

#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	IndirectReset(NULL);
#endif
	/*Set MAC antenna configuration register to maximum antenna - this requireed in order to load progmodel per antenna file*/
	/*It will be changed in set antenna request according to real antenna configuration per band*/
	if (ConfigurationManager_GetMyBand() == CONFIGURATION_MANAGER_BAND_0)
	{
		hdkSetAntConfigForMyBand(ANTENNA_BITMAP_ALL_ANTENNAS_GEN5);
	}
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, pMsg, pMsg->header.vapId); 
}

STATIC void hdkResetPhyReq(K_MSG* pMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract;
	pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(pMsg);

#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	PhyDrv_ResetBB();
	PhyDrv_PowerSaveInit();
#endif
	/*Send confirmation to HdkCdbManager*/
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, pMsg, pMsg->header.vapId); 

}
STATIC void hdkResetRfReq(K_MSG* pMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract;
	pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(pMsg);

#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
#if !defined(HDK_RF_EMULATOR)
	AFE_InitFuse(0);
#endif
	RficDriver_Init();
#endif
	/*Send confirmation to HdkCdbManager*/
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, pMsg, pMsg->header.vapId); 
}

STATIC void hdkResetRfBandReq(K_MSG* pMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract;
	pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(pMsg);

#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	IndirectResetAnt();
#if !defined(HDK_RF_EMULATOR)
	AFE_InitFuseAnt();
#endif
	RficDriver_BandInit();
#endif
	/*Send confirmation to HdkCdbManager*/
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, pMsg, pMsg->header.vapId); 
}

STATIC void HDK_ConfigSmHwDependentReq(K_MSG *psMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(psMsg);
#if !defined(ENET_INC_HW_FPGA)
#if defined(ENET_INC_LMAC0)
	UmiHwDependentConfig_t* pConfigReq = (UmiHwDependentConfig_t*)pK_MSG_DATA(pConfigSmMsgExtract->requesterKmsg);
#endif

	AFE_Init(NULL, TRUE);
#if defined(ENET_INC_LMAC0)
	LmHdk_SetXtalValue(pConfigReq->xtal);
	RficDriver_XtalInitPreventAmpChange();
#endif
#endif
	p32PsdProgmodelShramAddressBand = (uint32*)pConfigSmMsgExtract->param; //Set progmodel and PSD shram address (sent to driver by host interface chi vector)
	setPsdShramAddress(p32PsdProgmodelShramAddressBand);

	/*Send confirmation to HdkCdbManager*/
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, psMsg, psMsg->header.vapId); 
}

STATIC void hdkOfflineCalSmInvalidEvent(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	ASSERT(0);
}

STATIC void setHdkOfflineCalSmState(HdkOfflineCalState_e state)
{
#ifdef HDK_LOGS
	if (state != HDK_PROCESS_STATE_IDLE)
	{
		ILOG0_D("setHdkConfigSmState,state: %d", state);
	}
#endif

	hdkSmStates.hdkOfflineCalState = state;
}

STATIC void offlineCalRunCalReqFromCdbManEventHandler(K_MSG* pMsg)
{
	hdkOfflineCalSmFunc[hdkSmStates.hdkOfflineCalState][HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER](pMsg);
}
STATIC void offlineCalFinishCalReqFromCdbManEventHandler(K_MSG* pMsg)
{
	hdkOfflineCalSmFunc[hdkSmStates.hdkOfflineCalState][HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER](pMsg);
}
void offlineCalSetEvent(HdkOfflineCalEvent_e offlineCalEvent)
{
	hdkOfflineCalSmFunc[hdkSmStates.hdkOfflineCalState][offlineCalEvent](NULL);
}
STATIC void hdkOfflineCalSmRunCalEvent(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);
	setHdkOfflineCalSmState(HDK_OFFLINE_CAL_STATE_WAIT_FOR_OFFLINE_CAL_START);
}
STATIC void hdkOfflineCalFromCalProcSmRunCalEvent(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	setHdkOfflineCalSmState(HDK_OFFLINE_CAL_STATE_WAIT_FOR_SET_MAX_ANTS);
}

STATIC void hdkOfflineCalSmRunCalReqFromCdbManEvent(K_MSG *psMsg)
{
	HdkCdbManagerOfflineCalSmMsg_t* pOfflineCalMsg;
	BandId_e band = ConfigurationManager_GetMyBand();
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(band);
#ifdef HDK_DEBUG_LOGGER
	dutDB_t * dutDb = Dut_getDB();
	ILOG0_D("hdkOfflineCalSmRunCalReqFromCdbManEvent mode:%d",dutDb->operationMode);
#endif
	pOfflineCalMsg = (HdkCdbManagerOfflineCalSmMsg_t *)pK_MSG_DATA(psMsg);
	pOfflineCalMsg->band = band;

	setHdkOfflineCalSmState(HDK_OFFLINE_CAL_STATE_CALIBRATION_RUNNING);
	ClbrHndlr_Calibrate();
	setCalibrationStatistics();
	/*Send calibration done cfm to HdkCdbMan*/
	OSAL_SEND_MESSAGE(pOfflineCalMsg->retMsg,pOfflineCalMsg->retTask,psMsg,vapId);
}



STATIC void hdkOfflineCalSmFinishCalEvent(K_MSG *psMsg)
{
	HdkCdbManagerOfflineCalSmMsg_t* pOfflineCalMsgtoBand;
	
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;

	pOfflineCalMsgtoBand = (HdkCdbManagerOfflineCalSmMsg_t *)pK_MSG_DATA(psMsg);

	setHdkOfflineCalSmState(HDK_OFFLINE_CAL_STATE_IDLE);
	
	switch (pOfflineCalMsgtoBand->requester)
	{
		case OFFLINE_CAL_SET_CHANNEL_REQUESTER:
			hdkOfflineCalFinishedSetChannelCb();
			break;
		
		case OFFLINE_CAL_COC_REQUESTER:
			hdkOfflineCalFinishedCoCCb();
			break;
			
		case OFFLINE_CAL_ON_DEMAND_REQUESTER:
			hdkOfflineCalFinishedOnDemandCb(pOfflineCalMsgtoBand->requesterKmsgPtr);
			break;
		
		case OFFLINE_CAL_RADIO_STATE_REQUESTER:
			hdkOfflineCalFinishedRadioStatedCb();
			break;
		
		case OFFLINE_CAL_CALIBRATE_REQUESTER:
			/* Send confirmation to driver  */
			OSAL_SEND_MESSAGE(UMI_MC_MAN_CALIBRATE_CFM, TASK_UM_IF_TASK, pOfflineCalMsgtoBand->requesterKmsgPtr, VAP_ID_DO_NOT_CARE);
			break;		
		case OFFLINE_CAL_ERP_ADD_STA_IN_RF_OFF_EVENT_REQUESTER:

			/*Move to Wait Process Start Abort*/
			HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
			/*Request Process Manager to end the process*/
			dummyMsg = ProcessManager_GetDummyMessage();	
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
			break;	
		case OFFLINE_CAL_ERP_RF_OFF_TIMER_EVENT_REQUESTER:
			/*Change State*/
			HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END);
			/*Start RF off timeout*/
			dummyMsg = ProcessManager_GetDummyMessage();	
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
			break;	
		case OFFLINE_CAL_ERP_BSS_TX_IN_RF_OFF_EVENT_REQUESTER:

			/*Move to Wait Process End Abort*/
			HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_ABORT);
			/*Request Process Manager to end the process*/
			dummyMsg = ProcessManager_GetDummyMessage();	
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
			
			break;	
		case OFFLINE_CAL_ERP_DISABLE_IN_RF_OFF_EVENT_REQUESTER:

			/*Wait for process end*/
			HDK_ERPChangeState(ERP_STATE_WAIT_PROCESS_END_DISABLE);
			/*Request Process Manager to end the process*/
			dummyMsg = ProcessManager_GetDummyMessage();	
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
			/*Reset RF Off timer*/
			OSAL_RESET_TIMER_EXPLICIT(HDK_ERP_TIMER_EXPIRED, TASK_HDK);
			
			break;	
			
		default:
			ASSERT(0);
	}
	
}
STATIC void hdkOfflineCalFinishedSetChannelCb(void)
{
	/* Send Offline Calibration Done event to Set Channel SM */
	setChannelOfflineCalDoneEventHandler(NULL);
}
void hdkOfflineCalFinishedCoCCb(void)
{
	K_MSG *cocCfmKmsg = OSAL_GET_MESSAGE(sizeof(cocReq_t));
	cocReq_t*	pCocReq = (cocReq_t*)pK_MSG_DATA(cocCfmKmsg);
	BandId_e band = ConfigurationManager_GetMyBand();
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(band);

	// Set OK status
	pCocReq->hdkStatus = COC_STATUS_HDK_IS_READY;
	
	// Send confirmation to CoC module
	OSAL_SEND_MESSAGE(COC_HDK_SET_ANTS_CFM, TASK_COC, cocCfmKmsg,vapId);	
}
STATIC void hdkOfflineCalFinishedOnDemandCb(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	/* Send Process Finished event to HDK Process SM */
	hdkProcessProcessFinishedEventHandler(NULL, HDK_PROCESS_USER_DEMAND);
}
STATIC void hdkOfflineCalFinishedRadioStatedCb(void)
{
	/* Send Process Finished event to HDK Process SM */
	hdkProcessProcessFinishedEventHandler(NULL, HDK_PROCESS_RADIO_ON_OFF);
}




HdkFreqJumpState_e HDK_GetFreqJumpSmState(void)
{
	return hdkSmStates.freqJumpSmState;
}

/*******************    Channel Notification handlers  *******************/

void channelNotificationLATpcData(void)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LA_SET_CHANNEL_DATA_t));
	/* use shram memory(PSD/progmodel position) for these tables, in order to reduce the message size */
	uint8* internalPowerLowerLimit = (uint8*)(au8RxCircBuf+sizeof(LM_VECTOR_BLOCK));
	uint8* internalPowerUpperLimit = (uint8*)(au8RxCircBuf+sizeof(LM_VECTOR_BLOCK)+(LA_NUM_OF_BANDWIDTH*MAX_NUM_OF_ANTENNAS)); //TBD - use MAX_NUM_OF_BW when TPC will support BW 160
	LA_SET_CHANNEL_DATA_t *params_p = (LA_SET_CHANNEL_DATA_t *)pK_MSG_DATA(kMsg_p);
	UmiOperationMode_e operationMode = Dut_getDB()->operationMode;

	uint8			ant;
	uint8			bw;
	uint8 			low_chan_num;
	uint8  			chan_width;

	
	params_p->wlanBandwidthMax = ssbParameters.hdkSSBTcrBw; //need to be changed, when set channel handling will be merged

	if(setChannelParams.setChannelReqParams.channelNotification == CHANNEL_NOTIFICATION_NORMAL)
	{
		low_chan_num = setChannelParams.setChannelReqParams.low_chan_num;
		chan_width =  setChannelParams.setChannelReqParams.chan_width;
	}
	else
	{
		chan_width = setChannelParams.setChannelReqParams.channelNotification - 1;
		if(setChannelParams.setChannelReqParams.channelNotification == CHANNEL_NOTIFICATION_TWENTY)
		{
			low_chan_num = setChannelParams.setChannelReqParams.primary_chan_idx*4+setChannelParams.setChannelReqParams.low_chan_num;
		}
		else
		{
			if(setChannelParams.setChannelReqParams.primary_chan_idx > 1)
			{
				low_chan_num = (setChannelParams.setChannelReqParams.primary_chan_idx&0x2)*4+setChannelParams.setChannelReqParams.low_chan_num;
			}
			else
			{
				low_chan_num = setChannelParams.setChannelReqParams.low_chan_num;
			}
		}
	}
	TPC_loadChannelData(low_chan_num, chan_width);
	TPC_getPowerToIndexLUT(&params_p->tpcInfo);

	// TBD . Run up to BW 80, and copy BW 80 values to BW 160, until it will be fully supported in TPC
	for (bw = 0; bw < MAX_NUM_OF_BW; bw++)
	{
		params_p->tpcInfo.regulationLimit[bw] 	= getRegulationLimitPerBw(setChannelParams.band, bw, low_chan_num);
		params_p->tpcInfo.regulationLimitMU[bw] = TPC_getRegulationLimitMU(bw) >> (GAIN_RESOLUTION - 1);
		params_p->tpcInfo.regulationLimitBF[bw] = TPC_getRegulationLimitBF(bw) >> (GAIN_RESOLUTION - 1);
		
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			internalPowerLowerLimit[ant * LA_NUM_OF_BANDWIDTH + bw] = TPC_getMinPower(ant, bw);
			internalPowerUpperLimit[ant * LA_NUM_OF_BANDWIDTH + bw] = TPC_getMaxEVMpower(ant, bw);
		}
	}
#ifdef ENET_INC_ARCH_WAVE600
	// copy from BW 80 to 160
	params_p->frequency_index = low_chan_num;
	params_p->tpcInfo.regulationLimitMU[BANDWIDTH_ONE_HUNDRED_SIXTY] = params_p->tpcInfo.regulationLimitMU[BANDWIDTH_EIGHTY];
	params_p->tpcInfo.regulationLimitBF[BANDWIDTH_ONE_HUNDRED_SIXTY] = params_p->tpcInfo.regulationLimitBF[BANDWIDTH_EIGHTY];

	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		internalPowerLowerLimit[ant * LA_NUM_OF_BANDWIDTH + BANDWIDTH_ONE_HUNDRED_SIXTY] = internalPowerLowerLimit[ant * LA_NUM_OF_BANDWIDTH + BANDWIDTH_EIGHTY];
		internalPowerUpperLimit[ant * LA_NUM_OF_BANDWIDTH + BANDWIDTH_ONE_HUNDRED_SIXTY] = internalPowerUpperLimit[ant * LA_NUM_OF_BANDWIDTH + BANDWIDTH_EIGHTY];
	}
#endif
	if ((operationMode != OPERATION_MODE_DUT) && (operationMode != OPERATION_MODE_SNIFFER))
	{
		params_p->tpcInfo.ant0PowerBoost = TPC_getMinAntBoostOverBws(ANTENNA_0);
		params_p->tpcInfo.ant1PowerBoost = TPC_getMinAntBoostOverBws(ANTENNA_1);
		params_p->tpcInfo.ant2PowerBoost = TPC_getMinAntBoostOverBws(ANTENNA_2);
		params_p->tpcInfo.ant3PowerBoost = TPC_getMinAntBoostOverBws(ANTENNA_3);
	}
	else
	{
		params_p->tpcInfo.ant0PowerBoost = 0;
		params_p->tpcInfo.ant1PowerBoost = 0;
		params_p->tpcInfo.ant2PowerBoost = 0;
		params_p->tpcInfo.ant3PowerBoost = 0;
	}

	params_p->tpcInfo.internalPowerLowerLimit = internalPowerLowerLimit;
	params_p->tpcInfo.internalPowerUpperLimit = internalPowerUpperLimit;
	params_p->tpcInfo.txPower11B = (TPC_get11bRegulationLimit() >> (GAIN_RESOLUTION - 1));

	params_p->wlanBandwidthMax = ssbParameters.hdkSSBTcrBw; //need to be changed, when set channel handling will be merged
	params_p->antennaConnectedMask = Hdk_GetTxAntSelectionMask();
	
	params_p->band = setChannelParams.band;
	params_p->frequency_index = low_chan_num;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_CHANNEL_DATA_REQ, TASK_LINK_ADAPTATION, kMsg_p, GET_DEFAULT_VAP_FOR_MY_BAND());
}

void channelNotificationTpcTimerHandler(void)
{
	if (TPC_getLoopType() == TPC_CLOSED_LOOP)
	{
		/* set TPC timer */
		TPC_setTimer();
	}
	
	/* Send confirmation */
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CHANNEL_NOTIFICATION_CFM, TASK_HDK, VAP_ID_DO_NOT_CARE);
}

void channelNotificationOnlineTimerHandler(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);
	uint8 switchType = hdkGetChannelSwitchType();
	if ((switchType != ST_CALIBRATE) && (switchType != ST_SCAN))
	{
		if ((hdkSmStates.hdkProcessParams.requestedProcessesBitmap & (1 << HDK_PROCESS_ONLINE_CAL)) == FALSE)
		{
			/* Set online calibration timer (only if online calibration process is not pending or running) */
			ClbrMngr_EnableDisableOnlineCal(ENABLED, TRUE);
		}
	}
}

void channelNotificationCoC(void)
{
	CoC_sendSmps();
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CHANNEL_NOTIFICATION_CFM, TASK_HDK, VAP_ID_DO_NOT_CARE);
}


uint8 getChannelNotification(void)
{
	return setChannelParams.setChannelReqParams.channelNotification;
}


void HDK_SetFrequencyRadioOn(void)
{
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(HdkSetChannelReqParams_t));
	HdkSetChannelReqParams_t *pSetChannelReqParams_temp = (HdkSetChannelReqParams_t *)pK_MSG_DATA(pMsg);
	byte localPersistant = pMsg->header.bPersistentMsg;
	pSetChannelReqParams_temp->low_chan_num = setChannelParams.setChannelReqParams.low_chan_num;
	pSetChannelReqParams_temp->low_chan_num2 = setChannelParams.setChannelReqParams.low_chan_num2;
	pSetChannelReqParams_temp->chan_width = setChannelParams.setChannelReqParams.chan_width;
	pSetChannelReqParams_temp->primary_chan_idx = setChannelParams.setChannelReqParams.primary_chan_idx;
	pSetChannelReqParams_temp->isRadarDetectionNeeded = setChannelParams.setChannelReqParams.isRadarDetectionNeeded;
	pSetChannelReqParams_temp->isContinuousInterfererDetectionNeeded = setChannelParams.setChannelReqParams.isContinuousInterfererDetectionNeeded;
	pSetChannelReqParams_temp->switchType = setChannelParams.setChannelReqParams.switchType;
	pSetChannelReqParams_temp->block_tx_post = setChannelParams.setChannelReqParams.block_tx_post;
	pSetChannelReqParams_temp->RegulationType = setChannelParams.setChannelReqParams.RegulationType;

	SelectBandFilterFW(pMsg);
	SelectClippingRam(pMsg);
	/* Set BW and Frequency */
	setBwAndFrequency(pMsg);
	OSAL_FREE_MESSAGE(pMsg,localPersistant);
}

PowerSaveStates_e HDK_FindPowerSaveState(bool radioOn, bool radioOff,uint8 requestedNumOfAnts, bool isCocUp, bool isErpDutyCycle)
{
	PowerSaveStates_e PowerSaveState;

	if ((TRUE == radioOff)&&(FALSE == isErpDutyCycle))
	{
		PowerSaveState=RADIO_OFF;
#ifdef HDK_LOGS	
		ILOG0_V("RADIO_OFF FindState");
#endif
	}

	else if ((TRUE == radioOff)&&(TRUE == isErpDutyCycle))
		{
			PowerSaveState=RADIO_OFF_ERP_DUTY_CYCLE;
#ifdef HDK_LOGS	
			ILOG0_V("RADIO_OFF_ERP_DUTY_CYCLE FindState");
#endif
		}

	else if ((TRUE == radioOn)&&(1 != requestedNumOfAnts))
	{
		PowerSaveState=RADIO_ON;
#ifdef HDK_LOGS	
		ILOG0_V("RADIO_ON FindState");
#endif
	}
	else if ((TRUE == radioOn)&&(1 == requestedNumOfAnts))//radio on and 1*1 power save
	{	
		PowerSaveState=RADIO_ON_AND_1_ON_1;
#ifdef HDK_LOGS	
		ILOG0_V("RADIO_ON_AND_1_ON_1 FindState");
#endif
	}
	else if ((1 == requestedNumOfAnts) && (FALSE == isCocUp))//1*1 power save  &&(FALSE == radioOn)
	{	
		PowerSaveState=_1_ON_1;
#ifdef HDK_LOGS	
		ILOG0_V("1_ON_1 FindState");
#endif
	}
	else if (1 == CoC_getNumActiveTxAnts())//out of Coc  exist:(FALSE == radioOn)&&(FALSE == radioOff)
	{	
		PowerSaveState=OUT_OF_1_ON_1;
#ifdef HDK_LOGS	
		ILOG0_V("OUT_OF_1_ON_1 FindState");
#endif
	}
	else if (TRUE == isCocUp)
	{
		PowerSaveState = INCREASE_NUM_OF_ANTS;
#ifdef HDK_LOGS	
		ILOG0_V("INCREASE_NUM_OF_ANTS FindState");
#endif
	}
	else
	{
		PowerSaveState = DECREASE_NUM_OF_ANTS;
#ifdef HDK_LOGS	
		ILOG0_V("DECREASE_NUM_OF_ANTS FindState");
#endif
	}
	return PowerSaveState;
}

#if !defined(ENET_INC_HW_FPGA)
void HDK_PowerSave_RadioOnInit(void)
{
#ifndef ENET_INC_ARCH_WAVE600
	/* Initialize PHY, AFE & RF */
	AFE_Init(NULL,FALSE);
	AFE_InitFuse(0);
	RficDriver_Init();
#endif
}
void HDK_PowerSave_RadioOn(void)
{
#ifndef ENET_INC_ARCH_WAVE600
	AFE_Init(NULL,FALSE);//false:no central  //to send only antenna mask//to ask amitai//but waht to do when chnage num of antennas??? should init again
	AFE_InitFuse(0);//to send in a new argument only antenna mask then maybe shoud update every 1_ON_1
	RficDriver_Init();
	HDK_SetFrequencyRadioOn();
#endif
}
void HDK_PowerSave_RadioOff(void)
{
	PhyDrv_PowerSave_RadioOff();
}
void HDK_PowerSave_RadioOnAndCoc(AntennaBitmaps_e requestedTxAntsMask)
{
	HDK_PowerSave_RadioOn();
	HDK_PowerSave_Coc(requestedTxAntsMask);
}
void HDK_PowerSave_Coc(AntennaBitmaps_e requestedTxAntsMask)
{
	UNUSED_PARAM(requestedTxAntsMask);	
	//powerMode = rfic_get_mode_lp(requestedTxAntsMask);
	//RficDriver_set_rfbandwidthAndMode(requestedTxAntsMask,HDK_RF_ANTENNA0_FCSI_SR0_MODE_2__VAL, TRUE);//RF_ANTENNA0_FCSI_SR0_MODE_2__VAL (lp)
	//RficDriver_UpdateShort0ShadowRegister(requestedTxAntsMask);
	RficDriver_enable_pll_lowpower();//works good
	//PhyDrv_UpdatePrimaryChannel(setChannelParams.band, BANDWIDTH_TWENTY, PRIMARY_CH_IDX_0);
}
void HDK_PowerSave_OutOfCoc(AntennaBitmaps_e requestedTxAntsMask)
{
	UNUSED_PARAM(requestedTxAntsMask);
	RficDriver_disable_pll_lowpower();
	//RficDriver_set_rfbandwidthAndMode(CoC_getMaskActiveTxAnts(),powerMode,FALSE);//to take the mdoe from setchannel
	//RficDriver_UpdateShort0ShadowRegister(requestedTxAntsMask);
	//PhyDrv_UpdatePrimaryChannel(setChannelParams.band, setChannelParams.setChannelReqParams.chan_width, setChannelParams.setChannelReqParams.primary_chan_idx);
}
#endif

void HDK_PowerSave(PowerSaveStates_e powerSaveState, uint8 requestedNumOfAnts, AntennaBitmaps_e requestedTxAntsMask)
{
	UNUSED_PARAM(requestedNumOfAnts);
#if !defined(ENET_INC_HW_FPGA)

	switch (powerSaveState)
	{
		case RADIO_ON_INIT:
#ifdef HDK_LOGS	
			ILOG0_V("RADIO_ON_INIT");
#endif
			HDK_PowerSave_RadioOnInit();
			break;
		case RADIO_ON:
#ifdef HDK_LOGS	
			ILOG0_V("RADIO_ON");
#endif
			HDK_PowerSave_RadioOn();
			break;
		case RADIO_OFF:
#ifdef HDK_LOGS	
			ILOG0_V("RADIO_OFF");
#endif
			HDK_PowerSave_RadioOff();
			break;
		case RADIO_ON_AND_1_ON_1:
#ifdef HDK_LOGS	
			ILOG0_V("RADIO_ON_AND_1_ON_1");
#endif
			HDK_PowerSave_RadioOnAndCoc(requestedTxAntsMask);
			break;
		case _1_ON_1:
#ifdef HDK_LOGS	
			ILOG0_V("1_ON_1");
#endif
			HDK_PowerSave_Coc(requestedTxAntsMask);
			break;
		case OUT_OF_1_ON_1:
#ifdef HDK_LOGS	
			ILOG0_V("OUT_OF_1_ON_1");
#endif
			HDK_PowerSave_OutOfCoc(requestedTxAntsMask);
			break;
			
		case RADIO_OFF_ERP_DUTY_CYCLE:
#ifdef HDK_LOGS	
					ILOG0_V("RADIO_OFF_ERP_DUTY_CYCLE");
#endif
			break;
	
		default:
			break;
	}
#else	
	UNUSED_PARAM(powerSaveState);
	UNUSED_PARAM(requestedTxAntsMask);
#endif
}

void HDK_notify_interferer(PowerSaveStates_e powerSaveState)
{
	K_MSG *psMsg;
	InterfererDetectionSetRadioState_t *setRadioState;

	switch (powerSaveState)
	{
		case RADIO_OFF:
		case RADIO_OFF_ERP_DUTY_CYCLE:
		{
			psMsg = OSAL_GET_MESSAGE(sizeof(InterfererDetectionSetRadioState_t));
			setRadioState = (InterfererDetectionSetRadioState_t *)pK_MSG_DATA(psMsg);
			setRadioState->radioState = DISABLE_RADIO;
			OSAL_SEND_MESSAGE(INTERFERER_DETECTION_SET_RADIO_STATE, TASK_INTERFERER_DETECTION, psMsg, GET_DEFAULT_VAP_FOR_MY_BAND());
			break;
		}

		case RADIO_ON:
		case RADIO_ON_INIT:	
		case RADIO_ON_AND_1_ON_1:
		case _1_ON_1:
		case OUT_OF_1_ON_1:
		case INCREASE_NUM_OF_ANTS:
		case DECREASE_NUM_OF_ANTS:
	
		{
			psMsg = OSAL_GET_MESSAGE(sizeof(InterfererDetectionSetRadioState_t));
			setRadioState = (InterfererDetectionSetRadioState_t *)pK_MSG_DATA(psMsg);
			setRadioState->radioState = ENABLE_RADIO;
			OSAL_SEND_MESSAGE(INTERFERER_DETECTION_SET_RADIO_STATE, TASK_INTERFERER_DETECTION, psMsg, GET_DEFAULT_VAP_FOR_MY_BAND());
			break;
		}

	}	
}



void HDK_SetAntennasReq(AntennaBitmaps_e requestedTxAntsMask, AntennaBitmaps_e requestedRxAntsMask, uint8 requestedNumOfAnts, PowerSaveStates_e powerSaveState)
{
	uint8 digitalAfeTxAntMask = requestedTxAntsMask;
	uint8 digitalAfeRxAntMask = requestedRxAntsMask;
#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	uint8 PgcFiltLUT_local[5][11] = {{0},{0}};
	AntennaBitmaps_e rfTxAntMask = requestedTxAntsMask;
#endif
	uint32 firstAnt;

	if (Hdk_GetTxAntMask()!=0)
	{

		// Stop PHY Genrisc
		PhyDrv_ResetBB();

		HDK_PowerSave(powerSaveState, requestedNumOfAnts, requestedTxAntsMask); 

		HDK_notify_interferer(powerSaveState);

#if !defined(ENET_INC_HW_FPGA)|| defined(HDK_RF_EMULATOR)
		if (RADIO_ON_INIT == powerSaveState)//radio on init time, happend once
		{
			//cpoy rf rx filter to phy
			RficDriver_createPgcfiltLut(0, 0);//create internal PGC Filter Tuning LUT from eFuse
			RficDriver_getPgcFiltLut(PgcFiltLUT_local);
			PhyDrv_setPgcFiltLut(requestedTxAntsMask ,PgcFiltLUT_local);
		}
#endif
		if ((RADIO_OFF == powerSaveState)||(RADIO_OFF_ERP_DUTY_CYCLE== powerSaveState))  //radioOff
		{
			/* PSD_findFirstAntInMask func. should not called with antmask == 0, 
				In gen5 and gen6 there is no option to set up system with antenna mask == 0*/
			digitalAfeTxAntMask = 1 << (PSD_findFirstAntInMask(Hdk_GetTxAntMask()));
			digitalAfeRxAntMask = 1 << (PSD_findFirstAntInMask(Hdk_GetRxAntMask()));
		}

		// Set digital antennas masks (phy)
		PhyDrv_SetTxAntOperationSet(digitalAfeTxAntMask);
		PhyDrv_SetRxAntOperationSet(digitalAfeRxAntMask);
		/*Compressed fourier phases*/
		PhyDrv_SetCompressedFourierPhases(requestedNumOfAnts);
		PhyDrv_SetCompressedFourierPhases(requestedNumOfAnts);
#if !defined(ENET_INC_HW_FPGA)|| defined(HDK_RF_EMULATOR)
		// Set Tx and RX antenna in the RFIC and AFE
		RficDriver_SetAntennas(rfTxAntMask, digitalAfeTxAntMask, requestedNumOfAnts, powerSaveState);
#endif //!defined(ENET_INC_HW_FPGA)
		// Restart Genrisc	
		PhyDrv_ReActivateBB();
	
		// Store the number of active antennas in HDK DB 
		HDK_SetMaxAnts(requestedNumOfAnts, requestedTxAntsMask);

		if (requestedTxAntsMask != 0)
		{
			firstAnt = Utils_CountTrailingZeros(requestedTxAntsMask);
			GlobalAntSelection.txAnt = firstAnt;
			GlobalAntSelection.rxAnt = firstAnt;
		}
	}
}
void HDK_SetLaChannelDataCfm(K_MSG * psMsg)
{
	UNUSED_PARAM(psMsg);	
	hdkChannelNotificationCb(NULL);
}

/**********************************************************************************
hdk_CocSetAntennasReq 

Description:
------------
	Handle a request from CoC module to change configuration of antennas.
	CoC module already paused TX and RX.
Input:
-----
	cocReq_t*	pCocReq
Output:
-------

Returns:
--------
	void - 
**********************************************************************************/


void hdk_CocSetAntennasReq(K_MSG *psMsg)
{
	cocReq_t*			pCocReq 			= (cocReq_t*)pK_MSG_DATA(psMsg);
	uint8				requestedTxAntsMask = pCocReq->requestedTxAntsMask;
	uint8				requestedRxAntsMask = pCocReq->requestedRxAntsMask;
	uint8				requestedNumOfAnts	= pCocReq->requestedNumOfAnts;
	bool				isCocUp 			= (bool)pCocReq->upOrDown;
	PowerSaveStates_e 	PowerSaveState;
#ifdef HDK_LOGS	
	SLOG0(0, 0, cocReq_t, pCocReq);
#endif
	//if ire and req is for 4*4 to verify switch A is OK
	// Turn on/off antennas
	PowerSaveState = HDK_FindPowerSaveState(FALSE, FALSE, requestedNumOfAnts, isCocUp, FALSE);
	HDK_SetAntennasReq((AntennaBitmaps_e)requestedTxAntsMask, (AntennaBitmaps_e)requestedRxAntsMask, requestedNumOfAnts, PowerSaveState);

	// Calibrate if needed
	//RficDriver_CoCcalib((AntennaBitmaps_e)requestedTxAntsMask, requestedNumOfAnts, isCocUp);

	//trigger host
	if (TRUE == isCocUp)
	{
		pCocSaveMsgBeforeDmaTrigger = psMsg;
		if (setChannelParams.calibrationBufferBaseAddress != 0) 
		{
			/* Send trigger load event to Load & Store SM */
			loadStoreTriggerLoadEventHandler();
		}
	}
	else 
	{
		hdkOfflineCalFinishedCoCCb();
	}
}

/**********************************************************************************
HDK_SetMaxAnts 

Description:
------------
	Set max number of antennas and antennas mask
Input:
-----
	uint8 numAnts
Output:
-------

Returns:
--------
	void - 
**********************************************************************************/
void HDK_SetMaxAnts(uint8 numAnts, uint8 antMask)
{

	maxActiveAnt = numAnts;
	activeAntMask = antMask;
}

/**********************************************************************************
HDK_GetMaxActiveAntennasNumAndMask 

Description:
------------
	Get max number of antennas and antennas mask
Input:
-----
	uint8 numAnts
Output:
-------

Returns:
--------
	void - 
**********************************************************************************/
void HDK_GetMaxActiveAntennasNumAndMask(uint8 * maxAnts,uint8 * antMask)
{
	*maxAnts = maxActiveAnt;
	*antMask = activeAntMask;
}

K_MSG* HDK_GetCocSaveMsg(void)
{
	return pCocSaveMsgBeforeDmaTrigger;
}


void HDK_Task( K_MSG *psMsg )
{
	ILOG0_D("HDK_Task, msgType = %d",psMsg->header.tKMsgType);
	/* Use common task switching and Table */
	vTaskDispatcher(psMsg, afpTaskTable, TASK_HDK_START, TASK_HDK_END);
}


#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
/**********************************************************************************

HDK_Init 

Description:
------------
	Initialization Routine of HDK Task

Input:
-----
	None
		
Output:
-------
	None

Returns:
--------
	void 
	
**********************************************************************************/
void clippingInit(void)
{
	memset32(&clippingDB, 0, CONVERT_BYTES_TO_WORDS(sizeof(Clipping_t)));
}
void HDK_InitConfigParams(void)
{
	hdkConfigParams.calibrationMasks.offlineCalMask = SUPPORTED_OFFLINE_CALIBRATION_MASK;
	hdkConfigParams.calibrationMasks.onlineCalMask = SUPPORTED_ONLINE_CALIBRATION_MASK;
}

void HDK_Init(void)
{
	memset(&G_HdkFreqJumpParams,0, sizeof(HdkFreqJumpParams_t));	
	// Initialize HDK state machines
	hdkSmInit();
	
	// Init the calibration management module
	HDK_InitConfigParams();
	ClbrMngr_Init(FALSE);
	TPC_fillDefines();
	RficDriver_IREInit();
	clippingInit();
	RficDriver_resetPsdArray();
	RficDriver_resetZwdfsPsdArray();

#if ((!defined HDK_REL_2_0) && (!defined HDK_INTERMEDIATE_UNTIL_API_MERGE)) //PHYTBD: open after merge with CDB and API lignment 
	AFE_resetPsdArray();
#endif
	HDK_SetBaseHostDataAddr(0);
	setChannelParams.setChannelReqParams.chan_width = BANDWIDTH_FOURTY;
	memset(&ssbParameters, 0, sizeof(HdkSSBParameters_t));

	/* Channel Notification init */
	channelNotificationInit();
	/*Ant config notification bitmap init*/
	antConfigNotificationBitmapInit();
    /* Interferer detection configuration */
	HdkContinuousInterfererDetection_Initialize();
#if defined RADAR_DETECTION_ENABLED
	HdkRadarDetection_Initialize();
#endif
	PhyDrvInterfererDetection_Initialize();
	/* ERP init*/
	ERP_init();
	/* DutyCycle init*/
	HDK_DCinit();
	/* send Init Done event to HDK main SM */
	hdkInitDoneEventHandler(NULL);
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization_start" 
void  HDK_PostInit(void)
{
	TPC_PostInit();
}
#pragma ghs section text=default
#endif

void HDK_configure(UMI_HDK_CONFIG* params)
{
	ClbrProcType_e nextProc;

	MEMCPY(&hdkConfigParams, &params->hdkConf, sizeof(hdkConfiguration_t));
	setChannelParams.band = hdkConfigParams.band;
//	setChannelParams.mode = params->setChannelMode;
	setChannelParams.mode = OFFLINE_CAL_MODE_FULL;
	setChannelParams.calibrationBufferBaseAddress = params->calibrationBufferBaseAddress;
	//params->hdkConf.calibrationMasks.onlineCalMask = CLBR_PROC_BIT_RX_DC_OFFSET | CLBR_PROC_BIT_TX_LO_LEAKAGE;
	ClbrMngr_Reset(&params->hdkConf.calibrationMasks);
	hdkConfigParams.calibrationMasks.offlineCalMask = ClbrMngr_GetCalibProcMask(CLBR_TYPE_OFFLINE);//updated in ClbrMngr_Reset
	hdkConfigParams.calibrationMasks.onlineCalMask = params->hdkConf.calibrationMasks.onlineCalMask;//updated in ClbrMngr_Reset
	
	nextProc = (params->hdkConf.calibrationMasks.onlineCalMask == 0) ? CLBR_PROC_TYPE_INVALID : 
				GetNextProc(params->hdkConf.calibrationMasks.onlineCalMask); // 0

	/*Send msg to HdkCdbMan online cal sm for init next calibration in firsttime*/
	sendOnlineCalMsgToHdkCdbMan(HDK_CDB_MAN_BAND_EN_DIS_ONLINE_CAL_REQ, FALSE, FALSE,nextProc, DISABLED);
}

void HDK_preSetChannel(uint8 bandwidth)
{
	UNUSED_PARAM(bandwidth);	
	PhyDrv_Init();	
}

uint32 HDK_GetBaseHostDataAddrPointer(void)
{
	return (uint32)setChannelParams.calibrationBufferBaseAddress;
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void HDK_SetBaseHostDataAddr(uint32 val)
{
	setChannelParams.calibrationBufferBaseAddress = val;
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

void HDK_scheduleRequestToProcessManager(uint8 processId, K_MSG* pReqParams, K_MSG_TYPE startProcessMessage, K_MSG_TYPE endProcessMessage, uint32 preServiceBitMap, uint32 postServiceBitMap, uint32 serviceData, bool dualCoreProcess)
{
	K_MSG *processManagerMsg;
	ProcessRequestParams_t *processRequestParams;
	
	/* Schedule Process*/	
	processManagerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg);
	processRequestParams->processId 				   		= processId;
	processRequestParams->startProcessMsg			   		= startProcessMessage;
	processRequestParams->endProcessMsg 			   		= endProcessMessage;
	processRequestParams->requesterParams			   		= pReqParams; // save MSG from host here
	processRequestParams->preProcessServiceBitmap	   		= preServiceBitMap;
	processRequestParams->postProcessServiceBitmap	   		= postServiceBitMap;
	processRequestParams->returnTask				   		= TASK_HDK;
	processRequestParams->updateParamsBeforeFinalizing 		= FALSE;
	processRequestParams->serviceData 				   		= serviceData;
	processRequestParams->vapId 							= ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	processRequestParams->dualBandProcess 					= dualCoreProcess;
	processRequestParams->processMsgHandledByCdbProcessMan 	= FALSE;

	/* Send process schedule request */
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER,processManagerMsg, pReqParams->header.vapId);
}

/**
* Returns the position in cache array for a certain channel and 
* spectrum mode
*
* @return Data index according to channel and spectrum mode

2.4 GHZ 20M 			2.4 GHZ 40M 		5 GHZ   20M				5 GHZ 40M					5GHZ 80M                   			5GHZ 160M 	
Channel Index 			Channel Index		Channel	Index			Channel	Index			      Channel	                Index			Channel	              					Index
1		0				1,5		14			36		24				36,40	49					36,40,44,48	       	61			36,40,44,48,52,56,60,64	      			67			
2		1				2,6		15			40		25				44,48	50					52,56,60,64			62			100,104,108,112,116,120,124,128		68
3		2				3,7		16			44		26				52,56	51					100,104,108,112		63				
4		3				4,8		17			48		27				60,64	52					116,120,124,128		64
5		4				5,9		18			52		28				100,104	53					132,136,140,144		65
6		5				6,10		19			56		29				108,112	54					149,153,157,161		66			
7		6				7,11		20			60		30				116,120	55					
8		7				8,12		21			64		31				124,128	56									
9		8				9,13		22			100		32				132,136	57					
10		9				10,14	23			104		33				140,144	58					
11		10									108		34				149,153	59			
12		11									112		35				157,161	60					
13		12									116		36									
14		13									120		37								
											124		38								
											128 		39								
											132 		40				
											136 		41				
											140 		42				
											144		43
											149 		44								
											153 		45								
											157 		46
											161 		47
											165 		48
	
*/


	
uint8 HDK_convertChannelNumToIndex(uint8 channelNum, uint8 bandWidth, uint8 band)
{
	DEBUG_ASSERT(channelNum);

	if (band == BAND_2_4_GHZ) /* In case we are in 2.4 Ghz */ 
	{
		if (bandWidth == BANDWIDTH_TWENTY)
		{
			/*	In this case the channel is the index -1  */ 
			return( channelNum -1);
		}
		else
		{
			if (channelNum > 10)
			{
				/*	return same as 20 MHz  */ 
				return( channelNum -1);

			}
			else
			{
				/*	In this case the channel is the index  + 13  */ 
				return ( channelNum + 13);
			}
		}
	}
	else	/* In case we are in 5 Ghz */ 
	{
		if (bandWidth == BANDWIDTH_TWENTY)
		{
			if(channelNum <= 64)
			{
				return ((channelNum >> 2) + 15);  /*divide by 4 and add 15 */
			}
			else if (channelNum >= 100)
			{
				if (channelNum <= 144) 
				{
					return ((channelNum >> 2) + 7);	 /*divide by 4 and add 7 */
				}
				else if (channelNum <= 165)
				{
					return (((channelNum-1) >> 2) + 7);/*decrease 1 and divide by 4 and add 7 */
				}	
			}
		}
		else if (bandWidth == BANDWIDTH_FOURTY)	
		{
			if(channelNum <= 60)
			{
				return ((channelNum >> 3) + 45);  /*divide by 8 and add 45 */ 
			}
			else if (channelNum >= 100)
			{
				if (channelNum <= 140)
				{
					return ((channelNum >> 3) + 41);  /*divide by 8 and add 41*/
				}
				else if (channelNum <= 157)
				{
					return (((channelNum-1) >> 3) + 41);/*decrease 1 and divide by 8 and add 41*/
				} 
			}	
		}
		else if (bandWidth == BANDWIDTH_EIGHTY)	
		{										
			if(channelNum <= 52)
			{
				return ((channelNum >> 4) + 59);  /*divide by 16 and add 59 */ 
			}
			else if (channelNum >= 100)
			{
				if (channelNum <= 132)
				{
					return ((channelNum >> 4) + 57);  /*divide by 16 and add 57*/
				}
				else if (channelNum == 149)
				{
					return 66;
				} 
			}	
		}
#ifdef ENET_INC_ARCH_WAVE600
		else  //BANDWIDTH_ONE_HUNDRED_SIXTY
		{
			if (channelNum == 36)
			{
				return 67;
			}
			else if (channelNum == 100)
			{
				return 68;
			}
		}
#endif
	}
	ASSERT(0);
	return INVALID_INDEX;
}
HdkSetChannelReqParams_t* HDK_getSetChannelReqParams()
{
	return &setChannelParams.setChannelReqParams;
}

SetChannelParams_t* HDK_getSetChannelParams()
{
	return &setChannelParams;
}

uint8 HDK_getBand()
{
	return setChannelParams.band;
}
uint8 HDK_getOfflineCalMode()
{
	return setChannelParams.mode;
}

void HDK_setOfflineCalMode(uint8 mode)
{
	setChannelParams.mode = mode;
}

uint8 HDK_getChannelWidth()
{
	return setChannelParams.setChannelReqParams.chan_width;
}

uint8 HDK_IsFrequencyJumpEnabled(void)
{
	return G_HdkFreqJumpParams.fjEnabled;
}

uint8 HDK_getLowChannel()
{
	return setChannelParams.setChannelReqParams.low_chan_num;
}
void HDK_setSsbParameters(K_MSG* psMsg)
{
	UMI_SSB_Mode_t* params = (UMI_SSB_Mode_t*)pK_MSG_DATA(psMsg);

	if (params->getSetOperation == API_GET_OPERATION)
	{
		params->enableSSB = ssbParameters.ssbConfigurationValid;
		params->SSB20Mode = ssbParameters.ssb20MhzOption;
	}
	else
	{
		ssbParameters.ssbConfigurationValid = params->enableSSB;
		ssbParameters.ssb20MhzOption = (HdkSSB20MhzParameters_e)params->SSB20Mode;
	}
}
uint8 hdkGetSsbModifiedBw(uint8 bandwidth, HdkSSBParameters_t ssbParams)
{
	uint8 modifiedBw = bandwidth;
	
	if (bandwidth == BANDWIDTH_TWENTY)
	{
		switch (ssbParams.ssb20MhzOption)
		{
			case HALF_BAND_40_80_SSB_20_40:
				modifiedBw = BANDWIDTH_FOURTY;
				break;
			case SSB_20_80:
				ASSERT(setChannelParams.band == BAND_5_2_GHZ);
				modifiedBw = BANDWIDTH_EIGHTY;
				break;
			default:
				DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
				break;
		}
	}
	else if ((bandwidth == BANDWIDTH_FOURTY) && (setChannelParams.band == BAND_5_2_GHZ))
	{
		modifiedBw = BANDWIDTH_EIGHTY;
	}
		
	return modifiedBw;
}

uint8 hdkGetChannelSwitchType()
{
	return setChannelParams.setChannelReqParams.switchType;
}

void set11bAntennaSelection(K_MSG* psMsg, uint8 driverMsg)
{
	UMI_ANT_SELECTION_11B *AntSelection;

	AntSelection = (UMI_ANT_SELECTION_11B *)pK_MSG_DATA(psMsg);
	if ((driverMsg) && (AntSelection->getSetOperation == API_GET_OPERATION))
	{
		MEMCPY(AntSelection, &GlobalAntSelection, sizeof(UMI_ANT_SELECTION_11B));
	}
	else //SET
	{
		if(driverMsg)
		{
			MEMCPY(&GlobalAntSelection, AntSelection, sizeof(UMI_ANT_SELECTION_11B));
		}
		else
		{
			AntSelection = &GlobalAntSelection;
		}
		if(AntSelection->rxAnt == ROUNDROBIN && AntSelection->txAnt == ROUNDROBIN)
		{
			PhyDrv_Set_11B_roundRobinSelection(AntSelection->rate);
		}
		else
		{
			PhyDrv_Set_11B_RxAntSelection((PhyDrv_11BAntSelection_e)AntSelection->rxAnt);
			PhyDrv_Set_11B_TxAntSelection((PhyDrv_11BAntSelection_e)AntSelection->txAnt);
		}
	}
}

void HDK_Get11bAntSelParams(uint8* rxAnt, uint8* txAnt, uint8* rate)
{
	*rxAnt = GlobalAntSelection.rxAnt;
	*txAnt = GlobalAntSelection.txAnt;
	*rate =  GlobalAntSelection.rate;
}

void HDK_Set11bAntSelParams(uint8 rxAnt, uint8 txAnt, uint8 rate)
{
	GlobalAntSelection.rxAnt = rxAnt;
	GlobalAntSelection.txAnt = txAnt;
	GlobalAntSelection.rate = rate;
}

STATIC void HDK_SetCcaTh(K_MSG * psMsg)
{
	PhyDrv_SetCcaTh(psMsg);
	/*Send message to Beacon Blocking Manager*/
	OSAL_SEND_NO_DATA_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_RESTART, TASK_PAC_MANAGER, psMsg->header.vapId);
	OSAL_SEND_MESSAGE(UMI_MAN_CCA_TH_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_GetCcaTh(K_MSG * psMsg)
{
	PhyDrv_GetCcaTh(psMsg);

	OSAL_SEND_MESSAGE(UMI_MAN_GET_CCA_TH_CFM, TASK_UM_IF_TASK, psMsg, VAP_ID_DO_NOT_CARE);
}

STATIC void bandStateChangedInHdkCdbManRes (K_MSG* pmsg)
{
	HdkCdbManagerBandChangeStateMsg_t*	pBandChangeStateRes = (HdkCdbManagerBandChangeStateMsg_t*)pK_MSG_DATA(pmsg);
	K_MSG* psSetChannelCfm;
	
	/*Change band main sm state (after HdkCdbMan has changed its state)*/
	setHdkMainSmState((HdkState_e)pBandChangeStateRes->bandState);

	/*Complete requester flow*/
	switch (pBandChangeStateRes->cbTask)
	{
		case HDK_ADD_VAP:
			/*Send confirmation to HdkCdbManager*/
			OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM, TASK_HDK_CDB_MANAGER, pBandChangeStateRes->storedCbMsg->header.vapId); 
			break;
		case HDK_REMOVE_VAP:
			/*Send confirmation to HdkCdbManager*/
			OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_REMOVE_VAP_BAND_CONFIG_CFM, TASK_HDK_CDB_MANAGER, pBandChangeStateRes->storedCbMsg->header.vapId); 
			break;
		case HDK_RADIO_ON:
		case HDK_RADIO_OFF:
			/* Send confirmation to driver  */
			OSAL_SEND_MESSAGE(UMI_MC_MAN_ENABLE_RADIO_CFM, TASK_UM_IF_TASK, pBandChangeStateRes->storedCbMsg, VAP_ID_DO_NOT_CARE);
			break;
		case HDK_CHANNEL_NOTIFICATION_DONE_SEND_CFM_TO_CSM:
			/* Calibrate process is not active	- send CFM to CSM */
			psSetChannelCfm = OSAL_GET_MESSAGE(sizeof(HdkSetChannelCfmParams_t));
			((HdkSetChannelCfmParams_t*)pK_MSG_DATA(psSetChannelCfm))->antennaMask = Hdk_GetTxAntMask();
			/* Set Channel CFM to CSM */
			OSAL_SEND_MESSAGE(CHANNEL_SWITCH_MANAGER_SET_CHANNEL_CFM, TASK_CHANNEL_SWITCH_MANAGER, psSetChannelCfm, pmsg->header.vapId);
			break;
			
		default:
			ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
			break;
			
	}
	
}
STATIC void sendBandStateChangedIndToHdkCdbMan(HdkState_e state, K_MSG* storedKMsgFromRequester,HdkChangeStateCbTask_e cbTask)
{
	K_MSG *pBandChangeStateIndMsg;
	HdkCdbManagerBandChangeStateMsg_t*	pBandChangeStateIndParams;
	uint8 	vapId;

	/* Send indication to HdkCdbMan task about band change state*/	
	pBandChangeStateIndMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerBandChangeStateMsg_t));
	pBandChangeStateIndParams = (HdkCdbManagerBandChangeStateMsg_t*)pK_MSG_DATA(pBandChangeStateIndMsg);
	pBandChangeStateIndParams->band = ConfigurationManager_GetMyBand();
	pBandChangeStateIndParams->bandState = state;
	pBandChangeStateIndParams->retMsg = HDK_BAND_STATE_CHANGED_RES;
	pBandChangeStateIndParams->retTask = TASK_HDK;
	pBandChangeStateIndParams->storedCbMsg = storedKMsgFromRequester;
	pBandChangeStateIndParams->cbTask = cbTask;

	vapId = ConfigurationManager_GetFirstVapForBand(pBandChangeStateIndParams->band);
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_BAND_STATE_CHANGED_IND, TASK_HDK_CDB_MANAGER,pBandChangeStateIndMsg, vapId);

}
uint32 Hdk_GetRfChipId(void)
{
	return PSD_getDataField(PSD_FIELD_RF_CHIP_ID);
}
uint32 Hdk_GetBbChipId(void)
{
	return PSD_getDataField(PSD_FIELD_CHIP_ID);
}

uint32 Hdk_GetSupportedBand(void)
{
	uint32 support_2_4 = PSD_getDataField(PSD_FIELD_BAND_SUPPORT_2_4G);
	uint32 support_5 = PSD_getDataField(PSD_FIELD_BAND_SUPPORT_5G);
	uint32 rfband ;
	if (support_2_4 && support_5)
	{
		rfband = DUT_BAND_BOTH;
	}
	else if (support_2_4)
	{
		rfband = DUT_BAND_2400MHZ;
	}
	else
	{
		rfband = DUT_BAND_5000MHZ;
	}
	return rfband;
}

uint32 Hdk_GetTxAntMask(void)
{
#if defined (HDK_CDB_SUPPORT_BY_DRIVER)
	return setChannelParams.txAntMask;
#elif(defined ENET_INC_ARCH_WAVE600) && (defined LOWER_MAC_CPU)
	return ANTENNA_BITMAP_ANTENNA_0_AND_1
#elif (defined ENET_INC_ARCH_WAVE600) && (defined LOWER1_MAC_CPU)
	return ANTENNA_BITMAP_ANTENNA_2_AND_3;
#else
	return PSD_getDataField(PSD_FIELD_TX_ANTS_MASK);
#endif
}
uint32 Hdk_GetRxAntMask(void)
{
	return setChannelParams.rxAntMask;
}

uint32 Hdk_GetZwdfsAntMask(void)
{
	return setChannelParams.ZwdfsAntMask;
}

uint32 Hdk_GetRxAntSelectionMask(void)
{
#if defined (HDK_CDB_SUPPORT_BY_DRIVER)
	return setChannelParams.rxAntSelectionMask;
#elif(defined ENET_INC_ARCH_WAVE600) && (defined LOWER_MAC_CPU)
	return ANTENNA_SELECTION_BITMAP_ANTENNA_0_AND_1
#elif (defined ENET_INC_ARCH_WAVE600) && (defined LOWER1_MAC_CPU)
	return ANTENNA_SELECTION_BITMAP_ANTENNA_2_AND_3;
#else
	return PSD_getDataField(PSD_FIELD_RX_ANT_SELECTION_MASK);

#endif
}
uint32 Hdk_GetTxAntSelectionMask(void)
{
#if defined (HDK_CDB_SUPPORT_BY_DRIVER)
	return setChannelParams.txAntSelectionMask;
#elif(defined ENET_INC_ARCH_WAVE600) && (defined LOWER_MAC_CPU)
	return ANTENNA_SELECTION_BITMAP_ANTENNA_0_AND_1
#elif (defined ENET_INC_ARCH_WAVE600) && (defined LOWER1_MAC_CPU)
	return ANTENNA_SELECTION_BITMAP_ANTENNA_2_AND_3;
#else
	return PSD_getDataField(PSD_FIELD_TX_ANT_SELECTION_MASK);
#endif
}
uint32 Hdk_GetMaxTxAntMask(void)
{
	return PSD_getDataField(PSD_FIELD_TX_ANTS_MASK);
}
uint32 Hdk_GetMaxRxAntMask(void)
{
	return PSD_getDataField(PSD_FIELD_RX_ANTS_MASK);
}
uint32 Hdk_GetMaxRxAntSelectionMask(void)
{
	return PSD_getDataField(PSD_FIELD_RX_ANT_SELECTION_MASK);

}
uint32 Hdk_GetMaxTxAntSelectionMask(void)
{
	return PSD_getDataField(PSD_FIELD_TX_ANT_SELECTION_MASK);
}

void sendOnlineCalMsgToHdkCdbMan(K_MSG_TYPE msgType, bool moreFrags, bool wasCalibrated, ClbrProcType_e nextCalibration, bool enDisCal)
{
	K_MSG *pOnlineCalMsg;
	HdkCdbManagerOnlineCalSmMsg_t*	pOnlineCalMsgParams;
	uint8 	vapId;

	/* Send indication to HdkCdbMan task about band change state*/	
	pOnlineCalMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerOnlineCalSmMsg_t));
	pOnlineCalMsgParams = (HdkCdbManagerOnlineCalSmMsg_t*)pK_MSG_DATA(pOnlineCalMsg);
	pOnlineCalMsgParams->band = ConfigurationManager_GetMyBand();
	pOnlineCalMsgParams->moreFrags =  moreFrags;
	pOnlineCalMsgParams->wasCalibrated =  wasCalibrated;
	pOnlineCalMsgParams->nextCalibration = nextCalibration;
	pOnlineCalMsgParams->enableDisableCal = enDisCal;
	pOnlineCalMsgParams->retMsg = HDK_CDB_MAN_INVALID_MSG;
	pOnlineCalMsgParams->retTask = HDK_CDB_MAN_INVALID_TASK;
	vapId = ConfigurationManager_GetFirstVapForBand(pOnlineCalMsgParams->band);

	OSAL_SEND_MESSAGE(msgType, TASK_HDK_CDB_MANAGER,pOnlineCalMsg, vapId);
}

void HDK_SetSsbModeReq(K_MSG* pMsg)
{
	HDK_setSsbParameters(pMsg);

	OSAL_SEND_MESSAGE(UMI_MC_MAN_SSB_MODE_CFM, TASK_UM_IF_TASK, pMsg, pMsg->header.vapId);
}

void HDK_RadarDetectionRssiThConfigReq(K_MSG* psMsg)
{
	UMI_RADAR_DETECTION_RSSI_TH_CONFIG* pRadarDetectionRssiTh = (UMI_RADAR_DETECTION_RSSI_TH_CONFIG*)psMsg->abData;

	if (pRadarDetectionRssiTh->getSetOperation == API_GET_OPERATION)
	{
		pRadarDetectionRssiTh->radarDetectionRssiTh = PhyDrvRadarDetection_GetRssiTh();
	}
	else
	{
		PhyDrvRadarDetection_SetRssiTh(pRadarDetectionRssiTh->radarDetectionRssiTh);
	}
	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void HDK_AntConfigSetProcess(K_MSG* psMsg)
{
	hdkProcessScheduleProcessReqEventHandler(psMsg, HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
	setHdkAntConfigSmState(ANT_CONFIG_WAIT_FOR_PROCESS_SCHED);
} 
STATIC void HDK_SetAntConfig(K_MSG* psMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(psMsg);
	UMI_HDK_SET_ANTENNA_REQ* pSetAntMsg = (UMI_HDK_SET_ANTENNA_REQ*) pK_MSG_DATA(pConfigSmMsgExtract->requesterKmsg);
	uint8 myBand = ConfigurationManager_GetMyBand();
	antennaParameters_t* antParams = &pSetAntMsg->antParams[myBand];	

	uint8 requestedAntNum = Utils_GetNumAntsFromMask(antParams->txAntMask);
	uint8 currentAntNum = Utils_GetNumAntsFromMask(setChannelParams.txAntMask);
	uint8 isUp = (requestedAntNum > currentAntNum) ? TRUE : FALSE;
	PowerSaveStates_e PowerSaveState = HDK_FindPowerSaveState(FALSE, FALSE, requestedAntNum, isUp, FALSE);

#if defined (WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) && defined (ENET_INC_LMAC1)
	uint8 numOfAntennas;	
	TxSender_ScratchPadApiParams_t *pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B1_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
#endif //(WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) &&  (ENET_INC_LMAC1)

	setChannelParams.txAntMask = antParams->txAntMask;
	setChannelParams.txAntSelectionMask = antParams->txAntSelectionMask;
	setChannelParams.rxAntSelectionMask = antParams->rxAntSelectionMask;
	setChannelParams.rxAntMask = antParams->rxAntMask;
	
	setChannelParams.txAntMaskOrig = setChannelParams.txAntMask;
	setChannelParams.txAntSelectionMaskOrig = setChannelParams.txAntSelectionMask;
	setChannelParams.rxAntMaskOrig = setChannelParams.rxAntMask;
	setChannelParams.rxAntSelectionMaskOrig = setChannelParams.rxAntSelectionMask;
	
#if defined (WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) && defined (ENET_INC_LMAC1)
	numOfAntennas = ((setChannelParams.txAntMask&1)>>0) + \
					((setChannelParams.txAntMask&2)>>1) + \
					((setChannelParams.txAntMask&4)>>2) + \
					((setChannelParams.txAntMask&8)>>3);

	pScratchPadApiParams->numOfAllocatedAntennas = numOfAntennas;

#endif //(WORKAROUND_FOR_HW_BUG_IN_DMA_WRAPPER_BAND1) &&  (ENET_INC_LMAC1)
	
	
	if (myBand== CONFIGURATION_MANAGER_BAND_0)
	{
		
		hdkSetAntConfigForMyBand(setChannelParams.txAntMask);
		HDK_override11bAntSel(setChannelParams.txAntMask);
		
	}


	if (hdkSmStates.hdkMainSmState == HDK_STATE_INIT)
	{
		if (setChannelParams.txAntMask == 0)
		{
			PhyDrv_DisablePhy();
			PhyDrv_LockReActivateBB(TRUE);
		}
			setHdkAntConfigSmState(ANT_CONFIG_IDLE);
			sendHdkCdbManConfigSmCfm(); 
	}
	else
	{
			
			/*Antenna's are needed in disabled inorder to reassociate on the fly*/
			ASSERT(getHdkAntConfigSmState() == ANT_CONFIG_DISABLE_ANT);
			/*Valid entry for Zwdfs init.*/
			ASSERT(ConfigurationManager_GetIsDualBandZWDFS());
			handleModifyAntMaskOtf(PowerSaveState);
	}
}

STATIC void handleModifyAntMaskOtf(PowerSaveStates_e PowerSaveState)
{
	uint8 RequestedTxAntsMask = Hdk_GetTxAntMask();
	uint8 RequestedRxAntsMask = Hdk_GetRxAntMask();
	uint8 antNum = Utils_GetNumAntsFromMask(RequestedTxAntsMask);
	  
	
	if	(antNum == 0) 
	{
		
		ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE);
		/*Release phy and lock from reactivating*/
		PhyDrv_DisablePhy();
		PhyDrv_LockReActivateBB(TRUE);
		/*Process manager is occupied - close proecess*/
		setHdkAntConfigSmState(ANT_CONFIG_SET_ANTENNA_WAIT_FOR_NOTIFICATION_CFM);
		setAntennaConfigurationEvent(ANT_CONFIG_EVENT_NOTIFICATION_DONE, NULL);
	}
								
	else 
	{
		/*update RFregs with PSDB*/
		RficDriver_writePsdTableFromDB();
		/*Enable online calibration*/
		ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);
		/*HDK_SetAntennasReq should be called just after add vap - in init state it should not be called*/
		HDK_SetAntennasReq((AntennaBitmaps_e)RequestedTxAntsMask, (AntennaBitmaps_e)RequestedRxAntsMask, antNum, PowerSaveState);
		
		
		if ((PowerSaveState == INCREASE_NUM_OF_ANTS) && (hdkSmStates.setChannelSmState == SET_CHANNEL_STATE_ACTIVE))
		{

		/*Overwrite RSSI calibration DATA*/
		//RssiPath_extractValuesFromCalBin();

		/*Load Calibrations from host incase antenna increase*/

		//	if (HDK_GetBaseHostDataAddrPointer() != 0) 
		//	{
			
				//Send trigger load event to Load & Store SM 
		//		loadStoreTriggerLoadEventHandler();
		//	}
		}
		
		/*unlock and enable Phy*/
		PhyDrv_LockReActivateBB(FALSE);
		PhyDrv_ReActivateBB();

		/*Notify modules [Coc,LA,SmpS,GroupManager] on antenna mask change*/
		antConfigSendParams();
		setHdkAntConfigSmState(ANT_CONFIG_SET_ANTENNA_WAIT_FOR_NOTIFICATION_CFM);
	}
}
STATIC void hdkAntConfigSmDisableAllAntsEvent(K_MSG* psMsg)
{
	HDK_DisableAllAnts(psMsg);
	setHdkAntConfigSmState(ANT_CONFIG_DISABLE_ANT);
}

STATIC void HDK_DisableAllAnts(K_MSG* psMsg)
{
	UNUSED_PARAM(psMsg);	
	HDK_SetAntennasReq((AntennaBitmaps_e)0,(AntennaBitmaps_e)0, 0, RADIO_OFF);
	ILOG0_V("HDK_DisableAllAnts");
	sendHdkCdbManConfigSmCfm();
}

STATIC void hdkAntConfigSmInvalidEvent(K_MSG* psMsg)
{
	UNUSED_PARAM(psMsg);	
	ASSERT(0);
}
STATIC void hdkAntConfigSmNotificationDoneEvent(K_MSG* psMsg)
{
	/*Finish process*/
	UNUSED_PARAM(psMsg);	
	hdkProcessProcessFinishedEventHandler(NULL, HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
	setHdkAntConfigSmState(ANT_CONFIG_WAIT_FOR_PROCESS_END);
}
STATIC void hdkAntConfigProcessEndEventHandler(K_MSG* psMsg)
{
	setAntennaConfigurationEvent(ANT_CONFIG_EVENT_PROCESS_END,psMsg);
}
STATIC void hdkSetOperationalAntConfigReq(K_MSG* psMsg)
{
	uint8 cocRequestedTxAntsMask = CoC_getMaskActiveTxAnts();
	uint8 cocRequestedRxAntsMask = CoC_getMaskActiveRxAnts();
	uint8 antNum = Utils_GetNumAntsFromMask(cocRequestedTxAntsMask);
	UNUSED_PARAM(psMsg);
	
	/*Reconstruct set shannel ants masks*/
	setChannelParams.txAntMask = setChannelParams.txAntMaskOrig;
	setChannelParams.txAntSelectionMask = setChannelParams.txAntSelectionMaskOrig;
	setChannelParams.rxAntSelectionMask = setChannelParams.rxAntSelectionMaskOrig;
	setChannelParams.rxAntMask = setChannelParams.rxAntMaskOrig;
	hdkSetAntConfigForMyBand(setChannelParams.txAntMask);
	HDK_SetAntennasReq((AntennaBitmaps_e)cocRequestedTxAntsMask,(AntennaBitmaps_e)cocRequestedRxAntsMask,antNum, DECREASE_NUM_OF_ANTS);
	sendHdkCdbManConfigSmCfm();
	ILOG0_V("hdkSetOperationalAntConfigReq");
}

static void hdkSetMaxAntsReq(K_MSG* psMsg)
{
	uint8 antNum;
	UNUSED_PARAM(psMsg);
	setChannelParams.txAntMask = Hdk_GetMaxTxAntMask();
	setChannelParams.txAntSelectionMask = Hdk_GetMaxTxAntSelectionMask();
	setChannelParams.rxAntSelectionMask = Hdk_GetMaxRxAntSelectionMask();
	setChannelParams.rxAntMask = Hdk_GetMaxRxAntMask();

	antNum = Utils_GetNumAntsFromMask(setChannelParams.txAntMask);

	hdkSetAntConfigForMyBand(setChannelParams.txAntMask);
	/*Power save state = DECREASE_NUM_OF_ANTS because no calibration is needed*/
	HDK_SetAntennasReq((AntennaBitmaps_e)setChannelParams.txAntMask,(AntennaBitmaps_e)setChannelParams.rxAntMask,antNum, DECREASE_NUM_OF_ANTS);
	ILOG0_V("hdkSetMaxAntsReq");
	SLOG0(0, 0, SetChannelParams_t, &setChannelParams);

	sendHdkCdbManConfigSmCfm();
}

STATIC void hdkSetRxDutyCycleReq(K_MSG* psMsg)
{
	UMI_RX_DUTY_CYCLE* pRxDutyCycleMsg = (UMI_RX_DUTY_CYCLE*)pK_MSG_DATA(psMsg);


	if (pRxDutyCycleMsg->getSetOperation == API_GET_OPERATION)
	{
		pRxDutyCycleMsg->offTime = rxThresholdParams.offTime;
		pRxDutyCycleMsg->onTime = rxThresholdParams.onTime;
	}
	else
	{
		//save the on time and the off time
		rxThresholdParams.onTime = pRxDutyCycleMsg->onTime;
		rxThresholdParams.offTime = pRxDutyCycleMsg->offTime;
		//write the duty cucle to the phy
		PhyDrv_WriteRxDutyCycleReq(pRxDutyCycleMsg->onTime, pRxDutyCycleMsg->offTime);
	}
	
	//send confirm to host
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RX_DUTY_CYCLE_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

STATIC void hdkSetRxThReq(K_MSG* psMsg)
{
	UMI_RX_TH* pRxThMsg = (UMI_RX_TH*)pK_MSG_DATA(psMsg);

	PhyDrv_WriteRxThToPhy(pRxThMsg->rxThValue);

#ifdef ENET_INC_ARCH_WAVE600	
	//send confirm to host
	OSAL_SEND_MESSAGE(PAC_MANAGER_SET_MIN_RSSI_THRESHOLD, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
#endif
}

#ifndef ENET_INC_ARCH_WAVE600
STATIC void hdkSetMinRssiReq(K_MSG* psMsg)
{	
	HdkMinRssi_t* pMinRssiMsg = (HdkMinRssi_t*)pK_MSG_DATA(psMsg);

	PhyDrv_WriteMinRssiToPhy(pMinRssiMsg->minRssi);
}
#endif

#ifdef ENET_INC_ARCH_WAVE600	
STATIC void hdkConfigCliAnalogRxDc(K_MSG* psMsg)
{	
	RxDcOffset_CliConfigAnalog(psMsg);
}
STATIC void hdkConfigCliDigitalRxDc(K_MSG* psMsg)
{	
	RxDcOffset_CliConfigDigital(psMsg);
}
#endif
STATIC void hdkAntConfigSmProcessDoneEvent(K_MSG* psMsg)
{
	/* Send Process finished event to HDK Process SM */
	hdkProcessExecutionCompletedEventHandler(psMsg, HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
	setHdkAntConfigSmState(ANT_CONFIG_IDLE);
}
STATIC void hdkSetAntConfigForMyBand(uint8 antMask)
{
#ifdef WRX600_BU_LOGS
	ILOG0_DD("hdkSetAntConfigForMyBand. band %d antMask 0x%x", ConfigurationManager_GetMyBand(), antMask);
#endif
	/* Configure MAC HW */
	PhyDrv_SetMacAntConfig(antMask);
#if !defined(ENET_INC_HW_FPGA) || defined(HDK_RF_EMULATOR)
	/* Associate antennas mask to PLL (0/1) */
	RficDriver_AssociateAntennasToMyBand(antMask);
#endif
}
/**********************    Event Handlers - Antenna configuration SM    *****************************/

STATIC void setAntennaConfigurationEvent(HdkAntConfigEvent_e event, K_MSG* pMsg)
{
//#ifdef HDK_LOGS	
	ILOG0_D("setAntennaConfigurationEventHandler, current state: %d", hdkSmStates.hdkAntConfigurationState);
//#endif

	AntConfigChangeSmFunc[hdkSmStates.hdkAntConfigurationState][event](pMsg);
}

STATIC void hdkSetProcessAndDisableAntEventHandler(K_MSG* pMsg)
{
	setAntennaConfigurationEvent(ANT_CONFIG_EVENT_SET_PROCESS,pMsg);
}
STATIC void hdkAntConfigProcessSchedEventHandler(K_MSG* pMsg)
{
	/* Send Process Scheduled event to HDK Process SM */
	hdkProcessProcessScheduledEventHandler(NULL, HDK_PROCESS_SET_ANTENNA_CONFIGURATION);
	setAntennaConfigurationEvent(ANT_CONFIG_EVENT_DISABLE_ANTS,pMsg);
}
STATIC void hdkAntConfigSetAntsEventHandler(K_MSG* pMsg)
{
	setAntennaConfigurationEvent(ANT_CONFIG_EVENT_SET_ANTS,pMsg);
}

STATIC void setHdkAntConfigSmState(HdkAntConfigState_e state)
{
#ifdef HDK_LOGS	
	ILOG0_D("setHdkAntConfigSmState. state: %d", state);
#endif

	hdkSmStates.hdkAntConfigurationState = state;
}
STATIC void antConfgiNotificationToLa(void)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LinkAdaptationFixedAntennaSelection_t));
	LinkAdaptationFixedAntennaSelection_t* params_p = (LinkAdaptationFixedAntennaSelection_t*) pK_MSG_DATA(kMsg_p);
	BandId_e band = ConfigurationManager_GetMyBand();
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(band);
	
	params_p->mask = setChannelParams.txAntMask;
	params_p->mode = MODIFY_CONNECTED_ANTENNA_MASK;
	params_p->retMsg = HDK_SET_ANT_CONFIG_NOTIFICATION_CFM;
	params_p->retTask = TASK_HDK;
	params_p->stationId = INVALID_STA_INDEX;
	params_p->vapId = vapId;

	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_ANTENNA_SELECTION_REQ, TASK_LINK_ADAPTATION, kMsg_p, vapId);
}
STATIC void antConfigNotificationToCoC(void)
{
	K_MSG*	pCocUpdateAntsNumMsg;
	cocUpdateAntMaskMsg_t* pCocAntsNum;
	BandId_e band = ConfigurationManager_GetMyBand();
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(band);
	// Send notification to DUT of number of current antennas
	pCocUpdateAntsNumMsg = OSAL_GET_MESSAGE(sizeof(cocUpdateAntMaskMsg_t));
	pCocAntsNum = (cocUpdateAntMaskMsg_t*)pK_MSG_DATA(pCocUpdateAntsNumMsg);		
	pCocAntsNum->currentRxAntsMask = setChannelParams.rxAntMask;
	pCocAntsNum->currentTxAntsMask = setChannelParams.txAntMask;
	pCocAntsNum->band = band;
	
	OSAL_SEND_MESSAGE(COC_UPDATE_ANT_CONFIG_FROM_HDK, TASK_COC, pCocUpdateAntsNumMsg, vapId);

}
STATIC void antConfigNotificationBitmapInit(void)
{
	/* Initialize Channel Notification requesters bitmap */
	antConfigDb.antConfigParams.requestersBitmap = 0;
	CHANNEL_NOTIFICATION_SET_BIT(antConfigDb.antConfigParams.requestersBitmap, ANT_CONFIG_NOTIFICATION_LA);
	CHANNEL_NOTIFICATION_SET_BIT(antConfigDb.antConfigParams.requestersBitmap, ANT_CONFIG_NOTIFICATION_COC);
	CHANNEL_NOTIFICATION_SET_BIT(antConfigDb.antConfigParams.requestersBitmap, ANT_CONFIG_NOTIFICATION_HE_GROUP_MANAGER);
}

STATIC void hdkAntConfigNotificationCfmEventHandler(K_MSG* pMsg)
{
	hdkAntConfigNotificationCb(pMsg);
}
STATIC void sendCdbManOnlineCalProcessFinishInd(bool processAbortBeforeRun)
{
	HdkCdbManagerOnlineCalSmMsg_t* ponlineCalMsgParams;
	K_MSG* onlineCalMsg;
	uint8 vapId;
	
	onlineCalMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerOnlineCalSmMsg_t));
	ponlineCalMsgParams = (HdkCdbManagerOnlineCalSmMsg_t *)pK_MSG_DATA(onlineCalMsg);
	ponlineCalMsgParams->band = ConfigurationManager_GetMyBand();
	ponlineCalMsgParams->processAbortBeforeRun = processAbortBeforeRun;
	vapId = ConfigurationManager_GetFirstVapForBand(ponlineCalMsgParams->band);

	/*Send message to HdkCdbManager*/
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED, TASK_HDK_CDB_MANAGER, onlineCalMsg, vapId);	//HdkCdbMan should know the sender vapId
}
uint32* hdkGetPsdProgmodelShramAddress(void)
{
	return p32PsdProgmodelShramAddressBand;
}
void sendHdkCdbManConfigSmCfm(void)
{
	K_MSG* pMsgToBand;
	HdkCdbManagerConfigBandReq_t* pHdkCdbManagerConfigReq;
	uint8 vapId = ConfigurationManager_GetFirstVapForMyBand();
	
	/*Send band configration request to LM*/
	pMsgToBand = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigBandReq_t));
	pHdkCdbManagerConfigReq = (HdkCdbManagerConfigBandReq_t *)pK_MSG_DATA(pMsgToBand);
	pHdkCdbManagerConfigReq->retMsg = HDK_CDB_MAN_INVALID_MSG;
	pHdkCdbManagerConfigReq->retTask = HDK_CDB_MAN_INVALID_TASK;
	pHdkCdbManagerConfigReq->requesterKmsg = NULL;
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_CFM, TASK_HDK_CDB_MANAGER, pMsgToBand, vapId);	//HdkCdbMan should know the sender vapId
		
}
/*=============================================================================*/
uint8 HDK_GetFreqJumpOriginChannelWidth()
{
	return G_HdkFreqJumpParams.setChannelOriginalParams.chan_width;
}
uint8 HDK_GetFreqJumpLowChanNum(uint8 bw)
{
	return G_HdkFreqJumpParams.chanDBperBW[bw].low_chan_num;
}
uint8 HDK_GetRfBw(uint8 fwBw)
{
	if(fwBw == BANDWIDTH_TWENTY)
		return RF_BW_20;
	else if(fwBw == BANDWIDTH_FOURTY)
		return RF_BW_40;
	else if(fwBw == BANDWIDTH_EIGHTY)
		return RF_BW_80;

	return RF_BW_80;
}
void hdkCalcLoFrequencies()
{	
	SetChannelParams_t setChanl;
	uint8 bw, rfBw;
	uint16 freq;
	uint8 requested_bw = HDK_GetFreqJumpOriginChannelWidth();
	/* this function calculate at the first loop the all frequencies and store it in global array LoFrequencies[] */
	
	HDK_InitLoFrequenciesArr();

	/*copy set channel msg to use in function 'RficDriver_CalcLoFrequency'. setChannel filled at HdkConfigInit*/
	MEMCPY(&setChanl, HDK_getSetChannelParams(), sizeof(SetChannelParams_t));
	
	/* need for frc driver bw, low_chan,*/		
	for(bw = BANDWIDTH_TWENTY ; bw <= requested_bw ; bw++)
	{
		rfBw = HDK_GetRfBw(bw);
		setChanl.setChannelReqParams.chan_width = bw;
		setChanl.setChannelReqParams.low_chan_num = HDK_GetFreqJumpLowChanNum(bw);				
		freq = RficDriver_CalcLoFrequency(&setChanl);
		HDK_SetFreqArr(freq,rfBw);
	}
}

/* rfBw 0=80MHz, 1=40MHz, 2=20MHz */
void HDK_SetFreqArr(uint16 freq, uint8 rfBwIdx)
{
		LoFrequencies_G[rfBwIdx] = freq;
		
}
uint16 HDK_GetLoFrequency(uint8 rfBwIdx)
{
		return LoFrequencies_G[rfBwIdx];
		
}

void HDK_InitLoFrequenciesArr(void)
{
		memset(LoFrequencies_G,0,sizeof(LoFrequencies_G));
}


/*============================================================================*/
void HDK_FreqJumpCalMapHandler(uint32* pCalibMap)
{
	if(HDK_GetFreqJumpSmState()== FREQ_JUMP_STATE_FJ_CHANNEL)
	{		
		(*pCalibMap) = (*pCalibMap) & SUPPORTED_FREQUENCY_JUMP_RX_CALIBRATION_MASK;
		
#ifdef HDK_LOGS
		ILOG0_D("BITMAP FJ_CHANNEL_STATE m_curOfflineProcBitmap = %d", (*pCalibMap));
#endif
	}
}

bool HDK_SetChannelFreeMsgNeeded(void)
{
	if ((getHdkProcessId() == HDK_PROCESS_CALIBRATE) && (getHdkProcessSmState() == HDK_PROCESS_STATE_ACTIVE) 
		 || (G_HdkFreqJumpParams.allocated == TRUE)
		)
	{
		G_HdkFreqJumpParams.allocated = FALSE;
		return TRUE;
	}

	return FALSE;//default				
}


/*=============================================================================*/	
STATIC void hdkFreqJumpFillChannelParams(HdkSetChannelReqParams_t* pSetChannelToFillParams, Bandwidth_e bw)
{
	pSetChannelToFillParams->chan_width   = G_HdkFreqJumpParams.chanDBperBW[bw].chan_width;
	pSetChannelToFillParams->low_chan_num = G_HdkFreqJumpParams.chanDBperBW[bw].low_chan_num;
	pSetChannelToFillParams->primary_chan_idx = G_HdkFreqJumpParams.chanDBperBW[bw].primary_chan_idx;
}


STATIC void hdkFreqJumpSetBwChannelParams(Bandwidth_e bw)
{
/* for more info about low_chan_num calculation, search in HdkTask.c "@return Data index according to channel and spectrum mode" */
	
	/* calculate per bw parameters: low channel num and primary index */
	switch(bw)
	{	
		case BANDWIDTH_TWENTY:
			G_HdkFreqJumpParams.chanDBperBW[bw].chan_width = BANDWIDTH_TWENTY;
			G_HdkFreqJumpParams.chanDBperBW[bw].low_chan_num = G_HdkFreqJumpParams.setChannelOriginalParams.low_chan_num + (G_HdkFreqJumpParams.setChannelOriginalParams.primary_chan_idx * JUMP_BETWN_CHANLS);
			G_HdkFreqJumpParams.chanDBperBW[bw].primary_chan_idx = 0;
			break;
		case BANDWIDTH_FOURTY:
			G_HdkFreqJumpParams.chanDBperBW[bw].chan_width = BANDWIDTH_FOURTY;
			G_HdkFreqJumpParams.chanDBperBW[bw].low_chan_num = G_HdkFreqJumpParams.setChannelOriginalParams.low_chan_num + (G_HdkFreqJumpParams.setChannelOriginalParams.primary_chan_idx >> 1)* 8  ;
			G_HdkFreqJumpParams.chanDBperBW[bw].primary_chan_idx = G_HdkFreqJumpParams.setChannelOriginalParams.primary_chan_idx & 1;
			break;
		case BANDWIDTH_EIGHTY:
			G_HdkFreqJumpParams.chanDBperBW[bw].chan_width = BANDWIDTH_EIGHTY;
			G_HdkFreqJumpParams.chanDBperBW[bw].low_chan_num = G_HdkFreqJumpParams.setChannelOriginalParams.low_chan_num;
			G_HdkFreqJumpParams.chanDBperBW[bw].primary_chan_idx = G_HdkFreqJumpParams.setChannelOriginalParams.primary_chan_idx;
			break;
		default:
			break;
	}
}

void hdkFreqJumpDBbwChannelParams(Bandwidth_e originBw)
{
	Bandwidth_e bw;
	
	memset(G_HdkFreqJumpParams.chanDBperBW, 0, sizeof(HdkFreqJumpChanlDB_t)*FREQ_JUMP_BW_DB);
			
	/* fill DB of channel parameters per bw */
	for(bw = BANDWIDTH_TWENTY ; bw <= originBw; bw++)
	{
		hdkFreqJumpSetBwChannelParams(bw);
	}
}

void hdkFreqJumpRestoreOriginParms(HdkSetChannelReqParams_t *pHdkSetChannelRequestParams)
{
	MEMCPY(pHdkSetChannelRequestParams,&G_HdkFreqJumpParams.setChannelOriginalParams,sizeof(HdkSetChannelReqParams_t));
}

STATIC void hdkFreqJumpStoreChanParms(HdkSetChannelReqParams_t* pSetChannelCurrentParams)
{
	MEMCPY(&G_HdkFreqJumpParams.setChannelOriginalParams, pSetChannelCurrentParams, sizeof(HdkSetChannelReqParams_t));
}

/**********************    Event Handlers - Frequency Jump SM    *****************************/
void hdkFreqJumpEventEnable(K_MSG* pMsg)
{
	hdkFreqJumpStateMachineFunc[hdkSmStates.freqJumpSmState][FREQ_JUMP_EVENT_ENABLE_FREQ](pMsg);
}
void hdkFreqJumpEventDisable(K_MSG* pMsg)
{					
	hdkFreqJumpStateMachineFunc[hdkSmStates.freqJumpSmState][FREQ_JUMP_EVENT_DISABLE_FREQ](pMsg);				
}

void hdkFreqJumpEventStart(K_MSG* pMsg)
{	
	hdkFreqJumpStateMachineFunc[hdkSmStates.freqJumpSmState][FREQ_JUMP_EVENT_START](pMsg);
}

void hdkFreqJumpEventNextBw(K_MSG* pMsg)
{	
	ILOG0_D("Freq Jump event 2 + 3: FREQ_JUMP_EVENT_NEXT_BW. current state: %d", hdkSmStates.freqJumpSmState);

	hdkFreqJumpStateMachineFunc[hdkSmStates.freqJumpSmState][FREQ_JUMP_EVENT_NEXT_BW](pMsg);
}
void hdkFreqJumpEventCalDone(K_MSG* pMsg)
{
#ifdef HDK_LOGS	
	ILOG0_D("Freq Jump event 4 done: FREQ_JUMP_EVENT_CAL_DONE. current state: %d", hdkSmStates.freqJumpSmState);
#endif
	hdkFreqJumpStateMachineFunc[hdkSmStates.freqJumpSmState][FREQ_JUMP_EVENT_CAL_DONE](pMsg);
}

void hdkFreqJumpEventIgnor(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
}
void hdkFreqJumpInvalidEvent(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	ASSERT(0);
}		

/**********************    State Handlers - HDK Main SM    *****************************/
		
void HDK_EnableFrequencyJump(K_MSG *pMsg)
{		
	UMI_ENABLE_FREQUENCY_JUMP_t* param;
	param = (UMI_ENABLE_FREQUENCY_JUMP_t*)pK_MSG_DATA(pMsg);	
	
	if(param->u8FreqJumpOn == TRUE)
	{			
		hdkFreqJumpEventEnable(pMsg);
	}
	else
	{		
		hdkFreqJumpEventDisable(pMsg);
	}
	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_FREQ_JUMP_MODE_CFM, TASK_UM_IF_TASK, pMsg, pMsg->header.vapId);
}
STATIC void hdkFreqJumpEnable(K_MSG* pMsg)
{
		UNUSED_PARAM(pMsg);	
	G_HdkFreqJumpParams.fjEnabled = TRUE;
	hdkSetFreqJumpModeInCtsAutoReply();
	setFreqJumpSmState(FREQ_JUMP_STATE_INIT);	
}
void  hdkSetFreqJumpModeInCtsAutoReply(void)
{
	/* set In Delia Recep. at RTS Auto Reply-. bwchanged=1 */
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LmFreqJumpMode_t));
	LmFreqJumpMode_t *params_p = (LmFreqJumpMode_t *)pK_MSG_DATA(kMsg_p);
	params_p->freqJumpMode = G_HdkFreqJumpParams.fjEnabled;
	
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FREQ_JUMP_MODE_REQ, TASK_LINK_ADAPTATION, kMsg_p, GET_DEFAULT_VAP_FOR_MY_BAND());
}

STATIC void hdkFreqJumpDisable(K_MSG* pMsg)
{	
	UNUSED_PARAM(pMsg);	
	G_HdkFreqJumpParams.fjEnabled = FALSE;
	hdkSetFreqJumpModeInCtsAutoReply();
	HDK_InitLoFrequenciesArr();// the system can up with disabled fj.
	setFreqJumpSmState(FREQ_JUMP_STATE_DISABLED);
}
void hdkSetChannelStateHandler(K_MSG* pMsg)
{	
	/* Init Frequency jump */
	hdkFreqJumpEventStart(pMsg);

	/* send Set Frequency event to Set Channel SM */
	setChannelSetFrequencyEventHandler(pMsg);
}
void setChannelCalResultsStoredStateHandler(K_MSG* pMsg)
{	
	/* On Freq Jump if(current bw< Requested Bw) Loop to setFreq */
	if(HDK_GetFreqJumpSmState() == FREQ_JUMP_STATE_FJ_CHANNEL)//need for case of Calibrate wait for cfm, and for case load cal return late.
	{
		hdkFreqJumpEventNextBw(pMsg);
	}
	else
	{
		/* Switch Set Channel state */		
		setSetChannelSmState(SET_CHANNEL_STATE_SEND_PARAMS);
		
		hdkFreqJumpEventCalDone(NULL);	
		
		sendChannelParams();
	}

}

STATIC void hdkFreqJumpInit(K_MSG* pMsg)
{
	HdkSetChannelReqParams_t* pSetChannelCurrentParams = (HdkSetChannelReqParams_t*) pK_MSG_DATA(pMsg);

	/* first: store original params  */
	hdkFreqJumpStoreChanParms(pSetChannelCurrentParams);
		
	hdkFreqJumpDBbwChannelParams((Bandwidth_e)pSetChannelCurrentParams->chan_width);
	
	/* calculate and fill LO frequencies */
	hdkCalcLoFrequencies();

	RficDriver_InitBwChanDC();

	
	/* internal msg allocation flag */
	G_HdkFreqJumpParams.allocated = FALSE;

	if( (pSetChannelCurrentParams->chan_width > BANDWIDTH_TWENTY)&&((pSetChannelCurrentParams->switchType == ST_NORMAL) || (pSetChannelCurrentParams->switchType == ST_NORMAL_AFTER_RSSI) || (pSetChannelCurrentParams->switchType == ST_CSA)))
	{
#ifdef HDK_LOGS	
		ILOG0_D("SWITCH TYPE REAL FJ  %d ++++++++ ", pSetChannelCurrentParams->switchType); 							
#endif
			/* fill first loop	with bw 20MHz  */
		hdkFreqJumpFillChannelParams(pSetChannelCurrentParams, BANDWIDTH_TWENTY);	
		setFreqJumpSmState(FREQ_JUMP_STATE_FJ_CHANNEL);

	}
	else
	{			
		setFreqJumpSmState(FREQ_JUMP_STATE_REQ_CHANNEL);	
	}
}

STATIC void hdkFreqJumpHndlr(K_MSG* pMsg)
{				
	K_MSG *pSetChannelMsg;
	HdkSetChannelReqParams_t* pSetChannelCurrentParams;
	uint8 bwNextJump = HDK_getChannelWidth(); //get current bw from DB. DB filled at setBWandFrequency()
	UNUSED_PARAM(pMsg);

#ifdef HDK_LOGS		
	ILOG0_V(" +++++FREQ JUMP HNDLR++++++++	");
#endif

	/* Allocate new Set Channel message */
	pSetChannelMsg = OSAL_GET_MESSAGE(sizeof(HdkSetChannelReqParams_t));
	pSetChannelCurrentParams = ((HdkSetChannelReqParams_t *)pK_MSG_DATA(pSetChannelMsg));
	G_HdkFreqJumpParams.allocated = TRUE;
	
	/* Calibrate next bw */
	bwNextJump++;

	if(bwNextJump == HDK_GetFreqJumpOriginChannelWidth())
	{			
		/* last iteration, restore the original set channel params */
		hdkFreqJumpRestoreOriginParms(pSetChannelCurrentParams);
		
#ifdef HDK_LOGS	
		ILOG0_D("INTO NextBW %d & Restore RestoreOriginParms ", bwNextJump);
#endif

		
		/* move to last state */	
		setFreqJumpSmState(FREQ_JUMP_STATE_REQ_CHANNEL);
	}
	else
	{			
		/* next  bw  message */		
		MEMCPY(pSetChannelCurrentParams , HDK_getSetChannelReqParams(),sizeof(HdkSetChannelReqParams_t));//from DB
		
		/* Fill next bw Set Channel params */
		hdkFreqJumpFillChannelParams(pSetChannelCurrentParams, (Bandwidth_e)bwNextJump);

#ifdef HDK_LOGS	
		ILOG0_D("NextBW %d NOT the LAST. fill params ",bwNextJump);
#endif
		
		/* move to next state */
		setFreqJumpSmState(FREQ_JUMP_STATE_FJ_CHANNEL);
		
	}
#ifdef HDK_LOGS	
	SLOG0(0, 0, HdkSetChannelReqParams_t, (HdkSetChannelReqParams_t *)pSetChannelCurrentParams);	
	SLOG0(0, 0, HdkSetChannelReqParams_t, (HdkSetChannelReqParams_t *)pSetChannelMsg->abData);							
	ILOG0_V(" LOOPPPPPPPP ======= no send param");			
#endif
	
	setChannelSetFrequencyStateHandler(pSetChannelMsg);	
}

STATIC void hdkFreqJumpCalDone(K_MSG* pMsg)
{
	UNUSED_PARAM(pMsg);	
	setFreqJumpSmState(FREQ_JUMP_STATE_INIT);	
}
/*================================*/

void hdkSsbModeFixChannelParams()
{
	if ((setChannelParams.band == BAND_2_4_GHZ) && (ssbParameters.hdkSSBTcrBw == BANDWIDTH_TWENTY) && (setChannelParams.setChannelReqParams.chan_width == BANDWIDTH_FOURTY) && (setChannelParams.setChannelReqParams.low_chan_num > MAX_UPPER_BONDING_CHANNEL))
	{
		setChannelParams.setChannelReqParams.low_chan_num -= 4;
		setChannelParams.setChannelReqParams.primary_chan_idx = 1;
	}
}
static void hdkUpdateantennaMaskPerChannel(uint8 channel_index)
{
	AntennaBitmaps_e antMask, oldmask;
	uint8 numAnts;
	PowerSaveStates_e powerSaveState;


	/*Mask with CDB configuration*/
	oldmask = (AntennaBitmaps_e)(PSD_getDataField(PSD_FIELD_TX_ANTS_MASK) & Hdk_GetTxAntMask());
	
	PSD_setNewChannel(channel_index);
	/*Mask with CDB configuration*/
	antMask = (AntennaBitmaps_e)(PSD_getDataField(PSD_FIELD_TX_ANTS_MASK) & Hdk_GetTxAntMask());
	numAnts = Utils_GetNumAntsFromMask(antMask);
	if ((antMask & (~oldmask)) != 0)
	{
		powerSaveState = INCREASE_NUM_OF_ANTS;
	}
	else
	{
		powerSaveState = DECREASE_NUM_OF_ANTS;
	}
	if (( Utils_GetNumAntsFromMask(oldmask) > 1) && (CoC_getNumActiveTxAnts() == 1))
	{
		powerSaveState = OUT_OF_1_ON_1;
	}
	HDK_SetAntennasReq(antMask, antMask, numAnts, powerSaveState);
	CoC_updateNewAntennaMask(antMask);
}

#if defined RADAR_DETECTION_ENABLED
void hdkRadarAdaptiveSensUpdateParamsReq(K_MSG *psMsg)
{
	RadarAdaptiveSensParams_t* params = (RadarAdaptiveSensParams_t*)pK_MSG_DATA(psMsg);
	radarDetectionAdaptiveSensUpdateParams(params->disableFeature, params->nonAssoDataPacketsTh, params->InterferernceRadarRatio);
}
void hdkRadarAdaptiveSensSendSerialTrace(K_MSG *psMsg)
{
	radarSerialTraceEnable_t* params = (radarSerialTraceEnable_t*)pK_MSG_DATA(psMsg);
	RadarAdaptiveSensEnableSerialTrace(params->enableserialTrace);
}

#endif


#ifndef ENET_INC_ARCH_WAVE600
static CalStatus_e RxDcOffset_GetAndStatus(CalStatus_e status1, CalStatus_e status2)
{
	CalStatus_e status = CAL_STATUS_INIT;
	if ((status1 == CAL_STATUS_PASS) && (status2 == CAL_STATUS_PASS))
	{
		status = CAL_STATUS_PASS;
	}
	else if ((status1 == CAL_STATUS_FAIL) || (status2 == CAL_STATUS_FAIL))
	{
		status = CAL_STATUS_FAIL;
	}
	else if ((status1 == CAL_STATUS_IN_PROCESS) || (status2 == CAL_STATUS_IN_PROCESS))
	{
		status = CAL_STATUS_IN_PROCESS;
	}
	else if ((status1 == CAL_STATUS_STUCK) || (status2 == CAL_STATUS_STUCK))
	{
		status = CAL_STATUS_STUCK;
	}
	else if ((status1 == CAL_STATUS_INIT) || (status2 == CAL_STATUS_INIT))
	{
		status = CAL_STATUS_INIT;
	}
	else
	{
		ASSERT(0);
	}
	return status;
}
#endif

STATIC void setCalibrationStatistics(void)
{
	K_MSG *pCalibrationStatusMsg;
	LinkAdaptationCalibrationStatus_t*	pCalibrationStatusParams;
	uint8 vapId;
	uint8 ant, BFTypes;
	uint8 antMask, numOfAnts;
	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &antMask);
	UNUSED_PARAM(BFTypes);

	pCalibrationStatusMsg = OSAL_GET_MESSAGE(sizeof(LinkAdaptationCalibrationStatus_t));
	pCalibrationStatusParams = (LinkAdaptationCalibrationStatus_t*)pK_MSG_DATA(pCalibrationStatusMsg);
#ifndef ENET_INC_ARCH_WAVE600
	for (BFTypes = AFE; BFTypes < MAX_NUMBER_OF_BF_CALS; BFTypes++)
	{
		pCalibrationStatusParams->BF[BFTypes] = BeamForming_GetStatus((QBF_CalibrationType_e)BFTypes);
	}
#endif

	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
#ifdef ENET_INC_ARCH_WAVE600
			pCalibrationStatusParams->rxDc[ant] = RxDcOffset_GetStatus(ant);
#else
			pCalibrationStatusParams->rxDc[ant] = RxDcOffset_GetAndStatus(RxDcOffset_GetStatus(ant,RFIC_PATH_TYPE_I),RxDcOffset_GetStatus(ant,RFIC_PATH_TYPE_Q));
#endif
			pCalibrationStatusParams->txLo[ant] = TxLoLeakage_GetStatus(ant);
			pCalibrationStatusParams->rxIq[ant] = RxIQ_GetStatus(ant);
			pCalibrationStatusParams->txIq[ant] = TxIQClbr_GetStatus(ant);

		}
	}
	vapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_CALIBRATION_STATISTICS, TASK_LINK_ADAPTATION,pCalibrationStatusMsg, vapId);

}

#ifdef ENET_INC_ARCH_WAVE600

bool TEST_BUS_ENABLE = TRUE;
#ifdef DEBUG_UM_INTERFACE
static void hdkTestBusEn(K_MSG * psMsg)
{
	UMI_testBusEn_t* params = (UMI_testBusEn_t*)pK_MSG_DATA(psMsg);

	if ((TEST_BUS_ENABLE == TRUE) && (params->enable == FALSE))
	{
		PhyTestBus_Close();
	}
	TEST_BUS_ENABLE = params->enable;
	OSAL_SEND_MESSAGE(UMI_MC_TEST_BUS_EN_CFM, TASK_UM_IF_TASK, psMsg, INVALID_VAP);
}
#endif

bool Hdk_isTestBusEnable()
{
	return TEST_BUS_ENABLE;
}

#endif

    
/***********************************************************************
* hdkGetPhyStatistics
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void hdkGetPhyStatistics(K_MSG* psMsg)
{
	uint8 ant;	
	uint8 antMask;
	uint8 numOfAnts;
	int32 txPower = 0;
	BandId_e bandId = ConfigurationManager_GetMyBand();
#ifdef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
	int8 maxRssi;
#endif
	StaId staIndex = LmStaDataBase.headIndexOfStaLinkList; // Each LM (band 0/1) has a different head to the list.
	int8 minRssi;

	// Get extStaRx
#ifdef ENET_INC_ARCH_WAVE600
	phyRxStatusDb.devicePhyRxStatus[bandId].extStaRx = PhyDrv_GetRxAbortCounter();
#else
	phyRxStatusDb.devicePhyRxStatus.extStaRx = PhyDrv_GetRxAbortCounter();
#endif

	// calculate TX Power
	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &antMask);
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if(antMask&(1<<ant))
		{
			txPower += TPC_getMaxEVMpower(ant, HDK_getChannelWidth()); //Max evm value to the current bandwidth
		}
	}	

	if (numOfAnts != 0)
	{
#ifdef ENET_INC_ARCH_WAVE600
		phyRxStatusDb.devicePhyRxStatus[bandId].txPower = txPower/numOfAnts;
#else
		phyRxStatusDb.devicePhyRxStatus.txPower = txPower/numOfAnts;
#endif
	}
	else
	{
#ifdef ENET_INC_ARCH_WAVE600
		phyRxStatusDb.devicePhyRxStatus[bandId].txPower = 0;
#else
		phyRxStatusDb.devicePhyRxStatus.txPower = 0;
#endif
	}

	// Get CWIvalue
#ifdef ENET_INC_ARCH_WAVE600
	phyRxStatusDb.devicePhyRxStatus[bandId].CWIvalue = ContinuousInterfererDetection_GetMaxMeasuremenet();
#else
	phyRxStatusDb.devicePhyRxStatus.CWIvalue = ContinuousInterfererDetection_GetMaxMeasuremenet();
#endif	

#ifdef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
	// We have a bug in PAC Extrapolator so we turn off the MIN RSSI feature. Sicne driver needs it, we compute it ourselves.
	while (staIndex != DB_ASYNC_SID)
	{
		DEBUG_ASSERT(staIndex < HW_NUM_OF_STATIONS);
		maxRssi = RX_THRESHOLD_DEFAULT_VALUE;

		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if(antMask&(1<<ant))
			{
				if (phyRxStatusDb.staPhyRxStatus[staIndex].rssi[ant] > maxRssi)
				{
					maxRssi = phyRxStatusDb.staPhyRxStatus[staIndex].rssi[ant];
				}				
			}
		}
		// fill the value in the array of maxRssi instead of the turned off PAC Extrapolator HW.
		pacExtrapolatorRssi.maxRssi[staIndex] = maxRssi;
		staIndex = StaDbSwEntries[staIndex].nextSid;
	}
	staIndex = LmStaDataBase.headIndexOfStaLinkList; // Each LM (band 0/1) has a different head to the list.
#endif

	while (staIndex != DB_ASYNC_SID)
	{
		DEBUG_ASSERT(staIndex < HW_NUM_OF_STATIONS);
		minRssi = MAX_INT8;

		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if(antMask&(1<<ant))
			{
				if (phyRxStatusDb.staPhyRxStatus[staIndex].rssi[ant] < minRssi)
				{
					minRssi = phyRxStatusDb.staPhyRxStatus[staIndex].rssi[ant];
				}				
			}
		}
		/* Update min rssi */
		pacExtrapolatorRssi.minRssi[staIndex] = minRssi;
		staIndex = StaDbSwEntries[staIndex].nextSid;
	}

	// Send confirm to UMAC
	OSAL_SEND_NO_DATA_MESSAGE(STATISTICS_MANAGER_HDK_STATISTICS_CFM, TASK_STATISTICS_MANAGER, psMsg->header.vapId);	
}

void Hdk_SetTxWindowLimit(K_MSG *psMsg)
{
	
	txWindowSize_t* params = (txWindowSize_t*)pK_MSG_DATA(psMsg);
	ILOG0_D("Hdk_SetTxWindowLimit, sindowSizeOption = %d", params->sindowSizeOption);
	
	phyDrv_SetTxWindow(params->sindowSizeOption);
	
}
	
void ChannelNotificationHeGroupManager(void)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(HeGroupManagerChannelNotification_t));
	HeGroupManagerChannelNotification_t *params_p = (HeGroupManagerChannelNotification_t *)pK_MSG_DATA(kMsg_p);

	params_p->bw = setChannelParams.setChannelReqParams.chan_width;
	
	OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_SET_CHANNEL, TASK_HE_GROUP_MANAGER, kMsg_p, GET_DEFAULT_VAP_FOR_MY_BAND());

}

void antConfigNotificationToHeGroupManager(void)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(HeGroupManagerAntConfigNotification_t));
	HeGroupManagerAntConfigNotification_t *params_p = (HeGroupManagerAntConfigNotification_t *)pK_MSG_DATA(kMsg_p);

	params_p->numberOfConnectedAnts = Utils_GetNumAntsFromMask(setChannelParams.txAntMask);
	
	OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_SET_ANTENNAS, TASK_HE_GROUP_MANAGER, kMsg_p, GET_DEFAULT_VAP_FOR_MY_BAND());

}


