#include "LmHdk_API.h"
#include "Indirect_API.h"
#include "Afe_API.h"
#include "PhyDriver_API.h"
#include "RficDriver_API.h"
#include "loggerAPI.h"
#include "lmi.h"
#include "RFICDefines.h"
#include "CalibrationHandler.h"
#include "RficCommon.h"
#include "lm.h"
#include "RxDcOffsetClbrHndlr.h"
#include "enet_pas.h"
#include "RegAccess_Api.h"
#include "sysinfo.h"
#include "System_Information.h"
#include "CoC_Api.h"
#include "PSD.h"


#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 6


#define EFUSE_IBIAS_TRIM_MASK		(0x1F)
#define EFUSE_BGP_VREF_CONF_MASK	(0xE0)
#define EFUSE_TRIM_GAIN_CH1_MASK    (0xF000)
#define EFUSE_TRIM_GAIN_CH2_MASK    (0xF0000)
#define EFUSE_TRIM_GAIN_CH3_MASK    (0xF00000)
#define EFUSE_TRIM_MS_LDO_MASK		(0x7000000)
#define EFUSE_IBIAS_TRIM_SHIFT		0
#define EFUSE_BGP_VREF_CONF_SHIFT	5
#define EFUSE_TRIM_GAIN_CH1_SHIFT   12
#define EFUSE_TRIM_GAIN_CH2_SHIFT   16
#define EFUSE_TRIM_GAIN_CH3_SHIFT   20
#define EFUSE_TRIM_MS_LDO_SHIFT		24

#define GRX350_EFUSE_BANDGAP_TRIM_MASK					(0x70)
#define GRX350_EFUSE_BANDGAP_TRIM_SHIFT					4
#define GRX350_EFUSE_BANDGAP_TRIM_OFFSET				0
#define GRX350_EFUSE_BIAS_CUR_TRIM_MASK					(0xF)
#define GRX350_EFUSE_BIAS_CUR_TRIM_SHIFT				0
#define GRX350_EFUSE_BIAS_CUR_TRIM_OFFSET				0
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT0_MASK		(0x7)
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT0_SHIFT	0
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT0_OFFSET	1
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT1_MASK		(0x38)
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT1_SHIFT	3
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT1_OFFSET	1
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT2_MASK		(0x1C0)
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT2_SHIFT	6
#define GRX350_EFUSE_TRIM_ABS_GAIN_IQ_DAC_ANT2_OFFSET	1
#define GRX350_EFUSE_SSI_MASK							(0x600)
#define GRX350_EFUSE_SSI_SHIFT							9
#define GRX350_EFUSE_SSI_OFFSET							1
#define GRX350_EFUSE_LDO_ANT0_TRIM_MASK					(0x7000)
#define GRX350_EFUSE_LDO_ANT0_TRIM_SHIFT				12
#define GRX350_EFUSE_LDO_ANT0_TRIM_OFFSET				0
#define GRX350_EFUSE_LDO_ANT1_TRIM_MASK					(0x38000)
#define GRX350_EFUSE_LDO_ANT1_TRIM_SHIFT				15
#define GRX350_EFUSE_LDO_ANT1_TRIM_OFFSET				0
#define GRX350_EFUSE_LDO_ANT2_TRIM_MASK					(0x1C0000)
#define GRX350_EFUSE_LDO_ANT2_TRIM_SHIFT				18
#define GRX350_EFUSE_LDO_ANT2_TRIM_OFFSET				0
#define GRX350_EFUSE_BIAS_CUR_TRIM_REG_SHIFT			1
#define GRX350_EFUSE_BIAS_CUR_TRIM_REG_MASK				(0x1E)
#define GRX350_EFUSE_SSI_OFFSET_REG_SHIFT				14
#define GRX350_EFUSE_SSI_OFFSET_REG_MASK				(0xC000)
#define GRX350_EFUSE_LDO_ANT0_TRIM_REG					(0x55)
#define GRX350_EFUSE_LDO_ANT0_TRIM_REG_MASK				(0x3800)
#define GRX350_EFUSE_LDO_ANT0_TRIM_REG_SHIFT			11
#define GRX350_EFUSE_LDO_ANT1_TRIM_REG					(0x54)
#define GRX350_EFUSE_LDO_ANT1_TRIM_REG_MASK				(0x700)
#define GRX350_EFUSE_LDO_ANT1_TRIM_REG_SHIFT			8
#define GRX350_EFUSE_LDO_ANT2_TRIM_REG					(0x54)
#define GRX350_EFUSE_LDO_ANT2_TRIM_REG_MASK				(0x7000)
#define GRX350_EFUSE_LDO_ANT2_TRIM_REG_SHIFT			12


void LmHdk_SetInitAfeAR10(uint32 *AFEval);
void LmHdk_SetInitAfeGRX350(uint32 *AFEval);


/***************************************************************************
**
** NAME          LM_HDK_SetXtalValue
**
** PARAMETERS   xtal
** DESCRIPTION : for boards with xtal crystal, write the value to PLL 
**                 
****************************************************************************/
void LmHdk_SetXtalValue(uint32 xtal)
{ 
	RficDriver_SetXtalValue(xtal);
	//For wave300 with xtal write xtal frequency to Pll reg in case of wave300 with Xo - not effective
}

/***************************************************************************
**
** NAME          LmHdk_SetXtalValue
**
** PARAMETERS   xtal
** DESCRIPTION : for boards with xtal crystal, write the value to PLL 
**                 
****************************************************************************/
void LmHdk_GetXtalValue(OUT uint32 *xtal)
{
	RficDriver_GetXtalValue(xtal);
}



/***************************************************************************
**
** NAME          LmHdk_SetInitAfe
**
** PARAMETERS   AFE value from EFUSE
** DESCRIPTION : init AFE
**                 
****************************************************************************/

void LmHdk_StartTestBus()
{
#ifndef ENET_INC_ARCH_WAVE600 // if needed in gen6 - check how to do it.
	MT_WrReg(PHY_TD_BASE_ADDR, 0x178, 0);
	MT_WrReg(PHY_TD_BASE_ADDR, 0x17C, 0);
	MT_WrReg(PHY_TD_BASE_ADDR, 0x180, 0);
	MT_WrReg(PHY_BE_BASE_ADDR, 0x10, 0);
	MT_WrReg(PHY_TX_BASE_ADDR, 0x168, 0);
	MT_WrRegMask(PHY_FD_BASE_ADDR, 0x40, 0x1FF00000, 0);
	MT_WrReg(PHY_FD_BASE_ADDR, 0x70, 0);
	MT_WrReg(PHY_TD_BASE_ADDR, 0x178, 1);
	MT_WrReg(PHY_TD_BASE_ADDR, 0x180, 1);
	MT_WrRegMask(PHY_TD_BASE_ADDR, 0x210, 0x333F, 0x210B);
	MT_WrReg(PHY_TD_BASE_ADDR, 0x178, 0x80000);
	MT_WrRegMask(PHY_TD_BASE_ADDR, 0x210, 0x333F, 0x210B);
#endif
}

