/*******************************************************************************
*    
*   Source File:
*       HDK_utils.c
*	
*	AUTHOR: 
* 
*   Copyright: 
*   Revision History:
*
*******************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "HDK_utils.h"
#include "PhyRegsIncluder.h"
#include "ConfigurationManager_api.h"
#include "RegAccess_Api.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"


#define LOG_LOCAL_GID GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 7


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

void writeArr2AllAntRegs(uint32 regAddress, uint32* regValueAntArr)
{
	int8 i;
	uint8 antMask;
	uint8 antIterator;

	antMask = Hdk_GetRxAntMask();

	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		if ((antIterator & 0x1) == 0x1)
		{
		
			RegAccess_Write(regAddress + i*ANT_REGS_OFFSET,regValueAntArr[i]);
		}
		i++;
	}
}
void writeVal2AllAntRegs(uint32 regAddress, uint32 value)
{
	int8 i;
	uint8 antMask;
	uint8 antIterator;

	antMask = Hdk_GetRxAntMask();

	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		if ((antIterator & 0x1) == 0x1)
		{
		
			RegAccess_Write(regAddress + i*ANT_REGS_OFFSET,value);
		}
		i++;
	}
}

void readArrFromAllAntRegs(uint32 regAddress, uint32* regValueAntArr)
{
	int8 i;
	uint8 antMask;
	uint8 antIterator;

	antMask = Hdk_GetRxAntMask();

	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		regValueAntArr[i] = 0;

		if ((antIterator & 0x1) == 0x1)
		{
		
			RegAccess_Read(regAddress + i*ANT_REGS_OFFSET,&regValueAntArr[i]);
		}
		i++;
	}
}
void writeVal2MaskAntRegs(uint32 regAddress, uint32 value, uint8 antMask)
{
	int8 i;
	uint8 antIterator;
	uint8 bandAntMask;
	bandAntMask = Hdk_GetRxAntMask();

	ASSERT((bandAntMask&antMask)== antMask); //required antMask should be contained in band antenna mask
	
	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		if ((antIterator & 0x1) == 0x1)
		{
			RegAccess_Write(regAddress + i*ANT_REGS_OFFSET,value);
		}
		i++;
	}
}
void writeArr2MaskAntRegs(uint32 regAddress, uint32* regValueAntArr, uint8 antMask)
{
	int8 i;
	uint8 antIterator;
	
	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		if ((antIterator & 0x1) == 0x1)
		{
			RegAccess_Write(regAddress + i*ANT_REGS_OFFSET,regValueAntArr[i]);
		}
		i++;
	}
}

void readArrFromMaskAntRegs(uint32 regAddress, uint32* regValueAntArr, uint8 antMask)
{
	int8 i;
	uint8 antIterator;
	
	for(i=0, antIterator = antMask; antIterator!=0; antIterator>>=1)
	{
		if ((antIterator & 0x1) == 0x1)
		{
			RegAccess_Read(regAddress + i*ANT_REGS_OFFSET,&(regValueAntArr[i]));
		}
		i++;
	}
}


