/***********************************************************************************
 File:			GroupsGenerator.h
 Module:		HE Group Manager 
 Purpose: 		To create MU groups
 Description:	This file contains all definitions and the structures of the groups 
 				generator which is responsible of creating multi user groups
************************************************************************************/
#ifndef HE_GROUPS_GENRATOR_H_
#define HE_GROUPS_GENRATOR_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Configuration.h"
#include "HeGroupManager_API.h"
#include "OSAL_Kmsg.h"
#include "linkAdaptation_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
	
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void groupsGenerator_SetGroupPoliciesTable(HeGroupManagerGroupPoliciesTable_t groupPoliciesTable);
void groupsGenerator_AddGroupTypeToTable(HeGroupManagerGroupPolicy_t groupPolicy);
bool groupsGenerator_GenerateAllGroups(void);
void groupsGenerator_GenerateGroupsForVap(uint8 vapId, BandId_e bandId, uint8* numOfFreeGroups, bool* groupsInGeneration);
void groupsGenerator_FillGroupParametersForPlan(HeGroupManagerGroupPolicy_t* groupPolicy, HeGroupGeneratorResults_t* groupGeneratorResults, uint8 vapId, uint8 numOfStationsInGroup);
void groupsGenerator_GenerateGroup(uint8 vapId, HeGroupManagerGroupPolicy_t groupPolicy);
void groupsGenerator_SetMaxGroupsConfiguration(uint8 maxGroupsBand0, uint8 maxGroupsBand1);
void groupsGenerator_SetNumOfStaInGroupConfiguration(K_MSG* pMsg);
void groupsGenerator_SetTrafficConfiguration(TrafficType_e trafficType);
void groupsGenerator_SetMuModeConfiguration(FormationType_e dlTypeOpt1, FormationType_e dlTypeOpt2, FormationType_e ulTypeOpt1, FormationType_e ulTypeOpt2);
void groupsGenerator_SetAntennasConfiguration(NumOfAntennas_e numOfAnt, BandId_e bandId);
void groupsGenerator_CreatePlan(HeGroupGeneratorResults_t *pHeGroupGeneratorResults);
bool groupsGenerator_CreatePlanDone(K_MSG* psMsg);
void groupsGenerator_CreateStaticPlan(K_MSG* psMsg);
uint8 groupsGenerator_GetNumOfFreeDataPhases(uint8 vapId);
bool groupsGenerator_CheckFreeDataPhases(HeGroupManagerPhaseBitmap_t phaseBitmap, uint8 vapId);
void groupsGenerator_IncreaseNumOfFreeDataPhases(HeGroupManagerPhaseBitmap_t phaseBitmap, uint8 vapId);
void groupsGenerator_DecreaseNumOfFreeDataPhases(HeGroupManagerPhaseBitmap_t phaseBitmap, uint8 vapId);
uint8 groupsGenerator_CalcNumOfDataPhases(HeGroupManagerPhaseBitmap_t phaseBitmap);
#ifdef ENET_INC_ARCH_WAVE600D2
void groupsGenerator_SetGroupSupportMbssRxCntrl(K_MSG* psMsg, uint8 groupId);
#endif


#endif /* HE_GROUPS_GENRATOR_H_ */

