/***********************************************************************************
 File:			HeGroupHandlerr.h
 Module:		HE Group Manager 
 Purpose: 		Handle groups
 Description:	
************************************************************************************/
#ifndef HE_GROUPS_HANDLER_H_
#define HE_GROUPS_HANDLER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Kmsg.h"
#include "linkAdaptation_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern bool groupsHandler_CheckGroupsEfficiency(void);
extern bool groupsHandler_RemoveStation(K_MSG* psMsg);
extern void groupsHandler_RemoveGroup(uint8 groupId);
extern bool  groupsHandler_PlanRemovedCfm (K_MSG* psMsg,K_MSG** psMsgOriginal, uint8* returnGroupId);
extern bool groupsHandler_RemoveStaticPlan(K_MSG* psMsg);
extern void groupsHandler_PlanRemovedDoneGroupsInRemoval (K_MSG* psMsgOriginal, uint8 groupId);
extern void groupsHandler_PlanRemovedDoneGroupsUnderMaintenence (uint8 groupId);
extern bool groupsHandler_RemoveAllActiveGroups(void);
extern bool groupsHandler_BandConfigurationChanged(BandId_e bandId);

#endif /* HE_GROUPS_HANDLER_H_ */

