/***********************************************************************************
 File:			HeGroupManager.h
 Module:		HE Group Manager 
 Purpose: 		To create and delete HE MU groups
 Description:	This file contains all definitions and the structures of the HE group 
 				manager which is responsible of creating and deleting HE multi user 
 				groups
************************************************************************************/
#ifndef HE_GROUP_MANAGER_H_
#define HE_GROUP_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Configuration.h"
#include "HeGroupManager_API.h"
#include "OSAL_Kmsg.h"
#include "linkAdaptation_api.h"
#include "VapDatabase_Api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define DOWNLINK_PLAN 											(0)
#define HE_GROUP_MANAGER_CALENDAR_WHEEL_TIMER_IN_MILLISECONDS 	(400)
#define ALL_GROUPS_FREE										  	(0x00000000) // should match the HE_GROUP_MANAGER_MAX_NUMBER_OF_GROUPS
#define NUMBER_OF_GROUPS_FOR_PROBING							(0)
#define NONE_TIDS												(0)
#define MAX_GROUP_POLICIES                                      (32)	
#define MIN_STA_IN_HE_GROUP										(4)			//by default, groups of 4 Stations will be created. can be changed via UMI_MAN_SET_DYNAMIC_MU_TYPE API.
#define MAX_STA_IN_HE_GROUP										(4)
#define MAX_NUM_OF_HE_GROUPS									(2)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum HeGroupManagerGlobalState_e
{
	HE_GROUP_MANAGER_GLOBAL_STATE_DISABLED = 0,
	HE_GROUP_MANAGER_GLOBAL_STATE_IDLE,
	HE_GROUP_MANAGER_GLOBAL_STATE_COLLECTING_METRICS,
	HE_GROUP_MANAGER_GLOBAL_STATE_UNDER_MAINTENENCE,
	HE_GROUP_MANAGER_GLOBAL_STATE_GROUPS_IN_CREATION,
	HE_GROUP_MANAGER_GLOBAL_STATE_IN_REMOVAL,
	HE_GROUP_MANAGER_GLOBAL_STATE_CREATING_STATIC_PLAN,
	HE_GROUP_MANAGER_GLOBAL_STATE_STATIC_PLAN,
	HE_GROUP_MANAGER_GLOBAL_STATE_REMOVING_STATIC_PLAN,
	HE_GROUP_MANAGER_GLOBAL_LAST_STATE = HE_GROUP_MANAGER_GLOBAL_STATE_REMOVING_STATIC_PLAN,	
} HeGroupManagerGlobalState_e;

typedef enum HeGroupManagerGlobalEvent_e
{
	HE_GROUP_MANAGER_GLOBAL_EVENT_DISABLE_MU,
	HE_GROUP_MANAGER_GLOBAL_EVENT_ENABLE_DYNAMIC_MU,
	HE_GROUP_MANAGER_GLOBAL_EVENT_DISABLE_DYNAMIC_MU,
	HE_GROUP_MANAGER_GLOBAL_EVENT_SET_CHANNEL,
	HE_GROUP_MANAGER_GLOBAL_EVENT_SET_ANTENNAS,
	HE_GROUP_MANAGER_GLOBAL_EVENT_ADD_STA,
	HE_GROUP_MANAGER_GLOBAL_EVENT_SET_STA_ASSOC_PARAMS_FROM_LA,
	HE_GROUP_MANAGER_GLOBAL_EVENT_REMOVE_STA,
	HE_GROUP_MANAGER_GLOBAL_EVENT_TIMER_EXPIRED,
	HE_GROUP_MANAGER_GLOBAL_EVENT_METRICS_READY,
	HE_GROUP_MANAGER_GLOBAL_EVENT_PLAN_REMOVED_DONE,
	HE_GROUP_MANAGER_GLOBAL_EVENT_PLAN_CREATION_DONE,
	HE_GROUP_MANAGER_GLOBAL_EVENT_SET_STATIC_PLAN,
	HE_GROUP_MANAGER_GLOBAL_EVENT_REMOVE_STATIC_PLAN,
	HE_GROUP_MANAGER_GLOBAL_EVENT_SET_NUM_OF_STA_IN_GROUP,
	HE_GROUP_MANAGER_GLOBAL_LAST_EVENT = HE_GROUP_MANAGER_GLOBAL_EVENT_SET_NUM_OF_STA_IN_GROUP
} HeGroupManagerGlobalEvent_e;

typedef enum RemovalRequestor_e
{	
	NO_REMOVAL_REQUESTOR = 0,
	DISABLE_PROCESS,
	DISABLE_DYNAMIC_MU_PROCESS,
	REMOVE_STATIC,
	STATION_REMOVAL,
	CREATE_STATIC,
	SET_CHANNEL,
	SET_ANTENNA,
	REMOVE_GROUPS_FOR_STATION_TID,
	CHANGE_FROM_STATIC_TO_DYNAMIC
} RemovalRequestor_e;

typedef enum CreationRequestor_e
{	
	NO_CREATION_REQUESTOR = 0,
	STATIC_REQ,
	NON_STATIC_REQ,	
} CreationRequestor_e;
typedef enum dlUlOfdmaType 
{
	DYNAMIC_MU_TYPE_NONE,
	DYNAMIC_MU_TYPE_OFDMA,
	DYNAMIC_MU_TYPE_MIMO,
	DYNAMIC_MU_TYPE_BOTH,
	DYNAMIC_DL_UL_MU_TYPE_NUM
}dlUlMuType_e;

typedef enum heMuGroupCdbMode
{
	DYNAMIC_MU_CDB,
	DYNAMIC_MU_BAND0,
	DYNAMIC_MU_BAND1	
}heMuGroupCdbMode_e;

typedef struct HeGroupManagerConfigurations_t
{
    dlUlMuType_e                    	dlMuType;
    dlUlMuType_e                        ulMuType;         
    uint8                               maxGroups[NUM_OF_CONFIGURATION_MANAGER_BANDS];
    uint8 						        maxStationsInGroup;
	uint8 						        minStationsInGroup;
} HeGroupManagerConfigurations_t;

typedef struct HeGroupManagerGroupPolicy_t
{
	HeGroupManagerCharacteristicsBitmap_u	groupCharacteristics;
    HeGroupManagerPhaseBitmap_t				phasesBitmap;
	HeMuSequence_e							sequence;
    FormationType_e			                formationType;
	uint8 									maxStationsInGroup;
	uint8 									minStationsInGroup;	
    uint8                                   numberOfRepetitions;
    uint8                                   validGroup           :1;
    uint8                                   numOfGroupsForPolicy :4;
    uint8                                   reserved             :3;	
} HeGroupManagerGroupPolicy_t;

typedef struct HeGroupManagerGroupPoliciesTable_t
{
    HeGroupManagerGroupPolicy_t* pHeGroupManagerGroupPolicies;
    uint8                        numOfPolicies;
    uint8                        maxNumOfGroupsPerPolicy;
} HeGroupManagerGroupPoliciesTable_t;

typedef struct HeGroupManager_GlobalParameters_t
{	  
    HeGroupManagerGroupPoliciesTable_t  groupPoliciesTable;
    HeGroupManagerConfigurations_t      groupManagerConfigurations;
    FwUtils_queue_t				        pendingQueue;
	K_MSG*  					        returnMsg;
    uint32  					        activeGroupsBitmap;
	uint16						        stationIdCurrentlyProcessed;
    uint16						        tidsHeMuEnableByPlan;					/* Plan manager valid TIDs */
    RemovalRequestor_e			        removalRequestor;
	CreationRequestor_e			        creationRequestor;
	HeGroupManagerGlobalState_e         globalState;
    uint8						        tidCurrentlyProcessed;
	uint8						        numOfGroupsInCreation;
	uint8						        numOfGroupsInRemoval;
	uint8						        numOfActiveStaticPlan;

} HeGroupManager_GlobalParameters_t;

typedef struct HeGroupManager_BandParameters_t
{
    HeGroupManagerCharacteristicsBitmap_u bandLimitationBitmap;
	NumOfAntennas_e 				      numOfActiveAntennas;
    Bw_e								  maxBw;
    uint8                                 numOfFreeDataPhases;  
	uint8 								  setChannelVapIdCfmPendingMsg;
} HeGroupManager_BandParameters_t;

typedef enum ActivateTimer_e
{	
	DONT_ACTIVATE_TIMER = 0,
	ACTIVATE_TIMER,
} ActivateTimer_e;

typedef enum GroupGenerationStatus_e
{	
	GROUP_CANDIDATE_FOUND = 0,
	NO_GROUP_CANDIDATE,
} GroupGenerationStatus_e;

typedef struct HeGroupGeneratorResults_t
{ 
    HeGroupManagerCharacteristicsBitmap_u	groupCharacteristics;    
    StaId					                stationsList[HE_GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP];
    HeGroupManagerPhaseBitmap_t	            phasesBitmap;
    HeMuSequence_e				            sequence;
    FormationType_e			                formationType;
    Bw_e					                bw;
    MuType_e                                muType;
    uint8                                   numberOfRepetitions;	
	uint8					                numOfStationsInGroup;
	uint8					                vapId;
} HeGroupGeneratorResults_t;

typedef struct HeGroupManager_StationDbEntry_t
{
    HeGroupManagerCharacteristicsBitmap_u   characteristicsBitmap;
    uint32						            groupsBitmap;					// groups this station is member to/or pointing to
    uint16						            tidsHeMuEnablebyHeGM;			// for race between TS Manager & HE GM
	uint16						            tidsHeMuEnablebyTSManager;	    // for race between TS Manager & HE GM
	HeGroupManagerStationState_e            heGroupManagerStationState;	
	LnaType_e					            lnaType;	
	uint8						            vapId;	
} HeGroupManager_StationDbEntry_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void  heGroupManagerEnableHeMuInSelector(uint8 groupId);
extern void  heGroupManagerDisableHeMuInSelector(StaId stationId, uint8 groupId);
extern bool  heGroupManagerStationAcPsTypesAreMixed(uint8 acPsTypeBitmap);
extern void  hegroupManager_SendConfirmToStationManager(StaId stationIndex);
extern void  heGroupManagerChangeGlobalState(HeGroupManagerGlobalState_e newState);
extern void  heGroupManager_SetBwConfiguration(Bw_e maxBw, HeGroupManagerCharacteristicsBitmap_u* chararcteristicsBitmap);

//---------------------------------------------------------------------------------
//						Global Variables Declaration				
//---------------------------------------------------------------------------------

extern HeGroupManager_GlobalParameters_t  heGroupManagerGlobalParameters;
extern HeGroupManager_StationDbEntry_t	  heGroupManagerStationDb[HW_NUM_OF_STATIONS];
extern HeGroupManager_BandParameters_t    heGroupManagerBandParameters[NUM_OF_CONFIGURATION_MANAGER_BANDS];
extern VapDbObject_t	                  VapDatabaseObj;

#endif /* HE_GROUP_MANAGER_H_ */

