/***********************************************************************************
 File:			HeGroupManagerClassifier.h
 Module:		HE Group Manager 
 Purpose: 		To create and delete HE MU groups
 Description:	This file contains all definitions and the structures of the HE group 
 				manager which is responsible of creating and deleting HE multi user 
 				groups
************************************************************************************/
#ifndef HE_GROUP_MANAGER_CLASSIFIER_H_
#define HE_GROUP_MANAGER_CLASSIFIER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Configuration.h"
#include "HeGroupManager_API.h"
#include "OSAL_Kmsg.h"
#include "linkAdaptation_api.h"
#include "HeGroupManager_API.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
	
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Function Decleration				
//---------------------------------------------------------------------------------

extern void heGroupManagerClassifier_CreateStationsCluster(uint8 vapId, HeGroupManagerCharacteristicsBitmap_u groupPolicyChar, StaId* itemsInCluster);
extern StaId heGroupManagerClassifier_GetStationFromCluster(void);
extern StaId heGroupManagerClassifier_GetNumberOfStaInCluster(void);
extern void heGroupManagerClassifier_RemoveStationFromGroup(StaId stationId, uint8 groupId);
extern void heGroupManagerClassifier_UpdateClassificationBitmapFromMetrics(void);
extern void heGroupManagerClassifier_AddSta(StaId stationIndex, UMI_STA_ADD *pAddStationMessageParameters);
extern bool heGroupManagerClassifierCharBitmapCmpr(HeGroupManagerCharacteristicsBitmap_u staCharacteristics, HeGroupManagerCharacteristicsBitmap_u groupCharacteristics);
extern void heGroupManagerClassifierGroupCreationCanceled(StaId staionslistFromCanceledGroup[HE_GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP]);
extern void heGroupManagerClassifier_SetStaAssocParamsFromLa(K_MSG* pMsg);
extern void heGroupManagerClassifier_SetAntennasConfiguration(uint8 maxNss, HeGroupManagerCharacteristicsBitmap_u* pStaChararcteristicsBitmap);
extern void heGroupManagerClassifier_RemoveStation(StaId stationId);
extern void heGroupManager_Classifier_Init(void);
#endif /* HE_GROUP_MANAGER_CLASSIFIER_H */

