/***************************************************************
 File:		HostGenRiscInterface_Api.h
 Module:	  	host gen risc interface
 Purpose: 	interface between the FW and the host genRisc
 Description:  This file is the API to the FW - host GenRisc interface module  
***************************************************************/
#ifndef HOST_GENRISC_INTERFACE_API_H_
#define HOST_GENRISC_INTERFACE_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HostInterface_API.h"
#include "HostInterface_MailboxApi.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
uint16 HostGenRisc_Halt(void);
void HostGenRisc_Initialize(UMI_DATA_PATH_INIT_PARAMS* pInitParams);
ISR_VOID isr_HostGenRisc(void);

#ifdef ENET_INC_ARCH_WAVE600
void HostGenRiscInterface_Mailbox_Push(FwHostGenRiscInterfaceMailboxFifoInMessage_t *message);
K_MSG *HostGenRiscInterface_Mailbox_Pop(void);
#else

#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
void HostInterfaceInterface_Mailbox0_Push(FwHostGenRiscInterfaceMailbox0FifoInMessage_t *message);
K_MSG *HostGenRiscInterface_Mailbox0_Pop(void);
#endif //FW_HOST_INTERFACE_MAILBOX_0_ENABLED

#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
void HostGenRiscInterface_Mailbox1_Push(FwHostGenRiscInterfaceMailbox1FifoInMessage_t *message);
K_MSG *HostGenRiscInterface_Mailbox1_Pop(void);
#endif //FW_HOST_INTERFACE_MAILBOX_1_ENABLED
#endif //ENET_INC_ARCH_WAVE600

#endif /* HOST_GENRISC_INTERFACE_API_H_ */


