/***************************************************************
 File:		SenderInterface.h
 Module:	  	Sender interface
 Purpose: 	holds the definions for the FW - sender interface module 
 Description:  This file contains the definions of the FW - sender interface module
***************************************************************/
#ifndef HOST_GENRISC_INTERFACE_H_
#define HOST_GENRISC_INTERFACE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HostInterface_InitApi.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define HOST_GENRISC_START_VALUE 1
#define HOST_GENRISC_HALT_VALUE 1
#define HOST_GENRISC_MAX_MICROSECONDS_FOR_INITIALIZATION 2500 
#define HOST_GENRISC_COMPLETED_CHI_MAGIC ((HOST_INTERFACE_INIT_FIELD_CHI_MAGIC_READY_VALUE_H << 16) | HOST_INTERFACE_INIT_FIELD_CHI_MAGIC_READY_VALUE_L)
#define HOST_GENRISC_INIT_NOT_VALID_INPUT_EXPECTED_VALUE ((HOST_INTERFACE_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_H << 16) | HOST_INTERFACE_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_L)


#define HOST_IF_ACC_TX_IN_HD_ACCUM_ADD                    0xDC
#define HOST_IF_ACC_TX_OUT_HD_ACCUM_SUB                   0xF4
#define HOST_IF_ACC_TX_IN_HD_ACCUM_COUNT                  0xFC
#define HOST_IF_ACC_TX_OUT_HD_ACCUM_COUNT                 0x104

#ifdef ENET_INC_ARCH_WAVE600
#define HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP	   ((TRUE	<<	HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_TX_IN_TASK_BIT)	|\
															(TRUE	<<	HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_TX_OUT_TASK_BIT)	|\
															(TRUE  <<  HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_RX_IN_TASK_BIT)	|\
															(TRUE	<<	HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_RX_OUT_TASK_BIT)	|\
															(TRUE	<<	HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_LOGGER_TASK_BIT))

#endif //ENET_INC_ARCH_WAVE600


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

#endif /* HOST_GENRISC_INTERFACE_H_ */

