/***************************************************************
 File:		HostGenRiscInterface.c
 Module:	  	host genRisc interface
 Purpose: 	holds all the implementation of the  FW - host genRisc interface module
 Description:  This module contains the implementation of the  FW - host genRisc interface
 			module
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "StaDb.h" //should be removed when the SHRAM files will be defined
#include "VapDb.h" //should be removed when the SHRAM files will be defined
#include "ieee80211.h" //should be removed when the SHRAM files will be defined
#include "Pac_Api.h" 
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HostGenRiscInterface.h"
#include "HostGenRiscInterface_Api.h"
#include "HostInterface_InitApi.h"
#include "MacGenriscRegs.h"
#include "ShramHostGenRisc.h"
#include "ShramGenRiscMailboxes.h"
#include "PacketDescriptor.h"
#include "HostInterface_API.h"
#include "HwQManager_API.h"
#include "enet_pas.h"
#include "shram_dataHostIf.h"
#include "ShramPacketDescriptors.h"
#include "Utils_Api.h"
#include "HwMemoryMap.h"
#include "ShramGenriscInitVectorStartAddr.h"
#include "ShramHim.h"
#ifdef CBM_FRAGMENTATION_WORKAROUND
#include "ShramHdAddrRing.h"
#endif //CBM_FRAGMENTATION_WORKAROUND
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_GENRISCS_INTERFACE
#define LOG_LOCAL_FID 0



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes(void);


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
FwHostGenRiscInterfaceMailbox0FifoInParams_t	*pFwHostGenRiscInterfaceMailbox0FifoInParams;
FwHostGenRiscInterfaceMailbox0FifoOutParams_t	*pFwHostGenRiscInterfaceMailbox0FifoOutParams;
FwHostGenRiscInterfaceMailbox1FifoInParams_t	*pFwHostGenRiscInterfaceMailbox1FifoInParams;
FwHostGenRiscInterfaceMailbox1FifoOutParams_t	*pFwHostGenRiscInterfaceMailbox1FifoOutParams;

uint32 AAA_eventIndex = 0;

/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/
#ifdef PUMA_DEBUG_DIRECT_CONNECT
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutReadyCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutReadyCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInFreedCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInFreedCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSizeBytes;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInHdSize;	
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingSizeBytes;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInHdSize;	
#endif

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

isr_HostGenRisc  


Description:
------------
interrupt routine that handles errors scenarions from the host genRisc 



Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
ISR_VOID isr_HostGenRisc(void)
{
#if defined (ENET_INC_UMAC)
	RegMacGenriscGenriscUpperIrqClr_u irqClearRegister;
	RegMacGenriscGenriscUpperIrqStatus_u irqStatusRegister;
#elif defined (ENET_INC_LMAC)
	RegMacGenriscGenriscLowerIrqClr_u irqClearRegister;
	RegMacGenriscGenriscLowerIrqStatus_u irqStatusRegister;
#endif
	uint32 eventIndex;
#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
	FwHostGenRiscInterfaceMailbox0FifoOutMessage_t *pBody0;
#endif //FW_HOST_INTERFACE_MAILBOX_0_ENABLED
#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	FwHostGenRiscInterfaceMailbox1FifoOutMessage_t *pBody1;
#endif //FW_HOST_INTERFACE_MAILBOX_1_ENABLED
#if defined FW_HOST_INTERFACE_MAILBOX_0_ENABLED || defined FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	uint32 idx;
	K_MSG *pMsg;
#endif

	irqClearRegister.val = 0;
	irqStatusRegister.val = 0;


#if defined (ENET_INC_UMAC)
	RegAccess_Read(REG_MAC_GENRISC_GENRISC_UPPER_IRQ_STATUS, &irqStatusRegister.val);

	eventIndex = Utils_CountTrailingZeros(irqStatusRegister.val);
	irqClearRegister.bitFields.genriscUpperIrqClr = (0x1 << eventIndex);

	RegAccess_Write(REG_MAC_GENRISC_GENRISC_UPPER_IRQ_CLR, irqClearRegister.val);
#elif defined (ENET_INC_LMAC)
	RegAccess_Read(REG_MAC_GENRISC_GENRISC_LOWER_IRQ_STATUS, &irqStatusRegister.val);

	eventIndex = Utils_CountTrailingZeros(irqStatusRegister.val);
	irqClearRegister.bitFields.genriscLowerIrqClr = (0x1 << eventIndex);

	RegAccess_Write(REG_MAC_GENRISC_GENRISC_LOWER_IRQ_CLR, irqClearRegister.val);
#else
#error "either umac or lmac must be defined"
#endif

	AAA_eventIndex = eventIndex;

	switch (eventIndex)
	{
	case HOST_INTERFACE_2_MIPS_INTERRUPTS_ERROR_START_BIT:
		DEBUG_FATAL("Host Interface 2 MIPS Error Start");
		break;
#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
	case HOST_INTERFACE_2_MIPS_INTERRUPTS_MAILBOX_0_FIFO_OUT_NOT_EMPTY_START_BIT:
		idx = 0;
		while (idx < FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES)
		{
			pMsg = HostGenRiscInterface_Mailbox0_Pop();
			if (pMsg)
			{
				pBody0 = (FwHostGenRiscInterfaceMailbox0FifoOutMessage_t *)pK_MSG_DATA(pMsg);

				//send message to designated task
				switch(pBody0->messageId)
				{
				default:
					DEBUG_FATAL("Unsupported Message ID");
				}
			}
			else
			{
				break;
			}
			idx++;
		}
		break;
#endif //FW_HOST_INTERFACE_MAILBOX_0_ENABLED
#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	case HOST_INTERFACE_2_MIPS_INTERRUPTS_MAILBOX_1_FIFO_OUT_NOT_EMPTY_START_BIT:
		idx = 0;
		while (idx < FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES)
		{
			pMsg = HostGenRiscInterface_Mailbox1_Pop();
			if (pMsg)
			{
				pBody1 = (FwHostGenRiscInterfaceMailbox1FifoOutMessage_t *)pK_MSG_DATA(pMsg);

				//send message to designated task
				switch(pBody1->messageId)
				{
				default:
					DEBUG_FATAL("Unsupported Message ID");
				}
			}
			else
			{
				break;
			}
			idx++;
		}
		break;
#endif //FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	default:
		DEBUG_FATAL("Host Interface 2 MIPS Unknown event");
	}
}


/**********************************************************************************

HostGenRisc_Halt  


Description:
------------
stop the host genRisc

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
   
uint16 HostGenRisc_Halt(void)
{	
	//RegMacGenriscStopOp_u haltRegister;
	RegMacGenriscLastPcExecuted_u lastPcExecuted;

	//haltRegister.val = 0;

	/* Stop the genrisc - currently we don't do it */
	//haltRegister.bitFields.stopOp = HOST_GENRISC_HALT_VALUE;
	//RegAccess_Write(REG_MAC_GENRISC_STOP_OP, haltRegister.val);

	/* Read last pc executed */
	RegAccess_Read(REG_MAC_GENRISC_LAST_PC_EXECUTED, &lastPcExecuted.val);

	return lastPcExecuted.bitFields.lastExecuted;
}


/**********************************************************************************

HostGenRisc_Initialize  


Description:
------------
fill the initizlization structre of the host genRisc and start the host genRisc

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void HostGenRisc_Initialize(UMI_DATA_PATH_INIT_PARAMS* pInitParams)
{
	RegMacGenriscStartOp_u startRegister;
    uint32 timeStamp = 0;
	HostIfDataPathHdSize_t *hostIfDataHdSize;
	HostGenRiscInterfaceParams_t *pHostGenRiscInitializationStructure;

	hostIfDataHdSize = HostInterfaceRings_GetHdSizes((DataPathMode_e)pInitParams->dataPathMode);

	hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes();

	pHostGenRiscInitializationStructure = (HostGenRiscInterfaceParams_t *)CONVERT_TO_PHYSICAL_ADDR(&HostGenRiscInitializationStructure); 
	GenriscsInitVectorStartAddr.hostInterfaceInitVectorPtr = (uint32)pHostGenRiscInitializationStructure; 

	startRegister.val = 0;
	memset((void*)&HostGenRiscInitializationStructure, 0, sizeof(HostGenRiscInterfaceParams_t));

	HostGenRiscInitializationStructure.enabledTasksBitmapDefault = HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP;
#ifdef CBM_FRAGMENTATION_WORKAROUND
	HostGenRiscInitializationStructure.enabledTasksBitmapDefault |= ((pInitParams->cbmFragmentationWaEnable) << HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_CBM_FRAGMENTATION_WA_FLAG_BIT);
#endif //CBM_FRAGMENTATION_WORKAROUND
	HostGenRiscInitializationStructure.txInBufferSizeInBytes = TX_IN_BUFFER_SIZE;
	HostGenRiscInitializationStructure.txInBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.TxInShramBuffers[0][0]);// DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txInRingSize = (pInitParams->txInRingSizeBytes/ hostIfDataHdSize->txInHdSize); // HDS
	HostGenRiscInitializationStructure.txInRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txInRingStartAddress); // DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txOutBufferSizeInBytes = TX_OUT_BUFFER_SIZE;
	HostGenRiscInitializationStructure.txOutBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.TxOutShramBuffers[0][0]);// DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txOutRingSize = (pInitParams->txOutRingSizeBytes / hostIfDataHdSize->txOutHdSize); // HDS
	HostGenRiscInitializationStructure.txOutRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txOutRingStartAddress ); // DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.rxInBufferSizeInBytes = RX_IN_BUFFER_SIZE;
    HostGenRiscInitializationStructure.rxInBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.RxInShramBuffers[0][0]);// DMA ADDRESS SPACE
	if ((DataPathMode_e)pInitParams->dataPathMode != DATA_PATH_MODE_DC_MODE_0)
	{
		HostGenRiscInitializationStructure.rxInRingSize = (pInitParams->rxInRingSizeBytes /hostIfDataHdSize->rxInHdSize); // HDS
	}
    HostGenRiscInitializationStructure.rxInRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxInRingStartAddress); // DMA ADDRESS SPACE
    HostGenRiscInitializationStructure.rxOutBufferSizeInBytes = RX_OUT_BUFFER_SIZE;
    HostGenRiscInitializationStructure.rxOutBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.RxOutShramBuffers[0][0]);// DMA ADDRESS SPACE
    HostGenRiscInitializationStructure.rxOutRingSize = (pInitParams->rxOutRingSizeBytes / hostIfDataHdSize->rxOutHdSize); // HDS
    HostGenRiscInitializationStructure.rxOutRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxOutRingStartAddress); // DMA ADDRESS SPACE	
	HostGenRiscInitializationStructure.loggerBufferListIndex = HW_Q_MANAGER_TX_POOL_LIST_LOGGER_FREE_BD;// Free LoggerBDs
	HostGenRiscInitializationStructure.loggerRdsPendingListIndex = HW_Q_MANAGER_RX_DONE_LIST_LOGGER;  //RX READY list 
	HostGenRiscInitializationStructure.loggerRdsPoolbaseAddress = CONVERT_TO_PHYSICAL_ADDR(PacketDescriptorsPtr);
	HostGenRiscInitializationStructure.rxRdsProcessingListIndex = HW_Q_MANAGER_RX_HOST_INTERFACE_TEMP_LIST;
	HostGenRiscInitializationStructure.rxLiberatorListIndex =HW_Q_MANAGER_RX_LIBERATOR_INPUT_LIST; 
	HostGenRiscInitializationStructure.loggerRdsProcessingListIndex =  HW_Q_MANAGER_RX_PENDING_LOGGER_RDS_LIST; // internal hostIf list    
	HostGenRiscInitializationStructure.rxOutListIndex = HW_Q_MANAGER_RX_DONE_LIST_HOST_INTERFACE_ACCELERATOR_INPUT;	
	HostGenRiscInitializationStructure.wlanInterface = 0; /* TBD add API to get wlan IF*/
	HostGenRiscInitializationStructure.loggerStream = 0;  /* TBD - Mechanism to chengae logger stream */
	HostGenRiscInitializationStructure.loggerQueueId= SID_FOR_LOGGER_RX_DATA << 0x3;	// TBD - use definition to shift the sid to proper location in queue id
	HostGenRiscInitializationStructure.loggerActiveMode = (uint32)&loggerActiveMode;	// indicate to HIM about the logger active mode

#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
	HostGenRiscInitializationStructure.mailbox0_FifoInStructStartAddress = CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailbox0FifoInParams);
	HostGenRiscInitializationStructure.mailbox0_FifoInNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES;
	HostGenRiscInitializationStructure.mailbox0_FifoOutStructStartAddress = CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailbox0FifoOutParams);
	HostGenRiscInitializationStructure.mailbox0_FifoOutNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES;
#else
	HostGenRiscInitializationStructure.mailbox0_FifoInStructStartAddress = HOST_GENRISC_INIT_NOT_VALID_INPUT_EXPECTED_VALUE;
	HostGenRiscInitializationStructure.mailbox0_FifoInNumOfEntries = 0;
	HostGenRiscInitializationStructure.mailbox0_FifoOutStructStartAddress = HOST_GENRISC_INIT_NOT_VALID_INPUT_EXPECTED_VALUE;
	HostGenRiscInitializationStructure.mailbox0_FifoOutNumOfEntries = 0;
#endif
#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	HostGenRiscInitializationStructure.mailbox1_FifoInStructStartAddress =  CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailbox1FifoInParams);
	HostGenRiscInitializationStructure.mailbox1_FifoInNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES;
	HostGenRiscInitializationStructure.mailbox1_FifoOutStructStartAddress = CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailbox1FifoOutParams);
	HostGenRiscInitializationStructure.mailbox1_FifoOutNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES;
#else
	HostGenRiscInitializationStructure.mailbox1_FifoInStructStartAddress =  HOST_GENRISC_INIT_NOT_VALID_INPUT_EXPECTED_VALUE;
	HostGenRiscInitializationStructure.mailbox1_FifoInNumOfEntries = 0;
	HostGenRiscInitializationStructure.mailbox1_FifoOutStructStartAddress = HOST_GENRISC_INIT_NOT_VALID_INPUT_EXPECTED_VALUE;
	HostGenRiscInitializationStructure.mailbox1_FifoOutNumOfEntries = 0;
#endif

	/* Store TX Out Ring HD Ready counter */
	HostGenRiscInitializationStructure.txOutReadyCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txOutReadyCounterAddress);

	/* Store RX Out Ring HD Ready counter */
	HostGenRiscInitializationStructure.rxOutReadyCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxOutReadyCounterAddress);

	/* Store TX In Ring HD Freed counter */
	HostGenRiscInitializationStructure.txInFreedCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txInFreedCounterAddress);

	/* Store RX In Ring HD Freed counter */
	HostGenRiscInitializationStructure.rxInFreedCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxInFreedCounterAddress);

#ifdef CBM_FRAGMENTATION_WORKAROUND
	/*Initialize Rx Out Hd Addr Ring for CBM W/A*/
	HostGenRiscInitializationStructure.rxOutHdAddrRingStartAddress = CONVERT_TO_PHYSICAL_ADDR(HdAddrRing);			/* Rx out HDs Address ring for CBM Fragmentation W/A only	*/	
	HostGenRiscInitializationStructure.rxOutHdAddrRingNumOfEntries = HD_ADDR_RING_NUM_OF_ENTRIES; 					/* Num Of HDs in Rx out HDs Address ring - for CBM Fragmentation W/A only	*/
#endif //CBM_FRAGMENTATION_WORKAROUND


#ifdef PUMA_DEBUG_DIRECT_CONNECT
	/* debug start */
	AAA_PUMA_HostGenRiscInterfaceParams_txInRingSize = HostGenRiscInitializationStructure.txInRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_txInRingStartAddress = HostGenRiscInitializationStructure.txInRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_txOutRingSize = HostGenRiscInitializationStructure.txOutRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_txOutRingStartAddress = HostGenRiscInitializationStructure.txOutRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSize = HostGenRiscInitializationStructure.rxInRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingStartAddress = HostGenRiscInitializationStructure.rxInRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingSize = HostGenRiscInitializationStructure.rxOutRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingStartAddress = HostGenRiscInitializationStructure.rxOutRingStartAddress;
	
	AAA_PUMA_HostGenRiscInterfaceParams_txOutReadyCounterAddress = HostGenRiscInitializationStructure.txOutReadyCounterAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutReadyCounterAddress = HostGenRiscInitializationStructure.rxOutReadyCounterAddress;

	AAA_PUMA_HostGenRiscInterfaceParams_txInFreedCounterAddress = HostGenRiscInitializationStructure.txInFreedCounterAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInFreedCounterAddress = HostGenRiscInitializationStructure.rxInFreedCounterAddress;

	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSizeBytes = pInitParams->rxInRingSizeBytes;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInHdSize = hostIfDataHdSize->rxInHdSize;	

	AAA_PUMA_HostGenRiscInterfaceParams_txInRingSizeBytes = pInitParams->txInRingSizeBytes;
	AAA_PUMA_HostGenRiscInterfaceParams_txInHdSize = hostIfDataHdSize->txInHdSize;	

	/* debug end */
#endif

	ErrorHandlerEnableModuleHalt(HALT_MODULE_HOST_IF_GENRISC);

	/* Start the genrisc */
	startRegister.bitFields.startOp = HOST_GENRISC_START_VALUE;
	RegAccess_Write(REG_MAC_GENRISC_START_OP, startRegister.val);

	timeStamp = GET_TSF_TIMER_LOW();
	while(HOST_GENRISC_COMPLETED_CHI_MAGIC != HostGenRiscInitializationStructure.chiMagic)
	{
		ASSERT((GET_TSF_TIMER_LOW() - timeStamp) <= HOST_GENRISC_MAX_MICROSECONDS_FOR_INITIALIZATION); 
	}
}

static void hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes(void)
{
#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
	memset(&FwHostGenRiscInterfaceMailbox0FifoInBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailbox0FifoInBuffer));
	memset(&FwHostGenRiscInterfaceMailbox0FifoOutBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailbox0FifoOutBuffer));
	pFwHostGenRiscInterfaceMailbox0FifoInParams = (FwHostGenRiscInterfaceMailbox0FifoInParams_t *)(&FwHostGenRiscInterfaceMailbox0FifoInBuffer);
	pFwHostGenRiscInterfaceMailbox0FifoOutParams = (FwHostGenRiscInterfaceMailbox0FifoOutParams_t *)(&FwHostGenRiscInterfaceMailbox0FifoOutBuffer);
#endif

#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
	memset(&FwHostGenRiscInterfaceMailbox1FifoInBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailbox1FifoInBuffer));
	memset(&FwHostGenRiscInterfaceMailbox1FifoOutBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailbox1FifoOutBuffer));
	pFwHostGenRiscInterfaceMailbox1FifoInParams = (FwHostGenRiscInterfaceMailbox1FifoInParams_t *)(&FwHostGenRiscInterfaceMailbox1FifoInBuffer);
	pFwHostGenRiscInterfaceMailbox1FifoOutParams = (FwHostGenRiscInterfaceMailbox1FifoOutParams_t *)(&FwHostGenRiscInterfaceMailbox1FifoOutBuffer);
#endif
}

#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
void HostInterfaceInterface_Mailbox0_Push(FwHostGenRiscInterfaceMailbox0FifoInMessage_t *message)
{
	RegMacGenriscMips2GenriscIrqSet_u irqSetRegister;
	TX_INTERRUPT_SAVE_AREA;

	irqSetRegister.val = 0;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	DEBUG_ASSERT((pFwHostGenRiscInterfaceMailbox0FifoInParams->writeCounter - pFwHostGenRiscInterfaceMailbox0FifoInParams->readCounter) < FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES);

	memcpy32(&(pFwHostGenRiscInterfaceMailbox0FifoInParams->messageArray[(pFwHostGenRiscInterfaceMailbox0FifoInParams->writeCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_FIFO_NUMBER_OF_ENTRIES)]), 
		message, 
		(sizeof(FwHostGenRiscInterfaceMailbox0FifoInMessage_t) >> 0x2));

	pFwHostGenRiscInterfaceMailbox0FifoInParams->writeCounter++;

	/* set interrupt to genrisc */
	irqSetRegister.bitFields.mips2GenriscIrqSet = (TRUE << 0x0); //bit 0 for mailbox 0
	RegAccess_Write(REG_MAC_GENRISC_MIPS2GENRISC_IRQ_SET, irqSetRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

K_MSG *HostGenRiscInterface_Mailbox0_Pop(void)
{
	TX_INTERRUPT_SAVE_AREA;
	K_MSG *pMsg = NULL;
	FwHostGenRiscInterfaceMailbox0FifoOutMessage_t *pBody;

	if (pFwHostGenRiscInterfaceMailbox0FifoOutParams->readCounter != pFwHostGenRiscInterfaceMailbox0FifoOutParams->writeCounter)
	{
		pMsg = OSAL_GET_MESSAGE(sizeof(FwHostGenRiscInterfaceMailbox0FifoOutMessage_t));
		pBody = (FwHostGenRiscInterfaceMailbox0FifoOutMessage_t *)pK_MSG_DATA(pMsg);

		memcpy32(pBody,
			&(pFwHostGenRiscInterfaceMailbox0FifoOutParams->messageArray[(pFwHostGenRiscInterfaceMailbox0FifoOutParams->readCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_FIFO_NUMBER_OF_ENTRIES)]),
			(sizeof(FwHostGenRiscInterfaceMailbox0FifoOutMessage_t) >> 0x2));

		OSAL_DISABLE_INTERRUPTS(&interrupt_save);

		pFwHostGenRiscInterfaceMailbox0FifoOutParams->readCounter++;

		OSAL_ENABLE_INTERRUPTS(interrupt_save);
	}
	
	return pMsg;
}
#endif //FW_HOST_INTERFACE_MAILBOX_0_ENABLED

#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
void HostGenRiscInterface_Mailbox1_Push(FwHostGenRiscInterfaceMailbox1FifoInMessage_t *message)
{
	RegMacGenriscMips2GenriscIrqSet_u irqSetRegister;
	TX_INTERRUPT_SAVE_AREA;

	irqSetRegister.val = 0;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	DEBUG_ASSERT((pFwHostGenRiscInterfaceMailbox1FifoInParams->writeCounter - pFwHostGenRiscInterfaceMailbox1FifoInParams->readCounter) < FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES);

	memcpy32(&(pFwHostGenRiscInterfaceMailbox1FifoInParams->messageArray[(pFwHostGenRiscInterfaceMailbox1FifoInParams->writeCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_FIFO_NUMBER_OF_ENTRIES)]), 
		message, 
		(sizeof(FwHostGenRiscInterfaceMailbox1FifoInMessage_t) >> 0x2));

	pFwHostGenRiscInterfaceMailbox1FifoInParams->writeCounter++;

	/* set interrupt to genrisc */
	irqSetRegister.bitFields.mips2GenriscIrqSet = (TRUE << 0x1); //bit 1 for mailbox 1
	RegAccess_Write(REG_MAC_GENRISC_MIPS2GENRISC_IRQ_SET, irqSetRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

K_MSG *HostGenRiscInterface_Mailbox1_Pop(void)
{
	TX_INTERRUPT_SAVE_AREA;
	K_MSG *pMsg = NULL;
	FwHostGenRiscInterfaceMailbox1FifoOutMessage_t *pBody;

	if (pFwHostGenRiscInterfaceMailbox1FifoOutParams->readCounter != pFwHostGenRiscInterfaceMailbox1FifoOutParams->writeCounter)
	{
		pMsg = OSAL_GET_MESSAGE(sizeof(FwHostGenRiscInterfaceMailbox1FifoOutMessage_t));
		pBody = (FwHostGenRiscInterfaceMailbox1FifoOutMessage_t *)pK_MSG_DATA(pMsg);

		memcpy32(pBody,
			&(pFwHostGenRiscInterfaceMailbox1FifoOutParams->messageArray[(pFwHostGenRiscInterfaceMailbox1FifoOutParams->readCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_FIFO_NUMBER_OF_ENTRIES)]),
			(sizeof(FwHostGenRiscInterfaceMailbox1FifoOutMessage_t) >> 0x2));

		OSAL_DISABLE_INTERRUPTS(&interrupt_save);

		pFwHostGenRiscInterfaceMailbox1FifoOutParams->readCounter++;

		OSAL_ENABLE_INTERRUPTS(interrupt_save);
	}

	return pMsg;
}
#endif //FW_HOST_INTERFACE_MAILBOX_1_ENABLED




