/***************************************************************
 File:		HostGenRiscInterface.c
 Module:	  	host genRisc interface
 Purpose: 	holds all the implementation of the  FW - host genRisc interface module
 Description:  This module contains the implementation of the  FW - host genRisc interface
 			module
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "StaDb.h" //should be removed when the SHRAM files will be defined
#include "VapDb.h" //should be removed when the SHRAM files will be defined
#include "ieee80211.h" //should be removed when the SHRAM files will be defined
#include "Pac_Api.h" 
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HostGenRiscInterface.h"
#include "HostGenRiscInterface_Api.h"
#include "HostInterface_InitApi.h"
#include "MacGenriscRegs.h"
#include "ShramHostGenRisc.h"
#include "ShramGenRiscMailboxes.h"
#include "PacketDescriptor.h"
#include "HostInterface_API.h"
#include "HwQManager_API.h"
#include "enet_pas.h"
#include "shram_dataHostIf.h"
#include "ShramPacketDescriptors.h"
#include "Utils_Api.h"
#include "HwMemoryMap.h"
#include "ShramGenriscInitVectorStartAddr.h"
#include "um_interface.h"
#include "HostInterface_ScratchPadApi.h"
#ifdef CBM_FRAGMENTATION_WORKAROUND
#include "ShramHdAddrRing.h"
#endif //CBM_FRAGMENTATION_WORKAROUND
#include "HostIfGenriscInitVector_Descriptors.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_GENRISCS_INTERFACE
#define LOG_LOCAL_FID 5



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes(void);


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
FwHostGenRiscInterfaceMailboxFifoInParams_t	*pFwHostGenRiscInterfaceMailboxFifoInParams;
FwHostGenRiscInterfaceMailboxFifoOutParams_t *pFwHostGenRiscInterfaceMailboxFifoOutParams;


/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/
#ifdef PUMA_DEBUG_DIRECT_CONNECT
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingSize;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingStartAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txOutReadyCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxOutReadyCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInFreedCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInFreedCounterAddress;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSizeBytes;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_rxInHdSize;	
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInRingSizeBytes;
uint32 AAA_PUMA_HostGenRiscInterfaceParams_txInHdSize;	
#endif

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

isr_HostGenRisc  


Description:
------------
interrupt routine that handles errors scenarions from the host genRisc 



Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
uint32 AAA_eventIndex = 0;
uint32 AAA_RISC_ABORT_REG =0;
ISR_VOID isr_HostGenRisc(void)
{
	RegMacGenriscGenriscUpperIrqClr_u irqClearRegister;
	RegMacGenriscGenriscUpperIrqStatus_u irqStatusRegister;
	uint32 eventIndex;
	FwHostGenRiscInterfaceMailboxFifoOutMessage_t *pBody1;
	uint32 idx;
	K_MSG *pMsg;

	irqClearRegister.val = 0;
	irqStatusRegister.val = 0;


	RegAccess_Read(REG_MAC_GENRISC_GENRISC_UPPER_IRQ_STATUS, &irqStatusRegister.val);

	eventIndex = Utils_CountTrailingZeros(irqStatusRegister.val);
	irqClearRegister.bitFields.genriscUpperIrqClr = (0x1 << eventIndex);

	RegAccess_Write(REG_MAC_GENRISC_GENRISC_UPPER_IRQ_CLR, irqClearRegister.val);

	AAA_eventIndex = eventIndex;

	switch (eventIndex)
	{
	case HOST_INTERFACE_2_MIPS_INTERRUPTS_ERROR_START_BIT:
		RegAccess_Read(0xA0279098, &AAA_RISC_ABORT_REG);
		DEBUG_FATAL("Host Interface 2 MIPS Error Start");
		break;
	case HOST_INTERFACE_2_MIPS_INTERRUPTS_MAILBOX_FIFO_OUT_NOT_EMPTY_START_BIT:
		idx = 0;
		while (idx < FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES)
		{
			pMsg = HostGenRiscInterface_Mailbox_Pop();
			if (pMsg)
			{
				pBody1 = (FwHostGenRiscInterfaceMailboxFifoOutMessage_t *)pK_MSG_DATA(pMsg);

				//send message to designated task
				switch(pBody1->messageId)
				{
				default:
					DEBUG_FATAL("Unsupported Message ID");
				}
			}
			else
			{
				break;
			}
			idx++;
		}
		break;
	default:
		DEBUG_FATAL("Host Interface 2 MIPS Unknown event");
	}
}


/**********************************************************************************

HostGenRisc_Halt  


Description:
------------
stop the host genRisc

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
   
uint16 HostGenRisc_Halt(void)
{	
	//RegMacGenriscStopOp_u haltRegister;
	RegMacGenriscLastPcExecuted_u lastPcExecuted;

	//haltRegister.val = 0;

	/* Stop the genrisc - currently we don't do it */
	//haltRegister.bitFields.stopOp = HOST_GENRISC_HALT_VALUE;
	//RegAccess_Write(REG_MAC_GENRISC_STOP_OP, haltRegister.val);

	/* Read last pc executed */
	RegAccess_Read(REG_MAC_GENRISC_LAST_PC_EXECUTED, &lastPcExecuted.val);

	return lastPcExecuted.bitFields.lastExecuted;
}


/**********************************************************************************

HostGenRisc_Initialize  


Description:
------------
fill the initizlization structre of the host genRisc and start the host genRisc

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void HostGenRisc_Initialize(UMI_DATA_PATH_INIT_PARAMS* pInitParams)
{
	RegMacGenriscStartOp_u startRegister;
    uint32 timeStamp = 0;
	HostIfDataPathHdSize_t *hostIfDataHdSize;
	HostIfGenriscInitVector_t *pHostGenRiscInitializationStructure;
	Rd_t tempRd;
	RegMacGenriscAbortCntLimit_u abortCntLimitReg;
	
	tempRd.word2 = 0;
	tempRd.rxQueueStaId = LoggerApi_GetLoggerStationIndex();

	hostIfDataHdSize = HostInterfaceRings_GetHdSizes((DataPathMode_e)pInitParams->dataPathMode);

	hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes();

	pHostGenRiscInitializationStructure = (HostIfGenriscInitVector_t *)CONVERT_TO_PHYSICAL_ADDR(&HostGenRiscInitializationStructure); 
	GenriscsInitVectorStartAddr.hostInterfaceInitVectorPtr = (uint32)pHostGenRiscInitializationStructure; 

	startRegister.val = 0;
	abortCntLimitReg.val = 0;
	memset((void*)&HostGenRiscInitializationStructure, 0, sizeof(HostIfGenriscInitVector_t));

	HostGenRiscInitializationStructure.enabledTasksBitmapDefault = HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP;
#ifdef CBM_FRAGMENTATION_WORKAROUND
	HostGenRiscInitializationStructure.enabledTasksBitmapDefault |= ((pInitParams->cbmFragmentationWaEnable) << HOST_INTERFACE_INIT_FIELD_ENABLED_TASKS_BITMAP_CBM_FRAGMENTATION_WA_FLAG_BIT);
#endif //CBM_FRAGMENTATION_WORKAROUND
	HostGenRiscInitializationStructure.txInBufferSizeInBytes = TX_IN_BUFFER_SIZE;
	HostGenRiscInitializationStructure.txInBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.TxInShramBuffers[0][0]);// DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txInRingSize = (pInitParams->txInRingSizeBytes/ hostIfDataHdSize->txInHdSize); // HDS
	HostGenRiscInitializationStructure.txInRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txInRingStartAddress); // DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txOutBufferSizeInBytes = TX_OUT_BUFFER_SIZE;
	HostGenRiscInitializationStructure.txOutBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.TxOutShramBuffers[0][0]);// DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.txOutRingSize = (pInitParams->txOutRingSizeBytes / hostIfDataHdSize->txOutHdSize); // HDS
	HostGenRiscInitializationStructure.txOutRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txOutRingStartAddress ); // DMA ADDRESS SPACE
	HostGenRiscInitializationStructure.rxInBufferSizeInBytes = RX_IN_BUFFER_SIZE;
    HostGenRiscInitializationStructure.rxInBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.RxInShramBuffers[0][0]);// DMA ADDRESS SPACE
    HostGenRiscInitializationStructure.rxInRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxInRingStartAddress); // DMA ADDRESS SPACE
    HostGenRiscInitializationStructure.rxOutBufferSizeInBytes = RX_OUT_BUFFER_SIZE;
    HostGenRiscInitializationStructure.rxOutBufferStartAddress = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR((uint32)&ShramHostIfDb.RxOutShramBuffers[0][0]);// DMA ADDRESS SPACE
    HostGenRiscInitializationStructure.rxOutRingSize = (pInitParams->rxOutRingSizeBytes / hostIfDataHdSize->rxOutHdSize); // HDS
    HostGenRiscInitializationStructure.rxOutRingStartAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxOutRingStartAddress); // DMA ADDRESS SPACE	
	HostGenRiscInitializationStructure.loggerBufferListIndex = HW_Q_MANAGER_TX_POOL_LIST_LOGGER_FREE_BD;// Free LoggerBDs
	HostGenRiscInitializationStructure.loggerRdsPendingListIndex = HW_Q_MANAGER_RX_DONE_LIST_LOGGER;  //RX READY list 
	HostGenRiscInitializationStructure.loggerRdsPoolBaseAddress = CONVERT_TO_PHYSICAL_ADDR(PacketDescriptorsPtr);
	HostGenRiscInitializationStructure.rxRdsProcessingListIndex = HW_Q_MANAGER_RX_HOST_INTERFACE_TEMP_LIST;
	HostGenRiscInitializationStructure.rxLiberatorListIndex =HW_Q_MANAGER_RX_LIBERATOR_INPUT_LIST; 
	HostGenRiscInitializationStructure.loggerRdsProcessingListIndex =  HW_Q_MANAGER_RX_PENDING_LOGGER_RDS_LIST; // internal hostIf list    
	HostGenRiscInitializationStructure.rxOutListIndex = HW_Q_MANAGER_RX_DONE_LIST_HOST_INTERFACE_ACCELERATOR_INPUT;	
	HostGenRiscInitializationStructure.wlanInterface = 0; /* TBD add API to get wlan IF*/
	HostGenRiscInitializationStructure.loggerStream = 0;  /* TBD - Mechanism to chengae logger stream */
	HostGenRiscInitializationStructure.loggerActiveMode = (uint32)&loggerActiveMode;	// indicate to HIM about the logger active mode
	HostGenRiscInitializationStructure.badPointerRdListIdx = HW_Q_MANAGER_RX_READY_LIST_BAD_PTR_RDS;
	DEBUG_ASSERT(LoggerApi_GetLoggerStationIndex() != INVALID_LOGGER_SID); 
	HostGenRiscInitializationStructure.loggerQueueId= tempRd.word2;
	HostGenRiscInitializationStructure.mailboxFifoInStructStartAddress =  CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailboxFifoInParams);
	HostGenRiscInitializationStructure.mailboxFifoInNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES;
	HostGenRiscInitializationStructure.mailboxFifoOutStructStartAddress = CONVERT_TO_PHYSICAL_ADDR(pFwHostGenRiscInterfaceMailboxFifoOutParams);
	HostGenRiscInitializationStructure.mailboxFifoOutNumOfEntries = FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES;

	if (((DataPathMode_e)pInitParams->dataPathMode != DATA_PATH_MODE_DC_MODE_0) && ((DataPathMode_e)pInitParams->dataPathMode != DATA_PATH_MODE_DC_MODE_3))
	{
		HostGenRiscInitializationStructure.rxInRingSize = (pInitParams->rxInRingSizeBytes /hostIfDataHdSize->rxInHdSize); // HDS
		HostGenRiscInitializationStructure.maxHostRdNum = pInitParams->numOfAllocatedRxHds;
	}
	else
	{		
		HostGenRiscInitializationStructure.maxHostRdNum = NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS;
	}

	/* Store TX Out Ring HD Ready counter */
	HostGenRiscInitializationStructure.txOutReadyCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txOutReadyCounterAddress);

	/* Store RX Out Ring HD Ready counter */
	HostGenRiscInitializationStructure.rxOutReadyCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxOutReadyCounterAddress);

	/* Store TX In Ring HD Freed counter */
	HostGenRiscInitializationStructure.txInFreedCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->txInFreedCounterAddress);

	/* Store RX In Ring HD Freed counter */
	HostGenRiscInitializationStructure.rxInFreedCounterAddress = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pInitParams->rxInFreedCounterAddress);

#ifdef CBM_FRAGMENTATION_WORKAROUND
	HostGenRiscInitializationStructure.rxOutHdAddressRing = CONVERT_TO_PHYSICAL_ADDR(HdAddrRing);			/* Rx out HDs Address ring for CBM Fragmentation W/A only	*/	
	HostGenRiscInitializationStructure.rxOutHdAddressRingNumOfEntries = HD_ADDR_RING_NUM_OF_ENTRIES; 		/* Num Of HDs in Rx out HDs Address ring - for CBM Fragmentation W/A only	*/
#endif //CBM_FRAGMENTATION_WORKAROUND

#ifdef HOST_IF_COUNTERS_WORKAROUND
	HostGenRiscInitializationStructure.dualBand = ConfigurationManager_GetBandConfigurationMode();
#endif // HOST_IF_COUNTERS_WORKAROUND

#ifdef PUMA_DEBUG_DIRECT_CONNECT
	/* debug start */
	AAA_PUMA_HostGenRiscInterfaceParams_txInRingSize = HostGenRiscInitializationStructure.txInRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_txInRingStartAddress = HostGenRiscInitializationStructure.txInRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_txOutRingSize = HostGenRiscInitializationStructure.txOutRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_txOutRingStartAddress = HostGenRiscInitializationStructure.txOutRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSize = HostGenRiscInitializationStructure.rxInRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingStartAddress = HostGenRiscInitializationStructure.rxInRingStartAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingSize = HostGenRiscInitializationStructure.rxOutRingSize;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutRingStartAddress = HostGenRiscInitializationStructure.rxOutRingStartAddress;
	
	AAA_PUMA_HostGenRiscInterfaceParams_txOutReadyCounterAddress = HostGenRiscInitializationStructure.txOutReadyCounterAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxOutReadyCounterAddress = HostGenRiscInitializationStructure.rxOutReadyCounterAddress;

	AAA_PUMA_HostGenRiscInterfaceParams_txInFreedCounterAddress = HostGenRiscInitializationStructure.txInFreedCounterAddress;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInFreedCounterAddress = HostGenRiscInitializationStructure.rxInFreedCounterAddress;

	AAA_PUMA_HostGenRiscInterfaceParams_rxInRingSizeBytes = pInitParams->rxInRingSizeBytes;
	AAA_PUMA_HostGenRiscInterfaceParams_rxInHdSize = hostIfDataHdSize->rxInHdSize;	

	AAA_PUMA_HostGenRiscInterfaceParams_txInRingSizeBytes = pInitParams->txInRingSizeBytes;
	AAA_PUMA_HostGenRiscInterfaceParams_txInHdSize = hostIfDataHdSize->txInHdSize;	

	/* debug end */
#endif

	/*We MUST enable this module HALT since it is part of the mechanism which freeing allocatd buffers after 
	assert and it is assumed that before filling the driver error message there is no more activity in
	the host interface genrisc which could influence the data free Pd Pool */
	ErrorHandlerEnableModuleHalt(HALT_MODULE_HOST_IF_GENRISC);

	abortCntLimitReg.bitFields.abortCntLimit = 0xFFFF;
	RegAccess_Write(REG_MAC_GENRISC_ABORT_CNT_LIMIT, abortCntLimitReg.val);


	/* Start the genrisc */
	startRegister.bitFields.startOp = HOST_GENRISC_START_VALUE;
	RegAccess_Write(REG_MAC_GENRISC_START_OP, startRegister.val);

	timeStamp = GET_TSF_TIMER_LOW();
	while(HOST_GENRISC_COMPLETED_CHI_MAGIC != HostGenRiscInitializationStructure.chiMagic)
	{
		ASSERT((GET_TSF_TIMER_LOW() - timeStamp) <= HOST_GENRISC_MAX_MICROSECONDS_FOR_INITIALIZATION); 
	}
}

static void hostGenriscInterface_InitFwHostGenRiscInterfaceMailboxes(void)
{
	memset(&FwHostGenRiscInterfaceMailboxFifoInBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailboxFifoInBuffer));
	memset(&FwHostGenRiscInterfaceMailboxFifoOutBuffer, 0x0, sizeof(FwHostGenRiscInterfaceMailboxFifoOutBuffer));
	pFwHostGenRiscInterfaceMailboxFifoInParams = (FwHostGenRiscInterfaceMailboxFifoInParams_t *)(&FwHostGenRiscInterfaceMailboxFifoInBuffer);
	pFwHostGenRiscInterfaceMailboxFifoOutParams = (FwHostGenRiscInterfaceMailboxFifoOutParams_t *)(&FwHostGenRiscInterfaceMailboxFifoOutBuffer);
}


void HostGenRiscInterface_Mailbox_Push(FwHostGenRiscInterfaceMailboxFifoInMessage_t *message)
{
	RegMacGenriscMips2GenriscIrqSet_u irqSetRegister;
	TX_INTERRUPT_SAVE_AREA;

	irqSetRegister.val = 0;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	DEBUG_ASSERT((pFwHostGenRiscInterfaceMailboxFifoInParams->writeCounter - pFwHostGenRiscInterfaceMailboxFifoInParams->readCounter) < FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES);

	memcpy32(&(pFwHostGenRiscInterfaceMailboxFifoInParams->messageArray[(pFwHostGenRiscInterfaceMailboxFifoInParams->writeCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_FIFO_NUMBER_OF_ENTRIES)]), 
		message, 
		(sizeof(FwHostGenRiscInterfaceMailboxFifoInMessage_t) >> 0x2));

	pFwHostGenRiscInterfaceMailboxFifoInParams->writeCounter++;

	/* set interrupt to genrisc */
	irqSetRegister.bitFields.mips2GenriscIrqSet = (TRUE << 0x1); //bit 1 for mailbox 1
	RegAccess_Write(REG_MAC_GENRISC_MIPS2GENRISC_IRQ_SET, irqSetRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

K_MSG *HostGenRiscInterface_Mailbox_Pop(void)
{
	TX_INTERRUPT_SAVE_AREA;
	K_MSG *pMsg = NULL;
	FwHostGenRiscInterfaceMailboxFifoOutMessage_t *pBody;

	if (pFwHostGenRiscInterfaceMailboxFifoOutParams->readCounter != pFwHostGenRiscInterfaceMailboxFifoOutParams->writeCounter)
	{
		pMsg = OSAL_GET_MESSAGE(sizeof(FwHostGenRiscInterfaceMailboxFifoOutMessage_t));
		pBody = (FwHostGenRiscInterfaceMailboxFifoOutMessage_t *)pK_MSG_DATA(pMsg);

		memcpy32(pBody,
			&(pFwHostGenRiscInterfaceMailboxFifoOutParams->messageArray[(pFwHostGenRiscInterfaceMailboxFifoOutParams->readCounter % FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_FIFO_NUMBER_OF_ENTRIES)]),
			(sizeof(FwHostGenRiscInterfaceMailboxFifoOutMessage_t) >> 0x2));

		OSAL_DISABLE_INTERRUPTS(&interrupt_save);

		pFwHostGenRiscInterfaceMailboxFifoOutParams->readCounter++;

		OSAL_ENABLE_INTERRUPTS(interrupt_save);
	}

	return pMsg;
}




