/***********************************************************************************
 File:		HostInterfaceAcc_Api.h
 Module:		Host Interface
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HOST_IF_ACC_API_H_
#define HOST_IF_ACC_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "shramTxDesc.h"

//---------------------------------------------------------------------------------

//						Defines						
//---------------------------------------------------------------------------------
#define HOST_INTERFACE_ACCELERATOR_TTL_SCALE 2
#define HOST_INTERFACE_ACCELERATOR_BASIC_TTL_RESOLUTION_SHIFT 5 /* The basic TTL resoultion is 32 miliseconds */
#define HOST_INTERFACE_ACCELERATOR_FREE_PDS_THRESHOLD (NUM_OF_TX_DESC >> 3) /* Threshold is defined as 1/8 of total PDs */
#define HOST_INTERFACE_ACCELERATOR_FREE_PDS_THRESHOLD_DISABLED (0) /* Threshold disabled */
#define HOST_INTERFACE_TTL_MASK 0x7F
#define HOST_INTERFACE_FREE_PDS_THRESH_RESTRICTED_AC_ENABLE 	((NUM_OF_TX_DESC >> 2)) //leaving 1/4 of total amount of Pds as free 
#define HOST_INTERFACE_FREE_PDS_THRESH_RESTRICTED_AC_DISABLE	(HOST_INTERFACE_FREE_PDS_THRESH_RESTRICTED_AC_ENABLE + (HOST_INTERFACE_FREE_PDS_THRESH_RESTRICTED_AC_ENABLE>>1))

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define HOST_INTERFACE_ACCELERATOR_CONVERT_TIME_UNITS_TO_TTL_UNITS(x)	((x) >> (HOST_INTERFACE_ACCELERATOR_BASIC_TTL_RESOLUTION_SHIFT + HOST_INTERFACE_ACCELERATOR_TTL_SCALE))
#define HOST_INTERFACE_ACCELERATOR_CONVERT_TTL_UNITS_TO_TIME_UNITS(x)   ((x) << (HOST_INTERFACE_ACCELERATOR_BASIC_TTL_RESOLUTION_SHIFT + HOST_INTERFACE_ACCELERATOR_TTL_SCALE))
#define HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(x)			((x) >> (HOST_INTERFACE_ACCELERATOR_BASIC_TTL_RESOLUTION_SHIFT + HOST_INTERFACE_ACCELERATOR_TTL_SCALE + 10))

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
    PD_DIST_TXQ,
	PD_DIST_UMAC,
	NUM_OF_PD_DIST,
    PD_DIST_MAX = MAX_UINT8
}PdDist_e;

typedef enum
{
    DIST_TYPE_UNICAST,
	DIST_TYPE_MULTICAST_GROUP,
	DIST_TYPE_MULTICAST_VAP,
	NUM_OF_DIST_TYPE,
    DIST_TYPE_MAX = MAX_UINT8
}DistType_e;

typedef enum
{
    MCAST_DIST_MODE_IGNORE_BITMAPS, // always Umac
	MCAST_DIST_MODE_GROUP_BITMAP,   // dist according to group bitmap
	MCAST_DIST_MODE_VAP_BITMAPS,    // dist according to vap bitmap
	MCAST_DIST_MODE_VAP_AND_GROUP_BITMAPS, // send to UMAC only if group & VAP is UMAC
	NUM_OF_MCAST_DIST_MODE,
    MCAST_DIST_MODE_MAX = MAX_UINT8
} McastDistMode_e;

typedef enum
{
    BITMAP_TYPE_UNICAST,
	BITMAP_TYPE_VAP,
	BITMAP_TYPE_GROUP,
	NUM_OF_BITMAP_TYPE,
    BITMAP_TYPE_MAX = MAX_UINT8
}BitmapType_e;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void HostIfAcc_Init(void);
void HostIfAcc_ConfigureRingsSize(UMI_DATA_PATH_INIT_PARAMS* dataPathInitParams);
void hostIfAccChangeStaTidPdDist(PdDist_e distValue ,StaId staId,uint8 TID);
void HostIfAcc_ChangeStaAllTidPdDist(PdDist_e distValue ,StaId staId); 
void HostIfAcc_ChangeVapMcastPdDist(PdDist_e distValue ,uint16 vapId);
void HostIfAcc_ChangeMcastGroupPdDist(PdDist_e distValue ,uint16 groupId);
void HostIfAcc_SetMcastDistMode(McastDistMode_e newMcastMode);
#ifdef ENET_INC_ARCH_WAVE600
uint32 HostIfAcc_GetCurrentFreePdsNumber(void);
#else
uint16 HostIfAcc_GetCurrentFreePdsNumber(void);
#endif
void HostIfAcc_ClearFreePdsThresholdEvent(void);
void HostIfAcc_SetPdThreshold(uint16 pdThreshold);
#endif //HOST_IF_ACC_API_H_

