/* CMSynergyVer %full_filespec: HostInterface_API.h;2.1.1.3.2.1.1:incl:1 % */
/***************************************************************************
****************************************************************************
**
** COMPONENT:        Host Interface Manager
**
** MODULE:           $File: //bwp/enet/demo153_sw/develop/src/him_cardbus/HostInterface_API.h $
**
** VERSION:          $Revision: #1 $  
**
** DATED:            $Date: 2003/10/27 $
**
** AUTHOR:           Laurence Evans
**
** DESCRIPTION:      Host Interface Manager Public Header
**
**
** CHANGE HISTORY:
**
**   $Log: HostInterface_API.h $
**   Revision 1.1  2003/02/11 16:30:07Z  wrh
**   Initial revision
**   Revision 1.7  2001/08/24 17:17:50Z  ifo
**   Updated to match current doc & MAC.
**   Needs test harness (UMAC + Host) updated to match.
**   Revision 1.6  2001/08/16 09:45:11Z  ifo
**   Modified for simplified interrupt structure.
**   Revision 1.5  2001/05/18 13:36:12Z  lde
**   Initial module testing complete.
**   Revision 1.4  2001/05/16 13:17:23Z  lde
**   Bug fixes during initial module testing.
**   Revision 1.3  2001/05/09 15:06:45Z  lde
**   Revision 1.2  2001/04/20 16:27:27Z  lde
**   Now compiles and links with the him module test.
**   Revision 1.1  2001/04/18 16:02:00Z  lde
**   Initial revision
**
** LAST MODIFIED BY:   $Author: njk $
**                     $Modtime:$
**
****************************************************************************
*
* Copyright (c) 2001 TTPCom Limited
* 
****************************************************************************/
#ifndef HOST_INTERFACE_API_INCLUDED_H
#define HOST_INTERFACE_API_INCLUDED_H


////#include "enet_sw.h"
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "loggerAPI.h"
#include "queue_utility.h"
#include "PacketDescriptor.h"
#include "RxDescriptor.h"
#include "ShramHim.h"
#include "ResourceManager_API.h"
#include "ShramRxDescriptors.h"
#include "QueueUtility_Api.h"

#ifdef ENET_INC_ARCH_WAVE600
#include "PumaHd_Descriptors.h"
#include "GswipHd_Descriptors.h"
#include "Hd_Descriptors.h"
#endif

#ifdef ENET_INC_ARCH_WAVE600B
#include "LgmReducedHd_Descriptors.h"
#include "FlmReducedHd_Descriptors.h"
#endif

//#define DEBUG_STA_MODE_RSSI


/***************************************************************************/
/***                       Types and Defines                             ***/
/***************************************************************************/
#define HOST_MAGIC	(0xBEADFEED)

typedef enum
{
    HIM_BUF_MAN_Q_TYPE_RX,
    HIM_BUF_MAN_Q_TYPE_LOGGER,
    HIM_BUF_MAN_Q_TYPE_MAX = MAX_UINT8
} HimBufManQueueType_e;

typedef enum
{
	HOST_INTERFACE_RING_DIRECTION_IN  = 0,
	HOST_INTERFACE_RING_DIRECTION_OUT = 1,
	NUM_OF_HOST_INTERFACE_RINGS,
} HostInterfaceRingDirection_e;

/* Descriptor indexes Queue */
/* Moved here from rx_manage_task.c */
typedef struct{
    uint8  u8HeadIndex;     /* Holds the head index in this queue - ( index of free descriptor in asHIMdatIndDesc[]) */
    uint8  u8BufferCounter; /* Holds number of buffers descriptors in this queue */
    uint16 u16BufferSize;   /* Holds size of buffer allocated for element in this queue*/		
} DESC_IDX_QUEUE;

typedef struct{
    DESC_IDX_QUEUE descQueue;   /* A queue descriptor struct */
    uint8         *indexPool;   /* Pool of indexes serving the queue, One index per BD + 1 for Invalid index(last index)*/
} HimBufManDescManager_t;

typedef struct
/* This struct is a combination of K_MSG header and a DMA_REQ as the abData */
/* used for holding buffers of various types */
{
    K_MSG_HEADER         kMsgHeader;
    UMQ                  sQueue;    /* This struct is use only to allow use of UM queus*/
    HimBufManQueueType_e queueType; /* type of queue this message belongs to */
    uint8                bdIndex;   /* index of BD in BD queue */
	uint8                origin;    /* Origin CPU*/  
} HimBufManKmsgDmaReq_t;


typedef struct {
    uint8                  loggerIndexPool[LOGGER_NUM_OF_BUFFERS];
    HimBufManDescManager_t loggerFreeBufDescManager;
    HimBufManKmsgDmaReq_t  loggerKmsgDmaReq[LOGGER_NUM_OF_BUFFERS];
    UMI_MSG                loggerUmiMsg[LOGGER_NUM_OF_BUFFERS];
} HIM_BUFFER_MANAGER_DB;


typedef struct GlobalHostIfDb
{
	GeneralQueueBlock_t pendingDmaDoneQueue;
	uint32 dmaTransferCount;
	bool doneListMsgSent;
	bool DmaCmpltMsgSent;
}GlobalHostIfDb_t;
extern GlobalHostIfDb_t GlobalHostIfRingsDb;


typedef struct{
    uint8        ringType;  
} RingDoneData_t;


typedef struct HostIfDataPathHdSize_
{
	uint32 txInHdSize;	/* Numer of  lines (32 bit width) in Tx HD passed from host*/
	uint32 txOutHdSize;	/* Numer of  lines (32 bit width) in Tx HD passed to host*/
	uint32 rxInHdSize;	/* Numer of  lines (32 bit width) in Rx HD Passed from host*/
	uint32 rxOutHdSize;	/* Numer of  lines (32 bit width) in Rx HD passed to host*/
} HostIfDataPathHdSize_t;

#ifdef ENET_INC_ARCH_WAVE600
typedef union HostDescriptor
{
	PumaHd_t		pumaHd;
	GswipHd_t		gswipHd;
	Hd_t			hd;
#ifdef ENET_INC_ARCH_WAVE600B
	LgmReducedHd_t	lgmReducedHd;
	FlmReducedHd_t	flmReducedmHd;
#endif //ENET_INC_ARCH_WAVE600B
} HostDescriptor_u;
#endif

PRAGMA_START_DATA



/* Note vector area overlays start of SHRAM on target - this is the start
   of the recieve circular buffer */
extern uint8 au8RxCircBuf[];
#define sCHIvectorArea (*(volatile VECTOR_AREA *)au8RxCircBuf)

#define PAS_BASE_ADDRESS    ((uint32)&sCHIvectorArea)

#if defined (ENET_INC_LMAC0)
#define SET_DEBUG_CHI(x) \
	(sCHIvectorArea.sBasic.u32Magic = (x << 16) | (sCHIvectorArea.sBasic.u32Magic & 0x0000ffff)); \
	(sCHIvectorArea.sDebugExt.sData.u32Core0_info = x)
#endif
#if defined (ENET_INC_LMAC1)
#define SET_DEBUG_CHI(x) \
	(sCHIvectorArea.sDebugExt.sData.u32Core1_info = x)
#endif
#if defined (ENET_INC_UMAC)
#define SET_DEBUG_CHI(x) \
	(sCHIvectorArea.sBasic.u32Magic = (x & 0xffff) | (sCHIvectorArea.sBasic.u32Magic & 0xffff0000)); \
	(sCHIvectorArea.sDebugExt.sData.u32Core2_info = x)
#endif
 
#if defined (ENET_CFG_ALLOC_SEPARATE_FORWARD_POOL)
extern uint8 au8ApFwdPayload[MSDU_MAX_LENGTH * ENET_AP_FORWARD_POOL_SIZE]; /* variable length */
#endif

PRAGMA_END_DATA


/***************************************************************************/
/***                  Public Function Prototypes                         ***/
/***************************************************************************/

void vHIM_Task(K_MSG *psKnlMsg);
void vHIM_Init(void);
void HostInterface_PostInit(void);
void vHIM_Enable(void);
void vHIM_HostISR(void);
ISR_VOID isr_HostIfTxInMangCountNotZero(void);
ISR_VOID isr_HostIfRxInMangCountNotZero(void);



void sendInitializationCompleteToHost(void);
void HimApi_InitIndexQueues(void);
K_MSG *HimApi_PrepBufferMsg(HimBufManQueueType_e queueType, uint8 *buffer, uint32 length, uint8 originCpu);
void vHIM_SendMsgToHost(K_MSG *psMsg);
void vHRC_GenerateHostInterrupt(uint8 intType);
HostIfDataPathHdSize_t* HostInterfaceRings_GetHdSizes(DataPathMode_e dataPathMode);
 void HostInterfaceRings_Init(void);
void HostInterfaceRings_PostInit(void);

TxPd_t* hostInterfaceRingsGetPdFromList(PacketDescriptorQueue_t* pPdList);
void hostInterfaceRings_PutOnPdsList(TxPd_t* pPacketDescHead , TxPd_t* pPacketDescTail,PacketDescriptorQueue_t* pPdList);
Rd_t * hostInterfaceRingsGetRdFromList(rxDescriptorQueue_t* pRdList);
void hostInterfaceRings_PutOnRdsList(Rd_t  *headRxDescriptor, Rd_t  *tailRxDescriptor,rxDescriptorQueue_t* pRdList);
void hostInterfaceRings_DoneListsHandler(K_MSG *psMsg);
void hostInterfaceRings_HandleDmaComplete(K_MSG *psMsg);
void hostInterfaceRings_NewRxMangHds(K_MSG *psMsg);
void hostInterfaceRings_NewTxMangHds(K_MSG *psMsg);
void HostInterfaceRings_SetRingsParams(UMI_DATA_PATH_INIT_PARAMS* pInitParams);
void HostInterfaceRings_FillChiHostRingsInfo(volatile VECTOR_AREA_BASIC* pBasic);

void hostInterfaceRingsNewHdsIndication(K_MSG* pHdsOnRingMsg);

#ifdef DEBUG_STA_MODE_RSSI
void hostInterfaceRingsSetPowerManagementBit(bssHostDescriptor_t* tempHostDesc, bool PowerManagementVal);
#endif

void hostInterfaceRingsConvertDriverHdsToPds(Hd_t* pHostDesc ,uint8 numOfHds);
void hostInterfaceRingsConvertDriverHdsToRds(Hd_t* pHostDesc ,uint8 numOfHds);
uint16 hostInterfaceRingsConvertDriverRdsToHds(Hd_t* pHostDesc ,uint8 numOfHds);
uint16 hostInterfaceRingsConvertDriverPdsToHds(Hd_t* pHostDesc ,uint8 numOfHds);
void hostInterfaceRingsSetAtfBufferDisable(StaId stationId);
#ifdef ENET_INC_ARCH_WAVE600 
void hostInterfaceIncrementPdByteCount(uint8 tid, StaId staId, uint16 byteCount);
void hostInterfaceDecrementPdByteCount(uint8 tid, StaId staId, uint16 byteCount);
#endif




#endif /* !HOST_INTERFACE_API_INCLUDED_H */

