
#ifndef HOST_INTERFACE_INCLUDED_H
#define HOST_INTERFACE_INCLUDED_H




#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HostInterface_API.h"
#include "EventsManager_api.h"

#include "shram_dataHostIf.h"
//#include "HwEventsAndErrors_Api.h"
#include "HostInterfaceAcc_Api.h"

#define ACM_ALL_ACS_ALLOWED	0x0

typedef struct HostInterfaceStaDb_s
{
	uint8 enabled:1;
	uint8 open:1;		/*Filter open - used to filter data packets*/
	uint8 use_pmf:1;	/*PMF in use - used to encrypt management frames*/
    uint8 atf_buffered:1; /*ATF in static mode req to buffer data so this station wont TX*/
	uint8 acm_flags:4;	/*In STA mode, we may need to drop packets if AP set the ACM bit for the AC*/
	PdDist_e pdDist;
	uint8 flags;
} HostInterfaceStaDb_t;

extern HostInterfaceStaDb_t	HostInterfaceStaDb[HW_NUM_OF_STATIONS];

void vHIM_ForwardMcMsgs( K_MSG *psMsg);
void HimApi_HandleSendBufferToHostRes(uint8 index);
uint8 HimApi_GetIndexFromK_MSG(K_MSG *pMsg);
void HimBufMan_HandleSendBufferToHostRes(uint8 index);
void HimBufMan_InitLoggerIndexQueue(void);
HimBufManKmsgDmaReq_t* HimBufMan_PrepLoggerBufferMsg(uint8 *buffer, uint32 length, uint8 origin);

HostIfShRamBuf_t* hostInterfaceRingsGetFullBufferAddr(buffDb_t* pbuffDb);
HostIfShRamBuf_t* hostInterfaceRingsGetFreeBufferAddr(buffDb_t* pbuffDb);
void hostInterfaceRingsMoveToNextFreeBuffer(buffDb_t* pbuffDb);
void hostInterfaceRingsMoveToNextFullBuffer(buffDb_t* pbuffDb);

bool hostInterface_IsStaEnabled(StaId sid);
bool hostInterface_IsStaOpen(StaId sid);
bool hostInterface_IsStaMfp(StaId sid);
bool hostInterface_IsStaQoS(StaId sid);
bool hostInterface_IsStaAtfBuffered(StaId sid);
bool hostInterface_IsStaTidAcmAllowed(StaId sid, uint8 tid);
bool HostInterface_IsRestrictedAc(uint8 tid);
bool hostInterface_IsVapEnabled(uint8 vapId);
bool hostInterface_IsRobustManagementFrame(uint8 subType, uint8 action);

void hostInterfaceRingsNewHds(HdRingDb_t* pRingDb);

void hostInterfaceRingsNewDesc(HdRingDb_t* pRingDb);

#ifndef TX_DATA_UM_PATH
void hostInterface_ReadyListsHandler(K_MSG *psMsg);
#endif

#endif //HOST_INTERFACE_INCLUDED_H

