/***********************************************************************************
 File:		HostAccCode.h
 Module:		Host IF accelerator
 Purpose:		
 Description:	
************************************************************************************/

#ifndef HOST_ACC_CODE_INCLUDED_
#define HOST_ACC_CODE_INCLUDED_


/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH
Remarks: Length of field to copy
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT       0x0
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_NUMBER_OF_BITS  0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK            0x0000001F

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET
Remarks: Offset of the field in the line, valid values are 0-31, valid only in copy instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_START_BIT       0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_NUMBER_OF_BITS  0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_MASK            0x000003E0

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX
Remarks: Source line number, valid values are 0-7, valid only in copy instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_START_BIT           0xA
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_NUMBER_OF_BITS      0x3
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_MASK                0x00001C00

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS
Remarks: Data taken from registers index, TTL Write is reserved for register index 0, valid only in write instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_START_BIT       0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_NUMBER_OF_BITS  0x4
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_MASK            0x000001E0

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0
Remarks: valid only in write instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_START_BIT             0x9
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_NUMBER_OF_BITS        0x4
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_MASK                  0x00001E00

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET
Remarks: Offset of the field in the line, valid values are 0-63
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT      0xD
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_NUMBER_OF_BITS 0x6
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK           0x0007E000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE
Remarks: Last instruction to the destination line
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT              0x13
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_NUMBER_OF_BITS         0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK                   0x00080000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_LAST
Remarks: Last instruction  Makes the read of this line the last one
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT                   0x14
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_NUMBER_OF_BITS              0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK                        0x00100000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE
Remarks: 
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT                   0x15
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_NUMBER_OF_BITS              0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_MASK                        0x00200000
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_COPY                  0x0
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_WRITE_CONSTANT        0x1

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_VALID
Remarks: Valid instruction  Used to signal on empty destination line
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT                  0x16
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_NUMBER_OF_BITS             0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_MASK                       0x00400000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1
Remarks: 
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_START_BIT             0x17
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_NUMBER_OF_BITS        0x9
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_MASK                  0xFF800000


#define HOST_IF_UCODE_INSTRUCTION_COPY(srcFieldLength, srcFieldOffset, srcLineIdx, destFieldOffset, lastInstLine, lastInst)		\
	((TRUE << HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT) | \
	(HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_COPY << HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT) | \
	((lastInst << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK) | \
	((lastInstLine << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK) | \
	((destFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK) | \
	((srcLineIdx << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_MASK) | \
	((srcFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_MASK) | \
	(((srcFieldLength - 0x1) << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK))

#define HOST_IF_UCODE_INSTRUCTION_WRITE(srcFieldLength, regAddr, destFieldOffset, lastInstLine, lastInst)		\
	((TRUE << HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT) | \
	(HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_WRITE_CONSTANT << HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT) | \
	((lastInst << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK) | \
	((lastInstLine << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK) | \
	((destFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK) | \
	((regAddr << HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_MASK) | \
	(((srcFieldLength - 0x1) << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK))



/*---------------------------------------------------------------------------------
/						Tx In HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathTxInAccCode[] = 
{
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 25, FALSE, FALSE), 	//	0x4321C0 -> MC bit 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  1,  0, 	FALSE, FALSE),	//	0x60002F -> A-MSDU null const
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 14,  0, 62, FALSE, FALSE), 	//	0x47C1E1 -> EType 		   
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3, 48, FALSE, FALSE), 	//	0x460C0D -> Data length 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  1, 32, 	 TRUE, FALSE),	//	0x6C002F -> PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3, FALSE, FALSE),	//	0x40687C -> Pointer to DRAM 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  2,  0, FALSE, FALSE),	//	0x400EE2 -> Byte offset 
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0, 50, 	FALSE, FALSE),	//	0x664006 -> TTL counter const
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 24,  3, 32, FALSE, FALSE),	//	0x440402 -> TID-ID 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 7,  0,  0, 35, FALSE, FALSE),	//	0x446006 -> STA-ID 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4,  8,  0, 43, FALSE, FALSE),	//	0x456103 -> VAP-ID 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 48,  TRUE, FALSE),	//	0x4E01C0 -> TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2,  0, 	FALSE, FALSE),	//	0x60005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2, 32, 	 TRUE, FALSE),	//	0x6C005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_COPY (16,  0,  1,  0, FALSE, FALSE),	//  0x40100F -> BD index copy (debug: check that the PP card is sending the running counter...)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 25,  TRUE, TRUE) ,	//	0x5B21C0 -> DW6 MC bit  	
};

static const uint32 SwPathTxInAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 25, FALSE, FALSE),		//	0x4321C0 -> MC bit copy	 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 1, 0, FALSE, FALSE),		//	0x60002F -> A-MSDU null const
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 15, 0, 62, FALSE, FALSE),		//	0x47C1E1 -> etype copy         
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 0, 3, 48, FALSE, FALSE),		//	0x460C0D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 1, 32, TRUE, FALSE),		//	0x6C002F -> PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3, 2, 3, FALSE, FALSE),		//	0x40687C -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 23, 3, 0, FALSE, FALSE),		//	0x400EE2 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(7, 0, 50, FALSE, FALSE),		//	0x664006 -> TTL counter const
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 0, 1, 32, FALSE, FALSE),		//	0x440402 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(7, 0, 0, 35, FALSE, FALSE),		//	0x446006 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(4, 8, 0, 43, FALSE, FALSE),		//	0x456103 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 48, TRUE, FALSE),		//	0x4E01C0 -> TXQ UNI/MULTI copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(32, 2, 0, FALSE, FALSE),		//  0x60005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_WRITE(32, 2, 32, TRUE, FALSE),		//  0x6C005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 0, 4, 0, FALSE, FALSE),		//  0x40100F -> BD index copy
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 25, TRUE, TRUE),		//	0x5B21C0 -> DW6 MC bit copy     
};

static const uint32 FastPathTxInAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 25, FALSE, FALSE),		//	0x4321C0 -> MC bit copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 1, 0, FALSE, FALSE),		//	0x60002F -> A-MSDU null const
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 15, 0, 62, FALSE, FALSE),		//	0x47C1E1 -> etype copy         
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 0, 3, 48, FALSE, FALSE),		//	0x460C0D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 1, 32, TRUE, FALSE),		//	0x6C002F -> PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3, 2, 3, FALSE, FALSE),		//	0x40687C -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 23, 3, 0, FALSE, FALSE),		//	0x400EE2 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(7, 0, 50, FALSE, FALSE),		//	0x664006 -> TTL counter const
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 4, 1, 32, FALSE, FALSE),		//	0x440482 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(7, 0, 0, 35, FALSE, FALSE),		//	0x446006 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(4, 8, 0, 43, FALSE, FALSE),		//	0x456103 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 48, TRUE, FALSE),		//	0x4E01C0 -> TXQ UNI/MULTI copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(32, 2, 0, FALSE, FALSE),		//	0x60005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_WRITE(32, 2, 32, TRUE, FALSE),		//	0x6C005F -> Writing zeros
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 14, 0, 25, TRUE, TRUE),		//	0x5B21C0 -> DW6 MC bit copy 	
};


static const uint32 TxInAccFixedValues[] = 
{
	0xFFFFFFFF, 
    0x0,
};


/*---------------------------------------------------------------------------------
/						Tx Out HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 25,  0, 13, FALSE, FALSE), 	//	0x41C320 -> MC bit copy  
	HOST_IF_UCODE_INSTRUCTION_COPY ( 7,  3,  3,  0, FALSE, FALSE),	//	0x400C66 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4, 11,  3,  8, FALSE, FALSE),	//	0x410D63 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY (16,  0,  6, 32, FALSE, FALSE),	//  0x58180F -> BD index copy  ====== debug for running counter sent to PP cable card
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 30,  1, 14,  TRUE, FALSE),	//	0x49E7C1 -> EType copy
	HOST_IF_UCODE_INSTRUCTION_WRITE( 1,  1, 63, 	FALSE, FALSE),	//	0x67E020 -> Own bit const
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2,  0,  2,  0, FALSE, FALSE),	//	0x46E801 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY (14, 16,  1, 32, FALSE, FALSE),	//	0x44060D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY (30,  2,  2,  2,	FALSE, FALSE),	//	0x48485D -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  3, 56,  TRUE,  TRUE),	//	0x440C02 -> TID-ID copy	
};

static const uint32 SwPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(1, 25, 0, 14, FALSE, FALSE),		//  0x41C320 -> MC bit copy  
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 0, 3, 32, FALSE, FALSE),		//	0x440C02 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(7, 3, 3, 0, FALSE, FALSE),		//	0x400C66 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(4, 11, 3, 8, FALSE, FALSE),		//	0x410D63 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 30, 1, 15, TRUE, FALSE),		//  0x49E7C1 -> etype copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(1, 1, 63, FALSE, FALSE),		//	0x67E020 -> Own bit const
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 0, 2, 55, FALSE, FALSE),		//	0x46E801 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 16, 1, 32, FALSE, FALSE),	//	0x44060D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(30, 2, 2, 2, TRUE, FALSE),		//	0x48485D -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 0, 6, 0, TRUE, TRUE),		//  0x58180F -> BD index copy
};

static const uint32 FastPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3, 2, 3, TRUE, TRUE),		//	0x58687C -> Pointer to DRAM copy  
};


static const uint32 TxOutAccFixedValues[] = 
{
	0xFFFFFFFF, 
};

/*---------------------------------------------------------------------------------
/						Rx In HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathRxInAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  3,  0,		 TRUE, FALSE),		//    0x68006F -> Const value
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3, FALSE, FALSE),		//    0x40485D -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  1, 32, 	 TRUE, FALSE),		//    0x6C002F -> Set RD next pointer to 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  3, 32, 	 TRUE, TRUE) ,		//    0x7C006F -> Const value
};

static const uint32 SwPathRxInAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 3, 0, TRUE, FALSE),		//    0x68006F -> Const value
	HOST_IF_UCODE_INSTRUCTION_COPY(30, 2, 2, 2, FALSE, FALSE),		//    0x40485D -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 1, 32, TRUE, FALSE),		//    0x6C002F -> Set RD next pointer to 
	0x280040,												//    0x280040 -> Empty line
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 0, 4, 48, FALSE, FALSE),		//    0x46100F -> BD index copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 3, 32, TRUE, TRUE),		//    0x7C006F -> Const value
};

/* There is no Rx In Code when working on Fast Data PAth Mode*/

static const uint32 RxInAccFixedValues[] = 
{
    0xFFFFFFFF,
    0x0,
    0xBEEF,
};

/*---------------------------------------------------------------------------------
/						Rx In HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathRxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 16, 7, 32, FALSE, FALSE),	//    0x581E0F -> BD index copy ==== debug give the pp card a running counter
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 0, 14, FALSE, FALSE), 	//	 0x41E1C1 -> EType copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  8, 1,  0, FALSE, FALSE),	//	 0x400507 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 16, 1,  8,  TRUE, FALSE),	//	 0x490603 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,	5, 1, 56, FALSE, FALSE),	//	 0x4404A2 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2,  3, 1, 61, FALSE, FALSE),	//	 0x478461 -> SoP+EoP bits copy	   
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  1,    63, FALSE, FALSE),	//	 0x63E020 -> Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 0, 32, FALSE, FALSE), 	//	 0x44000D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 2,  3, FALSE, FALSE),	//	 0x48081F -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 1,  0,  TRUE,  TRUE),	//    0x46E402 -> Byte offset copy
};

static const uint32 SwPathRxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 5, 1, 32, FALSE, FALSE),		//   0x4404A2 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 14, 0, 15, FALSE, FALSE),		//   0x41E1C1 -> etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY(8, 8, 1, 0, FALSE, FALSE),		//   0x400507 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(4, 16, 1, 8, TRUE, FALSE),		//   0x490603 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 3, 1, 60, FALSE, FALSE),		//   0x478461 -> SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,	1,  63, FALSE, FALSE),		//	 0x63E020 -> Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 0, 1, 55, FALSE, FALSE),		//   0x46E402 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 0, 0, 32, FALSE, FALSE),		//   0x44000D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(32, 0, 2, 0, TRUE, FALSE),		//   0x48081F -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 16, 7, 0, TRUE, TRUE),		//   0x581E0F -> BD index copy 
};

//	in fast path there is an issue in the swp 64 so the HD is looks like:
//																			Word 1
//																			word 0
//																			Word 3
//																			Word 2
//
// this is why there is an 32 bit offset between the fast pafh and sw pash micro code

static const uint32 FastPathRxOutAccCode[] =
{
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 5, 1, 0, FALSE, FALSE),		//	0x4004A2 -> TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 14, 0, 47, FALSE, FALSE),		//	0x45E1C1 -> etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY(8, 8, 1, 32, FALSE, FALSE),		//	0x440507 -> STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY(4, 16, 1, 40, TRUE, FALSE),		//	0x4D0603 -> VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(1, 1, 31, FALSE, FALSE),		//	0x63E020 -> Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY(2, 3, 1, 28, FALSE, FALSE),		//	0x438461 -> SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_COPY(3, 0, 1, 23, FALSE, FALSE),		//	0x42E402 -> Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 0, 0, 0, FALSE, FALSE),		//	0x40000D -> Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(32, 0, 2, 32, TRUE, TRUE),		//	0x5C081F -> Pointer to DRAM copy
};

static const uint32 RxOutAccFixedValues[] = 
{
    0xFFFFFFFF,
    0x0,
};   

#endif //HOST_ACC_CODE_INCLUDED


