/***********************************************************************************
 File:		HostAccCode.h
 Module:		Host IF accelerator
 Purpose:		
 Description:	
************************************************************************************/

#ifndef HOST_ACC_CODE_INCLUDED_
#define HOST_ACC_CODE_INCLUDED_


/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH
Remarks: Length of field to copy
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT       0x0
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_NUMBER_OF_BITS  0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK            0x0000001F

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET
Remarks: Offset of the field in the line, valid values are 0-31, valid only in copy instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_START_BIT       0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_NUMBER_OF_BITS  0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_MASK            0x000003E0

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX
Remarks: Source line number, valid values are 0-7, valid only in copy instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_START_BIT           0xA
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_NUMBER_OF_BITS      0x3
#define HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_MASK                0x00001C00

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS
Remarks: Data taken from registers index, TTL Write is reserved for register index 0, valid only in write instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_START_BIT       0x5
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_NUMBER_OF_BITS  0x4
#define HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_MASK            0x000001E0

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0
Remarks: valid only in write instruction
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_START_BIT             0x9
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_NUMBER_OF_BITS        0x4
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_0_MASK                  0x00001E00

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET
Remarks: Offset of the field in the line, valid values are 0-63
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT      0xD
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_NUMBER_OF_BITS 0x6
#define HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK           0x0007E000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE
Remarks: Last instruction to the destination line
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT              0x13
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_NUMBER_OF_BITS         0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK                   0x00080000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_LAST
Remarks: Last instruction  Makes the read of this line the last one
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT                   0x14
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_NUMBER_OF_BITS              0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK                        0x00100000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE
Remarks: 
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT                   0x15
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_NUMBER_OF_BITS              0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_MASK                        0x00200000
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_COPY                  0x0
#define HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_WRITE_CONSTANT        0x1

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_VALID
Remarks: Valid instruction  Used to signal on empty destination line
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT                  0x16
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_NUMBER_OF_BITS             0x1
#define HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_MASK                       0x00400000

/*====================================================================================================
List of Definitions for HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1
Remarks: 
====================================================================================================*/
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_START_BIT             0x17
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_NUMBER_OF_BITS        0x9
#define HOST_IF_UCODE_INSTRUCTION_FIELD_RESERVED_1_MASK                  0xFF800000


#define HOST_IF_UCODE_INSTRUCTION_COPY(srcFieldLength, srcFieldOffset, srcLineIdx, destFieldOffset, lastInstLine, lastInst)		\
	((TRUE << HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT) | \
	(HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_COPY << HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT) | \
	((lastInst << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK) | \
	((lastInstLine << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK) | \
	((destFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK) | \
	((srcLineIdx << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_LINE_IDX_MASK) | \
	((srcFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_OFFSET_MASK) | \
	(((srcFieldLength - 0x1) << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK))

#define HOST_IF_UCODE_INSTRUCTION_WRITE(srcFieldLength, regAddr, destFieldOffset, lastInstLine, lastInst)		\
	((TRUE << HOST_IF_UCODE_INSTRUCTION_FIELD_VALID_START_BIT) | \
	(HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_VALUE_WRITE_CONSTANT << HOST_IF_UCODE_INSTRUCTION_FIELD_TYPE_START_BIT) | \
	((lastInst << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_MASK) | \
	((lastInstLine << HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_LAST_LINE_MASK) | \
	((destFieldOffset << HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_DEST_FIELD_OFFSET_MASK) | \
	((regAddr << HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_REGISTER_ADDRESS_MASK) | \
	(((srcFieldLength - 0x1) << HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_START_BIT) & HOST_IF_UCODE_INSTRUCTION_FIELD_SRC_FIELD_LENGTH_MASK))



/*---------------------------------------------------------------------------------
/						Tx In HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathTxInAccCode[] = 
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3,  0,  FALSE, FALSE), //	Data length 
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 15,  FALSE, FALSE), //	MC bit 
 	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  	16,  FALSE, FALSE),	//	Writing zeros (FN + SN)
	//Destination points to word1
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,     32,  FALSE, FALSE),	//	A-MSDU tail pointer 	
	HOST_IF_UCODE_INSTRUCTION_WRITE(8,   2,     56,  TRUE,  FALSE),	//	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,      0,  FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE(4,   2,  	24,  FALSE, FALSE),	//	Writing zeros - retry count  
	HOST_IF_UCODE_INSTRUCTION_COPY (2, 14,  0,  28,  FALSE, FALSE), // EType
	//Destination points to word3
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,     32,	 FALSE, FALSE), //	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 24,  3, 32,  FALSE, FALSE), //	TID-ID - (TBD : 4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE), //	STA-ID - (TBD : 9 bits in PD)	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - (TBD : 7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 53,  TRUE,  FALSE), //	TXQ UNI/MULTI
	//Destination points to word4	
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,      0,  FALSE, FALSE),	//	TTL counter const	
	HOST_IF_UCODE_INSTRUCTION_WRITE( 56, 2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word5
	//
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY (32,  0,  2, 0,	 FALSE, FALSE), //	Pointer to DRAM and Byte offset 	
	//Destination points to word7
	HOST_IF_UCODE_INSTRUCTION_COPY (16,  0,  1, 32,  FALSE, FALSE),	//  BD index copy 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,     48,  TRUE,  TRUE),	//	Writing zeros (Upper half word of BD index)
};


static const uint32 LgmPathTxInAccCode[] = 
{
	//Destination points to word0
 	HOST_IF_UCODE_INSTRUCTION_COPY (14, 0,   3, 0,   FALSE, FALSE), //	Data length 
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 15,  0, 15,  FALSE, FALSE), //	MC bit   
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 2,   16, 	 FALSE,  FALSE),//	Writing zeros (FN + SN)
	//Destination points to word1
	HOST_IF_UCODE_INSTRUCTION_WRITE(24, 1,   32, 	 FALSE, FALSE),	//	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE( 8, 2,   56, 	 TRUE, FALSE),	//	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  0, 	 FALSE, FALSE),	//	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE(4,   2,  24, 	 FALSE,  FALSE),//	Writing zeros - retry count 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 16,  0, 28,  FALSE, FALSE), //  EType 
	//Destination points to word3
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,  32, 	 FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  8,  1, 32,  FALSE, FALSE),	//	TID-ID - (TBD : 4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (TBD : 9 bits in PD) 	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 5,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - (TBD : 7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 15,  0, 53,  TRUE, FALSE), //	TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,  0, 	 FALSE, FALSE),	//	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 56, 2,  8, 	 TRUE,  FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word5
	//
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY (32,  0,  2, 0,	 FALSE, FALSE), //	Pointer to DRAM and Byte offset 	
	//Destination points to word7
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2,     32,	 TRUE,  TRUE),	//	Writing zeros (Upper half word of BD index)
};


static const uint32 PumaPathTxInAccCodeCDB[] = 
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3,  0,  FALSE, FALSE), //	Data length 
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 15,  FALSE, FALSE), //	MC bit 
 	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  	16,  FALSE, FALSE),	//	Writing zeros (FN + SN)
	//Destination points to word1
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,     32,  FALSE, FALSE),	//	A-MSDU tail pointer 	
	HOST_IF_UCODE_INSTRUCTION_WRITE(8,   2,     56,  TRUE,  FALSE),	//	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,      0,  FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE(4,   2,  	24,  FALSE, FALSE),	//	Writing zeros - retry count  
	HOST_IF_UCODE_INSTRUCTION_COPY (2,  14,  0,  28,  FALSE, FALSE),// EType
	//Destination points to word3
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,     32,	 FALSE, FALSE), //	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 24,  3, 32,  FALSE, FALSE), //	TID-ID - (TBD : 4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE), //	STA-ID - (TBD : 9 bits in PD)	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first 3 bits (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 11,  0, 49,  FALSE, FALSE), //	VAP-ID - bit #4 (taken from VAP ID bit #3)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 13,  0, 53,  TRUE,  FALSE), //	TXQ UNI/MULTI
	//Destination points to word4	
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,      0,  FALSE, FALSE),	//	TTL counter const	
	HOST_IF_UCODE_INSTRUCTION_WRITE( 56, 2,      8,  TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word5
	//
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY (32,  0,  2, 0,	 FALSE, FALSE), //	Pointer to DRAM and Byte offset 	
	//Destination points to word7
	HOST_IF_UCODE_INSTRUCTION_COPY (16,  0,  1, 32,  FALSE, FALSE),	//  BD index copy 
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,     48,  TRUE,  TRUE),	//	Writing zeros (Upper half word of BD index)
};

static const uint32 SwPathTxInAccCode[] = 
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3,  0,  FALSE, FALSE), //	Data length 
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 15,  FALSE, FALSE), // 	MC bit 
 	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,     16,	 FALSE, FALSE), //	Writing zeros (FN + SN)
	//Destination points to word1
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,     32,	 FALSE, FALSE), //	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE(8,	 2,     56,	 TRUE,  FALSE), //	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)
	//Destination points to word2
 	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,      0,  FALSE, FALSE), //	PD next pointer null const
 	HOST_IF_UCODE_INSTRUCTION_WRITE(4,	 2,     24,	 FALSE,  FALSE), //	Writing zeros -retryCount
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 15,  0, 28,  FALSE, FALSE), // 	EType 
	//Destination points to word3
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,     32,  FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 0,   1, 32,  FALSE, FALSE),	//	TID-ID - (4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (9 bits in PD) 
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first 4 bits(7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1,  8,  1, 49,  FALSE, FALSE), //	VAP-ID - last MSB (taken from EP field) (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 53,  TRUE, FALSE), //	TXQ UNI/MULTI 
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,      0,  FALSE, FALSE), //	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 56, 2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype +PN)
	//Destination points to word5
	//
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  23,  3, 0,  FALSE, FALSE),	//	Byte offset 
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,   2, 3,  FALSE, FALSE),	//	Pointer to DRAM 
	//Destination points to word7
	HOST_IF_UCODE_INSTRUCTION_COPY (16,  0,   4, 32, FALSE, FALSE),	//  BD index copy (debug: check that the PP card is sending the running counter...) 	
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,      48, TRUE,  TRUE),	//	Writing zeros (Upper half word of BD index)

};

static const uint32 FastPathTxInAccCode[] = 
{
	//Destination points to word0
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 15,  FALSE, FALSE), //  MC bit   
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  32,	 FALSE, FALSE), //	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE( 8,	 2,  56,	 FALSE, FALSE), //	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)  
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  16,	 FALSE, FALSE), //	Writing zeros (FN + SN)
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3, 0,   TRUE, FALSE), 	//	Data length 
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 15,  0, 28,  FALSE, FALSE), //	EType 
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,  32, 	 FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 0,   1, 32,  FALSE, FALSE), //	TID-ID - (4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (9 bits in PD) 	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first and only 4 bits (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 53,  FALSE, FALSE), //	TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  0, 	 FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 4,	 2,  24,	 TRUE,  FALSE), //	Writing zeros - retryCount
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,  0, 	 FALSE, FALSE), //	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE(56,  2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  23, 3, 0, 	 FALSE, FALSE),	//	Byte offset 
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3,  TRUE, TRUE),	//	Pointer to DRAM 
};


static const uint32 FastPathTxInAccCodeCDB[] = 
{
	//Destination points to word0
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 15,  FALSE, FALSE), // MC bit   
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  32,	 FALSE, FALSE), //	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE( 8,	 2,  56,	 FALSE, FALSE), //	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)  
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  16,	 FALSE, FALSE), //	Writing zeros (FN + SN)
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3, 0,   TRUE, FALSE), 	//	Data length 
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 15,  0, 28,  FALSE, FALSE), //	EType 
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,  32, 	 FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 0,   1, 32,  FALSE, FALSE), //	TID-ID - (4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (9 bits in PD) 	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first 3 bits (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 11,  0, 49,  FALSE, FALSE), //	VAP-ID - bit #4 (taken from VAP ID bit #3)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 53,  FALSE, FALSE), //	TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  0, 	 FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 4,	 2,  24,	 TRUE,  FALSE), //	Writing zeros - retryCount
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,  0, 	 FALSE, FALSE), //	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE(56,  2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  23, 3, 0, 	 FALSE, FALSE),	//	Byte offset 
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3,  TRUE, TRUE),	//	Pointer to DRAM 
};


static const uint32 FlmPathTxInAccCode[] = 
{
	//Destination points to word0
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 15,  FALSE, FALSE), // MC bit   
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  32,	 FALSE, FALSE), //	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE( 8,	 2,  56,	 FALSE, FALSE), //	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)  
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  16,	 FALSE, FALSE), //	Writing zeros (FN + SN)
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3, 0,   TRUE, FALSE), 	//	Data length 
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 15,  0, 28,  FALSE, FALSE), //	EType 
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,  32, 	 FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 0,	 1, 32,  FALSE, FALSE), //	TID-ID - (4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (9 bits in PD) 	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first and only 4 bits (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 53,  FALSE, FALSE), //	TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  0, 	 FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 4,	 2,  24,	 TRUE,  FALSE), //	Writing zeros - retryCount
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,  0, 	 FALSE, FALSE), //	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE(56,  2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  23, 3, 0, 	 FALSE, FALSE),	//	Byte offset 
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3,  TRUE, TRUE),	//	Pointer to DRAM 
};


static const uint32 FlmPathTxInAccCodeCDB[] = 
{
	//Destination points to word0
 	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 15,  FALSE, FALSE), //  MC bit   
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  32,	 FALSE, FALSE), //	A-MSDU tail pointer  
	HOST_IF_UCODE_INSTRUCTION_WRITE( 8,	 2,  56,	 FALSE, FALSE), //	Writing zeros (A-MSDU PD counter +Frag+Retransmission + Aggregation)  
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  2,  16,	 FALSE, FALSE), //	Writing zeros (FN + SN)
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  3, 0,   TRUE, FALSE), 	//	Data length 
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 15,  0, 28,  FALSE, FALSE), //	EType 
	HOST_IF_UCODE_INSTRUCTION_WRITE(23,  2,  32, 	 FALSE, FALSE),	//	Reset All TID bits
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 0,	 1, 32,  FALSE, FALSE), //	TID-ID - (4 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8,  0,  0, 36,  FALSE, FALSE),	//	STA-ID - (9 bits in PD) 	
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  8,  0, 45,  FALSE, FALSE), //	VAP-ID - first 3 bits (7 bits in PD)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 11,  0, 49,  FALSE, FALSE), //	VAP-ID - bit #4 (taken from VAP ID bit #3)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 14,  0, 53,  FALSE, FALSE), //	TXQ UNI/MULTI 
	HOST_IF_UCODE_INSTRUCTION_WRITE(24,  1,  0, 	 FALSE, FALSE), //	PD next pointer null const
	HOST_IF_UCODE_INSTRUCTION_WRITE( 4,	 2,  24,	 TRUE,  FALSE), //	Writing zeros - retryCount
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_WRITE( 7,  0,  0, 	 FALSE, FALSE), //	TTL counter const
	HOST_IF_UCODE_INSTRUCTION_WRITE(56,  2,  8, 	 TRUE, FALSE),	//	Writing zeros (status+Frame subtype+PN)
	//Destination points to word6
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  23, 3, 0, 	 FALSE, FALSE),	//	Byte offset 
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  2,  3,  TRUE, TRUE),	//	Pointer to DRAM 
};


static const uint32 TxInAccFixedValues[] = 
{
	0xFFFFFFFF, 
    0x0,
};


/*---------------------------------------------------------------------------------
/						Tx Out HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 15,  0, 13, FALSE, FALSE), 	//	MC bit copy  
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8, 4,   3,  0, FALSE, FALSE),	//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 4, 13,  3,  8, FALSE, FALSE),	//	VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY (16, 0,   7, 32, FALSE, FALSE),	//	BD index copy  ====== debug for running counter sent to PP cable card
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 28,  2, 14, TRUE, FALSE),	//	EType copy
	HOST_IF_UCODE_INSTRUCTION_WRITE( 1,  3,  63, 	FALSE, FALSE),	//	Own bit const
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  6,  0, FALSE, FALSE),	//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  0, 32, FALSE, FALSE),	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  6,  3,	FALSE, FALSE),	//	Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  3, 56, TRUE,  TRUE),	//	TID-ID copy		
};

static const uint32 LgmPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY (32,  0,  6,  0, FALSE, FALSE),	//	Pointer to DRAM + Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  4, 	32, TRUE,   TRUE),	//	Const value of 0 (including own bit)
};


static const uint32 PumaPathTxOutAccCodeCDB[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 15,  0, 13, FALSE, FALSE), 	//	MC bit copy  
	HOST_IF_UCODE_INSTRUCTION_COPY ( 8, 4,   3,  0, FALSE, FALSE),	//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3, 13,  3,  8, FALSE, FALSE),	//	VAP-ID copy (first 3 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY ( 1, 17,  3, 11, FALSE, FALSE),	//	VAP-ID copy bit 4 of VAP in PD to bit 3 of VAP in HD
	HOST_IF_UCODE_INSTRUCTION_COPY (16, 0,   7, 32, FALSE, FALSE),	//	BD index copy  ====== debug for running counter sent to PP cable card
	HOST_IF_UCODE_INSTRUCTION_COPY ( 2, 28,  2, 14, TRUE,  FALSE),	//	EType copy
	HOST_IF_UCODE_INSTRUCTION_WRITE( 1,  3,  63, 	FALSE, FALSE),	//	Own bit const
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  6,  0, FALSE, FALSE),	//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY (14,  0,  0, 32, FALSE, FALSE),	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY (29,  3,  6,  3,	FALSE, FALSE),	//	Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY ( 3,  0,  3, 56, TRUE,  TRUE),	//	TID-ID copy		
};

static const uint32 SwPathTxOutAccCode[] = 
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 15, 0, 14,  FALSE, FALSE),	//	MC bit copy  
	HOST_IF_UCODE_INSTRUCTION_COPY( 3, 0,  3, 32,  FALSE, FALSE),	//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8, 4,  3, 0,   FALSE, FALSE),	//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 13, 3, 8,   FALSE, FALSE),	//	VAP-ID copy (first 4 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 17, 3, 40,  FALSE, FALSE),	//	EP copy (last bit of VAP)
	HOST_IF_UCODE_INSTRUCTION_WRITE(3, 1,  41,	   FALSE, FALSE),	//	EP write 3Msb (port set by driver in data path init request)
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 28, 2, 15,  TRUE,  FALSE),	//	etype copy
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(1, 3,  63,     FALSE, FALSE),	//	Own bit const
	HOST_IF_UCODE_INSTRUCTION_COPY( 3, 0,  6, 55,  FALSE, FALSE),	//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14, 0,  0, 32,  FALSE, FALSE),	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3,  6, 3,   TRUE,  FALSE),	//	Pointer to DRAM copy
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_COPY(16,0, 7, 0,     TRUE,  TRUE),	//	BD index copy
};


//	in GRX fast path there is an issue in the swp 64 so the HD is looks like, while FLM no such issue:
//																			GSWIP		FLM
//																			Word 1		Word 0
//																			Word 0		Word 1


static const uint32 FastPathTxOutAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3, 6, 3, TRUE, TRUE),		//	Pointer to DRAM copy 

};


static const uint32 FlmPathTxOutAccCode[] = 
{	
	HOST_IF_UCODE_INSTRUCTION_COPY(29, 3, 6, 3,   FALSE,  FALSE),	//	Pointer to DRAM copy	
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2,  32,  TRUE,  TRUE),	    //	Const value recieved from driver
};


static const uint32 TxOutAccFixedValues[] = 
{
	0xFFFFFFFF,
	0x0,
};

/*---------------------------------------------------------------------------------
/						Rx In HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathRxInAccCode[] = 
{ 
	HOST_IF_UCODE_INSTRUCTION_COPY (28,  4,  2,  4 ,  FALSE, FALSE),	//    Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  3,  	 32,  TRUE, TRUE),		//    Const value - (data legth + EType)
};


static const uint32 LgmPathRxInAccCode[] = 
{ 
	HOST_IF_UCODE_INSTRUCTION_COPY (28,  4,  0,  4 ,  FALSE, FALSE),	//    Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16,  3,  	 32,  TRUE, TRUE),		//    Const value - (data legth + EType)
};


static const uint32 SwPathRxInAccCode[] = 
{
	HOST_IF_UCODE_INSTRUCTION_COPY( 28, 4,  2, 4,  FALSE, FALSE),	//     -> Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(16, 3, 32,	   TRUE, FALSE),	//     -> Const value - (data legth + EType)
	0x280040,														//    0x280040 -> Empty line	
	HOST_IF_UCODE_INSTRUCTION_WRITE(5,  3, 24,	   TRUE, FALSE),	//     -> Const value
	HOST_IF_UCODE_INSTRUCTION_COPY( 16, 0,  4, 32, TRUE, TRUE),		//     -> BD index copy

};

/* There is no Rx In Code when working on Fast Data Path/FLM Mode*/

static const uint32 RxInAccFixedValues[] = 
{
    0xFFFFFFFF,
    0x0,
    0xBEEF,
};

/*---------------------------------------------------------------------------------
/						Rx Out HostIF Acc Code						
/----------------------------------------------------------------------------------*/
static const uint32 PumaPathRxOutAccCode[] = 
{ 
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 0,  7, 32,  FALSE, FALSE),	//	BD index copy ==== debug give the pp card a running counter
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 14,  FALSE, FALSE), 	//	EType copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2,  0,  FALSE, FALSE),	//	STA-ID copy -  need to be change for 256 sta
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 13, 2,  8,  TRUE,  FALSE),	//	VAP-ID copy -  need to be change for 32 vaps
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,	0, 2, 56,  FALSE, FALSE),	//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 61,  FALSE, FALSE),	//	SoP+EoP bits copy	   
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3,    63,  FALSE, FALSE),	//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1, 32,  FALSE, FALSE), 	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0,  3,  FALSE, FALSE),	//	Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0,  0,  TRUE,  TRUE),	// 	Byte offset copy -  need to be change for 16 bytes offset
};


static const uint32 PumaPathRxOutAccCodeCDB[] = 
{ 
	HOST_IF_UCODE_INSTRUCTION_COPY(16, 0,  7, 32,  FALSE, FALSE),	//	BD index copy ==== debug give the pp card a running counter
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 14,  FALSE, FALSE), 	//	EType copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2,  0,  FALSE, FALSE),	//	STA-ID copy -  need to be change for 256 sta
	HOST_IF_UCODE_INSTRUCTION_COPY( 3, 13, 2,  8,  FALSE, FALSE),	//	VAP-ID copy  (first 3 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 17, 2, 11,  TRUE,  FALSE),	//	VAP-ID copy  (copy bit #4 in PD vap id field to bit #3 in HD vap id field)
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,	0, 2, 56,  FALSE, FALSE),	//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 61,  FALSE, FALSE),	//	SoP+EoP bits copy	   
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3,    63,  FALSE, FALSE),	//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1, 32,  FALSE, FALSE), 	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0,  3,  FALSE, FALSE),	//	Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0,  0,  TRUE,  TRUE),	// 	Byte offset copy -  need to be change for 16 bytes offset
};


static const uint32 LgmPathRxOutAccCode[] = 
{ 
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 16,  FALSE, FALSE), 	//	EType copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2,  0,  FALSE, FALSE),	//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 5, 13, 2,  8,  FALSE, FALSE),	//	VAP-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,	0, 2, 40,  TRUE,  FALSE),	//	TID-ID copy

	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY(32,  0, 0,  0,  FALSE, FALSE),	//	Pointer to DRAM copy + Byte Offset
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2, 32,	  FALSE, FALSE),	//	Pool & policy (write word as is recieved from driver)	
	HOST_IF_UCODE_INSTRUCTION_COPY(14,	0, 1, 32,  FALSE, FALSE),	//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 60,  FALSE, FALSE),	//	SoP+EoP bits copy	   
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  4,    63,  TRUE,  TRUE),	//	Own bit
};



static const uint32 SwPathRxOutAccCode[] = 
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,  0, 2, 32,  FALSE, FALSE),		//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 15,  FALSE, FALSE),		//	etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2,  0,  FALSE, FALSE),		//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 13, 2,  8,  FALSE, FALSE),		//	VAP-ID copy (first 4 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 17, 2, 40,  FALSE, FALSE),	    //	EP copy (last bit of VAP)
	HOST_IF_UCODE_INSTRUCTION_WRITE(3, 1,  41,	   TRUE, FALSE),		//	EP write 3Msb (port set by driver in data path init request)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 60,  FALSE, FALSE),		//	SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,	3,  63, 	FALSE, FALSE),			//	 0x63E020 -> Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0, 55,  FALSE, FALSE),		//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1, 32,  FALSE, FALSE),		//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0,  3,  TRUE, FALSE),		//	Pointer to DRAM copy
	//Destination points to word4
	HOST_IF_UCODE_INSTRUCTION_COPY(16,  0, 7,  0,  TRUE, TRUE),			//	BD index copy 
};

//	in GRX fast path there is an issue in the swp 64 so the HD is looks like, while FLM no such issue:
//																			GRX			FLM
//																			Word 1		Word 0
//																			Word 0		Word 1
//																			Word 3		Word 2
//																			Word 2		Word 3
//
// this is why there is an 32 bit offset between the fast path and sw path micro code

static const uint32 FastPathRxOutAccCode[] =
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,  0, 2, 0,  FALSE, FALSE),		//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 47, FALSE, FALSE),		//	etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2, 32, FALSE, FALSE),		//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 13, 2, 40, TRUE, FALSE),			//	VAP-ID copy  (first and only4 bits of VAP)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3, 31,	  FALSE, FALSE),		//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 28, FALSE, FALSE),		//	SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0, 23, FALSE, FALSE),		//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1,  0, FALSE, FALSE),		//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0, 35, TRUE,  TRUE),			//	Pointer to DRAM copy
};

static const uint32 FastPathRxOutAccCodeCDB[] =
{
	//Destination points to word0
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,  0, 2, 0,  FALSE, FALSE),		//	TID-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 47, FALSE, FALSE),		//	etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2, 32, FALSE, FALSE),		//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3, 13, 2, 40, FALSE, FALSE),		//	VAP-ID copy  (first 3 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 17, 2, 43, TRUE, FALSE),			//	VAP-ID copy  (copy bit #4 in PD vap id field to bit #3 in HD vap id field)
	//Destination points to word2
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3, 31,	  FALSE, FALSE),		//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 28, FALSE, FALSE),		//	SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0, 23, FALSE, FALSE),		//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1,  0, FALSE, FALSE),		//	Data length copy
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0, 35, TRUE,  TRUE),			//	Pointer to DRAM copy
};

static const uint32 FlmPathRxOutAccCode[] =
{
	//Destination points to word0	
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2, 0,  FALSE, FALSE),		//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 13, 2, 8,  FALSE, FALSE),		//	VAP-ID copy  (first and only4 bits of VAP)	
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 15, FALSE, FALSE),		//	etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4,  0, 2, 32, FALSE, FALSE),		//	TID-ID copy	
	HOST_IF_UCODE_INSTRUCTION_WRITE(4, 1,  36,	  TRUE, FALSE),			//	IP write 4bits (port set by driver in data path init request)
	//Destination points to word2	
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0, 3,  FALSE,  FALSE),		//	Pointer to DRAM copy	
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2, 32,	  FALSE, FALSE),		//	Pool & policy (write word as is recieved from driver)	
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3, 63,	  FALSE, FALSE),		//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 60, FALSE, FALSE),		//	SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0, 55, FALSE, FALSE),		//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1,  32, TRUE, TRUE),			//	Data length copy
};

static const uint32 FlmPathRxOutAccCodeCDB[] =
{
	//Destination points to word0	
	HOST_IF_UCODE_INSTRUCTION_COPY( 8,  4, 2, 0,  FALSE, FALSE),		//	STA-ID copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 3, 13, 2, 8,  FALSE, FALSE),		//	VAP-ID copy  (first 3 bits of VAP)
	HOST_IF_UCODE_INSTRUCTION_COPY( 1, 17, 2, 11, FALSE, FALSE),		//	VAP-ID copy  (copy bit #4 in PD vap id field to bit #3 in HD vap id field)	
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 14, 1, 15, FALSE, FALSE),		//	etype copy
	HOST_IF_UCODE_INSTRUCTION_COPY( 4, 0, 2, 32,  FALSE, FALSE),		//	TID-ID copy	
	HOST_IF_UCODE_INSTRUCTION_WRITE(4, 1,  36,	  TRUE, FALSE),			//	IP write 4bits (port set by driver in data path init request)
	//Destination points to word2	
	HOST_IF_UCODE_INSTRUCTION_COPY(29,  3, 0, 3, FALSE, FALSE),			//	Pointer to DRAM copy
	HOST_IF_UCODE_INSTRUCTION_WRITE(32,  2, 32,	  FALSE, FALSE),		//	Pool & policy (write word as is recieved from driver)	
	HOST_IF_UCODE_INSTRUCTION_WRITE(1,  3, 63,	  FALSE, FALSE),		//	Own bit
	HOST_IF_UCODE_INSTRUCTION_COPY( 2, 24, 2, 60, FALSE, FALSE),		//	SoP+EoP bits copy     
	HOST_IF_UCODE_INSTRUCTION_COPY( 3,  0, 0, 55, FALSE, FALSE),		//	Byte offset copy
	HOST_IF_UCODE_INSTRUCTION_COPY(14,  0, 1,  32, TRUE, TRUE),			//	Data length copy
};



static const uint32 RxOutAccFixedValues[] = 
{
    0xFFFFFFFF,
    0x0,
};   

#endif //HOST_ACC_CODE_INCLUDED


