/***********************************************************************************
 File:		HostInterfaceHw.h
 Module:		HostInterfaceHw
 Purpose:	
 Description:	
************************************************************************************/
#ifndef HOST_INTERFACE_HW_H_
#define HOST_INTERFACE_HW_H_
/*---------------------------------------------------------------------------------
/								Includes						
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"

//#include "HostInterface.h"
#include "EventsManager_api.h"
#include "DmaManager_Api.h"
#include "RxDescriptor.h"
#include "HostInterface_API.h"
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/								Defines 					
/----------------------------------------------------------------------------------*/


#define NUM_OF_SHARED_RAM_BUFFERS   (2)
#define NUM_HDS_IN_TX_BUF    (32)
#define NUM_HDS_IN_RX_BUF    (32)    
#define TX_IN_BUFFER_SIZE   (NUM_HDS_IN_TX_BUF * sizeof(HostDescriptor_u))
#define TX_OUT_BUFFER_SIZE  (NUM_HDS_IN_TX_BUF * sizeof(HostDescriptor_u))
#define RX_IN_BUFFER_SIZE   (NUM_HDS_IN_RX_BUF * sizeof(HostDescriptor_u))
#define RX_OUT_BUFFER_SIZE  (NUM_HDS_IN_RX_BUF * sizeof(HostDescriptor_u))

/*---------------------------------------------------------------------------------
/								Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/								Data Type Definitions						
/----------------------------------------------------------------------------------*/

typedef void (*InDmaDoneFunc)(Hd_t* ,uint8);
typedef uint16 (*descsDoneListFunc)(Hd_t* ,uint8);



typedef struct HostIfShRamBuf_s HostIfShRamBuf_t;

struct HostIfShRamBuf_s
{ 
	HostIfShRamBuf_t *nextBuffer;	
	uint8* pBuffer; // pointer to the shared RAM buffer
	uint8  numHdInBuf; // number of HDs in the buffer
	uint8 status; // buffer status (empty / full)
	uint8 ringIndex;
	uint8 ringDirection;
};

typedef struct buffDb
{
	uint8 maxHdsInBuffer; // max number of HDs in buffer
	uint8 nextEmptyBufferIndex; // points to the next empty buffer to be used
 	uint8 nextFullBufferIndex;  // points to the next full buffer to be handled
	uint8 numOfFreeBuffers; // number of free buffers
	HostIfShRamBuf_t buffer[NUM_OF_SHARED_RAM_BUFFERS]; // Shared RAM buffers Db
}buffDb_t;



typedef enum {
	HOST_RING_MANG_RX,
	HOST_RING_MANG_TX,
	NUM_OF_HOST_RINGS 
}HostIfRings_e; 

typedef struct HdRingDb
{ 
	uint32  doneCounter; // how many HDs copied from the ring to Shared RAM
	uint32  ringStartAddr; // TX HD ring base address 
	uint32  ringEndAddr; // TX HD ring end address 
	uint32  readAddress; // FW read pointer from ring
	uint32  writeAddress; // FW write pointer to ring
	uint32  ringSizeBytes; // DDR HD ring size in bytes
	uint16  ringSizeHds; //max number of HDs in ring
	uint32* pInCounter; // pointer to the shared RAM in counter
	uint32* pOutCounter; // pointer to the shared RAM out counter
    uint32 inAccumStatusAddr;
    uint32 inAccumSubAddr;
    uint32 outAccumAddAddr;
	buffDb_t inBuffers; // Tx in buffers DB
	buffDb_t outBuffers; // Tx out buffers DB
    uint32 numOfFreeDescriptors;
    InDmaDoneFunc inDmaDoneHandler;
    descsDoneListFunc descsDoneListHandler;
    bool msgPending;
	eventId_e eventInId;
}HdRingDb_t;

/*---------------------------------------------------------------------------------
/						Static Function Declaration 								
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/							Static Variables								
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/							Public Variables								
/----------------------------------------------------------------------------------*/


extern HdRingDb_t* pRingsDb[NUM_OF_HOST_RINGS];
extern uint8 hostIfRingsDmaClientId;

extern rxDescriptorQueue_t driverRdsDoneList;
extern rxDescriptorQueue_t driverRdsTempList;
extern PacketDescriptorQueue_t driverPdsDoneList;


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

uint32 hostInterfaceGetNumOfReadyHdsInHostRing(HdRingDb_t* pRingDb);
void hostInterfaceIncNumOfDoneInHdsCounter(HdRingDb_t* pRingDb , uint16 numHdToCopy);
void hostInterfaceIncNumOfDoneOutHdsCounter(HdRingDb_t* pRingDb , uint16 numOfHds);
void hostInterfaceCheckForNewHdsOnDmaDone(void);
void hostInterfaceCheckForNewDesc(void);
void hostInterfaceCheckBroadcastProbeReq(Rd_t  *rxDescriptor);
bool hostInterfaceCheckDutMulticastManagement(Rd_t *rxDescriptor);



#endif /* HOST_INTERFACE_HW_H_ */

