/***********************************************************************************
 File:		HostInterfaceHw.c
 Module:		HostInterfaceHw
 Purpose:	
 Description:	
************************************************************************************/

/*---------------------------------------------------------------------------------
/								Includes						
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "HwQManager_API.h"
#include "HostInterface.h"
#include "RegAccess_Api.h"
#include "HwMemoryMap.h"
#include "HostIfAccRegs.h"
#include "DmaManager_Api.h"
#include "shramTxDesc.h"
#include "HostInterfaceHw.h"
#include "HostIfRegs.h"
#include "ShramPacketDescriptors.h"
#include "RxDescriptor.h"
#include "PacketDescriptor.h"

#include "loggerAPI.h"
#include "Dut_Api.h"
#include "RxManager_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define LOG_LOCAL_GID   GLOBAL_GID_HOST_IF
#define LOG_LOCAL_FID 8

#define TX_OUT_FREED_COUNTER_OFFSET 4 // PUMA Direct Connect: offset from the end of the SCPAD to the location of the counter (2 last addresses in SCPAD 
#define RX_OUT_FREED_COUNTER_OFFSET 8 // are reserved in order to get fixed addresses we can send to PUMA cable card)

/*---------------------------------------------------------------------------------
/								Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/								Data Type Definitions						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/								Debug section						
/----------------------------------------------------------------------------------*/
#ifdef PUMA_DEBUG_DIRECT_CONNECT
uint32 AAA_PUMA_sTxRING_u32InCounterAddress;
uint32 AAA_PUMA_sRxRING_u32InCounterAddress;
uint32 AAA_PUMA_sTxRING_u32InCounterAddressBigEnd;
uint32 AAA_PUMA_sRxRING_u32InCounterAddressBigEnd;
uint32 AAA_PUMA_sTxRING_u32OutFreedCounterAddressBigEnd;
uint32 AAA_PUMA_sRxRING_u32OutFreedCounterAddressBigEnd;
#endif // PUMA_DEBUG_DIRECT_CONNECT

/*---------------------------------------------------------------------------------
/						Static Function Declaration 								
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/							Static Variables								
/----------------------------------------------------------------------------------*/
static HostIfDataPathHdSize_t hostIfDataHdSizes[NUM_OF_DATA_PATH_MODE] = 
{
	/* Sw Data Path Sizes */
	{
		sizeof(Hd_t),
		sizeof(Hd_t),
		sizeof(Hd_t),
		sizeof(Hd_t),
	},
	/* FAST Data Path Sizes */
	{		
		sizeof(GswipHd_t),
		TX_OUT_HOST_DESCRIPTOR_SIZE,
		RX_IN_HOST_DESCRIPTOR_SIZE,
		sizeof(GswipHd_t),
	},
	/* PUMA Data path sizes */
	{
		sizeof(PumaHd_t),	
		sizeof(PumaHd_t),
		sizeof(PumaHd_t),			
		sizeof(PumaHd_t),	
	},
	/* LGM Data path sizes (starting from gen6b and above only) */
	{
#ifdef ENET_INC_ARCH_WAVE600B
		sizeof(Hd_t),				/* txInHdSize:	4 DW */
		sizeof(LgmReducedHd_t),		/* txOutHdSize: 2 DW */
		sizeof(LgmReducedHd_t),		/* rxInHdSize:	2 DW */			
		sizeof(Hd_t),				/* rxOutHdSize:	4 DW */
#endif //ENET_INC_ARCH_WAVE600B
	},
	/* FLM Data path sizes (starting from gen6b and above only) */
	{
#ifdef ENET_INC_ARCH_WAVE600B
		sizeof(FlmHd_t),				/* txInHdSize:	4 DW */
		sizeof(FlmReducedHd_t),			/* txOutHdSize: 2 DW */
		RX_IN_HOST_DESCRIPTOR_SIZE,		/* rxInHdSize:	0 DW */			
		sizeof(FlmHd_t),				/* rxOutHdSize:	4 DW */
#endif //ENET_INC_ARCH_WAVE600B
	}
};

/*---------------------------------------------------------------------------------
/							Public Variables								
/----------------------------------------------------------------------------------*/




GlobalHostIfDb_t GlobalHostIfRingsDb;
HdRingDb_t txMangRingDb;
HdRingDb_t rxMangRingDb;

rxDescriptorQueue_t driverRdsDoneList;
rxDescriptorQueue_t driverRdsTempList;
PacketDescriptorQueue_t driverPdsDoneList;
HdRingDb_t* pRingsDb[NUM_OF_HOST_RINGS];
uint8 hostIfRingsDmaClientId;


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

isr_HostIfTxInMangCountNotZero 

Description:
------------


**********************************************************************************/
ISR_VOID isr_HostIfTxInMangCountNotZero(void)
{	
	K_MSG* pRingDoneMsg = NULL;
	RingDoneData_t* pRingDoneData = NULL;

	EventManager_TurnOffEvent(EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY);
	pRingDoneMsg = OSAL_GET_MESSAGE(sizeof(RingDoneData_t));
	pRingDoneData = (RingDoneData_t*)pRingDoneMsg->abData;
	pRingDoneData->ringType = HOST_RING_MANG_TX;
	OSAL_SEND_MESSAGE(HIM_NEW_HDS_IN_HOST_RING,TASK_HIM,pRingDoneMsg, VAP_ID_DO_NOT_CARE);
}

/**********************************************************************************

isr_HostIfRxInMangCountNotZero 

Description:
------------


**********************************************************************************/
ISR_VOID isr_HostIfRxInMangCountNotZero(void)
{
	K_MSG* pRingDoneMsg = NULL;
	RingDoneData_t* pRingDoneData = NULL;

	EventManager_TurnOffEvent(EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY);
	pRingDoneMsg = OSAL_GET_MESSAGE(sizeof(RingDoneData_t));
	pRingDoneData = (RingDoneData_t*)pRingDoneMsg->abData;
	pRingDoneData->ringType = HOST_RING_MANG_RX;
	OSAL_SEND_MESSAGE(HIM_NEW_HDS_IN_HOST_RING,TASK_HIM,pRingDoneMsg, VAP_ID_DO_NOT_CARE);
}


uint32 hostInterfaceGetNumOfReadyHdsInHostRing(HdRingDb_t* pRingDb)
{
	uint32 ddrReadyHds;
	

    RegAccess_Read(pRingDb->inAccumStatusAddr,&ddrReadyHds);

	return ddrReadyHds;
}

void hostInterfaceIncNumOfDoneInHdsCounter(HdRingDb_t* pRingDb , uint16 numHdToCopy)
{
		
	RegAccess_Write(pRingDb->inAccumSubAddr,numHdToCopy);

	EventManager_TurnOnEvent(pRingDb->eventInId);		
	
}

void hostInterfaceIncNumOfDoneOutHdsCounter(HdRingDb_t* pRingDb , uint16 numOfHds)
{
	RegAccess_Write(pRingDb->outAccumAddAddr,numOfHds);
}

void hostInterfaceCheckForNewHdsOnDmaDone()
{
    hostInterfaceRingsNewHds(&rxMangRingDb);
    hostInterfaceRingsNewHds(&txMangRingDb);
}

void hostInterfaceCheckForNewDesc()
{
    hostInterfaceRingsNewDesc(&rxMangRingDb);
    hostInterfaceRingsNewDesc(&txMangRingDb);
}


void HostInterfaceRings_FillChiHostRingsInfo(volatile VECTOR_AREA_BASIC* pBasic)
{		
	pBasic->sTxRING.u32InCounterAddress  			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_IN_HD_ACCUM_ADD);
	pBasic->sTxRING.u32OutCounterAddress 			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_OUT_HD_ACCUM_SUB);
	pBasic->sTxRING.u32InStatusAddress   			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_IN_HD_ACCUM_COUNT);
	pBasic->sTxRING.u32OutStatusAddress  			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_OUT_HD_ACCUM_COUNT);
	pBasic->sTxRING.u32InCounterAddressBigEnd 		= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_IN_HD_ACCUM_ADD_BIG_END);
	pBasic->sTxRING.u32OutFreedCounterAddressBigEnd	= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_OUT_HD_ACCUM_ADD_READY_BIG_END);


	pBasic->sRxRING.u32InCounterAddress  			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_IN_HD_ACCUM_ADD);
	pBasic->sRxRING.u32OutCounterAddress 			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_OUT_HD_ACCUM_SUB);
	pBasic->sRxRING.u32InStatusAddress   			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_IN_HD_ACCUM_COUNT);
	pBasic->sRxRING.u32OutStatusAddress  			= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_OUT_HD_ACCUM_COUNT);
	pBasic->sRxRING.u32InCounterAddressBigEnd		= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_IN_HD_ACCUM_ADD_BIG_END);	
	pBasic->sRxRING.u32OutFreedCounterAddressBigEnd	= CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_OUT_HD_ACCUM_ADD_READY_BIG_END);

	pBasic->sMangTxRING.u32InCounterAddress  = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_IN_MGMT_ACCUM_ADD );
	pBasic->sMangTxRING.u32OutCounterAddress = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_OUT_MGMT_ACCUM_SUB);
	pBasic->sMangTxRING.u32InStatusAddress	 = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_IN_MGMT_ACCUM_COUNT);
	pBasic->sMangTxRING.u32OutStatusAddress  = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_TX_OUT_MGMT_ACCUM_COUNT);
	pBasic->sMangRxRING.u32InCounterAddress  = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_IN_MGMT_ACCUM_ADD);
	pBasic->sMangRxRING.u32OutCounterAddress = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_OUT_MGMT_ACCUM_SUB);
	pBasic->sMangRxRING.u32InStatusAddress	 = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_IN_MGMT_ACCUM_COUNT);
	pBasic->sMangRxRING.u32OutStatusAddress  = CONVERT_WLAN_HOST_IF_ACC_ADDR_TO_OFFSET_FROM_BAR0(REG_HOST_IF_RX_OUT_MGMT_ACCUM_COUNT);

	pBasic->sRdPOOL.u32RdPoolBaseAddress = CONVERT_WLAN_DESCRIPTOR_ADDR_TO_OFFSET_FROM_BAR0((uint32)&HostRxDescriptorsPool[0]);
    pBasic->sRdPOOL.u32RdSizeInBytes = sizeof(Rd_t);
    pBasic->sRdPOOL.u32PayloadAddressOffsetInRd = CONVERT_WORDS_TO_BYTES(0);
    pBasic->sRdPOOL.u32BdIndexOffsetInRd = CONVERT_WORDS_TO_BYTES(7);
    pBasic->sRdPOOL.u32NumRdsInPool = NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS;
    pBasic->sRdPOOL.u32NumMgmtRdsInPool = NUM_OF_HOST_MANAGEMENT_RX_DESCRIPTORS;
    pBasic->sRdPOOL.u32FirstMgmtRdIndex = INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR;

	pBasic->sPdPOOL.u32PdPoolBaseAddress = CONVERT_WLAN_DESCRIPTOR_ADDR_TO_OFFSET_FROM_BAR0((uint32)PacketDescriptorsPtr);
	pBasic->sPdPOOL.u32DataPdPoolOffsetFromBaseAddress = ((uint32)&PdDescPools.DataDescPool[0] - (uint32)PacketDescriptorsPtr);
    pBasic->sPdPOOL.u32PdSizeInBytes = sizeof(TxPd_t);
    pBasic->sPdPOOL.u32PayloadAddressOffsetInPd = CONVERT_WORDS_TO_BYTES(6);	
    pBasic->sPdPOOL.u32NextPdPointerOffsetInPd = CONVERT_WORDS_TO_BYTES(2);
	pBasic->sPdPOOL.u32NextPdPointerFieldMask = 0xFFFFFF;
	pBasic->sPdPOOL.u32MaxNumOfAvailablePds = NUM_OF_TX_DESC;
	
#ifdef PUMA_DEBUG_DIRECT_CONNECT
	/* debug start */
	AAA_PUMA_sTxRING_u32InCounterAddress  				= pBasic->sTxRING.u32InCounterAddress;
	AAA_PUMA_sRxRING_u32InCounterAddress				= pBasic->sRxRING.u32InCounterAddress;
	AAA_PUMA_sTxRING_u32InCounterAddressBigEnd			= pBasic->sTxRING.u32InCounterAddressBigEnd;
	AAA_PUMA_sRxRING_u32InCounterAddressBigEnd			= pBasic->sRxRING.u32InCounterAddressBigEnd;
	AAA_PUMA_sTxRING_u32OutFreedCounterAddressBigEnd	= pBasic->sTxRING.u32OutFreedCounterAddressBigEnd;
	AAA_PUMA_sRxRING_u32OutFreedCounterAddressBigEnd	= pBasic->sRxRING.u32OutFreedCounterAddressBigEnd;		
	/* debug end */	
#endif
}

void HostInterfaceRings_SetRingsParams(UMI_DATA_PATH_INIT_PARAMS* pInitParams)
{
	
	txMangRingDb.ringStartAddr = pInitParams->mangTxRingStartAddress;
	txMangRingDb.ringSizeBytes = pInitParams->mangTxRingSizeBytes;
	txMangRingDb.ringEndAddr = txMangRingDb.ringStartAddr+ txMangRingDb.ringSizeBytes;
	txMangRingDb.readAddress = txMangRingDb.ringStartAddr;
    txMangRingDb.writeAddress = txMangRingDb.ringStartAddr; 
	txMangRingDb.ringSizeHds = (txMangRingDb.ringSizeBytes / sizeof(Hd_t));


	rxMangRingDb.ringStartAddr = pInitParams->mangRxRingStartAddress;
	rxMangRingDb.ringSizeBytes = pInitParams->mangRxRingSizeBytes;
	rxMangRingDb.ringEndAddr = rxMangRingDb.ringStartAddr+ rxMangRingDb.ringSizeBytes;
	rxMangRingDb.readAddress = rxMangRingDb.ringStartAddr;
	rxMangRingDb.writeAddress = rxMangRingDb.ringStartAddr; 
	rxMangRingDb.ringSizeHds = (rxMangRingDb.ringSizeBytes / sizeof(Hd_t));

}

HostIfDataPathHdSize_t* HostInterfaceRings_GetHdSizes(DataPathMode_e dataPathMode)
{	
	return &hostIfDataHdSizes[dataPathMode];
}
	

void HostInterfaceRings_Init(void)
{
    memset(&ShramHostIfDb,0,sizeof(ShramHostIfRingsDb_t));
    memset(&GlobalHostIfRingsDb,0,sizeof(GlobalHostIfDb_t));
    memset(&txMangRingDb,0,sizeof(HdRingDb_t));
    memset(&rxMangRingDb,0,sizeof(HdRingDb_t));


    txMangRingDb.inBuffers.buffer[0].pBuffer  = &ShramHostIfDb.MangTxInShramBuffers[0][0];
	txMangRingDb.inBuffers.buffer[0].ringDirection = HOST_INTERFACE_RING_DIRECTION_IN;
	txMangRingDb.inBuffers.buffer[0].ringIndex = HOST_RING_MANG_TX;
	txMangRingDb.inBuffers.buffer[1].pBuffer  = &ShramHostIfDb.MangTxInShramBuffers[1][0];	
	txMangRingDb.inBuffers.buffer[1].ringDirection = HOST_INTERFACE_RING_DIRECTION_IN;
	txMangRingDb.inBuffers.buffer[1].ringIndex = HOST_RING_MANG_TX;
    txMangRingDb.outBuffers.buffer[0].pBuffer = &ShramHostIfDb.MangTxOutShramBuffers[0][0];
	txMangRingDb.outBuffers.buffer[0].ringDirection = HOST_INTERFACE_RING_DIRECTION_OUT;
	txMangRingDb.outBuffers.buffer[0].ringIndex  = HOST_RING_MANG_TX;
    txMangRingDb.outBuffers.buffer[1].pBuffer = &ShramHostIfDb.MangTxOutShramBuffers[1][0];
	txMangRingDb.outBuffers.buffer[1].ringDirection = HOST_INTERFACE_RING_DIRECTION_OUT;
	txMangRingDb.outBuffers.buffer[1].ringIndex  = HOST_RING_MANG_TX;
    txMangRingDb.inBuffers.maxHdsInBuffer = NUM_HDS_IN_TX_BUF;
    txMangRingDb.outBuffers.maxHdsInBuffer = NUM_HDS_IN_TX_BUF;
    txMangRingDb.inBuffers.numOfFreeBuffers = NUM_OF_SHARED_RAM_BUFFERS;
    txMangRingDb.outBuffers.numOfFreeBuffers = NUM_OF_SHARED_RAM_BUFFERS;
    txMangRingDb.inAccumStatusAddr = REG_HOST_IF_TX_IN_MGMT_ACCUM_COUNT;
    txMangRingDb.inAccumSubAddr = REG_HOST_IF_TX_IN_MGMT_ACCUM_SUB;
    txMangRingDb.outAccumAddAddr = REG_HOST_IF_TX_OUT_MGMT_ACCUM_ADD;
    txMangRingDb.numOfFreeDescriptors = NUM_OF_BSS_DESCRIPTORS;
    txMangRingDb.inDmaDoneHandler = hostInterfaceRingsConvertDriverHdsToPds;
    txMangRingDb.descsDoneListHandler = hostInterfaceRingsConvertDriverPdsToHds;
    txMangRingDb.msgPending = FALSE;
    txMangRingDb.eventInId = EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY;


    rxMangRingDb.inBuffers.buffer[0].pBuffer  = &ShramHostIfDb.MangRxInShramBuffers[0][0];
	rxMangRingDb.inBuffers.buffer[0].ringDirection =HOST_INTERFACE_RING_DIRECTION_IN;
	rxMangRingDb.inBuffers.buffer[0].ringIndex = HOST_RING_MANG_RX;
    rxMangRingDb.inBuffers.buffer[1].pBuffer  = &ShramHostIfDb.MangRxInShramBuffers[1][0];
	rxMangRingDb.inBuffers.buffer[1].ringDirection =HOST_INTERFACE_RING_DIRECTION_IN;
	rxMangRingDb.inBuffers.buffer[1].ringIndex = HOST_RING_MANG_RX;
    rxMangRingDb.outBuffers.buffer[0].pBuffer = &ShramHostIfDb.MangRxOutShramBuffers[0][0];
	rxMangRingDb.outBuffers.buffer[0].ringDirection = HOST_INTERFACE_RING_DIRECTION_OUT;
	rxMangRingDb.outBuffers.buffer[0].ringIndex = HOST_RING_MANG_RX;
    rxMangRingDb.outBuffers.buffer[1].pBuffer = &ShramHostIfDb.MangRxOutShramBuffers[1][0];
	rxMangRingDb.outBuffers.buffer[1].ringDirection = HOST_INTERFACE_RING_DIRECTION_OUT;
	rxMangRingDb.outBuffers.buffer[1].ringIndex = HOST_RING_MANG_RX;
    rxMangRingDb.inBuffers.maxHdsInBuffer = NUM_HDS_IN_RX_BUF;
    rxMangRingDb.outBuffers.maxHdsInBuffer = NUM_HDS_IN_RX_BUF;
    rxMangRingDb.inBuffers.numOfFreeBuffers = NUM_OF_SHARED_RAM_BUFFERS;
    rxMangRingDb.outBuffers.numOfFreeBuffers = NUM_OF_SHARED_RAM_BUFFERS;
    rxMangRingDb.inAccumStatusAddr = REG_HOST_IF_RX_IN_MGMT_ACCUM_COUNT;
    rxMangRingDb.inAccumSubAddr = REG_HOST_IF_RX_IN_MGMT_ACCUM_SUB;
    rxMangRingDb.outAccumAddAddr = REG_HOST_IF_RX_OUT_MGMT_ACCUM_ADD;
    rxMangRingDb.numOfFreeDescriptors = 0; // in Rx , free descriptor number is the number of Rds on the Rds temp list
    rxMangRingDb.inDmaDoneHandler = hostInterfaceRingsConvertDriverHdsToRds;
    rxMangRingDb.descsDoneListHandler = hostInterfaceRingsConvertDriverRdsToHds;
    rxMangRingDb.msgPending = FALSE;
    rxMangRingDb.eventInId = EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY;

    pRingsDb[HOST_RING_MANG_RX] = &rxMangRingDb;
    pRingsDb[HOST_RING_MANG_TX] = &txMangRingDb;

    driverRdsDoneList.pHead = (Rd_t *)NULL_RD;
    driverRdsDoneList.pTail = (Rd_t *)NULL_RD;

    driverRdsTempList.pHead = (Rd_t *)NULL_RD;
    driverRdsTempList.pTail = (Rd_t *)NULL_RD;

    driverPdsDoneList.pHead = (TxPd_t*)NULL_PD;
    driverPdsDoneList.pTail = (TxPd_t*)NULL_PD;
}

void HostInterfaceRings_PostInit(void)
{
	
	dmaRegistration_t dmaRegister;

	dmaRegister.priority = DMA_PRIORITY_5;
	dmaRegister.eventId = EVENT_ID_DMA_HOST_IF_DONE;

	hostIfRingsDmaClientId = DmaManager_Register(&dmaRegister);
}


bool hostInterfaceCheckDutMulticastManagement (Rd_t *rxDescriptor)
{
   HwQueueManagerRequestParams_t hwQueueManagerRequestParams;

   if(RxManager_GetDutOpeationMode() != OPERATION_MODE_DUT)
   {
    	return (FALSE);
   }
   if ((rxDescriptor->broadcast) &&
        (rxDescriptor->frameType == FM_CONTROL_FTYPE_MANAGEMENT) &&
       (rxDescriptor->frameSubtype == MGMT_FRAME_SUBTYPE_ACTION))
   {
      /*Assume only Public category*/
	  RxManager_IncDutRxCount();
   }
   memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
   hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_RX_LISTS_DLM;
   hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
   hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_RX_LIBERATOR_INPUT_LIST;
   hwQueueManagerRequestParams.pHeadDesc = rxDescriptor;
   HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);      
   return (TRUE);
}



