/***********************************************************************************
 File:		HwBeamforming_Api.h
 Module:		Hw Beamforming
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_BEAMFORMING_API_H_
#define HW_BEAMFORMING_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
typedef enum
{
	BF_RE_FORMAT_NO_REPORT_EXPECTED 		= 0,
	BF_RE_FORMAT_IMMEDIATE_REPORT_EXPECTED 	= 1, /* Mandatory In Excel File*/
	BF_RE_FORMAT_DELAYED_REPORT_EXPECTED 	= 2, /* Optional In Excel File */
}BfResponseFormat_e;

typedef enum
{
	BF_DB_UPDATE_MODE_HW = 0,/* The BF DB is updated during Rx by HW */
	BF_DB_UPDATE_MODE_FW = 1 /* The BF DB is updated by FW */
} BfDbUpdateMode_e;

typedef enum
{
	
	BF_RX_MODE_DISABLED				= 0x0, /* Disable updating BF DB during Rx */
	BF_RX_MODE_UNSUPPORTED			= 0x1, /* update BF DB during Rx without checking the sounding bit */
	BF_RX_MODE_EXPLICIT_BEAMFORMEE	= 0x6, /* transmit BF frame report) & Rx Update unsupported BF (update BF DB during Rx without checking the sounding bit */
	BF_RX_MODE_EXPLICIT_BEAMFORMER_AND_BEAMFORMEE	= 0x7, /* update BF DB during Rx of BF frame report & Beamformee (transmit BF frame report) */
} BfMethod_e;


typedef enum
{
	MINIMAL_GROUPING_1 = 0,
	MINIMAL_GROUPING_1_2,
	MINIMAL_GROUPING_1_4,
	MINIMAL_GROUPING_1_2_4,
} BfMinimalGrouping_e;

typedef enum
{
	HW_MCS_FEEDBACK_UPDATING_DISABLED= 0,
	HW_MCS_FEEDBACK_UPDATING_ENABLED = 1
}HwMcsFeedbackUpadating_e;

typedef enum
{
	BF_AGING_MODE_FAST 		= 0,
	BF_AGING_MODE_MEDIUM_1	= 1,
	BF_AGING_MODE_MEDIUM_2	= 2,
	BF_AGING_MODE_SLOW		= 3,
} BfAgingMode_e;

typedef enum
{
	BF_DB_NOT_VALID = 0,
	BF_DB_VALID = 1,
}BfDbValid_e;


typedef enum
{
	BF_DB_AGING_STATUS_OLD		= 0,
	BF_DB_AGING_STATUS_VALID	= 1,
}BfDbAgingStatus_e;

typedef enum
{
	MCS_FEEDBACK_NOT_VALID	= 0,
	MCS_FEEDBACK_VALID 		= 1,
}MfbValid_e;


#define MAC_BF_BF_NONSTANDARD_IMP_RULES_INDX_VHT_STA 0
#define MAC_BF_BF_NONSTANDARD_IMP_RULES_INDX_HT_STA 1



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
#ifndef ENET_INC_ARCH_WAVE600
void HwBeamforming_Init(void);
#endif //ENET_INC_ARCH_WAVE600

#endif   /* HW_BEAMFORMING_API_H_ */
