/***********************************************************************************
 File:		HwBeamforming.c
 Module:		Hw Beamforming
 Purpose:		
 Description:	FW driver for Hw Beamforming Module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "HwBeamforming_Api.h"
#include "MacBfRegs.h"
#include "StaDb.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "ShramBeamforming.h"
#include "loggerAPI.h"
#include "VapDb.h"
#include "ieee80211.h"
#include "ConfigurationManager_api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_HW_DRIVERS
#define LOG_LOCAL_FID 2


#define HW_BEAMORNING_GLOBAL_ENABLE 			(1)
#define HW_BEAMORNING_ENABLE_AGING_NON_STANDARD (1)
#define HW_BEAMORNING_ENABLE_AGING_STANDARD 	(1)



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

HwBeamforming_Init 

Description:
------------
	Enable Beamforming HW
	Confugre required base addreses 
	Init interrupt configuration 

Input:
-----
Output:
-------
	
Returns:
--------
	void - 
**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void HwBeamforming_Init(void)
{
	RegMacBfBfEnable_u bfEnableReg;
	RegMacBfBfDbBaseAddr_u dbBaseAddrReg;
	RegMacBfTxBfeeBufferAddr_u txBfeeBufferAddrReg;
	RegMacBfStaDbBfWordsOffset_u staDbBfWordOffsetReg;
	RegMacBfBfIndexesTableBaseAddr_u bfIndexTableBaseAddr;
	RegMacBfVapDbBssidAid4BOffset_u bfVapDbBssidAid4BOffset;
	RegMacBfBfeeMacHdrLength_u bfBfeeMacHdrLength;
	RegMacBfBfNonstandardImpRulesIdx0_u RegMacBfBfNonstandardImpRulesIdx0;
	RegMacBfBfNonstandardImpRulesIdx1_u RegMacBfBfNonstandardImpRulesIdx1;
	RegMacBfBfNonstandardImpRulesIdx2_u RegMacBfBfNonstandardImpRulesIdx2;
	RegMacBfBfNonstandardImpRulesIdx3_u RegMacBfBfNonstandardImpRulesIdx3;
	uint8 i;
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();	
	
	
	bfEnableReg.val = 0;
	dbBaseAddrReg.val = 0;
	txBfeeBufferAddrReg.val = 0;
	staDbBfWordOffsetReg.val = 0;
	bfIndexTableBaseAddr.val = 0;
	bfVapDbBssidAid4BOffset.val = 0;
	bfBfeeMacHdrLength.val = 0;
	RegMacBfBfNonstandardImpRulesIdx0.val = 0;
	RegMacBfBfNonstandardImpRulesIdx1.val = 0;
	RegMacBfBfNonstandardImpRulesIdx2.val = 0;
	RegMacBfBfNonstandardImpRulesIdx3.val = 0;
	
	/* Enable Hw Beamforming module and abeamforming aging mechanism*/
	bfEnableReg.bitFields.bfEnable = HW_BEAMORNING_GLOBAL_ENABLE;	
	bfEnableReg.bitFields.agingNonstandardBfEnable = HW_BEAMORNING_ENABLE_AGING_NON_STANDARD;	
	bfEnableReg.bitFields.agingStandardBfEnable = HW_BEAMORNING_ENABLE_AGING_STANDARD; 
	RegAccess_Write(REG_MAC_BF_BF_ENABLE,bfEnableReg.val);
	/* Configure physical shram address of  Beamforming DB */
	dbBaseAddrReg.bitFields.bfDbBaseAddr = CONVERT_TO_PHYSICAL_ADDR(BeamformingDatabase);
	RegAccess_Write(REG_MAC_BF_BF_DB_BASE_ADDR,dbBaseAddrReg.val);
	/* Configure  physical BF Buffer address to Tx Cyclic Buffer*/		
	//bf start address will be in middle of buffer
	txBfeeBufferAddrReg.bitFields.txBfeeBufferAddr = CONVERT_PHYSICAL_TO_SHRAM_OFFSET((SHARED_RAM_TX_CIRCULAR0_BASE_ADDR + 0x800));
	txBfeeBufferAddrReg.bitFields.txBfeeBufferPointsTxCyclicBuf = TRUE;

	RegAccess_Write(REG_MAC_BF_TX_BFEE_BUFFER_ADDR,txBfeeBufferAddrReg.val);
	/* Set BF word offset in sta DB*/
	staDbBfWordOffsetReg.bitFields.staDbBfWordsOffset = 3;//FM_STRUCT_OFFSET(StaDb_t,bfRxHwFwMode); /* offset = 3*/
	RegAccess_Write(REG_MAC_BF_STA_DB_BF_WORDS_OFFSET,staDbBfWordOffsetReg.val);
	/* Set Auto ReplyDegradation Offset*/
	RegAccess_Write(REG_MAC_BF_BF_RPT_AUTO_REPLY_MCS_DEGRADATION_VAL_VAP0TO7,0x44444444);
	RegAccess_Write(REG_MAC_BF_BF_RPT_AUTO_REPLY_MCS_DEGRADATION_VAL_VAP8TO15,0x44444444);

	bfVapDbBssidAid4BOffset.bitFields.vapDbBssidAid4BOffset = FM_STRUCT_OFFSET(VapDb_t,bssid) >> 0x2;
	RegAccess_Write(REG_MAC_BF_VAP_DB_BSSID_AID_4B_OFFSET,bfVapDbBssidAid4BOffset.val);

	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsVerifyBwToBwScrambler = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0CtsVerifyBwScramblerToDb = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0AckBaAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx0.bitFields.idx0OtherRxAgingIgnoreNssDbRules = 0;
	RegAccess_Write(REG_MAC_BF_BF_NONSTANDARD_IMP_RULES_IDX0,RegMacBfBfNonstandardImpRulesIdx0.val);

	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsVerifyBwToBwScrambler = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1CtsVerifyBwScramblerToDb = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1AckBaAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx1.bitFields.idx1OtherRxAgingIgnoreNssDbRules = 0;
	RegAccess_Write(REG_MAC_BF_BF_NONSTANDARD_IMP_RULES_IDX1,RegMacBfBfNonstandardImpRulesIdx1.val);

	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsVerifyBwToBwScrambler = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2CtsVerifyBwScramblerToDb = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2AckBaAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx2.bitFields.idx2OtherRxAgingIgnoreNssDbRules = 0;
	RegAccess_Write(REG_MAC_BF_BF_NONSTANDARD_IMP_RULES_IDX2,RegMacBfBfNonstandardImpRulesIdx2.val);

	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsVerifyBwToBwScrambler = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3CtsVerifyBwScramblerToDb = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3AckBaAgingIgnoreNssDbRules = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxNeverUpdate = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxVerifyBwToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxVerifyNssToDb = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxVerifyNssToMaxTxNss = 0;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxAgingIgnoreBwDbRules = 1;
	RegMacBfBfNonstandardImpRulesIdx3.bitFields.idx3OtherRxAgingIgnoreNssDbRules = 0;
	RegAccess_Write(REG_MAC_BF_BF_NONSTANDARD_IMP_RULES_IDX3,RegMacBfBfNonstandardImpRulesIdx3.val);

	/* Init &  Configure physical  shram address of  BF indexes table */
	for(i = firstSidInBand; i < (firstSidInBand + numOfSidsInBand); i++)
	{
		BeamformingIndexesTable[i] = i+1;
	}
	bfIndexTableBaseAddr.bitFields.bfIndexesTableBaseAddr = CONVERT_TO_PHYSICAL_ADDR(BeamformingIndexesTable);			
	RegAccess_Write(REG_MAC_BF_BF_INDEXES_TABLE_BASE_ADDR,bfIndexTableBaseAddr.val);

	bfBfeeMacHdrLength.bitFields.bfeeMacHdrLength = 24;	/*Default value includes HTC but not all STAs support it ...*/
	RegAccess_Write(REG_MAC_BF_BFEE_MAC_HDR_LENGTH, bfBfeeMacHdrLength.val);
	
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default 
#endif





