/************************************************************************************
*
*	File:				TxMpduDescriptor_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_A0_mac_descriptors_ver0.32.3.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _TX_MPDU_DESCRIPTOR_DESC_H_
#define _TX_MPDU_DESCRIPTOR_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _TxMpduDescriptorCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 securityMainKeyEntryIdx : 12; //bits [0..11]
			uint32 duplication             : 3;  //bits [12..14]
			uint32 triggerFrame            : 1;  //bit [15]
			uint32 zldCount                : 10; //bits [16..25]
			uint32 lastInStation           : 1;  //bit [26]
			uint32 fcChk                   : 1;  //bit [27]
			uint32 addDuration             : 2;  //bits [28..29]
			uint32 eof                     : 1;  //bit [30]
			uint32 addDelimiter            : 1;  //bit [31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 securityMicKeyEntryIdx : 12; //bits [0..11]
			uint32                        : 20;
		}; //TKIP/WAPI/GCMP256
		struct
		{
			uint32    : 12;
			uint32 fn : 4;  //bits [12..15]
			uint32    : 16;
		}; //Fragment Number
		struct
		{
			uint32              : 16;
			uint32 frameControl : 16; //bits [16..31]
		};
		struct
		{
			uint32                 : 16;
			uint32 protocolVersion : 2;  //bits [16..17]
			uint32                 : 14;
		};
		struct
		{
			uint32      : 18;
			uint32 type : 2;  //bits [18..19]
			uint32      : 12;
		};
		struct
		{
			uint32         : 20;
			uint32 subtype : 4;  //bits [20..23]
			uint32         : 8;
		};
		struct
		{
			uint32      : 24;
			uint32 toDs : 1;  //bit [24]
			uint32      : 7;
		};
		struct
		{
			uint32        : 25;
			uint32 fromDs : 1;  //bit [25]
			uint32        : 6;
		};
		struct
		{
			uint32               : 26;
			uint32 moreFragments : 1;  //bit [26]
			uint32               : 5;
		};
		struct
		{
			uint32       : 27;
			uint32 retry : 1;  //bit [27]
			uint32       : 4;
		};
		struct
		{
			uint32                 : 28;
			uint32 powerManagement : 1;  //bit [28]
			uint32                 : 3;
		};
		struct
		{
			uint32          : 29;
			uint32 moreData : 1;  //bit [29]
			uint32          : 2;
		};
		struct
		{
			uint32                : 30;
			uint32 protectedFrame : 1;  //bit [30]
			uint32                : 1;
		};
		struct
		{
			uint32          : 31;
			uint32 htcOrder : 1;  //bit [31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 securitySwAttributes : 10; //bits [0..9]
			uint32                      : 22;
		};
		struct
		{
			uint32 isEncryption : 1;  //bit [0]
			uint32              : 31;
		};
		struct
		{
			uint32                   : 1;
			uint32 generateInterrupt : 1;  //bit [1]
			uint32                   : 30;
		};
		struct
		{
			uint32                : 2;
			uint32 encryptionType : 4;  //bits [2..5], values from SecurityTypeSecd_e
			uint32                : 26;
		};
		struct
		{
			uint32                 : 6;
			uint32 sppAmsduCapable : 1;  //bit [6]
			uint32                 : 25;
		}; //relevant to CCMP and GCMP only
		struct
		{
			uint32       : 7;
			uint32 keyId : 2;  //bits [7..8]
			uint32       : 23;
		}; //relevant to WEP only
		struct
		{
			uint32                        : 9;
			uint32 reservedSecSwAttribute : 1;  //bit [9]
			uint32                        : 22;
		};
		struct
		{
			uint32                 : 10;
			uint32 totalMpduLength : 14; //bits [10..23]
			uint32                 : 8;
		};
		struct
		{
			uint32     : 24;
			uint32 tid : 4;  //bits [24..27]
			uint32     : 4;
		}; //Traffic Identifier
		struct
		{
			uint32          : 28;
			uint32 fragment : 1;  //bit [28]
			uint32          : 3;
		}; //Fragmented Mode
		struct
		{
			uint32            : 29;
			uint32 reserved20 : 1;  //bit [29]
			uint32            : 2;
		};
		struct
		{
			uint32           : 30;
			uint32 ackPolicy : 2;  //bits [30..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 headerPointer80211 : 25; //bits [0..24], Pointer to 802.11 Header
			uint32 userId             : 7;  //bits [25..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 vapIndex     : 7;  //bits [0..6], VAP Index
			uint32 stationIndex : 9;  //bits [7..15], Station Index
			uint32 sn           : 12; //bits [16..27], Sequence Number
			uint32 reserved40   : 4;  //bits [28..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 nextMpduDescriptor : 16; //bits [0..15], In resolution of 4bytes
			uint32 pn0                : 8;  //bits [16..23], PN_0
			uint32 pn1                : 8;  //bits [24..31], PN_1
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 pn2 : 8;  //bits [0..7], PN_2
			uint32 pn3 : 8;  //bits [8..15], PN_3
			uint32 pn4 : 8;  //bits [16..23], PN_4
			uint32 pn5 : 8;  //bits [24..31], PN_5
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 amsduMsduFragByteLength : 14; //bits [0..13]
			uint32                         : 18;
		}; //A-MSDU/MSDU/Fragment Byte Length
		struct
		{
			uint32            : 14;
			uint32 reserved70 : 2;  //bits [14..15]
			uint32            : 16;
		};
		struct
		{
			uint32                : 16;
			uint32 fragmentOffset : 14; //bits [16..29]
			uint32                : 2;
		}; //Fragment Offset
		struct
		{
			uint32                      : 16;
			uint32 amsduDmaTransactions : 8;  //bits [16..23]
			uint32                      : 8;
		}; //Number of A-MSDU DMA Transactions
		struct
		{
			uint32            : 24;
			uint32 reserved71 : 6;  //bits [24..29]
			uint32            : 2;
		};
		struct
		{
			uint32            : 30;
			uint32 reserved72 : 2;  //bits [30..31]
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 mpduPdTailPointer : 24; //bits [0..23], Tail Pointer of PD within an MPDU
			uint32 msduCount         : 5;  //bits [24..28]
			uint32 reserved80        : 3;  //bits [29..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 mpduPdHeadPointer : 24; //bits [0..23], Head Pointer of PD within an MPDU
			uint32 tidIndex          : 7;  //bits [24..30], TID Index - Internal index. The allocated index of a unique TID (one of NUM_USERS maximal TIDs) which is part of a PPDU
			uint32 reserved90        : 1;  //bit [31]
		};
	};
} TxMpduDescriptorCommon_t;

typedef TxMpduDescriptorCommon_t TxMpduDescriptor_t;

#endif //_TX_MPDU_DESCRIPTOR_DESC_H_
