/************************************************************************************
*
*	File:				TxPd_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_A0_mac_descriptors_ver0.32.3.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _TX_PD_DESC_H_
#define _TX_PD_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _TxPdCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 dataLength : 14; //bits [0..13], PD Length in bytes
			uint32 powerMng   : 1;  //bit [14], Used for STA Mode NDP PD Type - OTFA always copies as is to the Frame Control and it's FW repsonsibility to set it only for NDP (or when needed)
			uint32 mcUnicast  : 1;  //bit [15], values from McUnicast_e, Multicast/Unicast indication
			uint32 fn         : 4;  //bits [16..19], Fragment Number
			uint32 sn         : 12; //bits [20..31], Sequence Number (Not valid in Control frames)
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 aMsduTailPointer : 24; //bits [0..23]
			uint32                  : 8;
		}; //Valid in the first PD of an MPDU with multiple PDs
		struct
		{
			uint32           : 24;
			uint32 pdCounter : 5;  //bits [24..28]
			uint32           : 3;
		}; //Valid in the first PD of an MPDU with multiple PDs
		struct
		{
			uint32 aMsduDataLength : 14; //bits [0..13]
			uint32                 : 18;
		}; //Valid in the last PD of an MPDU with multiple PDs
		struct
		{
			uint32                      : 14;
			uint32 aMsduDmaTransactions : 8;  //bits [14..21]
			uint32                      : 10;
		}; //Valid in the last PD of an MPDU with multiple PDs
		struct
		{
			uint32            : 22;
			uint32 reserved10 : 7;  //bits [22..28]
			uint32            : 3;
		}; //Valid in the last PD of an MPDU with multiple PDs
		struct
		{
			uint32 mgmtPacketType : 12; //bits [0..11]
			uint32                : 20;
		}; //Valid in MGMT PD
		struct
		{
			uint32 mgmtActionValue : 5;  //bits [0..4]
			uint32                 : 27;
		}; //Valid in MGMT PD
		struct
		{
			uint32                : 5;
			uint32 mgmtActionCode : 7;  //bits [5..11]
			uint32                : 20;
		}; //Valid in MGMT PD
		struct
		{
			uint32                     : 12;
			uint32 beaconProberesIndex : 8;  //bits [12..19]
			uint32                     : 12;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32        : 20;
			uint32 ctrlBw : 2;  //bits [20..21]
			uint32        : 10;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32            : 22;
			uint32 reserved11 : 6;  //bits [22..27]
			uint32            : 4;
		};
		struct
		{
			uint32 fragmentOffset : 14; //bits [0..13]
			uint32                : 18;
		}; //Valid in case of fragmentation
		struct
		{
			uint32                : 14;
			uint32 fragByteLength : 14; //bits [14..27]
			uint32                : 4;
		}; //Valid in case of fragmentation
		struct
		{
			uint32            : 28;
			uint32 reserved12 : 1;  //bit [28]
			uint32            : 3;
		}; //Valid in case of fragmentation
		struct
		{
			uint32 reserved13 : 24; //bits [0..23]
			uint32            : 8;
		}; //Valid in case RTS Counter is used - No A-MSDU, No Fragment, PD Type 0 or 1, Single MPDU
		struct
		{
			uint32            : 24;
			uint32 rtsCounter : 4;  //bits [24..27]
			uint32            : 4;
		}; //Valid in case RTS Counter is used - No A-MSDU, No Fragment, PD Type 0 or 1, Single MPDU
		struct
		{
			uint32            : 28;
			uint32 reserved14 : 1;  //bit [28]
			uint32            : 3;
		}; //Valid in case RTS Counter is used - No A-MSDU, No Fragment, PD Type 0 or 1, Single MPDU
		struct
		{
			uint32      : 29;
			uint32 frag : 1;  //bit [29]
			uint32      : 2;
		}; //Fragmentation indication - Valid in the first PD of an MPDU
		struct
		{
			uint32                          : 30;
			uint32 retransmissionIndication : 1;  //bit [30]
			uint32                          : 1;
		}; //Retransmission indication - Valid in the first PD of an MPDU
		struct
		{
			uint32                       : 31;
			uint32 aggregationIndication : 1;  //bit [31]
		}; //Aggregation indication - Valid in the first PD of an MPDU
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 nextPdPointer : 24; //bits [0..23]
			uint32               : 8;
		}; //DW address; NULL == 0xFFFFFF
		struct
		{
			uint32                  : 24;
			uint32 mgmtFrameSubtype : 4;  //bits [24..27], values from MgmtFrameSubtype_e
			uint32                  : 4;
		}; //Frame Subtype - Valid in Mgmt PDs (not beacon)
		struct
		{
			uint32                    : 24;
			uint32 beaconFrameSubtype : 4;  //bits [24..27], values from BeaconFrameSubtype_e
			uint32                    : 4;
		}; //Frame Subtype - Valid in beacon PDs
		struct
		{
			uint32                  : 24;
			uint32 ctrlFrameSubtype : 4;  //bits [24..27], values from CtrlFrameSubtype_e
			uint32                  : 4;
		}; //Frame Subtype - Valid in control PDs
		struct
		{
			uint32         : 28;
			uint32 ethType : 2;  //bits [28..29], values from EthType_e
			uint32         : 2;
		}; //valid in DATA
		struct
		{
			uint32            : 30;
			uint32 unnkownSid : 1;  //bit [30]
			uint32            : 1;
		};
		struct
		{
			uint32           : 31;
			uint32 reserved2 : 1;  //bit [31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 txQId : 23; //bits [0..22]
			uint32       : 9;
		};
		struct
		{
			uint32 txQTid : 4;  //bits [0..3]
			uint32        : 28;
		};
		struct
		{
			uint32          : 4;
			uint32 txQStaId : 9;  //bits [4..12]
			uint32          : 19;
		}; //valid in u/c packets
		struct
		{
			uint32              : 4;
			uint32 mcGroupIndex : 9;  //bits [4..12]
			uint32              : 19;
		}; //valid in m/c packets, range 0..63
		struct
		{
			uint32          : 13;
			uint32 txQVapId : 7;  //bits [13..19]
			uint32          : 12;
		};
		struct
		{
			uint32            : 20;
			uint32 txQGroupId : 3;  //bits [20..22], values from TxqGroupId_e
			uint32            : 9;
		};
		struct
		{
			uint32           : 23;
			uint32 reserved3 : 1;  //bit [23]
			uint32           : 8;
		};
		struct
		{
			uint32        : 24;
			uint32 pdType : 5;  //bits [24..28], values from PdType_e
			uint32        : 3;
		}; //PD Type
		struct
		{
			uint32          : 29;
			uint32 pdSource : 3;  //bits [29..31]
		}; //PD Source
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 ttlCount : 7;  //bits [0..6]
			uint32          : 25;
		}; //TTL Count
		struct
		{
			uint32           : 7;
			uint32 reserved4 : 1;  //bit [7]
			uint32           : 24;
		};
		struct
		{
			uint32        : 8;
			uint32 status : 4;  //bits [8..11]
			uint32        : 20;
		};
		struct
		{
			uint32            : 12;
			uint32 retryCount : 4;  //bits [12..15]
			uint32            : 16;
		}; //Retry Count - Valid in the first PD of an MPDU
		struct
		{
			uint32      : 16;
			uint32 pn01 : 16; //bits [16..31]
		}; //Not in CTRL/NDP/Unencrypted
		struct
		{
			uint32                            : 16;
			uint32 beaconProbeRespTotalLength : 14; //bits [16..29]
			uint32                            : 2;
		}; //Valid in Beacon & Probe Response PDs when activate dma is set
		struct
		{
			uint32                            : 30;
			uint32 beaconProbeRespActivateDma : 1;  //bit [30]
			uint32                            : 1;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32                                  : 31;
			uint32 beaconProbeRespLastDmaActivation : 1;  //bit [31]
		}; //Valid in Beacon & Probe Response PDs
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 pn25 : 32; //bits [0..31]
		}; //Not in CTRL/NDP/Unencrypted
		struct
		{
			uint32 ctrlDuration : 16; //bits [0..15]
			uint32              : 16;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32 beaconProbeRespOffsetFromPacketStart : 16; //bits [0..15]
			uint32                                      : 16;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32           : 16;
			uint32 reserved6 : 16; //bits [16..31]
		}; //Valid in CTRL_UNENC PD
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 packetPointer : 32; //bits [0..31]
		};
		struct
		{
			uint32 packetPointerByteOffset : 4;  //bits [0..3]
			uint32                         : 28;
		};
		struct
		{
			uint32                      : 4;
			uint32 packetPointerInWords : 28; //bits [4..31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 bdIndex   : 16; //bits [0..15], For SW path mode
			uint32 reserved7 : 16; //bits [16..31]
		};
	};
} TxPdCommon_t;

typedef TxPdCommon_t TxPd_t;

#endif //_TX_PD_DESC_H_
