/************************************************************************************
*
*	File:				UlDataPhase_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_A0_mac_descriptors_ver0.32.3.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _UL_DATA_PHASE_DESC_H_
#define _UL_DATA_PHASE_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _UlDataPhaseCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 validUsers310 : 32; //bits [0..31], TX Valid Users bitmap (bits 31:0). 0 - User not valid;  1 - User valid
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 validUsers3532     : 4;  //bits [0..3], TX Valid Users bitmap (bits 35:32). 0 - User not valid;  1 - User valid
			uint32 phaseType          : 3;  //bits [4..6], values from PhaseType_e, 0 - Protection Phase;  1 - Sounding Phase;  2 - DL Data Phase;  3 - UL Phase
			uint32 oneShotPhase       : 1;  //bit [7], Phase will run one time then sender will clear the phase valid bit of this phase. 0 - one shot disabled;  1 - one shot enabled
			uint32 partialDuration    : 18; //bits [8..25], Time in usec
			uint32 keepPlanLock       : 1;  //bit [26], Keep Plan Lock, 	indicates if to keep the Plan Lock (instead of Unlock at the end of TXOP)	0  Unlock at the end of TXOP	1  Keep Plan Lock
			uint32 moveStaToSu        : 1;  //bit [27], Move STA to SU	Indicates if STAs in this Phase need to be set to SU	0  dont change/update STA to SU	1  update STA to SU	Note: this configuration is intended to UL Phase for Training with all phases as one shot, if used in this phase need to verify that Sender support it 
			uint32 tfParamTriggerType : 3;  //bits [28..30], values from TfType_e
			uint32 commonReserved10   : 1;  //bit [31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 actionBitmap : 16; //bits [0..15]
			uint32              : 16;
		}; //Action Bitmap
		struct
		{
			uint32 plannedTrainingFiller : 1;  //bit [0]
			uint32                       : 31;
		};
		struct
		{
			uint32                : 1;
			uint32 plannedMuBarTf : 1;  //bit [1]
			uint32                : 30;
		};
		struct
		{
			uint32            : 2;
			uint32 plannedBar : 1;  //bit [2]
			uint32            : 29;
		};
		struct
		{
			uint32             : 3;
			uint32 plannedUlTf : 1;  //bit [3]
			uint32             : 28;
		}; //UL data/BSRP
		struct
		{
			uint32             : 4;
			uint32 plannedData : 1;  //bit [4]
			uint32             : 27;
		}; //DL data
		struct
		{
			uint32               : 5;
			uint32 plannedBfrpTf : 1;  //bit [5]
			uint32               : 26;
		};
		struct
		{
			uint32                : 6;
			uint32 plannedBfPoll3 : 1;  //bit [6]
			uint32                : 25;
		};
		struct
		{
			uint32                : 7;
			uint32 plannedBfPoll2 : 1;  //bit [7]
			uint32                : 24;
		};
		struct
		{
			uint32                : 8;
			uint32 plannedBfPoll1 : 1;  //bit [8]
			uint32                : 23;
		};
		struct
		{
			uint32               : 9;
			uint32 plannedPhyNdp : 1;  //bit [9]
			uint32               : 22;
		};
		struct
		{
			uint32              : 10;
			uint32 plannedBfReq : 1;  //bit [10]
			uint32              : 21;
		}; //Qos HT NDP / NDPA VHT / NDPA HE
		struct
		{
			uint32               : 11;
			uint32 plannedFiller : 1;  //bit [11]
			uint32               : 20;
		};
		struct
		{
			uint32              : 12;
			uint32 plannedMuRts : 1;  //bit [12]
			uint32              : 19;
		};
		struct
		{
			uint32               : 13;
			uint32 plannedRtsCts : 1;  //bit [13]
			uint32               : 18;
		};
		struct
		{
			uint32                 : 14;
			uint32 plannedCts2Self : 1;  //bit [14]
			uint32                 : 17;
		};
		struct
		{
			uint32              : 15;
			uint32 plannedCfEnd : 1;  //bit [15]
			uint32              : 16;
		};
		struct
		{
			uint32                                     : 16;
			uint32 minimumNumberOfUsersForTransmission : 7;  //bits [16..22]
			uint32                                     : 9;
		};
		struct
		{
			uint32                        : 23;
			uint32 tfInfoBaseAddrDwOffset : 9;  //bits [23..31]
		}; //offset in DWs to TF info base address
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 ulDataSeqType          : 1;  //bit [0], UL sequence type:	0  UL TF	1  UL BSRP TF
			uint32 tfBroadcastUnicastMode : 1;  //bit [1], TF Mode:	0  Broadcast	1  Unicast
			uint32 baBroadcastUnicastMode : 1;  //bit [2], BA Unicast/Broadcast Mode	0  BA is sent in Broadcast mode	1  BA is sent in Unicast mode
			uint32 commonReserved30       : 21; //bits [3..23]
			uint32 groupIndex             : 8;  //bits [24..31], Group Index	indicating the Group Index for the Users (used for updating UL RSSI) 
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 commonReserved40 : 32; //bits [0..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 ulPhaseId        : 6;  //bits [0..5], indicates entry index in LA phase DB
			uint32 commonReserved50 : 26; //bits [6..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 nextOrMirrorPhasePointer : 32; //bits [0..31], reserved word for SW use
		};
	};
} UlDataPhaseCommon_t;

typedef struct _UlDataPhaseCommonTcra_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonTcra0310 : 32; //bits [0..31], common TCR A 0 bits [31:0] (TF TCR)
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonTcra06332 : 32; //bits [0..31], common TCR A 0 bits [63:32] (TF TCR)
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 commonTcra09564 : 32; //bits [0..31], common TCR A 0 bits [95:64] (TF TCR)
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 commonTcra012796 : 32; //bits [0..31], common TCR A 0 bits [127:96] (TF TCR)
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 commonTcra1310 : 32; //bits [0..31], common TCR A 1 bits [31:0] (TF TCR)
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 commonTcra16332 : 32; //bits [0..31], common TCR A 1 bits [63:32] (TF TCR)
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 commonTcra19564 : 32; //bits [0..31], common TCR A 1 bits [95:64] (TF TCR)
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 commonTcra112796 : 32; //bits [0..31], common TCR A 1 bits [127:96] (TF TCR)
		};
	};
} UlDataPhaseCommonTcra_t;

typedef struct _UlDataPhaseCommonTcrb_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonTcrb0310 : 32; //bits [0..31], common TCR B 0 bits [31:0] (TF TCR)
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonTcrb06332 : 32; //bits [0..31], common TCR B 0 bits [63:32] (auto resp TCR)
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 commonTcrb09564 : 32; //bits [0..31], common TCR B 0 bits [95:64] (auto resp TCR)
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 commonTcrb012796 : 32; //bits [0..31], common TCR B 0 bits [127:96] (auto resp TCR)
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 commonTcrb1310 : 32; //bits [0..31], common TCR B 1 bits [31:0] (auto resp TCR)
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 commonTcrb16332 : 32; //bits [0..31], common TCR B 1 bits [63:32] (auto resp TCR)
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 commonTcrb19564 : 32; //bits [0..31], common TCR B 1 bits [95:64] (auto resp TCR)
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 commonTcrb112796 : 32; //bits [0..31], common TCR B 1 bits [127:96] (auto resp TCR)
		};
	};
} UlDataPhaseCommonTcrb_t;

typedef struct _UlDataPhaseCommonRcr_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonRcr310 : 32; //bits [0..31], common RCR bits [31:0] (ul data)
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonRcr6332 : 32; //bits [0..31], common RCR bits [63:32] (ul data)
		};
	};
} UlDataPhaseCommonRcr_t;

typedef struct _UlDataPhaseCommonUserTcra_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 brdcstUserTcraSubBand           : 3;  //bits [0..2], broadcast TF per user TCR
			uint32 brdcstUserTcraStartRu           : 4;  //bits [3..6], broadcast TF per user TCR
			uint32 brdcstUserTcraRuSize            : 3;  //bits [7..9], broadcast TF per user TCR
			uint32 brdcstUserTcraLdpc              : 1;  //bit [10], broadcast TF per user TCR
			uint32 brdcstUserTcraTxbf              : 1;  //bit [11], broadcast TF per user TCR
			uint32 brdcstUserTcraPsduRate          : 8;  //bits [12..19], broadcast TF per user TCR
			uint32 brdcstUserTcraRelativeUserPower : 4;  //bits [20..23], broadcast TF per user TCR
			uint32 brdcstUserTcraReserve00         : 4;  //bits [24..27], broadcast TF per user TCR
			uint32 brdcstUserTcraPacketExtension   : 2;  //bits [28..29], broadcast TF per user TCR
			uint32 brdcstUserTcraReserve01         : 2;  //bits [30..31], broadcast TF per user TCR
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 brdcstUserTcraStaAid    : 11; //bits [0..10], broadcast TF per user TCR
			uint32 brdcstUserTcraReserve10 : 5;  //bits [11..15], broadcast TF per user TCR
			uint32 brdcstUserTcraBfIndex   : 8;  //bits [16..23], broadcast TF per user TCR
			uint32 brdcstUserTcraReserve11 : 8;  //bits [24..31], broadcast TF per user TCR
		};
	};
} UlDataPhaseCommonUserTcra_t;

typedef struct _UlDataPhaseCommonUserTcrb_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 brdcstUserTcrbSubBand           : 3;  //bits [0..2], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbStartRu           : 4;  //bits [3..6], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbRuSize            : 3;  //bits [7..9], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbLdpc              : 1;  //bit [10], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbTxbf              : 1;  //bit [11], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbPsduRate          : 8;  //bits [12..19], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbRelativeUserPower : 4;  //bits [20..23], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbReserve00         : 4;  //bits [24..27], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbPacketExtension   : 2;  //bits [28..29], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbReserve01         : 2;  //bits [30..31], auto resp broadcast per user TCR
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 brdcstUserTcrbStaAid    : 11; //bits [0..10], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbReserve10 : 5;  //bits [11..15], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbBfIndex   : 8;  //bits [16..23], auto resp broadcast per user TCR
			uint32 brdcstUserTcrbReserve11 : 8;  //bits [24..31], auto resp broadcast per user TCR
		};
	};
} UlDataPhaseCommonUserTcrb_t;

typedef struct _UlDataPhaseUserPhase_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 staId              : 9;  //bits [0..8], station id
			uint32 vapId              : 7;  //bits [9..15], vap id
			uint32 tfPadding          : 2;  //bits [16..17], User Trigger Frame MAC Padding Duration	00  0 us	01  8 us	10  16 us	11  reserved	
			uint32 numTfRepetition    : 3;  //bits [18..20], Number of TF Repetition 	0 to 7	
			uint32 mapTxUserToRxUser  : 6;  //bits [21..26], TX to RX User Mapping  indicate the index of user 1 to user 36 in the RX	Value 0-35		
			uint32 userPhaseReserve00 : 5;  //bits [27..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tidAllocBitmap     : 9;  //bits [0..8], UL TID Bitmap:	Pre-AGG select from this bitmap the available TIDs for UL 	
			uint32 maxTids            : 3;  //bits [9..11], Max TID AGG Limit:	Indicate the maximum number of TIDs to be allocated for this STA		max tids = actaul value -1
			uint32 mapTxUserToTxUser  : 6;  //bits [12..17], Mapping RX User to TX BA User	(used by BAG to map each RX to the transmitted BA)	Value 0-35
			uint32 userPhaseReserve10 : 14; //bits [18..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 userRcrSubBand    : 3;  //bits [0..2], UL data per user RCR
			uint32 userRcrStartRu    : 4;  //bits [3..6], UL data per user RCR
			uint32 userRcrRuSize     : 3;  //bits [7..9], UL data per user RCR
			uint32 userRcrLdpc       : 1;  //bit [10], UL data per user RCR
			uint32 userRcrTxbf       : 1;  //bit [11], UL data per user RCR
			uint32 userRcrPsduRate   : 8;  //bits [12..19], UL data per user RCR
			uint32 userRcrTargetRssi : 8;  //bits [20..27], UL data per user RCR
			uint32 userRcrReserve00  : 3;  //bits [28..30], UL data per user RCR
			uint32 userRcrValid      : 1;  //bit [31], UL data per user RCR
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 userTcraSubBand           : 3;  //bits [0..2],  unicast TF per user TCR
			uint32 userTcraStartRu           : 4;  //bits [3..6],  unicast TF per user TCR
			uint32 userTcraRuSize            : 3;  //bits [7..9],  unicast TF per user TCR
			uint32 userTcraLdpc              : 1;  //bit [10],  unicast TF per user TCR
			uint32 userTcraTxbf              : 1;  //bit [11],  unicast TF per user TCR
			uint32 userTcraPsduRate          : 8;  //bits [12..19],  unicast TF per user TCR
			uint32 userTcraRelativeUserPower : 4;  //bits [20..23],  unicast TF per user TCR
			uint32 userTcraReserve00         : 4;  //bits [24..27],  unicast TF per user TCR
			uint32 userTcraPacketExtension   : 2;  //bits [28..29],  unicast TF per user TCR
			uint32 userTcraReserve01         : 2;  //bits [30..31],  unicast TF per user TCR
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 userTcraStaAid    : 11; //bits [0..10],  unicast TF per user TCR
			uint32 userTcraReserve10 : 5;  //bits [11..15],  unicast TF per user TCR
			uint32 userTcraBfIndex   : 8;  //bits [16..23],  unicast TF per user TCR
			uint32 userTcraReserve11 : 8;  //bits [24..31],  unicast TF per user TCR
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 userTcrbSubBand           : 3;  //bits [0..2], unicast auto resp per user TCR
			uint32 userTcrbStartRu           : 4;  //bits [3..6], unicast auto resp per user TCR
			uint32 userTcrbRuSize            : 3;  //bits [7..9], unicast auto resp per user TCR
			uint32 userTcrbLdpc              : 1;  //bit [10], unicast auto resp per user TCR
			uint32 userTcrbTxbf              : 1;  //bit [11], unicast auto resp per user TCR
			uint32 userTcrbPsduRate          : 8;  //bits [12..19], unicast auto resp per user TCR
			uint32 userTcrbRelativeUserPower : 4;  //bits [20..23], unicast auto resp per user TCR
			uint32 userTcrbReserve00         : 4;  //bits [24..27], unicast auto resp per user TCR
			uint32 userTcrbPacketExtension   : 2;  //bits [28..29], unicast auto resp per user TCR
			uint32 userTcrbReserve01         : 2;  //bits [30..31], unicast auto resp per user TCR
		};
	};
} UlDataPhaseUserPhase_t;

typedef struct _UlDataPhaseTfParameters_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfReservedTfParams00 : 4;  //bits [0..3]
			uint32                      : 28;
		}; //unicast auto resp per user TCR
		struct
		{
			uint32                        : 4;
			uint32 tfOverrideEnableParams : 16; //bits [4..19]
			uint32                        : 12;
		}; //Override Enable Parameters
		struct
		{
			uint32                      : 4;
			uint32 tfLsigLengthOverride : 1;  //bit [4]
			uint32                      : 27;
		}; //L-SIG Length Override Enable (within Common Info section)
		struct
		{
			uint32              : 5;
			uint32 tfBwOverride : 1;  //bit [5]
			uint32              : 26;
		}; //Bandwidth Override Enable (within Common Info section)
		struct
		{
			uint32                        : 6;
			uint32 tfRuAllocationOverride : 1;  //bit [6]
			uint32                        : 25;
		}; //RU Allocation Override Enable (within User General Info section)
		struct
		{
			uint32               : 7;
			uint32 tfMcsOverride : 1;  //bit [7]
			uint32               : 24;
		}; //MCS Override Enable (within User General Info section)
		struct
		{
			uint32               : 8;
			uint32 tfDcmOverride : 1;  //bit [8]
			uint32               : 23;
		}; //DCM Override Enable (within User General Info section)
		struct
		{
			uint32               : 9;
			uint32 tfNssOverride : 1;  //bit [9]
			uint32               : 22;
		}; //NSS Override Enable (within User General Info section)
		struct
		{
			uint32                      : 10;
			uint32 tfTargetRssiOverride : 1;  //bit [10]
			uint32                      : 21;
		}; //Target RSSI Override Enable (within User General Info section)
		struct
		{
			uint32                        : 11;
			uint32 tfTidAggrLimitOverride : 1;  //bit [11]
			uint32                        : 20;
		}; //TID Aggr Limit Override Enable (within User TF Dependent section for Basic Trigger)
		struct
		{
			uint32                       : 12;
			uint32 tfPreferredAcOverride : 1;  //bit [12]
			uint32                       : 19;
		}; //Preferred AC Override Enable (within User TF Dependent section for Basic Trigger)
		struct
		{
			uint32                    : 13;
			uint32 tfMultiTidOverride : 1;  //bit [13]
			uint32                    : 18;
		}; //Multi-TID Override Enable (within MU-BAR Control section)
		struct
		{
			uint32                   : 14;
			uint32 tfTidInfoOverride : 1;  //bit [14]
			uint32                   : 17;
		}; //TID Info Override Enable (within MU-BAR Control section)
		struct
		{
			uint32                        : 15;
			uint32 tfCompressedFnOverride : 1;  //bit [15]
			uint32                        : 16;
		}; //Fragment Number (bits 2:1) Override Enable (within Compressed MU-BAR Information section)
		struct
		{
			uint32                         : 16;
			uint32 tfCompressedSsnOverride : 1;  //bit [16]
			uint32                         : 15;
		}; //Starting Sequence Number Override Enable (within Compressed MU-BAR Information section)
		struct
		{
			uint32                       : 17;
			uint32 tfMultiTidTidOverride : 1;  //bit [17]
			uint32                       : 14;
		}; //TID Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                      : 18;
			uint32 tfMultiTidFnOverride : 1;  //bit [18]
			uint32                      : 13;
		}; //Fragment Number (bits 2:1) Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                       : 19;
			uint32 tfMultiTidSsnOverride : 1;  //bit [19]
			uint32                       : 12;
		}; //Starting Sequence Number Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                              : 20;
			uint32 tfCommonInfoSwOverrideEnable : 1;  //bit [20]
			uint32                              : 11;
		}; //Common Info General SW Override Enable
		struct
		{
			uint32                            : 21;
			uint32 tfUserInfoSwOverrideEnable : 1;  //bit [21]
			uint32                            : 10;
		}; //User Info General SW Override Enable
		struct
		{
			uint32                      : 22;
			uint32 tfReservedTfParams01 : 10; //bits [22..31]
		};
	};
} UlDataPhaseTfParameters_t;

typedef struct _UlDataPhaseTfCommonInfo_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfTriggerType            : 4;  //bits [0..3]
			uint32 tfLength                 : 12; //bits [4..15], Override option
			uint32 tfCascadeIndication      : 1;  //bit [16]
			uint32 tfCsRequired             : 1;  //bit [17]
			uint32 tfBw                     : 2;  //bits [18..19], Override option
			uint32 tfGiAndLtfType           : 2;  //bits [20..21]
			uint32 tfMuMimoLtfMode          : 1;  //bit [22]
			uint32 tfNumberOfHeLtfSymbols   : 3;  //bits [23..25]
			uint32 tfStbc                   : 1;  //bit [26]
			uint32 tfLdpcExtraSymbolSegment : 1;  //bit [27]
			uint32 tfApTxPower30            : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tfApTxPower54        : 2;  //bits [0..1]
			uint32 tfPacketExtension    : 3;  //bits [2..4]
			uint32 tfSpatialReuse       : 16; //bits [5..20]
			uint32 tfDoppler            : 1;  //bit [21]
			uint32 tfHeSigAReserved     : 9;  //bits [22..30]
			uint32 tfReservedCommonInfo : 1;  //bit [31]
		};
	};
} UlDataPhaseTfCommonInfo_t;

typedef struct _UlDataPhaseTfUserInfo_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfAid120 : 12; //bits [0..11]
			uint32          : 20;
		};
		struct
		{
			uint32                 : 12;
			uint32 tfRuAllocation0 : 8;  //bits [12..19]
			uint32                 : 12;
		}; //Override option
		struct
		{
			uint32               : 20;
			uint32 tfCodingType0 : 1;  //bit [20]
			uint32               : 11;
		};
		struct
		{
			uint32        : 21;
			uint32 tfMcs0 : 4;  //bits [21..24]
			uint32        : 7;
		}; //Override option
		struct
		{
			uint32        : 25;
			uint32 tfDcm0 : 1;  //bit [25]
			uint32        : 6;
		}; //Override option
		struct
		{
			uint32                 : 26;
			uint32 tfSsAllocation0 : 6;  //bits [26..31]
		};
		struct
		{
			uint32                          : 26;
			uint32 tfStartingSpatialStream0 : 3;  //bits [26..28]
			uint32                          : 3;
		};
		struct
		{
			uint32                           : 29;
			uint32 tfNumberOfSpatialStreams0 : 3;  //bits [29..31]
		}; //Override option
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tfTargetRssi0 : 7;  //bits [0..6]
			uint32               : 25;
		}; //Override option
		struct
		{
			uint32                     : 7;
			uint32 tfReservedUserInfo0 : 1;  //bit [7]
			uint32                     : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 tfTriggerDependent0 : 8;  //bits [8..15]
			uint32                     : 16;
		};
		struct
		{
			uint32                             : 8;
			uint32 tfBasicMpduMuSpacingFactor0 : 2;  //bits [8..9]
			uint32                             : 22;
		};
		struct
		{
			uint32                     : 10;
			uint32 tfBasicTidAggLimit0 : 3;  //bits [10..12]
			uint32                     : 19;
		}; //Override option
		struct
		{
			uint32                  : 13;
			uint32 tfBasicReserved0 : 1;  //bit [13]
			uint32                  : 18;
		};
		struct
		{
			uint32                     : 14;
			uint32 tfBasicPreferredAc0 : 2;  //bits [14..15]
			uint32                     : 16;
		}; //Override option
		struct
		{
			uint32          : 16;
			uint32 tfAid121 : 12; //bits [16..27]
			uint32          : 4;
		};
		struct
		{
			uint32                   : 28;
			uint32 tfRuAllocation130 : 4;  //bits [28..31]
		}; //Override option
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tfRuAllocation174 : 4;  //bits [0..3]
			uint32                   : 28;
		}; //Override option
		struct
		{
			uint32               : 4;
			uint32 tfCodingType1 : 1;  //bit [4]
			uint32               : 27;
		};
		struct
		{
			uint32        : 5;
			uint32 tfMcs1 : 4;  //bits [5..8]
			uint32        : 23;
		}; //Override option
		struct
		{
			uint32        : 9;
			uint32 tfDcm1 : 1;  //bit [9]
			uint32        : 22;
		}; //Override option
		struct
		{
			uint32                 : 10;
			uint32 tfSsAllocation1 : 6;  //bits [10..15]
			uint32                 : 16;
		};
		struct
		{
			uint32                          : 10;
			uint32 tfStartingSpatialStream1 : 3;  //bits [10..12]
			uint32                          : 19;
		};
		struct
		{
			uint32                           : 13;
			uint32 tfNumberOfSpatialStreams1 : 3;  //bits [13..15]
			uint32                           : 16;
		}; //Override option
		struct
		{
			uint32               : 16;
			uint32 tfTargetRssi1 : 7;  //bits [16..22]
			uint32               : 9;
		}; //Override option
		struct
		{
			uint32                     : 23;
			uint32 tfReservedUserInfo1 : 1;  //bit [23]
			uint32                     : 8;
		};
		struct
		{
			uint32                     : 24;
			uint32 tfTriggerDependent1 : 8;  //bits [24..31]
		};
		struct
		{
			uint32                             : 24;
			uint32 tfBasicMpduMuSpacingFactor1 : 2;  //bits [24..25]
			uint32                             : 6;
		};
		struct
		{
			uint32                     : 26;
			uint32 tfBasicTidAggLimit1 : 3;  //bits [26..28]
			uint32                     : 3;
		}; //Override option
		struct
		{
			uint32                  : 29;
			uint32 tfBasicReserved1 : 1;  //bit [29]
			uint32                  : 2;
		};
		struct
		{
			uint32                     : 30;
			uint32 tfBasicPreferredAc1 : 2;  //bits [30..31]
		}; //Override option
	};
} UlDataPhaseTfUserInfo_t;

typedef struct _UlDataPhase_t
{
	UlDataPhaseCommon_t         common;
	UlDataPhaseCommonTcra_t     commonTcra;
	UlDataPhaseCommonTcrb_t     commonTcrb;
	UlDataPhaseCommonRcr_t      commonRcr;
	UlDataPhaseCommonUserTcra_t commonUserTcra;
	UlDataPhaseCommonUserTcrb_t commonUserTcrb;
	UlDataPhaseUserPhase_t      userPhase[NUM_OF_USERS_MU_HE_PHASE];
	UlDataPhaseTfParameters_t   tfParameters;
	UlDataPhaseTfCommonInfo_t   tfCommonInfo;
	UlDataPhaseTfUserInfo_t     tfUserInfo[HALF_NUM_OF_USERS_MU_HE_PHASE];
} UlDataPhase_t;

#endif //_UL_DATA_PHASE_DESC_H_
