/************************************************************************************
*
*	File:				UserUlReport_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_A0_mac_descriptors_ver0.32.3.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _USER_UL_REPORT_DESC_H_
#define _USER_UL_REPORT_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _UserUlReportCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 transactionNumber : 8;  //bits [0..7], Transaction number. The counter value matches the counter value of the common entry (of the same PPDU) which is associated with the user.
			uint32 rxUserId          : 7;  //bits [8..14], User ID
			uint32 staId             : 9;  //bits [15..23], Station Index
			uint32 ruSubBand         : 3;  //bits [24..26], RU Sub Band From RCR (relevant only in HE MU)
			uint32 startRu           : 4;  //bits [27..30], Start RU From RCR (relevant only in HE MU)
			uint32 userReserved00    : 1;  //bit [31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 targetRssi        : 8;  //bits [0..7], Target RSSI From RCR (relevant only in HE MU)
			uint32 ruSize            : 3;  //bits [8..10], RU Size From RCR (relevant only in HE MU)
			uint32 totalNumberOfZlds : 21; //bits [11..31], Total number of ZLDS (in units of ZLDs)
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 psduLength     : 17; //bits [0..16], Size of PSDU. Quantized (/64bytes) size
			uint32 rate           : 8;  //bits [17..24], Received PPDU Rate. Comprised of DCM, NSS, MCM. Taken from PHY Status
			uint32 ldpc           : 1;  //bit [25], LDPC from PHY
			uint32 userReserved20 : 6;  //bits [26..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 totalGoodMpduLength : 17; //bits [0..16], Total Good MPDU Length per User counter [Bytes] The value Includes Header and Delimiter. Quantized (/64bytes) size
			uint32 numberOfRetryMpdus  : 12; //bits [17..28], Number of Retry MPDUs received by this user (FCS OK and Retry bit=1 in the frame header)
			uint32 userReserved30      : 3;  //bits [29..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 maxFdRssi          : 8;  //bits [0..7], Max FD RSSI for all antennas from PHY which are not 0x80. This is a signed value
			uint32 minFdRssi          : 8;  //bits [8..15], Min FD RSSI for all antennas from PHY which are not 0x80. This is a signed value
			uint32 aControlTypeBitmap : 16; //bits [16..31], Identifier for which Control IDs were received within the  A-Control field
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 aControl       : 30; //bits [0..29], The A-Control Field which was received by RXC. Valid only if A-Control Type Bitmap != 0
			uint32 userReserved50 : 2;  //bits [30..31]
		};
	};
} UserUlReportCommon_t;

typedef UserUlReportCommon_t UserUlReport_t;

#endif //_USER_UL_REPORT_DESC_H_
