/************************************************************************************
*
*	File:				SoundingPhase_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_B0_mac_descriptors_ver1.10.6.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _SOUNDING_PHASE_DESC_H_
#define _SOUNDING_PHASE_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _SoundingPhaseCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 validUsers310 : 32; //bits [0..31], TX Valid Users bitmap (bits 31:0). 0 - User not valid;  1 - User valid
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 validUsers3532     : 4;  //bits [0..3], TX Valid Users bitmap (bits 35:32). 0 - User not valid;  1 - User valid
			uint32 phaseType          : 3;  //bits [4..6], values from PhaseType_e, 0 - Protection Phase;  1 - Sounding Phase;  2 - DL Data Phase;  3 - UL Phase
			uint32 oneShotPhase       : 1;  //bit [7], Phase will run one time then sender will clear the phase valid bit of this phase. 0 - one shot disabled;  1 - one shot enabled
			uint32 partialDuration    : 15; //bits [8..22], Time in usec
			uint32 commonReserved10   : 1;  //bit [23]
			uint32 broadcastTfAidCfg  : 1;  //bit [24], 0 - Use AID = 1024 + k	  1  use original AID from Phase
			uint32 unicastTfTypeCfg   : 1;  //bit [25], 0  TF Type is set to BSRP 	 1  use original TF Type from Phase
			uint32 keepPlanLock       : 1;  //bit [26], Keep Plan Lock, 	indicates if to keep the Plan Lock (instead of Unlock at the end of TXOP)	0  Unlock at the end of TXOP	1  Keep Plan Lock
			uint32 moveStaToSu        : 1;  //bit [27], Move STA to SU	Indicates if STAs in this Phase need to be set to SU	0  dont change/update STA to SU	1  update STA to SU	Note: this configuration is intended to UL Phase for Training with all phases as one shot, if used in this phase need to verify that Sender support it 
			uint32 tfParamTriggerType : 3;  //bits [28..30], values from TfType_e
			uint32 commonReserved11   : 1;  //bit [31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 actionBitmap : 16; //bits [0..15]
			uint32              : 16;
		}; //Action Bitmap
		struct
		{
			uint32 plannedTrainingFiller : 1;  //bit [0]
			uint32                       : 31;
		};
		struct
		{
			uint32                : 1;
			uint32 plannedMuBarTf : 1;  //bit [1]
			uint32                : 30;
		};
		struct
		{
			uint32            : 2;
			uint32 plannedBar : 1;  //bit [2]
			uint32            : 29;
		};
		struct
		{
			uint32             : 3;
			uint32 plannedUlTf : 1;  //bit [3]
			uint32             : 28;
		}; //UL data/BSRP
		struct
		{
			uint32             : 4;
			uint32 plannedData : 1;  //bit [4]
			uint32             : 27;
		}; //DL data
		struct
		{
			uint32               : 5;
			uint32 plannedBfrpTf : 1;  //bit [5]
			uint32               : 26;
		};
		struct
		{
			uint32                : 6;
			uint32 plannedBfPoll3 : 1;  //bit [6]
			uint32                : 25;
		};
		struct
		{
			uint32                : 7;
			uint32 plannedBfPoll2 : 1;  //bit [7]
			uint32                : 24;
		};
		struct
		{
			uint32                : 8;
			uint32 plannedBfPoll1 : 1;  //bit [8]
			uint32                : 23;
		};
		struct
		{
			uint32               : 9;
			uint32 plannedPhyNdp : 1;  //bit [9]
			uint32               : 22;
		};
		struct
		{
			uint32              : 10;
			uint32 plannedBfReq : 1;  //bit [10]
			uint32              : 21;
		}; //Qos HT NDP / NDPA VHT / NDPA HE
		struct
		{
			uint32               : 11;
			uint32 plannedFiller : 1;  //bit [11]
			uint32               : 20;
		};
		struct
		{
			uint32              : 12;
			uint32 plannedMuRts : 1;  //bit [12]
			uint32              : 19;
		};
		struct
		{
			uint32               : 13;
			uint32 plannedRtsCts : 1;  //bit [13]
			uint32               : 18;
		};
		struct
		{
			uint32                 : 14;
			uint32 plannedCts2Self : 1;  //bit [14]
			uint32                 : 17;
		};
		struct
		{
			uint32              : 15;
			uint32 plannedCfEnd : 1;  //bit [15]
			uint32              : 16;
		};
		struct
		{
			uint32                                     : 16;
			uint32 minimumNumberOfUsersForTransmission : 7;  //bits [16..22]
			uint32                                     : 9;
		};
		struct
		{
			uint32                        : 23;
			uint32 tfInfoBaseAddrDwOffset : 9;  //bits [23..31]
		}; //offset in DWs to TF info base address
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 bfTxSeqType                : 2;  //bits [0..1], BF TX Sequence Type	00  NO BF Sequence	01  BF Sequence Without Data	11  BF Sequence Before Data PPDU	10  Reserved
			uint32 doubleSoundingEn           : 1;  //bit [2], Double Sounding Enable:	0  Double Sounding not enabled	1  double sounding enable (use second TF)
			uint32 saveUserBitmapForData      : 1;  //bit [3], Save User Bitmap for Data:	0 - Don't Save User Bitmap	1 - Save User Bitmap	note: in sounding for MIMO require to set this bit so the Sounding and Data will be based on the same valid users	
			uint32 nssMaxNdp                  : 3;  //bits [4..6], NSS MAX NDP  Maximum number of Spatial Streams, requested from STA (Determine the	type of MU BF report to be requested from the STA ) 	000  1 spatial stream	001  2 spatial streams	010  3 spatial streams	011  4 spatial streams	:	111  8 spatial streams
			uint32 soundingPartialSuccessCond : 1;  //bit [7], define how to treat the BF results:	0 - Full - success when received BF for all users (i.e in MIMO mode)	1 - Partail - success when received not for all BF users (i.e. OFDMA Mode
			uint32 tfBroadcastUnicastMode     : 1;  //bit [8], TF Mode:	0  Broadcast	1  Unicast
			uint32 muMimoDataTransmission     : 1;  //bit [9], MU MIMO Data transmission	indicates if the sounding is used for MIMO or not	0 - Sounding is used for OFDMA (not for MIMO)	1 - Sounding us used for MIMO operation
			uint32 commonReserved30           : 14; //bits [10..23]
			uint32 groupIndex                 : 8;  //bits [24..31], Group Index	indicating the Group Index for the Users (used for updating UL RSSI) 	
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 ndpaPointer : 32; //bits [0..31], Pointer to NDPA Frame Parameters
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 commonReserved50 : 32; //bits [0..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 nextPhasePointer : 32; //bits [0..31], reserved word for SW use
		};
	};
} SoundingPhaseCommon_t;

typedef struct _SoundingPhaseCommonTcra_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonTcra0310 : 32; //bits [0..31], common TCR A 0 bits [31:0]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonTcra06332 : 32; //bits [0..31], common TCR A 0 bits [63:32]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 commonTcra09564 : 32; //bits [0..31], common TCR A 0 bits [95:64]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 commonTcra012796 : 32; //bits [0..31], common TCR A 0 bits [127:96]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 commonTcra1310 : 32; //bits [0..31], common TCR A 1 bits [31:0]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 commonTcra16332 : 32; //bits [0..31], common TCR A 1 bits [63:32]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 commonTcra19564 : 32; //bits [0..31], common TCR A 1 bits [95:64]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 commonTcra112796 : 32; //bits [0..31], common TCR A 1 bits [127:96]
		};
	};
} SoundingPhaseCommonTcra_t;

typedef struct _SoundingPhaseCommonTcrb_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonTcrb0310 : 32; //bits [0..31], common TCR B 0 bits [31:0]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonTcrb06332 : 32; //bits [0..31], common TCR B 0 bits [63:32]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 commonTcrb09564 : 32; //bits [0..31], common TCR B 0 bits [95:64]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 commonTcrb012796 : 32; //bits [0..31], common TCR B 0 bits [127:96]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 commonTcrb1310 : 32; //bits [0..31], common TCR B 1 bits [31:0]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 commonTcrb16332 : 32; //bits [0..31], common TCR B 1 bits [63:32]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 commonTcrb19564 : 32; //bits [0..31], common TCR B 1 bits [95:64]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 commonTcrb112796 : 32; //bits [0..31], common TCR B 1 bits [127:96]
		};
	};
} SoundingPhaseCommonTcrb_t;

typedef struct _SoundingPhaseCommonRcr_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 commonRcr310 : 32; //bits [0..31], common RCR bits [31:0]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 commonRcr6332 : 32; //bits [0..31], common RCR bits [63:32]
		};
	};
} SoundingPhaseCommonRcr_t;

typedef struct _SoundingPhaseCommonUserTcra_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 brdcstUserTcraSubBand           : 3;  //bits [0..2], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraStartRu           : 4;  //bits [3..6], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraRuSize            : 3;  //bits [7..9], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraLdpc              : 1;  //bit [10], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraTxbf              : 1;  //bit [11], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraPsduRate          : 8;  //bits [12..19], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraRelativeUserPower : 4;  //bits [20..23], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraReserve00         : 4;  //bits [24..27], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraPacketExtension   : 2;  //bits [28..29], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraReserve01         : 2;  //bits [30..31], broadcast NDP/NDPA per user TCR
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 brdcstUserTcraStaAid    : 11; //bits [0..10], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraReserve10 : 5;  //bits [11..15], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraBfIndex   : 8;  //bits [16..23], broadcast NDP/NDPA per user TCR
			uint32 brdcstUserTcraReserve11 : 8;  //bits [24..31], broadcast NDP/NDPA per user TCR
		};
	};
} SoundingPhaseCommonUserTcra_t;

typedef struct _SoundingPhaseCommonUserTcrb_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 brdcstUserTcrbSubBand           : 3;  //bits [0..2], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbStartRu           : 4;  //bits [3..6], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbRuSize            : 3;  //bits [7..9], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbLdpc              : 1;  //bit [10], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbTxbf              : 1;  //bit [11], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbPsduRate          : 8;  //bits [12..19], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbRelativeUserPower : 4;  //bits [20..23], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbReserve00         : 4;  //bits [24..27], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbPacketExtension   : 2;  //bits [28..29], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbReserve01         : 2;  //bits [30..31], BF poll broadcast per user TCR
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 brdcstUserTcrbStaAid    : 11; //bits [0..10], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbReserve10 : 5;  //bits [11..15], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbBfIndex   : 8;  //bits [16..23], BF poll broadcast per user TCR
			uint32 brdcstUserTcrbReserve11 : 8;  //bits [24..31], BF poll broadcast per user TCR
		};
	};
} SoundingPhaseCommonUserTcrb_t;

typedef struct _SoundingPhaseUserPhase_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 staId              : 9;  //bits [0..8], station id
			uint32 vapId              : 7;  //bits [9..15], vap id
			uint32 tfPadding          : 2;  //bits [16..17], User Trigger Frame MAC Padding Duration	00  0 us	01  8 us	10  16 us	11  reserved	
			uint32 numTfRepetition    : 3;  //bits [18..20], Number of TF Repetition 	0 to 7	
			uint32 mapTxUserToRxUser  : 6;  //bits [21..26], TX to RX User Mapping  indicate the index of user 1 to user 36 in the RX	Value 0-35		
			uint32 userPhaseReserve00 : 5;  //bits [27..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 muBfIndex          : 4;  //bits [0..3], MU BF Index:	Value: 0 to 15	relevant only in MU-MIMO	
			uint32 userPhaseReserve10 : 8;  //bits [4..11]
			uint32 mapTxUserToTxUser  : 6;  //bits [12..17], Mapping TX Valid User to NDPA TX User 	Indicate the relevant NDPA TX User Index:	used by NDPA to map each TX to the transmitted STA in NDPA	Value 0  43
			uint32 userPhaseReserve11 : 14; //bits [18..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 userRcrSubBand    : 3;  //bits [0..2], BF report RCR
			uint32 userRcrStartRu    : 4;  //bits [3..6], BF report RCR
			uint32 userRcrRuSize     : 3;  //bits [7..9], BF report RCR
			uint32 userRcrLdpc       : 1;  //bit [10], BF report RCR
			uint32 userRcrTxbf       : 1;  //bit [11], BF report RCR
			uint32 userRcrPsduRate   : 8;  //bits [12..19], BF report RCR
			uint32 userRcrTargetRssi : 8;  //bits [20..27], BF report RCR
			uint32 userRcrReserve00  : 3;  //bits [28..30], BF report RCR
			uint32 userRcrValid      : 1;  //bit [31], BF report RCR
		};
	};
} SoundingPhaseUserPhase_t;

typedef struct _SoundingPhaseTfParameters_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfReservedTfParams00 : 4;  //bits [0..3]
			uint32                      : 28;
		};
		struct
		{
			uint32                        : 4;
			uint32 tfOverrideEnableParams : 18; //bits [4..21]
			uint32                        : 10;
		}; //Override Enable Parameters
		struct
		{
			uint32                      : 4;
			uint32 tfLsigLengthOverride : 1;  //bit [4]
			uint32                      : 27;
		}; //L-SIG Length Override Enable (within Common Info section)
		struct
		{
			uint32                             : 5;
			uint32 tfCascadeIndicationOverride : 1;  //bit [5]
			uint32                             : 26;
		}; //Cascade Indication Override Enable (within Common Info section)
		struct
		{
			uint32              : 6;
			uint32 tfBwOverride : 1;  //bit [6]
			uint32              : 25;
		}; //Bandwidth Override Enable (within Common Info section)
		struct
		{
			uint32                                : 7;
			uint32 tfRuPrimarySecondary80Override : 1;  //bit [7]
			uint32                                : 24;
		}; //RU Primary Secondary Indication Override Enable (within User General Info section)
		struct
		{
			uint32                   : 8;
			uint32 tfRuIndexOverride : 1;  //bit [8]
			uint32                   : 23;
		}; //RU Index Override Enable (within User General Info section)
		struct
		{
			uint32               : 9;
			uint32 tfMcsOverride : 1;  //bit [9]
			uint32               : 22;
		}; //MCS Override Enable (within User General Info section)
		struct
		{
			uint32               : 10;
			uint32 tfDcmOverride : 1;  //bit [10]
			uint32               : 21;
		}; //DCM Override Enable (within User General Info section)
		struct
		{
			uint32               : 11;
			uint32 tfNssOverride : 1;  //bit [11]
			uint32               : 20;
		}; //NSS Override Enable (within User General Info section)
		struct
		{
			uint32                      : 12;
			uint32 tfTargetRssiOverride : 1;  //bit [12]
			uint32                      : 19;
		}; //Target RSSI Override Enable (within User General Info section)
		struct
		{
			uint32                        : 13;
			uint32 tfTidAggrLimitOverride : 1;  //bit [13]
			uint32                        : 18;
		}; //TID Aggr Limit Override Enable (within User TF Dependent section for Basic Trigger)
		struct
		{
			uint32                       : 14;
			uint32 tfPreferredAcOverride : 1;  //bit [14]
			uint32                       : 17;
		}; //Preferred AC Override Enable (within User TF Dependent section for Basic Trigger)
		struct
		{
			uint32                    : 15;
			uint32 tfMultiTidOverride : 1;  //bit [15]
			uint32                    : 16;
		}; //Multi-TID Override Enable (within MU-BAR Control section)
		struct
		{
			uint32                   : 16;
			uint32 tfTidInfoOverride : 1;  //bit [16]
			uint32                   : 15;
		}; //TID Info Override Enable (within MU-BAR Control section)
		struct
		{
			uint32                        : 17;
			uint32 tfCompressedFnOverride : 1;  //bit [17]
			uint32                        : 14;
		}; //Fragment Number (bits 2:1) Override Enable (within Compressed MU-BAR Information section)
		struct
		{
			uint32                         : 18;
			uint32 tfCompressedSsnOverride : 1;  //bit [18]
			uint32                         : 13;
		}; //Starting Sequence Number Override Enable (within Compressed MU-BAR Information section)
		struct
		{
			uint32                       : 19;
			uint32 tfMultiTidTidOverride : 1;  //bit [19]
			uint32                       : 12;
		}; //TID Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                      : 20;
			uint32 tfMultiTidFnOverride : 1;  //bit [20]
			uint32                      : 11;
		}; //Fragment Number (bits 2:1) Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                       : 21;
			uint32 tfMultiTidSsnOverride : 1;  //bit [21]
			uint32                       : 10;
		}; //Starting Sequence Number Override Enable (within Multi-TID MU-BAR Information section)
		struct
		{
			uint32                              : 22;
			uint32 tfCommonInfoSwOverrideEnable : 1;  //bit [22]
			uint32                              : 9;
		}; //Common Info General SW Override Enable
		struct
		{
			uint32                            : 23;
			uint32 tfUserInfoSwOverrideEnable : 1;  //bit [23]
			uint32                            : 8;
		}; //User Info General SW Override Enable
		struct
		{
			uint32                      : 24;
			uint32 tfReservedTfParams01 : 8;  //bits [24..31]
		};
	};
} SoundingPhaseTfParameters_t;

typedef struct _SoundingPhaseTfCommonInfo_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfTriggerType            : 4;  //bits [0..3]
			uint32 tfLength                 : 12; //bits [4..15], Override option
			uint32 tfCascadeIndication      : 1;  //bit [16], Override option
			uint32 tfCsRequired             : 1;  //bit [17]
			uint32 tfBw                     : 2;  //bits [18..19], Override option
			uint32 tfGiAndLtfType           : 2;  //bits [20..21]
			uint32 tfMuMimoLtfMode          : 1;  //bit [22]
			uint32 tfNumberOfHeLtfSymbols   : 3;  //bits [23..25]
			uint32 tfStbc                   : 1;  //bit [26]
			uint32 tfLdpcExtraSymbolSegment : 1;  //bit [27]
			uint32 tfApTxPower30            : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tfApTxPower54        : 2;  //bits [0..1]
			uint32 tfPacketExtension    : 3;  //bits [2..4]
			uint32 tfSpatialReuse       : 16; //bits [5..20]
			uint32 tfDoppler            : 1;  //bit [21]
			uint32 tfHeSigAReserved     : 9;  //bits [22..30]
			uint32 tfReservedCommonInfo : 1;  //bit [31]
		};
	};
} SoundingPhaseTfCommonInfo_t;

typedef struct _SoundingPhaseTfUserInfo_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tfAid120 : 12; //bits [0..11]
			uint32          : 20;
		};
		struct
		{
			uint32                 : 12;
			uint32 tfRuAllocation0 : 8;  //bits [12..19]
			uint32                 : 12;
		};
		struct
		{
			uint32                         : 12;
			uint32 tfRuPrimarySecondary800 : 1;  //bit [12]
			uint32                         : 19;
		}; //Override option
		struct
		{
			uint32            : 13;
			uint32 tfRuIndex0 : 7;  //bits [13..19]
			uint32            : 12;
		}; //Override option
		struct
		{
			uint32               : 20;
			uint32 tfCodingType0 : 1;  //bit [20]
			uint32               : 11;
		};
		struct
		{
			uint32        : 21;
			uint32 tfMcs0 : 4;  //bits [21..24]
			uint32        : 7;
		}; //Override option
		struct
		{
			uint32        : 25;
			uint32 tfDcm0 : 1;  //bit [25]
			uint32        : 6;
		}; //Override option
		struct
		{
			uint32                 : 26;
			uint32 tfSsAllocation0 : 6;  //bits [26..31]
		};
		struct
		{
			uint32                          : 26;
			uint32 tfStartingSpatialStream0 : 3;  //bits [26..28]
			uint32                          : 3;
		};
		struct
		{
			uint32                           : 29;
			uint32 tfNumberOfSpatialStreams0 : 3;  //bits [29..31]
		}; //Override option
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tfTargetRssi0 : 7;  //bits [0..6]
			uint32               : 25;
		}; //Override option
		struct
		{
			uint32                     : 7;
			uint32 tfReservedUserInfo0 : 1;  //bit [7]
			uint32                     : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 tfTriggerDependent0 : 8;  //bits [8..15]
			uint32                     : 16;
		};
		struct
		{
			uint32                             : 8;
			uint32 tfBasicMpduMuSpacingFactor0 : 2;  //bits [8..9]
			uint32                             : 22;
		};
		struct
		{
			uint32                     : 10;
			uint32 tfBasicTidAggLimit0 : 3;  //bits [10..12]
			uint32                     : 19;
		}; //Override option
		struct
		{
			uint32                  : 13;
			uint32 tfBasicReserved0 : 1;  //bit [13]
			uint32                  : 18;
		};
		struct
		{
			uint32                     : 14;
			uint32 tfBasicPreferredAc0 : 2;  //bits [14..15]
			uint32                     : 16;
		}; //Override option
		struct
		{
			uint32          : 16;
			uint32 tfAid121 : 12; //bits [16..27]
			uint32          : 4;
		};
		struct
		{
			uint32                     : 28;
			uint32 tfRuAllocation3To01 : 4;  //bits [28..31]
		};
		struct
		{
			uint32                         : 28;
			uint32 tfRuPrimarySecondary801 : 1;  //bit [28]
			uint32                         : 3;
		}; //Override option
		struct
		{
			uint32                : 29;
			uint32 tfRuIndex2To01 : 3;  //bits [29..31]
		}; //Override option
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tfRuAllocation7To41 : 4;  //bits [0..3]
			uint32                     : 28;
		};
		struct
		{
			uint32 tfRuIndex6To31 : 4;  //bits [0..3]
			uint32                : 28;
		}; //Override option
		struct
		{
			uint32               : 4;
			uint32 tfCodingType1 : 1;  //bit [4]
			uint32               : 27;
		};
		struct
		{
			uint32        : 5;
			uint32 tfMcs1 : 4;  //bits [5..8]
			uint32        : 23;
		}; //Override option
		struct
		{
			uint32        : 9;
			uint32 tfDcm1 : 1;  //bit [9]
			uint32        : 22;
		}; //Override option
		struct
		{
			uint32                 : 10;
			uint32 tfSsAllocation1 : 6;  //bits [10..15]
			uint32                 : 16;
		};
		struct
		{
			uint32                          : 10;
			uint32 tfStartingSpatialStream1 : 3;  //bits [10..12]
			uint32                          : 19;
		};
		struct
		{
			uint32                           : 13;
			uint32 tfNumberOfSpatialStreams1 : 3;  //bits [13..15]
			uint32                           : 16;
		}; //Override option
		struct
		{
			uint32               : 16;
			uint32 tfTargetRssi1 : 7;  //bits [16..22]
			uint32               : 9;
		}; //Override option
		struct
		{
			uint32                     : 23;
			uint32 tfReservedUserInfo1 : 1;  //bit [23]
			uint32                     : 8;
		};
		struct
		{
			uint32                     : 24;
			uint32 tfTriggerDependent1 : 8;  //bits [24..31]
		};
		struct
		{
			uint32                             : 24;
			uint32 tfBasicMpduMuSpacingFactor1 : 2;  //bits [24..25]
			uint32                             : 6;
		};
		struct
		{
			uint32                     : 26;
			uint32 tfBasicTidAggLimit1 : 3;  //bits [26..28]
			uint32                     : 3;
		}; //Override option
		struct
		{
			uint32                  : 29;
			uint32 tfBasicReserved1 : 1;  //bit [29]
			uint32                  : 2;
		};
		struct
		{
			uint32                     : 30;
			uint32 tfBasicPreferredAc1 : 2;  //bits [30..31]
		}; //Override option
	};
} SoundingPhaseTfUserInfo_t;

typedef struct _SoundingPhase_t
{
	SoundingPhaseCommon_t         common;
	SoundingPhaseCommonTcra_t     commonTcra;
	SoundingPhaseCommonTcrb_t     commonTcrb;
	SoundingPhaseCommonRcr_t      commonRcr;
	SoundingPhaseCommonUserTcra_t commonUserTcra;
	SoundingPhaseCommonUserTcrb_t commonUserTcrb;
	SoundingPhaseUserPhase_t      userPhase[NUM_OF_USERS_MU_HE_PHASE];
	SoundingPhaseTfParameters_t   tfParameters;
	SoundingPhaseTfCommonInfo_t   tfCommonInfo;
	SoundingPhaseTfUserInfo_t     tfUserInfo[HALF_NUM_OF_USERS_MU_HE_PHASE];
} SoundingPhase_t;

#endif //_SOUNDING_PHASE_DESC_H_
