/************************************************************************************
*
*	File:				AutoRespUserDb_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_mac_descriptors_ver2.10.0.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _AUTO_RESP_USER_DB_DESC_H_
#define _AUTO_RESP_USER_DB_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _AutoRespUserDbUserGeneral_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 staId        : 8;  //bits [0..7]
			uint32 maxBaWinSize : 3;  //bits [8..10], max block ack window size
			uint32 vapId        : 5;  //bits [11..15], vap id
			uint32 txUserId     : 7;  //bits [16..22], Holds the transmit user ID that the Auto response is transmitted to
			uint32 reserved01   : 1;  //bit [23]
			uint32 tidLimit     : 4;  //bits [24..27], max number of TIDs supported by this station (3bit)
			uint32 reserved02   : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 multiTidErrCntr      : 3;  //bits [0..2], 3 bit error counter that counts the number of TIDs that exceeded the user max number of TIDs supported
			uint32 multiTidsCntr        : 4;  //bits [3..6], number of TIDs counter
			uint32 usrTcrLen            : 10; //bits [7..16], 10 bit TCR length counter
			uint32 tidCausedMultiTidErr : 4;  //bits [17..20], the first TID that caused the multi TID error counter to move from zero to one (valid only if multi TID error counter is not zero)
			uint32 ftype                : 2;  //bits [21..22], Indicate user Frame response type.0  ACK, 1  C-BA, 2  M-BA
			uint32 multiTidBarLengthErr : 1;  //bit [23], 1 bit indication that Multi TID BAR length is wrong
			uint32 managementBit        : 1;  //bit [24], 1 bit indication that management was received
			uint32 cbaBitmap128         : 1;  //bit [25], 1 bit indication that C-BA is selected and bitmap size is 128. this is to signal that nee 128 bit padding since C-BA bitmap size is restricted to 64/256 bit
			uint32 barPerUser           : 1;  //bit [26], 1 bit indication that there is a bar indication set in one of the users TIDs
			uint32 barErr               : 1;  //bit [27], 1 bit indication that a BAR error has occurred
			uint32 tidCausedBarErr      : 4;  //bits [28..31], The first TID that caused the BAR error indication to assert (valid only bar error indication is high)
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tid0BaWinSize : 9;  //bits [0..8], TID BA window size
			uint32 tid1BaWinSize : 9;  //bits [9..17], TID BA window size
			uint32 tid2BaWinSize : 9;  //bits [18..26], TID BA window size
			uint32 reserved20    : 5;  //bits [27..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 tid3BaWinSize : 9;  //bits [0..8], TID BA window size
			uint32 tid4BaWinSize : 9;  //bits [9..17], TID BA window size
			uint32 tid5BaWinSize : 9;  //bits [18..26], TID BA window size
			uint32 reserved30    : 5;  //bits [27..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tid6BaWinSize  : 9;  //bits [0..8], TID BA window size
			uint32 tid7BaWinSize  : 9;  //bits [9..17], TID BA window size
			uint32 tid15BaWinSize : 9;  //bits [18..26], TID BA window size
			uint32 reserved40     : 5;  //bits [27..31]
		};
	};
} AutoRespUserDbUserGeneral_t;

typedef struct _AutoRespUserDbUserTid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 sn                  : 12; //bits [0..11], highiest SN reveived for this user TID in case of bitmap type
			uint32 bitmapMapping       : 3;  //bits [12..14], mapping of the bitmap to the TID. Each bit indicates a 64bit window in the 2x256 bits that are allocated for each user
			uint32 bitmapSize          : 2;  //bits [15..16], 2 bit bitmap actual size after resizing (if done). Possible values (0  64bit, 1  128bit, 3  256bit)
			uint32 bar                 : 1;  //bit [17], 1 bit  indication that BAR was received
			uint32 immediateBit        : 1;  //bit [18], 1 bit indicating if response frame to last RX is immediate
			uint32 numBarBits          : 2;  //bits [19..20], 2 bits indicate the requested BA size
			uint32 tidBaType           : 1;  //bit [21], in case of M-BA or HE MU unicast this bit indicates per TID if to use ack without bitmap or ack with bitmap
			uint32 numMpdusOutOfBounds : 8;  //bits [22..29], counter that counts the number of SNs that were out of bounds (grater then 2^11 or negative)
			uint32 mpdusOutOfWinInd    : 1;  //bit [30], counter that counts the number of MPDUs that where left out when after BA window shift
			uint32 tidReserved01       : 1;  //bit [31]
		};
	};
} AutoRespUserDbUserTid_t;

typedef struct _AutoRespUserDbUser_t
{
	AutoRespUserDbUserGeneral_t general;
	AutoRespUserDbUserTid_t     tid[NUM_OF_RX_TIDS];
} AutoRespUserDbUser_t;

typedef struct _AutoRespUserDbBand0_t
{
	AutoRespUserDbUser_t user[NUM_OF_USERS_MU_HE_BAND0];
} AutoRespUserDbBand0_t;

typedef struct _AutoRespUserDbBand1_t
{
	AutoRespUserDbUser_t user[NUM_OF_USERS_MU_HE_BAND1];
} AutoRespUserDbBand1_t;

#endif //_AUTO_RESP_USER_DB_DESC_H_
