/************************************************************************************
*
*	File:				Rd_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_mac_descriptors_ver2.10.0.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _RD_DESC_H_
#define _RD_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _RdCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 dramByteOffset : 4;  //bits [0..3]
			uint32 dramPointer    : 28; //bits [4..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 dataLength      : 14; //bits [0..13]
			uint32 ethType         : 2;  //bits [14..15], values from EthType_e
			uint32 protected       : 1;  //bit [16], Valid in 1st RD Only
			uint32 securityWepType : 1;  //bit [17], Valid in 1st RD Only
			uint32 keyId           : 2;  //bits [18..19], Valid in 1st RD Only
			uint32 rdType          : 5;  //bits [20..24], values from RdType_e, Valid in 1st RD Only. Logger Type is not handled in RxH
			uint32 ttlCount        : 7;  //bits [25..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 rxQueueId : 23; //bits [0..22]
			uint32           : 9;
		};
		struct
		{
			uint32 rxQueueTid : 4;  //bits [0..3]
			uint32            : 28;
		};
		struct
		{
			uint32              : 4;
			uint32 rxQueueStaId : 9;  //bits [4..12]
			uint32              : 19;
		};
		struct
		{
			uint32              : 13;
			uint32 rxQueueVapId : 7;  //bits [13..19]
			uint32              : 12;
		};
		struct
		{
			uint32                : 20;
			uint32 rxQueueGroupId : 3;  //bits [20..22], values from RxqGroupId_e
			uint32                : 9;
		};
		struct
		{
			uint32          : 23;
			uint32 amsduAgg : 1;  //bit [23]
			uint32          : 8;
		}; //Valid in 1st RD Only
		struct
		{
			uint32     : 24;
			uint32 eop : 1;  //bit [24]
			uint32     : 7;
		};
		struct
		{
			uint32     : 25;
			uint32 sop : 1;  //bit [25]
			uint32     : 6;
		};
		struct
		{
			uint32           : 26;
			uint32 broadcast : 1;  //bit [26]
			uint32           : 5;
		};
		struct
		{
			uint32           : 27;
			uint32 multicast : 1;  //bit [27]
			uint32           : 4;
		};
		struct
		{
			uint32              : 28;
			uint32 frameSubtype : 4;  //bits [28..31]
		}; //Valid in 1st RD Only
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 nextRd                  : 24; //bits [0..23], In resolution of 4bytes	NULL = 16777215
			uint32 rdSource                : 3;  //bits [24..26], values from RdSource_e
			uint32 statusRxhError          : 1;  //bit [27], must be zeroed by FW
			uint32 statusDeaggregatorError : 1;  //bit [28], must be zeroed by FW
			uint32 reserved3               : 3;  //bits [29..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tailRd : 24; //bits [0..23]
			uint32        : 8;
		}; //Valid in 1st RD Only and when Aggregation field is set	NULL = 16777215
		struct
		{
			uint32 msduCount : 10; //bits [0..9]
			uint32           : 22;
		}; //Valid in the last RD of AMSDU, providing there	 is more than 1 MSDU in the AMSDU
		struct
		{
			uint32           : 10;
			uint32 reserved4 : 14; //bits [10..23]
			uint32           : 8;
		}; //Valid in the last RD of AMSDU, providing there	 is more than 1 MSDU in the AMSDU
		struct
		{
			uint32                : 24;
			uint32 securityStatus : 4;  //bits [24..27]
			uint32                : 4;
		}; //Valid in 1st RD Only
		struct
		{
			uint32            : 24;
			uint32 micFailure : 1;  //bit [24]
			uint32            : 7;
		}; //Valid in 1st RD Only
		struct
		{
			uint32             : 25;
			uint32 keyNotValid : 1;  //bit [25]
			uint32             : 6;
		}; //Valid in 1st RD Only
		struct
		{
			uint32                        : 26;
			uint32 lengthEivTkipFragError : 2;  //bits [26..27], values from LengthEivTkipFragError_e
			uint32                        : 4;
		}; //Valid in 1st RD Only
		struct
		{
			uint32                 : 28;
			uint32 statusRxppError : 1;  //bit [28]
			uint32                 : 3;
		}; //Valid in 1st RD Only
		struct
		{
			uint32      : 29;
			uint32 retx : 1;  //bit [29]
			uint32      : 2;
		}; //Valid in 1st RD Only
		struct
		{
			uint32           : 30;
			uint32 frameType : 2;  //bits [30..31]
		}; //Valid in 1st RD Only
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 fragNumber : 4;  //bits [0..3]
			uint32            : 28;
		}; //Valid in 1st RD Only
		struct
		{
			uint32    : 4;
			uint32 sn : 12; //bits [4..15]
			uint32    : 16;
		}; //Valid in 1st RD Only
		struct
		{
			uint32      : 16;
			uint32 pn01 : 16; //bits [16..31]
		}; //Valid in 1st RD Only
		struct
		{
			uint32                       : 8;
			uint32 loggerBufferPdPointer : 24; //bits [8..31]
		}; //Valid in Logger RD Only
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 pn25 : 32; //bits [0..31]
		}; //Valid in 1st RD Only
		struct
		{
			uint32 loggerBufferAddress : 32; //bits [0..31]
		}; //Valid in Logger RD Only
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 bdIndex   : 16; //bits [0..15], For SW path mode
			uint32 reserved7 : 16; //bits [16..31]
		};
	};
} RdCommon_t;

typedef RdCommon_t Rd_t;

#endif //_RD_DESC_H_
