/************************************************************************************
*
*	File:				Tcr_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_mac_descriptors_ver2.13.0.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _TCR_DESC_H_
#define _TCR_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _TcrCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 antennaSelection : 16; //bits [0..15]
			uint32 ant0Boost        : 2;  //bits [16..17]
			uint32 ant1Boost        : 2;  //bits [18..19]
			uint32 ant2Boost        : 2;  //bits [20..21]
			uint32 ant3Boost        : 2;  //bits [22..23]
			uint32 reserved0        : 8;  //bits [24..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 rfPower         : 8;  //bits [0..7]
			uint32 txLoopMode      : 2;  //bits [8..9], values from TxLoopMode_e
			uint32 cbw             : 2;  //bits [10..11], values from Bw_e
			uint32 phyMode         : 3;  //bits [12..14], values from PhyMode_e
			uint32 heFullbandMu    : 1;  //bit [15]
			uint32 hePuncturingMap : 8;  //bits [16..23]
			uint32 forceTx         : 1;  //bit [24]
			uint32 dpdCalibrate    : 1;  //bit [25]
			uint32 beacon          : 1;  //bit [26], A value of '1' indicates that this is a beacon frame
			uint32 reserved11      : 5;  //bits [27..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tbSiga2Reserved : 9;  //bits [0..8]
			uint32 reserved2       : 23; //bits [9..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 tcr0GenriscReserved : 32; //bits [0..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 bssColor            : 6;  //bits [0..5]
			uint32 customBf            : 2;  //bits [6..7]
			uint32 nHeltf              : 3;  //bits [8..10]
			uint32 ulDl                : 1;  //bit [11]
			uint32 txopPs              : 1;  //bit [12]
			uint32 expectedRcr         : 1;  //bit [13]
			uint32 bwChange            : 1;  //bit [14]
			uint32 txopDurationFromMac : 1;  //bit [15]
			uint32 aggregate           : 1;  //bit [16]
			uint32 dynamicBw           : 1;  //bit [17]
			uint32 muPhyNdp            : 1;  //bit [18]
			uint32 muTraining          : 1;  //bit [19]
			uint32 reuseScrambler      : 1;  //bit [20]
			uint32 reserved4           : 3;  //bits [21..23]
			uint32 heCp                : 2;  //bits [24..25], values from HeCp_e
			uint32 heLtf               : 2;  //bits [26..27], values from HeLtf_e
			uint32 scp                 : 1;  //bit [28]
			uint32 smoothing           : 1;  //bit [29]
			uint32 notSounding         : 1;  //bit [30]
			uint32 stbc                : 1;  //bit [31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 spatialReuse            : 16; //bits [0..15]
			uint32 triggerBasedDataLLenght : 12; //bits [16..27]
			uint32 triggerBasedDataLdpc    : 1;  //bit [28]
			uint32 triggerBasedDataPktExt  : 2;  //bits [29..30]
			uint32 triggerBasedDataPeDisam : 1;  //bit [31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 groupId     : 6;  //bits [0..5]
			uint32 reserved60  : 2;  //bits [6..7]
			uint32 heSigRate   : 8;  //bits [8..15]
			uint32 macDuration : 15; //bits [16..30]
			uint32 reserved61  : 1;  //bit [31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 reserved7 : 32; //bits [0..31]
		};
	};
} TcrCommon_t;

typedef struct _TcrUser_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 length             : 22; //bits [0..21]
			uint32 notInUsedReserved8 : 10; //bits [22..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 subBand           : 3;  //bits [0..2]
			uint32 startRu           : 4;  //bits [3..6]
			uint32 ruSize            : 3;  //bits [7..9]
			uint32 ldpc              : 1;  //bit [10]
			uint32 txbf              : 1;  //bit [11]
			uint32 rate              : 8;  //bits [12..19]
			uint32 relativeUserPower : 4;  //bits [20..23]
			uint32 heSigbCompressed  : 1;  //bit [24]
			uint32 heSigb16Symbols   : 1;  //bit [25]
			uint32 reserved90        : 2;  //bits [26..27]
			uint32 packetExtention   : 2;  //bits [28..29]
			uint32 reserved91        : 2;  //bits [30..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 stationAid           : 11; //bits [0..10], in HE for sigB in MU station_aid[10:0]	in VHT SU for partial_aid[8:0]
			uint32 notInUsedReserved100 : 1;  //bit [11]
			uint32 heTbMuStartingSts    : 3;  //bits [12..14]
			uint32 notInUsedReserved101 : 1;  //bit [15]
			uint32 bfIndex              : 8;  //bits [16..23]
			uint32 ndpFbRuToneSetIndex  : 5;  //bits [24..28]
			uint32 ndpFbStartingSts     : 1;  //bit [29]
			uint32 ndpFbValue           : 1;  //bit [30]
			uint32 reserved101          : 1;  //bit [31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 reserved11 : 32; //bits [0..31]
		};
	};
} TcrUser_t;

typedef struct _Tcr_t
{
	TcrCommon_t common;
	TcrUser_t   user[NUM_OF_USERS_MU_HE];
} Tcr_t;

#endif //_TCR_DESC_H_
