/************************************************************************************
*
*	File:				VapDb_Descriptors.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_mac_descriptors_ver2.10.0.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _VAP_DB_DESC_H_
#define _VAP_DB_DESC_H_

#include "DescriptorsDefinitions.h"

typedef struct _VapDbCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 keyIndex0         : 12; //bits [0..11]
			uint32 reserved00        : 3;  //bits [12..14]
			uint32 rxKeyId0Remapping : 1;  //bit [15], not used in WEP
			uint32 keyIndex1         : 12; //bits [16..27]
			uint32 reserved01        : 3;  //bits [28..30]
			uint32 rxKeyId1Remapping : 1;  //bit [31], not used in WEP
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 keyIndex2         : 12; //bits [0..11]
			uint32 reserved10        : 3;  //bits [12..14]
			uint32 rxKeyId2Remapping : 1;  //bit [15], not used in WEP
			uint32 keyIndex3         : 12; //bits [16..27]
			uint32 reserved11        : 3;  //bits [28..30]
			uint32 rxKeyId3Remapping : 1;  //bit [31], not used in WEP
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 pn03 : 32; //bits [0..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 pn45                : 16; //bits [0..15]
			uint32 soundingDialogToken : 6;  //bits [16..21]
			uint32 reserved30          : 2;  //bits [22..23]
			uint32 currSpLengthLimit   : 8;  //bits [24..31], "0" means unlimited
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 omi160MNssRatio : 3;  //bits [0..2]
			uint32 reserved40      : 29; //bits [3..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 htHeAControl : 32; //bits [0..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 maxMpduLengthLimit     : 14; //bits [0..13], unit: [bytes]
			uint32 bfReportResponseFormat : 2;  //bits [14..15], values from BfReportRxIndication_e
			uint32 currentPacketDensity   : 3;  //bits [16..18]
			uint32 sppAmsduCapable        : 1;  //bit [19]
			uint32 dataEncryptionType     : 3;  //bits [20..22], values from SecurityType_e
			uint32 _80211EncryptionType   : 3;  //bits [23..25], values from SecurityType_e
			uint32 dataEncryptionEnable   : 1;  //bit [26]
			uint32 _80211EncryptionEnable : 1;  //bit [27]
			uint32 dataKeyId              : 2;  //bits [28..29]
			uint32 _80211KeyId            : 2;  //bits [30..31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 maxNumFragMsdus     : 3;  //bits [0..2]
			uint32 minFrag             : 2;  //bits [3..4], values from MinFrag_e
			uint32 reserved70          : 4;  //bits [5..8]
			uint32 negotiatedWds       : 1;  //bit [9]
			uint32 noAggInPs           : 1;  //bit [10]
			uint32 psForceOneNss       : 1;  //bit [11]
			uint32 maxNssNdp           : 3;  //bits [12..14]
			uint32 qosEnableCapability : 1;  //bit [15]
			uint32 txPostpone          : 2;  //bits [16..17], values from FillerType_e
			uint32 dynamicBwEnable     : 1;  //bit [18]
			uint32 staticBwEnable      : 1;  //bit [19]
			uint32 rtsCtsTxMethod      : 2;  //bits [20..21], values from RtsCtsTxMethod_e
			uint32 ctsToSelfTxMethod   : 2;  //bits [22..23], values from CtsToSelfTxMethod_e
			uint32 vapMode             : 1;  //bit [24], values from VapMode_e
			uint32 maxSpLength         : 7;  //bits [25..31], "0" means unlimited
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 bferHwDbParams : 32; //bits [0..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 reserved93                : 1;  //bit [0]
			uint32 bfImplicitSupport         : 1;  //bit [1]
			uint32 bfBfmeeSupport            : 1;  //bit [2]
			uint32 htcFieldCapable           : 1;  //bit [3]
			uint32 bfMinimalGrouping         : 2;  //bits [4..5]
			uint32 maxNssTx                  : 3;  //bits [6..8]
			uint32 bfMfbUpdating             : 1;  //bit [9]
			uint32 implicitBfRulesTableIndex : 2;  //bits [10..11]
			uint32 bfImplicitFiller          : 1;  //bit [12]
			uint32 maxSupportedNss           : 3;  //bits [13..15]
			uint32 hwReserved91              : 7;  //bits [16..22]
			uint32 mfbVariant                : 1;  //bit [23], values from MfbVariant_e, Init by FW, updating by HW
			uint32 mcsFeedback               : 7;  //bits [24..30], Init by FW, updating by HW
			uint32 mfbValid                  : 1;  //bit [31], Init by FW, updating by HW
		};
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 maxPsduLengthLimit  : 23; //bits [0..22], unit: [bytes]
			uint32 heSuStaResponseMode : 1;  //bit [23], values from HeSuStaResponseDurTimeout_e
			uint32 reserved100         : 7;  //bits [24..30]
			uint32 durationUpdateMode  : 1;  //bit [31], values from DurationUpdateMode_e
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 heSupportMultiTid      : 9;  //bits [0..8]
			uint32 heMultiTidAggSupport   : 3;  //bits [9..11]
			uint32 heMultiTidSelectPolicy : 2;  //bits [12..13]
			uint32 heMngAgg               : 1;  //bit [14]
			uint32 heBarAgg               : 1;  //bit [15]
			uint32 maxMsduAtAmsduCount    : 5;  //bits [16..20]
			uint32 staPhyCapabilities     : 3;  //bits [21..23], values from PhyMode_e
			uint32 aMpduLimit             : 8;  //bits [24..31], "0" means unlimited
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 tcr0DataAntennaSelection : 16; //bits [0..15]
			uint32 tcr0DataAnt0Boost        : 2;  //bits [16..17]
			uint32 tcr0DataAnt1Boost        : 2;  //bits [18..19]
			uint32 tcr0DataAnt2Boost        : 2;  //bits [20..21]
			uint32 tcr0DataAnt3Boost        : 2;  //bits [22..23]
			uint32 tcr0DataAnt4Boost        : 2;  //bits [24..25]
			uint32 tcr0DataAnt5Boost        : 2;  //bits [26..27]
			uint32 tcr0DataAnt6Boost        : 2;  //bits [28..29]
			uint32 tcr0DataAnt7Boost        : 2;  //bits [30..31]
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 tcr0Data20MhzRfPower      : 8;  //bits [0..7]
			uint32 tcr0Data20MhzTxLoopMode   : 2;  //bits [8..9], values from TxLoopMode_e
			uint32 tcr0Data20MhzCbw          : 2;  //bits [10..11], values from Bw_e, Only 20MHz valid
			uint32 tcr0Data20MhzPhyMode      : 3;  //bits [12..14], values from PhyMode_e
			uint32 tcr0Dw1Data20MhzReserved0 : 1;  //bit [15]
			uint32 tcr0Data40MhzRfPower      : 8;  //bits [16..23]
			uint32 tcr0Data40MhzTxLoopMode   : 2;  //bits [24..25], values from TxLoopMode_e
			uint32 tcr0Data40MhzCbw          : 2;  //bits [26..27], values from Bw_e, Only 40MHz valid
			uint32 tcr0Data40MhzPhyMode      : 3;  //bits [28..30], values from PhyMode_e
			uint32 tcr0Dw1Data40MhzReserved0 : 1;  //bit [31]
		};
	};
	union //word14
	{
		uint32 word14;
		struct
		{
			uint32 tcr0Data80MhzRfPower       : 8;  //bits [0..7]
			uint32 tcr0Data80MhzTxLoopMode    : 2;  //bits [8..9], values from TxLoopMode_e
			uint32 tcr0Data80MhzCbw           : 2;  //bits [10..11], values from Bw_e, Only 80MHz valid
			uint32 tcr0Data80MhzPhyMode       : 3;  //bits [12..14], values from PhyMode_e
			uint32 tcr0Dw1Data80MhzReserved0  : 1;  //bit [15]
			uint32 tcr0Data160MhzRfPower      : 8;  //bits [16..23]
			uint32 tcr0Data160MhzTxLoopMode   : 2;  //bits [24..25], values from TxLoopMode_e
			uint32 tcr0Data160MhzCbw          : 2;  //bits [26..27], values from Bw_e, Only 160MHz valid
			uint32 tcr0Data160MhzPhyMode      : 3;  //bits [28..30], values from PhyMode_e
			uint32 tcr0Dw1Data160MhzReserved0 : 1;  //bit [31]
		};
	};
	union //word15
	{
		uint32 word15;
		struct
		{
			uint32 tcr0DataGenriscReserve : 32; //bits [0..31]
		};
	};
	union //word16
	{
		uint32 word16;
		struct
		{
			uint32 tcr080211AntennaSelection : 16; //bits [0..15]
			uint32 tcr080211Ant0Boost        : 2;  //bits [16..17]
			uint32 tcr080211Ant1Boost        : 2;  //bits [18..19]
			uint32 tcr080211Ant2Boost        : 2;  //bits [20..21]
			uint32 tcr080211Ant3Boost        : 2;  //bits [22..23]
			uint32 tcr080211Ant4Boost        : 2;  //bits [24..25]
			uint32 tcr080211Ant5Boost        : 2;  //bits [26..27]
			uint32 tcr080211Ant6Boost        : 2;  //bits [28..29]
			uint32 tcr080211Ant7Boost        : 2;  //bits [30..31]
		};
	};
	union //word17
	{
		uint32 word17;
		struct
		{
			uint32 tcr08021120MhzRfPower      : 8;  //bits [0..7]
			uint32 tcr08021120MhzTxLoopMode   : 2;  //bits [8..9], values from TxLoopMode_e
			uint32 tcr08021120MhzCbw          : 2;  //bits [10..11], values from Bw_e, Only 20MHz valid
			uint32 tcr08021120MhzPhyMode      : 3;  //bits [12..14], values from PhyMode_e
			uint32 tcr0Dw18021120MhzReserved0 : 1;  //bit [15]
			uint32 tcr08021140MhzRfPower      : 8;  //bits [16..23]
			uint32 tcr08021140MhzTxLoopMode   : 2;  //bits [24..25], values from TxLoopMode_e
			uint32 tcr08021140MhzCbw          : 2;  //bits [26..27], values from Bw_e, Only 40MHz valid
			uint32 tcr08021140MhzPhyMode      : 3;  //bits [28..30], values from PhyMode_e
			uint32 tcr0Dw18021140MhzReserved0 : 1;  //bit [31]
		};
	};
	union //word18
	{
		uint32 word18;
		struct
		{
			uint32 tcr08021180MhzRfPower       : 8;  //bits [0..7]
			uint32 tcr08021180MhzTxLoopMode    : 2;  //bits [8..9], values from TxLoopMode_e
			uint32 tcr08021180MhzCbw           : 2;  //bits [10..11], values from Bw_e, Only 80MHz valid
			uint32 tcr08021180MhzPhyMode       : 3;  //bits [12..14], values from PhyMode_e
			uint32 tcr0Dw18021180MhzReserved0  : 1;  //bit [15]
			uint32 tcr080211160MhzRfPower      : 8;  //bits [16..23]
			uint32 tcr080211160MhzTxLoopMode   : 2;  //bits [24..25], values from TxLoopMode_e
			uint32 tcr080211160MhzCbw          : 2;  //bits [26..27], values from Bw_e, Only 160MHz valid
			uint32 tcr080211160MhzPhyMode      : 3;  //bits [28..30], values from PhyMode_e
			uint32 tcr0Dw180211160MhzReserved0 : 1;  //bit [31]
		};
	};
	union //word19
	{
		uint32 word19;
		struct
		{
			uint32 tcr080211GenriscReserved : 32; //bits [0..31]
		};
	};
	union //word20
	{
		uint32 word20;
		struct
		{
			uint32 tcr1BssColor            : 6;  //bits [0..5]
			uint32 tcr1CustomBf            : 2;  //bits [6..7]
			uint32 tcr1NHelft              : 3;  //bits [8..10]
			uint32 tcr1UlDl                : 1;  //bit [11]
			uint32 tcr1TxopPsNotAllowed    : 1;  //bit [12]
			uint32 tcr1ExpectRcr           : 1;  //bit [13]
			uint32 tcr1BwChange            : 1;  //bit [14]
			uint32 tcr1TxopDurationFromMac : 1;  //bit [15]
			uint32 tcr1SpaitalReuse        : 16; //bits [16..31]
		};
	};
	union //word21
	{
		uint32 word21;
		struct
		{
			uint32 tcr120MhzDataHeCp         : 2;  //bits [0..1]
			uint32 tcr120MhzDataHeLtf        : 2;  //bits [2..3]
			uint32 tcr120MhzDataScp          : 1;  //bit [4]
			uint32 tcr120MhzDataSmoothing    : 1;  //bit [5]
			uint32 tcr120MhzDataNotSounding  : 1;  //bit [6]
			uint32 tcr120MhzDataStbc         : 1;  //bit [7]
			uint32 tcr140MhzDataHeCp         : 2;  //bits [8..9]
			uint32 tcr140MhzDataHeLtf        : 2;  //bits [10..11]
			uint32 tcr140MhzDataScp          : 1;  //bit [12]
			uint32 tcr140MhzDataSmoothing    : 1;  //bit [13]
			uint32 tcr140MhzDataNotSounding  : 1;  //bit [14]
			uint32 tcr140MhzDataStbc         : 1;  //bit [15]
			uint32 tcr180MhzDataHeCp         : 2;  //bits [16..17]
			uint32 tcr180MhzDataHeLtf        : 2;  //bits [18..19]
			uint32 tcr180MhzDataScp          : 1;  //bit [20]
			uint32 tcr180MhzDataSmoothing    : 1;  //bit [21]
			uint32 tcr180MhzDataNotSounding  : 1;  //bit [22]
			uint32 tcr180MhzDataStbc         : 1;  //bit [23]
			uint32 tcr1160MhzDataHeCp        : 2;  //bits [24..25]
			uint32 tcr1160MhzDataHeLtf       : 2;  //bits [26..27]
			uint32 tcr1160MhzDataScp         : 1;  //bit [28]
			uint32 tcr1160MhzDataSmoothing   : 1;  //bit [29]
			uint32 tcr1160MhzDataNotSounding : 1;  //bit [30]
			uint32 tcr1160MhzDataStbc        : 1;  //bit [31]
		};
	};
	union //word22
	{
		uint32 word22;
		struct
		{
			uint32 tcr120Mhz80211HeCp         : 2;  //bits [0..1]
			uint32 tcr120Mhz80211HeLtf        : 2;  //bits [2..3]
			uint32 tcr120Mhz80211Scp          : 1;  //bit [4]
			uint32 tcr120Mhz80211Smoothing    : 1;  //bit [5]
			uint32 tcr120Mhz80211NotSounding  : 1;  //bit [6]
			uint32 tcr120Mhz80211Stbc         : 1;  //bit [7]
			uint32 tcr140Mhz80211HeCp         : 2;  //bits [8..9]
			uint32 tcr140Mhz80211HeLtf        : 2;  //bits [10..11]
			uint32 tcr140Mhz80211Scp          : 1;  //bit [12]
			uint32 tcr140Mhz80211Smoothing    : 1;  //bit [13]
			uint32 tcr140Mhz80211NotSounding  : 1;  //bit [14]
			uint32 tcr140Mhz80211Stbc         : 1;  //bit [15]
			uint32 tcr180Mhz80211HeCp         : 2;  //bits [16..17]
			uint32 tcr180Mhz80211HeLtf        : 2;  //bits [18..19]
			uint32 tcr180Mhz80211Scp          : 1;  //bit [20]
			uint32 tcr180Mhz80211Smoothing    : 1;  //bit [21]
			uint32 tcr180Mhz80211NotSounding  : 1;  //bit [22]
			uint32 tcr180Mhz80211Stbc         : 1;  //bit [23]
			uint32 tcr1160Mhz80211HeCp        : 2;  //bits [24..25]
			uint32 tcr1160Mhz80211HeLtf       : 2;  //bits [26..27]
			uint32 tcr1160Mhz80211Scp         : 1;  //bit [28]
			uint32 tcr1160Mhz80211Smoothing   : 1;  //bit [29]
			uint32 tcr1160Mhz80211NotSounding : 1;  //bit [30]
			uint32 tcr1160Mhz80211Stbc        : 1;  //bit [31]
		};
	};
	union //word23
	{
		uint32 word23;
		struct
		{
			uint32 tcr1GroupId              : 6;  //bits [0..5]
			uint32 tcr1Dw2Reserve0          : 2;  //bits [6..7]
			uint32 tcr1HeSigBRate           : 8;  //bits [8..15]
			uint32 reserved230              : 8;  //bits [16..23]
			uint32 heSuExtDataRuSize        : 1;  //bit [24], values from HeSuExtRuSize_e
			uint32 heSuExtMngRuSize         : 1;  //bit [25], values from HeSuExtRuSize_e
			uint32 altRateReasonFastProbing : 1;  //bit [26]
			uint32 altRateReasonSlowProbing : 1;  //bit [27]
			uint32 dataBwLimit              : 2;  //bits [28..29], values from Bw_e
			uint32 _80211BwLimit            : 2;  //bits [30..31], values from Bw_e
		};
	};
	union //word24
	{
		uint32 word24;
		struct
		{
			uint32 tcr220MhzDataPsduRate  : 8;  //bits [0..7]
			uint32 tcr240MhzDataPsduRate  : 8;  //bits [8..15]
			uint32 tcr280MhzDataPsduRate  : 8;  //bits [16..23]
			uint32 tcr2160MhzDataPsduRate : 8;  //bits [24..31]
		};
	};
	union //word25
	{
		uint32 word25;
		struct
		{
			uint32 tcr220Mhz80211PsduRate  : 8;  //bits [0..7]
			uint32 tcr240Mhz80211PsduRate  : 8;  //bits [8..15]
			uint32 tcr280Mhz80211PsduRate  : 8;  //bits [16..23]
			uint32 tcr2160Mhz80211PsduRate : 8;  //bits [24..31]
		};
	};
	union //word26
	{
		uint32 word26;
		struct
		{
			uint32 tcr220MhzDataTxbf     : 1;  //bit [0]
			uint32 tcr240MhzDataTxbf     : 1;  //bit [1]
			uint32 tcr280MhzDataTxbf     : 1;  //bit [2]
			uint32 tcr2160MhzDataTxbf    : 1;  //bit [3]
			uint32 tcr220Mhz80211Txbf    : 1;  //bit [4]
			uint32 tcr240Mhz80211Txbf    : 1;  //bit [5]
			uint32 tcr280Mhz80211Txbf    : 1;  //bit [6]
			uint32 tcr2160Mhz80211Txbf   : 1;  //bit [7]
			uint32 tcr2DataLdpc          : 1;  //bit [8]
			uint32 tcr280211Ldpc         : 1;  //bit [9]
			uint32 tcr2RelativeUserPower : 4;  //bits [10..13]
			uint32 tcr2PacketExtension   : 2;  //bits [14..15]
			uint32 tcr2VhtSuPartialAid   : 11; //bits [16..26]
			uint32 reserved260           : 5;  //bits [27..31]
		};
	};
} VapDbCommon_t;

typedef struct _VapDbTid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 currentSequenceNumber : 12; //bits [0..11]
			uint32 reservedTid00         : 4;  //bits [12..15]
			uint32 lowSequenceNumber     : 12; //bits [16..27]
			uint32 reservedTid01         : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 baEnable                     : 1;  //bit [0]
			uint32 ppduTxMode                   : 2;  //bits [1..2], values from PpduTxMode_e
			uint32 maxPsduTransmissionTimeLimit : 13; //bits [3..15], unit: [2 * micro seconds]
			uint32 currentBaWindowLimit         : 8;  //bits [16..23], "0" means 256
			uint32 txopMultipleDataEn           : 1;  //bit [24]
			uint32 tidRrWeight                  : 3;  //bits [25..27]
			uint32 fragLevel                    : 2;  //bits [28..29], values from FragLevel_e
			uint32 reservedTid10                : 2;  //bits [30..31]
		};
	};
} VapDbTid_t;

typedef struct _VapDbBssid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 macAddress03 : 32; //bits [0..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 macAddress45   : 16; //bits [0..15]
			uint32 aid12          : 12; //bits [16..27], Contains the 12 least significant bits of the AID
			uint32 reservedBssid0 : 4;  //bits [28..31]
		};
	};
} VapDbBssid_t;

typedef struct _VapDbTcrTemplates_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tcr0Word0Template : 32; //bits [0..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tcr0Word1Template : 32; //bits [0..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tcr0Word2Template : 32; //bits [0..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 tcr0Word3Template : 32; //bits [0..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tcr1Word4Template : 32; //bits [0..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 tcr1Word5Template : 32; //bits [0..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 tcr1Word6Template : 32; //bits [0..31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 tcr1Word7Template : 32; //bits [0..31]
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 tcr2Word0Template : 32; //bits [0..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 tcr2Word1Template : 32; //bits [0..31]
		};
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 tcr2Word2Template : 32; //bits [0..31]
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 tcr2Word3Template : 32; //bits [0..31]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 rfPowerTemplates : 32; //bits [0..31]
		};
		struct
		{
			uint32 rfPower20MhzTemplate : 8;  //bits [0..7]
			uint32                      : 24;
		};
		struct
		{
			uint32                      : 8;
			uint32 rfPower40MhzTemplate : 8;  //bits [8..15]
			uint32                      : 16;
		};
		struct
		{
			uint32                      : 16;
			uint32 rfPower80MhzTemplate : 8;  //bits [16..23]
			uint32                      : 8;
		};
		struct
		{
			uint32                       : 24;
			uint32 rfPower160MhzTemplate : 8;  //bits [24..31]
		};
	};
} VapDbTcrTemplates_t;

typedef struct _VapDb_t
{
	VapDbCommon_t       common;
	VapDbTid_t          tid;
	VapDbBssid_t        bssid;
	VapDbTcrTemplates_t tcrTemplates[NUM_OF_VAP_TCR_TEMPLATES];
} VapDb_t;

#endif //_VAP_DB_DESC_H_
