/***************************************************************
 File:		Rxf_Common.h
 Module:	  	RXF
 Purpose: 	holds all the common definions for the RXF module 
 Description:  This module contains the common definions of the RXF module which is responsible for filtering 
 			the incoming packets in the PAC
***************************************************************/
#ifndef RXF_COMMON_H
#define RXF_COMMON_H
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "frame.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define RXF_NUM_OF_EXTENDED_FILTERS_LONG_FILTER0_ABC 3
#define RXF_NUM_OF_EXTENDED_FILTERS_LONG_FILTER1_ABC 3
#define RXF_NUM_OF_EXTENDED_FILTERS_LONG_FILTER1_WF_ABC 3
#define RXF_NUM_OF_EXTENDED_FILTERS_LONG_FILTER0_DEFG 4

//long_filter_0_control:
//long_filter_0_control 0-5 bits
//offset_long_filter_0_control 8-14 bits
#define RXF_LONG_FILTER_ADDRESS_1_OFFSET_VALUE 		(4) // 4 bytes - location of address 1(receiver) from beginning of packet
#define RXF_LONG_FILTER_ADDRESS_1_OFFSET_LOCATION 	(8) // 8 bytes - offset_long_filter_0_control 8-14 bits
#define RXF_LONG_FILTER_ADDRESS_1_OFFSET 			(RXF_LONG_FILTER_ADDRESS_1_OFFSET_VALUE << RXF_LONG_FILTER_ADDRESS_1_OFFSET_LOCATION) //4<<8=1024

#define RXF_LONG_FILTER_ADDRESS_2_OFFSET_VALUE 		(RXF_LONG_FILTER_ADDRESS_1_OFFSET_VALUE + RXF_LONG_FILTER_MASK_SIZE) //10 bytes location of address 2(sender) in MAC frame
#define RXF_LONG_FILTER_ADDRESS_2_OFFSET_LOCATION   (RXF_LONG_FILTER_ADDRESS_1_OFFSET_LOCATION) //offset_long_filter_0_control 8-14 bits
#define RXF_LONG_FILTER_ADDRESS_2_OFFSET 			(RXF_LONG_FILTER_ADDRESS_2_OFFSET_VALUE << RXF_LONG_FILTER_ADDRESS_2_OFFSET_LOCATION)//((0xA)<<8)

#define RXF_LONG_FILTER_MASK_SIZE					(6) // 6 bytes - size of address field in packet
#define RXF_LONG_FILTER_MASK_LOCATION				(0)
#define RXF_LONG_FILTER_MASK						(MASK (RXF_LONG_FILTER_MASK_SIZE,RXF_LONG_FILTER_MASK_LOCATION,uint32))
#define RXF_LONG_FILTER_MASK_ADDRESS_2_GEN4			(0xFC) //6 bytes - with offset2 since offset needs to be 10 but forced to be 8 and therefore 2 first bytes should not be compared
#define RXF_LONG_FILTER_SNIFFER_MASK				(0x0)

#define RXF_LONG_FILTER_ADDRESS_1					(RXF_LONG_FILTER_ADDRESS_1_OFFSET | RXF_LONG_FILTER_MASK)
#define RXF_LONG_FILTER_FOR_SNIFFER					(RXF_LONG_FILTER_ADDRESS_1_OFFSET | RXF_LONG_FILTER_SNIFFER_MASK)

#define RXF_LONG_FILTER_ADDRESS_2					(RXF_LONG_FILTER_ADDRESS_2_OFFSET | RXF_LONG_FILTER_MASK_ADDRESS_2_GEN4)
#define RXF_LONG_FILTER_FOR_RSSI					(RXF_LONG_FILTER_ADDRESS_2)	//0xAFC

#define RXF_VAP_FILTERS_CONTROL_REGISTER			RXF_LONG_FILTER_CONTROL_REGISTER_0
#define RXF_VAP_FILTERS_CONTROL						RXF_LONG_FILTER_ADDRESS_1
#define RXF_VAP_SNIFFER_FILTERS_CONTROL				RXF_LONG_FILTER_FOR_SNIFFER
#define RXF_BROADCAST_FILTER_CONTROL_REGISTER		RXF_LONG_FILTER_CONTROL_REGISTER_2
#define RXF_BROADCAST_FILTER_CONTROL				RXF_LONG_FILTER_ADDRESS_1
#define RXF_BROADCAST_ADDRESS_LOW					0xFFFFFFFF
#define RXF_BROADCAST_ADDRESS_HIGH					0xFFFF

#define RXF_FULL_RESET_MASK  (REG_SW_RESET_RXF_REG_MASK |REG_SW_RESET_RXF_MASK)
#define RXF_FULL_RESET   0 
#define RXF_REFERENCE_DATA_DEFAULT_VALUE_LOW 0
#define RXF_REFERENCE_DATA_DEFAULT_VALUE_HIGH 0

#define RXF_IEEE_ADDRESS_FIRST_BYTE  0
#define RXF_IEEE_ADDRESS_SECOND_BYTE 1
#define RXF_IEEE_ADDRESS_THIRD_BYTE  2
#define RXF_IEEE_ADDRESS_FORTH_BYTE  3
#define RXF_IEEE_ADDRESS_FIFTH_BYTE  4
#define RXF_IEEE_ADDRESS_SIXT_BYTE   5

#define RXF_IEEE_ADDRESS_FIRST_BYTE_SHIFT  0
#define RXF_IEEE_ADDRESS_SECOND_BYTE_SHIFT 8
#define RXF_IEEE_ADDRESS_THIRD_BYTE_SHIFT  16
#define RXF_IEEE_ADDRESS_FORTH_BYTE_SHIFT  24
#define RXF_IEEE_ADDRESS_FIFTH_BYTE_SHIFT  0
#define RXF_IEEE_ADDRESS_SIXT_BYTE_SHIFT   8




//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef enum _RXF_LONG_FILTER_CONTROL_REGISTER {	
    RXF_LONG_FILTER_CONTROL_REGISTER_0 = 0,	
    RXF_LONG_FILTER_CONTROL_REGISTER_1 = 1,	
    RXF_LONG_FILTER_CONTROL_REGISTER_2 = 2,	
    RXF_LONG_FILTER_CONTROL_REGISTER_LAST,	
} RXF_LONG_FILTER_CONTROL_REGISTER;

typedef enum _RXF_LONG_FILTER_REFERENCE_DATA_REGISTER {	
    RXF_LONG_FILTER_REFERENCE_DATA_LOW = 0,	
    RXF_LONG_FILTER_REFERENCE_DATA_HIGH = 1,	
    RXF_LONG_FILTER_REFERENCE_DATA_LAST,	
} RXF_LONG_FILTER_REFERENCE_DATA_REGISTER;

typedef enum _RXF_LONG_FILTER_SELECTION_REGISTER {	
    RXF_LONG_FILTER_SELECTION_REGISTER_0 = 0,	
    RXF_LONG_FILTER_SELECTION_REGISTER_1 = 1,	
    RXF_LONG_FILTER_SELECTION_REGISTER_LAST,	
} RXF_LONG_FILTER_SELECTION_REGISTER;

typedef struct   /* Long Filter extensions reference */
{
	uint32  u32Ref1;
	uint32  u32Ref2;
} EXTENDED_LF;

typedef struct   /* Long Filter main -control + reference */
{
	uint32  u32Ref1;
	uint32  u32Ref2;
	uint32  u32Control;
} LFC;


//---------------------------------------------------------------------------------
//						Internal Function Declaration				
//---------------------------------------------------------------------------------





#endif /* RXF_COMMON_H*/

