/***********************************************************************************
 File:			DurRam.h
 Module:		RAM DUR
 Purpose: 		
 Description:	defines the RAM of the PAC_DUR
************************************************************************************/
#ifndef PAC_DUR_RAM_H_
#define PAC_DUR_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "lmi.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PAC_DUR_RAM_MCS_OUT_SIZE (HW_NUM_OF_VAPS + 1)
#define PAC_DUR_RAM_MCS_OUT_GENERAL_VAP_INDEX (HW_NUM_OF_VAPS)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef union
{
	uint32 val;
	struct
	{
		uint32 ackOrCtsAirTime11B:10;
		uint32 ackOrCtsAirTime11AG:10;
		uint32 baAirTime11AG:10;
		uint32 reserved:2;
	} bitFields;
} AutoReplyFrameAndSifsAirTime_t;



typedef union
{
	uint32 val;
	struct
	{
		uint32 txPower11B:6;
		uint32 txPower11agbw20:6;
		uint32 txPower11AGbw40:6;
		uint32 txPower11AGbw80:6;
		uint32 txPower11AGbw160:6;
		uint32 reserved:2;
	} bitFields;
}DurTxPower_t;

typedef union
{
	uint32 val;
	struct
	{
		uint32 mcs0In:3;
		uint32 mcs1In:3;
		uint32 mcs2In:3;
		uint32 mcs3In:3;
		uint32 mcs4In:3;
		uint32 mcs5In:3;
		uint32 mcs6In:3;
		uint32 mcs7In:3;		
		uint32 mcs8In:3;
		uint32 mcs9In:3;
		uint32 reserved:2;
	} bitFields;
}McsOut11nAc_t;

typedef union
{
	uint32 val;
	struct
	{
		uint32 mcs0In:3;
		uint32 mcs1In:3;
		uint32 mcs2In:3;
		uint32 mcs3In:3;
		uint32 mcs4In:3;
		uint32 mcs5In:3;
		uint32 mcs6In:3;
		uint32 mcs7In:3;		
		uint32 reserved:8;
	} bitFields;
} McsOut11abg_t;

typedef union
{
	uint32 val;
	struct
	{
		uint32 txPower11B       :6;
		uint32 txPower11AGBw20  :6;
		uint32 txPower11AGBw40  :6;
		uint32 txPower11AGBw80  :6;
		uint32 txPower11AGBw160 :6;
		uint32 reserved         :2;
	} bitFields;
} AutoReplyPower_t;

typedef struct McsOut_t
{
	McsOut11nAc_t mscOut11nAc;
	McsOut11abg_t mscOut11ag;
	McsOut11abg_t mscOut11b;
} McsOut_t;

typedef struct PacDurRam
{
	AutoReplyFrameAndSifsAirTime_t autoReplyAndSifsAirTime[LM_PHY_11A_MAX_RATES];
	AutoReplyPower_t               autoReplyPower[LM_PHY_11A_MAX_RATES];
	McsOut_t                       mcsOut[PAC_DUR_RAM_MCS_OUT_SIZE];
} PacDurRam_t;


#endif /* PAC_DUR_RAM_H_ */


