/***********************************************************************************
 File:			PacDur.h
 Module:		Hw drivers
 Purpose: 		Create a SW interface for all HW PAC modules 
 Description:	This file contains all the definitions and the structures of the PAC 
 				DUR	driver which is responsible to configure the PAC Duration HW 
 				module
************************************************************************************/
#ifndef PAC_DUR_H_
#define PAC_DUR_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Pac_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PAC_DUR_NAV_SET_NO_UPDATE	0x0
#define PAC_DUR_NAV_SET_UPDATE		0x2
#define PAC_DUR_NAV_SET_RESET		0x3
#define PAC_DUR_NAV_SET_ENTRY_SHIFT	0x1
#define PAC_DUR_NAV_SET_ENTRY_MASK	0xF

/* There are 3 registers with 16 entries each (in the last register only the first 2 entries are valid). Each entry is 2 bits. the code 
   here calculates the location of each line in the RXD in the register : (line number % 16 ) * 2 is equal to the number of the 
   starting bit of the entry. */
   

/* Register 0 */
#define PAC_DUR_NAV_RESET_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER  ((RCD_NAV_RESET & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)

/* Register 1 */
#define PAC_DUR_MULTI_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER      ((RCD_MULTI & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)
#define PAC_DUR_NAV_LOAD_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER   ((RCD_NAV_LOAD & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)

/* Register 2 */
/* empty */

/* Configuration of lines */
#define PAC_DUR_NAV_SET_RXD_LINES_0_TO_15_INIT_VALUE   (PAC_DUR_NAV_SET_RESET << PAC_DUR_NAV_RESET_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER)
#define PAC_DUR_NAV_SET_RXD_LINES_16_TO_31_INIT_VALUE  ((PAC_DUR_NAV_SET_UPDATE << PAC_DUR_MULTI_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER) | \
														(PAC_DUR_NAV_SET_UPDATE << PAC_DUR_NAV_LOAD_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER))
														
#define PAC_DUR_NAV_SET_RXD_LINES_32_TO_33_INIT_VALUE   0


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/




#endif /* PAC_DUR_H_ */


