/***********************************************************************************
 File:			RxcRam.h
 Module:		Rxc
 Purpose: 		To create RXC driver which handles Rx packets after the filtering
 Description:	This file contains the definitions of the RAM of the RXC module which 
 				is responsible of handling Rx packets after the filtering
************************************************************************************/
#ifndef RXC_RAM_H_
#define RXC_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define RXC_TRAFFIC_INDICATION_CLEAR_BY_ONE_BITMAP     (TRAFFIC_INDICATOR_BASE_ADDR)
#define RXC_TRAFFIC_INDICATION_REGULAR_BITMAP_OFFSET   (0x200)
#define NUM_STA_PER_LINE								(2) /* Traffic Indication Bittmap (see rxc_rxd_rxf.doc section 2.2.1) */
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define RXC_TRAFFIC_INDICATION_STATION_ACTIVITY_BITMAP_SIZE_IN_WORDS (CONVERT_BIT_INDEX_TO_WORDS(HW_NUM_OF_STATIONS - 1) + 1)

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef union 
{
	uint32 val;
	struct	
	{
		uint8 sta0Tid0:1; /* station index is 0-3 per row */
		uint8 sta0Tid1:1;
		uint8 sta0Tid2:1;
		uint8 sta0Tid3:1;
		uint8 sta0Tid4:1;
		uint8 sta0Tid5:1;
		uint8 sta0Tid6:1;
		uint8 sta0Tid7:1;
		uint8 sta1Tid0:1;
		uint8 sta1Tid1:1;
		uint8 sta1Tid2:1;
		uint8 sta1Tid3:1;
		uint8 sta1Tid4:1;
		uint8 sta1Tid5:1;
		uint8 sta1Tid6:1;
		uint8 sta1Tid7:1;		
		uint8 sta2Tid0:1;
		uint8 sta2Tid1:1;
		uint8 sta2Tid2:1;
		uint8 sta2Tid3:1;
		uint8 sta2Tid4:1;
		uint8 sta2Tid5:1;
		uint8 sta2Tid6:1;
		uint8 sta2Tid7:1;
		uint8 sta3Tid0:1;
		uint8 sta3Tid1:1;
		uint8 sta3Tid2:1;
		uint8 sta3Tid3:1;
		uint8 sta3Tid4:1;
		uint8 sta3Tid5:1;
		uint8 sta3Tid6:1;
		uint8 sta3Tid7:1;
	} bitfields;
} RxcStationBaAgreementActivityBitmap_t;

typedef struct RxcTrafficIndRam
{
	RxcStationBaAgreementActivityBitmap_t BaAgreementRecipientActivityBitmap[HW_NUM_OF_STATIONS >> NUM_STA_PER_LINE];	
	RxcStationBaAgreementActivityBitmap_t BaAgreementInitiatorActivityBitmap[HW_NUM_OF_STATIONS >> NUM_STA_PER_LINE];
	uint32 stationActivityBitmap[RXC_TRAFFIC_INDICATION_STATION_ACTIVITY_BITMAP_SIZE_IN_WORDS]; /* there are 32 indication bits in a word. Bit per station */
} RxcTrafficIndRam_t;


#endif // RXPP_API_H_


