/***********************************************************************************
 File:			RxPp_Api.h
 Module:			Rx Post processing
 Purpose: 		Owner for all access to the Rx Post processing driver
 Description:		This module is the API to the Rx Post Processor HW driver responsible
 				for the configuration of the RXPP HW
************************************************************************************/
#ifndef RXF_RAM_H_
#define RXF_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "SharedDbTypes.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define RXF_MPDU_TYPE_FILTER_START_OFFSET        (0x1300) //offset from RXF RAM block
#define RXF_MPDU_TYPE_FILTER_START               (PAC_RXF_BASE_ADDR + RXF_MPDU_TYPE_FILTER_START_OFFSET)   // the memory structure of the MPDU types filter starts at 0x06c01300
#define RXF_TYPE_FILTER_BYTES_SIZE        		 (4)   // Every vap has 3 words. Word per type(Data, Management, Control). Every word(type) contains 16 subtype bits. the 16 MSBits are reserved.	
#define RXF_MPDU_TYPES_REJECT_FILTER_RAM_SIZE     48   // size of MPDU types filter RAM in words

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef union
{
	uint32 val;
	struct
	{
		uint32 subType0  :1;
		uint32 subType1  :1;
		uint32 subType2  :1;
		uint32 subType3  :1;
		uint32 subType4  :1;
		uint32 subType5  :1;
		uint32 subType6  :1;
		uint32 subType7  :1;
		uint32 subType8  :1;
		uint32 subType9  :1;
		uint32 subType10 :1;
		uint32 subType11 :1;
		uint32 subType12 :1;
		uint32 subType13 :1;
		uint32 subType14 :1;
		uint32 subType15 :1;
		uint32 reserved  :16;
	} subTypes;
}RxcSubtypesVapMpduFilter_u;


typedef struct RxfVapMpduTypesFilter
{
	RxcSubtypesVapMpduFilter_u RxcDataSubtypesMpduType;
	RxcSubtypesVapMpduFilter_u RxcManagementSubtypesMpduType;
	RxcSubtypesVapMpduFilter_u RxcControlSubtypesMpduType;
} RxfVapMpduTypesFilter_t;


typedef struct RxfMpduTypesFilterRam_
{
	RxfVapMpduTypesFilter_t VapMpduTypesFilter[HW_NUM_OF_VAPS];
} RxfMpduTypesFilterRam_t;


#endif // RXPP_API_H_


